/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.fbs.feather;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.ac.bristol.star.fbs.feather.Column;
import uk.ac.bristol.star.fbs.google.FlatBufferBuilder;
import uk.ac.bristol.star.fbs.google.Table;

public final class CTable
extends Table {
    public static CTable getRootAsCTable(ByteBuffer byteBuffer) {
        return CTable.getRootAsCTable(byteBuffer, new CTable());
    }

    public static CTable getRootAsCTable(ByteBuffer byteBuffer, CTable cTable) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return cTable.__assign(byteBuffer.getInt(byteBuffer.position()) + byteBuffer.position(), byteBuffer);
    }

    public void __init(int n, ByteBuffer byteBuffer) {
        this.bb_pos = n;
        this.bb = byteBuffer;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public CTable __assign(int n, ByteBuffer byteBuffer) {
        this.__init(n, byteBuffer);
        return this;
    }

    public String description() {
        int n = this.__offset(4);
        return n != 0 ? this.__string(n + this.bb_pos) : null;
    }

    public ByteBuffer descriptionAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer descriptionInByteBuffer(ByteBuffer byteBuffer) {
        return this.__vector_in_bytebuffer(byteBuffer, 4, 1);
    }

    public long numRows() {
        int n = this.__offset(6);
        return n != 0 ? this.bb.getLong(n + this.bb_pos) : 0L;
    }

    public Column columns(int n) {
        return this.columns(new Column(), n);
    }

    public Column columns(Column column, int n) {
        int n2 = this.__offset(8);
        return n2 != 0 ? column.__assign(this.__indirect(this.__vector(n2) + n * 4), this.bb) : null;
    }

    public int columnsLength() {
        int n = this.__offset(8);
        return n != 0 ? this.__vector_len(n) : 0;
    }

    public int version() {
        int n = this.__offset(10);
        return n != 0 ? this.bb.getInt(n + this.bb_pos) : 0;
    }

    public String metadata() {
        int n = this.__offset(12);
        return n != 0 ? this.__string(n + this.bb_pos) : null;
    }

    public ByteBuffer metadataAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer metadataInByteBuffer(ByteBuffer byteBuffer) {
        return this.__vector_in_bytebuffer(byteBuffer, 12, 1);
    }

    public static int createCTable(FlatBufferBuilder flatBufferBuilder, int n, long l, int n2, int n3, int n4) {
        flatBufferBuilder.startObject(5);
        CTable.addNumRows(flatBufferBuilder, l);
        CTable.addMetadata(flatBufferBuilder, n4);
        CTable.addVersion(flatBufferBuilder, n3);
        CTable.addColumns(flatBufferBuilder, n2);
        CTable.addDescription(flatBufferBuilder, n);
        return CTable.endCTable(flatBufferBuilder);
    }

    public static void startCTable(FlatBufferBuilder flatBufferBuilder) {
        flatBufferBuilder.startObject(5);
    }

    public static void addDescription(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.addOffset(0, n, 0);
    }

    public static void addNumRows(FlatBufferBuilder flatBufferBuilder, long l) {
        flatBufferBuilder.addLong(1, l, 0L);
    }

    public static void addColumns(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.addOffset(2, n, 0);
    }

    public static int createColumnsVector(FlatBufferBuilder flatBufferBuilder, int[] nArray) {
        flatBufferBuilder.startVector(4, nArray.length, 4);
        for (int i = nArray.length - 1; i >= 0; --i) {
            flatBufferBuilder.addOffset(nArray[i]);
        }
        return flatBufferBuilder.endVector();
    }

    public static void startColumnsVector(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.startVector(4, n, 4);
    }

    public static void addVersion(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.addInt(3, n, 0);
    }

    public static void addMetadata(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.addOffset(4, n, 0);
    }

    public static int endCTable(FlatBufferBuilder flatBufferBuilder) {
        int n = flatBufferBuilder.endObject();
        return n;
    }

    public static void finishCTableBuffer(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.finish(n);
    }

    public static void finishSizePrefixedCTableBuffer(FlatBufferBuilder flatBufferBuilder, int n) {
        flatBufferBuilder.finishSizePrefixed(n);
    }
}

