/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.fbs.google;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import uk.ac.bristol.star.fbs.google.Utf8;

public class Utf8Old
extends Utf8 {
    private static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(() -> new Cache());

    @Override
    public int encodedLength(CharSequence charSequence) {
        Cache cache = CACHE.get();
        int n = (int)((float)charSequence.length() * cache.encoder.maxBytesPerChar());
        if (cache.lastOutput == null || cache.lastOutput.capacity() < n) {
            cache.lastOutput = ByteBuffer.allocate(Math.max(128, n));
        }
        cache.lastOutput.clear();
        cache.lastInput = charSequence;
        CharBuffer charBuffer = charSequence instanceof CharBuffer ? (CharBuffer)charSequence : CharBuffer.wrap(charSequence);
        CoderResult coderResult = cache.encoder.encode(charBuffer, cache.lastOutput, true);
        if (coderResult.isError()) {
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IllegalArgumentException("bad character encoding", characterCodingException);
            }
        }
        return cache.lastOutput.remaining();
    }

    @Override
    public void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        Cache cache = CACHE.get();
        if (cache.lastInput != charSequence) {
            this.encodedLength(charSequence);
        }
        byteBuffer.put(cache.lastOutput);
    }

    @Override
    public String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) {
        CharsetDecoder charsetDecoder = Utf8Old.CACHE.get().decoder;
        charsetDecoder.reset();
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        try {
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            charBuffer.flip();
            return charBuffer.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalArgumentException("Bad encoding", characterCodingException);
        }
    }

    private static class Cache {
        final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        CharSequence lastInput = null;
        ByteBuffer lastOutput = null;

        Cache() {
        }
    }
}

