/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.fbs.google;

import java.nio.ByteBuffer;
import uk.ac.bristol.star.fbs.google.Utf8;

public final class Utf8Safe
extends Utf8 {
    private static int computeEncodedLength(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += Utf8Safe.encodedLengthGeneral(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new UnpairedSurrogateException(i, n2);
            }
            ++i;
        }
        return n3;
    }

    private static String decodeUtf8Array(byte[] byArray, int n, int n2) {
        byte by;
        int n3;
        if ((n | n2 | byArray.length - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n, n2));
        }
        int n4 = n3 + n2;
        char[] cArray = new char[n2];
        int n5 = 0;
        for (n3 = n; n3 < n4 && Utf8.DecodeUtil.isOneByte(by = byArray[n3]); ++n3) {
            Utf8.DecodeUtil.handleOneByte(by, cArray, n5++);
        }
        while (n3 < n4) {
            if (Utf8.DecodeUtil.isOneByte(by = byArray[n3++])) {
                byte by2;
                Utf8.DecodeUtil.handleOneByte(by, cArray, n5++);
                while (n3 < n4 && Utf8.DecodeUtil.isOneByte(by2 = byArray[n3])) {
                    ++n3;
                    Utf8.DecodeUtil.handleOneByte(by2, cArray, n5++);
                }
                continue;
            }
            if (Utf8.DecodeUtil.isTwoBytes(by)) {
                if (n3 >= n4) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleTwoBytes(by, byArray[n3++], cArray, n5++);
                continue;
            }
            if (Utf8.DecodeUtil.isThreeBytes(by)) {
                if (n3 >= n4 - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleThreeBytes(by, byArray[n3++], byArray[n3++], cArray, n5++);
                continue;
            }
            if (n3 >= n4 - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            Utf8.DecodeUtil.handleFourBytes(by, byArray[n3++], byArray[n3++], byArray[n3++], cArray, n5++);
            ++n5;
        }
        return new String(cArray, 0, n5);
    }

    private static String decodeUtf8Buffer(ByteBuffer byteBuffer, int n, int n2) {
        byte by;
        if ((n | n2 | byteBuffer.limit() - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n, n2));
        }
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = 0;
        while (n < n3 && Utf8.DecodeUtil.isOneByte(by = byteBuffer.get(n))) {
            ++n;
            Utf8.DecodeUtil.handleOneByte(by, cArray, n4++);
        }
        while (n < n3) {
            if (Utf8.DecodeUtil.isOneByte(by = byteBuffer.get(n++))) {
                byte by2;
                Utf8.DecodeUtil.handleOneByte(by, cArray, n4++);
                while (n < n3 && Utf8.DecodeUtil.isOneByte(by2 = byteBuffer.get(n))) {
                    ++n;
                    Utf8.DecodeUtil.handleOneByte(by2, cArray, n4++);
                }
                continue;
            }
            if (Utf8.DecodeUtil.isTwoBytes(by)) {
                if (n >= n3) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleTwoBytes(by, byteBuffer.get(n++), cArray, n4++);
                continue;
            }
            if (Utf8.DecodeUtil.isThreeBytes(by)) {
                if (n >= n3 - 1) {
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                Utf8.DecodeUtil.handleThreeBytes(by, byteBuffer.get(n++), byteBuffer.get(n++), cArray, n4++);
                continue;
            }
            if (n >= n3 - 2) {
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            Utf8.DecodeUtil.handleFourBytes(by, byteBuffer.get(n++), byteBuffer.get(n++), byteBuffer.get(n++), cArray, n4++);
            ++n4;
        }
        return new String(cArray, 0, n4);
    }

    @Override
    public int encodedLength(CharSequence charSequence) {
        return Utf8Safe.computeEncodedLength(charSequence);
    }

    @Override
    public String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) throws IllegalArgumentException {
        if (byteBuffer.hasArray()) {
            return Utf8Safe.decodeUtf8Array(byteBuffer.array(), byteBuffer.arrayOffset() + n, n2);
        }
        return Utf8Safe.decodeUtf8Buffer(byteBuffer, n, n2);
    }

    private static void encodeUtf8Buffer(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n;
        int n2 = charSequence.length();
        int n3 = byteBuffer.position();
        try {
            char c;
            for (n = 0; n < n2 && (c = charSequence.charAt(n)) < '\u0080'; ++n) {
                byteBuffer.put(n3 + n, (byte)c);
            }
            if (n == n2) {
                byteBuffer.position(n3 + n);
                return;
            }
            n3 += n;
            while (n < n2) {
                c = charSequence.charAt(n);
                if (c < '\u0080') {
                    byteBuffer.put(n3, (byte)c);
                } else if (c < '\u0800') {
                    byteBuffer.put(n3++, (byte)(0xC0 | c >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & c));
                } else if (c < '\ud800' || '\udfff' < c) {
                    byteBuffer.put(n3++, (byte)(0xE0 | c >>> 12));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & c >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & c));
                } else {
                    char c2;
                    if (n + 1 == n2 || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n))) {
                        throw new UnpairedSurrogateException(n, n2);
                    }
                    int n4 = Character.toCodePoint(c, c2);
                    byteBuffer.put(n3++, (byte)(0xF0 | n4 >>> 18));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 12));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & n4));
                }
                ++n;
                ++n3;
            }
            byteBuffer.position(n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n5 = byteBuffer.position() + Math.max(n, n3 - byteBuffer.position() + 1);
            throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n) + " at index " + n5);
        }
    }

    private static int encodeUtf8Array(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new UnpairedSurrogateException(n3 - 1, n4);
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                if (!('\ud800' > c || c > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c, charSequence.charAt(n3 + 1)))) {
                    throw new UnpairedSurrogateException(n3, n4);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    @Override
    public void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset();
            int n2 = Utf8Safe.encodeUtf8Array(charSequence, byteBuffer.array(), n + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(n2 - n);
        } else {
            Utf8Safe.encodeUtf8Buffer(charSequence, byteBuffer);
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int n, int n2) {
            super("Unpaired surrogate at index " + n + " of " + n2);
        }
    }
}

