/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

public class FeatherType {
    private final byte tbyte_;
    private final String name_;
    public static final FeatherType BOOL = new FeatherType(0, "BOOL");
    public static final FeatherType INT8 = new FeatherType(1, "INT8");
    public static final FeatherType INT16 = new FeatherType(2, "INT16");
    public static final FeatherType INT32 = new FeatherType(3, "INT32");
    public static final FeatherType INT64 = new FeatherType(4, "INT64");
    public static final FeatherType UINT8 = new FeatherType(5, "UINT8");
    public static final FeatherType UINT16 = new FeatherType(6, "UINT16");
    public static final FeatherType UINT32 = new FeatherType(7, "UINT32");
    public static final FeatherType UINT64 = new FeatherType(8, "UINT64");
    public static final FeatherType FLOAT = new FeatherType(9, "FLOAT");
    public static final FeatherType DOUBLE = new FeatherType(10, "DOUBLE");
    public static final FeatherType UTF8 = new FeatherType(11, "UTF8");
    public static final FeatherType BINARY = new FeatherType(12, "BINARY");
    public static final FeatherType CATEGORY = new FeatherType(13, "CATEGORY");
    public static final FeatherType TIMESTAMP = new FeatherType(14, "TIMESTAMP");
    public static final FeatherType DATE = new FeatherType(15, "DATE");
    public static final FeatherType TIME = new FeatherType(16, "TIME");
    public static final FeatherType LARGE_UTF8 = new FeatherType(17, "LARGE_UTF8");
    public static final FeatherType LARGE_BINARY = new FeatherType(18, "LARGE_BINARY");
    static final FeatherType[] ALL_TYPES = new FeatherType[]{BOOL, INT8, INT16, INT32, INT64, UINT8, UINT16, UINT32, UINT64, FLOAT, DOUBLE, UTF8, BINARY, CATEGORY, TIMESTAMP, DATE, TIME, LARGE_UTF8, LARGE_BINARY};

    private FeatherType(byte by, String string) {
        this.tbyte_ = by;
        this.name_ = string;
    }

    public byte getTypeByte() {
        return this.tbyte_;
    }

    public static FeatherType fromByte(byte by) {
        for (FeatherType featherType : ALL_TYPES) {
            if (featherType.getTypeByte() != by) continue;
            return featherType;
        }
        return null;
    }

    public String toString() {
        return this.name_;
    }
}

