(ns affable-async.core
  (:require [clojure.core.async :as a]))

(defn u-pipeline-async [{:keys [n to af from close?] :or {close? true}}]
  "Unordered Pipeline for async operations.
  Takes elements from the 'from' channel and applies 'af' function then
  puts the transformed elements onto 'to' channel. The function 'af'
  must be of two arguments the first being the input value and the second
  being a channel. It is assumed that 'af' will be asynchronous sending the
  result of the async operation to the provided channel. Outputs will be 
  placed onto 'to' channel in no particular order.
  The 'to' channel will be closed when the 'from' channel closes, but can
  be determined by the 'close?' parameter. The pipeline will stop consuming
  the 'from' channel if the 'to' channel closes.

  'n': the number of parallel ops
  'from': channel to take elements from
  'af': async function taking an element and channel
  'to': channel to put values generated by 'af'"

  (assert (pos-int? n))
  (dotimes [_ n]
    (a/go-loop [p (a/chan 1)]
               (if-some [e (a/<! from)]
                 (do (af e p)
                     (when-some [af-result (a/<! p)]
                       (if (a/>! to af-result)
                         (recur (a/chan 1))
                         (a/close! from))))
                 (when close? (a/close! to))))))
