/*
 * Decompiled with CFR 0.152.
 */
package datomic;

import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import datomic.Connection;
import datomic.functions.Fn;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Peer {
    private static final Var REQUIRE = RT.var((String)"clojure.core", (String)"require");
    private static final Var SQUUID;
    private static final Var SQUUID_TIME;
    private static final Var ID_LITERAL;
    private static final Var FUNCTION;
    private static final Var Q;
    private static final Var CREATE_DATABASE;
    private static final Var RENAME_DATABASE;
    private static final Var DELETE_DATABASE;
    private static final Var CONNECT_URI;

    public static Connection connect(Object uriOrMap) {
        return (Connection)CONNECT_URI.invoke(uriOrMap);
    }

    public static boolean createDatabase(Object uriOrMap) {
        return (Boolean)CREATE_DATABASE.invoke(uriOrMap);
    }

    public static boolean renameDatabase(Object uriOrMap, String newName) {
        return (Boolean)RENAME_DATABASE.invoke(uriOrMap, (Object)newName);
    }

    public static boolean deleteDatabase(Object uriOrMap) {
        return (Boolean)DELETE_DATABASE.invoke(uriOrMap);
    }

    public static UUID squuid() {
        return (UUID)SQUUID.invoke();
    }

    public static long squuidTimeMillis(UUID squuid2) {
        return (Long)SQUUID_TIME.invoke((Object)squuid2);
    }

    public static Object tempid(Object partition) {
        return ID_LITERAL.invoke((Object)new Object[]{partition});
    }

    public static Object tempid(Object partition, long idNumber) {
        return ID_LITERAL.invoke((Object)new Object[]{partition, idNumber});
    }

    public static Collection<List<Object>> q(Object query2, Object ... inputs) {
        return (Collection)Q.invoke(query2, (Object)inputs);
    }

    public static Fn function(Map m) {
        return (Fn)FUNCTION.invoke((Object)m);
    }

    static {
        REQUIRE.invoke((Object)Symbol.intern((String)"datomic.query"));
        REQUIRE.invoke((Object)Symbol.intern((String)"datomic.peer"));
        REQUIRE.invoke((Object)Symbol.intern((String)"datomic.function"));
        SQUUID = RT.var((String)"datomic.common", (String)"squuid");
        SQUUID_TIME = RT.var((String)"datomic.common", (String)"squuid-time-ms");
        ID_LITERAL = RT.var((String)"datomic.db", (String)"id-literal");
        FUNCTION = RT.var((String)"datomic.function", (String)"construct");
        Q = RT.var((String)"datomic.query", (String)"q");
        CREATE_DATABASE = RT.var((String)"datomic.peer", (String)"create-database");
        RENAME_DATABASE = RT.var((String)"datomic.peer", (String)"rename-database");
        DELETE_DATABASE = RT.var((String)"datomic.peer", (String)"delete-database");
        CONNECT_URI = RT.var((String)"datomic.peer", (String)"connect-uri");
    }
}

