/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.fressian.handlers.ILookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fns {
    public static IllegalArgumentException expected(Object expected, int ch) {
        return new IllegalArgumentException(String.format("expected %s at %X", expected, ch));
    }

    public static IllegalArgumentException expected(Object expected, int ch, Object got) {
        return new IllegalArgumentException(String.format("expected %s at %X, got %s", expected, ch, got));
    }

    public static <K, V> Map.Entry<K, V> soloEntry(Map<K, V> m) {
        if (m != null && m.size() == 1) {
            return m.entrySet().iterator().next();
        }
        throw new IllegalArgumentException(String.format("expected a map of one entry, got %s", m));
    }

    public static byte[] UUIDtoByteArray(UUID uuid) {
        byte[] bytes = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bytes;
    }

    public static UUID byteArrayToUUID(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static <K, V> K soloKey(Map<K, V> m) {
        return Fns.soloEntry(m).getKey();
    }

    public static <K, V> V soloVal(Map<K, V> m) {
        return Fns.soloEntry(m).getValue();
    }

    public static <K, V> Map<K, V> soloMap(K k, V v) {
        HashMap<K, V> m = new HashMap<K, V>();
        m.put(k, v);
        return m;
    }

    public static <K, V> V lookup(ILookup<K, V> theLookup, K k) {
        if (theLookup == null) {
            return null;
        }
        return theLookup.valAt(k);
    }

    public static Class getClassOrNull(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass();
    }

    public static int intCast(long x) {
        int i = (int)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return i;
    }

    public static void readUTF8Chars(StringBuffer dest, byte[] source, int offset, int length) {
        int pos = offset;
        block5: while (pos < length) {
            int ch = source[pos++] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    dest.append((char)ch);
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte ch1 = source[pos++];
                    dest.append((char)((ch & 0x1F) << 6 | ch1 & 0x3F));
                    continue block5;
                }
                case 14: {
                    byte ch1 = source[pos++];
                    byte ch2 = source[pos++];
                    dest.append((char)((ch & 0xF) << 12 | (ch1 & 0x3F) << 6 | ch2 & 0x3F));
                    continue block5;
                }
            }
            throw new RuntimeException(String.format("Invalid UTF-8: %X", ch));
        }
    }

    public static int utf8EncodingSize(int ch) {
        if (ch <= 127) {
            return 1;
        }
        if (ch > 2047) {
            return 3;
        }
        return 2;
    }

    public static int[] bufferStringChunkUTF8(CharSequence s, int start, byte[] byteBuffer) throws IOException {
        char ch;
        int encodingSize;
        int stringPos;
        int bufferPos = 0;
        block5: for (stringPos = start; stringPos < s.length() && bufferPos + (encodingSize = Fns.utf8EncodingSize(ch = s.charAt(stringPos))) <= byteBuffer.length; ++stringPos) {
            switch (encodingSize) {
                case 1: {
                    byteBuffer[bufferPos++] = (byte)ch;
                    continue block5;
                }
                case 2: {
                    byteBuffer[bufferPos++] = (byte)(0xC0 | ch >> 6 & 0x1F);
                    byteBuffer[bufferPos++] = (byte)(0x80 | ch >> 0 & 0x3F);
                    continue block5;
                }
                case 3: {
                    byteBuffer[bufferPos++] = (byte)(0xE0 | ch >> 12 & 0xF);
                    byteBuffer[bufferPos++] = (byte)(0x80 | ch >> 6 & 0x3F);
                    byteBuffer[bufferPos++] = (byte)(0x80 | ch >> 0 & 0x3F);
                }
            }
        }
        return new int[]{stringPos, bufferPos};
    }
}

