/*
 * Decompiled with CFR 0.152.
 */
package org.fressian;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fressian.Reader;
import org.fressian.TaggedObject;
import org.fressian.handlers.ConvertBytes;
import org.fressian.handlers.ConvertDouble;
import org.fressian.handlers.ConvertFloat;
import org.fressian.handlers.ConvertList;
import org.fressian.handlers.ILookup;
import org.fressian.handlers.ReadHandler;
import org.fressian.impl.Fns;
import org.fressian.impl.Handlers;
import org.fressian.impl.RawInput;
import org.fressian.impl.StructType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FressianReader
implements Reader,
Closeable {
    private final RawInput is;
    private ArrayList priorityCache;
    private ArrayList structCache;
    public final Map standardExtensionHandlers = Handlers.extendedReadHandlers;
    private final ILookup<Object, ReadHandler> handlerLookup;
    private byte[] byteBuffer;
    private static Object UNDER_CONSTRUCTION = new Object();
    public static final Map coreHandlers;

    public FressianReader(InputStream is) {
        this(is, null, true);
    }

    public FressianReader(InputStream is, ILookup<Object, ReadHandler> handlerLookup) {
        this(is, handlerLookup, true);
    }

    public FressianReader(InputStream is, ILookup<Object, ReadHandler> handlerLookup, boolean validateAdler) {
        this.is = new RawInput(is, validateAdler);
        this.handlerLookup = handlerLookup;
        this.resetCaches();
    }

    @Override
    public boolean readBoolean() throws IOException {
        int code = this.readNextCode();
        switch (code) {
            case 245: {
                return true;
            }
            case 246: {
                return false;
            }
        }
        Object result = this.read(code);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw Fns.expected("boolean", code, result);
    }

    @Override
    public long readInt() throws IOException {
        return this.internalReadInt();
    }

    private long internalReadInt() throws IOException {
        long result;
        int code = this.readNextCode();
        switch (code) {
            case 255: {
                result = -1L;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                result = (long)code & 0xFFL;
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                result = (long)(code - 80) << 8 | this.is.readRawInt8();
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                result = (long)(code - 104) << 16 | this.is.readRawInt16();
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                result = (long)(code - 114 << 24) | this.is.readRawInt24();
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                result = (long)(code - 118) << 32 | this.is.readRawInt32();
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                result = (long)code - 122L << 40 | this.is.readRawInt40();
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                result = (long)code - 126L << 48 | this.is.readRawInt48();
                break;
            }
            case 248: {
                result = this.is.readRawInt64();
                break;
            }
            default: {
                Object o = this.read(code);
                if (o instanceof Long) {
                    return (Long)o;
                }
                throw Fns.expected("int64", code, o);
            }
        }
        return result;
    }

    @Override
    public double readDouble() throws IOException {
        int code = this.readNextCode();
        double d = this.internalReadDouble(code);
        return d;
    }

    @Override
    public float readFloat() throws IOException {
        float result;
        int code = this.readNextCode();
        switch (code) {
            case 249: {
                result = this.is.readRawFloat();
                break;
            }
            default: {
                Object o = this.read(code);
                if (o instanceof Float) {
                    return ((Float)o).floatValue();
                }
                throw Fns.expected("float", code, o);
            }
        }
        return result;
    }

    @Override
    public Object readObject() throws IOException {
        return this.read(this.readNextCode());
    }

    private Object read(int code) throws IOException {
        Object result;
        switch (code) {
            case 255: {
                result = -1L;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                result = (long)code & 0xFFL;
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                result = (long)(code - 80) << 8 | this.is.readRawInt8();
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                result = (long)(code - 104) << 16 | this.is.readRawInt16();
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                result = (long)(code - 114 << 24) | this.is.readRawInt24();
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                result = (long)(code - 118) << 32 | this.is.readRawInt32();
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                result = (long)code - 122L << 40 | this.is.readRawInt40();
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                result = (long)code - 126L << 48 | this.is.readRawInt48();
                break;
            }
            case 205: {
                result = this.readAndCacheObject(this.getPriorityCache());
                break;
            }
            case 204: {
                result = this.lookupCache(this.getPriorityCache(), this.readInt32());
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                result = this.lookupCache(this.getPriorityCache(), code - 128);
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                StructType st = (StructType)this.lookupCache(this.getStructCache(), code - 160);
                result = this.handleStruct(st.tag, st.fields);
                break;
            }
            case 192: {
                result = this.handleStruct("map", 1);
                break;
            }
            case 193: {
                result = this.handleStruct("set", 1);
                break;
            }
            case 195: {
                result = this.handleStruct("uuid", 2);
                break;
            }
            case 196: {
                result = this.handleStruct("regex", 1);
                break;
            }
            case 197: {
                result = this.handleStruct("uri", 1);
                break;
            }
            case 198: {
                result = this.handleStruct("bigint", 1);
                break;
            }
            case 199: {
                result = this.handleStruct("bigdec", 2);
                break;
            }
            case 200: {
                result = this.handleStruct("inst", 1);
                break;
            }
            case 201: {
                result = this.handleStruct("sym", 2);
                break;
            }
            case 202: {
                result = this.handleStruct("key", 2);
                break;
            }
            case 179: {
                result = this.handleStruct("int[]", 2);
                break;
            }
            case 176: {
                result = this.handleStruct("long[]", 2);
                break;
            }
            case 180: {
                result = this.handleStruct("float[]", 2);
                break;
            }
            case 178: {
                result = this.handleStruct("boolean[]", 2);
                break;
            }
            case 177: {
                result = this.handleStruct("double[]", 2);
                break;
            }
            case 181: {
                result = this.handleStruct("Object[]", 2);
                break;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                result = this.internalReadBytes(code - 208);
                break;
            }
            case 217: {
                result = this.internalReadBytes(this.readCount());
                break;
            }
            case 216: {
                result = this.internalReadChunkedBytes();
                break;
            }
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                result = this.internalReadString(code - 218).toString();
                break;
            }
            case 227: {
                result = this.internalReadString(this.readCount()).toString();
                break;
            }
            case 226: {
                result = this.internalReadChunkedString(this.readCount());
                break;
            }
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: {
                result = this.internalReadList(code - 228);
                break;
            }
            case 236: {
                result = this.internalReadList(this.readCount());
                break;
            }
            case 237: {
                result = ((ConvertList)this.getHandler("list")).convertList(this.readClosedList());
                break;
            }
            case 238: {
                result = ((ConvertList)this.getHandler("list")).convertList(this.readOpenList());
                break;
            }
            case 245: {
                result = Boolean.TRUE;
                break;
            }
            case 246: {
                result = Boolean.FALSE;
                break;
            }
            case 250: 
            case 251: 
            case 252: {
                result = ((ConvertDouble)this.getHandler("double")).convertDouble(this.internalReadDouble(code));
                break;
            }
            case 249: {
                result = ((ConvertFloat)this.getHandler("float")).convertFloat(this.is.readRawFloat());
                break;
            }
            case 248: {
                result = this.is.readRawInt64();
                break;
            }
            case 247: {
                result = null;
                break;
            }
            case 207: {
                int calculatedLength = this.is.getBytesRead() - 1;
                int magicFromStream = (code << 24) + (int)this.is.readRawInt24();
                this.validateFooter(calculatedLength, magicFromStream);
                return this.readObject();
            }
            case 239: {
                Object tag = this.readObject();
                int fields = this.readInt32();
                this.getStructCache().add(new StructType(tag, fields));
                result = this.handleStruct(tag, fields);
                break;
            }
            case 240: {
                StructType st = (StructType)this.lookupCache(this.getStructCache(), this.readInt32());
                result = this.handleStruct(st.tag, st.fields);
                break;
            }
            case 254: {
                this.resetCaches();
                result = this.readObject();
                break;
            }
            default: {
                throw Fns.expected("any", code);
            }
        }
        return result;
    }

    private Object handleStruct(Object tag, int fields) throws IOException {
        ReadHandler h = Fns.lookup(this.handlerLookup, tag);
        if (h == null) {
            h = (ReadHandler)this.standardExtensionHandlers.get(tag);
        }
        if (h == null) {
            return new TaggedObject(tag, this.readObjects(fields));
        }
        return h.read(this, tag, fields);
    }

    private int readCount() throws IOException {
        return this.readInt32();
    }

    private int internalReadInt32() throws IOException {
        return Fns.intCast(this.internalReadInt());
    }

    private int readInt32() throws IOException {
        return Fns.intCast(this.readInt());
    }

    private StringBuffer internalReadString(int length) throws IOException {
        return this.internalReadStringBuffer(new StringBuffer(length), length);
    }

    private StringBuffer internalReadStringBuffer(StringBuffer buf, int length) throws IOException {
        if (this.byteBuffer == null || this.byteBuffer.length < length) {
            this.byteBuffer = new byte[length];
        }
        this.is.readFully(this.byteBuffer, 0, length);
        Fns.readUTF8Chars(buf, this.byteBuffer, 0, length);
        return buf;
    }

    private String internalReadChunkedString(int length) throws IOException {
        StringBuffer buf = this.internalReadString(length);
        boolean done = false;
        block5: while (!done) {
            int code = this.readNextCode();
            switch (code) {
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: {
                    this.internalReadStringBuffer(buf, code - 218).toString();
                    done = true;
                    continue block5;
                }
                case 227: {
                    this.internalReadStringBuffer(buf, this.readCount());
                    done = true;
                    continue block5;
                }
                case 226: {
                    this.internalReadStringBuffer(buf, this.readCount());
                    continue block5;
                }
            }
            throw Fns.expected("chunked string", code);
        }
        return buf.toString();
    }

    private byte[] internalReadBytes(int length) throws IOException {
        byte[] result = new byte[length];
        this.is.readFully(result, 0, length);
        return result;
    }

    private byte[] internalReadChunkedBytes() throws IOException {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int code = 216;
        while (code == 216) {
            chunks.add(this.internalReadBytes(this.readCount()));
            code = this.readNextCode();
        }
        if (code != 217) {
            throw Fns.expected("conclusion of chunked bytes", code);
        }
        chunks.add(this.internalReadBytes(this.readCount()));
        int length = 0;
        for (int n = 0; n < chunks.size(); ++n) {
            length += ((byte[])chunks.get(n)).length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (int n = 0; n < chunks.size(); ++n) {
            System.arraycopy(chunks.get(n), 0, result, pos, ((byte[])chunks.get(n)).length);
            pos += ((byte[])chunks.get(n)).length;
        }
        return result;
    }

    private Object getHandler(String tag) {
        Object o = coreHandlers.get(tag);
        if (o == null) {
            throw new RuntimeException("No read handler for type " + tag);
        }
        return o;
    }

    private double internalReadDouble(int code) throws IOException {
        switch (code) {
            case 250: {
                return this.is.readRawDouble();
            }
            case 251: {
                return 0.0;
            }
            case 252: {
                return 1.0;
            }
        }
        Object o = this.read(code);
        if (o instanceof Double) {
            return (Double)o;
        }
        throw Fns.expected("double", code, o);
    }

    private Object[] readObjects(int length) throws IOException {
        Object[] objects = new Object[length];
        for (int n = 0; n < length; ++n) {
            objects[n] = this.readObject();
        }
        return objects;
    }

    private Object[] readClosedList() throws IOException {
        ArrayList<Object> objects = new ArrayList<Object>();
        int code;
        while ((code = this.readNextCode()) != 253) {
            objects.add(this.read(code));
        }
        return objects.toArray();
    }

    private Object[] readOpenList() throws IOException {
        ArrayList<Object> objects = new ArrayList<Object>();
        while (true) {
            int code;
            try {
                code = this.readNextCode();
            }
            catch (EOFException e) {
                code = 253;
            }
            if (code == 253) {
                return objects.toArray();
            }
            objects.add(this.read(code));
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private Object lookupCache(ArrayList cache2, int index2) {
        if (index2 < cache2.size()) {
            Object result = cache2.get(index2);
            if (result == UNDER_CONSTRUCTION) {
                throw new RuntimeException("Unable to resolve circular reference in cache");
            }
            return result;
        }
        throw new RuntimeException("Requested object beyond end of cache at " + index2);
    }

    private List internalReadList(int length) throws IOException {
        return ((ConvertList)this.getHandler("list")).convertList(this.readObjects(length));
    }

    private void validateFooter(int calculatedLength, int magicFromStream) throws IOException {
        if (magicFromStream != -808464433) {
            throw new RuntimeException(String.format("Invalid footer magic, expected %X got %X", -808464433, magicFromStream));
        }
        int lengthFromStream = (int)this.is.readRawInt32();
        if (lengthFromStream != calculatedLength) {
            throw new RuntimeException(String.format("Invalid footer length, expected %X got %X", calculatedLength, lengthFromStream));
        }
        this.is.validateChecksum();
        this.is.reset();
        this.resetCaches();
    }

    private ArrayList getPriorityCache() {
        if (this.priorityCache == null) {
            this.priorityCache = new ArrayList();
        }
        return this.priorityCache;
    }

    private ArrayList getStructCache() {
        if (this.structCache == null) {
            this.structCache = new ArrayList();
        }
        return this.structCache;
    }

    private void resetCaches() {
        if (this.priorityCache != null) {
            this.priorityCache.clear();
        }
        if (this.structCache != null) {
            this.structCache.clear();
        }
    }

    @Override
    public void validateFooter() throws IOException {
        int calculatedLength = this.is.getBytesRead();
        int magicFromStream = (int)this.is.readRawInt32();
        this.validateFooter(calculatedLength, magicFromStream);
    }

    private int readNextCode() throws IOException {
        return this.is.readRawByte();
    }

    private Object readAndCacheObject(ArrayList cache2) throws IOException {
        int index2 = cache2.size();
        cache2.add(UNDER_CONSTRUCTION);
        Object o = this.readObject();
        cache2.set(index2, o);
        return o;
    }

    static {
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        handlers.put("list", new ConvertList(){

            public List convertList(Object[] items) {
                return Arrays.asList(items);
            }
        });
        handlers.put("bytes", new ConvertBytes(){

            public Object convertBytes(byte[] bytes) {
                return bytes;
            }
        });
        handlers.put("double", new ConvertDouble(){

            public Object convertDouble(double d) {
                return d;
            }
        });
        handlers.put("float", new ConvertFloat(){

            public Object convertFloat(float f) {
                return Float.valueOf(f);
            }
        });
        coreHandlers = Collections.unmodifiableMap(handlers);
    }

    static class MapEntry
    implements Map.Entry {
        public final Object key;
        public final Object value;

        public MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

