/*
 * Decompiled with CFR 0.152.
 */
package datomic.impl.lucene;

import clojure.lang.ILookup;
import datomic.impl.clusterfs.Closed;
import datomic.impl.clusterfs.IClusterFS;
import datomic.impl.lucene.ClusterIndexInput;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;

public class ClusterDirectory
extends Directory {
    private volatile IClusterFS cluster;
    private final ILookup olookup;

    public ClusterDirectory(IClusterFS cluster2, ILookup olookup) throws IOException {
        this.cluster = cluster2;
        this.olookup = olookup;
        this.setLockFactory((LockFactory)NoLockFactory.getNoLockFactory());
    }

    public String[] listAll() throws IOException {
        Collection c = this.cluster.getFiles();
        return c.toArray(new String[c.size()]);
    }

    public boolean fileExists(String s) throws IOException {
        return this.cluster.getFiles().contains(s);
    }

    public long fileModified(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void touchFile(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void deleteFile(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String s) throws IOException {
        return this.cluster.fileLength(s);
    }

    public IndexOutput createOutput(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    public IndexInput openInput(String s) throws IOException {
        return new ClusterIndexInput(this.cluster, this.olookup, s, this.cluster.chunkSize());
    }

    public void close() throws IOException {
        this.cluster = Closed.instance;
    }
}

