/*
 * Decompiled with CFR 0.152.
 */
package datomic.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf.duplicate();
    }

    public synchronized void reset() throws IOException {
        this.buf.reset();
    }

    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        byte result = this.buf.get();
        return result & 0xFF;
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int bytesRead = Math.min(len, this.buf.remaining());
        if (bytesRead <= 0) {
            return -1;
        }
        this.buf.get(bytes, off, bytesRead);
        return bytesRead;
    }

    public long skip(long l) throws IOException {
        int skipped = Math.min((int)l, this.buf.remaining());
        if (skipped <= 0) {
            return 0L;
        }
        this.buf.position(this.buf.position() + skipped);
        return skipped;
    }

    public int available() throws IOException {
        return this.buf.remaining();
    }
}

