goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__66715 = arguments.length;
switch (G__66715) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async66720 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async66720 = (function (f,blockable,meta66721){
this.f = f;
this.blockable = blockable;
this.meta66721 = meta66721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async66720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_66722,meta66721__$1){
var self__ = this;
var _66722__$1 = this;
return (new cljs.core.async.t_cljs$core$async66720(self__.f,self__.blockable,meta66721__$1));
}));

(cljs.core.async.t_cljs$core$async66720.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_66722){
var self__ = this;
var _66722__$1 = this;
return self__.meta66721;
}));

(cljs.core.async.t_cljs$core$async66720.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async66720.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async66720.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async66720.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async66720.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta66721","meta66721",-42029333,null)], null);
}));

(cljs.core.async.t_cljs$core$async66720.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async66720.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async66720");

(cljs.core.async.t_cljs$core$async66720.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async66720");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async66720.
 */
cljs.core.async.__GT_t_cljs$core$async66720 = (function cljs$core$async$__GT_t_cljs$core$async66720(f__$1,blockable__$1,meta66721){
return (new cljs.core.async.t_cljs$core$async66720(f__$1,blockable__$1,meta66721));
});

}

return (new cljs.core.async.t_cljs$core$async66720(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__66745 = arguments.length;
switch (G__66745) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__66759 = arguments.length;
switch (G__66759) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__66778 = arguments.length;
switch (G__66778) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_70275 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_70275) : fn1.call(null,val_70275));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_70275) : fn1.call(null,val_70275));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__66788 = arguments.length;
switch (G__66788) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___70299 = n;
var x_70300 = (0);
while(true){
if((x_70300 < n__4741__auto___70299)){
(a[x_70300] = x_70300);

var G__70301 = (x_70300 + (1));
x_70300 = G__70301;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async66804 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async66804 = (function (flag,meta66805){
this.flag = flag;
this.meta66805 = meta66805;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async66804.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_66806,meta66805__$1){
var self__ = this;
var _66806__$1 = this;
return (new cljs.core.async.t_cljs$core$async66804(self__.flag,meta66805__$1));
}));

(cljs.core.async.t_cljs$core$async66804.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_66806){
var self__ = this;
var _66806__$1 = this;
return self__.meta66805;
}));

(cljs.core.async.t_cljs$core$async66804.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async66804.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async66804.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async66804.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async66804.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta66805","meta66805",-25895804,null)], null);
}));

(cljs.core.async.t_cljs$core$async66804.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async66804.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async66804");

(cljs.core.async.t_cljs$core$async66804.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async66804");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async66804.
 */
cljs.core.async.__GT_t_cljs$core$async66804 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async66804(flag__$1,meta66805){
return (new cljs.core.async.t_cljs$core$async66804(flag__$1,meta66805));
});

}

return (new cljs.core.async.t_cljs$core$async66804(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async66819 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async66819 = (function (flag,cb,meta66820){
this.flag = flag;
this.cb = cb;
this.meta66820 = meta66820;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async66819.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_66821,meta66820__$1){
var self__ = this;
var _66821__$1 = this;
return (new cljs.core.async.t_cljs$core$async66819(self__.flag,self__.cb,meta66820__$1));
}));

(cljs.core.async.t_cljs$core$async66819.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_66821){
var self__ = this;
var _66821__$1 = this;
return self__.meta66820;
}));

(cljs.core.async.t_cljs$core$async66819.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async66819.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async66819.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async66819.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async66819.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta66820","meta66820",-416906906,null)], null);
}));

(cljs.core.async.t_cljs$core$async66819.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async66819.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async66819");

(cljs.core.async.t_cljs$core$async66819.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async66819");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async66819.
 */
cljs.core.async.__GT_t_cljs$core$async66819 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async66819(flag__$1,cb__$1,meta66820){
return (new cljs.core.async.t_cljs$core$async66819(flag__$1,cb__$1,meta66820));
});

}

return (new cljs.core.async.t_cljs$core$async66819(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__66832_SHARP_){
var G__66842 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__66832_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__66842) : fret.call(null,G__66842));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__66833_SHARP_){
var G__66843 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__66833_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__66843) : fret.call(null,G__66843));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__70307 = (i + (1));
i = G__70307;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70309 = arguments.length;
var i__4865__auto___70310 = (0);
while(true){
if((i__4865__auto___70310 < len__4864__auto___70309)){
args__4870__auto__.push((arguments[i__4865__auto___70310]));

var G__70311 = (i__4865__auto___70310 + (1));
i__4865__auto___70310 = G__70311;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__66857){
var map__66858 = p__66857;
var map__66858__$1 = cljs.core.__destructure_map(map__66858);
var opts = map__66858__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq66850){
var G__66851 = cljs.core.first(seq66850);
var seq66850__$1 = cljs.core.next(seq66850);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66851,seq66850__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__66876 = arguments.length;
switch (G__66876) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__43278__auto___70316 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_66913){
var state_val_66914 = (state_66913[(1)]);
if((state_val_66914 === (7))){
var inst_66909 = (state_66913[(2)]);
var state_66913__$1 = state_66913;
var statearr_66919_70317 = state_66913__$1;
(statearr_66919_70317[(2)] = inst_66909);

(statearr_66919_70317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (1))){
var state_66913__$1 = state_66913;
var statearr_66921_70318 = state_66913__$1;
(statearr_66921_70318[(2)] = null);

(statearr_66921_70318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (4))){
var inst_66889 = (state_66913[(7)]);
var inst_66889__$1 = (state_66913[(2)]);
var inst_66893 = (inst_66889__$1 == null);
var state_66913__$1 = (function (){var statearr_66925 = state_66913;
(statearr_66925[(7)] = inst_66889__$1);

return statearr_66925;
})();
if(cljs.core.truth_(inst_66893)){
var statearr_66927_70321 = state_66913__$1;
(statearr_66927_70321[(1)] = (5));

} else {
var statearr_66929_70323 = state_66913__$1;
(statearr_66929_70323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (13))){
var state_66913__$1 = state_66913;
var statearr_66931_70325 = state_66913__$1;
(statearr_66931_70325[(2)] = null);

(statearr_66931_70325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (6))){
var inst_66889 = (state_66913[(7)]);
var state_66913__$1 = state_66913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_66913__$1,(11),to,inst_66889);
} else {
if((state_val_66914 === (3))){
var inst_66911 = (state_66913[(2)]);
var state_66913__$1 = state_66913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66913__$1,inst_66911);
} else {
if((state_val_66914 === (12))){
var state_66913__$1 = state_66913;
var statearr_66932_70335 = state_66913__$1;
(statearr_66932_70335[(2)] = null);

(statearr_66932_70335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (2))){
var state_66913__$1 = state_66913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66913__$1,(4),from);
} else {
if((state_val_66914 === (11))){
var inst_66902 = (state_66913[(2)]);
var state_66913__$1 = state_66913;
if(cljs.core.truth_(inst_66902)){
var statearr_66937_70336 = state_66913__$1;
(statearr_66937_70336[(1)] = (12));

} else {
var statearr_66939_70337 = state_66913__$1;
(statearr_66939_70337[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (9))){
var state_66913__$1 = state_66913;
var statearr_66940_70338 = state_66913__$1;
(statearr_66940_70338[(2)] = null);

(statearr_66940_70338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (5))){
var state_66913__$1 = state_66913;
if(cljs.core.truth_(close_QMARK_)){
var statearr_66946_70344 = state_66913__$1;
(statearr_66946_70344[(1)] = (8));

} else {
var statearr_66947_70346 = state_66913__$1;
(statearr_66947_70346[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (14))){
var inst_66907 = (state_66913[(2)]);
var state_66913__$1 = state_66913;
var statearr_66948_70348 = state_66913__$1;
(statearr_66948_70348[(2)] = inst_66907);

(statearr_66948_70348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (10))){
var inst_66899 = (state_66913[(2)]);
var state_66913__$1 = state_66913;
var statearr_66953_70350 = state_66913__$1;
(statearr_66953_70350[(2)] = inst_66899);

(statearr_66953_70350[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66914 === (8))){
var inst_66896 = cljs.core.async.close_BANG_(to);
var state_66913__$1 = state_66913;
var statearr_66959_70352 = state_66913__$1;
(statearr_66959_70352[(2)] = inst_66896);

(statearr_66959_70352[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_66968 = [null,null,null,null,null,null,null,null];
(statearr_66968[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_66968[(1)] = (1));

return statearr_66968;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_66913){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_66913);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e66969){var ex__42018__auto__ = e66969;
var statearr_66971_70356 = state_66913;
(statearr_66971_70356[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_66913[(4)]))){
var statearr_66972_70357 = state_66913;
(statearr_66972_70357[(1)] = cljs.core.first((state_66913[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70358 = state_66913;
state_66913 = G__70358;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_66913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_66913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_66975 = f__43279__auto__();
(statearr_66975[(6)] = c__43278__auto___70316);

return statearr_66975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__66981){
var vec__66982 = p__66981;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66982,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66982,(1),null);
var job = vec__66982;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__43278__auto___70363 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_66990){
var state_val_66991 = (state_66990[(1)]);
if((state_val_66991 === (1))){
var state_66990__$1 = state_66990;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_66990__$1,(2),res,v);
} else {
if((state_val_66991 === (2))){
var inst_66987 = (state_66990[(2)]);
var inst_66988 = cljs.core.async.close_BANG_(res);
var state_66990__$1 = (function (){var statearr_66995 = state_66990;
(statearr_66995[(7)] = inst_66987);

return statearr_66995;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_66990__$1,inst_66988);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0 = (function (){
var statearr_66997 = [null,null,null,null,null,null,null,null];
(statearr_66997[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__);

(statearr_66997[(1)] = (1));

return statearr_66997;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1 = (function (state_66990){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_66990);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e66998){var ex__42018__auto__ = e66998;
var statearr_66999_70367 = state_66990;
(statearr_66999_70367[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_66990[(4)]))){
var statearr_67000_70368 = state_66990;
(statearr_67000_70368[(1)] = cljs.core.first((state_66990[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70369 = state_66990;
state_66990 = G__70369;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = function(state_66990){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1.call(this,state_66990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67006 = f__43279__auto__();
(statearr_67006[(6)] = c__43278__auto___70363);

return statearr_67006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__67007){
var vec__67008 = p__67007;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67008,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67008,(1),null);
var job = vec__67008;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___70370 = n;
var __70371 = (0);
while(true){
if((__70371 < n__4741__auto___70370)){
var G__67017_70373 = type;
var G__67017_70374__$1 = (((G__67017_70373 instanceof cljs.core.Keyword))?G__67017_70373.fqn:null);
switch (G__67017_70374__$1) {
case "compute":
var c__43278__auto___70376 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__70371,c__43278__auto___70376,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async){
return (function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = ((function (__70371,c__43278__auto___70376,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async){
return (function (state_67034){
var state_val_67035 = (state_67034[(1)]);
if((state_val_67035 === (1))){
var state_67034__$1 = state_67034;
var statearr_67036_70382 = state_67034__$1;
(statearr_67036_70382[(2)] = null);

(statearr_67036_70382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (2))){
var state_67034__$1 = state_67034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67034__$1,(4),jobs);
} else {
if((state_val_67035 === (3))){
var inst_67032 = (state_67034[(2)]);
var state_67034__$1 = state_67034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67034__$1,inst_67032);
} else {
if((state_val_67035 === (4))){
var inst_67024 = (state_67034[(2)]);
var inst_67025 = process(inst_67024);
var state_67034__$1 = state_67034;
if(cljs.core.truth_(inst_67025)){
var statearr_67038_70384 = state_67034__$1;
(statearr_67038_70384[(1)] = (5));

} else {
var statearr_67039_70385 = state_67034__$1;
(statearr_67039_70385[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (5))){
var state_67034__$1 = state_67034;
var statearr_67041_70386 = state_67034__$1;
(statearr_67041_70386[(2)] = null);

(statearr_67041_70386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (6))){
var state_67034__$1 = state_67034;
var statearr_67042_70391 = state_67034__$1;
(statearr_67042_70391[(2)] = null);

(statearr_67042_70391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67035 === (7))){
var inst_67030 = (state_67034[(2)]);
var state_67034__$1 = state_67034;
var statearr_67043_70393 = state_67034__$1;
(statearr_67043_70393[(2)] = inst_67030);

(statearr_67043_70393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__70371,c__43278__auto___70376,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async))
;
return ((function (__70371,switch__42014__auto__,c__43278__auto___70376,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0 = (function (){
var statearr_67044 = [null,null,null,null,null,null,null];
(statearr_67044[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__);

(statearr_67044[(1)] = (1));

return statearr_67044;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1 = (function (state_67034){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67034);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67046){var ex__42018__auto__ = e67046;
var statearr_67047_70396 = state_67034;
(statearr_67047_70396[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67034[(4)]))){
var statearr_67048_70397 = state_67034;
(statearr_67048_70397[(1)] = cljs.core.first((state_67034[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70398 = state_67034;
state_67034 = G__70398;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = function(state_67034){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1.call(this,state_67034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__;
})()
;})(__70371,switch__42014__auto__,c__43278__auto___70376,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async))
})();
var state__43280__auto__ = (function (){var statearr_67049 = f__43279__auto__();
(statearr_67049[(6)] = c__43278__auto___70376);

return statearr_67049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
});})(__70371,c__43278__auto___70376,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async))
);


break;
case "async":
var c__43278__auto___70399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__70371,c__43278__auto___70399,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async){
return (function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = ((function (__70371,c__43278__auto___70399,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async){
return (function (state_67065){
var state_val_67066 = (state_67065[(1)]);
if((state_val_67066 === (1))){
var state_67065__$1 = state_67065;
var statearr_67071_70400 = state_67065__$1;
(statearr_67071_70400[(2)] = null);

(statearr_67071_70400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67066 === (2))){
var state_67065__$1 = state_67065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67065__$1,(4),jobs);
} else {
if((state_val_67066 === (3))){
var inst_67063 = (state_67065[(2)]);
var state_67065__$1 = state_67065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67065__$1,inst_67063);
} else {
if((state_val_67066 === (4))){
var inst_67055 = (state_67065[(2)]);
var inst_67056 = async(inst_67055);
var state_67065__$1 = state_67065;
if(cljs.core.truth_(inst_67056)){
var statearr_67079_70401 = state_67065__$1;
(statearr_67079_70401[(1)] = (5));

} else {
var statearr_67080_70402 = state_67065__$1;
(statearr_67080_70402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67066 === (5))){
var state_67065__$1 = state_67065;
var statearr_67084_70403 = state_67065__$1;
(statearr_67084_70403[(2)] = null);

(statearr_67084_70403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67066 === (6))){
var state_67065__$1 = state_67065;
var statearr_67087_70405 = state_67065__$1;
(statearr_67087_70405[(2)] = null);

(statearr_67087_70405[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67066 === (7))){
var inst_67061 = (state_67065[(2)]);
var state_67065__$1 = state_67065;
var statearr_67094_70410 = state_67065__$1;
(statearr_67094_70410[(2)] = inst_67061);

(statearr_67094_70410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__70371,c__43278__auto___70399,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async))
;
return ((function (__70371,switch__42014__auto__,c__43278__auto___70399,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0 = (function (){
var statearr_67095 = [null,null,null,null,null,null,null];
(statearr_67095[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__);

(statearr_67095[(1)] = (1));

return statearr_67095;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1 = (function (state_67065){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67065);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67096){var ex__42018__auto__ = e67096;
var statearr_67097_70423 = state_67065;
(statearr_67097_70423[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67065[(4)]))){
var statearr_67098_70424 = state_67065;
(statearr_67098_70424[(1)] = cljs.core.first((state_67065[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70425 = state_67065;
state_67065 = G__70425;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = function(state_67065){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1.call(this,state_67065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__;
})()
;})(__70371,switch__42014__auto__,c__43278__auto___70399,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async))
})();
var state__43280__auto__ = (function (){var statearr_67105 = f__43279__auto__();
(statearr_67105[(6)] = c__43278__auto___70399);

return statearr_67105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
});})(__70371,c__43278__auto___70399,G__67017_70373,G__67017_70374__$1,n__4741__auto___70370,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67017_70374__$1)].join('')));

}

var G__70430 = (__70371 + (1));
__70371 = G__70430;
continue;
} else {
}
break;
}

var c__43278__auto___70431 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_67138){
var state_val_67139 = (state_67138[(1)]);
if((state_val_67139 === (7))){
var inst_67134 = (state_67138[(2)]);
var state_67138__$1 = state_67138;
var statearr_67144_70432 = state_67138__$1;
(statearr_67144_70432[(2)] = inst_67134);

(statearr_67144_70432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67139 === (1))){
var state_67138__$1 = state_67138;
var statearr_67145_70433 = state_67138__$1;
(statearr_67145_70433[(2)] = null);

(statearr_67145_70433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67139 === (4))){
var inst_67119 = (state_67138[(7)]);
var inst_67119__$1 = (state_67138[(2)]);
var inst_67120 = (inst_67119__$1 == null);
var state_67138__$1 = (function (){var statearr_67146 = state_67138;
(statearr_67146[(7)] = inst_67119__$1);

return statearr_67146;
})();
if(cljs.core.truth_(inst_67120)){
var statearr_67150_70434 = state_67138__$1;
(statearr_67150_70434[(1)] = (5));

} else {
var statearr_67151_70435 = state_67138__$1;
(statearr_67151_70435[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67139 === (6))){
var inst_67124 = (state_67138[(8)]);
var inst_67119 = (state_67138[(7)]);
var inst_67124__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_67125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67126 = [inst_67119,inst_67124__$1];
var inst_67127 = (new cljs.core.PersistentVector(null,2,(5),inst_67125,inst_67126,null));
var state_67138__$1 = (function (){var statearr_67156 = state_67138;
(statearr_67156[(8)] = inst_67124__$1);

return statearr_67156;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_67138__$1,(8),jobs,inst_67127);
} else {
if((state_val_67139 === (3))){
var inst_67136 = (state_67138[(2)]);
var state_67138__$1 = state_67138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67138__$1,inst_67136);
} else {
if((state_val_67139 === (2))){
var state_67138__$1 = state_67138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67138__$1,(4),from);
} else {
if((state_val_67139 === (9))){
var inst_67131 = (state_67138[(2)]);
var state_67138__$1 = (function (){var statearr_67157 = state_67138;
(statearr_67157[(9)] = inst_67131);

return statearr_67157;
})();
var statearr_67158_70436 = state_67138__$1;
(statearr_67158_70436[(2)] = null);

(statearr_67158_70436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67139 === (5))){
var inst_67122 = cljs.core.async.close_BANG_(jobs);
var state_67138__$1 = state_67138;
var statearr_67159_70438 = state_67138__$1;
(statearr_67159_70438[(2)] = inst_67122);

(statearr_67159_70438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67139 === (8))){
var inst_67124 = (state_67138[(8)]);
var inst_67129 = (state_67138[(2)]);
var state_67138__$1 = (function (){var statearr_67162 = state_67138;
(statearr_67162[(10)] = inst_67129);

return statearr_67162;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_67138__$1,(9),results,inst_67124);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0 = (function (){
var statearr_67163 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_67163[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__);

(statearr_67163[(1)] = (1));

return statearr_67163;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1 = (function (state_67138){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67138);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67164){var ex__42018__auto__ = e67164;
var statearr_67165_70440 = state_67138;
(statearr_67165_70440[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67138[(4)]))){
var statearr_67166_70445 = state_67138;
(statearr_67166_70445[(1)] = cljs.core.first((state_67138[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70446 = state_67138;
state_67138 = G__70446;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = function(state_67138){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1.call(this,state_67138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67169 = f__43279__auto__();
(statearr_67169[(6)] = c__43278__auto___70431);

return statearr_67169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


var c__43278__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_67233){
var state_val_67234 = (state_67233[(1)]);
if((state_val_67234 === (7))){
var inst_67228 = (state_67233[(2)]);
var state_67233__$1 = state_67233;
var statearr_67236_70447 = state_67233__$1;
(statearr_67236_70447[(2)] = inst_67228);

(statearr_67236_70447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (20))){
var state_67233__$1 = state_67233;
var statearr_67239_70449 = state_67233__$1;
(statearr_67239_70449[(2)] = null);

(statearr_67239_70449[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (1))){
var state_67233__$1 = state_67233;
var statearr_67241_70457 = state_67233__$1;
(statearr_67241_70457[(2)] = null);

(statearr_67241_70457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (4))){
var inst_67182 = (state_67233[(7)]);
var inst_67182__$1 = (state_67233[(2)]);
var inst_67184 = (inst_67182__$1 == null);
var state_67233__$1 = (function (){var statearr_67247 = state_67233;
(statearr_67247[(7)] = inst_67182__$1);

return statearr_67247;
})();
if(cljs.core.truth_(inst_67184)){
var statearr_67250_70462 = state_67233__$1;
(statearr_67250_70462[(1)] = (5));

} else {
var statearr_67251_70463 = state_67233__$1;
(statearr_67251_70463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (15))){
var inst_67205 = (state_67233[(8)]);
var state_67233__$1 = state_67233;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_67233__$1,(18),to,inst_67205);
} else {
if((state_val_67234 === (21))){
var inst_67219 = (state_67233[(2)]);
var state_67233__$1 = state_67233;
var statearr_67261_70467 = state_67233__$1;
(statearr_67261_70467[(2)] = inst_67219);

(statearr_67261_70467[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (13))){
var inst_67221 = (state_67233[(2)]);
var state_67233__$1 = (function (){var statearr_67265 = state_67233;
(statearr_67265[(9)] = inst_67221);

return statearr_67265;
})();
var statearr_67266_70468 = state_67233__$1;
(statearr_67266_70468[(2)] = null);

(statearr_67266_70468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (6))){
var inst_67182 = (state_67233[(7)]);
var state_67233__$1 = state_67233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67233__$1,(11),inst_67182);
} else {
if((state_val_67234 === (17))){
var inst_67214 = (state_67233[(2)]);
var state_67233__$1 = state_67233;
if(cljs.core.truth_(inst_67214)){
var statearr_67269_70473 = state_67233__$1;
(statearr_67269_70473[(1)] = (19));

} else {
var statearr_67274_70474 = state_67233__$1;
(statearr_67274_70474[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (3))){
var inst_67230 = (state_67233[(2)]);
var state_67233__$1 = state_67233;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67233__$1,inst_67230);
} else {
if((state_val_67234 === (12))){
var inst_67197 = (state_67233[(10)]);
var state_67233__$1 = state_67233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67233__$1,(14),inst_67197);
} else {
if((state_val_67234 === (2))){
var state_67233__$1 = state_67233;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67233__$1,(4),results);
} else {
if((state_val_67234 === (19))){
var state_67233__$1 = state_67233;
var statearr_67282_70475 = state_67233__$1;
(statearr_67282_70475[(2)] = null);

(statearr_67282_70475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (11))){
var inst_67197 = (state_67233[(2)]);
var state_67233__$1 = (function (){var statearr_67283 = state_67233;
(statearr_67283[(10)] = inst_67197);

return statearr_67283;
})();
var statearr_67286_70476 = state_67233__$1;
(statearr_67286_70476[(2)] = null);

(statearr_67286_70476[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (9))){
var state_67233__$1 = state_67233;
var statearr_67292_70477 = state_67233__$1;
(statearr_67292_70477[(2)] = null);

(statearr_67292_70477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (5))){
var state_67233__$1 = state_67233;
if(cljs.core.truth_(close_QMARK_)){
var statearr_67294_70478 = state_67233__$1;
(statearr_67294_70478[(1)] = (8));

} else {
var statearr_67295_70479 = state_67233__$1;
(statearr_67295_70479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (14))){
var inst_67208 = (state_67233[(11)]);
var inst_67205 = (state_67233[(8)]);
var inst_67205__$1 = (state_67233[(2)]);
var inst_67207 = (inst_67205__$1 == null);
var inst_67208__$1 = cljs.core.not(inst_67207);
var state_67233__$1 = (function (){var statearr_67301 = state_67233;
(statearr_67301[(11)] = inst_67208__$1);

(statearr_67301[(8)] = inst_67205__$1);

return statearr_67301;
})();
if(inst_67208__$1){
var statearr_67326_70480 = state_67233__$1;
(statearr_67326_70480[(1)] = (15));

} else {
var statearr_67327_70481 = state_67233__$1;
(statearr_67327_70481[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (16))){
var inst_67208 = (state_67233[(11)]);
var state_67233__$1 = state_67233;
var statearr_67331_70486 = state_67233__$1;
(statearr_67331_70486[(2)] = inst_67208);

(statearr_67331_70486[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (10))){
var inst_67192 = (state_67233[(2)]);
var state_67233__$1 = state_67233;
var statearr_67333_70487 = state_67233__$1;
(statearr_67333_70487[(2)] = inst_67192);

(statearr_67333_70487[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (18))){
var inst_67211 = (state_67233[(2)]);
var state_67233__$1 = state_67233;
var statearr_67334_70494 = state_67233__$1;
(statearr_67334_70494[(2)] = inst_67211);

(statearr_67334_70494[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67234 === (8))){
var inst_67189 = cljs.core.async.close_BANG_(to);
var state_67233__$1 = state_67233;
var statearr_67336_70495 = state_67233__$1;
(statearr_67336_70495[(2)] = inst_67189);

(statearr_67336_70495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0 = (function (){
var statearr_67342 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67342[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__);

(statearr_67342[(1)] = (1));

return statearr_67342;
});
var cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1 = (function (state_67233){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67233);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67343){var ex__42018__auto__ = e67343;
var statearr_67344_70505 = state_67233;
(statearr_67344_70505[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67233[(4)]))){
var statearr_67345_70510 = state_67233;
(statearr_67345_70510[(1)] = cljs.core.first((state_67233[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70514 = state_67233;
state_67233 = G__70514;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__ = function(state_67233){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1.call(this,state_67233);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__42015__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67349 = f__43279__auto__();
(statearr_67349[(6)] = c__43278__auto__);

return statearr_67349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));

return c__43278__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__67359 = arguments.length;
switch (G__67359) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__67378 = arguments.length;
switch (G__67378) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__67402 = arguments.length;
switch (G__67402) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__43278__auto___70532 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_67439){
var state_val_67440 = (state_67439[(1)]);
if((state_val_67440 === (7))){
var inst_67434 = (state_67439[(2)]);
var state_67439__$1 = state_67439;
var statearr_67441_70536 = state_67439__$1;
(statearr_67441_70536[(2)] = inst_67434);

(statearr_67441_70536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (1))){
var state_67439__$1 = state_67439;
var statearr_67442_70537 = state_67439__$1;
(statearr_67442_70537[(2)] = null);

(statearr_67442_70537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (4))){
var inst_67412 = (state_67439[(7)]);
var inst_67412__$1 = (state_67439[(2)]);
var inst_67413 = (inst_67412__$1 == null);
var state_67439__$1 = (function (){var statearr_67445 = state_67439;
(statearr_67445[(7)] = inst_67412__$1);

return statearr_67445;
})();
if(cljs.core.truth_(inst_67413)){
var statearr_67447_70542 = state_67439__$1;
(statearr_67447_70542[(1)] = (5));

} else {
var statearr_67448_70543 = state_67439__$1;
(statearr_67448_70543[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (13))){
var state_67439__$1 = state_67439;
var statearr_67455_70546 = state_67439__$1;
(statearr_67455_70546[(2)] = null);

(statearr_67455_70546[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (6))){
var inst_67412 = (state_67439[(7)]);
var inst_67419 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_67412) : p.call(null,inst_67412));
var state_67439__$1 = state_67439;
if(cljs.core.truth_(inst_67419)){
var statearr_67456_70551 = state_67439__$1;
(statearr_67456_70551[(1)] = (9));

} else {
var statearr_67457_70552 = state_67439__$1;
(statearr_67457_70552[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (3))){
var inst_67436 = (state_67439[(2)]);
var state_67439__$1 = state_67439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67439__$1,inst_67436);
} else {
if((state_val_67440 === (12))){
var state_67439__$1 = state_67439;
var statearr_67460_70553 = state_67439__$1;
(statearr_67460_70553[(2)] = null);

(statearr_67460_70553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (2))){
var state_67439__$1 = state_67439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67439__$1,(4),ch);
} else {
if((state_val_67440 === (11))){
var inst_67412 = (state_67439[(7)]);
var inst_67423 = (state_67439[(2)]);
var state_67439__$1 = state_67439;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_67439__$1,(8),inst_67423,inst_67412);
} else {
if((state_val_67440 === (9))){
var state_67439__$1 = state_67439;
var statearr_67467_70556 = state_67439__$1;
(statearr_67467_70556[(2)] = tc);

(statearr_67467_70556[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (5))){
var inst_67415 = cljs.core.async.close_BANG_(tc);
var inst_67416 = cljs.core.async.close_BANG_(fc);
var state_67439__$1 = (function (){var statearr_67469 = state_67439;
(statearr_67469[(8)] = inst_67415);

return statearr_67469;
})();
var statearr_67471_70561 = state_67439__$1;
(statearr_67471_70561[(2)] = inst_67416);

(statearr_67471_70561[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (14))){
var inst_67432 = (state_67439[(2)]);
var state_67439__$1 = state_67439;
var statearr_67478_70562 = state_67439__$1;
(statearr_67478_70562[(2)] = inst_67432);

(statearr_67478_70562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (10))){
var state_67439__$1 = state_67439;
var statearr_67482_70563 = state_67439__$1;
(statearr_67482_70563[(2)] = fc);

(statearr_67482_70563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67440 === (8))){
var inst_67425 = (state_67439[(2)]);
var state_67439__$1 = state_67439;
if(cljs.core.truth_(inst_67425)){
var statearr_67484_70568 = state_67439__$1;
(statearr_67484_70568[(1)] = (12));

} else {
var statearr_67486_70569 = state_67439__$1;
(statearr_67486_70569[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_67491 = [null,null,null,null,null,null,null,null,null];
(statearr_67491[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_67491[(1)] = (1));

return statearr_67491;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_67439){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67439);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67493){var ex__42018__auto__ = e67493;
var statearr_67494_70571 = state_67439;
(statearr_67494_70571[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67439[(4)]))){
var statearr_67495_70572 = state_67439;
(statearr_67495_70572[(1)] = cljs.core.first((state_67439[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70574 = state_67439;
state_67439 = G__70574;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_67439){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_67439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67504 = f__43279__auto__();
(statearr_67504[(6)] = c__43278__auto___70532);

return statearr_67504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__43278__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_67537){
var state_val_67538 = (state_67537[(1)]);
if((state_val_67538 === (7))){
var inst_67532 = (state_67537[(2)]);
var state_67537__$1 = state_67537;
var statearr_67560_70575 = state_67537__$1;
(statearr_67560_70575[(2)] = inst_67532);

(statearr_67560_70575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (1))){
var inst_67511 = init;
var inst_67513 = inst_67511;
var state_67537__$1 = (function (){var statearr_67569 = state_67537;
(statearr_67569[(7)] = inst_67513);

return statearr_67569;
})();
var statearr_67570_70582 = state_67537__$1;
(statearr_67570_70582[(2)] = null);

(statearr_67570_70582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (4))){
var inst_67518 = (state_67537[(8)]);
var inst_67518__$1 = (state_67537[(2)]);
var inst_67519 = (inst_67518__$1 == null);
var state_67537__$1 = (function (){var statearr_67571 = state_67537;
(statearr_67571[(8)] = inst_67518__$1);

return statearr_67571;
})();
if(cljs.core.truth_(inst_67519)){
var statearr_67572_70584 = state_67537__$1;
(statearr_67572_70584[(1)] = (5));

} else {
var statearr_67573_70585 = state_67537__$1;
(statearr_67573_70585[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (6))){
var inst_67513 = (state_67537[(7)]);
var inst_67522 = (state_67537[(9)]);
var inst_67518 = (state_67537[(8)]);
var inst_67522__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_67513,inst_67518) : f.call(null,inst_67513,inst_67518));
var inst_67523 = cljs.core.reduced_QMARK_(inst_67522__$1);
var state_67537__$1 = (function (){var statearr_67574 = state_67537;
(statearr_67574[(9)] = inst_67522__$1);

return statearr_67574;
})();
if(inst_67523){
var statearr_67577_70594 = state_67537__$1;
(statearr_67577_70594[(1)] = (8));

} else {
var statearr_67580_70595 = state_67537__$1;
(statearr_67580_70595[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (3))){
var inst_67534 = (state_67537[(2)]);
var state_67537__$1 = state_67537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67537__$1,inst_67534);
} else {
if((state_val_67538 === (2))){
var state_67537__$1 = state_67537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67537__$1,(4),ch);
} else {
if((state_val_67538 === (9))){
var inst_67522 = (state_67537[(9)]);
var inst_67513 = inst_67522;
var state_67537__$1 = (function (){var statearr_67584 = state_67537;
(statearr_67584[(7)] = inst_67513);

return statearr_67584;
})();
var statearr_67587_70596 = state_67537__$1;
(statearr_67587_70596[(2)] = null);

(statearr_67587_70596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (5))){
var inst_67513 = (state_67537[(7)]);
var state_67537__$1 = state_67537;
var statearr_67590_70601 = state_67537__$1;
(statearr_67590_70601[(2)] = inst_67513);

(statearr_67590_70601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (10))){
var inst_67530 = (state_67537[(2)]);
var state_67537__$1 = state_67537;
var statearr_67591_70602 = state_67537__$1;
(statearr_67591_70602[(2)] = inst_67530);

(statearr_67591_70602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67538 === (8))){
var inst_67522 = (state_67537[(9)]);
var inst_67526 = cljs.core.deref(inst_67522);
var state_67537__$1 = state_67537;
var statearr_67596_70606 = state_67537__$1;
(statearr_67596_70606[(2)] = inst_67526);

(statearr_67596_70606[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__42015__auto__ = null;
var cljs$core$async$reduce_$_state_machine__42015__auto____0 = (function (){
var statearr_67601 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67601[(0)] = cljs$core$async$reduce_$_state_machine__42015__auto__);

(statearr_67601[(1)] = (1));

return statearr_67601;
});
var cljs$core$async$reduce_$_state_machine__42015__auto____1 = (function (state_67537){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67537);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67608){var ex__42018__auto__ = e67608;
var statearr_67612_70610 = state_67537;
(statearr_67612_70610[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67537[(4)]))){
var statearr_67638_70614 = state_67537;
(statearr_67638_70614[(1)] = cljs.core.first((state_67537[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70615 = state_67537;
state_67537 = G__70615;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__42015__auto__ = function(state_67537){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__42015__auto____1.call(this,state_67537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__42015__auto____0;
cljs$core$async$reduce_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__42015__auto____1;
return cljs$core$async$reduce_$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67643 = f__43279__auto__();
(statearr_67643[(6)] = c__43278__auto__);

return statearr_67643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));

return c__43278__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__43278__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_67704){
var state_val_67705 = (state_67704[(1)]);
if((state_val_67705 === (1))){
var inst_67699 = cljs.core.async.reduce(f__$1,init,ch);
var state_67704__$1 = state_67704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67704__$1,(2),inst_67699);
} else {
if((state_val_67705 === (2))){
var inst_67701 = (state_67704[(2)]);
var inst_67702 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_67701) : f__$1.call(null,inst_67701));
var state_67704__$1 = state_67704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67704__$1,inst_67702);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__42015__auto__ = null;
var cljs$core$async$transduce_$_state_machine__42015__auto____0 = (function (){
var statearr_67734 = [null,null,null,null,null,null,null];
(statearr_67734[(0)] = cljs$core$async$transduce_$_state_machine__42015__auto__);

(statearr_67734[(1)] = (1));

return statearr_67734;
});
var cljs$core$async$transduce_$_state_machine__42015__auto____1 = (function (state_67704){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67704);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67739){var ex__42018__auto__ = e67739;
var statearr_67741_70623 = state_67704;
(statearr_67741_70623[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67704[(4)]))){
var statearr_67742_70624 = state_67704;
(statearr_67742_70624[(1)] = cljs.core.first((state_67704[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70625 = state_67704;
state_67704 = G__70625;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__42015__auto__ = function(state_67704){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__42015__auto____1.call(this,state_67704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__42015__auto____0;
cljs$core$async$transduce_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__42015__auto____1;
return cljs$core$async$transduce_$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67745 = f__43279__auto__();
(statearr_67745[(6)] = c__43278__auto__);

return statearr_67745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));

return c__43278__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__67747 = arguments.length;
switch (G__67747) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__43278__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_67793){
var state_val_67794 = (state_67793[(1)]);
if((state_val_67794 === (7))){
var inst_67775 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
var statearr_67799_70632 = state_67793__$1;
(statearr_67799_70632[(2)] = inst_67775);

(statearr_67799_70632[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (1))){
var inst_67757 = cljs.core.seq(coll);
var inst_67762 = inst_67757;
var state_67793__$1 = (function (){var statearr_67800 = state_67793;
(statearr_67800[(7)] = inst_67762);

return statearr_67800;
})();
var statearr_67801_70633 = state_67793__$1;
(statearr_67801_70633[(2)] = null);

(statearr_67801_70633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (4))){
var inst_67762 = (state_67793[(7)]);
var inst_67773 = cljs.core.first(inst_67762);
var state_67793__$1 = state_67793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_67793__$1,(7),ch,inst_67773);
} else {
if((state_val_67794 === (13))){
var inst_67787 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
var statearr_67802_70634 = state_67793__$1;
(statearr_67802_70634[(2)] = inst_67787);

(statearr_67802_70634[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (6))){
var inst_67778 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
if(cljs.core.truth_(inst_67778)){
var statearr_67809_70635 = state_67793__$1;
(statearr_67809_70635[(1)] = (8));

} else {
var statearr_67812_70636 = state_67793__$1;
(statearr_67812_70636[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (3))){
var inst_67791 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67793__$1,inst_67791);
} else {
if((state_val_67794 === (12))){
var state_67793__$1 = state_67793;
var statearr_67815_70640 = state_67793__$1;
(statearr_67815_70640[(2)] = null);

(statearr_67815_70640[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (2))){
var inst_67762 = (state_67793[(7)]);
var state_67793__$1 = state_67793;
if(cljs.core.truth_(inst_67762)){
var statearr_67820_70641 = state_67793__$1;
(statearr_67820_70641[(1)] = (4));

} else {
var statearr_67821_70642 = state_67793__$1;
(statearr_67821_70642[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (11))){
var inst_67784 = cljs.core.async.close_BANG_(ch);
var state_67793__$1 = state_67793;
var statearr_67823_70645 = state_67793__$1;
(statearr_67823_70645[(2)] = inst_67784);

(statearr_67823_70645[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (9))){
var state_67793__$1 = state_67793;
if(cljs.core.truth_(close_QMARK_)){
var statearr_67826_70646 = state_67793__$1;
(statearr_67826_70646[(1)] = (11));

} else {
var statearr_67827_70647 = state_67793__$1;
(statearr_67827_70647[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (5))){
var inst_67762 = (state_67793[(7)]);
var state_67793__$1 = state_67793;
var statearr_67829_70650 = state_67793__$1;
(statearr_67829_70650[(2)] = inst_67762);

(statearr_67829_70650[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (10))){
var inst_67789 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
var statearr_67831_70651 = state_67793__$1;
(statearr_67831_70651[(2)] = inst_67789);

(statearr_67831_70651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67794 === (8))){
var inst_67762 = (state_67793[(7)]);
var inst_67780 = cljs.core.next(inst_67762);
var inst_67762__$1 = inst_67780;
var state_67793__$1 = (function (){var statearr_67836 = state_67793;
(statearr_67836[(7)] = inst_67762__$1);

return statearr_67836;
})();
var statearr_67837_70656 = state_67793__$1;
(statearr_67837_70656[(2)] = null);

(statearr_67837_70656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_67840 = [null,null,null,null,null,null,null,null];
(statearr_67840[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_67840[(1)] = (1));

return statearr_67840;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_67793){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_67793);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e67842){var ex__42018__auto__ = e67842;
var statearr_67843_70667 = state_67793;
(statearr_67843_70667[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_67793[(4)]))){
var statearr_67844_70668 = state_67793;
(statearr_67844_70668[(1)] = cljs.core.first((state_67793[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70669 = state_67793;
state_67793 = G__70669;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_67793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_67793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_67845 = f__43279__auto__();
(statearr_67845[(6)] = c__43278__auto__);

return statearr_67845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));

return c__43278__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__67851 = arguments.length;
switch (G__67851) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_70676 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_70676(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_70680 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_70680(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_70681 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_70681(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_70683 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_70683(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async67872 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async67872 = (function (ch,cs,meta67873){
this.ch = ch;
this.cs = cs;
this.meta67873 = meta67873;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_67874,meta67873__$1){
var self__ = this;
var _67874__$1 = this;
return (new cljs.core.async.t_cljs$core$async67872(self__.ch,self__.cs,meta67873__$1));
}));

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_67874){
var self__ = this;
var _67874__$1 = this;
return self__.meta67873;
}));

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async67872.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async67872.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta67873","meta67873",-1672482651,null)], null);
}));

(cljs.core.async.t_cljs$core$async67872.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async67872.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async67872");

(cljs.core.async.t_cljs$core$async67872.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async67872");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async67872.
 */
cljs.core.async.__GT_t_cljs$core$async67872 = (function cljs$core$async$mult_$___GT_t_cljs$core$async67872(ch__$1,cs__$1,meta67873){
return (new cljs.core.async.t_cljs$core$async67872(ch__$1,cs__$1,meta67873));
});

}

return (new cljs.core.async.t_cljs$core$async67872(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__43278__auto___70697 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_68069){
var state_val_68070 = (state_68069[(1)]);
if((state_val_68070 === (7))){
var inst_68063 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68077_70698 = state_68069__$1;
(statearr_68077_70698[(2)] = inst_68063);

(statearr_68077_70698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (20))){
var inst_67933 = (state_68069[(7)]);
var inst_67951 = cljs.core.first(inst_67933);
var inst_67952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67951,(0),null);
var inst_67953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67951,(1),null);
var state_68069__$1 = (function (){var statearr_68080 = state_68069;
(statearr_68080[(8)] = inst_67952);

return statearr_68080;
})();
if(cljs.core.truth_(inst_67953)){
var statearr_68082_70699 = state_68069__$1;
(statearr_68082_70699[(1)] = (22));

} else {
var statearr_68084_70700 = state_68069__$1;
(statearr_68084_70700[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (27))){
var inst_68000 = (state_68069[(9)]);
var inst_67992 = (state_68069[(10)]);
var inst_67899 = (state_68069[(11)]);
var inst_67994 = (state_68069[(12)]);
var inst_68000__$1 = cljs.core._nth(inst_67992,inst_67994);
var inst_68001 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_68000__$1,inst_67899,done);
var state_68069__$1 = (function (){var statearr_68090 = state_68069;
(statearr_68090[(9)] = inst_68000__$1);

return statearr_68090;
})();
if(cljs.core.truth_(inst_68001)){
var statearr_68091_70705 = state_68069__$1;
(statearr_68091_70705[(1)] = (30));

} else {
var statearr_68093_70706 = state_68069__$1;
(statearr_68093_70706[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (1))){
var state_68069__$1 = state_68069;
var statearr_68094_70707 = state_68069__$1;
(statearr_68094_70707[(2)] = null);

(statearr_68094_70707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (24))){
var inst_67933 = (state_68069[(7)]);
var inst_67959 = (state_68069[(2)]);
var inst_67962 = cljs.core.next(inst_67933);
var inst_67908 = inst_67962;
var inst_67909 = null;
var inst_67910 = (0);
var inst_67911 = (0);
var state_68069__$1 = (function (){var statearr_68095 = state_68069;
(statearr_68095[(13)] = inst_67909);

(statearr_68095[(14)] = inst_67959);

(statearr_68095[(15)] = inst_67908);

(statearr_68095[(16)] = inst_67911);

(statearr_68095[(17)] = inst_67910);

return statearr_68095;
})();
var statearr_68096_70708 = state_68069__$1;
(statearr_68096_70708[(2)] = null);

(statearr_68096_70708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (39))){
var state_68069__$1 = state_68069;
var statearr_68101_70712 = state_68069__$1;
(statearr_68101_70712[(2)] = null);

(statearr_68101_70712[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (4))){
var inst_67899 = (state_68069[(11)]);
var inst_67899__$1 = (state_68069[(2)]);
var inst_67900 = (inst_67899__$1 == null);
var state_68069__$1 = (function (){var statearr_68104 = state_68069;
(statearr_68104[(11)] = inst_67899__$1);

return statearr_68104;
})();
if(cljs.core.truth_(inst_67900)){
var statearr_68106_70714 = state_68069__$1;
(statearr_68106_70714[(1)] = (5));

} else {
var statearr_68107_70715 = state_68069__$1;
(statearr_68107_70715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (15))){
var inst_67909 = (state_68069[(13)]);
var inst_67908 = (state_68069[(15)]);
var inst_67911 = (state_68069[(16)]);
var inst_67910 = (state_68069[(17)]);
var inst_67929 = (state_68069[(2)]);
var inst_67930 = (inst_67911 + (1));
var tmp68097 = inst_67909;
var tmp68098 = inst_67908;
var tmp68099 = inst_67910;
var inst_67908__$1 = tmp68098;
var inst_67909__$1 = tmp68097;
var inst_67910__$1 = tmp68099;
var inst_67911__$1 = inst_67930;
var state_68069__$1 = (function (){var statearr_68108 = state_68069;
(statearr_68108[(13)] = inst_67909__$1);

(statearr_68108[(15)] = inst_67908__$1);

(statearr_68108[(16)] = inst_67911__$1);

(statearr_68108[(17)] = inst_67910__$1);

(statearr_68108[(18)] = inst_67929);

return statearr_68108;
})();
var statearr_68109_70725 = state_68069__$1;
(statearr_68109_70725[(2)] = null);

(statearr_68109_70725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (21))){
var inst_67965 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68114_70726 = state_68069__$1;
(statearr_68114_70726[(2)] = inst_67965);

(statearr_68114_70726[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (31))){
var inst_68000 = (state_68069[(9)]);
var inst_68004 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_68000);
var state_68069__$1 = state_68069;
var statearr_68119_70732 = state_68069__$1;
(statearr_68119_70732[(2)] = inst_68004);

(statearr_68119_70732[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (32))){
var inst_67992 = (state_68069[(10)]);
var inst_67994 = (state_68069[(12)]);
var inst_67993 = (state_68069[(19)]);
var inst_67991 = (state_68069[(20)]);
var inst_68006 = (state_68069[(2)]);
var inst_68009 = (inst_67994 + (1));
var tmp68111 = inst_67992;
var tmp68112 = inst_67993;
var tmp68113 = inst_67991;
var inst_67991__$1 = tmp68113;
var inst_67992__$1 = tmp68111;
var inst_67993__$1 = tmp68112;
var inst_67994__$1 = inst_68009;
var state_68069__$1 = (function (){var statearr_68123 = state_68069;
(statearr_68123[(10)] = inst_67992__$1);

(statearr_68123[(12)] = inst_67994__$1);

(statearr_68123[(19)] = inst_67993__$1);

(statearr_68123[(21)] = inst_68006);

(statearr_68123[(20)] = inst_67991__$1);

return statearr_68123;
})();
var statearr_68124_70734 = state_68069__$1;
(statearr_68124_70734[(2)] = null);

(statearr_68124_70734[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (40))){
var inst_68030 = (state_68069[(22)]);
var inst_68036 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_68030);
var state_68069__$1 = state_68069;
var statearr_68129_70736 = state_68069__$1;
(statearr_68129_70736[(2)] = inst_68036);

(statearr_68129_70736[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (33))){
var inst_68018 = (state_68069[(23)]);
var inst_68023 = cljs.core.chunked_seq_QMARK_(inst_68018);
var state_68069__$1 = state_68069;
if(inst_68023){
var statearr_68135_70737 = state_68069__$1;
(statearr_68135_70737[(1)] = (36));

} else {
var statearr_68139_70739 = state_68069__$1;
(statearr_68139_70739[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (13))){
var inst_67923 = (state_68069[(24)]);
var inst_67926 = cljs.core.async.close_BANG_(inst_67923);
var state_68069__$1 = state_68069;
var statearr_68144_70740 = state_68069__$1;
(statearr_68144_70740[(2)] = inst_67926);

(statearr_68144_70740[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (22))){
var inst_67952 = (state_68069[(8)]);
var inst_67955 = cljs.core.async.close_BANG_(inst_67952);
var state_68069__$1 = state_68069;
var statearr_68149_70741 = state_68069__$1;
(statearr_68149_70741[(2)] = inst_67955);

(statearr_68149_70741[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (36))){
var inst_68018 = (state_68069[(23)]);
var inst_68025 = cljs.core.chunk_first(inst_68018);
var inst_68026 = cljs.core.chunk_rest(inst_68018);
var inst_68027 = cljs.core.count(inst_68025);
var inst_67991 = inst_68026;
var inst_67992 = inst_68025;
var inst_67993 = inst_68027;
var inst_67994 = (0);
var state_68069__$1 = (function (){var statearr_68154 = state_68069;
(statearr_68154[(10)] = inst_67992);

(statearr_68154[(12)] = inst_67994);

(statearr_68154[(19)] = inst_67993);

(statearr_68154[(20)] = inst_67991);

return statearr_68154;
})();
var statearr_68155_70742 = state_68069__$1;
(statearr_68155_70742[(2)] = null);

(statearr_68155_70742[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (41))){
var inst_68018 = (state_68069[(23)]);
var inst_68038 = (state_68069[(2)]);
var inst_68039 = cljs.core.next(inst_68018);
var inst_67991 = inst_68039;
var inst_67992 = null;
var inst_67993 = (0);
var inst_67994 = (0);
var state_68069__$1 = (function (){var statearr_68160 = state_68069;
(statearr_68160[(10)] = inst_67992);

(statearr_68160[(25)] = inst_68038);

(statearr_68160[(12)] = inst_67994);

(statearr_68160[(19)] = inst_67993);

(statearr_68160[(20)] = inst_67991);

return statearr_68160;
})();
var statearr_68161_70743 = state_68069__$1;
(statearr_68161_70743[(2)] = null);

(statearr_68161_70743[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (43))){
var state_68069__$1 = state_68069;
var statearr_68162_70753 = state_68069__$1;
(statearr_68162_70753[(2)] = null);

(statearr_68162_70753[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (29))){
var inst_68049 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68163_70754 = state_68069__$1;
(statearr_68163_70754[(2)] = inst_68049);

(statearr_68163_70754[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (44))){
var inst_68060 = (state_68069[(2)]);
var state_68069__$1 = (function (){var statearr_68166 = state_68069;
(statearr_68166[(26)] = inst_68060);

return statearr_68166;
})();
var statearr_68167_70755 = state_68069__$1;
(statearr_68167_70755[(2)] = null);

(statearr_68167_70755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (6))){
var inst_67981 = (state_68069[(27)]);
var inst_67980 = cljs.core.deref(cs);
var inst_67981__$1 = cljs.core.keys(inst_67980);
var inst_67983 = cljs.core.count(inst_67981__$1);
var inst_67984 = cljs.core.reset_BANG_(dctr,inst_67983);
var inst_67990 = cljs.core.seq(inst_67981__$1);
var inst_67991 = inst_67990;
var inst_67992 = null;
var inst_67993 = (0);
var inst_67994 = (0);
var state_68069__$1 = (function (){var statearr_68168 = state_68069;
(statearr_68168[(10)] = inst_67992);

(statearr_68168[(27)] = inst_67981__$1);

(statearr_68168[(12)] = inst_67994);

(statearr_68168[(28)] = inst_67984);

(statearr_68168[(19)] = inst_67993);

(statearr_68168[(20)] = inst_67991);

return statearr_68168;
})();
var statearr_68170_70756 = state_68069__$1;
(statearr_68170_70756[(2)] = null);

(statearr_68170_70756[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (28))){
var inst_67991 = (state_68069[(20)]);
var inst_68018 = (state_68069[(23)]);
var inst_68018__$1 = cljs.core.seq(inst_67991);
var state_68069__$1 = (function (){var statearr_68171 = state_68069;
(statearr_68171[(23)] = inst_68018__$1);

return statearr_68171;
})();
if(inst_68018__$1){
var statearr_68172_70757 = state_68069__$1;
(statearr_68172_70757[(1)] = (33));

} else {
var statearr_68173_70759 = state_68069__$1;
(statearr_68173_70759[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (25))){
var inst_67994 = (state_68069[(12)]);
var inst_67993 = (state_68069[(19)]);
var inst_67996 = (inst_67994 < inst_67993);
var inst_67997 = inst_67996;
var state_68069__$1 = state_68069;
if(cljs.core.truth_(inst_67997)){
var statearr_68174_70761 = state_68069__$1;
(statearr_68174_70761[(1)] = (27));

} else {
var statearr_68175_70762 = state_68069__$1;
(statearr_68175_70762[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (34))){
var state_68069__$1 = state_68069;
var statearr_68176_70763 = state_68069__$1;
(statearr_68176_70763[(2)] = null);

(statearr_68176_70763[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (17))){
var state_68069__$1 = state_68069;
var statearr_68181_70764 = state_68069__$1;
(statearr_68181_70764[(2)] = null);

(statearr_68181_70764[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (3))){
var inst_68066 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68069__$1,inst_68066);
} else {
if((state_val_68070 === (12))){
var inst_67973 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68183_70766 = state_68069__$1;
(statearr_68183_70766[(2)] = inst_67973);

(statearr_68183_70766[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (2))){
var state_68069__$1 = state_68069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68069__$1,(4),ch);
} else {
if((state_val_68070 === (23))){
var state_68069__$1 = state_68069;
var statearr_68187_70770 = state_68069__$1;
(statearr_68187_70770[(2)] = null);

(statearr_68187_70770[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (35))){
var inst_68047 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68188_70771 = state_68069__$1;
(statearr_68188_70771[(2)] = inst_68047);

(statearr_68188_70771[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (19))){
var inst_67933 = (state_68069[(7)]);
var inst_67940 = cljs.core.chunk_first(inst_67933);
var inst_67943 = cljs.core.chunk_rest(inst_67933);
var inst_67944 = cljs.core.count(inst_67940);
var inst_67908 = inst_67943;
var inst_67909 = inst_67940;
var inst_67910 = inst_67944;
var inst_67911 = (0);
var state_68069__$1 = (function (){var statearr_68190 = state_68069;
(statearr_68190[(13)] = inst_67909);

(statearr_68190[(15)] = inst_67908);

(statearr_68190[(16)] = inst_67911);

(statearr_68190[(17)] = inst_67910);

return statearr_68190;
})();
var statearr_68192_70774 = state_68069__$1;
(statearr_68192_70774[(2)] = null);

(statearr_68192_70774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (11))){
var inst_67933 = (state_68069[(7)]);
var inst_67908 = (state_68069[(15)]);
var inst_67933__$1 = cljs.core.seq(inst_67908);
var state_68069__$1 = (function (){var statearr_68193 = state_68069;
(statearr_68193[(7)] = inst_67933__$1);

return statearr_68193;
})();
if(inst_67933__$1){
var statearr_68194_70777 = state_68069__$1;
(statearr_68194_70777[(1)] = (16));

} else {
var statearr_68195_70778 = state_68069__$1;
(statearr_68195_70778[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (9))){
var inst_67976 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68196_70779 = state_68069__$1;
(statearr_68196_70779[(2)] = inst_67976);

(statearr_68196_70779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (5))){
var inst_67906 = cljs.core.deref(cs);
var inst_67907 = cljs.core.seq(inst_67906);
var inst_67908 = inst_67907;
var inst_67909 = null;
var inst_67910 = (0);
var inst_67911 = (0);
var state_68069__$1 = (function (){var statearr_68198 = state_68069;
(statearr_68198[(13)] = inst_67909);

(statearr_68198[(15)] = inst_67908);

(statearr_68198[(16)] = inst_67911);

(statearr_68198[(17)] = inst_67910);

return statearr_68198;
})();
var statearr_68199_70780 = state_68069__$1;
(statearr_68199_70780[(2)] = null);

(statearr_68199_70780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (14))){
var state_68069__$1 = state_68069;
var statearr_68200_70784 = state_68069__$1;
(statearr_68200_70784[(2)] = null);

(statearr_68200_70784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (45))){
var inst_68057 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68201_70789 = state_68069__$1;
(statearr_68201_70789[(2)] = inst_68057);

(statearr_68201_70789[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (26))){
var inst_67981 = (state_68069[(27)]);
var inst_68051 = (state_68069[(2)]);
var inst_68053 = cljs.core.seq(inst_67981);
var state_68069__$1 = (function (){var statearr_68202 = state_68069;
(statearr_68202[(29)] = inst_68051);

return statearr_68202;
})();
if(inst_68053){
var statearr_68203_70796 = state_68069__$1;
(statearr_68203_70796[(1)] = (42));

} else {
var statearr_68204_70797 = state_68069__$1;
(statearr_68204_70797[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (16))){
var inst_67933 = (state_68069[(7)]);
var inst_67936 = cljs.core.chunked_seq_QMARK_(inst_67933);
var state_68069__$1 = state_68069;
if(inst_67936){
var statearr_68205_70798 = state_68069__$1;
(statearr_68205_70798[(1)] = (19));

} else {
var statearr_68207_70799 = state_68069__$1;
(statearr_68207_70799[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (38))){
var inst_68043 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68210_70800 = state_68069__$1;
(statearr_68210_70800[(2)] = inst_68043);

(statearr_68210_70800[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (30))){
var state_68069__$1 = state_68069;
var statearr_68214_70801 = state_68069__$1;
(statearr_68214_70801[(2)] = null);

(statearr_68214_70801[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (10))){
var inst_67909 = (state_68069[(13)]);
var inst_67911 = (state_68069[(16)]);
var inst_67922 = cljs.core._nth(inst_67909,inst_67911);
var inst_67923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67922,(0),null);
var inst_67924 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67922,(1),null);
var state_68069__$1 = (function (){var statearr_68215 = state_68069;
(statearr_68215[(24)] = inst_67923);

return statearr_68215;
})();
if(cljs.core.truth_(inst_67924)){
var statearr_68216_70802 = state_68069__$1;
(statearr_68216_70802[(1)] = (13));

} else {
var statearr_68217_70803 = state_68069__$1;
(statearr_68217_70803[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (18))){
var inst_67969 = (state_68069[(2)]);
var state_68069__$1 = state_68069;
var statearr_68219_70804 = state_68069__$1;
(statearr_68219_70804[(2)] = inst_67969);

(statearr_68219_70804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (42))){
var state_68069__$1 = state_68069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68069__$1,(45),dchan);
} else {
if((state_val_68070 === (37))){
var inst_67899 = (state_68069[(11)]);
var inst_68030 = (state_68069[(22)]);
var inst_68018 = (state_68069[(23)]);
var inst_68030__$1 = cljs.core.first(inst_68018);
var inst_68031 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_68030__$1,inst_67899,done);
var state_68069__$1 = (function (){var statearr_68223 = state_68069;
(statearr_68223[(22)] = inst_68030__$1);

return statearr_68223;
})();
if(cljs.core.truth_(inst_68031)){
var statearr_68226_70809 = state_68069__$1;
(statearr_68226_70809[(1)] = (39));

} else {
var statearr_68227_70810 = state_68069__$1;
(statearr_68227_70810[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68070 === (8))){
var inst_67911 = (state_68069[(16)]);
var inst_67910 = (state_68069[(17)]);
var inst_67913 = (inst_67911 < inst_67910);
var inst_67914 = inst_67913;
var state_68069__$1 = state_68069;
if(cljs.core.truth_(inst_67914)){
var statearr_68230_70812 = state_68069__$1;
(statearr_68230_70812[(1)] = (10));

} else {
var statearr_68231_70813 = state_68069__$1;
(statearr_68231_70813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__42015__auto__ = null;
var cljs$core$async$mult_$_state_machine__42015__auto____0 = (function (){
var statearr_68232 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68232[(0)] = cljs$core$async$mult_$_state_machine__42015__auto__);

(statearr_68232[(1)] = (1));

return statearr_68232;
});
var cljs$core$async$mult_$_state_machine__42015__auto____1 = (function (state_68069){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_68069);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e68234){var ex__42018__auto__ = e68234;
var statearr_68235_70821 = state_68069;
(statearr_68235_70821[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_68069[(4)]))){
var statearr_68236_70823 = state_68069;
(statearr_68236_70823[(1)] = cljs.core.first((state_68069[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70826 = state_68069;
state_68069 = G__70826;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__42015__auto__ = function(state_68069){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__42015__auto____1.call(this,state_68069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__42015__auto____0;
cljs$core$async$mult_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__42015__auto____1;
return cljs$core$async$mult_$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_68240 = f__43279__auto__();
(statearr_68240[(6)] = c__43278__auto___70697);

return statearr_68240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__68243 = arguments.length;
switch (G__68243) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_70841 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_70841(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_70845 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_70845(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_70862 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_70862(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_70864 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_70864(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_70875 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_70875(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70885 = arguments.length;
var i__4865__auto___70886 = (0);
while(true){
if((i__4865__auto___70886 < len__4864__auto___70885)){
args__4870__auto__.push((arguments[i__4865__auto___70886]));

var G__70887 = (i__4865__auto___70886 + (1));
i__4865__auto___70886 = G__70887;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__68285){
var map__68286 = p__68285;
var map__68286__$1 = cljs.core.__destructure_map(map__68286);
var opts = map__68286__$1;
var statearr_68287_70895 = state;
(statearr_68287_70895[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_68288_70902 = state;
(statearr_68288_70902[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_68290_70903 = state;
(statearr_68290_70903[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq68275){
var G__68276 = cljs.core.first(seq68275);
var seq68275__$1 = cljs.core.next(seq68275);
var G__68277 = cljs.core.first(seq68275__$1);
var seq68275__$2 = cljs.core.next(seq68275__$1);
var G__68278 = cljs.core.first(seq68275__$2);
var seq68275__$3 = cljs.core.next(seq68275__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68276,G__68277,G__68278,seq68275__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async68305 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async68305 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta68306){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta68306 = meta68306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_68307,meta68306__$1){
var self__ = this;
var _68307__$1 = this;
return (new cljs.core.async.t_cljs$core$async68305(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta68306__$1));
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_68307){
var self__ = this;
var _68307__$1 = this;
return self__.meta68306;
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async68305.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async68305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta68306","meta68306",-1207791871,null)], null);
}));

(cljs.core.async.t_cljs$core$async68305.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async68305.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async68305");

(cljs.core.async.t_cljs$core$async68305.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async68305");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async68305.
 */
cljs.core.async.__GT_t_cljs$core$async68305 = (function cljs$core$async$mix_$___GT_t_cljs$core$async68305(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta68306){
return (new cljs.core.async.t_cljs$core$async68305(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta68306));
});

}

return (new cljs.core.async.t_cljs$core$async68305(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43278__auto___70954 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_68422){
var state_val_68424 = (state_68422[(1)]);
if((state_val_68424 === (7))){
var inst_68378 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
if(cljs.core.truth_(inst_68378)){
var statearr_68432_70961 = state_68422__$1;
(statearr_68432_70961[(1)] = (8));

} else {
var statearr_68433_70962 = state_68422__$1;
(statearr_68433_70962[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (20))){
var inst_68369 = (state_68422[(7)]);
var state_68422__$1 = state_68422;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_68422__$1,(23),out,inst_68369);
} else {
if((state_val_68424 === (1))){
var inst_68344 = calc_state();
var inst_68346 = cljs.core.__destructure_map(inst_68344);
var inst_68348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68346,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_68349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68346,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_68350 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68346,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_68352 = inst_68344;
var state_68422__$1 = (function (){var statearr_68452 = state_68422;
(statearr_68452[(8)] = inst_68352);

(statearr_68452[(9)] = inst_68348);

(statearr_68452[(10)] = inst_68349);

(statearr_68452[(11)] = inst_68350);

return statearr_68452;
})();
var statearr_68454_70973 = state_68422__$1;
(statearr_68454_70973[(2)] = null);

(statearr_68454_70973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (24))){
var inst_68357 = (state_68422[(12)]);
var inst_68352 = inst_68357;
var state_68422__$1 = (function (){var statearr_68456 = state_68422;
(statearr_68456[(8)] = inst_68352);

return statearr_68456;
})();
var statearr_68458_70977 = state_68422__$1;
(statearr_68458_70977[(2)] = null);

(statearr_68458_70977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (4))){
var inst_68369 = (state_68422[(7)]);
var inst_68373 = (state_68422[(13)]);
var inst_68368 = (state_68422[(2)]);
var inst_68369__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68368,(0),null);
var inst_68370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68368,(1),null);
var inst_68373__$1 = (inst_68369__$1 == null);
var state_68422__$1 = (function (){var statearr_68465 = state_68422;
(statearr_68465[(14)] = inst_68370);

(statearr_68465[(7)] = inst_68369__$1);

(statearr_68465[(13)] = inst_68373__$1);

return statearr_68465;
})();
if(cljs.core.truth_(inst_68373__$1)){
var statearr_68466_70982 = state_68422__$1;
(statearr_68466_70982[(1)] = (5));

} else {
var statearr_68467_70983 = state_68422__$1;
(statearr_68467_70983[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (15))){
var inst_68393 = (state_68422[(15)]);
var inst_68358 = (state_68422[(16)]);
var inst_68393__$1 = cljs.core.empty_QMARK_(inst_68358);
var state_68422__$1 = (function (){var statearr_68469 = state_68422;
(statearr_68469[(15)] = inst_68393__$1);

return statearr_68469;
})();
if(inst_68393__$1){
var statearr_68472_70989 = state_68422__$1;
(statearr_68472_70989[(1)] = (17));

} else {
var statearr_68473_70990 = state_68422__$1;
(statearr_68473_70990[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (21))){
var inst_68357 = (state_68422[(12)]);
var inst_68352 = inst_68357;
var state_68422__$1 = (function (){var statearr_68474 = state_68422;
(statearr_68474[(8)] = inst_68352);

return statearr_68474;
})();
var statearr_68476_70993 = state_68422__$1;
(statearr_68476_70993[(2)] = null);

(statearr_68476_70993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (13))){
var inst_68385 = (state_68422[(2)]);
var inst_68386 = calc_state();
var inst_68352 = inst_68386;
var state_68422__$1 = (function (){var statearr_68481 = state_68422;
(statearr_68481[(8)] = inst_68352);

(statearr_68481[(17)] = inst_68385);

return statearr_68481;
})();
var statearr_68483_70997 = state_68422__$1;
(statearr_68483_70997[(2)] = null);

(statearr_68483_70997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (22))){
var inst_68415 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
var statearr_68484_71001 = state_68422__$1;
(statearr_68484_71001[(2)] = inst_68415);

(statearr_68484_71001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (6))){
var inst_68370 = (state_68422[(14)]);
var inst_68376 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68370,change);
var state_68422__$1 = state_68422;
var statearr_68488_71002 = state_68422__$1;
(statearr_68488_71002[(2)] = inst_68376);

(statearr_68488_71002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (25))){
var state_68422__$1 = state_68422;
var statearr_68492_71005 = state_68422__$1;
(statearr_68492_71005[(2)] = null);

(statearr_68492_71005[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (17))){
var inst_68370 = (state_68422[(14)]);
var inst_68359 = (state_68422[(18)]);
var inst_68395 = (inst_68359.cljs$core$IFn$_invoke$arity$1 ? inst_68359.cljs$core$IFn$_invoke$arity$1(inst_68370) : inst_68359.call(null,inst_68370));
var inst_68396 = cljs.core.not(inst_68395);
var state_68422__$1 = state_68422;
var statearr_68495_71010 = state_68422__$1;
(statearr_68495_71010[(2)] = inst_68396);

(statearr_68495_71010[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (3))){
var inst_68419 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68422__$1,inst_68419);
} else {
if((state_val_68424 === (12))){
var state_68422__$1 = state_68422;
var statearr_68501_71017 = state_68422__$1;
(statearr_68501_71017[(2)] = null);

(statearr_68501_71017[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (2))){
var inst_68352 = (state_68422[(8)]);
var inst_68357 = (state_68422[(12)]);
var inst_68357__$1 = cljs.core.__destructure_map(inst_68352);
var inst_68358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68357__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_68359 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68357__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_68361 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68357__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_68422__$1 = (function (){var statearr_68503 = state_68422;
(statearr_68503[(18)] = inst_68359);

(statearr_68503[(16)] = inst_68358);

(statearr_68503[(12)] = inst_68357__$1);

return statearr_68503;
})();
return cljs.core.async.ioc_alts_BANG_(state_68422__$1,(4),inst_68361);
} else {
if((state_val_68424 === (23))){
var inst_68405 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
if(cljs.core.truth_(inst_68405)){
var statearr_68506_71027 = state_68422__$1;
(statearr_68506_71027[(1)] = (24));

} else {
var statearr_68507_71028 = state_68422__$1;
(statearr_68507_71028[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (19))){
var inst_68399 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
var statearr_68510_71029 = state_68422__$1;
(statearr_68510_71029[(2)] = inst_68399);

(statearr_68510_71029[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (11))){
var inst_68370 = (state_68422[(14)]);
var inst_68382 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_68370);
var state_68422__$1 = state_68422;
var statearr_68515_71032 = state_68422__$1;
(statearr_68515_71032[(2)] = inst_68382);

(statearr_68515_71032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (9))){
var inst_68370 = (state_68422[(14)]);
var inst_68390 = (state_68422[(19)]);
var inst_68358 = (state_68422[(16)]);
var inst_68390__$1 = (inst_68358.cljs$core$IFn$_invoke$arity$1 ? inst_68358.cljs$core$IFn$_invoke$arity$1(inst_68370) : inst_68358.call(null,inst_68370));
var state_68422__$1 = (function (){var statearr_68523 = state_68422;
(statearr_68523[(19)] = inst_68390__$1);

return statearr_68523;
})();
if(cljs.core.truth_(inst_68390__$1)){
var statearr_68525_71036 = state_68422__$1;
(statearr_68525_71036[(1)] = (14));

} else {
var statearr_68526_71042 = state_68422__$1;
(statearr_68526_71042[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (5))){
var inst_68373 = (state_68422[(13)]);
var state_68422__$1 = state_68422;
var statearr_68531_71045 = state_68422__$1;
(statearr_68531_71045[(2)] = inst_68373);

(statearr_68531_71045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (14))){
var inst_68390 = (state_68422[(19)]);
var state_68422__$1 = state_68422;
var statearr_68537_71048 = state_68422__$1;
(statearr_68537_71048[(2)] = inst_68390);

(statearr_68537_71048[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (26))){
var inst_68411 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
var statearr_68538_71050 = state_68422__$1;
(statearr_68538_71050[(2)] = inst_68411);

(statearr_68538_71050[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (16))){
var inst_68401 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
if(cljs.core.truth_(inst_68401)){
var statearr_68543_71051 = state_68422__$1;
(statearr_68543_71051[(1)] = (20));

} else {
var statearr_68544_71052 = state_68422__$1;
(statearr_68544_71052[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (10))){
var inst_68417 = (state_68422[(2)]);
var state_68422__$1 = state_68422;
var statearr_68545_71054 = state_68422__$1;
(statearr_68545_71054[(2)] = inst_68417);

(statearr_68545_71054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (18))){
var inst_68393 = (state_68422[(15)]);
var state_68422__$1 = state_68422;
var statearr_68546_71058 = state_68422__$1;
(statearr_68546_71058[(2)] = inst_68393);

(statearr_68546_71058[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68424 === (8))){
var inst_68369 = (state_68422[(7)]);
var inst_68380 = (inst_68369 == null);
var state_68422__$1 = state_68422;
if(cljs.core.truth_(inst_68380)){
var statearr_68547_71061 = state_68422__$1;
(statearr_68547_71061[(1)] = (11));

} else {
var statearr_68548_71062 = state_68422__$1;
(statearr_68548_71062[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__42015__auto__ = null;
var cljs$core$async$mix_$_state_machine__42015__auto____0 = (function (){
var statearr_68549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68549[(0)] = cljs$core$async$mix_$_state_machine__42015__auto__);

(statearr_68549[(1)] = (1));

return statearr_68549;
});
var cljs$core$async$mix_$_state_machine__42015__auto____1 = (function (state_68422){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_68422);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e68554){var ex__42018__auto__ = e68554;
var statearr_68555_71067 = state_68422;
(statearr_68555_71067[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_68422[(4)]))){
var statearr_68560_71071 = state_68422;
(statearr_68560_71071[(1)] = cljs.core.first((state_68422[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71075 = state_68422;
state_68422 = G__71075;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__42015__auto__ = function(state_68422){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__42015__auto____1.call(this,state_68422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__42015__auto____0;
cljs$core$async$mix_$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__42015__auto____1;
return cljs$core$async$mix_$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_68565 = f__43279__auto__();
(statearr_68565[(6)] = c__43278__auto___70954);

return statearr_68565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_71086 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_71086(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_71092 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_71092(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_71094 = (function() {
var G__71095 = null;
var G__71095__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__71095__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__71095 = function(p,v){
switch(arguments.length){
case 1:
return G__71095__1.call(this,p);
case 2:
return G__71095__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71095.cljs$core$IFn$_invoke$arity$1 = G__71095__1;
G__71095.cljs$core$IFn$_invoke$arity$2 = G__71095__2;
return G__71095;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__68614 = arguments.length;
switch (G__68614) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_71094(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_71094(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__68635 = arguments.length;
switch (G__68635) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__68627_SHARP_){
if(cljs.core.truth_((p1__68627_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__68627_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__68627_SHARP_.call(null,topic)))){
return p1__68627_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__68627_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async68650 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async68650 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta68651){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta68651 = meta68651;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_68652,meta68651__$1){
var self__ = this;
var _68652__$1 = this;
return (new cljs.core.async.t_cljs$core$async68650(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta68651__$1));
}));

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_68652){
var self__ = this;
var _68652__$1 = this;
return self__.meta68651;
}));

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async68650.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async68650.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta68651","meta68651",-554936313,null)], null);
}));

(cljs.core.async.t_cljs$core$async68650.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async68650.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async68650");

(cljs.core.async.t_cljs$core$async68650.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async68650");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async68650.
 */
cljs.core.async.__GT_t_cljs$core$async68650 = (function cljs$core$async$__GT_t_cljs$core$async68650(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta68651){
return (new cljs.core.async.t_cljs$core$async68650(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta68651));
});

}

return (new cljs.core.async.t_cljs$core$async68650(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__43278__auto___71144 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_68791){
var state_val_68792 = (state_68791[(1)]);
if((state_val_68792 === (7))){
var inst_68787 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
var statearr_68804_71145 = state_68791__$1;
(statearr_68804_71145[(2)] = inst_68787);

(statearr_68804_71145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (20))){
var state_68791__$1 = state_68791;
var statearr_68805_71146 = state_68791__$1;
(statearr_68805_71146[(2)] = null);

(statearr_68805_71146[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (1))){
var state_68791__$1 = state_68791;
var statearr_68809_71148 = state_68791__$1;
(statearr_68809_71148[(2)] = null);

(statearr_68809_71148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (24))){
var inst_68765 = (state_68791[(7)]);
var inst_68777 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_68765);
var state_68791__$1 = state_68791;
var statearr_68811_71153 = state_68791__$1;
(statearr_68811_71153[(2)] = inst_68777);

(statearr_68811_71153[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (4))){
var inst_68698 = (state_68791[(8)]);
var inst_68698__$1 = (state_68791[(2)]);
var inst_68699 = (inst_68698__$1 == null);
var state_68791__$1 = (function (){var statearr_68815 = state_68791;
(statearr_68815[(8)] = inst_68698__$1);

return statearr_68815;
})();
if(cljs.core.truth_(inst_68699)){
var statearr_68818_71154 = state_68791__$1;
(statearr_68818_71154[(1)] = (5));

} else {
var statearr_68819_71159 = state_68791__$1;
(statearr_68819_71159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (15))){
var inst_68757 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
var statearr_68823_71160 = state_68791__$1;
(statearr_68823_71160[(2)] = inst_68757);

(statearr_68823_71160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (21))){
var inst_68782 = (state_68791[(2)]);
var state_68791__$1 = (function (){var statearr_68825 = state_68791;
(statearr_68825[(9)] = inst_68782);

return statearr_68825;
})();
var statearr_68826_71165 = state_68791__$1;
(statearr_68826_71165[(2)] = null);

(statearr_68826_71165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (13))){
var inst_68734 = (state_68791[(10)]);
var inst_68738 = cljs.core.chunked_seq_QMARK_(inst_68734);
var state_68791__$1 = state_68791;
if(inst_68738){
var statearr_68828_71170 = state_68791__$1;
(statearr_68828_71170[(1)] = (16));

} else {
var statearr_68829_71172 = state_68791__$1;
(statearr_68829_71172[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (22))){
var inst_68773 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
if(cljs.core.truth_(inst_68773)){
var statearr_68833_71174 = state_68791__$1;
(statearr_68833_71174[(1)] = (23));

} else {
var statearr_68834_71182 = state_68791__$1;
(statearr_68834_71182[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (6))){
var inst_68768 = (state_68791[(11)]);
var inst_68765 = (state_68791[(7)]);
var inst_68698 = (state_68791[(8)]);
var inst_68765__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_68698) : topic_fn.call(null,inst_68698));
var inst_68766 = cljs.core.deref(mults);
var inst_68768__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68766,inst_68765__$1);
var state_68791__$1 = (function (){var statearr_68842 = state_68791;
(statearr_68842[(11)] = inst_68768__$1);

(statearr_68842[(7)] = inst_68765__$1);

return statearr_68842;
})();
if(cljs.core.truth_(inst_68768__$1)){
var statearr_68848_71184 = state_68791__$1;
(statearr_68848_71184[(1)] = (19));

} else {
var statearr_68849_71185 = state_68791__$1;
(statearr_68849_71185[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (25))){
var inst_68779 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
var statearr_68853_71186 = state_68791__$1;
(statearr_68853_71186[(2)] = inst_68779);

(statearr_68853_71186[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (17))){
var inst_68734 = (state_68791[(10)]);
var inst_68746 = cljs.core.first(inst_68734);
var inst_68747 = cljs.core.async.muxch_STAR_(inst_68746);
var inst_68748 = cljs.core.async.close_BANG_(inst_68747);
var inst_68749 = cljs.core.next(inst_68734);
var inst_68713 = inst_68749;
var inst_68714 = null;
var inst_68715 = (0);
var inst_68716 = (0);
var state_68791__$1 = (function (){var statearr_68865 = state_68791;
(statearr_68865[(12)] = inst_68713);

(statearr_68865[(13)] = inst_68748);

(statearr_68865[(14)] = inst_68716);

(statearr_68865[(15)] = inst_68714);

(statearr_68865[(16)] = inst_68715);

return statearr_68865;
})();
var statearr_68868_71195 = state_68791__$1;
(statearr_68868_71195[(2)] = null);

(statearr_68868_71195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (3))){
var inst_68789 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68791__$1,inst_68789);
} else {
if((state_val_68792 === (12))){
var inst_68760 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
var statearr_68880_71201 = state_68791__$1;
(statearr_68880_71201[(2)] = inst_68760);

(statearr_68880_71201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (2))){
var state_68791__$1 = state_68791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68791__$1,(4),ch);
} else {
if((state_val_68792 === (23))){
var state_68791__$1 = state_68791;
var statearr_68890_71202 = state_68791__$1;
(statearr_68890_71202[(2)] = null);

(statearr_68890_71202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (19))){
var inst_68768 = (state_68791[(11)]);
var inst_68698 = (state_68791[(8)]);
var inst_68771 = cljs.core.async.muxch_STAR_(inst_68768);
var state_68791__$1 = state_68791;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_68791__$1,(22),inst_68771,inst_68698);
} else {
if((state_val_68792 === (11))){
var inst_68713 = (state_68791[(12)]);
var inst_68734 = (state_68791[(10)]);
var inst_68734__$1 = cljs.core.seq(inst_68713);
var state_68791__$1 = (function (){var statearr_68897 = state_68791;
(statearr_68897[(10)] = inst_68734__$1);

return statearr_68897;
})();
if(inst_68734__$1){
var statearr_68899_71206 = state_68791__$1;
(statearr_68899_71206[(1)] = (13));

} else {
var statearr_68905_71207 = state_68791__$1;
(statearr_68905_71207[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (9))){
var inst_68762 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
var statearr_68908_71211 = state_68791__$1;
(statearr_68908_71211[(2)] = inst_68762);

(statearr_68908_71211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (5))){
var inst_68709 = cljs.core.deref(mults);
var inst_68710 = cljs.core.vals(inst_68709);
var inst_68711 = cljs.core.seq(inst_68710);
var inst_68713 = inst_68711;
var inst_68714 = null;
var inst_68715 = (0);
var inst_68716 = (0);
var state_68791__$1 = (function (){var statearr_68915 = state_68791;
(statearr_68915[(12)] = inst_68713);

(statearr_68915[(14)] = inst_68716);

(statearr_68915[(15)] = inst_68714);

(statearr_68915[(16)] = inst_68715);

return statearr_68915;
})();
var statearr_68918_71213 = state_68791__$1;
(statearr_68918_71213[(2)] = null);

(statearr_68918_71213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (14))){
var state_68791__$1 = state_68791;
var statearr_68926_71218 = state_68791__$1;
(statearr_68926_71218[(2)] = null);

(statearr_68926_71218[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (16))){
var inst_68734 = (state_68791[(10)]);
var inst_68740 = cljs.core.chunk_first(inst_68734);
var inst_68741 = cljs.core.chunk_rest(inst_68734);
var inst_68742 = cljs.core.count(inst_68740);
var inst_68713 = inst_68741;
var inst_68714 = inst_68740;
var inst_68715 = inst_68742;
var inst_68716 = (0);
var state_68791__$1 = (function (){var statearr_68934 = state_68791;
(statearr_68934[(12)] = inst_68713);

(statearr_68934[(14)] = inst_68716);

(statearr_68934[(15)] = inst_68714);

(statearr_68934[(16)] = inst_68715);

return statearr_68934;
})();
var statearr_68935_71236 = state_68791__$1;
(statearr_68935_71236[(2)] = null);

(statearr_68935_71236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (10))){
var inst_68713 = (state_68791[(12)]);
var inst_68716 = (state_68791[(14)]);
var inst_68714 = (state_68791[(15)]);
var inst_68715 = (state_68791[(16)]);
var inst_68723 = cljs.core._nth(inst_68714,inst_68716);
var inst_68724 = cljs.core.async.muxch_STAR_(inst_68723);
var inst_68725 = cljs.core.async.close_BANG_(inst_68724);
var inst_68726 = (inst_68716 + (1));
var tmp68921 = inst_68713;
var tmp68922 = inst_68714;
var tmp68923 = inst_68715;
var inst_68713__$1 = tmp68921;
var inst_68714__$1 = tmp68922;
var inst_68715__$1 = tmp68923;
var inst_68716__$1 = inst_68726;
var state_68791__$1 = (function (){var statearr_68944 = state_68791;
(statearr_68944[(17)] = inst_68725);

(statearr_68944[(12)] = inst_68713__$1);

(statearr_68944[(14)] = inst_68716__$1);

(statearr_68944[(15)] = inst_68714__$1);

(statearr_68944[(16)] = inst_68715__$1);

return statearr_68944;
})();
var statearr_68948_71247 = state_68791__$1;
(statearr_68948_71247[(2)] = null);

(statearr_68948_71247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (18))){
var inst_68752 = (state_68791[(2)]);
var state_68791__$1 = state_68791;
var statearr_68949_71248 = state_68791__$1;
(statearr_68949_71248[(2)] = inst_68752);

(statearr_68949_71248[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68792 === (8))){
var inst_68716 = (state_68791[(14)]);
var inst_68715 = (state_68791[(16)]);
var inst_68718 = (inst_68716 < inst_68715);
var inst_68719 = inst_68718;
var state_68791__$1 = state_68791;
if(cljs.core.truth_(inst_68719)){
var statearr_68958_71253 = state_68791__$1;
(statearr_68958_71253[(1)] = (10));

} else {
var statearr_68959_71254 = state_68791__$1;
(statearr_68959_71254[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_68969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68969[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_68969[(1)] = (1));

return statearr_68969;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_68791){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_68791);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e68972){var ex__42018__auto__ = e68972;
var statearr_68974_71260 = state_68791;
(statearr_68974_71260[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_68791[(4)]))){
var statearr_68978_71261 = state_68791;
(statearr_68978_71261[(1)] = cljs.core.first((state_68791[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71270 = state_68791;
state_68791 = G__71270;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_68791){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_68791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_68985 = f__43279__auto__();
(statearr_68985[(6)] = c__43278__auto___71144);

return statearr_68985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__68991 = arguments.length;
switch (G__68991) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__69010 = arguments.length;
switch (G__69010) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__69017 = arguments.length;
switch (G__69017) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__43278__auto___71310 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69084){
var state_val_69085 = (state_69084[(1)]);
if((state_val_69085 === (7))){
var state_69084__$1 = state_69084;
var statearr_69133_71315 = state_69084__$1;
(statearr_69133_71315[(2)] = null);

(statearr_69133_71315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (1))){
var state_69084__$1 = state_69084;
var statearr_69139_71316 = state_69084__$1;
(statearr_69139_71316[(2)] = null);

(statearr_69139_71316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (4))){
var inst_69038 = (state_69084[(7)]);
var inst_69040 = (state_69084[(8)]);
var inst_69042 = (inst_69040 < inst_69038);
var state_69084__$1 = state_69084;
if(cljs.core.truth_(inst_69042)){
var statearr_69158_71320 = state_69084__$1;
(statearr_69158_71320[(1)] = (6));

} else {
var statearr_69159_71321 = state_69084__$1;
(statearr_69159_71321[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (15))){
var inst_69066 = (state_69084[(9)]);
var inst_69074 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_69066);
var state_69084__$1 = state_69084;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69084__$1,(17),out,inst_69074);
} else {
if((state_val_69085 === (13))){
var inst_69066 = (state_69084[(9)]);
var inst_69066__$1 = (state_69084[(2)]);
var inst_69068 = cljs.core.some(cljs.core.nil_QMARK_,inst_69066__$1);
var state_69084__$1 = (function (){var statearr_69162 = state_69084;
(statearr_69162[(9)] = inst_69066__$1);

return statearr_69162;
})();
if(cljs.core.truth_(inst_69068)){
var statearr_69164_71331 = state_69084__$1;
(statearr_69164_71331[(1)] = (14));

} else {
var statearr_69165_71332 = state_69084__$1;
(statearr_69165_71332[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (6))){
var state_69084__$1 = state_69084;
var statearr_69172_71333 = state_69084__$1;
(statearr_69172_71333[(2)] = null);

(statearr_69172_71333[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (17))){
var inst_69076 = (state_69084[(2)]);
var state_69084__$1 = (function (){var statearr_69175 = state_69084;
(statearr_69175[(10)] = inst_69076);

return statearr_69175;
})();
var statearr_69176_71335 = state_69084__$1;
(statearr_69176_71335[(2)] = null);

(statearr_69176_71335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (3))){
var inst_69082 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69084__$1,inst_69082);
} else {
if((state_val_69085 === (12))){
var _ = (function (){var statearr_69187 = state_69084;
(statearr_69187[(4)] = cljs.core.rest((state_69084[(4)])));

return statearr_69187;
})();
var state_69084__$1 = state_69084;
var ex69174 = (state_69084__$1[(2)]);
var statearr_69188_71341 = state_69084__$1;
(statearr_69188_71341[(5)] = ex69174);


if((ex69174 instanceof Object)){
var statearr_69189_71342 = state_69084__$1;
(statearr_69189_71342[(1)] = (11));

(statearr_69189_71342[(5)] = null);

} else {
throw ex69174;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (2))){
var inst_69036 = cljs.core.reset_BANG_(dctr,cnt);
var inst_69038 = cnt;
var inst_69040 = (0);
var state_69084__$1 = (function (){var statearr_69195 = state_69084;
(statearr_69195[(11)] = inst_69036);

(statearr_69195[(7)] = inst_69038);

(statearr_69195[(8)] = inst_69040);

return statearr_69195;
})();
var statearr_69197_71343 = state_69084__$1;
(statearr_69197_71343[(2)] = null);

(statearr_69197_71343[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (11))){
var inst_69044 = (state_69084[(2)]);
var inst_69045 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_69084__$1 = (function (){var statearr_69199 = state_69084;
(statearr_69199[(12)] = inst_69044);

return statearr_69199;
})();
var statearr_69201_71344 = state_69084__$1;
(statearr_69201_71344[(2)] = inst_69045);

(statearr_69201_71344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (9))){
var inst_69040 = (state_69084[(8)]);
var _ = (function (){var statearr_69205 = state_69084;
(statearr_69205[(4)] = cljs.core.cons((12),(state_69084[(4)])));

return statearr_69205;
})();
var inst_69052 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_69040) : chs__$1.call(null,inst_69040));
var inst_69053 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_69040) : done.call(null,inst_69040));
var inst_69054 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69052,inst_69053);
var ___$1 = (function (){var statearr_69207 = state_69084;
(statearr_69207[(4)] = cljs.core.rest((state_69084[(4)])));

return statearr_69207;
})();
var state_69084__$1 = state_69084;
var statearr_69208_71347 = state_69084__$1;
(statearr_69208_71347[(2)] = inst_69054);

(statearr_69208_71347[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (5))){
var inst_69064 = (state_69084[(2)]);
var state_69084__$1 = (function (){var statearr_69210 = state_69084;
(statearr_69210[(13)] = inst_69064);

return statearr_69210;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69084__$1,(13),dchan);
} else {
if((state_val_69085 === (14))){
var inst_69071 = cljs.core.async.close_BANG_(out);
var state_69084__$1 = state_69084;
var statearr_69215_71361 = state_69084__$1;
(statearr_69215_71361[(2)] = inst_69071);

(statearr_69215_71361[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (16))){
var inst_69079 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69234_71367 = state_69084__$1;
(statearr_69234_71367[(2)] = inst_69079);

(statearr_69234_71367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (10))){
var inst_69040 = (state_69084[(8)]);
var inst_69057 = (state_69084[(2)]);
var inst_69058 = (inst_69040 + (1));
var inst_69040__$1 = inst_69058;
var state_69084__$1 = (function (){var statearr_69236 = state_69084;
(statearr_69236[(14)] = inst_69057);

(statearr_69236[(8)] = inst_69040__$1);

return statearr_69236;
})();
var statearr_69237_71381 = state_69084__$1;
(statearr_69237_71381[(2)] = null);

(statearr_69237_71381[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69085 === (8))){
var inst_69062 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69239_71386 = state_69084__$1;
(statearr_69239_71386[(2)] = inst_69062);

(statearr_69239_71386[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_69244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69244[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_69244[(1)] = (1));

return statearr_69244;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_69084){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69084);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e69245){var ex__42018__auto__ = e69245;
var statearr_69246_71387 = state_69084;
(statearr_69246_71387[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69084[(4)]))){
var statearr_69247_71390 = state_69084;
(statearr_69247_71390[(1)] = cljs.core.first((state_69084[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71392 = state_69084;
state_69084 = G__71392;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_69084){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_69084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_69253 = f__43279__auto__();
(statearr_69253[(6)] = c__43278__auto___71310);

return statearr_69253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__69263 = arguments.length;
switch (G__69263) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43278__auto___71400 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69306){
var state_val_69307 = (state_69306[(1)]);
if((state_val_69307 === (7))){
var inst_69282 = (state_69306[(7)]);
var inst_69283 = (state_69306[(8)]);
var inst_69282__$1 = (state_69306[(2)]);
var inst_69283__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69282__$1,(0),null);
var inst_69284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69282__$1,(1),null);
var inst_69285 = (inst_69283__$1 == null);
var state_69306__$1 = (function (){var statearr_69316 = state_69306;
(statearr_69316[(7)] = inst_69282__$1);

(statearr_69316[(8)] = inst_69283__$1);

(statearr_69316[(9)] = inst_69284);

return statearr_69316;
})();
if(cljs.core.truth_(inst_69285)){
var statearr_69317_71404 = state_69306__$1;
(statearr_69317_71404[(1)] = (8));

} else {
var statearr_69318_71408 = state_69306__$1;
(statearr_69318_71408[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (1))){
var inst_69272 = cljs.core.vec(chs);
var inst_69273 = inst_69272;
var state_69306__$1 = (function (){var statearr_69319 = state_69306;
(statearr_69319[(10)] = inst_69273);

return statearr_69319;
})();
var statearr_69320_71410 = state_69306__$1;
(statearr_69320_71410[(2)] = null);

(statearr_69320_71410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (4))){
var inst_69273 = (state_69306[(10)]);
var state_69306__$1 = state_69306;
return cljs.core.async.ioc_alts_BANG_(state_69306__$1,(7),inst_69273);
} else {
if((state_val_69307 === (6))){
var inst_69302 = (state_69306[(2)]);
var state_69306__$1 = state_69306;
var statearr_69325_71412 = state_69306__$1;
(statearr_69325_71412[(2)] = inst_69302);

(statearr_69325_71412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (3))){
var inst_69304 = (state_69306[(2)]);
var state_69306__$1 = state_69306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69306__$1,inst_69304);
} else {
if((state_val_69307 === (2))){
var inst_69273 = (state_69306[(10)]);
var inst_69275 = cljs.core.count(inst_69273);
var inst_69276 = (inst_69275 > (0));
var state_69306__$1 = state_69306;
if(cljs.core.truth_(inst_69276)){
var statearr_69335_71413 = state_69306__$1;
(statearr_69335_71413[(1)] = (4));

} else {
var statearr_69336_71414 = state_69306__$1;
(statearr_69336_71414[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (11))){
var inst_69273 = (state_69306[(10)]);
var inst_69294 = (state_69306[(2)]);
var tmp69327 = inst_69273;
var inst_69273__$1 = tmp69327;
var state_69306__$1 = (function (){var statearr_69337 = state_69306;
(statearr_69337[(10)] = inst_69273__$1);

(statearr_69337[(11)] = inst_69294);

return statearr_69337;
})();
var statearr_69338_71415 = state_69306__$1;
(statearr_69338_71415[(2)] = null);

(statearr_69338_71415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (9))){
var inst_69283 = (state_69306[(8)]);
var state_69306__$1 = state_69306;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69306__$1,(11),out,inst_69283);
} else {
if((state_val_69307 === (5))){
var inst_69300 = cljs.core.async.close_BANG_(out);
var state_69306__$1 = state_69306;
var statearr_69345_71419 = state_69306__$1;
(statearr_69345_71419[(2)] = inst_69300);

(statearr_69345_71419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (10))){
var inst_69298 = (state_69306[(2)]);
var state_69306__$1 = state_69306;
var statearr_69346_71422 = state_69306__$1;
(statearr_69346_71422[(2)] = inst_69298);

(statearr_69346_71422[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69307 === (8))){
var inst_69282 = (state_69306[(7)]);
var inst_69283 = (state_69306[(8)]);
var inst_69273 = (state_69306[(10)]);
var inst_69284 = (state_69306[(9)]);
var inst_69287 = (function (){var cs = inst_69273;
var vec__69278 = inst_69282;
var v = inst_69283;
var c = inst_69284;
return (function (p1__69254_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__69254_SHARP_);
});
})();
var inst_69288 = cljs.core.filterv(inst_69287,inst_69273);
var inst_69273__$1 = inst_69288;
var state_69306__$1 = (function (){var statearr_69347 = state_69306;
(statearr_69347[(10)] = inst_69273__$1);

return statearr_69347;
})();
var statearr_69349_71433 = state_69306__$1;
(statearr_69349_71433[(2)] = null);

(statearr_69349_71433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_69350 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69350[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_69350[(1)] = (1));

return statearr_69350;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_69306){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69306);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e69351){var ex__42018__auto__ = e69351;
var statearr_69356_71437 = state_69306;
(statearr_69356_71437[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69306[(4)]))){
var statearr_69357_71439 = state_69306;
(statearr_69357_71439[(1)] = cljs.core.first((state_69306[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71440 = state_69306;
state_69306 = G__71440;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_69306){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_69306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_69360 = f__43279__auto__();
(statearr_69360[(6)] = c__43278__auto___71400);

return statearr_69360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__69367 = arguments.length;
switch (G__69367) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43278__auto___71448 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69396){
var state_val_69397 = (state_69396[(1)]);
if((state_val_69397 === (7))){
var inst_69375 = (state_69396[(7)]);
var inst_69375__$1 = (state_69396[(2)]);
var inst_69379 = (inst_69375__$1 == null);
var inst_69380 = cljs.core.not(inst_69379);
var state_69396__$1 = (function (){var statearr_69403 = state_69396;
(statearr_69403[(7)] = inst_69375__$1);

return statearr_69403;
})();
if(inst_69380){
var statearr_69404_71456 = state_69396__$1;
(statearr_69404_71456[(1)] = (8));

} else {
var statearr_69408_71457 = state_69396__$1;
(statearr_69408_71457[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (1))){
var inst_69369 = (0);
var state_69396__$1 = (function (){var statearr_69409 = state_69396;
(statearr_69409[(8)] = inst_69369);

return statearr_69409;
})();
var statearr_69410_71458 = state_69396__$1;
(statearr_69410_71458[(2)] = null);

(statearr_69410_71458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (4))){
var state_69396__$1 = state_69396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69396__$1,(7),ch);
} else {
if((state_val_69397 === (6))){
var inst_69391 = (state_69396[(2)]);
var state_69396__$1 = state_69396;
var statearr_69412_71459 = state_69396__$1;
(statearr_69412_71459[(2)] = inst_69391);

(statearr_69412_71459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (3))){
var inst_69393 = (state_69396[(2)]);
var inst_69394 = cljs.core.async.close_BANG_(out);
var state_69396__$1 = (function (){var statearr_69414 = state_69396;
(statearr_69414[(9)] = inst_69393);

return statearr_69414;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69396__$1,inst_69394);
} else {
if((state_val_69397 === (2))){
var inst_69369 = (state_69396[(8)]);
var inst_69371 = (inst_69369 < n);
var state_69396__$1 = state_69396;
if(cljs.core.truth_(inst_69371)){
var statearr_69425_71461 = state_69396__$1;
(statearr_69425_71461[(1)] = (4));

} else {
var statearr_69431_71462 = state_69396__$1;
(statearr_69431_71462[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (11))){
var inst_69369 = (state_69396[(8)]);
var inst_69383 = (state_69396[(2)]);
var inst_69384 = (inst_69369 + (1));
var inst_69369__$1 = inst_69384;
var state_69396__$1 = (function (){var statearr_69454 = state_69396;
(statearr_69454[(8)] = inst_69369__$1);

(statearr_69454[(10)] = inst_69383);

return statearr_69454;
})();
var statearr_69455_71463 = state_69396__$1;
(statearr_69455_71463[(2)] = null);

(statearr_69455_71463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (9))){
var state_69396__$1 = state_69396;
var statearr_69456_71464 = state_69396__$1;
(statearr_69456_71464[(2)] = null);

(statearr_69456_71464[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (5))){
var state_69396__$1 = state_69396;
var statearr_69457_71465 = state_69396__$1;
(statearr_69457_71465[(2)] = null);

(statearr_69457_71465[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (10))){
var inst_69388 = (state_69396[(2)]);
var state_69396__$1 = state_69396;
var statearr_69464_71471 = state_69396__$1;
(statearr_69464_71471[(2)] = inst_69388);

(statearr_69464_71471[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69397 === (8))){
var inst_69375 = (state_69396[(7)]);
var state_69396__$1 = state_69396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69396__$1,(11),out,inst_69375);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_69468 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69468[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_69468[(1)] = (1));

return statearr_69468;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_69396){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69396);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e69469){var ex__42018__auto__ = e69469;
var statearr_69470_71473 = state_69396;
(statearr_69470_71473[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69396[(4)]))){
var statearr_69471_71475 = state_69396;
(statearr_69471_71475[(1)] = cljs.core.first((state_69396[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71477 = state_69396;
state_69396 = G__71477;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_69396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_69396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_69472 = f__43279__auto__();
(statearr_69472[(6)] = c__43278__auto___71448);

return statearr_69472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async69474 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async69474 = (function (f,ch,meta69475){
this.f = f;
this.ch = ch;
this.meta69475 = meta69475;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_69476,meta69475__$1){
var self__ = this;
var _69476__$1 = this;
return (new cljs.core.async.t_cljs$core$async69474(self__.f,self__.ch,meta69475__$1));
}));

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_69476){
var self__ = this;
var _69476__$1 = this;
return self__.meta69475;
}));

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async69486 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async69486 = (function (f,ch,meta69475,_,fn1,meta69487){
this.f = f;
this.ch = ch;
this.meta69475 = meta69475;
this._ = _;
this.fn1 = fn1;
this.meta69487 = meta69487;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async69486.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_69488,meta69487__$1){
var self__ = this;
var _69488__$1 = this;
return (new cljs.core.async.t_cljs$core$async69486(self__.f,self__.ch,self__.meta69475,self__._,self__.fn1,meta69487__$1));
}));

(cljs.core.async.t_cljs$core$async69486.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_69488){
var self__ = this;
var _69488__$1 = this;
return self__.meta69487;
}));

(cljs.core.async.t_cljs$core$async69486.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69486.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async69486.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async69486.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__69473_SHARP_){
var G__69495 = (((p1__69473_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__69473_SHARP_) : self__.f.call(null,p1__69473_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__69495) : f1.call(null,G__69495));
});
}));

(cljs.core.async.t_cljs$core$async69486.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta69475","meta69475",345815165,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async69474","cljs.core.async/t_cljs$core$async69474",1400589126,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta69487","meta69487",1056376261,null)], null);
}));

(cljs.core.async.t_cljs$core$async69486.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async69486.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async69486");

(cljs.core.async.t_cljs$core$async69486.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async69486");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async69486.
 */
cljs.core.async.__GT_t_cljs$core$async69486 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async69486(f__$1,ch__$1,meta69475__$1,___$2,fn1__$1,meta69487){
return (new cljs.core.async.t_cljs$core$async69486(f__$1,ch__$1,meta69475__$1,___$2,fn1__$1,meta69487));
});

}

return (new cljs.core.async.t_cljs$core$async69486(self__.f,self__.ch,self__.meta69475,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__69501 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__69501) : self__.f.call(null,G__69501));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69474.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async69474.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta69475","meta69475",345815165,null)], null);
}));

(cljs.core.async.t_cljs$core$async69474.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async69474.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async69474");

(cljs.core.async.t_cljs$core$async69474.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async69474");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async69474.
 */
cljs.core.async.__GT_t_cljs$core$async69474 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async69474(f__$1,ch__$1,meta69475){
return (new cljs.core.async.t_cljs$core$async69474(f__$1,ch__$1,meta69475));
});

}

return (new cljs.core.async.t_cljs$core$async69474(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async69506 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async69506 = (function (f,ch,meta69507){
this.f = f;
this.ch = ch;
this.meta69507 = meta69507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_69508,meta69507__$1){
var self__ = this;
var _69508__$1 = this;
return (new cljs.core.async.t_cljs$core$async69506(self__.f,self__.ch,meta69507__$1));
}));

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_69508){
var self__ = this;
var _69508__$1 = this;
return self__.meta69507;
}));

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69506.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async69506.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta69507","meta69507",-737621554,null)], null);
}));

(cljs.core.async.t_cljs$core$async69506.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async69506.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async69506");

(cljs.core.async.t_cljs$core$async69506.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async69506");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async69506.
 */
cljs.core.async.__GT_t_cljs$core$async69506 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async69506(f__$1,ch__$1,meta69507){
return (new cljs.core.async.t_cljs$core$async69506(f__$1,ch__$1,meta69507));
});

}

return (new cljs.core.async.t_cljs$core$async69506(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async69515 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async69515 = (function (p,ch,meta69516){
this.p = p;
this.ch = ch;
this.meta69516 = meta69516;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_69517,meta69516__$1){
var self__ = this;
var _69517__$1 = this;
return (new cljs.core.async.t_cljs$core$async69515(self__.p,self__.ch,meta69516__$1));
}));

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_69517){
var self__ = this;
var _69517__$1 = this;
return self__.meta69516;
}));

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async69515.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async69515.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta69516","meta69516",1178415131,null)], null);
}));

(cljs.core.async.t_cljs$core$async69515.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async69515.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async69515");

(cljs.core.async.t_cljs$core$async69515.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async69515");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async69515.
 */
cljs.core.async.__GT_t_cljs$core$async69515 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async69515(p__$1,ch__$1,meta69516){
return (new cljs.core.async.t_cljs$core$async69515(p__$1,ch__$1,meta69516));
});

}

return (new cljs.core.async.t_cljs$core$async69515(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__69539 = arguments.length;
switch (G__69539) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43278__auto___71515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69563){
var state_val_69564 = (state_69563[(1)]);
if((state_val_69564 === (7))){
var inst_69556 = (state_69563[(2)]);
var state_69563__$1 = state_69563;
var statearr_69571_71517 = state_69563__$1;
(statearr_69571_71517[(2)] = inst_69556);

(statearr_69571_71517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (1))){
var state_69563__$1 = state_69563;
var statearr_69572_71518 = state_69563__$1;
(statearr_69572_71518[(2)] = null);

(statearr_69572_71518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (4))){
var inst_69542 = (state_69563[(7)]);
var inst_69542__$1 = (state_69563[(2)]);
var inst_69543 = (inst_69542__$1 == null);
var state_69563__$1 = (function (){var statearr_69574 = state_69563;
(statearr_69574[(7)] = inst_69542__$1);

return statearr_69574;
})();
if(cljs.core.truth_(inst_69543)){
var statearr_69575_71519 = state_69563__$1;
(statearr_69575_71519[(1)] = (5));

} else {
var statearr_69576_71520 = state_69563__$1;
(statearr_69576_71520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (6))){
var inst_69542 = (state_69563[(7)]);
var inst_69547 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_69542) : p.call(null,inst_69542));
var state_69563__$1 = state_69563;
if(cljs.core.truth_(inst_69547)){
var statearr_69584_71522 = state_69563__$1;
(statearr_69584_71522[(1)] = (8));

} else {
var statearr_69591_71523 = state_69563__$1;
(statearr_69591_71523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (3))){
var inst_69558 = (state_69563[(2)]);
var state_69563__$1 = state_69563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69563__$1,inst_69558);
} else {
if((state_val_69564 === (2))){
var state_69563__$1 = state_69563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69563__$1,(4),ch);
} else {
if((state_val_69564 === (11))){
var inst_69550 = (state_69563[(2)]);
var state_69563__$1 = state_69563;
var statearr_69604_71524 = state_69563__$1;
(statearr_69604_71524[(2)] = inst_69550);

(statearr_69604_71524[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (9))){
var state_69563__$1 = state_69563;
var statearr_69608_71526 = state_69563__$1;
(statearr_69608_71526[(2)] = null);

(statearr_69608_71526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (5))){
var inst_69545 = cljs.core.async.close_BANG_(out);
var state_69563__$1 = state_69563;
var statearr_69610_71527 = state_69563__$1;
(statearr_69610_71527[(2)] = inst_69545);

(statearr_69610_71527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (10))){
var inst_69553 = (state_69563[(2)]);
var state_69563__$1 = (function (){var statearr_69611 = state_69563;
(statearr_69611[(8)] = inst_69553);

return statearr_69611;
})();
var statearr_69612_71528 = state_69563__$1;
(statearr_69612_71528[(2)] = null);

(statearr_69612_71528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69564 === (8))){
var inst_69542 = (state_69563[(7)]);
var state_69563__$1 = state_69563;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69563__$1,(11),out,inst_69542);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_69620 = [null,null,null,null,null,null,null,null,null];
(statearr_69620[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_69620[(1)] = (1));

return statearr_69620;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_69563){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69563);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e69624){var ex__42018__auto__ = e69624;
var statearr_69625_71529 = state_69563;
(statearr_69625_71529[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69563[(4)]))){
var statearr_69626_71530 = state_69563;
(statearr_69626_71530[(1)] = cljs.core.first((state_69563[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71535 = state_69563;
state_69563 = G__71535;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_69563){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_69563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_69634 = f__43279__auto__();
(statearr_69634[(6)] = c__43278__auto___71515);

return statearr_69634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__69638 = arguments.length;
switch (G__69638) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__43278__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69708){
var state_val_69709 = (state_69708[(1)]);
if((state_val_69709 === (7))){
var inst_69704 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
var statearr_69711_71541 = state_69708__$1;
(statearr_69711_71541[(2)] = inst_69704);

(statearr_69711_71541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (20))){
var inst_69674 = (state_69708[(7)]);
var inst_69685 = (state_69708[(2)]);
var inst_69686 = cljs.core.next(inst_69674);
var inst_69660 = inst_69686;
var inst_69661 = null;
var inst_69662 = (0);
var inst_69663 = (0);
var state_69708__$1 = (function (){var statearr_69713 = state_69708;
(statearr_69713[(8)] = inst_69663);

(statearr_69713[(9)] = inst_69662);

(statearr_69713[(10)] = inst_69661);

(statearr_69713[(11)] = inst_69685);

(statearr_69713[(12)] = inst_69660);

return statearr_69713;
})();
var statearr_69717_71542 = state_69708__$1;
(statearr_69717_71542[(2)] = null);

(statearr_69717_71542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (1))){
var state_69708__$1 = state_69708;
var statearr_69718_71544 = state_69708__$1;
(statearr_69718_71544[(2)] = null);

(statearr_69718_71544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (4))){
var inst_69649 = (state_69708[(13)]);
var inst_69649__$1 = (state_69708[(2)]);
var inst_69650 = (inst_69649__$1 == null);
var state_69708__$1 = (function (){var statearr_69719 = state_69708;
(statearr_69719[(13)] = inst_69649__$1);

return statearr_69719;
})();
if(cljs.core.truth_(inst_69650)){
var statearr_69720_71545 = state_69708__$1;
(statearr_69720_71545[(1)] = (5));

} else {
var statearr_69723_71546 = state_69708__$1;
(statearr_69723_71546[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (15))){
var state_69708__$1 = state_69708;
var statearr_69733_71547 = state_69708__$1;
(statearr_69733_71547[(2)] = null);

(statearr_69733_71547[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (21))){
var state_69708__$1 = state_69708;
var statearr_69735_71553 = state_69708__$1;
(statearr_69735_71553[(2)] = null);

(statearr_69735_71553[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (13))){
var inst_69663 = (state_69708[(8)]);
var inst_69662 = (state_69708[(9)]);
var inst_69661 = (state_69708[(10)]);
var inst_69660 = (state_69708[(12)]);
var inst_69670 = (state_69708[(2)]);
var inst_69671 = (inst_69663 + (1));
var tmp69728 = inst_69662;
var tmp69729 = inst_69661;
var tmp69730 = inst_69660;
var inst_69660__$1 = tmp69730;
var inst_69661__$1 = tmp69729;
var inst_69662__$1 = tmp69728;
var inst_69663__$1 = inst_69671;
var state_69708__$1 = (function (){var statearr_69738 = state_69708;
(statearr_69738[(8)] = inst_69663__$1);

(statearr_69738[(9)] = inst_69662__$1);

(statearr_69738[(14)] = inst_69670);

(statearr_69738[(10)] = inst_69661__$1);

(statearr_69738[(12)] = inst_69660__$1);

return statearr_69738;
})();
var statearr_69739_71564 = state_69708__$1;
(statearr_69739_71564[(2)] = null);

(statearr_69739_71564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (22))){
var state_69708__$1 = state_69708;
var statearr_69740_71565 = state_69708__$1;
(statearr_69740_71565[(2)] = null);

(statearr_69740_71565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (6))){
var inst_69649 = (state_69708[(13)]);
var inst_69658 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_69649) : f.call(null,inst_69649));
var inst_69659 = cljs.core.seq(inst_69658);
var inst_69660 = inst_69659;
var inst_69661 = null;
var inst_69662 = (0);
var inst_69663 = (0);
var state_69708__$1 = (function (){var statearr_69746 = state_69708;
(statearr_69746[(8)] = inst_69663);

(statearr_69746[(9)] = inst_69662);

(statearr_69746[(10)] = inst_69661);

(statearr_69746[(12)] = inst_69660);

return statearr_69746;
})();
var statearr_69748_71568 = state_69708__$1;
(statearr_69748_71568[(2)] = null);

(statearr_69748_71568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (17))){
var inst_69674 = (state_69708[(7)]);
var inst_69678 = cljs.core.chunk_first(inst_69674);
var inst_69679 = cljs.core.chunk_rest(inst_69674);
var inst_69680 = cljs.core.count(inst_69678);
var inst_69660 = inst_69679;
var inst_69661 = inst_69678;
var inst_69662 = inst_69680;
var inst_69663 = (0);
var state_69708__$1 = (function (){var statearr_69755 = state_69708;
(statearr_69755[(8)] = inst_69663);

(statearr_69755[(9)] = inst_69662);

(statearr_69755[(10)] = inst_69661);

(statearr_69755[(12)] = inst_69660);

return statearr_69755;
})();
var statearr_69756_71569 = state_69708__$1;
(statearr_69756_71569[(2)] = null);

(statearr_69756_71569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (3))){
var inst_69706 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69708__$1,inst_69706);
} else {
if((state_val_69709 === (12))){
var inst_69694 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
var statearr_69763_71570 = state_69708__$1;
(statearr_69763_71570[(2)] = inst_69694);

(statearr_69763_71570[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (2))){
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69708__$1,(4),in$);
} else {
if((state_val_69709 === (23))){
var inst_69702 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
var statearr_69765_71571 = state_69708__$1;
(statearr_69765_71571[(2)] = inst_69702);

(statearr_69765_71571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (19))){
var inst_69689 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
var statearr_69767_71572 = state_69708__$1;
(statearr_69767_71572[(2)] = inst_69689);

(statearr_69767_71572[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (11))){
var inst_69674 = (state_69708[(7)]);
var inst_69660 = (state_69708[(12)]);
var inst_69674__$1 = cljs.core.seq(inst_69660);
var state_69708__$1 = (function (){var statearr_69780 = state_69708;
(statearr_69780[(7)] = inst_69674__$1);

return statearr_69780;
})();
if(inst_69674__$1){
var statearr_69781_71575 = state_69708__$1;
(statearr_69781_71575[(1)] = (14));

} else {
var statearr_69782_71576 = state_69708__$1;
(statearr_69782_71576[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (9))){
var inst_69696 = (state_69708[(2)]);
var inst_69697 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_69708__$1 = (function (){var statearr_69786 = state_69708;
(statearr_69786[(15)] = inst_69696);

return statearr_69786;
})();
if(cljs.core.truth_(inst_69697)){
var statearr_69787_71577 = state_69708__$1;
(statearr_69787_71577[(1)] = (21));

} else {
var statearr_69792_71578 = state_69708__$1;
(statearr_69792_71578[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (5))){
var inst_69652 = cljs.core.async.close_BANG_(out);
var state_69708__$1 = state_69708;
var statearr_69793_71579 = state_69708__$1;
(statearr_69793_71579[(2)] = inst_69652);

(statearr_69793_71579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (14))){
var inst_69674 = (state_69708[(7)]);
var inst_69676 = cljs.core.chunked_seq_QMARK_(inst_69674);
var state_69708__$1 = state_69708;
if(inst_69676){
var statearr_69794_71580 = state_69708__$1;
(statearr_69794_71580[(1)] = (17));

} else {
var statearr_69797_71581 = state_69708__$1;
(statearr_69797_71581[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (16))){
var inst_69692 = (state_69708[(2)]);
var state_69708__$1 = state_69708;
var statearr_69798_71582 = state_69708__$1;
(statearr_69798_71582[(2)] = inst_69692);

(statearr_69798_71582[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69709 === (10))){
var inst_69663 = (state_69708[(8)]);
var inst_69661 = (state_69708[(10)]);
var inst_69668 = cljs.core._nth(inst_69661,inst_69663);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69708__$1,(13),out,inst_69668);
} else {
if((state_val_69709 === (18))){
var inst_69674 = (state_69708[(7)]);
var inst_69683 = cljs.core.first(inst_69674);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69708__$1,(20),out,inst_69683);
} else {
if((state_val_69709 === (8))){
var inst_69663 = (state_69708[(8)]);
var inst_69662 = (state_69708[(9)]);
var inst_69665 = (inst_69663 < inst_69662);
var inst_69666 = inst_69665;
var state_69708__$1 = state_69708;
if(cljs.core.truth_(inst_69666)){
var statearr_69802_71585 = state_69708__$1;
(statearr_69802_71585[(1)] = (10));

} else {
var statearr_69803_71586 = state_69708__$1;
(statearr_69803_71586[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__42015__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__42015__auto____0 = (function (){
var statearr_69804 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69804[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__42015__auto__);

(statearr_69804[(1)] = (1));

return statearr_69804;
});
var cljs$core$async$mapcat_STAR__$_state_machine__42015__auto____1 = (function (state_69708){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69708);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e69805){var ex__42018__auto__ = e69805;
var statearr_69806_71591 = state_69708;
(statearr_69806_71591[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69708[(4)]))){
var statearr_69807_71593 = state_69708;
(statearr_69807_71593[(1)] = cljs.core.first((state_69708[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71594 = state_69708;
state_69708 = G__71594;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__42015__auto__ = function(state_69708){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__42015__auto____1.call(this,state_69708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__42015__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__42015__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_69810 = f__43279__auto__();
(statearr_69810[(6)] = c__43278__auto__);

return statearr_69810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));

return c__43278__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__69812 = arguments.length;
switch (G__69812) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__69824 = arguments.length;
switch (G__69824) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__69829 = arguments.length;
switch (G__69829) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43278__auto___71604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69866){
var state_val_69867 = (state_69866[(1)]);
if((state_val_69867 === (7))){
var inst_69861 = (state_69866[(2)]);
var state_69866__$1 = state_69866;
var statearr_69868_71608 = state_69866__$1;
(statearr_69868_71608[(2)] = inst_69861);

(statearr_69868_71608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (1))){
var inst_69837 = null;
var state_69866__$1 = (function (){var statearr_69869 = state_69866;
(statearr_69869[(7)] = inst_69837);

return statearr_69869;
})();
var statearr_69871_71612 = state_69866__$1;
(statearr_69871_71612[(2)] = null);

(statearr_69871_71612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (4))){
var inst_69840 = (state_69866[(8)]);
var inst_69840__$1 = (state_69866[(2)]);
var inst_69841 = (inst_69840__$1 == null);
var inst_69842 = cljs.core.not(inst_69841);
var state_69866__$1 = (function (){var statearr_69873 = state_69866;
(statearr_69873[(8)] = inst_69840__$1);

return statearr_69873;
})();
if(inst_69842){
var statearr_69875_71614 = state_69866__$1;
(statearr_69875_71614[(1)] = (5));

} else {
var statearr_69876_71615 = state_69866__$1;
(statearr_69876_71615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (6))){
var state_69866__$1 = state_69866;
var statearr_69878_71616 = state_69866__$1;
(statearr_69878_71616[(2)] = null);

(statearr_69878_71616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (3))){
var inst_69863 = (state_69866[(2)]);
var inst_69864 = cljs.core.async.close_BANG_(out);
var state_69866__$1 = (function (){var statearr_69880 = state_69866;
(statearr_69880[(9)] = inst_69863);

return statearr_69880;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69866__$1,inst_69864);
} else {
if((state_val_69867 === (2))){
var state_69866__$1 = state_69866;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69866__$1,(4),ch);
} else {
if((state_val_69867 === (11))){
var inst_69840 = (state_69866[(8)]);
var inst_69855 = (state_69866[(2)]);
var inst_69837 = inst_69840;
var state_69866__$1 = (function (){var statearr_69883 = state_69866;
(statearr_69883[(7)] = inst_69837);

(statearr_69883[(10)] = inst_69855);

return statearr_69883;
})();
var statearr_69888_71625 = state_69866__$1;
(statearr_69888_71625[(2)] = null);

(statearr_69888_71625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (9))){
var inst_69840 = (state_69866[(8)]);
var state_69866__$1 = state_69866;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69866__$1,(11),out,inst_69840);
} else {
if((state_val_69867 === (5))){
var inst_69837 = (state_69866[(7)]);
var inst_69840 = (state_69866[(8)]);
var inst_69850 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69840,inst_69837);
var state_69866__$1 = state_69866;
if(inst_69850){
var statearr_69893_71628 = state_69866__$1;
(statearr_69893_71628[(1)] = (8));

} else {
var statearr_69894_71630 = state_69866__$1;
(statearr_69894_71630[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (10))){
var inst_69858 = (state_69866[(2)]);
var state_69866__$1 = state_69866;
var statearr_69895_71631 = state_69866__$1;
(statearr_69895_71631[(2)] = inst_69858);

(statearr_69895_71631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69867 === (8))){
var inst_69837 = (state_69866[(7)]);
var tmp69891 = inst_69837;
var inst_69837__$1 = tmp69891;
var state_69866__$1 = (function (){var statearr_69897 = state_69866;
(statearr_69897[(7)] = inst_69837__$1);

return statearr_69897;
})();
var statearr_69901_71637 = state_69866__$1;
(statearr_69901_71637[(2)] = null);

(statearr_69901_71637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_69903 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69903[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_69903[(1)] = (1));

return statearr_69903;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_69866){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69866);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e69905){var ex__42018__auto__ = e69905;
var statearr_69906_71639 = state_69866;
(statearr_69906_71639[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69866[(4)]))){
var statearr_69908_71640 = state_69866;
(statearr_69908_71640[(1)] = cljs.core.first((state_69866[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71641 = state_69866;
state_69866 = G__71641;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_69866){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_69866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_69912 = f__43279__auto__();
(statearr_69912[(6)] = c__43278__auto___71604);

return statearr_69912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__69915 = arguments.length;
switch (G__69915) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43278__auto___71643 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_69959){
var state_val_69960 = (state_69959[(1)]);
if((state_val_69960 === (7))){
var inst_69955 = (state_69959[(2)]);
var state_69959__$1 = state_69959;
var statearr_69964_71644 = state_69959__$1;
(statearr_69964_71644[(2)] = inst_69955);

(statearr_69964_71644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (1))){
var inst_69919 = (new Array(n));
var inst_69920 = inst_69919;
var inst_69921 = (0);
var state_69959__$1 = (function (){var statearr_69965 = state_69959;
(statearr_69965[(7)] = inst_69920);

(statearr_69965[(8)] = inst_69921);

return statearr_69965;
})();
var statearr_69966_71646 = state_69959__$1;
(statearr_69966_71646[(2)] = null);

(statearr_69966_71646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (4))){
var inst_69925 = (state_69959[(9)]);
var inst_69925__$1 = (state_69959[(2)]);
var inst_69926 = (inst_69925__$1 == null);
var inst_69927 = cljs.core.not(inst_69926);
var state_69959__$1 = (function (){var statearr_69969 = state_69959;
(statearr_69969[(9)] = inst_69925__$1);

return statearr_69969;
})();
if(inst_69927){
var statearr_69970_71648 = state_69959__$1;
(statearr_69970_71648[(1)] = (5));

} else {
var statearr_69971_71649 = state_69959__$1;
(statearr_69971_71649[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (15))){
var inst_69949 = (state_69959[(2)]);
var state_69959__$1 = state_69959;
var statearr_69972_71650 = state_69959__$1;
(statearr_69972_71650[(2)] = inst_69949);

(statearr_69972_71650[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (13))){
var state_69959__$1 = state_69959;
var statearr_69973_71651 = state_69959__$1;
(statearr_69973_71651[(2)] = null);

(statearr_69973_71651[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (6))){
var inst_69921 = (state_69959[(8)]);
var inst_69945 = (inst_69921 > (0));
var state_69959__$1 = state_69959;
if(cljs.core.truth_(inst_69945)){
var statearr_69974_71652 = state_69959__$1;
(statearr_69974_71652[(1)] = (12));

} else {
var statearr_69975_71653 = state_69959__$1;
(statearr_69975_71653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (3))){
var inst_69957 = (state_69959[(2)]);
var state_69959__$1 = state_69959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69959__$1,inst_69957);
} else {
if((state_val_69960 === (12))){
var inst_69920 = (state_69959[(7)]);
var inst_69947 = cljs.core.vec(inst_69920);
var state_69959__$1 = state_69959;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69959__$1,(15),out,inst_69947);
} else {
if((state_val_69960 === (2))){
var state_69959__$1 = state_69959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69959__$1,(4),ch);
} else {
if((state_val_69960 === (11))){
var inst_69938 = (state_69959[(2)]);
var inst_69939 = (new Array(n));
var inst_69920 = inst_69939;
var inst_69921 = (0);
var state_69959__$1 = (function (){var statearr_69982 = state_69959;
(statearr_69982[(7)] = inst_69920);

(statearr_69982[(8)] = inst_69921);

(statearr_69982[(10)] = inst_69938);

return statearr_69982;
})();
var statearr_69983_71657 = state_69959__$1;
(statearr_69983_71657[(2)] = null);

(statearr_69983_71657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (9))){
var inst_69920 = (state_69959[(7)]);
var inst_69936 = cljs.core.vec(inst_69920);
var state_69959__$1 = state_69959;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_69959__$1,(11),out,inst_69936);
} else {
if((state_val_69960 === (5))){
var inst_69925 = (state_69959[(9)]);
var inst_69930 = (state_69959[(11)]);
var inst_69920 = (state_69959[(7)]);
var inst_69921 = (state_69959[(8)]);
var inst_69929 = (inst_69920[inst_69921] = inst_69925);
var inst_69930__$1 = (inst_69921 + (1));
var inst_69931 = (inst_69930__$1 < n);
var state_69959__$1 = (function (){var statearr_69992 = state_69959;
(statearr_69992[(11)] = inst_69930__$1);

(statearr_69992[(12)] = inst_69929);

return statearr_69992;
})();
if(cljs.core.truth_(inst_69931)){
var statearr_69993_71662 = state_69959__$1;
(statearr_69993_71662[(1)] = (8));

} else {
var statearr_69998_71663 = state_69959__$1;
(statearr_69998_71663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (14))){
var inst_69952 = (state_69959[(2)]);
var inst_69953 = cljs.core.async.close_BANG_(out);
var state_69959__$1 = (function (){var statearr_70000 = state_69959;
(statearr_70000[(13)] = inst_69952);

return statearr_70000;
})();
var statearr_70001_71664 = state_69959__$1;
(statearr_70001_71664[(2)] = inst_69953);

(statearr_70001_71664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (10))){
var inst_69942 = (state_69959[(2)]);
var state_69959__$1 = state_69959;
var statearr_70002_71666 = state_69959__$1;
(statearr_70002_71666[(2)] = inst_69942);

(statearr_70002_71666[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69960 === (8))){
var inst_69930 = (state_69959[(11)]);
var inst_69920 = (state_69959[(7)]);
var tmp69999 = inst_69920;
var inst_69920__$1 = tmp69999;
var inst_69921 = inst_69930;
var state_69959__$1 = (function (){var statearr_70003 = state_69959;
(statearr_70003[(7)] = inst_69920__$1);

(statearr_70003[(8)] = inst_69921);

return statearr_70003;
})();
var statearr_70006_71669 = state_69959__$1;
(statearr_70006_71669[(2)] = null);

(statearr_70006_71669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_70008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70008[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_70008[(1)] = (1));

return statearr_70008;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_69959){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_69959);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e70009){var ex__42018__auto__ = e70009;
var statearr_70010_71674 = state_69959;
(statearr_70010_71674[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_69959[(4)]))){
var statearr_70011_71675 = state_69959;
(statearr_70011_71675[(1)] = cljs.core.first((state_69959[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71676 = state_69959;
state_69959 = G__71676;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_69959){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_69959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_70017 = f__43279__auto__();
(statearr_70017[(6)] = c__43278__auto___71643);

return statearr_70017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__70024 = arguments.length;
switch (G__70024) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__43278__auto___71687 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_70077){
var state_val_70078 = (state_70077[(1)]);
if((state_val_70078 === (7))){
var inst_70073 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70089_71694 = state_70077__$1;
(statearr_70089_71694[(2)] = inst_70073);

(statearr_70089_71694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (1))){
var inst_70025 = [];
var inst_70028 = inst_70025;
var inst_70029 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_70077__$1 = (function (){var statearr_70092 = state_70077;
(statearr_70092[(7)] = inst_70029);

(statearr_70092[(8)] = inst_70028);

return statearr_70092;
})();
var statearr_70097_71703 = state_70077__$1;
(statearr_70097_71703[(2)] = null);

(statearr_70097_71703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (4))){
var inst_70032 = (state_70077[(9)]);
var inst_70032__$1 = (state_70077[(2)]);
var inst_70037 = (inst_70032__$1 == null);
var inst_70038 = cljs.core.not(inst_70037);
var state_70077__$1 = (function (){var statearr_70103 = state_70077;
(statearr_70103[(9)] = inst_70032__$1);

return statearr_70103;
})();
if(inst_70038){
var statearr_70104_71710 = state_70077__$1;
(statearr_70104_71710[(1)] = (5));

} else {
var statearr_70105_71715 = state_70077__$1;
(statearr_70105_71715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (15))){
var inst_70028 = (state_70077[(8)]);
var inst_70065 = cljs.core.vec(inst_70028);
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70077__$1,(18),out,inst_70065);
} else {
if((state_val_70078 === (13))){
var inst_70060 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70110_71723 = state_70077__$1;
(statearr_70110_71723[(2)] = inst_70060);

(statearr_70110_71723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (6))){
var inst_70028 = (state_70077[(8)]);
var inst_70062 = inst_70028.length;
var inst_70063 = (inst_70062 > (0));
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_70063)){
var statearr_70117_71728 = state_70077__$1;
(statearr_70117_71728[(1)] = (15));

} else {
var statearr_70118_71730 = state_70077__$1;
(statearr_70118_71730[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (17))){
var inst_70070 = (state_70077[(2)]);
var inst_70071 = cljs.core.async.close_BANG_(out);
var state_70077__$1 = (function (){var statearr_70120 = state_70077;
(statearr_70120[(10)] = inst_70070);

return statearr_70120;
})();
var statearr_70121_71732 = state_70077__$1;
(statearr_70121_71732[(2)] = inst_70071);

(statearr_70121_71732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (3))){
var inst_70075 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70077__$1,inst_70075);
} else {
if((state_val_70078 === (12))){
var inst_70028 = (state_70077[(8)]);
var inst_70053 = cljs.core.vec(inst_70028);
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_70077__$1,(14),out,inst_70053);
} else {
if((state_val_70078 === (2))){
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70077__$1,(4),ch);
} else {
if((state_val_70078 === (11))){
var inst_70028 = (state_70077[(8)]);
var inst_70041 = (state_70077[(11)]);
var inst_70032 = (state_70077[(9)]);
var inst_70050 = inst_70028.push(inst_70032);
var tmp70122 = inst_70028;
var inst_70028__$1 = tmp70122;
var inst_70029 = inst_70041;
var state_70077__$1 = (function (){var statearr_70129 = state_70077;
(statearr_70129[(7)] = inst_70029);

(statearr_70129[(12)] = inst_70050);

(statearr_70129[(8)] = inst_70028__$1);

return statearr_70129;
})();
var statearr_70131_71739 = state_70077__$1;
(statearr_70131_71739[(2)] = null);

(statearr_70131_71739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (9))){
var inst_70029 = (state_70077[(7)]);
var inst_70045 = cljs.core.keyword_identical_QMARK_(inst_70029,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_70077__$1 = state_70077;
var statearr_70135_71740 = state_70077__$1;
(statearr_70135_71740[(2)] = inst_70045);

(statearr_70135_71740[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (5))){
var inst_70029 = (state_70077[(7)]);
var inst_70041 = (state_70077[(11)]);
var inst_70042 = (state_70077[(13)]);
var inst_70032 = (state_70077[(9)]);
var inst_70041__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_70032) : f.call(null,inst_70032));
var inst_70042__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70041__$1,inst_70029);
var state_70077__$1 = (function (){var statearr_70138 = state_70077;
(statearr_70138[(11)] = inst_70041__$1);

(statearr_70138[(13)] = inst_70042__$1);

return statearr_70138;
})();
if(inst_70042__$1){
var statearr_70139_71745 = state_70077__$1;
(statearr_70139_71745[(1)] = (8));

} else {
var statearr_70140_71747 = state_70077__$1;
(statearr_70140_71747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (14))){
var inst_70041 = (state_70077[(11)]);
var inst_70032 = (state_70077[(9)]);
var inst_70055 = (state_70077[(2)]);
var inst_70056 = [];
var inst_70057 = inst_70056.push(inst_70032);
var inst_70028 = inst_70056;
var inst_70029 = inst_70041;
var state_70077__$1 = (function (){var statearr_70142 = state_70077;
(statearr_70142[(7)] = inst_70029);

(statearr_70142[(14)] = inst_70057);

(statearr_70142[(15)] = inst_70055);

(statearr_70142[(8)] = inst_70028);

return statearr_70142;
})();
var statearr_70143_71749 = state_70077__$1;
(statearr_70143_71749[(2)] = null);

(statearr_70143_71749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (16))){
var state_70077__$1 = state_70077;
var statearr_70144_71752 = state_70077__$1;
(statearr_70144_71752[(2)] = null);

(statearr_70144_71752[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (10))){
var inst_70047 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_70047)){
var statearr_70145_71755 = state_70077__$1;
(statearr_70145_71755[(1)] = (11));

} else {
var statearr_70147_71757 = state_70077__$1;
(statearr_70147_71757[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (18))){
var inst_70067 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70148_71758 = state_70077__$1;
(statearr_70148_71758[(2)] = inst_70067);

(statearr_70148_71758[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (8))){
var inst_70042 = (state_70077[(13)]);
var state_70077__$1 = state_70077;
var statearr_70149_71759 = state_70077__$1;
(statearr_70149_71759[(2)] = inst_70042);

(statearr_70149_71759[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__42015__auto__ = null;
var cljs$core$async$state_machine__42015__auto____0 = (function (){
var statearr_70150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70150[(0)] = cljs$core$async$state_machine__42015__auto__);

(statearr_70150[(1)] = (1));

return statearr_70150;
});
var cljs$core$async$state_machine__42015__auto____1 = (function (state_70077){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_70077);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e70153){var ex__42018__auto__ = e70153;
var statearr_70154_71760 = state_70077;
(statearr_70154_71760[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_70077[(4)]))){
var statearr_70155_71761 = state_70077;
(statearr_70155_71761[(1)] = cljs.core.first((state_70077[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71762 = state_70077;
state_70077 = G__71762;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
cljs$core$async$state_machine__42015__auto__ = function(state_70077){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__42015__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__42015__auto____1.call(this,state_70077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__42015__auto____0;
cljs$core$async$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__42015__auto____1;
return cljs$core$async$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_70160 = f__43279__auto__();
(statearr_70160[(6)] = c__43278__auto___71687);

return statearr_70160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
