goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__45361__45362__auto__){
if((!((p1__45361__45362__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__45361__45362__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__45361__45362__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__45361__45362__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__45361__45362__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___78944 = schema.utils.use_fn_validation;
var output_schema78108_78945 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78109_78946 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker78110_78947 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78109_78946);
}),null));
var output_checker78111_78948 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78108_78945);
}),null));
var ret__47899__auto___78949 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__78112){
var validate__42950__auto__ = cljs.core.deref(ufv___78944);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___78954 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78112], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78114_78955 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78115_78956 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__78116_78957 = input_schema78109_78946;
var G__78117_78958 = cljs.core.deref(input_checker78110_78947);
var G__78118_78959 = args__42951__auto___78954;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78114_78955,G__78115_78956,G__78116_78957,G__78117_78958,G__78118_78959) : schema.core.fn_validator.call(null,G__78114_78955,G__78115_78956,G__78116_78957,G__78117_78958,G__78118_78959));
} else {
var temp__5753__auto___78960 = (function (){var fexpr__78119 = cljs.core.deref(input_checker78110_78947);
return (fexpr__78119.cljs$core$IFn$_invoke$arity$1 ? fexpr__78119.cljs$core$IFn$_invoke$arity$1(args__42951__auto___78954) : fexpr__78119.call(null,args__42951__auto___78954));
})();
if(cljs.core.truth_(temp__5753__auto___78960)){
var error__42952__auto___78961 = temp__5753__auto___78960;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___78961], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78109_78946,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___78954,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___78961], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var json = G__78112;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78123_78968 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78124_78969 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__78125_78970 = output_schema78108_78945;
var G__78126_78971 = cljs.core.deref(output_checker78111_78948);
var G__78127_78972 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78123_78968,G__78124_78969,G__78125_78970,G__78126_78971,G__78127_78972) : schema.core.fn_validator.call(null,G__78123_78968,G__78124_78969,G__78125_78970,G__78126_78971,G__78127_78972));
} else {
var temp__5753__auto___78973 = (function (){var fexpr__78129 = cljs.core.deref(output_checker78111_78948);
return (fexpr__78129.cljs$core$IFn$_invoke$arity$1 ? fexpr__78129.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78129.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___78973)){
var error__42952__auto___78974 = temp__5753__auto___78973;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___78974], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78108_78945,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___78974], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema78108_78945,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78109_78946], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___78975 = schema.utils.use_fn_validation;
var output_schema78142_78976 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78143_78977 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema78148_78978 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker78144_78979 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78143_78977);
}),null));
var output_checker78145_78980 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78142_78976);
}),null));
var input_checker78149_78981 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78148_78978);
}),null));
var output_checker78150_78982 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78142_78976);
}),null));
var ret__47899__auto___78983 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__78183 = arguments.length;
switch (G__78183) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__78146,G__78147){
var validate__42950__auto__ = cljs.core.deref(ufv___78975);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___78985 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78146,G__78147], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78200_78986 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78201_78987 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__78202_78988 = input_schema78143_78977;
var G__78203_78989 = cljs.core.deref(input_checker78144_78979);
var G__78204_78990 = args__42951__auto___78985;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78200_78986,G__78201_78987,G__78202_78988,G__78203_78989,G__78204_78990) : schema.core.fn_validator.call(null,G__78200_78986,G__78201_78987,G__78202_78988,G__78203_78989,G__78204_78990));
} else {
var temp__5753__auto___78992 = (function (){var fexpr__78205 = cljs.core.deref(input_checker78144_78979);
return (fexpr__78205.cljs$core$IFn$_invoke$arity$1 ? fexpr__78205.cljs$core$IFn$_invoke$arity$1(args__42951__auto___78985) : fexpr__78205.call(null,args__42951__auto___78985));
})();
if(cljs.core.truth_(temp__5753__auto___78992)){
var error__42952__auto___78993 = temp__5753__auto___78992;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___78993], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78143_78977,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___78985,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___78993], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var name_kw = G__78146;
var fields = G__78147;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78206_78995 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78207_78996 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__78208_78997 = output_schema78142_78976;
var G__78209_78998 = cljs.core.deref(output_checker78145_78980);
var G__78210_78999 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78206_78995,G__78207_78996,G__78208_78997,G__78209_78998,G__78210_78999) : schema.core.fn_validator.call(null,G__78206_78995,G__78207_78996,G__78208_78997,G__78209_78998,G__78210_78999));
} else {
var temp__5753__auto___79000 = (function (){var fexpr__78211 = cljs.core.deref(output_checker78145_78980);
return (fexpr__78211.cljs$core$IFn$_invoke$arity$1 ? fexpr__78211.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78211.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79000)){
var error__42952__auto___79001 = temp__5753__auto___79000;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79001], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78142_78976,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79001], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__78151,G__78152,G__78153){
var validate__42950__auto__ = cljs.core.deref(ufv___78975);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79002 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78151,G__78152,G__78153], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78212_79003 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78213_79004 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__78214_79005 = input_schema78148_78978;
var G__78215_79006 = cljs.core.deref(input_checker78149_78981);
var G__78216_79007 = args__42951__auto___79002;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78212_79003,G__78213_79004,G__78214_79005,G__78215_79006,G__78216_79007) : schema.core.fn_validator.call(null,G__78212_79003,G__78213_79004,G__78214_79005,G__78215_79006,G__78216_79007));
} else {
var temp__5753__auto___79008 = (function (){var fexpr__78217 = cljs.core.deref(input_checker78149_78981);
return (fexpr__78217.cljs$core$IFn$_invoke$arity$1 ? fexpr__78217.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79002) : fexpr__78217.call(null,args__42951__auto___79002));
})();
if(cljs.core.truth_(temp__5753__auto___79008)){
var error__42952__auto___79009 = temp__5753__auto___79008;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79009], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78148_78978,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79002,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79009], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var name_kw = G__78151;
var docstring = G__78152;
var fields = G__78153;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78221_79010 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78222_79011 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__78223_79012 = output_schema78142_78976;
var G__78224_79013 = cljs.core.deref(output_checker78150_78982);
var G__78225_79014 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78221_79010,G__78222_79011,G__78223_79012,G__78224_79013,G__78225_79014) : schema.core.fn_validator.call(null,G__78221_79010,G__78222_79011,G__78223_79012,G__78224_79013,G__78225_79014));
} else {
var temp__5753__auto___79015 = (function (){var fexpr__78226 = cljs.core.deref(output_checker78150_78982);
return (fexpr__78226.cljs$core$IFn$_invoke$arity$1 ? fexpr__78226.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78226.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79015)){
var error__42952__auto___79016 = temp__5753__auto___79015;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79016], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78142_78976,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79016], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema78142_78976,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78143_78977,input_schema78148_78978], null)));

var ufv___79017 = schema.utils.use_fn_validation;
var output_schema78233_79018 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78234_79019 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema78239_79020 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker78235_79021 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78234_79019);
}),null));
var output_checker78236_79022 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78233_79018);
}),null));
var input_checker78240_79023 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78239_79020);
}),null));
var output_checker78241_79024 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78233_79018);
}),null));
var ret__47899__auto___79025 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__78248 = arguments.length;
switch (G__78248) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__78237,G__78238){
var validate__42950__auto__ = cljs.core.deref(ufv___79017);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79027 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78237,G__78238], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78249_79028 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78250_79029 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__78251_79030 = input_schema78234_79019;
var G__78252_79031 = cljs.core.deref(input_checker78235_79021);
var G__78253_79032 = args__42951__auto___79027;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78249_79028,G__78250_79029,G__78251_79030,G__78252_79031,G__78253_79032) : schema.core.fn_validator.call(null,G__78249_79028,G__78250_79029,G__78251_79030,G__78252_79031,G__78253_79032));
} else {
var temp__5753__auto___79033 = (function (){var fexpr__78258 = cljs.core.deref(input_checker78235_79021);
return (fexpr__78258.cljs$core$IFn$_invoke$arity$1 ? fexpr__78258.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79027) : fexpr__78258.call(null,args__42951__auto___79027));
})();
if(cljs.core.truth_(temp__5753__auto___79033)){
var error__42952__auto___79034 = temp__5753__auto___79033;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79034], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78234_79019,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79027,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79034], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var name_kw = G__78237;
var symbol_keywords = G__78238;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78260_79035 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78261_79036 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__78262_79037 = output_schema78233_79018;
var G__78263_79038 = cljs.core.deref(output_checker78236_79022);
var G__78264_79039 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78260_79035,G__78261_79036,G__78262_79037,G__78263_79038,G__78264_79039) : schema.core.fn_validator.call(null,G__78260_79035,G__78261_79036,G__78262_79037,G__78263_79038,G__78264_79039));
} else {
var temp__5753__auto___79040 = (function (){var fexpr__78265 = cljs.core.deref(output_checker78236_79022);
return (fexpr__78265.cljs$core$IFn$_invoke$arity$1 ? fexpr__78265.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78265.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79040)){
var error__42952__auto___79041 = temp__5753__auto___79040;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79041], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78233_79018,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79041], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__78242,G__78243,G__78244){
var validate__42950__auto__ = cljs.core.deref(ufv___79017);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79042 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78242,G__78243,G__78244], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78266_79043 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78267_79044 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__78268_79045 = input_schema78239_79020;
var G__78269_79046 = cljs.core.deref(input_checker78240_79023);
var G__78270_79047 = args__42951__auto___79042;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78266_79043,G__78267_79044,G__78268_79045,G__78269_79046,G__78270_79047) : schema.core.fn_validator.call(null,G__78266_79043,G__78267_79044,G__78268_79045,G__78269_79046,G__78270_79047));
} else {
var temp__5753__auto___79052 = (function (){var fexpr__78271 = cljs.core.deref(input_checker78240_79023);
return (fexpr__78271.cljs$core$IFn$_invoke$arity$1 ? fexpr__78271.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79042) : fexpr__78271.call(null,args__42951__auto___79042));
})();
if(cljs.core.truth_(temp__5753__auto___79052)){
var error__42952__auto___79053 = temp__5753__auto___79052;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79053], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78239_79020,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79042,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79053], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var name_kw = G__78242;
var docstring = G__78243;
var symbol_keywords = G__78244;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78272_79055 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78273_79056 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__78274_79057 = output_schema78233_79018;
var G__78275_79058 = cljs.core.deref(output_checker78241_79024);
var G__78276_79059 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78272_79055,G__78273_79056,G__78274_79057,G__78275_79058,G__78276_79059) : schema.core.fn_validator.call(null,G__78272_79055,G__78273_79056,G__78274_79057,G__78275_79058,G__78276_79059));
} else {
var temp__5753__auto___79060 = (function (){var fexpr__78277 = cljs.core.deref(output_checker78241_79024);
return (fexpr__78277.cljs$core$IFn$_invoke$arity$1 ? fexpr__78277.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78277.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79060)){
var error__42952__auto___79061 = temp__5753__auto___79060;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79061], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78233_79018,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79061], null));
} else {
}
}
} else {
}

return o__42953__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema78233_79018,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78234_79019,input_schema78239_79020], null)));

var ufv___79063 = schema.utils.use_fn_validation;
var output_schema78279_79064 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78280_79065 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker78281_79066 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78280_79065);
}),null));
var output_checker78282_79067 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78279_79064);
}),null));
var ret__47899__auto___79069 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__78284,G__78285){
var validate__42950__auto__ = cljs.core.deref(ufv___79063);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79070 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78284,G__78285], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78286_79071 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78287_79072 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__78288_79073 = input_schema78280_79065;
var G__78289_79074 = cljs.core.deref(input_checker78281_79066);
var G__78290_79075 = args__42951__auto___79070;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78286_79071,G__78287_79072,G__78288_79073,G__78289_79074,G__78290_79075) : schema.core.fn_validator.call(null,G__78286_79071,G__78287_79072,G__78288_79073,G__78289_79074,G__78290_79075));
} else {
var temp__5753__auto___79076 = (function (){var fexpr__78293 = cljs.core.deref(input_checker78281_79066);
return (fexpr__78293.cljs$core$IFn$_invoke$arity$1 ? fexpr__78293.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79070) : fexpr__78293.call(null,args__42951__auto___79070));
})();
if(cljs.core.truth_(temp__5753__auto___79076)){
var error__42952__auto___79077 = temp__5753__auto___79076;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79077], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78280_79065,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79070,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79077], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var name_kw = G__78284;
var size = G__78285;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78294_79078 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78295_79079 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__78296_79080 = output_schema78279_79064;
var G__78297_79081 = cljs.core.deref(output_checker78282_79067);
var G__78298_79082 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78294_79078,G__78295_79079,G__78296_79080,G__78297_79081,G__78298_79082) : schema.core.fn_validator.call(null,G__78294_79078,G__78295_79079,G__78296_79080,G__78297_79081,G__78298_79082));
} else {
var temp__5753__auto___79083 = (function (){var fexpr__78299 = cljs.core.deref(output_checker78282_79067);
return (fexpr__78299.cljs$core$IFn$_invoke$arity$1 ? fexpr__78299.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78299.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79083)){
var error__42952__auto___79084 = temp__5753__auto___79083;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79084], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78279_79064,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79084], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema78279_79064,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78280_79065], null)));

var ufv___79085 = schema.utils.use_fn_validation;
var output_schema78300_79086 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78301_79087 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker78302_79088 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78301_79087);
}),null));
var output_checker78303_79089 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78300_79086);
}),null));
var ret__47899__auto___79090 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__78304){
var validate__42950__auto__ = cljs.core.deref(ufv___79085);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79092 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78304], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78309_79093 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78310_79094 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__78311_79095 = input_schema78301_79087;
var G__78312_79096 = cljs.core.deref(input_checker78302_79088);
var G__78313_79097 = args__42951__auto___79092;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78309_79093,G__78310_79094,G__78311_79095,G__78312_79096,G__78313_79097) : schema.core.fn_validator.call(null,G__78309_79093,G__78310_79094,G__78311_79095,G__78312_79096,G__78313_79097));
} else {
var temp__5753__auto___79098 = (function (){var fexpr__78315 = cljs.core.deref(input_checker78302_79088);
return (fexpr__78315.cljs$core$IFn$_invoke$arity$1 ? fexpr__78315.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79092) : fexpr__78315.call(null,args__42951__auto___79092));
})();
if(cljs.core.truth_(temp__5753__auto___79098)){
var error__42952__auto___79099 = temp__5753__auto___79098;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79099], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78301_79087,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79092,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79099], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var items_schema = G__78304;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78317_79100 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78318_79101 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__78319_79102 = output_schema78300_79086;
var G__78320_79103 = cljs.core.deref(output_checker78303_79089);
var G__78321_79104 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78317_79100,G__78318_79101,G__78319_79102,G__78320_79103,G__78321_79104) : schema.core.fn_validator.call(null,G__78317_79100,G__78318_79101,G__78319_79102,G__78320_79103,G__78321_79104));
} else {
var temp__5753__auto___79106 = (function (){var fexpr__78322 = cljs.core.deref(output_checker78303_79089);
return (fexpr__78322.cljs$core$IFn$_invoke$arity$1 ? fexpr__78322.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78322.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79106)){
var error__42952__auto___79107 = temp__5753__auto___79106;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79107], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78300_79086,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79107], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema78300_79086,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78301_79087], null)));

var ufv___79108 = schema.utils.use_fn_validation;
var output_schema78324_79109 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78325_79110 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker78326_79111 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78325_79110);
}),null));
var output_checker78327_79112 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78324_79109);
}),null));
var ret__47899__auto___79113 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__78328){
var validate__42950__auto__ = cljs.core.deref(ufv___79108);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79115 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78328], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78330_79117 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78331_79118 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__78332_79119 = input_schema78325_79110;
var G__78333_79120 = cljs.core.deref(input_checker78326_79111);
var G__78334_79121 = args__42951__auto___79115;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78330_79117,G__78331_79118,G__78332_79119,G__78333_79120,G__78334_79121) : schema.core.fn_validator.call(null,G__78330_79117,G__78331_79118,G__78332_79119,G__78333_79120,G__78334_79121));
} else {
var temp__5753__auto___79123 = (function (){var fexpr__78335 = cljs.core.deref(input_checker78326_79111);
return (fexpr__78335.cljs$core$IFn$_invoke$arity$1 ? fexpr__78335.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79115) : fexpr__78335.call(null,args__42951__auto___79115));
})();
if(cljs.core.truth_(temp__5753__auto___79123)){
var error__42952__auto___79124 = temp__5753__auto___79123;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79124], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78325_79110,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79115,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79124], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var values_schema = G__78328;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78337_79127 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78338_79128 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__78339_79129 = output_schema78324_79109;
var G__78340_79130 = cljs.core.deref(output_checker78327_79112);
var G__78341_79131 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78337_79127,G__78338_79128,G__78339_79129,G__78340_79130,G__78341_79131) : schema.core.fn_validator.call(null,G__78337_79127,G__78338_79128,G__78339_79129,G__78340_79130,G__78341_79131));
} else {
var temp__5753__auto___79132 = (function (){var fexpr__78342 = cljs.core.deref(output_checker78327_79112);
return (fexpr__78342.cljs$core$IFn$_invoke$arity$1 ? fexpr__78342.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78342.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79132)){
var error__42952__auto___79133 = temp__5753__auto___79132;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79133], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78324_79109,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79133], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema78324_79109,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78325_79110], null)));

var ufv___79136 = schema.utils.use_fn_validation;
var output_schema78343_79137 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78344_79138 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker78345_79139 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78344_79138);
}),null));
var output_checker78346_79140 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78343_79137);
}),null));
var ret__47899__auto___79142 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__78347){
var validate__42950__auto__ = cljs.core.deref(ufv___79136);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79144 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78347], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78348_79145 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78349_79146 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__78350_79147 = input_schema78344_79138;
var G__78351_79148 = cljs.core.deref(input_checker78345_79139);
var G__78352_79149 = args__42951__auto___79144;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78348_79145,G__78349_79146,G__78350_79147,G__78351_79148,G__78352_79149) : schema.core.fn_validator.call(null,G__78348_79145,G__78349_79146,G__78350_79147,G__78351_79148,G__78352_79149));
} else {
var temp__5753__auto___79150 = (function (){var fexpr__78353 = cljs.core.deref(input_checker78345_79139);
return (fexpr__78353.cljs$core$IFn$_invoke$arity$1 ? fexpr__78353.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79144) : fexpr__78353.call(null,args__42951__auto___79144));
})();
if(cljs.core.truth_(temp__5753__auto___79150)){
var error__42952__auto___79151 = temp__5753__auto___79150;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79151], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78344_79138,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79144,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79151], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var member_schemas = G__78347;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78355_79152 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78356_79153 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__78357_79154 = output_schema78343_79137;
var G__78358_79155 = cljs.core.deref(output_checker78346_79140);
var G__78359_79156 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78355_79152,G__78356_79153,G__78357_79154,G__78358_79155,G__78359_79156) : schema.core.fn_validator.call(null,G__78355_79152,G__78356_79153,G__78357_79154,G__78358_79155,G__78359_79156));
} else {
var temp__5753__auto___79157 = (function (){var fexpr__78360 = cljs.core.deref(output_checker78346_79140);
return (fexpr__78360.cljs$core$IFn$_invoke$arity$1 ? fexpr__78360.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78360.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79157)){
var error__42952__auto___79158 = temp__5753__auto___79157;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79158], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78343_79137,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79158], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema78343_79137,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78344_79138], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___79160 = schema.utils.use_fn_validation;
var output_schema78362_79161 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78364_79162 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker78365_79163 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78364_79162);
}),null));
var output_checker78366_79164 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78362_79161);
}),null));
var ret__47899__auto___79165 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__78367){
var validate__42950__auto__ = cljs.core.deref(ufv___79160);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79167 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78367], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78368_79168 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78369_79169 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__78370_79170 = input_schema78364_79162;
var G__78371_79171 = cljs.core.deref(input_checker78365_79163);
var G__78372_79172 = args__42951__auto___79167;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78368_79168,G__78369_79169,G__78370_79170,G__78371_79171,G__78372_79172) : schema.core.fn_validator.call(null,G__78368_79168,G__78369_79169,G__78370_79170,G__78371_79171,G__78372_79172));
} else {
var temp__5753__auto___79173 = (function (){var fexpr__78373 = cljs.core.deref(input_checker78365_79163);
return (fexpr__78373.cljs$core$IFn$_invoke$arity$1 ? fexpr__78373.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79167) : fexpr__78373.call(null,args__42951__auto___79167));
})();
if(cljs.core.truth_(temp__5753__auto___79173)){
var error__42952__auto___79174 = temp__5753__auto___79173;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79174], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78364_79162,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79167,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79174], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78367;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78375_79175 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78376_79176 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__78377_79177 = output_schema78362_79161;
var G__78378_79178 = cljs.core.deref(output_checker78366_79164);
var G__78379_79179 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78375_79175,G__78376_79176,G__78377_79177,G__78378_79178,G__78379_79179) : schema.core.fn_validator.call(null,G__78375_79175,G__78376_79176,G__78377_79177,G__78378_79178,G__78379_79179));
} else {
var temp__5753__auto___79180 = (function (){var fexpr__78380 = cljs.core.deref(output_checker78366_79164);
return (fexpr__78380.cljs$core$IFn$_invoke$arity$1 ? fexpr__78380.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78380.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79180)){
var error__42952__auto___79181 = temp__5753__auto___79180;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79181], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78362_79161,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79181], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema78362_79161,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78364_79162], null)));

var ufv___79182 = schema.utils.use_fn_validation;
var output_schema78381_79183 = deercreeklabs.baracus.ByteArray;
var input_schema78383_79184 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker78384_79185 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78383_79184);
}),null));
var output_checker78385_79186 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78381_79183);
}),null));
var ret__47899__auto___79187 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__78386,G__78387){
var validate__42950__auto__ = cljs.core.deref(ufv___79182);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79188 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78386,G__78387], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78389_79189 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78390_79190 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__78391_79191 = input_schema78383_79184;
var G__78392_79192 = cljs.core.deref(input_checker78384_79185);
var G__78393_79193 = args__42951__auto___79188;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78389_79189,G__78390_79190,G__78391_79191,G__78392_79192,G__78393_79193) : schema.core.fn_validator.call(null,G__78389_79189,G__78390_79190,G__78391_79191,G__78392_79192,G__78393_79193));
} else {
var temp__5753__auto___79194 = (function (){var fexpr__78394 = cljs.core.deref(input_checker78384_79185);
return (fexpr__78394.cljs$core$IFn$_invoke$arity$1 ? fexpr__78394.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79188) : fexpr__78394.call(null,args__42951__auto___79188));
})();
if(cljs.core.truth_(temp__5753__auto___79194)){
var error__42952__auto___79195 = temp__5753__auto___79194;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79195], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78383_79184,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79188,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79195], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var writer_schema = G__78386;
var data = G__78387;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78402_79196 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78403_79197 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__78404_79198 = output_schema78381_79183;
var G__78405_79199 = cljs.core.deref(output_checker78385_79186);
var G__78406_79200 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78402_79196,G__78403_79197,G__78404_79198,G__78405_79199,G__78406_79200) : schema.core.fn_validator.call(null,G__78402_79196,G__78403_79197,G__78404_79198,G__78405_79199,G__78406_79200));
} else {
var temp__5753__auto___79202 = (function (){var fexpr__78407 = cljs.core.deref(output_checker78385_79186);
return (fexpr__78407.cljs$core$IFn$_invoke$arity$1 ? fexpr__78407.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78407.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79202)){
var error__42952__auto___79203 = temp__5753__auto___79202;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79203], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78381_79183,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79203], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema78381_79183,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78383_79184], null)));

var ufv___79204 = schema.utils.use_fn_validation;
var output_schema78408_79205 = schema.core.Any;
var input_schema78409_79206 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker78410_79207 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78409_79206);
}),null));
var output_checker78411_79208 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78408_79205);
}),null));
var ret__47899__auto___79211 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__78412,G__78413,G__78414){
var validate__42950__auto__ = cljs.core.deref(ufv___79204);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79213 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78412,G__78413,G__78414], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78418_79215 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78419_79216 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__78420_79217 = input_schema78409_79206;
var G__78421_79218 = cljs.core.deref(input_checker78410_79207);
var G__78422_79219 = args__42951__auto___79213;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78418_79215,G__78419_79216,G__78420_79217,G__78421_79218,G__78422_79219) : schema.core.fn_validator.call(null,G__78418_79215,G__78419_79216,G__78420_79217,G__78421_79218,G__78422_79219));
} else {
var temp__5753__auto___79220 = (function (){var fexpr__78423 = cljs.core.deref(input_checker78410_79207);
return (fexpr__78423.cljs$core$IFn$_invoke$arity$1 ? fexpr__78423.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79213) : fexpr__78423.call(null,args__42951__auto___79213));
})();
if(cljs.core.truth_(temp__5753__auto___79220)){
var error__42952__auto___79221 = temp__5753__auto___79220;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79221], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78409_79206,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79213,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79221], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var reader_schema = G__78412;
var writer_schema = G__78413;
var ba = G__78414;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78441_79228 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78442_79229 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__78443_79230 = output_schema78408_79205;
var G__78444_79231 = cljs.core.deref(output_checker78411_79208);
var G__78445_79232 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78441_79228,G__78442_79229,G__78443_79230,G__78444_79231,G__78445_79232) : schema.core.fn_validator.call(null,G__78441_79228,G__78442_79229,G__78443_79230,G__78444_79231,G__78445_79232));
} else {
var temp__5753__auto___79233 = (function (){var fexpr__78448 = cljs.core.deref(output_checker78411_79208);
return (fexpr__78448.cljs$core$IFn$_invoke$arity$1 ? fexpr__78448.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78448.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79233)){
var error__42952__auto___79234 = temp__5753__auto___79233;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79234], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78408_79205,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79234], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema78408_79205,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78409_79206], null)));

var ufv___79235 = schema.utils.use_fn_validation;
var output_schema78450_79236 = schema.core.Any;
var input_schema78451_79237 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker78452_79238 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78451_79237);
}),null));
var output_checker78453_79239 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78450_79236);
}),null));
var ret__47899__auto___79240 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__78454,G__78455){
var validate__42950__auto__ = cljs.core.deref(ufv___79235);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79241 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78454,G__78455], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78458_79242 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78459_79243 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__78460_79244 = input_schema78451_79237;
var G__78461_79245 = cljs.core.deref(input_checker78452_79238);
var G__78462_79246 = args__42951__auto___79241;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78458_79242,G__78459_79243,G__78460_79244,G__78461_79245,G__78462_79246) : schema.core.fn_validator.call(null,G__78458_79242,G__78459_79243,G__78460_79244,G__78461_79245,G__78462_79246));
} else {
var temp__5753__auto___79247 = (function (){var fexpr__78463 = cljs.core.deref(input_checker78452_79238);
return (fexpr__78463.cljs$core$IFn$_invoke$arity$1 ? fexpr__78463.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79241) : fexpr__78463.call(null,args__42951__auto___79241));
})();
if(cljs.core.truth_(temp__5753__auto___79247)){
var error__42952__auto___79248 = temp__5753__auto___79247;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79248], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78451_79237,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79241,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79248], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78454;
var ba = G__78455;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78464_79249 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78465_79250 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__78466_79251 = output_schema78450_79236;
var G__78467_79252 = cljs.core.deref(output_checker78453_79239);
var G__78468_79253 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78464_79249,G__78465_79250,G__78466_79251,G__78467_79252,G__78468_79253) : schema.core.fn_validator.call(null,G__78464_79249,G__78465_79250,G__78466_79251,G__78467_79252,G__78468_79253));
} else {
var temp__5753__auto___79255 = (function (){var fexpr__78469 = cljs.core.deref(output_checker78453_79239);
return (fexpr__78469.cljs$core$IFn$_invoke$arity$1 ? fexpr__78469.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78469.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79255)){
var error__42952__auto___79257 = temp__5753__auto___79255;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79257], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78450_79236,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79257], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema78450_79236,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78451_79237], null)));

var ufv___79258 = schema.utils.use_fn_validation;
var output_schema78473_79259 = schema.core.Any;
var input_schema78474_79260 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78475_79261 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78474_79260);
}),null));
var output_checker78476_79262 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78473_79259);
}),null));
var ret__47899__auto___79263 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__78479){
var validate__42950__auto__ = cljs.core.deref(ufv___79258);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79264 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78479], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78491_79265 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78492_79266 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__78493_79267 = input_schema78474_79260;
var G__78494_79268 = cljs.core.deref(input_checker78475_79261);
var G__78495_79269 = args__42951__auto___79264;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78491_79265,G__78492_79266,G__78493_79267,G__78494_79268,G__78495_79269) : schema.core.fn_validator.call(null,G__78491_79265,G__78492_79266,G__78493_79267,G__78494_79268,G__78495_79269));
} else {
var temp__5753__auto___79270 = (function (){var fexpr__78497 = cljs.core.deref(input_checker78475_79261);
return (fexpr__78497.cljs$core$IFn$_invoke$arity$1 ? fexpr__78497.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79264) : fexpr__78497.call(null,args__42951__auto___79264));
})();
if(cljs.core.truth_(temp__5753__auto___79270)){
var error__42952__auto___79271 = temp__5753__auto___79270;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79271], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78474_79260,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79264,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79271], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78479;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78498_79272 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78499_79273 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__78500_79274 = output_schema78473_79259;
var G__78501_79275 = cljs.core.deref(output_checker78476_79262);
var G__78502_79276 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78498_79272,G__78499_79273,G__78500_79274,G__78501_79275,G__78502_79276) : schema.core.fn_validator.call(null,G__78498_79272,G__78499_79273,G__78500_79274,G__78501_79275,G__78502_79276));
} else {
var temp__5753__auto___79277 = (function (){var fexpr__78507 = cljs.core.deref(output_checker78476_79262);
return (fexpr__78507.cljs$core$IFn$_invoke$arity$1 ? fexpr__78507.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78507.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79277)){
var error__42952__auto___79278 = temp__5753__auto___79277;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79278], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78473_79259,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79278], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema78473_79259,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78474_79260], null)));

var ufv___79279 = schema.utils.use_fn_validation;
var output_schema78510_79280 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78511_79281 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker78512_79282 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78511_79281);
}),null));
var output_checker78513_79283 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78510_79280);
}),null));
var ret__47899__auto___79284 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__78514){
var validate__42950__auto__ = cljs.core.deref(ufv___79279);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79285 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78514], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78520_79286 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78521_79287 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__78522_79288 = input_schema78511_79281;
var G__78523_79289 = cljs.core.deref(input_checker78512_79282);
var G__78524_79290 = args__42951__auto___79285;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78520_79286,G__78521_79287,G__78522_79288,G__78523_79289,G__78524_79290) : schema.core.fn_validator.call(null,G__78520_79286,G__78521_79287,G__78522_79288,G__78523_79289,G__78524_79290));
} else {
var temp__5753__auto___79291 = (function (){var fexpr__78526 = cljs.core.deref(input_checker78512_79282);
return (fexpr__78526.cljs$core$IFn$_invoke$arity$1 ? fexpr__78526.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79285) : fexpr__78526.call(null,args__42951__auto___79285));
})();
if(cljs.core.truth_(temp__5753__auto___79291)){
var error__42952__auto___79292 = temp__5753__auto___79291;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79292], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78511_79281,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79285,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79292], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var edn = G__78514;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78532_79293 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78533_79294 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__78534_79295 = output_schema78510_79280;
var G__78535_79296 = cljs.core.deref(output_checker78513_79283);
var G__78536_79297 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78532_79293,G__78533_79294,G__78534_79295,G__78535_79296,G__78536_79297) : schema.core.fn_validator.call(null,G__78532_79293,G__78533_79294,G__78534_79295,G__78535_79296,G__78536_79297));
} else {
var temp__5753__auto___79298 = (function (){var fexpr__78537 = cljs.core.deref(output_checker78513_79283);
return (fexpr__78537.cljs$core$IFn$_invoke$arity$1 ? fexpr__78537.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78537.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79298)){
var error__42952__auto___79299 = temp__5753__auto___79298;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79299], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78510_79280,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79299], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema78510_79280,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78511_79281], null)));

var ufv___79301 = schema.utils.use_fn_validation;
var output_schema78540_79302 = schema.core.Str;
var input_schema78541_79303 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78542_79304 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78541_79303);
}),null));
var output_checker78543_79305 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78540_79302);
}),null));
var ret__47899__auto___79307 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__78544){
var validate__42950__auto__ = cljs.core.deref(ufv___79301);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79308 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78544], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78547_79309 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78548_79310 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__78549_79311 = input_schema78541_79303;
var G__78550_79312 = cljs.core.deref(input_checker78542_79304);
var G__78551_79313 = args__42951__auto___79308;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78547_79309,G__78548_79310,G__78549_79311,G__78550_79312,G__78551_79313) : schema.core.fn_validator.call(null,G__78547_79309,G__78548_79310,G__78549_79311,G__78550_79312,G__78551_79313));
} else {
var temp__5753__auto___79314 = (function (){var fexpr__78553 = cljs.core.deref(input_checker78542_79304);
return (fexpr__78553.cljs$core$IFn$_invoke$arity$1 ? fexpr__78553.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79308) : fexpr__78553.call(null,args__42951__auto___79308));
})();
if(cljs.core.truth_(temp__5753__auto___79314)){
var error__42952__auto___79315 = temp__5753__auto___79314;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79315], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78541_79303,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79308,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79315], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78544;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78554_79316 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78555_79317 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__78556_79318 = output_schema78540_79302;
var G__78557_79319 = cljs.core.deref(output_checker78543_79305);
var G__78558_79320 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78554_79316,G__78555_79317,G__78556_79318,G__78557_79319,G__78558_79320) : schema.core.fn_validator.call(null,G__78554_79316,G__78555_79317,G__78556_79318,G__78557_79319,G__78558_79320));
} else {
var temp__5753__auto___79321 = (function (){var fexpr__78560 = cljs.core.deref(output_checker78543_79305);
return (fexpr__78560.cljs$core$IFn$_invoke$arity$1 ? fexpr__78560.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78560.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79321)){
var error__42952__auto___79322 = temp__5753__auto___79321;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79322], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78540_79302,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79322], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema78540_79302,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78541_79303], null)));

var ufv___79323 = schema.utils.use_fn_validation;
var output_schema78562_79324 = schema.core.Keyword;
var input_schema78564_79325 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78565_79326 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78564_79325);
}),null));
var output_checker78566_79327 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78562_79324);
}),null));
var ret__47899__auto___79330 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__78567){
var validate__42950__auto__ = cljs.core.deref(ufv___79323);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79331 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78567], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78572_79332 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78573_79333 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__78574_79334 = input_schema78564_79325;
var G__78575_79335 = cljs.core.deref(input_checker78565_79326);
var G__78576_79336 = args__42951__auto___79331;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78572_79332,G__78573_79333,G__78574_79334,G__78575_79335,G__78576_79336) : schema.core.fn_validator.call(null,G__78572_79332,G__78573_79333,G__78574_79334,G__78575_79335,G__78576_79336));
} else {
var temp__5753__auto___79337 = (function (){var fexpr__78577 = cljs.core.deref(input_checker78565_79326);
return (fexpr__78577.cljs$core$IFn$_invoke$arity$1 ? fexpr__78577.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79331) : fexpr__78577.call(null,args__42951__auto___79331));
})();
if(cljs.core.truth_(temp__5753__auto___79337)){
var error__42952__auto___79338 = temp__5753__auto___79337;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79338], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78564_79325,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79331,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79338], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78567;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78579_79339 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78580_79340 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__78581_79341 = output_schema78562_79324;
var G__78582_79342 = cljs.core.deref(output_checker78566_79327);
var G__78583_79343 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78579_79339,G__78580_79340,G__78581_79341,G__78582_79342,G__78583_79343) : schema.core.fn_validator.call(null,G__78579_79339,G__78580_79340,G__78581_79341,G__78582_79342,G__78583_79343));
} else {
var temp__5753__auto___79344 = (function (){var fexpr__78584 = cljs.core.deref(output_checker78566_79327);
return (fexpr__78584.cljs$core$IFn$_invoke$arity$1 ? fexpr__78584.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78584.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79344)){
var error__42952__auto___79345 = temp__5753__auto___79344;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79345], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78562_79324,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79345], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema78562_79324,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78564_79325], null)));

var ufv___79347 = schema.utils.use_fn_validation;
var output_schema78587_79348 = schema.core.Str;
var input_schema78588_79349 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78589_79350 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78588_79349);
}),null));
var output_checker78590_79351 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78587_79348);
}),null));
var ret__47899__auto___79353 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__78591){
var validate__42950__auto__ = cljs.core.deref(ufv___79347);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79354 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78591], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78593_79355 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78594_79356 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__78595_79357 = input_schema78588_79349;
var G__78596_79358 = cljs.core.deref(input_checker78589_79350);
var G__78597_79359 = args__42951__auto___79354;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78593_79355,G__78594_79356,G__78595_79357,G__78596_79358,G__78597_79359) : schema.core.fn_validator.call(null,G__78593_79355,G__78594_79356,G__78595_79357,G__78596_79358,G__78597_79359));
} else {
var temp__5753__auto___79360 = (function (){var fexpr__78598 = cljs.core.deref(input_checker78589_79350);
return (fexpr__78598.cljs$core$IFn$_invoke$arity$1 ? fexpr__78598.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79354) : fexpr__78598.call(null,args__42951__auto___79354));
})();
if(cljs.core.truth_(temp__5753__auto___79360)){
var error__42952__auto___79361 = temp__5753__auto___79360;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79361], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78588_79349,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79354,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79361], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78591;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78601_79362 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78602_79363 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__78603_79364 = output_schema78587_79348;
var G__78604_79365 = cljs.core.deref(output_checker78590_79351);
var G__78605_79366 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78601_79362,G__78602_79363,G__78603_79364,G__78604_79365,G__78605_79366) : schema.core.fn_validator.call(null,G__78601_79362,G__78602_79363,G__78603_79364,G__78604_79365,G__78605_79366));
} else {
var temp__5753__auto___79367 = (function (){var fexpr__78606 = cljs.core.deref(output_checker78590_79351);
return (fexpr__78606.cljs$core$IFn$_invoke$arity$1 ? fexpr__78606.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78606.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79367)){
var error__42952__auto___79368 = temp__5753__auto___79367;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79368], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78587_79348,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79368], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema78587_79348,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78588_79349], null)));

var ufv___79369 = schema.utils.use_fn_validation;
var output_schema78617_79370 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema78618_79371 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78619_79372 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78618_79371);
}),null));
var output_checker78620_79373 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78617_79370);
}),null));
var ret__47899__auto___79374 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__78621){
var validate__42950__auto__ = cljs.core.deref(ufv___79369);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79375 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78621], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78635_79376 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78636_79377 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__78637_79378 = input_schema78618_79371;
var G__78638_79379 = cljs.core.deref(input_checker78619_79372);
var G__78639_79380 = args__42951__auto___79375;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78635_79376,G__78636_79377,G__78637_79378,G__78638_79379,G__78639_79380) : schema.core.fn_validator.call(null,G__78635_79376,G__78636_79377,G__78637_79378,G__78638_79379,G__78639_79380));
} else {
var temp__5753__auto___79381 = (function (){var fexpr__78640 = cljs.core.deref(input_checker78619_79372);
return (fexpr__78640.cljs$core$IFn$_invoke$arity$1 ? fexpr__78640.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79375) : fexpr__78640.call(null,args__42951__auto___79375));
})();
if(cljs.core.truth_(temp__5753__auto___79381)){
var error__42952__auto___79382 = temp__5753__auto___79381;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79382], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78618_79371,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79375,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79382], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78621;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78659_79383 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78660_79384 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__78661_79385 = output_schema78617_79370;
var G__78662_79386 = cljs.core.deref(output_checker78620_79373);
var G__78663_79387 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78659_79383,G__78660_79384,G__78661_79385,G__78662_79386,G__78663_79387) : schema.core.fn_validator.call(null,G__78659_79383,G__78660_79384,G__78661_79385,G__78662_79386,G__78663_79387));
} else {
var temp__5753__auto___79388 = (function (){var fexpr__78674 = cljs.core.deref(output_checker78620_79373);
return (fexpr__78674.cljs$core$IFn$_invoke$arity$1 ? fexpr__78674.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78674.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79388)){
var error__42952__auto___79389 = temp__5753__auto___79388;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79389], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78617_79370,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79389], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema78617_79370,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78618_79371], null)));

var ufv___79390 = schema.utils.use_fn_validation;
var output_schema78686_79391 = deercreeklabs.baracus.ByteArray;
var input_schema78687_79392 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78688_79393 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78687_79392);
}),null));
var output_checker78689_79394 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78686_79391);
}),null));
var ret__47899__auto___79396 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__78690){
var validate__42950__auto__ = cljs.core.deref(ufv___79390);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79397 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78690], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78696_79398 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78697_79399 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__78698_79400 = input_schema78687_79392;
var G__78699_79401 = cljs.core.deref(input_checker78688_79393);
var G__78700_79402 = args__42951__auto___79397;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78696_79398,G__78697_79399,G__78698_79400,G__78699_79401,G__78700_79402) : schema.core.fn_validator.call(null,G__78696_79398,G__78697_79399,G__78698_79400,G__78699_79401,G__78700_79402));
} else {
var temp__5753__auto___79403 = (function (){var fexpr__78703 = cljs.core.deref(input_checker78688_79393);
return (fexpr__78703.cljs$core$IFn$_invoke$arity$1 ? fexpr__78703.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79397) : fexpr__78703.call(null,args__42951__auto___79397));
})();
if(cljs.core.truth_(temp__5753__auto___79403)){
var error__42952__auto___79404 = temp__5753__auto___79403;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79404], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78687_79392,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79397,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79404], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78690;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78705_79405 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78706_79406 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__78707_79407 = output_schema78686_79391;
var G__78708_79408 = cljs.core.deref(output_checker78689_79394);
var G__78709_79409 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78705_79405,G__78706_79406,G__78707_79407,G__78708_79408,G__78709_79409) : schema.core.fn_validator.call(null,G__78705_79405,G__78706_79406,G__78707_79407,G__78708_79408,G__78709_79409));
} else {
var temp__5753__auto___79410 = (function (){var fexpr__78710 = cljs.core.deref(output_checker78689_79394);
return (fexpr__78710.cljs$core$IFn$_invoke$arity$1 ? fexpr__78710.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78710.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79410)){
var error__42952__auto___79411 = temp__5753__auto___79410;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79411], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78686_79391,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79411], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema78686_79391,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78687_79392], null)));

var ufv___79414 = schema.utils.use_fn_validation;
var output_schema78713_79415 = deercreeklabs.baracus.ByteArray;
var input_schema78714_79416 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78715_79417 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78714_79416);
}),null));
var output_checker78716_79418 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78713_79415);
}),null));
var ret__47899__auto___79419 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__78717){
var validate__42950__auto__ = cljs.core.deref(ufv___79414);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79420 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78717], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78718_79421 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78719_79422 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__78720_79423 = input_schema78714_79416;
var G__78721_79424 = cljs.core.deref(input_checker78715_79417);
var G__78722_79425 = args__42951__auto___79420;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78718_79421,G__78719_79422,G__78720_79423,G__78721_79424,G__78722_79425) : schema.core.fn_validator.call(null,G__78718_79421,G__78719_79422,G__78720_79423,G__78721_79424,G__78722_79425));
} else {
var temp__5753__auto___79426 = (function (){var fexpr__78723 = cljs.core.deref(input_checker78715_79417);
return (fexpr__78723.cljs$core$IFn$_invoke$arity$1 ? fexpr__78723.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79420) : fexpr__78723.call(null,args__42951__auto___79420));
})();
if(cljs.core.truth_(temp__5753__auto___79426)){
var error__42952__auto___79427 = temp__5753__auto___79426;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79427], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78714_79416,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79420,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79427], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78717;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78726_79428 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78727_79429 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__78728_79430 = output_schema78713_79415;
var G__78729_79431 = cljs.core.deref(output_checker78716_79418);
var G__78730_79432 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78726_79428,G__78727_79429,G__78728_79430,G__78729_79431,G__78730_79432) : schema.core.fn_validator.call(null,G__78726_79428,G__78727_79429,G__78728_79430,G__78729_79431,G__78730_79432));
} else {
var temp__5753__auto___79433 = (function (){var fexpr__78731 = cljs.core.deref(output_checker78716_79418);
return (fexpr__78731.cljs$core$IFn$_invoke$arity$1 ? fexpr__78731.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78731.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79433)){
var error__42952__auto___79434 = temp__5753__auto___79433;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79434], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78713_79415,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79434], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema78713_79415,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78714_79416], null)));

var ufv___79435 = schema.utils.use_fn_validation;
var output_schema78733_79436 = schema.core.Bool;
var input_schema78734_79437 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker78735_79438 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78734_79437);
}),null));
var output_checker78736_79439 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78733_79436);
}),null));
var ret__47899__auto___79440 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__78737){
var validate__42950__auto__ = cljs.core.deref(ufv___79435);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79441 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78737], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78739_79442 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78740_79443 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__78741_79444 = input_schema78734_79437;
var G__78742_79445 = cljs.core.deref(input_checker78735_79438);
var G__78743_79446 = args__42951__auto___79441;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78739_79442,G__78740_79443,G__78741_79444,G__78742_79445,G__78743_79446) : schema.core.fn_validator.call(null,G__78739_79442,G__78740_79443,G__78741_79444,G__78742_79445,G__78743_79446));
} else {
var temp__5753__auto___79447 = (function (){var fexpr__78747 = cljs.core.deref(input_checker78735_79438);
return (fexpr__78747.cljs$core$IFn$_invoke$arity$1 ? fexpr__78747.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79441) : fexpr__78747.call(null,args__42951__auto___79441));
})();
if(cljs.core.truth_(temp__5753__auto___79447)){
var error__42952__auto___79448 = temp__5753__auto___79447;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79448], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78734_79437,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79441,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79448], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var arg = G__78737;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78751_79449 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78752_79450 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__78753_79451 = output_schema78733_79436;
var G__78754_79452 = cljs.core.deref(output_checker78736_79439);
var G__78755_79453 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78751_79449,G__78752_79450,G__78753_79451,G__78754_79452,G__78755_79453) : schema.core.fn_validator.call(null,G__78751_79449,G__78752_79450,G__78753_79451,G__78754_79452,G__78755_79453));
} else {
var temp__5753__auto___79454 = (function (){var fexpr__78758 = cljs.core.deref(output_checker78736_79439);
return (fexpr__78758.cljs$core$IFn$_invoke$arity$1 ? fexpr__78758.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78758.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79454)){
var error__42952__auto___79455 = temp__5753__auto___79454;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79455], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78733_79436,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79455], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema78733_79436,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78734_79437], null)));

var ufv___79456 = schema.utils.use_fn_validation;
var output_schema78761_79457 = schema.core.Bool;
var input_schema78762_79458 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78763_79459 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78762_79458);
}),null));
var output_checker78764_79460 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78761_79457);
}),null));
var ret__47899__auto___79461 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__78765,G__78766){
var validate__42950__auto__ = cljs.core.deref(ufv___79456);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79462 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78765,G__78766], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78769_79463 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78770_79464 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__78771_79465 = input_schema78762_79458;
var G__78772_79466 = cljs.core.deref(input_checker78763_79459);
var G__78773_79467 = args__42951__auto___79462;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78769_79463,G__78770_79464,G__78771_79465,G__78772_79466,G__78773_79467) : schema.core.fn_validator.call(null,G__78769_79463,G__78770_79464,G__78771_79465,G__78772_79466,G__78773_79467));
} else {
var temp__5753__auto___79469 = (function (){var fexpr__78774 = cljs.core.deref(input_checker78763_79459);
return (fexpr__78774.cljs$core$IFn$_invoke$arity$1 ? fexpr__78774.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79462) : fexpr__78774.call(null,args__42951__auto___79462));
})();
if(cljs.core.truth_(temp__5753__auto___79469)){
var error__42952__auto___79470 = temp__5753__auto___79469;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79470], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78762_79458,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79462,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79470], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var reader_schema = G__78765;
var writer_schema = G__78766;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78777_79471 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78778_79472 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__78779_79473 = output_schema78761_79457;
var G__78780_79474 = cljs.core.deref(output_checker78764_79460);
var G__78781_79475 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78777_79471,G__78778_79472,G__78779_79473,G__78780_79474,G__78781_79475) : schema.core.fn_validator.call(null,G__78777_79471,G__78778_79472,G__78779_79473,G__78780_79474,G__78781_79475));
} else {
var temp__5753__auto___79476 = (function (){var fexpr__78784 = cljs.core.deref(output_checker78764_79460);
return (fexpr__78784.cljs$core$IFn$_invoke$arity$1 ? fexpr__78784.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78784.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79476)){
var error__42952__auto___79477 = temp__5753__auto___79476;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79477], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78761_79457,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79477], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema78761_79457,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78762_79458], null)));

var ufv___79478 = schema.utils.use_fn_validation;
var output_schema78787_79479 = schema.core.Any;
var input_schema78788_79480 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78789_79481 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78788_79480);
}),null));
var output_checker78790_79482 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78787_79479);
}),null));
var ret__47899__auto___79483 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__78791){
var validate__42950__auto__ = cljs.core.deref(ufv___79478);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79484 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78791], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78796_79485 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78797_79486 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__78798_79487 = input_schema78788_79480;
var G__78799_79488 = cljs.core.deref(input_checker78789_79481);
var G__78800_79489 = args__42951__auto___79484;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78796_79485,G__78797_79486,G__78798_79487,G__78799_79488,G__78800_79489) : schema.core.fn_validator.call(null,G__78796_79485,G__78797_79486,G__78798_79487,G__78799_79488,G__78800_79489));
} else {
var temp__5753__auto___79491 = (function (){var fexpr__78801 = cljs.core.deref(input_checker78789_79481);
return (fexpr__78801.cljs$core$IFn$_invoke$arity$1 ? fexpr__78801.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79484) : fexpr__78801.call(null,args__42951__auto___79484));
})();
if(cljs.core.truth_(temp__5753__auto___79491)){
var error__42952__auto___79492 = temp__5753__auto___79491;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79492], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78788_79480,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79484,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79492], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78791;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78802_79494 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78803_79495 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__78804_79496 = output_schema78787_79479;
var G__78805_79497 = cljs.core.deref(output_checker78790_79482);
var G__78806_79498 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78802_79494,G__78803_79495,G__78804_79496,G__78805_79497,G__78806_79498) : schema.core.fn_validator.call(null,G__78802_79494,G__78803_79495,G__78804_79496,G__78805_79497,G__78806_79498));
} else {
var temp__5753__auto___79499 = (function (){var fexpr__78807 = cljs.core.deref(output_checker78790_79482);
return (fexpr__78807.cljs$core$IFn$_invoke$arity$1 ? fexpr__78807.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78807.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79499)){
var error__42952__auto___79500 = temp__5753__auto___79499;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79500], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78787_79479,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79500], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema78787_79479,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78788_79480], null)));

var ufv___79501 = schema.utils.use_fn_validation;
var output_schema78808_79502 = schema.core.Any;
var input_schema78809_79503 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78810_79504 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78809_79503);
}),null));
var output_checker78811_79505 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78808_79502);
}),null));
var ret__47899__auto___79506 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__78812){
var validate__42950__auto__ = cljs.core.deref(ufv___79501);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79507 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78812], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78816_79508 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78817_79509 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__78818_79510 = input_schema78809_79503;
var G__78819_79511 = cljs.core.deref(input_checker78810_79504);
var G__78820_79512 = args__42951__auto___79507;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78816_79508,G__78817_79509,G__78818_79510,G__78819_79511,G__78820_79512) : schema.core.fn_validator.call(null,G__78816_79508,G__78817_79509,G__78818_79510,G__78819_79511,G__78820_79512));
} else {
var temp__5753__auto___79513 = (function (){var fexpr__78822 = cljs.core.deref(input_checker78810_79504);
return (fexpr__78822.cljs$core$IFn$_invoke$arity$1 ? fexpr__78822.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79507) : fexpr__78822.call(null,args__42951__auto___79507));
})();
if(cljs.core.truth_(temp__5753__auto___79513)){
var error__42952__auto___79514 = temp__5753__auto___79513;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79514], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78809_79503,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79507,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79514], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78812;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78824_79516 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78825_79517 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__78826_79518 = output_schema78808_79502;
var G__78827_79519 = cljs.core.deref(output_checker78811_79505);
var G__78828_79520 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78824_79516,G__78825_79517,G__78826_79518,G__78827_79519,G__78828_79520) : schema.core.fn_validator.call(null,G__78824_79516,G__78825_79517,G__78826_79518,G__78827_79519,G__78828_79520));
} else {
var temp__5753__auto___79521 = (function (){var fexpr__78829 = cljs.core.deref(output_checker78811_79505);
return (fexpr__78829.cljs$core$IFn$_invoke$arity$1 ? fexpr__78829.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78829.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79521)){
var error__42952__auto___79522 = temp__5753__auto___79521;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79522], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78808_79502,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79522], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema78808_79502,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78809_79503], null)));

var ufv___79523 = schema.utils.use_fn_validation;
var output_schema78833_79524 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema78834_79525 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker78835_79526 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78834_79525);
}),null));
var output_checker78837_79527 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78833_79524);
}),null));
var ret__47899__auto___79528 = /**
 * Inputs: [schema :- LancasterSchema path :- [s/Any]]
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(G__78838,G__78839){
var validate__42950__auto__ = cljs.core.deref(ufv___79523);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79529 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78838,G__78839], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78843_79530 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78844_79531 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__78845_79532 = input_schema78834_79525;
var G__78846_79533 = cljs.core.deref(input_checker78835_79526);
var G__78847_79534 = args__42951__auto___79529;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78843_79530,G__78844_79531,G__78845_79532,G__78846_79533,G__78847_79534) : schema.core.fn_validator.call(null,G__78843_79530,G__78844_79531,G__78845_79532,G__78846_79533,G__78847_79534));
} else {
var temp__5753__auto___79535 = (function (){var fexpr__78848 = cljs.core.deref(input_checker78835_79526);
return (fexpr__78848.cljs$core$IFn$_invoke$arity$1 ? fexpr__78848.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79529) : fexpr__78848.call(null,args__42951__auto___79529));
})();
if(cljs.core.truth_(temp__5753__auto___79535)){
var error__42952__auto___79536 = temp__5753__auto___79535;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79536], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78834_79525,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79529,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79536], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78838;
var path = G__78839;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

if((path == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path], null));
}
}

return deercreeklabs.lancaster.sub.schema_at_path(schema__$1,path);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78850_79537 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78851_79538 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__78852_79539 = output_schema78833_79524;
var G__78853_79540 = cljs.core.deref(output_checker78837_79527);
var G__78854_79541 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78850_79537,G__78851_79538,G__78852_79539,G__78853_79540,G__78854_79541) : schema.core.fn_validator.call(null,G__78850_79537,G__78851_79538,G__78852_79539,G__78853_79540,G__78854_79541));
} else {
var temp__5753__auto___79542 = (function (){var fexpr__78855 = cljs.core.deref(output_checker78837_79527);
return (fexpr__78855.cljs$core$IFn$_invoke$arity$1 ? fexpr__78855.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78855.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79542)){
var error__42952__auto___79543 = temp__5753__auto___79542;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79543], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78833_79524,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79543], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.__GT_FnSchema(output_schema78833_79524,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78834_79525], null)));

var ufv___79544 = schema.utils.use_fn_validation;
var output_schema78856_79545 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema78857_79546 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78858_79547 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78857_79546);
}),null));
var output_checker78859_79548 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78856_79545);
}),null));
var ret__47899__auto___79549 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__78860){
var validate__42950__auto__ = cljs.core.deref(ufv___79544);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79550 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78860], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78861_79551 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78862_79552 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__78863_79553 = input_schema78857_79546;
var G__78864_79554 = cljs.core.deref(input_checker78858_79547);
var G__78865_79555 = args__42951__auto___79550;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78861_79551,G__78862_79552,G__78863_79553,G__78864_79554,G__78865_79555) : schema.core.fn_validator.call(null,G__78861_79551,G__78862_79552,G__78863_79553,G__78864_79554,G__78865_79555));
} else {
var temp__5753__auto___79556 = (function (){var fexpr__78866 = cljs.core.deref(input_checker78858_79547);
return (fexpr__78866.cljs$core$IFn$_invoke$arity$1 ? fexpr__78866.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79550) : fexpr__78866.call(null,args__42951__auto___79550));
})();
if(cljs.core.truth_(temp__5753__auto___79556)){
var error__42952__auto___79557 = temp__5753__auto___79556;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79557], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78857_79546,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79550,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79557], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var union_schema = G__78860;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78876_79558 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78877_79559 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__78878_79560 = output_schema78856_79545;
var G__78879_79561 = cljs.core.deref(output_checker78859_79548);
var G__78880_79562 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78876_79558,G__78877_79559,G__78878_79560,G__78879_79561,G__78880_79562) : schema.core.fn_validator.call(null,G__78876_79558,G__78877_79559,G__78878_79560,G__78879_79561,G__78880_79562));
} else {
var temp__5753__auto___79563 = (function (){var fexpr__78882 = cljs.core.deref(output_checker78859_79548);
return (fexpr__78882.cljs$core$IFn$_invoke$arity$1 ? fexpr__78882.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78882.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79563)){
var error__42952__auto___79564 = temp__5753__auto___79563;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79564], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78856_79545,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79564], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema78856_79545,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78857_79546], null)));

var ufv___79565 = schema.utils.use_fn_validation;
var output_schema78883_79566 = deercreeklabs.lancaster.LancasterSchema;
var input_schema78884_79567 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker78885_79568 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78884_79567);
}),null));
var output_checker78886_79569 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78883_79566);
}),null));
var ret__47899__auto___79570 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__78887,G__78888){
var validate__42950__auto__ = cljs.core.deref(ufv___79565);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79571 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78887,G__78888], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78892_79572 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78893_79573 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__78894_79574 = input_schema78884_79567;
var G__78895_79575 = cljs.core.deref(input_checker78885_79568);
var G__78896_79576 = args__42951__auto___79571;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78892_79572,G__78893_79573,G__78894_79574,G__78895_79575,G__78896_79576) : schema.core.fn_validator.call(null,G__78892_79572,G__78893_79573,G__78894_79574,G__78895_79575,G__78896_79576));
} else {
var temp__5753__auto___79577 = (function (){var fexpr__78897 = cljs.core.deref(input_checker78885_79568);
return (fexpr__78897.cljs$core$IFn$_invoke$arity$1 ? fexpr__78897.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79571) : fexpr__78897.call(null,args__42951__auto___79571));
})();
if(cljs.core.truth_(temp__5753__auto___79577)){
var error__42952__auto___79581 = temp__5753__auto___79577;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79581], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78884_79567,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79571,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79581], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var union_schema = G__78887;
var branch_index = G__78888;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = branch_index;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78906_79582 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78907_79583 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__78908_79584 = output_schema78883_79566;
var G__78909_79585 = cljs.core.deref(output_checker78886_79569);
var G__78910_79586 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78906_79582,G__78907_79583,G__78908_79584,G__78909_79585,G__78910_79586) : schema.core.fn_validator.call(null,G__78906_79582,G__78907_79583,G__78908_79584,G__78909_79585,G__78910_79586));
} else {
var temp__5753__auto___79587 = (function (){var fexpr__78911 = cljs.core.deref(output_checker78886_79569);
return (fexpr__78911.cljs$core$IFn$_invoke$arity$1 ? fexpr__78911.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78911.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79587)){
var error__42952__auto___79588 = temp__5753__auto___79587;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79588], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78883_79566,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79588], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema78883_79566,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78884_79567], null)));

var ufv___79591 = schema.utils.use_fn_validation;
var output_schema78912_79592 = schema.core.Keyword;
var input_schema78913_79593 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker78914_79594 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema78913_79593);
}),null));
var output_checker78915_79595 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema78912_79592);
}),null));
var ret__47899__auto___79596 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__78916){
var validate__42950__auto__ = cljs.core.deref(ufv___79591);
if(cljs.core.truth_(validate__42950__auto__)){
var args__42951__auto___79597 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__78916], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78917_79598 = new cljs.core.Keyword(null,"input","input",556931961);
var G__78918_79599 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__78919_79600 = input_schema78913_79593;
var G__78920_79601 = cljs.core.deref(input_checker78914_79594);
var G__78921_79602 = args__42951__auto___79597;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78917_79598,G__78918_79599,G__78919_79600,G__78920_79601,G__78921_79602) : schema.core.fn_validator.call(null,G__78917_79598,G__78918_79599,G__78919_79600,G__78920_79601,G__78921_79602));
} else {
var temp__5753__auto___79603 = (function (){var fexpr__78924 = cljs.core.deref(input_checker78914_79594);
return (fexpr__78924.cljs$core$IFn$_invoke$arity$1 ? fexpr__78924.cljs$core$IFn$_invoke$arity$1(args__42951__auto___79597) : fexpr__78924.call(null,args__42951__auto___79597));
})();
if(cljs.core.truth_(temp__5753__auto___79603)){
var error__42952__auto___79605 = temp__5753__auto___79603;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79605], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema78913_79593,new cljs.core.Keyword(null,"value","value",305978217),args__42951__auto___79597,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79605], null));
} else {
}
}
} else {
}

var o__42953__auto__ = (function (){var schema__$1 = G__78916;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__42950__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__78929_79607 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__78930_79608 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__78931_79609 = output_schema78912_79592;
var G__78932_79610 = cljs.core.deref(output_checker78915_79595);
var G__78933_79611 = o__42953__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__78929_79607,G__78930_79608,G__78931_79609,G__78932_79610,G__78933_79611) : schema.core.fn_validator.call(null,G__78929_79607,G__78930_79608,G__78931_79609,G__78932_79610,G__78933_79611));
} else {
var temp__5753__auto___79612 = (function (){var fexpr__78934 = cljs.core.deref(output_checker78915_79595);
return (fexpr__78934.cljs$core$IFn$_invoke$arity$1 ? fexpr__78934.cljs$core$IFn$_invoke$arity$1(o__42953__auto__) : fexpr__78934.call(null,o__42953__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___79612)){
var error__42952__auto___79613 = temp__5753__auto___79612;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__42952__auto___79613], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema78912_79592,new cljs.core.Keyword(null,"value","value",305978217),o__42953__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__42952__auto___79613], null));
} else {
}
}
} else {
}

return o__42953__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema78912_79592,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema78913_79593], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
