goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_72117 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_72117(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_72131 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_72131(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__70305 = coll;
var G__70306 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__70305,G__70306) : shadow.dom.lazy_native_coll_seq.call(null,G__70305,G__70306));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__70322 = arguments.length;
switch (G__70322) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__70351 = arguments.length;
switch (G__70351) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__70364 = arguments.length;
switch (G__70364) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__70377 = arguments.length;
switch (G__70377) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__70411 = arguments.length;
switch (G__70411) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__70439 = arguments.length;
switch (G__70439) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e70469){if((e70469 instanceof Object)){
var e = e70469;
return console.log("didnt support attachEvent",el,e);
} else {
throw e70469;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__70500 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__70501 = null;
var count__70502 = (0);
var i__70503 = (0);
while(true){
if((i__70503 < count__70502)){
var el = chunk__70501.cljs$core$IIndexed$_nth$arity$2(null,i__70503);
var handler_72262__$1 = ((function (seq__70500,chunk__70501,count__70502,i__70503,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__70500,chunk__70501,count__70502,i__70503,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_72262__$1);


var G__72263 = seq__70500;
var G__72264 = chunk__70501;
var G__72265 = count__70502;
var G__72266 = (i__70503 + (1));
seq__70500 = G__72263;
chunk__70501 = G__72264;
count__70502 = G__72265;
i__70503 = G__72266;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__70500);
if(temp__5753__auto__){
var seq__70500__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__70500__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__70500__$1);
var G__72269 = cljs.core.chunk_rest(seq__70500__$1);
var G__72270 = c__4679__auto__;
var G__72271 = cljs.core.count(c__4679__auto__);
var G__72272 = (0);
seq__70500 = G__72269;
chunk__70501 = G__72270;
count__70502 = G__72271;
i__70503 = G__72272;
continue;
} else {
var el = cljs.core.first(seq__70500__$1);
var handler_72280__$1 = ((function (seq__70500,chunk__70501,count__70502,i__70503,el,seq__70500__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__70500,chunk__70501,count__70502,i__70503,el,seq__70500__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_72280__$1);


var G__72282 = cljs.core.next(seq__70500__$1);
var G__72283 = null;
var G__72284 = (0);
var G__72285 = (0);
seq__70500 = G__72282;
chunk__70501 = G__72283;
count__70502 = G__72284;
i__70503 = G__72285;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__70560 = arguments.length;
switch (G__70560) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__70587 = cljs.core.seq(events);
var chunk__70588 = null;
var count__70589 = (0);
var i__70590 = (0);
while(true){
if((i__70590 < count__70589)){
var vec__70603 = chunk__70588.cljs$core$IIndexed$_nth$arity$2(null,i__70590);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70603,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70603,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__72315 = seq__70587;
var G__72316 = chunk__70588;
var G__72317 = count__70589;
var G__72318 = (i__70590 + (1));
seq__70587 = G__72315;
chunk__70588 = G__72316;
count__70589 = G__72317;
i__70590 = G__72318;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__70587);
if(temp__5753__auto__){
var seq__70587__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__70587__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__70587__$1);
var G__72321 = cljs.core.chunk_rest(seq__70587__$1);
var G__72322 = c__4679__auto__;
var G__72323 = cljs.core.count(c__4679__auto__);
var G__72324 = (0);
seq__70587 = G__72321;
chunk__70588 = G__72322;
count__70589 = G__72323;
i__70590 = G__72324;
continue;
} else {
var vec__70611 = cljs.core.first(seq__70587__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70611,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70611,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__72327 = cljs.core.next(seq__70587__$1);
var G__72328 = null;
var G__72329 = (0);
var G__72330 = (0);
seq__70587 = G__72327;
chunk__70588 = G__72328;
count__70589 = G__72329;
i__70590 = G__72330;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__70616 = cljs.core.seq(styles);
var chunk__70617 = null;
var count__70618 = (0);
var i__70619 = (0);
while(true){
if((i__70619 < count__70618)){
var vec__70637 = chunk__70617.cljs$core$IIndexed$_nth$arity$2(null,i__70619);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70637,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70637,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__72337 = seq__70616;
var G__72338 = chunk__70617;
var G__72339 = count__70618;
var G__72340 = (i__70619 + (1));
seq__70616 = G__72337;
chunk__70617 = G__72338;
count__70618 = G__72339;
i__70619 = G__72340;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__70616);
if(temp__5753__auto__){
var seq__70616__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__70616__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__70616__$1);
var G__72342 = cljs.core.chunk_rest(seq__70616__$1);
var G__72343 = c__4679__auto__;
var G__72344 = cljs.core.count(c__4679__auto__);
var G__72345 = (0);
seq__70616 = G__72342;
chunk__70617 = G__72343;
count__70618 = G__72344;
i__70619 = G__72345;
continue;
} else {
var vec__70653 = cljs.core.first(seq__70616__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70653,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70653,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__72346 = cljs.core.next(seq__70616__$1);
var G__72347 = null;
var G__72348 = (0);
var G__72349 = (0);
seq__70616 = G__72346;
chunk__70617 = G__72347;
count__70618 = G__72348;
i__70619 = G__72349;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__70670_72350 = key;
var G__70670_72351__$1 = (((G__70670_72350 instanceof cljs.core.Keyword))?G__70670_72350.fqn:null);
switch (G__70670_72351__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_72353 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_72353,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_72353,"aria-");
}
})())){
el.setAttribute(ks_72353,value);
} else {
(el[ks_72353] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__70713){
var map__70716 = p__70713;
var map__70716__$1 = cljs.core.__destructure_map(map__70716);
var props = map__70716__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70716__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__70722 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70722,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70722,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70722,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__70727 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__70727,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__70727;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__70738 = arguments.length;
switch (G__70738) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__70765){
var vec__70767 = p__70765;
var seq__70768 = cljs.core.seq(vec__70767);
var first__70769 = cljs.core.first(seq__70768);
var seq__70768__$1 = cljs.core.next(seq__70768);
var nn = first__70769;
var first__70769__$1 = cljs.core.first(seq__70768__$1);
var seq__70768__$2 = cljs.core.next(seq__70768__$1);
var np = first__70769__$1;
var nc = seq__70768__$2;
var node = vec__70767;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__70772 = nn;
var G__70773 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__70772,G__70773) : create_fn.call(null,G__70772,G__70773));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__70775 = nn;
var G__70776 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__70775,G__70776) : create_fn.call(null,G__70775,G__70776));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__70781 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70781,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70781,(1),null);
var seq__70785_72447 = cljs.core.seq(node_children);
var chunk__70786_72448 = null;
var count__70787_72449 = (0);
var i__70788_72450 = (0);
while(true){
if((i__70788_72450 < count__70787_72449)){
var child_struct_72451 = chunk__70786_72448.cljs$core$IIndexed$_nth$arity$2(null,i__70788_72450);
var children_72456 = shadow.dom.dom_node(child_struct_72451);
if(cljs.core.seq_QMARK_(children_72456)){
var seq__70846_72457 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_72456));
var chunk__70848_72458 = null;
var count__70849_72459 = (0);
var i__70850_72460 = (0);
while(true){
if((i__70850_72460 < count__70849_72459)){
var child_72465 = chunk__70848_72458.cljs$core$IIndexed$_nth$arity$2(null,i__70850_72460);
if(cljs.core.truth_(child_72465)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_72465);


var G__72467 = seq__70846_72457;
var G__72469 = chunk__70848_72458;
var G__72471 = count__70849_72459;
var G__72473 = (i__70850_72460 + (1));
seq__70846_72457 = G__72467;
chunk__70848_72458 = G__72469;
count__70849_72459 = G__72471;
i__70850_72460 = G__72473;
continue;
} else {
var G__72474 = seq__70846_72457;
var G__72475 = chunk__70848_72458;
var G__72476 = count__70849_72459;
var G__72477 = (i__70850_72460 + (1));
seq__70846_72457 = G__72474;
chunk__70848_72458 = G__72475;
count__70849_72459 = G__72476;
i__70850_72460 = G__72477;
continue;
}
} else {
var temp__5753__auto___72479 = cljs.core.seq(seq__70846_72457);
if(temp__5753__auto___72479){
var seq__70846_72480__$1 = temp__5753__auto___72479;
if(cljs.core.chunked_seq_QMARK_(seq__70846_72480__$1)){
var c__4679__auto___72481 = cljs.core.chunk_first(seq__70846_72480__$1);
var G__72482 = cljs.core.chunk_rest(seq__70846_72480__$1);
var G__72483 = c__4679__auto___72481;
var G__72484 = cljs.core.count(c__4679__auto___72481);
var G__72485 = (0);
seq__70846_72457 = G__72482;
chunk__70848_72458 = G__72483;
count__70849_72459 = G__72484;
i__70850_72460 = G__72485;
continue;
} else {
var child_72486 = cljs.core.first(seq__70846_72480__$1);
if(cljs.core.truth_(child_72486)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_72486);


var G__72488 = cljs.core.next(seq__70846_72480__$1);
var G__72489 = null;
var G__72490 = (0);
var G__72491 = (0);
seq__70846_72457 = G__72488;
chunk__70848_72458 = G__72489;
count__70849_72459 = G__72490;
i__70850_72460 = G__72491;
continue;
} else {
var G__72492 = cljs.core.next(seq__70846_72480__$1);
var G__72493 = null;
var G__72494 = (0);
var G__72495 = (0);
seq__70846_72457 = G__72492;
chunk__70848_72458 = G__72493;
count__70849_72459 = G__72494;
i__70850_72460 = G__72495;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_72456);
}


var G__72496 = seq__70785_72447;
var G__72497 = chunk__70786_72448;
var G__72498 = count__70787_72449;
var G__72499 = (i__70788_72450 + (1));
seq__70785_72447 = G__72496;
chunk__70786_72448 = G__72497;
count__70787_72449 = G__72498;
i__70788_72450 = G__72499;
continue;
} else {
var temp__5753__auto___72503 = cljs.core.seq(seq__70785_72447);
if(temp__5753__auto___72503){
var seq__70785_72504__$1 = temp__5753__auto___72503;
if(cljs.core.chunked_seq_QMARK_(seq__70785_72504__$1)){
var c__4679__auto___72507 = cljs.core.chunk_first(seq__70785_72504__$1);
var G__72508 = cljs.core.chunk_rest(seq__70785_72504__$1);
var G__72509 = c__4679__auto___72507;
var G__72510 = cljs.core.count(c__4679__auto___72507);
var G__72511 = (0);
seq__70785_72447 = G__72508;
chunk__70786_72448 = G__72509;
count__70787_72449 = G__72510;
i__70788_72450 = G__72511;
continue;
} else {
var child_struct_72512 = cljs.core.first(seq__70785_72504__$1);
var children_72513 = shadow.dom.dom_node(child_struct_72512);
if(cljs.core.seq_QMARK_(children_72513)){
var seq__70896_72514 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_72513));
var chunk__70898_72515 = null;
var count__70899_72516 = (0);
var i__70900_72517 = (0);
while(true){
if((i__70900_72517 < count__70899_72516)){
var child_72520 = chunk__70898_72515.cljs$core$IIndexed$_nth$arity$2(null,i__70900_72517);
if(cljs.core.truth_(child_72520)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_72520);


var G__72525 = seq__70896_72514;
var G__72526 = chunk__70898_72515;
var G__72527 = count__70899_72516;
var G__72528 = (i__70900_72517 + (1));
seq__70896_72514 = G__72525;
chunk__70898_72515 = G__72526;
count__70899_72516 = G__72527;
i__70900_72517 = G__72528;
continue;
} else {
var G__72529 = seq__70896_72514;
var G__72530 = chunk__70898_72515;
var G__72531 = count__70899_72516;
var G__72532 = (i__70900_72517 + (1));
seq__70896_72514 = G__72529;
chunk__70898_72515 = G__72530;
count__70899_72516 = G__72531;
i__70900_72517 = G__72532;
continue;
}
} else {
var temp__5753__auto___72533__$1 = cljs.core.seq(seq__70896_72514);
if(temp__5753__auto___72533__$1){
var seq__70896_72534__$1 = temp__5753__auto___72533__$1;
if(cljs.core.chunked_seq_QMARK_(seq__70896_72534__$1)){
var c__4679__auto___72535 = cljs.core.chunk_first(seq__70896_72534__$1);
var G__72536 = cljs.core.chunk_rest(seq__70896_72534__$1);
var G__72537 = c__4679__auto___72535;
var G__72538 = cljs.core.count(c__4679__auto___72535);
var G__72539 = (0);
seq__70896_72514 = G__72536;
chunk__70898_72515 = G__72537;
count__70899_72516 = G__72538;
i__70900_72517 = G__72539;
continue;
} else {
var child_72540 = cljs.core.first(seq__70896_72534__$1);
if(cljs.core.truth_(child_72540)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_72540);


var G__72542 = cljs.core.next(seq__70896_72534__$1);
var G__72543 = null;
var G__72544 = (0);
var G__72545 = (0);
seq__70896_72514 = G__72542;
chunk__70898_72515 = G__72543;
count__70899_72516 = G__72544;
i__70900_72517 = G__72545;
continue;
} else {
var G__72546 = cljs.core.next(seq__70896_72534__$1);
var G__72547 = null;
var G__72548 = (0);
var G__72549 = (0);
seq__70896_72514 = G__72546;
chunk__70898_72515 = G__72547;
count__70899_72516 = G__72548;
i__70900_72517 = G__72549;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_72513);
}


var G__72550 = cljs.core.next(seq__70785_72504__$1);
var G__72551 = null;
var G__72552 = (0);
var G__72553 = (0);
seq__70785_72447 = G__72550;
chunk__70786_72448 = G__72551;
count__70787_72449 = G__72552;
i__70788_72450 = G__72553;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__71006 = cljs.core.seq(node);
var chunk__71007 = null;
var count__71008 = (0);
var i__71009 = (0);
while(true){
if((i__71009 < count__71008)){
var n = chunk__71007.cljs$core$IIndexed$_nth$arity$2(null,i__71009);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__72560 = seq__71006;
var G__72561 = chunk__71007;
var G__72562 = count__71008;
var G__72563 = (i__71009 + (1));
seq__71006 = G__72560;
chunk__71007 = G__72561;
count__71008 = G__72562;
i__71009 = G__72563;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__71006);
if(temp__5753__auto__){
var seq__71006__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__71006__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__71006__$1);
var G__72565 = cljs.core.chunk_rest(seq__71006__$1);
var G__72566 = c__4679__auto__;
var G__72567 = cljs.core.count(c__4679__auto__);
var G__72568 = (0);
seq__71006 = G__72565;
chunk__71007 = G__72566;
count__71008 = G__72567;
i__71009 = G__72568;
continue;
} else {
var n = cljs.core.first(seq__71006__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__72573 = cljs.core.next(seq__71006__$1);
var G__72574 = null;
var G__72575 = (0);
var G__72576 = (0);
seq__71006 = G__72573;
chunk__71007 = G__72574;
count__71008 = G__72575;
i__71009 = G__72576;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__71059 = arguments.length;
switch (G__71059) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__71082 = arguments.length;
switch (G__71082) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__71112 = arguments.length;
switch (G__71112) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72588 = arguments.length;
var i__4865__auto___72589 = (0);
while(true){
if((i__4865__auto___72589 < len__4864__auto___72588)){
args__4870__auto__.push((arguments[i__4865__auto___72589]));

var G__72590 = (i__4865__auto___72589 + (1));
i__4865__auto___72589 = G__72590;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__71194_72594 = cljs.core.seq(nodes);
var chunk__71196_72595 = null;
var count__71197_72596 = (0);
var i__71198_72597 = (0);
while(true){
if((i__71198_72597 < count__71197_72596)){
var node_72598 = chunk__71196_72595.cljs$core$IIndexed$_nth$arity$2(null,i__71198_72597);
fragment.appendChild(shadow.dom._to_dom(node_72598));


var G__72599 = seq__71194_72594;
var G__72600 = chunk__71196_72595;
var G__72601 = count__71197_72596;
var G__72602 = (i__71198_72597 + (1));
seq__71194_72594 = G__72599;
chunk__71196_72595 = G__72600;
count__71197_72596 = G__72601;
i__71198_72597 = G__72602;
continue;
} else {
var temp__5753__auto___72603 = cljs.core.seq(seq__71194_72594);
if(temp__5753__auto___72603){
var seq__71194_72605__$1 = temp__5753__auto___72603;
if(cljs.core.chunked_seq_QMARK_(seq__71194_72605__$1)){
var c__4679__auto___72606 = cljs.core.chunk_first(seq__71194_72605__$1);
var G__72607 = cljs.core.chunk_rest(seq__71194_72605__$1);
var G__72608 = c__4679__auto___72606;
var G__72609 = cljs.core.count(c__4679__auto___72606);
var G__72610 = (0);
seq__71194_72594 = G__72607;
chunk__71196_72595 = G__72608;
count__71197_72596 = G__72609;
i__71198_72597 = G__72610;
continue;
} else {
var node_72611 = cljs.core.first(seq__71194_72605__$1);
fragment.appendChild(shadow.dom._to_dom(node_72611));


var G__72612 = cljs.core.next(seq__71194_72605__$1);
var G__72613 = null;
var G__72614 = (0);
var G__72615 = (0);
seq__71194_72594 = G__72612;
chunk__71196_72595 = G__72613;
count__71197_72596 = G__72614;
i__71198_72597 = G__72615;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq71171){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq71171));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__71280_72617 = cljs.core.seq(scripts);
var chunk__71281_72618 = null;
var count__71282_72619 = (0);
var i__71283_72620 = (0);
while(true){
if((i__71283_72620 < count__71282_72619)){
var vec__71311_72621 = chunk__71281_72618.cljs$core$IIndexed$_nth$arity$2(null,i__71283_72620);
var script_tag_72622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71311_72621,(0),null);
var script_body_72623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71311_72621,(1),null);
eval(script_body_72623);


var G__72624 = seq__71280_72617;
var G__72625 = chunk__71281_72618;
var G__72626 = count__71282_72619;
var G__72627 = (i__71283_72620 + (1));
seq__71280_72617 = G__72624;
chunk__71281_72618 = G__72625;
count__71282_72619 = G__72626;
i__71283_72620 = G__72627;
continue;
} else {
var temp__5753__auto___72629 = cljs.core.seq(seq__71280_72617);
if(temp__5753__auto___72629){
var seq__71280_72630__$1 = temp__5753__auto___72629;
if(cljs.core.chunked_seq_QMARK_(seq__71280_72630__$1)){
var c__4679__auto___72631 = cljs.core.chunk_first(seq__71280_72630__$1);
var G__72632 = cljs.core.chunk_rest(seq__71280_72630__$1);
var G__72633 = c__4679__auto___72631;
var G__72634 = cljs.core.count(c__4679__auto___72631);
var G__72635 = (0);
seq__71280_72617 = G__72632;
chunk__71281_72618 = G__72633;
count__71282_72619 = G__72634;
i__71283_72620 = G__72635;
continue;
} else {
var vec__71323_72636 = cljs.core.first(seq__71280_72630__$1);
var script_tag_72637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71323_72636,(0),null);
var script_body_72638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71323_72636,(1),null);
eval(script_body_72638);


var G__72640 = cljs.core.next(seq__71280_72630__$1);
var G__72641 = null;
var G__72642 = (0);
var G__72643 = (0);
seq__71280_72617 = G__72640;
chunk__71281_72618 = G__72641;
count__71282_72619 = G__72642;
i__71283_72620 = G__72643;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__71334){
var vec__71336 = p__71334;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71336,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71336,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__71383 = arguments.length;
switch (G__71383) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__71423 = cljs.core.seq(style_keys);
var chunk__71424 = null;
var count__71425 = (0);
var i__71426 = (0);
while(true){
if((i__71426 < count__71425)){
var it = chunk__71424.cljs$core$IIndexed$_nth$arity$2(null,i__71426);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__72663 = seq__71423;
var G__72664 = chunk__71424;
var G__72665 = count__71425;
var G__72666 = (i__71426 + (1));
seq__71423 = G__72663;
chunk__71424 = G__72664;
count__71425 = G__72665;
i__71426 = G__72666;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__71423);
if(temp__5753__auto__){
var seq__71423__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__71423__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__71423__$1);
var G__72667 = cljs.core.chunk_rest(seq__71423__$1);
var G__72668 = c__4679__auto__;
var G__72669 = cljs.core.count(c__4679__auto__);
var G__72670 = (0);
seq__71423 = G__72667;
chunk__71424 = G__72668;
count__71425 = G__72669;
i__71426 = G__72670;
continue;
} else {
var it = cljs.core.first(seq__71423__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__72672 = cljs.core.next(seq__71423__$1);
var G__72673 = null;
var G__72674 = (0);
var G__72675 = (0);
seq__71423 = G__72672;
chunk__71424 = G__72673;
count__71425 = G__72674;
i__71426 = G__72675;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k71444,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__71460 = k71444;
var G__71460__$1 = (((G__71460 instanceof cljs.core.Keyword))?G__71460.fqn:null);
switch (G__71460__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k71444,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__71466){
var vec__71468 = p__71466;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71468,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71468,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71443){
var self__ = this;
var G__71443__$1 = this;
return (new cljs.core.RecordIter((0),G__71443__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71445,other71446){
var self__ = this;
var this71445__$1 = this;
return (((!((other71446 == null)))) && ((((this71445__$1.constructor === other71446.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71445__$1.x,other71446.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71445__$1.y,other71446.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71445__$1.__extmap,other71446.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k71444){
var self__ = this;
var this__4509__auto____$1 = this;
var G__71496 = k71444;
var G__71496__$1 = (((G__71496 instanceof cljs.core.Keyword))?G__71496.fqn:null);
switch (G__71496__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k71444);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__71443){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__71497 = cljs.core.keyword_identical_QMARK_;
var expr__71498 = k__4511__auto__;
if(cljs.core.truth_((pred__71497.cljs$core$IFn$_invoke$arity$2 ? pred__71497.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__71498) : pred__71497.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__71498)))){
return (new shadow.dom.Coordinate(G__71443,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__71497.cljs$core$IFn$_invoke$arity$2 ? pred__71497.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__71498) : pred__71497.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__71498)))){
return (new shadow.dom.Coordinate(self__.x,G__71443,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__71443),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__71443){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__71443,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__71450){
var extmap__4542__auto__ = (function (){var G__71521 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__71450,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__71450)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__71521);
} else {
return G__71521;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__71450),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__71450),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k71534,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__71543 = k71534;
var G__71543__$1 = (((G__71543 instanceof cljs.core.Keyword))?G__71543.fqn:null);
switch (G__71543__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k71534,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__71555){
var vec__71556 = p__71555;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71556,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71556,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71533){
var self__ = this;
var G__71533__$1 = this;
return (new cljs.core.RecordIter((0),G__71533__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71536,other71537){
var self__ = this;
var this71536__$1 = this;
return (((!((other71537 == null)))) && ((((this71536__$1.constructor === other71537.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71536__$1.w,other71537.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71536__$1.h,other71537.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this71536__$1.__extmap,other71537.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k71534){
var self__ = this;
var this__4509__auto____$1 = this;
var G__71598 = k71534;
var G__71598__$1 = (((G__71598 instanceof cljs.core.Keyword))?G__71598.fqn:null);
switch (G__71598__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k71534);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__71533){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__71605 = cljs.core.keyword_identical_QMARK_;
var expr__71606 = k__4511__auto__;
if(cljs.core.truth_((pred__71605.cljs$core$IFn$_invoke$arity$2 ? pred__71605.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__71606) : pred__71605.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__71606)))){
return (new shadow.dom.Size(G__71533,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__71605.cljs$core$IFn$_invoke$arity$2 ? pred__71605.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__71606) : pred__71605.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__71606)))){
return (new shadow.dom.Size(self__.w,G__71533,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__71533),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__71533){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__71533,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__71540){
var extmap__4542__auto__ = (function (){var G__71645 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__71540,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__71540)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__71645);
} else {
return G__71645;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__71540),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__71540),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__72737 = (i + (1));
var G__72738 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__72737;
ret = G__72738;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__71705){
var vec__71711 = p__71705;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71711,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71711,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__71733 = arguments.length;
switch (G__71733) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__72748 = ps;
var G__72749 = (i + (1));
el__$1 = G__72748;
i = G__72749;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__71800 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71800,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71800,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71800,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__71806_72757 = cljs.core.seq(props);
var chunk__71807_72758 = null;
var count__71808_72759 = (0);
var i__71809_72760 = (0);
while(true){
if((i__71809_72760 < count__71808_72759)){
var vec__71827_72761 = chunk__71807_72758.cljs$core$IIndexed$_nth$arity$2(null,i__71809_72760);
var k_72762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71827_72761,(0),null);
var v_72763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71827_72761,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_72762);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_72762),v_72763);


var G__72765 = seq__71806_72757;
var G__72767 = chunk__71807_72758;
var G__72768 = count__71808_72759;
var G__72769 = (i__71809_72760 + (1));
seq__71806_72757 = G__72765;
chunk__71807_72758 = G__72767;
count__71808_72759 = G__72768;
i__71809_72760 = G__72769;
continue;
} else {
var temp__5753__auto___72770 = cljs.core.seq(seq__71806_72757);
if(temp__5753__auto___72770){
var seq__71806_72771__$1 = temp__5753__auto___72770;
if(cljs.core.chunked_seq_QMARK_(seq__71806_72771__$1)){
var c__4679__auto___72772 = cljs.core.chunk_first(seq__71806_72771__$1);
var G__72773 = cljs.core.chunk_rest(seq__71806_72771__$1);
var G__72774 = c__4679__auto___72772;
var G__72775 = cljs.core.count(c__4679__auto___72772);
var G__72776 = (0);
seq__71806_72757 = G__72773;
chunk__71807_72758 = G__72774;
count__71808_72759 = G__72775;
i__71809_72760 = G__72776;
continue;
} else {
var vec__71844_72777 = cljs.core.first(seq__71806_72771__$1);
var k_72778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71844_72777,(0),null);
var v_72779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71844_72777,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_72778);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_72778),v_72779);


var G__72780 = cljs.core.next(seq__71806_72771__$1);
var G__72781 = null;
var G__72782 = (0);
var G__72783 = (0);
seq__71806_72757 = G__72780;
chunk__71807_72758 = G__72781;
count__71808_72759 = G__72782;
i__71809_72760 = G__72783;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__71862 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71862,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71862,(1),null);
var seq__71866_72784 = cljs.core.seq(node_children);
var chunk__71869_72785 = null;
var count__71870_72786 = (0);
var i__71871_72787 = (0);
while(true){
if((i__71871_72787 < count__71870_72786)){
var child_struct_72792 = chunk__71869_72785.cljs$core$IIndexed$_nth$arity$2(null,i__71871_72787);
if((!((child_struct_72792 == null)))){
if(typeof child_struct_72792 === 'string'){
var text_72794 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_72794),child_struct_72792].join(''));
} else {
var children_72795 = shadow.dom.svg_node(child_struct_72792);
if(cljs.core.seq_QMARK_(children_72795)){
var seq__71916_72796 = cljs.core.seq(children_72795);
var chunk__71918_72797 = null;
var count__71919_72798 = (0);
var i__71920_72799 = (0);
while(true){
if((i__71920_72799 < count__71919_72798)){
var child_72800 = chunk__71918_72797.cljs$core$IIndexed$_nth$arity$2(null,i__71920_72799);
if(cljs.core.truth_(child_72800)){
node.appendChild(child_72800);


var G__72801 = seq__71916_72796;
var G__72802 = chunk__71918_72797;
var G__72803 = count__71919_72798;
var G__72804 = (i__71920_72799 + (1));
seq__71916_72796 = G__72801;
chunk__71918_72797 = G__72802;
count__71919_72798 = G__72803;
i__71920_72799 = G__72804;
continue;
} else {
var G__72805 = seq__71916_72796;
var G__72806 = chunk__71918_72797;
var G__72807 = count__71919_72798;
var G__72808 = (i__71920_72799 + (1));
seq__71916_72796 = G__72805;
chunk__71918_72797 = G__72806;
count__71919_72798 = G__72807;
i__71920_72799 = G__72808;
continue;
}
} else {
var temp__5753__auto___72809 = cljs.core.seq(seq__71916_72796);
if(temp__5753__auto___72809){
var seq__71916_72810__$1 = temp__5753__auto___72809;
if(cljs.core.chunked_seq_QMARK_(seq__71916_72810__$1)){
var c__4679__auto___72811 = cljs.core.chunk_first(seq__71916_72810__$1);
var G__72812 = cljs.core.chunk_rest(seq__71916_72810__$1);
var G__72813 = c__4679__auto___72811;
var G__72814 = cljs.core.count(c__4679__auto___72811);
var G__72815 = (0);
seq__71916_72796 = G__72812;
chunk__71918_72797 = G__72813;
count__71919_72798 = G__72814;
i__71920_72799 = G__72815;
continue;
} else {
var child_72816 = cljs.core.first(seq__71916_72810__$1);
if(cljs.core.truth_(child_72816)){
node.appendChild(child_72816);


var G__72818 = cljs.core.next(seq__71916_72810__$1);
var G__72819 = null;
var G__72820 = (0);
var G__72821 = (0);
seq__71916_72796 = G__72818;
chunk__71918_72797 = G__72819;
count__71919_72798 = G__72820;
i__71920_72799 = G__72821;
continue;
} else {
var G__72823 = cljs.core.next(seq__71916_72810__$1);
var G__72824 = null;
var G__72825 = (0);
var G__72826 = (0);
seq__71916_72796 = G__72823;
chunk__71918_72797 = G__72824;
count__71919_72798 = G__72825;
i__71920_72799 = G__72826;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_72795);
}
}


var G__72827 = seq__71866_72784;
var G__72828 = chunk__71869_72785;
var G__72829 = count__71870_72786;
var G__72830 = (i__71871_72787 + (1));
seq__71866_72784 = G__72827;
chunk__71869_72785 = G__72828;
count__71870_72786 = G__72829;
i__71871_72787 = G__72830;
continue;
} else {
var G__72831 = seq__71866_72784;
var G__72832 = chunk__71869_72785;
var G__72833 = count__71870_72786;
var G__72834 = (i__71871_72787 + (1));
seq__71866_72784 = G__72831;
chunk__71869_72785 = G__72832;
count__71870_72786 = G__72833;
i__71871_72787 = G__72834;
continue;
}
} else {
var temp__5753__auto___72835 = cljs.core.seq(seq__71866_72784);
if(temp__5753__auto___72835){
var seq__71866_72836__$1 = temp__5753__auto___72835;
if(cljs.core.chunked_seq_QMARK_(seq__71866_72836__$1)){
var c__4679__auto___72838 = cljs.core.chunk_first(seq__71866_72836__$1);
var G__72839 = cljs.core.chunk_rest(seq__71866_72836__$1);
var G__72840 = c__4679__auto___72838;
var G__72841 = cljs.core.count(c__4679__auto___72838);
var G__72842 = (0);
seq__71866_72784 = G__72839;
chunk__71869_72785 = G__72840;
count__71870_72786 = G__72841;
i__71871_72787 = G__72842;
continue;
} else {
var child_struct_72844 = cljs.core.first(seq__71866_72836__$1);
if((!((child_struct_72844 == null)))){
if(typeof child_struct_72844 === 'string'){
var text_72845 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_72845),child_struct_72844].join(''));
} else {
var children_72846 = shadow.dom.svg_node(child_struct_72844);
if(cljs.core.seq_QMARK_(children_72846)){
var seq__71929_72847 = cljs.core.seq(children_72846);
var chunk__71931_72848 = null;
var count__71932_72849 = (0);
var i__71933_72850 = (0);
while(true){
if((i__71933_72850 < count__71932_72849)){
var child_72851 = chunk__71931_72848.cljs$core$IIndexed$_nth$arity$2(null,i__71933_72850);
if(cljs.core.truth_(child_72851)){
node.appendChild(child_72851);


var G__72853 = seq__71929_72847;
var G__72854 = chunk__71931_72848;
var G__72855 = count__71932_72849;
var G__72856 = (i__71933_72850 + (1));
seq__71929_72847 = G__72853;
chunk__71931_72848 = G__72854;
count__71932_72849 = G__72855;
i__71933_72850 = G__72856;
continue;
} else {
var G__72857 = seq__71929_72847;
var G__72858 = chunk__71931_72848;
var G__72859 = count__71932_72849;
var G__72860 = (i__71933_72850 + (1));
seq__71929_72847 = G__72857;
chunk__71931_72848 = G__72858;
count__71932_72849 = G__72859;
i__71933_72850 = G__72860;
continue;
}
} else {
var temp__5753__auto___72862__$1 = cljs.core.seq(seq__71929_72847);
if(temp__5753__auto___72862__$1){
var seq__71929_72863__$1 = temp__5753__auto___72862__$1;
if(cljs.core.chunked_seq_QMARK_(seq__71929_72863__$1)){
var c__4679__auto___72864 = cljs.core.chunk_first(seq__71929_72863__$1);
var G__72865 = cljs.core.chunk_rest(seq__71929_72863__$1);
var G__72866 = c__4679__auto___72864;
var G__72867 = cljs.core.count(c__4679__auto___72864);
var G__72868 = (0);
seq__71929_72847 = G__72865;
chunk__71931_72848 = G__72866;
count__71932_72849 = G__72867;
i__71933_72850 = G__72868;
continue;
} else {
var child_72869 = cljs.core.first(seq__71929_72863__$1);
if(cljs.core.truth_(child_72869)){
node.appendChild(child_72869);


var G__72870 = cljs.core.next(seq__71929_72863__$1);
var G__72871 = null;
var G__72872 = (0);
var G__72873 = (0);
seq__71929_72847 = G__72870;
chunk__71931_72848 = G__72871;
count__71932_72849 = G__72872;
i__71933_72850 = G__72873;
continue;
} else {
var G__72874 = cljs.core.next(seq__71929_72863__$1);
var G__72875 = null;
var G__72876 = (0);
var G__72877 = (0);
seq__71929_72847 = G__72874;
chunk__71931_72848 = G__72875;
count__71932_72849 = G__72876;
i__71933_72850 = G__72877;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_72846);
}
}


var G__72878 = cljs.core.next(seq__71866_72836__$1);
var G__72879 = null;
var G__72880 = (0);
var G__72881 = (0);
seq__71866_72784 = G__72878;
chunk__71869_72785 = G__72879;
count__71870_72786 = G__72880;
i__71871_72787 = G__72881;
continue;
} else {
var G__72882 = cljs.core.next(seq__71866_72836__$1);
var G__72883 = null;
var G__72884 = (0);
var G__72885 = (0);
seq__71866_72784 = G__72882;
chunk__71869_72785 = G__72883;
count__71870_72786 = G__72884;
i__71871_72787 = G__72885;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72886 = arguments.length;
var i__4865__auto___72887 = (0);
while(true){
if((i__4865__auto___72887 < len__4864__auto___72886)){
args__4870__auto__.push((arguments[i__4865__auto___72887]));

var G__72889 = (i__4865__auto___72887 + (1));
i__4865__auto___72887 = G__72889;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq71966){
var G__71967 = cljs.core.first(seq71966);
var seq71966__$1 = cljs.core.next(seq71966);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71967,seq71966__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__71979 = arguments.length;
switch (G__71979) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__43278__auto___72899 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43279__auto__ = (function (){var switch__42014__auto__ = (function (state_71995){
var state_val_71996 = (state_71995[(1)]);
if((state_val_71996 === (1))){
var state_71995__$1 = state_71995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71995__$1,(2),once_or_cleanup);
} else {
if((state_val_71996 === (2))){
var inst_71991 = (state_71995[(2)]);
var inst_71993 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_71995__$1 = (function (){var statearr_72004 = state_71995;
(statearr_72004[(7)] = inst_71991);

return statearr_72004;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_71995__$1,inst_71993);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__42015__auto__ = null;
var shadow$dom$state_machine__42015__auto____0 = (function (){
var statearr_72008 = [null,null,null,null,null,null,null,null];
(statearr_72008[(0)] = shadow$dom$state_machine__42015__auto__);

(statearr_72008[(1)] = (1));

return statearr_72008;
});
var shadow$dom$state_machine__42015__auto____1 = (function (state_71995){
while(true){
var ret_value__42016__auto__ = (function (){try{while(true){
var result__42017__auto__ = switch__42014__auto__(state_71995);
if(cljs.core.keyword_identical_QMARK_(result__42017__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42017__auto__;
}
break;
}
}catch (e72009){var ex__42018__auto__ = e72009;
var statearr_72014_72902 = state_71995;
(statearr_72014_72902[(2)] = ex__42018__auto__);


if(cljs.core.seq((state_71995[(4)]))){
var statearr_72019_72903 = state_71995;
(statearr_72019_72903[(1)] = cljs.core.first((state_71995[(4)])));

} else {
throw ex__42018__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__42016__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72904 = state_71995;
state_71995 = G__72904;
continue;
} else {
return ret_value__42016__auto__;
}
break;
}
});
shadow$dom$state_machine__42015__auto__ = function(state_71995){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__42015__auto____0.call(this);
case 1:
return shadow$dom$state_machine__42015__auto____1.call(this,state_71995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__42015__auto____0;
shadow$dom$state_machine__42015__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__42015__auto____1;
return shadow$dom$state_machine__42015__auto__;
})()
})();
var state__43280__auto__ = (function (){var statearr_72024 = f__43279__auto__();
(statearr_72024[(6)] = c__43278__auto___72899);

return statearr_72024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43280__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
