goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___57691 = schema.utils.use_fn_validation;
var output_schema57242_57692 = schema.core.Bool;
var input_schema57243_57693 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker57244_57694 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57243_57693);
}),null));
var output_checker57245_57695 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57242_57692);
}),null));
var ret__54411__auto___57699 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__57246){
var validate__51657__auto__ = cljs.core.deref(ufv___57691);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57700 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57246], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57250_57701 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57251_57702 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__57252_57703 = input_schema57243_57693;
var G__57253_57704 = cljs.core.deref(input_checker57244_57694);
var G__57254_57705 = args__51658__auto___57700;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57250_57701,G__57251_57702,G__57252_57703,G__57253_57704,G__57254_57705) : schema.core.fn_validator.call(null,G__57250_57701,G__57251_57702,G__57252_57703,G__57253_57704,G__57254_57705));
} else {
var temp__5753__auto___57706 = (function (){var fexpr__57258 = cljs.core.deref(input_checker57244_57694);
return (fexpr__57258.cljs$core$IFn$_invoke$arity$1 ? fexpr__57258.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57700) : fexpr__57258.call(null,args__51658__auto___57700));
})();
if(cljs.core.truth_(temp__5753__auto___57706)){
var error__51659__auto___57707 = temp__5753__auto___57706;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57707], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57243_57693,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57700,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57707], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var arg = G__57246;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57259_57722 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57260_57723 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__57261_57724 = output_schema57242_57692;
var G__57262_57725 = cljs.core.deref(output_checker57245_57695);
var G__57263_57726 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57259_57722,G__57260_57723,G__57261_57724,G__57262_57725,G__57263_57726) : schema.core.fn_validator.call(null,G__57259_57722,G__57260_57723,G__57261_57724,G__57262_57725,G__57263_57726));
} else {
var temp__5753__auto___57727 = (function (){var fexpr__57264 = cljs.core.deref(output_checker57245_57695);
return (fexpr__57264.cljs$core$IFn$_invoke$arity$1 ? fexpr__57264.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57264.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57727)){
var error__51659__auto___57728 = temp__5753__auto___57727;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57728], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57242_57692,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57728], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema57242_57692,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57243_57693], null)));

var ufv___57729 = schema.utils.use_fn_validation;
var output_schema57266_57730 = deercreeklabs.baracus.ByteArray;
var input_schema57267_57731 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema57272_57732 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker57268_57733 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57267_57731);
}),null));
var output_checker57269_57734 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57266_57730);
}),null));
var input_checker57273_57735 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57272_57732);
}),null));
var output_checker57274_57736 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57266_57730);
}),null));
var ret__54411__auto___57737 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__57280 = arguments.length;
switch (G__57280) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__57270){
var validate__51657__auto__ = cljs.core.deref(ufv___57729);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57739 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57270], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57281_57740 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57282_57741 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__57283_57742 = input_schema57267_57731;
var G__57284_57743 = cljs.core.deref(input_checker57268_57733);
var G__57285_57744 = args__51658__auto___57739;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57281_57740,G__57282_57741,G__57283_57742,G__57284_57743,G__57285_57744) : schema.core.fn_validator.call(null,G__57281_57740,G__57282_57741,G__57283_57742,G__57284_57743,G__57285_57744));
} else {
var temp__5753__auto___57745 = (function (){var fexpr__57286 = cljs.core.deref(input_checker57268_57733);
return (fexpr__57286.cljs$core$IFn$_invoke$arity$1 ? fexpr__57286.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57739) : fexpr__57286.call(null,args__51658__auto___57739));
})();
if(cljs.core.truth_(temp__5753__auto___57745)){
var error__51659__auto___57746 = temp__5753__auto___57745;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57746], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57267_57731,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57739,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57746], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var size_or_seq = G__57270;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57289_57747 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57290_57748 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__57291_57749 = output_schema57266_57730;
var G__57292_57750 = cljs.core.deref(output_checker57269_57734);
var G__57293_57751 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57289_57747,G__57290_57748,G__57291_57749,G__57292_57750,G__57293_57751) : schema.core.fn_validator.call(null,G__57289_57747,G__57290_57748,G__57291_57749,G__57292_57750,G__57293_57751));
} else {
var temp__5753__auto___57752 = (function (){var fexpr__57294 = cljs.core.deref(output_checker57269_57734);
return (fexpr__57294.cljs$core$IFn$_invoke$arity$1 ? fexpr__57294.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57294.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57752)){
var error__51659__auto___57753 = temp__5753__auto___57752;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57753], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57266_57730,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57753], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__57275,G__57276){
var validate__51657__auto__ = cljs.core.deref(ufv___57729);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57754 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57275,G__57276], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57301_57755 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57302_57756 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__57303_57757 = input_schema57272_57732;
var G__57304_57758 = cljs.core.deref(input_checker57273_57735);
var G__57305_57759 = args__51658__auto___57754;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57301_57755,G__57302_57756,G__57303_57757,G__57304_57758,G__57305_57759) : schema.core.fn_validator.call(null,G__57301_57755,G__57302_57756,G__57303_57757,G__57304_57758,G__57305_57759));
} else {
var temp__5753__auto___57760 = (function (){var fexpr__57306 = cljs.core.deref(input_checker57273_57735);
return (fexpr__57306.cljs$core$IFn$_invoke$arity$1 ? fexpr__57306.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57754) : fexpr__57306.call(null,args__51658__auto___57754));
})();
if(cljs.core.truth_(temp__5753__auto___57760)){
var error__51659__auto___57761 = temp__5753__auto___57760;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57761], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57272_57732,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57754,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57761], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var size = G__57275;
var init_val_or_seq = G__57276;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57307_57762 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57308_57763 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__57309_57764 = output_schema57266_57730;
var G__57310_57765 = cljs.core.deref(output_checker57274_57736);
var G__57311_57766 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57307_57762,G__57308_57763,G__57309_57764,G__57310_57765,G__57311_57766) : schema.core.fn_validator.call(null,G__57307_57762,G__57308_57763,G__57309_57764,G__57310_57765,G__57311_57766));
} else {
var temp__5753__auto___57767 = (function (){var fexpr__57312 = cljs.core.deref(output_checker57274_57736);
return (fexpr__57312.cljs$core$IFn$_invoke$arity$1 ? fexpr__57312.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57312.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57767)){
var error__51659__auto___57768 = temp__5753__auto___57767;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57768], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57266_57730,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57768], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema57266_57730,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57267_57731,input_schema57272_57732], null)));

var ufv___57769 = schema.utils.use_fn_validation;
var output_schema57313_57770 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema57314_57771 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker57315_57772 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57314_57771);
}),null));
var output_checker57316_57773 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57313_57770);
}),null));
var ret__54411__auto___57774 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__57317){
var validate__51657__auto__ = cljs.core.deref(ufv___57769);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57775 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57317], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57321_57776 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57322_57777 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__57323_57778 = input_schema57314_57771;
var G__57324_57779 = cljs.core.deref(input_checker57315_57772);
var G__57325_57780 = args__51658__auto___57775;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57321_57776,G__57322_57777,G__57323_57778,G__57324_57779,G__57325_57780) : schema.core.fn_validator.call(null,G__57321_57776,G__57322_57777,G__57323_57778,G__57324_57779,G__57325_57780));
} else {
var temp__5753__auto___57781 = (function (){var fexpr__57326 = cljs.core.deref(input_checker57315_57772);
return (fexpr__57326.cljs$core$IFn$_invoke$arity$1 ? fexpr__57326.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57775) : fexpr__57326.call(null,args__51658__auto___57775));
})();
if(cljs.core.truth_(temp__5753__auto___57781)){
var error__51659__auto___57782 = temp__5753__auto___57781;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57782], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57314_57771,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57775,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57782], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var arrays = G__57317;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__57330 = cljs.core.count(arrays__$1);
switch (G__57330) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__57330,arrays__$1,validate__51657__auto__,ufv___57769,output_schema57313_57770,input_schema57314_57771,input_checker57315_57772,output_checker57316_57773){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__57330,arrays__$1,validate__51657__auto__,ufv___57769,output_schema57313_57770,input_schema57314_57771,input_checker57315_57772,output_checker57316_57773))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__57330,arrays__$1,validate__51657__auto__,ufv___57769,output_schema57313_57770,input_schema57314_57771,input_checker57315_57772,output_checker57316_57773){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__57330,arrays__$1,validate__51657__auto__,ufv___57769,output_schema57313_57770,input_schema57314_57771,input_checker57315_57772,output_checker57316_57773))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57331_57791 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57332_57792 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__57333_57793 = output_schema57313_57770;
var G__57334_57794 = cljs.core.deref(output_checker57316_57773);
var G__57335_57795 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57331_57791,G__57332_57792,G__57333_57793,G__57334_57794,G__57335_57795) : schema.core.fn_validator.call(null,G__57331_57791,G__57332_57792,G__57333_57793,G__57334_57794,G__57335_57795));
} else {
var temp__5753__auto___57798 = (function (){var fexpr__57336 = cljs.core.deref(output_checker57316_57773);
return (fexpr__57336.cljs$core$IFn$_invoke$arity$1 ? fexpr__57336.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57336.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57798)){
var error__51659__auto___57799 = temp__5753__auto___57798;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57799], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57313_57770,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57799], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema57313_57770,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57314_57771], null)));

var ufv___57800 = schema.utils.use_fn_validation;
var output_schema57340_57801 = schema.core.Bool;
var input_schema57341_57802 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker57342_57803 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57341_57802);
}),null));
var output_checker57343_57804 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57340_57801);
}),null));
var ret__54411__auto___57806 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__57344,G__57345){
var validate__51657__auto__ = cljs.core.deref(ufv___57800);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57808 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57344,G__57345], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57346_57810 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57347_57811 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__57348_57812 = input_schema57341_57802;
var G__57349_57813 = cljs.core.deref(input_checker57342_57803);
var G__57350_57814 = args__51658__auto___57808;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57346_57810,G__57347_57811,G__57348_57812,G__57349_57813,G__57350_57814) : schema.core.fn_validator.call(null,G__57346_57810,G__57347_57811,G__57348_57812,G__57349_57813,G__57350_57814));
} else {
var temp__5753__auto___57823 = (function (){var fexpr__57351 = cljs.core.deref(input_checker57342_57803);
return (fexpr__57351.cljs$core$IFn$_invoke$arity$1 ? fexpr__57351.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57808) : fexpr__57351.call(null,args__51658__auto___57808));
})();
if(cljs.core.truth_(temp__5753__auto___57823)){
var error__51659__auto___57824 = temp__5753__auto___57823;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57824], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57341_57802,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57808,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57824], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var a = G__57344;
var b = G__57345;
while(true){
var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__4251__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__57829 = ((i + (1)) | (0));
i = G__57829;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__4251__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57355_57831 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57356_57832 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__57357_57833 = output_schema57340_57801;
var G__57358_57834 = cljs.core.deref(output_checker57343_57804);
var G__57359_57835 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57355_57831,G__57356_57832,G__57357_57833,G__57358_57834,G__57359_57835) : schema.core.fn_validator.call(null,G__57355_57831,G__57356_57832,G__57357_57833,G__57358_57834,G__57359_57835));
} else {
var temp__5753__auto___57837 = (function (){var fexpr__57360 = cljs.core.deref(output_checker57343_57804);
return (fexpr__57360.cljs$core$IFn$_invoke$arity$1 ? fexpr__57360.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57360.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57837)){
var error__51659__auto___57838 = temp__5753__auto___57837;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57838], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57340_57801,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57838], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema57340_57801,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57341_57802], null)));

var ufv___57839 = schema.utils.use_fn_validation;
var output_schema57361_57840 = schema.core.Str;
var input_schema57362_57841 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker57363_57842 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57362_57841);
}),null));
var output_checker57364_57843 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57361_57840);
}),null));
var ret__54411__auto___57844 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__57365){
var validate__51657__auto__ = cljs.core.deref(ufv___57839);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57845 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57365], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57368_57847 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57369_57848 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__57370_57849 = input_schema57362_57841;
var G__57371_57850 = cljs.core.deref(input_checker57363_57842);
var G__57372_57851 = args__51658__auto___57845;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57368_57847,G__57369_57848,G__57370_57849,G__57371_57850,G__57372_57851) : schema.core.fn_validator.call(null,G__57368_57847,G__57369_57848,G__57370_57849,G__57371_57850,G__57372_57851));
} else {
var temp__5753__auto___57854 = (function (){var fexpr__57374 = cljs.core.deref(input_checker57363_57842);
return (fexpr__57374.cljs$core$IFn$_invoke$arity$1 ? fexpr__57374.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57845) : fexpr__57374.call(null,args__51658__auto___57845));
})();
if(cljs.core.truth_(temp__5753__auto___57854)){
var error__51659__auto___57856 = temp__5753__auto___57854;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57856], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57362_57841,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57845,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57856], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57365;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57376_57857 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57377_57858 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__57378_57859 = output_schema57361_57840;
var G__57379_57860 = cljs.core.deref(output_checker57364_57843);
var G__57380_57861 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57376_57857,G__57377_57858,G__57378_57859,G__57379_57860,G__57380_57861) : schema.core.fn_validator.call(null,G__57376_57857,G__57377_57858,G__57378_57859,G__57379_57860,G__57380_57861));
} else {
var temp__5753__auto___57862 = (function (){var fexpr__57381 = cljs.core.deref(output_checker57364_57843);
return (fexpr__57381.cljs$core$IFn$_invoke$arity$1 ? fexpr__57381.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57381.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57862)){
var error__51659__auto___57863 = temp__5753__auto___57862;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57361_57840,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57863], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema57361_57840,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57362_57841], null)));

var ufv___57865 = schema.utils.use_fn_validation;
var output_schema57386_57866 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema57387_57867 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema57391_57868 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema57396_57869 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker57388_57870 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57387_57867);
}),null));
var output_checker57389_57871 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57386_57866);
}),null));
var input_checker57392_57872 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57391_57868);
}),null));
var output_checker57393_57873 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57386_57866);
}),null));
var input_checker57397_57874 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57396_57869);
}),null));
var output_checker57398_57875 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57386_57866);
}),null));
var ret__54411__auto___57878 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__57404 = arguments.length;
switch (G__57404) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__57390){
var validate__51657__auto__ = cljs.core.deref(ufv___57865);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57882 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57390], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57405_57883 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57406_57884 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__57407_57885 = input_schema57387_57867;
var G__57408_57886 = cljs.core.deref(input_checker57388_57870);
var G__57409_57887 = args__51658__auto___57882;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57405_57883,G__57406_57884,G__57407_57885,G__57408_57886,G__57409_57887) : schema.core.fn_validator.call(null,G__57405_57883,G__57406_57884,G__57407_57885,G__57408_57886,G__57409_57887));
} else {
var temp__5753__auto___57888 = (function (){var fexpr__57410 = cljs.core.deref(input_checker57388_57870);
return (fexpr__57410.cljs$core$IFn$_invoke$arity$1 ? fexpr__57410.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57882) : fexpr__57410.call(null,args__51658__auto___57882));
})();
if(cljs.core.truth_(temp__5753__auto___57888)){
var error__51659__auto___57890 = temp__5753__auto___57888;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57890], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57387_57867,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57882,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57890], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57390;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57411_57891 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57412_57892 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__57413_57893 = output_schema57386_57866;
var G__57414_57894 = cljs.core.deref(output_checker57389_57871);
var G__57415_57895 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57411_57891,G__57412_57892,G__57413_57893,G__57414_57894,G__57415_57895) : schema.core.fn_validator.call(null,G__57411_57891,G__57412_57892,G__57413_57893,G__57414_57894,G__57415_57895));
} else {
var temp__5753__auto___57897 = (function (){var fexpr__57416 = cljs.core.deref(output_checker57389_57871);
return (fexpr__57416.cljs$core$IFn$_invoke$arity$1 ? fexpr__57416.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57416.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57897)){
var error__51659__auto___57898 = temp__5753__auto___57897;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57898], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57386_57866,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57898], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__57394,G__57395){
var validate__51657__auto__ = cljs.core.deref(ufv___57865);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57900 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57394,G__57395], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57418_57901 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57419_57902 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__57420_57903 = input_schema57391_57868;
var G__57421_57904 = cljs.core.deref(input_checker57392_57872);
var G__57422_57905 = args__51658__auto___57900;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57418_57901,G__57419_57902,G__57420_57903,G__57421_57904,G__57422_57905) : schema.core.fn_validator.call(null,G__57418_57901,G__57419_57902,G__57420_57903,G__57421_57904,G__57422_57905));
} else {
var temp__5753__auto___57906 = (function (){var fexpr__57424 = cljs.core.deref(input_checker57392_57872);
return (fexpr__57424.cljs$core$IFn$_invoke$arity$1 ? fexpr__57424.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57900) : fexpr__57424.call(null,args__51658__auto___57900));
})();
if(cljs.core.truth_(temp__5753__auto___57906)){
var error__51659__auto___57907 = temp__5753__auto___57906;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57907], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57391_57868,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57900,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57907], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57394;
var start = G__57395;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57426_57912 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57427_57913 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__57428_57914 = output_schema57386_57866;
var G__57429_57915 = cljs.core.deref(output_checker57393_57873);
var G__57430_57916 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57426_57912,G__57427_57913,G__57428_57914,G__57429_57915,G__57430_57916) : schema.core.fn_validator.call(null,G__57426_57912,G__57427_57913,G__57428_57914,G__57429_57915,G__57430_57916));
} else {
var temp__5753__auto___57917 = (function (){var fexpr__57431 = cljs.core.deref(output_checker57393_57873);
return (fexpr__57431.cljs$core$IFn$_invoke$arity$1 ? fexpr__57431.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57431.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57917)){
var error__51659__auto___57919 = temp__5753__auto___57917;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57919], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57386_57866,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57919], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__57399,G__57400,G__57401){
var validate__51657__auto__ = cljs.core.deref(ufv___57865);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57920 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57399,G__57400,G__57401], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57433_57922 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57434_57923 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__57435_57924 = input_schema57396_57869;
var G__57436_57925 = cljs.core.deref(input_checker57397_57874);
var G__57437_57926 = args__51658__auto___57920;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57433_57922,G__57434_57923,G__57435_57924,G__57436_57925,G__57437_57926) : schema.core.fn_validator.call(null,G__57433_57922,G__57434_57923,G__57435_57924,G__57436_57925,G__57437_57926));
} else {
var temp__5753__auto___57927 = (function (){var fexpr__57438 = cljs.core.deref(input_checker57397_57874);
return (fexpr__57438.cljs$core$IFn$_invoke$arity$1 ? fexpr__57438.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57920) : fexpr__57438.call(null,args__51658__auto___57920));
})();
if(cljs.core.truth_(temp__5753__auto___57927)){
var error__51659__auto___57928 = temp__5753__auto___57927;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57928], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57396_57869,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57920,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57928], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57399;
var start = G__57400;
var end = G__57401;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4339__auto__ = end;
var y__4340__auto__ = cljs.core.count(ba);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57439_57932 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57440_57933 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__57441_57934 = output_schema57386_57866;
var G__57442_57935 = cljs.core.deref(output_checker57398_57875);
var G__57443_57936 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57439_57932,G__57440_57933,G__57441_57934,G__57442_57935,G__57443_57936) : schema.core.fn_validator.call(null,G__57439_57932,G__57440_57933,G__57441_57934,G__57442_57935,G__57443_57936));
} else {
var temp__5753__auto___57937 = (function (){var fexpr__57444 = cljs.core.deref(output_checker57398_57875);
return (fexpr__57444.cljs$core$IFn$_invoke$arity$1 ? fexpr__57444.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57444.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57937)){
var error__51659__auto___57938 = temp__5753__auto___57937;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57938], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57386_57866,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57938], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema57386_57866,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57387_57867,input_schema57391_57868,input_schema57396_57869], null)));

var ufv___57944 = schema.utils.use_fn_validation;
var output_schema57445_57945 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema57446_57946 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker57447_57947 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57446_57946);
}),null));
var output_checker57448_57948 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57445_57945);
}),null));
var ret__54411__auto___57949 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__57449){
var validate__51657__auto__ = cljs.core.deref(ufv___57944);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57950 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57449], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57450_57951 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57451_57952 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__57452_57953 = input_schema57446_57946;
var G__57453_57954 = cljs.core.deref(input_checker57447_57947);
var G__57454_57955 = args__51658__auto___57950;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57450_57951,G__57451_57952,G__57452_57953,G__57453_57954,G__57454_57955) : schema.core.fn_validator.call(null,G__57450_57951,G__57451_57952,G__57452_57953,G__57453_57954,G__57454_57955));
} else {
var temp__5753__auto___57957 = (function (){var fexpr__57455 = cljs.core.deref(input_checker57447_57947);
return (fexpr__57455.cljs$core$IFn$_invoke$arity$1 ? fexpr__57455.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57950) : fexpr__57455.call(null,args__51658__auto___57950));
})();
if(cljs.core.truth_(temp__5753__auto___57957)){
var error__51659__auto___57958 = temp__5753__auto___57957;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57958], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57446_57946,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57950,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57958], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57449;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4741__auto___57960 = num;
var i_57961 = (0);
while(true){
if((i_57961 < n__4741__auto___57960)){
(new$[i_57961] = (ba[(last - i_57961)]));

var G__57962 = (i_57961 + (1));
i_57961 = G__57962;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57456_57963 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57457_57964 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__57458_57965 = output_schema57445_57945;
var G__57459_57966 = cljs.core.deref(output_checker57448_57948);
var G__57460_57967 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57456_57963,G__57457_57964,G__57458_57965,G__57459_57966,G__57460_57967) : schema.core.fn_validator.call(null,G__57456_57963,G__57457_57964,G__57458_57965,G__57459_57966,G__57460_57967));
} else {
var temp__5753__auto___57968 = (function (){var fexpr__57461 = cljs.core.deref(output_checker57448_57948);
return (fexpr__57461.cljs$core$IFn$_invoke$arity$1 ? fexpr__57461.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57461.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___57968)){
var error__51659__auto___57970 = temp__5753__auto___57968;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57970], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57445_57945,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57970], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema57445_57945,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57446_57946], null)));

var ufv___57971 = schema.utils.use_fn_validation;
var output_schema57462_57972 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema57463_57973 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker57464_57974 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57463_57973);
}),null));
var output_checker57465_57975 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57462_57972);
}),null));
var ret__54411__auto___57977 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__57466,G__57467){
var validate__51657__auto__ = cljs.core.deref(ufv___57971);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___57981 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57466,G__57467], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57468_57982 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57469_57983 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__57470_57984 = input_schema57463_57973;
var G__57471_57985 = cljs.core.deref(input_checker57464_57974);
var G__57472_57986 = args__51658__auto___57981;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57468_57982,G__57469_57983,G__57470_57984,G__57471_57985,G__57472_57986) : schema.core.fn_validator.call(null,G__57468_57982,G__57469_57983,G__57470_57984,G__57471_57985,G__57472_57986));
} else {
var temp__5753__auto___57989 = (function (){var fexpr__57473 = cljs.core.deref(input_checker57464_57974);
return (fexpr__57473.cljs$core$IFn$_invoke$arity$1 ? fexpr__57473.cljs$core$IFn$_invoke$arity$1(args__51658__auto___57981) : fexpr__57473.call(null,args__51658__auto___57981));
})();
if(cljs.core.truth_(temp__5753__auto___57989)){
var error__51659__auto___57990 = temp__5753__auto___57989;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___57990], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57463_57973,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___57981,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___57990], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57466;
var fragment_size = G__57467;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__57994 = (end_offset | (0));
var G__57995 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__57994;
output = G__57995;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57474_57996 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57475_57997 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__57476_57998 = output_schema57462_57972;
var G__57477_57999 = cljs.core.deref(output_checker57465_57975);
var G__57478_58000 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57474_57996,G__57475_57997,G__57476_57998,G__57477_57999,G__57478_58000) : schema.core.fn_validator.call(null,G__57474_57996,G__57475_57997,G__57476_57998,G__57477_57999,G__57478_58000));
} else {
var temp__5753__auto___58001 = (function (){var fexpr__57479 = cljs.core.deref(output_checker57465_57975);
return (fexpr__57479.cljs$core$IFn$_invoke$arity$1 ? fexpr__57479.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57479.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58001)){
var error__51659__auto___58002 = temp__5753__auto___58001;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58002], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57462_57972,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58002], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema57462_57972,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57463_57973], null)));

var ufv___58003 = schema.utils.use_fn_validation;
var output_schema57480_58004 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema57481_58005 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker57482_58006 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57481_58005);
}),null));
var output_checker57483_58007 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57480_58004);
}),null));
var ret__54411__auto___58009 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__57484){
var validate__51657__auto__ = cljs.core.deref(ufv___58003);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58010 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57484], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57485_58011 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57486_58012 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__57487_58013 = input_schema57481_58005;
var G__57488_58014 = cljs.core.deref(input_checker57482_58006);
var G__57489_58015 = args__51658__auto___58010;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57485_58011,G__57486_58012,G__57487_58013,G__57488_58014,G__57489_58015) : schema.core.fn_validator.call(null,G__57485_58011,G__57486_58012,G__57487_58013,G__57488_58014,G__57489_58015));
} else {
var temp__5753__auto___58017 = (function (){var fexpr__57490 = cljs.core.deref(input_checker57482_58006);
return (fexpr__57490.cljs$core$IFn$_invoke$arity$1 ? fexpr__57490.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58010) : fexpr__57490.call(null,args__51658__auto___58010));
})();
if(cljs.core.truth_(temp__5753__auto___58017)){
var error__51659__auto___58018 = temp__5753__auto___58017;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58018], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57481_58005,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58010,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58018], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57484;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__58026 = (n + (1));
var G__58027 = (i__$1 | (0));
var G__58028 = (out__$1 | (0));
n = G__58026;
i = G__58027;
out = G__58028;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57491_58033 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57492_58034 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__57493_58035 = output_schema57480_58004;
var G__57494_58036 = cljs.core.deref(output_checker57483_58007);
var G__57495_58037 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57491_58033,G__57492_58034,G__57493_58035,G__57494_58036,G__57495_58037) : schema.core.fn_validator.call(null,G__57491_58033,G__57492_58034,G__57493_58035,G__57494_58036,G__57495_58037));
} else {
var temp__5753__auto___58040 = (function (){var fexpr__57496 = cljs.core.deref(output_checker57483_58007);
return (fexpr__57496.cljs$core$IFn$_invoke$arity$1 ? fexpr__57496.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57496.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58040)){
var error__51659__auto___58041 = temp__5753__auto___58040;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58041], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57480_58004,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58041], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema57480_58004,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57481_58005], null)));

var ufv___58043 = schema.utils.use_fn_validation;
var output_schema57497_58044 = deercreeklabs.baracus.ByteArray;
var input_schema57498_58045 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker57499_58046 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57498_58045);
}),null));
var output_checker57500_58047 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57497_58044);
}),null));
var ret__54411__auto___58048 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__57501){
var validate__51657__auto__ = cljs.core.deref(ufv___58043);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58050 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57501], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57502_58051 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57503_58052 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__57504_58053 = input_schema57498_58045;
var G__57505_58054 = cljs.core.deref(input_checker57499_58046);
var G__57506_58055 = args__51658__auto___58050;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57502_58051,G__57503_58052,G__57504_58053,G__57505_58054,G__57506_58055) : schema.core.fn_validator.call(null,G__57502_58051,G__57503_58052,G__57504_58053,G__57505_58054,G__57506_58055));
} else {
var temp__5753__auto___58056 = (function (){var fexpr__57507 = cljs.core.deref(input_checker57499_58046);
return (fexpr__57507.cljs$core$IFn$_invoke$arity$1 ? fexpr__57507.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58050) : fexpr__57507.call(null,args__51658__auto___58050));
})();
if(cljs.core.truth_(temp__5753__auto___58056)){
var error__51659__auto___58057 = temp__5753__auto___58056;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58057], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57498_58045,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58050,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58057], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var i = G__57501;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__58068 = (n >>> (7));
var G__58069 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__58068;
out = G__58069;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57508_58070 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57509_58071 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__57510_58072 = output_schema57497_58044;
var G__57511_58073 = cljs.core.deref(output_checker57500_58047);
var G__57512_58074 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57508_58070,G__57509_58071,G__57510_58072,G__57511_58073,G__57512_58074) : schema.core.fn_validator.call(null,G__57508_58070,G__57509_58071,G__57510_58072,G__57511_58073,G__57512_58074));
} else {
var temp__5753__auto___58076 = (function (){var fexpr__57513 = cljs.core.deref(output_checker57500_58047);
return (fexpr__57513.cljs$core$IFn$_invoke$arity$1 ? fexpr__57513.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57513.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58076)){
var error__51659__auto___58077 = temp__5753__auto___58076;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58077], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57497_58044,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58077], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema57497_58044,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57498_58045], null)));

var ufv___58079 = schema.utils.use_fn_validation;
var output_schema57514_58080 = schema.core.maybe(schema.core.Str);
var input_schema57515_58081 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker57516_58082 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57515_58081);
}),null));
var output_checker57517_58083 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57514_58080);
}),null));
var ret__54411__auto___58084 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__57518){
var validate__51657__auto__ = cljs.core.deref(ufv___58079);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58086 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57518], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57519_58087 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57520_58088 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__57521_58089 = input_schema57515_58081;
var G__57522_58090 = cljs.core.deref(input_checker57516_58082);
var G__57523_58091 = args__51658__auto___58086;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57519_58087,G__57520_58088,G__57521_58089,G__57522_58090,G__57523_58091) : schema.core.fn_validator.call(null,G__57519_58087,G__57520_58088,G__57521_58089,G__57522_58090,G__57523_58091));
} else {
var temp__5753__auto___58092 = (function (){var fexpr__57524 = cljs.core.deref(input_checker57516_58082);
return (fexpr__57524.cljs$core$IFn$_invoke$arity$1 ? fexpr__57524.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58086) : fexpr__57524.call(null,args__51658__auto___58086));
})();
if(cljs.core.truth_(temp__5753__auto___58092)){
var error__51659__auto___58095 = temp__5753__auto___58092;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58095], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57515_58081,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58086,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58095], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var b = G__57518;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57525_58098 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57526_58099 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__57527_58100 = output_schema57514_58080;
var G__57528_58101 = cljs.core.deref(output_checker57517_58083);
var G__57529_58102 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57525_58098,G__57526_58099,G__57527_58100,G__57528_58101,G__57529_58102) : schema.core.fn_validator.call(null,G__57525_58098,G__57526_58099,G__57527_58100,G__57528_58101,G__57529_58102));
} else {
var temp__5753__auto___58103 = (function (){var fexpr__57530 = cljs.core.deref(output_checker57517_58083);
return (fexpr__57530.cljs$core$IFn$_invoke$arity$1 ? fexpr__57530.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57530.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58103)){
var error__51659__auto___58105 = temp__5753__auto___58103;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58105], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57514_58080,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58105], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema57514_58080,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57515_58081], null)));

var ufv___58109 = schema.utils.use_fn_validation;
var output_schema57531_58110 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema57532_58111 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker57533_58112 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57532_58111);
}),null));
var output_checker57534_58113 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57531_58110);
}),null));
var ret__54411__auto___58115 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__57535){
var validate__51657__auto__ = cljs.core.deref(ufv___58109);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58116 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57535], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57536_58117 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57537_58118 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__57538_58119 = input_schema57532_58111;
var G__57539_58120 = cljs.core.deref(input_checker57533_58112);
var G__57540_58121 = args__51658__auto___58116;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57536_58117,G__57537_58118,G__57538_58119,G__57539_58120,G__57540_58121) : schema.core.fn_validator.call(null,G__57536_58117,G__57537_58118,G__57538_58119,G__57539_58120,G__57540_58121));
} else {
var temp__5753__auto___58123 = (function (){var fexpr__57541 = cljs.core.deref(input_checker57533_58112);
return (fexpr__57541.cljs$core$IFn$_invoke$arity$1 ? fexpr__57541.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58116) : fexpr__57541.call(null,args__51658__auto___58116));
})();
if(cljs.core.truth_(temp__5753__auto___58123)){
var error__51659__auto___58125 = temp__5753__auto___58123;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58125], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57532_58111,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58116,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58125], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var s = G__57535;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57542_58135 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57543_58136 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__57544_58137 = output_schema57531_58110;
var G__57545_58138 = cljs.core.deref(output_checker57534_58113);
var G__57546_58139 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57542_58135,G__57543_58136,G__57544_58137,G__57545_58138,G__57546_58139) : schema.core.fn_validator.call(null,G__57542_58135,G__57543_58136,G__57544_58137,G__57545_58138,G__57546_58139));
} else {
var temp__5753__auto___58140 = (function (){var fexpr__57547 = cljs.core.deref(output_checker57534_58113);
return (fexpr__57547.cljs$core$IFn$_invoke$arity$1 ? fexpr__57547.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57547.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58140)){
var error__51659__auto___58141 = temp__5753__auto___58140;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58141], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57531_58110,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58141], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema57531_58110,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57532_58111], null)));

var ufv___58143 = schema.utils.use_fn_validation;
var output_schema57548_58144 = schema.core.maybe(schema.core.Str);
var input_schema57549_58145 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker57550_58146 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57549_58145);
}),null));
var output_checker57551_58147 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57548_58144);
}),null));
var ret__54411__auto___58149 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__57552){
var validate__51657__auto__ = cljs.core.deref(ufv___58143);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58150 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57552], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57553_58151 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57554_58152 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__57555_58153 = input_schema57549_58145;
var G__57556_58154 = cljs.core.deref(input_checker57550_58146);
var G__57557_58155 = args__51658__auto___58150;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57553_58151,G__57554_58152,G__57555_58153,G__57556_58154,G__57557_58155) : schema.core.fn_validator.call(null,G__57553_58151,G__57554_58152,G__57555_58153,G__57556_58154,G__57557_58155));
} else {
var temp__5753__auto___58158 = (function (){var fexpr__57558 = cljs.core.deref(input_checker57550_58146);
return (fexpr__57558.cljs$core$IFn$_invoke$arity$1 ? fexpr__57558.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58150) : fexpr__57558.call(null,args__51658__auto___58150));
})();
if(cljs.core.truth_(temp__5753__auto___58158)){
var error__51659__auto___58159 = temp__5753__auto___58158;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58159], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57549_58145,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58150,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58159], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57552;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57561_58164 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57562_58165 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__57563_58166 = output_schema57548_58144;
var G__57564_58167 = cljs.core.deref(output_checker57551_58147);
var G__57565_58168 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57561_58164,G__57562_58165,G__57563_58166,G__57564_58167,G__57565_58168) : schema.core.fn_validator.call(null,G__57561_58164,G__57562_58165,G__57563_58166,G__57564_58167,G__57565_58168));
} else {
var temp__5753__auto___58170 = (function (){var fexpr__57566 = cljs.core.deref(output_checker57551_58147);
return (fexpr__57566.cljs$core$IFn$_invoke$arity$1 ? fexpr__57566.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57566.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58170)){
var error__51659__auto___58171 = temp__5753__auto___58170;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58171], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57548_58144,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58171], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema57548_58144,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57549_58145], null)));

var ufv___58174 = schema.utils.use_fn_validation;
var output_schema57567_58175 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema57568_58176 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker57569_58177 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57568_58176);
}),null));
var output_checker57570_58178 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57567_58175);
}),null));
var ret__54411__auto___58179 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__57571){
var validate__51657__auto__ = cljs.core.deref(ufv___58174);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58180 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57571], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57574_58181 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57575_58182 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__57576_58183 = input_schema57568_58176;
var G__57577_58184 = cljs.core.deref(input_checker57569_58177);
var G__57578_58185 = args__51658__auto___58180;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57574_58181,G__57575_58182,G__57576_58183,G__57577_58184,G__57578_58185) : schema.core.fn_validator.call(null,G__57574_58181,G__57575_58182,G__57576_58183,G__57577_58184,G__57578_58185));
} else {
var temp__5753__auto___58186 = (function (){var fexpr__57579 = cljs.core.deref(input_checker57569_58177);
return (fexpr__57579.cljs$core$IFn$_invoke$arity$1 ? fexpr__57579.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58180) : fexpr__57579.call(null,args__51658__auto___58180));
})();
if(cljs.core.truth_(temp__5753__auto___58186)){
var error__51659__auto___58187 = temp__5753__auto___58186;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58187], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57568_58176,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58180,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58187], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var s = G__57571;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57580_58190 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57581_58191 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__57582_58192 = output_schema57567_58175;
var G__57583_58193 = cljs.core.deref(output_checker57570_58178);
var G__57584_58194 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57580_58190,G__57581_58191,G__57582_58192,G__57583_58193,G__57584_58194) : schema.core.fn_validator.call(null,G__57580_58190,G__57581_58191,G__57582_58192,G__57583_58193,G__57584_58194));
} else {
var temp__5753__auto___58195 = (function (){var fexpr__57586 = cljs.core.deref(output_checker57570_58178);
return (fexpr__57586.cljs$core$IFn$_invoke$arity$1 ? fexpr__57586.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57586.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58195)){
var error__51659__auto___58196 = temp__5753__auto___58195;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58196], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57567_58175,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58196], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema57567_58175,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57568_58176], null)));

var ufv___58197 = schema.utils.use_fn_validation;
var output_schema57587_58198 = schema.core.maybe(schema.core.Str);
var input_schema57588_58199 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker57589_58200 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57588_58199);
}),null));
var output_checker57590_58201 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57587_58198);
}),null));
var ret__54411__auto___58206 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__57591){
var validate__51657__auto__ = cljs.core.deref(ufv___58197);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58207 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57591], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57594_58208 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57595_58209 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__57596_58210 = input_schema57588_58199;
var G__57597_58211 = cljs.core.deref(input_checker57589_58200);
var G__57598_58212 = args__51658__auto___58207;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57594_58208,G__57595_58209,G__57596_58210,G__57597_58211,G__57598_58212) : schema.core.fn_validator.call(null,G__57594_58208,G__57595_58209,G__57596_58210,G__57597_58211,G__57598_58212));
} else {
var temp__5753__auto___58214 = (function (){var fexpr__57599 = cljs.core.deref(input_checker57589_58200);
return (fexpr__57599.cljs$core$IFn$_invoke$arity$1 ? fexpr__57599.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58207) : fexpr__57599.call(null,args__51658__auto___58207));
})();
if(cljs.core.truth_(temp__5753__auto___58214)){
var error__51659__auto___58217 = temp__5753__auto___58214;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58217], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57588_58199,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58207,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58217], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57591;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4741__auto___58221 = len;
var i_58222 = (0);
while(true){
if((i_58222 < n__4741__auto___58221)){
var b_58223 = ((ba[i_58222]) & (255));
var j_58224 = ((2) * i_58222);
(ca[j_58224] = (function (){var G__57600 = (b_58223 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__57600) : hex_chars.call(null,G__57600));
})());

(ca[(j_58224 + (1))] = (function (){var G__57601 = (b_58223 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__57601) : hex_chars.call(null,G__57601));
})());

var G__58225 = (i_58222 + (1));
i_58222 = G__58225;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57602_58226 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57603_58227 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__57604_58228 = output_schema57587_58198;
var G__57605_58229 = cljs.core.deref(output_checker57590_58201);
var G__57606_58230 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57602_58226,G__57603_58227,G__57604_58228,G__57605_58229,G__57606_58230) : schema.core.fn_validator.call(null,G__57602_58226,G__57603_58227,G__57604_58228,G__57605_58229,G__57606_58230));
} else {
var temp__5753__auto___58231 = (function (){var fexpr__57607 = cljs.core.deref(output_checker57590_58201);
return (fexpr__57607.cljs$core$IFn$_invoke$arity$1 ? fexpr__57607.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57607.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58231)){
var error__51659__auto___58232 = temp__5753__auto___58231;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58232], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57587_58198,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58232], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema57587_58198,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57588_58199], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___58237 = schema.utils.use_fn_validation;
var output_schema57608_58238 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema57609_58239 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker57610_58240 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57609_58239);
}),null));
var output_checker57611_58241 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57608_58238);
}),null));
var ret__54411__auto___58242 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__57612){
var validate__51657__auto__ = cljs.core.deref(ufv___58237);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58243 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57612], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57613_58244 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57614_58245 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__57615_58246 = input_schema57609_58239;
var G__57616_58247 = cljs.core.deref(input_checker57610_58240);
var G__57617_58248 = args__51658__auto___58243;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57613_58244,G__57614_58245,G__57615_58246,G__57616_58247,G__57617_58248) : schema.core.fn_validator.call(null,G__57613_58244,G__57614_58245,G__57615_58246,G__57616_58247,G__57617_58248));
} else {
var temp__5753__auto___58250 = (function (){var fexpr__57618 = cljs.core.deref(input_checker57610_58240);
return (fexpr__57618.cljs$core$IFn$_invoke$arity$1 ? fexpr__57618.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58243) : fexpr__57618.call(null,args__51658__auto___58243));
})();
if(cljs.core.truth_(temp__5753__auto___58250)){
var error__51659__auto___58253 = temp__5753__auto___58250;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58253], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57609_58239,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58243,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58253], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var s = G__57612;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4741__auto___58255 = ba_len;
var i_58256 = (0);
while(true){
if((i_58256 < n__4741__auto___58255)){
var j_58257 = ((2) * i_58256);
(ba[i_58256] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_58257)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_58257 + (1))))));

var G__58259 = (i_58256 + (1));
i_58256 = G__58259;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57621_58264 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57622_58265 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__57623_58266 = output_schema57608_58238;
var G__57624_58267 = cljs.core.deref(output_checker57611_58241);
var G__57625_58268 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57621_58264,G__57622_58265,G__57623_58266,G__57624_58267,G__57625_58268) : schema.core.fn_validator.call(null,G__57621_58264,G__57622_58265,G__57623_58266,G__57624_58267,G__57625_58268));
} else {
var temp__5753__auto___58272 = (function (){var fexpr__57626 = cljs.core.deref(output_checker57611_58241);
return (fexpr__57626.cljs$core$IFn$_invoke$arity$1 ? fexpr__57626.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57626.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58272)){
var error__51659__auto___58273 = temp__5753__auto___58272;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58273], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57608_58238,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58273], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema57608_58238,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57609_58239], null)));

var ufv___58275 = schema.utils.use_fn_validation;
var output_schema57629_58276 = deercreeklabs.baracus.ByteArray;
var input_schema57630_58277 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker57631_58278 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57630_58277);
}),null));
var output_checker57632_58279 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57629_58276);
}),null));
var ret__54411__auto___58280 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__57633){
var validate__51657__auto__ = cljs.core.deref(ufv___58275);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58281 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57633], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57634_58282 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57635_58283 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__57636_58284 = input_schema57630_58277;
var G__57637_58285 = cljs.core.deref(input_checker57631_58278);
var G__57638_58286 = args__51658__auto___58281;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57634_58282,G__57635_58283,G__57636_58284,G__57637_58285,G__57638_58286) : schema.core.fn_validator.call(null,G__57634_58282,G__57635_58283,G__57636_58284,G__57637_58285,G__57638_58286));
} else {
var temp__5753__auto___58287 = (function (){var fexpr__57639 = cljs.core.deref(input_checker57631_58278);
return (fexpr__57639.cljs$core$IFn$_invoke$arity$1 ? fexpr__57639.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58281) : fexpr__57639.call(null,args__51658__auto___58281));
})();
if(cljs.core.truth_(temp__5753__auto___58287)){
var error__51659__auto___58288 = temp__5753__auto___58287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58288], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57630_58277,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58281,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58288], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57633;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57640_58294 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57641_58295 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__57642_58296 = output_schema57629_58276;
var G__57643_58297 = cljs.core.deref(output_checker57632_58279);
var G__57644_58298 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57640_58294,G__57641_58295,G__57642_58296,G__57643_58297,G__57644_58298) : schema.core.fn_validator.call(null,G__57640_58294,G__57641_58295,G__57642_58296,G__57643_58297,G__57644_58298));
} else {
var temp__5753__auto___58299 = (function (){var fexpr__57645 = cljs.core.deref(output_checker57632_58279);
return (fexpr__57645.cljs$core$IFn$_invoke$arity$1 ? fexpr__57645.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57645.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58299)){
var error__51659__auto___58300 = temp__5753__auto___58299;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58300], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57629_58276,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58300], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema57629_58276,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57630_58277], null)));

var ufv___58302 = schema.utils.use_fn_validation;
var output_schema57646_58303 = deercreeklabs.baracus.ByteArray;
var input_schema57647_58304 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker57648_58305 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57647_58304);
}),null));
var output_checker57649_58306 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57646_58303);
}),null));
var ret__54411__auto___58307 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__57650){
var validate__51657__auto__ = cljs.core.deref(ufv___58302);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58308 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57650], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57654_58309 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57655_58310 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__57656_58311 = input_schema57647_58304;
var G__57657_58312 = cljs.core.deref(input_checker57648_58305);
var G__57658_58313 = args__51658__auto___58308;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57654_58309,G__57655_58310,G__57656_58311,G__57657_58312,G__57658_58313) : schema.core.fn_validator.call(null,G__57654_58309,G__57655_58310,G__57656_58311,G__57657_58312,G__57658_58313));
} else {
var temp__5753__auto___58314 = (function (){var fexpr__57659 = cljs.core.deref(input_checker57648_58305);
return (fexpr__57659.cljs$core$IFn$_invoke$arity$1 ? fexpr__57659.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58308) : fexpr__57659.call(null,args__51658__auto___58308));
})();
if(cljs.core.truth_(temp__5753__auto___58314)){
var error__51659__auto___58315 = temp__5753__auto___58314;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58315], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57647_58304,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58308,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58315], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57650;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57661_58317 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57662_58318 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__57663_58319 = output_schema57646_58303;
var G__57664_58320 = cljs.core.deref(output_checker57649_58306);
var G__57665_58321 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57661_58317,G__57662_58318,G__57663_58319,G__57664_58320,G__57665_58321) : schema.core.fn_validator.call(null,G__57661_58317,G__57662_58318,G__57663_58319,G__57664_58320,G__57665_58321));
} else {
var temp__5753__auto___58322 = (function (){var fexpr__57667 = cljs.core.deref(output_checker57649_58306);
return (fexpr__57667.cljs$core$IFn$_invoke$arity$1 ? fexpr__57667.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57667.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58322)){
var error__51659__auto___58323 = temp__5753__auto___58322;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58323], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57646_58303,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58323], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema57646_58303,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57647_58304], null)));

var ufv___58325 = schema.utils.use_fn_validation;
var output_schema57668_58326 = deercreeklabs.baracus.ByteArray;
var input_schema57669_58327 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker57670_58328 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema57669_58327);
}),null));
var output_checker57671_58329 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema57668_58326);
}),null));
var ret__54411__auto___58335 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__57672){
var validate__51657__auto__ = cljs.core.deref(ufv___58325);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___58336 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__57672], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57673_58337 = new cljs.core.Keyword(null,"input","input",556931961);
var G__57674_58338 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__57675_58339 = input_schema57669_58327;
var G__57676_58340 = cljs.core.deref(input_checker57670_58328);
var G__57677_58341 = args__51658__auto___58336;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57673_58337,G__57674_58338,G__57675_58339,G__57676_58340,G__57677_58341) : schema.core.fn_validator.call(null,G__57673_58337,G__57674_58338,G__57675_58339,G__57676_58340,G__57677_58341));
} else {
var temp__5753__auto___58342 = (function (){var fexpr__57678 = cljs.core.deref(input_checker57670_58328);
return (fexpr__57678.cljs$core$IFn$_invoke$arity$1 ? fexpr__57678.cljs$core$IFn$_invoke$arity$1(args__51658__auto___58336) : fexpr__57678.call(null,args__51658__auto___58336));
})();
if(cljs.core.truth_(temp__5753__auto___58342)){
var error__51659__auto___58343 = temp__5753__auto___58342;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58343], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema57669_58327,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___58336,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58343], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var ba = G__57672;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__57679_58344 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__57680_58345 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__57681_58346 = output_schema57668_58326;
var G__57682_58347 = cljs.core.deref(output_checker57671_58329);
var G__57683_58348 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__57679_58344,G__57680_58345,G__57681_58346,G__57682_58347,G__57683_58348) : schema.core.fn_validator.call(null,G__57679_58344,G__57680_58345,G__57681_58346,G__57682_58347,G__57683_58348));
} else {
var temp__5753__auto___58349 = (function (){var fexpr__57684 = cljs.core.deref(output_checker57671_58329);
return (fexpr__57684.cljs$core$IFn$_invoke$arity$1 ? fexpr__57684.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__57684.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___58349)){
var error__51659__auto___58350 = temp__5753__auto___58349;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___58350], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema57668_58326,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___58350], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema57668_58326,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema57669_58327], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
