goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__53543__53544__auto__){
if((!((p1__53543__53544__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__53543__53544__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__53543__53544__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__53543__53544__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__53543__53544__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___69065 = schema.utils.use_fn_validation;
var output_schema68429_69066 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68430_69067 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker68431_69068 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68430_69067);
}),null));
var output_checker68432_69069 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68429_69066);
}),null));
var ret__54411__auto___69070 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__68433){
var validate__51657__auto__ = cljs.core.deref(ufv___69065);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69071 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68433], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68434_69072 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68435_69073 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__68436_69074 = input_schema68430_69067;
var G__68437_69075 = cljs.core.deref(input_checker68431_69068);
var G__68438_69076 = args__51658__auto___69071;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68434_69072,G__68435_69073,G__68436_69074,G__68437_69075,G__68438_69076) : schema.core.fn_validator.call(null,G__68434_69072,G__68435_69073,G__68436_69074,G__68437_69075,G__68438_69076));
} else {
var temp__5753__auto___69077 = (function (){var fexpr__68439 = cljs.core.deref(input_checker68431_69068);
return (fexpr__68439.cljs$core$IFn$_invoke$arity$1 ? fexpr__68439.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69071) : fexpr__68439.call(null,args__51658__auto___69071));
})();
if(cljs.core.truth_(temp__5753__auto___69077)){
var error__51659__auto___69078 = temp__5753__auto___69077;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69078], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68430_69067,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69071,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69078], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var json = G__68433;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68440_69079 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68441_69080 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__68442_69081 = output_schema68429_69066;
var G__68443_69082 = cljs.core.deref(output_checker68432_69069);
var G__68444_69083 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68440_69079,G__68441_69080,G__68442_69081,G__68443_69082,G__68444_69083) : schema.core.fn_validator.call(null,G__68440_69079,G__68441_69080,G__68442_69081,G__68443_69082,G__68444_69083));
} else {
var temp__5753__auto___69084 = (function (){var fexpr__68445 = cljs.core.deref(output_checker68432_69069);
return (fexpr__68445.cljs$core$IFn$_invoke$arity$1 ? fexpr__68445.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68445.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69084)){
var error__51659__auto___69085 = temp__5753__auto___69084;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69085], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68429_69066,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69085], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema68429_69066,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68430_69067], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___69086 = schema.utils.use_fn_validation;
var output_schema68446_69087 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68447_69088 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema68452_69089 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker68448_69090 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68447_69088);
}),null));
var output_checker68449_69091 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68446_69087);
}),null));
var input_checker68453_69092 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68452_69089);
}),null));
var output_checker68454_69093 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68446_69087);
}),null));
var ret__54411__auto___69094 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__68459 = arguments.length;
switch (G__68459) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__68450,G__68451){
var validate__51657__auto__ = cljs.core.deref(ufv___69086);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69096 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68450,G__68451], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68460_69097 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68461_69098 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__68462_69099 = input_schema68447_69088;
var G__68463_69100 = cljs.core.deref(input_checker68448_69090);
var G__68464_69101 = args__51658__auto___69096;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68460_69097,G__68461_69098,G__68462_69099,G__68463_69100,G__68464_69101) : schema.core.fn_validator.call(null,G__68460_69097,G__68461_69098,G__68462_69099,G__68463_69100,G__68464_69101));
} else {
var temp__5753__auto___69102 = (function (){var fexpr__68465 = cljs.core.deref(input_checker68448_69090);
return (fexpr__68465.cljs$core$IFn$_invoke$arity$1 ? fexpr__68465.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69096) : fexpr__68465.call(null,args__51658__auto___69096));
})();
if(cljs.core.truth_(temp__5753__auto___69102)){
var error__51659__auto___69103 = temp__5753__auto___69102;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69103], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68447_69088,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69096,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69103], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var name_kw = G__68450;
var fields = G__68451;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68466_69104 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68467_69105 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__68468_69106 = output_schema68446_69087;
var G__68469_69107 = cljs.core.deref(output_checker68449_69091);
var G__68470_69108 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68466_69104,G__68467_69105,G__68468_69106,G__68469_69107,G__68470_69108) : schema.core.fn_validator.call(null,G__68466_69104,G__68467_69105,G__68468_69106,G__68469_69107,G__68470_69108));
} else {
var temp__5753__auto___69109 = (function (){var fexpr__68471 = cljs.core.deref(output_checker68449_69091);
return (fexpr__68471.cljs$core$IFn$_invoke$arity$1 ? fexpr__68471.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68471.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69109)){
var error__51659__auto___69110 = temp__5753__auto___69109;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69110], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68446_69087,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69110], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__68455,G__68456,G__68457){
var validate__51657__auto__ = cljs.core.deref(ufv___69086);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69111 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68455,G__68456,G__68457], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68472_69112 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68473_69113 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__68474_69114 = input_schema68452_69089;
var G__68475_69115 = cljs.core.deref(input_checker68453_69092);
var G__68476_69116 = args__51658__auto___69111;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68472_69112,G__68473_69113,G__68474_69114,G__68475_69115,G__68476_69116) : schema.core.fn_validator.call(null,G__68472_69112,G__68473_69113,G__68474_69114,G__68475_69115,G__68476_69116));
} else {
var temp__5753__auto___69117 = (function (){var fexpr__68477 = cljs.core.deref(input_checker68453_69092);
return (fexpr__68477.cljs$core$IFn$_invoke$arity$1 ? fexpr__68477.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69111) : fexpr__68477.call(null,args__51658__auto___69111));
})();
if(cljs.core.truth_(temp__5753__auto___69117)){
var error__51659__auto___69118 = temp__5753__auto___69117;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69118], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68452_69089,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69111,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69118], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var name_kw = G__68455;
var docstring = G__68456;
var fields = G__68457;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68478_69119 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68479_69120 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__68480_69121 = output_schema68446_69087;
var G__68481_69122 = cljs.core.deref(output_checker68454_69093);
var G__68482_69123 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68478_69119,G__68479_69120,G__68480_69121,G__68481_69122,G__68482_69123) : schema.core.fn_validator.call(null,G__68478_69119,G__68479_69120,G__68480_69121,G__68481_69122,G__68482_69123));
} else {
var temp__5753__auto___69124 = (function (){var fexpr__68483 = cljs.core.deref(output_checker68454_69093);
return (fexpr__68483.cljs$core$IFn$_invoke$arity$1 ? fexpr__68483.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68483.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69124)){
var error__51659__auto___69125 = temp__5753__auto___69124;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69125], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68446_69087,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69125], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema68446_69087,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68447_69088,input_schema68452_69089], null)));

var ufv___69126 = schema.utils.use_fn_validation;
var output_schema68484_69127 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68485_69128 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema68490_69129 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker68486_69130 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68485_69128);
}),null));
var output_checker68487_69131 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68484_69127);
}),null));
var input_checker68491_69132 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68490_69129);
}),null));
var output_checker68492_69133 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68484_69127);
}),null));
var ret__54411__auto___69134 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__68497 = arguments.length;
switch (G__68497) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__68488,G__68489){
var validate__51657__auto__ = cljs.core.deref(ufv___69126);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69136 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68488,G__68489], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68498_69137 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68499_69138 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__68500_69139 = input_schema68485_69128;
var G__68501_69140 = cljs.core.deref(input_checker68486_69130);
var G__68502_69141 = args__51658__auto___69136;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68498_69137,G__68499_69138,G__68500_69139,G__68501_69140,G__68502_69141) : schema.core.fn_validator.call(null,G__68498_69137,G__68499_69138,G__68500_69139,G__68501_69140,G__68502_69141));
} else {
var temp__5753__auto___69142 = (function (){var fexpr__68503 = cljs.core.deref(input_checker68486_69130);
return (fexpr__68503.cljs$core$IFn$_invoke$arity$1 ? fexpr__68503.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69136) : fexpr__68503.call(null,args__51658__auto___69136));
})();
if(cljs.core.truth_(temp__5753__auto___69142)){
var error__51659__auto___69143 = temp__5753__auto___69142;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69143], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68485_69128,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69136,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69143], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var name_kw = G__68488;
var symbol_keywords = G__68489;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68504_69144 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68505_69145 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__68506_69146 = output_schema68484_69127;
var G__68507_69147 = cljs.core.deref(output_checker68487_69131);
var G__68508_69148 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68504_69144,G__68505_69145,G__68506_69146,G__68507_69147,G__68508_69148) : schema.core.fn_validator.call(null,G__68504_69144,G__68505_69145,G__68506_69146,G__68507_69147,G__68508_69148));
} else {
var temp__5753__auto___69149 = (function (){var fexpr__68509 = cljs.core.deref(output_checker68487_69131);
return (fexpr__68509.cljs$core$IFn$_invoke$arity$1 ? fexpr__68509.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68509.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69149)){
var error__51659__auto___69150 = temp__5753__auto___69149;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69150], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68484_69127,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69150], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__68493,G__68494,G__68495){
var validate__51657__auto__ = cljs.core.deref(ufv___69126);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69153 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68493,G__68494,G__68495], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68510_69154 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68511_69155 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__68512_69156 = input_schema68490_69129;
var G__68513_69157 = cljs.core.deref(input_checker68491_69132);
var G__68514_69158 = args__51658__auto___69153;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68510_69154,G__68511_69155,G__68512_69156,G__68513_69157,G__68514_69158) : schema.core.fn_validator.call(null,G__68510_69154,G__68511_69155,G__68512_69156,G__68513_69157,G__68514_69158));
} else {
var temp__5753__auto___69159 = (function (){var fexpr__68515 = cljs.core.deref(input_checker68491_69132);
return (fexpr__68515.cljs$core$IFn$_invoke$arity$1 ? fexpr__68515.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69153) : fexpr__68515.call(null,args__51658__auto___69153));
})();
if(cljs.core.truth_(temp__5753__auto___69159)){
var error__51659__auto___69160 = temp__5753__auto___69159;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69160], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68490_69129,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69153,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69160], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var name_kw = G__68493;
var docstring = G__68494;
var symbol_keywords = G__68495;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68516_69163 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68517_69164 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__68518_69165 = output_schema68484_69127;
var G__68519_69166 = cljs.core.deref(output_checker68492_69133);
var G__68520_69167 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68516_69163,G__68517_69164,G__68518_69165,G__68519_69166,G__68520_69167) : schema.core.fn_validator.call(null,G__68516_69163,G__68517_69164,G__68518_69165,G__68519_69166,G__68520_69167));
} else {
var temp__5753__auto___69168 = (function (){var fexpr__68521 = cljs.core.deref(output_checker68492_69133);
return (fexpr__68521.cljs$core$IFn$_invoke$arity$1 ? fexpr__68521.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68521.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69168)){
var error__51659__auto___69170 = temp__5753__auto___69168;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69170], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68484_69127,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69170], null));
} else {
}
}
} else {
}

return o__51660__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema68484_69127,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68485_69128,input_schema68490_69129], null)));

var ufv___69172 = schema.utils.use_fn_validation;
var output_schema68522_69173 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68523_69174 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker68524_69175 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68523_69174);
}),null));
var output_checker68525_69176 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68522_69173);
}),null));
var ret__54411__auto___69177 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__68526,G__68527){
var validate__51657__auto__ = cljs.core.deref(ufv___69172);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69178 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68526,G__68527], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68528_69179 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68529_69180 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__68530_69181 = input_schema68523_69174;
var G__68531_69182 = cljs.core.deref(input_checker68524_69175);
var G__68532_69183 = args__51658__auto___69178;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68528_69179,G__68529_69180,G__68530_69181,G__68531_69182,G__68532_69183) : schema.core.fn_validator.call(null,G__68528_69179,G__68529_69180,G__68530_69181,G__68531_69182,G__68532_69183));
} else {
var temp__5753__auto___69184 = (function (){var fexpr__68533 = cljs.core.deref(input_checker68524_69175);
return (fexpr__68533.cljs$core$IFn$_invoke$arity$1 ? fexpr__68533.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69178) : fexpr__68533.call(null,args__51658__auto___69178));
})();
if(cljs.core.truth_(temp__5753__auto___69184)){
var error__51659__auto___69185 = temp__5753__auto___69184;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69185], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68523_69174,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69178,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69185], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var name_kw = G__68526;
var size = G__68527;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68534_69186 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68535_69187 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__68536_69188 = output_schema68522_69173;
var G__68537_69189 = cljs.core.deref(output_checker68525_69176);
var G__68538_69190 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68534_69186,G__68535_69187,G__68536_69188,G__68537_69189,G__68538_69190) : schema.core.fn_validator.call(null,G__68534_69186,G__68535_69187,G__68536_69188,G__68537_69189,G__68538_69190));
} else {
var temp__5753__auto___69191 = (function (){var fexpr__68539 = cljs.core.deref(output_checker68525_69176);
return (fexpr__68539.cljs$core$IFn$_invoke$arity$1 ? fexpr__68539.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68539.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69191)){
var error__51659__auto___69192 = temp__5753__auto___69191;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69192], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68522_69173,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69192], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema68522_69173,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68523_69174], null)));

var ufv___69193 = schema.utils.use_fn_validation;
var output_schema68540_69194 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68541_69196 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker68542_69197 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68541_69196);
}),null));
var output_checker68543_69198 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68540_69194);
}),null));
var ret__54411__auto___69200 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__68544){
var validate__51657__auto__ = cljs.core.deref(ufv___69193);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69202 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68544], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68545_69203 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68546_69204 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__68547_69205 = input_schema68541_69196;
var G__68548_69206 = cljs.core.deref(input_checker68542_69197);
var G__68549_69207 = args__51658__auto___69202;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68545_69203,G__68546_69204,G__68547_69205,G__68548_69206,G__68549_69207) : schema.core.fn_validator.call(null,G__68545_69203,G__68546_69204,G__68547_69205,G__68548_69206,G__68549_69207));
} else {
var temp__5753__auto___69209 = (function (){var fexpr__68550 = cljs.core.deref(input_checker68542_69197);
return (fexpr__68550.cljs$core$IFn$_invoke$arity$1 ? fexpr__68550.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69202) : fexpr__68550.call(null,args__51658__auto___69202));
})();
if(cljs.core.truth_(temp__5753__auto___69209)){
var error__51659__auto___69210 = temp__5753__auto___69209;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69210], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68541_69196,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69202,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69210], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var items_schema = G__68544;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68551_69211 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68552_69212 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__68553_69213 = output_schema68540_69194;
var G__68554_69214 = cljs.core.deref(output_checker68543_69198);
var G__68555_69215 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68551_69211,G__68552_69212,G__68553_69213,G__68554_69214,G__68555_69215) : schema.core.fn_validator.call(null,G__68551_69211,G__68552_69212,G__68553_69213,G__68554_69214,G__68555_69215));
} else {
var temp__5753__auto___69216 = (function (){var fexpr__68556 = cljs.core.deref(output_checker68543_69198);
return (fexpr__68556.cljs$core$IFn$_invoke$arity$1 ? fexpr__68556.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68556.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69216)){
var error__51659__auto___69217 = temp__5753__auto___69216;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69217], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68540_69194,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69217], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema68540_69194,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68541_69196], null)));

var ufv___69218 = schema.utils.use_fn_validation;
var output_schema68557_69219 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68558_69220 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker68559_69221 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68558_69220);
}),null));
var output_checker68560_69222 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68557_69219);
}),null));
var ret__54411__auto___69224 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__68561){
var validate__51657__auto__ = cljs.core.deref(ufv___69218);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69225 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68561], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68562_69226 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68563_69227 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__68564_69228 = input_schema68558_69220;
var G__68565_69229 = cljs.core.deref(input_checker68559_69221);
var G__68566_69230 = args__51658__auto___69225;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68562_69226,G__68563_69227,G__68564_69228,G__68565_69229,G__68566_69230) : schema.core.fn_validator.call(null,G__68562_69226,G__68563_69227,G__68564_69228,G__68565_69229,G__68566_69230));
} else {
var temp__5753__auto___69231 = (function (){var fexpr__68567 = cljs.core.deref(input_checker68559_69221);
return (fexpr__68567.cljs$core$IFn$_invoke$arity$1 ? fexpr__68567.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69225) : fexpr__68567.call(null,args__51658__auto___69225));
})();
if(cljs.core.truth_(temp__5753__auto___69231)){
var error__51659__auto___69234 = temp__5753__auto___69231;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69234], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68558_69220,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69225,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69234], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var values_schema = G__68561;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68568_69235 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68569_69236 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__68570_69237 = output_schema68557_69219;
var G__68571_69238 = cljs.core.deref(output_checker68560_69222);
var G__68572_69239 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68568_69235,G__68569_69236,G__68570_69237,G__68571_69238,G__68572_69239) : schema.core.fn_validator.call(null,G__68568_69235,G__68569_69236,G__68570_69237,G__68571_69238,G__68572_69239));
} else {
var temp__5753__auto___69240 = (function (){var fexpr__68573 = cljs.core.deref(output_checker68560_69222);
return (fexpr__68573.cljs$core$IFn$_invoke$arity$1 ? fexpr__68573.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68573.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69240)){
var error__51659__auto___69241 = temp__5753__auto___69240;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69241], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68557_69219,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69241], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema68557_69219,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68558_69220], null)));

var ufv___69244 = schema.utils.use_fn_validation;
var output_schema68574_69245 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68575_69246 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker68576_69247 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68575_69246);
}),null));
var output_checker68577_69248 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68574_69245);
}),null));
var ret__54411__auto___69249 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__68578){
var validate__51657__auto__ = cljs.core.deref(ufv___69244);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69250 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68578], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68579_69251 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68580_69252 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__68581_69253 = input_schema68575_69246;
var G__68582_69254 = cljs.core.deref(input_checker68576_69247);
var G__68583_69255 = args__51658__auto___69250;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68579_69251,G__68580_69252,G__68581_69253,G__68582_69254,G__68583_69255) : schema.core.fn_validator.call(null,G__68579_69251,G__68580_69252,G__68581_69253,G__68582_69254,G__68583_69255));
} else {
var temp__5753__auto___69256 = (function (){var fexpr__68584 = cljs.core.deref(input_checker68576_69247);
return (fexpr__68584.cljs$core$IFn$_invoke$arity$1 ? fexpr__68584.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69250) : fexpr__68584.call(null,args__51658__auto___69250));
})();
if(cljs.core.truth_(temp__5753__auto___69256)){
var error__51659__auto___69257 = temp__5753__auto___69256;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69257], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68575_69246,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69250,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69257], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var member_schemas = G__68578;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68585_69259 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68586_69260 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__68587_69261 = output_schema68574_69245;
var G__68588_69262 = cljs.core.deref(output_checker68577_69248);
var G__68589_69263 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68585_69259,G__68586_69260,G__68587_69261,G__68588_69262,G__68589_69263) : schema.core.fn_validator.call(null,G__68585_69259,G__68586_69260,G__68587_69261,G__68588_69262,G__68589_69263));
} else {
var temp__5753__auto___69264 = (function (){var fexpr__68590 = cljs.core.deref(output_checker68577_69248);
return (fexpr__68590.cljs$core$IFn$_invoke$arity$1 ? fexpr__68590.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68590.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69264)){
var error__51659__auto___69265 = temp__5753__auto___69264;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69265], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68574_69245,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69265], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema68574_69245,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68575_69246], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___69266 = schema.utils.use_fn_validation;
var output_schema68591_69267 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68592_69268 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker68593_69269 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68592_69268);
}),null));
var output_checker68594_69270 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68591_69267);
}),null));
var ret__54411__auto___69272 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__68595){
var validate__51657__auto__ = cljs.core.deref(ufv___69266);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69273 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68595], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68596_69274 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68597_69275 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__68598_69276 = input_schema68592_69268;
var G__68599_69277 = cljs.core.deref(input_checker68593_69269);
var G__68600_69278 = args__51658__auto___69273;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68596_69274,G__68597_69275,G__68598_69276,G__68599_69277,G__68600_69278) : schema.core.fn_validator.call(null,G__68596_69274,G__68597_69275,G__68598_69276,G__68599_69277,G__68600_69278));
} else {
var temp__5753__auto___69279 = (function (){var fexpr__68601 = cljs.core.deref(input_checker68593_69269);
return (fexpr__68601.cljs$core$IFn$_invoke$arity$1 ? fexpr__68601.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69273) : fexpr__68601.call(null,args__51658__auto___69273));
})();
if(cljs.core.truth_(temp__5753__auto___69279)){
var error__51659__auto___69280 = temp__5753__auto___69279;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69280], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68592_69268,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69273,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69280], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68595;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68602_69282 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68603_69283 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__68604_69284 = output_schema68591_69267;
var G__68605_69285 = cljs.core.deref(output_checker68594_69270);
var G__68606_69286 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68602_69282,G__68603_69283,G__68604_69284,G__68605_69285,G__68606_69286) : schema.core.fn_validator.call(null,G__68602_69282,G__68603_69283,G__68604_69284,G__68605_69285,G__68606_69286));
} else {
var temp__5753__auto___69287 = (function (){var fexpr__68607 = cljs.core.deref(output_checker68594_69270);
return (fexpr__68607.cljs$core$IFn$_invoke$arity$1 ? fexpr__68607.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68607.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69287)){
var error__51659__auto___69289 = temp__5753__auto___69287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69289], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68591_69267,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69289], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema68591_69267,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68592_69268], null)));

var ufv___69290 = schema.utils.use_fn_validation;
var output_schema68608_69291 = deercreeklabs.baracus.ByteArray;
var input_schema68609_69292 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker68610_69293 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68609_69292);
}),null));
var output_checker68611_69294 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68608_69291);
}),null));
var ret__54411__auto___69296 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__68612,G__68613){
var validate__51657__auto__ = cljs.core.deref(ufv___69290);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69297 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68612,G__68613], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68614_69298 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68615_69299 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__68616_69300 = input_schema68609_69292;
var G__68617_69301 = cljs.core.deref(input_checker68610_69293);
var G__68618_69302 = args__51658__auto___69297;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68614_69298,G__68615_69299,G__68616_69300,G__68617_69301,G__68618_69302) : schema.core.fn_validator.call(null,G__68614_69298,G__68615_69299,G__68616_69300,G__68617_69301,G__68618_69302));
} else {
var temp__5753__auto___69304 = (function (){var fexpr__68619 = cljs.core.deref(input_checker68610_69293);
return (fexpr__68619.cljs$core$IFn$_invoke$arity$1 ? fexpr__68619.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69297) : fexpr__68619.call(null,args__51658__auto___69297));
})();
if(cljs.core.truth_(temp__5753__auto___69304)){
var error__51659__auto___69305 = temp__5753__auto___69304;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69305], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68609_69292,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69297,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69305], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var writer_schema = G__68612;
var data = G__68613;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68621_69308 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68622_69309 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__68623_69310 = output_schema68608_69291;
var G__68624_69311 = cljs.core.deref(output_checker68611_69294);
var G__68625_69312 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68621_69308,G__68622_69309,G__68623_69310,G__68624_69311,G__68625_69312) : schema.core.fn_validator.call(null,G__68621_69308,G__68622_69309,G__68623_69310,G__68624_69311,G__68625_69312));
} else {
var temp__5753__auto___69313 = (function (){var fexpr__68626 = cljs.core.deref(output_checker68611_69294);
return (fexpr__68626.cljs$core$IFn$_invoke$arity$1 ? fexpr__68626.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68626.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69313)){
var error__51659__auto___69314 = temp__5753__auto___69313;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69314], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68608_69291,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69314], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema68608_69291,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68609_69292], null)));

var ufv___69317 = schema.utils.use_fn_validation;
var output_schema68627_69318 = schema.core.Any;
var input_schema68628_69319 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker68629_69320 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68628_69319);
}),null));
var output_checker68630_69321 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68627_69318);
}),null));
var ret__54411__auto___69323 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__68631,G__68632,G__68633){
var validate__51657__auto__ = cljs.core.deref(ufv___69317);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69324 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68631,G__68632,G__68633], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68634_69325 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68635_69326 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__68636_69327 = input_schema68628_69319;
var G__68637_69328 = cljs.core.deref(input_checker68629_69320);
var G__68638_69329 = args__51658__auto___69324;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68634_69325,G__68635_69326,G__68636_69327,G__68637_69328,G__68638_69329) : schema.core.fn_validator.call(null,G__68634_69325,G__68635_69326,G__68636_69327,G__68637_69328,G__68638_69329));
} else {
var temp__5753__auto___69332 = (function (){var fexpr__68639 = cljs.core.deref(input_checker68629_69320);
return (fexpr__68639.cljs$core$IFn$_invoke$arity$1 ? fexpr__68639.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69324) : fexpr__68639.call(null,args__51658__auto___69324));
})();
if(cljs.core.truth_(temp__5753__auto___69332)){
var error__51659__auto___69333 = temp__5753__auto___69332;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69333], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68628_69319,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69324,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69333], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var reader_schema = G__68631;
var writer_schema = G__68632;
var ba = G__68633;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68642_69337 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68643_69338 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__68644_69339 = output_schema68627_69318;
var G__68645_69340 = cljs.core.deref(output_checker68630_69321);
var G__68646_69341 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68642_69337,G__68643_69338,G__68644_69339,G__68645_69340,G__68646_69341) : schema.core.fn_validator.call(null,G__68642_69337,G__68643_69338,G__68644_69339,G__68645_69340,G__68646_69341));
} else {
var temp__5753__auto___69344 = (function (){var fexpr__68647 = cljs.core.deref(output_checker68630_69321);
return (fexpr__68647.cljs$core$IFn$_invoke$arity$1 ? fexpr__68647.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68647.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69344)){
var error__51659__auto___69345 = temp__5753__auto___69344;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69345], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68627_69318,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69345], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema68627_69318,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68628_69319], null)));

var ufv___69348 = schema.utils.use_fn_validation;
var output_schema68648_69349 = schema.core.Any;
var input_schema68649_69350 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker68650_69351 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68649_69350);
}),null));
var output_checker68651_69352 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68648_69349);
}),null));
var ret__54411__auto___69354 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__68652,G__68653){
var validate__51657__auto__ = cljs.core.deref(ufv___69348);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69355 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68652,G__68653], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68654_69356 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68655_69357 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__68656_69358 = input_schema68649_69350;
var G__68657_69359 = cljs.core.deref(input_checker68650_69351);
var G__68658_69360 = args__51658__auto___69355;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68654_69356,G__68655_69357,G__68656_69358,G__68657_69359,G__68658_69360) : schema.core.fn_validator.call(null,G__68654_69356,G__68655_69357,G__68656_69358,G__68657_69359,G__68658_69360));
} else {
var temp__5753__auto___69362 = (function (){var fexpr__68659 = cljs.core.deref(input_checker68650_69351);
return (fexpr__68659.cljs$core$IFn$_invoke$arity$1 ? fexpr__68659.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69355) : fexpr__68659.call(null,args__51658__auto___69355));
})();
if(cljs.core.truth_(temp__5753__auto___69362)){
var error__51659__auto___69363 = temp__5753__auto___69362;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69363], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68649_69350,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69355,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69363], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68652;
var ba = G__68653;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68660_69365 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68661_69366 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__68662_69367 = output_schema68648_69349;
var G__68663_69368 = cljs.core.deref(output_checker68651_69352);
var G__68664_69369 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68660_69365,G__68661_69366,G__68662_69367,G__68663_69368,G__68664_69369) : schema.core.fn_validator.call(null,G__68660_69365,G__68661_69366,G__68662_69367,G__68663_69368,G__68664_69369));
} else {
var temp__5753__auto___69371 = (function (){var fexpr__68665 = cljs.core.deref(output_checker68651_69352);
return (fexpr__68665.cljs$core$IFn$_invoke$arity$1 ? fexpr__68665.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68665.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69371)){
var error__51659__auto___69372 = temp__5753__auto___69371;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69372], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68648_69349,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69372], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema68648_69349,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68649_69350], null)));

var ufv___69374 = schema.utils.use_fn_validation;
var output_schema68666_69375 = schema.core.Any;
var input_schema68667_69376 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68668_69377 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68667_69376);
}),null));
var output_checker68669_69378 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68666_69375);
}),null));
var ret__54411__auto___69380 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__68670){
var validate__51657__auto__ = cljs.core.deref(ufv___69374);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69381 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68670], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68671_69382 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68672_69383 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__68673_69384 = input_schema68667_69376;
var G__68674_69385 = cljs.core.deref(input_checker68668_69377);
var G__68675_69386 = args__51658__auto___69381;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68671_69382,G__68672_69383,G__68673_69384,G__68674_69385,G__68675_69386) : schema.core.fn_validator.call(null,G__68671_69382,G__68672_69383,G__68673_69384,G__68674_69385,G__68675_69386));
} else {
var temp__5753__auto___69387 = (function (){var fexpr__68676 = cljs.core.deref(input_checker68668_69377);
return (fexpr__68676.cljs$core$IFn$_invoke$arity$1 ? fexpr__68676.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69381) : fexpr__68676.call(null,args__51658__auto___69381));
})();
if(cljs.core.truth_(temp__5753__auto___69387)){
var error__51659__auto___69388 = temp__5753__auto___69387;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69388], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68667_69376,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69381,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69388], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68670;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68677_69392 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68678_69393 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__68679_69394 = output_schema68666_69375;
var G__68680_69395 = cljs.core.deref(output_checker68669_69378);
var G__68681_69396 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68677_69392,G__68678_69393,G__68679_69394,G__68680_69395,G__68681_69396) : schema.core.fn_validator.call(null,G__68677_69392,G__68678_69393,G__68679_69394,G__68680_69395,G__68681_69396));
} else {
var temp__5753__auto___69397 = (function (){var fexpr__68682 = cljs.core.deref(output_checker68669_69378);
return (fexpr__68682.cljs$core$IFn$_invoke$arity$1 ? fexpr__68682.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68682.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69397)){
var error__51659__auto___69398 = temp__5753__auto___69397;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69398], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68666_69375,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69398], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema68666_69375,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68667_69376], null)));

var ufv___69400 = schema.utils.use_fn_validation;
var output_schema68683_69401 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68684_69402 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker68685_69403 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68684_69402);
}),null));
var output_checker68686_69404 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68683_69401);
}),null));
var ret__54411__auto___69405 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__68687){
var validate__51657__auto__ = cljs.core.deref(ufv___69400);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69406 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68687], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68688_69407 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68689_69408 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__68690_69409 = input_schema68684_69402;
var G__68691_69410 = cljs.core.deref(input_checker68685_69403);
var G__68692_69411 = args__51658__auto___69406;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68688_69407,G__68689_69408,G__68690_69409,G__68691_69410,G__68692_69411) : schema.core.fn_validator.call(null,G__68688_69407,G__68689_69408,G__68690_69409,G__68691_69410,G__68692_69411));
} else {
var temp__5753__auto___69412 = (function (){var fexpr__68693 = cljs.core.deref(input_checker68685_69403);
return (fexpr__68693.cljs$core$IFn$_invoke$arity$1 ? fexpr__68693.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69406) : fexpr__68693.call(null,args__51658__auto___69406));
})();
if(cljs.core.truth_(temp__5753__auto___69412)){
var error__51659__auto___69414 = temp__5753__auto___69412;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69414], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68684_69402,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69406,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69414], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var edn = G__68687;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68694_69415 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68695_69416 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__68696_69417 = output_schema68683_69401;
var G__68697_69418 = cljs.core.deref(output_checker68686_69404);
var G__68698_69419 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68694_69415,G__68695_69416,G__68696_69417,G__68697_69418,G__68698_69419) : schema.core.fn_validator.call(null,G__68694_69415,G__68695_69416,G__68696_69417,G__68697_69418,G__68698_69419));
} else {
var temp__5753__auto___69420 = (function (){var fexpr__68699 = cljs.core.deref(output_checker68686_69404);
return (fexpr__68699.cljs$core$IFn$_invoke$arity$1 ? fexpr__68699.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68699.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69420)){
var error__51659__auto___69422 = temp__5753__auto___69420;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69422], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68683_69401,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69422], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema68683_69401,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68684_69402], null)));

var ufv___69423 = schema.utils.use_fn_validation;
var output_schema68700_69424 = schema.core.Str;
var input_schema68701_69425 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68702_69426 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68701_69425);
}),null));
var output_checker68703_69427 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68700_69424);
}),null));
var ret__54411__auto___69428 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__68704){
var validate__51657__auto__ = cljs.core.deref(ufv___69423);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69429 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68704], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68705_69430 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68706_69431 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__68707_69432 = input_schema68701_69425;
var G__68708_69433 = cljs.core.deref(input_checker68702_69426);
var G__68709_69434 = args__51658__auto___69429;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68705_69430,G__68706_69431,G__68707_69432,G__68708_69433,G__68709_69434) : schema.core.fn_validator.call(null,G__68705_69430,G__68706_69431,G__68707_69432,G__68708_69433,G__68709_69434));
} else {
var temp__5753__auto___69438 = (function (){var fexpr__68710 = cljs.core.deref(input_checker68702_69426);
return (fexpr__68710.cljs$core$IFn$_invoke$arity$1 ? fexpr__68710.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69429) : fexpr__68710.call(null,args__51658__auto___69429));
})();
if(cljs.core.truth_(temp__5753__auto___69438)){
var error__51659__auto___69440 = temp__5753__auto___69438;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69440], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68701_69425,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69429,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69440], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68704;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68711_69443 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68712_69444 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__68713_69445 = output_schema68700_69424;
var G__68714_69446 = cljs.core.deref(output_checker68703_69427);
var G__68715_69447 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68711_69443,G__68712_69444,G__68713_69445,G__68714_69446,G__68715_69447) : schema.core.fn_validator.call(null,G__68711_69443,G__68712_69444,G__68713_69445,G__68714_69446,G__68715_69447));
} else {
var temp__5753__auto___69448 = (function (){var fexpr__68716 = cljs.core.deref(output_checker68703_69427);
return (fexpr__68716.cljs$core$IFn$_invoke$arity$1 ? fexpr__68716.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68716.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69448)){
var error__51659__auto___69449 = temp__5753__auto___69448;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69449], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68700_69424,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69449], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema68700_69424,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68701_69425], null)));

var ufv___69450 = schema.utils.use_fn_validation;
var output_schema68717_69451 = schema.core.Keyword;
var input_schema68718_69452 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68719_69453 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68718_69452);
}),null));
var output_checker68720_69454 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68717_69451);
}),null));
var ret__54411__auto___69455 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__68721){
var validate__51657__auto__ = cljs.core.deref(ufv___69450);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69456 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68721], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68722_69457 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68723_69458 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__68724_69459 = input_schema68718_69452;
var G__68725_69460 = cljs.core.deref(input_checker68719_69453);
var G__68726_69461 = args__51658__auto___69456;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68722_69457,G__68723_69458,G__68724_69459,G__68725_69460,G__68726_69461) : schema.core.fn_validator.call(null,G__68722_69457,G__68723_69458,G__68724_69459,G__68725_69460,G__68726_69461));
} else {
var temp__5753__auto___69463 = (function (){var fexpr__68727 = cljs.core.deref(input_checker68719_69453);
return (fexpr__68727.cljs$core$IFn$_invoke$arity$1 ? fexpr__68727.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69456) : fexpr__68727.call(null,args__51658__auto___69456));
})();
if(cljs.core.truth_(temp__5753__auto___69463)){
var error__51659__auto___69465 = temp__5753__auto___69463;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69465], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68718_69452,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69456,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69465], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68721;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68728_69466 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68729_69467 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__68730_69468 = output_schema68717_69451;
var G__68731_69469 = cljs.core.deref(output_checker68720_69454);
var G__68732_69470 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68728_69466,G__68729_69467,G__68730_69468,G__68731_69469,G__68732_69470) : schema.core.fn_validator.call(null,G__68728_69466,G__68729_69467,G__68730_69468,G__68731_69469,G__68732_69470));
} else {
var temp__5753__auto___69471 = (function (){var fexpr__68733 = cljs.core.deref(output_checker68720_69454);
return (fexpr__68733.cljs$core$IFn$_invoke$arity$1 ? fexpr__68733.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68733.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69471)){
var error__51659__auto___69472 = temp__5753__auto___69471;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69472], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68717_69451,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69472], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema68717_69451,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68718_69452], null)));

var ufv___69473 = schema.utils.use_fn_validation;
var output_schema68734_69474 = schema.core.Str;
var input_schema68735_69475 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68736_69476 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68735_69475);
}),null));
var output_checker68737_69477 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68734_69474);
}),null));
var ret__54411__auto___69478 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__68738){
var validate__51657__auto__ = cljs.core.deref(ufv___69473);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69479 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68738], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68739_69481 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68740_69482 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__68741_69483 = input_schema68735_69475;
var G__68742_69484 = cljs.core.deref(input_checker68736_69476);
var G__68743_69485 = args__51658__auto___69479;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68739_69481,G__68740_69482,G__68741_69483,G__68742_69484,G__68743_69485) : schema.core.fn_validator.call(null,G__68739_69481,G__68740_69482,G__68741_69483,G__68742_69484,G__68743_69485));
} else {
var temp__5753__auto___69487 = (function (){var fexpr__68744 = cljs.core.deref(input_checker68736_69476);
return (fexpr__68744.cljs$core$IFn$_invoke$arity$1 ? fexpr__68744.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69479) : fexpr__68744.call(null,args__51658__auto___69479));
})();
if(cljs.core.truth_(temp__5753__auto___69487)){
var error__51659__auto___69488 = temp__5753__auto___69487;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69488], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68735_69475,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69479,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69488], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68738;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68745_69490 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68746_69491 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__68747_69492 = output_schema68734_69474;
var G__68748_69493 = cljs.core.deref(output_checker68737_69477);
var G__68749_69494 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68745_69490,G__68746_69491,G__68747_69492,G__68748_69493,G__68749_69494) : schema.core.fn_validator.call(null,G__68745_69490,G__68746_69491,G__68747_69492,G__68748_69493,G__68749_69494));
} else {
var temp__5753__auto___69495 = (function (){var fexpr__68750 = cljs.core.deref(output_checker68737_69477);
return (fexpr__68750.cljs$core$IFn$_invoke$arity$1 ? fexpr__68750.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68750.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69495)){
var error__51659__auto___69496 = temp__5753__auto___69495;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69496], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68734_69474,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69496], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema68734_69474,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68735_69475], null)));

var ufv___69497 = schema.utils.use_fn_validation;
var output_schema68751_69498 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema68752_69499 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68753_69500 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68752_69499);
}),null));
var output_checker68754_69501 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68751_69498);
}),null));
var ret__54411__auto___69503 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__68755){
var validate__51657__auto__ = cljs.core.deref(ufv___69497);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69504 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68755], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68756_69506 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68757_69507 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__68758_69508 = input_schema68752_69499;
var G__68759_69509 = cljs.core.deref(input_checker68753_69500);
var G__68760_69510 = args__51658__auto___69504;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68756_69506,G__68757_69507,G__68758_69508,G__68759_69509,G__68760_69510) : schema.core.fn_validator.call(null,G__68756_69506,G__68757_69507,G__68758_69508,G__68759_69509,G__68760_69510));
} else {
var temp__5753__auto___69512 = (function (){var fexpr__68761 = cljs.core.deref(input_checker68753_69500);
return (fexpr__68761.cljs$core$IFn$_invoke$arity$1 ? fexpr__68761.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69504) : fexpr__68761.call(null,args__51658__auto___69504));
})();
if(cljs.core.truth_(temp__5753__auto___69512)){
var error__51659__auto___69513 = temp__5753__auto___69512;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69513], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68752_69499,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69504,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69513], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68755;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68762_69515 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68763_69516 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__68764_69517 = output_schema68751_69498;
var G__68765_69518 = cljs.core.deref(output_checker68754_69501);
var G__68766_69519 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68762_69515,G__68763_69516,G__68764_69517,G__68765_69518,G__68766_69519) : schema.core.fn_validator.call(null,G__68762_69515,G__68763_69516,G__68764_69517,G__68765_69518,G__68766_69519));
} else {
var temp__5753__auto___69521 = (function (){var fexpr__68767 = cljs.core.deref(output_checker68754_69501);
return (fexpr__68767.cljs$core$IFn$_invoke$arity$1 ? fexpr__68767.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68767.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69521)){
var error__51659__auto___69523 = temp__5753__auto___69521;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69523], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68751_69498,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69523], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema68751_69498,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68752_69499], null)));

var ufv___69524 = schema.utils.use_fn_validation;
var output_schema68768_69525 = deercreeklabs.baracus.ByteArray;
var input_schema68769_69526 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68770_69527 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68769_69526);
}),null));
var output_checker68771_69528 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68768_69525);
}),null));
var ret__54411__auto___69531 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__68772){
var validate__51657__auto__ = cljs.core.deref(ufv___69524);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69532 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68772], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68773_69533 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68774_69534 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__68775_69535 = input_schema68769_69526;
var G__68776_69536 = cljs.core.deref(input_checker68770_69527);
var G__68777_69537 = args__51658__auto___69532;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68773_69533,G__68774_69534,G__68775_69535,G__68776_69536,G__68777_69537) : schema.core.fn_validator.call(null,G__68773_69533,G__68774_69534,G__68775_69535,G__68776_69536,G__68777_69537));
} else {
var temp__5753__auto___69541 = (function (){var fexpr__68778 = cljs.core.deref(input_checker68770_69527);
return (fexpr__68778.cljs$core$IFn$_invoke$arity$1 ? fexpr__68778.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69532) : fexpr__68778.call(null,args__51658__auto___69532));
})();
if(cljs.core.truth_(temp__5753__auto___69541)){
var error__51659__auto___69542 = temp__5753__auto___69541;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69542], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68769_69526,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69532,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69542], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68772;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68779_69544 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68780_69545 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__68781_69546 = output_schema68768_69525;
var G__68782_69547 = cljs.core.deref(output_checker68771_69528);
var G__68783_69548 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68779_69544,G__68780_69545,G__68781_69546,G__68782_69547,G__68783_69548) : schema.core.fn_validator.call(null,G__68779_69544,G__68780_69545,G__68781_69546,G__68782_69547,G__68783_69548));
} else {
var temp__5753__auto___69549 = (function (){var fexpr__68784 = cljs.core.deref(output_checker68771_69528);
return (fexpr__68784.cljs$core$IFn$_invoke$arity$1 ? fexpr__68784.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68784.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69549)){
var error__51659__auto___69550 = temp__5753__auto___69549;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69550], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68768_69525,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69550], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema68768_69525,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68769_69526], null)));

var ufv___69551 = schema.utils.use_fn_validation;
var output_schema68785_69552 = deercreeklabs.baracus.ByteArray;
var input_schema68786_69553 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68787_69554 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68786_69553);
}),null));
var output_checker68788_69555 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68785_69552);
}),null));
var ret__54411__auto___69556 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__68789){
var validate__51657__auto__ = cljs.core.deref(ufv___69551);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69557 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68789], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68790_69558 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68791_69559 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__68792_69560 = input_schema68786_69553;
var G__68793_69561 = cljs.core.deref(input_checker68787_69554);
var G__68794_69562 = args__51658__auto___69557;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68790_69558,G__68791_69559,G__68792_69560,G__68793_69561,G__68794_69562) : schema.core.fn_validator.call(null,G__68790_69558,G__68791_69559,G__68792_69560,G__68793_69561,G__68794_69562));
} else {
var temp__5753__auto___69563 = (function (){var fexpr__68795 = cljs.core.deref(input_checker68787_69554);
return (fexpr__68795.cljs$core$IFn$_invoke$arity$1 ? fexpr__68795.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69557) : fexpr__68795.call(null,args__51658__auto___69557));
})();
if(cljs.core.truth_(temp__5753__auto___69563)){
var error__51659__auto___69564 = temp__5753__auto___69563;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69564], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68786_69553,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69557,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69564], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68789;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68796_69565 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68797_69566 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__68798_69567 = output_schema68785_69552;
var G__68799_69568 = cljs.core.deref(output_checker68788_69555);
var G__68800_69569 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68796_69565,G__68797_69566,G__68798_69567,G__68799_69568,G__68800_69569) : schema.core.fn_validator.call(null,G__68796_69565,G__68797_69566,G__68798_69567,G__68799_69568,G__68800_69569));
} else {
var temp__5753__auto___69571 = (function (){var fexpr__68801 = cljs.core.deref(output_checker68788_69555);
return (fexpr__68801.cljs$core$IFn$_invoke$arity$1 ? fexpr__68801.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68801.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69571)){
var error__51659__auto___69573 = temp__5753__auto___69571;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69573], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68785_69552,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69573], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema68785_69552,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68786_69553], null)));

var ufv___69574 = schema.utils.use_fn_validation;
var output_schema68802_69575 = schema.core.Bool;
var input_schema68803_69576 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker68804_69577 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68803_69576);
}),null));
var output_checker68805_69578 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68802_69575);
}),null));
var ret__54411__auto___69579 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__68806){
var validate__51657__auto__ = cljs.core.deref(ufv___69574);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69580 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68806], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68807_69581 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68808_69582 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__68809_69583 = input_schema68803_69576;
var G__68810_69584 = cljs.core.deref(input_checker68804_69577);
var G__68811_69585 = args__51658__auto___69580;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68807_69581,G__68808_69582,G__68809_69583,G__68810_69584,G__68811_69585) : schema.core.fn_validator.call(null,G__68807_69581,G__68808_69582,G__68809_69583,G__68810_69584,G__68811_69585));
} else {
var temp__5753__auto___69588 = (function (){var fexpr__68812 = cljs.core.deref(input_checker68804_69577);
return (fexpr__68812.cljs$core$IFn$_invoke$arity$1 ? fexpr__68812.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69580) : fexpr__68812.call(null,args__51658__auto___69580));
})();
if(cljs.core.truth_(temp__5753__auto___69588)){
var error__51659__auto___69589 = temp__5753__auto___69588;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69589], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68803_69576,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69580,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69589], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var arg = G__68806;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68814_69591 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68815_69592 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__68816_69593 = output_schema68802_69575;
var G__68817_69594 = cljs.core.deref(output_checker68805_69578);
var G__68818_69595 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68814_69591,G__68815_69592,G__68816_69593,G__68817_69594,G__68818_69595) : schema.core.fn_validator.call(null,G__68814_69591,G__68815_69592,G__68816_69593,G__68817_69594,G__68818_69595));
} else {
var temp__5753__auto___69597 = (function (){var fexpr__68819 = cljs.core.deref(output_checker68805_69578);
return (fexpr__68819.cljs$core$IFn$_invoke$arity$1 ? fexpr__68819.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68819.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69597)){
var error__51659__auto___69598 = temp__5753__auto___69597;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69598], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68802_69575,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69598], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema68802_69575,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68803_69576], null)));

var ufv___69600 = schema.utils.use_fn_validation;
var output_schema68820_69601 = schema.core.Bool;
var input_schema68821_69602 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68822_69603 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68821_69602);
}),null));
var output_checker68823_69604 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68820_69601);
}),null));
var ret__54411__auto___69608 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__68824,G__68825){
var validate__51657__auto__ = cljs.core.deref(ufv___69600);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69609 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68824,G__68825], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68826_69610 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68827_69611 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__68828_69612 = input_schema68821_69602;
var G__68829_69613 = cljs.core.deref(input_checker68822_69603);
var G__68830_69614 = args__51658__auto___69609;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68826_69610,G__68827_69611,G__68828_69612,G__68829_69613,G__68830_69614) : schema.core.fn_validator.call(null,G__68826_69610,G__68827_69611,G__68828_69612,G__68829_69613,G__68830_69614));
} else {
var temp__5753__auto___69615 = (function (){var fexpr__68831 = cljs.core.deref(input_checker68822_69603);
return (fexpr__68831.cljs$core$IFn$_invoke$arity$1 ? fexpr__68831.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69609) : fexpr__68831.call(null,args__51658__auto___69609));
})();
if(cljs.core.truth_(temp__5753__auto___69615)){
var error__51659__auto___69616 = temp__5753__auto___69615;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69616], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68821_69602,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69609,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69616], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var reader_schema = G__68824;
var writer_schema = G__68825;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68839_69617 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68840_69618 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__68841_69619 = output_schema68820_69601;
var G__68842_69620 = cljs.core.deref(output_checker68823_69604);
var G__68843_69621 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68839_69617,G__68840_69618,G__68841_69619,G__68842_69620,G__68843_69621) : schema.core.fn_validator.call(null,G__68839_69617,G__68840_69618,G__68841_69619,G__68842_69620,G__68843_69621));
} else {
var temp__5753__auto___69623 = (function (){var fexpr__68845 = cljs.core.deref(output_checker68823_69604);
return (fexpr__68845.cljs$core$IFn$_invoke$arity$1 ? fexpr__68845.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68845.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69623)){
var error__51659__auto___69624 = temp__5753__auto___69623;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69624], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68820_69601,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69624], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema68820_69601,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68821_69602], null)));

var ufv___69625 = schema.utils.use_fn_validation;
var output_schema68848_69626 = schema.core.Any;
var input_schema68849_69627 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68850_69628 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68849_69627);
}),null));
var output_checker68851_69629 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68848_69626);
}),null));
var ret__54411__auto___69630 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__68852){
var validate__51657__auto__ = cljs.core.deref(ufv___69625);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69631 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68852], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68858_69632 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68859_69633 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__68860_69634 = input_schema68849_69627;
var G__68861_69635 = cljs.core.deref(input_checker68850_69628);
var G__68862_69636 = args__51658__auto___69631;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68858_69632,G__68859_69633,G__68860_69634,G__68861_69635,G__68862_69636) : schema.core.fn_validator.call(null,G__68858_69632,G__68859_69633,G__68860_69634,G__68861_69635,G__68862_69636));
} else {
var temp__5753__auto___69638 = (function (){var fexpr__68863 = cljs.core.deref(input_checker68850_69628);
return (fexpr__68863.cljs$core$IFn$_invoke$arity$1 ? fexpr__68863.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69631) : fexpr__68863.call(null,args__51658__auto___69631));
})();
if(cljs.core.truth_(temp__5753__auto___69638)){
var error__51659__auto___69639 = temp__5753__auto___69638;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69639], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68849_69627,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69631,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69639], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68852;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68865_69642 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68866_69643 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__68867_69644 = output_schema68848_69626;
var G__68868_69645 = cljs.core.deref(output_checker68851_69629);
var G__68869_69646 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68865_69642,G__68866_69643,G__68867_69644,G__68868_69645,G__68869_69646) : schema.core.fn_validator.call(null,G__68865_69642,G__68866_69643,G__68867_69644,G__68868_69645,G__68869_69646));
} else {
var temp__5753__auto___69647 = (function (){var fexpr__68870 = cljs.core.deref(output_checker68851_69629);
return (fexpr__68870.cljs$core$IFn$_invoke$arity$1 ? fexpr__68870.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68870.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69647)){
var error__51659__auto___69648 = temp__5753__auto___69647;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69648], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68848_69626,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69648], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema68848_69626,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68849_69627], null)));

var ufv___69649 = schema.utils.use_fn_validation;
var output_schema68872_69650 = schema.core.Any;
var input_schema68873_69651 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68874_69652 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68873_69651);
}),null));
var output_checker68875_69653 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68872_69650);
}),null));
var ret__54411__auto___69654 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__68876){
var validate__51657__auto__ = cljs.core.deref(ufv___69649);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69655 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68876], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68878_69656 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68879_69657 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__68880_69658 = input_schema68873_69651;
var G__68881_69659 = cljs.core.deref(input_checker68874_69652);
var G__68882_69660 = args__51658__auto___69655;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68878_69656,G__68879_69657,G__68880_69658,G__68881_69659,G__68882_69660) : schema.core.fn_validator.call(null,G__68878_69656,G__68879_69657,G__68880_69658,G__68881_69659,G__68882_69660));
} else {
var temp__5753__auto___69661 = (function (){var fexpr__68883 = cljs.core.deref(input_checker68874_69652);
return (fexpr__68883.cljs$core$IFn$_invoke$arity$1 ? fexpr__68883.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69655) : fexpr__68883.call(null,args__51658__auto___69655));
})();
if(cljs.core.truth_(temp__5753__auto___69661)){
var error__51659__auto___69662 = temp__5753__auto___69661;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69662], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68873_69651,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69655,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69662], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68876;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68886_69665 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68887_69666 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__68888_69667 = output_schema68872_69650;
var G__68889_69668 = cljs.core.deref(output_checker68875_69653);
var G__68890_69669 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68886_69665,G__68887_69666,G__68888_69667,G__68889_69668,G__68890_69669) : schema.core.fn_validator.call(null,G__68886_69665,G__68887_69666,G__68888_69667,G__68889_69668,G__68890_69669));
} else {
var temp__5753__auto___69671 = (function (){var fexpr__68892 = cljs.core.deref(output_checker68875_69653);
return (fexpr__68892.cljs$core$IFn$_invoke$arity$1 ? fexpr__68892.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68892.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69671)){
var error__51659__auto___69672 = temp__5753__auto___69671;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69672], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68872_69650,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69672], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema68872_69650,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68873_69651], null)));

var ufv___69675 = schema.utils.use_fn_validation;
var output_schema68901_69676 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema68905_69677 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_checker68906_69678 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68905_69677);
}),null));
var output_checker68907_69679 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68901_69676);
}),null));
var ret__54411__auto___69680 = /**
 * Inputs: [schema :- LancasterSchema path :- [s/Any]]
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(G__68908,G__68909){
var validate__51657__auto__ = cljs.core.deref(ufv___69675);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69681 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68908,G__68909], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68915_69682 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68916_69683 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__68917_69684 = input_schema68905_69677;
var G__68918_69685 = cljs.core.deref(input_checker68906_69678);
var G__68919_69686 = args__51658__auto___69681;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68915_69682,G__68916_69683,G__68917_69684,G__68918_69685,G__68919_69686) : schema.core.fn_validator.call(null,G__68915_69682,G__68916_69683,G__68917_69684,G__68918_69685,G__68919_69686));
} else {
var temp__5753__auto___69687 = (function (){var fexpr__68920 = cljs.core.deref(input_checker68906_69678);
return (fexpr__68920.cljs$core$IFn$_invoke$arity$1 ? fexpr__68920.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69681) : fexpr__68920.call(null,args__51658__auto___69681));
})();
if(cljs.core.truth_(temp__5753__auto___69687)){
var error__51659__auto___69688 = temp__5753__auto___69687;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69688], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68905_69677,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69681,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69688], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68908;
var path = G__68909;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

if((path == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path], null));
}
}

return deercreeklabs.lancaster.sub.schema_at_path(schema__$1,path);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68930_69690 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68931_69691 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__68932_69692 = output_schema68901_69676;
var G__68933_69693 = cljs.core.deref(output_checker68907_69679);
var G__68934_69694 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68930_69690,G__68931_69691,G__68932_69692,G__68933_69693,G__68934_69694) : schema.core.fn_validator.call(null,G__68930_69690,G__68931_69691,G__68932_69692,G__68933_69693,G__68934_69694));
} else {
var temp__5753__auto___69696 = (function (){var fexpr__68935 = cljs.core.deref(output_checker68907_69679);
return (fexpr__68935.cljs$core$IFn$_invoke$arity$1 ? fexpr__68935.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68935.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69696)){
var error__51659__auto___69697 = temp__5753__auto___69696;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69697], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68901_69676,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69697], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.__GT_FnSchema(output_schema68901_69676,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68905_69677], null)));

var ufv___69699 = schema.utils.use_fn_validation;
var output_schema68936_69700 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema68937_69701 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68938_69702 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68937_69701);
}),null));
var output_checker68939_69703 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68936_69700);
}),null));
var ret__54411__auto___69705 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__68940){
var validate__51657__auto__ = cljs.core.deref(ufv___69699);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69706 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68940], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68942_69707 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68943_69708 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__68944_69709 = input_schema68937_69701;
var G__68945_69710 = cljs.core.deref(input_checker68938_69702);
var G__68946_69711 = args__51658__auto___69706;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68942_69707,G__68943_69708,G__68944_69709,G__68945_69710,G__68946_69711) : schema.core.fn_validator.call(null,G__68942_69707,G__68943_69708,G__68944_69709,G__68945_69710,G__68946_69711));
} else {
var temp__5753__auto___69712 = (function (){var fexpr__68947 = cljs.core.deref(input_checker68938_69702);
return (fexpr__68947.cljs$core$IFn$_invoke$arity$1 ? fexpr__68947.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69706) : fexpr__68947.call(null,args__51658__auto___69706));
})();
if(cljs.core.truth_(temp__5753__auto___69712)){
var error__51659__auto___69713 = temp__5753__auto___69712;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69713], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68937_69701,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69706,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69713], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var union_schema = G__68940;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68951_69715 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68952_69716 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__68953_69717 = output_schema68936_69700;
var G__68954_69718 = cljs.core.deref(output_checker68939_69703);
var G__68955_69719 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68951_69715,G__68952_69716,G__68953_69717,G__68954_69718,G__68955_69719) : schema.core.fn_validator.call(null,G__68951_69715,G__68952_69716,G__68953_69717,G__68954_69718,G__68955_69719));
} else {
var temp__5753__auto___69720 = (function (){var fexpr__68956 = cljs.core.deref(output_checker68939_69703);
return (fexpr__68956.cljs$core$IFn$_invoke$arity$1 ? fexpr__68956.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68956.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69720)){
var error__51659__auto___69721 = temp__5753__auto___69720;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69721], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68936_69700,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69721], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema68936_69700,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68937_69701], null)));

var ufv___69722 = schema.utils.use_fn_validation;
var output_schema68959_69723 = deercreeklabs.lancaster.LancasterSchema;
var input_schema68960_69724 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker68961_69725 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68960_69724);
}),null));
var output_checker68962_69726 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68959_69723);
}),null));
var ret__54411__auto___69727 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__68963,G__68964){
var validate__51657__auto__ = cljs.core.deref(ufv___69722);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69728 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68963,G__68964], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68966_69729 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68967_69730 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__68968_69731 = input_schema68960_69724;
var G__68969_69732 = cljs.core.deref(input_checker68961_69725);
var G__68970_69733 = args__51658__auto___69728;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68966_69729,G__68967_69730,G__68968_69731,G__68969_69732,G__68970_69733) : schema.core.fn_validator.call(null,G__68966_69729,G__68967_69730,G__68968_69731,G__68969_69732,G__68970_69733));
} else {
var temp__5753__auto___69734 = (function (){var fexpr__68972 = cljs.core.deref(input_checker68961_69725);
return (fexpr__68972.cljs$core$IFn$_invoke$arity$1 ? fexpr__68972.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69728) : fexpr__68972.call(null,args__51658__auto___69728));
})();
if(cljs.core.truth_(temp__5753__auto___69734)){
var error__51659__auto___69735 = temp__5753__auto___69734;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69735], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68960_69724,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69728,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69735], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var union_schema = G__68963;
var branch_index = G__68964;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = union_schema;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = branch_index;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68977_69736 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68978_69737 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__68979_69738 = output_schema68959_69723;
var G__68980_69739 = cljs.core.deref(output_checker68962_69726);
var G__68981_69740 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68977_69736,G__68978_69737,G__68979_69738,G__68980_69739,G__68981_69740) : schema.core.fn_validator.call(null,G__68977_69736,G__68978_69737,G__68979_69738,G__68980_69739,G__68981_69740));
} else {
var temp__5753__auto___69741 = (function (){var fexpr__68984 = cljs.core.deref(output_checker68962_69726);
return (fexpr__68984.cljs$core$IFn$_invoke$arity$1 ? fexpr__68984.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__68984.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69741)){
var error__51659__auto___69742 = temp__5753__auto___69741;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69742], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68959_69723,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69742], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema68959_69723,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68960_69724], null)));

var ufv___69743 = schema.utils.use_fn_validation;
var output_schema68985_69744 = schema.core.Keyword;
var input_schema68986_69745 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker68987_69746 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema68986_69745);
}),null));
var output_checker68988_69747 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema68985_69744);
}),null));
var ret__54411__auto___69748 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__68989){
var validate__51657__auto__ = cljs.core.deref(ufv___69743);
if(cljs.core.truth_(validate__51657__auto__)){
var args__51658__auto___69749 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__68989], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68990_69750 = new cljs.core.Keyword(null,"input","input",556931961);
var G__68991_69751 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__68992_69752 = input_schema68986_69745;
var G__68993_69753 = cljs.core.deref(input_checker68987_69746);
var G__68994_69754 = args__51658__auto___69749;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68990_69750,G__68991_69751,G__68992_69752,G__68993_69753,G__68994_69754) : schema.core.fn_validator.call(null,G__68990_69750,G__68991_69751,G__68992_69752,G__68993_69753,G__68994_69754));
} else {
var temp__5753__auto___69755 = (function (){var fexpr__68995 = cljs.core.deref(input_checker68987_69746);
return (fexpr__68995.cljs$core$IFn$_invoke$arity$1 ? fexpr__68995.cljs$core$IFn$_invoke$arity$1(args__51658__auto___69749) : fexpr__68995.call(null,args__51658__auto___69749));
})();
if(cljs.core.truth_(temp__5753__auto___69755)){
var error__51659__auto___69756 = temp__5753__auto___69755;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69756], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema68986_69745,new cljs.core.Keyword(null,"value","value",305978217),args__51658__auto___69749,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69756], null));
} else {
}
}
} else {
}

var o__51660__auto__ = (function (){var schema__$1 = G__68989;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__51657__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__68998_69758 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__68999_69759 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__69000_69760 = output_schema68985_69744;
var G__69001_69761 = cljs.core.deref(output_checker68988_69747);
var G__69002_69762 = o__51660__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__68998_69758,G__68999_69759,G__69000_69760,G__69001_69761,G__69002_69762) : schema.core.fn_validator.call(null,G__68998_69758,G__68999_69759,G__69000_69760,G__69001_69761,G__69002_69762));
} else {
var temp__5753__auto___69763 = (function (){var fexpr__69004 = cljs.core.deref(output_checker68988_69747);
return (fexpr__69004.cljs$core$IFn$_invoke$arity$1 ? fexpr__69004.cljs$core$IFn$_invoke$arity$1(o__51660__auto__) : fexpr__69004.call(null,o__51660__auto__));
})();
if(cljs.core.truth_(temp__5753__auto___69763)){
var error__51659__auto___69764 = temp__5753__auto___69763;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__51659__auto___69764], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema68985_69744,new cljs.core.Keyword(null,"value","value",305978217),o__51660__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__51659__auto___69764], null));
} else {
}
}
} else {
}

return o__51660__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema68985_69744,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema68986_69745], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
