goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31209 = arguments.length;
switch (G__31209) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31211 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31211 = (function (f,blockable,meta31212){
this.f = f;
this.blockable = blockable;
this.meta31212 = meta31212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31213,meta31212__$1){
var self__ = this;
var _31213__$1 = this;
return (new cljs.core.async.t_cljs$core$async31211(self__.f,self__.blockable,meta31212__$1));
}));

(cljs.core.async.t_cljs$core$async31211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31213){
var self__ = this;
var _31213__$1 = this;
return self__.meta31212;
}));

(cljs.core.async.t_cljs$core$async31211.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31211.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31211.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async31211.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async31211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31212","meta31212",-887190776,null)], null);
}));

(cljs.core.async.t_cljs$core$async31211.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31211");

(cljs.core.async.t_cljs$core$async31211.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31211");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31211.
 */
cljs.core.async.__GT_t_cljs$core$async31211 = (function cljs$core$async$__GT_t_cljs$core$async31211(f__$1,blockable__$1,meta31212){
return (new cljs.core.async.t_cljs$core$async31211(f__$1,blockable__$1,meta31212));
});

}

return (new cljs.core.async.t_cljs$core$async31211(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31243 = arguments.length;
switch (G__31243) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31252 = arguments.length;
switch (G__31252) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31268 = arguments.length;
switch (G__31268) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34344 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34344) : fn1.call(null,val_34344));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34344) : fn1.call(null,val_34344));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31277 = arguments.length;
switch (G__31277) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___34363 = n;
var x_34364 = (0);
while(true){
if((x_34364 < n__5636__auto___34363)){
(a[x_34364] = x_34364);

var G__34366 = (x_34364 + (1));
x_34364 = G__34366;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31289 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31289 = (function (flag,meta31290){
this.flag = flag;
this.meta31290 = meta31290;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31289.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31291,meta31290__$1){
var self__ = this;
var _31291__$1 = this;
return (new cljs.core.async.t_cljs$core$async31289(self__.flag,meta31290__$1));
}));

(cljs.core.async.t_cljs$core$async31289.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31291){
var self__ = this;
var _31291__$1 = this;
return self__.meta31290;
}));

(cljs.core.async.t_cljs$core$async31289.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31289.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31289.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31289.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async31289.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31290","meta31290",1784265938,null)], null);
}));

(cljs.core.async.t_cljs$core$async31289.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31289.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31289");

(cljs.core.async.t_cljs$core$async31289.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31289");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31289.
 */
cljs.core.async.__GT_t_cljs$core$async31289 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31289(flag__$1,meta31290){
return (new cljs.core.async.t_cljs$core$async31289(flag__$1,meta31290));
});

}

return (new cljs.core.async.t_cljs$core$async31289(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31306 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31306 = (function (flag,cb,meta31307){
this.flag = flag;
this.cb = cb;
this.meta31307 = meta31307;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31306.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31308,meta31307__$1){
var self__ = this;
var _31308__$1 = this;
return (new cljs.core.async.t_cljs$core$async31306(self__.flag,self__.cb,meta31307__$1));
}));

(cljs.core.async.t_cljs$core$async31306.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31308){
var self__ = this;
var _31308__$1 = this;
return self__.meta31307;
}));

(cljs.core.async.t_cljs$core$async31306.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31306.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31306.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31306.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async31306.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31307","meta31307",2092895045,null)], null);
}));

(cljs.core.async.t_cljs$core$async31306.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31306.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31306");

(cljs.core.async.t_cljs$core$async31306.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31306");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31306.
 */
cljs.core.async.__GT_t_cljs$core$async31306 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31306(flag__$1,cb__$1,meta31307){
return (new cljs.core.async.t_cljs$core$async31306(flag__$1,cb__$1,meta31307));
});

}

return (new cljs.core.async.t_cljs$core$async31306(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31320_SHARP_){
var G__31331 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31320_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31331) : fret.call(null,G__31331));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31322_SHARP_){
var G__31332 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31322_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31332) : fret.call(null,G__31332));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34401 = (i + (1));
i = G__34401;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34405 = arguments.length;
var i__5770__auto___34406 = (0);
while(true){
if((i__5770__auto___34406 < len__5769__auto___34405)){
args__5775__auto__.push((arguments[i__5770__auto___34406]));

var G__34408 = (i__5770__auto___34406 + (1));
i__5770__auto___34406 = G__34408;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31347){
var map__31348 = p__31347;
var map__31348__$1 = cljs.core.__destructure_map(map__31348);
var opts = map__31348__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31342){
var G__31343 = cljs.core.first(seq31342);
var seq31342__$1 = cljs.core.next(seq31342);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31343,seq31342__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31360 = arguments.length;
switch (G__31360) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31116__auto___34426 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_31429){
var state_val_31430 = (state_31429[(1)]);
if((state_val_31430 === (7))){
var inst_31419 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
var statearr_31443_34433 = state_31429__$1;
(statearr_31443_34433[(2)] = inst_31419);

(statearr_31443_34433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (1))){
var state_31429__$1 = state_31429;
var statearr_31444_34435 = state_31429__$1;
(statearr_31444_34435[(2)] = null);

(statearr_31444_34435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (4))){
var inst_31398 = (state_31429[(7)]);
var inst_31398__$1 = (state_31429[(2)]);
var inst_31400 = (inst_31398__$1 == null);
var state_31429__$1 = (function (){var statearr_31449 = state_31429;
(statearr_31449[(7)] = inst_31398__$1);

return statearr_31449;
})();
if(cljs.core.truth_(inst_31400)){
var statearr_31450_34436 = state_31429__$1;
(statearr_31450_34436[(1)] = (5));

} else {
var statearr_31451_34437 = state_31429__$1;
(statearr_31451_34437[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (13))){
var state_31429__$1 = state_31429;
var statearr_31452_34438 = state_31429__$1;
(statearr_31452_34438[(2)] = null);

(statearr_31452_34438[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (6))){
var inst_31398 = (state_31429[(7)]);
var state_31429__$1 = state_31429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31429__$1,(11),to,inst_31398);
} else {
if((state_val_31430 === (3))){
var inst_31421 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31429__$1,inst_31421);
} else {
if((state_val_31430 === (12))){
var state_31429__$1 = state_31429;
var statearr_31457_34443 = state_31429__$1;
(statearr_31457_34443[(2)] = null);

(statearr_31457_34443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (2))){
var state_31429__$1 = state_31429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31429__$1,(4),from);
} else {
if((state_val_31430 === (11))){
var inst_31409 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
if(cljs.core.truth_(inst_31409)){
var statearr_31459_34444 = state_31429__$1;
(statearr_31459_34444[(1)] = (12));

} else {
var statearr_31460_34445 = state_31429__$1;
(statearr_31460_34445[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (9))){
var state_31429__$1 = state_31429;
var statearr_31461_34446 = state_31429__$1;
(statearr_31461_34446[(2)] = null);

(statearr_31461_34446[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (5))){
var state_31429__$1 = state_31429;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31464_34447 = state_31429__$1;
(statearr_31464_34447[(1)] = (8));

} else {
var statearr_31466_34448 = state_31429__$1;
(statearr_31466_34448[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (14))){
var inst_31417 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
var statearr_31467_34450 = state_31429__$1;
(statearr_31467_34450[(2)] = inst_31417);

(statearr_31467_34450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (10))){
var inst_31406 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
var statearr_31468_34452 = state_31429__$1;
(statearr_31468_34452[(2)] = inst_31406);

(statearr_31468_34452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (8))){
var inst_31403 = cljs.core.async.close_BANG_(to);
var state_31429__$1 = state_31429;
var statearr_31469_34462 = state_31429__$1;
(statearr_31469_34462[(2)] = inst_31403);

(statearr_31469_34462[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_31470 = [null,null,null,null,null,null,null,null];
(statearr_31470[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_31470[(1)] = (1));

return statearr_31470;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_31429){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31429);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e31471){var ex__30557__auto__ = e31471;
var statearr_31472_34475 = state_31429;
(statearr_31472_34475[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31429[(4)]))){
var statearr_31473_34477 = state_31429;
(statearr_31473_34477[(1)] = cljs.core.first((state_31429[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34478 = state_31429;
state_31429 = G__34478;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_31429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_31429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_31474 = f__31117__auto__();
(statearr_31474[(6)] = c__31116__auto___34426);

return statearr_31474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__31483){
var vec__31484 = p__31483;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31484,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31484,(1),null);
var job = vec__31484;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__31116__auto___34504 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_31491){
var state_val_31492 = (state_31491[(1)]);
if((state_val_31492 === (1))){
var state_31491__$1 = state_31491;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31491__$1,(2),res,v);
} else {
if((state_val_31492 === (2))){
var inst_31488 = (state_31491[(2)]);
var inst_31489 = cljs.core.async.close_BANG_(res);
var state_31491__$1 = (function (){var statearr_31495 = state_31491;
(statearr_31495[(7)] = inst_31488);

return statearr_31495;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31491__$1,inst_31489);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0 = (function (){
var statearr_31496 = [null,null,null,null,null,null,null,null];
(statearr_31496[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__);

(statearr_31496[(1)] = (1));

return statearr_31496;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1 = (function (state_31491){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31491);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e31498){var ex__30557__auto__ = e31498;
var statearr_31500_34510 = state_31491;
(statearr_31500_34510[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31491[(4)]))){
var statearr_31503_34511 = state_31491;
(statearr_31503_34511[(1)] = cljs.core.first((state_31491[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34512 = state_31491;
state_31491 = G__34512;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = function(state_31491){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1.call(this,state_31491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_31506 = f__31117__auto__();
(statearr_31506[(6)] = c__31116__auto___34504);

return statearr_31506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31507){
var vec__31508 = p__31507;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31508,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31508,(1),null);
var job = vec__31508;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___34528 = n;
var __34529 = (0);
while(true){
if((__34529 < n__5636__auto___34528)){
var G__31520_34534 = type;
var G__31520_34535__$1 = (((G__31520_34534 instanceof cljs.core.Keyword))?G__31520_34534.fqn:null);
switch (G__31520_34535__$1) {
case "compute":
var c__31116__auto___34539 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34529,c__31116__auto___34539,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async){
return (function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = ((function (__34529,c__31116__auto___34539,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async){
return (function (state_31544){
var state_val_31545 = (state_31544[(1)]);
if((state_val_31545 === (1))){
var state_31544__$1 = state_31544;
var statearr_31553_34540 = state_31544__$1;
(statearr_31553_34540[(2)] = null);

(statearr_31553_34540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31545 === (2))){
var state_31544__$1 = state_31544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31544__$1,(4),jobs);
} else {
if((state_val_31545 === (3))){
var inst_31539 = (state_31544[(2)]);
var state_31544__$1 = state_31544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31544__$1,inst_31539);
} else {
if((state_val_31545 === (4))){
var inst_31530 = (state_31544[(2)]);
var inst_31531 = process__$1(inst_31530);
var state_31544__$1 = state_31544;
if(cljs.core.truth_(inst_31531)){
var statearr_31561_34541 = state_31544__$1;
(statearr_31561_34541[(1)] = (5));

} else {
var statearr_31562_34542 = state_31544__$1;
(statearr_31562_34542[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31545 === (5))){
var state_31544__$1 = state_31544;
var statearr_31566_34543 = state_31544__$1;
(statearr_31566_34543[(2)] = null);

(statearr_31566_34543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31545 === (6))){
var state_31544__$1 = state_31544;
var statearr_31569_34544 = state_31544__$1;
(statearr_31569_34544[(2)] = null);

(statearr_31569_34544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31545 === (7))){
var inst_31537 = (state_31544[(2)]);
var state_31544__$1 = state_31544;
var statearr_31575_34547 = state_31544__$1;
(statearr_31575_34547[(2)] = inst_31537);

(statearr_31575_34547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34529,c__31116__auto___34539,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async))
;
return ((function (__34529,switch__30553__auto__,c__31116__auto___34539,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0 = (function (){
var statearr_31579 = [null,null,null,null,null,null,null];
(statearr_31579[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__);

(statearr_31579[(1)] = (1));

return statearr_31579;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1 = (function (state_31544){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31544);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e31580){var ex__30557__auto__ = e31580;
var statearr_31581_34549 = state_31544;
(statearr_31581_34549[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31544[(4)]))){
var statearr_31582_34550 = state_31544;
(statearr_31582_34550[(1)] = cljs.core.first((state_31544[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34551 = state_31544;
state_31544 = G__34551;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = function(state_31544){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1.call(this,state_31544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__;
})()
;})(__34529,switch__30553__auto__,c__31116__auto___34539,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async))
})();
var state__31118__auto__ = (function (){var statearr_31587 = f__31117__auto__();
(statearr_31587[(6)] = c__31116__auto___34539);

return statearr_31587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
});})(__34529,c__31116__auto___34539,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async))
);


break;
case "async":
var c__31116__auto___34552 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34529,c__31116__auto___34552,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async){
return (function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = ((function (__34529,c__31116__auto___34552,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async){
return (function (state_31601){
var state_val_31602 = (state_31601[(1)]);
if((state_val_31602 === (1))){
var state_31601__$1 = state_31601;
var statearr_31604_34553 = state_31601__$1;
(statearr_31604_34553[(2)] = null);

(statearr_31604_34553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (2))){
var state_31601__$1 = state_31601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31601__$1,(4),jobs);
} else {
if((state_val_31602 === (3))){
var inst_31598 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31601__$1,inst_31598);
} else {
if((state_val_31602 === (4))){
var inst_31590 = (state_31601[(2)]);
var inst_31591 = async(inst_31590);
var state_31601__$1 = state_31601;
if(cljs.core.truth_(inst_31591)){
var statearr_31605_34554 = state_31601__$1;
(statearr_31605_34554[(1)] = (5));

} else {
var statearr_31606_34556 = state_31601__$1;
(statearr_31606_34556[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (5))){
var state_31601__$1 = state_31601;
var statearr_31610_34561 = state_31601__$1;
(statearr_31610_34561[(2)] = null);

(statearr_31610_34561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (6))){
var state_31601__$1 = state_31601;
var statearr_31611_34565 = state_31601__$1;
(statearr_31611_34565[(2)] = null);

(statearr_31611_34565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31602 === (7))){
var inst_31596 = (state_31601[(2)]);
var state_31601__$1 = state_31601;
var statearr_31612_34567 = state_31601__$1;
(statearr_31612_34567[(2)] = inst_31596);

(statearr_31612_34567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34529,c__31116__auto___34552,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async))
;
return ((function (__34529,switch__30553__auto__,c__31116__auto___34552,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0 = (function (){
var statearr_31613 = [null,null,null,null,null,null,null];
(statearr_31613[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__);

(statearr_31613[(1)] = (1));

return statearr_31613;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1 = (function (state_31601){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31601);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e31614){var ex__30557__auto__ = e31614;
var statearr_31615_34571 = state_31601;
(statearr_31615_34571[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31601[(4)]))){
var statearr_31616_34572 = state_31601;
(statearr_31616_34572[(1)] = cljs.core.first((state_31601[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34573 = state_31601;
state_31601 = G__34573;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = function(state_31601){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1.call(this,state_31601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__;
})()
;})(__34529,switch__30553__auto__,c__31116__auto___34552,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async))
})();
var state__31118__auto__ = (function (){var statearr_31621 = f__31117__auto__();
(statearr_31621[(6)] = c__31116__auto___34552);

return statearr_31621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
});})(__34529,c__31116__auto___34552,G__31520_34534,G__31520_34535__$1,n__5636__auto___34528,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31520_34535__$1)].join('')));

}

var G__34578 = (__34529 + (1));
__34529 = G__34578;
continue;
} else {
}
break;
}

var c__31116__auto___34579 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_31646){
var state_val_31647 = (state_31646[(1)]);
if((state_val_31647 === (7))){
var inst_31641 = (state_31646[(2)]);
var state_31646__$1 = state_31646;
var statearr_31649_34581 = state_31646__$1;
(statearr_31649_34581[(2)] = inst_31641);

(statearr_31649_34581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31647 === (1))){
var state_31646__$1 = state_31646;
var statearr_31650_34582 = state_31646__$1;
(statearr_31650_34582[(2)] = null);

(statearr_31650_34582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31647 === (4))){
var inst_31624 = (state_31646[(7)]);
var inst_31624__$1 = (state_31646[(2)]);
var inst_31625 = (inst_31624__$1 == null);
var state_31646__$1 = (function (){var statearr_31651 = state_31646;
(statearr_31651[(7)] = inst_31624__$1);

return statearr_31651;
})();
if(cljs.core.truth_(inst_31625)){
var statearr_31652_34586 = state_31646__$1;
(statearr_31652_34586[(1)] = (5));

} else {
var statearr_31653_34587 = state_31646__$1;
(statearr_31653_34587[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31647 === (6))){
var inst_31624 = (state_31646[(7)]);
var inst_31629 = (state_31646[(8)]);
var inst_31629__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31631 = [inst_31624,inst_31629__$1];
var inst_31632 = (new cljs.core.PersistentVector(null,2,(5),inst_31630,inst_31631,null));
var state_31646__$1 = (function (){var statearr_31656 = state_31646;
(statearr_31656[(8)] = inst_31629__$1);

return statearr_31656;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31646__$1,(8),jobs,inst_31632);
} else {
if((state_val_31647 === (3))){
var inst_31643 = (state_31646[(2)]);
var state_31646__$1 = state_31646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31646__$1,inst_31643);
} else {
if((state_val_31647 === (2))){
var state_31646__$1 = state_31646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31646__$1,(4),from);
} else {
if((state_val_31647 === (9))){
var inst_31638 = (state_31646[(2)]);
var state_31646__$1 = (function (){var statearr_31659 = state_31646;
(statearr_31659[(9)] = inst_31638);

return statearr_31659;
})();
var statearr_31661_34595 = state_31646__$1;
(statearr_31661_34595[(2)] = null);

(statearr_31661_34595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31647 === (5))){
var inst_31627 = cljs.core.async.close_BANG_(jobs);
var state_31646__$1 = state_31646;
var statearr_31662_34596 = state_31646__$1;
(statearr_31662_34596[(2)] = inst_31627);

(statearr_31662_34596[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31647 === (8))){
var inst_31629 = (state_31646[(8)]);
var inst_31635 = (state_31646[(2)]);
var state_31646__$1 = (function (){var statearr_31663 = state_31646;
(statearr_31663[(10)] = inst_31635);

return statearr_31663;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31646__$1,(9),results,inst_31629);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0 = (function (){
var statearr_31665 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31665[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__);

(statearr_31665[(1)] = (1));

return statearr_31665;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1 = (function (state_31646){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31646);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e31667){var ex__30557__auto__ = e31667;
var statearr_31668_34607 = state_31646;
(statearr_31668_34607[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31646[(4)]))){
var statearr_31669_34610 = state_31646;
(statearr_31669_34610[(1)] = cljs.core.first((state_31646[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34614 = state_31646;
state_31646 = G__34614;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = function(state_31646){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1.call(this,state_31646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_31670 = f__31117__auto__();
(statearr_31670[(6)] = c__31116__auto___34579);

return statearr_31670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


var c__31116__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_31708){
var state_val_31709 = (state_31708[(1)]);
if((state_val_31709 === (7))){
var inst_31704 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31712_34618 = state_31708__$1;
(statearr_31712_34618[(2)] = inst_31704);

(statearr_31712_34618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (20))){
var state_31708__$1 = state_31708;
var statearr_31713_34619 = state_31708__$1;
(statearr_31713_34619[(2)] = null);

(statearr_31713_34619[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (1))){
var state_31708__$1 = state_31708;
var statearr_31714_34623 = state_31708__$1;
(statearr_31714_34623[(2)] = null);

(statearr_31714_34623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (4))){
var inst_31673 = (state_31708[(7)]);
var inst_31673__$1 = (state_31708[(2)]);
var inst_31674 = (inst_31673__$1 == null);
var state_31708__$1 = (function (){var statearr_31715 = state_31708;
(statearr_31715[(7)] = inst_31673__$1);

return statearr_31715;
})();
if(cljs.core.truth_(inst_31674)){
var statearr_31717_34627 = state_31708__$1;
(statearr_31717_34627[(1)] = (5));

} else {
var statearr_31718_34629 = state_31708__$1;
(statearr_31718_34629[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (15))){
var inst_31686 = (state_31708[(8)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31708__$1,(18),to,inst_31686);
} else {
if((state_val_31709 === (21))){
var inst_31699 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31719_34631 = state_31708__$1;
(statearr_31719_34631[(2)] = inst_31699);

(statearr_31719_34631[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (13))){
var inst_31701 = (state_31708[(2)]);
var state_31708__$1 = (function (){var statearr_31720 = state_31708;
(statearr_31720[(9)] = inst_31701);

return statearr_31720;
})();
var statearr_31721_34632 = state_31708__$1;
(statearr_31721_34632[(2)] = null);

(statearr_31721_34632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (6))){
var inst_31673 = (state_31708[(7)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31708__$1,(11),inst_31673);
} else {
if((state_val_31709 === (17))){
var inst_31694 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
if(cljs.core.truth_(inst_31694)){
var statearr_31723_34634 = state_31708__$1;
(statearr_31723_34634[(1)] = (19));

} else {
var statearr_31725_34636 = state_31708__$1;
(statearr_31725_34636[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (3))){
var inst_31706 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31708__$1,inst_31706);
} else {
if((state_val_31709 === (12))){
var inst_31683 = (state_31708[(10)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31708__$1,(14),inst_31683);
} else {
if((state_val_31709 === (2))){
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31708__$1,(4),results);
} else {
if((state_val_31709 === (19))){
var state_31708__$1 = state_31708;
var statearr_31729_34639 = state_31708__$1;
(statearr_31729_34639[(2)] = null);

(statearr_31729_34639[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (11))){
var inst_31683 = (state_31708[(2)]);
var state_31708__$1 = (function (){var statearr_31731 = state_31708;
(statearr_31731[(10)] = inst_31683);

return statearr_31731;
})();
var statearr_31732_34643 = state_31708__$1;
(statearr_31732_34643[(2)] = null);

(statearr_31732_34643[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (9))){
var state_31708__$1 = state_31708;
var statearr_31734_34644 = state_31708__$1;
(statearr_31734_34644[(2)] = null);

(statearr_31734_34644[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (5))){
var state_31708__$1 = state_31708;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31737_34645 = state_31708__$1;
(statearr_31737_34645[(1)] = (8));

} else {
var statearr_31739_34646 = state_31708__$1;
(statearr_31739_34646[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (14))){
var inst_31688 = (state_31708[(11)]);
var inst_31686 = (state_31708[(8)]);
var inst_31686__$1 = (state_31708[(2)]);
var inst_31687 = (inst_31686__$1 == null);
var inst_31688__$1 = cljs.core.not(inst_31687);
var state_31708__$1 = (function (){var statearr_31745 = state_31708;
(statearr_31745[(11)] = inst_31688__$1);

(statearr_31745[(8)] = inst_31686__$1);

return statearr_31745;
})();
if(inst_31688__$1){
var statearr_31746_34647 = state_31708__$1;
(statearr_31746_34647[(1)] = (15));

} else {
var statearr_31747_34649 = state_31708__$1;
(statearr_31747_34649[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (16))){
var inst_31688 = (state_31708[(11)]);
var state_31708__$1 = state_31708;
var statearr_31751_34650 = state_31708__$1;
(statearr_31751_34650[(2)] = inst_31688);

(statearr_31751_34650[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (10))){
var inst_31680 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31752_34653 = state_31708__$1;
(statearr_31752_34653[(2)] = inst_31680);

(statearr_31752_34653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (18))){
var inst_31691 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31756_34656 = state_31708__$1;
(statearr_31756_34656[(2)] = inst_31691);

(statearr_31756_34656[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (8))){
var inst_31677 = cljs.core.async.close_BANG_(to);
var state_31708__$1 = state_31708;
var statearr_31757_34658 = state_31708__$1;
(statearr_31757_34658[(2)] = inst_31677);

(statearr_31757_34658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0 = (function (){
var statearr_31760 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31760[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__);

(statearr_31760[(1)] = (1));

return statearr_31760;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1 = (function (state_31708){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31708);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e31769){var ex__30557__auto__ = e31769;
var statearr_31770_34659 = state_31708;
(statearr_31770_34659[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31708[(4)]))){
var statearr_31775_34661 = state_31708;
(statearr_31775_34661[(1)] = cljs.core.first((state_31708[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34662 = state_31708;
state_31708 = G__34662;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__ = function(state_31708){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1.call(this,state_31708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30554__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_31782 = f__31117__auto__();
(statearr_31782[(6)] = c__31116__auto__);

return statearr_31782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

return c__31116__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31800 = arguments.length;
switch (G__31800) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31818 = arguments.length;
switch (G__31818) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31835 = arguments.length;
switch (G__31835) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__31116__auto___34692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_31879){
var state_val_31883 = (state_31879[(1)]);
if((state_val_31883 === (7))){
var inst_31874 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31911_34694 = state_31879__$1;
(statearr_31911_34694[(2)] = inst_31874);

(statearr_31911_34694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (1))){
var state_31879__$1 = state_31879;
var statearr_31920_34696 = state_31879__$1;
(statearr_31920_34696[(2)] = null);

(statearr_31920_34696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (4))){
var inst_31854 = (state_31879[(7)]);
var inst_31854__$1 = (state_31879[(2)]);
var inst_31856 = (inst_31854__$1 == null);
var state_31879__$1 = (function (){var statearr_31929 = state_31879;
(statearr_31929[(7)] = inst_31854__$1);

return statearr_31929;
})();
if(cljs.core.truth_(inst_31856)){
var statearr_31930_34700 = state_31879__$1;
(statearr_31930_34700[(1)] = (5));

} else {
var statearr_31931_34702 = state_31879__$1;
(statearr_31931_34702[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (13))){
var state_31879__$1 = state_31879;
var statearr_31932_34706 = state_31879__$1;
(statearr_31932_34706[(2)] = null);

(statearr_31932_34706[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (6))){
var inst_31854 = (state_31879[(7)]);
var inst_31861 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31854) : p.call(null,inst_31854));
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31861)){
var statearr_31935_34709 = state_31879__$1;
(statearr_31935_34709[(1)] = (9));

} else {
var statearr_31936_34710 = state_31879__$1;
(statearr_31936_34710[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (3))){
var inst_31876 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31879__$1,inst_31876);
} else {
if((state_val_31883 === (12))){
var state_31879__$1 = state_31879;
var statearr_31950_34713 = state_31879__$1;
(statearr_31950_34713[(2)] = null);

(statearr_31950_34713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (2))){
var state_31879__$1 = state_31879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31879__$1,(4),ch);
} else {
if((state_val_31883 === (11))){
var inst_31854 = (state_31879[(7)]);
var inst_31865 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31879__$1,(8),inst_31865,inst_31854);
} else {
if((state_val_31883 === (9))){
var state_31879__$1 = state_31879;
var statearr_31968_34721 = state_31879__$1;
(statearr_31968_34721[(2)] = tc);

(statearr_31968_34721[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (5))){
var inst_31858 = cljs.core.async.close_BANG_(tc);
var inst_31859 = cljs.core.async.close_BANG_(fc);
var state_31879__$1 = (function (){var statearr_31973 = state_31879;
(statearr_31973[(8)] = inst_31858);

return statearr_31973;
})();
var statearr_31975_34731 = state_31879__$1;
(statearr_31975_34731[(2)] = inst_31859);

(statearr_31975_34731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (14))){
var inst_31872 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
var statearr_31997_34732 = state_31879__$1;
(statearr_31997_34732[(2)] = inst_31872);

(statearr_31997_34732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (10))){
var state_31879__$1 = state_31879;
var statearr_32000_34733 = state_31879__$1;
(statearr_32000_34733[(2)] = fc);

(statearr_32000_34733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31883 === (8))){
var inst_31867 = (state_31879[(2)]);
var state_31879__$1 = state_31879;
if(cljs.core.truth_(inst_31867)){
var statearr_32012_34734 = state_31879__$1;
(statearr_32012_34734[(1)] = (12));

} else {
var statearr_32013_34735 = state_31879__$1;
(statearr_32013_34735[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_32022 = [null,null,null,null,null,null,null,null,null];
(statearr_32022[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_32022[(1)] = (1));

return statearr_32022;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_31879){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_31879);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32024){var ex__30557__auto__ = e32024;
var statearr_32025_34739 = state_31879;
(statearr_32025_34739[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_31879[(4)]))){
var statearr_32026_34744 = state_31879;
(statearr_32026_34744[(1)] = cljs.core.first((state_31879[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34748 = state_31879;
state_31879 = G__34748;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_31879){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_31879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32030 = f__31117__auto__();
(statearr_32030[(6)] = c__31116__auto___34692);

return statearr_32030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31116__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_32062){
var state_val_32063 = (state_32062[(1)]);
if((state_val_32063 === (7))){
var inst_32058 = (state_32062[(2)]);
var state_32062__$1 = state_32062;
var statearr_32066_34758 = state_32062__$1;
(statearr_32066_34758[(2)] = inst_32058);

(statearr_32066_34758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (1))){
var inst_32039 = init;
var inst_32040 = inst_32039;
var state_32062__$1 = (function (){var statearr_32067 = state_32062;
(statearr_32067[(7)] = inst_32040);

return statearr_32067;
})();
var statearr_32068_34766 = state_32062__$1;
(statearr_32068_34766[(2)] = null);

(statearr_32068_34766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (4))){
var inst_32043 = (state_32062[(8)]);
var inst_32043__$1 = (state_32062[(2)]);
var inst_32044 = (inst_32043__$1 == null);
var state_32062__$1 = (function (){var statearr_32070 = state_32062;
(statearr_32070[(8)] = inst_32043__$1);

return statearr_32070;
})();
if(cljs.core.truth_(inst_32044)){
var statearr_32073_34773 = state_32062__$1;
(statearr_32073_34773[(1)] = (5));

} else {
var statearr_32077_34774 = state_32062__$1;
(statearr_32077_34774[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (6))){
var inst_32043 = (state_32062[(8)]);
var inst_32047 = (state_32062[(9)]);
var inst_32040 = (state_32062[(7)]);
var inst_32047__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32040,inst_32043) : f.call(null,inst_32040,inst_32043));
var inst_32048 = cljs.core.reduced_QMARK_(inst_32047__$1);
var state_32062__$1 = (function (){var statearr_32082 = state_32062;
(statearr_32082[(9)] = inst_32047__$1);

return statearr_32082;
})();
if(inst_32048){
var statearr_32086_34780 = state_32062__$1;
(statearr_32086_34780[(1)] = (8));

} else {
var statearr_32087_34788 = state_32062__$1;
(statearr_32087_34788[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (3))){
var inst_32060 = (state_32062[(2)]);
var state_32062__$1 = state_32062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32062__$1,inst_32060);
} else {
if((state_val_32063 === (2))){
var state_32062__$1 = state_32062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32062__$1,(4),ch);
} else {
if((state_val_32063 === (9))){
var inst_32047 = (state_32062[(9)]);
var inst_32040 = inst_32047;
var state_32062__$1 = (function (){var statearr_32101 = state_32062;
(statearr_32101[(7)] = inst_32040);

return statearr_32101;
})();
var statearr_32102_34807 = state_32062__$1;
(statearr_32102_34807[(2)] = null);

(statearr_32102_34807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (5))){
var inst_32040 = (state_32062[(7)]);
var state_32062__$1 = state_32062;
var statearr_32104_34808 = state_32062__$1;
(statearr_32104_34808[(2)] = inst_32040);

(statearr_32104_34808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (10))){
var inst_32055 = (state_32062[(2)]);
var state_32062__$1 = state_32062;
var statearr_32112_34809 = state_32062__$1;
(statearr_32112_34809[(2)] = inst_32055);

(statearr_32112_34809[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32063 === (8))){
var inst_32047 = (state_32062[(9)]);
var inst_32051 = cljs.core.deref(inst_32047);
var state_32062__$1 = state_32062;
var statearr_32114_34815 = state_32062__$1;
(statearr_32114_34815[(2)] = inst_32051);

(statearr_32114_34815[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__30554__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30554__auto____0 = (function (){
var statearr_32127 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32127[(0)] = cljs$core$async$reduce_$_state_machine__30554__auto__);

(statearr_32127[(1)] = (1));

return statearr_32127;
});
var cljs$core$async$reduce_$_state_machine__30554__auto____1 = (function (state_32062){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_32062);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32133){var ex__30557__auto__ = e32133;
var statearr_32138_34816 = state_32062;
(statearr_32138_34816[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_32062[(4)]))){
var statearr_32139_34817 = state_32062;
(statearr_32139_34817[(1)] = cljs.core.first((state_32062[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34828 = state_32062;
state_32062 = G__34828;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30554__auto__ = function(state_32062){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30554__auto____1.call(this,state_32062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30554__auto____0;
cljs$core$async$reduce_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30554__auto____1;
return cljs$core$async$reduce_$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32140 = f__31117__auto__();
(statearr_32140[(6)] = c__31116__auto__);

return statearr_32140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

return c__31116__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__31116__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_32146){
var state_val_32147 = (state_32146[(1)]);
if((state_val_32147 === (1))){
var inst_32141 = cljs.core.async.reduce(f__$1,init,ch);
var state_32146__$1 = state_32146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32146__$1,(2),inst_32141);
} else {
if((state_val_32147 === (2))){
var inst_32143 = (state_32146[(2)]);
var inst_32144 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32143) : f__$1.call(null,inst_32143));
var state_32146__$1 = state_32146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32146__$1,inst_32144);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__30554__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30554__auto____0 = (function (){
var statearr_32150 = [null,null,null,null,null,null,null];
(statearr_32150[(0)] = cljs$core$async$transduce_$_state_machine__30554__auto__);

(statearr_32150[(1)] = (1));

return statearr_32150;
});
var cljs$core$async$transduce_$_state_machine__30554__auto____1 = (function (state_32146){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_32146);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32151){var ex__30557__auto__ = e32151;
var statearr_32152_34837 = state_32146;
(statearr_32152_34837[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_32146[(4)]))){
var statearr_32153_34838 = state_32146;
(statearr_32153_34838[(1)] = cljs.core.first((state_32146[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34839 = state_32146;
state_32146 = G__34839;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30554__auto__ = function(state_32146){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30554__auto____1.call(this,state_32146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30554__auto____0;
cljs$core$async$transduce_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30554__auto____1;
return cljs$core$async$transduce_$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32154 = f__31117__auto__();
(statearr_32154[(6)] = c__31116__auto__);

return statearr_32154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

return c__31116__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__32156 = arguments.length;
switch (G__32156) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31116__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_32182){
var state_val_32183 = (state_32182[(1)]);
if((state_val_32183 === (7))){
var inst_32164 = (state_32182[(2)]);
var state_32182__$1 = state_32182;
var statearr_32184_34844 = state_32182__$1;
(statearr_32184_34844[(2)] = inst_32164);

(statearr_32184_34844[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (1))){
var inst_32158 = cljs.core.seq(coll);
var inst_32159 = inst_32158;
var state_32182__$1 = (function (){var statearr_32185 = state_32182;
(statearr_32185[(7)] = inst_32159);

return statearr_32185;
})();
var statearr_32186_34845 = state_32182__$1;
(statearr_32186_34845[(2)] = null);

(statearr_32186_34845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (4))){
var inst_32159 = (state_32182[(7)]);
var inst_32162 = cljs.core.first(inst_32159);
var state_32182__$1 = state_32182;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32182__$1,(7),ch,inst_32162);
} else {
if((state_val_32183 === (13))){
var inst_32176 = (state_32182[(2)]);
var state_32182__$1 = state_32182;
var statearr_32187_34847 = state_32182__$1;
(statearr_32187_34847[(2)] = inst_32176);

(statearr_32187_34847[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (6))){
var inst_32167 = (state_32182[(2)]);
var state_32182__$1 = state_32182;
if(cljs.core.truth_(inst_32167)){
var statearr_32189_34850 = state_32182__$1;
(statearr_32189_34850[(1)] = (8));

} else {
var statearr_32190_34851 = state_32182__$1;
(statearr_32190_34851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (3))){
var inst_32180 = (state_32182[(2)]);
var state_32182__$1 = state_32182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32182__$1,inst_32180);
} else {
if((state_val_32183 === (12))){
var state_32182__$1 = state_32182;
var statearr_32192_34856 = state_32182__$1;
(statearr_32192_34856[(2)] = null);

(statearr_32192_34856[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (2))){
var inst_32159 = (state_32182[(7)]);
var state_32182__$1 = state_32182;
if(cljs.core.truth_(inst_32159)){
var statearr_32193_34857 = state_32182__$1;
(statearr_32193_34857[(1)] = (4));

} else {
var statearr_32194_34858 = state_32182__$1;
(statearr_32194_34858[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (11))){
var inst_32173 = cljs.core.async.close_BANG_(ch);
var state_32182__$1 = state_32182;
var statearr_32195_34859 = state_32182__$1;
(statearr_32195_34859[(2)] = inst_32173);

(statearr_32195_34859[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (9))){
var state_32182__$1 = state_32182;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32196_34861 = state_32182__$1;
(statearr_32196_34861[(1)] = (11));

} else {
var statearr_32197_34862 = state_32182__$1;
(statearr_32197_34862[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (5))){
var inst_32159 = (state_32182[(7)]);
var state_32182__$1 = state_32182;
var statearr_32198_34874 = state_32182__$1;
(statearr_32198_34874[(2)] = inst_32159);

(statearr_32198_34874[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (10))){
var inst_32178 = (state_32182[(2)]);
var state_32182__$1 = state_32182;
var statearr_32199_34875 = state_32182__$1;
(statearr_32199_34875[(2)] = inst_32178);

(statearr_32199_34875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32183 === (8))){
var inst_32159 = (state_32182[(7)]);
var inst_32169 = cljs.core.next(inst_32159);
var inst_32159__$1 = inst_32169;
var state_32182__$1 = (function (){var statearr_32200 = state_32182;
(statearr_32200[(7)] = inst_32159__$1);

return statearr_32200;
})();
var statearr_32201_34876 = state_32182__$1;
(statearr_32201_34876[(2)] = null);

(statearr_32201_34876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_32210 = [null,null,null,null,null,null,null,null];
(statearr_32210[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_32210[(1)] = (1));

return statearr_32210;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_32182){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_32182);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32215){var ex__30557__auto__ = e32215;
var statearr_32216_34879 = state_32182;
(statearr_32216_34879[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_32182[(4)]))){
var statearr_32217_34882 = state_32182;
(statearr_32217_34882[(1)] = cljs.core.first((state_32182[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34883 = state_32182;
state_32182 = G__34883;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_32182){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_32182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32227 = f__31117__auto__();
(statearr_32227[(6)] = c__31116__auto__);

return statearr_32227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

return c__31116__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32231 = arguments.length;
switch (G__32231) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34895 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34895(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34900 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34900(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34902 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34902(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34908 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34908(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32256 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32256 = (function (ch,cs,meta32257){
this.ch = ch;
this.cs = cs;
this.meta32257 = meta32257;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32258,meta32257__$1){
var self__ = this;
var _32258__$1 = this;
return (new cljs.core.async.t_cljs$core$async32256(self__.ch,self__.cs,meta32257__$1));
}));

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32258){
var self__ = this;
var _32258__$1 = this;
return self__.meta32257;
}));

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async32256.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async32256.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32257","meta32257",-1327825585,null)], null);
}));

(cljs.core.async.t_cljs$core$async32256.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32256.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32256");

(cljs.core.async.t_cljs$core$async32256.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32256");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32256.
 */
cljs.core.async.__GT_t_cljs$core$async32256 = (function cljs$core$async$mult_$___GT_t_cljs$core$async32256(ch__$1,cs__$1,meta32257){
return (new cljs.core.async.t_cljs$core$async32256(ch__$1,cs__$1,meta32257));
});

}

return (new cljs.core.async.t_cljs$core$async32256(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__31116__auto___34923 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_32409){
var state_val_32410 = (state_32409[(1)]);
if((state_val_32410 === (7))){
var inst_32405 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32412_34924 = state_32409__$1;
(statearr_32412_34924[(2)] = inst_32405);

(statearr_32412_34924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (20))){
var inst_32307 = (state_32409[(7)]);
var inst_32319 = cljs.core.first(inst_32307);
var inst_32320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32319,(0),null);
var inst_32321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32319,(1),null);
var state_32409__$1 = (function (){var statearr_32413 = state_32409;
(statearr_32413[(8)] = inst_32320);

return statearr_32413;
})();
if(cljs.core.truth_(inst_32321)){
var statearr_32414_34938 = state_32409__$1;
(statearr_32414_34938[(1)] = (22));

} else {
var statearr_32415_34939 = state_32409__$1;
(statearr_32415_34939[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (27))){
var inst_32350 = (state_32409[(9)]);
var inst_32357 = (state_32409[(10)]);
var inst_32352 = (state_32409[(11)]);
var inst_32275 = (state_32409[(12)]);
var inst_32357__$1 = cljs.core._nth(inst_32350,inst_32352);
var inst_32358 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32357__$1,inst_32275,done);
var state_32409__$1 = (function (){var statearr_32417 = state_32409;
(statearr_32417[(10)] = inst_32357__$1);

return statearr_32417;
})();
if(cljs.core.truth_(inst_32358)){
var statearr_32418_34941 = state_32409__$1;
(statearr_32418_34941[(1)] = (30));

} else {
var statearr_32419_34942 = state_32409__$1;
(statearr_32419_34942[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (1))){
var state_32409__$1 = state_32409;
var statearr_32420_34949 = state_32409__$1;
(statearr_32420_34949[(2)] = null);

(statearr_32420_34949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (24))){
var inst_32307 = (state_32409[(7)]);
var inst_32326 = (state_32409[(2)]);
var inst_32327 = cljs.core.next(inst_32307);
var inst_32284 = inst_32327;
var inst_32285 = null;
var inst_32286 = (0);
var inst_32287 = (0);
var state_32409__$1 = (function (){var statearr_32421 = state_32409;
(statearr_32421[(13)] = inst_32284);

(statearr_32421[(14)] = inst_32286);

(statearr_32421[(15)] = inst_32326);

(statearr_32421[(16)] = inst_32285);

(statearr_32421[(17)] = inst_32287);

return statearr_32421;
})();
var statearr_32422_34951 = state_32409__$1;
(statearr_32422_34951[(2)] = null);

(statearr_32422_34951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (39))){
var state_32409__$1 = state_32409;
var statearr_32429_34954 = state_32409__$1;
(statearr_32429_34954[(2)] = null);

(statearr_32429_34954[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (4))){
var inst_32275 = (state_32409[(12)]);
var inst_32275__$1 = (state_32409[(2)]);
var inst_32276 = (inst_32275__$1 == null);
var state_32409__$1 = (function (){var statearr_32430 = state_32409;
(statearr_32430[(12)] = inst_32275__$1);

return statearr_32430;
})();
if(cljs.core.truth_(inst_32276)){
var statearr_32432_34956 = state_32409__$1;
(statearr_32432_34956[(1)] = (5));

} else {
var statearr_32433_34957 = state_32409__$1;
(statearr_32433_34957[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (15))){
var inst_32284 = (state_32409[(13)]);
var inst_32286 = (state_32409[(14)]);
var inst_32285 = (state_32409[(16)]);
var inst_32287 = (state_32409[(17)]);
var inst_32302 = (state_32409[(2)]);
var inst_32303 = (inst_32287 + (1));
var tmp32423 = inst_32284;
var tmp32424 = inst_32286;
var tmp32425 = inst_32285;
var inst_32284__$1 = tmp32423;
var inst_32285__$1 = tmp32425;
var inst_32286__$1 = tmp32424;
var inst_32287__$1 = inst_32303;
var state_32409__$1 = (function (){var statearr_32435 = state_32409;
(statearr_32435[(13)] = inst_32284__$1);

(statearr_32435[(14)] = inst_32286__$1);

(statearr_32435[(16)] = inst_32285__$1);

(statearr_32435[(17)] = inst_32287__$1);

(statearr_32435[(18)] = inst_32302);

return statearr_32435;
})();
var statearr_32437_34958 = state_32409__$1;
(statearr_32437_34958[(2)] = null);

(statearr_32437_34958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (21))){
var inst_32330 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32441_34959 = state_32409__$1;
(statearr_32441_34959[(2)] = inst_32330);

(statearr_32441_34959[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (31))){
var inst_32357 = (state_32409[(10)]);
var inst_32361 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32357);
var state_32409__$1 = state_32409;
var statearr_32444_34960 = state_32409__$1;
(statearr_32444_34960[(2)] = inst_32361);

(statearr_32444_34960[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (32))){
var inst_32350 = (state_32409[(9)]);
var inst_32351 = (state_32409[(19)]);
var inst_32352 = (state_32409[(11)]);
var inst_32349 = (state_32409[(20)]);
var inst_32363 = (state_32409[(2)]);
var inst_32364 = (inst_32352 + (1));
var tmp32438 = inst_32350;
var tmp32439 = inst_32351;
var tmp32440 = inst_32349;
var inst_32349__$1 = tmp32440;
var inst_32350__$1 = tmp32438;
var inst_32351__$1 = tmp32439;
var inst_32352__$1 = inst_32364;
var state_32409__$1 = (function (){var statearr_32445 = state_32409;
(statearr_32445[(9)] = inst_32350__$1);

(statearr_32445[(19)] = inst_32351__$1);

(statearr_32445[(21)] = inst_32363);

(statearr_32445[(11)] = inst_32352__$1);

(statearr_32445[(20)] = inst_32349__$1);

return statearr_32445;
})();
var statearr_32447_34974 = state_32409__$1;
(statearr_32447_34974[(2)] = null);

(statearr_32447_34974[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (40))){
var inst_32378 = (state_32409[(22)]);
var inst_32382 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32378);
var state_32409__$1 = state_32409;
var statearr_32449_34975 = state_32409__$1;
(statearr_32449_34975[(2)] = inst_32382);

(statearr_32449_34975[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (33))){
var inst_32367 = (state_32409[(23)]);
var inst_32370 = cljs.core.chunked_seq_QMARK_(inst_32367);
var state_32409__$1 = state_32409;
if(inst_32370){
var statearr_32450_34979 = state_32409__$1;
(statearr_32450_34979[(1)] = (36));

} else {
var statearr_32453_34980 = state_32409__$1;
(statearr_32453_34980[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (13))){
var inst_32296 = (state_32409[(24)]);
var inst_32299 = cljs.core.async.close_BANG_(inst_32296);
var state_32409__$1 = state_32409;
var statearr_32456_34986 = state_32409__$1;
(statearr_32456_34986[(2)] = inst_32299);

(statearr_32456_34986[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (22))){
var inst_32320 = (state_32409[(8)]);
var inst_32323 = cljs.core.async.close_BANG_(inst_32320);
var state_32409__$1 = state_32409;
var statearr_32458_34987 = state_32409__$1;
(statearr_32458_34987[(2)] = inst_32323);

(statearr_32458_34987[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (36))){
var inst_32367 = (state_32409[(23)]);
var inst_32373 = cljs.core.chunk_first(inst_32367);
var inst_32374 = cljs.core.chunk_rest(inst_32367);
var inst_32375 = cljs.core.count(inst_32373);
var inst_32349 = inst_32374;
var inst_32350 = inst_32373;
var inst_32351 = inst_32375;
var inst_32352 = (0);
var state_32409__$1 = (function (){var statearr_32459 = state_32409;
(statearr_32459[(9)] = inst_32350);

(statearr_32459[(19)] = inst_32351);

(statearr_32459[(11)] = inst_32352);

(statearr_32459[(20)] = inst_32349);

return statearr_32459;
})();
var statearr_32460_34991 = state_32409__$1;
(statearr_32460_34991[(2)] = null);

(statearr_32460_34991[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (41))){
var inst_32367 = (state_32409[(23)]);
var inst_32384 = (state_32409[(2)]);
var inst_32385 = cljs.core.next(inst_32367);
var inst_32349 = inst_32385;
var inst_32350 = null;
var inst_32351 = (0);
var inst_32352 = (0);
var state_32409__$1 = (function (){var statearr_32462 = state_32409;
(statearr_32462[(9)] = inst_32350);

(statearr_32462[(19)] = inst_32351);

(statearr_32462[(11)] = inst_32352);

(statearr_32462[(20)] = inst_32349);

(statearr_32462[(25)] = inst_32384);

return statearr_32462;
})();
var statearr_32463_34997 = state_32409__$1;
(statearr_32463_34997[(2)] = null);

(statearr_32463_34997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (43))){
var state_32409__$1 = state_32409;
var statearr_32464_34999 = state_32409__$1;
(statearr_32464_34999[(2)] = null);

(statearr_32464_34999[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (29))){
var inst_32393 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32465_35003 = state_32409__$1;
(statearr_32465_35003[(2)] = inst_32393);

(statearr_32465_35003[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (44))){
var inst_32402 = (state_32409[(2)]);
var state_32409__$1 = (function (){var statearr_32466 = state_32409;
(statearr_32466[(26)] = inst_32402);

return statearr_32466;
})();
var statearr_32467_35004 = state_32409__$1;
(statearr_32467_35004[(2)] = null);

(statearr_32467_35004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (6))){
var inst_32341 = (state_32409[(27)]);
var inst_32340 = cljs.core.deref(cs);
var inst_32341__$1 = cljs.core.keys(inst_32340);
var inst_32342 = cljs.core.count(inst_32341__$1);
var inst_32343 = cljs.core.reset_BANG_(dctr,inst_32342);
var inst_32348 = cljs.core.seq(inst_32341__$1);
var inst_32349 = inst_32348;
var inst_32350 = null;
var inst_32351 = (0);
var inst_32352 = (0);
var state_32409__$1 = (function (){var statearr_32469 = state_32409;
(statearr_32469[(9)] = inst_32350);

(statearr_32469[(19)] = inst_32351);

(statearr_32469[(11)] = inst_32352);

(statearr_32469[(28)] = inst_32343);

(statearr_32469[(20)] = inst_32349);

(statearr_32469[(27)] = inst_32341__$1);

return statearr_32469;
})();
var statearr_32470_35005 = state_32409__$1;
(statearr_32470_35005[(2)] = null);

(statearr_32470_35005[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (28))){
var inst_32367 = (state_32409[(23)]);
var inst_32349 = (state_32409[(20)]);
var inst_32367__$1 = cljs.core.seq(inst_32349);
var state_32409__$1 = (function (){var statearr_32471 = state_32409;
(statearr_32471[(23)] = inst_32367__$1);

return statearr_32471;
})();
if(inst_32367__$1){
var statearr_32472_35006 = state_32409__$1;
(statearr_32472_35006[(1)] = (33));

} else {
var statearr_32473_35007 = state_32409__$1;
(statearr_32473_35007[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (25))){
var inst_32351 = (state_32409[(19)]);
var inst_32352 = (state_32409[(11)]);
var inst_32354 = (inst_32352 < inst_32351);
var inst_32355 = inst_32354;
var state_32409__$1 = state_32409;
if(cljs.core.truth_(inst_32355)){
var statearr_32475_35016 = state_32409__$1;
(statearr_32475_35016[(1)] = (27));

} else {
var statearr_32476_35018 = state_32409__$1;
(statearr_32476_35018[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (34))){
var state_32409__$1 = state_32409;
var statearr_32477_35019 = state_32409__$1;
(statearr_32477_35019[(2)] = null);

(statearr_32477_35019[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (17))){
var state_32409__$1 = state_32409;
var statearr_32479_35021 = state_32409__$1;
(statearr_32479_35021[(2)] = null);

(statearr_32479_35021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (3))){
var inst_32407 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32409__$1,inst_32407);
} else {
if((state_val_32410 === (12))){
var inst_32335 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32481_35022 = state_32409__$1;
(statearr_32481_35022[(2)] = inst_32335);

(statearr_32481_35022[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (2))){
var state_32409__$1 = state_32409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32409__$1,(4),ch);
} else {
if((state_val_32410 === (23))){
var state_32409__$1 = state_32409;
var statearr_32482_35032 = state_32409__$1;
(statearr_32482_35032[(2)] = null);

(statearr_32482_35032[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (35))){
var inst_32391 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32483_35033 = state_32409__$1;
(statearr_32483_35033[(2)] = inst_32391);

(statearr_32483_35033[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (19))){
var inst_32307 = (state_32409[(7)]);
var inst_32311 = cljs.core.chunk_first(inst_32307);
var inst_32312 = cljs.core.chunk_rest(inst_32307);
var inst_32313 = cljs.core.count(inst_32311);
var inst_32284 = inst_32312;
var inst_32285 = inst_32311;
var inst_32286 = inst_32313;
var inst_32287 = (0);
var state_32409__$1 = (function (){var statearr_32484 = state_32409;
(statearr_32484[(13)] = inst_32284);

(statearr_32484[(14)] = inst_32286);

(statearr_32484[(16)] = inst_32285);

(statearr_32484[(17)] = inst_32287);

return statearr_32484;
})();
var statearr_32485_35038 = state_32409__$1;
(statearr_32485_35038[(2)] = null);

(statearr_32485_35038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (11))){
var inst_32284 = (state_32409[(13)]);
var inst_32307 = (state_32409[(7)]);
var inst_32307__$1 = cljs.core.seq(inst_32284);
var state_32409__$1 = (function (){var statearr_32486 = state_32409;
(statearr_32486[(7)] = inst_32307__$1);

return statearr_32486;
})();
if(inst_32307__$1){
var statearr_32488_35039 = state_32409__$1;
(statearr_32488_35039[(1)] = (16));

} else {
var statearr_32489_35040 = state_32409__$1;
(statearr_32489_35040[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (9))){
var inst_32337 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32490_35048 = state_32409__$1;
(statearr_32490_35048[(2)] = inst_32337);

(statearr_32490_35048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (5))){
var inst_32282 = cljs.core.deref(cs);
var inst_32283 = cljs.core.seq(inst_32282);
var inst_32284 = inst_32283;
var inst_32285 = null;
var inst_32286 = (0);
var inst_32287 = (0);
var state_32409__$1 = (function (){var statearr_32492 = state_32409;
(statearr_32492[(13)] = inst_32284);

(statearr_32492[(14)] = inst_32286);

(statearr_32492[(16)] = inst_32285);

(statearr_32492[(17)] = inst_32287);

return statearr_32492;
})();
var statearr_32493_35050 = state_32409__$1;
(statearr_32493_35050[(2)] = null);

(statearr_32493_35050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (14))){
var state_32409__$1 = state_32409;
var statearr_32495_35055 = state_32409__$1;
(statearr_32495_35055[(2)] = null);

(statearr_32495_35055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (45))){
var inst_32399 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32496_35056 = state_32409__$1;
(statearr_32496_35056[(2)] = inst_32399);

(statearr_32496_35056[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (26))){
var inst_32341 = (state_32409[(27)]);
var inst_32395 = (state_32409[(2)]);
var inst_32396 = cljs.core.seq(inst_32341);
var state_32409__$1 = (function (){var statearr_32497 = state_32409;
(statearr_32497[(29)] = inst_32395);

return statearr_32497;
})();
if(inst_32396){
var statearr_32499_35064 = state_32409__$1;
(statearr_32499_35064[(1)] = (42));

} else {
var statearr_32501_35065 = state_32409__$1;
(statearr_32501_35065[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (16))){
var inst_32307 = (state_32409[(7)]);
var inst_32309 = cljs.core.chunked_seq_QMARK_(inst_32307);
var state_32409__$1 = state_32409;
if(inst_32309){
var statearr_32502_35066 = state_32409__$1;
(statearr_32502_35066[(1)] = (19));

} else {
var statearr_32503_35067 = state_32409__$1;
(statearr_32503_35067[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (38))){
var inst_32388 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32504_35072 = state_32409__$1;
(statearr_32504_35072[(2)] = inst_32388);

(statearr_32504_35072[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (30))){
var state_32409__$1 = state_32409;
var statearr_32505_35074 = state_32409__$1;
(statearr_32505_35074[(2)] = null);

(statearr_32505_35074[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (10))){
var inst_32285 = (state_32409[(16)]);
var inst_32287 = (state_32409[(17)]);
var inst_32295 = cljs.core._nth(inst_32285,inst_32287);
var inst_32296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32295,(0),null);
var inst_32297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32295,(1),null);
var state_32409__$1 = (function (){var statearr_32506 = state_32409;
(statearr_32506[(24)] = inst_32296);

return statearr_32506;
})();
if(cljs.core.truth_(inst_32297)){
var statearr_32507_35080 = state_32409__$1;
(statearr_32507_35080[(1)] = (13));

} else {
var statearr_32508_35081 = state_32409__$1;
(statearr_32508_35081[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (18))){
var inst_32333 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32510_35082 = state_32409__$1;
(statearr_32510_35082[(2)] = inst_32333);

(statearr_32510_35082[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (42))){
var state_32409__$1 = state_32409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32409__$1,(45),dchan);
} else {
if((state_val_32410 === (37))){
var inst_32378 = (state_32409[(22)]);
var inst_32275 = (state_32409[(12)]);
var inst_32367 = (state_32409[(23)]);
var inst_32378__$1 = cljs.core.first(inst_32367);
var inst_32379 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32378__$1,inst_32275,done);
var state_32409__$1 = (function (){var statearr_32511 = state_32409;
(statearr_32511[(22)] = inst_32378__$1);

return statearr_32511;
})();
if(cljs.core.truth_(inst_32379)){
var statearr_32512_35089 = state_32409__$1;
(statearr_32512_35089[(1)] = (39));

} else {
var statearr_32513_35090 = state_32409__$1;
(statearr_32513_35090[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (8))){
var inst_32286 = (state_32409[(14)]);
var inst_32287 = (state_32409[(17)]);
var inst_32289 = (inst_32287 < inst_32286);
var inst_32290 = inst_32289;
var state_32409__$1 = state_32409;
if(cljs.core.truth_(inst_32290)){
var statearr_32514_35093 = state_32409__$1;
(statearr_32514_35093[(1)] = (10));

} else {
var statearr_32515_35099 = state_32409__$1;
(statearr_32515_35099[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__30554__auto__ = null;
var cljs$core$async$mult_$_state_machine__30554__auto____0 = (function (){
var statearr_32517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32517[(0)] = cljs$core$async$mult_$_state_machine__30554__auto__);

(statearr_32517[(1)] = (1));

return statearr_32517;
});
var cljs$core$async$mult_$_state_machine__30554__auto____1 = (function (state_32409){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_32409);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32518){var ex__30557__auto__ = e32518;
var statearr_32519_35101 = state_32409;
(statearr_32519_35101[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_32409[(4)]))){
var statearr_32521_35102 = state_32409;
(statearr_32521_35102[(1)] = cljs.core.first((state_32409[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35103 = state_32409;
state_32409 = G__35103;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30554__auto__ = function(state_32409){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30554__auto____1.call(this,state_32409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30554__auto____0;
cljs$core$async$mult_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30554__auto____1;
return cljs$core$async$mult_$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32522 = f__31117__auto__();
(statearr_32522[(6)] = c__31116__auto___34923);

return statearr_32522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32525 = arguments.length;
switch (G__32525) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_35109 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_35109(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_35116 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_35116(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_35117 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_35117(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_35118 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_35118(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_35119 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_35119(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35121 = arguments.length;
var i__5770__auto___35122 = (0);
while(true){
if((i__5770__auto___35122 < len__5769__auto___35121)){
args__5775__auto__.push((arguments[i__5770__auto___35122]));

var G__35123 = (i__5770__auto___35122 + (1));
i__5770__auto___35122 = G__35123;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32562){
var map__32563 = p__32562;
var map__32563__$1 = cljs.core.__destructure_map(map__32563);
var opts = map__32563__$1;
var statearr_32564_35128 = state;
(statearr_32564_35128[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32565_35129 = state;
(statearr_32565_35129[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32568_35130 = state;
(statearr_32568_35130[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32552){
var G__32553 = cljs.core.first(seq32552);
var seq32552__$1 = cljs.core.next(seq32552);
var G__32554 = cljs.core.first(seq32552__$1);
var seq32552__$2 = cljs.core.next(seq32552__$1);
var G__32555 = cljs.core.first(seq32552__$2);
var seq32552__$3 = cljs.core.next(seq32552__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32553,G__32554,G__32555,seq32552__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32601 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32601 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32602){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32602 = meta32602;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32603,meta32602__$1){
var self__ = this;
var _32603__$1 = this;
return (new cljs.core.async.t_cljs$core$async32601(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32602__$1));
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32603){
var self__ = this;
var _32603__$1 = this;
return self__.meta32602;
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32601.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32601.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32602","meta32602",-70307808,null)], null);
}));

(cljs.core.async.t_cljs$core$async32601.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32601.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32601");

(cljs.core.async.t_cljs$core$async32601.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32601");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32601.
 */
cljs.core.async.__GT_t_cljs$core$async32601 = (function cljs$core$async$mix_$___GT_t_cljs$core$async32601(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32602){
return (new cljs.core.async.t_cljs$core$async32601(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32602));
});

}

return (new cljs.core.async.t_cljs$core$async32601(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31116__auto___35165 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_32702){
var state_val_32703 = (state_32702[(1)]);
if((state_val_32703 === (7))){
var inst_32659 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
if(cljs.core.truth_(inst_32659)){
var statearr_32707_35166 = state_32702__$1;
(statearr_32707_35166[(1)] = (8));

} else {
var statearr_32708_35167 = state_32702__$1;
(statearr_32708_35167[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (20))){
var inst_32651 = (state_32702[(7)]);
var state_32702__$1 = state_32702;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32702__$1,(23),out,inst_32651);
} else {
if((state_val_32703 === (1))){
var inst_32632 = calc_state();
var inst_32633 = cljs.core.__destructure_map(inst_32632);
var inst_32634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32633,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32633,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32633,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32637 = inst_32632;
var state_32702__$1 = (function (){var statearr_32709 = state_32702;
(statearr_32709[(8)] = inst_32635);

(statearr_32709[(9)] = inst_32634);

(statearr_32709[(10)] = inst_32636);

(statearr_32709[(11)] = inst_32637);

return statearr_32709;
})();
var statearr_32710_35176 = state_32702__$1;
(statearr_32710_35176[(2)] = null);

(statearr_32710_35176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (24))){
var inst_32641 = (state_32702[(12)]);
var inst_32637 = inst_32641;
var state_32702__$1 = (function (){var statearr_32711 = state_32702;
(statearr_32711[(11)] = inst_32637);

return statearr_32711;
})();
var statearr_32714_35178 = state_32702__$1;
(statearr_32714_35178[(2)] = null);

(statearr_32714_35178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (4))){
var inst_32654 = (state_32702[(13)]);
var inst_32651 = (state_32702[(7)]);
var inst_32650 = (state_32702[(2)]);
var inst_32651__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32650,(0),null);
var inst_32652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32650,(1),null);
var inst_32654__$1 = (inst_32651__$1 == null);
var state_32702__$1 = (function (){var statearr_32721 = state_32702;
(statearr_32721[(13)] = inst_32654__$1);

(statearr_32721[(14)] = inst_32652);

(statearr_32721[(7)] = inst_32651__$1);

return statearr_32721;
})();
if(cljs.core.truth_(inst_32654__$1)){
var statearr_32723_35179 = state_32702__$1;
(statearr_32723_35179[(1)] = (5));

} else {
var statearr_32729_35180 = state_32702__$1;
(statearr_32729_35180[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (15))){
var inst_32674 = (state_32702[(15)]);
var inst_32642 = (state_32702[(16)]);
var inst_32674__$1 = cljs.core.empty_QMARK_(inst_32642);
var state_32702__$1 = (function (){var statearr_32737 = state_32702;
(statearr_32737[(15)] = inst_32674__$1);

return statearr_32737;
})();
if(inst_32674__$1){
var statearr_32742_35181 = state_32702__$1;
(statearr_32742_35181[(1)] = (17));

} else {
var statearr_32745_35182 = state_32702__$1;
(statearr_32745_35182[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (21))){
var inst_32641 = (state_32702[(12)]);
var inst_32637 = inst_32641;
var state_32702__$1 = (function (){var statearr_32746 = state_32702;
(statearr_32746[(11)] = inst_32637);

return statearr_32746;
})();
var statearr_32747_35184 = state_32702__$1;
(statearr_32747_35184[(2)] = null);

(statearr_32747_35184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (13))){
var inst_32666 = (state_32702[(2)]);
var inst_32668 = calc_state();
var inst_32637 = inst_32668;
var state_32702__$1 = (function (){var statearr_32748 = state_32702;
(statearr_32748[(17)] = inst_32666);

(statearr_32748[(11)] = inst_32637);

return statearr_32748;
})();
var statearr_32750_35187 = state_32702__$1;
(statearr_32750_35187[(2)] = null);

(statearr_32750_35187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (22))){
var inst_32694 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
var statearr_32751_35188 = state_32702__$1;
(statearr_32751_35188[(2)] = inst_32694);

(statearr_32751_35188[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (6))){
var inst_32652 = (state_32702[(14)]);
var inst_32657 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32652,change);
var state_32702__$1 = state_32702;
var statearr_32752_35190 = state_32702__$1;
(statearr_32752_35190[(2)] = inst_32657);

(statearr_32752_35190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (25))){
var state_32702__$1 = state_32702;
var statearr_32753_35191 = state_32702__$1;
(statearr_32753_35191[(2)] = null);

(statearr_32753_35191[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (17))){
var inst_32652 = (state_32702[(14)]);
var inst_32643 = (state_32702[(18)]);
var inst_32676 = (inst_32643.cljs$core$IFn$_invoke$arity$1 ? inst_32643.cljs$core$IFn$_invoke$arity$1(inst_32652) : inst_32643.call(null,inst_32652));
var inst_32677 = cljs.core.not(inst_32676);
var state_32702__$1 = state_32702;
var statearr_32754_35193 = state_32702__$1;
(statearr_32754_35193[(2)] = inst_32677);

(statearr_32754_35193[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (3))){
var inst_32698 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32702__$1,inst_32698);
} else {
if((state_val_32703 === (12))){
var state_32702__$1 = state_32702;
var statearr_32755_35195 = state_32702__$1;
(statearr_32755_35195[(2)] = null);

(statearr_32755_35195[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (2))){
var inst_32641 = (state_32702[(12)]);
var inst_32637 = (state_32702[(11)]);
var inst_32641__$1 = cljs.core.__destructure_map(inst_32637);
var inst_32642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32641__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32641__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32645 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32641__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32702__$1 = (function (){var statearr_32757 = state_32702;
(statearr_32757[(12)] = inst_32641__$1);

(statearr_32757[(16)] = inst_32642);

(statearr_32757[(18)] = inst_32643);

return statearr_32757;
})();
return cljs.core.async.ioc_alts_BANG_(state_32702__$1,(4),inst_32645);
} else {
if((state_val_32703 === (23))){
var inst_32685 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
if(cljs.core.truth_(inst_32685)){
var statearr_32760_35206 = state_32702__$1;
(statearr_32760_35206[(1)] = (24));

} else {
var statearr_32761_35207 = state_32702__$1;
(statearr_32761_35207[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (19))){
var inst_32680 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
var statearr_32762_35208 = state_32702__$1;
(statearr_32762_35208[(2)] = inst_32680);

(statearr_32762_35208[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (11))){
var inst_32652 = (state_32702[(14)]);
var inst_32663 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32652);
var state_32702__$1 = state_32702;
var statearr_32764_35209 = state_32702__$1;
(statearr_32764_35209[(2)] = inst_32663);

(statearr_32764_35209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (9))){
var inst_32671 = (state_32702[(19)]);
var inst_32652 = (state_32702[(14)]);
var inst_32642 = (state_32702[(16)]);
var inst_32671__$1 = (inst_32642.cljs$core$IFn$_invoke$arity$1 ? inst_32642.cljs$core$IFn$_invoke$arity$1(inst_32652) : inst_32642.call(null,inst_32652));
var state_32702__$1 = (function (){var statearr_32767 = state_32702;
(statearr_32767[(19)] = inst_32671__$1);

return statearr_32767;
})();
if(cljs.core.truth_(inst_32671__$1)){
var statearr_32770_35215 = state_32702__$1;
(statearr_32770_35215[(1)] = (14));

} else {
var statearr_32771_35216 = state_32702__$1;
(statearr_32771_35216[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (5))){
var inst_32654 = (state_32702[(13)]);
var state_32702__$1 = state_32702;
var statearr_32774_35217 = state_32702__$1;
(statearr_32774_35217[(2)] = inst_32654);

(statearr_32774_35217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (14))){
var inst_32671 = (state_32702[(19)]);
var state_32702__$1 = state_32702;
var statearr_32777_35219 = state_32702__$1;
(statearr_32777_35219[(2)] = inst_32671);

(statearr_32777_35219[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (26))){
var inst_32690 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
var statearr_32781_35222 = state_32702__$1;
(statearr_32781_35222[(2)] = inst_32690);

(statearr_32781_35222[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (16))){
var inst_32682 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
if(cljs.core.truth_(inst_32682)){
var statearr_32782_35223 = state_32702__$1;
(statearr_32782_35223[(1)] = (20));

} else {
var statearr_32783_35224 = state_32702__$1;
(statearr_32783_35224[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (10))){
var inst_32696 = (state_32702[(2)]);
var state_32702__$1 = state_32702;
var statearr_32784_35225 = state_32702__$1;
(statearr_32784_35225[(2)] = inst_32696);

(statearr_32784_35225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (18))){
var inst_32674 = (state_32702[(15)]);
var state_32702__$1 = state_32702;
var statearr_32785_35226 = state_32702__$1;
(statearr_32785_35226[(2)] = inst_32674);

(statearr_32785_35226[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32703 === (8))){
var inst_32651 = (state_32702[(7)]);
var inst_32661 = (inst_32651 == null);
var state_32702__$1 = state_32702;
if(cljs.core.truth_(inst_32661)){
var statearr_32786_35230 = state_32702__$1;
(statearr_32786_35230[(1)] = (11));

} else {
var statearr_32787_35231 = state_32702__$1;
(statearr_32787_35231[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__30554__auto__ = null;
var cljs$core$async$mix_$_state_machine__30554__auto____0 = (function (){
var statearr_32789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32789[(0)] = cljs$core$async$mix_$_state_machine__30554__auto__);

(statearr_32789[(1)] = (1));

return statearr_32789;
});
var cljs$core$async$mix_$_state_machine__30554__auto____1 = (function (state_32702){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_32702);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32790){var ex__30557__auto__ = e32790;
var statearr_32791_35235 = state_32702;
(statearr_32791_35235[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_32702[(4)]))){
var statearr_32792_35236 = state_32702;
(statearr_32792_35236[(1)] = cljs.core.first((state_32702[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35237 = state_32702;
state_32702 = G__35237;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30554__auto__ = function(state_32702){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30554__auto____1.call(this,state_32702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30554__auto____0;
cljs$core$async$mix_$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30554__auto____1;
return cljs$core$async$mix_$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32793 = f__31117__auto__();
(statearr_32793[(6)] = c__31116__auto___35165);

return statearr_32793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_35243 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_35243(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_35244 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_35244(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_35247 = (function() {
var G__35248 = null;
var G__35248__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__35248__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__35248 = function(p,v){
switch(arguments.length){
case 1:
return G__35248__1.call(this,p);
case 2:
return G__35248__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35248.cljs$core$IFn$_invoke$arity$1 = G__35248__1;
G__35248.cljs$core$IFn$_invoke$arity$2 = G__35248__2;
return G__35248;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32815 = arguments.length;
switch (G__32815) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35247(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35247(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32828 = arguments.length;
switch (G__32828) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32825_SHARP_){
if(cljs.core.truth_((p1__32825_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32825_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32825_SHARP_.call(null,topic)))){
return p1__32825_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32825_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32838 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32838 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32839){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32839 = meta32839;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32840,meta32839__$1){
var self__ = this;
var _32840__$1 = this;
return (new cljs.core.async.t_cljs$core$async32838(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32839__$1));
}));

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32840){
var self__ = this;
var _32840__$1 = this;
return self__.meta32839;
}));

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32838.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32838.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32839","meta32839",1901742144,null)], null);
}));

(cljs.core.async.t_cljs$core$async32838.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32838.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32838");

(cljs.core.async.t_cljs$core$async32838.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32838");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32838.
 */
cljs.core.async.__GT_t_cljs$core$async32838 = (function cljs$core$async$__GT_t_cljs$core$async32838(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32839){
return (new cljs.core.async.t_cljs$core$async32838(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32839));
});

}

return (new cljs.core.async.t_cljs$core$async32838(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31116__auto___35288 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_32919){
var state_val_32920 = (state_32919[(1)]);
if((state_val_32920 === (7))){
var inst_32914 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
var statearr_32921_35292 = state_32919__$1;
(statearr_32921_35292[(2)] = inst_32914);

(statearr_32921_35292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (20))){
var state_32919__$1 = state_32919;
var statearr_32922_35297 = state_32919__$1;
(statearr_32922_35297[(2)] = null);

(statearr_32922_35297[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (1))){
var state_32919__$1 = state_32919;
var statearr_32923_35300 = state_32919__$1;
(statearr_32923_35300[(2)] = null);

(statearr_32923_35300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (24))){
var inst_32895 = (state_32919[(7)]);
var inst_32906 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32895);
var state_32919__$1 = state_32919;
var statearr_32924_35309 = state_32919__$1;
(statearr_32924_35309[(2)] = inst_32906);

(statearr_32924_35309[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (4))){
var inst_32846 = (state_32919[(8)]);
var inst_32846__$1 = (state_32919[(2)]);
var inst_32847 = (inst_32846__$1 == null);
var state_32919__$1 = (function (){var statearr_32925 = state_32919;
(statearr_32925[(8)] = inst_32846__$1);

return statearr_32925;
})();
if(cljs.core.truth_(inst_32847)){
var statearr_32926_35314 = state_32919__$1;
(statearr_32926_35314[(1)] = (5));

} else {
var statearr_32927_35315 = state_32919__$1;
(statearr_32927_35315[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (15))){
var inst_32889 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
var statearr_32928_35320 = state_32919__$1;
(statearr_32928_35320[(2)] = inst_32889);

(statearr_32928_35320[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (21))){
var inst_32911 = (state_32919[(2)]);
var state_32919__$1 = (function (){var statearr_32929 = state_32919;
(statearr_32929[(9)] = inst_32911);

return statearr_32929;
})();
var statearr_32930_35327 = state_32919__$1;
(statearr_32930_35327[(2)] = null);

(statearr_32930_35327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (13))){
var inst_32870 = (state_32919[(10)]);
var inst_32873 = cljs.core.chunked_seq_QMARK_(inst_32870);
var state_32919__$1 = state_32919;
if(inst_32873){
var statearr_32931_35334 = state_32919__$1;
(statearr_32931_35334[(1)] = (16));

} else {
var statearr_32932_35336 = state_32919__$1;
(statearr_32932_35336[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (22))){
var inst_32901 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
if(cljs.core.truth_(inst_32901)){
var statearr_32933_35341 = state_32919__$1;
(statearr_32933_35341[(1)] = (23));

} else {
var statearr_32934_35342 = state_32919__$1;
(statearr_32934_35342[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (6))){
var inst_32846 = (state_32919[(8)]);
var inst_32897 = (state_32919[(11)]);
var inst_32895 = (state_32919[(7)]);
var inst_32895__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32846) : topic_fn.call(null,inst_32846));
var inst_32896 = cljs.core.deref(mults);
var inst_32897__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32896,inst_32895__$1);
var state_32919__$1 = (function (){var statearr_32935 = state_32919;
(statearr_32935[(11)] = inst_32897__$1);

(statearr_32935[(7)] = inst_32895__$1);

return statearr_32935;
})();
if(cljs.core.truth_(inst_32897__$1)){
var statearr_32936_35344 = state_32919__$1;
(statearr_32936_35344[(1)] = (19));

} else {
var statearr_32937_35345 = state_32919__$1;
(statearr_32937_35345[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (25))){
var inst_32908 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
var statearr_32938_35346 = state_32919__$1;
(statearr_32938_35346[(2)] = inst_32908);

(statearr_32938_35346[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (17))){
var inst_32870 = (state_32919[(10)]);
var inst_32880 = cljs.core.first(inst_32870);
var inst_32881 = cljs.core.async.muxch_STAR_(inst_32880);
var inst_32882 = cljs.core.async.close_BANG_(inst_32881);
var inst_32883 = cljs.core.next(inst_32870);
var inst_32856 = inst_32883;
var inst_32857 = null;
var inst_32858 = (0);
var inst_32859 = (0);
var state_32919__$1 = (function (){var statearr_32939 = state_32919;
(statearr_32939[(12)] = inst_32882);

(statearr_32939[(13)] = inst_32857);

(statearr_32939[(14)] = inst_32859);

(statearr_32939[(15)] = inst_32856);

(statearr_32939[(16)] = inst_32858);

return statearr_32939;
})();
var statearr_32940_35351 = state_32919__$1;
(statearr_32940_35351[(2)] = null);

(statearr_32940_35351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (3))){
var inst_32916 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32919__$1,inst_32916);
} else {
if((state_val_32920 === (12))){
var inst_32891 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
var statearr_32941_35352 = state_32919__$1;
(statearr_32941_35352[(2)] = inst_32891);

(statearr_32941_35352[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (2))){
var state_32919__$1 = state_32919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32919__$1,(4),ch);
} else {
if((state_val_32920 === (23))){
var state_32919__$1 = state_32919;
var statearr_32943_35356 = state_32919__$1;
(statearr_32943_35356[(2)] = null);

(statearr_32943_35356[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (19))){
var inst_32846 = (state_32919[(8)]);
var inst_32897 = (state_32919[(11)]);
var inst_32899 = cljs.core.async.muxch_STAR_(inst_32897);
var state_32919__$1 = state_32919;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32919__$1,(22),inst_32899,inst_32846);
} else {
if((state_val_32920 === (11))){
var inst_32870 = (state_32919[(10)]);
var inst_32856 = (state_32919[(15)]);
var inst_32870__$1 = cljs.core.seq(inst_32856);
var state_32919__$1 = (function (){var statearr_32947 = state_32919;
(statearr_32947[(10)] = inst_32870__$1);

return statearr_32947;
})();
if(inst_32870__$1){
var statearr_32948_35364 = state_32919__$1;
(statearr_32948_35364[(1)] = (13));

} else {
var statearr_32949_35366 = state_32919__$1;
(statearr_32949_35366[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (9))){
var inst_32893 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
var statearr_32950_35367 = state_32919__$1;
(statearr_32950_35367[(2)] = inst_32893);

(statearr_32950_35367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (5))){
var inst_32853 = cljs.core.deref(mults);
var inst_32854 = cljs.core.vals(inst_32853);
var inst_32855 = cljs.core.seq(inst_32854);
var inst_32856 = inst_32855;
var inst_32857 = null;
var inst_32858 = (0);
var inst_32859 = (0);
var state_32919__$1 = (function (){var statearr_32953 = state_32919;
(statearr_32953[(13)] = inst_32857);

(statearr_32953[(14)] = inst_32859);

(statearr_32953[(15)] = inst_32856);

(statearr_32953[(16)] = inst_32858);

return statearr_32953;
})();
var statearr_32955_35378 = state_32919__$1;
(statearr_32955_35378[(2)] = null);

(statearr_32955_35378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (14))){
var state_32919__$1 = state_32919;
var statearr_32959_35381 = state_32919__$1;
(statearr_32959_35381[(2)] = null);

(statearr_32959_35381[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (16))){
var inst_32870 = (state_32919[(10)]);
var inst_32875 = cljs.core.chunk_first(inst_32870);
var inst_32876 = cljs.core.chunk_rest(inst_32870);
var inst_32877 = cljs.core.count(inst_32875);
var inst_32856 = inst_32876;
var inst_32857 = inst_32875;
var inst_32858 = inst_32877;
var inst_32859 = (0);
var state_32919__$1 = (function (){var statearr_32963 = state_32919;
(statearr_32963[(13)] = inst_32857);

(statearr_32963[(14)] = inst_32859);

(statearr_32963[(15)] = inst_32856);

(statearr_32963[(16)] = inst_32858);

return statearr_32963;
})();
var statearr_32964_35393 = state_32919__$1;
(statearr_32964_35393[(2)] = null);

(statearr_32964_35393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (10))){
var inst_32857 = (state_32919[(13)]);
var inst_32859 = (state_32919[(14)]);
var inst_32856 = (state_32919[(15)]);
var inst_32858 = (state_32919[(16)]);
var inst_32864 = cljs.core._nth(inst_32857,inst_32859);
var inst_32865 = cljs.core.async.muxch_STAR_(inst_32864);
var inst_32866 = cljs.core.async.close_BANG_(inst_32865);
var inst_32867 = (inst_32859 + (1));
var tmp32956 = inst_32857;
var tmp32957 = inst_32856;
var tmp32958 = inst_32858;
var inst_32856__$1 = tmp32957;
var inst_32857__$1 = tmp32956;
var inst_32858__$1 = tmp32958;
var inst_32859__$1 = inst_32867;
var state_32919__$1 = (function (){var statearr_32965 = state_32919;
(statearr_32965[(13)] = inst_32857__$1);

(statearr_32965[(14)] = inst_32859__$1);

(statearr_32965[(17)] = inst_32866);

(statearr_32965[(15)] = inst_32856__$1);

(statearr_32965[(16)] = inst_32858__$1);

return statearr_32965;
})();
var statearr_32966_35396 = state_32919__$1;
(statearr_32966_35396[(2)] = null);

(statearr_32966_35396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (18))){
var inst_32886 = (state_32919[(2)]);
var state_32919__$1 = state_32919;
var statearr_32967_35406 = state_32919__$1;
(statearr_32967_35406[(2)] = inst_32886);

(statearr_32967_35406[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32920 === (8))){
var inst_32859 = (state_32919[(14)]);
var inst_32858 = (state_32919[(16)]);
var inst_32861 = (inst_32859 < inst_32858);
var inst_32862 = inst_32861;
var state_32919__$1 = state_32919;
if(cljs.core.truth_(inst_32862)){
var statearr_32968_35413 = state_32919__$1;
(statearr_32968_35413[(1)] = (10));

} else {
var statearr_32969_35414 = state_32919__$1;
(statearr_32969_35414[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_32973 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32973[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_32973[(1)] = (1));

return statearr_32973;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_32919){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_32919);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e32977){var ex__30557__auto__ = e32977;
var statearr_32978_35415 = state_32919;
(statearr_32978_35415[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_32919[(4)]))){
var statearr_32979_35416 = state_32919;
(statearr_32979_35416[(1)] = cljs.core.first((state_32919[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35418 = state_32919;
state_32919 = G__35418;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_32919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_32919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_32981 = f__31117__auto__();
(statearr_32981[(6)] = c__31116__auto___35288);

return statearr_32981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32987 = arguments.length;
switch (G__32987) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32999 = arguments.length;
switch (G__32999) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__33007 = arguments.length;
switch (G__33007) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__31116__auto___35443 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33073){
var state_val_33074 = (state_33073[(1)]);
if((state_val_33074 === (7))){
var state_33073__$1 = state_33073;
var statearr_33077_35450 = state_33073__$1;
(statearr_33077_35450[(2)] = null);

(statearr_33077_35450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (1))){
var state_33073__$1 = state_33073;
var statearr_33080_35451 = state_33073__$1;
(statearr_33080_35451[(2)] = null);

(statearr_33080_35451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (4))){
var inst_33020 = (state_33073[(7)]);
var inst_33019 = (state_33073[(8)]);
var inst_33023 = (inst_33020 < inst_33019);
var state_33073__$1 = state_33073;
if(cljs.core.truth_(inst_33023)){
var statearr_33082_35455 = state_33073__$1;
(statearr_33082_35455[(1)] = (6));

} else {
var statearr_33083_35456 = state_33073__$1;
(statearr_33083_35456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (15))){
var inst_33057 = (state_33073[(9)]);
var inst_33063 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33057);
var state_33073__$1 = state_33073;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33073__$1,(17),out,inst_33063);
} else {
if((state_val_33074 === (13))){
var inst_33057 = (state_33073[(9)]);
var inst_33057__$1 = (state_33073[(2)]);
var inst_33058 = cljs.core.some(cljs.core.nil_QMARK_,inst_33057__$1);
var state_33073__$1 = (function (){var statearr_33085 = state_33073;
(statearr_33085[(9)] = inst_33057__$1);

return statearr_33085;
})();
if(cljs.core.truth_(inst_33058)){
var statearr_33087_35458 = state_33073__$1;
(statearr_33087_35458[(1)] = (14));

} else {
var statearr_33089_35459 = state_33073__$1;
(statearr_33089_35459[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (6))){
var state_33073__$1 = state_33073;
var statearr_33091_35460 = state_33073__$1;
(statearr_33091_35460[(2)] = null);

(statearr_33091_35460[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (17))){
var inst_33065 = (state_33073[(2)]);
var state_33073__$1 = (function (){var statearr_33106 = state_33073;
(statearr_33106[(10)] = inst_33065);

return statearr_33106;
})();
var statearr_33107_35462 = state_33073__$1;
(statearr_33107_35462[(2)] = null);

(statearr_33107_35462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (3))){
var inst_33070 = (state_33073[(2)]);
var state_33073__$1 = state_33073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33073__$1,inst_33070);
} else {
if((state_val_33074 === (12))){
var _ = (function (){var statearr_33109 = state_33073;
(statearr_33109[(4)] = cljs.core.rest((state_33073[(4)])));

return statearr_33109;
})();
var state_33073__$1 = state_33073;
var ex33101 = (state_33073__$1[(2)]);
var statearr_33110_35469 = state_33073__$1;
(statearr_33110_35469[(5)] = ex33101);


if((ex33101 instanceof Object)){
var statearr_33115_35470 = state_33073__$1;
(statearr_33115_35470[(1)] = (11));

(statearr_33115_35470[(5)] = null);

} else {
throw ex33101;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (2))){
var inst_33017 = cljs.core.reset_BANG_(dctr,cnt);
var inst_33019 = cnt;
var inst_33020 = (0);
var state_33073__$1 = (function (){var statearr_33118 = state_33073;
(statearr_33118[(7)] = inst_33020);

(statearr_33118[(8)] = inst_33019);

(statearr_33118[(11)] = inst_33017);

return statearr_33118;
})();
var statearr_33121_35471 = state_33073__$1;
(statearr_33121_35471[(2)] = null);

(statearr_33121_35471[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (11))){
var inst_33032 = (state_33073[(2)]);
var inst_33034 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33073__$1 = (function (){var statearr_33128 = state_33073;
(statearr_33128[(12)] = inst_33032);

return statearr_33128;
})();
var statearr_33129_35472 = state_33073__$1;
(statearr_33129_35472[(2)] = inst_33034);

(statearr_33129_35472[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (9))){
var inst_33020 = (state_33073[(7)]);
var _ = (function (){var statearr_33130 = state_33073;
(statearr_33130[(4)] = cljs.core.cons((12),(state_33073[(4)])));

return statearr_33130;
})();
var inst_33041 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33020) : chs__$1.call(null,inst_33020));
var inst_33042 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33020) : done.call(null,inst_33020));
var inst_33043 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33041,inst_33042);
var ___$1 = (function (){var statearr_33132 = state_33073;
(statearr_33132[(4)] = cljs.core.rest((state_33073[(4)])));

return statearr_33132;
})();
var state_33073__$1 = state_33073;
var statearr_33136_35473 = state_33073__$1;
(statearr_33136_35473[(2)] = inst_33043);

(statearr_33136_35473[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (5))){
var inst_33054 = (state_33073[(2)]);
var state_33073__$1 = (function (){var statearr_33138 = state_33073;
(statearr_33138[(13)] = inst_33054);

return statearr_33138;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33073__$1,(13),dchan);
} else {
if((state_val_33074 === (14))){
var inst_33060 = cljs.core.async.close_BANG_(out);
var state_33073__$1 = state_33073;
var statearr_33141_35474 = state_33073__$1;
(statearr_33141_35474[(2)] = inst_33060);

(statearr_33141_35474[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (16))){
var inst_33068 = (state_33073[(2)]);
var state_33073__$1 = state_33073;
var statearr_33146_35476 = state_33073__$1;
(statearr_33146_35476[(2)] = inst_33068);

(statearr_33146_35476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (10))){
var inst_33020 = (state_33073[(7)]);
var inst_33046 = (state_33073[(2)]);
var inst_33047 = (inst_33020 + (1));
var inst_33020__$1 = inst_33047;
var state_33073__$1 = (function (){var statearr_33152 = state_33073;
(statearr_33152[(14)] = inst_33046);

(statearr_33152[(7)] = inst_33020__$1);

return statearr_33152;
})();
var statearr_33154_35483 = state_33073__$1;
(statearr_33154_35483[(2)] = null);

(statearr_33154_35483[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (8))){
var inst_33051 = (state_33073[(2)]);
var state_33073__$1 = state_33073;
var statearr_33162_35484 = state_33073__$1;
(statearr_33162_35484[(2)] = inst_33051);

(statearr_33162_35484[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_33170 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33170[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_33170[(1)] = (1));

return statearr_33170;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_33073){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33073);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33171){var ex__30557__auto__ = e33171;
var statearr_33173_35488 = state_33073;
(statearr_33173_35488[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33073[(4)]))){
var statearr_33174_35489 = state_33073;
(statearr_33174_35489[(1)] = cljs.core.first((state_33073[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35490 = state_33073;
state_33073 = G__35490;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_33073){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_33073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33176 = f__31117__auto__();
(statearr_33176[(6)] = c__31116__auto___35443);

return statearr_33176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33185 = arguments.length;
switch (G__33185) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31116__auto___35495 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33223){
var state_val_33224 = (state_33223[(1)]);
if((state_val_33224 === (7))){
var inst_33201 = (state_33223[(7)]);
var inst_33202 = (state_33223[(8)]);
var inst_33201__$1 = (state_33223[(2)]);
var inst_33202__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33201__$1,(0),null);
var inst_33203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33201__$1,(1),null);
var inst_33204 = (inst_33202__$1 == null);
var state_33223__$1 = (function (){var statearr_33228 = state_33223;
(statearr_33228[(7)] = inst_33201__$1);

(statearr_33228[(9)] = inst_33203);

(statearr_33228[(8)] = inst_33202__$1);

return statearr_33228;
})();
if(cljs.core.truth_(inst_33204)){
var statearr_33232_35497 = state_33223__$1;
(statearr_33232_35497[(1)] = (8));

} else {
var statearr_33233_35498 = state_33223__$1;
(statearr_33233_35498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (1))){
var inst_33191 = cljs.core.vec(chs);
var inst_33192 = inst_33191;
var state_33223__$1 = (function (){var statearr_33236 = state_33223;
(statearr_33236[(10)] = inst_33192);

return statearr_33236;
})();
var statearr_33239_35499 = state_33223__$1;
(statearr_33239_35499[(2)] = null);

(statearr_33239_35499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (4))){
var inst_33192 = (state_33223[(10)]);
var state_33223__$1 = state_33223;
return cljs.core.async.ioc_alts_BANG_(state_33223__$1,(7),inst_33192);
} else {
if((state_val_33224 === (6))){
var inst_33219 = (state_33223[(2)]);
var state_33223__$1 = state_33223;
var statearr_33242_35507 = state_33223__$1;
(statearr_33242_35507[(2)] = inst_33219);

(statearr_33242_35507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (3))){
var inst_33221 = (state_33223[(2)]);
var state_33223__$1 = state_33223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33223__$1,inst_33221);
} else {
if((state_val_33224 === (2))){
var inst_33192 = (state_33223[(10)]);
var inst_33194 = cljs.core.count(inst_33192);
var inst_33195 = (inst_33194 > (0));
var state_33223__$1 = state_33223;
if(cljs.core.truth_(inst_33195)){
var statearr_33248_35509 = state_33223__$1;
(statearr_33248_35509[(1)] = (4));

} else {
var statearr_33249_35510 = state_33223__$1;
(statearr_33249_35510[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (11))){
var inst_33192 = (state_33223[(10)]);
var inst_33212 = (state_33223[(2)]);
var tmp33243 = inst_33192;
var inst_33192__$1 = tmp33243;
var state_33223__$1 = (function (){var statearr_33252 = state_33223;
(statearr_33252[(10)] = inst_33192__$1);

(statearr_33252[(11)] = inst_33212);

return statearr_33252;
})();
var statearr_33256_35515 = state_33223__$1;
(statearr_33256_35515[(2)] = null);

(statearr_33256_35515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (9))){
var inst_33202 = (state_33223[(8)]);
var state_33223__$1 = state_33223;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33223__$1,(11),out,inst_33202);
} else {
if((state_val_33224 === (5))){
var inst_33217 = cljs.core.async.close_BANG_(out);
var state_33223__$1 = state_33223;
var statearr_33266_35518 = state_33223__$1;
(statearr_33266_35518[(2)] = inst_33217);

(statearr_33266_35518[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (10))){
var inst_33215 = (state_33223[(2)]);
var state_33223__$1 = state_33223;
var statearr_33268_35522 = state_33223__$1;
(statearr_33268_35522[(2)] = inst_33215);

(statearr_33268_35522[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33224 === (8))){
var inst_33201 = (state_33223[(7)]);
var inst_33192 = (state_33223[(10)]);
var inst_33203 = (state_33223[(9)]);
var inst_33202 = (state_33223[(8)]);
var inst_33207 = (function (){var cs = inst_33192;
var vec__33197 = inst_33201;
var v = inst_33202;
var c = inst_33203;
return (function (p1__33180_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33180_SHARP_);
});
})();
var inst_33208 = cljs.core.filterv(inst_33207,inst_33192);
var inst_33192__$1 = inst_33208;
var state_33223__$1 = (function (){var statearr_33272 = state_33223;
(statearr_33272[(10)] = inst_33192__$1);

return statearr_33272;
})();
var statearr_33273_35524 = state_33223__$1;
(statearr_33273_35524[(2)] = null);

(statearr_33273_35524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_33277 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33277[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_33277[(1)] = (1));

return statearr_33277;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_33223){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33223);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33278){var ex__30557__auto__ = e33278;
var statearr_33279_35526 = state_33223;
(statearr_33279_35526[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33223[(4)]))){
var statearr_33280_35527 = state_33223;
(statearr_33280_35527[(1)] = cljs.core.first((state_33223[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35528 = state_33223;
state_33223 = G__35528;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_33223){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_33223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33282 = f__31117__auto__();
(statearr_33282[(6)] = c__31116__auto___35495);

return statearr_33282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33293 = arguments.length;
switch (G__33293) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31116__auto___35531 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33352){
var state_val_33353 = (state_33352[(1)]);
if((state_val_33353 === (7))){
var inst_33312 = (state_33352[(7)]);
var inst_33312__$1 = (state_33352[(2)]);
var inst_33318 = (inst_33312__$1 == null);
var inst_33321 = cljs.core.not(inst_33318);
var state_33352__$1 = (function (){var statearr_33358 = state_33352;
(statearr_33358[(7)] = inst_33312__$1);

return statearr_33358;
})();
if(inst_33321){
var statearr_33362_35533 = state_33352__$1;
(statearr_33362_35533[(1)] = (8));

} else {
var statearr_33363_35534 = state_33352__$1;
(statearr_33363_35534[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (1))){
var inst_33302 = (0);
var state_33352__$1 = (function (){var statearr_33367 = state_33352;
(statearr_33367[(8)] = inst_33302);

return statearr_33367;
})();
var statearr_33368_35535 = state_33352__$1;
(statearr_33368_35535[(2)] = null);

(statearr_33368_35535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (4))){
var state_33352__$1 = state_33352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33352__$1,(7),ch);
} else {
if((state_val_33353 === (6))){
var inst_33345 = (state_33352[(2)]);
var state_33352__$1 = state_33352;
var statearr_33378_35536 = state_33352__$1;
(statearr_33378_35536[(2)] = inst_33345);

(statearr_33378_35536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (3))){
var inst_33347 = (state_33352[(2)]);
var inst_33348 = cljs.core.async.close_BANG_(out);
var state_33352__$1 = (function (){var statearr_33380 = state_33352;
(statearr_33380[(9)] = inst_33347);

return statearr_33380;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33352__$1,inst_33348);
} else {
if((state_val_33353 === (2))){
var inst_33302 = (state_33352[(8)]);
var inst_33305 = (inst_33302 < n);
var state_33352__$1 = state_33352;
if(cljs.core.truth_(inst_33305)){
var statearr_33383_35539 = state_33352__$1;
(statearr_33383_35539[(1)] = (4));

} else {
var statearr_33384_35540 = state_33352__$1;
(statearr_33384_35540[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (11))){
var inst_33302 = (state_33352[(8)]);
var inst_33337 = (state_33352[(2)]);
var inst_33338 = (inst_33302 + (1));
var inst_33302__$1 = inst_33338;
var state_33352__$1 = (function (){var statearr_33388 = state_33352;
(statearr_33388[(10)] = inst_33337);

(statearr_33388[(8)] = inst_33302__$1);

return statearr_33388;
})();
var statearr_33389_35543 = state_33352__$1;
(statearr_33389_35543[(2)] = null);

(statearr_33389_35543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (9))){
var state_33352__$1 = state_33352;
var statearr_33391_35544 = state_33352__$1;
(statearr_33391_35544[(2)] = null);

(statearr_33391_35544[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (5))){
var state_33352__$1 = state_33352;
var statearr_33392_35546 = state_33352__$1;
(statearr_33392_35546[(2)] = null);

(statearr_33392_35546[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (10))){
var inst_33342 = (state_33352[(2)]);
var state_33352__$1 = state_33352;
var statearr_33396_35547 = state_33352__$1;
(statearr_33396_35547[(2)] = inst_33342);

(statearr_33396_35547[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33353 === (8))){
var inst_33312 = (state_33352[(7)]);
var state_33352__$1 = state_33352;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33352__$1,(11),out,inst_33312);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_33398 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33398[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_33398[(1)] = (1));

return statearr_33398;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_33352){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33352);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33402){var ex__30557__auto__ = e33402;
var statearr_33403_35551 = state_33352;
(statearr_33403_35551[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33352[(4)]))){
var statearr_33404_35553 = state_33352;
(statearr_33404_35553[(1)] = cljs.core.first((state_33352[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35554 = state_33352;
state_33352 = G__35554;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_33352){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_33352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33408 = f__31117__auto__();
(statearr_33408[(6)] = c__31116__auto___35531);

return statearr_33408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33415 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33415 = (function (f,ch,meta33416){
this.f = f;
this.ch = ch;
this.meta33416 = meta33416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33417,meta33416__$1){
var self__ = this;
var _33417__$1 = this;
return (new cljs.core.async.t_cljs$core$async33415(self__.f,self__.ch,meta33416__$1));
}));

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33417){
var self__ = this;
var _33417__$1 = this;
return self__.meta33416;
}));

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33426 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33426 = (function (f,ch,meta33416,_,fn1,meta33427){
this.f = f;
this.ch = ch;
this.meta33416 = meta33416;
this._ = _;
this.fn1 = fn1;
this.meta33427 = meta33427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33428,meta33427__$1){
var self__ = this;
var _33428__$1 = this;
return (new cljs.core.async.t_cljs$core$async33426(self__.f,self__.ch,self__.meta33416,self__._,self__.fn1,meta33427__$1));
}));

(cljs.core.async.t_cljs$core$async33426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33428){
var self__ = this;
var _33428__$1 = this;
return self__.meta33427;
}));

(cljs.core.async.t_cljs$core$async33426.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33426.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33426.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33426.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33411_SHARP_){
var G__33444 = (((p1__33411_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33411_SHARP_) : self__.f.call(null,p1__33411_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33444) : f1.call(null,G__33444));
});
}));

(cljs.core.async.t_cljs$core$async33426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33416","meta33416",985355421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33415","cljs.core.async/t_cljs$core$async33415",-564346036,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33427","meta33427",1606476895,null)], null);
}));

(cljs.core.async.t_cljs$core$async33426.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33426");

(cljs.core.async.t_cljs$core$async33426.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33426");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33426.
 */
cljs.core.async.__GT_t_cljs$core$async33426 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33426(f__$1,ch__$1,meta33416__$1,___$2,fn1__$1,meta33427){
return (new cljs.core.async.t_cljs$core$async33426(f__$1,ch__$1,meta33416__$1,___$2,fn1__$1,meta33427));
});

}

return (new cljs.core.async.t_cljs$core$async33426(self__.f,self__.ch,self__.meta33416,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33463 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33463) : self__.f.call(null,G__33463));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33415.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33416","meta33416",985355421,null)], null);
}));

(cljs.core.async.t_cljs$core$async33415.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33415");

(cljs.core.async.t_cljs$core$async33415.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33415");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33415.
 */
cljs.core.async.__GT_t_cljs$core$async33415 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33415(f__$1,ch__$1,meta33416){
return (new cljs.core.async.t_cljs$core$async33415(f__$1,ch__$1,meta33416));
});

}

return (new cljs.core.async.t_cljs$core$async33415(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33482 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33482 = (function (f,ch,meta33483){
this.f = f;
this.ch = ch;
this.meta33483 = meta33483;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33484,meta33483__$1){
var self__ = this;
var _33484__$1 = this;
return (new cljs.core.async.t_cljs$core$async33482(self__.f,self__.ch,meta33483__$1));
}));

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33484){
var self__ = this;
var _33484__$1 = this;
return self__.meta33483;
}));

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33482.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33482.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33483","meta33483",1768715472,null)], null);
}));

(cljs.core.async.t_cljs$core$async33482.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33482.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33482");

(cljs.core.async.t_cljs$core$async33482.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33482");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33482.
 */
cljs.core.async.__GT_t_cljs$core$async33482 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33482(f__$1,ch__$1,meta33483){
return (new cljs.core.async.t_cljs$core$async33482(f__$1,ch__$1,meta33483));
});

}

return (new cljs.core.async.t_cljs$core$async33482(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33516 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33516 = (function (p,ch,meta33517){
this.p = p;
this.ch = ch;
this.meta33517 = meta33517;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33518,meta33517__$1){
var self__ = this;
var _33518__$1 = this;
return (new cljs.core.async.t_cljs$core$async33516(self__.p,self__.ch,meta33517__$1));
}));

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33518){
var self__ = this;
var _33518__$1 = this;
return self__.meta33517;
}));

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33516.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33516.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33517","meta33517",638316259,null)], null);
}));

(cljs.core.async.t_cljs$core$async33516.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33516.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33516");

(cljs.core.async.t_cljs$core$async33516.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33516");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33516.
 */
cljs.core.async.__GT_t_cljs$core$async33516 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33516(p__$1,ch__$1,meta33517){
return (new cljs.core.async.t_cljs$core$async33516(p__$1,ch__$1,meta33517));
});

}

return (new cljs.core.async.t_cljs$core$async33516(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33533 = arguments.length;
switch (G__33533) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31116__auto___35606 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33559){
var state_val_33560 = (state_33559[(1)]);
if((state_val_33560 === (7))){
var inst_33555 = (state_33559[(2)]);
var state_33559__$1 = state_33559;
var statearr_33565_35611 = state_33559__$1;
(statearr_33565_35611[(2)] = inst_33555);

(statearr_33565_35611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (1))){
var state_33559__$1 = state_33559;
var statearr_33566_35615 = state_33559__$1;
(statearr_33566_35615[(2)] = null);

(statearr_33566_35615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (4))){
var inst_33541 = (state_33559[(7)]);
var inst_33541__$1 = (state_33559[(2)]);
var inst_33542 = (inst_33541__$1 == null);
var state_33559__$1 = (function (){var statearr_33570 = state_33559;
(statearr_33570[(7)] = inst_33541__$1);

return statearr_33570;
})();
if(cljs.core.truth_(inst_33542)){
var statearr_33571_35616 = state_33559__$1;
(statearr_33571_35616[(1)] = (5));

} else {
var statearr_33572_35617 = state_33559__$1;
(statearr_33572_35617[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (6))){
var inst_33541 = (state_33559[(7)]);
var inst_33546 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33541) : p.call(null,inst_33541));
var state_33559__$1 = state_33559;
if(cljs.core.truth_(inst_33546)){
var statearr_33574_35618 = state_33559__$1;
(statearr_33574_35618[(1)] = (8));

} else {
var statearr_33575_35619 = state_33559__$1;
(statearr_33575_35619[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (3))){
var inst_33557 = (state_33559[(2)]);
var state_33559__$1 = state_33559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33559__$1,inst_33557);
} else {
if((state_val_33560 === (2))){
var state_33559__$1 = state_33559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33559__$1,(4),ch);
} else {
if((state_val_33560 === (11))){
var inst_33549 = (state_33559[(2)]);
var state_33559__$1 = state_33559;
var statearr_33577_35621 = state_33559__$1;
(statearr_33577_35621[(2)] = inst_33549);

(statearr_33577_35621[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (9))){
var state_33559__$1 = state_33559;
var statearr_33582_35622 = state_33559__$1;
(statearr_33582_35622[(2)] = null);

(statearr_33582_35622[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (5))){
var inst_33544 = cljs.core.async.close_BANG_(out);
var state_33559__$1 = state_33559;
var statearr_33583_35624 = state_33559__$1;
(statearr_33583_35624[(2)] = inst_33544);

(statearr_33583_35624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (10))){
var inst_33552 = (state_33559[(2)]);
var state_33559__$1 = (function (){var statearr_33589 = state_33559;
(statearr_33589[(8)] = inst_33552);

return statearr_33589;
})();
var statearr_33590_35626 = state_33559__$1;
(statearr_33590_35626[(2)] = null);

(statearr_33590_35626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33560 === (8))){
var inst_33541 = (state_33559[(7)]);
var state_33559__$1 = state_33559;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33559__$1,(11),out,inst_33541);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_33595 = [null,null,null,null,null,null,null,null,null];
(statearr_33595[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_33595[(1)] = (1));

return statearr_33595;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_33559){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33559);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33599){var ex__30557__auto__ = e33599;
var statearr_33605_35627 = state_33559;
(statearr_33605_35627[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33559[(4)]))){
var statearr_33606_35628 = state_33559;
(statearr_33606_35628[(1)] = cljs.core.first((state_33559[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35633 = state_33559;
state_33559 = G__35633;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_33559){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_33559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33607 = f__31117__auto__();
(statearr_33607[(6)] = c__31116__auto___35606);

return statearr_33607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33613 = arguments.length;
switch (G__33613) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31116__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33698){
var state_val_33699 = (state_33698[(1)]);
if((state_val_33699 === (7))){
var inst_33694 = (state_33698[(2)]);
var state_33698__$1 = state_33698;
var statearr_33707_35636 = state_33698__$1;
(statearr_33707_35636[(2)] = inst_33694);

(statearr_33707_35636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (20))){
var inst_33664 = (state_33698[(7)]);
var inst_33675 = (state_33698[(2)]);
var inst_33676 = cljs.core.next(inst_33664);
var inst_33649 = inst_33676;
var inst_33650 = null;
var inst_33651 = (0);
var inst_33652 = (0);
var state_33698__$1 = (function (){var statearr_33709 = state_33698;
(statearr_33709[(8)] = inst_33649);

(statearr_33709[(9)] = inst_33652);

(statearr_33709[(10)] = inst_33675);

(statearr_33709[(11)] = inst_33650);

(statearr_33709[(12)] = inst_33651);

return statearr_33709;
})();
var statearr_33710_35638 = state_33698__$1;
(statearr_33710_35638[(2)] = null);

(statearr_33710_35638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (1))){
var state_33698__$1 = state_33698;
var statearr_33711_35640 = state_33698__$1;
(statearr_33711_35640[(2)] = null);

(statearr_33711_35640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (4))){
var inst_33636 = (state_33698[(13)]);
var inst_33636__$1 = (state_33698[(2)]);
var inst_33637 = (inst_33636__$1 == null);
var state_33698__$1 = (function (){var statearr_33715 = state_33698;
(statearr_33715[(13)] = inst_33636__$1);

return statearr_33715;
})();
if(cljs.core.truth_(inst_33637)){
var statearr_33718_35641 = state_33698__$1;
(statearr_33718_35641[(1)] = (5));

} else {
var statearr_33719_35642 = state_33698__$1;
(statearr_33719_35642[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (15))){
var state_33698__$1 = state_33698;
var statearr_33725_35647 = state_33698__$1;
(statearr_33725_35647[(2)] = null);

(statearr_33725_35647[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (21))){
var state_33698__$1 = state_33698;
var statearr_33726_35649 = state_33698__$1;
(statearr_33726_35649[(2)] = null);

(statearr_33726_35649[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (13))){
var inst_33649 = (state_33698[(8)]);
var inst_33652 = (state_33698[(9)]);
var inst_33650 = (state_33698[(11)]);
var inst_33651 = (state_33698[(12)]);
var inst_33659 = (state_33698[(2)]);
var inst_33660 = (inst_33652 + (1));
var tmp33722 = inst_33649;
var tmp33723 = inst_33650;
var tmp33724 = inst_33651;
var inst_33649__$1 = tmp33722;
var inst_33650__$1 = tmp33723;
var inst_33651__$1 = tmp33724;
var inst_33652__$1 = inst_33660;
var state_33698__$1 = (function (){var statearr_33733 = state_33698;
(statearr_33733[(8)] = inst_33649__$1);

(statearr_33733[(14)] = inst_33659);

(statearr_33733[(9)] = inst_33652__$1);

(statearr_33733[(11)] = inst_33650__$1);

(statearr_33733[(12)] = inst_33651__$1);

return statearr_33733;
})();
var statearr_33735_35665 = state_33698__$1;
(statearr_33735_35665[(2)] = null);

(statearr_33735_35665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (22))){
var state_33698__$1 = state_33698;
var statearr_33747_35671 = state_33698__$1;
(statearr_33747_35671[(2)] = null);

(statearr_33747_35671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (6))){
var inst_33636 = (state_33698[(13)]);
var inst_33647 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33636) : f.call(null,inst_33636));
var inst_33648 = cljs.core.seq(inst_33647);
var inst_33649 = inst_33648;
var inst_33650 = null;
var inst_33651 = (0);
var inst_33652 = (0);
var state_33698__$1 = (function (){var statearr_33754 = state_33698;
(statearr_33754[(8)] = inst_33649);

(statearr_33754[(9)] = inst_33652);

(statearr_33754[(11)] = inst_33650);

(statearr_33754[(12)] = inst_33651);

return statearr_33754;
})();
var statearr_33757_35696 = state_33698__$1;
(statearr_33757_35696[(2)] = null);

(statearr_33757_35696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (17))){
var inst_33664 = (state_33698[(7)]);
var inst_33668 = cljs.core.chunk_first(inst_33664);
var inst_33669 = cljs.core.chunk_rest(inst_33664);
var inst_33670 = cljs.core.count(inst_33668);
var inst_33649 = inst_33669;
var inst_33650 = inst_33668;
var inst_33651 = inst_33670;
var inst_33652 = (0);
var state_33698__$1 = (function (){var statearr_33760 = state_33698;
(statearr_33760[(8)] = inst_33649);

(statearr_33760[(9)] = inst_33652);

(statearr_33760[(11)] = inst_33650);

(statearr_33760[(12)] = inst_33651);

return statearr_33760;
})();
var statearr_33762_35714 = state_33698__$1;
(statearr_33762_35714[(2)] = null);

(statearr_33762_35714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (3))){
var inst_33696 = (state_33698[(2)]);
var state_33698__$1 = state_33698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33698__$1,inst_33696);
} else {
if((state_val_33699 === (12))){
var inst_33684 = (state_33698[(2)]);
var state_33698__$1 = state_33698;
var statearr_33765_35725 = state_33698__$1;
(statearr_33765_35725[(2)] = inst_33684);

(statearr_33765_35725[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (2))){
var state_33698__$1 = state_33698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33698__$1,(4),in$);
} else {
if((state_val_33699 === (23))){
var inst_33692 = (state_33698[(2)]);
var state_33698__$1 = state_33698;
var statearr_33769_35731 = state_33698__$1;
(statearr_33769_35731[(2)] = inst_33692);

(statearr_33769_35731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (19))){
var inst_33679 = (state_33698[(2)]);
var state_33698__$1 = state_33698;
var statearr_33770_35737 = state_33698__$1;
(statearr_33770_35737[(2)] = inst_33679);

(statearr_33770_35737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (11))){
var inst_33664 = (state_33698[(7)]);
var inst_33649 = (state_33698[(8)]);
var inst_33664__$1 = cljs.core.seq(inst_33649);
var state_33698__$1 = (function (){var statearr_33771 = state_33698;
(statearr_33771[(7)] = inst_33664__$1);

return statearr_33771;
})();
if(inst_33664__$1){
var statearr_33772_35750 = state_33698__$1;
(statearr_33772_35750[(1)] = (14));

} else {
var statearr_33773_35751 = state_33698__$1;
(statearr_33773_35751[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (9))){
var inst_33686 = (state_33698[(2)]);
var inst_33687 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33698__$1 = (function (){var statearr_33778 = state_33698;
(statearr_33778[(15)] = inst_33686);

return statearr_33778;
})();
if(cljs.core.truth_(inst_33687)){
var statearr_33781_35764 = state_33698__$1;
(statearr_33781_35764[(1)] = (21));

} else {
var statearr_33782_35765 = state_33698__$1;
(statearr_33782_35765[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (5))){
var inst_33639 = cljs.core.async.close_BANG_(out);
var state_33698__$1 = state_33698;
var statearr_33784_35766 = state_33698__$1;
(statearr_33784_35766[(2)] = inst_33639);

(statearr_33784_35766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (14))){
var inst_33664 = (state_33698[(7)]);
var inst_33666 = cljs.core.chunked_seq_QMARK_(inst_33664);
var state_33698__$1 = state_33698;
if(inst_33666){
var statearr_33786_35767 = state_33698__$1;
(statearr_33786_35767[(1)] = (17));

} else {
var statearr_33788_35768 = state_33698__$1;
(statearr_33788_35768[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (16))){
var inst_33682 = (state_33698[(2)]);
var state_33698__$1 = state_33698;
var statearr_33789_35769 = state_33698__$1;
(statearr_33789_35769[(2)] = inst_33682);

(statearr_33789_35769[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33699 === (10))){
var inst_33652 = (state_33698[(9)]);
var inst_33650 = (state_33698[(11)]);
var inst_33657 = cljs.core._nth(inst_33650,inst_33652);
var state_33698__$1 = state_33698;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33698__$1,(13),out,inst_33657);
} else {
if((state_val_33699 === (18))){
var inst_33664 = (state_33698[(7)]);
var inst_33673 = cljs.core.first(inst_33664);
var state_33698__$1 = state_33698;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33698__$1,(20),out,inst_33673);
} else {
if((state_val_33699 === (8))){
var inst_33652 = (state_33698[(9)]);
var inst_33651 = (state_33698[(12)]);
var inst_33654 = (inst_33652 < inst_33651);
var inst_33655 = inst_33654;
var state_33698__$1 = state_33698;
if(cljs.core.truth_(inst_33655)){
var statearr_33795_35772 = state_33698__$1;
(statearr_33795_35772[(1)] = (10));

} else {
var statearr_33796_35777 = state_33698__$1;
(statearr_33796_35777[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30554__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30554__auto____0 = (function (){
var statearr_33799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33799[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30554__auto__);

(statearr_33799[(1)] = (1));

return statearr_33799;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30554__auto____1 = (function (state_33698){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33698);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33801){var ex__30557__auto__ = e33801;
var statearr_33802_35786 = state_33698;
(statearr_33802_35786[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33698[(4)]))){
var statearr_33803_35787 = state_33698;
(statearr_33803_35787[(1)] = cljs.core.first((state_33698[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35791 = state_33698;
state_33698 = G__35791;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30554__auto__ = function(state_33698){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30554__auto____1.call(this,state_33698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30554__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30554__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33807 = f__31117__auto__();
(statearr_33807[(6)] = c__31116__auto__);

return statearr_33807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

return c__31116__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33811 = arguments.length;
switch (G__33811) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33814 = arguments.length;
switch (G__33814) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33816 = arguments.length;
switch (G__33816) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31116__auto___35799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33842){
var state_val_33843 = (state_33842[(1)]);
if((state_val_33843 === (7))){
var inst_33837 = (state_33842[(2)]);
var state_33842__$1 = state_33842;
var statearr_33844_35802 = state_33842__$1;
(statearr_33844_35802[(2)] = inst_33837);

(statearr_33844_35802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (1))){
var inst_33818 = null;
var state_33842__$1 = (function (){var statearr_33845 = state_33842;
(statearr_33845[(7)] = inst_33818);

return statearr_33845;
})();
var statearr_33846_35805 = state_33842__$1;
(statearr_33846_35805[(2)] = null);

(statearr_33846_35805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (4))){
var inst_33822 = (state_33842[(8)]);
var inst_33822__$1 = (state_33842[(2)]);
var inst_33823 = (inst_33822__$1 == null);
var inst_33824 = cljs.core.not(inst_33823);
var state_33842__$1 = (function (){var statearr_33847 = state_33842;
(statearr_33847[(8)] = inst_33822__$1);

return statearr_33847;
})();
if(inst_33824){
var statearr_33848_35820 = state_33842__$1;
(statearr_33848_35820[(1)] = (5));

} else {
var statearr_33849_35827 = state_33842__$1;
(statearr_33849_35827[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (6))){
var state_33842__$1 = state_33842;
var statearr_33852_35829 = state_33842__$1;
(statearr_33852_35829[(2)] = null);

(statearr_33852_35829[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (3))){
var inst_33839 = (state_33842[(2)]);
var inst_33840 = cljs.core.async.close_BANG_(out);
var state_33842__$1 = (function (){var statearr_33853 = state_33842;
(statearr_33853[(9)] = inst_33839);

return statearr_33853;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33842__$1,inst_33840);
} else {
if((state_val_33843 === (2))){
var state_33842__$1 = state_33842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33842__$1,(4),ch);
} else {
if((state_val_33843 === (11))){
var inst_33822 = (state_33842[(8)]);
var inst_33831 = (state_33842[(2)]);
var inst_33818 = inst_33822;
var state_33842__$1 = (function (){var statearr_33854 = state_33842;
(statearr_33854[(7)] = inst_33818);

(statearr_33854[(10)] = inst_33831);

return statearr_33854;
})();
var statearr_33855_35851 = state_33842__$1;
(statearr_33855_35851[(2)] = null);

(statearr_33855_35851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (9))){
var inst_33822 = (state_33842[(8)]);
var state_33842__$1 = state_33842;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33842__$1,(11),out,inst_33822);
} else {
if((state_val_33843 === (5))){
var inst_33818 = (state_33842[(7)]);
var inst_33822 = (state_33842[(8)]);
var inst_33826 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33822,inst_33818);
var state_33842__$1 = state_33842;
if(inst_33826){
var statearr_33860_35869 = state_33842__$1;
(statearr_33860_35869[(1)] = (8));

} else {
var statearr_33861_35870 = state_33842__$1;
(statearr_33861_35870[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (10))){
var inst_33834 = (state_33842[(2)]);
var state_33842__$1 = state_33842;
var statearr_33862_35873 = state_33842__$1;
(statearr_33862_35873[(2)] = inst_33834);

(statearr_33862_35873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33843 === (8))){
var inst_33818 = (state_33842[(7)]);
var tmp33857 = inst_33818;
var inst_33818__$1 = tmp33857;
var state_33842__$1 = (function (){var statearr_33865 = state_33842;
(statearr_33865[(7)] = inst_33818__$1);

return statearr_33865;
})();
var statearr_33867_35878 = state_33842__$1;
(statearr_33867_35878[(2)] = null);

(statearr_33867_35878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_33871 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33871[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_33871[(1)] = (1));

return statearr_33871;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_33842){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33842);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33872){var ex__30557__auto__ = e33872;
var statearr_33873_35884 = state_33842;
(statearr_33873_35884[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33842[(4)]))){
var statearr_33874_35885 = state_33842;
(statearr_33874_35885[(1)] = cljs.core.first((state_33842[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35895 = state_33842;
state_33842 = G__35895;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_33842){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_33842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33875 = f__31117__auto__();
(statearr_33875[(6)] = c__31116__auto___35799);

return statearr_33875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33881 = arguments.length;
switch (G__33881) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31116__auto___35926 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_33923){
var state_val_33924 = (state_33923[(1)]);
if((state_val_33924 === (7))){
var inst_33915 = (state_33923[(2)]);
var state_33923__$1 = state_33923;
var statearr_33933_35928 = state_33923__$1;
(statearr_33933_35928[(2)] = inst_33915);

(statearr_33933_35928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (1))){
var inst_33882 = (new Array(n));
var inst_33883 = inst_33882;
var inst_33884 = (0);
var state_33923__$1 = (function (){var statearr_33934 = state_33923;
(statearr_33934[(7)] = inst_33883);

(statearr_33934[(8)] = inst_33884);

return statearr_33934;
})();
var statearr_33935_35937 = state_33923__$1;
(statearr_33935_35937[(2)] = null);

(statearr_33935_35937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (4))){
var inst_33887 = (state_33923[(9)]);
var inst_33887__$1 = (state_33923[(2)]);
var inst_33888 = (inst_33887__$1 == null);
var inst_33889 = cljs.core.not(inst_33888);
var state_33923__$1 = (function (){var statearr_33938 = state_33923;
(statearr_33938[(9)] = inst_33887__$1);

return statearr_33938;
})();
if(inst_33889){
var statearr_33939_35938 = state_33923__$1;
(statearr_33939_35938[(1)] = (5));

} else {
var statearr_33940_35939 = state_33923__$1;
(statearr_33940_35939[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (15))){
var inst_33909 = (state_33923[(2)]);
var state_33923__$1 = state_33923;
var statearr_33941_35940 = state_33923__$1;
(statearr_33941_35940[(2)] = inst_33909);

(statearr_33941_35940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (13))){
var state_33923__$1 = state_33923;
var statearr_33942_35941 = state_33923__$1;
(statearr_33942_35941[(2)] = null);

(statearr_33942_35941[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (6))){
var inst_33884 = (state_33923[(8)]);
var inst_33905 = (inst_33884 > (0));
var state_33923__$1 = state_33923;
if(cljs.core.truth_(inst_33905)){
var statearr_33944_35957 = state_33923__$1;
(statearr_33944_35957[(1)] = (12));

} else {
var statearr_33946_35958 = state_33923__$1;
(statearr_33946_35958[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (3))){
var inst_33917 = (state_33923[(2)]);
var state_33923__$1 = state_33923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33923__$1,inst_33917);
} else {
if((state_val_33924 === (12))){
var inst_33883 = (state_33923[(7)]);
var inst_33907 = cljs.core.vec(inst_33883);
var state_33923__$1 = state_33923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33923__$1,(15),out,inst_33907);
} else {
if((state_val_33924 === (2))){
var state_33923__$1 = state_33923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33923__$1,(4),ch);
} else {
if((state_val_33924 === (11))){
var inst_33899 = (state_33923[(2)]);
var inst_33900 = (new Array(n));
var inst_33883 = inst_33900;
var inst_33884 = (0);
var state_33923__$1 = (function (){var statearr_33950 = state_33923;
(statearr_33950[(7)] = inst_33883);

(statearr_33950[(10)] = inst_33899);

(statearr_33950[(8)] = inst_33884);

return statearr_33950;
})();
var statearr_33951_35968 = state_33923__$1;
(statearr_33951_35968[(2)] = null);

(statearr_33951_35968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (9))){
var inst_33883 = (state_33923[(7)]);
var inst_33897 = cljs.core.vec(inst_33883);
var state_33923__$1 = state_33923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33923__$1,(11),out,inst_33897);
} else {
if((state_val_33924 === (5))){
var inst_33883 = (state_33923[(7)]);
var inst_33887 = (state_33923[(9)]);
var inst_33892 = (state_33923[(11)]);
var inst_33884 = (state_33923[(8)]);
var inst_33891 = (inst_33883[inst_33884] = inst_33887);
var inst_33892__$1 = (inst_33884 + (1));
var inst_33893 = (inst_33892__$1 < n);
var state_33923__$1 = (function (){var statearr_33953 = state_33923;
(statearr_33953[(11)] = inst_33892__$1);

(statearr_33953[(12)] = inst_33891);

return statearr_33953;
})();
if(cljs.core.truth_(inst_33893)){
var statearr_33955_35979 = state_33923__$1;
(statearr_33955_35979[(1)] = (8));

} else {
var statearr_33956_35980 = state_33923__$1;
(statearr_33956_35980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (14))){
var inst_33912 = (state_33923[(2)]);
var inst_33913 = cljs.core.async.close_BANG_(out);
var state_33923__$1 = (function (){var statearr_33959 = state_33923;
(statearr_33959[(13)] = inst_33912);

return statearr_33959;
})();
var statearr_33962_35983 = state_33923__$1;
(statearr_33962_35983[(2)] = inst_33913);

(statearr_33962_35983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (10))){
var inst_33903 = (state_33923[(2)]);
var state_33923__$1 = state_33923;
var statearr_33965_35994 = state_33923__$1;
(statearr_33965_35994[(2)] = inst_33903);

(statearr_33965_35994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33924 === (8))){
var inst_33883 = (state_33923[(7)]);
var inst_33892 = (state_33923[(11)]);
var tmp33957 = inst_33883;
var inst_33883__$1 = tmp33957;
var inst_33884 = inst_33892;
var state_33923__$1 = (function (){var statearr_33970 = state_33923;
(statearr_33970[(7)] = inst_33883__$1);

(statearr_33970[(8)] = inst_33884);

return statearr_33970;
})();
var statearr_33973_36036 = state_33923__$1;
(statearr_33973_36036[(2)] = null);

(statearr_33973_36036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_33975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33975[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_33975[(1)] = (1));

return statearr_33975;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_33923){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_33923);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e33978){var ex__30557__auto__ = e33978;
var statearr_33979_36059 = state_33923;
(statearr_33979_36059[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_33923[(4)]))){
var statearr_33984_36060 = state_33923;
(statearr_33984_36060[(1)] = cljs.core.first((state_33923[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36061 = state_33923;
state_33923 = G__36061;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_33923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_33923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_33985 = f__31117__auto__();
(statearr_33985[(6)] = c__31116__auto___35926);

return statearr_33985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33987 = arguments.length;
switch (G__33987) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31116__auto___36077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_34121){
var state_val_34122 = (state_34121[(1)]);
if((state_val_34122 === (7))){
var inst_34117 = (state_34121[(2)]);
var state_34121__$1 = state_34121;
var statearr_34129_36078 = state_34121__$1;
(statearr_34129_36078[(2)] = inst_34117);

(statearr_34129_36078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (1))){
var inst_34068 = [];
var inst_34069 = inst_34068;
var inst_34070 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34121__$1 = (function (){var statearr_34131 = state_34121;
(statearr_34131[(7)] = inst_34069);

(statearr_34131[(8)] = inst_34070);

return statearr_34131;
})();
var statearr_34132_36084 = state_34121__$1;
(statearr_34132_36084[(2)] = null);

(statearr_34132_36084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (4))){
var inst_34073 = (state_34121[(9)]);
var inst_34073__$1 = (state_34121[(2)]);
var inst_34075 = (inst_34073__$1 == null);
var inst_34076 = cljs.core.not(inst_34075);
var state_34121__$1 = (function (){var statearr_34133 = state_34121;
(statearr_34133[(9)] = inst_34073__$1);

return statearr_34133;
})();
if(inst_34076){
var statearr_34134_36085 = state_34121__$1;
(statearr_34134_36085[(1)] = (5));

} else {
var statearr_34135_36086 = state_34121__$1;
(statearr_34135_36086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (15))){
var inst_34069 = (state_34121[(7)]);
var inst_34109 = cljs.core.vec(inst_34069);
var state_34121__$1 = state_34121;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34121__$1,(18),out,inst_34109);
} else {
if((state_val_34122 === (13))){
var inst_34102 = (state_34121[(2)]);
var state_34121__$1 = state_34121;
var statearr_34139_36088 = state_34121__$1;
(statearr_34139_36088[(2)] = inst_34102);

(statearr_34139_36088[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (6))){
var inst_34069 = (state_34121[(7)]);
var inst_34104 = inst_34069.length;
var inst_34105 = (inst_34104 > (0));
var state_34121__$1 = state_34121;
if(cljs.core.truth_(inst_34105)){
var statearr_34140_36089 = state_34121__$1;
(statearr_34140_36089[(1)] = (15));

} else {
var statearr_34141_36090 = state_34121__$1;
(statearr_34141_36090[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (17))){
var inst_34114 = (state_34121[(2)]);
var inst_34115 = cljs.core.async.close_BANG_(out);
var state_34121__$1 = (function (){var statearr_34142 = state_34121;
(statearr_34142[(10)] = inst_34114);

return statearr_34142;
})();
var statearr_34143_36091 = state_34121__$1;
(statearr_34143_36091[(2)] = inst_34115);

(statearr_34143_36091[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (3))){
var inst_34119 = (state_34121[(2)]);
var state_34121__$1 = state_34121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34121__$1,inst_34119);
} else {
if((state_val_34122 === (12))){
var inst_34069 = (state_34121[(7)]);
var inst_34095 = cljs.core.vec(inst_34069);
var state_34121__$1 = state_34121;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34121__$1,(14),out,inst_34095);
} else {
if((state_val_34122 === (2))){
var state_34121__$1 = state_34121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34121__$1,(4),ch);
} else {
if((state_val_34122 === (11))){
var inst_34069 = (state_34121[(7)]);
var inst_34073 = (state_34121[(9)]);
var inst_34078 = (state_34121[(11)]);
var inst_34092 = inst_34069.push(inst_34073);
var tmp34144 = inst_34069;
var inst_34069__$1 = tmp34144;
var inst_34070 = inst_34078;
var state_34121__$1 = (function (){var statearr_34149 = state_34121;
(statearr_34149[(7)] = inst_34069__$1);

(statearr_34149[(12)] = inst_34092);

(statearr_34149[(8)] = inst_34070);

return statearr_34149;
})();
var statearr_34150_36092 = state_34121__$1;
(statearr_34150_36092[(2)] = null);

(statearr_34150_36092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (9))){
var inst_34070 = (state_34121[(8)]);
var inst_34086 = cljs.core.keyword_identical_QMARK_(inst_34070,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_34121__$1 = state_34121;
var statearr_34151_36093 = state_34121__$1;
(statearr_34151_36093[(2)] = inst_34086);

(statearr_34151_36093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (5))){
var inst_34083 = (state_34121[(13)]);
var inst_34070 = (state_34121[(8)]);
var inst_34073 = (state_34121[(9)]);
var inst_34078 = (state_34121[(11)]);
var inst_34078__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34073) : f.call(null,inst_34073));
var inst_34083__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34078__$1,inst_34070);
var state_34121__$1 = (function (){var statearr_34156 = state_34121;
(statearr_34156[(13)] = inst_34083__$1);

(statearr_34156[(11)] = inst_34078__$1);

return statearr_34156;
})();
if(inst_34083__$1){
var statearr_34164_36098 = state_34121__$1;
(statearr_34164_36098[(1)] = (8));

} else {
var statearr_34168_36099 = state_34121__$1;
(statearr_34168_36099[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (14))){
var inst_34073 = (state_34121[(9)]);
var inst_34078 = (state_34121[(11)]);
var inst_34097 = (state_34121[(2)]);
var inst_34098 = [];
var inst_34099 = inst_34098.push(inst_34073);
var inst_34069 = inst_34098;
var inst_34070 = inst_34078;
var state_34121__$1 = (function (){var statearr_34171 = state_34121;
(statearr_34171[(14)] = inst_34097);

(statearr_34171[(7)] = inst_34069);

(statearr_34171[(8)] = inst_34070);

(statearr_34171[(15)] = inst_34099);

return statearr_34171;
})();
var statearr_34173_36102 = state_34121__$1;
(statearr_34173_36102[(2)] = null);

(statearr_34173_36102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (16))){
var state_34121__$1 = state_34121;
var statearr_34177_36106 = state_34121__$1;
(statearr_34177_36106[(2)] = null);

(statearr_34177_36106[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (10))){
var inst_34088 = (state_34121[(2)]);
var state_34121__$1 = state_34121;
if(cljs.core.truth_(inst_34088)){
var statearr_34181_36107 = state_34121__$1;
(statearr_34181_36107[(1)] = (11));

} else {
var statearr_34182_36108 = state_34121__$1;
(statearr_34182_36108[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (18))){
var inst_34111 = (state_34121[(2)]);
var state_34121__$1 = state_34121;
var statearr_34186_36109 = state_34121__$1;
(statearr_34186_36109[(2)] = inst_34111);

(statearr_34186_36109[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34122 === (8))){
var inst_34083 = (state_34121[(13)]);
var state_34121__$1 = state_34121;
var statearr_34190_36110 = state_34121__$1;
(statearr_34190_36110[(2)] = inst_34083);

(statearr_34190_36110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30554__auto__ = null;
var cljs$core$async$state_machine__30554__auto____0 = (function (){
var statearr_34198 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34198[(0)] = cljs$core$async$state_machine__30554__auto__);

(statearr_34198[(1)] = (1));

return statearr_34198;
});
var cljs$core$async$state_machine__30554__auto____1 = (function (state_34121){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_34121);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e34203){var ex__30557__auto__ = e34203;
var statearr_34204_36112 = state_34121;
(statearr_34204_36112[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_34121[(4)]))){
var statearr_34205_36113 = state_34121;
(statearr_34205_36113[(1)] = cljs.core.first((state_34121[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36114 = state_34121;
state_34121 = G__36114;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
cljs$core$async$state_machine__30554__auto__ = function(state_34121){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30554__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30554__auto____1.call(this,state_34121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30554__auto____0;
cljs$core$async$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30554__auto____1;
return cljs$core$async$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_34210 = f__31117__auto__();
(statearr_34210[(6)] = c__31116__auto___36077);

return statearr_34210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
