goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41716 = schema.utils.use_fn_validation;
var output_schema41229_41717 = schema.core.Bool;
var input_schema41231_41718 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41232_41719 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41231_41718);
}),null));
var output_checker41233_41720 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41229_41717);
}),null));
var ret__40655__auto___41721 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41234){
var validate__38257__auto__ = cljs.core.deref(ufv___41716);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41722 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41234], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41238_41723 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41239_41724 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41240_41725 = input_schema41231_41718;
var G__41241_41726 = cljs.core.deref(input_checker41232_41719);
var G__41242_41727 = args__38258__auto___41722;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41238_41723,G__41239_41724,G__41240_41725,G__41241_41726,G__41242_41727) : schema.core.fn_validator.call(null,G__41238_41723,G__41239_41724,G__41240_41725,G__41241_41726,G__41242_41727));
} else {
var temp__5804__auto___41728 = (function (){var fexpr__41244 = cljs.core.deref(input_checker41232_41719);
return (fexpr__41244.cljs$core$IFn$_invoke$arity$1 ? fexpr__41244.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41722) : fexpr__41244.call(null,args__38258__auto___41722));
})();
if(cljs.core.truth_(temp__5804__auto___41728)){
var error__38259__auto___41729 = temp__5804__auto___41728;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41729], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41231_41718,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41722,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41729], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var arg = G__41234;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41245_41730 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41246_41731 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41247_41732 = output_schema41229_41717;
var G__41248_41733 = cljs.core.deref(output_checker41233_41720);
var G__41249_41734 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41245_41730,G__41246_41731,G__41247_41732,G__41248_41733,G__41249_41734) : schema.core.fn_validator.call(null,G__41245_41730,G__41246_41731,G__41247_41732,G__41248_41733,G__41249_41734));
} else {
var temp__5804__auto___41735 = (function (){var fexpr__41250 = cljs.core.deref(output_checker41233_41720);
return (fexpr__41250.cljs$core$IFn$_invoke$arity$1 ? fexpr__41250.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41250.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41735)){
var error__38259__auto___41736 = temp__5804__auto___41735;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41736], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41229_41717,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41736], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41229_41717,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41231_41718], null)));

var ufv___41738 = schema.utils.use_fn_validation;
var output_schema41252_41739 = deercreeklabs.baracus.ByteArray;
var input_schema41253_41740 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41257_41741 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41254_41742 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41253_41740);
}),null));
var output_checker41255_41743 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41252_41739);
}),null));
var input_checker41258_41744 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41257_41741);
}),null));
var output_checker41259_41745 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41252_41739);
}),null));
var ret__40655__auto___41746 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41264 = arguments.length;
switch (G__41264) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41256){
var validate__38257__auto__ = cljs.core.deref(ufv___41738);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41748 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41256], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41266_41749 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41267_41750 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41268_41751 = input_schema41253_41740;
var G__41269_41752 = cljs.core.deref(input_checker41254_41742);
var G__41270_41753 = args__38258__auto___41748;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41266_41749,G__41267_41750,G__41268_41751,G__41269_41752,G__41270_41753) : schema.core.fn_validator.call(null,G__41266_41749,G__41267_41750,G__41268_41751,G__41269_41752,G__41270_41753));
} else {
var temp__5804__auto___41755 = (function (){var fexpr__41271 = cljs.core.deref(input_checker41254_41742);
return (fexpr__41271.cljs$core$IFn$_invoke$arity$1 ? fexpr__41271.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41748) : fexpr__41271.call(null,args__38258__auto___41748));
})();
if(cljs.core.truth_(temp__5804__auto___41755)){
var error__38259__auto___41757 = temp__5804__auto___41755;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41757], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41253_41740,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41748,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41757], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var size_or_seq = G__41256;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41272_41759 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41273_41760 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41274_41761 = output_schema41252_41739;
var G__41275_41762 = cljs.core.deref(output_checker41255_41743);
var G__41276_41763 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41272_41759,G__41273_41760,G__41274_41761,G__41275_41762,G__41276_41763) : schema.core.fn_validator.call(null,G__41272_41759,G__41273_41760,G__41274_41761,G__41275_41762,G__41276_41763));
} else {
var temp__5804__auto___41764 = (function (){var fexpr__41277 = cljs.core.deref(output_checker41255_41743);
return (fexpr__41277.cljs$core$IFn$_invoke$arity$1 ? fexpr__41277.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41277.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41764)){
var error__38259__auto___41765 = temp__5804__auto___41764;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41765], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41252_41739,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41765], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41260,G__41261){
var validate__38257__auto__ = cljs.core.deref(ufv___41738);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41766 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41260,G__41261], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41279_41767 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41280_41768 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41281_41769 = input_schema41257_41741;
var G__41282_41770 = cljs.core.deref(input_checker41258_41744);
var G__41283_41771 = args__38258__auto___41766;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41279_41767,G__41280_41768,G__41281_41769,G__41282_41770,G__41283_41771) : schema.core.fn_validator.call(null,G__41279_41767,G__41280_41768,G__41281_41769,G__41282_41770,G__41283_41771));
} else {
var temp__5804__auto___41772 = (function (){var fexpr__41284 = cljs.core.deref(input_checker41258_41744);
return (fexpr__41284.cljs$core$IFn$_invoke$arity$1 ? fexpr__41284.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41766) : fexpr__41284.call(null,args__38258__auto___41766));
})();
if(cljs.core.truth_(temp__5804__auto___41772)){
var error__38259__auto___41773 = temp__5804__auto___41772;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41773], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41257_41741,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41766,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41773], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var size = G__41260;
var init_val_or_seq = G__41261;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41285_41775 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41286_41776 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41287_41777 = output_schema41252_41739;
var G__41288_41778 = cljs.core.deref(output_checker41259_41745);
var G__41289_41779 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41285_41775,G__41286_41776,G__41287_41777,G__41288_41778,G__41289_41779) : schema.core.fn_validator.call(null,G__41285_41775,G__41286_41776,G__41287_41777,G__41288_41778,G__41289_41779));
} else {
var temp__5804__auto___41780 = (function (){var fexpr__41290 = cljs.core.deref(output_checker41259_41745);
return (fexpr__41290.cljs$core$IFn$_invoke$arity$1 ? fexpr__41290.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41290.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41780)){
var error__38259__auto___41781 = temp__5804__auto___41780;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41781], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41252_41739,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41781], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41252_41739,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41253_41740,input_schema41257_41741], null)));

var ufv___41782 = schema.utils.use_fn_validation;
var output_schema41292_41783 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41293_41784 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41294_41785 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41293_41784);
}),null));
var output_checker41295_41786 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41292_41783);
}),null));
var ret__40655__auto___41788 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41296){
var validate__38257__auto__ = cljs.core.deref(ufv___41782);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41789 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41296], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41297_41790 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41298_41791 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41299_41792 = input_schema41293_41784;
var G__41300_41793 = cljs.core.deref(input_checker41294_41785);
var G__41301_41794 = args__38258__auto___41789;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41297_41790,G__41298_41791,G__41299_41792,G__41300_41793,G__41301_41794) : schema.core.fn_validator.call(null,G__41297_41790,G__41298_41791,G__41299_41792,G__41300_41793,G__41301_41794));
} else {
var temp__5804__auto___41795 = (function (){var fexpr__41302 = cljs.core.deref(input_checker41294_41785);
return (fexpr__41302.cljs$core$IFn$_invoke$arity$1 ? fexpr__41302.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41789) : fexpr__41302.call(null,args__38258__auto___41789));
})();
if(cljs.core.truth_(temp__5804__auto___41795)){
var error__38259__auto___41796 = temp__5804__auto___41795;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41796], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41293_41784,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41789,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41796], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var arrays = G__41296;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41305 = cljs.core.count(arrays__$1);
switch (G__41305) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41305,arrays__$1,validate__38257__auto__,ufv___41782,output_schema41292_41783,input_schema41293_41784,input_checker41294_41785,output_checker41295_41786){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41305,arrays__$1,validate__38257__auto__,ufv___41782,output_schema41292_41783,input_schema41293_41784,input_checker41294_41785,output_checker41295_41786))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41305,arrays__$1,validate__38257__auto__,ufv___41782,output_schema41292_41783,input_schema41293_41784,input_checker41294_41785,output_checker41295_41786){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41305,arrays__$1,validate__38257__auto__,ufv___41782,output_schema41292_41783,input_schema41293_41784,input_checker41294_41785,output_checker41295_41786))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41306_41798 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41307_41799 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41308_41800 = output_schema41292_41783;
var G__41309_41801 = cljs.core.deref(output_checker41295_41786);
var G__41310_41802 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41306_41798,G__41307_41799,G__41308_41800,G__41309_41801,G__41310_41802) : schema.core.fn_validator.call(null,G__41306_41798,G__41307_41799,G__41308_41800,G__41309_41801,G__41310_41802));
} else {
var temp__5804__auto___41803 = (function (){var fexpr__41311 = cljs.core.deref(output_checker41295_41786);
return (fexpr__41311.cljs$core$IFn$_invoke$arity$1 ? fexpr__41311.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41311.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41803)){
var error__38259__auto___41805 = temp__5804__auto___41803;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41805], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41292_41783,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41805], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41292_41783,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41293_41784], null)));

var ufv___41806 = schema.utils.use_fn_validation;
var output_schema41313_41807 = schema.core.Bool;
var input_schema41314_41808 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41315_41809 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41314_41808);
}),null));
var output_checker41316_41810 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41313_41807);
}),null));
var ret__40655__auto___41811 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41317,G__41318){
var validate__38257__auto__ = cljs.core.deref(ufv___41806);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41812 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41317,G__41318], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41322_41813 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41323_41814 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41324_41815 = input_schema41314_41808;
var G__41325_41816 = cljs.core.deref(input_checker41315_41809);
var G__41326_41817 = args__38258__auto___41812;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41322_41813,G__41323_41814,G__41324_41815,G__41325_41816,G__41326_41817) : schema.core.fn_validator.call(null,G__41322_41813,G__41323_41814,G__41324_41815,G__41325_41816,G__41326_41817));
} else {
var temp__5804__auto___41818 = (function (){var fexpr__41327 = cljs.core.deref(input_checker41315_41809);
return (fexpr__41327.cljs$core$IFn$_invoke$arity$1 ? fexpr__41327.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41812) : fexpr__41327.call(null,args__38258__auto___41812));
})();
if(cljs.core.truth_(temp__5804__auto___41818)){
var error__38259__auto___41819 = temp__5804__auto___41818;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41819], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41314_41808,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41812,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41819], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var a = G__41317;
var b = G__41318;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41821 = ((i + (1)) | (0));
i = G__41821;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41329_41822 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41330_41823 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41331_41824 = output_schema41313_41807;
var G__41332_41825 = cljs.core.deref(output_checker41316_41810);
var G__41333_41826 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41329_41822,G__41330_41823,G__41331_41824,G__41332_41825,G__41333_41826) : schema.core.fn_validator.call(null,G__41329_41822,G__41330_41823,G__41331_41824,G__41332_41825,G__41333_41826));
} else {
var temp__5804__auto___41827 = (function (){var fexpr__41334 = cljs.core.deref(output_checker41316_41810);
return (fexpr__41334.cljs$core$IFn$_invoke$arity$1 ? fexpr__41334.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41334.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41827)){
var error__38259__auto___41828 = temp__5804__auto___41827;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41828], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41313_41807,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41828], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41313_41807,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41314_41808], null)));

var ufv___41829 = schema.utils.use_fn_validation;
var output_schema41335_41830 = schema.core.Str;
var input_schema41336_41831 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41337_41832 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41336_41831);
}),null));
var output_checker41338_41833 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41335_41830);
}),null));
var ret__40655__auto___41834 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41339){
var validate__38257__auto__ = cljs.core.deref(ufv___41829);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41835 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41339], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41341_41836 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41342_41837 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41343_41838 = input_schema41336_41831;
var G__41344_41839 = cljs.core.deref(input_checker41337_41832);
var G__41345_41840 = args__38258__auto___41835;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41341_41836,G__41342_41837,G__41343_41838,G__41344_41839,G__41345_41840) : schema.core.fn_validator.call(null,G__41341_41836,G__41342_41837,G__41343_41838,G__41344_41839,G__41345_41840));
} else {
var temp__5804__auto___41841 = (function (){var fexpr__41346 = cljs.core.deref(input_checker41337_41832);
return (fexpr__41346.cljs$core$IFn$_invoke$arity$1 ? fexpr__41346.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41835) : fexpr__41346.call(null,args__38258__auto___41835));
})();
if(cljs.core.truth_(temp__5804__auto___41841)){
var error__38259__auto___41842 = temp__5804__auto___41841;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41842], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41336_41831,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41835,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41842], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41339;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41347_41844 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41348_41845 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41349_41846 = output_schema41335_41830;
var G__41350_41847 = cljs.core.deref(output_checker41338_41833);
var G__41351_41848 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41347_41844,G__41348_41845,G__41349_41846,G__41350_41847,G__41351_41848) : schema.core.fn_validator.call(null,G__41347_41844,G__41348_41845,G__41349_41846,G__41350_41847,G__41351_41848));
} else {
var temp__5804__auto___41849 = (function (){var fexpr__41352 = cljs.core.deref(output_checker41338_41833);
return (fexpr__41352.cljs$core$IFn$_invoke$arity$1 ? fexpr__41352.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41352.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41849)){
var error__38259__auto___41850 = temp__5804__auto___41849;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41850], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41335_41830,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41850], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41335_41830,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41336_41831], null)));

var ufv___41851 = schema.utils.use_fn_validation;
var output_schema41354_41852 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41355_41853 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41360_41854 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41365_41855 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41356_41856 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41355_41853);
}),null));
var output_checker41357_41857 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41354_41852);
}),null));
var input_checker41361_41858 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41360_41854);
}),null));
var output_checker41362_41859 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41354_41852);
}),null));
var input_checker41366_41860 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41365_41855);
}),null));
var output_checker41367_41861 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41354_41852);
}),null));
var ret__40655__auto___41862 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41373 = arguments.length;
switch (G__41373) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41358){
var validate__38257__auto__ = cljs.core.deref(ufv___41851);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41864 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41358], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41374_41865 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41375_41866 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41376_41867 = input_schema41355_41853;
var G__41377_41868 = cljs.core.deref(input_checker41356_41856);
var G__41378_41869 = args__38258__auto___41864;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41374_41865,G__41375_41866,G__41376_41867,G__41377_41868,G__41378_41869) : schema.core.fn_validator.call(null,G__41374_41865,G__41375_41866,G__41376_41867,G__41377_41868,G__41378_41869));
} else {
var temp__5804__auto___41870 = (function (){var fexpr__41379 = cljs.core.deref(input_checker41356_41856);
return (fexpr__41379.cljs$core$IFn$_invoke$arity$1 ? fexpr__41379.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41864) : fexpr__41379.call(null,args__38258__auto___41864));
})();
if(cljs.core.truth_(temp__5804__auto___41870)){
var error__38259__auto___41871 = temp__5804__auto___41870;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41871], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41355_41853,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41864,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41871], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41358;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41380_41873 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41381_41874 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41382_41875 = output_schema41354_41852;
var G__41383_41876 = cljs.core.deref(output_checker41357_41857);
var G__41384_41877 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41380_41873,G__41381_41874,G__41382_41875,G__41383_41876,G__41384_41877) : schema.core.fn_validator.call(null,G__41380_41873,G__41381_41874,G__41382_41875,G__41383_41876,G__41384_41877));
} else {
var temp__5804__auto___41878 = (function (){var fexpr__41385 = cljs.core.deref(output_checker41357_41857);
return (fexpr__41385.cljs$core$IFn$_invoke$arity$1 ? fexpr__41385.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41385.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41878)){
var error__38259__auto___41879 = temp__5804__auto___41878;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41879], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41354_41852,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41879], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41363,G__41364){
var validate__38257__auto__ = cljs.core.deref(ufv___41851);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41880 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41363,G__41364], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41386_41881 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41387_41882 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41388_41883 = input_schema41360_41854;
var G__41389_41884 = cljs.core.deref(input_checker41361_41858);
var G__41390_41885 = args__38258__auto___41880;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41386_41881,G__41387_41882,G__41388_41883,G__41389_41884,G__41390_41885) : schema.core.fn_validator.call(null,G__41386_41881,G__41387_41882,G__41388_41883,G__41389_41884,G__41390_41885));
} else {
var temp__5804__auto___41886 = (function (){var fexpr__41391 = cljs.core.deref(input_checker41361_41858);
return (fexpr__41391.cljs$core$IFn$_invoke$arity$1 ? fexpr__41391.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41880) : fexpr__41391.call(null,args__38258__auto___41880));
})();
if(cljs.core.truth_(temp__5804__auto___41886)){
var error__38259__auto___41887 = temp__5804__auto___41886;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41887], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41360_41854,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41880,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41887], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41363;
var start = G__41364;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41392_41888 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41393_41889 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41394_41890 = output_schema41354_41852;
var G__41395_41891 = cljs.core.deref(output_checker41362_41859);
var G__41396_41892 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41392_41888,G__41393_41889,G__41394_41890,G__41395_41891,G__41396_41892) : schema.core.fn_validator.call(null,G__41392_41888,G__41393_41889,G__41394_41890,G__41395_41891,G__41396_41892));
} else {
var temp__5804__auto___41893 = (function (){var fexpr__41397 = cljs.core.deref(output_checker41362_41859);
return (fexpr__41397.cljs$core$IFn$_invoke$arity$1 ? fexpr__41397.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41397.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41893)){
var error__38259__auto___41894 = temp__5804__auto___41893;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41894], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41354_41852,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41894], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41368,G__41369,G__41370){
var validate__38257__auto__ = cljs.core.deref(ufv___41851);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41896 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41368,G__41369,G__41370], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41399_41897 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41400_41898 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41401_41899 = input_schema41365_41855;
var G__41402_41900 = cljs.core.deref(input_checker41366_41860);
var G__41403_41901 = args__38258__auto___41896;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41399_41897,G__41400_41898,G__41401_41899,G__41402_41900,G__41403_41901) : schema.core.fn_validator.call(null,G__41399_41897,G__41400_41898,G__41401_41899,G__41402_41900,G__41403_41901));
} else {
var temp__5804__auto___41903 = (function (){var fexpr__41404 = cljs.core.deref(input_checker41366_41860);
return (fexpr__41404.cljs$core$IFn$_invoke$arity$1 ? fexpr__41404.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41896) : fexpr__41404.call(null,args__38258__auto___41896));
})();
if(cljs.core.truth_(temp__5804__auto___41903)){
var error__38259__auto___41904 = temp__5804__auto___41903;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41904], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41365_41855,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41896,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41904], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41368;
var start = G__41369;
var end = G__41370;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41405_41908 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41406_41909 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41407_41910 = output_schema41354_41852;
var G__41408_41911 = cljs.core.deref(output_checker41367_41861);
var G__41409_41912 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41405_41908,G__41406_41909,G__41407_41910,G__41408_41911,G__41409_41912) : schema.core.fn_validator.call(null,G__41405_41908,G__41406_41909,G__41407_41910,G__41408_41911,G__41409_41912));
} else {
var temp__5804__auto___41913 = (function (){var fexpr__41410 = cljs.core.deref(output_checker41367_41861);
return (fexpr__41410.cljs$core$IFn$_invoke$arity$1 ? fexpr__41410.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41410.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41913)){
var error__38259__auto___41914 = temp__5804__auto___41913;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41914], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41354_41852,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41914], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41354_41852,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41355_41853,input_schema41360_41854,input_schema41365_41855], null)));

var ufv___41919 = schema.utils.use_fn_validation;
var output_schema41412_41920 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41413_41921 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41414_41922 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41413_41921);
}),null));
var output_checker41415_41923 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41412_41920);
}),null));
var ret__40655__auto___41925 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41416){
var validate__38257__auto__ = cljs.core.deref(ufv___41919);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41926 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41416], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41417_41927 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41418_41928 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41419_41929 = input_schema41413_41921;
var G__41420_41930 = cljs.core.deref(input_checker41414_41922);
var G__41421_41931 = args__38258__auto___41926;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41417_41927,G__41418_41928,G__41419_41929,G__41420_41930,G__41421_41931) : schema.core.fn_validator.call(null,G__41417_41927,G__41418_41928,G__41419_41929,G__41420_41930,G__41421_41931));
} else {
var temp__5804__auto___41933 = (function (){var fexpr__41423 = cljs.core.deref(input_checker41414_41922);
return (fexpr__41423.cljs$core$IFn$_invoke$arity$1 ? fexpr__41423.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41926) : fexpr__41423.call(null,args__38258__auto___41926));
})();
if(cljs.core.truth_(temp__5804__auto___41933)){
var error__38259__auto___41934 = temp__5804__auto___41933;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41934], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41413_41921,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41926,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41934], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41416;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5636__auto___41935 = num;
var i_41936 = (0);
while(true){
if((i_41936 < n__5636__auto___41935)){
(new$[i_41936] = (ba[(last - i_41936)]));

var G__41937 = (i_41936 + (1));
i_41936 = G__41937;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41424_41940 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41425_41941 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41426_41942 = output_schema41412_41920;
var G__41427_41943 = cljs.core.deref(output_checker41415_41923);
var G__41428_41944 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41424_41940,G__41425_41941,G__41426_41942,G__41427_41943,G__41428_41944) : schema.core.fn_validator.call(null,G__41424_41940,G__41425_41941,G__41426_41942,G__41427_41943,G__41428_41944));
} else {
var temp__5804__auto___41946 = (function (){var fexpr__41429 = cljs.core.deref(output_checker41415_41923);
return (fexpr__41429.cljs$core$IFn$_invoke$arity$1 ? fexpr__41429.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41429.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41946)){
var error__38259__auto___41949 = temp__5804__auto___41946;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41949], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41412_41920,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41949], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41412_41920,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41413_41921], null)));

var ufv___41951 = schema.utils.use_fn_validation;
var output_schema41431_41952 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41432_41953 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41433_41954 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41432_41953);
}),null));
var output_checker41434_41955 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41431_41952);
}),null));
var ret__40655__auto___41957 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41435,G__41436){
var validate__38257__auto__ = cljs.core.deref(ufv___41951);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41959 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41435,G__41436], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41439_41960 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41440_41961 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41441_41962 = input_schema41432_41953;
var G__41442_41963 = cljs.core.deref(input_checker41433_41954);
var G__41443_41964 = args__38258__auto___41959;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41439_41960,G__41440_41961,G__41441_41962,G__41442_41963,G__41443_41964) : schema.core.fn_validator.call(null,G__41439_41960,G__41440_41961,G__41441_41962,G__41442_41963,G__41443_41964));
} else {
var temp__5804__auto___41968 = (function (){var fexpr__41444 = cljs.core.deref(input_checker41433_41954);
return (fexpr__41444.cljs$core$IFn$_invoke$arity$1 ? fexpr__41444.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41959) : fexpr__41444.call(null,args__38258__auto___41959));
})();
if(cljs.core.truth_(temp__5804__auto___41968)){
var error__38259__auto___41969 = temp__5804__auto___41968;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41969], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41432_41953,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41959,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41969], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41435;
var fragment_size = G__41436;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__41971 = (end_offset | (0));
var G__41972 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__41971;
output = G__41972;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41446_41973 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41447_41974 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41448_41975 = output_schema41431_41952;
var G__41449_41976 = cljs.core.deref(output_checker41434_41955);
var G__41450_41977 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41446_41973,G__41447_41974,G__41448_41975,G__41449_41976,G__41450_41977) : schema.core.fn_validator.call(null,G__41446_41973,G__41447_41974,G__41448_41975,G__41449_41976,G__41450_41977));
} else {
var temp__5804__auto___41978 = (function (){var fexpr__41454 = cljs.core.deref(output_checker41434_41955);
return (fexpr__41454.cljs$core$IFn$_invoke$arity$1 ? fexpr__41454.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41454.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41978)){
var error__38259__auto___41979 = temp__5804__auto___41978;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41979], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41431_41952,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41979], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41431_41952,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41432_41953], null)));

var ufv___41984 = schema.utils.use_fn_validation;
var output_schema41456_41985 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41457_41986 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41458_41987 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41457_41986);
}),null));
var output_checker41459_41988 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41456_41985);
}),null));
var ret__40655__auto___41990 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an variable-length zig-zag encoded byte array and reads an integer
 * from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41460){
var validate__38257__auto__ = cljs.core.deref(ufv___41984);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___41991 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41460], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41461_41992 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41462_41993 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41463_41994 = input_schema41457_41986;
var G__41464_41995 = cljs.core.deref(input_checker41458_41987);
var G__41465_41996 = args__38258__auto___41991;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41461_41992,G__41462_41993,G__41463_41994,G__41464_41995,G__41465_41996) : schema.core.fn_validator.call(null,G__41461_41992,G__41462_41993,G__41463_41994,G__41464_41995,G__41465_41996));
} else {
var temp__5804__auto___41998 = (function (){var fexpr__41467 = cljs.core.deref(input_checker41458_41987);
return (fexpr__41467.cljs$core$IFn$_invoke$arity$1 ? fexpr__41467.cljs$core$IFn$_invoke$arity$1(args__38258__auto___41991) : fexpr__41467.call(null,args__38258__auto___41991));
})();
if(cljs.core.truth_(temp__5804__auto___41998)){
var error__38259__auto___41999 = temp__5804__auto___41998;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___41999], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41457_41986,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___41991,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___41999], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41460;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__42006 = (n + (1));
var G__42007 = (i__$1 | (0));
var G__42008 = (out__$1 | (0));
n = G__42006;
i = G__42007;
out = G__42008;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41468_42010 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41469_42011 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41470_42012 = output_schema41456_41985;
var G__41471_42013 = cljs.core.deref(output_checker41459_41988);
var G__41472_42014 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41468_42010,G__41469_42011,G__41470_42012,G__41471_42013,G__41472_42014) : schema.core.fn_validator.call(null,G__41468_42010,G__41469_42011,G__41470_42012,G__41471_42013,G__41472_42014));
} else {
var temp__5804__auto___42015 = (function (){var fexpr__41474 = cljs.core.deref(output_checker41459_41988);
return (fexpr__41474.cljs$core$IFn$_invoke$arity$1 ? fexpr__41474.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41474.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42015)){
var error__38259__auto___42016 = temp__5804__auto___42015;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42016], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41456_41985,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42016], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41456_41985,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41457_41986], null)));

var ufv___42018 = schema.utils.use_fn_validation;
var output_schema41475_42019 = deercreeklabs.baracus.ByteArray;
var input_schema41476_42020 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41477_42021 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41476_42020);
}),null));
var output_checker41478_42022 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41475_42019);
}),null));
var ret__40655__auto___42023 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Encodes an integer using variable length zig-zag coding.
 * Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41479){
var validate__38257__auto__ = cljs.core.deref(ufv___42018);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42026 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41479], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41483_42027 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41484_42028 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41485_42029 = input_schema41476_42020;
var G__41486_42030 = cljs.core.deref(input_checker41477_42021);
var G__41487_42031 = args__38258__auto___42026;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41483_42027,G__41484_42028,G__41485_42029,G__41486_42030,G__41487_42031) : schema.core.fn_validator.call(null,G__41483_42027,G__41484_42028,G__41485_42029,G__41486_42030,G__41487_42031));
} else {
var temp__5804__auto___42032 = (function (){var fexpr__41488 = cljs.core.deref(input_checker41477_42021);
return (fexpr__41488.cljs$core$IFn$_invoke$arity$1 ? fexpr__41488.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42026) : fexpr__41488.call(null,args__38258__auto___42026));
})();
if(cljs.core.truth_(temp__5804__auto___42032)){
var error__38259__auto___42033 = temp__5804__auto___42032;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42033], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41476_42020,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42026,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42033], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var i = G__41479;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__42038 = (n >>> (7));
var G__42039 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__42038;
out = G__42039;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41490_42040 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41491_42041 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41492_42042 = output_schema41475_42019;
var G__41493_42043 = cljs.core.deref(output_checker41478_42022);
var G__41494_42044 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41490_42040,G__41491_42041,G__41492_42042,G__41493_42043,G__41494_42044) : schema.core.fn_validator.call(null,G__41490_42040,G__41491_42041,G__41492_42042,G__41493_42043,G__41494_42044));
} else {
var temp__5804__auto___42046 = (function (){var fexpr__41496 = cljs.core.deref(output_checker41478_42022);
return (fexpr__41496.cljs$core$IFn$_invoke$arity$1 ? fexpr__41496.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41496.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42046)){
var error__38259__auto___42047 = temp__5804__auto___42046;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42047], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41475_42019,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42047], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41475_42019,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41476_42020], null)));

var ufv___42049 = schema.utils.use_fn_validation;
var output_schema41497_42050 = schema.core.maybe(schema.core.Str);
var input_schema41498_42051 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41499_42052 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41498_42051);
}),null));
var output_checker41500_42053 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41497_42050);
}),null));
var ret__40655__auto___42055 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41501){
var validate__38257__auto__ = cljs.core.deref(ufv___42049);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42056 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41501], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41503_42057 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41504_42058 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41505_42059 = input_schema41498_42051;
var G__41506_42060 = cljs.core.deref(input_checker41499_42052);
var G__41507_42061 = args__38258__auto___42056;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41503_42057,G__41504_42058,G__41505_42059,G__41506_42060,G__41507_42061) : schema.core.fn_validator.call(null,G__41503_42057,G__41504_42058,G__41505_42059,G__41506_42060,G__41507_42061));
} else {
var temp__5804__auto___42064 = (function (){var fexpr__41508 = cljs.core.deref(input_checker41499_42052);
return (fexpr__41508.cljs$core$IFn$_invoke$arity$1 ? fexpr__41508.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42056) : fexpr__41508.call(null,args__38258__auto___42056));
})();
if(cljs.core.truth_(temp__5804__auto___42064)){
var error__38259__auto___42067 = temp__5804__auto___42064;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42067], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41498_42051,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42056,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42067], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var b = G__41501;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41510_42069 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41511_42070 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41512_42071 = output_schema41497_42050;
var G__41513_42072 = cljs.core.deref(output_checker41500_42053);
var G__41514_42073 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41510_42069,G__41511_42070,G__41512_42071,G__41513_42072,G__41514_42073) : schema.core.fn_validator.call(null,G__41510_42069,G__41511_42070,G__41512_42071,G__41513_42072,G__41514_42073));
} else {
var temp__5804__auto___42075 = (function (){var fexpr__41515 = cljs.core.deref(output_checker41500_42053);
return (fexpr__41515.cljs$core$IFn$_invoke$arity$1 ? fexpr__41515.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41515.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42075)){
var error__38259__auto___42076 = temp__5804__auto___42075;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42076], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41497_42050,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42076], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41497_42050,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41498_42051], null)));

var ufv___42078 = schema.utils.use_fn_validation;
var output_schema41516_42079 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41517_42080 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41518_42081 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41517_42080);
}),null));
var output_checker41519_42082 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41516_42079);
}),null));
var ret__40655__auto___42083 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41520){
var validate__38257__auto__ = cljs.core.deref(ufv___42078);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42086 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41520], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41522_42087 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41523_42088 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41524_42089 = input_schema41517_42080;
var G__41525_42090 = cljs.core.deref(input_checker41518_42081);
var G__41526_42091 = args__38258__auto___42086;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41522_42087,G__41523_42088,G__41524_42089,G__41525_42090,G__41526_42091) : schema.core.fn_validator.call(null,G__41522_42087,G__41523_42088,G__41524_42089,G__41525_42090,G__41526_42091));
} else {
var temp__5804__auto___42094 = (function (){var fexpr__41527 = cljs.core.deref(input_checker41518_42081);
return (fexpr__41527.cljs$core$IFn$_invoke$arity$1 ? fexpr__41527.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42086) : fexpr__41527.call(null,args__38258__auto___42086));
})();
if(cljs.core.truth_(temp__5804__auto___42094)){
var error__38259__auto___42095 = temp__5804__auto___42094;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42095], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41517_42080,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42086,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42095], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var s = G__41520;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41529_42097 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41530_42098 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41531_42099 = output_schema41516_42079;
var G__41532_42100 = cljs.core.deref(output_checker41519_42082);
var G__41533_42101 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41529_42097,G__41530_42098,G__41531_42099,G__41532_42100,G__41533_42101) : schema.core.fn_validator.call(null,G__41529_42097,G__41530_42098,G__41531_42099,G__41532_42100,G__41533_42101));
} else {
var temp__5804__auto___42103 = (function (){var fexpr__41534 = cljs.core.deref(output_checker41519_42082);
return (fexpr__41534.cljs$core$IFn$_invoke$arity$1 ? fexpr__41534.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41534.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42103)){
var error__38259__auto___42104 = temp__5804__auto___42103;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42104], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41516_42079,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42104], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41516_42079,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41517_42080], null)));

var ufv___42106 = schema.utils.use_fn_validation;
var output_schema41535_42107 = schema.core.maybe(schema.core.Str);
var input_schema41536_42108 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41537_42109 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41536_42108);
}),null));
var output_checker41538_42110 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41535_42107);
}),null));
var ret__40655__auto___42115 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41539){
var validate__38257__auto__ = cljs.core.deref(ufv___42106);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42116 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41539], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41544_42117 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41545_42118 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41546_42119 = input_schema41536_42108;
var G__41547_42120 = cljs.core.deref(input_checker41537_42109);
var G__41548_42121 = args__38258__auto___42116;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41544_42117,G__41545_42118,G__41546_42119,G__41547_42120,G__41548_42121) : schema.core.fn_validator.call(null,G__41544_42117,G__41545_42118,G__41546_42119,G__41547_42120,G__41548_42121));
} else {
var temp__5804__auto___42123 = (function (){var fexpr__41549 = cljs.core.deref(input_checker41537_42109);
return (fexpr__41549.cljs$core$IFn$_invoke$arity$1 ? fexpr__41549.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42116) : fexpr__41549.call(null,args__38258__auto___42116));
})();
if(cljs.core.truth_(temp__5804__auto___42123)){
var error__38259__auto___42124 = temp__5804__auto___42123;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42124], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41536_42108,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42116,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42124], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41539;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41550_42126 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41551_42127 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41552_42128 = output_schema41535_42107;
var G__41553_42129 = cljs.core.deref(output_checker41538_42110);
var G__41554_42130 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41550_42126,G__41551_42127,G__41552_42128,G__41553_42129,G__41554_42130) : schema.core.fn_validator.call(null,G__41550_42126,G__41551_42127,G__41552_42128,G__41553_42129,G__41554_42130));
} else {
var temp__5804__auto___42131 = (function (){var fexpr__41555 = cljs.core.deref(output_checker41538_42110);
return (fexpr__41555.cljs$core$IFn$_invoke$arity$1 ? fexpr__41555.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41555.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42131)){
var error__38259__auto___42133 = temp__5804__auto___42131;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42133], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41535_42107,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42133], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41535_42107,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41536_42108], null)));

var ufv___42134 = schema.utils.use_fn_validation;
var output_schema41556_42135 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41557_42136 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41558_42137 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41557_42136);
}),null));
var output_checker41559_42138 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41556_42135);
}),null));
var ret__40655__auto___42141 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41560){
var validate__38257__auto__ = cljs.core.deref(ufv___42134);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42143 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41560], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41562_42145 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41563_42146 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41564_42147 = input_schema41557_42136;
var G__41565_42148 = cljs.core.deref(input_checker41558_42137);
var G__41566_42149 = args__38258__auto___42143;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41562_42145,G__41563_42146,G__41564_42147,G__41565_42148,G__41566_42149) : schema.core.fn_validator.call(null,G__41562_42145,G__41563_42146,G__41564_42147,G__41565_42148,G__41566_42149));
} else {
var temp__5804__auto___42150 = (function (){var fexpr__41567 = cljs.core.deref(input_checker41558_42137);
return (fexpr__41567.cljs$core$IFn$_invoke$arity$1 ? fexpr__41567.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42143) : fexpr__41567.call(null,args__38258__auto___42143));
})();
if(cljs.core.truth_(temp__5804__auto___42150)){
var error__38259__auto___42151 = temp__5804__auto___42150;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42151], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41557_42136,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42143,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42151], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var s = G__41560;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41568_42153 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41569_42154 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41570_42155 = output_schema41556_42135;
var G__41571_42156 = cljs.core.deref(output_checker41559_42138);
var G__41572_42157 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41568_42153,G__41569_42154,G__41570_42155,G__41571_42156,G__41572_42157) : schema.core.fn_validator.call(null,G__41568_42153,G__41569_42154,G__41570_42155,G__41571_42156,G__41572_42157));
} else {
var temp__5804__auto___42159 = (function (){var fexpr__41573 = cljs.core.deref(output_checker41559_42138);
return (fexpr__41573.cljs$core$IFn$_invoke$arity$1 ? fexpr__41573.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41573.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42159)){
var error__38259__auto___42160 = temp__5804__auto___42159;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42160], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41556_42135,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42160], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41556_42135,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41557_42136], null)));

deercreeklabs.baracus.byte_array__GT_hex_str_STAR_ = (function deercreeklabs$baracus$byte_array__GT_hex_str_STAR_(p__41575){
var map__41576 = p__41575;
var map__41576__$1 = cljs.core.__destructure_map(map__41576);
var alphabet = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41576__$1,new cljs.core.Keyword(null,"alphabet","alphabet",788478088));
var ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41576__$1,new cljs.core.Keyword(null,"ba","ba",-960950298));
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var ca = (new Array(((2) * len)));
var n__5636__auto___42161 = len;
var i_42162 = (0);
while(true){
if((i_42162 < n__5636__auto___42161)){
var b_42163 = ((ba[i_42162]) & (255));
var j_42164 = ((2) * i_42162);
(ca[j_42164] = (function (){var G__41578 = (b_42163 >> (4));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41578) : alphabet.call(null,G__41578));
})());

(ca[(j_42164 + (1))] = (function (){var G__41579 = (b_42163 & (15));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41579) : alphabet.call(null,G__41579));
})());

var G__42165 = (i_42162 + (1));
i_42162 = G__42165;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
});
var ufv___42166 = schema.utils.use_fn_validation;
var output_schema41580_42167 = schema.core.maybe(schema.core.Str);
var input_schema41581_42168 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41582_42169 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41581_42168);
}),null));
var output_checker41583_42170 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41580_42167);
}),null));
var ret__40655__auto___42172 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41584){
var validate__38257__auto__ = cljs.core.deref(ufv___42166);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42173 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41584], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41585_42174 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41586_42175 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41587_42176 = input_schema41581_42168;
var G__41588_42177 = cljs.core.deref(input_checker41582_42169);
var G__41589_42178 = args__38258__auto___42173;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41585_42174,G__41586_42175,G__41587_42176,G__41588_42177,G__41589_42178) : schema.core.fn_validator.call(null,G__41585_42174,G__41586_42175,G__41587_42176,G__41588_42177,G__41589_42178));
} else {
var temp__5804__auto___42179 = (function (){var fexpr__41590 = cljs.core.deref(input_checker41582_42169);
return (fexpr__41590.cljs$core$IFn$_invoke$arity$1 ? fexpr__41590.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42173) : fexpr__41590.call(null,args__38258__auto___42173));
})();
if(cljs.core.truth_(temp__5804__auto___42179)){
var error__38259__auto___42180 = temp__5804__auto___42179;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42180], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41581_42168,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42173,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42180], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41584;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41591_42181 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41592_42182 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41593_42183 = output_schema41580_42167;
var G__41594_42184 = cljs.core.deref(output_checker41583_42170);
var G__41595_42185 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41591_42181,G__41592_42182,G__41593_42183,G__41594_42184,G__41595_42185) : schema.core.fn_validator.call(null,G__41591_42181,G__41592_42182,G__41593_42183,G__41594_42184,G__41595_42185));
} else {
var temp__5804__auto___42186 = (function (){var fexpr__41597 = cljs.core.deref(output_checker41583_42170);
return (fexpr__41597.cljs$core$IFn$_invoke$arity$1 ? fexpr__41597.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41597.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42186)){
var error__38259__auto___42187 = temp__5804__auto___42186;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42187], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41580_42167,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42187], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41580_42167,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41581_42168], null)));

var ufv___42190 = schema.utils.use_fn_validation;
var output_schema41598_42191 = schema.core.maybe(schema.core.Str);
var input_schema41599_42192 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41600_42193 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41599_42192);
}),null));
var output_checker41601_42194 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41598_42191);
}),null));
var ret__40655__auto___42195 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_upper_hex_str = (function deercreeklabs$baracus$byte_array__GT_upper_hex_str(G__41602){
var validate__38257__auto__ = cljs.core.deref(ufv___42190);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42198 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41602], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41606_42199 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41607_42200 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41608_42201 = input_schema41599_42192;
var G__41609_42202 = cljs.core.deref(input_checker41600_42193);
var G__41610_42203 = args__38258__auto___42198;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41606_42199,G__41607_42200,G__41608_42201,G__41609_42202,G__41610_42203) : schema.core.fn_validator.call(null,G__41606_42199,G__41607_42200,G__41608_42201,G__41609_42202,G__41610_42203));
} else {
var temp__5804__auto___42204 = (function (){var fexpr__41611 = cljs.core.deref(input_checker41600_42193);
return (fexpr__41611.cljs$core$IFn$_invoke$arity$1 ? fexpr__41611.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42198) : fexpr__41611.call(null,args__38258__auto___42198));
})();
if(cljs.core.truth_(temp__5804__auto___42204)){
var error__38259__auto___42206 = temp__5804__auto___42204;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42206], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41599_42192,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42198,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42206], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41602;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41612_42209 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41613_42210 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41614_42211 = output_schema41598_42191;
var G__41615_42212 = cljs.core.deref(output_checker41601_42194);
var G__41616_42213 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41612_42209,G__41613_42210,G__41614_42211,G__41615_42212,G__41616_42213) : schema.core.fn_validator.call(null,G__41612_42209,G__41613_42210,G__41614_42211,G__41615_42212,G__41616_42213));
} else {
var temp__5804__auto___42215 = (function (){var fexpr__41617 = cljs.core.deref(output_checker41601_42194);
return (fexpr__41617.cljs$core$IFn$_invoke$arity$1 ? fexpr__41617.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41617.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42215)){
var error__38259__auto___42216 = temp__5804__auto___42215;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42216], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41598_42191,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42216], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_upper_hex_str),schema.core.__GT_FnSchema(output_schema41598_42191,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41599_42192], null)));

var ufv___42217 = schema.utils.use_fn_validation;
var output_schema41619_42218 = schema.core.maybe(schema.core.Str);
var input_schema41620_42219 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41621_42220 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41620_42219);
}),null));
var output_checker41622_42221 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41619_42218);
}),null));
var ret__40655__auto___42222 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_b16_alpha_str = (function deercreeklabs$baracus$byte_array__GT_b16_alpha_str(G__41623){
var validate__38257__auto__ = cljs.core.deref(ufv___42217);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42223 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41623], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41624_42224 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41625_42225 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41626_42226 = input_schema41620_42219;
var G__41627_42227 = cljs.core.deref(input_checker41621_42220);
var G__41628_42228 = args__38258__auto___42223;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41624_42224,G__41625_42225,G__41626_42226,G__41627_42227,G__41628_42228) : schema.core.fn_validator.call(null,G__41624_42224,G__41625_42225,G__41626_42226,G__41627_42227,G__41628_42228));
} else {
var temp__5804__auto___42229 = (function (){var fexpr__41629 = cljs.core.deref(input_checker41621_42220);
return (fexpr__41629.cljs$core$IFn$_invoke$arity$1 ? fexpr__41629.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42223) : fexpr__41629.call(null,args__38258__auto___42223));
})();
if(cljs.core.truth_(temp__5804__auto___42229)){
var error__38259__auto___42230 = temp__5804__auto___42229;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42230], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41620_42219,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42223,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42230], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41623;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["a","b","c","d","c","e","f","g","h","i","j","k","l","m","n","o"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41631_42233 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41632_42234 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41633_42235 = output_schema41619_42218;
var G__41634_42236 = cljs.core.deref(output_checker41622_42221);
var G__41635_42237 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41631_42233,G__41632_42234,G__41633_42235,G__41634_42236,G__41635_42237) : schema.core.fn_validator.call(null,G__41631_42233,G__41632_42234,G__41633_42235,G__41634_42236,G__41635_42237));
} else {
var temp__5804__auto___42239 = (function (){var fexpr__41636 = cljs.core.deref(output_checker41622_42221);
return (fexpr__41636.cljs$core$IFn$_invoke$arity$1 ? fexpr__41636.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41636.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42239)){
var error__38259__auto___42241 = temp__5804__auto___42239;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42241], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41619_42218,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42241], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b16_alpha_str),schema.core.__GT_FnSchema(output_schema41619_42218,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41620_42219], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42246 = schema.utils.use_fn_validation;
var output_schema41637_42247 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41638_42248 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41639_42249 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41638_42248);
}),null));
var output_checker41640_42250 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41637_42247);
}),null));
var ret__40655__auto___42251 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41641){
var validate__38257__auto__ = cljs.core.deref(ufv___42246);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42252 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41641], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41643_42253 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41644_42254 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41645_42255 = input_schema41638_42248;
var G__41646_42256 = cljs.core.deref(input_checker41639_42249);
var G__41647_42257 = args__38258__auto___42252;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41643_42253,G__41644_42254,G__41645_42255,G__41646_42256,G__41647_42257) : schema.core.fn_validator.call(null,G__41643_42253,G__41644_42254,G__41645_42255,G__41646_42256,G__41647_42257));
} else {
var temp__5804__auto___42258 = (function (){var fexpr__41648 = cljs.core.deref(input_checker41639_42249);
return (fexpr__41648.cljs$core$IFn$_invoke$arity$1 ? fexpr__41648.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42252) : fexpr__41648.call(null,args__38258__auto___42252));
})();
if(cljs.core.truth_(temp__5804__auto___42258)){
var error__38259__auto___42259 = temp__5804__auto___42258;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42259], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41638_42248,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42252,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42259], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var s = G__41641;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5636__auto___42260 = ba_len;
var i_42261 = (0);
while(true){
if((i_42261 < n__5636__auto___42260)){
var j_42262 = ((2) * i_42261);
(ba[i_42261] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42262)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42262 + (1))))));

var G__42263 = (i_42261 + (1));
i_42261 = G__42263;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41650_42264 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41651_42265 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41652_42266 = output_schema41637_42247;
var G__41653_42267 = cljs.core.deref(output_checker41640_42250);
var G__41654_42268 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41650_42264,G__41651_42265,G__41652_42266,G__41653_42267,G__41654_42268) : schema.core.fn_validator.call(null,G__41650_42264,G__41651_42265,G__41652_42266,G__41653_42267,G__41654_42268));
} else {
var temp__5804__auto___42269 = (function (){var fexpr__41655 = cljs.core.deref(output_checker41640_42250);
return (fexpr__41655.cljs$core$IFn$_invoke$arity$1 ? fexpr__41655.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41655.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42269)){
var error__38259__auto___42270 = temp__5804__auto___42269;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42270], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41637_42247,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42270], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41637_42247,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41638_42248], null)));

var ufv___42274 = schema.utils.use_fn_validation;
var output_schema41657_42275 = deercreeklabs.baracus.ByteArray;
var input_schema41658_42276 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41659_42277 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41658_42276);
}),null));
var output_checker41660_42278 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41657_42275);
}),null));
var ret__40655__auto___42280 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41661){
var validate__38257__auto__ = cljs.core.deref(ufv___42274);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42281 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41661], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41663_42282 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41664_42283 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41665_42284 = input_schema41658_42276;
var G__41666_42285 = cljs.core.deref(input_checker41659_42277);
var G__41667_42286 = args__38258__auto___42281;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41663_42282,G__41664_42283,G__41665_42284,G__41666_42285,G__41667_42286) : schema.core.fn_validator.call(null,G__41663_42282,G__41664_42283,G__41665_42284,G__41666_42285,G__41667_42286));
} else {
var temp__5804__auto___42287 = (function (){var fexpr__41668 = cljs.core.deref(input_checker41659_42277);
return (fexpr__41668.cljs$core$IFn$_invoke$arity$1 ? fexpr__41668.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42281) : fexpr__41668.call(null,args__38258__auto___42281));
})();
if(cljs.core.truth_(temp__5804__auto___42287)){
var error__38259__auto___42288 = temp__5804__auto___42287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42288], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41658_42276,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42281,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42288], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41661;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41669_42292 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41670_42293 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41671_42294 = output_schema41657_42275;
var G__41672_42295 = cljs.core.deref(output_checker41660_42278);
var G__41673_42296 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41669_42292,G__41670_42293,G__41671_42294,G__41672_42295,G__41673_42296) : schema.core.fn_validator.call(null,G__41669_42292,G__41670_42293,G__41671_42294,G__41672_42295,G__41673_42296));
} else {
var temp__5804__auto___42297 = (function (){var fexpr__41674 = cljs.core.deref(output_checker41660_42278);
return (fexpr__41674.cljs$core$IFn$_invoke$arity$1 ? fexpr__41674.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41674.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42297)){
var error__38259__auto___42298 = temp__5804__auto___42297;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42298], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41657_42275,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42298], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41657_42275,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41658_42276], null)));

var ufv___42300 = schema.utils.use_fn_validation;
var output_schema41676_42301 = deercreeklabs.baracus.ByteArray;
var input_schema41677_42302 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41678_42303 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41677_42302);
}),null));
var output_checker41679_42304 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41676_42301);
}),null));
var ret__40655__auto___42305 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41680){
var validate__38257__auto__ = cljs.core.deref(ufv___42300);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42306 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41680], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41681_42307 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41682_42308 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41683_42309 = input_schema41677_42302;
var G__41684_42310 = cljs.core.deref(input_checker41678_42303);
var G__41685_42311 = args__38258__auto___42306;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41681_42307,G__41682_42308,G__41683_42309,G__41684_42310,G__41685_42311) : schema.core.fn_validator.call(null,G__41681_42307,G__41682_42308,G__41683_42309,G__41684_42310,G__41685_42311));
} else {
var temp__5804__auto___42312 = (function (){var fexpr__41686 = cljs.core.deref(input_checker41678_42303);
return (fexpr__41686.cljs$core$IFn$_invoke$arity$1 ? fexpr__41686.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42306) : fexpr__41686.call(null,args__38258__auto___42306));
})();
if(cljs.core.truth_(temp__5804__auto___42312)){
var error__38259__auto___42313 = temp__5804__auto___42312;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42313], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41677_42302,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42306,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42313], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41680;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41687_42314 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41688_42315 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41689_42316 = output_schema41676_42301;
var G__41690_42317 = cljs.core.deref(output_checker41679_42304);
var G__41691_42318 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41687_42314,G__41688_42315,G__41689_42316,G__41690_42317,G__41691_42318) : schema.core.fn_validator.call(null,G__41687_42314,G__41688_42315,G__41689_42316,G__41690_42317,G__41691_42318));
} else {
var temp__5804__auto___42319 = (function (){var fexpr__41692 = cljs.core.deref(output_checker41679_42304);
return (fexpr__41692.cljs$core$IFn$_invoke$arity$1 ? fexpr__41692.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41692.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42319)){
var error__38259__auto___42320 = temp__5804__auto___42319;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42320], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41676_42301,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42320], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41676_42301,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41677_42302], null)));

var ufv___42322 = schema.utils.use_fn_validation;
var output_schema41694_42323 = deercreeklabs.baracus.ByteArray;
var input_schema41695_42324 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41696_42325 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41695_42324);
}),null));
var output_checker41697_42326 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41694_42323);
}),null));
var ret__40655__auto___42327 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41698){
var validate__38257__auto__ = cljs.core.deref(ufv___42322);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___42328 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41698], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41699_42329 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41700_42330 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41701_42331 = input_schema41695_42324;
var G__41702_42332 = cljs.core.deref(input_checker41696_42325);
var G__41703_42333 = args__38258__auto___42328;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41699_42329,G__41700_42330,G__41701_42331,G__41702_42332,G__41703_42333) : schema.core.fn_validator.call(null,G__41699_42329,G__41700_42330,G__41701_42331,G__41702_42332,G__41703_42333));
} else {
var temp__5804__auto___42334 = (function (){var fexpr__41704 = cljs.core.deref(input_checker41696_42325);
return (fexpr__41704.cljs$core$IFn$_invoke$arity$1 ? fexpr__41704.cljs$core$IFn$_invoke$arity$1(args__38258__auto___42328) : fexpr__41704.call(null,args__38258__auto___42328));
})();
if(cljs.core.truth_(temp__5804__auto___42334)){
var error__38259__auto___42335 = temp__5804__auto___42334;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42335], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41695_42324,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___42328,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42335], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var ba = G__41698;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41706_42337 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41707_42338 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41708_42339 = output_schema41694_42323;
var G__41709_42340 = cljs.core.deref(output_checker41697_42326);
var G__41710_42341 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41706_42337,G__41707_42338,G__41708_42339,G__41709_42340,G__41710_42341) : schema.core.fn_validator.call(null,G__41706_42337,G__41707_42338,G__41708_42339,G__41709_42340,G__41710_42341));
} else {
var temp__5804__auto___42342 = (function (){var fexpr__41711 = cljs.core.deref(output_checker41697_42326);
return (fexpr__41711.cljs$core$IFn$_invoke$arity$1 ? fexpr__41711.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__41711.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42342)){
var error__38259__auto___42343 = temp__5804__auto___42342;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___42343], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41694_42323,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___42343], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41694_42323,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41695_42324], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
