goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39786__39787__auto__){
if((!((p1__39786__39787__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39786__39787__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39786__39787__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39786__39787__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39786__39787__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___53914 = schema.utils.use_fn_validation;
var output_schema52951_53915 = deercreeklabs.lancaster.LancasterSchema;
var input_schema52952_53916 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker52953_53917 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52952_53916);
}),null));
var output_checker52954_53918 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52951_53915);
}),null));
var ret__40655__auto___53919 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__52955){
var validate__38257__auto__ = cljs.core.deref(ufv___53914);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___53920 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52955], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52968_53921 = new cljs.core.Keyword(null,"input","input",556931961);
var G__52969_53922 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__52970_53923 = input_schema52952_53916;
var G__52971_53924 = cljs.core.deref(input_checker52953_53917);
var G__52972_53925 = args__38258__auto___53920;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52968_53921,G__52969_53922,G__52970_53923,G__52971_53924,G__52972_53925) : schema.core.fn_validator.call(null,G__52968_53921,G__52969_53922,G__52970_53923,G__52971_53924,G__52972_53925));
} else {
var temp__5804__auto___53926 = (function (){var fexpr__52973 = cljs.core.deref(input_checker52953_53917);
return (fexpr__52973.cljs$core$IFn$_invoke$arity$1 ? fexpr__52973.cljs$core$IFn$_invoke$arity$1(args__38258__auto___53920) : fexpr__52973.call(null,args__38258__auto___53920));
})();
if(cljs.core.truth_(temp__5804__auto___53926)){
var error__38259__auto___53927 = temp__5804__auto___53926;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___53927], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52952_53916,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___53920,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___53927], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var json = G__52955;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__52978_53928 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__52979_53929 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__52980_53930 = output_schema52951_53915;
var G__52982_53931 = cljs.core.deref(output_checker52954_53918);
var G__52983_53932 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__52978_53928,G__52979_53929,G__52980_53930,G__52982_53931,G__52983_53932) : schema.core.fn_validator.call(null,G__52978_53928,G__52979_53929,G__52980_53930,G__52982_53931,G__52983_53932));
} else {
var temp__5804__auto___53933 = (function (){var fexpr__52985 = cljs.core.deref(output_checker52954_53918);
return (fexpr__52985.cljs$core$IFn$_invoke$arity$1 ? fexpr__52985.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__52985.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53933)){
var error__38259__auto___53937 = temp__5804__auto___53933;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___53937], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52951_53915,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___53937], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema52951_53915,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52952_53916], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___53939 = schema.utils.use_fn_validation;
var output_schema52993_53940 = deercreeklabs.lancaster.LancasterSchema;
var input_schema52994_53942 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema52999_53943 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker52995_53944 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52994_53942);
}),null));
var output_checker52996_53945 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52993_53940);
}),null));
var input_checker53000_53946 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema52999_53943);
}),null));
var output_checker53001_53947 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema52993_53940);
}),null));
var ret__40655__auto___53948 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__53014 = arguments.length;
switch (G__53014) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__52997,G__52998){
var validate__38257__auto__ = cljs.core.deref(ufv___53939);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___53950 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__52997,G__52998], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53015_53951 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53016_53952 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53017_53953 = input_schema52994_53942;
var G__53018_53954 = cljs.core.deref(input_checker52995_53944);
var G__53019_53955 = args__38258__auto___53950;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53015_53951,G__53016_53952,G__53017_53953,G__53018_53954,G__53019_53955) : schema.core.fn_validator.call(null,G__53015_53951,G__53016_53952,G__53017_53953,G__53018_53954,G__53019_53955));
} else {
var temp__5804__auto___53956 = (function (){var fexpr__53020 = cljs.core.deref(input_checker52995_53944);
return (fexpr__53020.cljs$core$IFn$_invoke$arity$1 ? fexpr__53020.cljs$core$IFn$_invoke$arity$1(args__38258__auto___53950) : fexpr__53020.call(null,args__38258__auto___53950));
})();
if(cljs.core.truth_(temp__5804__auto___53956)){
var error__38259__auto___53958 = temp__5804__auto___53956;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___53958], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52994_53942,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___53950,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___53958], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var name_kw = G__52997;
var fields = G__52998;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53023_53961 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53024_53962 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53025_53963 = output_schema52993_53940;
var G__53026_53964 = cljs.core.deref(output_checker52996_53945);
var G__53027_53965 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53023_53961,G__53024_53962,G__53025_53963,G__53026_53964,G__53027_53965) : schema.core.fn_validator.call(null,G__53023_53961,G__53024_53962,G__53025_53963,G__53026_53964,G__53027_53965));
} else {
var temp__5804__auto___53970 = (function (){var fexpr__53029 = cljs.core.deref(output_checker52996_53945);
return (fexpr__53029.cljs$core$IFn$_invoke$arity$1 ? fexpr__53029.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53029.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53970)){
var error__38259__auto___53974 = temp__5804__auto___53970;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___53974], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52993_53940,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___53974], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53002,G__53003,G__53004){
var validate__38257__auto__ = cljs.core.deref(ufv___53939);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___53975 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53002,G__53003,G__53004], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53035_53976 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53036_53977 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53037_53978 = input_schema52999_53943;
var G__53038_53979 = cljs.core.deref(input_checker53000_53946);
var G__53039_53980 = args__38258__auto___53975;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53035_53976,G__53036_53977,G__53037_53978,G__53038_53979,G__53039_53980) : schema.core.fn_validator.call(null,G__53035_53976,G__53036_53977,G__53037_53978,G__53038_53979,G__53039_53980));
} else {
var temp__5804__auto___53981 = (function (){var fexpr__53043 = cljs.core.deref(input_checker53000_53946);
return (fexpr__53043.cljs$core$IFn$_invoke$arity$1 ? fexpr__53043.cljs$core$IFn$_invoke$arity$1(args__38258__auto___53975) : fexpr__53043.call(null,args__38258__auto___53975));
})();
if(cljs.core.truth_(temp__5804__auto___53981)){
var error__38259__auto___53985 = temp__5804__auto___53981;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___53985], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema52999_53943,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___53975,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___53985], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var name_kw = G__53002;
var docstring = G__53003;
var fields = G__53004;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53044_53986 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53045_53987 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53046_53988 = output_schema52993_53940;
var G__53047_53989 = cljs.core.deref(output_checker53001_53947);
var G__53048_53990 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53044_53986,G__53045_53987,G__53046_53988,G__53047_53989,G__53048_53990) : schema.core.fn_validator.call(null,G__53044_53986,G__53045_53987,G__53046_53988,G__53047_53989,G__53048_53990));
} else {
var temp__5804__auto___53991 = (function (){var fexpr__53049 = cljs.core.deref(output_checker53001_53947);
return (fexpr__53049.cljs$core$IFn$_invoke$arity$1 ? fexpr__53049.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53049.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___53991)){
var error__38259__auto___53992 = temp__5804__auto___53991;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___53992], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema52993_53940,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___53992], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema52993_53940,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema52994_53942,input_schema52999_53943], null)));

var ufv___54000 = schema.utils.use_fn_validation;
var output_schema53053_54001 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53054_54002 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema53059_54003 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53055_54004 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53054_54002);
}),null));
var output_checker53056_54005 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53053_54001);
}),null));
var input_checker53060_54006 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53059_54003);
}),null));
var output_checker53061_54007 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53053_54001);
}),null));
var ret__40655__auto___54010 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__53078 = arguments.length;
switch (G__53078) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53057,G__53058){
var validate__38257__auto__ = cljs.core.deref(ufv___54000);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54012 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53057,G__53058], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53083_54013 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53084_54014 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53085_54015 = input_schema53054_54002;
var G__53086_54016 = cljs.core.deref(input_checker53055_54004);
var G__53087_54017 = args__38258__auto___54012;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53083_54013,G__53084_54014,G__53085_54015,G__53086_54016,G__53087_54017) : schema.core.fn_validator.call(null,G__53083_54013,G__53084_54014,G__53085_54015,G__53086_54016,G__53087_54017));
} else {
var temp__5804__auto___54018 = (function (){var fexpr__53088 = cljs.core.deref(input_checker53055_54004);
return (fexpr__53088.cljs$core$IFn$_invoke$arity$1 ? fexpr__53088.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54012) : fexpr__53088.call(null,args__38258__auto___54012));
})();
if(cljs.core.truth_(temp__5804__auto___54018)){
var error__38259__auto___54019 = temp__5804__auto___54018;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54019], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53054_54002,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54012,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54019], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var name_kw = G__53057;
var symbol_keywords = G__53058;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53090_54020 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53091_54021 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53092_54022 = output_schema53053_54001;
var G__53093_54023 = cljs.core.deref(output_checker53056_54005);
var G__53094_54024 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53090_54020,G__53091_54021,G__53092_54022,G__53093_54023,G__53094_54024) : schema.core.fn_validator.call(null,G__53090_54020,G__53091_54021,G__53092_54022,G__53093_54023,G__53094_54024));
} else {
var temp__5804__auto___54028 = (function (){var fexpr__53095 = cljs.core.deref(output_checker53056_54005);
return (fexpr__53095.cljs$core$IFn$_invoke$arity$1 ? fexpr__53095.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53095.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54028)){
var error__38259__auto___54029 = temp__5804__auto___54028;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54029], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53053_54001,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54029], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53063,G__53064,G__53065){
var validate__38257__auto__ = cljs.core.deref(ufv___54000);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54030 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53063,G__53064,G__53065], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53100_54031 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53101_54032 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53102_54033 = input_schema53059_54003;
var G__53103_54034 = cljs.core.deref(input_checker53060_54006);
var G__53104_54035 = args__38258__auto___54030;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53100_54031,G__53101_54032,G__53102_54033,G__53103_54034,G__53104_54035) : schema.core.fn_validator.call(null,G__53100_54031,G__53101_54032,G__53102_54033,G__53103_54034,G__53104_54035));
} else {
var temp__5804__auto___54036 = (function (){var fexpr__53105 = cljs.core.deref(input_checker53060_54006);
return (fexpr__53105.cljs$core$IFn$_invoke$arity$1 ? fexpr__53105.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54030) : fexpr__53105.call(null,args__38258__auto___54030));
})();
if(cljs.core.truth_(temp__5804__auto___54036)){
var error__38259__auto___54037 = temp__5804__auto___54036;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54037], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53059_54003,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54030,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54037], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var name_kw = G__53063;
var docstring = G__53064;
var symbol_keywords = G__53065;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53108_54038 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53109_54039 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53110_54040 = output_schema53053_54001;
var G__53111_54041 = cljs.core.deref(output_checker53061_54007);
var G__53112_54042 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53108_54038,G__53109_54039,G__53110_54040,G__53111_54041,G__53112_54042) : schema.core.fn_validator.call(null,G__53108_54038,G__53109_54039,G__53110_54040,G__53111_54041,G__53112_54042));
} else {
var temp__5804__auto___54043 = (function (){var fexpr__53113 = cljs.core.deref(output_checker53061_54007);
return (fexpr__53113.cljs$core$IFn$_invoke$arity$1 ? fexpr__53113.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53113.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54043)){
var error__38259__auto___54044 = temp__5804__auto___54043;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54044], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53053_54001,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54044], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema53053_54001,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53054_54002,input_schema53059_54003], null)));

var ufv___54045 = schema.utils.use_fn_validation;
var output_schema53119_54046 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53120_54047 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53121_54048 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53120_54047);
}),null));
var output_checker53122_54049 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53119_54046);
}),null));
var ret__40655__auto___54052 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__53123,G__53124){
var validate__38257__auto__ = cljs.core.deref(ufv___54045);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54053 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53123,G__53124], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53132_54054 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53133_54055 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53134_54056 = input_schema53120_54047;
var G__53135_54057 = cljs.core.deref(input_checker53121_54048);
var G__53136_54058 = args__38258__auto___54053;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53132_54054,G__53133_54055,G__53134_54056,G__53135_54057,G__53136_54058) : schema.core.fn_validator.call(null,G__53132_54054,G__53133_54055,G__53134_54056,G__53135_54057,G__53136_54058));
} else {
var temp__5804__auto___54059 = (function (){var fexpr__53142 = cljs.core.deref(input_checker53121_54048);
return (fexpr__53142.cljs$core$IFn$_invoke$arity$1 ? fexpr__53142.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54053) : fexpr__53142.call(null,args__38258__auto___54053));
})();
if(cljs.core.truth_(temp__5804__auto___54059)){
var error__38259__auto___54060 = temp__5804__auto___54059;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54060], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53120_54047,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54053,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54060], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var name_kw = G__53123;
var size = G__53124;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53143_54064 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53144_54065 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53145_54066 = output_schema53119_54046;
var G__53146_54067 = cljs.core.deref(output_checker53122_54049);
var G__53147_54068 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53143_54064,G__53144_54065,G__53145_54066,G__53146_54067,G__53147_54068) : schema.core.fn_validator.call(null,G__53143_54064,G__53144_54065,G__53145_54066,G__53146_54067,G__53147_54068));
} else {
var temp__5804__auto___54069 = (function (){var fexpr__53148 = cljs.core.deref(output_checker53122_54049);
return (fexpr__53148.cljs$core$IFn$_invoke$arity$1 ? fexpr__53148.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53148.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54069)){
var error__38259__auto___54070 = temp__5804__auto___54069;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54070], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53119_54046,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54070], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema53119_54046,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53120_54047], null)));

var ufv___54071 = schema.utils.use_fn_validation;
var output_schema53153_54072 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53154_54073 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53155_54074 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53154_54073);
}),null));
var output_checker53156_54075 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53153_54072);
}),null));
var ret__40655__auto___54076 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__53157){
var validate__38257__auto__ = cljs.core.deref(ufv___54071);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54077 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53157], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53160_54078 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53161_54079 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53162_54080 = input_schema53154_54073;
var G__53163_54081 = cljs.core.deref(input_checker53155_54074);
var G__53164_54082 = args__38258__auto___54077;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53160_54078,G__53161_54079,G__53162_54080,G__53163_54081,G__53164_54082) : schema.core.fn_validator.call(null,G__53160_54078,G__53161_54079,G__53162_54080,G__53163_54081,G__53164_54082));
} else {
var temp__5804__auto___54083 = (function (){var fexpr__53165 = cljs.core.deref(input_checker53155_54074);
return (fexpr__53165.cljs$core$IFn$_invoke$arity$1 ? fexpr__53165.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54077) : fexpr__53165.call(null,args__38258__auto___54077));
})();
if(cljs.core.truth_(temp__5804__auto___54083)){
var error__38259__auto___54084 = temp__5804__auto___54083;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54084], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53154_54073,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54077,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54084], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var items_schema = G__53157;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53167_54085 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53168_54086 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53169_54087 = output_schema53153_54072;
var G__53170_54088 = cljs.core.deref(output_checker53156_54075);
var G__53171_54089 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53167_54085,G__53168_54086,G__53169_54087,G__53170_54088,G__53171_54089) : schema.core.fn_validator.call(null,G__53167_54085,G__53168_54086,G__53169_54087,G__53170_54088,G__53171_54089));
} else {
var temp__5804__auto___54090 = (function (){var fexpr__53172 = cljs.core.deref(output_checker53156_54075);
return (fexpr__53172.cljs$core$IFn$_invoke$arity$1 ? fexpr__53172.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53172.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54090)){
var error__38259__auto___54091 = temp__5804__auto___54090;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54091], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53153_54072,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54091], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema53153_54072,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53154_54073], null)));

var ufv___54092 = schema.utils.use_fn_validation;
var output_schema53177_54093 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53178_54094 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53179_54095 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53178_54094);
}),null));
var output_checker53180_54096 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53177_54093);
}),null));
var ret__40655__auto___54097 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__53181){
var validate__38257__auto__ = cljs.core.deref(ufv___54092);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54098 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53181], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53183_54099 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53184_54100 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53185_54101 = input_schema53178_54094;
var G__53186_54102 = cljs.core.deref(input_checker53179_54095);
var G__53187_54103 = args__38258__auto___54098;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53183_54099,G__53184_54100,G__53185_54101,G__53186_54102,G__53187_54103) : schema.core.fn_validator.call(null,G__53183_54099,G__53184_54100,G__53185_54101,G__53186_54102,G__53187_54103));
} else {
var temp__5804__auto___54104 = (function (){var fexpr__53193 = cljs.core.deref(input_checker53179_54095);
return (fexpr__53193.cljs$core$IFn$_invoke$arity$1 ? fexpr__53193.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54098) : fexpr__53193.call(null,args__38258__auto___54098));
})();
if(cljs.core.truth_(temp__5804__auto___54104)){
var error__38259__auto___54105 = temp__5804__auto___54104;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54105], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53178_54094,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54098,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54105], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var values_schema = G__53181;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53197_54106 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53198_54107 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53199_54108 = output_schema53177_54093;
var G__53200_54109 = cljs.core.deref(output_checker53180_54096);
var G__53201_54110 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53197_54106,G__53198_54107,G__53199_54108,G__53200_54109,G__53201_54110) : schema.core.fn_validator.call(null,G__53197_54106,G__53198_54107,G__53199_54108,G__53200_54109,G__53201_54110));
} else {
var temp__5804__auto___54111 = (function (){var fexpr__53202 = cljs.core.deref(output_checker53180_54096);
return (fexpr__53202.cljs$core$IFn$_invoke$arity$1 ? fexpr__53202.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53202.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54111)){
var error__38259__auto___54112 = temp__5804__auto___54111;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54112], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53177_54093,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54112], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema53177_54093,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53178_54094], null)));

var ufv___54113 = schema.utils.use_fn_validation;
var output_schema53203_54114 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53204_54115 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker53205_54116 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53204_54115);
}),null));
var output_checker53206_54117 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53203_54114);
}),null));
var ret__40655__auto___54118 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__53207){
var validate__38257__auto__ = cljs.core.deref(ufv___54113);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54119 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53207], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53209_54120 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53210_54121 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53211_54122 = input_schema53204_54115;
var G__53212_54123 = cljs.core.deref(input_checker53205_54116);
var G__53213_54124 = args__38258__auto___54119;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53209_54120,G__53210_54121,G__53211_54122,G__53212_54123,G__53213_54124) : schema.core.fn_validator.call(null,G__53209_54120,G__53210_54121,G__53211_54122,G__53212_54123,G__53213_54124));
} else {
var temp__5804__auto___54125 = (function (){var fexpr__53220 = cljs.core.deref(input_checker53205_54116);
return (fexpr__53220.cljs$core$IFn$_invoke$arity$1 ? fexpr__53220.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54119) : fexpr__53220.call(null,args__38258__auto___54119));
})();
if(cljs.core.truth_(temp__5804__auto___54125)){
var error__38259__auto___54126 = temp__5804__auto___54125;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54126], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53204_54115,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54119,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54126], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var member_schemas = G__53207;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53225_54127 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53226_54128 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53227_54129 = output_schema53203_54114;
var G__53228_54130 = cljs.core.deref(output_checker53206_54117);
var G__53229_54131 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53225_54127,G__53226_54128,G__53227_54129,G__53228_54130,G__53229_54131) : schema.core.fn_validator.call(null,G__53225_54127,G__53226_54128,G__53227_54129,G__53228_54130,G__53229_54131));
} else {
var temp__5804__auto___54132 = (function (){var fexpr__53230 = cljs.core.deref(output_checker53206_54117);
return (fexpr__53230.cljs$core$IFn$_invoke$arity$1 ? fexpr__53230.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53230.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54132)){
var error__38259__auto___54133 = temp__5804__auto___54132;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54133], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53203_54114,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54133], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema53203_54114,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53204_54115], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___54134 = schema.utils.use_fn_validation;
var output_schema53234_54135 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53235_54136 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53236_54137 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53235_54136);
}),null));
var output_checker53237_54138 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53234_54135);
}),null));
var ret__40655__auto___54139 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__53238){
var validate__38257__auto__ = cljs.core.deref(ufv___54134);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54140 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53238], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53249_54141 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53250_54142 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53251_54143 = input_schema53235_54136;
var G__53252_54144 = cljs.core.deref(input_checker53236_54137);
var G__53253_54145 = args__38258__auto___54140;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53249_54141,G__53250_54142,G__53251_54143,G__53252_54144,G__53253_54145) : schema.core.fn_validator.call(null,G__53249_54141,G__53250_54142,G__53251_54143,G__53252_54144,G__53253_54145));
} else {
var temp__5804__auto___54146 = (function (){var fexpr__53256 = cljs.core.deref(input_checker53236_54137);
return (fexpr__53256.cljs$core$IFn$_invoke$arity$1 ? fexpr__53256.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54140) : fexpr__53256.call(null,args__38258__auto___54140));
})();
if(cljs.core.truth_(temp__5804__auto___54146)){
var error__38259__auto___54147 = temp__5804__auto___54146;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54147], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53235_54136,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54140,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54147], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53238;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53259_54148 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53260_54149 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53261_54150 = output_schema53234_54135;
var G__53262_54151 = cljs.core.deref(output_checker53237_54138);
var G__53263_54152 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53259_54148,G__53260_54149,G__53261_54150,G__53262_54151,G__53263_54152) : schema.core.fn_validator.call(null,G__53259_54148,G__53260_54149,G__53261_54150,G__53262_54151,G__53263_54152));
} else {
var temp__5804__auto___54153 = (function (){var fexpr__53269 = cljs.core.deref(output_checker53237_54138);
return (fexpr__53269.cljs$core$IFn$_invoke$arity$1 ? fexpr__53269.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53269.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54153)){
var error__38259__auto___54154 = temp__5804__auto___54153;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54154], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53234_54135,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54154], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema53234_54135,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53235_54136], null)));

var ufv___54155 = schema.utils.use_fn_validation;
var output_schema53274_54156 = deercreeklabs.baracus.ByteArray;
var input_schema53275_54157 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53276_54158 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53275_54157);
}),null));
var output_checker53277_54159 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53274_54156);
}),null));
var ret__40655__auto___54160 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__53278,G__53279){
var validate__38257__auto__ = cljs.core.deref(ufv___54155);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54161 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53278,G__53279], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53284_54162 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53285_54163 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53286_54164 = input_schema53275_54157;
var G__53287_54165 = cljs.core.deref(input_checker53276_54158);
var G__53288_54166 = args__38258__auto___54161;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53284_54162,G__53285_54163,G__53286_54164,G__53287_54165,G__53288_54166) : schema.core.fn_validator.call(null,G__53284_54162,G__53285_54163,G__53286_54164,G__53287_54165,G__53288_54166));
} else {
var temp__5804__auto___54167 = (function (){var fexpr__53289 = cljs.core.deref(input_checker53276_54158);
return (fexpr__53289.cljs$core$IFn$_invoke$arity$1 ? fexpr__53289.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54161) : fexpr__53289.call(null,args__38258__auto___54161));
})();
if(cljs.core.truth_(temp__5804__auto___54167)){
var error__38259__auto___54168 = temp__5804__auto___54167;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54168], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53275_54157,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54161,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54168], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var writer_schema = G__53278;
var data = G__53279;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53315_54170 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53316_54171 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53317_54172 = output_schema53274_54156;
var G__53318_54173 = cljs.core.deref(output_checker53277_54159);
var G__53319_54174 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53315_54170,G__53316_54171,G__53317_54172,G__53318_54173,G__53319_54174) : schema.core.fn_validator.call(null,G__53315_54170,G__53316_54171,G__53317_54172,G__53318_54173,G__53319_54174));
} else {
var temp__5804__auto___54175 = (function (){var fexpr__53321 = cljs.core.deref(output_checker53277_54159);
return (fexpr__53321.cljs$core$IFn$_invoke$arity$1 ? fexpr__53321.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53321.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54175)){
var error__38259__auto___54176 = temp__5804__auto___54175;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54176], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53274_54156,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54176], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema53274_54156,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53275_54157], null)));

var ufv___54182 = schema.utils.use_fn_validation;
var output_schema53325_54183 = schema.core.Any;
var input_schema53326_54184 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53327_54185 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53326_54184);
}),null));
var output_checker53328_54186 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53325_54183);
}),null));
var ret__40655__auto___54187 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__53329,G__53330,G__53331){
var validate__38257__auto__ = cljs.core.deref(ufv___54182);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54188 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53329,G__53330,G__53331], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53335_54189 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53336_54190 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53337_54191 = input_schema53326_54184;
var G__53338_54192 = cljs.core.deref(input_checker53327_54185);
var G__53339_54193 = args__38258__auto___54188;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53335_54189,G__53336_54190,G__53337_54191,G__53338_54192,G__53339_54193) : schema.core.fn_validator.call(null,G__53335_54189,G__53336_54190,G__53337_54191,G__53338_54192,G__53339_54193));
} else {
var temp__5804__auto___54194 = (function (){var fexpr__53340 = cljs.core.deref(input_checker53327_54185);
return (fexpr__53340.cljs$core$IFn$_invoke$arity$1 ? fexpr__53340.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54188) : fexpr__53340.call(null,args__38258__auto___54188));
})();
if(cljs.core.truth_(temp__5804__auto___54194)){
var error__38259__auto___54195 = temp__5804__auto___54194;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54195], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53326_54184,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54188,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54195], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var reader_schema = G__53329;
var writer_schema = G__53330;
var ba = G__53331;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53353_54198 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53354_54199 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53355_54200 = output_schema53325_54183;
var G__53356_54201 = cljs.core.deref(output_checker53328_54186);
var G__53357_54202 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53353_54198,G__53354_54199,G__53355_54200,G__53356_54201,G__53357_54202) : schema.core.fn_validator.call(null,G__53353_54198,G__53354_54199,G__53355_54200,G__53356_54201,G__53357_54202));
} else {
var temp__5804__auto___54206 = (function (){var fexpr__53358 = cljs.core.deref(output_checker53328_54186);
return (fexpr__53358.cljs$core$IFn$_invoke$arity$1 ? fexpr__53358.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53358.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54206)){
var error__38259__auto___54207 = temp__5804__auto___54206;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54207], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53325_54183,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54207], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema53325_54183,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53326_54184], null)));

var ufv___54209 = schema.utils.use_fn_validation;
var output_schema53367_54210 = schema.core.Any;
var input_schema53369_54211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53370_54212 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53369_54211);
}),null));
var output_checker53371_54213 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53367_54210);
}),null));
var ret__40655__auto___54216 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__53372,G__53373){
var validate__38257__auto__ = cljs.core.deref(ufv___54209);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54217 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53372,G__53373], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53391_54218 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53392_54219 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53393_54220 = input_schema53369_54211;
var G__53394_54221 = cljs.core.deref(input_checker53370_54212);
var G__53395_54222 = args__38258__auto___54217;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53391_54218,G__53392_54219,G__53393_54220,G__53394_54221,G__53395_54222) : schema.core.fn_validator.call(null,G__53391_54218,G__53392_54219,G__53393_54220,G__53394_54221,G__53395_54222));
} else {
var temp__5804__auto___54223 = (function (){var fexpr__53399 = cljs.core.deref(input_checker53370_54212);
return (fexpr__53399.cljs$core$IFn$_invoke$arity$1 ? fexpr__53399.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54217) : fexpr__53399.call(null,args__38258__auto___54217));
})();
if(cljs.core.truth_(temp__5804__auto___54223)){
var error__38259__auto___54224 = temp__5804__auto___54223;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54224], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53369_54211,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54217,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54224], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53372;
var ba = G__53373;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53401_54225 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53402_54226 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53403_54227 = output_schema53367_54210;
var G__53404_54228 = cljs.core.deref(output_checker53371_54213);
var G__53405_54229 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53401_54225,G__53402_54226,G__53403_54227,G__53404_54228,G__53405_54229) : schema.core.fn_validator.call(null,G__53401_54225,G__53402_54226,G__53403_54227,G__53404_54228,G__53405_54229));
} else {
var temp__5804__auto___54230 = (function (){var fexpr__53408 = cljs.core.deref(output_checker53371_54213);
return (fexpr__53408.cljs$core$IFn$_invoke$arity$1 ? fexpr__53408.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53408.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54230)){
var error__38259__auto___54231 = temp__5804__auto___54230;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54231], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53367_54210,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54231], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema53367_54210,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53369_54211], null)));

var ufv___54238 = schema.utils.use_fn_validation;
var output_schema53412_54239 = schema.core.Any;
var input_schema53413_54240 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53414_54241 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53413_54240);
}),null));
var output_checker53415_54242 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53412_54239);
}),null));
var ret__40655__auto___54244 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__53416){
var validate__38257__auto__ = cljs.core.deref(ufv___54238);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54245 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53416], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53445_54247 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53446_54248 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53447_54249 = input_schema53413_54240;
var G__53448_54250 = cljs.core.deref(input_checker53414_54241);
var G__53449_54251 = args__38258__auto___54245;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53445_54247,G__53446_54248,G__53447_54249,G__53448_54250,G__53449_54251) : schema.core.fn_validator.call(null,G__53445_54247,G__53446_54248,G__53447_54249,G__53448_54250,G__53449_54251));
} else {
var temp__5804__auto___54258 = (function (){var fexpr__53456 = cljs.core.deref(input_checker53414_54241);
return (fexpr__53456.cljs$core$IFn$_invoke$arity$1 ? fexpr__53456.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54245) : fexpr__53456.call(null,args__38258__auto___54245));
})();
if(cljs.core.truth_(temp__5804__auto___54258)){
var error__38259__auto___54259 = temp__5804__auto___54258;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54259], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53413_54240,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54245,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54259], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53416;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53457_54262 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53458_54263 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53459_54264 = output_schema53412_54239;
var G__53460_54265 = cljs.core.deref(output_checker53415_54242);
var G__53461_54266 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53457_54262,G__53458_54263,G__53459_54264,G__53460_54265,G__53461_54266) : schema.core.fn_validator.call(null,G__53457_54262,G__53458_54263,G__53459_54264,G__53460_54265,G__53461_54266));
} else {
var temp__5804__auto___54267 = (function (){var fexpr__53462 = cljs.core.deref(output_checker53415_54242);
return (fexpr__53462.cljs$core$IFn$_invoke$arity$1 ? fexpr__53462.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53462.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54267)){
var error__38259__auto___54268 = temp__5804__auto___54267;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54268], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53412_54239,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54268], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema53412_54239,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53413_54240], null)));

var ufv___54270 = schema.utils.use_fn_validation;
var output_schema53463_54271 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53464_54272 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53465_54273 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53464_54272);
}),null));
var output_checker53466_54274 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53463_54271);
}),null));
var ret__40655__auto___54278 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__53467){
var validate__38257__auto__ = cljs.core.deref(ufv___54270);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54279 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53467], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53468_54280 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53469_54281 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53470_54282 = input_schema53464_54272;
var G__53471_54283 = cljs.core.deref(input_checker53465_54273);
var G__53472_54284 = args__38258__auto___54279;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53468_54280,G__53469_54281,G__53470_54282,G__53471_54283,G__53472_54284) : schema.core.fn_validator.call(null,G__53468_54280,G__53469_54281,G__53470_54282,G__53471_54283,G__53472_54284));
} else {
var temp__5804__auto___54285 = (function (){var fexpr__53473 = cljs.core.deref(input_checker53465_54273);
return (fexpr__53473.cljs$core$IFn$_invoke$arity$1 ? fexpr__53473.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54279) : fexpr__53473.call(null,args__38258__auto___54279));
})();
if(cljs.core.truth_(temp__5804__auto___54285)){
var error__38259__auto___54289 = temp__5804__auto___54285;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54289], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53464_54272,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54279,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54289], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var edn = G__53467;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53474_54292 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53475_54293 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53476_54294 = output_schema53463_54271;
var G__53477_54295 = cljs.core.deref(output_checker53466_54274);
var G__53478_54296 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53474_54292,G__53475_54293,G__53476_54294,G__53477_54295,G__53478_54296) : schema.core.fn_validator.call(null,G__53474_54292,G__53475_54293,G__53476_54294,G__53477_54295,G__53478_54296));
} else {
var temp__5804__auto___54300 = (function (){var fexpr__53479 = cljs.core.deref(output_checker53466_54274);
return (fexpr__53479.cljs$core$IFn$_invoke$arity$1 ? fexpr__53479.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53479.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54300)){
var error__38259__auto___54301 = temp__5804__auto___54300;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54301], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53463_54271,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54301], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema53463_54271,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53464_54272], null)));

var ufv___54302 = schema.utils.use_fn_validation;
var output_schema53482_54303 = schema.core.Str;
var input_schema53483_54304 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53484_54305 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53483_54304);
}),null));
var output_checker53485_54306 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53482_54303);
}),null));
var ret__40655__auto___54308 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__53486){
var validate__38257__auto__ = cljs.core.deref(ufv___54302);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54309 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53486], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53490_54310 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53491_54311 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53492_54312 = input_schema53483_54304;
var G__53493_54313 = cljs.core.deref(input_checker53484_54305);
var G__53494_54314 = args__38258__auto___54309;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53490_54310,G__53491_54311,G__53492_54312,G__53493_54313,G__53494_54314) : schema.core.fn_validator.call(null,G__53490_54310,G__53491_54311,G__53492_54312,G__53493_54313,G__53494_54314));
} else {
var temp__5804__auto___54315 = (function (){var fexpr__53495 = cljs.core.deref(input_checker53484_54305);
return (fexpr__53495.cljs$core$IFn$_invoke$arity$1 ? fexpr__53495.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54309) : fexpr__53495.call(null,args__38258__auto___54309));
})();
if(cljs.core.truth_(temp__5804__auto___54315)){
var error__38259__auto___54316 = temp__5804__auto___54315;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54316], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53483_54304,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54309,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54316], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53486;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53496_54318 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53497_54319 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53498_54320 = output_schema53482_54303;
var G__53499_54321 = cljs.core.deref(output_checker53485_54306);
var G__53500_54322 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53496_54318,G__53497_54319,G__53498_54320,G__53499_54321,G__53500_54322) : schema.core.fn_validator.call(null,G__53496_54318,G__53497_54319,G__53498_54320,G__53499_54321,G__53500_54322));
} else {
var temp__5804__auto___54323 = (function (){var fexpr__53501 = cljs.core.deref(output_checker53485_54306);
return (fexpr__53501.cljs$core$IFn$_invoke$arity$1 ? fexpr__53501.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53501.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54323)){
var error__38259__auto___54324 = temp__5804__auto___54323;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54324], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53482_54303,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54324], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema53482_54303,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53483_54304], null)));

var ufv___54325 = schema.utils.use_fn_validation;
var output_schema53505_54326 = schema.core.Keyword;
var input_schema53506_54327 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53507_54328 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53506_54327);
}),null));
var output_checker53508_54329 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53505_54326);
}),null));
var ret__40655__auto___54330 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__53509){
var validate__38257__auto__ = cljs.core.deref(ufv___54325);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54331 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53509], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53510_54332 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53511_54333 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53512_54334 = input_schema53506_54327;
var G__53513_54335 = cljs.core.deref(input_checker53507_54328);
var G__53514_54336 = args__38258__auto___54331;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53510_54332,G__53511_54333,G__53512_54334,G__53513_54335,G__53514_54336) : schema.core.fn_validator.call(null,G__53510_54332,G__53511_54333,G__53512_54334,G__53513_54335,G__53514_54336));
} else {
var temp__5804__auto___54337 = (function (){var fexpr__53518 = cljs.core.deref(input_checker53507_54328);
return (fexpr__53518.cljs$core$IFn$_invoke$arity$1 ? fexpr__53518.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54331) : fexpr__53518.call(null,args__38258__auto___54331));
})();
if(cljs.core.truth_(temp__5804__auto___54337)){
var error__38259__auto___54338 = temp__5804__auto___54337;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54338], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53506_54327,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54331,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54338], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53509;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53519_54339 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53520_54340 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53521_54341 = output_schema53505_54326;
var G__53522_54342 = cljs.core.deref(output_checker53508_54329);
var G__53523_54343 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53519_54339,G__53520_54340,G__53521_54341,G__53522_54342,G__53523_54343) : schema.core.fn_validator.call(null,G__53519_54339,G__53520_54340,G__53521_54341,G__53522_54342,G__53523_54343));
} else {
var temp__5804__auto___54344 = (function (){var fexpr__53524 = cljs.core.deref(output_checker53508_54329);
return (fexpr__53524.cljs$core$IFn$_invoke$arity$1 ? fexpr__53524.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53524.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54344)){
var error__38259__auto___54345 = temp__5804__auto___54344;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54345], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53505_54326,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54345], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema53505_54326,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53506_54327], null)));

var ufv___54346 = schema.utils.use_fn_validation;
var output_schema53528_54347 = schema.core.Str;
var input_schema53529_54348 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53530_54349 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53529_54348);
}),null));
var output_checker53531_54350 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53528_54347);
}),null));
var ret__40655__auto___54351 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__53532){
var validate__38257__auto__ = cljs.core.deref(ufv___54346);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54352 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53532], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53533_54353 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53534_54354 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53535_54355 = input_schema53529_54348;
var G__53536_54356 = cljs.core.deref(input_checker53530_54349);
var G__53537_54357 = args__38258__auto___54352;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53533_54353,G__53534_54354,G__53535_54355,G__53536_54356,G__53537_54357) : schema.core.fn_validator.call(null,G__53533_54353,G__53534_54354,G__53535_54355,G__53536_54356,G__53537_54357));
} else {
var temp__5804__auto___54358 = (function (){var fexpr__53538 = cljs.core.deref(input_checker53530_54349);
return (fexpr__53538.cljs$core$IFn$_invoke$arity$1 ? fexpr__53538.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54352) : fexpr__53538.call(null,args__38258__auto___54352));
})();
if(cljs.core.truth_(temp__5804__auto___54358)){
var error__38259__auto___54359 = temp__5804__auto___54358;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54359], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53529_54348,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54352,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54359], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53532;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53542_54360 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53543_54361 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53544_54362 = output_schema53528_54347;
var G__53545_54363 = cljs.core.deref(output_checker53531_54350);
var G__53546_54364 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53542_54360,G__53543_54361,G__53544_54362,G__53545_54363,G__53546_54364) : schema.core.fn_validator.call(null,G__53542_54360,G__53543_54361,G__53544_54362,G__53545_54363,G__53546_54364));
} else {
var temp__5804__auto___54366 = (function (){var fexpr__53547 = cljs.core.deref(output_checker53531_54350);
return (fexpr__53547.cljs$core$IFn$_invoke$arity$1 ? fexpr__53547.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53547.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54366)){
var error__38259__auto___54367 = temp__5804__auto___54366;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54367], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53528_54347,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54367], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema53528_54347,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53529_54348], null)));

var ufv___54368 = schema.utils.use_fn_validation;
var output_schema53548_54369 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema53549_54370 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53550_54371 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53549_54370);
}),null));
var output_checker53551_54372 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53548_54369);
}),null));
var ret__40655__auto___54373 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__53552){
var validate__38257__auto__ = cljs.core.deref(ufv___54368);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54374 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53552], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53557_54375 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53558_54376 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53559_54377 = input_schema53549_54370;
var G__53560_54378 = cljs.core.deref(input_checker53550_54371);
var G__53561_54379 = args__38258__auto___54374;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53557_54375,G__53558_54376,G__53559_54377,G__53560_54378,G__53561_54379) : schema.core.fn_validator.call(null,G__53557_54375,G__53558_54376,G__53559_54377,G__53560_54378,G__53561_54379));
} else {
var temp__5804__auto___54380 = (function (){var fexpr__53562 = cljs.core.deref(input_checker53550_54371);
return (fexpr__53562.cljs$core$IFn$_invoke$arity$1 ? fexpr__53562.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54374) : fexpr__53562.call(null,args__38258__auto___54374));
})();
if(cljs.core.truth_(temp__5804__auto___54380)){
var error__38259__auto___54381 = temp__5804__auto___54380;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54381], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53549_54370,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54374,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54381], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53552;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53563_54382 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53564_54383 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53565_54384 = output_schema53548_54369;
var G__53566_54385 = cljs.core.deref(output_checker53551_54372);
var G__53567_54386 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53563_54382,G__53564_54383,G__53565_54384,G__53566_54385,G__53567_54386) : schema.core.fn_validator.call(null,G__53563_54382,G__53564_54383,G__53565_54384,G__53566_54385,G__53567_54386));
} else {
var temp__5804__auto___54387 = (function (){var fexpr__53568 = cljs.core.deref(output_checker53551_54372);
return (fexpr__53568.cljs$core$IFn$_invoke$arity$1 ? fexpr__53568.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53568.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54387)){
var error__38259__auto___54388 = temp__5804__auto___54387;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54388], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53548_54369,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54388], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema53548_54369,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53549_54370], null)));

var ufv___54391 = schema.utils.use_fn_validation;
var output_schema53573_54392 = deercreeklabs.baracus.ByteArray;
var input_schema53574_54393 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53575_54394 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53574_54393);
}),null));
var output_checker53576_54395 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53573_54392);
}),null));
var ret__40655__auto___54396 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__53577){
var validate__38257__auto__ = cljs.core.deref(ufv___54391);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54398 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53577], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53578_54399 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53579_54400 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53580_54401 = input_schema53574_54393;
var G__53581_54402 = cljs.core.deref(input_checker53575_54394);
var G__53582_54403 = args__38258__auto___54398;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53578_54399,G__53579_54400,G__53580_54401,G__53581_54402,G__53582_54403) : schema.core.fn_validator.call(null,G__53578_54399,G__53579_54400,G__53580_54401,G__53581_54402,G__53582_54403));
} else {
var temp__5804__auto___54404 = (function (){var fexpr__53586 = cljs.core.deref(input_checker53575_54394);
return (fexpr__53586.cljs$core$IFn$_invoke$arity$1 ? fexpr__53586.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54398) : fexpr__53586.call(null,args__38258__auto___54398));
})();
if(cljs.core.truth_(temp__5804__auto___54404)){
var error__38259__auto___54405 = temp__5804__auto___54404;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54405], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53574_54393,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54398,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54405], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53577;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53587_54407 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53588_54408 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53589_54409 = output_schema53573_54392;
var G__53590_54410 = cljs.core.deref(output_checker53576_54395);
var G__53591_54411 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53587_54407,G__53588_54408,G__53589_54409,G__53590_54410,G__53591_54411) : schema.core.fn_validator.call(null,G__53587_54407,G__53588_54408,G__53589_54409,G__53590_54410,G__53591_54411));
} else {
var temp__5804__auto___54412 = (function (){var fexpr__53592 = cljs.core.deref(output_checker53576_54395);
return (fexpr__53592.cljs$core$IFn$_invoke$arity$1 ? fexpr__53592.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53592.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54412)){
var error__38259__auto___54413 = temp__5804__auto___54412;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54413], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53573_54392,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54413], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema53573_54392,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53574_54393], null)));

var ufv___54414 = schema.utils.use_fn_validation;
var output_schema53593_54415 = deercreeklabs.baracus.ByteArray;
var input_schema53594_54416 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53595_54417 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53594_54416);
}),null));
var output_checker53596_54418 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53593_54415);
}),null));
var ret__40655__auto___54419 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__53597){
var validate__38257__auto__ = cljs.core.deref(ufv___54414);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54422 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53597], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53601_54423 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53602_54424 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53603_54425 = input_schema53594_54416;
var G__53604_54426 = cljs.core.deref(input_checker53595_54417);
var G__53605_54427 = args__38258__auto___54422;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53601_54423,G__53602_54424,G__53603_54425,G__53604_54426,G__53605_54427) : schema.core.fn_validator.call(null,G__53601_54423,G__53602_54424,G__53603_54425,G__53604_54426,G__53605_54427));
} else {
var temp__5804__auto___54428 = (function (){var fexpr__53606 = cljs.core.deref(input_checker53595_54417);
return (fexpr__53606.cljs$core$IFn$_invoke$arity$1 ? fexpr__53606.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54422) : fexpr__53606.call(null,args__38258__auto___54422));
})();
if(cljs.core.truth_(temp__5804__auto___54428)){
var error__38259__auto___54430 = temp__5804__auto___54428;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54430], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53594_54416,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54422,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54430], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53597;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53607_54432 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53608_54433 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53609_54434 = output_schema53593_54415;
var G__53610_54435 = cljs.core.deref(output_checker53596_54418);
var G__53611_54436 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53607_54432,G__53608_54433,G__53609_54434,G__53610_54435,G__53611_54436) : schema.core.fn_validator.call(null,G__53607_54432,G__53608_54433,G__53609_54434,G__53610_54435,G__53611_54436));
} else {
var temp__5804__auto___54438 = (function (){var fexpr__53612 = cljs.core.deref(output_checker53596_54418);
return (fexpr__53612.cljs$core$IFn$_invoke$arity$1 ? fexpr__53612.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53612.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54438)){
var error__38259__auto___54440 = temp__5804__auto___54438;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54440], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53593_54415,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54440], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema53593_54415,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53594_54416], null)));

var ufv___54441 = schema.utils.use_fn_validation;
var output_schema53614_54442 = schema.core.Bool;
var input_schema53617_54443 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53618_54444 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53617_54443);
}),null));
var output_checker53619_54445 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53614_54442);
}),null));
var ret__40655__auto___54446 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__53620){
var validate__38257__auto__ = cljs.core.deref(ufv___54441);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54447 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53620], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53621_54448 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53622_54449 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53623_54450 = input_schema53617_54443;
var G__53624_54451 = cljs.core.deref(input_checker53618_54444);
var G__53625_54452 = args__38258__auto___54447;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53621_54448,G__53622_54449,G__53623_54450,G__53624_54451,G__53625_54452) : schema.core.fn_validator.call(null,G__53621_54448,G__53622_54449,G__53623_54450,G__53624_54451,G__53625_54452));
} else {
var temp__5804__auto___54453 = (function (){var fexpr__53626 = cljs.core.deref(input_checker53618_54444);
return (fexpr__53626.cljs$core$IFn$_invoke$arity$1 ? fexpr__53626.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54447) : fexpr__53626.call(null,args__38258__auto___54447));
})();
if(cljs.core.truth_(temp__5804__auto___54453)){
var error__38259__auto___54454 = temp__5804__auto___54453;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54454], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53617_54443,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54447,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54454], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var arg = G__53620;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53631_54457 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53632_54458 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53633_54459 = output_schema53614_54442;
var G__53634_54460 = cljs.core.deref(output_checker53619_54445);
var G__53635_54461 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53631_54457,G__53632_54458,G__53633_54459,G__53634_54460,G__53635_54461) : schema.core.fn_validator.call(null,G__53631_54457,G__53632_54458,G__53633_54459,G__53634_54460,G__53635_54461));
} else {
var temp__5804__auto___54463 = (function (){var fexpr__53636 = cljs.core.deref(output_checker53619_54445);
return (fexpr__53636.cljs$core$IFn$_invoke$arity$1 ? fexpr__53636.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53636.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54463)){
var error__38259__auto___54465 = temp__5804__auto___54463;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54465], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53614_54442,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54465], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema53614_54442,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53617_54443], null)));

var ufv___54468 = schema.utils.use_fn_validation;
var output_schema53640_54469 = schema.core.Bool;
var input_schema53641_54470 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53642_54471 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53641_54470);
}),null));
var output_checker53643_54472 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53640_54469);
}),null));
var ret__40655__auto___54473 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__53644,G__53645){
var validate__38257__auto__ = cljs.core.deref(ufv___54468);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54474 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53644,G__53645], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53646_54475 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53647_54476 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53648_54477 = input_schema53641_54470;
var G__53649_54478 = cljs.core.deref(input_checker53642_54471);
var G__53650_54479 = args__38258__auto___54474;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53646_54475,G__53647_54476,G__53648_54477,G__53649_54478,G__53650_54479) : schema.core.fn_validator.call(null,G__53646_54475,G__53647_54476,G__53648_54477,G__53649_54478,G__53650_54479));
} else {
var temp__5804__auto___54480 = (function (){var fexpr__53651 = cljs.core.deref(input_checker53642_54471);
return (fexpr__53651.cljs$core$IFn$_invoke$arity$1 ? fexpr__53651.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54474) : fexpr__53651.call(null,args__38258__auto___54474));
})();
if(cljs.core.truth_(temp__5804__auto___54480)){
var error__38259__auto___54481 = temp__5804__auto___54480;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54481], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53641_54470,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54474,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54481], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var reader_schema = G__53644;
var writer_schema = G__53645;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53657_54484 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53658_54485 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53659_54486 = output_schema53640_54469;
var G__53660_54487 = cljs.core.deref(output_checker53643_54472);
var G__53661_54488 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53657_54484,G__53658_54485,G__53659_54486,G__53660_54487,G__53661_54488) : schema.core.fn_validator.call(null,G__53657_54484,G__53658_54485,G__53659_54486,G__53660_54487,G__53661_54488));
} else {
var temp__5804__auto___54491 = (function (){var fexpr__53662 = cljs.core.deref(output_checker53643_54472);
return (fexpr__53662.cljs$core$IFn$_invoke$arity$1 ? fexpr__53662.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53662.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54491)){
var error__38259__auto___54493 = temp__5804__auto___54491;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54493], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53640_54469,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54493], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema53640_54469,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53641_54470], null)));

var ufv___54496 = schema.utils.use_fn_validation;
var output_schema53663_54497 = schema.core.Any;
var input_schema53664_54498 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53665_54499 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53664_54498);
}),null));
var output_checker53666_54500 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53663_54497);
}),null));
var ret__40655__auto___54502 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__53667){
var validate__38257__auto__ = cljs.core.deref(ufv___54496);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54503 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53667], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53673_54504 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53674_54505 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53675_54506 = input_schema53664_54498;
var G__53676_54507 = cljs.core.deref(input_checker53665_54499);
var G__53677_54508 = args__38258__auto___54503;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53673_54504,G__53674_54505,G__53675_54506,G__53676_54507,G__53677_54508) : schema.core.fn_validator.call(null,G__53673_54504,G__53674_54505,G__53675_54506,G__53676_54507,G__53677_54508));
} else {
var temp__5804__auto___54509 = (function (){var fexpr__53678 = cljs.core.deref(input_checker53665_54499);
return (fexpr__53678.cljs$core$IFn$_invoke$arity$1 ? fexpr__53678.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54503) : fexpr__53678.call(null,args__38258__auto___54503));
})();
if(cljs.core.truth_(temp__5804__auto___54509)){
var error__38259__auto___54510 = temp__5804__auto___54509;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54510], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53664_54498,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54503,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54510], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53667;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53679_54513 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53680_54514 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53681_54515 = output_schema53663_54497;
var G__53682_54516 = cljs.core.deref(output_checker53666_54500);
var G__53683_54517 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53679_54513,G__53680_54514,G__53681_54515,G__53682_54516,G__53683_54517) : schema.core.fn_validator.call(null,G__53679_54513,G__53680_54514,G__53681_54515,G__53682_54516,G__53683_54517));
} else {
var temp__5804__auto___54518 = (function (){var fexpr__53684 = cljs.core.deref(output_checker53666_54500);
return (fexpr__53684.cljs$core$IFn$_invoke$arity$1 ? fexpr__53684.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53684.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54518)){
var error__38259__auto___54520 = temp__5804__auto___54518;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54520], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53663_54497,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54520], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema53663_54497,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53664_54498], null)));

var ufv___54522 = schema.utils.use_fn_validation;
var output_schema53685_54523 = schema.core.Any;
var input_schema53686_54524 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53687_54526 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53686_54524);
}),null));
var output_checker53688_54527 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53685_54523);
}),null));
var ret__40655__auto___54529 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__53689){
var validate__38257__auto__ = cljs.core.deref(ufv___54522);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54530 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53689], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53692_54532 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53693_54533 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53694_54534 = input_schema53686_54524;
var G__53695_54535 = cljs.core.deref(input_checker53687_54526);
var G__53696_54536 = args__38258__auto___54530;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53692_54532,G__53693_54533,G__53694_54534,G__53695_54535,G__53696_54536) : schema.core.fn_validator.call(null,G__53692_54532,G__53693_54533,G__53694_54534,G__53695_54535,G__53696_54536));
} else {
var temp__5804__auto___54539 = (function (){var fexpr__53701 = cljs.core.deref(input_checker53687_54526);
return (fexpr__53701.cljs$core$IFn$_invoke$arity$1 ? fexpr__53701.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54530) : fexpr__53701.call(null,args__38258__auto___54530));
})();
if(cljs.core.truth_(temp__5804__auto___54539)){
var error__38259__auto___54541 = temp__5804__auto___54539;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54541], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53686_54524,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54530,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54541], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53689;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53705_54545 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53706_54546 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53707_54547 = output_schema53685_54523;
var G__53708_54548 = cljs.core.deref(output_checker53688_54527);
var G__53709_54549 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53705_54545,G__53706_54546,G__53707_54547,G__53708_54548,G__53709_54549) : schema.core.fn_validator.call(null,G__53705_54545,G__53706_54546,G__53707_54547,G__53708_54548,G__53709_54549));
} else {
var temp__5804__auto___54552 = (function (){var fexpr__53710 = cljs.core.deref(output_checker53688_54527);
return (fexpr__53710.cljs$core$IFn$_invoke$arity$1 ? fexpr__53710.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53710.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54552)){
var error__38259__auto___54555 = temp__5804__auto___54552;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54555], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53685_54523,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54555], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema53685_54523,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53686_54524], null)));

var ufv___54557 = schema.utils.use_fn_validation;
var output_schema53713_54558 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53714_54559 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema53718_54560 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker53715_54561 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53714_54559);
}),null));
var output_checker53716_54562 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53713_54558);
}),null));
var input_checker53719_54563 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53718_54560);
}),null));
var output_checker53720_54564 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53713_54558);
}),null));
var ret__40655__auto___54567 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__53728 = arguments.length;
switch (G__53728) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__53717){
var validate__38257__auto__ = cljs.core.deref(ufv___54557);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54570 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53717], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53729_54571 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53730_54572 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53731_54573 = input_schema53714_54559;
var G__53732_54574 = cljs.core.deref(input_checker53715_54561);
var G__53733_54575 = args__38258__auto___54570;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53729_54571,G__53730_54572,G__53731_54573,G__53732_54574,G__53733_54575) : schema.core.fn_validator.call(null,G__53729_54571,G__53730_54572,G__53731_54573,G__53732_54574,G__53733_54575));
} else {
var temp__5804__auto___54576 = (function (){var fexpr__53734 = cljs.core.deref(input_checker53715_54561);
return (fexpr__53734.cljs$core$IFn$_invoke$arity$1 ? fexpr__53734.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54570) : fexpr__53734.call(null,args__38258__auto___54570));
})();
if(cljs.core.truth_(temp__5804__auto___54576)){
var error__38259__auto___54577 = temp__5804__auto___54576;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54577], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53714_54559,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54570,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54577], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53717;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53740_54582 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53741_54583 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53742_54584 = output_schema53713_54558;
var G__53743_54585 = cljs.core.deref(output_checker53716_54562);
var G__53744_54586 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53740_54582,G__53741_54583,G__53742_54584,G__53743_54585,G__53744_54586) : schema.core.fn_validator.call(null,G__53740_54582,G__53741_54583,G__53742_54584,G__53743_54585,G__53744_54586));
} else {
var temp__5804__auto___54587 = (function (){var fexpr__53745 = cljs.core.deref(output_checker53716_54562);
return (fexpr__53745.cljs$core$IFn$_invoke$arity$1 ? fexpr__53745.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53745.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54587)){
var error__38259__auto___54588 = temp__5804__auto___54587;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54588], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53713_54558,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54588], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53721,G__53722){
var validate__38257__auto__ = cljs.core.deref(ufv___54557);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54591 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53721,G__53722], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53746_54592 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53747_54593 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53748_54594 = input_schema53718_54560;
var G__53749_54595 = cljs.core.deref(input_checker53719_54563);
var G__53750_54596 = args__38258__auto___54591;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53746_54592,G__53747_54593,G__53748_54594,G__53749_54595,G__53750_54596) : schema.core.fn_validator.call(null,G__53746_54592,G__53747_54593,G__53748_54594,G__53749_54595,G__53750_54596));
} else {
var temp__5804__auto___54600 = (function (){var fexpr__53751 = cljs.core.deref(input_checker53719_54563);
return (fexpr__53751.cljs$core$IFn$_invoke$arity$1 ? fexpr__53751.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54591) : fexpr__53751.call(null,args__38258__auto___54591));
})();
if(cljs.core.truth_(temp__5804__auto___54600)){
var error__38259__auto___54602 = temp__5804__auto___54600;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54602], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53718_54560,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54591,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54602], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53721;
var field_kw_or_branch_i = G__53722;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53752_54604 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53753_54605 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53754_54606 = output_schema53713_54558;
var G__53755_54607 = cljs.core.deref(output_checker53720_54564);
var G__53756_54608 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53752_54604,G__53753_54605,G__53754_54606,G__53755_54607,G__53756_54608) : schema.core.fn_validator.call(null,G__53752_54604,G__53753_54605,G__53754_54606,G__53755_54607,G__53756_54608));
} else {
var temp__5804__auto___54610 = (function (){var fexpr__53757 = cljs.core.deref(output_checker53720_54564);
return (fexpr__53757.cljs$core$IFn$_invoke$arity$1 ? fexpr__53757.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53757.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54610)){
var error__38259__auto___54611 = temp__5804__auto___54610;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54611], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53713_54558,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54611], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema53713_54558,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53714_54559,input_schema53718_54560], null)));

var ufv___54614 = schema.utils.use_fn_validation;
var output_schema53758_54615 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema53759_54616 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema53764_54617 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker53760_54618 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53759_54616);
}),null));
var output_checker53761_54619 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53758_54615);
}),null));
var input_checker53765_54620 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53764_54617);
}),null));
var output_checker53766_54621 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53758_54615);
}),null));
var ret__40655__auto___54625 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__53778 = arguments.length;
switch (G__53778) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__53762,G__53763){
var validate__38257__auto__ = cljs.core.deref(ufv___54614);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54629 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53762,G__53763], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53779_54630 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53780_54631 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53781_54632 = input_schema53759_54616;
var G__53782_54633 = cljs.core.deref(input_checker53760_54618);
var G__53783_54634 = args__38258__auto___54629;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53779_54630,G__53780_54631,G__53781_54632,G__53782_54633,G__53783_54634) : schema.core.fn_validator.call(null,G__53779_54630,G__53780_54631,G__53781_54632,G__53782_54633,G__53783_54634));
} else {
var temp__5804__auto___54636 = (function (){var fexpr__53784 = cljs.core.deref(input_checker53760_54618);
return (fexpr__53784.cljs$core$IFn$_invoke$arity$1 ? fexpr__53784.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54629) : fexpr__53784.call(null,args__38258__auto___54629));
})();
if(cljs.core.truth_(temp__5804__auto___54636)){
var error__38259__auto___54639 = temp__5804__auto___54636;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54639], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53759_54616,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54629,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54639], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53762;
var path = G__53763;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53785_54642 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53786_54643 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53787_54644 = output_schema53758_54615;
var G__53788_54645 = cljs.core.deref(output_checker53761_54619);
var G__53789_54646 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53785_54642,G__53786_54643,G__53787_54644,G__53788_54645,G__53789_54646) : schema.core.fn_validator.call(null,G__53785_54642,G__53786_54643,G__53787_54644,G__53788_54645,G__53789_54646));
} else {
var temp__5804__auto___54649 = (function (){var fexpr__53792 = cljs.core.deref(output_checker53761_54619);
return (fexpr__53792.cljs$core$IFn$_invoke$arity$1 ? fexpr__53792.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53792.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54649)){
var error__38259__auto___54652 = temp__5804__auto___54649;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54652], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53758_54615,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54652], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__53767,G__53768,G__53769){
var validate__38257__auto__ = cljs.core.deref(ufv___54614);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54655 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53767,G__53768,G__53769], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53793_54657 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53794_54658 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53795_54659 = input_schema53764_54617;
var G__53796_54660 = cljs.core.deref(input_checker53765_54620);
var G__53797_54661 = args__38258__auto___54655;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53793_54657,G__53794_54658,G__53795_54659,G__53796_54660,G__53797_54661) : schema.core.fn_validator.call(null,G__53793_54657,G__53794_54658,G__53795_54659,G__53796_54660,G__53797_54661));
} else {
var temp__5804__auto___54662 = (function (){var fexpr__53802 = cljs.core.deref(input_checker53765_54620);
return (fexpr__53802.cljs$core$IFn$_invoke$arity$1 ? fexpr__53802.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54655) : fexpr__53802.call(null,args__38258__auto___54655));
})();
if(cljs.core.truth_(temp__5804__auto___54662)){
var error__38259__auto___54663 = temp__5804__auto___54662;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54663], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53764_54617,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54655,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54663], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53767;
var path = G__53768;
var G__53804 = G__53769;
var map__53805 = G__53804;
var map__53805__$1 = cljs.core.__destructure_map(map__53805);
var opts = map__53805__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53805__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__53804__$1 = G__53804;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__53806 = G__53804__$1;
var map__53806__$1 = cljs.core.__destructure_map(map__53806);
var opts__$1 = map__53806__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53806__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53810_54669 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53811_54670 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53812_54671 = output_schema53758_54615;
var G__53813_54672 = cljs.core.deref(output_checker53766_54621);
var G__53814_54673 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53810_54669,G__53811_54670,G__53812_54671,G__53813_54672,G__53814_54673) : schema.core.fn_validator.call(null,G__53810_54669,G__53811_54670,G__53812_54671,G__53813_54672,G__53814_54673));
} else {
var temp__5804__auto___54675 = (function (){var fexpr__53815 = cljs.core.deref(output_checker53766_54621);
return (fexpr__53815.cljs$core$IFn$_invoke$arity$1 ? fexpr__53815.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53815.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54675)){
var error__38259__auto___54676 = temp__5804__auto___54675;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54676], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53758_54615,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54676], null));
} else {
}
}
} else {
}

return o__38260__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema53758_54615,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53759_54616,input_schema53764_54617], null)));

var ufv___54683 = schema.utils.use_fn_validation;
var output_schema53818_54684 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema53819_54685 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53820_54686 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53819_54685);
}),null));
var output_checker53821_54687 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53818_54684);
}),null));
var ret__40655__auto___54688 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__53822){
var validate__38257__auto__ = cljs.core.deref(ufv___54683);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54690 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53822], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53823_54691 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53824_54692 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__53825_54693 = input_schema53819_54685;
var G__53826_54694 = cljs.core.deref(input_checker53820_54686);
var G__53827_54695 = args__38258__auto___54690;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53823_54691,G__53824_54692,G__53825_54693,G__53826_54694,G__53827_54695) : schema.core.fn_validator.call(null,G__53823_54691,G__53824_54692,G__53825_54693,G__53826_54694,G__53827_54695));
} else {
var temp__5804__auto___54696 = (function (){var fexpr__53830 = cljs.core.deref(input_checker53820_54686);
return (fexpr__53830.cljs$core$IFn$_invoke$arity$1 ? fexpr__53830.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54690) : fexpr__53830.call(null,args__38258__auto___54690));
})();
if(cljs.core.truth_(temp__5804__auto___54696)){
var error__38259__auto___54699 = temp__5804__auto___54696;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54699], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53819_54685,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54690,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54699], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var union_schema = G__53822;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53832_54705 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53833_54706 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__53834_54707 = output_schema53818_54684;
var G__53835_54708 = cljs.core.deref(output_checker53821_54687);
var G__53836_54709 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53832_54705,G__53833_54706,G__53834_54707,G__53835_54708,G__53836_54709) : schema.core.fn_validator.call(null,G__53832_54705,G__53833_54706,G__53834_54707,G__53835_54708,G__53836_54709));
} else {
var temp__5804__auto___54711 = (function (){var fexpr__53839 = cljs.core.deref(output_checker53821_54687);
return (fexpr__53839.cljs$core$IFn$_invoke$arity$1 ? fexpr__53839.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53839.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54711)){
var error__38259__auto___54712 = temp__5804__auto___54711;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54712], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53818_54684,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54712], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema53818_54684,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53819_54685], null)));

var ufv___54725 = schema.utils.use_fn_validation;
var output_schema53840_54726 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53841_54727 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53842_54728 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53841_54727);
}),null));
var output_checker53843_54729 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53840_54726);
}),null));
var ret__40655__auto___54737 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__53844,G__53845){
var validate__38257__auto__ = cljs.core.deref(ufv___54725);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54739 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53844,G__53845], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53848_54741 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53849_54742 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__53850_54743 = input_schema53841_54727;
var G__53851_54744 = cljs.core.deref(input_checker53842_54728);
var G__53852_54745 = args__38258__auto___54739;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53848_54741,G__53849_54742,G__53850_54743,G__53851_54744,G__53852_54745) : schema.core.fn_validator.call(null,G__53848_54741,G__53849_54742,G__53850_54743,G__53851_54744,G__53852_54745));
} else {
var temp__5804__auto___54748 = (function (){var fexpr__53853 = cljs.core.deref(input_checker53842_54728);
return (fexpr__53853.cljs$core$IFn$_invoke$arity$1 ? fexpr__53853.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54739) : fexpr__53853.call(null,args__38258__auto___54739));
})();
if(cljs.core.truth_(temp__5804__auto___54748)){
var error__38259__auto___54751 = temp__5804__auto___54748;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54751], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53841_54727,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54739,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54751], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var union_schema = G__53844;
var branch_index = G__53845;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53857_54761 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53858_54762 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__53859_54763 = output_schema53840_54726;
var G__53860_54764 = cljs.core.deref(output_checker53843_54729);
var G__53861_54765 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53857_54761,G__53858_54762,G__53859_54763,G__53860_54764,G__53861_54765) : schema.core.fn_validator.call(null,G__53857_54761,G__53858_54762,G__53859_54763,G__53860_54764,G__53861_54765));
} else {
var temp__5804__auto___54766 = (function (){var fexpr__53864 = cljs.core.deref(output_checker53843_54729);
return (fexpr__53864.cljs$core$IFn$_invoke$arity$1 ? fexpr__53864.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53864.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54766)){
var error__38259__auto___54768 = temp__5804__auto___54766;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54768], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53840_54726,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54768], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema53840_54726,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53841_54727], null)));

var ufv___54775 = schema.utils.use_fn_validation;
var output_schema53865_54776 = schema.core.Keyword;
var input_schema53866_54777 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53867_54778 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53866_54777);
}),null));
var output_checker53868_54779 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53865_54776);
}),null));
var ret__40655__auto___54782 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__53869){
var validate__38257__auto__ = cljs.core.deref(ufv___54775);
if(cljs.core.truth_(validate__38257__auto__)){
var args__38258__auto___54790 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53869], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53872_54791 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53873_54792 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__53874_54793 = input_schema53866_54777;
var G__53875_54794 = cljs.core.deref(input_checker53867_54778);
var G__53876_54795 = args__38258__auto___54790;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53872_54791,G__53873_54792,G__53874_54793,G__53875_54794,G__53876_54795) : schema.core.fn_validator.call(null,G__53872_54791,G__53873_54792,G__53874_54793,G__53875_54794,G__53876_54795));
} else {
var temp__5804__auto___54796 = (function (){var fexpr__53878 = cljs.core.deref(input_checker53867_54778);
return (fexpr__53878.cljs$core$IFn$_invoke$arity$1 ? fexpr__53878.cljs$core$IFn$_invoke$arity$1(args__38258__auto___54790) : fexpr__53878.call(null,args__38258__auto___54790));
})();
if(cljs.core.truth_(temp__5804__auto___54796)){
var error__38259__auto___54797 = temp__5804__auto___54796;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54797], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53866_54777,new cljs.core.Keyword(null,"value","value",305978217),args__38258__auto___54790,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54797], null));
} else {
}
}
} else {
}

var o__38260__auto__ = (function (){var schema__$1 = G__53869;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38257__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53885_54813 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53886_54814 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__53887_54815 = output_schema53865_54776;
var G__53888_54816 = cljs.core.deref(output_checker53868_54779);
var G__53889_54817 = o__38260__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53885_54813,G__53886_54814,G__53887_54815,G__53888_54816,G__53889_54817) : schema.core.fn_validator.call(null,G__53885_54813,G__53886_54814,G__53887_54815,G__53888_54816,G__53889_54817));
} else {
var temp__5804__auto___54822 = (function (){var fexpr__53890 = cljs.core.deref(output_checker53868_54779);
return (fexpr__53890.cljs$core$IFn$_invoke$arity$1 ? fexpr__53890.cljs$core$IFn$_invoke$arity$1(o__38260__auto__) : fexpr__53890.call(null,o__38260__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54822)){
var error__38259__auto___54823 = temp__5804__auto___54822;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38259__auto___54823], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53865_54776,new cljs.core.Keyword(null,"value","value",305978217),o__38260__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38259__auto___54823], null));
} else {
}
}
} else {
}

return o__38260__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema53865_54776,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53866_54777], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
