goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35538 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35538(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35541 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35541(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34382 = coll;
var G__34383 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34382,G__34383) : shadow.dom.lazy_native_coll_seq.call(null,G__34382,G__34383));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34415 = arguments.length;
switch (G__34415) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34424 = arguments.length;
switch (G__34424) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34434 = arguments.length;
switch (G__34434) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34442 = arguments.length;
switch (G__34442) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34451 = arguments.length;
switch (G__34451) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34481 = arguments.length;
switch (G__34481) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34505){if((e34505 instanceof Object)){
var e = e34505;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34505;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34513 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34514 = null;
var count__34515 = (0);
var i__34516 = (0);
while(true){
if((i__34516 < count__34515)){
var el = chunk__34514.cljs$core$IIndexed$_nth$arity$2(null,i__34516);
var handler_35570__$1 = ((function (seq__34513,chunk__34514,count__34515,i__34516,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34513,chunk__34514,count__34515,i__34516,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35570__$1);


var G__35571 = seq__34513;
var G__35572 = chunk__34514;
var G__35573 = count__34515;
var G__35574 = (i__34516 + (1));
seq__34513 = G__35571;
chunk__34514 = G__35572;
count__34515 = G__35573;
i__34516 = G__35574;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34513);
if(temp__5804__auto__){
var seq__34513__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34513__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34513__$1);
var G__35575 = cljs.core.chunk_rest(seq__34513__$1);
var G__35576 = c__5568__auto__;
var G__35577 = cljs.core.count(c__5568__auto__);
var G__35578 = (0);
seq__34513 = G__35575;
chunk__34514 = G__35576;
count__34515 = G__35577;
i__34516 = G__35578;
continue;
} else {
var el = cljs.core.first(seq__34513__$1);
var handler_35579__$1 = ((function (seq__34513,chunk__34514,count__34515,i__34516,el,seq__34513__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34513,chunk__34514,count__34515,i__34516,el,seq__34513__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35579__$1);


var G__35580 = cljs.core.next(seq__34513__$1);
var G__35581 = null;
var G__35582 = (0);
var G__35583 = (0);
seq__34513 = G__35580;
chunk__34514 = G__35581;
count__34515 = G__35582;
i__34516 = G__35583;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34546 = arguments.length;
switch (G__34546) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34557 = cljs.core.seq(events);
var chunk__34558 = null;
var count__34559 = (0);
var i__34560 = (0);
while(true){
if((i__34560 < count__34559)){
var vec__34574 = chunk__34558.cljs$core$IIndexed$_nth$arity$2(null,i__34560);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34574,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34574,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35585 = seq__34557;
var G__35586 = chunk__34558;
var G__35587 = count__34559;
var G__35588 = (i__34560 + (1));
seq__34557 = G__35585;
chunk__34558 = G__35586;
count__34559 = G__35587;
i__34560 = G__35588;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34557);
if(temp__5804__auto__){
var seq__34557__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34557__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34557__$1);
var G__35589 = cljs.core.chunk_rest(seq__34557__$1);
var G__35590 = c__5568__auto__;
var G__35591 = cljs.core.count(c__5568__auto__);
var G__35592 = (0);
seq__34557 = G__35589;
chunk__34558 = G__35590;
count__34559 = G__35591;
i__34560 = G__35592;
continue;
} else {
var vec__34583 = cljs.core.first(seq__34557__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34583,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34583,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35593 = cljs.core.next(seq__34557__$1);
var G__35594 = null;
var G__35595 = (0);
var G__35596 = (0);
seq__34557 = G__35593;
chunk__34558 = G__35594;
count__34559 = G__35595;
i__34560 = G__35596;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34588 = cljs.core.seq(styles);
var chunk__34589 = null;
var count__34590 = (0);
var i__34591 = (0);
while(true){
if((i__34591 < count__34590)){
var vec__34611 = chunk__34589.cljs$core$IIndexed$_nth$arity$2(null,i__34591);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34611,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34611,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35598 = seq__34588;
var G__35599 = chunk__34589;
var G__35600 = count__34590;
var G__35601 = (i__34591 + (1));
seq__34588 = G__35598;
chunk__34589 = G__35599;
count__34590 = G__35600;
i__34591 = G__35601;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34588);
if(temp__5804__auto__){
var seq__34588__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34588__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34588__$1);
var G__35602 = cljs.core.chunk_rest(seq__34588__$1);
var G__35603 = c__5568__auto__;
var G__35604 = cljs.core.count(c__5568__auto__);
var G__35605 = (0);
seq__34588 = G__35602;
chunk__34589 = G__35603;
count__34590 = G__35604;
i__34591 = G__35605;
continue;
} else {
var vec__34620 = cljs.core.first(seq__34588__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34620,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34620,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35607 = cljs.core.next(seq__34588__$1);
var G__35608 = null;
var G__35609 = (0);
var G__35610 = (0);
seq__34588 = G__35607;
chunk__34589 = G__35608;
count__34590 = G__35609;
i__34591 = G__35610;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34633_35612 = key;
var G__34633_35613__$1 = (((G__34633_35612 instanceof cljs.core.Keyword))?G__34633_35612.fqn:null);
switch (G__34633_35613__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35620 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35620,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35620,"aria-");
}
})())){
el.setAttribute(ks_35620,value);
} else {
(el[ks_35620] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34674){
var map__34676 = p__34674;
var map__34676__$1 = cljs.core.__destructure_map(map__34676);
var props = map__34676__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34676__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34678 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34678,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34678,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34678,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34682 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34682,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34682;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34691 = arguments.length;
switch (G__34691) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34701){
var vec__34703 = p__34701;
var seq__34704 = cljs.core.seq(vec__34703);
var first__34705 = cljs.core.first(seq__34704);
var seq__34704__$1 = cljs.core.next(seq__34704);
var nn = first__34705;
var first__34705__$1 = cljs.core.first(seq__34704__$1);
var seq__34704__$2 = cljs.core.next(seq__34704__$1);
var np = first__34705__$1;
var nc = seq__34704__$2;
var node = vec__34703;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34707 = nn;
var G__34708 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34707,G__34708) : create_fn.call(null,G__34707,G__34708));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34711 = nn;
var G__34712 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34711,G__34712) : create_fn.call(null,G__34711,G__34712));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34714 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34714,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34714,(1),null);
var seq__34717_35654 = cljs.core.seq(node_children);
var chunk__34718_35655 = null;
var count__34719_35656 = (0);
var i__34720_35657 = (0);
while(true){
if((i__34720_35657 < count__34719_35656)){
var child_struct_35658 = chunk__34718_35655.cljs$core$IIndexed$_nth$arity$2(null,i__34720_35657);
var children_35659 = shadow.dom.dom_node(child_struct_35658);
if(cljs.core.seq_QMARK_(children_35659)){
var seq__34792_35661 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35659));
var chunk__34794_35662 = null;
var count__34795_35663 = (0);
var i__34796_35664 = (0);
while(true){
if((i__34796_35664 < count__34795_35663)){
var child_35670 = chunk__34794_35662.cljs$core$IIndexed$_nth$arity$2(null,i__34796_35664);
if(cljs.core.truth_(child_35670)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35670);


var G__35672 = seq__34792_35661;
var G__35673 = chunk__34794_35662;
var G__35674 = count__34795_35663;
var G__35675 = (i__34796_35664 + (1));
seq__34792_35661 = G__35672;
chunk__34794_35662 = G__35673;
count__34795_35663 = G__35674;
i__34796_35664 = G__35675;
continue;
} else {
var G__35676 = seq__34792_35661;
var G__35677 = chunk__34794_35662;
var G__35678 = count__34795_35663;
var G__35679 = (i__34796_35664 + (1));
seq__34792_35661 = G__35676;
chunk__34794_35662 = G__35677;
count__34795_35663 = G__35678;
i__34796_35664 = G__35679;
continue;
}
} else {
var temp__5804__auto___35680 = cljs.core.seq(seq__34792_35661);
if(temp__5804__auto___35680){
var seq__34792_35681__$1 = temp__5804__auto___35680;
if(cljs.core.chunked_seq_QMARK_(seq__34792_35681__$1)){
var c__5568__auto___35682 = cljs.core.chunk_first(seq__34792_35681__$1);
var G__35683 = cljs.core.chunk_rest(seq__34792_35681__$1);
var G__35684 = c__5568__auto___35682;
var G__35685 = cljs.core.count(c__5568__auto___35682);
var G__35686 = (0);
seq__34792_35661 = G__35683;
chunk__34794_35662 = G__35684;
count__34795_35663 = G__35685;
i__34796_35664 = G__35686;
continue;
} else {
var child_35691 = cljs.core.first(seq__34792_35681__$1);
if(cljs.core.truth_(child_35691)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35691);


var G__35692 = cljs.core.next(seq__34792_35681__$1);
var G__35693 = null;
var G__35694 = (0);
var G__35695 = (0);
seq__34792_35661 = G__35692;
chunk__34794_35662 = G__35693;
count__34795_35663 = G__35694;
i__34796_35664 = G__35695;
continue;
} else {
var G__35698 = cljs.core.next(seq__34792_35681__$1);
var G__35699 = null;
var G__35700 = (0);
var G__35701 = (0);
seq__34792_35661 = G__35698;
chunk__34794_35662 = G__35699;
count__34795_35663 = G__35700;
i__34796_35664 = G__35701;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35659);
}


var G__35702 = seq__34717_35654;
var G__35703 = chunk__34718_35655;
var G__35704 = count__34719_35656;
var G__35705 = (i__34720_35657 + (1));
seq__34717_35654 = G__35702;
chunk__34718_35655 = G__35703;
count__34719_35656 = G__35704;
i__34720_35657 = G__35705;
continue;
} else {
var temp__5804__auto___35706 = cljs.core.seq(seq__34717_35654);
if(temp__5804__auto___35706){
var seq__34717_35707__$1 = temp__5804__auto___35706;
if(cljs.core.chunked_seq_QMARK_(seq__34717_35707__$1)){
var c__5568__auto___35708 = cljs.core.chunk_first(seq__34717_35707__$1);
var G__35709 = cljs.core.chunk_rest(seq__34717_35707__$1);
var G__35710 = c__5568__auto___35708;
var G__35711 = cljs.core.count(c__5568__auto___35708);
var G__35712 = (0);
seq__34717_35654 = G__35709;
chunk__34718_35655 = G__35710;
count__34719_35656 = G__35711;
i__34720_35657 = G__35712;
continue;
} else {
var child_struct_35713 = cljs.core.first(seq__34717_35707__$1);
var children_35715 = shadow.dom.dom_node(child_struct_35713);
if(cljs.core.seq_QMARK_(children_35715)){
var seq__34822_35717 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35715));
var chunk__34824_35718 = null;
var count__34825_35719 = (0);
var i__34826_35720 = (0);
while(true){
if((i__34826_35720 < count__34825_35719)){
var child_35726 = chunk__34824_35718.cljs$core$IIndexed$_nth$arity$2(null,i__34826_35720);
if(cljs.core.truth_(child_35726)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35726);


var G__35727 = seq__34822_35717;
var G__35728 = chunk__34824_35718;
var G__35729 = count__34825_35719;
var G__35730 = (i__34826_35720 + (1));
seq__34822_35717 = G__35727;
chunk__34824_35718 = G__35728;
count__34825_35719 = G__35729;
i__34826_35720 = G__35730;
continue;
} else {
var G__35732 = seq__34822_35717;
var G__35733 = chunk__34824_35718;
var G__35734 = count__34825_35719;
var G__35735 = (i__34826_35720 + (1));
seq__34822_35717 = G__35732;
chunk__34824_35718 = G__35733;
count__34825_35719 = G__35734;
i__34826_35720 = G__35735;
continue;
}
} else {
var temp__5804__auto___35736__$1 = cljs.core.seq(seq__34822_35717);
if(temp__5804__auto___35736__$1){
var seq__34822_35738__$1 = temp__5804__auto___35736__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34822_35738__$1)){
var c__5568__auto___35739 = cljs.core.chunk_first(seq__34822_35738__$1);
var G__35741 = cljs.core.chunk_rest(seq__34822_35738__$1);
var G__35742 = c__5568__auto___35739;
var G__35743 = cljs.core.count(c__5568__auto___35739);
var G__35744 = (0);
seq__34822_35717 = G__35741;
chunk__34824_35718 = G__35742;
count__34825_35719 = G__35743;
i__34826_35720 = G__35744;
continue;
} else {
var child_35749 = cljs.core.first(seq__34822_35738__$1);
if(cljs.core.truth_(child_35749)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35749);


var G__35752 = cljs.core.next(seq__34822_35738__$1);
var G__35753 = null;
var G__35754 = (0);
var G__35755 = (0);
seq__34822_35717 = G__35752;
chunk__34824_35718 = G__35753;
count__34825_35719 = G__35754;
i__34826_35720 = G__35755;
continue;
} else {
var G__35756 = cljs.core.next(seq__34822_35738__$1);
var G__35757 = null;
var G__35758 = (0);
var G__35759 = (0);
seq__34822_35717 = G__35756;
chunk__34824_35718 = G__35757;
count__34825_35719 = G__35758;
i__34826_35720 = G__35759;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35715);
}


var G__35760 = cljs.core.next(seq__34717_35707__$1);
var G__35761 = null;
var G__35762 = (0);
var G__35763 = (0);
seq__34717_35654 = G__35760;
chunk__34718_35655 = G__35761;
count__34719_35656 = G__35762;
i__34720_35657 = G__35763;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34852 = cljs.core.seq(node);
var chunk__34853 = null;
var count__34854 = (0);
var i__34855 = (0);
while(true){
if((i__34855 < count__34854)){
var n = chunk__34853.cljs$core$IIndexed$_nth$arity$2(null,i__34855);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35773 = seq__34852;
var G__35774 = chunk__34853;
var G__35775 = count__34854;
var G__35776 = (i__34855 + (1));
seq__34852 = G__35773;
chunk__34853 = G__35774;
count__34854 = G__35775;
i__34855 = G__35776;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34852);
if(temp__5804__auto__){
var seq__34852__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34852__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34852__$1);
var G__35778 = cljs.core.chunk_rest(seq__34852__$1);
var G__35779 = c__5568__auto__;
var G__35780 = cljs.core.count(c__5568__auto__);
var G__35781 = (0);
seq__34852 = G__35778;
chunk__34853 = G__35779;
count__34854 = G__35780;
i__34855 = G__35781;
continue;
} else {
var n = cljs.core.first(seq__34852__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35782 = cljs.core.next(seq__34852__$1);
var G__35783 = null;
var G__35784 = (0);
var G__35785 = (0);
seq__34852 = G__35782;
chunk__34853 = G__35783;
count__34854 = G__35784;
i__34855 = G__35785;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34881 = arguments.length;
switch (G__34881) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34890 = arguments.length;
switch (G__34890) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34907 = arguments.length;
switch (G__34907) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35800 = arguments.length;
var i__5770__auto___35801 = (0);
while(true){
if((i__5770__auto___35801 < len__5769__auto___35800)){
args__5775__auto__.push((arguments[i__5770__auto___35801]));

var G__35803 = (i__5770__auto___35801 + (1));
i__5770__auto___35801 = G__35803;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34944_35806 = cljs.core.seq(nodes);
var chunk__34945_35807 = null;
var count__34946_35808 = (0);
var i__34947_35809 = (0);
while(true){
if((i__34947_35809 < count__34946_35808)){
var node_35811 = chunk__34945_35807.cljs$core$IIndexed$_nth$arity$2(null,i__34947_35809);
fragment.appendChild(shadow.dom._to_dom(node_35811));


var G__35812 = seq__34944_35806;
var G__35813 = chunk__34945_35807;
var G__35814 = count__34946_35808;
var G__35815 = (i__34947_35809 + (1));
seq__34944_35806 = G__35812;
chunk__34945_35807 = G__35813;
count__34946_35808 = G__35814;
i__34947_35809 = G__35815;
continue;
} else {
var temp__5804__auto___35816 = cljs.core.seq(seq__34944_35806);
if(temp__5804__auto___35816){
var seq__34944_35819__$1 = temp__5804__auto___35816;
if(cljs.core.chunked_seq_QMARK_(seq__34944_35819__$1)){
var c__5568__auto___35821 = cljs.core.chunk_first(seq__34944_35819__$1);
var G__35823 = cljs.core.chunk_rest(seq__34944_35819__$1);
var G__35824 = c__5568__auto___35821;
var G__35825 = cljs.core.count(c__5568__auto___35821);
var G__35826 = (0);
seq__34944_35806 = G__35823;
chunk__34945_35807 = G__35824;
count__34946_35808 = G__35825;
i__34947_35809 = G__35826;
continue;
} else {
var node_35828 = cljs.core.first(seq__34944_35819__$1);
fragment.appendChild(shadow.dom._to_dom(node_35828));


var G__35830 = cljs.core.next(seq__34944_35819__$1);
var G__35831 = null;
var G__35832 = (0);
var G__35833 = (0);
seq__34944_35806 = G__35830;
chunk__34945_35807 = G__35831;
count__34946_35808 = G__35832;
i__34947_35809 = G__35833;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34934){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34934));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34964_35839 = cljs.core.seq(scripts);
var chunk__34965_35840 = null;
var count__34966_35841 = (0);
var i__34967_35842 = (0);
while(true){
if((i__34967_35842 < count__34966_35841)){
var vec__34988_35843 = chunk__34965_35840.cljs$core$IIndexed$_nth$arity$2(null,i__34967_35842);
var script_tag_35844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34988_35843,(0),null);
var script_body_35845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34988_35843,(1),null);
eval(script_body_35845);


var G__35846 = seq__34964_35839;
var G__35847 = chunk__34965_35840;
var G__35848 = count__34966_35841;
var G__35849 = (i__34967_35842 + (1));
seq__34964_35839 = G__35846;
chunk__34965_35840 = G__35847;
count__34966_35841 = G__35848;
i__34967_35842 = G__35849;
continue;
} else {
var temp__5804__auto___35850 = cljs.core.seq(seq__34964_35839);
if(temp__5804__auto___35850){
var seq__34964_35852__$1 = temp__5804__auto___35850;
if(cljs.core.chunked_seq_QMARK_(seq__34964_35852__$1)){
var c__5568__auto___35854 = cljs.core.chunk_first(seq__34964_35852__$1);
var G__35855 = cljs.core.chunk_rest(seq__34964_35852__$1);
var G__35856 = c__5568__auto___35854;
var G__35857 = cljs.core.count(c__5568__auto___35854);
var G__35858 = (0);
seq__34964_35839 = G__35855;
chunk__34965_35840 = G__35856;
count__34966_35841 = G__35857;
i__34967_35842 = G__35858;
continue;
} else {
var vec__34993_35859 = cljs.core.first(seq__34964_35852__$1);
var script_tag_35860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34993_35859,(0),null);
var script_body_35861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34993_35859,(1),null);
eval(script_body_35861);


var G__35863 = cljs.core.next(seq__34964_35852__$1);
var G__35864 = null;
var G__35865 = (0);
var G__35866 = (0);
seq__34964_35839 = G__35863;
chunk__34965_35840 = G__35864;
count__34966_35841 = G__35865;
i__34967_35842 = G__35866;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__34998){
var vec__35000 = p__34998;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35000,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35000,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35017 = arguments.length;
switch (G__35017) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35051 = cljs.core.seq(style_keys);
var chunk__35052 = null;
var count__35053 = (0);
var i__35054 = (0);
while(true){
if((i__35054 < count__35053)){
var it = chunk__35052.cljs$core$IIndexed$_nth$arity$2(null,i__35054);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35886 = seq__35051;
var G__35887 = chunk__35052;
var G__35888 = count__35053;
var G__35889 = (i__35054 + (1));
seq__35051 = G__35886;
chunk__35052 = G__35887;
count__35053 = G__35888;
i__35054 = G__35889;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__35051);
if(temp__5804__auto__){
var seq__35051__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35051__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__35051__$1);
var G__35897 = cljs.core.chunk_rest(seq__35051__$1);
var G__35898 = c__5568__auto__;
var G__35899 = cljs.core.count(c__5568__auto__);
var G__35900 = (0);
seq__35051 = G__35897;
chunk__35052 = G__35898;
count__35053 = G__35899;
i__35054 = G__35900;
continue;
} else {
var it = cljs.core.first(seq__35051__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35914 = cljs.core.next(seq__35051__$1);
var G__35915 = null;
var G__35916 = (0);
var G__35917 = (0);
seq__35051 = G__35914;
chunk__35052 = G__35915;
count__35053 = G__35916;
i__35054 = G__35917;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35069,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35083 = k35069;
var G__35083__$1 = (((G__35083 instanceof cljs.core.Keyword))?G__35083.fqn:null);
switch (G__35083__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35069,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35084){
var vec__35085 = p__35084;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35085,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35085,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35068){
var self__ = this;
var G__35068__$1 = this;
return (new cljs.core.RecordIter((0),G__35068__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35070,other35071){
var self__ = this;
var this35070__$1 = this;
return (((!((other35071 == null)))) && ((((this35070__$1.constructor === other35071.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35070__$1.x,other35071.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35070__$1.y,other35071.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35070__$1.__extmap,other35071.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35069){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35110 = k35069;
var G__35110__$1 = (((G__35110 instanceof cljs.core.Keyword))?G__35110.fqn:null);
switch (G__35110__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35069);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35068){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35112 = cljs.core.keyword_identical_QMARK_;
var expr__35113 = k__5352__auto__;
if(cljs.core.truth_((pred__35112.cljs$core$IFn$_invoke$arity$2 ? pred__35112.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35113) : pred__35112.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35113)))){
return (new shadow.dom.Coordinate(G__35068,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35112.cljs$core$IFn$_invoke$arity$2 ? pred__35112.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35113) : pred__35112.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35113)))){
return (new shadow.dom.Coordinate(self__.x,G__35068,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35068),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35068){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35068,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35075){
var extmap__5385__auto__ = (function (){var G__35120 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35075,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__35075)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35120);
} else {
return G__35120;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35075),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35075),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35136,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35154 = k35136;
var G__35154__$1 = (((G__35154 instanceof cljs.core.Keyword))?G__35154.fqn:null);
switch (G__35154__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35136,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35155){
var vec__35156 = p__35155;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35156,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35156,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35135){
var self__ = this;
var G__35135__$1 = this;
return (new cljs.core.RecordIter((0),G__35135__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35137,other35138){
var self__ = this;
var this35137__$1 = this;
return (((!((other35138 == null)))) && ((((this35137__$1.constructor === other35138.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35137__$1.w,other35138.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35137__$1.h,other35138.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35137__$1.__extmap,other35138.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35136){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35194 = k35136;
var G__35194__$1 = (((G__35194 instanceof cljs.core.Keyword))?G__35194.fqn:null);
switch (G__35194__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35136);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35135){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35197 = cljs.core.keyword_identical_QMARK_;
var expr__35198 = k__5352__auto__;
if(cljs.core.truth_((pred__35197.cljs$core$IFn$_invoke$arity$2 ? pred__35197.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35198) : pred__35197.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35198)))){
return (new shadow.dom.Size(G__35135,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35197.cljs$core$IFn$_invoke$arity$2 ? pred__35197.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35198) : pred__35197.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35198)))){
return (new shadow.dom.Size(self__.w,G__35135,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35135),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35135){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35135,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35148){
var extmap__5385__auto__ = (function (){var G__35233 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35148,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35148)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35233);
} else {
return G__35233;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35148),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35148),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__36115 = (i + (1));
var G__36116 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__36115;
ret = G__36116;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35272){
var vec__35273 = p__35272;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35273,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35273,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35280 = arguments.length;
switch (G__35280) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__36211 = ps;
var G__36212 = (i + (1));
el__$1 = G__36211;
i = G__36212;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35353 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35353,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35353,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35353,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35357_36223 = cljs.core.seq(props);
var chunk__35358_36224 = null;
var count__35359_36225 = (0);
var i__35360_36226 = (0);
while(true){
if((i__35360_36226 < count__35359_36225)){
var vec__35375_36229 = chunk__35358_36224.cljs$core$IIndexed$_nth$arity$2(null,i__35360_36226);
var k_36230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35375_36229,(0),null);
var v_36231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35375_36229,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_36230);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36230),v_36231);


var G__36232 = seq__35357_36223;
var G__36233 = chunk__35358_36224;
var G__36234 = count__35359_36225;
var G__36235 = (i__35360_36226 + (1));
seq__35357_36223 = G__36232;
chunk__35358_36224 = G__36233;
count__35359_36225 = G__36234;
i__35360_36226 = G__36235;
continue;
} else {
var temp__5804__auto___36236 = cljs.core.seq(seq__35357_36223);
if(temp__5804__auto___36236){
var seq__35357_36237__$1 = temp__5804__auto___36236;
if(cljs.core.chunked_seq_QMARK_(seq__35357_36237__$1)){
var c__5568__auto___36238 = cljs.core.chunk_first(seq__35357_36237__$1);
var G__36239 = cljs.core.chunk_rest(seq__35357_36237__$1);
var G__36240 = c__5568__auto___36238;
var G__36241 = cljs.core.count(c__5568__auto___36238);
var G__36242 = (0);
seq__35357_36223 = G__36239;
chunk__35358_36224 = G__36240;
count__35359_36225 = G__36241;
i__35360_36226 = G__36242;
continue;
} else {
var vec__35385_36243 = cljs.core.first(seq__35357_36237__$1);
var k_36244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35385_36243,(0),null);
var v_36245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35385_36243,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_36244);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36244),v_36245);


var G__36248 = cljs.core.next(seq__35357_36237__$1);
var G__36249 = null;
var G__36250 = (0);
var G__36251 = (0);
seq__35357_36223 = G__36248;
chunk__35358_36224 = G__36249;
count__35359_36225 = G__36250;
i__35360_36226 = G__36251;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35397 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35397,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35397,(1),null);
var seq__35400_36254 = cljs.core.seq(node_children);
var chunk__35402_36255 = null;
var count__35403_36256 = (0);
var i__35404_36257 = (0);
while(true){
if((i__35404_36257 < count__35403_36256)){
var child_struct_36258 = chunk__35402_36255.cljs$core$IIndexed$_nth$arity$2(null,i__35404_36257);
if((!((child_struct_36258 == null)))){
if(typeof child_struct_36258 === 'string'){
var text_36262 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36262),child_struct_36258].join(''));
} else {
var children_36263 = shadow.dom.svg_node(child_struct_36258);
if(cljs.core.seq_QMARK_(children_36263)){
var seq__35444_36264 = cljs.core.seq(children_36263);
var chunk__35446_36265 = null;
var count__35447_36266 = (0);
var i__35448_36267 = (0);
while(true){
if((i__35448_36267 < count__35447_36266)){
var child_36269 = chunk__35446_36265.cljs$core$IIndexed$_nth$arity$2(null,i__35448_36267);
if(cljs.core.truth_(child_36269)){
node.appendChild(child_36269);


var G__36270 = seq__35444_36264;
var G__36271 = chunk__35446_36265;
var G__36272 = count__35447_36266;
var G__36273 = (i__35448_36267 + (1));
seq__35444_36264 = G__36270;
chunk__35446_36265 = G__36271;
count__35447_36266 = G__36272;
i__35448_36267 = G__36273;
continue;
} else {
var G__36274 = seq__35444_36264;
var G__36275 = chunk__35446_36265;
var G__36276 = count__35447_36266;
var G__36277 = (i__35448_36267 + (1));
seq__35444_36264 = G__36274;
chunk__35446_36265 = G__36275;
count__35447_36266 = G__36276;
i__35448_36267 = G__36277;
continue;
}
} else {
var temp__5804__auto___36278 = cljs.core.seq(seq__35444_36264);
if(temp__5804__auto___36278){
var seq__35444_36279__$1 = temp__5804__auto___36278;
if(cljs.core.chunked_seq_QMARK_(seq__35444_36279__$1)){
var c__5568__auto___36280 = cljs.core.chunk_first(seq__35444_36279__$1);
var G__36281 = cljs.core.chunk_rest(seq__35444_36279__$1);
var G__36282 = c__5568__auto___36280;
var G__36283 = cljs.core.count(c__5568__auto___36280);
var G__36284 = (0);
seq__35444_36264 = G__36281;
chunk__35446_36265 = G__36282;
count__35447_36266 = G__36283;
i__35448_36267 = G__36284;
continue;
} else {
var child_36290 = cljs.core.first(seq__35444_36279__$1);
if(cljs.core.truth_(child_36290)){
node.appendChild(child_36290);


var G__36291 = cljs.core.next(seq__35444_36279__$1);
var G__36292 = null;
var G__36293 = (0);
var G__36294 = (0);
seq__35444_36264 = G__36291;
chunk__35446_36265 = G__36292;
count__35447_36266 = G__36293;
i__35448_36267 = G__36294;
continue;
} else {
var G__36295 = cljs.core.next(seq__35444_36279__$1);
var G__36296 = null;
var G__36297 = (0);
var G__36298 = (0);
seq__35444_36264 = G__36295;
chunk__35446_36265 = G__36296;
count__35447_36266 = G__36297;
i__35448_36267 = G__36298;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36263);
}
}


var G__36299 = seq__35400_36254;
var G__36300 = chunk__35402_36255;
var G__36301 = count__35403_36256;
var G__36302 = (i__35404_36257 + (1));
seq__35400_36254 = G__36299;
chunk__35402_36255 = G__36300;
count__35403_36256 = G__36301;
i__35404_36257 = G__36302;
continue;
} else {
var G__36303 = seq__35400_36254;
var G__36304 = chunk__35402_36255;
var G__36305 = count__35403_36256;
var G__36306 = (i__35404_36257 + (1));
seq__35400_36254 = G__36303;
chunk__35402_36255 = G__36304;
count__35403_36256 = G__36305;
i__35404_36257 = G__36306;
continue;
}
} else {
var temp__5804__auto___36307 = cljs.core.seq(seq__35400_36254);
if(temp__5804__auto___36307){
var seq__35400_36315__$1 = temp__5804__auto___36307;
if(cljs.core.chunked_seq_QMARK_(seq__35400_36315__$1)){
var c__5568__auto___36316 = cljs.core.chunk_first(seq__35400_36315__$1);
var G__36317 = cljs.core.chunk_rest(seq__35400_36315__$1);
var G__36318 = c__5568__auto___36316;
var G__36319 = cljs.core.count(c__5568__auto___36316);
var G__36320 = (0);
seq__35400_36254 = G__36317;
chunk__35402_36255 = G__36318;
count__35403_36256 = G__36319;
i__35404_36257 = G__36320;
continue;
} else {
var child_struct_36321 = cljs.core.first(seq__35400_36315__$1);
if((!((child_struct_36321 == null)))){
if(typeof child_struct_36321 === 'string'){
var text_36322 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36322),child_struct_36321].join(''));
} else {
var children_36324 = shadow.dom.svg_node(child_struct_36321);
if(cljs.core.seq_QMARK_(children_36324)){
var seq__35463_36325 = cljs.core.seq(children_36324);
var chunk__35465_36326 = null;
var count__35466_36327 = (0);
var i__35467_36328 = (0);
while(true){
if((i__35467_36328 < count__35466_36327)){
var child_36329 = chunk__35465_36326.cljs$core$IIndexed$_nth$arity$2(null,i__35467_36328);
if(cljs.core.truth_(child_36329)){
node.appendChild(child_36329);


var G__36330 = seq__35463_36325;
var G__36331 = chunk__35465_36326;
var G__36332 = count__35466_36327;
var G__36333 = (i__35467_36328 + (1));
seq__35463_36325 = G__36330;
chunk__35465_36326 = G__36331;
count__35466_36327 = G__36332;
i__35467_36328 = G__36333;
continue;
} else {
var G__36334 = seq__35463_36325;
var G__36335 = chunk__35465_36326;
var G__36336 = count__35466_36327;
var G__36337 = (i__35467_36328 + (1));
seq__35463_36325 = G__36334;
chunk__35465_36326 = G__36335;
count__35466_36327 = G__36336;
i__35467_36328 = G__36337;
continue;
}
} else {
var temp__5804__auto___36338__$1 = cljs.core.seq(seq__35463_36325);
if(temp__5804__auto___36338__$1){
var seq__35463_36339__$1 = temp__5804__auto___36338__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35463_36339__$1)){
var c__5568__auto___36341 = cljs.core.chunk_first(seq__35463_36339__$1);
var G__36342 = cljs.core.chunk_rest(seq__35463_36339__$1);
var G__36343 = c__5568__auto___36341;
var G__36344 = cljs.core.count(c__5568__auto___36341);
var G__36345 = (0);
seq__35463_36325 = G__36342;
chunk__35465_36326 = G__36343;
count__35466_36327 = G__36344;
i__35467_36328 = G__36345;
continue;
} else {
var child_36346 = cljs.core.first(seq__35463_36339__$1);
if(cljs.core.truth_(child_36346)){
node.appendChild(child_36346);


var G__36349 = cljs.core.next(seq__35463_36339__$1);
var G__36350 = null;
var G__36351 = (0);
var G__36352 = (0);
seq__35463_36325 = G__36349;
chunk__35465_36326 = G__36350;
count__35466_36327 = G__36351;
i__35467_36328 = G__36352;
continue;
} else {
var G__36356 = cljs.core.next(seq__35463_36339__$1);
var G__36357 = null;
var G__36358 = (0);
var G__36359 = (0);
seq__35463_36325 = G__36356;
chunk__35465_36326 = G__36357;
count__35466_36327 = G__36358;
i__35467_36328 = G__36359;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36324);
}
}


var G__36360 = cljs.core.next(seq__35400_36315__$1);
var G__36361 = null;
var G__36362 = (0);
var G__36363 = (0);
seq__35400_36254 = G__36360;
chunk__35402_36255 = G__36361;
count__35403_36256 = G__36362;
i__35404_36257 = G__36363;
continue;
} else {
var G__36367 = cljs.core.next(seq__35400_36315__$1);
var G__36368 = null;
var G__36369 = (0);
var G__36370 = (0);
seq__35400_36254 = G__36367;
chunk__35402_36255 = G__36368;
count__35403_36256 = G__36369;
i__35404_36257 = G__36370;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36371 = arguments.length;
var i__5770__auto___36372 = (0);
while(true){
if((i__5770__auto___36372 < len__5769__auto___36371)){
args__5775__auto__.push((arguments[i__5770__auto___36372]));

var G__36374 = (i__5770__auto___36372 + (1));
i__5770__auto___36372 = G__36374;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35477){
var G__35478 = cljs.core.first(seq35477);
var seq35477__$1 = cljs.core.next(seq35477);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35478,seq35477__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35492 = arguments.length;
switch (G__35492) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__31116__auto___36387 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31117__auto__ = (function (){var switch__30553__auto__ = (function (state_35505){
var state_val_35506 = (state_35505[(1)]);
if((state_val_35506 === (1))){
var state_35505__$1 = state_35505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35505__$1,(2),once_or_cleanup);
} else {
if((state_val_35506 === (2))){
var inst_35501 = (state_35505[(2)]);
var inst_35502 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35505__$1 = (function (){var statearr_35508 = state_35505;
(statearr_35508[(7)] = inst_35501);

return statearr_35508;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35505__$1,inst_35502);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__30554__auto__ = null;
var shadow$dom$state_machine__30554__auto____0 = (function (){
var statearr_35511 = [null,null,null,null,null,null,null,null];
(statearr_35511[(0)] = shadow$dom$state_machine__30554__auto__);

(statearr_35511[(1)] = (1));

return statearr_35511;
});
var shadow$dom$state_machine__30554__auto____1 = (function (state_35505){
while(true){
var ret_value__30555__auto__ = (function (){try{while(true){
var result__30556__auto__ = switch__30553__auto__(state_35505);
if(cljs.core.keyword_identical_QMARK_(result__30556__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30556__auto__;
}
break;
}
}catch (e35512){var ex__30557__auto__ = e35512;
var statearr_35513_36388 = state_35505;
(statearr_35513_36388[(2)] = ex__30557__auto__);


if(cljs.core.seq((state_35505[(4)]))){
var statearr_35514_36390 = state_35505;
(statearr_35514_36390[(1)] = cljs.core.first((state_35505[(4)])));

} else {
throw ex__30557__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30555__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36391 = state_35505;
state_35505 = G__36391;
continue;
} else {
return ret_value__30555__auto__;
}
break;
}
});
shadow$dom$state_machine__30554__auto__ = function(state_35505){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__30554__auto____0.call(this);
case 1:
return shadow$dom$state_machine__30554__auto____1.call(this,state_35505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__30554__auto____0;
shadow$dom$state_machine__30554__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__30554__auto____1;
return shadow$dom$state_machine__30554__auto__;
})()
})();
var state__31118__auto__ = (function (){var statearr_35517 = f__31117__auto__();
(statearr_35517[(6)] = c__31116__auto___36387);

return statearr_35517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31118__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
