goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__56179){
var vec__56180 = p__56179;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56180,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56180,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__56184 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__56184__$1 = (((G__56184 instanceof cljs.core.Keyword))?G__56184.fqn:null);
switch (G__56184__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__56191 = (function (){
var seq__56193 = cljs.core.seq(vars__$1);
var chunk__56194 = null;
var count__56195 = (0);
var i__56196 = (0);
while(true){
if((i__56196 < count__56195)){
var v = chunk__56194.cljs$core$IIndexed$_nth$arity$2(null,i__56196);
var temp__5804__auto___56336 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56336)){
var t_56337 = temp__5804__auto___56336;
var G__56204_56338 = ((function (seq__56193,chunk__56194,count__56195,i__56196,t_56337,temp__5804__auto___56336,v,each_fixture_fn,G__56184,G__56184__$1,env,once_fixtures,each_fixtures,vec__56180,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56337)));
});})(seq__56193,chunk__56194,count__56195,i__56196,t_56337,temp__5804__auto___56336,v,each_fixture_fn,G__56184,G__56184__$1,env,once_fixtures,each_fixtures,vec__56180,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56204_56338) : each_fixture_fn.call(null,G__56204_56338));
} else {
}


var G__56339 = seq__56193;
var G__56340 = chunk__56194;
var G__56341 = count__56195;
var G__56342 = (i__56196 + (1));
seq__56193 = G__56339;
chunk__56194 = G__56340;
count__56195 = G__56341;
i__56196 = G__56342;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__56193);
if(temp__5804__auto__){
var seq__56193__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56193__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__56193__$1);
var G__56346 = cljs.core.chunk_rest(seq__56193__$1);
var G__56347 = c__5568__auto__;
var G__56348 = cljs.core.count(c__5568__auto__);
var G__56349 = (0);
seq__56193 = G__56346;
chunk__56194 = G__56347;
count__56195 = G__56348;
i__56196 = G__56349;
continue;
} else {
var v = cljs.core.first(seq__56193__$1);
var temp__5804__auto___56351__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56351__$1)){
var t_56352 = temp__5804__auto___56351__$1;
var G__56205_56353 = ((function (seq__56193,chunk__56194,count__56195,i__56196,t_56352,temp__5804__auto___56351__$1,v,seq__56193__$1,temp__5804__auto__,each_fixture_fn,G__56184,G__56184__$1,env,once_fixtures,each_fixtures,vec__56180,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56352)));
});})(seq__56193,chunk__56194,count__56195,i__56196,t_56352,temp__5804__auto___56351__$1,v,seq__56193__$1,temp__5804__auto__,each_fixture_fn,G__56184,G__56184__$1,env,once_fixtures,each_fixtures,vec__56180,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56205_56353) : each_fixture_fn.call(null,G__56205_56353));
} else {
}


var G__56354 = cljs.core.next(seq__56193__$1);
var G__56355 = null;
var G__56356 = (0);
var G__56357 = (0);
seq__56193 = G__56354;
chunk__56194 = G__56355;
count__56195 = G__56356;
i__56196 = G__56357;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__56190 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__56190.cljs$core$IFn$_invoke$arity$1 ? fexpr__56190.cljs$core$IFn$_invoke$arity$1(G__56191) : fexpr__56190.call(null,G__56191));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56184__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__56178_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56178_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__56207 = shadow.test.env.get_test_ns_info(ns);
var map__56207__$1 = cljs.core.__destructure_map(map__56207);
var test_ns = map__56207__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56207__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__56210,vars){
var map__56212 = p__56210;
var map__56212__$1 = cljs.core.__destructure_map(map__56212);
var env = map__56212__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56212__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__56214_56359 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__56216_56360 = null;
var count__56217_56361 = (0);
var i__56218_56362 = (0);
while(true){
if((i__56218_56362 < count__56217_56361)){
var vec__56244_56366 = chunk__56216_56360.cljs$core$IIndexed$_nth$arity$2(null,i__56218_56362);
var test_ns_56367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56244_56366,(0),null);
var ns_info_56368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56244_56366,(1),null);
var map__56249_56369 = ns_info_56368;
var map__56249_56370__$1 = cljs.core.__destructure_map(map__56249_56369);
var fixtures_56371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56249_56370__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56373 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56371);
if(cljs.core.truth_(temp__5804__auto___56373)){
var fix_56374 = temp__5804__auto___56373;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56367,fix_56374], 0));
} else {
}

var temp__5804__auto___56375 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56371);
if(cljs.core.truth_(temp__5804__auto___56375)){
var fix_56376 = temp__5804__auto___56375;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56367,fix_56376], 0));
} else {
}


var G__56377 = seq__56214_56359;
var G__56378 = chunk__56216_56360;
var G__56379 = count__56217_56361;
var G__56380 = (i__56218_56362 + (1));
seq__56214_56359 = G__56377;
chunk__56216_56360 = G__56378;
count__56217_56361 = G__56379;
i__56218_56362 = G__56380;
continue;
} else {
var temp__5804__auto___56381 = cljs.core.seq(seq__56214_56359);
if(temp__5804__auto___56381){
var seq__56214_56382__$1 = temp__5804__auto___56381;
if(cljs.core.chunked_seq_QMARK_(seq__56214_56382__$1)){
var c__5568__auto___56383 = cljs.core.chunk_first(seq__56214_56382__$1);
var G__56384 = cljs.core.chunk_rest(seq__56214_56382__$1);
var G__56385 = c__5568__auto___56383;
var G__56386 = cljs.core.count(c__5568__auto___56383);
var G__56387 = (0);
seq__56214_56359 = G__56384;
chunk__56216_56360 = G__56385;
count__56217_56361 = G__56386;
i__56218_56362 = G__56387;
continue;
} else {
var vec__56259_56388 = cljs.core.first(seq__56214_56382__$1);
var test_ns_56389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56259_56388,(0),null);
var ns_info_56390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56259_56388,(1),null);
var map__56264_56392 = ns_info_56390;
var map__56264_56393__$1 = cljs.core.__destructure_map(map__56264_56392);
var fixtures_56394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56264_56393__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56395__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56394);
if(cljs.core.truth_(temp__5804__auto___56395__$1)){
var fix_56396 = temp__5804__auto___56395__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56389,fix_56396], 0));
} else {
}

var temp__5804__auto___56397__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56394);
if(cljs.core.truth_(temp__5804__auto___56397__$1)){
var fix_56398 = temp__5804__auto___56397__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56389,fix_56398], 0));
} else {
}


var G__56399 = cljs.core.next(seq__56214_56382__$1);
var G__56400 = null;
var G__56401 = (0);
var G__56402 = (0);
seq__56214_56359 = G__56399;
chunk__56216_56360 = G__56400;
count__56217_56361 = G__56401;
i__56218_56362 = G__56402;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56209_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56209_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__56282 = cljs.test.get_current_env();
var map__56282__$1 = cljs.core.__destructure_map(map__56282);
var env = map__56282__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56282__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56282__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__56285 = arguments.length;
switch (G__56285) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__56297 = arguments.length;
switch (G__56297) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__56302 = shadow.test.env.get_test_ns_info(ns);
var map__56302__$1 = cljs.core.__destructure_map(map__56302);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56302__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__56311 = arguments.length;
switch (G__56311) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56309_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56309_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__56317 = arguments.length;
switch (G__56317) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56315_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56315_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
