goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31315 = arguments.length;
switch (G__31315) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31318 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31318 = (function (f,blockable,meta31319){
this.f = f;
this.blockable = blockable;
this.meta31319 = meta31319;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31318.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31320,meta31319__$1){
var self__ = this;
var _31320__$1 = this;
return (new cljs.core.async.t_cljs$core$async31318(self__.f,self__.blockable,meta31319__$1));
}));

(cljs.core.async.t_cljs$core$async31318.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31320){
var self__ = this;
var _31320__$1 = this;
return self__.meta31319;
}));

(cljs.core.async.t_cljs$core$async31318.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31318.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31318.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async31318.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async31318.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31319","meta31319",2083017388,null)], null);
}));

(cljs.core.async.t_cljs$core$async31318.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31318.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31318");

(cljs.core.async.t_cljs$core$async31318.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31318");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31318.
 */
cljs.core.async.__GT_t_cljs$core$async31318 = (function cljs$core$async$__GT_t_cljs$core$async31318(f__$1,blockable__$1,meta31319){
return (new cljs.core.async.t_cljs$core$async31318(f__$1,blockable__$1,meta31319));
});

}

return (new cljs.core.async.t_cljs$core$async31318(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31334 = arguments.length;
switch (G__31334) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31355 = arguments.length;
switch (G__31355) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31372 = arguments.length;
switch (G__31372) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34672 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34672) : fn1.call(null,val_34672));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34672) : fn1.call(null,val_34672));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31383 = arguments.length;
switch (G__31383) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___34674 = n;
var x_34675 = (0);
while(true){
if((x_34675 < n__5636__auto___34674)){
(a[x_34675] = x_34675);

var G__34676 = (x_34675 + (1));
x_34675 = G__34676;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31387 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31387 = (function (flag,meta31388){
this.flag = flag;
this.meta31388 = meta31388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31389,meta31388__$1){
var self__ = this;
var _31389__$1 = this;
return (new cljs.core.async.t_cljs$core$async31387(self__.flag,meta31388__$1));
}));

(cljs.core.async.t_cljs$core$async31387.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31389){
var self__ = this;
var _31389__$1 = this;
return self__.meta31388;
}));

(cljs.core.async.t_cljs$core$async31387.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31387.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31387.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31387.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async31387.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31388","meta31388",-1769290576,null)], null);
}));

(cljs.core.async.t_cljs$core$async31387.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31387.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31387");

(cljs.core.async.t_cljs$core$async31387.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31387");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31387.
 */
cljs.core.async.__GT_t_cljs$core$async31387 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31387(flag__$1,meta31388){
return (new cljs.core.async.t_cljs$core$async31387(flag__$1,meta31388));
});

}

return (new cljs.core.async.t_cljs$core$async31387(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31390 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31390 = (function (flag,cb,meta31391){
this.flag = flag;
this.cb = cb;
this.meta31391 = meta31391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31392,meta31391__$1){
var self__ = this;
var _31392__$1 = this;
return (new cljs.core.async.t_cljs$core$async31390(self__.flag,self__.cb,meta31391__$1));
}));

(cljs.core.async.t_cljs$core$async31390.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31392){
var self__ = this;
var _31392__$1 = this;
return self__.meta31391;
}));

(cljs.core.async.t_cljs$core$async31390.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31390.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31390.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31390.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async31390.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31391","meta31391",-2059744173,null)], null);
}));

(cljs.core.async.t_cljs$core$async31390.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31390");

(cljs.core.async.t_cljs$core$async31390.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31390");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31390.
 */
cljs.core.async.__GT_t_cljs$core$async31390 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31390(flag__$1,cb__$1,meta31391){
return (new cljs.core.async.t_cljs$core$async31390(flag__$1,cb__$1,meta31391));
});

}

return (new cljs.core.async.t_cljs$core$async31390(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31409_SHARP_){
var G__31420 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31409_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31420) : fret.call(null,G__31420));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31410_SHARP_){
var G__31425 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31410_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31425) : fret.call(null,G__31425));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34683 = (i + (1));
i = G__34683;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34687 = arguments.length;
var i__5770__auto___34688 = (0);
while(true){
if((i__5770__auto___34688 < len__5769__auto___34687)){
args__5775__auto__.push((arguments[i__5770__auto___34688]));

var G__34690 = (i__5770__auto___34688 + (1));
i__5770__auto___34688 = G__34690;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31446){
var map__31447 = p__31446;
var map__31447__$1 = cljs.core.__destructure_map(map__31447);
var opts = map__31447__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31441){
var G__31442 = cljs.core.first(seq31441);
var seq31441__$1 = cljs.core.next(seq31441);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31442,seq31441__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31468 = arguments.length;
switch (G__31468) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31231__auto___34694 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_31529){
var state_val_31530 = (state_31529[(1)]);
if((state_val_31530 === (7))){
var inst_31525 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
var statearr_31531_34696 = state_31529__$1;
(statearr_31531_34696[(2)] = inst_31525);

(statearr_31531_34696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (1))){
var state_31529__$1 = state_31529;
var statearr_31538_34697 = state_31529__$1;
(statearr_31538_34697[(2)] = null);

(statearr_31538_34697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (4))){
var inst_31504 = (state_31529[(7)]);
var inst_31504__$1 = (state_31529[(2)]);
var inst_31506 = (inst_31504__$1 == null);
var state_31529__$1 = (function (){var statearr_31544 = state_31529;
(statearr_31544[(7)] = inst_31504__$1);

return statearr_31544;
})();
if(cljs.core.truth_(inst_31506)){
var statearr_31545_34700 = state_31529__$1;
(statearr_31545_34700[(1)] = (5));

} else {
var statearr_31547_34701 = state_31529__$1;
(statearr_31547_34701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (13))){
var state_31529__$1 = state_31529;
var statearr_31548_34703 = state_31529__$1;
(statearr_31548_34703[(2)] = null);

(statearr_31548_34703[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (6))){
var inst_31504 = (state_31529[(7)]);
var state_31529__$1 = state_31529;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31529__$1,(11),to,inst_31504);
} else {
if((state_val_31530 === (3))){
var inst_31527 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31529__$1,inst_31527);
} else {
if((state_val_31530 === (12))){
var state_31529__$1 = state_31529;
var statearr_31556_34704 = state_31529__$1;
(statearr_31556_34704[(2)] = null);

(statearr_31556_34704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (2))){
var state_31529__$1 = state_31529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31529__$1,(4),from);
} else {
if((state_val_31530 === (11))){
var inst_31515 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
if(cljs.core.truth_(inst_31515)){
var statearr_31557_34705 = state_31529__$1;
(statearr_31557_34705[(1)] = (12));

} else {
var statearr_31558_34706 = state_31529__$1;
(statearr_31558_34706[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (9))){
var state_31529__$1 = state_31529;
var statearr_31562_34707 = state_31529__$1;
(statearr_31562_34707[(2)] = null);

(statearr_31562_34707[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (5))){
var state_31529__$1 = state_31529;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31567_34710 = state_31529__$1;
(statearr_31567_34710[(1)] = (8));

} else {
var statearr_31568_34711 = state_31529__$1;
(statearr_31568_34711[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (14))){
var inst_31523 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
var statearr_31571_34712 = state_31529__$1;
(statearr_31571_34712[(2)] = inst_31523);

(statearr_31571_34712[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (10))){
var inst_31512 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
var statearr_31572_34713 = state_31529__$1;
(statearr_31572_34713[(2)] = inst_31512);

(statearr_31572_34713[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31530 === (8))){
var inst_31509 = cljs.core.async.close_BANG_(to);
var state_31529__$1 = state_31529;
var statearr_31573_34715 = state_31529__$1;
(statearr_31573_34715[(2)] = inst_31509);

(statearr_31573_34715[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_31574 = [null,null,null,null,null,null,null,null];
(statearr_31574[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_31574[(1)] = (1));

return statearr_31574;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_31529){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_31529);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e31575){var ex__30669__auto__ = e31575;
var statearr_31576_34720 = state_31529;
(statearr_31576_34720[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_31529[(4)]))){
var statearr_31577_34721 = state_31529;
(statearr_31577_34721[(1)] = cljs.core.first((state_31529[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34722 = state_31529;
state_31529 = G__34722;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_31529){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_31529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_31578 = f__31232__auto__();
(statearr_31578[(6)] = c__31231__auto___34694);

return statearr_31578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__31605){
var vec__31608 = p__31605;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31608,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31608,(1),null);
var job = vec__31608;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__31231__auto___34723 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_31625){
var state_val_31626 = (state_31625[(1)]);
if((state_val_31626 === (1))){
var state_31625__$1 = state_31625;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31625__$1,(2),res,v);
} else {
if((state_val_31626 === (2))){
var inst_31622 = (state_31625[(2)]);
var inst_31623 = cljs.core.async.close_BANG_(res);
var state_31625__$1 = (function (){var statearr_31631 = state_31625;
(statearr_31631[(7)] = inst_31622);

return statearr_31631;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31625__$1,inst_31623);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0 = (function (){
var statearr_31632 = [null,null,null,null,null,null,null,null];
(statearr_31632[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__);

(statearr_31632[(1)] = (1));

return statearr_31632;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1 = (function (state_31625){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_31625);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e31633){var ex__30669__auto__ = e31633;
var statearr_31634_34728 = state_31625;
(statearr_31634_34728[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_31625[(4)]))){
var statearr_31635_34729 = state_31625;
(statearr_31635_34729[(1)] = cljs.core.first((state_31625[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34730 = state_31625;
state_31625 = G__34730;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = function(state_31625){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1.call(this,state_31625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_31637 = f__31232__auto__();
(statearr_31637[(6)] = c__31231__auto___34723);

return statearr_31637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31644){
var vec__31645 = p__31644;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31645,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31645,(1),null);
var job = vec__31645;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___34731 = n;
var __34732 = (0);
while(true){
if((__34732 < n__5636__auto___34731)){
var G__31650_34733 = type;
var G__31650_34734__$1 = (((G__31650_34733 instanceof cljs.core.Keyword))?G__31650_34733.fqn:null);
switch (G__31650_34734__$1) {
case "compute":
var c__31231__auto___34736 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34732,c__31231__auto___34736,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async){
return (function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = ((function (__34732,c__31231__auto___34736,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async){
return (function (state_31663){
var state_val_31664 = (state_31663[(1)]);
if((state_val_31664 === (1))){
var state_31663__$1 = state_31663;
var statearr_31669_34737 = state_31663__$1;
(statearr_31669_34737[(2)] = null);

(statearr_31669_34737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31664 === (2))){
var state_31663__$1 = state_31663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31663__$1,(4),jobs);
} else {
if((state_val_31664 === (3))){
var inst_31661 = (state_31663[(2)]);
var state_31663__$1 = state_31663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31663__$1,inst_31661);
} else {
if((state_val_31664 === (4))){
var inst_31653 = (state_31663[(2)]);
var inst_31654 = process__$1(inst_31653);
var state_31663__$1 = state_31663;
if(cljs.core.truth_(inst_31654)){
var statearr_31670_34738 = state_31663__$1;
(statearr_31670_34738[(1)] = (5));

} else {
var statearr_31671_34739 = state_31663__$1;
(statearr_31671_34739[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31664 === (5))){
var state_31663__$1 = state_31663;
var statearr_31672_34740 = state_31663__$1;
(statearr_31672_34740[(2)] = null);

(statearr_31672_34740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31664 === (6))){
var state_31663__$1 = state_31663;
var statearr_31673_34741 = state_31663__$1;
(statearr_31673_34741[(2)] = null);

(statearr_31673_34741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31664 === (7))){
var inst_31659 = (state_31663[(2)]);
var state_31663__$1 = state_31663;
var statearr_31674_34743 = state_31663__$1;
(statearr_31674_34743[(2)] = inst_31659);

(statearr_31674_34743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34732,c__31231__auto___34736,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async))
;
return ((function (__34732,switch__30665__auto__,c__31231__auto___34736,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0 = (function (){
var statearr_31675 = [null,null,null,null,null,null,null];
(statearr_31675[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__);

(statearr_31675[(1)] = (1));

return statearr_31675;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1 = (function (state_31663){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_31663);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e31676){var ex__30669__auto__ = e31676;
var statearr_31677_34745 = state_31663;
(statearr_31677_34745[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_31663[(4)]))){
var statearr_31678_34746 = state_31663;
(statearr_31678_34746[(1)] = cljs.core.first((state_31663[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34747 = state_31663;
state_31663 = G__34747;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = function(state_31663){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1.call(this,state_31663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__;
})()
;})(__34732,switch__30665__auto__,c__31231__auto___34736,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async))
})();
var state__31233__auto__ = (function (){var statearr_31680 = f__31232__auto__();
(statearr_31680[(6)] = c__31231__auto___34736);

return statearr_31680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
});})(__34732,c__31231__auto___34736,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async))
);


break;
case "async":
var c__31231__auto___34748 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34732,c__31231__auto___34748,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async){
return (function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = ((function (__34732,c__31231__auto___34748,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async){
return (function (state_31693){
var state_val_31694 = (state_31693[(1)]);
if((state_val_31694 === (1))){
var state_31693__$1 = state_31693;
var statearr_31695_34763 = state_31693__$1;
(statearr_31695_34763[(2)] = null);

(statearr_31695_34763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31694 === (2))){
var state_31693__$1 = state_31693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31693__$1,(4),jobs);
} else {
if((state_val_31694 === (3))){
var inst_31691 = (state_31693[(2)]);
var state_31693__$1 = state_31693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31693__$1,inst_31691);
} else {
if((state_val_31694 === (4))){
var inst_31683 = (state_31693[(2)]);
var inst_31684 = async(inst_31683);
var state_31693__$1 = state_31693;
if(cljs.core.truth_(inst_31684)){
var statearr_31696_34770 = state_31693__$1;
(statearr_31696_34770[(1)] = (5));

} else {
var statearr_31697_34771 = state_31693__$1;
(statearr_31697_34771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31694 === (5))){
var state_31693__$1 = state_31693;
var statearr_31698_34772 = state_31693__$1;
(statearr_31698_34772[(2)] = null);

(statearr_31698_34772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31694 === (6))){
var state_31693__$1 = state_31693;
var statearr_31768_34773 = state_31693__$1;
(statearr_31768_34773[(2)] = null);

(statearr_31768_34773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31694 === (7))){
var inst_31689 = (state_31693[(2)]);
var state_31693__$1 = state_31693;
var statearr_31769_34774 = state_31693__$1;
(statearr_31769_34774[(2)] = inst_31689);

(statearr_31769_34774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34732,c__31231__auto___34748,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async))
;
return ((function (__34732,switch__30665__auto__,c__31231__auto___34748,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0 = (function (){
var statearr_31792 = [null,null,null,null,null,null,null];
(statearr_31792[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__);

(statearr_31792[(1)] = (1));

return statearr_31792;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1 = (function (state_31693){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_31693);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e31803){var ex__30669__auto__ = e31803;
var statearr_31804_34783 = state_31693;
(statearr_31804_34783[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_31693[(4)]))){
var statearr_31805_34784 = state_31693;
(statearr_31805_34784[(1)] = cljs.core.first((state_31693[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34791 = state_31693;
state_31693 = G__34791;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = function(state_31693){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1.call(this,state_31693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__;
})()
;})(__34732,switch__30665__auto__,c__31231__auto___34748,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async))
})();
var state__31233__auto__ = (function (){var statearr_31813 = f__31232__auto__();
(statearr_31813[(6)] = c__31231__auto___34748);

return statearr_31813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
});})(__34732,c__31231__auto___34748,G__31650_34733,G__31650_34734__$1,n__5636__auto___34731,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31650_34734__$1)].join('')));

}

var G__34798 = (__34732 + (1));
__34732 = G__34798;
continue;
} else {
}
break;
}

var c__31231__auto___34799 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_31868){
var state_val_31870 = (state_31868[(1)]);
if((state_val_31870 === (7))){
var inst_31861 = (state_31868[(2)]);
var state_31868__$1 = state_31868;
var statearr_31880_34801 = state_31868__$1;
(statearr_31880_34801[(2)] = inst_31861);

(statearr_31880_34801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (1))){
var state_31868__$1 = state_31868;
var statearr_31885_34802 = state_31868__$1;
(statearr_31885_34802[(2)] = null);

(statearr_31885_34802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (4))){
var inst_31833 = (state_31868[(7)]);
var inst_31833__$1 = (state_31868[(2)]);
var inst_31836 = (inst_31833__$1 == null);
var state_31868__$1 = (function (){var statearr_31886 = state_31868;
(statearr_31886[(7)] = inst_31833__$1);

return statearr_31886;
})();
if(cljs.core.truth_(inst_31836)){
var statearr_31888_34803 = state_31868__$1;
(statearr_31888_34803[(1)] = (5));

} else {
var statearr_31889_34804 = state_31868__$1;
(statearr_31889_34804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (6))){
var inst_31833 = (state_31868[(7)]);
var inst_31840 = (state_31868[(8)]);
var inst_31840__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31848 = [inst_31833,inst_31840__$1];
var inst_31849 = (new cljs.core.PersistentVector(null,2,(5),inst_31845,inst_31848,null));
var state_31868__$1 = (function (){var statearr_31891 = state_31868;
(statearr_31891[(8)] = inst_31840__$1);

return statearr_31891;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31868__$1,(8),jobs,inst_31849);
} else {
if((state_val_31870 === (3))){
var inst_31863 = (state_31868[(2)]);
var state_31868__$1 = state_31868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31868__$1,inst_31863);
} else {
if((state_val_31870 === (2))){
var state_31868__$1 = state_31868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31868__$1,(4),from);
} else {
if((state_val_31870 === (9))){
var inst_31854 = (state_31868[(2)]);
var state_31868__$1 = (function (){var statearr_31892 = state_31868;
(statearr_31892[(9)] = inst_31854);

return statearr_31892;
})();
var statearr_31893_34809 = state_31868__$1;
(statearr_31893_34809[(2)] = null);

(statearr_31893_34809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (5))){
var inst_31838 = cljs.core.async.close_BANG_(jobs);
var state_31868__$1 = state_31868;
var statearr_31898_34811 = state_31868__$1;
(statearr_31898_34811[(2)] = inst_31838);

(statearr_31898_34811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (8))){
var inst_31840 = (state_31868[(8)]);
var inst_31852 = (state_31868[(2)]);
var state_31868__$1 = (function (){var statearr_31899 = state_31868;
(statearr_31899[(10)] = inst_31852);

return statearr_31899;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31868__$1,(9),results,inst_31840);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0 = (function (){
var statearr_31900 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31900[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__);

(statearr_31900[(1)] = (1));

return statearr_31900;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1 = (function (state_31868){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_31868);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e31901){var ex__30669__auto__ = e31901;
var statearr_31902_34814 = state_31868;
(statearr_31902_34814[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_31868[(4)]))){
var statearr_31903_34815 = state_31868;
(statearr_31903_34815[(1)] = cljs.core.first((state_31868[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34816 = state_31868;
state_31868 = G__34816;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = function(state_31868){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1.call(this,state_31868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_31912 = f__31232__auto__();
(statearr_31912[(6)] = c__31231__auto___34799);

return statearr_31912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


var c__31231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_31961){
var state_val_31962 = (state_31961[(1)]);
if((state_val_31962 === (7))){
var inst_31955 = (state_31961[(2)]);
var state_31961__$1 = state_31961;
var statearr_31964_34821 = state_31961__$1;
(statearr_31964_34821[(2)] = inst_31955);

(statearr_31964_34821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (20))){
var state_31961__$1 = state_31961;
var statearr_31965_34823 = state_31961__$1;
(statearr_31965_34823[(2)] = null);

(statearr_31965_34823[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (1))){
var state_31961__$1 = state_31961;
var statearr_31966_34824 = state_31961__$1;
(statearr_31966_34824[(2)] = null);

(statearr_31966_34824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (4))){
var inst_31920 = (state_31961[(7)]);
var inst_31920__$1 = (state_31961[(2)]);
var inst_31921 = (inst_31920__$1 == null);
var state_31961__$1 = (function (){var statearr_31967 = state_31961;
(statearr_31967[(7)] = inst_31920__$1);

return statearr_31967;
})();
if(cljs.core.truth_(inst_31921)){
var statearr_31968_34825 = state_31961__$1;
(statearr_31968_34825[(1)] = (5));

} else {
var statearr_31969_34826 = state_31961__$1;
(statearr_31969_34826[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (15))){
var inst_31936 = (state_31961[(8)]);
var state_31961__$1 = state_31961;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31961__$1,(18),to,inst_31936);
} else {
if((state_val_31962 === (21))){
var inst_31950 = (state_31961[(2)]);
var state_31961__$1 = state_31961;
var statearr_31970_34827 = state_31961__$1;
(statearr_31970_34827[(2)] = inst_31950);

(statearr_31970_34827[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (13))){
var inst_31952 = (state_31961[(2)]);
var state_31961__$1 = (function (){var statearr_31971 = state_31961;
(statearr_31971[(9)] = inst_31952);

return statearr_31971;
})();
var statearr_31972_34828 = state_31961__$1;
(statearr_31972_34828[(2)] = null);

(statearr_31972_34828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (6))){
var inst_31920 = (state_31961[(7)]);
var state_31961__$1 = state_31961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31961__$1,(11),inst_31920);
} else {
if((state_val_31962 === (17))){
var inst_31945 = (state_31961[(2)]);
var state_31961__$1 = state_31961;
if(cljs.core.truth_(inst_31945)){
var statearr_31973_34830 = state_31961__$1;
(statearr_31973_34830[(1)] = (19));

} else {
var statearr_31974_34831 = state_31961__$1;
(statearr_31974_34831[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (3))){
var inst_31957 = (state_31961[(2)]);
var state_31961__$1 = state_31961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31961__$1,inst_31957);
} else {
if((state_val_31962 === (12))){
var inst_31930 = (state_31961[(10)]);
var state_31961__$1 = state_31961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31961__$1,(14),inst_31930);
} else {
if((state_val_31962 === (2))){
var state_31961__$1 = state_31961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31961__$1,(4),results);
} else {
if((state_val_31962 === (19))){
var state_31961__$1 = state_31961;
var statearr_31976_34833 = state_31961__$1;
(statearr_31976_34833[(2)] = null);

(statearr_31976_34833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (11))){
var inst_31930 = (state_31961[(2)]);
var state_31961__$1 = (function (){var statearr_31977 = state_31961;
(statearr_31977[(10)] = inst_31930);

return statearr_31977;
})();
var statearr_31978_34834 = state_31961__$1;
(statearr_31978_34834[(2)] = null);

(statearr_31978_34834[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (9))){
var state_31961__$1 = state_31961;
var statearr_31980_34835 = state_31961__$1;
(statearr_31980_34835[(2)] = null);

(statearr_31980_34835[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (5))){
var state_31961__$1 = state_31961;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31981_34836 = state_31961__$1;
(statearr_31981_34836[(1)] = (8));

} else {
var statearr_31982_34837 = state_31961__$1;
(statearr_31982_34837[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (14))){
var inst_31936 = (state_31961[(8)]);
var inst_31939 = (state_31961[(11)]);
var inst_31936__$1 = (state_31961[(2)]);
var inst_31938 = (inst_31936__$1 == null);
var inst_31939__$1 = cljs.core.not(inst_31938);
var state_31961__$1 = (function (){var statearr_31983 = state_31961;
(statearr_31983[(8)] = inst_31936__$1);

(statearr_31983[(11)] = inst_31939__$1);

return statearr_31983;
})();
if(inst_31939__$1){
var statearr_31984_34838 = state_31961__$1;
(statearr_31984_34838[(1)] = (15));

} else {
var statearr_31986_34839 = state_31961__$1;
(statearr_31986_34839[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (16))){
var inst_31939 = (state_31961[(11)]);
var state_31961__$1 = state_31961;
var statearr_31988_34841 = state_31961__$1;
(statearr_31988_34841[(2)] = inst_31939);

(statearr_31988_34841[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (10))){
var inst_31927 = (state_31961[(2)]);
var state_31961__$1 = state_31961;
var statearr_31992_34843 = state_31961__$1;
(statearr_31992_34843[(2)] = inst_31927);

(statearr_31992_34843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (18))){
var inst_31942 = (state_31961[(2)]);
var state_31961__$1 = state_31961;
var statearr_31995_34844 = state_31961__$1;
(statearr_31995_34844[(2)] = inst_31942);

(statearr_31995_34844[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31962 === (8))){
var inst_31924 = cljs.core.async.close_BANG_(to);
var state_31961__$1 = state_31961;
var statearr_31998_34845 = state_31961__$1;
(statearr_31998_34845[(2)] = inst_31924);

(statearr_31998_34845[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0 = (function (){
var statearr_32003 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32003[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__);

(statearr_32003[(1)] = (1));

return statearr_32003;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1 = (function (state_31961){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_31961);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e32005){var ex__30669__auto__ = e32005;
var statearr_32007_34846 = state_31961;
(statearr_32007_34846[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_31961[(4)]))){
var statearr_32008_34847 = state_31961;
(statearr_32008_34847[(1)] = cljs.core.first((state_31961[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34848 = state_31961;
state_31961 = G__34848;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__ = function(state_31961){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1.call(this,state_31961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30666__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_32009 = f__31232__auto__();
(statearr_32009[(6)] = c__31231__auto__);

return statearr_32009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

return c__31231__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__32019 = arguments.length;
switch (G__32019) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__32032 = arguments.length;
switch (G__32032) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__32044 = arguments.length;
switch (G__32044) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__31231__auto___34855 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_32074){
var state_val_32075 = (state_32074[(1)]);
if((state_val_32075 === (7))){
var inst_32070 = (state_32074[(2)]);
var state_32074__$1 = state_32074;
var statearr_32088_34856 = state_32074__$1;
(statearr_32088_34856[(2)] = inst_32070);

(statearr_32088_34856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (1))){
var state_32074__$1 = state_32074;
var statearr_32091_34857 = state_32074__$1;
(statearr_32091_34857[(2)] = null);

(statearr_32091_34857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (4))){
var inst_32051 = (state_32074[(7)]);
var inst_32051__$1 = (state_32074[(2)]);
var inst_32052 = (inst_32051__$1 == null);
var state_32074__$1 = (function (){var statearr_32092 = state_32074;
(statearr_32092[(7)] = inst_32051__$1);

return statearr_32092;
})();
if(cljs.core.truth_(inst_32052)){
var statearr_32093_34858 = state_32074__$1;
(statearr_32093_34858[(1)] = (5));

} else {
var statearr_32094_34859 = state_32074__$1;
(statearr_32094_34859[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (13))){
var state_32074__$1 = state_32074;
var statearr_32095_34860 = state_32074__$1;
(statearr_32095_34860[(2)] = null);

(statearr_32095_34860[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (6))){
var inst_32051 = (state_32074[(7)]);
var inst_32057 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32051) : p.call(null,inst_32051));
var state_32074__$1 = state_32074;
if(cljs.core.truth_(inst_32057)){
var statearr_32096_34866 = state_32074__$1;
(statearr_32096_34866[(1)] = (9));

} else {
var statearr_32097_34868 = state_32074__$1;
(statearr_32097_34868[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (3))){
var inst_32072 = (state_32074[(2)]);
var state_32074__$1 = state_32074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32074__$1,inst_32072);
} else {
if((state_val_32075 === (12))){
var state_32074__$1 = state_32074;
var statearr_32098_34875 = state_32074__$1;
(statearr_32098_34875[(2)] = null);

(statearr_32098_34875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (2))){
var state_32074__$1 = state_32074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32074__$1,(4),ch);
} else {
if((state_val_32075 === (11))){
var inst_32051 = (state_32074[(7)]);
var inst_32061 = (state_32074[(2)]);
var state_32074__$1 = state_32074;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32074__$1,(8),inst_32061,inst_32051);
} else {
if((state_val_32075 === (9))){
var state_32074__$1 = state_32074;
var statearr_32099_34879 = state_32074__$1;
(statearr_32099_34879[(2)] = tc);

(statearr_32099_34879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (5))){
var inst_32054 = cljs.core.async.close_BANG_(tc);
var inst_32055 = cljs.core.async.close_BANG_(fc);
var state_32074__$1 = (function (){var statearr_32100 = state_32074;
(statearr_32100[(8)] = inst_32054);

return statearr_32100;
})();
var statearr_32101_34880 = state_32074__$1;
(statearr_32101_34880[(2)] = inst_32055);

(statearr_32101_34880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (14))){
var inst_32068 = (state_32074[(2)]);
var state_32074__$1 = state_32074;
var statearr_32104_34881 = state_32074__$1;
(statearr_32104_34881[(2)] = inst_32068);

(statearr_32104_34881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (10))){
var state_32074__$1 = state_32074;
var statearr_32106_34882 = state_32074__$1;
(statearr_32106_34882[(2)] = fc);

(statearr_32106_34882[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32075 === (8))){
var inst_32063 = (state_32074[(2)]);
var state_32074__$1 = state_32074;
if(cljs.core.truth_(inst_32063)){
var statearr_32107_34883 = state_32074__$1;
(statearr_32107_34883[(1)] = (12));

} else {
var statearr_32108_34884 = state_32074__$1;
(statearr_32108_34884[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_32109 = [null,null,null,null,null,null,null,null,null];
(statearr_32109[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_32109[(1)] = (1));

return statearr_32109;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_32074){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_32074);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e32118){var ex__30669__auto__ = e32118;
var statearr_32119_34885 = state_32074;
(statearr_32119_34885[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_32074[(4)]))){
var statearr_32120_34886 = state_32074;
(statearr_32120_34886[(1)] = cljs.core.first((state_32074[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34887 = state_32074;
state_32074 = G__34887;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_32074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_32074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_32121 = f__31232__auto__();
(statearr_32121[(6)] = c__31231__auto___34855);

return statearr_32121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_32162){
var state_val_32163 = (state_32162[(1)]);
if((state_val_32163 === (7))){
var inst_32156 = (state_32162[(2)]);
var state_32162__$1 = state_32162;
var statearr_32167_34888 = state_32162__$1;
(statearr_32167_34888[(2)] = inst_32156);

(statearr_32167_34888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (1))){
var inst_32131 = init;
var inst_32134 = inst_32131;
var state_32162__$1 = (function (){var statearr_32169 = state_32162;
(statearr_32169[(7)] = inst_32134);

return statearr_32169;
})();
var statearr_32171_34889 = state_32162__$1;
(statearr_32171_34889[(2)] = null);

(statearr_32171_34889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (4))){
var inst_32138 = (state_32162[(8)]);
var inst_32138__$1 = (state_32162[(2)]);
var inst_32142 = (inst_32138__$1 == null);
var state_32162__$1 = (function (){var statearr_32172 = state_32162;
(statearr_32172[(8)] = inst_32138__$1);

return statearr_32172;
})();
if(cljs.core.truth_(inst_32142)){
var statearr_32173_34892 = state_32162__$1;
(statearr_32173_34892[(1)] = (5));

} else {
var statearr_32174_34893 = state_32162__$1;
(statearr_32174_34893[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (6))){
var inst_32134 = (state_32162[(7)]);
var inst_32138 = (state_32162[(8)]);
var inst_32145 = (state_32162[(9)]);
var inst_32145__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32134,inst_32138) : f.call(null,inst_32134,inst_32138));
var inst_32148 = cljs.core.reduced_QMARK_(inst_32145__$1);
var state_32162__$1 = (function (){var statearr_32175 = state_32162;
(statearr_32175[(9)] = inst_32145__$1);

return statearr_32175;
})();
if(inst_32148){
var statearr_32179_34894 = state_32162__$1;
(statearr_32179_34894[(1)] = (8));

} else {
var statearr_32180_34895 = state_32162__$1;
(statearr_32180_34895[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (3))){
var inst_32158 = (state_32162[(2)]);
var state_32162__$1 = state_32162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32162__$1,inst_32158);
} else {
if((state_val_32163 === (2))){
var state_32162__$1 = state_32162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32162__$1,(4),ch);
} else {
if((state_val_32163 === (9))){
var inst_32145 = (state_32162[(9)]);
var inst_32134 = inst_32145;
var state_32162__$1 = (function (){var statearr_32188 = state_32162;
(statearr_32188[(7)] = inst_32134);

return statearr_32188;
})();
var statearr_32190_34896 = state_32162__$1;
(statearr_32190_34896[(2)] = null);

(statearr_32190_34896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (5))){
var inst_32134 = (state_32162[(7)]);
var state_32162__$1 = state_32162;
var statearr_32191_34897 = state_32162__$1;
(statearr_32191_34897[(2)] = inst_32134);

(statearr_32191_34897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (10))){
var inst_32154 = (state_32162[(2)]);
var state_32162__$1 = state_32162;
var statearr_32192_34898 = state_32162__$1;
(statearr_32192_34898[(2)] = inst_32154);

(statearr_32192_34898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (8))){
var inst_32145 = (state_32162[(9)]);
var inst_32150 = cljs.core.deref(inst_32145);
var state_32162__$1 = state_32162;
var statearr_32195_34899 = state_32162__$1;
(statearr_32195_34899[(2)] = inst_32150);

(statearr_32195_34899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__30666__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30666__auto____0 = (function (){
var statearr_32196 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32196[(0)] = cljs$core$async$reduce_$_state_machine__30666__auto__);

(statearr_32196[(1)] = (1));

return statearr_32196;
});
var cljs$core$async$reduce_$_state_machine__30666__auto____1 = (function (state_32162){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_32162);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e32200){var ex__30669__auto__ = e32200;
var statearr_32202_34904 = state_32162;
(statearr_32202_34904[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_32162[(4)]))){
var statearr_32204_34905 = state_32162;
(statearr_32204_34905[(1)] = cljs.core.first((state_32162[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34910 = state_32162;
state_32162 = G__34910;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30666__auto__ = function(state_32162){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30666__auto____1.call(this,state_32162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30666__auto____0;
cljs$core$async$reduce_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30666__auto____1;
return cljs$core$async$reduce_$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_32208 = f__31232__auto__();
(statearr_32208[(6)] = c__31231__auto__);

return statearr_32208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

return c__31231__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__31231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_32223){
var state_val_32224 = (state_32223[(1)]);
if((state_val_32224 === (1))){
var inst_32218 = cljs.core.async.reduce(f__$1,init,ch);
var state_32223__$1 = state_32223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32223__$1,(2),inst_32218);
} else {
if((state_val_32224 === (2))){
var inst_32220 = (state_32223[(2)]);
var inst_32221 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32220) : f__$1.call(null,inst_32220));
var state_32223__$1 = state_32223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32223__$1,inst_32221);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__30666__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30666__auto____0 = (function (){
var statearr_32243 = [null,null,null,null,null,null,null];
(statearr_32243[(0)] = cljs$core$async$transduce_$_state_machine__30666__auto__);

(statearr_32243[(1)] = (1));

return statearr_32243;
});
var cljs$core$async$transduce_$_state_machine__30666__auto____1 = (function (state_32223){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_32223);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e32244){var ex__30669__auto__ = e32244;
var statearr_32245_34920 = state_32223;
(statearr_32245_34920[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_32223[(4)]))){
var statearr_32246_34921 = state_32223;
(statearr_32246_34921[(1)] = cljs.core.first((state_32223[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34922 = state_32223;
state_32223 = G__34922;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30666__auto__ = function(state_32223){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30666__auto____1.call(this,state_32223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30666__auto____0;
cljs$core$async$transduce_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30666__auto____1;
return cljs$core$async$transduce_$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_32249 = f__31232__auto__();
(statearr_32249[(6)] = c__31231__auto__);

return statearr_32249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

return c__31231__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__32252 = arguments.length;
switch (G__32252) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_32296){
var state_val_32297 = (state_32296[(1)]);
if((state_val_32297 === (7))){
var inst_32271 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32300_34933 = state_32296__$1;
(statearr_32300_34933[(2)] = inst_32271);

(statearr_32300_34933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (1))){
var inst_32265 = cljs.core.seq(coll);
var inst_32266 = inst_32265;
var state_32296__$1 = (function (){var statearr_32302 = state_32296;
(statearr_32302[(7)] = inst_32266);

return statearr_32302;
})();
var statearr_32303_34937 = state_32296__$1;
(statearr_32303_34937[(2)] = null);

(statearr_32303_34937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (4))){
var inst_32266 = (state_32296[(7)]);
var inst_32269 = cljs.core.first(inst_32266);
var state_32296__$1 = state_32296;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32296__$1,(7),ch,inst_32269);
} else {
if((state_val_32297 === (13))){
var inst_32290 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32306_34940 = state_32296__$1;
(statearr_32306_34940[(2)] = inst_32290);

(statearr_32306_34940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (6))){
var inst_32275 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
if(cljs.core.truth_(inst_32275)){
var statearr_32307_34941 = state_32296__$1;
(statearr_32307_34941[(1)] = (8));

} else {
var statearr_32308_34945 = state_32296__$1;
(statearr_32308_34945[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (3))){
var inst_32294 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32296__$1,inst_32294);
} else {
if((state_val_32297 === (12))){
var state_32296__$1 = state_32296;
var statearr_32312_34946 = state_32296__$1;
(statearr_32312_34946[(2)] = null);

(statearr_32312_34946[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (2))){
var inst_32266 = (state_32296[(7)]);
var state_32296__$1 = state_32296;
if(cljs.core.truth_(inst_32266)){
var statearr_32313_34950 = state_32296__$1;
(statearr_32313_34950[(1)] = (4));

} else {
var statearr_32314_34951 = state_32296__$1;
(statearr_32314_34951[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (11))){
var inst_32287 = cljs.core.async.close_BANG_(ch);
var state_32296__$1 = state_32296;
var statearr_32315_34952 = state_32296__$1;
(statearr_32315_34952[(2)] = inst_32287);

(statearr_32315_34952[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (9))){
var state_32296__$1 = state_32296;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32316_34953 = state_32296__$1;
(statearr_32316_34953[(1)] = (11));

} else {
var statearr_32319_34954 = state_32296__$1;
(statearr_32319_34954[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (5))){
var inst_32266 = (state_32296[(7)]);
var state_32296__$1 = state_32296;
var statearr_32322_34955 = state_32296__$1;
(statearr_32322_34955[(2)] = inst_32266);

(statearr_32322_34955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (10))){
var inst_32292 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32325_34959 = state_32296__$1;
(statearr_32325_34959[(2)] = inst_32292);

(statearr_32325_34959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (8))){
var inst_32266 = (state_32296[(7)]);
var inst_32282 = cljs.core.next(inst_32266);
var inst_32266__$1 = inst_32282;
var state_32296__$1 = (function (){var statearr_32329 = state_32296;
(statearr_32329[(7)] = inst_32266__$1);

return statearr_32329;
})();
var statearr_32333_34960 = state_32296__$1;
(statearr_32333_34960[(2)] = null);

(statearr_32333_34960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_32336 = [null,null,null,null,null,null,null,null];
(statearr_32336[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_32336[(1)] = (1));

return statearr_32336;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_32296){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_32296);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e32337){var ex__30669__auto__ = e32337;
var statearr_32338_34961 = state_32296;
(statearr_32338_34961[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_32296[(4)]))){
var statearr_32339_34962 = state_32296;
(statearr_32339_34962[(1)] = cljs.core.first((state_32296[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34964 = state_32296;
state_32296 = G__34964;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_32296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_32296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_32343 = f__31232__auto__();
(statearr_32343[(6)] = c__31231__auto__);

return statearr_32343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

return c__31231__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32350 = arguments.length;
switch (G__32350) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34969 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34969(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34970 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34970(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34971 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34971(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34972 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34972(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32409 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32409 = (function (ch,cs,meta32410){
this.ch = ch;
this.cs = cs;
this.meta32410 = meta32410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32411,meta32410__$1){
var self__ = this;
var _32411__$1 = this;
return (new cljs.core.async.t_cljs$core$async32409(self__.ch,self__.cs,meta32410__$1));
}));

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32411){
var self__ = this;
var _32411__$1 = this;
return self__.meta32410;
}));

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async32409.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async32409.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32410","meta32410",-1734245409,null)], null);
}));

(cljs.core.async.t_cljs$core$async32409.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32409.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32409");

(cljs.core.async.t_cljs$core$async32409.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32409");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32409.
 */
cljs.core.async.__GT_t_cljs$core$async32409 = (function cljs$core$async$mult_$___GT_t_cljs$core$async32409(ch__$1,cs__$1,meta32410){
return (new cljs.core.async.t_cljs$core$async32409(ch__$1,cs__$1,meta32410));
});

}

return (new cljs.core.async.t_cljs$core$async32409(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__31231__auto___34996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_32613){
var state_val_32614 = (state_32613[(1)]);
if((state_val_32614 === (7))){
var inst_32608 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32618_34999 = state_32613__$1;
(statearr_32618_34999[(2)] = inst_32608);

(statearr_32618_34999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (20))){
var inst_32500 = (state_32613[(7)]);
var inst_32520 = cljs.core.first(inst_32500);
var inst_32521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32520,(0),null);
var inst_32522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32520,(1),null);
var state_32613__$1 = (function (){var statearr_32621 = state_32613;
(statearr_32621[(8)] = inst_32521);

return statearr_32621;
})();
if(cljs.core.truth_(inst_32522)){
var statearr_32622_35003 = state_32613__$1;
(statearr_32622_35003[(1)] = (22));

} else {
var statearr_32623_35004 = state_32613__$1;
(statearr_32623_35004[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (27))){
var inst_32551 = (state_32613[(9)]);
var inst_32447 = (state_32613[(10)]);
var inst_32553 = (state_32613[(11)]);
var inst_32558 = (state_32613[(12)]);
var inst_32558__$1 = cljs.core._nth(inst_32551,inst_32553);
var inst_32559 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32558__$1,inst_32447,done);
var state_32613__$1 = (function (){var statearr_32629 = state_32613;
(statearr_32629[(12)] = inst_32558__$1);

return statearr_32629;
})();
if(cljs.core.truth_(inst_32559)){
var statearr_32630_35013 = state_32613__$1;
(statearr_32630_35013[(1)] = (30));

} else {
var statearr_32632_35017 = state_32613__$1;
(statearr_32632_35017[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (1))){
var state_32613__$1 = state_32613;
var statearr_32633_35019 = state_32613__$1;
(statearr_32633_35019[(2)] = null);

(statearr_32633_35019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (24))){
var inst_32500 = (state_32613[(7)]);
var inst_32528 = (state_32613[(2)]);
var inst_32529 = cljs.core.next(inst_32500);
var inst_32464 = inst_32529;
var inst_32465 = null;
var inst_32466 = (0);
var inst_32467 = (0);
var state_32613__$1 = (function (){var statearr_32646 = state_32613;
(statearr_32646[(13)] = inst_32465);

(statearr_32646[(14)] = inst_32528);

(statearr_32646[(15)] = inst_32464);

(statearr_32646[(16)] = inst_32467);

(statearr_32646[(17)] = inst_32466);

return statearr_32646;
})();
var statearr_32647_35028 = state_32613__$1;
(statearr_32647_35028[(2)] = null);

(statearr_32647_35028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (39))){
var state_32613__$1 = state_32613;
var statearr_32660_35029 = state_32613__$1;
(statearr_32660_35029[(2)] = null);

(statearr_32660_35029[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (4))){
var inst_32447 = (state_32613[(10)]);
var inst_32447__$1 = (state_32613[(2)]);
var inst_32449 = (inst_32447__$1 == null);
var state_32613__$1 = (function (){var statearr_32661 = state_32613;
(statearr_32661[(10)] = inst_32447__$1);

return statearr_32661;
})();
if(cljs.core.truth_(inst_32449)){
var statearr_32664_35030 = state_32613__$1;
(statearr_32664_35030[(1)] = (5));

} else {
var statearr_32665_35031 = state_32613__$1;
(statearr_32665_35031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (15))){
var inst_32465 = (state_32613[(13)]);
var inst_32464 = (state_32613[(15)]);
var inst_32467 = (state_32613[(16)]);
var inst_32466 = (state_32613[(17)]);
var inst_32496 = (state_32613[(2)]);
var inst_32497 = (inst_32467 + (1));
var tmp32657 = inst_32465;
var tmp32658 = inst_32464;
var tmp32659 = inst_32466;
var inst_32464__$1 = tmp32658;
var inst_32465__$1 = tmp32657;
var inst_32466__$1 = tmp32659;
var inst_32467__$1 = inst_32497;
var state_32613__$1 = (function (){var statearr_32666 = state_32613;
(statearr_32666[(13)] = inst_32465__$1);

(statearr_32666[(15)] = inst_32464__$1);

(statearr_32666[(16)] = inst_32467__$1);

(statearr_32666[(17)] = inst_32466__$1);

(statearr_32666[(18)] = inst_32496);

return statearr_32666;
})();
var statearr_32668_35034 = state_32613__$1;
(statearr_32668_35034[(2)] = null);

(statearr_32668_35034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (21))){
var inst_32532 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32673_35035 = state_32613__$1;
(statearr_32673_35035[(2)] = inst_32532);

(statearr_32673_35035[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (31))){
var inst_32558 = (state_32613[(12)]);
var inst_32562 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32558);
var state_32613__$1 = state_32613;
var statearr_32674_35037 = state_32613__$1;
(statearr_32674_35037[(2)] = inst_32562);

(statearr_32674_35037[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (32))){
var inst_32550 = (state_32613[(19)]);
var inst_32551 = (state_32613[(9)]);
var inst_32552 = (state_32613[(20)]);
var inst_32553 = (state_32613[(11)]);
var inst_32564 = (state_32613[(2)]);
var inst_32565 = (inst_32553 + (1));
var tmp32670 = inst_32550;
var tmp32671 = inst_32551;
var tmp32672 = inst_32552;
var inst_32550__$1 = tmp32670;
var inst_32551__$1 = tmp32671;
var inst_32552__$1 = tmp32672;
var inst_32553__$1 = inst_32565;
var state_32613__$1 = (function (){var statearr_32676 = state_32613;
(statearr_32676[(19)] = inst_32550__$1);

(statearr_32676[(9)] = inst_32551__$1);

(statearr_32676[(21)] = inst_32564);

(statearr_32676[(20)] = inst_32552__$1);

(statearr_32676[(11)] = inst_32553__$1);

return statearr_32676;
})();
var statearr_32677_35041 = state_32613__$1;
(statearr_32677_35041[(2)] = null);

(statearr_32677_35041[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (40))){
var inst_32577 = (state_32613[(22)]);
var inst_32583 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32577);
var state_32613__$1 = state_32613;
var statearr_32678_35044 = state_32613__$1;
(statearr_32678_35044[(2)] = inst_32583);

(statearr_32678_35044[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (33))){
var inst_32568 = (state_32613[(23)]);
var inst_32570 = cljs.core.chunked_seq_QMARK_(inst_32568);
var state_32613__$1 = state_32613;
if(inst_32570){
var statearr_32680_35047 = state_32613__$1;
(statearr_32680_35047[(1)] = (36));

} else {
var statearr_32681_35048 = state_32613__$1;
(statearr_32681_35048[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (13))){
var inst_32489 = (state_32613[(24)]);
var inst_32493 = cljs.core.async.close_BANG_(inst_32489);
var state_32613__$1 = state_32613;
var statearr_32683_35049 = state_32613__$1;
(statearr_32683_35049[(2)] = inst_32493);

(statearr_32683_35049[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (22))){
var inst_32521 = (state_32613[(8)]);
var inst_32525 = cljs.core.async.close_BANG_(inst_32521);
var state_32613__$1 = state_32613;
var statearr_32686_35053 = state_32613__$1;
(statearr_32686_35053[(2)] = inst_32525);

(statearr_32686_35053[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (36))){
var inst_32568 = (state_32613[(23)]);
var inst_32572 = cljs.core.chunk_first(inst_32568);
var inst_32573 = cljs.core.chunk_rest(inst_32568);
var inst_32574 = cljs.core.count(inst_32572);
var inst_32550 = inst_32573;
var inst_32551 = inst_32572;
var inst_32552 = inst_32574;
var inst_32553 = (0);
var state_32613__$1 = (function (){var statearr_32690 = state_32613;
(statearr_32690[(19)] = inst_32550);

(statearr_32690[(9)] = inst_32551);

(statearr_32690[(20)] = inst_32552);

(statearr_32690[(11)] = inst_32553);

return statearr_32690;
})();
var statearr_32692_35064 = state_32613__$1;
(statearr_32692_35064[(2)] = null);

(statearr_32692_35064[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (41))){
var inst_32568 = (state_32613[(23)]);
var inst_32585 = (state_32613[(2)]);
var inst_32587 = cljs.core.next(inst_32568);
var inst_32550 = inst_32587;
var inst_32551 = null;
var inst_32552 = (0);
var inst_32553 = (0);
var state_32613__$1 = (function (){var statearr_32693 = state_32613;
(statearr_32693[(19)] = inst_32550);

(statearr_32693[(9)] = inst_32551);

(statearr_32693[(25)] = inst_32585);

(statearr_32693[(20)] = inst_32552);

(statearr_32693[(11)] = inst_32553);

return statearr_32693;
})();
var statearr_32694_35065 = state_32613__$1;
(statearr_32694_35065[(2)] = null);

(statearr_32694_35065[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (43))){
var state_32613__$1 = state_32613;
var statearr_32695_35066 = state_32613__$1;
(statearr_32695_35066[(2)] = null);

(statearr_32695_35066[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (29))){
var inst_32595 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32698_35067 = state_32613__$1;
(statearr_32698_35067[(2)] = inst_32595);

(statearr_32698_35067[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (44))){
var inst_32605 = (state_32613[(2)]);
var state_32613__$1 = (function (){var statearr_32701 = state_32613;
(statearr_32701[(26)] = inst_32605);

return statearr_32701;
})();
var statearr_32703_35068 = state_32613__$1;
(statearr_32703_35068[(2)] = null);

(statearr_32703_35068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (6))){
var inst_32542 = (state_32613[(27)]);
var inst_32541 = cljs.core.deref(cs);
var inst_32542__$1 = cljs.core.keys(inst_32541);
var inst_32543 = cljs.core.count(inst_32542__$1);
var inst_32544 = cljs.core.reset_BANG_(dctr,inst_32543);
var inst_32549 = cljs.core.seq(inst_32542__$1);
var inst_32550 = inst_32549;
var inst_32551 = null;
var inst_32552 = (0);
var inst_32553 = (0);
var state_32613__$1 = (function (){var statearr_32706 = state_32613;
(statearr_32706[(19)] = inst_32550);

(statearr_32706[(9)] = inst_32551);

(statearr_32706[(28)] = inst_32544);

(statearr_32706[(27)] = inst_32542__$1);

(statearr_32706[(20)] = inst_32552);

(statearr_32706[(11)] = inst_32553);

return statearr_32706;
})();
var statearr_32707_35069 = state_32613__$1;
(statearr_32707_35069[(2)] = null);

(statearr_32707_35069[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (28))){
var inst_32550 = (state_32613[(19)]);
var inst_32568 = (state_32613[(23)]);
var inst_32568__$1 = cljs.core.seq(inst_32550);
var state_32613__$1 = (function (){var statearr_32708 = state_32613;
(statearr_32708[(23)] = inst_32568__$1);

return statearr_32708;
})();
if(inst_32568__$1){
var statearr_32709_35070 = state_32613__$1;
(statearr_32709_35070[(1)] = (33));

} else {
var statearr_32710_35071 = state_32613__$1;
(statearr_32710_35071[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (25))){
var inst_32552 = (state_32613[(20)]);
var inst_32553 = (state_32613[(11)]);
var inst_32555 = (inst_32553 < inst_32552);
var inst_32556 = inst_32555;
var state_32613__$1 = state_32613;
if(cljs.core.truth_(inst_32556)){
var statearr_32712_35072 = state_32613__$1;
(statearr_32712_35072[(1)] = (27));

} else {
var statearr_32714_35073 = state_32613__$1;
(statearr_32714_35073[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (34))){
var state_32613__$1 = state_32613;
var statearr_32717_35074 = state_32613__$1;
(statearr_32717_35074[(2)] = null);

(statearr_32717_35074[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (17))){
var state_32613__$1 = state_32613;
var statearr_32725_35081 = state_32613__$1;
(statearr_32725_35081[(2)] = null);

(statearr_32725_35081[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (3))){
var inst_32610 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32613__$1,inst_32610);
} else {
if((state_val_32614 === (12))){
var inst_32537 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32728_35082 = state_32613__$1;
(statearr_32728_35082[(2)] = inst_32537);

(statearr_32728_35082[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (2))){
var state_32613__$1 = state_32613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32613__$1,(4),ch);
} else {
if((state_val_32614 === (23))){
var state_32613__$1 = state_32613;
var statearr_32733_35083 = state_32613__$1;
(statearr_32733_35083[(2)] = null);

(statearr_32733_35083[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (35))){
var inst_32593 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32735_35084 = state_32613__$1;
(statearr_32735_35084[(2)] = inst_32593);

(statearr_32735_35084[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (19))){
var inst_32500 = (state_32613[(7)]);
var inst_32508 = cljs.core.chunk_first(inst_32500);
var inst_32509 = cljs.core.chunk_rest(inst_32500);
var inst_32511 = cljs.core.count(inst_32508);
var inst_32464 = inst_32509;
var inst_32465 = inst_32508;
var inst_32466 = inst_32511;
var inst_32467 = (0);
var state_32613__$1 = (function (){var statearr_32738 = state_32613;
(statearr_32738[(13)] = inst_32465);

(statearr_32738[(15)] = inst_32464);

(statearr_32738[(16)] = inst_32467);

(statearr_32738[(17)] = inst_32466);

return statearr_32738;
})();
var statearr_32739_35087 = state_32613__$1;
(statearr_32739_35087[(2)] = null);

(statearr_32739_35087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (11))){
var inst_32464 = (state_32613[(15)]);
var inst_32500 = (state_32613[(7)]);
var inst_32500__$1 = cljs.core.seq(inst_32464);
var state_32613__$1 = (function (){var statearr_32740 = state_32613;
(statearr_32740[(7)] = inst_32500__$1);

return statearr_32740;
})();
if(inst_32500__$1){
var statearr_32741_35088 = state_32613__$1;
(statearr_32741_35088[(1)] = (16));

} else {
var statearr_32742_35089 = state_32613__$1;
(statearr_32742_35089[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (9))){
var inst_32539 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32746_35090 = state_32613__$1;
(statearr_32746_35090[(2)] = inst_32539);

(statearr_32746_35090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (5))){
var inst_32461 = cljs.core.deref(cs);
var inst_32462 = cljs.core.seq(inst_32461);
var inst_32464 = inst_32462;
var inst_32465 = null;
var inst_32466 = (0);
var inst_32467 = (0);
var state_32613__$1 = (function (){var statearr_32749 = state_32613;
(statearr_32749[(13)] = inst_32465);

(statearr_32749[(15)] = inst_32464);

(statearr_32749[(16)] = inst_32467);

(statearr_32749[(17)] = inst_32466);

return statearr_32749;
})();
var statearr_32752_35092 = state_32613__$1;
(statearr_32752_35092[(2)] = null);

(statearr_32752_35092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (14))){
var state_32613__$1 = state_32613;
var statearr_32754_35106 = state_32613__$1;
(statearr_32754_35106[(2)] = null);

(statearr_32754_35106[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (45))){
var inst_32602 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32755_35110 = state_32613__$1;
(statearr_32755_35110[(2)] = inst_32602);

(statearr_32755_35110[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (26))){
var inst_32542 = (state_32613[(27)]);
var inst_32597 = (state_32613[(2)]);
var inst_32598 = cljs.core.seq(inst_32542);
var state_32613__$1 = (function (){var statearr_32756 = state_32613;
(statearr_32756[(29)] = inst_32597);

return statearr_32756;
})();
if(inst_32598){
var statearr_32757_35111 = state_32613__$1;
(statearr_32757_35111[(1)] = (42));

} else {
var statearr_32758_35112 = state_32613__$1;
(statearr_32758_35112[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (16))){
var inst_32500 = (state_32613[(7)]);
var inst_32504 = cljs.core.chunked_seq_QMARK_(inst_32500);
var state_32613__$1 = state_32613;
if(inst_32504){
var statearr_32759_35113 = state_32613__$1;
(statearr_32759_35113[(1)] = (19));

} else {
var statearr_32761_35114 = state_32613__$1;
(statearr_32761_35114[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (38))){
var inst_32590 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32762_35116 = state_32613__$1;
(statearr_32762_35116[(2)] = inst_32590);

(statearr_32762_35116[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (30))){
var state_32613__$1 = state_32613;
var statearr_32764_35117 = state_32613__$1;
(statearr_32764_35117[(2)] = null);

(statearr_32764_35117[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (10))){
var inst_32465 = (state_32613[(13)]);
var inst_32467 = (state_32613[(16)]);
var inst_32488 = cljs.core._nth(inst_32465,inst_32467);
var inst_32489 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32488,(0),null);
var inst_32490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32488,(1),null);
var state_32613__$1 = (function (){var statearr_32765 = state_32613;
(statearr_32765[(24)] = inst_32489);

return statearr_32765;
})();
if(cljs.core.truth_(inst_32490)){
var statearr_32766_35119 = state_32613__$1;
(statearr_32766_35119[(1)] = (13));

} else {
var statearr_32767_35120 = state_32613__$1;
(statearr_32767_35120[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (18))){
var inst_32535 = (state_32613[(2)]);
var state_32613__$1 = state_32613;
var statearr_32768_35121 = state_32613__$1;
(statearr_32768_35121[(2)] = inst_32535);

(statearr_32768_35121[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (42))){
var state_32613__$1 = state_32613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32613__$1,(45),dchan);
} else {
if((state_val_32614 === (37))){
var inst_32568 = (state_32613[(23)]);
var inst_32447 = (state_32613[(10)]);
var inst_32577 = (state_32613[(22)]);
var inst_32577__$1 = cljs.core.first(inst_32568);
var inst_32578 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32577__$1,inst_32447,done);
var state_32613__$1 = (function (){var statearr_32771 = state_32613;
(statearr_32771[(22)] = inst_32577__$1);

return statearr_32771;
})();
if(cljs.core.truth_(inst_32578)){
var statearr_32773_35128 = state_32613__$1;
(statearr_32773_35128[(1)] = (39));

} else {
var statearr_32774_35129 = state_32613__$1;
(statearr_32774_35129[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32614 === (8))){
var inst_32467 = (state_32613[(16)]);
var inst_32466 = (state_32613[(17)]);
var inst_32481 = (inst_32467 < inst_32466);
var inst_32482 = inst_32481;
var state_32613__$1 = state_32613;
if(cljs.core.truth_(inst_32482)){
var statearr_32776_35130 = state_32613__$1;
(statearr_32776_35130[(1)] = (10));

} else {
var statearr_32777_35131 = state_32613__$1;
(statearr_32777_35131[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__30666__auto__ = null;
var cljs$core$async$mult_$_state_machine__30666__auto____0 = (function (){
var statearr_32778 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32778[(0)] = cljs$core$async$mult_$_state_machine__30666__auto__);

(statearr_32778[(1)] = (1));

return statearr_32778;
});
var cljs$core$async$mult_$_state_machine__30666__auto____1 = (function (state_32613){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_32613);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e32781){var ex__30669__auto__ = e32781;
var statearr_32782_35132 = state_32613;
(statearr_32782_35132[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_32613[(4)]))){
var statearr_32783_35133 = state_32613;
(statearr_32783_35133[(1)] = cljs.core.first((state_32613[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35134 = state_32613;
state_32613 = G__35134;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30666__auto__ = function(state_32613){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30666__auto____1.call(this,state_32613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30666__auto____0;
cljs$core$async$mult_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30666__auto____1;
return cljs$core$async$mult_$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_32785 = f__31232__auto__();
(statearr_32785[(6)] = c__31231__auto___34996);

return statearr_32785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32787 = arguments.length;
switch (G__32787) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_35136 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_35136(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_35137 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_35137(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_35138 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_35138(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_35141 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_35141(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_35148 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_35148(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35149 = arguments.length;
var i__5770__auto___35150 = (0);
while(true){
if((i__5770__auto___35150 < len__5769__auto___35149)){
args__5775__auto__.push((arguments[i__5770__auto___35150]));

var G__35160 = (i__5770__auto___35150 + (1));
i__5770__auto___35150 = G__35160;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32819){
var map__32820 = p__32819;
var map__32820__$1 = cljs.core.__destructure_map(map__32820);
var opts = map__32820__$1;
var statearr_32822_35161 = state;
(statearr_32822_35161[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32824_35162 = state;
(statearr_32824_35162[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32827_35163 = state;
(statearr_32827_35163[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32815){
var G__32816 = cljs.core.first(seq32815);
var seq32815__$1 = cljs.core.next(seq32815);
var G__32817 = cljs.core.first(seq32815__$1);
var seq32815__$2 = cljs.core.next(seq32815__$1);
var G__32818 = cljs.core.first(seq32815__$2);
var seq32815__$3 = cljs.core.next(seq32815__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32816,G__32817,G__32818,seq32815__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32857 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32857 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32858){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32858 = meta32858;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32859,meta32858__$1){
var self__ = this;
var _32859__$1 = this;
return (new cljs.core.async.t_cljs$core$async32857(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32858__$1));
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32859){
var self__ = this;
var _32859__$1 = this;
return self__.meta32858;
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32857.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32857.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32858","meta32858",-1807962273,null)], null);
}));

(cljs.core.async.t_cljs$core$async32857.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32857.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32857");

(cljs.core.async.t_cljs$core$async32857.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32857");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32857.
 */
cljs.core.async.__GT_t_cljs$core$async32857 = (function cljs$core$async$mix_$___GT_t_cljs$core$async32857(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32858){
return (new cljs.core.async.t_cljs$core$async32857(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32858));
});

}

return (new cljs.core.async.t_cljs$core$async32857(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31231__auto___35171 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_33006){
var state_val_33007 = (state_33006[(1)]);
if((state_val_33007 === (7))){
var inst_32950 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
if(cljs.core.truth_(inst_32950)){
var statearr_33014_35172 = state_33006__$1;
(statearr_33014_35172[(1)] = (8));

} else {
var statearr_33015_35173 = state_33006__$1;
(statearr_33015_35173[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (20))){
var inst_32943 = (state_33006[(7)]);
var state_33006__$1 = state_33006;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33006__$1,(23),out,inst_32943);
} else {
if((state_val_33007 === (1))){
var inst_32925 = calc_state();
var inst_32926 = cljs.core.__destructure_map(inst_32925);
var inst_32927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32926,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32926,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32929 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32926,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32930 = inst_32925;
var state_33006__$1 = (function (){var statearr_33028 = state_33006;
(statearr_33028[(8)] = inst_32930);

(statearr_33028[(9)] = inst_32929);

(statearr_33028[(10)] = inst_32928);

(statearr_33028[(11)] = inst_32927);

return statearr_33028;
})();
var statearr_33035_35174 = state_33006__$1;
(statearr_33035_35174[(2)] = null);

(statearr_33035_35174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (24))){
var inst_32934 = (state_33006[(12)]);
var inst_32930 = inst_32934;
var state_33006__$1 = (function (){var statearr_33041 = state_33006;
(statearr_33041[(8)] = inst_32930);

return statearr_33041;
})();
var statearr_33042_35177 = state_33006__$1;
(statearr_33042_35177[(2)] = null);

(statearr_33042_35177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (4))){
var inst_32943 = (state_33006[(7)]);
var inst_32945 = (state_33006[(13)]);
var inst_32942 = (state_33006[(2)]);
var inst_32943__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32942,(0),null);
var inst_32944 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32942,(1),null);
var inst_32945__$1 = (inst_32943__$1 == null);
var state_33006__$1 = (function (){var statearr_33048 = state_33006;
(statearr_33048[(7)] = inst_32943__$1);

(statearr_33048[(14)] = inst_32944);

(statearr_33048[(13)] = inst_32945__$1);

return statearr_33048;
})();
if(cljs.core.truth_(inst_32945__$1)){
var statearr_33051_35180 = state_33006__$1;
(statearr_33051_35180[(1)] = (5));

} else {
var statearr_33053_35181 = state_33006__$1;
(statearr_33053_35181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (15))){
var inst_32964 = (state_33006[(15)]);
var inst_32935 = (state_33006[(16)]);
var inst_32964__$1 = cljs.core.empty_QMARK_(inst_32935);
var state_33006__$1 = (function (){var statearr_33056 = state_33006;
(statearr_33056[(15)] = inst_32964__$1);

return statearr_33056;
})();
if(inst_32964__$1){
var statearr_33057_35182 = state_33006__$1;
(statearr_33057_35182[(1)] = (17));

} else {
var statearr_33058_35183 = state_33006__$1;
(statearr_33058_35183[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (21))){
var inst_32934 = (state_33006[(12)]);
var inst_32930 = inst_32934;
var state_33006__$1 = (function (){var statearr_33062 = state_33006;
(statearr_33062[(8)] = inst_32930);

return statearr_33062;
})();
var statearr_33063_35184 = state_33006__$1;
(statearr_33063_35184[(2)] = null);

(statearr_33063_35184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (13))){
var inst_32957 = (state_33006[(2)]);
var inst_32958 = calc_state();
var inst_32930 = inst_32958;
var state_33006__$1 = (function (){var statearr_33064 = state_33006;
(statearr_33064[(17)] = inst_32957);

(statearr_33064[(8)] = inst_32930);

return statearr_33064;
})();
var statearr_33068_35185 = state_33006__$1;
(statearr_33068_35185[(2)] = null);

(statearr_33068_35185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (22))){
var inst_33000 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
var statearr_33070_35186 = state_33006__$1;
(statearr_33070_35186[(2)] = inst_33000);

(statearr_33070_35186[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (6))){
var inst_32944 = (state_33006[(14)]);
var inst_32948 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32944,change);
var state_33006__$1 = state_33006;
var statearr_33074_35187 = state_33006__$1;
(statearr_33074_35187[(2)] = inst_32948);

(statearr_33074_35187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (25))){
var state_33006__$1 = state_33006;
var statearr_33075_35188 = state_33006__$1;
(statearr_33075_35188[(2)] = null);

(statearr_33075_35188[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (17))){
var inst_32936 = (state_33006[(18)]);
var inst_32944 = (state_33006[(14)]);
var inst_32966 = (inst_32936.cljs$core$IFn$_invoke$arity$1 ? inst_32936.cljs$core$IFn$_invoke$arity$1(inst_32944) : inst_32936.call(null,inst_32944));
var inst_32967 = cljs.core.not(inst_32966);
var state_33006__$1 = state_33006;
var statearr_33076_35189 = state_33006__$1;
(statearr_33076_35189[(2)] = inst_32967);

(statearr_33076_35189[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (3))){
var inst_33004 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33006__$1,inst_33004);
} else {
if((state_val_33007 === (12))){
var state_33006__$1 = state_33006;
var statearr_33077_35197 = state_33006__$1;
(statearr_33077_35197[(2)] = null);

(statearr_33077_35197[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (2))){
var inst_32930 = (state_33006[(8)]);
var inst_32934 = (state_33006[(12)]);
var inst_32934__$1 = cljs.core.__destructure_map(inst_32930);
var inst_32935 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32934__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32934__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32934__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_33006__$1 = (function (){var statearr_33087 = state_33006;
(statearr_33087[(16)] = inst_32935);

(statearr_33087[(18)] = inst_32936);

(statearr_33087[(12)] = inst_32934__$1);

return statearr_33087;
})();
return cljs.core.async.ioc_alts_BANG_(state_33006__$1,(4),inst_32937);
} else {
if((state_val_33007 === (23))){
var inst_32991 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
if(cljs.core.truth_(inst_32991)){
var statearr_33091_35199 = state_33006__$1;
(statearr_33091_35199[(1)] = (24));

} else {
var statearr_33092_35200 = state_33006__$1;
(statearr_33092_35200[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (19))){
var inst_32970 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
var statearr_33095_35201 = state_33006__$1;
(statearr_33095_35201[(2)] = inst_32970);

(statearr_33095_35201[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (11))){
var inst_32944 = (state_33006[(14)]);
var inst_32954 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32944);
var state_33006__$1 = state_33006;
var statearr_33098_35203 = state_33006__$1;
(statearr_33098_35203[(2)] = inst_32954);

(statearr_33098_35203[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (9))){
var inst_32961 = (state_33006[(19)]);
var inst_32935 = (state_33006[(16)]);
var inst_32944 = (state_33006[(14)]);
var inst_32961__$1 = (inst_32935.cljs$core$IFn$_invoke$arity$1 ? inst_32935.cljs$core$IFn$_invoke$arity$1(inst_32944) : inst_32935.call(null,inst_32944));
var state_33006__$1 = (function (){var statearr_33099 = state_33006;
(statearr_33099[(19)] = inst_32961__$1);

return statearr_33099;
})();
if(cljs.core.truth_(inst_32961__$1)){
var statearr_33101_35213 = state_33006__$1;
(statearr_33101_35213[(1)] = (14));

} else {
var statearr_33102_35214 = state_33006__$1;
(statearr_33102_35214[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (5))){
var inst_32945 = (state_33006[(13)]);
var state_33006__$1 = state_33006;
var statearr_33103_35215 = state_33006__$1;
(statearr_33103_35215[(2)] = inst_32945);

(statearr_33103_35215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (14))){
var inst_32961 = (state_33006[(19)]);
var state_33006__$1 = state_33006;
var statearr_33104_35216 = state_33006__$1;
(statearr_33104_35216[(2)] = inst_32961);

(statearr_33104_35216[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (26))){
var inst_32996 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
var statearr_33105_35223 = state_33006__$1;
(statearr_33105_35223[(2)] = inst_32996);

(statearr_33105_35223[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (16))){
var inst_32972 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
if(cljs.core.truth_(inst_32972)){
var statearr_33106_35226 = state_33006__$1;
(statearr_33106_35226[(1)] = (20));

} else {
var statearr_33107_35227 = state_33006__$1;
(statearr_33107_35227[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (10))){
var inst_33002 = (state_33006[(2)]);
var state_33006__$1 = state_33006;
var statearr_33108_35228 = state_33006__$1;
(statearr_33108_35228[(2)] = inst_33002);

(statearr_33108_35228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (18))){
var inst_32964 = (state_33006[(15)]);
var state_33006__$1 = state_33006;
var statearr_33113_35229 = state_33006__$1;
(statearr_33113_35229[(2)] = inst_32964);

(statearr_33113_35229[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33007 === (8))){
var inst_32943 = (state_33006[(7)]);
var inst_32952 = (inst_32943 == null);
var state_33006__$1 = state_33006;
if(cljs.core.truth_(inst_32952)){
var statearr_33114_35237 = state_33006__$1;
(statearr_33114_35237[(1)] = (11));

} else {
var statearr_33115_35238 = state_33006__$1;
(statearr_33115_35238[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__30666__auto__ = null;
var cljs$core$async$mix_$_state_machine__30666__auto____0 = (function (){
var statearr_33116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33116[(0)] = cljs$core$async$mix_$_state_machine__30666__auto__);

(statearr_33116[(1)] = (1));

return statearr_33116;
});
var cljs$core$async$mix_$_state_machine__30666__auto____1 = (function (state_33006){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_33006);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e33117){var ex__30669__auto__ = e33117;
var statearr_33118_35240 = state_33006;
(statearr_33118_35240[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_33006[(4)]))){
var statearr_33123_35241 = state_33006;
(statearr_33123_35241[(1)] = cljs.core.first((state_33006[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35242 = state_33006;
state_33006 = G__35242;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30666__auto__ = function(state_33006){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30666__auto____1.call(this,state_33006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30666__auto____0;
cljs$core$async$mix_$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30666__auto____1;
return cljs$core$async$mix_$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_33127 = f__31232__auto__();
(statearr_33127[(6)] = c__31231__auto___35171);

return statearr_33127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_35245 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_35245(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_35258 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_35258(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_35263 = (function() {
var G__35264 = null;
var G__35264__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__35264__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__35264 = function(p,v){
switch(arguments.length){
case 1:
return G__35264__1.call(this,p);
case 2:
return G__35264__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35264.cljs$core$IFn$_invoke$arity$1 = G__35264__1;
G__35264.cljs$core$IFn$_invoke$arity$2 = G__35264__2;
return G__35264;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__33144 = arguments.length;
switch (G__33144) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35263(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35263(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__33150 = arguments.length;
switch (G__33150) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__33148_SHARP_){
if(cljs.core.truth_((p1__33148_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33148_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33148_SHARP_.call(null,topic)))){
return p1__33148_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33148_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33158 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33158 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33159){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33159 = meta33159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33160,meta33159__$1){
var self__ = this;
var _33160__$1 = this;
return (new cljs.core.async.t_cljs$core$async33158(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33159__$1));
}));

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33160){
var self__ = this;
var _33160__$1 = this;
return self__.meta33159;
}));

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async33158.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async33158.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta33159","meta33159",1825316226,null)], null);
}));

(cljs.core.async.t_cljs$core$async33158.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33158");

(cljs.core.async.t_cljs$core$async33158.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33158");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33158.
 */
cljs.core.async.__GT_t_cljs$core$async33158 = (function cljs$core$async$__GT_t_cljs$core$async33158(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33159){
return (new cljs.core.async.t_cljs$core$async33158(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33159));
});

}

return (new cljs.core.async.t_cljs$core$async33158(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31231__auto___35292 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_33255){
var state_val_33256 = (state_33255[(1)]);
if((state_val_33256 === (7))){
var inst_33250 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
var statearr_33258_35293 = state_33255__$1;
(statearr_33258_35293[(2)] = inst_33250);

(statearr_33258_35293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (20))){
var state_33255__$1 = state_33255;
var statearr_33260_35294 = state_33255__$1;
(statearr_33260_35294[(2)] = null);

(statearr_33260_35294[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (1))){
var state_33255__$1 = state_33255;
var statearr_33261_35295 = state_33255__$1;
(statearr_33261_35295[(2)] = null);

(statearr_33261_35295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (24))){
var inst_33233 = (state_33255[(7)]);
var inst_33242 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33233);
var state_33255__$1 = state_33255;
var statearr_33265_35298 = state_33255__$1;
(statearr_33265_35298[(2)] = inst_33242);

(statearr_33265_35298[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (4))){
var inst_33175 = (state_33255[(8)]);
var inst_33175__$1 = (state_33255[(2)]);
var inst_33176 = (inst_33175__$1 == null);
var state_33255__$1 = (function (){var statearr_33270 = state_33255;
(statearr_33270[(8)] = inst_33175__$1);

return statearr_33270;
})();
if(cljs.core.truth_(inst_33176)){
var statearr_33271_35299 = state_33255__$1;
(statearr_33271_35299[(1)] = (5));

} else {
var statearr_33272_35300 = state_33255__$1;
(statearr_33272_35300[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (15))){
var inst_33226 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
var statearr_33282_35303 = state_33255__$1;
(statearr_33282_35303[(2)] = inst_33226);

(statearr_33282_35303[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (21))){
var inst_33247 = (state_33255[(2)]);
var state_33255__$1 = (function (){var statearr_33290 = state_33255;
(statearr_33290[(9)] = inst_33247);

return statearr_33290;
})();
var statearr_33293_35304 = state_33255__$1;
(statearr_33293_35304[(2)] = null);

(statearr_33293_35304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (13))){
var inst_33201 = (state_33255[(10)]);
var inst_33204 = cljs.core.chunked_seq_QMARK_(inst_33201);
var state_33255__$1 = state_33255;
if(inst_33204){
var statearr_33305_35305 = state_33255__$1;
(statearr_33305_35305[(1)] = (16));

} else {
var statearr_33311_35306 = state_33255__$1;
(statearr_33311_35306[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (22))){
var inst_33239 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
if(cljs.core.truth_(inst_33239)){
var statearr_33324_35307 = state_33255__$1;
(statearr_33324_35307[(1)] = (23));

} else {
var statearr_33326_35308 = state_33255__$1;
(statearr_33326_35308[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (6))){
var inst_33175 = (state_33255[(8)]);
var inst_33233 = (state_33255[(7)]);
var inst_33235 = (state_33255[(11)]);
var inst_33233__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33175) : topic_fn.call(null,inst_33175));
var inst_33234 = cljs.core.deref(mults);
var inst_33235__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33234,inst_33233__$1);
var state_33255__$1 = (function (){var statearr_33337 = state_33255;
(statearr_33337[(7)] = inst_33233__$1);

(statearr_33337[(11)] = inst_33235__$1);

return statearr_33337;
})();
if(cljs.core.truth_(inst_33235__$1)){
var statearr_33338_35310 = state_33255__$1;
(statearr_33338_35310[(1)] = (19));

} else {
var statearr_33339_35311 = state_33255__$1;
(statearr_33339_35311[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (25))){
var inst_33244 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
var statearr_33340_35312 = state_33255__$1;
(statearr_33340_35312[(2)] = inst_33244);

(statearr_33340_35312[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (17))){
var inst_33201 = (state_33255[(10)]);
var inst_33217 = cljs.core.first(inst_33201);
var inst_33218 = cljs.core.async.muxch_STAR_(inst_33217);
var inst_33219 = cljs.core.async.close_BANG_(inst_33218);
var inst_33220 = cljs.core.next(inst_33201);
var inst_33187 = inst_33220;
var inst_33188 = null;
var inst_33189 = (0);
var inst_33190 = (0);
var state_33255__$1 = (function (){var statearr_33348 = state_33255;
(statearr_33348[(12)] = inst_33189);

(statearr_33348[(13)] = inst_33187);

(statearr_33348[(14)] = inst_33219);

(statearr_33348[(15)] = inst_33188);

(statearr_33348[(16)] = inst_33190);

return statearr_33348;
})();
var statearr_33349_35318 = state_33255__$1;
(statearr_33349_35318[(2)] = null);

(statearr_33349_35318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (3))){
var inst_33252 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33255__$1,inst_33252);
} else {
if((state_val_33256 === (12))){
var inst_33229 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
var statearr_33355_35319 = state_33255__$1;
(statearr_33355_35319[(2)] = inst_33229);

(statearr_33355_35319[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (2))){
var state_33255__$1 = state_33255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33255__$1,(4),ch);
} else {
if((state_val_33256 === (23))){
var state_33255__$1 = state_33255;
var statearr_33360_35320 = state_33255__$1;
(statearr_33360_35320[(2)] = null);

(statearr_33360_35320[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (19))){
var inst_33175 = (state_33255[(8)]);
var inst_33235 = (state_33255[(11)]);
var inst_33237 = cljs.core.async.muxch_STAR_(inst_33235);
var state_33255__$1 = state_33255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33255__$1,(22),inst_33237,inst_33175);
} else {
if((state_val_33256 === (11))){
var inst_33201 = (state_33255[(10)]);
var inst_33187 = (state_33255[(13)]);
var inst_33201__$1 = cljs.core.seq(inst_33187);
var state_33255__$1 = (function (){var statearr_33364 = state_33255;
(statearr_33364[(10)] = inst_33201__$1);

return statearr_33364;
})();
if(inst_33201__$1){
var statearr_33366_35321 = state_33255__$1;
(statearr_33366_35321[(1)] = (13));

} else {
var statearr_33368_35322 = state_33255__$1;
(statearr_33368_35322[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (9))){
var inst_33231 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
var statearr_33371_35323 = state_33255__$1;
(statearr_33371_35323[(2)] = inst_33231);

(statearr_33371_35323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (5))){
var inst_33182 = cljs.core.deref(mults);
var inst_33183 = cljs.core.vals(inst_33182);
var inst_33184 = cljs.core.seq(inst_33183);
var inst_33187 = inst_33184;
var inst_33188 = null;
var inst_33189 = (0);
var inst_33190 = (0);
var state_33255__$1 = (function (){var statearr_33376 = state_33255;
(statearr_33376[(12)] = inst_33189);

(statearr_33376[(13)] = inst_33187);

(statearr_33376[(15)] = inst_33188);

(statearr_33376[(16)] = inst_33190);

return statearr_33376;
})();
var statearr_33378_35328 = state_33255__$1;
(statearr_33378_35328[(2)] = null);

(statearr_33378_35328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (14))){
var state_33255__$1 = state_33255;
var statearr_33382_35329 = state_33255__$1;
(statearr_33382_35329[(2)] = null);

(statearr_33382_35329[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (16))){
var inst_33201 = (state_33255[(10)]);
var inst_33212 = cljs.core.chunk_first(inst_33201);
var inst_33213 = cljs.core.chunk_rest(inst_33201);
var inst_33214 = cljs.core.count(inst_33212);
var inst_33187 = inst_33213;
var inst_33188 = inst_33212;
var inst_33189 = inst_33214;
var inst_33190 = (0);
var state_33255__$1 = (function (){var statearr_33383 = state_33255;
(statearr_33383[(12)] = inst_33189);

(statearr_33383[(13)] = inst_33187);

(statearr_33383[(15)] = inst_33188);

(statearr_33383[(16)] = inst_33190);

return statearr_33383;
})();
var statearr_33384_35331 = state_33255__$1;
(statearr_33384_35331[(2)] = null);

(statearr_33384_35331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (10))){
var inst_33189 = (state_33255[(12)]);
var inst_33187 = (state_33255[(13)]);
var inst_33188 = (state_33255[(15)]);
var inst_33190 = (state_33255[(16)]);
var inst_33195 = cljs.core._nth(inst_33188,inst_33190);
var inst_33196 = cljs.core.async.muxch_STAR_(inst_33195);
var inst_33197 = cljs.core.async.close_BANG_(inst_33196);
var inst_33198 = (inst_33190 + (1));
var tmp33379 = inst_33189;
var tmp33380 = inst_33187;
var tmp33381 = inst_33188;
var inst_33187__$1 = tmp33380;
var inst_33188__$1 = tmp33381;
var inst_33189__$1 = tmp33379;
var inst_33190__$1 = inst_33198;
var state_33255__$1 = (function (){var statearr_33389 = state_33255;
(statearr_33389[(17)] = inst_33197);

(statearr_33389[(12)] = inst_33189__$1);

(statearr_33389[(13)] = inst_33187__$1);

(statearr_33389[(15)] = inst_33188__$1);

(statearr_33389[(16)] = inst_33190__$1);

return statearr_33389;
})();
var statearr_33391_35332 = state_33255__$1;
(statearr_33391_35332[(2)] = null);

(statearr_33391_35332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (18))){
var inst_33223 = (state_33255[(2)]);
var state_33255__$1 = state_33255;
var statearr_33392_35333 = state_33255__$1;
(statearr_33392_35333[(2)] = inst_33223);

(statearr_33392_35333[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33256 === (8))){
var inst_33189 = (state_33255[(12)]);
var inst_33190 = (state_33255[(16)]);
var inst_33192 = (inst_33190 < inst_33189);
var inst_33193 = inst_33192;
var state_33255__$1 = state_33255;
if(cljs.core.truth_(inst_33193)){
var statearr_33395_35339 = state_33255__$1;
(statearr_33395_35339[(1)] = (10));

} else {
var statearr_33396_35340 = state_33255__$1;
(statearr_33396_35340[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_33399 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33399[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_33399[(1)] = (1));

return statearr_33399;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_33255){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_33255);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e33401){var ex__30669__auto__ = e33401;
var statearr_33402_35342 = state_33255;
(statearr_33402_35342[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_33255[(4)]))){
var statearr_33403_35343 = state_33255;
(statearr_33403_35343[(1)] = cljs.core.first((state_33255[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35347 = state_33255;
state_33255 = G__35347;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_33255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_33255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_33405 = f__31232__auto__();
(statearr_33405[(6)] = c__31231__auto___35292);

return statearr_33405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__33411 = arguments.length;
switch (G__33411) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__33419 = arguments.length;
switch (G__33419) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__33451 = arguments.length;
switch (G__33451) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__31231__auto___35365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_33519){
var state_val_33520 = (state_33519[(1)]);
if((state_val_33520 === (7))){
var state_33519__$1 = state_33519;
var statearr_33526_35366 = state_33519__$1;
(statearr_33526_35366[(2)] = null);

(statearr_33526_35366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (1))){
var state_33519__$1 = state_33519;
var statearr_33527_35367 = state_33519__$1;
(statearr_33527_35367[(2)] = null);

(statearr_33527_35367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (4))){
var inst_33466 = (state_33519[(7)]);
var inst_33465 = (state_33519[(8)]);
var inst_33469 = (inst_33466 < inst_33465);
var state_33519__$1 = state_33519;
if(cljs.core.truth_(inst_33469)){
var statearr_33534_35368 = state_33519__$1;
(statearr_33534_35368[(1)] = (6));

} else {
var statearr_33536_35369 = state_33519__$1;
(statearr_33536_35369[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (15))){
var inst_33504 = (state_33519[(9)]);
var inst_33509 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33504);
var state_33519__$1 = state_33519;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33519__$1,(17),out,inst_33509);
} else {
if((state_val_33520 === (13))){
var inst_33504 = (state_33519[(9)]);
var inst_33504__$1 = (state_33519[(2)]);
var inst_33505 = cljs.core.some(cljs.core.nil_QMARK_,inst_33504__$1);
var state_33519__$1 = (function (){var statearr_33540 = state_33519;
(statearr_33540[(9)] = inst_33504__$1);

return statearr_33540;
})();
if(cljs.core.truth_(inst_33505)){
var statearr_33545_35376 = state_33519__$1;
(statearr_33545_35376[(1)] = (14));

} else {
var statearr_33546_35377 = state_33519__$1;
(statearr_33546_35377[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (6))){
var state_33519__$1 = state_33519;
var statearr_33547_35378 = state_33519__$1;
(statearr_33547_35378[(2)] = null);

(statearr_33547_35378[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (17))){
var inst_33511 = (state_33519[(2)]);
var state_33519__$1 = (function (){var statearr_33565 = state_33519;
(statearr_33565[(10)] = inst_33511);

return statearr_33565;
})();
var statearr_33570_35386 = state_33519__$1;
(statearr_33570_35386[(2)] = null);

(statearr_33570_35386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (3))){
var inst_33516 = (state_33519[(2)]);
var state_33519__$1 = state_33519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33519__$1,inst_33516);
} else {
if((state_val_33520 === (12))){
var _ = (function (){var statearr_33572 = state_33519;
(statearr_33572[(4)] = cljs.core.rest((state_33519[(4)])));

return statearr_33572;
})();
var state_33519__$1 = state_33519;
var ex33561 = (state_33519__$1[(2)]);
var statearr_33575_35387 = state_33519__$1;
(statearr_33575_35387[(5)] = ex33561);


if((ex33561 instanceof Object)){
var statearr_33577_35388 = state_33519__$1;
(statearr_33577_35388[(1)] = (11));

(statearr_33577_35388[(5)] = null);

} else {
throw ex33561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (2))){
var inst_33464 = cljs.core.reset_BANG_(dctr,cnt);
var inst_33465 = cnt;
var inst_33466 = (0);
var state_33519__$1 = (function (){var statearr_33583 = state_33519;
(statearr_33583[(7)] = inst_33466);

(statearr_33583[(8)] = inst_33465);

(statearr_33583[(11)] = inst_33464);

return statearr_33583;
})();
var statearr_33584_35392 = state_33519__$1;
(statearr_33584_35392[(2)] = null);

(statearr_33584_35392[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (11))){
var inst_33482 = (state_33519[(2)]);
var inst_33483 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33519__$1 = (function (){var statearr_33592 = state_33519;
(statearr_33592[(12)] = inst_33482);

return statearr_33592;
})();
var statearr_33593_35393 = state_33519__$1;
(statearr_33593_35393[(2)] = inst_33483);

(statearr_33593_35393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (9))){
var inst_33466 = (state_33519[(7)]);
var _ = (function (){var statearr_33599 = state_33519;
(statearr_33599[(4)] = cljs.core.cons((12),(state_33519[(4)])));

return statearr_33599;
})();
var inst_33489 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33466) : chs__$1.call(null,inst_33466));
var inst_33491 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33466) : done.call(null,inst_33466));
var inst_33492 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33489,inst_33491);
var ___$1 = (function (){var statearr_33600 = state_33519;
(statearr_33600[(4)] = cljs.core.rest((state_33519[(4)])));

return statearr_33600;
})();
var state_33519__$1 = state_33519;
var statearr_33603_35395 = state_33519__$1;
(statearr_33603_35395[(2)] = inst_33492);

(statearr_33603_35395[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (5))){
var inst_33502 = (state_33519[(2)]);
var state_33519__$1 = (function (){var statearr_33605 = state_33519;
(statearr_33605[(13)] = inst_33502);

return statearr_33605;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33519__$1,(13),dchan);
} else {
if((state_val_33520 === (14))){
var inst_33507 = cljs.core.async.close_BANG_(out);
var state_33519__$1 = state_33519;
var statearr_33607_35396 = state_33519__$1;
(statearr_33607_35396[(2)] = inst_33507);

(statearr_33607_35396[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (16))){
var inst_33514 = (state_33519[(2)]);
var state_33519__$1 = state_33519;
var statearr_33609_35398 = state_33519__$1;
(statearr_33609_35398[(2)] = inst_33514);

(statearr_33609_35398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (10))){
var inst_33466 = (state_33519[(7)]);
var inst_33495 = (state_33519[(2)]);
var inst_33496 = (inst_33466 + (1));
var inst_33466__$1 = inst_33496;
var state_33519__$1 = (function (){var statearr_33612 = state_33519;
(statearr_33612[(7)] = inst_33466__$1);

(statearr_33612[(14)] = inst_33495);

return statearr_33612;
})();
var statearr_33613_35399 = state_33519__$1;
(statearr_33613_35399[(2)] = null);

(statearr_33613_35399[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33520 === (8))){
var inst_33500 = (state_33519[(2)]);
var state_33519__$1 = state_33519;
var statearr_33615_35400 = state_33519__$1;
(statearr_33615_35400[(2)] = inst_33500);

(statearr_33615_35400[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_33619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33619[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_33619[(1)] = (1));

return statearr_33619;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_33519){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_33519);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e33620){var ex__30669__auto__ = e33620;
var statearr_33622_35401 = state_33519;
(statearr_33622_35401[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_33519[(4)]))){
var statearr_33623_35403 = state_33519;
(statearr_33623_35403[(1)] = cljs.core.first((state_33519[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35404 = state_33519;
state_33519 = G__35404;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_33519){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_33519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_33627 = f__31232__auto__();
(statearr_33627[(6)] = c__31231__auto___35365);

return statearr_33627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33634 = arguments.length;
switch (G__33634) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31231__auto___35416 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_33683){
var state_val_33684 = (state_33683[(1)]);
if((state_val_33684 === (7))){
var inst_33652 = (state_33683[(7)]);
var inst_33650 = (state_33683[(8)]);
var inst_33650__$1 = (state_33683[(2)]);
var inst_33652__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33650__$1,(0),null);
var inst_33654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33650__$1,(1),null);
var inst_33655 = (inst_33652__$1 == null);
var state_33683__$1 = (function (){var statearr_33701 = state_33683;
(statearr_33701[(7)] = inst_33652__$1);

(statearr_33701[(9)] = inst_33654);

(statearr_33701[(8)] = inst_33650__$1);

return statearr_33701;
})();
if(cljs.core.truth_(inst_33655)){
var statearr_33702_35417 = state_33683__$1;
(statearr_33702_35417[(1)] = (8));

} else {
var statearr_33703_35418 = state_33683__$1;
(statearr_33703_35418[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (1))){
var inst_33640 = cljs.core.vec(chs);
var inst_33641 = inst_33640;
var state_33683__$1 = (function (){var statearr_33704 = state_33683;
(statearr_33704[(10)] = inst_33641);

return statearr_33704;
})();
var statearr_33706_35419 = state_33683__$1;
(statearr_33706_35419[(2)] = null);

(statearr_33706_35419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (4))){
var inst_33641 = (state_33683[(10)]);
var state_33683__$1 = state_33683;
return cljs.core.async.ioc_alts_BANG_(state_33683__$1,(7),inst_33641);
} else {
if((state_val_33684 === (6))){
var inst_33673 = (state_33683[(2)]);
var state_33683__$1 = state_33683;
var statearr_33711_35420 = state_33683__$1;
(statearr_33711_35420[(2)] = inst_33673);

(statearr_33711_35420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (3))){
var inst_33675 = (state_33683[(2)]);
var state_33683__$1 = state_33683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33683__$1,inst_33675);
} else {
if((state_val_33684 === (2))){
var inst_33641 = (state_33683[(10)]);
var inst_33643 = cljs.core.count(inst_33641);
var inst_33644 = (inst_33643 > (0));
var state_33683__$1 = state_33683;
if(cljs.core.truth_(inst_33644)){
var statearr_33716_35426 = state_33683__$1;
(statearr_33716_35426[(1)] = (4));

} else {
var statearr_33717_35427 = state_33683__$1;
(statearr_33717_35427[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (11))){
var inst_33641 = (state_33683[(10)]);
var inst_33665 = (state_33683[(2)]);
var tmp33714 = inst_33641;
var inst_33641__$1 = tmp33714;
var state_33683__$1 = (function (){var statearr_33719 = state_33683;
(statearr_33719[(11)] = inst_33665);

(statearr_33719[(10)] = inst_33641__$1);

return statearr_33719;
})();
var statearr_33720_35430 = state_33683__$1;
(statearr_33720_35430[(2)] = null);

(statearr_33720_35430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (9))){
var inst_33652 = (state_33683[(7)]);
var state_33683__$1 = state_33683;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33683__$1,(11),out,inst_33652);
} else {
if((state_val_33684 === (5))){
var inst_33671 = cljs.core.async.close_BANG_(out);
var state_33683__$1 = state_33683;
var statearr_33724_35431 = state_33683__$1;
(statearr_33724_35431[(2)] = inst_33671);

(statearr_33724_35431[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (10))){
var inst_33669 = (state_33683[(2)]);
var state_33683__$1 = state_33683;
var statearr_33725_35436 = state_33683__$1;
(statearr_33725_35436[(2)] = inst_33669);

(statearr_33725_35436[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33684 === (8))){
var inst_33652 = (state_33683[(7)]);
var inst_33654 = (state_33683[(9)]);
var inst_33641 = (state_33683[(10)]);
var inst_33650 = (state_33683[(8)]);
var inst_33659 = (function (){var cs = inst_33641;
var vec__33646 = inst_33650;
var v = inst_33652;
var c = inst_33654;
return (function (p1__33629_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33629_SHARP_);
});
})();
var inst_33660 = cljs.core.filterv(inst_33659,inst_33641);
var inst_33641__$1 = inst_33660;
var state_33683__$1 = (function (){var statearr_33727 = state_33683;
(statearr_33727[(10)] = inst_33641__$1);

return statearr_33727;
})();
var statearr_33730_35439 = state_33683__$1;
(statearr_33730_35439[(2)] = null);

(statearr_33730_35439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_33732 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33732[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_33732[(1)] = (1));

return statearr_33732;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_33683){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_33683);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e33734){var ex__30669__auto__ = e33734;
var statearr_33735_35448 = state_33683;
(statearr_33735_35448[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_33683[(4)]))){
var statearr_33736_35449 = state_33683;
(statearr_33736_35449[(1)] = cljs.core.first((state_33683[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35450 = state_33683;
state_33683 = G__35450;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_33683){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_33683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_33741 = f__31232__auto__();
(statearr_33741[(6)] = c__31231__auto___35416);

return statearr_33741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33749 = arguments.length;
switch (G__33749) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31231__auto___35462 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_33778){
var state_val_33779 = (state_33778[(1)]);
if((state_val_33779 === (7))){
var inst_33756 = (state_33778[(7)]);
var inst_33756__$1 = (state_33778[(2)]);
var inst_33761 = (inst_33756__$1 == null);
var inst_33762 = cljs.core.not(inst_33761);
var state_33778__$1 = (function (){var statearr_33782 = state_33778;
(statearr_33782[(7)] = inst_33756__$1);

return statearr_33782;
})();
if(inst_33762){
var statearr_33783_35464 = state_33778__$1;
(statearr_33783_35464[(1)] = (8));

} else {
var statearr_33784_35465 = state_33778__$1;
(statearr_33784_35465[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (1))){
var inst_33751 = (0);
var state_33778__$1 = (function (){var statearr_33787 = state_33778;
(statearr_33787[(8)] = inst_33751);

return statearr_33787;
})();
var statearr_33788_35466 = state_33778__$1;
(statearr_33788_35466[(2)] = null);

(statearr_33788_35466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (4))){
var state_33778__$1 = state_33778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33778__$1,(7),ch);
} else {
if((state_val_33779 === (6))){
var inst_33773 = (state_33778[(2)]);
var state_33778__$1 = state_33778;
var statearr_33790_35470 = state_33778__$1;
(statearr_33790_35470[(2)] = inst_33773);

(statearr_33790_35470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (3))){
var inst_33775 = (state_33778[(2)]);
var inst_33776 = cljs.core.async.close_BANG_(out);
var state_33778__$1 = (function (){var statearr_33792 = state_33778;
(statearr_33792[(9)] = inst_33775);

return statearr_33792;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33778__$1,inst_33776);
} else {
if((state_val_33779 === (2))){
var inst_33751 = (state_33778[(8)]);
var inst_33753 = (inst_33751 < n);
var state_33778__$1 = state_33778;
if(cljs.core.truth_(inst_33753)){
var statearr_33793_35471 = state_33778__$1;
(statearr_33793_35471[(1)] = (4));

} else {
var statearr_33794_35472 = state_33778__$1;
(statearr_33794_35472[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (11))){
var inst_33751 = (state_33778[(8)]);
var inst_33765 = (state_33778[(2)]);
var inst_33766 = (inst_33751 + (1));
var inst_33751__$1 = inst_33766;
var state_33778__$1 = (function (){var statearr_33795 = state_33778;
(statearr_33795[(8)] = inst_33751__$1);

(statearr_33795[(10)] = inst_33765);

return statearr_33795;
})();
var statearr_33796_35476 = state_33778__$1;
(statearr_33796_35476[(2)] = null);

(statearr_33796_35476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (9))){
var state_33778__$1 = state_33778;
var statearr_33797_35477 = state_33778__$1;
(statearr_33797_35477[(2)] = null);

(statearr_33797_35477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (5))){
var state_33778__$1 = state_33778;
var statearr_33798_35478 = state_33778__$1;
(statearr_33798_35478[(2)] = null);

(statearr_33798_35478[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (10))){
var inst_33770 = (state_33778[(2)]);
var state_33778__$1 = state_33778;
var statearr_33799_35479 = state_33778__$1;
(statearr_33799_35479[(2)] = inst_33770);

(statearr_33799_35479[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33779 === (8))){
var inst_33756 = (state_33778[(7)]);
var state_33778__$1 = state_33778;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33778__$1,(11),out,inst_33756);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_33803 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33803[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_33803[(1)] = (1));

return statearr_33803;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_33778){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_33778);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e33805){var ex__30669__auto__ = e33805;
var statearr_33806_35480 = state_33778;
(statearr_33806_35480[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_33778[(4)]))){
var statearr_33807_35481 = state_33778;
(statearr_33807_35481[(1)] = cljs.core.first((state_33778[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35482 = state_33778;
state_33778 = G__35482;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_33778){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_33778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_33812 = f__31232__auto__();
(statearr_33812[(6)] = c__31231__auto___35462);

return statearr_33812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33823 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33823 = (function (f,ch,meta33824){
this.f = f;
this.ch = ch;
this.meta33824 = meta33824;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33825,meta33824__$1){
var self__ = this;
var _33825__$1 = this;
return (new cljs.core.async.t_cljs$core$async33823(self__.f,self__.ch,meta33824__$1));
}));

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33825){
var self__ = this;
var _33825__$1 = this;
return self__.meta33824;
}));

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33840 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33840 = (function (f,ch,meta33824,_,fn1,meta33841){
this.f = f;
this.ch = ch;
this.meta33824 = meta33824;
this._ = _;
this.fn1 = fn1;
this.meta33841 = meta33841;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33840.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33842,meta33841__$1){
var self__ = this;
var _33842__$1 = this;
return (new cljs.core.async.t_cljs$core$async33840(self__.f,self__.ch,self__.meta33824,self__._,self__.fn1,meta33841__$1));
}));

(cljs.core.async.t_cljs$core$async33840.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33842){
var self__ = this;
var _33842__$1 = this;
return self__.meta33841;
}));

(cljs.core.async.t_cljs$core$async33840.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33840.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33840.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33840.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33817_SHARP_){
var G__33852 = (((p1__33817_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33817_SHARP_) : self__.f.call(null,p1__33817_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33852) : f1.call(null,G__33852));
});
}));

(cljs.core.async.t_cljs$core$async33840.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33824","meta33824",-315406175,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33823","cljs.core.async/t_cljs$core$async33823",-397385892,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33841","meta33841",-1591584581,null)], null);
}));

(cljs.core.async.t_cljs$core$async33840.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33840.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33840");

(cljs.core.async.t_cljs$core$async33840.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33840");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33840.
 */
cljs.core.async.__GT_t_cljs$core$async33840 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33840(f__$1,ch__$1,meta33824__$1,___$2,fn1__$1,meta33841){
return (new cljs.core.async.t_cljs$core$async33840(f__$1,ch__$1,meta33824__$1,___$2,fn1__$1,meta33841));
});

}

return (new cljs.core.async.t_cljs$core$async33840(self__.f,self__.ch,self__.meta33824,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33862 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33862) : self__.f.call(null,G__33862));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33823.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33823.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33824","meta33824",-315406175,null)], null);
}));

(cljs.core.async.t_cljs$core$async33823.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33823.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33823");

(cljs.core.async.t_cljs$core$async33823.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33823");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33823.
 */
cljs.core.async.__GT_t_cljs$core$async33823 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33823(f__$1,ch__$1,meta33824){
return (new cljs.core.async.t_cljs$core$async33823(f__$1,ch__$1,meta33824));
});

}

return (new cljs.core.async.t_cljs$core$async33823(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33873 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33873 = (function (f,ch,meta33874){
this.f = f;
this.ch = ch;
this.meta33874 = meta33874;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33875,meta33874__$1){
var self__ = this;
var _33875__$1 = this;
return (new cljs.core.async.t_cljs$core$async33873(self__.f,self__.ch,meta33874__$1));
}));

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33875){
var self__ = this;
var _33875__$1 = this;
return self__.meta33874;
}));

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33873.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33873.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33874","meta33874",1539187873,null)], null);
}));

(cljs.core.async.t_cljs$core$async33873.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33873.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33873");

(cljs.core.async.t_cljs$core$async33873.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33873");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33873.
 */
cljs.core.async.__GT_t_cljs$core$async33873 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33873(f__$1,ch__$1,meta33874){
return (new cljs.core.async.t_cljs$core$async33873(f__$1,ch__$1,meta33874));
});

}

return (new cljs.core.async.t_cljs$core$async33873(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33894 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33894 = (function (p,ch,meta33895){
this.p = p;
this.ch = ch;
this.meta33895 = meta33895;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33896,meta33895__$1){
var self__ = this;
var _33896__$1 = this;
return (new cljs.core.async.t_cljs$core$async33894(self__.p,self__.ch,meta33895__$1));
}));

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33896){
var self__ = this;
var _33896__$1 = this;
return self__.meta33895;
}));

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33894.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33894.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33895","meta33895",632764259,null)], null);
}));

(cljs.core.async.t_cljs$core$async33894.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33894.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33894");

(cljs.core.async.t_cljs$core$async33894.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33894");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33894.
 */
cljs.core.async.__GT_t_cljs$core$async33894 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33894(p__$1,ch__$1,meta33895){
return (new cljs.core.async.t_cljs$core$async33894(p__$1,ch__$1,meta33895));
});

}

return (new cljs.core.async.t_cljs$core$async33894(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33936 = arguments.length;
switch (G__33936) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31231__auto___35499 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_33981){
var state_val_33982 = (state_33981[(1)]);
if((state_val_33982 === (7))){
var inst_33977 = (state_33981[(2)]);
var state_33981__$1 = state_33981;
var statearr_33983_35500 = state_33981__$1;
(statearr_33983_35500[(2)] = inst_33977);

(statearr_33983_35500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (1))){
var state_33981__$1 = state_33981;
var statearr_33984_35501 = state_33981__$1;
(statearr_33984_35501[(2)] = null);

(statearr_33984_35501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (4))){
var inst_33959 = (state_33981[(7)]);
var inst_33959__$1 = (state_33981[(2)]);
var inst_33960 = (inst_33959__$1 == null);
var state_33981__$1 = (function (){var statearr_33985 = state_33981;
(statearr_33985[(7)] = inst_33959__$1);

return statearr_33985;
})();
if(cljs.core.truth_(inst_33960)){
var statearr_33986_35502 = state_33981__$1;
(statearr_33986_35502[(1)] = (5));

} else {
var statearr_33987_35503 = state_33981__$1;
(statearr_33987_35503[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (6))){
var inst_33959 = (state_33981[(7)]);
var inst_33968 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33959) : p.call(null,inst_33959));
var state_33981__$1 = state_33981;
if(cljs.core.truth_(inst_33968)){
var statearr_34002_35507 = state_33981__$1;
(statearr_34002_35507[(1)] = (8));

} else {
var statearr_34006_35508 = state_33981__$1;
(statearr_34006_35508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (3))){
var inst_33979 = (state_33981[(2)]);
var state_33981__$1 = state_33981;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33981__$1,inst_33979);
} else {
if((state_val_33982 === (2))){
var state_33981__$1 = state_33981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33981__$1,(4),ch);
} else {
if((state_val_33982 === (11))){
var inst_33971 = (state_33981[(2)]);
var state_33981__$1 = state_33981;
var statearr_34008_35509 = state_33981__$1;
(statearr_34008_35509[(2)] = inst_33971);

(statearr_34008_35509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (9))){
var state_33981__$1 = state_33981;
var statearr_34009_35510 = state_33981__$1;
(statearr_34009_35510[(2)] = null);

(statearr_34009_35510[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (5))){
var inst_33962 = cljs.core.async.close_BANG_(out);
var state_33981__$1 = state_33981;
var statearr_34011_35511 = state_33981__$1;
(statearr_34011_35511[(2)] = inst_33962);

(statearr_34011_35511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (10))){
var inst_33974 = (state_33981[(2)]);
var state_33981__$1 = (function (){var statearr_34012 = state_33981;
(statearr_34012[(8)] = inst_33974);

return statearr_34012;
})();
var statearr_34013_35512 = state_33981__$1;
(statearr_34013_35512[(2)] = null);

(statearr_34013_35512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33982 === (8))){
var inst_33959 = (state_33981[(7)]);
var state_33981__$1 = state_33981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33981__$1,(11),out,inst_33959);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_34029 = [null,null,null,null,null,null,null,null,null];
(statearr_34029[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_34029[(1)] = (1));

return statearr_34029;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_33981){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_33981);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e34035){var ex__30669__auto__ = e34035;
var statearr_34041_35513 = state_33981;
(statearr_34041_35513[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_33981[(4)]))){
var statearr_34044_35514 = state_33981;
(statearr_34044_35514[(1)] = cljs.core.first((state_33981[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35515 = state_33981;
state_33981 = G__35515;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_33981){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_33981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_34051 = f__31232__auto__();
(statearr_34051[(6)] = c__31231__auto___35499);

return statearr_34051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__34060 = arguments.length;
switch (G__34060) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31231__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_34165){
var state_val_34166 = (state_34165[(1)]);
if((state_val_34166 === (7))){
var inst_34157 = (state_34165[(2)]);
var state_34165__$1 = state_34165;
var statearr_34172_35517 = state_34165__$1;
(statearr_34172_35517[(2)] = inst_34157);

(statearr_34172_35517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (20))){
var inst_34120 = (state_34165[(7)]);
var inst_34136 = (state_34165[(2)]);
var inst_34137 = cljs.core.next(inst_34120);
var inst_34098 = inst_34137;
var inst_34099 = null;
var inst_34100 = (0);
var inst_34101 = (0);
var state_34165__$1 = (function (){var statearr_34176 = state_34165;
(statearr_34176[(8)] = inst_34098);

(statearr_34176[(9)] = inst_34101);

(statearr_34176[(10)] = inst_34136);

(statearr_34176[(11)] = inst_34100);

(statearr_34176[(12)] = inst_34099);

return statearr_34176;
})();
var statearr_34184_35519 = state_34165__$1;
(statearr_34184_35519[(2)] = null);

(statearr_34184_35519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (1))){
var state_34165__$1 = state_34165;
var statearr_34193_35520 = state_34165__$1;
(statearr_34193_35520[(2)] = null);

(statearr_34193_35520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (4))){
var inst_34087 = (state_34165[(13)]);
var inst_34087__$1 = (state_34165[(2)]);
var inst_34088 = (inst_34087__$1 == null);
var state_34165__$1 = (function (){var statearr_34198 = state_34165;
(statearr_34198[(13)] = inst_34087__$1);

return statearr_34198;
})();
if(cljs.core.truth_(inst_34088)){
var statearr_34199_35521 = state_34165__$1;
(statearr_34199_35521[(1)] = (5));

} else {
var statearr_34200_35522 = state_34165__$1;
(statearr_34200_35522[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (15))){
var state_34165__$1 = state_34165;
var statearr_34208_35523 = state_34165__$1;
(statearr_34208_35523[(2)] = null);

(statearr_34208_35523[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (21))){
var state_34165__$1 = state_34165;
var statearr_34210_35524 = state_34165__$1;
(statearr_34210_35524[(2)] = null);

(statearr_34210_35524[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (13))){
var inst_34098 = (state_34165[(8)]);
var inst_34101 = (state_34165[(9)]);
var inst_34100 = (state_34165[(11)]);
var inst_34099 = (state_34165[(12)]);
var inst_34111 = (state_34165[(2)]);
var inst_34116 = (inst_34101 + (1));
var tmp34204 = inst_34098;
var tmp34205 = inst_34100;
var tmp34206 = inst_34099;
var inst_34098__$1 = tmp34204;
var inst_34099__$1 = tmp34206;
var inst_34100__$1 = tmp34205;
var inst_34101__$1 = inst_34116;
var state_34165__$1 = (function (){var statearr_34216 = state_34165;
(statearr_34216[(14)] = inst_34111);

(statearr_34216[(8)] = inst_34098__$1);

(statearr_34216[(9)] = inst_34101__$1);

(statearr_34216[(11)] = inst_34100__$1);

(statearr_34216[(12)] = inst_34099__$1);

return statearr_34216;
})();
var statearr_34217_35525 = state_34165__$1;
(statearr_34217_35525[(2)] = null);

(statearr_34217_35525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (22))){
var state_34165__$1 = state_34165;
var statearr_34221_35526 = state_34165__$1;
(statearr_34221_35526[(2)] = null);

(statearr_34221_35526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (6))){
var inst_34087 = (state_34165[(13)]);
var inst_34096 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34087) : f.call(null,inst_34087));
var inst_34097 = cljs.core.seq(inst_34096);
var inst_34098 = inst_34097;
var inst_34099 = null;
var inst_34100 = (0);
var inst_34101 = (0);
var state_34165__$1 = (function (){var statearr_34226 = state_34165;
(statearr_34226[(8)] = inst_34098);

(statearr_34226[(9)] = inst_34101);

(statearr_34226[(11)] = inst_34100);

(statearr_34226[(12)] = inst_34099);

return statearr_34226;
})();
var statearr_34227_35530 = state_34165__$1;
(statearr_34227_35530[(2)] = null);

(statearr_34227_35530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (17))){
var inst_34120 = (state_34165[(7)]);
var inst_34124 = cljs.core.chunk_first(inst_34120);
var inst_34125 = cljs.core.chunk_rest(inst_34120);
var inst_34126 = cljs.core.count(inst_34124);
var inst_34098 = inst_34125;
var inst_34099 = inst_34124;
var inst_34100 = inst_34126;
var inst_34101 = (0);
var state_34165__$1 = (function (){var statearr_34234 = state_34165;
(statearr_34234[(8)] = inst_34098);

(statearr_34234[(9)] = inst_34101);

(statearr_34234[(11)] = inst_34100);

(statearr_34234[(12)] = inst_34099);

return statearr_34234;
})();
var statearr_34236_35539 = state_34165__$1;
(statearr_34236_35539[(2)] = null);

(statearr_34236_35539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (3))){
var inst_34159 = (state_34165[(2)]);
var state_34165__$1 = state_34165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34165__$1,inst_34159);
} else {
if((state_val_34166 === (12))){
var inst_34147 = (state_34165[(2)]);
var state_34165__$1 = state_34165;
var statearr_34242_35543 = state_34165__$1;
(statearr_34242_35543[(2)] = inst_34147);

(statearr_34242_35543[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (2))){
var state_34165__$1 = state_34165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34165__$1,(4),in$);
} else {
if((state_val_34166 === (23))){
var inst_34155 = (state_34165[(2)]);
var state_34165__$1 = state_34165;
var statearr_34250_35544 = state_34165__$1;
(statearr_34250_35544[(2)] = inst_34155);

(statearr_34250_35544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (19))){
var inst_34141 = (state_34165[(2)]);
var state_34165__$1 = state_34165;
var statearr_34254_35545 = state_34165__$1;
(statearr_34254_35545[(2)] = inst_34141);

(statearr_34254_35545[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (11))){
var inst_34098 = (state_34165[(8)]);
var inst_34120 = (state_34165[(7)]);
var inst_34120__$1 = cljs.core.seq(inst_34098);
var state_34165__$1 = (function (){var statearr_34258 = state_34165;
(statearr_34258[(7)] = inst_34120__$1);

return statearr_34258;
})();
if(inst_34120__$1){
var statearr_34262_35550 = state_34165__$1;
(statearr_34262_35550[(1)] = (14));

} else {
var statearr_34263_35551 = state_34165__$1;
(statearr_34263_35551[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (9))){
var inst_34149 = (state_34165[(2)]);
var inst_34150 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_34165__$1 = (function (){var statearr_34267 = state_34165;
(statearr_34267[(15)] = inst_34149);

return statearr_34267;
})();
if(cljs.core.truth_(inst_34150)){
var statearr_34271_35552 = state_34165__$1;
(statearr_34271_35552[(1)] = (21));

} else {
var statearr_34272_35553 = state_34165__$1;
(statearr_34272_35553[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (5))){
var inst_34090 = cljs.core.async.close_BANG_(out);
var state_34165__$1 = state_34165;
var statearr_34273_35554 = state_34165__$1;
(statearr_34273_35554[(2)] = inst_34090);

(statearr_34273_35554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (14))){
var inst_34120 = (state_34165[(7)]);
var inst_34122 = cljs.core.chunked_seq_QMARK_(inst_34120);
var state_34165__$1 = state_34165;
if(inst_34122){
var statearr_34278_35558 = state_34165__$1;
(statearr_34278_35558[(1)] = (17));

} else {
var statearr_34280_35559 = state_34165__$1;
(statearr_34280_35559[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (16))){
var inst_34145 = (state_34165[(2)]);
var state_34165__$1 = state_34165;
var statearr_34284_35560 = state_34165__$1;
(statearr_34284_35560[(2)] = inst_34145);

(statearr_34284_35560[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34166 === (10))){
var inst_34101 = (state_34165[(9)]);
var inst_34099 = (state_34165[(12)]);
var inst_34106 = cljs.core._nth(inst_34099,inst_34101);
var state_34165__$1 = state_34165;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34165__$1,(13),out,inst_34106);
} else {
if((state_val_34166 === (18))){
var inst_34120 = (state_34165[(7)]);
var inst_34132 = cljs.core.first(inst_34120);
var state_34165__$1 = state_34165;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34165__$1,(20),out,inst_34132);
} else {
if((state_val_34166 === (8))){
var inst_34101 = (state_34165[(9)]);
var inst_34100 = (state_34165[(11)]);
var inst_34103 = (inst_34101 < inst_34100);
var inst_34104 = inst_34103;
var state_34165__$1 = state_34165;
if(cljs.core.truth_(inst_34104)){
var statearr_34296_35564 = state_34165__$1;
(statearr_34296_35564[(1)] = (10));

} else {
var statearr_34297_35565 = state_34165__$1;
(statearr_34297_35565[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30666__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30666__auto____0 = (function (){
var statearr_34304 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34304[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30666__auto__);

(statearr_34304[(1)] = (1));

return statearr_34304;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30666__auto____1 = (function (state_34165){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_34165);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e34309){var ex__30669__auto__ = e34309;
var statearr_34310_35566 = state_34165;
(statearr_34310_35566[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_34165[(4)]))){
var statearr_34312_35567 = state_34165;
(statearr_34312_35567[(1)] = cljs.core.first((state_34165[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35568 = state_34165;
state_34165 = G__35568;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30666__auto__ = function(state_34165){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30666__auto____1.call(this,state_34165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30666__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30666__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_34318 = f__31232__auto__();
(statearr_34318[(6)] = c__31231__auto__);

return statearr_34318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));

return c__31231__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__34335 = arguments.length;
switch (G__34335) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__34355 = arguments.length;
switch (G__34355) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__34371 = arguments.length;
switch (G__34371) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31231__auto___35578 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_34396){
var state_val_34398 = (state_34396[(1)]);
if((state_val_34398 === (7))){
var inst_34391 = (state_34396[(2)]);
var state_34396__$1 = state_34396;
var statearr_34399_35579 = state_34396__$1;
(statearr_34399_35579[(2)] = inst_34391);

(statearr_34399_35579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (1))){
var inst_34373 = null;
var state_34396__$1 = (function (){var statearr_34400 = state_34396;
(statearr_34400[(7)] = inst_34373);

return statearr_34400;
})();
var statearr_34401_35580 = state_34396__$1;
(statearr_34401_35580[(2)] = null);

(statearr_34401_35580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (4))){
var inst_34376 = (state_34396[(8)]);
var inst_34376__$1 = (state_34396[(2)]);
var inst_34377 = (inst_34376__$1 == null);
var inst_34378 = cljs.core.not(inst_34377);
var state_34396__$1 = (function (){var statearr_34404 = state_34396;
(statearr_34404[(8)] = inst_34376__$1);

return statearr_34404;
})();
if(inst_34378){
var statearr_34405_35581 = state_34396__$1;
(statearr_34405_35581[(1)] = (5));

} else {
var statearr_34406_35582 = state_34396__$1;
(statearr_34406_35582[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (6))){
var state_34396__$1 = state_34396;
var statearr_34408_35583 = state_34396__$1;
(statearr_34408_35583[(2)] = null);

(statearr_34408_35583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (3))){
var inst_34393 = (state_34396[(2)]);
var inst_34394 = cljs.core.async.close_BANG_(out);
var state_34396__$1 = (function (){var statearr_34409 = state_34396;
(statearr_34409[(9)] = inst_34393);

return statearr_34409;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34396__$1,inst_34394);
} else {
if((state_val_34398 === (2))){
var state_34396__$1 = state_34396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34396__$1,(4),ch);
} else {
if((state_val_34398 === (11))){
var inst_34376 = (state_34396[(8)]);
var inst_34385 = (state_34396[(2)]);
var inst_34373 = inst_34376;
var state_34396__$1 = (function (){var statearr_34422 = state_34396;
(statearr_34422[(10)] = inst_34385);

(statearr_34422[(7)] = inst_34373);

return statearr_34422;
})();
var statearr_34423_35593 = state_34396__$1;
(statearr_34423_35593[(2)] = null);

(statearr_34423_35593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (9))){
var inst_34376 = (state_34396[(8)]);
var state_34396__$1 = state_34396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34396__$1,(11),out,inst_34376);
} else {
if((state_val_34398 === (5))){
var inst_34376 = (state_34396[(8)]);
var inst_34373 = (state_34396[(7)]);
var inst_34380 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34376,inst_34373);
var state_34396__$1 = state_34396;
if(inst_34380){
var statearr_34429_35594 = state_34396__$1;
(statearr_34429_35594[(1)] = (8));

} else {
var statearr_34430_35595 = state_34396__$1;
(statearr_34430_35595[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (10))){
var inst_34388 = (state_34396[(2)]);
var state_34396__$1 = state_34396;
var statearr_34431_35602 = state_34396__$1;
(statearr_34431_35602[(2)] = inst_34388);

(statearr_34431_35602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34398 === (8))){
var inst_34373 = (state_34396[(7)]);
var tmp34428 = inst_34373;
var inst_34373__$1 = tmp34428;
var state_34396__$1 = (function (){var statearr_34432 = state_34396;
(statearr_34432[(7)] = inst_34373__$1);

return statearr_34432;
})();
var statearr_34433_35603 = state_34396__$1;
(statearr_34433_35603[(2)] = null);

(statearr_34433_35603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_34435 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34435[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_34435[(1)] = (1));

return statearr_34435;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_34396){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_34396);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e34436){var ex__30669__auto__ = e34436;
var statearr_34438_35604 = state_34396;
(statearr_34438_35604[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_34396[(4)]))){
var statearr_34439_35605 = state_34396;
(statearr_34439_35605[(1)] = cljs.core.first((state_34396[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35606 = state_34396;
state_34396 = G__35606;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_34396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_34396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_34441 = f__31232__auto__();
(statearr_34441[(6)] = c__31231__auto___35578);

return statearr_34441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__34445 = arguments.length;
switch (G__34445) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31231__auto___35608 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_34505){
var state_val_34506 = (state_34505[(1)]);
if((state_val_34506 === (7))){
var inst_34482 = (state_34505[(2)]);
var state_34505__$1 = state_34505;
var statearr_34507_35609 = state_34505__$1;
(statearr_34507_35609[(2)] = inst_34482);

(statearr_34507_35609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (1))){
var inst_34449 = (new Array(n));
var inst_34450 = inst_34449;
var inst_34451 = (0);
var state_34505__$1 = (function (){var statearr_34515 = state_34505;
(statearr_34515[(7)] = inst_34451);

(statearr_34515[(8)] = inst_34450);

return statearr_34515;
})();
var statearr_34516_35610 = state_34505__$1;
(statearr_34516_35610[(2)] = null);

(statearr_34516_35610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (4))){
var inst_34454 = (state_34505[(9)]);
var inst_34454__$1 = (state_34505[(2)]);
var inst_34455 = (inst_34454__$1 == null);
var inst_34456 = cljs.core.not(inst_34455);
var state_34505__$1 = (function (){var statearr_34520 = state_34505;
(statearr_34520[(9)] = inst_34454__$1);

return statearr_34520;
})();
if(inst_34456){
var statearr_34521_35611 = state_34505__$1;
(statearr_34521_35611[(1)] = (5));

} else {
var statearr_34522_35612 = state_34505__$1;
(statearr_34522_35612[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (15))){
var inst_34476 = (state_34505[(2)]);
var state_34505__$1 = state_34505;
var statearr_34526_35615 = state_34505__$1;
(statearr_34526_35615[(2)] = inst_34476);

(statearr_34526_35615[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (13))){
var state_34505__$1 = state_34505;
var statearr_34527_35620 = state_34505__$1;
(statearr_34527_35620[(2)] = null);

(statearr_34527_35620[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (6))){
var inst_34451 = (state_34505[(7)]);
var inst_34472 = (inst_34451 > (0));
var state_34505__$1 = state_34505;
if(cljs.core.truth_(inst_34472)){
var statearr_34528_35621 = state_34505__$1;
(statearr_34528_35621[(1)] = (12));

} else {
var statearr_34529_35622 = state_34505__$1;
(statearr_34529_35622[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (3))){
var inst_34484 = (state_34505[(2)]);
var state_34505__$1 = state_34505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34505__$1,inst_34484);
} else {
if((state_val_34506 === (12))){
var inst_34450 = (state_34505[(8)]);
var inst_34474 = cljs.core.vec(inst_34450);
var state_34505__$1 = state_34505;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34505__$1,(15),out,inst_34474);
} else {
if((state_val_34506 === (2))){
var state_34505__$1 = state_34505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34505__$1,(4),ch);
} else {
if((state_val_34506 === (11))){
var inst_34466 = (state_34505[(2)]);
var inst_34467 = (new Array(n));
var inst_34450 = inst_34467;
var inst_34451 = (0);
var state_34505__$1 = (function (){var statearr_34530 = state_34505;
(statearr_34530[(10)] = inst_34466);

(statearr_34530[(7)] = inst_34451);

(statearr_34530[(8)] = inst_34450);

return statearr_34530;
})();
var statearr_34531_35623 = state_34505__$1;
(statearr_34531_35623[(2)] = null);

(statearr_34531_35623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (9))){
var inst_34450 = (state_34505[(8)]);
var inst_34464 = cljs.core.vec(inst_34450);
var state_34505__$1 = state_34505;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34505__$1,(11),out,inst_34464);
} else {
if((state_val_34506 === (5))){
var inst_34454 = (state_34505[(9)]);
var inst_34451 = (state_34505[(7)]);
var inst_34450 = (state_34505[(8)]);
var inst_34459 = (state_34505[(11)]);
var inst_34458 = (inst_34450[inst_34451] = inst_34454);
var inst_34459__$1 = (inst_34451 + (1));
var inst_34460 = (inst_34459__$1 < n);
var state_34505__$1 = (function (){var statearr_34536 = state_34505;
(statearr_34536[(11)] = inst_34459__$1);

(statearr_34536[(12)] = inst_34458);

return statearr_34536;
})();
if(cljs.core.truth_(inst_34460)){
var statearr_34537_35624 = state_34505__$1;
(statearr_34537_35624[(1)] = (8));

} else {
var statearr_34538_35625 = state_34505__$1;
(statearr_34538_35625[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (14))){
var inst_34479 = (state_34505[(2)]);
var inst_34480 = cljs.core.async.close_BANG_(out);
var state_34505__$1 = (function (){var statearr_34540 = state_34505;
(statearr_34540[(13)] = inst_34479);

return statearr_34540;
})();
var statearr_34541_35626 = state_34505__$1;
(statearr_34541_35626[(2)] = inst_34480);

(statearr_34541_35626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (10))){
var inst_34470 = (state_34505[(2)]);
var state_34505__$1 = state_34505;
var statearr_34542_35627 = state_34505__$1;
(statearr_34542_35627[(2)] = inst_34470);

(statearr_34542_35627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34506 === (8))){
var inst_34450 = (state_34505[(8)]);
var inst_34459 = (state_34505[(11)]);
var tmp34539 = inst_34450;
var inst_34450__$1 = tmp34539;
var inst_34451 = inst_34459;
var state_34505__$1 = (function (){var statearr_34543 = state_34505;
(statearr_34543[(7)] = inst_34451);

(statearr_34543[(8)] = inst_34450__$1);

return statearr_34543;
})();
var statearr_34544_35628 = state_34505__$1;
(statearr_34544_35628[(2)] = null);

(statearr_34544_35628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_34545 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34545[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_34545[(1)] = (1));

return statearr_34545;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_34505){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_34505);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e34546){var ex__30669__auto__ = e34546;
var statearr_34547_35635 = state_34505;
(statearr_34547_35635[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_34505[(4)]))){
var statearr_34548_35636 = state_34505;
(statearr_34548_35636[(1)] = cljs.core.first((state_34505[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35637 = state_34505;
state_34505 = G__35637;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_34505){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_34505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_34549 = f__31232__auto__();
(statearr_34549[(6)] = c__31231__auto___35608);

return statearr_34549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__34555 = arguments.length;
switch (G__34555) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__31231__auto___35639 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__31232__auto__ = (function (){var switch__30665__auto__ = (function (state_34604){
var state_val_34605 = (state_34604[(1)]);
if((state_val_34605 === (7))){
var inst_34600 = (state_34604[(2)]);
var state_34604__$1 = state_34604;
var statearr_34607_35640 = state_34604__$1;
(statearr_34607_35640[(2)] = inst_34600);

(statearr_34607_35640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (1))){
var inst_34560 = [];
var inst_34561 = inst_34560;
var inst_34562 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34604__$1 = (function (){var statearr_34609 = state_34604;
(statearr_34609[(7)] = inst_34561);

(statearr_34609[(8)] = inst_34562);

return statearr_34609;
})();
var statearr_34610_35641 = state_34604__$1;
(statearr_34610_35641[(2)] = null);

(statearr_34610_35641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (4))){
var inst_34565 = (state_34604[(9)]);
var inst_34565__$1 = (state_34604[(2)]);
var inst_34566 = (inst_34565__$1 == null);
var inst_34567 = cljs.core.not(inst_34566);
var state_34604__$1 = (function (){var statearr_34611 = state_34604;
(statearr_34611[(9)] = inst_34565__$1);

return statearr_34611;
})();
if(inst_34567){
var statearr_34612_35642 = state_34604__$1;
(statearr_34612_35642[(1)] = (5));

} else {
var statearr_34613_35643 = state_34604__$1;
(statearr_34613_35643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (15))){
var inst_34561 = (state_34604[(7)]);
var inst_34592 = cljs.core.vec(inst_34561);
var state_34604__$1 = state_34604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34604__$1,(18),out,inst_34592);
} else {
if((state_val_34605 === (13))){
var inst_34587 = (state_34604[(2)]);
var state_34604__$1 = state_34604;
var statearr_34615_35644 = state_34604__$1;
(statearr_34615_35644[(2)] = inst_34587);

(statearr_34615_35644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (6))){
var inst_34561 = (state_34604[(7)]);
var inst_34589 = inst_34561.length;
var inst_34590 = (inst_34589 > (0));
var state_34604__$1 = state_34604;
if(cljs.core.truth_(inst_34590)){
var statearr_34620_35651 = state_34604__$1;
(statearr_34620_35651[(1)] = (15));

} else {
var statearr_34621_35652 = state_34604__$1;
(statearr_34621_35652[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (17))){
var inst_34597 = (state_34604[(2)]);
var inst_34598 = cljs.core.async.close_BANG_(out);
var state_34604__$1 = (function (){var statearr_34622 = state_34604;
(statearr_34622[(10)] = inst_34597);

return statearr_34622;
})();
var statearr_34623_35653 = state_34604__$1;
(statearr_34623_35653[(2)] = inst_34598);

(statearr_34623_35653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (3))){
var inst_34602 = (state_34604[(2)]);
var state_34604__$1 = state_34604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34604__$1,inst_34602);
} else {
if((state_val_34605 === (12))){
var inst_34561 = (state_34604[(7)]);
var inst_34580 = cljs.core.vec(inst_34561);
var state_34604__$1 = state_34604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34604__$1,(14),out,inst_34580);
} else {
if((state_val_34605 === (2))){
var state_34604__$1 = state_34604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34604__$1,(4),ch);
} else {
if((state_val_34605 === (11))){
var inst_34569 = (state_34604[(11)]);
var inst_34565 = (state_34604[(9)]);
var inst_34561 = (state_34604[(7)]);
var inst_34577 = inst_34561.push(inst_34565);
var tmp34624 = inst_34561;
var inst_34561__$1 = tmp34624;
var inst_34562 = inst_34569;
var state_34604__$1 = (function (){var statearr_34625 = state_34604;
(statearr_34625[(12)] = inst_34577);

(statearr_34625[(7)] = inst_34561__$1);

(statearr_34625[(8)] = inst_34562);

return statearr_34625;
})();
var statearr_34626_35654 = state_34604__$1;
(statearr_34626_35654[(2)] = null);

(statearr_34626_35654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (9))){
var inst_34562 = (state_34604[(8)]);
var inst_34573 = cljs.core.keyword_identical_QMARK_(inst_34562,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_34604__$1 = state_34604;
var statearr_34627_35655 = state_34604__$1;
(statearr_34627_35655[(2)] = inst_34573);

(statearr_34627_35655[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (5))){
var inst_34570 = (state_34604[(13)]);
var inst_34569 = (state_34604[(11)]);
var inst_34565 = (state_34604[(9)]);
var inst_34562 = (state_34604[(8)]);
var inst_34569__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34565) : f.call(null,inst_34565));
var inst_34570__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34569__$1,inst_34562);
var state_34604__$1 = (function (){var statearr_34628 = state_34604;
(statearr_34628[(13)] = inst_34570__$1);

(statearr_34628[(11)] = inst_34569__$1);

return statearr_34628;
})();
if(inst_34570__$1){
var statearr_34629_35656 = state_34604__$1;
(statearr_34629_35656[(1)] = (8));

} else {
var statearr_34630_35657 = state_34604__$1;
(statearr_34630_35657[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (14))){
var inst_34569 = (state_34604[(11)]);
var inst_34565 = (state_34604[(9)]);
var inst_34582 = (state_34604[(2)]);
var inst_34583 = [];
var inst_34584 = inst_34583.push(inst_34565);
var inst_34561 = inst_34583;
var inst_34562 = inst_34569;
var state_34604__$1 = (function (){var statearr_34631 = state_34604;
(statearr_34631[(14)] = inst_34584);

(statearr_34631[(7)] = inst_34561);

(statearr_34631[(15)] = inst_34582);

(statearr_34631[(8)] = inst_34562);

return statearr_34631;
})();
var statearr_34632_35658 = state_34604__$1;
(statearr_34632_35658[(2)] = null);

(statearr_34632_35658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (16))){
var state_34604__$1 = state_34604;
var statearr_34633_35659 = state_34604__$1;
(statearr_34633_35659[(2)] = null);

(statearr_34633_35659[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (10))){
var inst_34575 = (state_34604[(2)]);
var state_34604__$1 = state_34604;
if(cljs.core.truth_(inst_34575)){
var statearr_34634_35660 = state_34604__$1;
(statearr_34634_35660[(1)] = (11));

} else {
var statearr_34635_35661 = state_34604__$1;
(statearr_34635_35661[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (18))){
var inst_34594 = (state_34604[(2)]);
var state_34604__$1 = state_34604;
var statearr_34636_35662 = state_34604__$1;
(statearr_34636_35662[(2)] = inst_34594);

(statearr_34636_35662[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34605 === (8))){
var inst_34570 = (state_34604[(13)]);
var state_34604__$1 = state_34604;
var statearr_34637_35663 = state_34604__$1;
(statearr_34637_35663[(2)] = inst_34570);

(statearr_34637_35663[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30666__auto__ = null;
var cljs$core$async$state_machine__30666__auto____0 = (function (){
var statearr_34638 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34638[(0)] = cljs$core$async$state_machine__30666__auto__);

(statearr_34638[(1)] = (1));

return statearr_34638;
});
var cljs$core$async$state_machine__30666__auto____1 = (function (state_34604){
while(true){
var ret_value__30667__auto__ = (function (){try{while(true){
var result__30668__auto__ = switch__30665__auto__(state_34604);
if(cljs.core.keyword_identical_QMARK_(result__30668__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30668__auto__;
}
break;
}
}catch (e34641){var ex__30669__auto__ = e34641;
var statearr_34644_35664 = state_34604;
(statearr_34644_35664[(2)] = ex__30669__auto__);


if(cljs.core.seq((state_34604[(4)]))){
var statearr_34645_35665 = state_34604;
(statearr_34645_35665[(1)] = cljs.core.first((state_34604[(4)])));

} else {
throw ex__30669__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30667__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35666 = state_34604;
state_34604 = G__35666;
continue;
} else {
return ret_value__30667__auto__;
}
break;
}
});
cljs$core$async$state_machine__30666__auto__ = function(state_34604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30666__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30666__auto____1.call(this,state_34604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30666__auto____0;
cljs$core$async$state_machine__30666__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30666__auto____1;
return cljs$core$async$state_machine__30666__auto__;
})()
})();
var state__31233__auto__ = (function (){var statearr_34647 = f__31232__auto__();
(statearr_34647[(6)] = c__31231__auto___35639);

return statearr_34647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__31233__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
