goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41734 = schema.utils.use_fn_validation;
var output_schema41247_41735 = schema.core.Bool;
var input_schema41248_41736 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41249_41737 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41248_41736);
}),null));
var output_checker41250_41738 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41247_41735);
}),null));
var ret__40667__auto___41739 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41251){
var validate__38224__auto__ = cljs.core.deref(ufv___41734);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41740 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41251], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41254_41741 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41255_41742 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41256_41743 = input_schema41248_41736;
var G__41257_41744 = cljs.core.deref(input_checker41249_41737);
var G__41258_41745 = args__38225__auto___41740;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41254_41741,G__41255_41742,G__41256_41743,G__41257_41744,G__41258_41745) : schema.core.fn_validator.call(null,G__41254_41741,G__41255_41742,G__41256_41743,G__41257_41744,G__41258_41745));
} else {
var temp__5804__auto___41746 = (function (){var fexpr__41259 = cljs.core.deref(input_checker41249_41737);
return (fexpr__41259.cljs$core$IFn$_invoke$arity$1 ? fexpr__41259.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41740) : fexpr__41259.call(null,args__38225__auto___41740));
})();
if(cljs.core.truth_(temp__5804__auto___41746)){
var error__38226__auto___41747 = temp__5804__auto___41746;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41747], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41248_41736,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41740,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41747], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var arg = G__41251;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41260_41749 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41261_41750 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41262_41751 = output_schema41247_41735;
var G__41263_41752 = cljs.core.deref(output_checker41250_41738);
var G__41264_41753 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41260_41749,G__41261_41750,G__41262_41751,G__41263_41752,G__41264_41753) : schema.core.fn_validator.call(null,G__41260_41749,G__41261_41750,G__41262_41751,G__41263_41752,G__41264_41753));
} else {
var temp__5804__auto___41754 = (function (){var fexpr__41265 = cljs.core.deref(output_checker41250_41738);
return (fexpr__41265.cljs$core$IFn$_invoke$arity$1 ? fexpr__41265.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41265.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41754)){
var error__38226__auto___41755 = temp__5804__auto___41754;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41755], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41247_41735,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41755], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41247_41735,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41248_41736], null)));

var ufv___41756 = schema.utils.use_fn_validation;
var output_schema41267_41757 = deercreeklabs.baracus.ByteArray;
var input_schema41268_41758 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41272_41759 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41269_41760 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41268_41758);
}),null));
var output_checker41270_41761 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41267_41757);
}),null));
var input_checker41273_41762 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41272_41759);
}),null));
var output_checker41274_41763 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41267_41757);
}),null));
var ret__40667__auto___41765 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41280 = arguments.length;
switch (G__41280) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41271){
var validate__38224__auto__ = cljs.core.deref(ufv___41756);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41767 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41271], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41282_41768 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41283_41769 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41284_41770 = input_schema41268_41758;
var G__41285_41771 = cljs.core.deref(input_checker41269_41760);
var G__41286_41772 = args__38225__auto___41767;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41282_41768,G__41283_41769,G__41284_41770,G__41285_41771,G__41286_41772) : schema.core.fn_validator.call(null,G__41282_41768,G__41283_41769,G__41284_41770,G__41285_41771,G__41286_41772));
} else {
var temp__5804__auto___41773 = (function (){var fexpr__41287 = cljs.core.deref(input_checker41269_41760);
return (fexpr__41287.cljs$core$IFn$_invoke$arity$1 ? fexpr__41287.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41767) : fexpr__41287.call(null,args__38225__auto___41767));
})();
if(cljs.core.truth_(temp__5804__auto___41773)){
var error__38226__auto___41774 = temp__5804__auto___41773;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41774], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41268_41758,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41767,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41774], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var size_or_seq = G__41271;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41288_41775 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41289_41776 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41290_41777 = output_schema41267_41757;
var G__41291_41778 = cljs.core.deref(output_checker41270_41761);
var G__41292_41779 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41288_41775,G__41289_41776,G__41290_41777,G__41291_41778,G__41292_41779) : schema.core.fn_validator.call(null,G__41288_41775,G__41289_41776,G__41290_41777,G__41291_41778,G__41292_41779));
} else {
var temp__5804__auto___41780 = (function (){var fexpr__41293 = cljs.core.deref(output_checker41270_41761);
return (fexpr__41293.cljs$core$IFn$_invoke$arity$1 ? fexpr__41293.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41293.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41780)){
var error__38226__auto___41781 = temp__5804__auto___41780;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41781], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41267_41757,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41781], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41275,G__41276){
var validate__38224__auto__ = cljs.core.deref(ufv___41756);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41782 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41275,G__41276], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41295_41783 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41296_41784 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41297_41785 = input_schema41272_41759;
var G__41298_41786 = cljs.core.deref(input_checker41273_41762);
var G__41299_41787 = args__38225__auto___41782;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41295_41783,G__41296_41784,G__41297_41785,G__41298_41786,G__41299_41787) : schema.core.fn_validator.call(null,G__41295_41783,G__41296_41784,G__41297_41785,G__41298_41786,G__41299_41787));
} else {
var temp__5804__auto___41789 = (function (){var fexpr__41300 = cljs.core.deref(input_checker41273_41762);
return (fexpr__41300.cljs$core$IFn$_invoke$arity$1 ? fexpr__41300.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41782) : fexpr__41300.call(null,args__38225__auto___41782));
})();
if(cljs.core.truth_(temp__5804__auto___41789)){
var error__38226__auto___41790 = temp__5804__auto___41789;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41790], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41272_41759,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41782,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41790], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var size = G__41275;
var init_val_or_seq = G__41276;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41301_41791 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41302_41792 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41303_41793 = output_schema41267_41757;
var G__41304_41794 = cljs.core.deref(output_checker41274_41763);
var G__41305_41795 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41301_41791,G__41302_41792,G__41303_41793,G__41304_41794,G__41305_41795) : schema.core.fn_validator.call(null,G__41301_41791,G__41302_41792,G__41303_41793,G__41304_41794,G__41305_41795));
} else {
var temp__5804__auto___41796 = (function (){var fexpr__41308 = cljs.core.deref(output_checker41274_41763);
return (fexpr__41308.cljs$core$IFn$_invoke$arity$1 ? fexpr__41308.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41308.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41796)){
var error__38226__auto___41797 = temp__5804__auto___41796;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41797], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41267_41757,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41797], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41267_41757,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41268_41758,input_schema41272_41759], null)));

var ufv___41798 = schema.utils.use_fn_validation;
var output_schema41311_41799 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41312_41800 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41313_41801 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41312_41800);
}),null));
var output_checker41314_41802 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41311_41799);
}),null));
var ret__40667__auto___41803 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41315){
var validate__38224__auto__ = cljs.core.deref(ufv___41798);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41804 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41315], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41316_41805 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41317_41806 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41318_41807 = input_schema41312_41800;
var G__41319_41808 = cljs.core.deref(input_checker41313_41801);
var G__41320_41809 = args__38225__auto___41804;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41316_41805,G__41317_41806,G__41318_41807,G__41319_41808,G__41320_41809) : schema.core.fn_validator.call(null,G__41316_41805,G__41317_41806,G__41318_41807,G__41319_41808,G__41320_41809));
} else {
var temp__5804__auto___41811 = (function (){var fexpr__41321 = cljs.core.deref(input_checker41313_41801);
return (fexpr__41321.cljs$core$IFn$_invoke$arity$1 ? fexpr__41321.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41804) : fexpr__41321.call(null,args__38225__auto___41804));
})();
if(cljs.core.truth_(temp__5804__auto___41811)){
var error__38226__auto___41812 = temp__5804__auto___41811;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41812], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41312_41800,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41804,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41812], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var arrays = G__41315;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41323 = cljs.core.count(arrays__$1);
switch (G__41323) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41323,arrays__$1,validate__38224__auto__,ufv___41798,output_schema41311_41799,input_schema41312_41800,input_checker41313_41801,output_checker41314_41802){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41323,arrays__$1,validate__38224__auto__,ufv___41798,output_schema41311_41799,input_schema41312_41800,input_checker41313_41801,output_checker41314_41802))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41323,arrays__$1,validate__38224__auto__,ufv___41798,output_schema41311_41799,input_schema41312_41800,input_checker41313_41801,output_checker41314_41802){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41323,arrays__$1,validate__38224__auto__,ufv___41798,output_schema41311_41799,input_schema41312_41800,input_checker41313_41801,output_checker41314_41802))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41324_41814 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41325_41815 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41326_41816 = output_schema41311_41799;
var G__41327_41817 = cljs.core.deref(output_checker41314_41802);
var G__41328_41818 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41324_41814,G__41325_41815,G__41326_41816,G__41327_41817,G__41328_41818) : schema.core.fn_validator.call(null,G__41324_41814,G__41325_41815,G__41326_41816,G__41327_41817,G__41328_41818));
} else {
var temp__5804__auto___41819 = (function (){var fexpr__41329 = cljs.core.deref(output_checker41314_41802);
return (fexpr__41329.cljs$core$IFn$_invoke$arity$1 ? fexpr__41329.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41329.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41819)){
var error__38226__auto___41820 = temp__5804__auto___41819;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41820], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41311_41799,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41820], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41311_41799,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41312_41800], null)));

var ufv___41821 = schema.utils.use_fn_validation;
var output_schema41330_41822 = schema.core.Bool;
var input_schema41331_41823 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41332_41824 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41331_41823);
}),null));
var output_checker41333_41825 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41330_41822);
}),null));
var ret__40667__auto___41826 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41334,G__41335){
var validate__38224__auto__ = cljs.core.deref(ufv___41821);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41827 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41334,G__41335], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41338_41828 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41339_41829 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41340_41830 = input_schema41331_41823;
var G__41341_41831 = cljs.core.deref(input_checker41332_41824);
var G__41342_41832 = args__38225__auto___41827;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41338_41828,G__41339_41829,G__41340_41830,G__41341_41831,G__41342_41832) : schema.core.fn_validator.call(null,G__41338_41828,G__41339_41829,G__41340_41830,G__41341_41831,G__41342_41832));
} else {
var temp__5804__auto___41833 = (function (){var fexpr__41343 = cljs.core.deref(input_checker41332_41824);
return (fexpr__41343.cljs$core$IFn$_invoke$arity$1 ? fexpr__41343.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41827) : fexpr__41343.call(null,args__38225__auto___41827));
})();
if(cljs.core.truth_(temp__5804__auto___41833)){
var error__38226__auto___41834 = temp__5804__auto___41833;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41834], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41331_41823,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41827,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41834], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var a = G__41334;
var b = G__41335;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41837 = ((i + (1)) | (0));
i = G__41837;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41344_41838 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41345_41839 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41346_41840 = output_schema41330_41822;
var G__41347_41841 = cljs.core.deref(output_checker41333_41825);
var G__41348_41842 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41344_41838,G__41345_41839,G__41346_41840,G__41347_41841,G__41348_41842) : schema.core.fn_validator.call(null,G__41344_41838,G__41345_41839,G__41346_41840,G__41347_41841,G__41348_41842));
} else {
var temp__5804__auto___41844 = (function (){var fexpr__41349 = cljs.core.deref(output_checker41333_41825);
return (fexpr__41349.cljs$core$IFn$_invoke$arity$1 ? fexpr__41349.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41349.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41844)){
var error__38226__auto___41845 = temp__5804__auto___41844;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41845], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41330_41822,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41845], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41330_41822,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41331_41823], null)));

var ufv___41846 = schema.utils.use_fn_validation;
var output_schema41351_41847 = schema.core.Str;
var input_schema41352_41848 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41353_41849 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41352_41848);
}),null));
var output_checker41354_41850 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41351_41847);
}),null));
var ret__40667__auto___41851 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41355){
var validate__38224__auto__ = cljs.core.deref(ufv___41846);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41853 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41355], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41356_41854 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41357_41855 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41358_41856 = input_schema41352_41848;
var G__41359_41857 = cljs.core.deref(input_checker41353_41849);
var G__41360_41858 = args__38225__auto___41853;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41356_41854,G__41357_41855,G__41358_41856,G__41359_41857,G__41360_41858) : schema.core.fn_validator.call(null,G__41356_41854,G__41357_41855,G__41358_41856,G__41359_41857,G__41360_41858));
} else {
var temp__5804__auto___41859 = (function (){var fexpr__41361 = cljs.core.deref(input_checker41353_41849);
return (fexpr__41361.cljs$core$IFn$_invoke$arity$1 ? fexpr__41361.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41853) : fexpr__41361.call(null,args__38225__auto___41853));
})();
if(cljs.core.truth_(temp__5804__auto___41859)){
var error__38226__auto___41860 = temp__5804__auto___41859;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41860], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41352_41848,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41853,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41860], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41355;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41362_41861 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41363_41862 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41364_41863 = output_schema41351_41847;
var G__41365_41864 = cljs.core.deref(output_checker41354_41850);
var G__41366_41865 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41362_41861,G__41363_41862,G__41364_41863,G__41365_41864,G__41366_41865) : schema.core.fn_validator.call(null,G__41362_41861,G__41363_41862,G__41364_41863,G__41365_41864,G__41366_41865));
} else {
var temp__5804__auto___41867 = (function (){var fexpr__41367 = cljs.core.deref(output_checker41354_41850);
return (fexpr__41367.cljs$core$IFn$_invoke$arity$1 ? fexpr__41367.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41367.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41867)){
var error__38226__auto___41868 = temp__5804__auto___41867;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41868], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41351_41847,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41868], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41351_41847,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41352_41848], null)));

var ufv___41869 = schema.utils.use_fn_validation;
var output_schema41368_41870 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41369_41871 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41373_41872 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41378_41873 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41370_41874 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41369_41871);
}),null));
var output_checker41371_41875 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41368_41870);
}),null));
var input_checker41374_41876 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41373_41872);
}),null));
var output_checker41375_41877 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41368_41870);
}),null));
var input_checker41379_41878 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41378_41873);
}),null));
var output_checker41380_41879 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41368_41870);
}),null));
var ret__40667__auto___41880 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41387 = arguments.length;
switch (G__41387) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41372){
var validate__38224__auto__ = cljs.core.deref(ufv___41869);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41884 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41372], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41388_41885 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41389_41886 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41390_41887 = input_schema41369_41871;
var G__41391_41888 = cljs.core.deref(input_checker41370_41874);
var G__41392_41889 = args__38225__auto___41884;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41388_41885,G__41389_41886,G__41390_41887,G__41391_41888,G__41392_41889) : schema.core.fn_validator.call(null,G__41388_41885,G__41389_41886,G__41390_41887,G__41391_41888,G__41392_41889));
} else {
var temp__5804__auto___41891 = (function (){var fexpr__41393 = cljs.core.deref(input_checker41370_41874);
return (fexpr__41393.cljs$core$IFn$_invoke$arity$1 ? fexpr__41393.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41884) : fexpr__41393.call(null,args__38225__auto___41884));
})();
if(cljs.core.truth_(temp__5804__auto___41891)){
var error__38226__auto___41893 = temp__5804__auto___41891;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41893], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41369_41871,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41884,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41893], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41372;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41395_41897 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41396_41898 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41397_41899 = output_schema41368_41870;
var G__41398_41900 = cljs.core.deref(output_checker41371_41875);
var G__41399_41901 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41395_41897,G__41396_41898,G__41397_41899,G__41398_41900,G__41399_41901) : schema.core.fn_validator.call(null,G__41395_41897,G__41396_41898,G__41397_41899,G__41398_41900,G__41399_41901));
} else {
var temp__5804__auto___41902 = (function (){var fexpr__41400 = cljs.core.deref(output_checker41371_41875);
return (fexpr__41400.cljs$core$IFn$_invoke$arity$1 ? fexpr__41400.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41400.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41902)){
var error__38226__auto___41903 = temp__5804__auto___41902;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41903], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41368_41870,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41903], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41376,G__41377){
var validate__38224__auto__ = cljs.core.deref(ufv___41869);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41904 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41376,G__41377], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41401_41905 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41402_41906 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41403_41907 = input_schema41373_41872;
var G__41404_41908 = cljs.core.deref(input_checker41374_41876);
var G__41405_41909 = args__38225__auto___41904;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41401_41905,G__41402_41906,G__41403_41907,G__41404_41908,G__41405_41909) : schema.core.fn_validator.call(null,G__41401_41905,G__41402_41906,G__41403_41907,G__41404_41908,G__41405_41909));
} else {
var temp__5804__auto___41910 = (function (){var fexpr__41406 = cljs.core.deref(input_checker41374_41876);
return (fexpr__41406.cljs$core$IFn$_invoke$arity$1 ? fexpr__41406.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41904) : fexpr__41406.call(null,args__38225__auto___41904));
})();
if(cljs.core.truth_(temp__5804__auto___41910)){
var error__38226__auto___41913 = temp__5804__auto___41910;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41913], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41373_41872,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41904,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41913], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41376;
var start = G__41377;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41408_41916 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41409_41917 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41410_41918 = output_schema41368_41870;
var G__41411_41919 = cljs.core.deref(output_checker41375_41877);
var G__41412_41920 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41408_41916,G__41409_41917,G__41410_41918,G__41411_41919,G__41412_41920) : schema.core.fn_validator.call(null,G__41408_41916,G__41409_41917,G__41410_41918,G__41411_41919,G__41412_41920));
} else {
var temp__5804__auto___41924 = (function (){var fexpr__41413 = cljs.core.deref(output_checker41375_41877);
return (fexpr__41413.cljs$core$IFn$_invoke$arity$1 ? fexpr__41413.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41413.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41924)){
var error__38226__auto___41925 = temp__5804__auto___41924;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41925], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41368_41870,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41925], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41381,G__41382,G__41383){
var validate__38224__auto__ = cljs.core.deref(ufv___41869);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41926 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41381,G__41382,G__41383], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41414_41927 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41415_41928 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41416_41929 = input_schema41378_41873;
var G__41417_41930 = cljs.core.deref(input_checker41379_41878);
var G__41418_41931 = args__38225__auto___41926;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41414_41927,G__41415_41928,G__41416_41929,G__41417_41930,G__41418_41931) : schema.core.fn_validator.call(null,G__41414_41927,G__41415_41928,G__41416_41929,G__41417_41930,G__41418_41931));
} else {
var temp__5804__auto___41933 = (function (){var fexpr__41419 = cljs.core.deref(input_checker41379_41878);
return (fexpr__41419.cljs$core$IFn$_invoke$arity$1 ? fexpr__41419.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41926) : fexpr__41419.call(null,args__38225__auto___41926));
})();
if(cljs.core.truth_(temp__5804__auto___41933)){
var error__38226__auto___41934 = temp__5804__auto___41933;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41934], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41378_41873,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41926,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41934], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41381;
var start = G__41382;
var end = G__41383;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41420_41939 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41421_41940 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41422_41941 = output_schema41368_41870;
var G__41423_41942 = cljs.core.deref(output_checker41380_41879);
var G__41424_41943 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41420_41939,G__41421_41940,G__41422_41941,G__41423_41942,G__41424_41943) : schema.core.fn_validator.call(null,G__41420_41939,G__41421_41940,G__41422_41941,G__41423_41942,G__41424_41943));
} else {
var temp__5804__auto___41944 = (function (){var fexpr__41425 = cljs.core.deref(output_checker41380_41879);
return (fexpr__41425.cljs$core$IFn$_invoke$arity$1 ? fexpr__41425.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41425.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41944)){
var error__38226__auto___41945 = temp__5804__auto___41944;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41945], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41368_41870,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41945], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41368_41870,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41369_41871,input_schema41373_41872,input_schema41378_41873], null)));

var ufv___41947 = schema.utils.use_fn_validation;
var output_schema41427_41948 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41428_41949 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41429_41950 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41428_41949);
}),null));
var output_checker41430_41951 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41427_41948);
}),null));
var ret__40667__auto___41952 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41431){
var validate__38224__auto__ = cljs.core.deref(ufv___41947);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41954 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41431], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41433_41956 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41434_41957 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41435_41958 = input_schema41428_41949;
var G__41436_41959 = cljs.core.deref(input_checker41429_41950);
var G__41437_41960 = args__38225__auto___41954;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41433_41956,G__41434_41957,G__41435_41958,G__41436_41959,G__41437_41960) : schema.core.fn_validator.call(null,G__41433_41956,G__41434_41957,G__41435_41958,G__41436_41959,G__41437_41960));
} else {
var temp__5804__auto___41963 = (function (){var fexpr__41438 = cljs.core.deref(input_checker41429_41950);
return (fexpr__41438.cljs$core$IFn$_invoke$arity$1 ? fexpr__41438.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41954) : fexpr__41438.call(null,args__38225__auto___41954));
})();
if(cljs.core.truth_(temp__5804__auto___41963)){
var error__38226__auto___41964 = temp__5804__auto___41963;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41964], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41428_41949,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41954,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41964], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41431;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5636__auto___41966 = num;
var i_41967 = (0);
while(true){
if((i_41967 < n__5636__auto___41966)){
(new$[i_41967] = (ba[(last - i_41967)]));

var G__41968 = (i_41967 + (1));
i_41967 = G__41968;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41440_41969 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41441_41970 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41442_41971 = output_schema41427_41948;
var G__41443_41972 = cljs.core.deref(output_checker41430_41951);
var G__41444_41973 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41440_41969,G__41441_41970,G__41442_41971,G__41443_41972,G__41444_41973) : schema.core.fn_validator.call(null,G__41440_41969,G__41441_41970,G__41442_41971,G__41443_41972,G__41444_41973));
} else {
var temp__5804__auto___41975 = (function (){var fexpr__41445 = cljs.core.deref(output_checker41430_41951);
return (fexpr__41445.cljs$core$IFn$_invoke$arity$1 ? fexpr__41445.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41445.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41975)){
var error__38226__auto___41976 = temp__5804__auto___41975;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41976], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41427_41948,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41976], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41427_41948,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41428_41949], null)));

var ufv___41978 = schema.utils.use_fn_validation;
var output_schema41449_41979 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41450_41980 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41451_41981 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41450_41980);
}),null));
var output_checker41452_41982 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41449_41979);
}),null));
var ret__40667__auto___41983 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41453,G__41454){
var validate__38224__auto__ = cljs.core.deref(ufv___41978);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___41986 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41453,G__41454], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41456_41987 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41457_41988 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41458_41990 = input_schema41450_41980;
var G__41459_41991 = cljs.core.deref(input_checker41451_41981);
var G__41460_41992 = args__38225__auto___41986;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41456_41987,G__41457_41988,G__41458_41990,G__41459_41991,G__41460_41992) : schema.core.fn_validator.call(null,G__41456_41987,G__41457_41988,G__41458_41990,G__41459_41991,G__41460_41992));
} else {
var temp__5804__auto___41994 = (function (){var fexpr__41461 = cljs.core.deref(input_checker41451_41981);
return (fexpr__41461.cljs$core$IFn$_invoke$arity$1 ? fexpr__41461.cljs$core$IFn$_invoke$arity$1(args__38225__auto___41986) : fexpr__41461.call(null,args__38225__auto___41986));
})();
if(cljs.core.truth_(temp__5804__auto___41994)){
var error__38226__auto___41995 = temp__5804__auto___41994;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___41995], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41450_41980,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___41986,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___41995], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41453;
var fragment_size = G__41454;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__41997 = (end_offset | (0));
var G__41998 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__41997;
output = G__41998;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41463_42000 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41464_42001 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41465_42002 = output_schema41449_41979;
var G__41466_42003 = cljs.core.deref(output_checker41452_41982);
var G__41467_42004 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41463_42000,G__41464_42001,G__41465_42002,G__41466_42003,G__41467_42004) : schema.core.fn_validator.call(null,G__41463_42000,G__41464_42001,G__41465_42002,G__41466_42003,G__41467_42004));
} else {
var temp__5804__auto___42005 = (function (){var fexpr__41468 = cljs.core.deref(output_checker41452_41982);
return (fexpr__41468.cljs$core$IFn$_invoke$arity$1 ? fexpr__41468.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41468.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42005)){
var error__38226__auto___42006 = temp__5804__auto___42005;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42006], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41449_41979,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42006], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41449_41979,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41450_41980], null)));

var ufv___42008 = schema.utils.use_fn_validation;
var output_schema41470_42009 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41471_42010 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41472_42011 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41471_42010);
}),null));
var output_checker41473_42012 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41470_42009);
}),null));
var ret__40667__auto___42015 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an variable-length zig-zag encoded byte array and reads an integer
 * from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41474){
var validate__38224__auto__ = cljs.core.deref(ufv___42008);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42016 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41474], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41475_42017 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41476_42018 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41477_42019 = input_schema41471_42010;
var G__41478_42020 = cljs.core.deref(input_checker41472_42011);
var G__41479_42021 = args__38225__auto___42016;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41475_42017,G__41476_42018,G__41477_42019,G__41478_42020,G__41479_42021) : schema.core.fn_validator.call(null,G__41475_42017,G__41476_42018,G__41477_42019,G__41478_42020,G__41479_42021));
} else {
var temp__5804__auto___42024 = (function (){var fexpr__41480 = cljs.core.deref(input_checker41472_42011);
return (fexpr__41480.cljs$core$IFn$_invoke$arity$1 ? fexpr__41480.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42016) : fexpr__41480.call(null,args__38225__auto___42016));
})();
if(cljs.core.truth_(temp__5804__auto___42024)){
var error__38226__auto___42025 = temp__5804__auto___42024;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42025], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41471_42010,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42016,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42025], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41474;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__42028 = (n + (1));
var G__42029 = (i__$1 | (0));
var G__42030 = (out__$1 | (0));
n = G__42028;
i = G__42029;
out = G__42030;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41485_42031 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41486_42032 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41487_42033 = output_schema41470_42009;
var G__41488_42034 = cljs.core.deref(output_checker41473_42012);
var G__41489_42035 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41485_42031,G__41486_42032,G__41487_42033,G__41488_42034,G__41489_42035) : schema.core.fn_validator.call(null,G__41485_42031,G__41486_42032,G__41487_42033,G__41488_42034,G__41489_42035));
} else {
var temp__5804__auto___42037 = (function (){var fexpr__41490 = cljs.core.deref(output_checker41473_42012);
return (fexpr__41490.cljs$core$IFn$_invoke$arity$1 ? fexpr__41490.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41490.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42037)){
var error__38226__auto___42038 = temp__5804__auto___42037;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42038], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41470_42009,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42038], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41470_42009,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41471_42010], null)));

var ufv___42043 = schema.utils.use_fn_validation;
var output_schema41492_42044 = deercreeklabs.baracus.ByteArray;
var input_schema41493_42045 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41494_42046 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41493_42045);
}),null));
var output_checker41495_42047 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41492_42044);
}),null));
var ret__40667__auto___42048 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Encodes an integer using variable length zig-zag coding.
 * Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41496){
var validate__38224__auto__ = cljs.core.deref(ufv___42043);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42050 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41496], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41498_42051 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41499_42052 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41500_42053 = input_schema41493_42045;
var G__41501_42054 = cljs.core.deref(input_checker41494_42046);
var G__41502_42055 = args__38225__auto___42050;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41498_42051,G__41499_42052,G__41500_42053,G__41501_42054,G__41502_42055) : schema.core.fn_validator.call(null,G__41498_42051,G__41499_42052,G__41500_42053,G__41501_42054,G__41502_42055));
} else {
var temp__5804__auto___42056 = (function (){var fexpr__41503 = cljs.core.deref(input_checker41494_42046);
return (fexpr__41503.cljs$core$IFn$_invoke$arity$1 ? fexpr__41503.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42050) : fexpr__41503.call(null,args__38225__auto___42050));
})();
if(cljs.core.truth_(temp__5804__auto___42056)){
var error__38226__auto___42057 = temp__5804__auto___42056;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42057], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41493_42045,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42050,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42057], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var i = G__41496;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__42060 = (n >>> (7));
var G__42061 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__42060;
out = G__42061;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41505_42062 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41506_42063 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41507_42064 = output_schema41492_42044;
var G__41508_42065 = cljs.core.deref(output_checker41495_42047);
var G__41509_42066 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41505_42062,G__41506_42063,G__41507_42064,G__41508_42065,G__41509_42066) : schema.core.fn_validator.call(null,G__41505_42062,G__41506_42063,G__41507_42064,G__41508_42065,G__41509_42066));
} else {
var temp__5804__auto___42067 = (function (){var fexpr__41510 = cljs.core.deref(output_checker41495_42047);
return (fexpr__41510.cljs$core$IFn$_invoke$arity$1 ? fexpr__41510.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41510.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42067)){
var error__38226__auto___42068 = temp__5804__auto___42067;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42068], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41492_42044,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42068], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41492_42044,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41493_42045], null)));

var ufv___42073 = schema.utils.use_fn_validation;
var output_schema41512_42074 = schema.core.maybe(schema.core.Str);
var input_schema41513_42075 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41514_42076 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41513_42075);
}),null));
var output_checker41515_42077 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41512_42074);
}),null));
var ret__40667__auto___42078 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41516){
var validate__38224__auto__ = cljs.core.deref(ufv___42073);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42079 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41516], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41517_42080 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41518_42081 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41519_42082 = input_schema41513_42075;
var G__41520_42083 = cljs.core.deref(input_checker41514_42076);
var G__41521_42084 = args__38225__auto___42079;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41517_42080,G__41518_42081,G__41519_42082,G__41520_42083,G__41521_42084) : schema.core.fn_validator.call(null,G__41517_42080,G__41518_42081,G__41519_42082,G__41520_42083,G__41521_42084));
} else {
var temp__5804__auto___42085 = (function (){var fexpr__41523 = cljs.core.deref(input_checker41514_42076);
return (fexpr__41523.cljs$core$IFn$_invoke$arity$1 ? fexpr__41523.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42079) : fexpr__41523.call(null,args__38225__auto___42079));
})();
if(cljs.core.truth_(temp__5804__auto___42085)){
var error__38226__auto___42086 = temp__5804__auto___42085;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42086], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41513_42075,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42079,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42086], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var b = G__41516;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41524_42087 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41525_42088 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41526_42089 = output_schema41512_42074;
var G__41527_42090 = cljs.core.deref(output_checker41515_42077);
var G__41528_42091 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41524_42087,G__41525_42088,G__41526_42089,G__41527_42090,G__41528_42091) : schema.core.fn_validator.call(null,G__41524_42087,G__41525_42088,G__41526_42089,G__41527_42090,G__41528_42091));
} else {
var temp__5804__auto___42092 = (function (){var fexpr__41530 = cljs.core.deref(output_checker41515_42077);
return (fexpr__41530.cljs$core$IFn$_invoke$arity$1 ? fexpr__41530.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41530.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42092)){
var error__38226__auto___42093 = temp__5804__auto___42092;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42093], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41512_42074,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42093], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41512_42074,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41513_42075], null)));

var ufv___42094 = schema.utils.use_fn_validation;
var output_schema41533_42095 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41535_42096 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41536_42097 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41535_42096);
}),null));
var output_checker41537_42098 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41533_42095);
}),null));
var ret__40667__auto___42099 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41538){
var validate__38224__auto__ = cljs.core.deref(ufv___42094);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42100 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41538], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41539_42101 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41540_42102 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41541_42103 = input_schema41535_42096;
var G__41542_42104 = cljs.core.deref(input_checker41536_42097);
var G__41543_42105 = args__38225__auto___42100;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41539_42101,G__41540_42102,G__41541_42103,G__41542_42104,G__41543_42105) : schema.core.fn_validator.call(null,G__41539_42101,G__41540_42102,G__41541_42103,G__41542_42104,G__41543_42105));
} else {
var temp__5804__auto___42106 = (function (){var fexpr__41544 = cljs.core.deref(input_checker41536_42097);
return (fexpr__41544.cljs$core$IFn$_invoke$arity$1 ? fexpr__41544.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42100) : fexpr__41544.call(null,args__38225__auto___42100));
})();
if(cljs.core.truth_(temp__5804__auto___42106)){
var error__38226__auto___42107 = temp__5804__auto___42106;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42107], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41535_42096,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42100,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42107], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var s = G__41538;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41545_42108 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41546_42109 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41547_42110 = output_schema41533_42095;
var G__41548_42111 = cljs.core.deref(output_checker41537_42098);
var G__41549_42112 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41545_42108,G__41546_42109,G__41547_42110,G__41548_42111,G__41549_42112) : schema.core.fn_validator.call(null,G__41545_42108,G__41546_42109,G__41547_42110,G__41548_42111,G__41549_42112));
} else {
var temp__5804__auto___42114 = (function (){var fexpr__41550 = cljs.core.deref(output_checker41537_42098);
return (fexpr__41550.cljs$core$IFn$_invoke$arity$1 ? fexpr__41550.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41550.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42114)){
var error__38226__auto___42115 = temp__5804__auto___42114;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42115], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41533_42095,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42115], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41533_42095,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41535_42096], null)));

var ufv___42117 = schema.utils.use_fn_validation;
var output_schema41552_42118 = schema.core.maybe(schema.core.Str);
var input_schema41553_42119 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41554_42120 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41553_42119);
}),null));
var output_checker41555_42121 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41552_42118);
}),null));
var ret__40667__auto___42122 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41556){
var validate__38224__auto__ = cljs.core.deref(ufv___42117);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42123 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41556], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41557_42124 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41558_42125 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41559_42126 = input_schema41553_42119;
var G__41560_42127 = cljs.core.deref(input_checker41554_42120);
var G__41561_42128 = args__38225__auto___42123;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41557_42124,G__41558_42125,G__41559_42126,G__41560_42127,G__41561_42128) : schema.core.fn_validator.call(null,G__41557_42124,G__41558_42125,G__41559_42126,G__41560_42127,G__41561_42128));
} else {
var temp__5804__auto___42130 = (function (){var fexpr__41562 = cljs.core.deref(input_checker41554_42120);
return (fexpr__41562.cljs$core$IFn$_invoke$arity$1 ? fexpr__41562.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42123) : fexpr__41562.call(null,args__38225__auto___42123));
})();
if(cljs.core.truth_(temp__5804__auto___42130)){
var error__38226__auto___42131 = temp__5804__auto___42130;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42131], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41553_42119,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42123,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42131], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41556;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41564_42132 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41565_42133 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41566_42134 = output_schema41552_42118;
var G__41567_42135 = cljs.core.deref(output_checker41555_42121);
var G__41568_42136 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41564_42132,G__41565_42133,G__41566_42134,G__41567_42135,G__41568_42136) : schema.core.fn_validator.call(null,G__41564_42132,G__41565_42133,G__41566_42134,G__41567_42135,G__41568_42136));
} else {
var temp__5804__auto___42137 = (function (){var fexpr__41569 = cljs.core.deref(output_checker41555_42121);
return (fexpr__41569.cljs$core$IFn$_invoke$arity$1 ? fexpr__41569.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41569.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42137)){
var error__38226__auto___42138 = temp__5804__auto___42137;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42138], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41552_42118,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42138], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41552_42118,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41553_42119], null)));

var ufv___42143 = schema.utils.use_fn_validation;
var output_schema41571_42144 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41572_42145 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41573_42146 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41572_42145);
}),null));
var output_checker41574_42147 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41571_42144);
}),null));
var ret__40667__auto___42148 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41575){
var validate__38224__auto__ = cljs.core.deref(ufv___42143);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42150 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41575], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41576_42151 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41577_42152 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41578_42153 = input_schema41572_42145;
var G__41579_42154 = cljs.core.deref(input_checker41573_42146);
var G__41580_42155 = args__38225__auto___42150;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41576_42151,G__41577_42152,G__41578_42153,G__41579_42154,G__41580_42155) : schema.core.fn_validator.call(null,G__41576_42151,G__41577_42152,G__41578_42153,G__41579_42154,G__41580_42155));
} else {
var temp__5804__auto___42156 = (function (){var fexpr__41581 = cljs.core.deref(input_checker41573_42146);
return (fexpr__41581.cljs$core$IFn$_invoke$arity$1 ? fexpr__41581.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42150) : fexpr__41581.call(null,args__38225__auto___42150));
})();
if(cljs.core.truth_(temp__5804__auto___42156)){
var error__38226__auto___42157 = temp__5804__auto___42156;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42157], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41572_42145,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42150,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42157], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var s = G__41575;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41583_42159 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41584_42160 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41585_42161 = output_schema41571_42144;
var G__41586_42162 = cljs.core.deref(output_checker41574_42147);
var G__41587_42163 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41583_42159,G__41584_42160,G__41585_42161,G__41586_42162,G__41587_42163) : schema.core.fn_validator.call(null,G__41583_42159,G__41584_42160,G__41585_42161,G__41586_42162,G__41587_42163));
} else {
var temp__5804__auto___42165 = (function (){var fexpr__41588 = cljs.core.deref(output_checker41574_42147);
return (fexpr__41588.cljs$core$IFn$_invoke$arity$1 ? fexpr__41588.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41588.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42165)){
var error__38226__auto___42166 = temp__5804__auto___42165;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42166], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41571_42144,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42166], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41571_42144,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41572_42145], null)));

deercreeklabs.baracus.byte_array__GT_hex_str_STAR_ = (function deercreeklabs$baracus$byte_array__GT_hex_str_STAR_(p__41589){
var map__41590 = p__41589;
var map__41590__$1 = cljs.core.__destructure_map(map__41590);
var alphabet = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41590__$1,new cljs.core.Keyword(null,"alphabet","alphabet",788478088));
var ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41590__$1,new cljs.core.Keyword(null,"ba","ba",-960950298));
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var ca = (new Array(((2) * len)));
var n__5636__auto___42171 = len;
var i_42172 = (0);
while(true){
if((i_42172 < n__5636__auto___42171)){
var b_42173 = ((ba[i_42172]) & (255));
var j_42174 = ((2) * i_42172);
(ca[j_42174] = (function (){var G__41594 = (b_42173 >> (4));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41594) : alphabet.call(null,G__41594));
})());

(ca[(j_42174 + (1))] = (function (){var G__41595 = (b_42173 & (15));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41595) : alphabet.call(null,G__41595));
})());

var G__42175 = (i_42172 + (1));
i_42172 = G__42175;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
});
var ufv___42177 = schema.utils.use_fn_validation;
var output_schema41597_42178 = schema.core.maybe(schema.core.Str);
var input_schema41598_42179 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41599_42180 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41598_42179);
}),null));
var output_checker41600_42181 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41597_42178);
}),null));
var ret__40667__auto___42182 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41601){
var validate__38224__auto__ = cljs.core.deref(ufv___42177);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42183 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41601], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41602_42184 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41603_42185 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41604_42186 = input_schema41598_42179;
var G__41605_42187 = cljs.core.deref(input_checker41599_42180);
var G__41606_42188 = args__38225__auto___42183;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41602_42184,G__41603_42185,G__41604_42186,G__41605_42187,G__41606_42188) : schema.core.fn_validator.call(null,G__41602_42184,G__41603_42185,G__41604_42186,G__41605_42187,G__41606_42188));
} else {
var temp__5804__auto___42190 = (function (){var fexpr__41607 = cljs.core.deref(input_checker41599_42180);
return (fexpr__41607.cljs$core$IFn$_invoke$arity$1 ? fexpr__41607.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42183) : fexpr__41607.call(null,args__38225__auto___42183));
})();
if(cljs.core.truth_(temp__5804__auto___42190)){
var error__38226__auto___42191 = temp__5804__auto___42190;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42191], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41598_42179,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42183,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42191], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41601;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41609_42193 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41610_42194 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41611_42195 = output_schema41597_42178;
var G__41612_42196 = cljs.core.deref(output_checker41600_42181);
var G__41613_42197 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41609_42193,G__41610_42194,G__41611_42195,G__41612_42196,G__41613_42197) : schema.core.fn_validator.call(null,G__41609_42193,G__41610_42194,G__41611_42195,G__41612_42196,G__41613_42197));
} else {
var temp__5804__auto___42198 = (function (){var fexpr__41614 = cljs.core.deref(output_checker41600_42181);
return (fexpr__41614.cljs$core$IFn$_invoke$arity$1 ? fexpr__41614.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41614.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42198)){
var error__38226__auto___42199 = temp__5804__auto___42198;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42199], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41597_42178,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42199], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41597_42178,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41598_42179], null)));

var ufv___42200 = schema.utils.use_fn_validation;
var output_schema41615_42201 = schema.core.maybe(schema.core.Str);
var input_schema41616_42202 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41617_42203 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41616_42202);
}),null));
var output_checker41618_42204 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41615_42201);
}),null));
var ret__40667__auto___42205 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_upper_hex_str = (function deercreeklabs$baracus$byte_array__GT_upper_hex_str(G__41619){
var validate__38224__auto__ = cljs.core.deref(ufv___42200);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42206 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41619], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41620_42207 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41621_42208 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41622_42209 = input_schema41616_42202;
var G__41623_42210 = cljs.core.deref(input_checker41617_42203);
var G__41624_42211 = args__38225__auto___42206;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41620_42207,G__41621_42208,G__41622_42209,G__41623_42210,G__41624_42211) : schema.core.fn_validator.call(null,G__41620_42207,G__41621_42208,G__41622_42209,G__41623_42210,G__41624_42211));
} else {
var temp__5804__auto___42212 = (function (){var fexpr__41626 = cljs.core.deref(input_checker41617_42203);
return (fexpr__41626.cljs$core$IFn$_invoke$arity$1 ? fexpr__41626.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42206) : fexpr__41626.call(null,args__38225__auto___42206));
})();
if(cljs.core.truth_(temp__5804__auto___42212)){
var error__38226__auto___42215 = temp__5804__auto___42212;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42215], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41616_42202,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42206,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42215], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41619;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41627_42218 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41628_42219 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41629_42220 = output_schema41615_42201;
var G__41630_42221 = cljs.core.deref(output_checker41618_42204);
var G__41631_42222 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41627_42218,G__41628_42219,G__41629_42220,G__41630_42221,G__41631_42222) : schema.core.fn_validator.call(null,G__41627_42218,G__41628_42219,G__41629_42220,G__41630_42221,G__41631_42222));
} else {
var temp__5804__auto___42225 = (function (){var fexpr__41632 = cljs.core.deref(output_checker41618_42204);
return (fexpr__41632.cljs$core$IFn$_invoke$arity$1 ? fexpr__41632.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41632.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42225)){
var error__38226__auto___42226 = temp__5804__auto___42225;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42226], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41615_42201,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42226], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_upper_hex_str),schema.core.__GT_FnSchema(output_schema41615_42201,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41616_42202], null)));

var ufv___42228 = schema.utils.use_fn_validation;
var output_schema41633_42229 = schema.core.maybe(schema.core.Str);
var input_schema41634_42230 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41635_42231 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41634_42230);
}),null));
var output_checker41636_42232 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41633_42229);
}),null));
var ret__40667__auto___42234 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_b16_alpha_str = (function deercreeklabs$baracus$byte_array__GT_b16_alpha_str(G__41637){
var validate__38224__auto__ = cljs.core.deref(ufv___42228);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42235 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41637], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41639_42236 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41640_42237 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41641_42238 = input_schema41634_42230;
var G__41642_42239 = cljs.core.deref(input_checker41635_42231);
var G__41643_42240 = args__38225__auto___42235;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41639_42236,G__41640_42237,G__41641_42238,G__41642_42239,G__41643_42240) : schema.core.fn_validator.call(null,G__41639_42236,G__41640_42237,G__41641_42238,G__41642_42239,G__41643_42240));
} else {
var temp__5804__auto___42241 = (function (){var fexpr__41644 = cljs.core.deref(input_checker41635_42231);
return (fexpr__41644.cljs$core$IFn$_invoke$arity$1 ? fexpr__41644.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42235) : fexpr__41644.call(null,args__38225__auto___42235));
})();
if(cljs.core.truth_(temp__5804__auto___42241)){
var error__38226__auto___42242 = temp__5804__auto___42241;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42242], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41634_42230,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42235,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42242], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41637;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["a","b","c","d","c","e","f","g","h","i","j","k","l","m","n","o"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41646_42243 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41647_42244 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41648_42245 = output_schema41633_42229;
var G__41649_42246 = cljs.core.deref(output_checker41636_42232);
var G__41650_42247 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41646_42243,G__41647_42244,G__41648_42245,G__41649_42246,G__41650_42247) : schema.core.fn_validator.call(null,G__41646_42243,G__41647_42244,G__41648_42245,G__41649_42246,G__41650_42247));
} else {
var temp__5804__auto___42248 = (function (){var fexpr__41651 = cljs.core.deref(output_checker41636_42232);
return (fexpr__41651.cljs$core$IFn$_invoke$arity$1 ? fexpr__41651.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41651.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42248)){
var error__38226__auto___42249 = temp__5804__auto___42248;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42249], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41633_42229,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42249], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b16_alpha_str),schema.core.__GT_FnSchema(output_schema41633_42229,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41634_42230], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42254 = schema.utils.use_fn_validation;
var output_schema41653_42255 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41654_42256 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41655_42257 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41654_42256);
}),null));
var output_checker41656_42258 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41653_42255);
}),null));
var ret__40667__auto___42259 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41657){
var validate__38224__auto__ = cljs.core.deref(ufv___42254);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42261 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41657], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41659_42262 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41660_42263 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41661_42264 = input_schema41654_42256;
var G__41662_42265 = cljs.core.deref(input_checker41655_42257);
var G__41663_42266 = args__38225__auto___42261;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41659_42262,G__41660_42263,G__41661_42264,G__41662_42265,G__41663_42266) : schema.core.fn_validator.call(null,G__41659_42262,G__41660_42263,G__41661_42264,G__41662_42265,G__41663_42266));
} else {
var temp__5804__auto___42268 = (function (){var fexpr__41664 = cljs.core.deref(input_checker41655_42257);
return (fexpr__41664.cljs$core$IFn$_invoke$arity$1 ? fexpr__41664.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42261) : fexpr__41664.call(null,args__38225__auto___42261));
})();
if(cljs.core.truth_(temp__5804__auto___42268)){
var error__38226__auto___42269 = temp__5804__auto___42268;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42269], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41654_42256,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42261,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42269], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var s = G__41657;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5636__auto___42272 = ba_len;
var i_42273 = (0);
while(true){
if((i_42273 < n__5636__auto___42272)){
var j_42274 = ((2) * i_42273);
(ba[i_42273] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42274)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42274 + (1))))));

var G__42275 = (i_42273 + (1));
i_42273 = G__42275;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41666_42276 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41667_42277 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41668_42278 = output_schema41653_42255;
var G__41669_42279 = cljs.core.deref(output_checker41656_42258);
var G__41670_42280 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41666_42276,G__41667_42277,G__41668_42278,G__41669_42279,G__41670_42280) : schema.core.fn_validator.call(null,G__41666_42276,G__41667_42277,G__41668_42278,G__41669_42279,G__41670_42280));
} else {
var temp__5804__auto___42281 = (function (){var fexpr__41671 = cljs.core.deref(output_checker41656_42258);
return (fexpr__41671.cljs$core$IFn$_invoke$arity$1 ? fexpr__41671.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41671.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42281)){
var error__38226__auto___42282 = temp__5804__auto___42281;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42282], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41653_42255,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42282], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41653_42255,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41654_42256], null)));

var ufv___42283 = schema.utils.use_fn_validation;
var output_schema41672_42284 = deercreeklabs.baracus.ByteArray;
var input_schema41673_42285 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41674_42286 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41673_42285);
}),null));
var output_checker41675_42287 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41672_42284);
}),null));
var ret__40667__auto___42288 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41676){
var validate__38224__auto__ = cljs.core.deref(ufv___42283);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42289 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41676], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41678_42290 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41679_42291 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41680_42292 = input_schema41673_42285;
var G__41681_42293 = cljs.core.deref(input_checker41674_42286);
var G__41682_42294 = args__38225__auto___42289;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41678_42290,G__41679_42291,G__41680_42292,G__41681_42293,G__41682_42294) : schema.core.fn_validator.call(null,G__41678_42290,G__41679_42291,G__41680_42292,G__41681_42293,G__41682_42294));
} else {
var temp__5804__auto___42295 = (function (){var fexpr__41683 = cljs.core.deref(input_checker41674_42286);
return (fexpr__41683.cljs$core$IFn$_invoke$arity$1 ? fexpr__41683.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42289) : fexpr__41683.call(null,args__38225__auto___42289));
})();
if(cljs.core.truth_(temp__5804__auto___42295)){
var error__38226__auto___42296 = temp__5804__auto___42295;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42296], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41673_42285,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42289,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42296], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41676;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41684_42297 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41685_42299 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41686_42300 = output_schema41672_42284;
var G__41687_42301 = cljs.core.deref(output_checker41675_42287);
var G__41688_42302 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41684_42297,G__41685_42299,G__41686_42300,G__41687_42301,G__41688_42302) : schema.core.fn_validator.call(null,G__41684_42297,G__41685_42299,G__41686_42300,G__41687_42301,G__41688_42302));
} else {
var temp__5804__auto___42304 = (function (){var fexpr__41689 = cljs.core.deref(output_checker41675_42287);
return (fexpr__41689.cljs$core$IFn$_invoke$arity$1 ? fexpr__41689.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41689.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42304)){
var error__38226__auto___42306 = temp__5804__auto___42304;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42306], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41672_42284,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42306], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41672_42284,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41673_42285], null)));

var ufv___42308 = schema.utils.use_fn_validation;
var output_schema41691_42309 = deercreeklabs.baracus.ByteArray;
var input_schema41692_42310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41693_42311 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41692_42310);
}),null));
var output_checker41694_42312 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41691_42309);
}),null));
var ret__40667__auto___42313 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41695){
var validate__38224__auto__ = cljs.core.deref(ufv___42308);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42314 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41695], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41696_42315 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41697_42316 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41698_42317 = input_schema41692_42310;
var G__41699_42318 = cljs.core.deref(input_checker41693_42311);
var G__41700_42319 = args__38225__auto___42314;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41696_42315,G__41697_42316,G__41698_42317,G__41699_42318,G__41700_42319) : schema.core.fn_validator.call(null,G__41696_42315,G__41697_42316,G__41698_42317,G__41699_42318,G__41700_42319));
} else {
var temp__5804__auto___42320 = (function (){var fexpr__41701 = cljs.core.deref(input_checker41693_42311);
return (fexpr__41701.cljs$core$IFn$_invoke$arity$1 ? fexpr__41701.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42314) : fexpr__41701.call(null,args__38225__auto___42314));
})();
if(cljs.core.truth_(temp__5804__auto___42320)){
var error__38226__auto___42322 = temp__5804__auto___42320;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42322], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41692_42310,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42314,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42322], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41695;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41703_42325 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41704_42326 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41705_42327 = output_schema41691_42309;
var G__41706_42328 = cljs.core.deref(output_checker41694_42312);
var G__41707_42329 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41703_42325,G__41704_42326,G__41705_42327,G__41706_42328,G__41707_42329) : schema.core.fn_validator.call(null,G__41703_42325,G__41704_42326,G__41705_42327,G__41706_42328,G__41707_42329));
} else {
var temp__5804__auto___42330 = (function (){var fexpr__41708 = cljs.core.deref(output_checker41694_42312);
return (fexpr__41708.cljs$core$IFn$_invoke$arity$1 ? fexpr__41708.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41708.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42330)){
var error__38226__auto___42331 = temp__5804__auto___42330;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42331], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41691_42309,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42331], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41691_42309,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41692_42310], null)));

var ufv___42332 = schema.utils.use_fn_validation;
var output_schema41710_42333 = deercreeklabs.baracus.ByteArray;
var input_schema41711_42334 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41712_42335 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41711_42334);
}),null));
var output_checker41713_42336 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41710_42333);
}),null));
var ret__40667__auto___42337 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41714){
var validate__38224__auto__ = cljs.core.deref(ufv___42332);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___42338 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41714], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41716_42339 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41717_42340 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41718_42341 = input_schema41711_42334;
var G__41719_42342 = cljs.core.deref(input_checker41712_42335);
var G__41720_42343 = args__38225__auto___42338;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41716_42339,G__41717_42340,G__41718_42341,G__41719_42342,G__41720_42343) : schema.core.fn_validator.call(null,G__41716_42339,G__41717_42340,G__41718_42341,G__41719_42342,G__41720_42343));
} else {
var temp__5804__auto___42345 = (function (){var fexpr__41721 = cljs.core.deref(input_checker41712_42335);
return (fexpr__41721.cljs$core$IFn$_invoke$arity$1 ? fexpr__41721.cljs$core$IFn$_invoke$arity$1(args__38225__auto___42338) : fexpr__41721.call(null,args__38225__auto___42338));
})();
if(cljs.core.truth_(temp__5804__auto___42345)){
var error__38226__auto___42346 = temp__5804__auto___42345;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42346], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41711_42334,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___42338,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42346], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var ba = G__41714;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41722_42347 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41723_42348 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41724_42349 = output_schema41710_42333;
var G__41725_42350 = cljs.core.deref(output_checker41713_42336);
var G__41726_42351 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41722_42347,G__41723_42348,G__41724_42349,G__41725_42350,G__41726_42351) : schema.core.fn_validator.call(null,G__41722_42347,G__41723_42348,G__41724_42349,G__41725_42350,G__41726_42351));
} else {
var temp__5804__auto___42352 = (function (){var fexpr__41728 = cljs.core.deref(output_checker41713_42336);
return (fexpr__41728.cljs$core$IFn$_invoke$arity$1 ? fexpr__41728.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__41728.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42352)){
var error__38226__auto___42353 = temp__5804__auto___42352;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___42353], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41710_42333,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___42353], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41710_42333,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41711_42334], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
