goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39798__39799__auto__){
if((!((p1__39798__39799__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39798__39799__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39798__39799__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39798__39799__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39798__39799__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___54133 = schema.utils.use_fn_validation;
var output_schema53181_54134 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53182_54135 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker53183_54136 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53182_54135);
}),null));
var output_checker53184_54137 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53181_54134);
}),null));
var ret__40667__auto___54139 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__53185){
var validate__38224__auto__ = cljs.core.deref(ufv___54133);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54141 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53185], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53196_54142 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53197_54143 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53198_54144 = input_schema53182_54135;
var G__53199_54145 = cljs.core.deref(input_checker53183_54136);
var G__53200_54146 = args__38225__auto___54141;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53196_54142,G__53197_54143,G__53198_54144,G__53199_54145,G__53200_54146) : schema.core.fn_validator.call(null,G__53196_54142,G__53197_54143,G__53198_54144,G__53199_54145,G__53200_54146));
} else {
var temp__5804__auto___54147 = (function (){var fexpr__53201 = cljs.core.deref(input_checker53183_54136);
return (fexpr__53201.cljs$core$IFn$_invoke$arity$1 ? fexpr__53201.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54141) : fexpr__53201.call(null,args__38225__auto___54141));
})();
if(cljs.core.truth_(temp__5804__auto___54147)){
var error__38226__auto___54148 = temp__5804__auto___54147;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54148], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53182_54135,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54141,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54148], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var json = G__53185;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53204_54151 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53205_54152 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53206_54153 = output_schema53181_54134;
var G__53207_54154 = cljs.core.deref(output_checker53184_54137);
var G__53208_54155 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53204_54151,G__53205_54152,G__53206_54153,G__53207_54154,G__53208_54155) : schema.core.fn_validator.call(null,G__53204_54151,G__53205_54152,G__53206_54153,G__53207_54154,G__53208_54155));
} else {
var temp__5804__auto___54157 = (function (){var fexpr__53209 = cljs.core.deref(output_checker53184_54137);
return (fexpr__53209.cljs$core$IFn$_invoke$arity$1 ? fexpr__53209.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53209.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54157)){
var error__38226__auto___54158 = temp__5804__auto___54157;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54158], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53181_54134,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54158], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema53181_54134,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53182_54135], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___54160 = schema.utils.use_fn_validation;
var output_schema53218_54161 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53219_54162 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema53224_54163 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53220_54164 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53219_54162);
}),null));
var output_checker53221_54165 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53218_54161);
}),null));
var input_checker53225_54166 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53224_54163);
}),null));
var output_checker53226_54167 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53218_54161);
}),null));
var ret__40667__auto___54169 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__53234 = arguments.length;
switch (G__53234) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53222,G__53223){
var validate__38224__auto__ = cljs.core.deref(ufv___54160);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54174 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53222,G__53223], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53241_54175 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53242_54176 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53243_54177 = input_schema53219_54162;
var G__53244_54178 = cljs.core.deref(input_checker53220_54164);
var G__53245_54179 = args__38225__auto___54174;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53241_54175,G__53242_54176,G__53243_54177,G__53244_54178,G__53245_54179) : schema.core.fn_validator.call(null,G__53241_54175,G__53242_54176,G__53243_54177,G__53244_54178,G__53245_54179));
} else {
var temp__5804__auto___54180 = (function (){var fexpr__53246 = cljs.core.deref(input_checker53220_54164);
return (fexpr__53246.cljs$core$IFn$_invoke$arity$1 ? fexpr__53246.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54174) : fexpr__53246.call(null,args__38225__auto___54174));
})();
if(cljs.core.truth_(temp__5804__auto___54180)){
var error__38226__auto___54181 = temp__5804__auto___54180;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54181], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53219_54162,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54174,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54181], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var name_kw = G__53222;
var fields = G__53223;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53254_54187 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53255_54188 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53256_54189 = output_schema53218_54161;
var G__53257_54190 = cljs.core.deref(output_checker53221_54165);
var G__53258_54191 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53254_54187,G__53255_54188,G__53256_54189,G__53257_54190,G__53258_54191) : schema.core.fn_validator.call(null,G__53254_54187,G__53255_54188,G__53256_54189,G__53257_54190,G__53258_54191));
} else {
var temp__5804__auto___54193 = (function (){var fexpr__53259 = cljs.core.deref(output_checker53221_54165);
return (fexpr__53259.cljs$core$IFn$_invoke$arity$1 ? fexpr__53259.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53259.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54193)){
var error__38226__auto___54195 = temp__5804__auto___54193;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54195], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53218_54161,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54195], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53227,G__53228,G__53229){
var validate__38224__auto__ = cljs.core.deref(ufv___54160);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54196 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53227,G__53228,G__53229], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53261_54197 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53262_54198 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53263_54199 = input_schema53224_54163;
var G__53264_54200 = cljs.core.deref(input_checker53225_54166);
var G__53265_54201 = args__38225__auto___54196;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53261_54197,G__53262_54198,G__53263_54199,G__53264_54200,G__53265_54201) : schema.core.fn_validator.call(null,G__53261_54197,G__53262_54198,G__53263_54199,G__53264_54200,G__53265_54201));
} else {
var temp__5804__auto___54203 = (function (){var fexpr__53267 = cljs.core.deref(input_checker53225_54166);
return (fexpr__53267.cljs$core$IFn$_invoke$arity$1 ? fexpr__53267.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54196) : fexpr__53267.call(null,args__38225__auto___54196));
})();
if(cljs.core.truth_(temp__5804__auto___54203)){
var error__38226__auto___54204 = temp__5804__auto___54203;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54204], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53224_54163,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54196,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54204], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var name_kw = G__53227;
var docstring = G__53228;
var fields = G__53229;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53268_54208 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53269_54209 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53270_54210 = output_schema53218_54161;
var G__53271_54211 = cljs.core.deref(output_checker53226_54167);
var G__53272_54212 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53268_54208,G__53269_54209,G__53270_54210,G__53271_54211,G__53272_54212) : schema.core.fn_validator.call(null,G__53268_54208,G__53269_54209,G__53270_54210,G__53271_54211,G__53272_54212));
} else {
var temp__5804__auto___54215 = (function (){var fexpr__53273 = cljs.core.deref(output_checker53226_54167);
return (fexpr__53273.cljs$core$IFn$_invoke$arity$1 ? fexpr__53273.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53273.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54215)){
var error__38226__auto___54216 = temp__5804__auto___54215;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54216], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53218_54161,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54216], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema53218_54161,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53219_54162,input_schema53224_54163], null)));

var ufv___54217 = schema.utils.use_fn_validation;
var output_schema53274_54218 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53275_54219 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema53282_54220 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53276_54221 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53275_54219);
}),null));
var output_checker53277_54222 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53274_54218);
}),null));
var input_checker53283_54223 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53282_54220);
}),null));
var output_checker53284_54224 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53274_54218);
}),null));
var ret__40667__auto___54226 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__53303 = arguments.length;
switch (G__53303) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53278,G__53279){
var validate__38224__auto__ = cljs.core.deref(ufv___54217);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54229 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53278,G__53279], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53307_54230 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53308_54231 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53309_54232 = input_schema53275_54219;
var G__53310_54233 = cljs.core.deref(input_checker53276_54221);
var G__53311_54234 = args__38225__auto___54229;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53307_54230,G__53308_54231,G__53309_54232,G__53310_54233,G__53311_54234) : schema.core.fn_validator.call(null,G__53307_54230,G__53308_54231,G__53309_54232,G__53310_54233,G__53311_54234));
} else {
var temp__5804__auto___54235 = (function (){var fexpr__53312 = cljs.core.deref(input_checker53276_54221);
return (fexpr__53312.cljs$core$IFn$_invoke$arity$1 ? fexpr__53312.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54229) : fexpr__53312.call(null,args__38225__auto___54229));
})();
if(cljs.core.truth_(temp__5804__auto___54235)){
var error__38226__auto___54237 = temp__5804__auto___54235;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54237], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53275_54219,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54229,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54237], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var name_kw = G__53278;
var symbol_keywords = G__53279;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53313_54245 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53314_54246 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53315_54247 = output_schema53274_54218;
var G__53316_54248 = cljs.core.deref(output_checker53277_54222);
var G__53317_54249 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53313_54245,G__53314_54246,G__53315_54247,G__53316_54248,G__53317_54249) : schema.core.fn_validator.call(null,G__53313_54245,G__53314_54246,G__53315_54247,G__53316_54248,G__53317_54249));
} else {
var temp__5804__auto___54250 = (function (){var fexpr__53322 = cljs.core.deref(output_checker53277_54222);
return (fexpr__53322.cljs$core$IFn$_invoke$arity$1 ? fexpr__53322.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53322.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54250)){
var error__38226__auto___54252 = temp__5804__auto___54250;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54252], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53274_54218,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54252], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53285,G__53286,G__53287){
var validate__38224__auto__ = cljs.core.deref(ufv___54217);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54256 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53285,G__53286,G__53287], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53323_54258 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53324_54259 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53325_54260 = input_schema53282_54220;
var G__53326_54261 = cljs.core.deref(input_checker53283_54223);
var G__53327_54262 = args__38225__auto___54256;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53323_54258,G__53324_54259,G__53325_54260,G__53326_54261,G__53327_54262) : schema.core.fn_validator.call(null,G__53323_54258,G__53324_54259,G__53325_54260,G__53326_54261,G__53327_54262));
} else {
var temp__5804__auto___54265 = (function (){var fexpr__53330 = cljs.core.deref(input_checker53283_54223);
return (fexpr__53330.cljs$core$IFn$_invoke$arity$1 ? fexpr__53330.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54256) : fexpr__53330.call(null,args__38225__auto___54256));
})();
if(cljs.core.truth_(temp__5804__auto___54265)){
var error__38226__auto___54268 = temp__5804__auto___54265;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54268], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53282_54220,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54256,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54268], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var name_kw = G__53285;
var docstring = G__53286;
var symbol_keywords = G__53287;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53331_54269 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53332_54270 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53333_54271 = output_schema53274_54218;
var G__53334_54272 = cljs.core.deref(output_checker53284_54224);
var G__53335_54273 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53331_54269,G__53332_54270,G__53333_54271,G__53334_54272,G__53335_54273) : schema.core.fn_validator.call(null,G__53331_54269,G__53332_54270,G__53333_54271,G__53334_54272,G__53335_54273));
} else {
var temp__5804__auto___54274 = (function (){var fexpr__53336 = cljs.core.deref(output_checker53284_54224);
return (fexpr__53336.cljs$core$IFn$_invoke$arity$1 ? fexpr__53336.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53336.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54274)){
var error__38226__auto___54275 = temp__5804__auto___54274;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54275], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53274_54218,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54275], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema53274_54218,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53275_54219,input_schema53282_54220], null)));

var ufv___54277 = schema.utils.use_fn_validation;
var output_schema53345_54278 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53346_54279 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53347_54280 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53346_54279);
}),null));
var output_checker53348_54281 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53345_54278);
}),null));
var ret__40667__auto___54282 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__53349,G__53350){
var validate__38224__auto__ = cljs.core.deref(ufv___54277);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54283 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53349,G__53350], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53351_54284 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53352_54285 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53353_54286 = input_schema53346_54279;
var G__53354_54287 = cljs.core.deref(input_checker53347_54280);
var G__53355_54288 = args__38225__auto___54283;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53351_54284,G__53352_54285,G__53353_54286,G__53354_54287,G__53355_54288) : schema.core.fn_validator.call(null,G__53351_54284,G__53352_54285,G__53353_54286,G__53354_54287,G__53355_54288));
} else {
var temp__5804__auto___54290 = (function (){var fexpr__53356 = cljs.core.deref(input_checker53347_54280);
return (fexpr__53356.cljs$core$IFn$_invoke$arity$1 ? fexpr__53356.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54283) : fexpr__53356.call(null,args__38225__auto___54283));
})();
if(cljs.core.truth_(temp__5804__auto___54290)){
var error__38226__auto___54291 = temp__5804__auto___54290;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54291], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53346_54279,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54283,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54291], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var name_kw = G__53349;
var size = G__53350;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53364_54294 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53365_54295 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53366_54296 = output_schema53345_54278;
var G__53367_54297 = cljs.core.deref(output_checker53348_54281);
var G__53368_54298 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53364_54294,G__53365_54295,G__53366_54296,G__53367_54297,G__53368_54298) : schema.core.fn_validator.call(null,G__53364_54294,G__53365_54295,G__53366_54296,G__53367_54297,G__53368_54298));
} else {
var temp__5804__auto___54305 = (function (){var fexpr__53369 = cljs.core.deref(output_checker53348_54281);
return (fexpr__53369.cljs$core$IFn$_invoke$arity$1 ? fexpr__53369.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53369.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54305)){
var error__38226__auto___54307 = temp__5804__auto___54305;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54307], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53345_54278,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54307], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema53345_54278,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53346_54279], null)));

var ufv___54308 = schema.utils.use_fn_validation;
var output_schema53370_54309 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53371_54310 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53372_54311 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53371_54310);
}),null));
var output_checker53373_54312 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53370_54309);
}),null));
var ret__40667__auto___54314 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__53374){
var validate__38224__auto__ = cljs.core.deref(ufv___54308);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54315 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53374], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53381_54316 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53382_54317 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53383_54318 = input_schema53371_54310;
var G__53384_54319 = cljs.core.deref(input_checker53372_54311);
var G__53385_54320 = args__38225__auto___54315;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53381_54316,G__53382_54317,G__53383_54318,G__53384_54319,G__53385_54320) : schema.core.fn_validator.call(null,G__53381_54316,G__53382_54317,G__53383_54318,G__53384_54319,G__53385_54320));
} else {
var temp__5804__auto___54322 = (function (){var fexpr__53386 = cljs.core.deref(input_checker53372_54311);
return (fexpr__53386.cljs$core$IFn$_invoke$arity$1 ? fexpr__53386.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54315) : fexpr__53386.call(null,args__38225__auto___54315));
})();
if(cljs.core.truth_(temp__5804__auto___54322)){
var error__38226__auto___54325 = temp__5804__auto___54322;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54325], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53371_54310,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54315,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54325], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var items_schema = G__53374;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53387_54328 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53388_54329 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53389_54330 = output_schema53370_54309;
var G__53390_54331 = cljs.core.deref(output_checker53373_54312);
var G__53391_54332 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53387_54328,G__53388_54329,G__53389_54330,G__53390_54331,G__53391_54332) : schema.core.fn_validator.call(null,G__53387_54328,G__53388_54329,G__53389_54330,G__53390_54331,G__53391_54332));
} else {
var temp__5804__auto___54336 = (function (){var fexpr__53392 = cljs.core.deref(output_checker53373_54312);
return (fexpr__53392.cljs$core$IFn$_invoke$arity$1 ? fexpr__53392.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53392.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54336)){
var error__38226__auto___54337 = temp__5804__auto___54336;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54337], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53370_54309,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54337], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema53370_54309,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53371_54310], null)));

var ufv___54341 = schema.utils.use_fn_validation;
var output_schema53395_54342 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53396_54343 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53397_54344 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53396_54343);
}),null));
var output_checker53398_54345 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53395_54342);
}),null));
var ret__40667__auto___54347 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__53399){
var validate__38224__auto__ = cljs.core.deref(ufv___54341);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54350 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53399], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53402_54352 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53403_54353 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53404_54354 = input_schema53396_54343;
var G__53405_54355 = cljs.core.deref(input_checker53397_54344);
var G__53406_54356 = args__38225__auto___54350;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53402_54352,G__53403_54353,G__53404_54354,G__53405_54355,G__53406_54356) : schema.core.fn_validator.call(null,G__53402_54352,G__53403_54353,G__53404_54354,G__53405_54355,G__53406_54356));
} else {
var temp__5804__auto___54358 = (function (){var fexpr__53410 = cljs.core.deref(input_checker53397_54344);
return (fexpr__53410.cljs$core$IFn$_invoke$arity$1 ? fexpr__53410.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54350) : fexpr__53410.call(null,args__38225__auto___54350));
})();
if(cljs.core.truth_(temp__5804__auto___54358)){
var error__38226__auto___54359 = temp__5804__auto___54358;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54359], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53396_54343,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54350,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54359], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var values_schema = G__53399;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53413_54365 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53414_54366 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53415_54367 = output_schema53395_54342;
var G__53416_54368 = cljs.core.deref(output_checker53398_54345);
var G__53417_54369 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53413_54365,G__53414_54366,G__53415_54367,G__53416_54368,G__53417_54369) : schema.core.fn_validator.call(null,G__53413_54365,G__53414_54366,G__53415_54367,G__53416_54368,G__53417_54369));
} else {
var temp__5804__auto___54371 = (function (){var fexpr__53419 = cljs.core.deref(output_checker53398_54345);
return (fexpr__53419.cljs$core$IFn$_invoke$arity$1 ? fexpr__53419.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53419.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54371)){
var error__38226__auto___54373 = temp__5804__auto___54371;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54373], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53395_54342,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54373], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema53395_54342,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53396_54343], null)));

var ufv___54374 = schema.utils.use_fn_validation;
var output_schema53420_54375 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53421_54376 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker53422_54377 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53421_54376);
}),null));
var output_checker53423_54378 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53420_54375);
}),null));
var ret__40667__auto___54379 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__53424){
var validate__38224__auto__ = cljs.core.deref(ufv___54374);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54381 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53424], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53431_54383 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53432_54384 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53433_54385 = input_schema53421_54376;
var G__53434_54386 = cljs.core.deref(input_checker53422_54377);
var G__53435_54387 = args__38225__auto___54381;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53431_54383,G__53432_54384,G__53433_54385,G__53434_54386,G__53435_54387) : schema.core.fn_validator.call(null,G__53431_54383,G__53432_54384,G__53433_54385,G__53434_54386,G__53435_54387));
} else {
var temp__5804__auto___54390 = (function (){var fexpr__53436 = cljs.core.deref(input_checker53422_54377);
return (fexpr__53436.cljs$core$IFn$_invoke$arity$1 ? fexpr__53436.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54381) : fexpr__53436.call(null,args__38225__auto___54381));
})();
if(cljs.core.truth_(temp__5804__auto___54390)){
var error__38226__auto___54393 = temp__5804__auto___54390;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54393], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53421_54376,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54381,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54393], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var member_schemas = G__53424;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53437_54395 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53438_54396 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53439_54397 = output_schema53420_54375;
var G__53440_54398 = cljs.core.deref(output_checker53423_54378);
var G__53441_54399 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53437_54395,G__53438_54396,G__53439_54397,G__53440_54398,G__53441_54399) : schema.core.fn_validator.call(null,G__53437_54395,G__53438_54396,G__53439_54397,G__53440_54398,G__53441_54399));
} else {
var temp__5804__auto___54401 = (function (){var fexpr__53442 = cljs.core.deref(output_checker53423_54378);
return (fexpr__53442.cljs$core$IFn$_invoke$arity$1 ? fexpr__53442.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53442.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54401)){
var error__38226__auto___54402 = temp__5804__auto___54401;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54402], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53420_54375,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54402], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema53420_54375,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53421_54376], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___54408 = schema.utils.use_fn_validation;
var output_schema53445_54409 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53446_54410 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53447_54411 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53446_54410);
}),null));
var output_checker53448_54412 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53445_54409);
}),null));
var ret__40667__auto___54413 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__53449){
var validate__38224__auto__ = cljs.core.deref(ufv___54408);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54414 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53449], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53451_54416 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53452_54417 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53453_54418 = input_schema53446_54410;
var G__53454_54419 = cljs.core.deref(input_checker53447_54411);
var G__53455_54420 = args__38225__auto___54414;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53451_54416,G__53452_54417,G__53453_54418,G__53454_54419,G__53455_54420) : schema.core.fn_validator.call(null,G__53451_54416,G__53452_54417,G__53453_54418,G__53454_54419,G__53455_54420));
} else {
var temp__5804__auto___54421 = (function (){var fexpr__53462 = cljs.core.deref(input_checker53447_54411);
return (fexpr__53462.cljs$core$IFn$_invoke$arity$1 ? fexpr__53462.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54414) : fexpr__53462.call(null,args__38225__auto___54414));
})();
if(cljs.core.truth_(temp__5804__auto___54421)){
var error__38226__auto___54423 = temp__5804__auto___54421;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54423], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53446_54410,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54414,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54423], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53449;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53469_54429 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53470_54430 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53471_54431 = output_schema53445_54409;
var G__53472_54432 = cljs.core.deref(output_checker53448_54412);
var G__53473_54433 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53469_54429,G__53470_54430,G__53471_54431,G__53472_54432,G__53473_54433) : schema.core.fn_validator.call(null,G__53469_54429,G__53470_54430,G__53471_54431,G__53472_54432,G__53473_54433));
} else {
var temp__5804__auto___54435 = (function (){var fexpr__53475 = cljs.core.deref(output_checker53448_54412);
return (fexpr__53475.cljs$core$IFn$_invoke$arity$1 ? fexpr__53475.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53475.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54435)){
var error__38226__auto___54436 = temp__5804__auto___54435;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54436], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53445_54409,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54436], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema53445_54409,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53446_54410], null)));

var ufv___54438 = schema.utils.use_fn_validation;
var output_schema53478_54439 = deercreeklabs.baracus.ByteArray;
var input_schema53480_54440 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53481_54441 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53480_54440);
}),null));
var output_checker53482_54442 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53478_54439);
}),null));
var ret__40667__auto___54445 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__53484,G__53485){
var validate__38224__auto__ = cljs.core.deref(ufv___54438);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54448 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53484,G__53485], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53497_54451 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53498_54452 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53499_54453 = input_schema53480_54440;
var G__53500_54454 = cljs.core.deref(input_checker53481_54441);
var G__53501_54455 = args__38225__auto___54448;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53497_54451,G__53498_54452,G__53499_54453,G__53500_54454,G__53501_54455) : schema.core.fn_validator.call(null,G__53497_54451,G__53498_54452,G__53499_54453,G__53500_54454,G__53501_54455));
} else {
var temp__5804__auto___54456 = (function (){var fexpr__53509 = cljs.core.deref(input_checker53481_54441);
return (fexpr__53509.cljs$core$IFn$_invoke$arity$1 ? fexpr__53509.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54448) : fexpr__53509.call(null,args__38225__auto___54448));
})();
if(cljs.core.truth_(temp__5804__auto___54456)){
var error__38226__auto___54457 = temp__5804__auto___54456;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54457], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53480_54440,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54448,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54457], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var writer_schema = G__53484;
var data = G__53485;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53518_54462 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53519_54463 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53520_54464 = output_schema53478_54439;
var G__53521_54465 = cljs.core.deref(output_checker53482_54442);
var G__53522_54466 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53518_54462,G__53519_54463,G__53520_54464,G__53521_54465,G__53522_54466) : schema.core.fn_validator.call(null,G__53518_54462,G__53519_54463,G__53520_54464,G__53521_54465,G__53522_54466));
} else {
var temp__5804__auto___54468 = (function (){var fexpr__53525 = cljs.core.deref(output_checker53482_54442);
return (fexpr__53525.cljs$core$IFn$_invoke$arity$1 ? fexpr__53525.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53525.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54468)){
var error__38226__auto___54469 = temp__5804__auto___54468;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54469], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53478_54439,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54469], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema53478_54439,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53480_54440], null)));

var ufv___54472 = schema.utils.use_fn_validation;
var output_schema53530_54473 = schema.core.Any;
var input_schema53531_54474 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53532_54475 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53531_54474);
}),null));
var output_checker53533_54476 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53530_54473);
}),null));
var ret__40667__auto___54478 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__53534,G__53535,G__53536){
var validate__38224__auto__ = cljs.core.deref(ufv___54472);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54480 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53534,G__53535,G__53536], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53560_54481 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53561_54482 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53562_54483 = input_schema53531_54474;
var G__53563_54484 = cljs.core.deref(input_checker53532_54475);
var G__53564_54485 = args__38225__auto___54480;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53560_54481,G__53561_54482,G__53562_54483,G__53563_54484,G__53564_54485) : schema.core.fn_validator.call(null,G__53560_54481,G__53561_54482,G__53562_54483,G__53563_54484,G__53564_54485));
} else {
var temp__5804__auto___54487 = (function (){var fexpr__53566 = cljs.core.deref(input_checker53532_54475);
return (fexpr__53566.cljs$core$IFn$_invoke$arity$1 ? fexpr__53566.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54480) : fexpr__53566.call(null,args__38225__auto___54480));
})();
if(cljs.core.truth_(temp__5804__auto___54487)){
var error__38226__auto___54488 = temp__5804__auto___54487;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54488], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53531_54474,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54480,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54488], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var reader_schema = G__53534;
var writer_schema = G__53535;
var ba = G__53536;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53575_54496 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53576_54497 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53577_54498 = output_schema53530_54473;
var G__53578_54499 = cljs.core.deref(output_checker53533_54476);
var G__53579_54500 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53575_54496,G__53576_54497,G__53577_54498,G__53578_54499,G__53579_54500) : schema.core.fn_validator.call(null,G__53575_54496,G__53576_54497,G__53577_54498,G__53578_54499,G__53579_54500));
} else {
var temp__5804__auto___54503 = (function (){var fexpr__53582 = cljs.core.deref(output_checker53533_54476);
return (fexpr__53582.cljs$core$IFn$_invoke$arity$1 ? fexpr__53582.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53582.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54503)){
var error__38226__auto___54504 = temp__5804__auto___54503;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54504], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53530_54473,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54504], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema53530_54473,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53531_54474], null)));

var ufv___54515 = schema.utils.use_fn_validation;
var output_schema53586_54516 = schema.core.Any;
var input_schema53587_54517 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53588_54518 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53587_54517);
}),null));
var output_checker53589_54519 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53586_54516);
}),null));
var ret__40667__auto___54520 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__53590,G__53591){
var validate__38224__auto__ = cljs.core.deref(ufv___54515);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54521 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53590,G__53591], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53600_54522 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53601_54523 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53602_54524 = input_schema53587_54517;
var G__53603_54525 = cljs.core.deref(input_checker53588_54518);
var G__53604_54526 = args__38225__auto___54521;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53600_54522,G__53601_54523,G__53602_54524,G__53603_54525,G__53604_54526) : schema.core.fn_validator.call(null,G__53600_54522,G__53601_54523,G__53602_54524,G__53603_54525,G__53604_54526));
} else {
var temp__5804__auto___54527 = (function (){var fexpr__53605 = cljs.core.deref(input_checker53588_54518);
return (fexpr__53605.cljs$core$IFn$_invoke$arity$1 ? fexpr__53605.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54521) : fexpr__53605.call(null,args__38225__auto___54521));
})();
if(cljs.core.truth_(temp__5804__auto___54527)){
var error__38226__auto___54528 = temp__5804__auto___54527;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54528], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53587_54517,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54521,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54528], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53590;
var ba = G__53591;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53609_54529 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53610_54530 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53611_54531 = output_schema53586_54516;
var G__53612_54532 = cljs.core.deref(output_checker53589_54519);
var G__53613_54533 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53609_54529,G__53610_54530,G__53611_54531,G__53612_54532,G__53613_54533) : schema.core.fn_validator.call(null,G__53609_54529,G__53610_54530,G__53611_54531,G__53612_54532,G__53613_54533));
} else {
var temp__5804__auto___54534 = (function (){var fexpr__53615 = cljs.core.deref(output_checker53589_54519);
return (fexpr__53615.cljs$core$IFn$_invoke$arity$1 ? fexpr__53615.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53615.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54534)){
var error__38226__auto___54535 = temp__5804__auto___54534;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54535], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53586_54516,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54535], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema53586_54516,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53587_54517], null)));

var ufv___54540 = schema.utils.use_fn_validation;
var output_schema53635_54541 = schema.core.Any;
var input_schema53637_54542 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53638_54543 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53637_54542);
}),null));
var output_checker53639_54544 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53635_54541);
}),null));
var ret__40667__auto___54547 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__53640){
var validate__38224__auto__ = cljs.core.deref(ufv___54540);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54548 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53640], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53650_54549 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53651_54550 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53652_54551 = input_schema53637_54542;
var G__53653_54552 = cljs.core.deref(input_checker53638_54543);
var G__53654_54553 = args__38225__auto___54548;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53650_54549,G__53651_54550,G__53652_54551,G__53653_54552,G__53654_54553) : schema.core.fn_validator.call(null,G__53650_54549,G__53651_54550,G__53652_54551,G__53653_54552,G__53654_54553));
} else {
var temp__5804__auto___54558 = (function (){var fexpr__53659 = cljs.core.deref(input_checker53638_54543);
return (fexpr__53659.cljs$core$IFn$_invoke$arity$1 ? fexpr__53659.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54548) : fexpr__53659.call(null,args__38225__auto___54548));
})();
if(cljs.core.truth_(temp__5804__auto___54558)){
var error__38226__auto___54560 = temp__5804__auto___54558;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54560], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53637_54542,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54548,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54560], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53640;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53663_54567 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53664_54568 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53665_54569 = output_schema53635_54541;
var G__53666_54570 = cljs.core.deref(output_checker53639_54544);
var G__53667_54572 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53663_54567,G__53664_54568,G__53665_54569,G__53666_54570,G__53667_54572) : schema.core.fn_validator.call(null,G__53663_54567,G__53664_54568,G__53665_54569,G__53666_54570,G__53667_54572));
} else {
var temp__5804__auto___54575 = (function (){var fexpr__53668 = cljs.core.deref(output_checker53639_54544);
return (fexpr__53668.cljs$core$IFn$_invoke$arity$1 ? fexpr__53668.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53668.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54575)){
var error__38226__auto___54576 = temp__5804__auto___54575;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54576], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53635_54541,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54576], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema53635_54541,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53637_54542], null)));

var ufv___54581 = schema.utils.use_fn_validation;
var output_schema53676_54582 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53677_54583 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53678_54584 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53677_54583);
}),null));
var output_checker53679_54585 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53676_54582);
}),null));
var ret__40667__auto___54586 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__53680){
var validate__38224__auto__ = cljs.core.deref(ufv___54581);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54587 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53680], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53706_54588 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53707_54589 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53708_54590 = input_schema53677_54583;
var G__53709_54591 = cljs.core.deref(input_checker53678_54584);
var G__53710_54592 = args__38225__auto___54587;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53706_54588,G__53707_54589,G__53708_54590,G__53709_54591,G__53710_54592) : schema.core.fn_validator.call(null,G__53706_54588,G__53707_54589,G__53708_54590,G__53709_54591,G__53710_54592));
} else {
var temp__5804__auto___54593 = (function (){var fexpr__53711 = cljs.core.deref(input_checker53678_54584);
return (fexpr__53711.cljs$core$IFn$_invoke$arity$1 ? fexpr__53711.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54587) : fexpr__53711.call(null,args__38225__auto___54587));
})();
if(cljs.core.truth_(temp__5804__auto___54593)){
var error__38226__auto___54594 = temp__5804__auto___54593;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54594], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53677_54583,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54587,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54594], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var edn = G__53680;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53712_54596 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53713_54597 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53714_54598 = output_schema53676_54582;
var G__53715_54599 = cljs.core.deref(output_checker53679_54585);
var G__53716_54600 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53712_54596,G__53713_54597,G__53714_54598,G__53715_54599,G__53716_54600) : schema.core.fn_validator.call(null,G__53712_54596,G__53713_54597,G__53714_54598,G__53715_54599,G__53716_54600));
} else {
var temp__5804__auto___54602 = (function (){var fexpr__53717 = cljs.core.deref(output_checker53679_54585);
return (fexpr__53717.cljs$core$IFn$_invoke$arity$1 ? fexpr__53717.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53717.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54602)){
var error__38226__auto___54603 = temp__5804__auto___54602;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54603], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53676_54582,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54603], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema53676_54582,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53677_54583], null)));

var ufv___54605 = schema.utils.use_fn_validation;
var output_schema53721_54606 = schema.core.Str;
var input_schema53722_54607 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53723_54608 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53722_54607);
}),null));
var output_checker53724_54609 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53721_54606);
}),null));
var ret__40667__auto___54610 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__53725){
var validate__38224__auto__ = cljs.core.deref(ufv___54605);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54611 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53725], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53726_54612 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53727_54613 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53728_54614 = input_schema53722_54607;
var G__53729_54615 = cljs.core.deref(input_checker53723_54608);
var G__53730_54616 = args__38225__auto___54611;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53726_54612,G__53727_54613,G__53728_54614,G__53729_54615,G__53730_54616) : schema.core.fn_validator.call(null,G__53726_54612,G__53727_54613,G__53728_54614,G__53729_54615,G__53730_54616));
} else {
var temp__5804__auto___54618 = (function (){var fexpr__53731 = cljs.core.deref(input_checker53723_54608);
return (fexpr__53731.cljs$core$IFn$_invoke$arity$1 ? fexpr__53731.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54611) : fexpr__53731.call(null,args__38225__auto___54611));
})();
if(cljs.core.truth_(temp__5804__auto___54618)){
var error__38226__auto___54619 = temp__5804__auto___54618;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54619], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53722_54607,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54611,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54619], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53725;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53732_54621 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53733_54622 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53734_54623 = output_schema53721_54606;
var G__53735_54624 = cljs.core.deref(output_checker53724_54609);
var G__53736_54625 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53732_54621,G__53733_54622,G__53734_54623,G__53735_54624,G__53736_54625) : schema.core.fn_validator.call(null,G__53732_54621,G__53733_54622,G__53734_54623,G__53735_54624,G__53736_54625));
} else {
var temp__5804__auto___54626 = (function (){var fexpr__53737 = cljs.core.deref(output_checker53724_54609);
return (fexpr__53737.cljs$core$IFn$_invoke$arity$1 ? fexpr__53737.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53737.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54626)){
var error__38226__auto___54627 = temp__5804__auto___54626;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54627], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53721_54606,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54627], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema53721_54606,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53722_54607], null)));

var ufv___54630 = schema.utils.use_fn_validation;
var output_schema53741_54631 = schema.core.Keyword;
var input_schema53742_54632 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53743_54633 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53742_54632);
}),null));
var output_checker53744_54634 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53741_54631);
}),null));
var ret__40667__auto___54636 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__53745){
var validate__38224__auto__ = cljs.core.deref(ufv___54630);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54640 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53745], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53748_54641 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53749_54642 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53750_54643 = input_schema53742_54632;
var G__53751_54644 = cljs.core.deref(input_checker53743_54633);
var G__53752_54645 = args__38225__auto___54640;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53748_54641,G__53749_54642,G__53750_54643,G__53751_54644,G__53752_54645) : schema.core.fn_validator.call(null,G__53748_54641,G__53749_54642,G__53750_54643,G__53751_54644,G__53752_54645));
} else {
var temp__5804__auto___54646 = (function (){var fexpr__53753 = cljs.core.deref(input_checker53743_54633);
return (fexpr__53753.cljs$core$IFn$_invoke$arity$1 ? fexpr__53753.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54640) : fexpr__53753.call(null,args__38225__auto___54640));
})();
if(cljs.core.truth_(temp__5804__auto___54646)){
var error__38226__auto___54647 = temp__5804__auto___54646;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54647], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53742_54632,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54640,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54647], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53745;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53754_54650 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53755_54651 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53756_54652 = output_schema53741_54631;
var G__53757_54653 = cljs.core.deref(output_checker53744_54634);
var G__53758_54654 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53754_54650,G__53755_54651,G__53756_54652,G__53757_54653,G__53758_54654) : schema.core.fn_validator.call(null,G__53754_54650,G__53755_54651,G__53756_54652,G__53757_54653,G__53758_54654));
} else {
var temp__5804__auto___54656 = (function (){var fexpr__53759 = cljs.core.deref(output_checker53744_54634);
return (fexpr__53759.cljs$core$IFn$_invoke$arity$1 ? fexpr__53759.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53759.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54656)){
var error__38226__auto___54658 = temp__5804__auto___54656;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54658], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53741_54631,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54658], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema53741_54631,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53742_54632], null)));

var ufv___54661 = schema.utils.use_fn_validation;
var output_schema53763_54662 = schema.core.Str;
var input_schema53764_54663 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53765_54664 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53764_54663);
}),null));
var output_checker53766_54665 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53763_54662);
}),null));
var ret__40667__auto___54669 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__53767){
var validate__38224__auto__ = cljs.core.deref(ufv___54661);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54673 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53767], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53769_54675 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53770_54676 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53771_54677 = input_schema53764_54663;
var G__53772_54678 = cljs.core.deref(input_checker53765_54664);
var G__53773_54679 = args__38225__auto___54673;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53769_54675,G__53770_54676,G__53771_54677,G__53772_54678,G__53773_54679) : schema.core.fn_validator.call(null,G__53769_54675,G__53770_54676,G__53771_54677,G__53772_54678,G__53773_54679));
} else {
var temp__5804__auto___54680 = (function (){var fexpr__53780 = cljs.core.deref(input_checker53765_54664);
return (fexpr__53780.cljs$core$IFn$_invoke$arity$1 ? fexpr__53780.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54673) : fexpr__53780.call(null,args__38225__auto___54673));
})();
if(cljs.core.truth_(temp__5804__auto___54680)){
var error__38226__auto___54681 = temp__5804__auto___54680;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54681], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53764_54663,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54673,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54681], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53767;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53781_54682 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53782_54683 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53783_54684 = output_schema53763_54662;
var G__53784_54685 = cljs.core.deref(output_checker53766_54665);
var G__53785_54686 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53781_54682,G__53782_54683,G__53783_54684,G__53784_54685,G__53785_54686) : schema.core.fn_validator.call(null,G__53781_54682,G__53782_54683,G__53783_54684,G__53784_54685,G__53785_54686));
} else {
var temp__5804__auto___54688 = (function (){var fexpr__53786 = cljs.core.deref(output_checker53766_54665);
return (fexpr__53786.cljs$core$IFn$_invoke$arity$1 ? fexpr__53786.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53786.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54688)){
var error__38226__auto___54691 = temp__5804__auto___54688;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54691], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53763_54662,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54691], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema53763_54662,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53764_54663], null)));

var ufv___54697 = schema.utils.use_fn_validation;
var output_schema53790_54698 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema53791_54699 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53792_54700 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53791_54699);
}),null));
var output_checker53793_54701 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53790_54698);
}),null));
var ret__40667__auto___54702 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__53794){
var validate__38224__auto__ = cljs.core.deref(ufv___54697);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54703 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53794], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53802_54704 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53803_54705 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53804_54706 = input_schema53791_54699;
var G__53805_54707 = cljs.core.deref(input_checker53792_54700);
var G__53806_54708 = args__38225__auto___54703;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53802_54704,G__53803_54705,G__53804_54706,G__53805_54707,G__53806_54708) : schema.core.fn_validator.call(null,G__53802_54704,G__53803_54705,G__53804_54706,G__53805_54707,G__53806_54708));
} else {
var temp__5804__auto___54710 = (function (){var fexpr__53807 = cljs.core.deref(input_checker53792_54700);
return (fexpr__53807.cljs$core$IFn$_invoke$arity$1 ? fexpr__53807.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54703) : fexpr__53807.call(null,args__38225__auto___54703));
})();
if(cljs.core.truth_(temp__5804__auto___54710)){
var error__38226__auto___54713 = temp__5804__auto___54710;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54713], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53791_54699,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54703,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54713], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53794;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53810_54716 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53811_54717 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53812_54718 = output_schema53790_54698;
var G__53813_54719 = cljs.core.deref(output_checker53793_54701);
var G__53814_54720 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53810_54716,G__53811_54717,G__53812_54718,G__53813_54719,G__53814_54720) : schema.core.fn_validator.call(null,G__53810_54716,G__53811_54717,G__53812_54718,G__53813_54719,G__53814_54720));
} else {
var temp__5804__auto___54724 = (function (){var fexpr__53815 = cljs.core.deref(output_checker53793_54701);
return (fexpr__53815.cljs$core$IFn$_invoke$arity$1 ? fexpr__53815.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53815.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54724)){
var error__38226__auto___54725 = temp__5804__auto___54724;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54725], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53790_54698,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54725], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema53790_54698,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53791_54699], null)));

var ufv___54730 = schema.utils.use_fn_validation;
var output_schema53816_54731 = deercreeklabs.baracus.ByteArray;
var input_schema53817_54732 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53818_54733 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53817_54732);
}),null));
var output_checker53819_54734 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53816_54731);
}),null));
var ret__40667__auto___54735 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__53820){
var validate__38224__auto__ = cljs.core.deref(ufv___54730);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54736 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53820], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53824_54738 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53825_54739 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53826_54740 = input_schema53817_54732;
var G__53827_54741 = cljs.core.deref(input_checker53818_54733);
var G__53828_54742 = args__38225__auto___54736;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53824_54738,G__53825_54739,G__53826_54740,G__53827_54741,G__53828_54742) : schema.core.fn_validator.call(null,G__53824_54738,G__53825_54739,G__53826_54740,G__53827_54741,G__53828_54742));
} else {
var temp__5804__auto___54746 = (function (){var fexpr__53829 = cljs.core.deref(input_checker53818_54733);
return (fexpr__53829.cljs$core$IFn$_invoke$arity$1 ? fexpr__53829.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54736) : fexpr__53829.call(null,args__38225__auto___54736));
})();
if(cljs.core.truth_(temp__5804__auto___54746)){
var error__38226__auto___54747 = temp__5804__auto___54746;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54747], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53817_54732,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54736,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54747], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53820;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53830_54750 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53831_54751 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53832_54752 = output_schema53816_54731;
var G__53833_54753 = cljs.core.deref(output_checker53819_54734);
var G__53834_54754 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53830_54750,G__53831_54751,G__53832_54752,G__53833_54753,G__53834_54754) : schema.core.fn_validator.call(null,G__53830_54750,G__53831_54751,G__53832_54752,G__53833_54753,G__53834_54754));
} else {
var temp__5804__auto___54755 = (function (){var fexpr__53835 = cljs.core.deref(output_checker53819_54734);
return (fexpr__53835.cljs$core$IFn$_invoke$arity$1 ? fexpr__53835.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53835.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54755)){
var error__38226__auto___54757 = temp__5804__auto___54755;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54757], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53816_54731,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54757], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema53816_54731,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53817_54732], null)));

var ufv___54760 = schema.utils.use_fn_validation;
var output_schema53836_54761 = deercreeklabs.baracus.ByteArray;
var input_schema53837_54762 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53838_54763 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53837_54762);
}),null));
var output_checker53839_54764 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53836_54761);
}),null));
var ret__40667__auto___54767 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__53840){
var validate__38224__auto__ = cljs.core.deref(ufv___54760);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54772 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53840], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53841_54773 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53842_54774 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53843_54775 = input_schema53837_54762;
var G__53844_54776 = cljs.core.deref(input_checker53838_54763);
var G__53845_54777 = args__38225__auto___54772;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53841_54773,G__53842_54774,G__53843_54775,G__53844_54776,G__53845_54777) : schema.core.fn_validator.call(null,G__53841_54773,G__53842_54774,G__53843_54775,G__53844_54776,G__53845_54777));
} else {
var temp__5804__auto___54778 = (function (){var fexpr__53848 = cljs.core.deref(input_checker53838_54763);
return (fexpr__53848.cljs$core$IFn$_invoke$arity$1 ? fexpr__53848.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54772) : fexpr__53848.call(null,args__38225__auto___54772));
})();
if(cljs.core.truth_(temp__5804__auto___54778)){
var error__38226__auto___54779 = temp__5804__auto___54778;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54779], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53837_54762,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54772,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54779], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53840;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53849_54780 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53850_54781 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53851_54782 = output_schema53836_54761;
var G__53852_54783 = cljs.core.deref(output_checker53839_54764);
var G__53853_54784 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53849_54780,G__53850_54781,G__53851_54782,G__53852_54783,G__53853_54784) : schema.core.fn_validator.call(null,G__53849_54780,G__53850_54781,G__53851_54782,G__53852_54783,G__53853_54784));
} else {
var temp__5804__auto___54785 = (function (){var fexpr__53854 = cljs.core.deref(output_checker53839_54764);
return (fexpr__53854.cljs$core$IFn$_invoke$arity$1 ? fexpr__53854.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53854.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54785)){
var error__38226__auto___54786 = temp__5804__auto___54785;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54786], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53836_54761,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54786], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema53836_54761,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53837_54762], null)));

var ufv___54788 = schema.utils.use_fn_validation;
var output_schema53858_54789 = schema.core.Bool;
var input_schema53859_54790 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53860_54791 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53859_54790);
}),null));
var output_checker53861_54792 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53858_54789);
}),null));
var ret__40667__auto___54794 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__53862){
var validate__38224__auto__ = cljs.core.deref(ufv___54788);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54795 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53862], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53863_54796 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53864_54797 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53865_54798 = input_schema53859_54790;
var G__53866_54799 = cljs.core.deref(input_checker53860_54791);
var G__53867_54800 = args__38225__auto___54795;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53863_54796,G__53864_54797,G__53865_54798,G__53866_54799,G__53867_54800) : schema.core.fn_validator.call(null,G__53863_54796,G__53864_54797,G__53865_54798,G__53866_54799,G__53867_54800));
} else {
var temp__5804__auto___54802 = (function (){var fexpr__53868 = cljs.core.deref(input_checker53860_54791);
return (fexpr__53868.cljs$core$IFn$_invoke$arity$1 ? fexpr__53868.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54795) : fexpr__53868.call(null,args__38225__auto___54795));
})();
if(cljs.core.truth_(temp__5804__auto___54802)){
var error__38226__auto___54803 = temp__5804__auto___54802;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54803], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53859_54790,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54795,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54803], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var arg = G__53862;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53870_54805 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53871_54806 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53872_54807 = output_schema53858_54789;
var G__53873_54808 = cljs.core.deref(output_checker53861_54792);
var G__53874_54809 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53870_54805,G__53871_54806,G__53872_54807,G__53873_54808,G__53874_54809) : schema.core.fn_validator.call(null,G__53870_54805,G__53871_54806,G__53872_54807,G__53873_54808,G__53874_54809));
} else {
var temp__5804__auto___54815 = (function (){var fexpr__53875 = cljs.core.deref(output_checker53861_54792);
return (fexpr__53875.cljs$core$IFn$_invoke$arity$1 ? fexpr__53875.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53875.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54815)){
var error__38226__auto___54817 = temp__5804__auto___54815;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54817], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53858_54789,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54817], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema53858_54789,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53859_54790], null)));

var ufv___54821 = schema.utils.use_fn_validation;
var output_schema53876_54822 = schema.core.Bool;
var input_schema53877_54823 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53878_54824 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53877_54823);
}),null));
var output_checker53879_54825 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53876_54822);
}),null));
var ret__40667__auto___54827 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__53880,G__53881){
var validate__38224__auto__ = cljs.core.deref(ufv___54821);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54830 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53880,G__53881], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53882_54831 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53883_54832 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53884_54833 = input_schema53877_54823;
var G__53885_54834 = cljs.core.deref(input_checker53878_54824);
var G__53886_54835 = args__38225__auto___54830;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53882_54831,G__53883_54832,G__53884_54833,G__53885_54834,G__53886_54835) : schema.core.fn_validator.call(null,G__53882_54831,G__53883_54832,G__53884_54833,G__53885_54834,G__53886_54835));
} else {
var temp__5804__auto___54837 = (function (){var fexpr__53887 = cljs.core.deref(input_checker53878_54824);
return (fexpr__53887.cljs$core$IFn$_invoke$arity$1 ? fexpr__53887.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54830) : fexpr__53887.call(null,args__38225__auto___54830));
})();
if(cljs.core.truth_(temp__5804__auto___54837)){
var error__38226__auto___54838 = temp__5804__auto___54837;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54838], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53877_54823,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54830,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54838], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var reader_schema = G__53880;
var writer_schema = G__53881;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53890_54856 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53891_54857 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53892_54858 = output_schema53876_54822;
var G__53893_54859 = cljs.core.deref(output_checker53879_54825);
var G__53894_54860 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53890_54856,G__53891_54857,G__53892_54858,G__53893_54859,G__53894_54860) : schema.core.fn_validator.call(null,G__53890_54856,G__53891_54857,G__53892_54858,G__53893_54859,G__53894_54860));
} else {
var temp__5804__auto___54865 = (function (){var fexpr__53895 = cljs.core.deref(output_checker53879_54825);
return (fexpr__53895.cljs$core$IFn$_invoke$arity$1 ? fexpr__53895.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53895.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54865)){
var error__38226__auto___54866 = temp__5804__auto___54865;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54866], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53876_54822,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54866], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema53876_54822,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53877_54823], null)));

var ufv___54869 = schema.utils.use_fn_validation;
var output_schema53896_54870 = schema.core.Any;
var input_schema53897_54871 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53898_54872 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53897_54871);
}),null));
var output_checker53899_54873 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53896_54870);
}),null));
var ret__40667__auto___54875 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__53900){
var validate__38224__auto__ = cljs.core.deref(ufv___54869);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54880 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53900], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53901_54882 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53902_54883 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53903_54884 = input_schema53897_54871;
var G__53904_54885 = cljs.core.deref(input_checker53898_54872);
var G__53905_54886 = args__38225__auto___54880;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53901_54882,G__53902_54883,G__53903_54884,G__53904_54885,G__53905_54886) : schema.core.fn_validator.call(null,G__53901_54882,G__53902_54883,G__53903_54884,G__53904_54885,G__53905_54886));
} else {
var temp__5804__auto___54887 = (function (){var fexpr__53906 = cljs.core.deref(input_checker53898_54872);
return (fexpr__53906.cljs$core$IFn$_invoke$arity$1 ? fexpr__53906.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54880) : fexpr__53906.call(null,args__38225__auto___54880));
})();
if(cljs.core.truth_(temp__5804__auto___54887)){
var error__38226__auto___54888 = temp__5804__auto___54887;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54888], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53897_54871,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54880,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54888], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53900;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53907_54890 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53908_54891 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53909_54892 = output_schema53896_54870;
var G__53910_54893 = cljs.core.deref(output_checker53899_54873);
var G__53911_54894 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53907_54890,G__53908_54891,G__53909_54892,G__53910_54893,G__53911_54894) : schema.core.fn_validator.call(null,G__53907_54890,G__53908_54891,G__53909_54892,G__53910_54893,G__53911_54894));
} else {
var temp__5804__auto___54902 = (function (){var fexpr__53912 = cljs.core.deref(output_checker53899_54873);
return (fexpr__53912.cljs$core$IFn$_invoke$arity$1 ? fexpr__53912.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53912.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54902)){
var error__38226__auto___54903 = temp__5804__auto___54902;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54903], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53896_54870,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54903], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema53896_54870,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53897_54871], null)));

var ufv___54904 = schema.utils.use_fn_validation;
var output_schema53913_54905 = schema.core.Any;
var input_schema53914_54906 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53915_54907 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53914_54906);
}),null));
var output_checker53916_54908 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53913_54905);
}),null));
var ret__40667__auto___54910 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__53917){
var validate__38224__auto__ = cljs.core.deref(ufv___54904);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54913 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53917], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53918_54914 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53919_54915 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53920_54916 = input_schema53914_54906;
var G__53921_54917 = cljs.core.deref(input_checker53915_54907);
var G__53922_54918 = args__38225__auto___54913;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53918_54914,G__53919_54915,G__53920_54916,G__53921_54917,G__53922_54918) : schema.core.fn_validator.call(null,G__53918_54914,G__53919_54915,G__53920_54916,G__53921_54917,G__53922_54918));
} else {
var temp__5804__auto___54921 = (function (){var fexpr__53923 = cljs.core.deref(input_checker53915_54907);
return (fexpr__53923.cljs$core$IFn$_invoke$arity$1 ? fexpr__53923.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54913) : fexpr__53923.call(null,args__38225__auto___54913));
})();
if(cljs.core.truth_(temp__5804__auto___54921)){
var error__38226__auto___54922 = temp__5804__auto___54921;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54922], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53914_54906,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54913,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54922], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53917;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53925_54924 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53926_54925 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53927_54926 = output_schema53913_54905;
var G__53928_54927 = cljs.core.deref(output_checker53916_54908);
var G__53929_54928 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53925_54924,G__53926_54925,G__53927_54926,G__53928_54927,G__53929_54928) : schema.core.fn_validator.call(null,G__53925_54924,G__53926_54925,G__53927_54926,G__53928_54927,G__53929_54928));
} else {
var temp__5804__auto___54930 = (function (){var fexpr__53930 = cljs.core.deref(output_checker53916_54908);
return (fexpr__53930.cljs$core$IFn$_invoke$arity$1 ? fexpr__53930.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53930.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54930)){
var error__38226__auto___54932 = temp__5804__auto___54930;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54932], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53913_54905,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54932], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema53913_54905,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53914_54906], null)));

var ufv___54937 = schema.utils.use_fn_validation;
var output_schema53931_54938 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53932_54939 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema53936_54940 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker53933_54941 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53932_54939);
}),null));
var output_checker53934_54942 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53931_54938);
}),null));
var input_checker53937_54943 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53936_54940);
}),null));
var output_checker53938_54944 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53931_54938);
}),null));
var ret__40667__auto___54947 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__53942 = arguments.length;
switch (G__53942) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__53935){
var validate__38224__auto__ = cljs.core.deref(ufv___54937);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54951 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53935], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53944_54952 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53945_54953 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53946_54954 = input_schema53932_54939;
var G__53947_54955 = cljs.core.deref(input_checker53933_54941);
var G__53948_54956 = args__38225__auto___54951;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53944_54952,G__53945_54953,G__53946_54954,G__53947_54955,G__53948_54956) : schema.core.fn_validator.call(null,G__53944_54952,G__53945_54953,G__53946_54954,G__53947_54955,G__53948_54956));
} else {
var temp__5804__auto___54959 = (function (){var fexpr__53949 = cljs.core.deref(input_checker53933_54941);
return (fexpr__53949.cljs$core$IFn$_invoke$arity$1 ? fexpr__53949.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54951) : fexpr__53949.call(null,args__38225__auto___54951));
})();
if(cljs.core.truth_(temp__5804__auto___54959)){
var error__38226__auto___54961 = temp__5804__auto___54959;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54961], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53932_54939,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54951,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54961], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53935;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53954_54966 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53955_54967 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53956_54968 = output_schema53931_54938;
var G__53957_54969 = cljs.core.deref(output_checker53934_54942);
var G__53958_54970 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53954_54966,G__53955_54967,G__53956_54968,G__53957_54969,G__53958_54970) : schema.core.fn_validator.call(null,G__53954_54966,G__53955_54967,G__53956_54968,G__53957_54969,G__53958_54970));
} else {
var temp__5804__auto___54972 = (function (){var fexpr__53960 = cljs.core.deref(output_checker53934_54942);
return (fexpr__53960.cljs$core$IFn$_invoke$arity$1 ? fexpr__53960.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53960.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54972)){
var error__38226__auto___54973 = temp__5804__auto___54972;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54973], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53931_54938,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54973], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53939,G__53940){
var validate__38224__auto__ = cljs.core.deref(ufv___54937);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___54974 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53939,G__53940], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53961_54977 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53962_54978 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53963_54979 = input_schema53936_54940;
var G__53964_54980 = cljs.core.deref(input_checker53937_54943);
var G__53965_54981 = args__38225__auto___54974;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53961_54977,G__53962_54978,G__53963_54979,G__53964_54980,G__53965_54981) : schema.core.fn_validator.call(null,G__53961_54977,G__53962_54978,G__53963_54979,G__53964_54980,G__53965_54981));
} else {
var temp__5804__auto___54987 = (function (){var fexpr__53966 = cljs.core.deref(input_checker53937_54943);
return (fexpr__53966.cljs$core$IFn$_invoke$arity$1 ? fexpr__53966.cljs$core$IFn$_invoke$arity$1(args__38225__auto___54974) : fexpr__53966.call(null,args__38225__auto___54974));
})();
if(cljs.core.truth_(temp__5804__auto___54987)){
var error__38226__auto___54988 = temp__5804__auto___54987;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54988], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53936_54940,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___54974,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54988], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53939;
var field_kw_or_branch_i = G__53940;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53967_54991 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53968_54992 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__53969_54993 = output_schema53931_54938;
var G__53970_54994 = cljs.core.deref(output_checker53938_54944);
var G__53971_54995 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53967_54991,G__53968_54992,G__53969_54993,G__53970_54994,G__53971_54995) : schema.core.fn_validator.call(null,G__53967_54991,G__53968_54992,G__53969_54993,G__53970_54994,G__53971_54995));
} else {
var temp__5804__auto___54997 = (function (){var fexpr__53972 = cljs.core.deref(output_checker53938_54944);
return (fexpr__53972.cljs$core$IFn$_invoke$arity$1 ? fexpr__53972.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__53972.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54997)){
var error__38226__auto___54998 = temp__5804__auto___54997;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___54998], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53931_54938,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___54998], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema53931_54938,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53932_54939,input_schema53936_54940], null)));

var ufv___55002 = schema.utils.use_fn_validation;
var output_schema53978_55003 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema53979_55004 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema53984_55005 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker53980_55006 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53979_55004);
}),null));
var output_checker53981_55007 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53978_55003);
}),null));
var input_checker53985_55008 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53984_55005);
}),null));
var output_checker53986_55009 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53978_55003);
}),null));
var ret__40667__auto___55012 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__53994 = arguments.length;
switch (G__53994) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__53982,G__53983){
var validate__38224__auto__ = cljs.core.deref(ufv___55002);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___55014 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53982,G__53983], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53995_55015 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53996_55016 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__53997_55017 = input_schema53979_55004;
var G__53998_55019 = cljs.core.deref(input_checker53980_55006);
var G__53999_55020 = args__38225__auto___55014;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53995_55015,G__53996_55016,G__53997_55017,G__53998_55019,G__53999_55020) : schema.core.fn_validator.call(null,G__53995_55015,G__53996_55016,G__53997_55017,G__53998_55019,G__53999_55020));
} else {
var temp__5804__auto___55025 = (function (){var fexpr__54000 = cljs.core.deref(input_checker53980_55006);
return (fexpr__54000.cljs$core$IFn$_invoke$arity$1 ? fexpr__54000.cljs$core$IFn$_invoke$arity$1(args__38225__auto___55014) : fexpr__54000.call(null,args__38225__auto___55014));
})();
if(cljs.core.truth_(temp__5804__auto___55025)){
var error__38226__auto___55027 = temp__5804__auto___55025;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55027], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53979_55004,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___55014,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55027], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53982;
var path = G__53983;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54006_55028 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54007_55029 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54008_55030 = output_schema53978_55003;
var G__54009_55031 = cljs.core.deref(output_checker53981_55007);
var G__54010_55032 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54006_55028,G__54007_55029,G__54008_55030,G__54009_55031,G__54010_55032) : schema.core.fn_validator.call(null,G__54006_55028,G__54007_55029,G__54008_55030,G__54009_55031,G__54010_55032));
} else {
var temp__5804__auto___55035 = (function (){var fexpr__54013 = cljs.core.deref(output_checker53981_55007);
return (fexpr__54013.cljs$core$IFn$_invoke$arity$1 ? fexpr__54013.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__54013.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55035)){
var error__38226__auto___55038 = temp__5804__auto___55035;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55038], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53978_55003,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55038], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__53987,G__53988,G__53989){
var validate__38224__auto__ = cljs.core.deref(ufv___55002);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___55045 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53987,G__53988,G__53989], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54018_55046 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54019_55047 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54020_55048 = input_schema53984_55005;
var G__54021_55049 = cljs.core.deref(input_checker53985_55008);
var G__54022_55050 = args__38225__auto___55045;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54018_55046,G__54019_55047,G__54020_55048,G__54021_55049,G__54022_55050) : schema.core.fn_validator.call(null,G__54018_55046,G__54019_55047,G__54020_55048,G__54021_55049,G__54022_55050));
} else {
var temp__5804__auto___55051 = (function (){var fexpr__54026 = cljs.core.deref(input_checker53985_55008);
return (fexpr__54026.cljs$core$IFn$_invoke$arity$1 ? fexpr__54026.cljs$core$IFn$_invoke$arity$1(args__38225__auto___55045) : fexpr__54026.call(null,args__38225__auto___55045));
})();
if(cljs.core.truth_(temp__5804__auto___55051)){
var error__38226__auto___55052 = temp__5804__auto___55051;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55052], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53984_55005,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___55045,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55052], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__53987;
var path = G__53988;
var G__54029 = G__53989;
var map__54030 = G__54029;
var map__54030__$1 = cljs.core.__destructure_map(map__54030);
var opts = map__54030__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54030__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__54029__$1 = G__54029;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__54032 = G__54029__$1;
var map__54032__$1 = cljs.core.__destructure_map(map__54032);
var opts__$1 = map__54032__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54032__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54038_55062 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54039_55063 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54040_55064 = output_schema53978_55003;
var G__54041_55065 = cljs.core.deref(output_checker53986_55009);
var G__54042_55066 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54038_55062,G__54039_55063,G__54040_55064,G__54041_55065,G__54042_55066) : schema.core.fn_validator.call(null,G__54038_55062,G__54039_55063,G__54040_55064,G__54041_55065,G__54042_55066));
} else {
var temp__5804__auto___55069 = (function (){var fexpr__54043 = cljs.core.deref(output_checker53986_55009);
return (fexpr__54043.cljs$core$IFn$_invoke$arity$1 ? fexpr__54043.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__54043.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55069)){
var error__38226__auto___55071 = temp__5804__auto___55069;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55071], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53978_55003,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55071], null));
} else {
}
}
} else {
}

return o__38227__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema53978_55003,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53979_55004,input_schema53984_55005], null)));

var ufv___55078 = schema.utils.use_fn_validation;
var output_schema54048_55079 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema54049_55080 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54050_55081 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54049_55080);
}),null));
var output_checker54051_55082 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54048_55079);
}),null));
var ret__40667__auto___55083 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__54052){
var validate__38224__auto__ = cljs.core.deref(ufv___55078);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___55084 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54052], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54057_55085 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54058_55086 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__54059_55087 = input_schema54049_55080;
var G__54060_55088 = cljs.core.deref(input_checker54050_55081);
var G__54061_55089 = args__38225__auto___55084;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54057_55085,G__54058_55086,G__54059_55087,G__54060_55088,G__54061_55089) : schema.core.fn_validator.call(null,G__54057_55085,G__54058_55086,G__54059_55087,G__54060_55088,G__54061_55089));
} else {
var temp__5804__auto___55091 = (function (){var fexpr__54063 = cljs.core.deref(input_checker54050_55081);
return (fexpr__54063.cljs$core$IFn$_invoke$arity$1 ? fexpr__54063.cljs$core$IFn$_invoke$arity$1(args__38225__auto___55084) : fexpr__54063.call(null,args__38225__auto___55084));
})();
if(cljs.core.truth_(temp__5804__auto___55091)){
var error__38226__auto___55092 = temp__5804__auto___55091;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55092], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54049_55080,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___55084,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55092], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var union_schema = G__54052;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54066_55096 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54067_55097 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__54068_55098 = output_schema54048_55079;
var G__54069_55099 = cljs.core.deref(output_checker54051_55082);
var G__54070_55100 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54066_55096,G__54067_55097,G__54068_55098,G__54069_55099,G__54070_55100) : schema.core.fn_validator.call(null,G__54066_55096,G__54067_55097,G__54068_55098,G__54069_55099,G__54070_55100));
} else {
var temp__5804__auto___55104 = (function (){var fexpr__54071 = cljs.core.deref(output_checker54051_55082);
return (fexpr__54071.cljs$core$IFn$_invoke$arity$1 ? fexpr__54071.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__54071.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55104)){
var error__38226__auto___55105 = temp__5804__auto___55104;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55105], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54048_55079,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55105], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema54048_55079,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54049_55080], null)));

var ufv___55106 = schema.utils.use_fn_validation;
var output_schema54072_55107 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54073_55108 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54074_55109 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54073_55108);
}),null));
var output_checker54075_55110 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54072_55107);
}),null));
var ret__40667__auto___55111 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__54076,G__54077){
var validate__38224__auto__ = cljs.core.deref(ufv___55106);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___55117 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54076,G__54077], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54078_55118 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54079_55119 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__54080_55120 = input_schema54073_55108;
var G__54081_55121 = cljs.core.deref(input_checker54074_55109);
var G__54082_55122 = args__38225__auto___55117;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54078_55118,G__54079_55119,G__54080_55120,G__54081_55121,G__54082_55122) : schema.core.fn_validator.call(null,G__54078_55118,G__54079_55119,G__54080_55120,G__54081_55121,G__54082_55122));
} else {
var temp__5804__auto___55129 = (function (){var fexpr__54084 = cljs.core.deref(input_checker54074_55109);
return (fexpr__54084.cljs$core$IFn$_invoke$arity$1 ? fexpr__54084.cljs$core$IFn$_invoke$arity$1(args__38225__auto___55117) : fexpr__54084.call(null,args__38225__auto___55117));
})();
if(cljs.core.truth_(temp__5804__auto___55129)){
var error__38226__auto___55131 = temp__5804__auto___55129;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55131], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54073_55108,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___55117,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55131], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var union_schema = G__54076;
var branch_index = G__54077;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54086_55134 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54087_55135 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__54088_55136 = output_schema54072_55107;
var G__54089_55137 = cljs.core.deref(output_checker54075_55110);
var G__54090_55138 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54086_55134,G__54087_55135,G__54088_55136,G__54089_55137,G__54090_55138) : schema.core.fn_validator.call(null,G__54086_55134,G__54087_55135,G__54088_55136,G__54089_55137,G__54090_55138));
} else {
var temp__5804__auto___55140 = (function (){var fexpr__54091 = cljs.core.deref(output_checker54075_55110);
return (fexpr__54091.cljs$core$IFn$_invoke$arity$1 ? fexpr__54091.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__54091.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55140)){
var error__38226__auto___55144 = temp__5804__auto___55140;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55144], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54072_55107,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55144], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema54072_55107,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54073_55108], null)));

var ufv___55151 = schema.utils.use_fn_validation;
var output_schema54092_55153 = schema.core.Keyword;
var input_schema54093_55154 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54094_55155 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54093_55154);
}),null));
var output_checker54095_55156 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54092_55153);
}),null));
var ret__40667__auto___55157 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__54096){
var validate__38224__auto__ = cljs.core.deref(ufv___55151);
if(cljs.core.truth_(validate__38224__auto__)){
var args__38225__auto___55158 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54096], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54099_55159 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54100_55160 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__54101_55161 = input_schema54093_55154;
var G__54102_55162 = cljs.core.deref(input_checker54094_55155);
var G__54103_55163 = args__38225__auto___55158;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54099_55159,G__54100_55160,G__54101_55161,G__54102_55162,G__54103_55163) : schema.core.fn_validator.call(null,G__54099_55159,G__54100_55160,G__54101_55161,G__54102_55162,G__54103_55163));
} else {
var temp__5804__auto___55164 = (function (){var fexpr__54105 = cljs.core.deref(input_checker54094_55155);
return (fexpr__54105.cljs$core$IFn$_invoke$arity$1 ? fexpr__54105.cljs$core$IFn$_invoke$arity$1(args__38225__auto___55158) : fexpr__54105.call(null,args__38225__auto___55158));
})();
if(cljs.core.truth_(temp__5804__auto___55164)){
var error__38226__auto___55166 = temp__5804__auto___55164;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55166], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54093_55154,new cljs.core.Keyword(null,"value","value",305978217),args__38225__auto___55158,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55166], null));
} else {
}
}
} else {
}

var o__38227__auto__ = (function (){var schema__$1 = G__54096;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__38224__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54108_55169 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54109_55170 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__54110_55171 = output_schema54092_55153;
var G__54111_55172 = cljs.core.deref(output_checker54095_55156);
var G__54112_55173 = o__38227__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54108_55169,G__54109_55170,G__54110_55171,G__54111_55172,G__54112_55173) : schema.core.fn_validator.call(null,G__54108_55169,G__54109_55170,G__54110_55171,G__54111_55172,G__54112_55173));
} else {
var temp__5804__auto___55178 = (function (){var fexpr__54113 = cljs.core.deref(output_checker54095_55156);
return (fexpr__54113.cljs$core$IFn$_invoke$arity$1 ? fexpr__54113.cljs$core$IFn$_invoke$arity$1(o__38227__auto__) : fexpr__54113.call(null,o__38227__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55178)){
var error__38226__auto___55179 = temp__5804__auto___55178;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38226__auto___55179], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54092_55153,new cljs.core.Keyword(null,"value","value",305978217),o__38227__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38226__auto___55179], null));
} else {
}
}
} else {
}

return o__38227__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema54092_55153,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54093_55154], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
