goog.provide('com.deercreeklabs.talk2.utils');
goog.scope(function(){
  com.deercreeklabs.talk2.utils.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
com.deercreeklabs.talk2.utils.max_ws_payload_len = (2147483647);
com.deercreeklabs.talk2.utils.ws_key_constant = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
com.deercreeklabs.talk2.utils.four_zeros_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0)], null));
com.deercreeklabs.talk2.utils.pprint = (function com$deercreeklabs$talk2$utils$pprint(x){
return cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(x);
});
com.deercreeklabs.talk2.utils.pprint_str = (function com$deercreeklabs$talk2$utils$pprint_str(x){
var sb__4795__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__48473_48547 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__48474_48548 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__48475_48549 = true;
var _STAR_print_fn_STAR__temp_val__48476_48550 = (function (x__4796__auto__){
return sb__4795__auto__.append(x__4796__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__48475_48549);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__48476_48550);

try{cljs.pprint.pprint.cljs$core$IFn$_invoke$arity$1(x);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__48474_48548);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__48473_48547);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4795__auto__);
});
com.deercreeklabs.talk2.utils.int_pow = (function com$deercreeklabs$talk2$utils$int_pow(base,exp){
return (Math.pow(base,exp) | (0));
});
com.deercreeklabs.talk2.utils.str__GT_int = (function com$deercreeklabs$talk2$utils$str__GT_int(s){
if(cljs.core.seq(s)){
return parseInt(s,(10));
} else {
return null;
}
});
com.deercreeklabs.talk2.utils.ex_msg = (function com$deercreeklabs$talk2$utils$ex_msg(e){
var obj48479 = e;
if((!((obj48479 == null)))){
return (obj48479["message"]);
} else {
return undefined;
}
});
com.deercreeklabs.talk2.utils.ex_stacktrace = (function com$deercreeklabs$talk2$utils$ex_stacktrace(e){
var obj48481 = e;
if((!((obj48481 == null)))){
return (obj48481["stack"]);
} else {
return undefined;
}
});
com.deercreeklabs.talk2.utils.ex_msg_and_stacktrace = (function com$deercreeklabs$talk2$utils$ex_msg_and_stacktrace(e){
var data = cljs.core.ex_data(e);
var lines = (function (){var G__48482 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["\nException:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.deercreeklabs.talk2.utils.ex_msg(e))].join('')], null);
var G__48482__$1 = (cljs.core.truth_(data)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__48482,["\nex-data:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data(e))].join('')):G__48482);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__48482__$1,["\nStacktrace:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.deercreeklabs.talk2.utils.ex_stacktrace(e))].join(''));

})();
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",lines);
});
com.deercreeklabs.talk2.utils.current_time_ms = (function com$deercreeklabs$talk2$utils$current_time_ms(){
return (new Date()).getTime();
});
com.deercreeklabs.talk2.utils.round_int = (function com$deercreeklabs$talk2$utils$round_int(n){
return (Math.round(n) | (0));
});
com.deercreeklabs.talk2.utils.floor_int = (function com$deercreeklabs$talk2$utils$floor_int(n){
return (Math.floor(n) | (0));
});
com.deercreeklabs.talk2.utils.jvm_QMARK_ = (function com$deercreeklabs$talk2$utils$jvm_QMARK_(){
return false;
});
com.deercreeklabs.talk2.utils.browser_QMARK_ = (function com$deercreeklabs$talk2$utils$browser_QMARK_(){
return (typeof navigator !== 'undefined');
});
com.deercreeklabs.talk2.utils.node_QMARK_ = (function com$deercreeklabs$talk2$utils$node_QMARK_(){
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("nodejs",cljs.core._STAR_target_STAR_));
});
com.deercreeklabs.talk2.utils.secure_random_byte_array = (function com$deercreeklabs$talk2$utils$secure_random_byte_array(num_bytes){
if(com.deercreeklabs.talk2.utils.node_QMARK_()){
var crypto = require("crypto");
return (new Int8Array((function (){var obj__33952__auto__ = crypto;
var f__33953__auto__ = (obj__33952__auto__["randomBytes"]);
return f__33953__auto__.call(obj__33952__auto__,num_bytes);
})()));
} else {
if(com.deercreeklabs.talk2.utils.browser_QMARK_()){
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num_bytes);
var parent__33959__auto___48569 = (window["crypto"]);
var f__33960__auto___48570 = (parent__33959__auto___48569["getRandomValues"]);
f__33960__auto___48570.call(parent__33959__auto___48569,ba);

return ba;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unsupported environment",cljs.core.PersistentArrayMap.EMPTY);

}
}
});
com.deercreeklabs.talk2.utils.random_byte_array = (function com$deercreeklabs$talk2$utils$random_byte_array(num_bytes){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (i){
return cljs.core.rand_int((255));
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(num_bytes)));
});
com.deercreeklabs.talk2.utils.ws_key__GT_ws_accept_key = (function com$deercreeklabs$talk2$utils$ws_key__GT_ws_accept_key(ws_key){
return deercreeklabs.baracus.byte_array__GT_b64(deercreeklabs.baracus.sha1(deercreeklabs.baracus.utf8__GT_byte_array([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ws_key),com.deercreeklabs.talk2.utils.ws_key_constant].join(''))));
});
com.deercreeklabs.talk2.utils.code__GT_byte_array = (function com$deercreeklabs$talk2$utils$code__GT_byte_array(code){
var hi = ((code >>> (8)) & (255));
var lo = (code & (255));
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hi,lo], null));
});
com.deercreeklabs.talk2.utils.byte_array__GT_code = (function com$deercreeklabs$talk2$utils$byte_array__GT_code(ba){
var hi = (ba[(0)]);
var lo = (ba[(1)]);
return ((((255) & hi) << (8)) | ((255) & lo));
});
com.deercreeklabs.talk2.utils.add_header = (function com$deercreeklabs$talk2$utils$add_header(headers,line){
var vec__48488 = clojure.string.split.cljs$core$IFn$_invoke$arity$3(line,/:/,(2));
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48488,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48488,(1),null);
var kw_k = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.lower_case(clojure.string.trim(k)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(headers,kw_k,(function (existing_v){
var trimmed_v = clojure.string.trim(v);
if(cljs.core.empty_QMARK_(existing_v)){
return trimmed_v;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(existing_v),", ",trimmed_v].join('');
}
}));
});
com.deercreeklabs.talk2.utils.byte_array__GT_http_info = (function com$deercreeklabs$talk2$utils$byte_array__GT_http_info(ba){
var bv = cljs.core.vec(ba);
var len = cljs.core.count(bv);
var i = (0);
var complete_QMARK_ = false;
var headers = cljs.core.PersistentArrayMap.EMPTY;
var first_line = null;
var unprocessed_bytes = cljs.core.PersistentVector.EMPTY;
while(true){
if((i >= len)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"complete?","complete?",-892991879),complete_QMARK_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"first-line","first-line",285094849),first_line,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(unprocessed_bytes)], null);
} else {
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(bv,i);
var ni = (i + (1));
var nb = (((ni < len))?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(bv,ni):null);
var eol_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((13),b)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((10),nb)));
var new_unprocessed_bytes = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(unprocessed_bytes,b);
var line = (cljs.core.truth_(complete_QMARK_)?null:clojure.string.trim(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.char$,unprocessed_bytes))));
if((!(eol_QMARK_))){
var G__48616 = ni;
var G__48617 = complete_QMARK_;
var G__48618 = headers;
var G__48619 = first_line;
var G__48620 = new_unprocessed_bytes;
i = G__48616;
complete_QMARK_ = G__48617;
headers = G__48618;
first_line = G__48619;
unprocessed_bytes = G__48620;
continue;
} else {
if(cljs.core.not(first_line)){
var G__48621 = (ni + (1));
var G__48622 = complete_QMARK_;
var G__48623 = headers;
var G__48624 = line;
var G__48625 = cljs.core.PersistentVector.EMPTY;
i = G__48621;
complete_QMARK_ = G__48622;
headers = G__48623;
first_line = G__48624;
unprocessed_bytes = G__48625;
continue;
} else {
if(cljs.core.seq(line)){
var new_headers = com.deercreeklabs.talk2.utils.add_header(headers,line);
var G__48627 = (ni + (1));
var G__48628 = complete_QMARK_;
var G__48629 = new_headers;
var G__48630 = first_line;
var G__48631 = cljs.core.PersistentVector.EMPTY;
i = G__48627;
complete_QMARK_ = G__48628;
headers = G__48629;
first_line = G__48630;
unprocessed_bytes = G__48631;
continue;
} else {
var G__48633 = (ni + (1));
var G__48634 = true;
var G__48635 = headers;
var G__48636 = first_line;
var G__48637 = cljs.core.PersistentVector.EMPTY;
i = G__48633;
complete_QMARK_ = G__48634;
headers = G__48635;
first_line = G__48636;
unprocessed_bytes = G__48637;
continue;

}
}
}
}
break;
}
});
/**
 * Mutates the ba arg in place to avoid allocation costs, which are significant
 * with large payloads.
 */
com.deercreeklabs.talk2.utils.mask_ws_payload_BANG_ = (function com$deercreeklabs$talk2$utils$mask_ws_payload_BANG_(key_ba,ba){
var n__4741__auto__ = cljs.core.count(ba);
var i = (0);
while(true){
if((i < n__4741__auto__)){
(ba[i] = ((key_ba[cljs.core.rem(i,(4))]) ^ (ba[i])));

var G__48648 = (i + (1));
i = G__48648;
continue;
} else {
return null;
}
break;
}
});
com.deercreeklabs.talk2.utils.throw_too_large_payload = (function com$deercreeklabs$talk2$utils$throw_too_large_payload(payload_len){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Payload too large (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(payload_len)," bytes). ","Max payload size is ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.deercreeklabs.talk2.utils.max_ws_payload_len)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"payload-len","payload-len",425828640),payload_len,new cljs.core.Keyword(null,"max-ws-payload-len","max-ws-payload-len",-947019636),com.deercreeklabs.talk2.utils.max_ws_payload_len], null));
});
com.deercreeklabs.talk2.utils.byte_array__GT_int = (function com$deercreeklabs$talk2$utils$byte_array__GT_int(ba){
var n = cljs.core.count(ba);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,i){
return ((((ba[i]) & (255)) << ((8) * ((n - (1)) - i))) | acc);
}),(0),cljs.core.range.cljs$core$IFn$_invoke$arity$1(n));
});
com.deercreeklabs.talk2.utils.int__GT_byte_array = (function com$deercreeklabs$talk2$utils$int__GT_byte_array(x){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,i){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,((x >>> ((8) * ((3) - i))) & (255)));
}),cljs.core.PersistentVector.EMPTY,cljs.core.range.cljs$core$IFn$_invoke$arity$1((4))));
});
/**
 * https://datatracker.ietf.org/doc/html/rfc6455#section-5.2
 */
com.deercreeklabs.talk2.utils.frame_header_map__GT_byte_array = (function com$deercreeklabs$talk2$utils$frame_header_map__GT_byte_array(p__48497){
var map__48498 = p__48497;
var map__48498__$1 = cljs.core.__destructure_map(map__48498);
var fin_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48498__$1,new cljs.core.Keyword(null,"fin?","fin?",-288046239));
var masking_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48498__$1,new cljs.core.Keyword(null,"masking-key","masking-key",574922792));
var opcode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48498__$1,new cljs.core.Keyword(null,"opcode","opcode",-1329442167));
var payload_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48498__$1,new cljs.core.Keyword(null,"payload-len","payload-len",425828640));
if(cljs.core.truth_((function (){var fexpr__48499 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [(0),null,(1),null,(2),null,(9),null,(10),null,(8),null], null), null);
return (fexpr__48499.cljs$core$IFn$_invoke$arity$1 ? fexpr__48499.cljs$core$IFn$_invoke$arity$1(opcode) : fexpr__48499.call(null,opcode));
})())){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid opcode: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(opcode),"."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode], null));
}

var vec__48500 = (((payload_len <= (125)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [payload_len,null], null):(((payload_len <= (65535)))?(function (){var hb = (((65280) & payload_len) >>> (8));
var lb = ((255) & payload_len);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(126),deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hb,lb], null))], null);
})():(((payload_len <= com.deercreeklabs.talk2.utils.max_ws_payload_len))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(127),deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.deercreeklabs.talk2.utils.four_zeros_ba,com.deercreeklabs.talk2.utils.int__GT_byte_array(payload_len)], null))], null):com.deercreeklabs.talk2.utils.throw_too_large_payload(payload_len)
)));
var l0 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48500,(0),null);
var l1_ba = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48500,(1),null);
var b0 = ((cljs.core.truth_(fin_QMARK_)?(128):(0)) | opcode);
var b1 = ((cljs.core.truth_(masking_key)?(128):(0)) | l0);
return deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [b0,b1], null)),l1_ba,masking_key], null));
});
com.deercreeklabs.talk2.utils.frame_info__GT_byte_array = (function com$deercreeklabs$talk2$utils$frame_info__GT_byte_array(m){
var map__48504 = m;
var map__48504__$1 = cljs.core.__destructure_map(map__48504);
var payload_ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48504__$1,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459));
var masking_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48504__$1,new cljs.core.Keyword(null,"masking-key","masking-key",574922792));
var header_ba = com.deercreeklabs.talk2.utils.frame_header_map__GT_byte_array(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"payload-len","payload-len",425828640),cljs.core.count(payload_ba)));
var payload_ba_STAR_ = ((cljs.core.not(payload_ba))?null:((cljs.core.not(masking_key))?payload_ba:(function (){
com.deercreeklabs.talk2.utils.mask_ws_payload_BANG_(masking_key,payload_ba);

return payload_ba;
})()

));
return deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [header_ba,payload_ba_STAR_], null));
});
com.deercreeklabs.talk2.utils.get_payload_start = (function com$deercreeklabs$talk2$utils$get_payload_start(masked_QMARK_,short_payload_len){
var G__48508 = (function (){var G__48509 = short_payload_len;
switch (G__48509) {
case (126):
return (4);

break;
case (127):
return (10);

break;
default:
return (2);

}
})();
if(cljs.core.truth_(masked_QMARK_)){
return (G__48508 + (4));
} else {
return G__48508;
}
});
com.deercreeklabs.talk2.utils.get_long_payload_len = (function com$deercreeklabs$talk2$utils$get_long_payload_len(ba,short_payload_len){
var G__48510 = short_payload_len;
switch (G__48510) {
case (126):
return com.deercreeklabs.talk2.utils.byte_array__GT_int(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(2),(4)));

break;
case (127):
if(((((ba[(2)]) === (0))) && (((((ba[(3)]) === (0))) && (((((ba[(4)]) === (0))) && (((ba[(5)]) === (0))))))))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Payload length is greater than ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(com.deercreeklabs.talk2.utils.max_ws_payload_len),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"max-ws-payload-len","max-ws-payload-len",-947019636),com.deercreeklabs.talk2.utils.max_ws_payload_len], null));
}

return com.deercreeklabs.talk2.utils.byte_array__GT_int(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(6),(10)));

break;
default:
return short_payload_len;

}
});
com.deercreeklabs.talk2.utils.byte_array__GT_frame_header_map = (function com$deercreeklabs$talk2$utils$byte_array__GT_frame_header_map(ba){

new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ba], null);

var ba_len = cljs.core.count(ba);
if((ba_len < (2))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224),false,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba], null);
} else {
var b0 = (ba[(0)]);
var b1 = (ba[(1)]);
var fin_QMARK_ = ((b0 & (1 << (7))) != 0);
var opcode = (b0 & (15));
var masked_QMARK_ = ((b1 & (1 << (7))) != 0);
var short_payload_len = (b1 & (127));
var payload_start = com.deercreeklabs.talk2.utils.get_payload_start(masked_QMARK_,short_payload_len);
if((ba_len < payload_start)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224),false,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),false,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba], null);
} else {
var payload_len = com.deercreeklabs.talk2.utils.get_long_payload_len(ba,short_payload_len);
var _ = (((payload_len > com.deercreeklabs.talk2.utils.max_ws_payload_len))?com.deercreeklabs.talk2.utils.throw_too_large_payload(payload_len):null);
var payload_end = (payload_start + payload_len);
var masking_key_start = (payload_start - (4));
var masking_key = ((masked_QMARK_)?deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,masking_key_start,payload_start):null);
var complete_header_QMARK_ = true;
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224),complete_header_QMARK_,new cljs.core.Keyword(null,"fin?","fin?",-288046239),fin_QMARK_,new cljs.core.Keyword(null,"masking-key","masking-key",574922792),masking_key,new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode,new cljs.core.Keyword(null,"payload-end","payload-end",-1127661697),payload_end,new cljs.core.Keyword(null,"payload-len","payload-len",425828640),payload_len,new cljs.core.Keyword(null,"payload-start","payload-start",536273380),payload_start], null);
}
}
});
com.deercreeklabs.talk2.utils.byte_array__GT_frame_info = (function com$deercreeklabs$talk2$utils$byte_array__GT_frame_info(ba){
var ba_len = cljs.core.count(ba);
var header_map = com.deercreeklabs.talk2.utils.byte_array__GT_frame_header_map(ba);
var map__48513 = header_map;
var map__48513__$1 = cljs.core.__destructure_map(map__48513);
var complete_header_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48513__$1,new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224));
var masking_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48513__$1,new cljs.core.Keyword(null,"masking-key","masking-key",574922792));
var payload_start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48513__$1,new cljs.core.Keyword(null,"payload-start","payload-start",536273380));
var payload_end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48513__$1,new cljs.core.Keyword(null,"payload-end","payload-end",-1127661697));
var m = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(header_map,new cljs.core.Keyword(null,"payload-len","payload-len",425828640),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"payload-start","payload-start",536273380),new cljs.core.Keyword(null,"payload-end","payload-end",-1127661697)], 0));
if(cljs.core.not(complete_header_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),false),new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba);
} else {
if((ba_len < payload_end)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),false),new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,payload_start));
} else {
var payload = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,payload_start,payload_end);
if(cljs.core.truth_(masking_key)){
com.deercreeklabs.talk2.utils.mask_ws_payload_BANG_(masking_key,payload);
} else {
}

var G__48516 = m;
var G__48516__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__48516,new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199),true)
;
var G__48516__$2 = (((cljs.core.count(payload) > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__48516__$1,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459),payload):G__48516__$1);
if((ba_len > payload_end)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__48516__$2,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,payload_end));
} else {
return G__48516__$2;
}

}
}
});
com.deercreeklabs.talk2.utils.process_frame_BANG_ = (function com$deercreeklabs$talk2$utils$process_frame_BANG_(p__48519){
var map__48520 = p__48519;
var map__48520__$1 = cljs.core.__destructure_map(map__48520);
var continuation_ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213));
var continuation_opcode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569));
var frame_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"frame-info","frame-info",-421931612));
var on_close_frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"on-close-frame","on-close-frame",1915345661));
var on_message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"on-message","on-message",1662987808));
var on_ping = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"on-ping","on-ping",528317767));
var on_pong = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48520__$1,new cljs.core.Keyword(null,"on-pong","on-pong",-1183742032));
var map__48527 = frame_info;
var map__48527__$1 = cljs.core.__destructure_map(map__48527);
var fin_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48527__$1,new cljs.core.Keyword(null,"fin?","fin?",-288046239));
var opcode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48527__$1,new cljs.core.Keyword(null,"opcode","opcode",-1329442167));
var payload_ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48527__$1,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459));
var control_frame_QMARK_ = ((opcode & (1 << (7))) != 0);
var data_ba = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),opcode))?deercreeklabs.baracus.concat_byte_arrays(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [continuation_ba,payload_ba], null)):null);
try{var G__48530_48735 = (opcode | (0));
switch (G__48530_48735) {
case (0):
if(cljs.core.truth_(fin_QMARK_)){
var data_48740 = (function (){var G__48531 = data_ba;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),continuation_opcode)){
return deercreeklabs.baracus.byte_array__GT_utf8(G__48531);
} else {
return G__48531;
}
})();
var G__48532_48746 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data_48740], null);
(on_message.cljs$core$IFn$_invoke$arity$1 ? on_message.cljs$core$IFn$_invoke$arity$1(G__48532_48746) : on_message.call(null,G__48532_48746));
} else {
}

break;
case (1):
if(cljs.core.truth_(fin_QMARK_)){
var G__48535_48750 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),deercreeklabs.baracus.byte_array__GT_utf8(payload_ba)], null);
(on_message.cljs$core$IFn$_invoke$arity$1 ? on_message.cljs$core$IFn$_invoke$arity$1(G__48535_48750) : on_message.call(null,G__48535_48750));
} else {
}

break;
case (2):
if(cljs.core.truth_(fin_QMARK_)){
var G__48536_48753 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),payload_ba], null);
(on_message.cljs$core$IFn$_invoke$arity$1 ? on_message.cljs$core$IFn$_invoke$arity$1(G__48536_48753) : on_message.call(null,G__48536_48753));
} else {
}

break;
case (8):
(on_close_frame.cljs$core$IFn$_invoke$arity$0 ? on_close_frame.cljs$core$IFn$_invoke$arity$0() : on_close_frame.call(null));

break;
case (9):
var G__48537_48756 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),payload_ba], null);
(on_ping.cljs$core$IFn$_invoke$arity$1 ? on_ping.cljs$core$IFn$_invoke$arity$1(G__48537_48756) : on_ping.call(null,G__48537_48756));

break;
case (10):
var G__48538_48758 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),payload_ba], null);
(on_pong.cljs$core$IFn$_invoke$arity$1 ? on_pong.cljs$core$IFn$_invoke$arity$1(G__48538_48758) : on_pong.call(null,G__48538_48758));

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad opcode: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(opcode),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode], null));

}
}catch (e48529){if((e48529 instanceof Error)){
var e_48763 = e48529;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"com.deercreeklabs.talk2.utils",null,406,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Error while executing frame effects:\n",com.deercreeklabs.talk2.utils.ex_msg_and_stacktrace(e_48763)].join('')], null);
}),null)),null,-330069213,null);
} else {
throw e48529;

}
}
if(cljs.core.truth_((function (){var or__4253__auto__ = fin_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return control_frame_QMARK_;
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),null,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),null], null);
} else {
if(((opcode | (0)) === (0))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),data_ba,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),continuation_opcode], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),payload_ba,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),opcode], null);

}
}
});
com.deercreeklabs.talk2.utils.process_data_BANG_ = (function com$deercreeklabs$talk2$utils$process_data_BANG_(p__48539){
var map__48540 = p__48539;
var map__48540__$1 = cljs.core.__destructure_map(map__48540);
var arg = map__48540__$1;
var close_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48540__$1,new cljs.core.Keyword(null,"close!","close!",-2079310498));
var server_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48540__$1,new cljs.core.Keyword(null,"server?","server?",1803113525));
var ba = new cljs.core.Keyword(null,"ba","ba",-960950298).cljs$core$IFn$_invoke$arity$1(arg);
var continuation_ba = new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213).cljs$core$IFn$_invoke$arity$1(arg);
var continuation_opcode = new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569).cljs$core$IFn$_invoke$arity$1(arg);
while(true){
var frame_info = com.deercreeklabs.talk2.utils.byte_array__GT_frame_info(ba);
if(cljs.core.not((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"complete-header?","complete-header?",1700680224).cljs$core$IFn$_invoke$arity$1(frame_info);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"complete-payload?","complete-payload?",-1024509199).cljs$core$IFn$_invoke$arity$1(frame_info);
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),continuation_ba,new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),continuation_opcode,new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172),ba], null);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = server_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(new cljs.core.Keyword(null,"masking-key","masking-key",574922792).cljs$core$IFn$_invoke$arity$1(frame_info));
} else {
return and__4251__auto__;
}
})())){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"com.deercreeklabs.talk2.utils",null,436,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (ba,continuation_ba,continuation_opcode,frame_info,map__48540,map__48540__$1,arg,close_BANG_,server_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Got frame without required masking key. Closing connection."], null);
});})(ba,continuation_ba,continuation_opcode,frame_info,map__48540,map__48540__$1,arg,close_BANG_,server_QMARK_))
,null)),null,850882457,null);

return (close_BANG_.cljs$core$IFn$_invoke$arity$0 ? close_BANG_.cljs$core$IFn$_invoke$arity$0() : close_BANG_.call(null));
} else {
var ret = com.deercreeklabs.talk2.utils.process_frame_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arg,new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213),continuation_ba,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569),continuation_opcode,new cljs.core.Keyword(null,"frame-info","frame-info",-421931612),frame_info], 0)));
var G__48783 = new cljs.core.Keyword(null,"unprocessed-ba","unprocessed-ba",110332172).cljs$core$IFn$_invoke$arity$1(frame_info);
var G__48784 = new cljs.core.Keyword(null,"continuation-ba","continuation-ba",-1838975213).cljs$core$IFn$_invoke$arity$1(ret);
var G__48785 = new cljs.core.Keyword(null,"continuation-opcode","continuation-opcode",381530569).cljs$core$IFn$_invoke$arity$1(ret);
ba = G__48783;
continuation_ba = G__48784;
continuation_opcode = G__48785;
continue;

}
}
break;
}
});
com.deercreeklabs.talk2.utils.data__GT_frame_byte_arrays = (function com$deercreeklabs$talk2$utils$data__GT_frame_byte_arrays(msg_type,data,mask_QMARK_,max_payload_len){
var ba = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),msg_type))?deercreeklabs.baracus.utf8__GT_byte_array(data):data);
var payload_bas = (function (){var or__4253__auto__ = deercreeklabs.baracus.byte_array__GT_fragments(ba,max_payload_len);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null);
}
})();
var last_i = ((cljs.core.count(payload_bas) - (1)) | (0));
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,payload_ba){
var fin_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((i | (0)),last_i);
var masking_key = (cljs.core.truth_(mask_QMARK_)?com.deercreeklabs.talk2.utils.secure_random_byte_array((4)):null);
var opcode = (((i > (0)))?(0):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),msg_type))?(1):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"binary","binary",-1802232288),msg_type))?(2):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"close","close",1835149582),msg_type))?(8):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ping","ping",-1670114784),msg_type))?(9):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"pong","pong",-172484958),msg_type))?(10):null))))));
var frame_info = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"fin?","fin?",-288046239),fin_QMARK_,new cljs.core.Keyword(null,"masking-key","masking-key",574922792),masking_key,new cljs.core.Keyword(null,"opcode","opcode",-1329442167),opcode,new cljs.core.Keyword(null,"payload-ba","payload-ba",-1054565459),payload_ba], null);
return com.deercreeklabs.talk2.utils.frame_info__GT_byte_array(frame_info);
}),payload_bas);
});
com.deercreeklabs.talk2.utils.get_msg_type = (function com$deercreeklabs$talk2$utils$get_msg_type(data){
if(typeof data === 'string'){
return new cljs.core.Keyword(null,"text","text",-1790561697);
} else {
if(cljs.core.truth_(deercreeklabs.baracus.byte_array_QMARK_(data))){
return new cljs.core.Keyword(null,"binary","binary",-1802232288);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad data type passed to `send!`. ","Data must be a string or byte array."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null));

}
}
});

//# sourceMappingURL=com.deercreeklabs.talk2.utils.js.map
