goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___40760 = schema.utils.use_fn_validation;
var output_schema40280_40761 = schema.core.Bool;
var input_schema40281_40762 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker40282_40763 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40281_40762);
}),null));
var output_checker40283_40764 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40280_40761);
}),null));
var ret__38856__auto___40766 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__40284){
var validate__36731__auto__ = cljs.core.deref(ufv___40760);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40767 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40284], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40290_40768 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40291_40769 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__40292_40770 = input_schema40281_40762;
var G__40293_40771 = cljs.core.deref(input_checker40282_40763);
var G__40294_40772 = args__36732__auto___40767;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40290_40768,G__40291_40769,G__40292_40770,G__40293_40771,G__40294_40772) : schema.core.fn_validator.call(null,G__40290_40768,G__40291_40769,G__40292_40770,G__40293_40771,G__40294_40772));
} else {
var temp__5804__auto___40773 = (function (){var fexpr__40296 = cljs.core.deref(input_checker40282_40763);
return (fexpr__40296.cljs$core$IFn$_invoke$arity$1 ? fexpr__40296.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40767) : fexpr__40296.call(null,args__36732__auto___40767));
})();
if(cljs.core.truth_(temp__5804__auto___40773)){
var error__36733__auto___40774 = temp__5804__auto___40773;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40774], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40281_40762,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40767,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40774], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var arg = G__40284;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40297_40776 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40298_40777 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__40299_40778 = output_schema40280_40761;
var G__40300_40779 = cljs.core.deref(output_checker40283_40764);
var G__40301_40780 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40297_40776,G__40298_40777,G__40299_40778,G__40300_40779,G__40301_40780) : schema.core.fn_validator.call(null,G__40297_40776,G__40298_40777,G__40299_40778,G__40300_40779,G__40301_40780));
} else {
var temp__5804__auto___40781 = (function (){var fexpr__40304 = cljs.core.deref(output_checker40283_40764);
return (fexpr__40304.cljs$core$IFn$_invoke$arity$1 ? fexpr__40304.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40304.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40781)){
var error__36733__auto___40782 = temp__5804__auto___40781;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40782], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40280_40761,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40782], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema40280_40761,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40281_40762], null)));

var ufv___40785 = schema.utils.use_fn_validation;
var output_schema40306_40786 = deercreeklabs.baracus.ByteArray;
var input_schema40308_40787 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema40312_40788 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker40309_40789 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40308_40787);
}),null));
var output_checker40310_40790 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40306_40786);
}),null));
var input_checker40313_40791 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40312_40788);
}),null));
var output_checker40314_40792 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40306_40786);
}),null));
var ret__38856__auto___40794 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__40323 = arguments.length;
switch (G__40323) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__40311){
var validate__36731__auto__ = cljs.core.deref(ufv___40785);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40797 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40311], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40325_40798 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40326_40799 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40327_40800 = input_schema40308_40787;
var G__40328_40801 = cljs.core.deref(input_checker40309_40789);
var G__40329_40802 = args__36732__auto___40797;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40325_40798,G__40326_40799,G__40327_40800,G__40328_40801,G__40329_40802) : schema.core.fn_validator.call(null,G__40325_40798,G__40326_40799,G__40327_40800,G__40328_40801,G__40329_40802));
} else {
var temp__5804__auto___40807 = (function (){var fexpr__40330 = cljs.core.deref(input_checker40309_40789);
return (fexpr__40330.cljs$core$IFn$_invoke$arity$1 ? fexpr__40330.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40797) : fexpr__40330.call(null,args__36732__auto___40797));
})();
if(cljs.core.truth_(temp__5804__auto___40807)){
var error__36733__auto___40809 = temp__5804__auto___40807;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40809], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40308_40787,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40797,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40809], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var size_or_seq = G__40311;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40331_40810 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40332_40811 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40333_40812 = output_schema40306_40786;
var G__40334_40813 = cljs.core.deref(output_checker40310_40790);
var G__40335_40814 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40331_40810,G__40332_40811,G__40333_40812,G__40334_40813,G__40335_40814) : schema.core.fn_validator.call(null,G__40331_40810,G__40332_40811,G__40333_40812,G__40334_40813,G__40335_40814));
} else {
var temp__5804__auto___40817 = (function (){var fexpr__40336 = cljs.core.deref(output_checker40310_40790);
return (fexpr__40336.cljs$core$IFn$_invoke$arity$1 ? fexpr__40336.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40336.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40817)){
var error__36733__auto___40820 = temp__5804__auto___40817;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40820], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40306_40786,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40820], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__40315,G__40316){
var validate__36731__auto__ = cljs.core.deref(ufv___40785);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40822 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40315,G__40316], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40337_40823 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40338_40824 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40339_40825 = input_schema40312_40788;
var G__40340_40826 = cljs.core.deref(input_checker40313_40791);
var G__40341_40827 = args__36732__auto___40822;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40337_40823,G__40338_40824,G__40339_40825,G__40340_40826,G__40341_40827) : schema.core.fn_validator.call(null,G__40337_40823,G__40338_40824,G__40339_40825,G__40340_40826,G__40341_40827));
} else {
var temp__5804__auto___40828 = (function (){var fexpr__40343 = cljs.core.deref(input_checker40313_40791);
return (fexpr__40343.cljs$core$IFn$_invoke$arity$1 ? fexpr__40343.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40822) : fexpr__40343.call(null,args__36732__auto___40822));
})();
if(cljs.core.truth_(temp__5804__auto___40828)){
var error__36733__auto___40829 = temp__5804__auto___40828;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40829], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40312_40788,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40822,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40829], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var size = G__40315;
var init_val_or_seq = G__40316;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40344_40832 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40345_40833 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__40346_40834 = output_schema40306_40786;
var G__40347_40835 = cljs.core.deref(output_checker40314_40792);
var G__40348_40836 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40344_40832,G__40345_40833,G__40346_40834,G__40347_40835,G__40348_40836) : schema.core.fn_validator.call(null,G__40344_40832,G__40345_40833,G__40346_40834,G__40347_40835,G__40348_40836));
} else {
var temp__5804__auto___40839 = (function (){var fexpr__40349 = cljs.core.deref(output_checker40314_40792);
return (fexpr__40349.cljs$core$IFn$_invoke$arity$1 ? fexpr__40349.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40349.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40839)){
var error__36733__auto___40840 = temp__5804__auto___40839;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40840], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40306_40786,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40840], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema40306_40786,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40308_40787,input_schema40312_40788], null)));

var ufv___40843 = schema.utils.use_fn_validation;
var output_schema40351_40844 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40352_40845 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker40353_40846 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40352_40845);
}),null));
var output_checker40354_40847 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40351_40844);
}),null));
var ret__38856__auto___40849 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__40355){
var validate__36731__auto__ = cljs.core.deref(ufv___40843);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40850 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40355], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40356_40851 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40357_40852 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__40358_40853 = input_schema40352_40845;
var G__40359_40854 = cljs.core.deref(input_checker40353_40846);
var G__40360_40855 = args__36732__auto___40850;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40356_40851,G__40357_40852,G__40358_40853,G__40359_40854,G__40360_40855) : schema.core.fn_validator.call(null,G__40356_40851,G__40357_40852,G__40358_40853,G__40359_40854,G__40360_40855));
} else {
var temp__5804__auto___40856 = (function (){var fexpr__40361 = cljs.core.deref(input_checker40353_40846);
return (fexpr__40361.cljs$core$IFn$_invoke$arity$1 ? fexpr__40361.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40850) : fexpr__40361.call(null,args__36732__auto___40850));
})();
if(cljs.core.truth_(temp__5804__auto___40856)){
var error__36733__auto___40859 = temp__5804__auto___40856;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40859], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40352_40845,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40850,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40859], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var arrays = G__40355;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__40375 = cljs.core.count(arrays__$1);
switch (G__40375) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__40375,arrays__$1,validate__36731__auto__,ufv___40843,output_schema40351_40844,input_schema40352_40845,input_checker40353_40846,output_checker40354_40847){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__40375,arrays__$1,validate__36731__auto__,ufv___40843,output_schema40351_40844,input_schema40352_40845,input_checker40353_40846,output_checker40354_40847))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__40375,arrays__$1,validate__36731__auto__,ufv___40843,output_schema40351_40844,input_schema40352_40845,input_checker40353_40846,output_checker40354_40847){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__40375,arrays__$1,validate__36731__auto__,ufv___40843,output_schema40351_40844,input_schema40352_40845,input_checker40353_40846,output_checker40354_40847))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40376_40867 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40377_40868 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__40378_40869 = output_schema40351_40844;
var G__40379_40870 = cljs.core.deref(output_checker40354_40847);
var G__40380_40871 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40376_40867,G__40377_40868,G__40378_40869,G__40379_40870,G__40380_40871) : schema.core.fn_validator.call(null,G__40376_40867,G__40377_40868,G__40378_40869,G__40379_40870,G__40380_40871));
} else {
var temp__5804__auto___40872 = (function (){var fexpr__40381 = cljs.core.deref(output_checker40354_40847);
return (fexpr__40381.cljs$core$IFn$_invoke$arity$1 ? fexpr__40381.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40381.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40872)){
var error__36733__auto___40875 = temp__5804__auto___40872;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40875], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40351_40844,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40875], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema40351_40844,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40352_40845], null)));

var ufv___40878 = schema.utils.use_fn_validation;
var output_schema40384_40879 = schema.core.Bool;
var input_schema40385_40880 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40386_40881 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40385_40880);
}),null));
var output_checker40387_40882 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40384_40879);
}),null));
var ret__38856__auto___40885 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__40388,G__40389){
var validate__36731__auto__ = cljs.core.deref(ufv___40878);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40888 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40388,G__40389], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40390_40889 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40391_40890 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__40392_40891 = input_schema40385_40880;
var G__40393_40892 = cljs.core.deref(input_checker40386_40881);
var G__40394_40893 = args__36732__auto___40888;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40390_40889,G__40391_40890,G__40392_40891,G__40393_40892,G__40394_40893) : schema.core.fn_validator.call(null,G__40390_40889,G__40391_40890,G__40392_40891,G__40393_40892,G__40394_40893));
} else {
var temp__5804__auto___40894 = (function (){var fexpr__40395 = cljs.core.deref(input_checker40386_40881);
return (fexpr__40395.cljs$core$IFn$_invoke$arity$1 ? fexpr__40395.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40888) : fexpr__40395.call(null,args__36732__auto___40888));
})();
if(cljs.core.truth_(temp__5804__auto___40894)){
var error__36733__auto___40895 = temp__5804__auto___40894;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40895], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40385_40880,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40888,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40895], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var a = G__40388;
var b = G__40389;
while(true){
var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__4251__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__40898 = ((i + (1)) | (0));
i = G__40898;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__4251__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40397_40899 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40398_40900 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__40399_40901 = output_schema40384_40879;
var G__40400_40902 = cljs.core.deref(output_checker40387_40882);
var G__40401_40903 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40397_40899,G__40398_40900,G__40399_40901,G__40400_40902,G__40401_40903) : schema.core.fn_validator.call(null,G__40397_40899,G__40398_40900,G__40399_40901,G__40400_40902,G__40401_40903));
} else {
var temp__5804__auto___40907 = (function (){var fexpr__40402 = cljs.core.deref(output_checker40387_40882);
return (fexpr__40402.cljs$core$IFn$_invoke$arity$1 ? fexpr__40402.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40402.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40907)){
var error__36733__auto___40908 = temp__5804__auto___40907;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40908], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40384_40879,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40908], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema40384_40879,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40385_40880], null)));

var ufv___40911 = schema.utils.use_fn_validation;
var output_schema40404_40912 = schema.core.Str;
var input_schema40405_40913 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40406_40914 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40405_40913);
}),null));
var output_checker40407_40915 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40404_40912);
}),null));
var ret__38856__auto___40916 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__40408){
var validate__36731__auto__ = cljs.core.deref(ufv___40911);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40918 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40408], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40409_40919 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40410_40920 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__40411_40921 = input_schema40405_40913;
var G__40412_40922 = cljs.core.deref(input_checker40406_40914);
var G__40413_40923 = args__36732__auto___40918;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40409_40919,G__40410_40920,G__40411_40921,G__40412_40922,G__40413_40923) : schema.core.fn_validator.call(null,G__40409_40919,G__40410_40920,G__40411_40921,G__40412_40922,G__40413_40923));
} else {
var temp__5804__auto___40924 = (function (){var fexpr__40415 = cljs.core.deref(input_checker40406_40914);
return (fexpr__40415.cljs$core$IFn$_invoke$arity$1 ? fexpr__40415.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40918) : fexpr__40415.call(null,args__36732__auto___40918));
})();
if(cljs.core.truth_(temp__5804__auto___40924)){
var error__36733__auto___40925 = temp__5804__auto___40924;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40925], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40405_40913,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40918,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40925], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40408;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40416_40929 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40417_40930 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__40418_40931 = output_schema40404_40912;
var G__40419_40932 = cljs.core.deref(output_checker40407_40915);
var G__40420_40933 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40416_40929,G__40417_40930,G__40418_40931,G__40419_40932,G__40420_40933) : schema.core.fn_validator.call(null,G__40416_40929,G__40417_40930,G__40418_40931,G__40419_40932,G__40420_40933));
} else {
var temp__5804__auto___40934 = (function (){var fexpr__40421 = cljs.core.deref(output_checker40407_40915);
return (fexpr__40421.cljs$core$IFn$_invoke$arity$1 ? fexpr__40421.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40421.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40934)){
var error__36733__auto___40935 = temp__5804__auto___40934;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40935], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40404_40912,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40935], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema40404_40912,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40405_40913], null)));

var ufv___40940 = schema.utils.use_fn_validation;
var output_schema40422_40941 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40423_40942 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema40427_40943 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema40432_40944 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker40424_40945 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40423_40942);
}),null));
var output_checker40425_40946 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40422_40941);
}),null));
var input_checker40428_40947 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40427_40943);
}),null));
var output_checker40429_40948 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40422_40941);
}),null));
var input_checker40433_40949 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40432_40944);
}),null));
var output_checker40434_40950 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40422_40941);
}),null));
var ret__38856__auto___40953 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__40445 = arguments.length;
switch (G__40445) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__40426){
var validate__36731__auto__ = cljs.core.deref(ufv___40940);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40959 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40426], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40447_40960 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40448_40961 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40449_40962 = input_schema40423_40942;
var G__40450_40963 = cljs.core.deref(input_checker40424_40945);
var G__40451_40964 = args__36732__auto___40959;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40447_40960,G__40448_40961,G__40449_40962,G__40450_40963,G__40451_40964) : schema.core.fn_validator.call(null,G__40447_40960,G__40448_40961,G__40449_40962,G__40450_40963,G__40451_40964));
} else {
var temp__5804__auto___40965 = (function (){var fexpr__40452 = cljs.core.deref(input_checker40424_40945);
return (fexpr__40452.cljs$core$IFn$_invoke$arity$1 ? fexpr__40452.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40959) : fexpr__40452.call(null,args__36732__auto___40959));
})();
if(cljs.core.truth_(temp__5804__auto___40965)){
var error__36733__auto___40966 = temp__5804__auto___40965;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40966], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40423_40942,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40959,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40966], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40426;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40454_40972 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40455_40973 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40456_40974 = output_schema40422_40941;
var G__40457_40975 = cljs.core.deref(output_checker40425_40946);
var G__40458_40976 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40454_40972,G__40455_40973,G__40456_40974,G__40457_40975,G__40458_40976) : schema.core.fn_validator.call(null,G__40454_40972,G__40455_40973,G__40456_40974,G__40457_40975,G__40458_40976));
} else {
var temp__5804__auto___40978 = (function (){var fexpr__40459 = cljs.core.deref(output_checker40425_40946);
return (fexpr__40459.cljs$core$IFn$_invoke$arity$1 ? fexpr__40459.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40459.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___40978)){
var error__36733__auto___40979 = temp__5804__auto___40978;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40979], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40422_40941,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40979], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__40430,G__40431){
var validate__36731__auto__ = cljs.core.deref(ufv___40940);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___40987 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40430,G__40431], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40461_40988 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40462_40989 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40463_40990 = input_schema40427_40943;
var G__40464_40991 = cljs.core.deref(input_checker40428_40947);
var G__40465_40992 = args__36732__auto___40987;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40461_40988,G__40462_40989,G__40463_40990,G__40464_40991,G__40465_40992) : schema.core.fn_validator.call(null,G__40461_40988,G__40462_40989,G__40463_40990,G__40464_40991,G__40465_40992));
} else {
var temp__5804__auto___40993 = (function (){var fexpr__40470 = cljs.core.deref(input_checker40428_40947);
return (fexpr__40470.cljs$core$IFn$_invoke$arity$1 ? fexpr__40470.cljs$core$IFn$_invoke$arity$1(args__36732__auto___40987) : fexpr__40470.call(null,args__36732__auto___40987));
})();
if(cljs.core.truth_(temp__5804__auto___40993)){
var error__36733__auto___40994 = temp__5804__auto___40993;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___40994], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40427_40943,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___40987,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___40994], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40430;
var start = G__40431;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40472_40995 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40473_40996 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40474_40997 = output_schema40422_40941;
var G__40475_40998 = cljs.core.deref(output_checker40429_40948);
var G__40476_40999 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40472_40995,G__40473_40996,G__40474_40997,G__40475_40998,G__40476_40999) : schema.core.fn_validator.call(null,G__40472_40995,G__40473_40996,G__40474_40997,G__40475_40998,G__40476_40999));
} else {
var temp__5804__auto___41000 = (function (){var fexpr__40477 = cljs.core.deref(output_checker40429_40948);
return (fexpr__40477.cljs$core$IFn$_invoke$arity$1 ? fexpr__40477.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40477.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41000)){
var error__36733__auto___41001 = temp__5804__auto___41000;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41001], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40422_40941,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41001], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__40435,G__40436,G__40437){
var validate__36731__auto__ = cljs.core.deref(ufv___40940);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41005 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40435,G__40436,G__40437], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40479_41007 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40480_41008 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40481_41009 = input_schema40432_40944;
var G__40482_41010 = cljs.core.deref(input_checker40433_40949);
var G__40483_41011 = args__36732__auto___41005;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40479_41007,G__40480_41008,G__40481_41009,G__40482_41010,G__40483_41011) : schema.core.fn_validator.call(null,G__40479_41007,G__40480_41008,G__40481_41009,G__40482_41010,G__40483_41011));
} else {
var temp__5804__auto___41012 = (function (){var fexpr__40484 = cljs.core.deref(input_checker40433_40949);
return (fexpr__40484.cljs$core$IFn$_invoke$arity$1 ? fexpr__40484.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41005) : fexpr__40484.call(null,args__36732__auto___41005));
})();
if(cljs.core.truth_(temp__5804__auto___41012)){
var error__36733__auto___41015 = temp__5804__auto___41012;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41015], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40432_40944,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41005,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41015], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40435;
var start = G__40436;
var end = G__40437;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__4339__auto__ = end;
var y__4340__auto__ = cljs.core.count(ba);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40485_41021 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40486_41022 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__40487_41023 = output_schema40422_40941;
var G__40488_41024 = cljs.core.deref(output_checker40434_40950);
var G__40489_41025 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40485_41021,G__40486_41022,G__40487_41023,G__40488_41024,G__40489_41025) : schema.core.fn_validator.call(null,G__40485_41021,G__40486_41022,G__40487_41023,G__40488_41024,G__40489_41025));
} else {
var temp__5804__auto___41029 = (function (){var fexpr__40490 = cljs.core.deref(output_checker40434_40950);
return (fexpr__40490.cljs$core$IFn$_invoke$arity$1 ? fexpr__40490.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40490.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41029)){
var error__36733__auto___41032 = temp__5804__auto___41029;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41032], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40422_40941,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41032], null));
} else {
}
}
} else {
}

return o__36734__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema40422_40941,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40423_40942,input_schema40427_40943,input_schema40432_40944], null)));

var ufv___41034 = schema.utils.use_fn_validation;
var output_schema40493_41035 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40494_41036 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40495_41037 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40494_41036);
}),null));
var output_checker40496_41038 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40493_41035);
}),null));
var ret__38856__auto___41042 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__40497){
var validate__36731__auto__ = cljs.core.deref(ufv___41034);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41043 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40497], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40498_41044 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40499_41045 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__40500_41046 = input_schema40494_41036;
var G__40501_41047 = cljs.core.deref(input_checker40495_41037);
var G__40502_41048 = args__36732__auto___41043;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40498_41044,G__40499_41045,G__40500_41046,G__40501_41047,G__40502_41048) : schema.core.fn_validator.call(null,G__40498_41044,G__40499_41045,G__40500_41046,G__40501_41047,G__40502_41048));
} else {
var temp__5804__auto___41050 = (function (){var fexpr__40503 = cljs.core.deref(input_checker40495_41037);
return (fexpr__40503.cljs$core$IFn$_invoke$arity$1 ? fexpr__40503.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41043) : fexpr__40503.call(null,args__36732__auto___41043));
})();
if(cljs.core.truth_(temp__5804__auto___41050)){
var error__36733__auto___41055 = temp__5804__auto___41050;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41055], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40494_41036,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41043,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41055], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40497;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__4741__auto___41061 = num;
var i_41062 = (0);
while(true){
if((i_41062 < n__4741__auto___41061)){
(new$[i_41062] = (ba[(last - i_41062)]));

var G__41063 = (i_41062 + (1));
i_41062 = G__41063;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40504_41064 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40505_41065 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__40506_41066 = output_schema40493_41035;
var G__40507_41067 = cljs.core.deref(output_checker40496_41038);
var G__40508_41068 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40504_41064,G__40505_41065,G__40506_41066,G__40507_41067,G__40508_41068) : schema.core.fn_validator.call(null,G__40504_41064,G__40505_41065,G__40506_41066,G__40507_41067,G__40508_41068));
} else {
var temp__5804__auto___41074 = (function (){var fexpr__40509 = cljs.core.deref(output_checker40496_41038);
return (fexpr__40509.cljs$core$IFn$_invoke$arity$1 ? fexpr__40509.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40509.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41074)){
var error__36733__auto___41075 = temp__5804__auto___41074;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41075], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40493_41035,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41075], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema40493_41035,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40494_41036], null)));

var ufv___41080 = schema.utils.use_fn_validation;
var output_schema40510_41081 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema40511_41082 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker40512_41083 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40511_41082);
}),null));
var output_checker40513_41084 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40510_41081);
}),null));
var ret__38856__auto___41086 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__40514,G__40515){
var validate__36731__auto__ = cljs.core.deref(ufv___41080);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41087 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40514,G__40515], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40517_41088 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40518_41089 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__40519_41090 = input_schema40511_41082;
var G__40520_41091 = cljs.core.deref(input_checker40512_41083);
var G__40521_41092 = args__36732__auto___41087;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40517_41088,G__40518_41089,G__40519_41090,G__40520_41091,G__40521_41092) : schema.core.fn_validator.call(null,G__40517_41088,G__40518_41089,G__40519_41090,G__40520_41091,G__40521_41092));
} else {
var temp__5804__auto___41093 = (function (){var fexpr__40522 = cljs.core.deref(input_checker40512_41083);
return (fexpr__40522.cljs$core$IFn$_invoke$arity$1 ? fexpr__40522.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41087) : fexpr__40522.call(null,args__36732__auto___41087));
})();
if(cljs.core.truth_(temp__5804__auto___41093)){
var error__36733__auto___41094 = temp__5804__auto___41093;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41094], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40511_41082,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41087,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41094], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40514;
var fragment_size = G__40515;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__41100 = (end_offset | (0));
var G__41101 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__41100;
output = G__41101;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40525_41102 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40526_41103 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__40527_41104 = output_schema40510_41081;
var G__40528_41105 = cljs.core.deref(output_checker40513_41084);
var G__40529_41106 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40525_41102,G__40526_41103,G__40527_41104,G__40528_41105,G__40529_41106) : schema.core.fn_validator.call(null,G__40525_41102,G__40526_41103,G__40527_41104,G__40528_41105,G__40529_41106));
} else {
var temp__5804__auto___41109 = (function (){var fexpr__40530 = cljs.core.deref(output_checker40513_41084);
return (fexpr__40530.cljs$core$IFn$_invoke$arity$1 ? fexpr__40530.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40530.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41109)){
var error__36733__auto___41112 = temp__5804__auto___41109;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41112], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40510_41081,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41112], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema40510_41081,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40511_41082], null)));

var ufv___41114 = schema.utils.use_fn_validation;
var output_schema40531_41115 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema40532_41116 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40533_41117 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40532_41116);
}),null));
var output_checker40534_41118 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40531_41115);
}),null));
var ret__38856__auto___41119 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__40535){
var validate__36731__auto__ = cljs.core.deref(ufv___41114);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41123 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40535], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40537_41124 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40538_41125 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__40539_41126 = input_schema40532_41116;
var G__40540_41127 = cljs.core.deref(input_checker40533_41117);
var G__40541_41128 = args__36732__auto___41123;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40537_41124,G__40538_41125,G__40539_41126,G__40540_41127,G__40541_41128) : schema.core.fn_validator.call(null,G__40537_41124,G__40538_41125,G__40539_41126,G__40540_41127,G__40541_41128));
} else {
var temp__5804__auto___41131 = (function (){var fexpr__40542 = cljs.core.deref(input_checker40533_41117);
return (fexpr__40542.cljs$core$IFn$_invoke$arity$1 ? fexpr__40542.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41123) : fexpr__40542.call(null,args__36732__auto___41123));
})();
if(cljs.core.truth_(temp__5804__auto___41131)){
var error__36733__auto___41132 = temp__5804__auto___41131;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41132], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40532_41116,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41123,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41132], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40535;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__41137 = (n + (1));
var G__41138 = (i__$1 | (0));
var G__41139 = (out__$1 | (0));
n = G__41137;
i = G__41138;
out = G__41139;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40544_41140 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40545_41141 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__40546_41142 = output_schema40531_41115;
var G__40547_41143 = cljs.core.deref(output_checker40534_41118);
var G__40548_41144 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40544_41140,G__40545_41141,G__40546_41142,G__40547_41143,G__40548_41144) : schema.core.fn_validator.call(null,G__40544_41140,G__40545_41141,G__40546_41142,G__40547_41143,G__40548_41144));
} else {
var temp__5804__auto___41146 = (function (){var fexpr__40549 = cljs.core.deref(output_checker40534_41118);
return (fexpr__40549.cljs$core$IFn$_invoke$arity$1 ? fexpr__40549.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40549.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41146)){
var error__36733__auto___41148 = temp__5804__auto___41146;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41148], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40531_41115,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41148], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema40531_41115,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40532_41116], null)));

var ufv___41151 = schema.utils.use_fn_validation;
var output_schema40550_41152 = deercreeklabs.baracus.ByteArray;
var input_schema40551_41153 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker40552_41154 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40551_41153);
}),null));
var output_checker40553_41155 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40550_41152);
}),null));
var ret__38856__auto___41158 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__40554){
var validate__36731__auto__ = cljs.core.deref(ufv___41151);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41159 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40554], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40555_41160 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40556_41161 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__40557_41162 = input_schema40551_41153;
var G__40558_41163 = cljs.core.deref(input_checker40552_41154);
var G__40559_41164 = args__36732__auto___41159;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40555_41160,G__40556_41161,G__40557_41162,G__40558_41163,G__40559_41164) : schema.core.fn_validator.call(null,G__40555_41160,G__40556_41161,G__40557_41162,G__40558_41163,G__40559_41164));
} else {
var temp__5804__auto___41165 = (function (){var fexpr__40560 = cljs.core.deref(input_checker40552_41154);
return (fexpr__40560.cljs$core$IFn$_invoke$arity$1 ? fexpr__40560.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41159) : fexpr__40560.call(null,args__36732__auto___41159));
})();
if(cljs.core.truth_(temp__5804__auto___41165)){
var error__36733__auto___41167 = temp__5804__auto___41165;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41167], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40551_41153,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41159,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41167], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var i = G__40554;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__41172 = (n >>> (7));
var G__41173 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__41172;
out = G__41173;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40562_41174 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40563_41175 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__40564_41176 = output_schema40550_41152;
var G__40565_41177 = cljs.core.deref(output_checker40553_41155);
var G__40566_41178 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40562_41174,G__40563_41175,G__40564_41176,G__40565_41177,G__40566_41178) : schema.core.fn_validator.call(null,G__40562_41174,G__40563_41175,G__40564_41176,G__40565_41177,G__40566_41178));
} else {
var temp__5804__auto___41181 = (function (){var fexpr__40567 = cljs.core.deref(output_checker40553_41155);
return (fexpr__40567.cljs$core$IFn$_invoke$arity$1 ? fexpr__40567.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40567.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41181)){
var error__36733__auto___41182 = temp__5804__auto___41181;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41182], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40550_41152,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41182], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema40550_41152,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40551_41153], null)));

var ufv___41187 = schema.utils.use_fn_validation;
var output_schema40569_41188 = schema.core.maybe(schema.core.Str);
var input_schema40570_41189 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40571_41190 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40570_41189);
}),null));
var output_checker40572_41191 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40569_41188);
}),null));
var ret__38856__auto___41192 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__40573){
var validate__36731__auto__ = cljs.core.deref(ufv___41187);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41193 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40573], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40575_41194 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40576_41195 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__40577_41196 = input_schema40570_41189;
var G__40578_41197 = cljs.core.deref(input_checker40571_41190);
var G__40579_41198 = args__36732__auto___41193;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40575_41194,G__40576_41195,G__40577_41196,G__40578_41197,G__40579_41198) : schema.core.fn_validator.call(null,G__40575_41194,G__40576_41195,G__40577_41196,G__40578_41197,G__40579_41198));
} else {
var temp__5804__auto___41200 = (function (){var fexpr__40580 = cljs.core.deref(input_checker40571_41190);
return (fexpr__40580.cljs$core$IFn$_invoke$arity$1 ? fexpr__40580.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41193) : fexpr__40580.call(null,args__36732__auto___41193));
})();
if(cljs.core.truth_(temp__5804__auto___41200)){
var error__36733__auto___41201 = temp__5804__auto___41200;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41201], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40570_41189,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41193,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41201], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var b = G__40573;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40584_41204 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40585_41205 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__40586_41206 = output_schema40569_41188;
var G__40587_41207 = cljs.core.deref(output_checker40572_41191);
var G__40588_41208 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40584_41204,G__40585_41205,G__40586_41206,G__40587_41207,G__40588_41208) : schema.core.fn_validator.call(null,G__40584_41204,G__40585_41205,G__40586_41206,G__40587_41207,G__40588_41208));
} else {
var temp__5804__auto___41211 = (function (){var fexpr__40590 = cljs.core.deref(output_checker40572_41191);
return (fexpr__40590.cljs$core$IFn$_invoke$arity$1 ? fexpr__40590.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40590.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41211)){
var error__36733__auto___41212 = temp__5804__auto___41211;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41212], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40569_41188,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41212], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema40569_41188,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40570_41189], null)));

var ufv___41216 = schema.utils.use_fn_validation;
var output_schema40591_41217 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40592_41218 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker40593_41219 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40592_41218);
}),null));
var output_checker40594_41220 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40591_41217);
}),null));
var ret__38856__auto___41225 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__40595){
var validate__36731__auto__ = cljs.core.deref(ufv___41216);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41227 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40595], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40597_41228 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40598_41229 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40599_41230 = input_schema40592_41218;
var G__40600_41231 = cljs.core.deref(input_checker40593_41219);
var G__40601_41232 = args__36732__auto___41227;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40597_41228,G__40598_41229,G__40599_41230,G__40600_41231,G__40601_41232) : schema.core.fn_validator.call(null,G__40597_41228,G__40598_41229,G__40599_41230,G__40600_41231,G__40601_41232));
} else {
var temp__5804__auto___41235 = (function (){var fexpr__40602 = cljs.core.deref(input_checker40593_41219);
return (fexpr__40602.cljs$core$IFn$_invoke$arity$1 ? fexpr__40602.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41227) : fexpr__40602.call(null,args__36732__auto___41227));
})();
if(cljs.core.truth_(temp__5804__auto___41235)){
var error__36733__auto___41236 = temp__5804__auto___41235;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41236], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40592_41218,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41227,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41236], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var s = G__40595;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40603_41241 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40604_41242 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40605_41243 = output_schema40591_41217;
var G__40606_41244 = cljs.core.deref(output_checker40594_41220);
var G__40607_41245 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40603_41241,G__40604_41242,G__40605_41243,G__40606_41244,G__40607_41245) : schema.core.fn_validator.call(null,G__40603_41241,G__40604_41242,G__40605_41243,G__40606_41244,G__40607_41245));
} else {
var temp__5804__auto___41247 = (function (){var fexpr__40608 = cljs.core.deref(output_checker40594_41220);
return (fexpr__40608.cljs$core$IFn$_invoke$arity$1 ? fexpr__40608.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40608.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41247)){
var error__36733__auto___41248 = temp__5804__auto___41247;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41248], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40591_41217,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41248], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema40591_41217,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40592_41218], null)));

var ufv___41250 = schema.utils.use_fn_validation;
var output_schema40610_41251 = schema.core.maybe(schema.core.Str);
var input_schema40611_41252 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40612_41253 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40611_41252);
}),null));
var output_checker40613_41254 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40610_41251);
}),null));
var ret__38856__auto___41255 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__40614){
var validate__36731__auto__ = cljs.core.deref(ufv___41250);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41257 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40614], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40616_41259 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40617_41260 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40618_41261 = input_schema40611_41252;
var G__40619_41262 = cljs.core.deref(input_checker40612_41253);
var G__40620_41263 = args__36732__auto___41257;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40616_41259,G__40617_41260,G__40618_41261,G__40619_41262,G__40620_41263) : schema.core.fn_validator.call(null,G__40616_41259,G__40617_41260,G__40618_41261,G__40619_41262,G__40620_41263));
} else {
var temp__5804__auto___41264 = (function (){var fexpr__40623 = cljs.core.deref(input_checker40612_41253);
return (fexpr__40623.cljs$core$IFn$_invoke$arity$1 ? fexpr__40623.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41257) : fexpr__40623.call(null,args__36732__auto___41257));
})();
if(cljs.core.truth_(temp__5804__auto___41264)){
var error__36733__auto___41265 = temp__5804__auto___41264;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41265], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40611_41252,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41257,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41265], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40614;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40624_41267 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40625_41268 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40626_41269 = output_schema40610_41251;
var G__40627_41270 = cljs.core.deref(output_checker40613_41254);
var G__40628_41271 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40624_41267,G__40625_41268,G__40626_41269,G__40627_41270,G__40628_41271) : schema.core.fn_validator.call(null,G__40624_41267,G__40625_41268,G__40626_41269,G__40627_41270,G__40628_41271));
} else {
var temp__5804__auto___41272 = (function (){var fexpr__40630 = cljs.core.deref(output_checker40613_41254);
return (fexpr__40630.cljs$core$IFn$_invoke$arity$1 ? fexpr__40630.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40630.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41272)){
var error__36733__auto___41273 = temp__5804__auto___41272;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41273], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40610_41251,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41273], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema40610_41251,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40611_41252], null)));

var ufv___41274 = schema.utils.use_fn_validation;
var output_schema40632_41275 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40633_41276 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker40634_41277 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40633_41276);
}),null));
var output_checker40635_41278 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40632_41275);
}),null));
var ret__38856__auto___41279 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__40636){
var validate__36731__auto__ = cljs.core.deref(ufv___41274);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41281 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40636], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40637_41282 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40638_41283 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40639_41284 = input_schema40633_41276;
var G__40640_41285 = cljs.core.deref(input_checker40634_41277);
var G__40641_41286 = args__36732__auto___41281;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40637_41282,G__40638_41283,G__40639_41284,G__40640_41285,G__40641_41286) : schema.core.fn_validator.call(null,G__40637_41282,G__40638_41283,G__40639_41284,G__40640_41285,G__40641_41286));
} else {
var temp__5804__auto___41287 = (function (){var fexpr__40643 = cljs.core.deref(input_checker40634_41277);
return (fexpr__40643.cljs$core$IFn$_invoke$arity$1 ? fexpr__40643.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41281) : fexpr__40643.call(null,args__36732__auto___41281));
})();
if(cljs.core.truth_(temp__5804__auto___41287)){
var error__36733__auto___41290 = temp__5804__auto___41287;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41290], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40633_41276,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41281,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41290], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var s = G__40636;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40644_41292 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40645_41293 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40646_41294 = output_schema40632_41275;
var G__40647_41295 = cljs.core.deref(output_checker40635_41278);
var G__40648_41296 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40644_41292,G__40645_41293,G__40646_41294,G__40647_41295,G__40648_41296) : schema.core.fn_validator.call(null,G__40644_41292,G__40645_41293,G__40646_41294,G__40647_41295,G__40648_41296));
} else {
var temp__5804__auto___41297 = (function (){var fexpr__40650 = cljs.core.deref(output_checker40635_41278);
return (fexpr__40650.cljs$core$IFn$_invoke$arity$1 ? fexpr__40650.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40650.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41297)){
var error__36733__auto___41298 = temp__5804__auto___41297;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41298], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40632_41275,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41298], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema40632_41275,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40633_41276], null)));

var ufv___41301 = schema.utils.use_fn_validation;
var output_schema40651_41302 = schema.core.maybe(schema.core.Str);
var input_schema40652_41303 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker40653_41304 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40652_41303);
}),null));
var output_checker40654_41305 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40651_41302);
}),null));
var ret__38856__auto___41308 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__40655){
var validate__36731__auto__ = cljs.core.deref(ufv___41301);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41309 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40655], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40657_41310 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40658_41311 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40659_41312 = input_schema40652_41303;
var G__40660_41313 = cljs.core.deref(input_checker40653_41304);
var G__40661_41314 = args__36732__auto___41309;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40657_41310,G__40658_41311,G__40659_41312,G__40660_41313,G__40661_41314) : schema.core.fn_validator.call(null,G__40657_41310,G__40658_41311,G__40659_41312,G__40660_41313,G__40661_41314));
} else {
var temp__5804__auto___41316 = (function (){var fexpr__40662 = cljs.core.deref(input_checker40653_41304);
return (fexpr__40662.cljs$core$IFn$_invoke$arity$1 ? fexpr__40662.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41309) : fexpr__40662.call(null,args__36732__auto___41309));
})();
if(cljs.core.truth_(temp__5804__auto___41316)){
var error__36733__auto___41317 = temp__5804__auto___41316;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41317], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40652_41303,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41309,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41317], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40655;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__4741__auto___41320 = len;
var i_41321 = (0);
while(true){
if((i_41321 < n__4741__auto___41320)){
var b_41323 = ((ba[i_41321]) & (255));
var j_41324 = ((2) * i_41321);
(ca[j_41324] = (function (){var G__40663 = (b_41323 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__40663) : hex_chars.call(null,G__40663));
})());

(ca[(j_41324 + (1))] = (function (){var G__40664 = (b_41323 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__40664) : hex_chars.call(null,G__40664));
})());

var G__41326 = (i_41321 + (1));
i_41321 = G__41326;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40666_41327 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40667_41328 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__40668_41329 = output_schema40651_41302;
var G__40669_41330 = cljs.core.deref(output_checker40654_41305);
var G__40670_41331 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40666_41327,G__40667_41328,G__40668_41329,G__40669_41330,G__40670_41331) : schema.core.fn_validator.call(null,G__40666_41327,G__40667_41328,G__40668_41329,G__40669_41330,G__40670_41331));
} else {
var temp__5804__auto___41332 = (function (){var fexpr__40671 = cljs.core.deref(output_checker40654_41305);
return (fexpr__40671.cljs$core$IFn$_invoke$arity$1 ? fexpr__40671.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40671.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41332)){
var error__36733__auto___41333 = temp__5804__auto___41332;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41333], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40651_41302,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41333], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema40651_41302,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40652_41303], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___41340 = schema.utils.use_fn_validation;
var output_schema40675_41341 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema40676_41342 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker40677_41343 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40676_41342);
}),null));
var output_checker40678_41344 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40675_41341);
}),null));
var ret__38856__auto___41345 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__40679){
var validate__36731__auto__ = cljs.core.deref(ufv___41340);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41346 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40679], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40681_41347 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40682_41348 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40683_41349 = input_schema40676_41342;
var G__40684_41350 = cljs.core.deref(input_checker40677_41343);
var G__40685_41351 = args__36732__auto___41346;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40681_41347,G__40682_41348,G__40683_41349,G__40684_41350,G__40685_41351) : schema.core.fn_validator.call(null,G__40681_41347,G__40682_41348,G__40683_41349,G__40684_41350,G__40685_41351));
} else {
var temp__5804__auto___41352 = (function (){var fexpr__40686 = cljs.core.deref(input_checker40677_41343);
return (fexpr__40686.cljs$core$IFn$_invoke$arity$1 ? fexpr__40686.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41346) : fexpr__40686.call(null,args__36732__auto___41346));
})();
if(cljs.core.truth_(temp__5804__auto___41352)){
var error__36733__auto___41353 = temp__5804__auto___41352;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41353], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40676_41342,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41346,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41353], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var s = G__40679;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__4741__auto___41363 = ba_len;
var i_41364 = (0);
while(true){
if((i_41364 < n__4741__auto___41363)){
var j_41365 = ((2) * i_41364);
(ba[i_41364] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_41365)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_41365 + (1))))));

var G__41367 = (i_41364 + (1));
i_41364 = G__41367;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40688_41368 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40689_41369 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__40690_41370 = output_schema40675_41341;
var G__40691_41371 = cljs.core.deref(output_checker40678_41344);
var G__40692_41372 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40688_41368,G__40689_41369,G__40690_41370,G__40691_41371,G__40692_41372) : schema.core.fn_validator.call(null,G__40688_41368,G__40689_41369,G__40690_41370,G__40691_41371,G__40692_41372));
} else {
var temp__5804__auto___41376 = (function (){var fexpr__40693 = cljs.core.deref(output_checker40678_41344);
return (fexpr__40693.cljs$core$IFn$_invoke$arity$1 ? fexpr__40693.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40693.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41376)){
var error__36733__auto___41378 = temp__5804__auto___41376;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41378], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40675_41341,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41378], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema40675_41341,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40676_41342], null)));

var ufv___41381 = schema.utils.use_fn_validation;
var output_schema40694_41382 = deercreeklabs.baracus.ByteArray;
var input_schema40695_41383 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40696_41384 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40695_41383);
}),null));
var output_checker40697_41385 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40694_41382);
}),null));
var ret__38856__auto___41386 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__40698){
var validate__36731__auto__ = cljs.core.deref(ufv___41381);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41389 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40698], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40700_41390 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40701_41391 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40702_41392 = input_schema40695_41383;
var G__40703_41393 = cljs.core.deref(input_checker40696_41384);
var G__40704_41394 = args__36732__auto___41389;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40700_41390,G__40701_41391,G__40702_41392,G__40703_41393,G__40704_41394) : schema.core.fn_validator.call(null,G__40700_41390,G__40701_41391,G__40702_41392,G__40703_41393,G__40704_41394));
} else {
var temp__5804__auto___41395 = (function (){var fexpr__40705 = cljs.core.deref(input_checker40696_41384);
return (fexpr__40705.cljs$core$IFn$_invoke$arity$1 ? fexpr__40705.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41389) : fexpr__40705.call(null,args__36732__auto___41389));
})();
if(cljs.core.truth_(temp__5804__auto___41395)){
var error__36733__auto___41396 = temp__5804__auto___41395;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41396], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40695_41383,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41389,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41396], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40698;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40707_41400 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40708_41401 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40709_41402 = output_schema40694_41382;
var G__40710_41403 = cljs.core.deref(output_checker40697_41385);
var G__40711_41404 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40707_41400,G__40708_41401,G__40709_41402,G__40710_41403,G__40711_41404) : schema.core.fn_validator.call(null,G__40707_41400,G__40708_41401,G__40709_41402,G__40710_41403,G__40711_41404));
} else {
var temp__5804__auto___41405 = (function (){var fexpr__40712 = cljs.core.deref(output_checker40697_41385);
return (fexpr__40712.cljs$core$IFn$_invoke$arity$1 ? fexpr__40712.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40712.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41405)){
var error__36733__auto___41406 = temp__5804__auto___41405;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41406], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40694_41382,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41406], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema40694_41382,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40695_41383], null)));

var ufv___41409 = schema.utils.use_fn_validation;
var output_schema40713_41410 = deercreeklabs.baracus.ByteArray;
var input_schema40714_41411 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40715_41412 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40714_41411);
}),null));
var output_checker40716_41413 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40713_41410);
}),null));
var ret__38856__auto___41415 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__40717){
var validate__36731__auto__ = cljs.core.deref(ufv___41409);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41416 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40717], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40718_41417 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40719_41418 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40720_41419 = input_schema40714_41411;
var G__40721_41420 = cljs.core.deref(input_checker40715_41412);
var G__40722_41421 = args__36732__auto___41416;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40718_41417,G__40719_41418,G__40720_41419,G__40721_41420,G__40722_41421) : schema.core.fn_validator.call(null,G__40718_41417,G__40719_41418,G__40720_41419,G__40721_41420,G__40722_41421));
} else {
var temp__5804__auto___41425 = (function (){var fexpr__40723 = cljs.core.deref(input_checker40715_41412);
return (fexpr__40723.cljs$core$IFn$_invoke$arity$1 ? fexpr__40723.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41416) : fexpr__40723.call(null,args__36732__auto___41416));
})();
if(cljs.core.truth_(temp__5804__auto___41425)){
var error__36733__auto___41427 = temp__5804__auto___41425;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41427], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40714_41411,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41416,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41427], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40717;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40725_41429 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40726_41430 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40727_41431 = output_schema40713_41410;
var G__40728_41432 = cljs.core.deref(output_checker40716_41413);
var G__40729_41433 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40725_41429,G__40726_41430,G__40727_41431,G__40728_41432,G__40729_41433) : schema.core.fn_validator.call(null,G__40725_41429,G__40726_41430,G__40727_41431,G__40728_41432,G__40729_41433));
} else {
var temp__5804__auto___41436 = (function (){var fexpr__40730 = cljs.core.deref(output_checker40716_41413);
return (fexpr__40730.cljs$core$IFn$_invoke$arity$1 ? fexpr__40730.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40730.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41436)){
var error__36733__auto___41437 = temp__5804__auto___41436;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41437], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40713_41410,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41437], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema40713_41410,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40714_41411], null)));

var ufv___41440 = schema.utils.use_fn_validation;
var output_schema40731_41441 = deercreeklabs.baracus.ByteArray;
var input_schema40732_41442 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker40733_41443 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema40732_41442);
}),null));
var output_checker40734_41444 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema40731_41441);
}),null));
var ret__38856__auto___41446 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__40735){
var validate__36731__auto__ = cljs.core.deref(ufv___41440);
if(cljs.core.truth_(validate__36731__auto__)){
var args__36732__auto___41449 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__40735], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40739_41450 = new cljs.core.Keyword(null,"input","input",556931961);
var G__40740_41451 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40741_41452 = input_schema40732_41442;
var G__40742_41453 = cljs.core.deref(input_checker40733_41443);
var G__40743_41454 = args__36732__auto___41449;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40739_41450,G__40740_41451,G__40741_41452,G__40742_41453,G__40743_41454) : schema.core.fn_validator.call(null,G__40739_41450,G__40740_41451,G__40741_41452,G__40742_41453,G__40743_41454));
} else {
var temp__5804__auto___41457 = (function (){var fexpr__40744 = cljs.core.deref(input_checker40733_41443);
return (fexpr__40744.cljs$core$IFn$_invoke$arity$1 ? fexpr__40744.cljs$core$IFn$_invoke$arity$1(args__36732__auto___41449) : fexpr__40744.call(null,args__36732__auto___41449));
})();
if(cljs.core.truth_(temp__5804__auto___41457)){
var error__36733__auto___41458 = temp__5804__auto___41457;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41458], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema40732_41442,new cljs.core.Keyword(null,"value","value",305978217),args__36732__auto___41449,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41458], null));
} else {
}
}
} else {
}

var o__36734__auto__ = (function (){var ba = G__40735;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__36731__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__40746_41462 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__40747_41463 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__40748_41464 = output_schema40731_41441;
var G__40749_41465 = cljs.core.deref(output_checker40734_41444);
var G__40750_41466 = o__36734__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__40746_41462,G__40747_41463,G__40748_41464,G__40749_41465,G__40750_41466) : schema.core.fn_validator.call(null,G__40746_41462,G__40747_41463,G__40748_41464,G__40749_41465,G__40750_41466));
} else {
var temp__5804__auto___41469 = (function (){var fexpr__40751 = cljs.core.deref(output_checker40734_41444);
return (fexpr__40751.cljs$core$IFn$_invoke$arity$1 ? fexpr__40751.cljs$core$IFn$_invoke$arity$1(o__36734__auto__) : fexpr__40751.call(null,o__36734__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41469)){
var error__36733__auto___41470 = temp__5804__auto___41469;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__36733__auto___41470], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema40731_41441,new cljs.core.Keyword(null,"value","value",305978217),o__36734__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__36733__auto___41470], null));
} else {
}
}
} else {
}

return o__36734__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema40731_41441,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema40732_41442], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
