goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_34567 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_34567(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_34568 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_34568(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__32937 = coll;
var G__32938 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__32937,G__32938) : shadow.dom.lazy_native_coll_seq.call(null,G__32937,G__32938));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__32995 = arguments.length;
switch (G__32995) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__33003 = arguments.length;
switch (G__33003) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__33020 = arguments.length;
switch (G__33020) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__33041 = arguments.length;
switch (G__33041) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33056 = arguments.length;
switch (G__33056) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33103 = arguments.length;
switch (G__33103) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33126){if((e33126 instanceof Object)){
var e = e33126;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33126;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33144 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33145 = null;
var count__33146 = (0);
var i__33147 = (0);
while(true){
if((i__33147 < count__33146)){
var el = chunk__33145.cljs$core$IIndexed$_nth$arity$2(null,i__33147);
var handler_34578__$1 = ((function (seq__33144,chunk__33145,count__33146,i__33147,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33144,chunk__33145,count__33146,i__33147,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34578__$1);


var G__34579 = seq__33144;
var G__34580 = chunk__33145;
var G__34581 = count__33146;
var G__34582 = (i__33147 + (1));
seq__33144 = G__34579;
chunk__33145 = G__34580;
count__33146 = G__34581;
i__33147 = G__34582;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33144);
if(temp__5804__auto__){
var seq__33144__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33144__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33144__$1);
var G__34583 = cljs.core.chunk_rest(seq__33144__$1);
var G__34584 = c__4679__auto__;
var G__34585 = cljs.core.count(c__4679__auto__);
var G__34586 = (0);
seq__33144 = G__34583;
chunk__33145 = G__34584;
count__33146 = G__34585;
i__33147 = G__34586;
continue;
} else {
var el = cljs.core.first(seq__33144__$1);
var handler_34587__$1 = ((function (seq__33144,chunk__33145,count__33146,i__33147,el,seq__33144__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33144,chunk__33145,count__33146,i__33147,el,seq__33144__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34587__$1);


var G__34588 = cljs.core.next(seq__33144__$1);
var G__34589 = null;
var G__34590 = (0);
var G__34591 = (0);
seq__33144 = G__34588;
chunk__33145 = G__34589;
count__33146 = G__34590;
i__33147 = G__34591;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33164 = arguments.length;
switch (G__33164) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33184 = cljs.core.seq(events);
var chunk__33185 = null;
var count__33186 = (0);
var i__33187 = (0);
while(true){
if((i__33187 < count__33186)){
var vec__33209 = chunk__33185.cljs$core$IIndexed$_nth$arity$2(null,i__33187);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33209,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33209,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34593 = seq__33184;
var G__34594 = chunk__33185;
var G__34595 = count__33186;
var G__34596 = (i__33187 + (1));
seq__33184 = G__34593;
chunk__33185 = G__34594;
count__33186 = G__34595;
i__33187 = G__34596;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33184);
if(temp__5804__auto__){
var seq__33184__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33184__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33184__$1);
var G__34597 = cljs.core.chunk_rest(seq__33184__$1);
var G__34598 = c__4679__auto__;
var G__34599 = cljs.core.count(c__4679__auto__);
var G__34600 = (0);
seq__33184 = G__34597;
chunk__33185 = G__34598;
count__33186 = G__34599;
i__33187 = G__34600;
continue;
} else {
var vec__33217 = cljs.core.first(seq__33184__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33217,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33217,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34601 = cljs.core.next(seq__33184__$1);
var G__34602 = null;
var G__34603 = (0);
var G__34604 = (0);
seq__33184 = G__34601;
chunk__33185 = G__34602;
count__33186 = G__34603;
i__33187 = G__34604;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__33225 = cljs.core.seq(styles);
var chunk__33226 = null;
var count__33227 = (0);
var i__33228 = (0);
while(true){
if((i__33228 < count__33227)){
var vec__33268 = chunk__33226.cljs$core$IIndexed$_nth$arity$2(null,i__33228);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33268,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33268,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34605 = seq__33225;
var G__34606 = chunk__33226;
var G__34607 = count__33227;
var G__34608 = (i__33228 + (1));
seq__33225 = G__34605;
chunk__33226 = G__34606;
count__33227 = G__34607;
i__33228 = G__34608;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33225);
if(temp__5804__auto__){
var seq__33225__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33225__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33225__$1);
var G__34609 = cljs.core.chunk_rest(seq__33225__$1);
var G__34610 = c__4679__auto__;
var G__34611 = cljs.core.count(c__4679__auto__);
var G__34612 = (0);
seq__33225 = G__34609;
chunk__33226 = G__34610;
count__33227 = G__34611;
i__33228 = G__34612;
continue;
} else {
var vec__33275 = cljs.core.first(seq__33225__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33275,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33275,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34613 = cljs.core.next(seq__33225__$1);
var G__34614 = null;
var G__34615 = (0);
var G__34616 = (0);
seq__33225 = G__34613;
chunk__33226 = G__34614;
count__33227 = G__34615;
i__33228 = G__34616;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__33287_34617 = key;
var G__33287_34618__$1 = (((G__33287_34617 instanceof cljs.core.Keyword))?G__33287_34617.fqn:null);
switch (G__33287_34618__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_34628 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_34628,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_34628,"aria-");
}
})())){
el.setAttribute(ks_34628,value);
} else {
(el[ks_34628] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__33317){
var map__33324 = p__33317;
var map__33324__$1 = cljs.core.__destructure_map(map__33324);
var props = map__33324__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33324__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__33327 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33327,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33327,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33327,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__33336 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__33336,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__33336;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__33353 = arguments.length;
switch (G__33353) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__33395){
var vec__33400 = p__33395;
var seq__33401 = cljs.core.seq(vec__33400);
var first__33402 = cljs.core.first(seq__33401);
var seq__33401__$1 = cljs.core.next(seq__33401);
var nn = first__33402;
var first__33402__$1 = cljs.core.first(seq__33401__$1);
var seq__33401__$2 = cljs.core.next(seq__33401__$1);
var np = first__33402__$1;
var nc = seq__33401__$2;
var node = vec__33400;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33409 = nn;
var G__33410 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33409,G__33410) : create_fn.call(null,G__33409,G__33410));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33411 = nn;
var G__33412 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33411,G__33412) : create_fn.call(null,G__33411,G__33412));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__33421 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33421,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33421,(1),null);
var seq__33425_34632 = cljs.core.seq(node_children);
var chunk__33427_34633 = null;
var count__33428_34634 = (0);
var i__33429_34635 = (0);
while(true){
if((i__33429_34635 < count__33428_34634)){
var child_struct_34636 = chunk__33427_34633.cljs$core$IIndexed$_nth$arity$2(null,i__33429_34635);
var children_34637 = shadow.dom.dom_node(child_struct_34636);
if(cljs.core.seq_QMARK_(children_34637)){
var seq__33551_34638 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34637));
var chunk__33553_34639 = null;
var count__33554_34640 = (0);
var i__33555_34641 = (0);
while(true){
if((i__33555_34641 < count__33554_34640)){
var child_34643 = chunk__33553_34639.cljs$core$IIndexed$_nth$arity$2(null,i__33555_34641);
if(cljs.core.truth_(child_34643)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34643);


var G__34645 = seq__33551_34638;
var G__34646 = chunk__33553_34639;
var G__34647 = count__33554_34640;
var G__34648 = (i__33555_34641 + (1));
seq__33551_34638 = G__34645;
chunk__33553_34639 = G__34646;
count__33554_34640 = G__34647;
i__33555_34641 = G__34648;
continue;
} else {
var G__34649 = seq__33551_34638;
var G__34650 = chunk__33553_34639;
var G__34651 = count__33554_34640;
var G__34652 = (i__33555_34641 + (1));
seq__33551_34638 = G__34649;
chunk__33553_34639 = G__34650;
count__33554_34640 = G__34651;
i__33555_34641 = G__34652;
continue;
}
} else {
var temp__5804__auto___34653 = cljs.core.seq(seq__33551_34638);
if(temp__5804__auto___34653){
var seq__33551_34654__$1 = temp__5804__auto___34653;
if(cljs.core.chunked_seq_QMARK_(seq__33551_34654__$1)){
var c__4679__auto___34655 = cljs.core.chunk_first(seq__33551_34654__$1);
var G__34656 = cljs.core.chunk_rest(seq__33551_34654__$1);
var G__34657 = c__4679__auto___34655;
var G__34658 = cljs.core.count(c__4679__auto___34655);
var G__34659 = (0);
seq__33551_34638 = G__34656;
chunk__33553_34639 = G__34657;
count__33554_34640 = G__34658;
i__33555_34641 = G__34659;
continue;
} else {
var child_34660 = cljs.core.first(seq__33551_34654__$1);
if(cljs.core.truth_(child_34660)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34660);


var G__34661 = cljs.core.next(seq__33551_34654__$1);
var G__34662 = null;
var G__34663 = (0);
var G__34664 = (0);
seq__33551_34638 = G__34661;
chunk__33553_34639 = G__34662;
count__33554_34640 = G__34663;
i__33555_34641 = G__34664;
continue;
} else {
var G__34665 = cljs.core.next(seq__33551_34654__$1);
var G__34666 = null;
var G__34667 = (0);
var G__34668 = (0);
seq__33551_34638 = G__34665;
chunk__33553_34639 = G__34666;
count__33554_34640 = G__34667;
i__33555_34641 = G__34668;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34637);
}


var G__34669 = seq__33425_34632;
var G__34670 = chunk__33427_34633;
var G__34671 = count__33428_34634;
var G__34672 = (i__33429_34635 + (1));
seq__33425_34632 = G__34669;
chunk__33427_34633 = G__34670;
count__33428_34634 = G__34671;
i__33429_34635 = G__34672;
continue;
} else {
var temp__5804__auto___34673 = cljs.core.seq(seq__33425_34632);
if(temp__5804__auto___34673){
var seq__33425_34674__$1 = temp__5804__auto___34673;
if(cljs.core.chunked_seq_QMARK_(seq__33425_34674__$1)){
var c__4679__auto___34675 = cljs.core.chunk_first(seq__33425_34674__$1);
var G__34676 = cljs.core.chunk_rest(seq__33425_34674__$1);
var G__34677 = c__4679__auto___34675;
var G__34678 = cljs.core.count(c__4679__auto___34675);
var G__34679 = (0);
seq__33425_34632 = G__34676;
chunk__33427_34633 = G__34677;
count__33428_34634 = G__34678;
i__33429_34635 = G__34679;
continue;
} else {
var child_struct_34681 = cljs.core.first(seq__33425_34674__$1);
var children_34682 = shadow.dom.dom_node(child_struct_34681);
if(cljs.core.seq_QMARK_(children_34682)){
var seq__33581_34683 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34682));
var chunk__33583_34684 = null;
var count__33584_34685 = (0);
var i__33585_34686 = (0);
while(true){
if((i__33585_34686 < count__33584_34685)){
var child_34687 = chunk__33583_34684.cljs$core$IIndexed$_nth$arity$2(null,i__33585_34686);
if(cljs.core.truth_(child_34687)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34687);


var G__34692 = seq__33581_34683;
var G__34693 = chunk__33583_34684;
var G__34694 = count__33584_34685;
var G__34695 = (i__33585_34686 + (1));
seq__33581_34683 = G__34692;
chunk__33583_34684 = G__34693;
count__33584_34685 = G__34694;
i__33585_34686 = G__34695;
continue;
} else {
var G__34696 = seq__33581_34683;
var G__34697 = chunk__33583_34684;
var G__34698 = count__33584_34685;
var G__34699 = (i__33585_34686 + (1));
seq__33581_34683 = G__34696;
chunk__33583_34684 = G__34697;
count__33584_34685 = G__34698;
i__33585_34686 = G__34699;
continue;
}
} else {
var temp__5804__auto___34700__$1 = cljs.core.seq(seq__33581_34683);
if(temp__5804__auto___34700__$1){
var seq__33581_34701__$1 = temp__5804__auto___34700__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33581_34701__$1)){
var c__4679__auto___34702 = cljs.core.chunk_first(seq__33581_34701__$1);
var G__34703 = cljs.core.chunk_rest(seq__33581_34701__$1);
var G__34704 = c__4679__auto___34702;
var G__34705 = cljs.core.count(c__4679__auto___34702);
var G__34706 = (0);
seq__33581_34683 = G__34703;
chunk__33583_34684 = G__34704;
count__33584_34685 = G__34705;
i__33585_34686 = G__34706;
continue;
} else {
var child_34707 = cljs.core.first(seq__33581_34701__$1);
if(cljs.core.truth_(child_34707)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34707);


var G__34708 = cljs.core.next(seq__33581_34701__$1);
var G__34709 = null;
var G__34710 = (0);
var G__34711 = (0);
seq__33581_34683 = G__34708;
chunk__33583_34684 = G__34709;
count__33584_34685 = G__34710;
i__33585_34686 = G__34711;
continue;
} else {
var G__34712 = cljs.core.next(seq__33581_34701__$1);
var G__34713 = null;
var G__34714 = (0);
var G__34715 = (0);
seq__33581_34683 = G__34712;
chunk__33583_34684 = G__34713;
count__33584_34685 = G__34714;
i__33585_34686 = G__34715;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34682);
}


var G__34716 = cljs.core.next(seq__33425_34674__$1);
var G__34717 = null;
var G__34718 = (0);
var G__34719 = (0);
seq__33425_34632 = G__34716;
chunk__33427_34633 = G__34717;
count__33428_34634 = G__34718;
i__33429_34635 = G__34719;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__33641 = cljs.core.seq(node);
var chunk__33642 = null;
var count__33643 = (0);
var i__33644 = (0);
while(true){
if((i__33644 < count__33643)){
var n = chunk__33642.cljs$core$IIndexed$_nth$arity$2(null,i__33644);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34723 = seq__33641;
var G__34724 = chunk__33642;
var G__34725 = count__33643;
var G__34726 = (i__33644 + (1));
seq__33641 = G__34723;
chunk__33642 = G__34724;
count__33643 = G__34725;
i__33644 = G__34726;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33641);
if(temp__5804__auto__){
var seq__33641__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33641__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33641__$1);
var G__34727 = cljs.core.chunk_rest(seq__33641__$1);
var G__34728 = c__4679__auto__;
var G__34729 = cljs.core.count(c__4679__auto__);
var G__34730 = (0);
seq__33641 = G__34727;
chunk__33642 = G__34728;
count__33643 = G__34729;
i__33644 = G__34730;
continue;
} else {
var n = cljs.core.first(seq__33641__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34731 = cljs.core.next(seq__33641__$1);
var G__34732 = null;
var G__34733 = (0);
var G__34734 = (0);
seq__33641 = G__34731;
chunk__33642 = G__34732;
count__33643 = G__34733;
i__33644 = G__34734;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__33693 = arguments.length;
switch (G__33693) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__33708 = arguments.length;
switch (G__33708) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__33720 = arguments.length;
switch (G__33720) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___34756 = arguments.length;
var i__4865__auto___34757 = (0);
while(true){
if((i__4865__auto___34757 < len__4864__auto___34756)){
args__4870__auto__.push((arguments[i__4865__auto___34757]));

var G__34758 = (i__4865__auto___34757 + (1));
i__4865__auto___34757 = G__34758;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__33756_34766 = cljs.core.seq(nodes);
var chunk__33757_34767 = null;
var count__33758_34768 = (0);
var i__33759_34769 = (0);
while(true){
if((i__33759_34769 < count__33758_34768)){
var node_34770 = chunk__33757_34767.cljs$core$IIndexed$_nth$arity$2(null,i__33759_34769);
fragment.appendChild(shadow.dom._to_dom(node_34770));


var G__34771 = seq__33756_34766;
var G__34772 = chunk__33757_34767;
var G__34773 = count__33758_34768;
var G__34774 = (i__33759_34769 + (1));
seq__33756_34766 = G__34771;
chunk__33757_34767 = G__34772;
count__33758_34768 = G__34773;
i__33759_34769 = G__34774;
continue;
} else {
var temp__5804__auto___34775 = cljs.core.seq(seq__33756_34766);
if(temp__5804__auto___34775){
var seq__33756_34776__$1 = temp__5804__auto___34775;
if(cljs.core.chunked_seq_QMARK_(seq__33756_34776__$1)){
var c__4679__auto___34777 = cljs.core.chunk_first(seq__33756_34776__$1);
var G__34778 = cljs.core.chunk_rest(seq__33756_34776__$1);
var G__34779 = c__4679__auto___34777;
var G__34780 = cljs.core.count(c__4679__auto___34777);
var G__34781 = (0);
seq__33756_34766 = G__34778;
chunk__33757_34767 = G__34779;
count__33758_34768 = G__34780;
i__33759_34769 = G__34781;
continue;
} else {
var node_34782 = cljs.core.first(seq__33756_34776__$1);
fragment.appendChild(shadow.dom._to_dom(node_34782));


var G__34783 = cljs.core.next(seq__33756_34776__$1);
var G__34784 = null;
var G__34785 = (0);
var G__34786 = (0);
seq__33756_34766 = G__34783;
chunk__33757_34767 = G__34784;
count__33758_34768 = G__34785;
i__33759_34769 = G__34786;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq33749){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33749));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__33774_34787 = cljs.core.seq(scripts);
var chunk__33775_34788 = null;
var count__33776_34789 = (0);
var i__33777_34790 = (0);
while(true){
if((i__33777_34790 < count__33776_34789)){
var vec__33790_34795 = chunk__33775_34788.cljs$core$IIndexed$_nth$arity$2(null,i__33777_34790);
var script_tag_34796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33790_34795,(0),null);
var script_body_34797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33790_34795,(1),null);
eval(script_body_34797);


var G__34799 = seq__33774_34787;
var G__34800 = chunk__33775_34788;
var G__34801 = count__33776_34789;
var G__34802 = (i__33777_34790 + (1));
seq__33774_34787 = G__34799;
chunk__33775_34788 = G__34800;
count__33776_34789 = G__34801;
i__33777_34790 = G__34802;
continue;
} else {
var temp__5804__auto___34803 = cljs.core.seq(seq__33774_34787);
if(temp__5804__auto___34803){
var seq__33774_34804__$1 = temp__5804__auto___34803;
if(cljs.core.chunked_seq_QMARK_(seq__33774_34804__$1)){
var c__4679__auto___34805 = cljs.core.chunk_first(seq__33774_34804__$1);
var G__34806 = cljs.core.chunk_rest(seq__33774_34804__$1);
var G__34807 = c__4679__auto___34805;
var G__34808 = cljs.core.count(c__4679__auto___34805);
var G__34809 = (0);
seq__33774_34787 = G__34806;
chunk__33775_34788 = G__34807;
count__33776_34789 = G__34808;
i__33777_34790 = G__34809;
continue;
} else {
var vec__33797_34810 = cljs.core.first(seq__33774_34804__$1);
var script_tag_34811 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33797_34810,(0),null);
var script_body_34812 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33797_34810,(1),null);
eval(script_body_34812);


var G__34813 = cljs.core.next(seq__33774_34804__$1);
var G__34814 = null;
var G__34815 = (0);
var G__34816 = (0);
seq__33774_34787 = G__34813;
chunk__33775_34788 = G__34814;
count__33776_34789 = G__34815;
i__33777_34790 = G__34816;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__33802){
var vec__33804 = p__33802;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33804,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33804,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__33819 = arguments.length;
switch (G__33819) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__33885 = cljs.core.seq(style_keys);
var chunk__33886 = null;
var count__33887 = (0);
var i__33888 = (0);
while(true){
if((i__33888 < count__33887)){
var it = chunk__33886.cljs$core$IIndexed$_nth$arity$2(null,i__33888);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34830 = seq__33885;
var G__34831 = chunk__33886;
var G__34832 = count__33887;
var G__34833 = (i__33888 + (1));
seq__33885 = G__34830;
chunk__33886 = G__34831;
count__33887 = G__34832;
i__33888 = G__34833;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33885);
if(temp__5804__auto__){
var seq__33885__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33885__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__33885__$1);
var G__34834 = cljs.core.chunk_rest(seq__33885__$1);
var G__34835 = c__4679__auto__;
var G__34836 = cljs.core.count(c__4679__auto__);
var G__34837 = (0);
seq__33885 = G__34834;
chunk__33886 = G__34835;
count__33887 = G__34836;
i__33888 = G__34837;
continue;
} else {
var it = cljs.core.first(seq__33885__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__34838 = cljs.core.next(seq__33885__$1);
var G__34839 = null;
var G__34840 = (0);
var G__34841 = (0);
seq__33885 = G__34838;
chunk__33886 = G__34839;
count__33887 = G__34840;
i__33888 = G__34841;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k33917,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__33966 = k33917;
var G__33966__$1 = (((G__33966 instanceof cljs.core.Keyword))?G__33966.fqn:null);
switch (G__33966__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33917,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__33972){
var vec__33975 = p__33972;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33975,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33975,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33916){
var self__ = this;
var G__33916__$1 = this;
return (new cljs.core.RecordIter((0),G__33916__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33918,other33919){
var self__ = this;
var this33918__$1 = this;
return (((!((other33919 == null)))) && ((((this33918__$1.constructor === other33919.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33918__$1.x,other33919.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33918__$1.y,other33919.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33918__$1.__extmap,other33919.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k33917){
var self__ = this;
var this__4509__auto____$1 = this;
var G__34039 = k33917;
var G__34039__$1 = (((G__34039 instanceof cljs.core.Keyword))?G__34039.fqn:null);
switch (G__34039__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k33917);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__33916){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__34045 = cljs.core.keyword_identical_QMARK_;
var expr__34046 = k__4511__auto__;
if(cljs.core.truth_((pred__34045.cljs$core$IFn$_invoke$arity$2 ? pred__34045.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__34046) : pred__34045.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__34046)))){
return (new shadow.dom.Coordinate(G__33916,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34045.cljs$core$IFn$_invoke$arity$2 ? pred__34045.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__34046) : pred__34045.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__34046)))){
return (new shadow.dom.Coordinate(self__.x,G__33916,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__33916),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__33916){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__33916,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__33932){
var extmap__4542__auto__ = (function (){var G__34075 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33932,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__33932)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34075);
} else {
return G__34075;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__33932),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__33932),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k34105,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__34138 = k34105;
var G__34138__$1 = (((G__34138 instanceof cljs.core.Keyword))?G__34138.fqn:null);
switch (G__34138__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34105,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__34155){
var vec__34157 = p__34155;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34157,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34157,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34104){
var self__ = this;
var G__34104__$1 = this;
return (new cljs.core.RecordIter((0),G__34104__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34106,other34107){
var self__ = this;
var this34106__$1 = this;
return (((!((other34107 == null)))) && ((((this34106__$1.constructor === other34107.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34106__$1.w,other34107.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34106__$1.h,other34107.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34106__$1.__extmap,other34107.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k34105){
var self__ = this;
var this__4509__auto____$1 = this;
var G__34253 = k34105;
var G__34253__$1 = (((G__34253 instanceof cljs.core.Keyword))?G__34253.fqn:null);
switch (G__34253__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34105);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__34104){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__34255 = cljs.core.keyword_identical_QMARK_;
var expr__34256 = k__4511__auto__;
if(cljs.core.truth_((pred__34255.cljs$core$IFn$_invoke$arity$2 ? pred__34255.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__34256) : pred__34255.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__34256)))){
return (new shadow.dom.Size(G__34104,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34255.cljs$core$IFn$_invoke$arity$2 ? pred__34255.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__34256) : pred__34255.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__34256)))){
return (new shadow.dom.Size(self__.w,G__34104,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__34104),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__34104){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__34104,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__34114){
var extmap__4542__auto__ = (function (){var G__34306 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34114,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__34114)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34306);
} else {
return G__34306;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__34114),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__34114),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__34977 = (i + (1));
var G__34978 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__34977;
ret = G__34978;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34396){
var vec__34397 = p__34396;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34397,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34397,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__34406 = arguments.length;
switch (G__34406) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__34988 = ps;
var G__34989 = (i + (1));
el__$1 = G__34988;
i = G__34989;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__34441 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34441,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34441,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34441,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__34445_34993 = cljs.core.seq(props);
var chunk__34446_34994 = null;
var count__34447_34995 = (0);
var i__34448_34996 = (0);
while(true){
if((i__34448_34996 < count__34447_34995)){
var vec__34458_34997 = chunk__34446_34994.cljs$core$IIndexed$_nth$arity$2(null,i__34448_34996);
var k_34998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34458_34997,(0),null);
var v_34999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34458_34997,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_34998);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_34998),v_34999);


var G__35001 = seq__34445_34993;
var G__35002 = chunk__34446_34994;
var G__35003 = count__34447_34995;
var G__35004 = (i__34448_34996 + (1));
seq__34445_34993 = G__35001;
chunk__34446_34994 = G__35002;
count__34447_34995 = G__35003;
i__34448_34996 = G__35004;
continue;
} else {
var temp__5804__auto___35005 = cljs.core.seq(seq__34445_34993);
if(temp__5804__auto___35005){
var seq__34445_35006__$1 = temp__5804__auto___35005;
if(cljs.core.chunked_seq_QMARK_(seq__34445_35006__$1)){
var c__4679__auto___35009 = cljs.core.chunk_first(seq__34445_35006__$1);
var G__35014 = cljs.core.chunk_rest(seq__34445_35006__$1);
var G__35015 = c__4679__auto___35009;
var G__35016 = cljs.core.count(c__4679__auto___35009);
var G__35017 = (0);
seq__34445_34993 = G__35014;
chunk__34446_34994 = G__35015;
count__34447_34995 = G__35016;
i__34448_34996 = G__35017;
continue;
} else {
var vec__34464_35018 = cljs.core.first(seq__34445_35006__$1);
var k_35019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34464_35018,(0),null);
var v_35020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34464_35018,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35019);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35019),v_35020);


var G__35028 = cljs.core.next(seq__34445_35006__$1);
var G__35029 = null;
var G__35030 = (0);
var G__35031 = (0);
seq__34445_34993 = G__35028;
chunk__34446_34994 = G__35029;
count__34447_34995 = G__35030;
i__34448_34996 = G__35031;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__34469 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34469,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34469,(1),null);
var seq__34472_35032 = cljs.core.seq(node_children);
var chunk__34474_35033 = null;
var count__34475_35034 = (0);
var i__34476_35035 = (0);
while(true){
if((i__34476_35035 < count__34475_35034)){
var child_struct_35036 = chunk__34474_35033.cljs$core$IIndexed$_nth$arity$2(null,i__34476_35035);
if((!((child_struct_35036 == null)))){
if(typeof child_struct_35036 === 'string'){
var text_35037 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35037),child_struct_35036].join(''));
} else {
var children_35043 = shadow.dom.svg_node(child_struct_35036);
if(cljs.core.seq_QMARK_(children_35043)){
var seq__34514_35044 = cljs.core.seq(children_35043);
var chunk__34517_35045 = null;
var count__34518_35046 = (0);
var i__34519_35047 = (0);
while(true){
if((i__34519_35047 < count__34518_35046)){
var child_35054 = chunk__34517_35045.cljs$core$IIndexed$_nth$arity$2(null,i__34519_35047);
if(cljs.core.truth_(child_35054)){
node.appendChild(child_35054);


var G__35055 = seq__34514_35044;
var G__35056 = chunk__34517_35045;
var G__35057 = count__34518_35046;
var G__35058 = (i__34519_35047 + (1));
seq__34514_35044 = G__35055;
chunk__34517_35045 = G__35056;
count__34518_35046 = G__35057;
i__34519_35047 = G__35058;
continue;
} else {
var G__35059 = seq__34514_35044;
var G__35060 = chunk__34517_35045;
var G__35061 = count__34518_35046;
var G__35062 = (i__34519_35047 + (1));
seq__34514_35044 = G__35059;
chunk__34517_35045 = G__35060;
count__34518_35046 = G__35061;
i__34519_35047 = G__35062;
continue;
}
} else {
var temp__5804__auto___35063 = cljs.core.seq(seq__34514_35044);
if(temp__5804__auto___35063){
var seq__34514_35069__$1 = temp__5804__auto___35063;
if(cljs.core.chunked_seq_QMARK_(seq__34514_35069__$1)){
var c__4679__auto___35070 = cljs.core.chunk_first(seq__34514_35069__$1);
var G__35071 = cljs.core.chunk_rest(seq__34514_35069__$1);
var G__35072 = c__4679__auto___35070;
var G__35073 = cljs.core.count(c__4679__auto___35070);
var G__35074 = (0);
seq__34514_35044 = G__35071;
chunk__34517_35045 = G__35072;
count__34518_35046 = G__35073;
i__34519_35047 = G__35074;
continue;
} else {
var child_35075 = cljs.core.first(seq__34514_35069__$1);
if(cljs.core.truth_(child_35075)){
node.appendChild(child_35075);


var G__35076 = cljs.core.next(seq__34514_35069__$1);
var G__35077 = null;
var G__35078 = (0);
var G__35079 = (0);
seq__34514_35044 = G__35076;
chunk__34517_35045 = G__35077;
count__34518_35046 = G__35078;
i__34519_35047 = G__35079;
continue;
} else {
var G__35084 = cljs.core.next(seq__34514_35069__$1);
var G__35085 = null;
var G__35086 = (0);
var G__35087 = (0);
seq__34514_35044 = G__35084;
chunk__34517_35045 = G__35085;
count__34518_35046 = G__35086;
i__34519_35047 = G__35087;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35043);
}
}


var G__35088 = seq__34472_35032;
var G__35089 = chunk__34474_35033;
var G__35090 = count__34475_35034;
var G__35091 = (i__34476_35035 + (1));
seq__34472_35032 = G__35088;
chunk__34474_35033 = G__35089;
count__34475_35034 = G__35090;
i__34476_35035 = G__35091;
continue;
} else {
var G__35092 = seq__34472_35032;
var G__35093 = chunk__34474_35033;
var G__35094 = count__34475_35034;
var G__35095 = (i__34476_35035 + (1));
seq__34472_35032 = G__35092;
chunk__34474_35033 = G__35093;
count__34475_35034 = G__35094;
i__34476_35035 = G__35095;
continue;
}
} else {
var temp__5804__auto___35096 = cljs.core.seq(seq__34472_35032);
if(temp__5804__auto___35096){
var seq__34472_35101__$1 = temp__5804__auto___35096;
if(cljs.core.chunked_seq_QMARK_(seq__34472_35101__$1)){
var c__4679__auto___35102 = cljs.core.chunk_first(seq__34472_35101__$1);
var G__35103 = cljs.core.chunk_rest(seq__34472_35101__$1);
var G__35104 = c__4679__auto___35102;
var G__35105 = cljs.core.count(c__4679__auto___35102);
var G__35106 = (0);
seq__34472_35032 = G__35103;
chunk__34474_35033 = G__35104;
count__34475_35034 = G__35105;
i__34476_35035 = G__35106;
continue;
} else {
var child_struct_35107 = cljs.core.first(seq__34472_35101__$1);
if((!((child_struct_35107 == null)))){
if(typeof child_struct_35107 === 'string'){
var text_35108 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35108),child_struct_35107].join(''));
} else {
var children_35109 = shadow.dom.svg_node(child_struct_35107);
if(cljs.core.seq_QMARK_(children_35109)){
var seq__34533_35110 = cljs.core.seq(children_35109);
var chunk__34535_35111 = null;
var count__34536_35112 = (0);
var i__34537_35113 = (0);
while(true){
if((i__34537_35113 < count__34536_35112)){
var child_35114 = chunk__34535_35111.cljs$core$IIndexed$_nth$arity$2(null,i__34537_35113);
if(cljs.core.truth_(child_35114)){
node.appendChild(child_35114);


var G__35115 = seq__34533_35110;
var G__35116 = chunk__34535_35111;
var G__35117 = count__34536_35112;
var G__35118 = (i__34537_35113 + (1));
seq__34533_35110 = G__35115;
chunk__34535_35111 = G__35116;
count__34536_35112 = G__35117;
i__34537_35113 = G__35118;
continue;
} else {
var G__35119 = seq__34533_35110;
var G__35120 = chunk__34535_35111;
var G__35121 = count__34536_35112;
var G__35122 = (i__34537_35113 + (1));
seq__34533_35110 = G__35119;
chunk__34535_35111 = G__35120;
count__34536_35112 = G__35121;
i__34537_35113 = G__35122;
continue;
}
} else {
var temp__5804__auto___35123__$1 = cljs.core.seq(seq__34533_35110);
if(temp__5804__auto___35123__$1){
var seq__34533_35124__$1 = temp__5804__auto___35123__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34533_35124__$1)){
var c__4679__auto___35125 = cljs.core.chunk_first(seq__34533_35124__$1);
var G__35131 = cljs.core.chunk_rest(seq__34533_35124__$1);
var G__35132 = c__4679__auto___35125;
var G__35133 = cljs.core.count(c__4679__auto___35125);
var G__35134 = (0);
seq__34533_35110 = G__35131;
chunk__34535_35111 = G__35132;
count__34536_35112 = G__35133;
i__34537_35113 = G__35134;
continue;
} else {
var child_35135 = cljs.core.first(seq__34533_35124__$1);
if(cljs.core.truth_(child_35135)){
node.appendChild(child_35135);


var G__35136 = cljs.core.next(seq__34533_35124__$1);
var G__35137 = null;
var G__35138 = (0);
var G__35139 = (0);
seq__34533_35110 = G__35136;
chunk__34535_35111 = G__35137;
count__34536_35112 = G__35138;
i__34537_35113 = G__35139;
continue;
} else {
var G__35140 = cljs.core.next(seq__34533_35124__$1);
var G__35141 = null;
var G__35142 = (0);
var G__35143 = (0);
seq__34533_35110 = G__35140;
chunk__34535_35111 = G__35141;
count__34536_35112 = G__35142;
i__34537_35113 = G__35143;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35109);
}
}


var G__35144 = cljs.core.next(seq__34472_35101__$1);
var G__35145 = null;
var G__35146 = (0);
var G__35147 = (0);
seq__34472_35032 = G__35144;
chunk__34474_35033 = G__35145;
count__34475_35034 = G__35146;
i__34476_35035 = G__35147;
continue;
} else {
var G__35148 = cljs.core.next(seq__34472_35101__$1);
var G__35149 = null;
var G__35150 = (0);
var G__35151 = (0);
seq__34472_35032 = G__35148;
chunk__34474_35033 = G__35149;
count__34475_35034 = G__35150;
i__34476_35035 = G__35151;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___35156 = arguments.length;
var i__4865__auto___35159 = (0);
while(true){
if((i__4865__auto___35159 < len__4864__auto___35156)){
args__4870__auto__.push((arguments[i__4865__auto___35159]));

var G__35160 = (i__4865__auto___35159 + (1));
i__4865__auto___35159 = G__35160;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq34540){
var G__34541 = cljs.core.first(seq34540);
var seq34540__$1 = cljs.core.next(seq34540);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34541,seq34540__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__34550 = arguments.length;
switch (G__34550) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__29281__auto___35195 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__29282__auto__ = (function (){var switch__28977__auto__ = (function (state_34556){
var state_val_34557 = (state_34556[(1)]);
if((state_val_34557 === (1))){
var state_34556__$1 = state_34556;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34556__$1,(2),once_or_cleanup);
} else {
if((state_val_34557 === (2))){
var inst_34553 = (state_34556[(2)]);
var inst_34554 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_34556__$1 = (function (){var statearr_34558 = state_34556;
(statearr_34558[(7)] = inst_34553);

return statearr_34558;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34556__$1,inst_34554);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__28978__auto__ = null;
var shadow$dom$state_machine__28978__auto____0 = (function (){
var statearr_34559 = [null,null,null,null,null,null,null,null];
(statearr_34559[(0)] = shadow$dom$state_machine__28978__auto__);

(statearr_34559[(1)] = (1));

return statearr_34559;
});
var shadow$dom$state_machine__28978__auto____1 = (function (state_34556){
while(true){
var ret_value__28979__auto__ = (function (){try{while(true){
var result__28980__auto__ = switch__28977__auto__(state_34556);
if(cljs.core.keyword_identical_QMARK_(result__28980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28980__auto__;
}
break;
}
}catch (e34560){var ex__28981__auto__ = e34560;
var statearr_34561_35206 = state_34556;
(statearr_34561_35206[(2)] = ex__28981__auto__);


if(cljs.core.seq((state_34556[(4)]))){
var statearr_34562_35208 = state_34556;
(statearr_34562_35208[(1)] = cljs.core.first((state_34556[(4)])));

} else {
throw ex__28981__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35217 = state_34556;
state_34556 = G__35217;
continue;
} else {
return ret_value__28979__auto__;
}
break;
}
});
shadow$dom$state_machine__28978__auto__ = function(state_34556){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__28978__auto____0.call(this);
case 1:
return shadow$dom$state_machine__28978__auto____1.call(this,state_34556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__28978__auto____0;
shadow$dom$state_machine__28978__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__28978__auto____1;
return shadow$dom$state_machine__28978__auto__;
})()
})();
var state__29283__auto__ = (function (){var statearr_34563 = f__29282__auto__();
(statearr_34563[(6)] = c__29281__auto___35195);

return statearr_34563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__29283__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
