goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__53756){
var vec__53757 = p__53756;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53757,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53757,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__53760 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__53760__$1 = (((G__53760 instanceof cljs.core.Keyword))?G__53760.fqn:null);
switch (G__53760__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__53768 = (function (){
var seq__53769 = cljs.core.seq(vars__$1);
var chunk__53770 = null;
var count__53771 = (0);
var i__53772 = (0);
while(true){
if((i__53772 < count__53771)){
var v = chunk__53770.cljs$core$IIndexed$_nth$arity$2(null,i__53772);
var temp__5804__auto___53898 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___53898)){
var t_53899 = temp__5804__auto___53898;
var G__53787_53900 = ((function (seq__53769,chunk__53770,count__53771,i__53772,t_53899,temp__5804__auto___53898,v,each_fixture_fn,G__53760,G__53760__$1,env,once_fixtures,each_fixtures,vec__53757,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_53899)));
});})(seq__53769,chunk__53770,count__53771,i__53772,t_53899,temp__5804__auto___53898,v,each_fixture_fn,G__53760,G__53760__$1,env,once_fixtures,each_fixtures,vec__53757,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__53787_53900) : each_fixture_fn.call(null,G__53787_53900));
} else {
}


var G__53906 = seq__53769;
var G__53907 = chunk__53770;
var G__53908 = count__53771;
var G__53909 = (i__53772 + (1));
seq__53769 = G__53906;
chunk__53770 = G__53907;
count__53771 = G__53908;
i__53772 = G__53909;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__53769);
if(temp__5804__auto__){
var seq__53769__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53769__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__53769__$1);
var G__53912 = cljs.core.chunk_rest(seq__53769__$1);
var G__53913 = c__4679__auto__;
var G__53914 = cljs.core.count(c__4679__auto__);
var G__53915 = (0);
seq__53769 = G__53912;
chunk__53770 = G__53913;
count__53771 = G__53914;
i__53772 = G__53915;
continue;
} else {
var v = cljs.core.first(seq__53769__$1);
var temp__5804__auto___53916__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___53916__$1)){
var t_53917 = temp__5804__auto___53916__$1;
var G__53793_53918 = ((function (seq__53769,chunk__53770,count__53771,i__53772,t_53917,temp__5804__auto___53916__$1,v,seq__53769__$1,temp__5804__auto__,each_fixture_fn,G__53760,G__53760__$1,env,once_fixtures,each_fixtures,vec__53757,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_53917)));
});})(seq__53769,chunk__53770,count__53771,i__53772,t_53917,temp__5804__auto___53916__$1,v,seq__53769__$1,temp__5804__auto__,each_fixture_fn,G__53760,G__53760__$1,env,once_fixtures,each_fixtures,vec__53757,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__53793_53918) : each_fixture_fn.call(null,G__53793_53918));
} else {
}


var G__53920 = cljs.core.next(seq__53769__$1);
var G__53921 = null;
var G__53922 = (0);
var G__53923 = (0);
seq__53769 = G__53920;
chunk__53770 = G__53921;
count__53771 = G__53922;
i__53772 = G__53923;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__53767 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__53767.cljs$core$IFn$_invoke$arity$1 ? fexpr__53767.cljs$core$IFn$_invoke$arity$1(G__53768) : fexpr__53767.call(null,G__53768));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__53760__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__53749_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53749_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__53801 = shadow.test.env.get_test_ns_info(ns);
var map__53801__$1 = cljs.core.__destructure_map(map__53801);
var test_ns = map__53801__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53801__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__53808,vars){
var map__53811 = p__53808;
var map__53811__$1 = cljs.core.__destructure_map(map__53811);
var env = map__53811__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53811__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__53812_53935 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__53814_53936 = null;
var count__53815_53937 = (0);
var i__53816_53938 = (0);
while(true){
if((i__53816_53938 < count__53815_53937)){
var vec__53838_53939 = chunk__53814_53936.cljs$core$IIndexed$_nth$arity$2(null,i__53816_53938);
var test_ns_53940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53838_53939,(0),null);
var ns_info_53941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53838_53939,(1),null);
var map__53841_53943 = ns_info_53941;
var map__53841_53944__$1 = cljs.core.__destructure_map(map__53841_53943);
var fixtures_53945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53841_53944__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___53946 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_53945);
if(cljs.core.truth_(temp__5804__auto___53946)){
var fix_53947 = temp__5804__auto___53946;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53940,fix_53947], 0));
} else {
}

var temp__5804__auto___53948 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_53945);
if(cljs.core.truth_(temp__5804__auto___53948)){
var fix_53951 = temp__5804__auto___53948;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53940,fix_53951], 0));
} else {
}


var G__53952 = seq__53812_53935;
var G__53953 = chunk__53814_53936;
var G__53954 = count__53815_53937;
var G__53955 = (i__53816_53938 + (1));
seq__53812_53935 = G__53952;
chunk__53814_53936 = G__53953;
count__53815_53937 = G__53954;
i__53816_53938 = G__53955;
continue;
} else {
var temp__5804__auto___53957 = cljs.core.seq(seq__53812_53935);
if(temp__5804__auto___53957){
var seq__53812_53959__$1 = temp__5804__auto___53957;
if(cljs.core.chunked_seq_QMARK_(seq__53812_53959__$1)){
var c__4679__auto___53961 = cljs.core.chunk_first(seq__53812_53959__$1);
var G__53963 = cljs.core.chunk_rest(seq__53812_53959__$1);
var G__53964 = c__4679__auto___53961;
var G__53965 = cljs.core.count(c__4679__auto___53961);
var G__53966 = (0);
seq__53812_53935 = G__53963;
chunk__53814_53936 = G__53964;
count__53815_53937 = G__53965;
i__53816_53938 = G__53966;
continue;
} else {
var vec__53848_53967 = cljs.core.first(seq__53812_53959__$1);
var test_ns_53968 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53848_53967,(0),null);
var ns_info_53969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53848_53967,(1),null);
var map__53851_53970 = ns_info_53969;
var map__53851_53971__$1 = cljs.core.__destructure_map(map__53851_53970);
var fixtures_53972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53851_53971__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___53973__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_53972);
if(cljs.core.truth_(temp__5804__auto___53973__$1)){
var fix_53975 = temp__5804__auto___53973__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53968,fix_53975], 0));
} else {
}

var temp__5804__auto___53981__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_53972);
if(cljs.core.truth_(temp__5804__auto___53981__$1)){
var fix_53982 = temp__5804__auto___53981__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_53968,fix_53982], 0));
} else {
}


var G__53983 = cljs.core.next(seq__53812_53959__$1);
var G__53984 = null;
var G__53985 = (0);
var G__53986 = (0);
seq__53812_53935 = G__53983;
chunk__53814_53936 = G__53984;
count__53815_53937 = G__53985;
i__53816_53938 = G__53986;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__53803_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53803_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__53859 = cljs.test.get_current_env();
var map__53859__$1 = cljs.core.__destructure_map(map__53859);
var env = map__53859__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53859__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53859__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__53867 = arguments.length;
switch (G__53867) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__53869 = arguments.length;
switch (G__53869) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__53870 = shadow.test.env.get_test_ns_info(ns);
var map__53870__$1 = cljs.core.__destructure_map(map__53870);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53870__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__53873 = arguments.length;
switch (G__53873) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__53871_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__53871_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__53876 = arguments.length;
switch (G__53876) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__53874_SHARP_){
var or__4253__auto__ = (re == null);
if(or__4253__auto__){
return or__4253__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__53874_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
