goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30431 = arguments.length;
switch (G__30431) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30437 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30437 = (function (f,blockable,meta30438){
this.f = f;
this.blockable = blockable;
this.meta30438 = meta30438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30439,meta30438__$1){
var self__ = this;
var _30439__$1 = this;
return (new cljs.core.async.t_cljs$core$async30437(self__.f,self__.blockable,meta30438__$1));
}));

(cljs.core.async.t_cljs$core$async30437.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30439){
var self__ = this;
var _30439__$1 = this;
return self__.meta30438;
}));

(cljs.core.async.t_cljs$core$async30437.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30437.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30437.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30437.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30437.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30438","meta30438",-1430827399,null)], null);
}));

(cljs.core.async.t_cljs$core$async30437.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30437.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30437");

(cljs.core.async.t_cljs$core$async30437.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async30437");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30437.
 */
cljs.core.async.__GT_t_cljs$core$async30437 = (function cljs$core$async$__GT_t_cljs$core$async30437(f__$1,blockable__$1,meta30438){
return (new cljs.core.async.t_cljs$core$async30437(f__$1,blockable__$1,meta30438));
});

}

return (new cljs.core.async.t_cljs$core$async30437(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30466 = arguments.length;
switch (G__30466) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30484 = arguments.length;
switch (G__30484) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30490 = arguments.length;
switch (G__30490) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34045 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34045) : fn1.call(null,val_34045));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34045) : fn1.call(null,val_34045));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30504 = arguments.length;
switch (G__30504) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5635__auto___34050 = n;
var x_34051 = (0);
while(true){
if((x_34051 < n__5635__auto___34050)){
(a[x_34051] = x_34051);

var G__34052 = (x_34051 + (1));
x_34051 = G__34052;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30509 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30509 = (function (flag,meta30510){
this.flag = flag;
this.meta30510 = meta30510;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30509.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30511,meta30510__$1){
var self__ = this;
var _30511__$1 = this;
return (new cljs.core.async.t_cljs$core$async30509(self__.flag,meta30510__$1));
}));

(cljs.core.async.t_cljs$core$async30509.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30511){
var self__ = this;
var _30511__$1 = this;
return self__.meta30510;
}));

(cljs.core.async.t_cljs$core$async30509.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30509.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30509.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30509.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30509.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30510","meta30510",1433969704,null)], null);
}));

(cljs.core.async.t_cljs$core$async30509.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30509.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30509");

(cljs.core.async.t_cljs$core$async30509.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async30509");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30509.
 */
cljs.core.async.__GT_t_cljs$core$async30509 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30509(flag__$1,meta30510){
return (new cljs.core.async.t_cljs$core$async30509(flag__$1,meta30510));
});

}

return (new cljs.core.async.t_cljs$core$async30509(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30531 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30531 = (function (flag,cb,meta30532){
this.flag = flag;
this.cb = cb;
this.meta30532 = meta30532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30533,meta30532__$1){
var self__ = this;
var _30533__$1 = this;
return (new cljs.core.async.t_cljs$core$async30531(self__.flag,self__.cb,meta30532__$1));
}));

(cljs.core.async.t_cljs$core$async30531.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30533){
var self__ = this;
var _30533__$1 = this;
return self__.meta30532;
}));

(cljs.core.async.t_cljs$core$async30531.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30531.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30531.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30531.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30531.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30532","meta30532",1779605089,null)], null);
}));

(cljs.core.async.t_cljs$core$async30531.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30531.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30531");

(cljs.core.async.t_cljs$core$async30531.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async30531");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30531.
 */
cljs.core.async.__GT_t_cljs$core$async30531 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30531(flag__$1,cb__$1,meta30532){
return (new cljs.core.async.t_cljs$core$async30531(flag__$1,cb__$1,meta30532));
});

}

return (new cljs.core.async.t_cljs$core$async30531(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30551_SHARP_){
var G__30562 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30551_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30562) : fret.call(null,G__30562));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30553_SHARP_){
var G__30565 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30553_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30565) : fret.call(null,G__30565));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34069 = (i + (1));
i = G__34069;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___34071 = arguments.length;
var i__5769__auto___34072 = (0);
while(true){
if((i__5769__auto___34072 < len__5768__auto___34071)){
args__5774__auto__.push((arguments[i__5769__auto___34072]));

var G__34073 = (i__5769__auto___34072 + (1));
i__5769__auto___34072 = G__34073;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30585){
var map__30586 = p__30585;
var map__30586__$1 = cljs.core.__destructure_map(map__30586);
var opts = map__30586__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30582){
var G__30583 = cljs.core.first(seq30582);
var seq30582__$1 = cljs.core.next(seq30582);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30583,seq30582__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30597 = arguments.length;
switch (G__30597) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30320__auto___34077 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_30648){
var state_val_30649 = (state_30648[(1)]);
if((state_val_30649 === (7))){
var inst_30643 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30656_34079 = state_30648__$1;
(statearr_30656_34079[(2)] = inst_30643);

(statearr_30656_34079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (1))){
var state_30648__$1 = state_30648;
var statearr_30657_34080 = state_30648__$1;
(statearr_30657_34080[(2)] = null);

(statearr_30657_34080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (4))){
var inst_30622 = (state_30648[(7)]);
var inst_30622__$1 = (state_30648[(2)]);
var inst_30623 = (inst_30622__$1 == null);
var state_30648__$1 = (function (){var statearr_30659 = state_30648;
(statearr_30659[(7)] = inst_30622__$1);

return statearr_30659;
})();
if(cljs.core.truth_(inst_30623)){
var statearr_30661_34083 = state_30648__$1;
(statearr_30661_34083[(1)] = (5));

} else {
var statearr_30668_34085 = state_30648__$1;
(statearr_30668_34085[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (13))){
var state_30648__$1 = state_30648;
var statearr_30672_34086 = state_30648__$1;
(statearr_30672_34086[(2)] = null);

(statearr_30672_34086[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (6))){
var inst_30622 = (state_30648[(7)]);
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30648__$1,(11),to,inst_30622);
} else {
if((state_val_30649 === (3))){
var inst_30646 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30648__$1,inst_30646);
} else {
if((state_val_30649 === (12))){
var state_30648__$1 = state_30648;
var statearr_30673_34087 = state_30648__$1;
(statearr_30673_34087[(2)] = null);

(statearr_30673_34087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (2))){
var state_30648__$1 = state_30648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30648__$1,(4),from);
} else {
if((state_val_30649 === (11))){
var inst_30636 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
if(cljs.core.truth_(inst_30636)){
var statearr_30676_34088 = state_30648__$1;
(statearr_30676_34088[(1)] = (12));

} else {
var statearr_30679_34092 = state_30648__$1;
(statearr_30679_34092[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (9))){
var state_30648__$1 = state_30648;
var statearr_30681_34093 = state_30648__$1;
(statearr_30681_34093[(2)] = null);

(statearr_30681_34093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (5))){
var state_30648__$1 = state_30648;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30691_34100 = state_30648__$1;
(statearr_30691_34100[(1)] = (8));

} else {
var statearr_30693_34101 = state_30648__$1;
(statearr_30693_34101[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (14))){
var inst_30641 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30694_34106 = state_30648__$1;
(statearr_30694_34106[(2)] = inst_30641);

(statearr_30694_34106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (10))){
var inst_30633 = (state_30648[(2)]);
var state_30648__$1 = state_30648;
var statearr_30696_34107 = state_30648__$1;
(statearr_30696_34107[(2)] = inst_30633);

(statearr_30696_34107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30649 === (8))){
var inst_30630 = cljs.core.async.close_BANG_(to);
var state_30648__$1 = state_30648;
var statearr_30699_34108 = state_30648__$1;
(statearr_30699_34108[(2)] = inst_30630);

(statearr_30699_34108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_30702 = [null,null,null,null,null,null,null,null];
(statearr_30702[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_30702[(1)] = (1));

return statearr_30702;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_30648){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_30648);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e30703){var ex__29995__auto__ = e30703;
var statearr_30704_34113 = state_30648;
(statearr_30704_34113[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_30648[(4)]))){
var statearr_30708_34114 = state_30648;
(statearr_30708_34114[(1)] = cljs.core.first((state_30648[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34115 = state_30648;
state_30648 = G__34115;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_30648){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_30648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_30713 = f__30321__auto__();
(statearr_30713[(6)] = c__30320__auto___34077);

return statearr_30713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__30728){
var vec__30729 = p__30728;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30729,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30729,(1),null);
var job = vec__30729;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30320__auto___34128 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_30738){
var state_val_30739 = (state_30738[(1)]);
if((state_val_30739 === (1))){
var state_30738__$1 = state_30738;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30738__$1,(2),res,v);
} else {
if((state_val_30739 === (2))){
var inst_30735 = (state_30738[(2)]);
var inst_30736 = cljs.core.async.close_BANG_(res);
var state_30738__$1 = (function (){var statearr_30746 = state_30738;
(statearr_30746[(7)] = inst_30735);

return statearr_30746;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30738__$1,inst_30736);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0 = (function (){
var statearr_30751 = [null,null,null,null,null,null,null,null];
(statearr_30751[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__);

(statearr_30751[(1)] = (1));

return statearr_30751;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1 = (function (state_30738){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_30738);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e30758){var ex__29995__auto__ = e30758;
var statearr_30762_34132 = state_30738;
(statearr_30762_34132[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_30738[(4)]))){
var statearr_30764_34133 = state_30738;
(statearr_30764_34133[(1)] = cljs.core.first((state_30738[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34135 = state_30738;
state_30738 = G__34135;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = function(state_30738){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1.call(this,state_30738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_30769 = f__30321__auto__();
(statearr_30769[(6)] = c__30320__auto___34128);

return statearr_30769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__30771){
var vec__30772 = p__30771;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30772,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30772,(1),null);
var job = vec__30772;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5635__auto___34145 = n;
var __34149 = (0);
while(true){
if((__34149 < n__5635__auto___34145)){
var G__30790_34150 = type;
var G__30790_34151__$1 = (((G__30790_34150 instanceof cljs.core.Keyword))?G__30790_34150.fqn:null);
switch (G__30790_34151__$1) {
case "compute":
var c__30320__auto___34153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34149,c__30320__auto___34153,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async){
return (function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = ((function (__34149,c__30320__auto___34153,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async){
return (function (state_30812){
var state_val_30813 = (state_30812[(1)]);
if((state_val_30813 === (1))){
var state_30812__$1 = state_30812;
var statearr_30827_34154 = state_30812__$1;
(statearr_30827_34154[(2)] = null);

(statearr_30827_34154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30813 === (2))){
var state_30812__$1 = state_30812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30812__$1,(4),jobs);
} else {
if((state_val_30813 === (3))){
var inst_30805 = (state_30812[(2)]);
var state_30812__$1 = state_30812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30812__$1,inst_30805);
} else {
if((state_val_30813 === (4))){
var inst_30796 = (state_30812[(2)]);
var inst_30798 = process__$1(inst_30796);
var state_30812__$1 = state_30812;
if(cljs.core.truth_(inst_30798)){
var statearr_30837_34160 = state_30812__$1;
(statearr_30837_34160[(1)] = (5));

} else {
var statearr_30842_34165 = state_30812__$1;
(statearr_30842_34165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30813 === (5))){
var state_30812__$1 = state_30812;
var statearr_30845_34169 = state_30812__$1;
(statearr_30845_34169[(2)] = null);

(statearr_30845_34169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30813 === (6))){
var state_30812__$1 = state_30812;
var statearr_30850_34173 = state_30812__$1;
(statearr_30850_34173[(2)] = null);

(statearr_30850_34173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30813 === (7))){
var inst_30803 = (state_30812[(2)]);
var state_30812__$1 = state_30812;
var statearr_30853_34180 = state_30812__$1;
(statearr_30853_34180[(2)] = inst_30803);

(statearr_30853_34180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34149,c__30320__auto___34153,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async))
;
return ((function (__34149,switch__29991__auto__,c__30320__auto___34153,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0 = (function (){
var statearr_30858 = [null,null,null,null,null,null,null];
(statearr_30858[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__);

(statearr_30858[(1)] = (1));

return statearr_30858;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1 = (function (state_30812){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_30812);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e30867){var ex__29995__auto__ = e30867;
var statearr_30868_34193 = state_30812;
(statearr_30868_34193[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_30812[(4)]))){
var statearr_30869_34195 = state_30812;
(statearr_30869_34195[(1)] = cljs.core.first((state_30812[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34197 = state_30812;
state_30812 = G__34197;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = function(state_30812){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1.call(this,state_30812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__;
})()
;})(__34149,switch__29991__auto__,c__30320__auto___34153,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async))
})();
var state__30322__auto__ = (function (){var statearr_30876 = f__30321__auto__();
(statearr_30876[(6)] = c__30320__auto___34153);

return statearr_30876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
});})(__34149,c__30320__auto___34153,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async))
);


break;
case "async":
var c__30320__auto___34198 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34149,c__30320__auto___34198,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async){
return (function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = ((function (__34149,c__30320__auto___34198,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async){
return (function (state_30891){
var state_val_30892 = (state_30891[(1)]);
if((state_val_30892 === (1))){
var state_30891__$1 = state_30891;
var statearr_30901_34201 = state_30891__$1;
(statearr_30901_34201[(2)] = null);

(statearr_30901_34201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30892 === (2))){
var state_30891__$1 = state_30891;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30891__$1,(4),jobs);
} else {
if((state_val_30892 === (3))){
var inst_30889 = (state_30891[(2)]);
var state_30891__$1 = state_30891;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30891__$1,inst_30889);
} else {
if((state_val_30892 === (4))){
var inst_30880 = (state_30891[(2)]);
var inst_30881 = async(inst_30880);
var state_30891__$1 = state_30891;
if(cljs.core.truth_(inst_30881)){
var statearr_30908_34202 = state_30891__$1;
(statearr_30908_34202[(1)] = (5));

} else {
var statearr_30910_34203 = state_30891__$1;
(statearr_30910_34203[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30892 === (5))){
var state_30891__$1 = state_30891;
var statearr_30915_34204 = state_30891__$1;
(statearr_30915_34204[(2)] = null);

(statearr_30915_34204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30892 === (6))){
var state_30891__$1 = state_30891;
var statearr_30921_34206 = state_30891__$1;
(statearr_30921_34206[(2)] = null);

(statearr_30921_34206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30892 === (7))){
var inst_30887 = (state_30891[(2)]);
var state_30891__$1 = state_30891;
var statearr_30924_34209 = state_30891__$1;
(statearr_30924_34209[(2)] = inst_30887);

(statearr_30924_34209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34149,c__30320__auto___34198,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async))
;
return ((function (__34149,switch__29991__auto__,c__30320__auto___34198,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0 = (function (){
var statearr_30925 = [null,null,null,null,null,null,null];
(statearr_30925[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__);

(statearr_30925[(1)] = (1));

return statearr_30925;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1 = (function (state_30891){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_30891);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e30928){var ex__29995__auto__ = e30928;
var statearr_30932_34210 = state_30891;
(statearr_30932_34210[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_30891[(4)]))){
var statearr_30934_34211 = state_30891;
(statearr_30934_34211[(1)] = cljs.core.first((state_30891[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34212 = state_30891;
state_30891 = G__34212;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = function(state_30891){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1.call(this,state_30891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__;
})()
;})(__34149,switch__29991__auto__,c__30320__auto___34198,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async))
})();
var state__30322__auto__ = (function (){var statearr_30938 = f__30321__auto__();
(statearr_30938[(6)] = c__30320__auto___34198);

return statearr_30938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
});})(__34149,c__30320__auto___34198,G__30790_34150,G__30790_34151__$1,n__5635__auto___34145,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30790_34151__$1)].join('')));

}

var G__34213 = (__34149 + (1));
__34149 = G__34213;
continue;
} else {
}
break;
}

var c__30320__auto___34214 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_30968){
var state_val_30969 = (state_30968[(1)]);
if((state_val_30969 === (7))){
var inst_30964 = (state_30968[(2)]);
var state_30968__$1 = state_30968;
var statearr_30983_34215 = state_30968__$1;
(statearr_30983_34215[(2)] = inst_30964);

(statearr_30983_34215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30969 === (1))){
var state_30968__$1 = state_30968;
var statearr_30988_34216 = state_30968__$1;
(statearr_30988_34216[(2)] = null);

(statearr_30988_34216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30969 === (4))){
var inst_30944 = (state_30968[(7)]);
var inst_30944__$1 = (state_30968[(2)]);
var inst_30946 = (inst_30944__$1 == null);
var state_30968__$1 = (function (){var statearr_30997 = state_30968;
(statearr_30997[(7)] = inst_30944__$1);

return statearr_30997;
})();
if(cljs.core.truth_(inst_30946)){
var statearr_30998_34217 = state_30968__$1;
(statearr_30998_34217[(1)] = (5));

} else {
var statearr_30999_34219 = state_30968__$1;
(statearr_30999_34219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30969 === (6))){
var inst_30950 = (state_30968[(8)]);
var inst_30944 = (state_30968[(7)]);
var inst_30950__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_30955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30956 = [inst_30944,inst_30950__$1];
var inst_30957 = (new cljs.core.PersistentVector(null,2,(5),inst_30955,inst_30956,null));
var state_30968__$1 = (function (){var statearr_31000 = state_30968;
(statearr_31000[(8)] = inst_30950__$1);

return statearr_31000;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30968__$1,(8),jobs,inst_30957);
} else {
if((state_val_30969 === (3))){
var inst_30966 = (state_30968[(2)]);
var state_30968__$1 = state_30968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30968__$1,inst_30966);
} else {
if((state_val_30969 === (2))){
var state_30968__$1 = state_30968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30968__$1,(4),from);
} else {
if((state_val_30969 === (9))){
var inst_30961 = (state_30968[(2)]);
var state_30968__$1 = (function (){var statearr_31009 = state_30968;
(statearr_31009[(9)] = inst_30961);

return statearr_31009;
})();
var statearr_31010_34232 = state_30968__$1;
(statearr_31010_34232[(2)] = null);

(statearr_31010_34232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30969 === (5))){
var inst_30948 = cljs.core.async.close_BANG_(jobs);
var state_30968__$1 = state_30968;
var statearr_31011_34237 = state_30968__$1;
(statearr_31011_34237[(2)] = inst_30948);

(statearr_31011_34237[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30969 === (8))){
var inst_30950 = (state_30968[(8)]);
var inst_30959 = (state_30968[(2)]);
var state_30968__$1 = (function (){var statearr_31015 = state_30968;
(statearr_31015[(10)] = inst_30959);

return statearr_31015;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30968__$1,(9),results,inst_30950);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0 = (function (){
var statearr_31019 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31019[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__);

(statearr_31019[(1)] = (1));

return statearr_31019;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1 = (function (state_30968){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_30968);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e31023){var ex__29995__auto__ = e31023;
var statearr_31024_34242 = state_30968;
(statearr_31024_34242[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_30968[(4)]))){
var statearr_31025_34243 = state_30968;
(statearr_31025_34243[(1)] = cljs.core.first((state_30968[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34248 = state_30968;
state_30968 = G__34248;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = function(state_30968){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1.call(this,state_30968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_31035 = f__30321__auto__();
(statearr_31035[(6)] = c__30320__auto___34214);

return statearr_31035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


var c__30320__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_31087){
var state_val_31094 = (state_31087[(1)]);
if((state_val_31094 === (7))){
var inst_31074 = (state_31087[(2)]);
var state_31087__$1 = state_31087;
var statearr_31097_34249 = state_31087__$1;
(statearr_31097_34249[(2)] = inst_31074);

(statearr_31097_34249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (20))){
var state_31087__$1 = state_31087;
var statearr_31098_34250 = state_31087__$1;
(statearr_31098_34250[(2)] = null);

(statearr_31098_34250[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (1))){
var state_31087__$1 = state_31087;
var statearr_31103_34251 = state_31087__$1;
(statearr_31103_34251[(2)] = null);

(statearr_31103_34251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (4))){
var inst_31042 = (state_31087[(7)]);
var inst_31042__$1 = (state_31087[(2)]);
var inst_31043 = (inst_31042__$1 == null);
var state_31087__$1 = (function (){var statearr_31105 = state_31087;
(statearr_31105[(7)] = inst_31042__$1);

return statearr_31105;
})();
if(cljs.core.truth_(inst_31043)){
var statearr_31106_34252 = state_31087__$1;
(statearr_31106_34252[(1)] = (5));

} else {
var statearr_31107_34253 = state_31087__$1;
(statearr_31107_34253[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (15))){
var inst_31056 = (state_31087[(8)]);
var state_31087__$1 = state_31087;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31087__$1,(18),to,inst_31056);
} else {
if((state_val_31094 === (21))){
var inst_31069 = (state_31087[(2)]);
var state_31087__$1 = state_31087;
var statearr_31108_34258 = state_31087__$1;
(statearr_31108_34258[(2)] = inst_31069);

(statearr_31108_34258[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (13))){
var inst_31071 = (state_31087[(2)]);
var state_31087__$1 = (function (){var statearr_31111 = state_31087;
(statearr_31111[(9)] = inst_31071);

return statearr_31111;
})();
var statearr_31116_34261 = state_31087__$1;
(statearr_31116_34261[(2)] = null);

(statearr_31116_34261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (6))){
var inst_31042 = (state_31087[(7)]);
var state_31087__$1 = state_31087;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31087__$1,(11),inst_31042);
} else {
if((state_val_31094 === (17))){
var inst_31064 = (state_31087[(2)]);
var state_31087__$1 = state_31087;
if(cljs.core.truth_(inst_31064)){
var statearr_31117_34262 = state_31087__$1;
(statearr_31117_34262[(1)] = (19));

} else {
var statearr_31118_34266 = state_31087__$1;
(statearr_31118_34266[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (3))){
var inst_31076 = (state_31087[(2)]);
var state_31087__$1 = state_31087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31087__$1,inst_31076);
} else {
if((state_val_31094 === (12))){
var inst_31053 = (state_31087[(10)]);
var state_31087__$1 = state_31087;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31087__$1,(14),inst_31053);
} else {
if((state_val_31094 === (2))){
var state_31087__$1 = state_31087;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31087__$1,(4),results);
} else {
if((state_val_31094 === (19))){
var state_31087__$1 = state_31087;
var statearr_31121_34269 = state_31087__$1;
(statearr_31121_34269[(2)] = null);

(statearr_31121_34269[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (11))){
var inst_31053 = (state_31087[(2)]);
var state_31087__$1 = (function (){var statearr_31122 = state_31087;
(statearr_31122[(10)] = inst_31053);

return statearr_31122;
})();
var statearr_31123_34270 = state_31087__$1;
(statearr_31123_34270[(2)] = null);

(statearr_31123_34270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (9))){
var state_31087__$1 = state_31087;
var statearr_31128_34271 = state_31087__$1;
(statearr_31128_34271[(2)] = null);

(statearr_31128_34271[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (5))){
var state_31087__$1 = state_31087;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31129_34273 = state_31087__$1;
(statearr_31129_34273[(1)] = (8));

} else {
var statearr_31135_34275 = state_31087__$1;
(statearr_31135_34275[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (14))){
var inst_31058 = (state_31087[(11)]);
var inst_31056 = (state_31087[(8)]);
var inst_31056__$1 = (state_31087[(2)]);
var inst_31057 = (inst_31056__$1 == null);
var inst_31058__$1 = cljs.core.not(inst_31057);
var state_31087__$1 = (function (){var statearr_31145 = state_31087;
(statearr_31145[(11)] = inst_31058__$1);

(statearr_31145[(8)] = inst_31056__$1);

return statearr_31145;
})();
if(inst_31058__$1){
var statearr_31152_34278 = state_31087__$1;
(statearr_31152_34278[(1)] = (15));

} else {
var statearr_31158_34280 = state_31087__$1;
(statearr_31158_34280[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (16))){
var inst_31058 = (state_31087[(11)]);
var state_31087__$1 = state_31087;
var statearr_31160_34286 = state_31087__$1;
(statearr_31160_34286[(2)] = inst_31058);

(statearr_31160_34286[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (10))){
var inst_31049 = (state_31087[(2)]);
var state_31087__$1 = state_31087;
var statearr_31161_34289 = state_31087__$1;
(statearr_31161_34289[(2)] = inst_31049);

(statearr_31161_34289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (18))){
var inst_31061 = (state_31087[(2)]);
var state_31087__$1 = state_31087;
var statearr_31165_34294 = state_31087__$1;
(statearr_31165_34294[(2)] = inst_31061);

(statearr_31165_34294[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31094 === (8))){
var inst_31046 = cljs.core.async.close_BANG_(to);
var state_31087__$1 = state_31087;
var statearr_31166_34307 = state_31087__$1;
(statearr_31166_34307[(2)] = inst_31046);

(statearr_31166_34307[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0 = (function (){
var statearr_31171 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31171[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__);

(statearr_31171[(1)] = (1));

return statearr_31171;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1 = (function (state_31087){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_31087);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e31173){var ex__29995__auto__ = e31173;
var statearr_31174_34309 = state_31087;
(statearr_31174_34309[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_31087[(4)]))){
var statearr_31177_34311 = state_31087;
(statearr_31177_34311[(1)] = cljs.core.first((state_31087[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34314 = state_31087;
state_31087 = G__34314;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__ = function(state_31087){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1.call(this,state_31087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29992__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_31185 = f__30321__auto__();
(statearr_31185[(6)] = c__30320__auto__);

return statearr_31185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

return c__30320__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31193 = arguments.length;
switch (G__31193) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31228 = arguments.length;
switch (G__31228) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31278 = arguments.length;
switch (G__31278) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30320__auto___34338 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_31337){
var state_val_31338 = (state_31337[(1)]);
if((state_val_31338 === (7))){
var inst_31331 = (state_31337[(2)]);
var state_31337__$1 = state_31337;
var statearr_31343_34342 = state_31337__$1;
(statearr_31343_34342[(2)] = inst_31331);

(statearr_31343_34342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (1))){
var state_31337__$1 = state_31337;
var statearr_31349_34343 = state_31337__$1;
(statearr_31349_34343[(2)] = null);

(statearr_31349_34343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (4))){
var inst_31310 = (state_31337[(7)]);
var inst_31310__$1 = (state_31337[(2)]);
var inst_31311 = (inst_31310__$1 == null);
var state_31337__$1 = (function (){var statearr_31351 = state_31337;
(statearr_31351[(7)] = inst_31310__$1);

return statearr_31351;
})();
if(cljs.core.truth_(inst_31311)){
var statearr_31352_34344 = state_31337__$1;
(statearr_31352_34344[(1)] = (5));

} else {
var statearr_31353_34345 = state_31337__$1;
(statearr_31353_34345[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (13))){
var state_31337__$1 = state_31337;
var statearr_31355_34346 = state_31337__$1;
(statearr_31355_34346[(2)] = null);

(statearr_31355_34346[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (6))){
var inst_31310 = (state_31337[(7)]);
var inst_31318 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31310) : p.call(null,inst_31310));
var state_31337__$1 = state_31337;
if(cljs.core.truth_(inst_31318)){
var statearr_31359_34352 = state_31337__$1;
(statearr_31359_34352[(1)] = (9));

} else {
var statearr_31365_34353 = state_31337__$1;
(statearr_31365_34353[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (3))){
var inst_31334 = (state_31337[(2)]);
var state_31337__$1 = state_31337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31337__$1,inst_31334);
} else {
if((state_val_31338 === (12))){
var state_31337__$1 = state_31337;
var statearr_31366_34354 = state_31337__$1;
(statearr_31366_34354[(2)] = null);

(statearr_31366_34354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (2))){
var state_31337__$1 = state_31337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31337__$1,(4),ch);
} else {
if((state_val_31338 === (11))){
var inst_31310 = (state_31337[(7)]);
var inst_31322 = (state_31337[(2)]);
var state_31337__$1 = state_31337;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31337__$1,(8),inst_31322,inst_31310);
} else {
if((state_val_31338 === (9))){
var state_31337__$1 = state_31337;
var statearr_31369_34361 = state_31337__$1;
(statearr_31369_34361[(2)] = tc);

(statearr_31369_34361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (5))){
var inst_31315 = cljs.core.async.close_BANG_(tc);
var inst_31316 = cljs.core.async.close_BANG_(fc);
var state_31337__$1 = (function (){var statearr_31376 = state_31337;
(statearr_31376[(8)] = inst_31315);

return statearr_31376;
})();
var statearr_31381_34365 = state_31337__$1;
(statearr_31381_34365[(2)] = inst_31316);

(statearr_31381_34365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (14))){
var inst_31329 = (state_31337[(2)]);
var state_31337__$1 = state_31337;
var statearr_31387_34367 = state_31337__$1;
(statearr_31387_34367[(2)] = inst_31329);

(statearr_31387_34367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (10))){
var state_31337__$1 = state_31337;
var statearr_31390_34368 = state_31337__$1;
(statearr_31390_34368[(2)] = fc);

(statearr_31390_34368[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31338 === (8))){
var inst_31324 = (state_31337[(2)]);
var state_31337__$1 = state_31337;
if(cljs.core.truth_(inst_31324)){
var statearr_31396_34372 = state_31337__$1;
(statearr_31396_34372[(1)] = (12));

} else {
var statearr_31399_34373 = state_31337__$1;
(statearr_31399_34373[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_31404 = [null,null,null,null,null,null,null,null,null];
(statearr_31404[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_31404[(1)] = (1));

return statearr_31404;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_31337){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_31337);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e31405){var ex__29995__auto__ = e31405;
var statearr_31406_34380 = state_31337;
(statearr_31406_34380[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_31337[(4)]))){
var statearr_31407_34382 = state_31337;
(statearr_31407_34382[(1)] = cljs.core.first((state_31337[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34383 = state_31337;
state_31337 = G__34383;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_31337){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_31337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_31409 = f__30321__auto__();
(statearr_31409[(6)] = c__30320__auto___34338);

return statearr_31409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30320__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_31445){
var state_val_31447 = (state_31445[(1)]);
if((state_val_31447 === (7))){
var inst_31441 = (state_31445[(2)]);
var state_31445__$1 = state_31445;
var statearr_31455_34389 = state_31445__$1;
(statearr_31455_34389[(2)] = inst_31441);

(statearr_31455_34389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (1))){
var inst_31418 = init;
var inst_31421 = inst_31418;
var state_31445__$1 = (function (){var statearr_31459 = state_31445;
(statearr_31459[(7)] = inst_31421);

return statearr_31459;
})();
var statearr_31460_34390 = state_31445__$1;
(statearr_31460_34390[(2)] = null);

(statearr_31460_34390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (4))){
var inst_31426 = (state_31445[(8)]);
var inst_31426__$1 = (state_31445[(2)]);
var inst_31427 = (inst_31426__$1 == null);
var state_31445__$1 = (function (){var statearr_31461 = state_31445;
(statearr_31461[(8)] = inst_31426__$1);

return statearr_31461;
})();
if(cljs.core.truth_(inst_31427)){
var statearr_31462_34393 = state_31445__$1;
(statearr_31462_34393[(1)] = (5));

} else {
var statearr_31463_34395 = state_31445__$1;
(statearr_31463_34395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (6))){
var inst_31421 = (state_31445[(7)]);
var inst_31431 = (state_31445[(9)]);
var inst_31426 = (state_31445[(8)]);
var inst_31431__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31421,inst_31426) : f.call(null,inst_31421,inst_31426));
var inst_31432 = cljs.core.reduced_QMARK_(inst_31431__$1);
var state_31445__$1 = (function (){var statearr_31465 = state_31445;
(statearr_31465[(9)] = inst_31431__$1);

return statearr_31465;
})();
if(inst_31432){
var statearr_31466_34401 = state_31445__$1;
(statearr_31466_34401[(1)] = (8));

} else {
var statearr_31467_34402 = state_31445__$1;
(statearr_31467_34402[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (3))){
var inst_31443 = (state_31445[(2)]);
var state_31445__$1 = state_31445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31445__$1,inst_31443);
} else {
if((state_val_31447 === (2))){
var state_31445__$1 = state_31445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31445__$1,(4),ch);
} else {
if((state_val_31447 === (9))){
var inst_31431 = (state_31445[(9)]);
var inst_31421 = inst_31431;
var state_31445__$1 = (function (){var statearr_31470 = state_31445;
(statearr_31470[(7)] = inst_31421);

return statearr_31470;
})();
var statearr_31472_34403 = state_31445__$1;
(statearr_31472_34403[(2)] = null);

(statearr_31472_34403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (5))){
var inst_31421 = (state_31445[(7)]);
var state_31445__$1 = state_31445;
var statearr_31473_34404 = state_31445__$1;
(statearr_31473_34404[(2)] = inst_31421);

(statearr_31473_34404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (10))){
var inst_31439 = (state_31445[(2)]);
var state_31445__$1 = state_31445;
var statearr_31474_34406 = state_31445__$1;
(statearr_31474_34406[(2)] = inst_31439);

(statearr_31474_34406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31447 === (8))){
var inst_31431 = (state_31445[(9)]);
var inst_31434 = cljs.core.deref(inst_31431);
var state_31445__$1 = state_31445;
var statearr_31476_34407 = state_31445__$1;
(statearr_31476_34407[(2)] = inst_31434);

(statearr_31476_34407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__29992__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29992__auto____0 = (function (){
var statearr_31478 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31478[(0)] = cljs$core$async$reduce_$_state_machine__29992__auto__);

(statearr_31478[(1)] = (1));

return statearr_31478;
});
var cljs$core$async$reduce_$_state_machine__29992__auto____1 = (function (state_31445){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_31445);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e31479){var ex__29995__auto__ = e31479;
var statearr_31481_34417 = state_31445;
(statearr_31481_34417[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_31445[(4)]))){
var statearr_31482_34419 = state_31445;
(statearr_31482_34419[(1)] = cljs.core.first((state_31445[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34420 = state_31445;
state_31445 = G__34420;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29992__auto__ = function(state_31445){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29992__auto____1.call(this,state_31445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29992__auto____0;
cljs$core$async$reduce_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29992__auto____1;
return cljs$core$async$reduce_$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_31486 = f__30321__auto__();
(statearr_31486[(6)] = c__30320__auto__);

return statearr_31486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

return c__30320__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30320__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_31500){
var state_val_31501 = (state_31500[(1)]);
if((state_val_31501 === (1))){
var inst_31495 = cljs.core.async.reduce(f__$1,init,ch);
var state_31500__$1 = state_31500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31500__$1,(2),inst_31495);
} else {
if((state_val_31501 === (2))){
var inst_31497 = (state_31500[(2)]);
var inst_31498 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31497) : f__$1.call(null,inst_31497));
var state_31500__$1 = state_31500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31500__$1,inst_31498);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__29992__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29992__auto____0 = (function (){
var statearr_31508 = [null,null,null,null,null,null,null];
(statearr_31508[(0)] = cljs$core$async$transduce_$_state_machine__29992__auto__);

(statearr_31508[(1)] = (1));

return statearr_31508;
});
var cljs$core$async$transduce_$_state_machine__29992__auto____1 = (function (state_31500){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_31500);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e31523){var ex__29995__auto__ = e31523;
var statearr_31528_34428 = state_31500;
(statearr_31528_34428[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_31500[(4)]))){
var statearr_31541_34429 = state_31500;
(statearr_31541_34429[(1)] = cljs.core.first((state_31500[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34434 = state_31500;
state_31500 = G__34434;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29992__auto__ = function(state_31500){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29992__auto____1.call(this,state_31500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29992__auto____0;
cljs$core$async$transduce_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29992__auto____1;
return cljs$core$async$transduce_$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_31550 = f__30321__auto__();
(statearr_31550[(6)] = c__30320__auto__);

return statearr_31550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

return c__30320__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31563 = arguments.length;
switch (G__31563) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30320__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_31593){
var state_val_31594 = (state_31593[(1)]);
if((state_val_31594 === (7))){
var inst_31573 = (state_31593[(2)]);
var state_31593__$1 = state_31593;
var statearr_31596_34462 = state_31593__$1;
(statearr_31596_34462[(2)] = inst_31573);

(statearr_31596_34462[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (1))){
var inst_31567 = cljs.core.seq(coll);
var inst_31568 = inst_31567;
var state_31593__$1 = (function (){var statearr_31598 = state_31593;
(statearr_31598[(7)] = inst_31568);

return statearr_31598;
})();
var statearr_31602_34463 = state_31593__$1;
(statearr_31602_34463[(2)] = null);

(statearr_31602_34463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (4))){
var inst_31568 = (state_31593[(7)]);
var inst_31571 = cljs.core.first(inst_31568);
var state_31593__$1 = state_31593;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31593__$1,(7),ch,inst_31571);
} else {
if((state_val_31594 === (13))){
var inst_31587 = (state_31593[(2)]);
var state_31593__$1 = state_31593;
var statearr_31607_34465 = state_31593__$1;
(statearr_31607_34465[(2)] = inst_31587);

(statearr_31607_34465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (6))){
var inst_31576 = (state_31593[(2)]);
var state_31593__$1 = state_31593;
if(cljs.core.truth_(inst_31576)){
var statearr_31608_34471 = state_31593__$1;
(statearr_31608_34471[(1)] = (8));

} else {
var statearr_31609_34472 = state_31593__$1;
(statearr_31609_34472[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (3))){
var inst_31591 = (state_31593[(2)]);
var state_31593__$1 = state_31593;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31593__$1,inst_31591);
} else {
if((state_val_31594 === (12))){
var state_31593__$1 = state_31593;
var statearr_31611_34473 = state_31593__$1;
(statearr_31611_34473[(2)] = null);

(statearr_31611_34473[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (2))){
var inst_31568 = (state_31593[(7)]);
var state_31593__$1 = state_31593;
if(cljs.core.truth_(inst_31568)){
var statearr_31613_34474 = state_31593__$1;
(statearr_31613_34474[(1)] = (4));

} else {
var statearr_31614_34475 = state_31593__$1;
(statearr_31614_34475[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (11))){
var inst_31584 = cljs.core.async.close_BANG_(ch);
var state_31593__$1 = state_31593;
var statearr_31616_34476 = state_31593__$1;
(statearr_31616_34476[(2)] = inst_31584);

(statearr_31616_34476[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (9))){
var state_31593__$1 = state_31593;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31617_34479 = state_31593__$1;
(statearr_31617_34479[(1)] = (11));

} else {
var statearr_31618_34480 = state_31593__$1;
(statearr_31618_34480[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (5))){
var inst_31568 = (state_31593[(7)]);
var state_31593__$1 = state_31593;
var statearr_31621_34485 = state_31593__$1;
(statearr_31621_34485[(2)] = inst_31568);

(statearr_31621_34485[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (10))){
var inst_31589 = (state_31593[(2)]);
var state_31593__$1 = state_31593;
var statearr_31622_34489 = state_31593__$1;
(statearr_31622_34489[(2)] = inst_31589);

(statearr_31622_34489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31594 === (8))){
var inst_31568 = (state_31593[(7)]);
var inst_31579 = cljs.core.next(inst_31568);
var inst_31568__$1 = inst_31579;
var state_31593__$1 = (function (){var statearr_31626 = state_31593;
(statearr_31626[(7)] = inst_31568__$1);

return statearr_31626;
})();
var statearr_31627_34490 = state_31593__$1;
(statearr_31627_34490[(2)] = null);

(statearr_31627_34490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_31628 = [null,null,null,null,null,null,null,null];
(statearr_31628[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_31628[(1)] = (1));

return statearr_31628;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_31593){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_31593);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e31632){var ex__29995__auto__ = e31632;
var statearr_31635_34494 = state_31593;
(statearr_31635_34494[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_31593[(4)]))){
var statearr_31637_34495 = state_31593;
(statearr_31637_34495[(1)] = cljs.core.first((state_31593[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34498 = state_31593;
state_31593 = G__34498;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_31593){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_31593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_31639 = f__30321__auto__();
(statearr_31639[(6)] = c__30320__auto__);

return statearr_31639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

return c__30320__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31647 = arguments.length;
switch (G__31647) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34500 = (function (_){
var x__5392__auto__ = (((_ == null))?null:_);
var m__5393__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5393__auto__.call(null,_));
} else {
var m__5391__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5391__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34500(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34501 = (function (m,ch,close_QMARK_){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5393__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5391__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5391__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34501(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34507 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34507(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34519 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5393__auto__.call(null,m));
} else {
var m__5391__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5391__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34519(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31683 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31683 = (function (ch,cs,meta31684){
this.ch = ch;
this.cs = cs;
this.meta31684 = meta31684;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31685,meta31684__$1){
var self__ = this;
var _31685__$1 = this;
return (new cljs.core.async.t_cljs$core$async31683(self__.ch,self__.cs,meta31684__$1));
}));

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31685){
var self__ = this;
var _31685__$1 = this;
return self__.meta31684;
}));

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31683.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31683.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31684","meta31684",1744681749,null)], null);
}));

(cljs.core.async.t_cljs$core$async31683.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31683.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31683");

(cljs.core.async.t_cljs$core$async31683.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async31683");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31683.
 */
cljs.core.async.__GT_t_cljs$core$async31683 = (function cljs$core$async$mult_$___GT_t_cljs$core$async31683(ch__$1,cs__$1,meta31684){
return (new cljs.core.async.t_cljs$core$async31683(ch__$1,cs__$1,meta31684));
});

}

return (new cljs.core.async.t_cljs$core$async31683(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30320__auto___34558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_31855){
var state_val_31857 = (state_31855[(1)]);
if((state_val_31857 === (7))){
var inst_31851 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_31864_34559 = state_31855__$1;
(statearr_31864_34559[(2)] = inst_31851);

(statearr_31864_34559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (20))){
var inst_31742 = (state_31855[(7)]);
var inst_31754 = cljs.core.first(inst_31742);
var inst_31755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31754,(0),null);
var inst_31756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31754,(1),null);
var state_31855__$1 = (function (){var statearr_31866 = state_31855;
(statearr_31866[(8)] = inst_31755);

return statearr_31866;
})();
if(cljs.core.truth_(inst_31756)){
var statearr_31867_34562 = state_31855__$1;
(statearr_31867_34562[(1)] = (22));

} else {
var statearr_31868_34564 = state_31855__$1;
(statearr_31868_34564[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (27))){
var inst_31699 = (state_31855[(9)]);
var inst_31791 = (state_31855[(10)]);
var inst_31799 = (state_31855[(11)]);
var inst_31793 = (state_31855[(12)]);
var inst_31799__$1 = cljs.core._nth(inst_31791,inst_31793);
var inst_31801 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31799__$1,inst_31699,done);
var state_31855__$1 = (function (){var statearr_31872 = state_31855;
(statearr_31872[(11)] = inst_31799__$1);

return statearr_31872;
})();
if(cljs.core.truth_(inst_31801)){
var statearr_31874_34565 = state_31855__$1;
(statearr_31874_34565[(1)] = (30));

} else {
var statearr_31875_34568 = state_31855__$1;
(statearr_31875_34568[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (1))){
var state_31855__$1 = state_31855;
var statearr_31877_34569 = state_31855__$1;
(statearr_31877_34569[(2)] = null);

(statearr_31877_34569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (24))){
var inst_31742 = (state_31855[(7)]);
var inst_31764 = (state_31855[(2)]);
var inst_31765 = cljs.core.next(inst_31742);
var inst_31709 = inst_31765;
var inst_31710 = null;
var inst_31711 = (0);
var inst_31712 = (0);
var state_31855__$1 = (function (){var statearr_31881 = state_31855;
(statearr_31881[(13)] = inst_31710);

(statearr_31881[(14)] = inst_31764);

(statearr_31881[(15)] = inst_31709);

(statearr_31881[(16)] = inst_31712);

(statearr_31881[(17)] = inst_31711);

return statearr_31881;
})();
var statearr_31882_34573 = state_31855__$1;
(statearr_31882_34573[(2)] = null);

(statearr_31882_34573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (39))){
var state_31855__$1 = state_31855;
var statearr_31886_34574 = state_31855__$1;
(statearr_31886_34574[(2)] = null);

(statearr_31886_34574[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (4))){
var inst_31699 = (state_31855[(9)]);
var inst_31699__$1 = (state_31855[(2)]);
var inst_31701 = (inst_31699__$1 == null);
var state_31855__$1 = (function (){var statearr_31888 = state_31855;
(statearr_31888[(9)] = inst_31699__$1);

return statearr_31888;
})();
if(cljs.core.truth_(inst_31701)){
var statearr_31889_34577 = state_31855__$1;
(statearr_31889_34577[(1)] = (5));

} else {
var statearr_31890_34578 = state_31855__$1;
(statearr_31890_34578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (15))){
var inst_31710 = (state_31855[(13)]);
var inst_31709 = (state_31855[(15)]);
var inst_31712 = (state_31855[(16)]);
var inst_31711 = (state_31855[(17)]);
var inst_31738 = (state_31855[(2)]);
var inst_31739 = (inst_31712 + (1));
var tmp31883 = inst_31710;
var tmp31884 = inst_31709;
var tmp31885 = inst_31711;
var inst_31709__$1 = tmp31884;
var inst_31710__$1 = tmp31883;
var inst_31711__$1 = tmp31885;
var inst_31712__$1 = inst_31739;
var state_31855__$1 = (function (){var statearr_31894 = state_31855;
(statearr_31894[(13)] = inst_31710__$1);

(statearr_31894[(15)] = inst_31709__$1);

(statearr_31894[(18)] = inst_31738);

(statearr_31894[(16)] = inst_31712__$1);

(statearr_31894[(17)] = inst_31711__$1);

return statearr_31894;
})();
var statearr_31898_34592 = state_31855__$1;
(statearr_31898_34592[(2)] = null);

(statearr_31898_34592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (21))){
var inst_31772 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_31910_34593 = state_31855__$1;
(statearr_31910_34593[(2)] = inst_31772);

(statearr_31910_34593[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (31))){
var inst_31799 = (state_31855[(11)]);
var inst_31804 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31799);
var state_31855__$1 = state_31855;
var statearr_31913_34594 = state_31855__$1;
(statearr_31913_34594[(2)] = inst_31804);

(statearr_31913_34594[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (32))){
var inst_31791 = (state_31855[(10)]);
var inst_31792 = (state_31855[(19)]);
var inst_31790 = (state_31855[(20)]);
var inst_31793 = (state_31855[(12)]);
var inst_31806 = (state_31855[(2)]);
var inst_31807 = (inst_31793 + (1));
var tmp31905 = inst_31791;
var tmp31906 = inst_31792;
var tmp31907 = inst_31790;
var inst_31790__$1 = tmp31907;
var inst_31791__$1 = tmp31905;
var inst_31792__$1 = tmp31906;
var inst_31793__$1 = inst_31807;
var state_31855__$1 = (function (){var statearr_31915 = state_31855;
(statearr_31915[(10)] = inst_31791__$1);

(statearr_31915[(21)] = inst_31806);

(statearr_31915[(19)] = inst_31792__$1);

(statearr_31915[(20)] = inst_31790__$1);

(statearr_31915[(12)] = inst_31793__$1);

return statearr_31915;
})();
var statearr_31918_34601 = state_31855__$1;
(statearr_31918_34601[(2)] = null);

(statearr_31918_34601[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (40))){
var inst_31824 = (state_31855[(22)]);
var inst_31828 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31824);
var state_31855__$1 = state_31855;
var statearr_31920_34602 = state_31855__$1;
(statearr_31920_34602[(2)] = inst_31828);

(statearr_31920_34602[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (33))){
var inst_31811 = (state_31855[(23)]);
var inst_31816 = cljs.core.chunked_seq_QMARK_(inst_31811);
var state_31855__$1 = state_31855;
if(inst_31816){
var statearr_31927_34606 = state_31855__$1;
(statearr_31927_34606[(1)] = (36));

} else {
var statearr_31928_34607 = state_31855__$1;
(statearr_31928_34607[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (13))){
var inst_31724 = (state_31855[(24)]);
var inst_31734 = cljs.core.async.close_BANG_(inst_31724);
var state_31855__$1 = state_31855;
var statearr_31929_34609 = state_31855__$1;
(statearr_31929_34609[(2)] = inst_31734);

(statearr_31929_34609[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (22))){
var inst_31755 = (state_31855[(8)]);
var inst_31759 = cljs.core.async.close_BANG_(inst_31755);
var state_31855__$1 = state_31855;
var statearr_31937_34610 = state_31855__$1;
(statearr_31937_34610[(2)] = inst_31759);

(statearr_31937_34610[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (36))){
var inst_31811 = (state_31855[(23)]);
var inst_31818 = cljs.core.chunk_first(inst_31811);
var inst_31819 = cljs.core.chunk_rest(inst_31811);
var inst_31820 = cljs.core.count(inst_31818);
var inst_31790 = inst_31819;
var inst_31791 = inst_31818;
var inst_31792 = inst_31820;
var inst_31793 = (0);
var state_31855__$1 = (function (){var statearr_31938 = state_31855;
(statearr_31938[(10)] = inst_31791);

(statearr_31938[(19)] = inst_31792);

(statearr_31938[(20)] = inst_31790);

(statearr_31938[(12)] = inst_31793);

return statearr_31938;
})();
var statearr_31946_34619 = state_31855__$1;
(statearr_31946_34619[(2)] = null);

(statearr_31946_34619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (41))){
var inst_31811 = (state_31855[(23)]);
var inst_31830 = (state_31855[(2)]);
var inst_31831 = cljs.core.next(inst_31811);
var inst_31790 = inst_31831;
var inst_31791 = null;
var inst_31792 = (0);
var inst_31793 = (0);
var state_31855__$1 = (function (){var statearr_31950 = state_31855;
(statearr_31950[(10)] = inst_31791);

(statearr_31950[(19)] = inst_31792);

(statearr_31950[(25)] = inst_31830);

(statearr_31950[(20)] = inst_31790);

(statearr_31950[(12)] = inst_31793);

return statearr_31950;
})();
var statearr_31951_34620 = state_31855__$1;
(statearr_31951_34620[(2)] = null);

(statearr_31951_34620[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (43))){
var state_31855__$1 = state_31855;
var statearr_31952_34625 = state_31855__$1;
(statearr_31952_34625[(2)] = null);

(statearr_31952_34625[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (29))){
var inst_31839 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_31954_34626 = state_31855__$1;
(statearr_31954_34626[(2)] = inst_31839);

(statearr_31954_34626[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (44))){
var inst_31848 = (state_31855[(2)]);
var state_31855__$1 = (function (){var statearr_31955 = state_31855;
(statearr_31955[(26)] = inst_31848);

return statearr_31955;
})();
var statearr_31957_34628 = state_31855__$1;
(statearr_31957_34628[(2)] = null);

(statearr_31957_34628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (6))){
var inst_31782 = (state_31855[(27)]);
var inst_31781 = cljs.core.deref(cs);
var inst_31782__$1 = cljs.core.keys(inst_31781);
var inst_31783 = cljs.core.count(inst_31782__$1);
var inst_31784 = cljs.core.reset_BANG_(dctr,inst_31783);
var inst_31789 = cljs.core.seq(inst_31782__$1);
var inst_31790 = inst_31789;
var inst_31791 = null;
var inst_31792 = (0);
var inst_31793 = (0);
var state_31855__$1 = (function (){var statearr_31960 = state_31855;
(statearr_31960[(10)] = inst_31791);

(statearr_31960[(27)] = inst_31782__$1);

(statearr_31960[(19)] = inst_31792);

(statearr_31960[(28)] = inst_31784);

(statearr_31960[(20)] = inst_31790);

(statearr_31960[(12)] = inst_31793);

return statearr_31960;
})();
var statearr_31973_34640 = state_31855__$1;
(statearr_31973_34640[(2)] = null);

(statearr_31973_34640[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (28))){
var inst_31811 = (state_31855[(23)]);
var inst_31790 = (state_31855[(20)]);
var inst_31811__$1 = cljs.core.seq(inst_31790);
var state_31855__$1 = (function (){var statearr_31974 = state_31855;
(statearr_31974[(23)] = inst_31811__$1);

return statearr_31974;
})();
if(inst_31811__$1){
var statearr_31977_34643 = state_31855__$1;
(statearr_31977_34643[(1)] = (33));

} else {
var statearr_31978_34644 = state_31855__$1;
(statearr_31978_34644[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (25))){
var inst_31792 = (state_31855[(19)]);
var inst_31793 = (state_31855[(12)]);
var inst_31796 = (inst_31793 < inst_31792);
var inst_31797 = inst_31796;
var state_31855__$1 = state_31855;
if(cljs.core.truth_(inst_31797)){
var statearr_31982_34645 = state_31855__$1;
(statearr_31982_34645[(1)] = (27));

} else {
var statearr_31984_34647 = state_31855__$1;
(statearr_31984_34647[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (34))){
var state_31855__$1 = state_31855;
var statearr_31985_34648 = state_31855__$1;
(statearr_31985_34648[(2)] = null);

(statearr_31985_34648[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (17))){
var state_31855__$1 = state_31855;
var statearr_31986_34649 = state_31855__$1;
(statearr_31986_34649[(2)] = null);

(statearr_31986_34649[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (3))){
var inst_31853 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31855__$1,inst_31853);
} else {
if((state_val_31857 === (12))){
var inst_31777 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_31987_34656 = state_31855__$1;
(statearr_31987_34656[(2)] = inst_31777);

(statearr_31987_34656[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (2))){
var state_31855__$1 = state_31855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31855__$1,(4),ch);
} else {
if((state_val_31857 === (23))){
var state_31855__$1 = state_31855;
var statearr_31990_34657 = state_31855__$1;
(statearr_31990_34657[(2)] = null);

(statearr_31990_34657[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (35))){
var inst_31837 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_31992_34658 = state_31855__$1;
(statearr_31992_34658[(2)] = inst_31837);

(statearr_31992_34658[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (19))){
var inst_31742 = (state_31855[(7)]);
var inst_31746 = cljs.core.chunk_first(inst_31742);
var inst_31747 = cljs.core.chunk_rest(inst_31742);
var inst_31748 = cljs.core.count(inst_31746);
var inst_31709 = inst_31747;
var inst_31710 = inst_31746;
var inst_31711 = inst_31748;
var inst_31712 = (0);
var state_31855__$1 = (function (){var statearr_31994 = state_31855;
(statearr_31994[(13)] = inst_31710);

(statearr_31994[(15)] = inst_31709);

(statearr_31994[(16)] = inst_31712);

(statearr_31994[(17)] = inst_31711);

return statearr_31994;
})();
var statearr_31998_34659 = state_31855__$1;
(statearr_31998_34659[(2)] = null);

(statearr_31998_34659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (11))){
var inst_31709 = (state_31855[(15)]);
var inst_31742 = (state_31855[(7)]);
var inst_31742__$1 = cljs.core.seq(inst_31709);
var state_31855__$1 = (function (){var statearr_32001 = state_31855;
(statearr_32001[(7)] = inst_31742__$1);

return statearr_32001;
})();
if(inst_31742__$1){
var statearr_32002_34663 = state_31855__$1;
(statearr_32002_34663[(1)] = (16));

} else {
var statearr_32003_34664 = state_31855__$1;
(statearr_32003_34664[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (9))){
var inst_31779 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_32007_34665 = state_31855__$1;
(statearr_32007_34665[(2)] = inst_31779);

(statearr_32007_34665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (5))){
var inst_31707 = cljs.core.deref(cs);
var inst_31708 = cljs.core.seq(inst_31707);
var inst_31709 = inst_31708;
var inst_31710 = null;
var inst_31711 = (0);
var inst_31712 = (0);
var state_31855__$1 = (function (){var statearr_32008 = state_31855;
(statearr_32008[(13)] = inst_31710);

(statearr_32008[(15)] = inst_31709);

(statearr_32008[(16)] = inst_31712);

(statearr_32008[(17)] = inst_31711);

return statearr_32008;
})();
var statearr_32010_34668 = state_31855__$1;
(statearr_32010_34668[(2)] = null);

(statearr_32010_34668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (14))){
var state_31855__$1 = state_31855;
var statearr_32012_34669 = state_31855__$1;
(statearr_32012_34669[(2)] = null);

(statearr_32012_34669[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (45))){
var inst_31845 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_32013_34670 = state_31855__$1;
(statearr_32013_34670[(2)] = inst_31845);

(statearr_32013_34670[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (26))){
var inst_31782 = (state_31855[(27)]);
var inst_31841 = (state_31855[(2)]);
var inst_31842 = cljs.core.seq(inst_31782);
var state_31855__$1 = (function (){var statearr_32018 = state_31855;
(statearr_32018[(29)] = inst_31841);

return statearr_32018;
})();
if(inst_31842){
var statearr_32019_34671 = state_31855__$1;
(statearr_32019_34671[(1)] = (42));

} else {
var statearr_32020_34673 = state_31855__$1;
(statearr_32020_34673[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (16))){
var inst_31742 = (state_31855[(7)]);
var inst_31744 = cljs.core.chunked_seq_QMARK_(inst_31742);
var state_31855__$1 = state_31855;
if(inst_31744){
var statearr_32021_34674 = state_31855__$1;
(statearr_32021_34674[(1)] = (19));

} else {
var statearr_32022_34675 = state_31855__$1;
(statearr_32022_34675[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (38))){
var inst_31834 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_32023_34677 = state_31855__$1;
(statearr_32023_34677[(2)] = inst_31834);

(statearr_32023_34677[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (30))){
var state_31855__$1 = state_31855;
var statearr_32024_34678 = state_31855__$1;
(statearr_32024_34678[(2)] = null);

(statearr_32024_34678[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (10))){
var inst_31710 = (state_31855[(13)]);
var inst_31712 = (state_31855[(16)]);
var inst_31723 = cljs.core._nth(inst_31710,inst_31712);
var inst_31724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31723,(0),null);
var inst_31725 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31723,(1),null);
var state_31855__$1 = (function (){var statearr_32033 = state_31855;
(statearr_32033[(24)] = inst_31724);

return statearr_32033;
})();
if(cljs.core.truth_(inst_31725)){
var statearr_32034_34680 = state_31855__$1;
(statearr_32034_34680[(1)] = (13));

} else {
var statearr_32041_34681 = state_31855__$1;
(statearr_32041_34681[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (18))){
var inst_31775 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
var statearr_32042_34682 = state_31855__$1;
(statearr_32042_34682[(2)] = inst_31775);

(statearr_32042_34682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (42))){
var state_31855__$1 = state_31855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31855__$1,(45),dchan);
} else {
if((state_val_31857 === (37))){
var inst_31699 = (state_31855[(9)]);
var inst_31811 = (state_31855[(23)]);
var inst_31824 = (state_31855[(22)]);
var inst_31824__$1 = cljs.core.first(inst_31811);
var inst_31825 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31824__$1,inst_31699,done);
var state_31855__$1 = (function (){var statearr_32044 = state_31855;
(statearr_32044[(22)] = inst_31824__$1);

return statearr_32044;
})();
if(cljs.core.truth_(inst_31825)){
var statearr_32045_34685 = state_31855__$1;
(statearr_32045_34685[(1)] = (39));

} else {
var statearr_32046_34687 = state_31855__$1;
(statearr_32046_34687[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31857 === (8))){
var inst_31712 = (state_31855[(16)]);
var inst_31711 = (state_31855[(17)]);
var inst_31717 = (inst_31712 < inst_31711);
var inst_31718 = inst_31717;
var state_31855__$1 = state_31855;
if(cljs.core.truth_(inst_31718)){
var statearr_32048_34688 = state_31855__$1;
(statearr_32048_34688[(1)] = (10));

} else {
var statearr_32049_34689 = state_31855__$1;
(statearr_32049_34689[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__29992__auto__ = null;
var cljs$core$async$mult_$_state_machine__29992__auto____0 = (function (){
var statearr_32052 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32052[(0)] = cljs$core$async$mult_$_state_machine__29992__auto__);

(statearr_32052[(1)] = (1));

return statearr_32052;
});
var cljs$core$async$mult_$_state_machine__29992__auto____1 = (function (state_31855){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_31855);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e32053){var ex__29995__auto__ = e32053;
var statearr_32054_34690 = state_31855;
(statearr_32054_34690[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_31855[(4)]))){
var statearr_32055_34691 = state_31855;
(statearr_32055_34691[(1)] = cljs.core.first((state_31855[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34692 = state_31855;
state_31855 = G__34692;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29992__auto__ = function(state_31855){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29992__auto____1.call(this,state_31855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29992__auto____0;
cljs$core$async$mult_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29992__auto____1;
return cljs$core$async$mult_$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_32059 = f__30321__auto__();
(statearr_32059[(6)] = c__30320__auto___34558);

return statearr_32059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32069 = arguments.length;
switch (G__32069) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_34704 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_34704(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_34710 = (function (m,ch){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5393__auto__.call(null,m,ch));
} else {
var m__5391__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5391__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_34710(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_34721 = (function (m){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5393__auto__.call(null,m));
} else {
var m__5391__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5391__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_34721(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_34731 = (function (m,state_map){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5393__auto__.call(null,m,state_map));
} else {
var m__5391__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5391__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_34731(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_34744 = (function (m,mode){
var x__5392__auto__ = (((m == null))?null:m);
var m__5393__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5393__auto__.call(null,m,mode));
} else {
var m__5391__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5391__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_34744(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5774__auto__ = [];
var len__5768__auto___34751 = arguments.length;
var i__5769__auto___34752 = (0);
while(true){
if((i__5769__auto___34752 < len__5768__auto___34751)){
args__5774__auto__.push((arguments[i__5769__auto___34752]));

var G__34754 = (i__5769__auto___34752 + (1));
i__5769__auto___34752 = G__34754;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((3) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5775__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32112){
var map__32113 = p__32112;
var map__32113__$1 = cljs.core.__destructure_map(map__32113);
var opts = map__32113__$1;
var statearr_32114_34757 = state;
(statearr_32114_34757[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32119_34761 = state;
(statearr_32119_34761[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32122_34762 = state;
(statearr_32122_34762[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32108){
var G__32109 = cljs.core.first(seq32108);
var seq32108__$1 = cljs.core.next(seq32108);
var G__32110 = cljs.core.first(seq32108__$1);
var seq32108__$2 = cljs.core.next(seq32108__$1);
var G__32111 = cljs.core.first(seq32108__$2);
var seq32108__$3 = cljs.core.next(seq32108__$2);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32109,G__32110,G__32111,seq32108__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32136 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32136 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32137){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32137 = meta32137;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32138,meta32137__$1){
var self__ = this;
var _32138__$1 = this;
return (new cljs.core.async.t_cljs$core$async32136(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32137__$1));
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32138){
var self__ = this;
var _32138__$1 = this;
return self__.meta32137;
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32136.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32136.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32137","meta32137",-1751224789,null)], null);
}));

(cljs.core.async.t_cljs$core$async32136.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32136.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32136");

(cljs.core.async.t_cljs$core$async32136.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async32136");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32136.
 */
cljs.core.async.__GT_t_cljs$core$async32136 = (function cljs$core$async$mix_$___GT_t_cljs$core$async32136(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32137){
return (new cljs.core.async.t_cljs$core$async32136(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32137));
});

}

return (new cljs.core.async.t_cljs$core$async32136(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30320__auto___34795 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_32229){
var state_val_32230 = (state_32229[(1)]);
if((state_val_32230 === (7))){
var inst_32188 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
if(cljs.core.truth_(inst_32188)){
var statearr_32232_34801 = state_32229__$1;
(statearr_32232_34801[(1)] = (8));

} else {
var statearr_32233_34802 = state_32229__$1;
(statearr_32233_34802[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (20))){
var inst_32181 = (state_32229[(7)]);
var state_32229__$1 = state_32229;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32229__$1,(23),out,inst_32181);
} else {
if((state_val_32230 === (1))){
var inst_32159 = calc_state();
var inst_32160 = cljs.core.__destructure_map(inst_32159);
var inst_32161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32160,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32160,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32160,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32164 = inst_32159;
var state_32229__$1 = (function (){var statearr_32239 = state_32229;
(statearr_32239[(8)] = inst_32164);

(statearr_32239[(9)] = inst_32161);

(statearr_32239[(10)] = inst_32162);

(statearr_32239[(11)] = inst_32163);

return statearr_32239;
})();
var statearr_32240_34808 = state_32229__$1;
(statearr_32240_34808[(2)] = null);

(statearr_32240_34808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (24))){
var inst_32167 = (state_32229[(12)]);
var inst_32164 = inst_32167;
var state_32229__$1 = (function (){var statearr_32243 = state_32229;
(statearr_32243[(8)] = inst_32164);

return statearr_32243;
})();
var statearr_32246_34809 = state_32229__$1;
(statearr_32246_34809[(2)] = null);

(statearr_32246_34809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (4))){
var inst_32181 = (state_32229[(7)]);
var inst_32183 = (state_32229[(13)]);
var inst_32180 = (state_32229[(2)]);
var inst_32181__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32180,(0),null);
var inst_32182 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32180,(1),null);
var inst_32183__$1 = (inst_32181__$1 == null);
var state_32229__$1 = (function (){var statearr_32251 = state_32229;
(statearr_32251[(7)] = inst_32181__$1);

(statearr_32251[(14)] = inst_32182);

(statearr_32251[(13)] = inst_32183__$1);

return statearr_32251;
})();
if(cljs.core.truth_(inst_32183__$1)){
var statearr_32252_34810 = state_32229__$1;
(statearr_32252_34810[(1)] = (5));

} else {
var statearr_32254_34811 = state_32229__$1;
(statearr_32254_34811[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (15))){
var inst_32203 = (state_32229[(15)]);
var inst_32168 = (state_32229[(16)]);
var inst_32203__$1 = cljs.core.empty_QMARK_(inst_32168);
var state_32229__$1 = (function (){var statearr_32255 = state_32229;
(statearr_32255[(15)] = inst_32203__$1);

return statearr_32255;
})();
if(inst_32203__$1){
var statearr_32256_34813 = state_32229__$1;
(statearr_32256_34813[(1)] = (17));

} else {
var statearr_32258_34814 = state_32229__$1;
(statearr_32258_34814[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (21))){
var inst_32167 = (state_32229[(12)]);
var inst_32164 = inst_32167;
var state_32229__$1 = (function (){var statearr_32261 = state_32229;
(statearr_32261[(8)] = inst_32164);

return statearr_32261;
})();
var statearr_32263_34815 = state_32229__$1;
(statearr_32263_34815[(2)] = null);

(statearr_32263_34815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (13))){
var inst_32196 = (state_32229[(2)]);
var inst_32197 = calc_state();
var inst_32164 = inst_32197;
var state_32229__$1 = (function (){var statearr_32266 = state_32229;
(statearr_32266[(8)] = inst_32164);

(statearr_32266[(17)] = inst_32196);

return statearr_32266;
})();
var statearr_32267_34818 = state_32229__$1;
(statearr_32267_34818[(2)] = null);

(statearr_32267_34818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (22))){
var inst_32223 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
var statearr_32272_34825 = state_32229__$1;
(statearr_32272_34825[(2)] = inst_32223);

(statearr_32272_34825[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (6))){
var inst_32182 = (state_32229[(14)]);
var inst_32186 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32182,change);
var state_32229__$1 = state_32229;
var statearr_32274_34827 = state_32229__$1;
(statearr_32274_34827[(2)] = inst_32186);

(statearr_32274_34827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (25))){
var state_32229__$1 = state_32229;
var statearr_32283_34832 = state_32229__$1;
(statearr_32283_34832[(2)] = null);

(statearr_32283_34832[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (17))){
var inst_32182 = (state_32229[(14)]);
var inst_32170 = (state_32229[(18)]);
var inst_32205 = (inst_32170.cljs$core$IFn$_invoke$arity$1 ? inst_32170.cljs$core$IFn$_invoke$arity$1(inst_32182) : inst_32170.call(null,inst_32182));
var inst_32206 = cljs.core.not(inst_32205);
var state_32229__$1 = state_32229;
var statearr_32285_34840 = state_32229__$1;
(statearr_32285_34840[(2)] = inst_32206);

(statearr_32285_34840[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (3))){
var inst_32227 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32229__$1,inst_32227);
} else {
if((state_val_32230 === (12))){
var state_32229__$1 = state_32229;
var statearr_32293_34852 = state_32229__$1;
(statearr_32293_34852[(2)] = null);

(statearr_32293_34852[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (2))){
var inst_32164 = (state_32229[(8)]);
var inst_32167 = (state_32229[(12)]);
var inst_32167__$1 = cljs.core.__destructure_map(inst_32164);
var inst_32168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32167__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32167__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32167__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32229__$1 = (function (){var statearr_32296 = state_32229;
(statearr_32296[(18)] = inst_32170);

(statearr_32296[(12)] = inst_32167__$1);

(statearr_32296[(16)] = inst_32168);

return statearr_32296;
})();
return cljs.core.async.ioc_alts_BANG_(state_32229__$1,(4),inst_32171);
} else {
if((state_val_32230 === (23))){
var inst_32214 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
if(cljs.core.truth_(inst_32214)){
var statearr_32301_34856 = state_32229__$1;
(statearr_32301_34856[(1)] = (24));

} else {
var statearr_32302_34857 = state_32229__$1;
(statearr_32302_34857[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (19))){
var inst_32209 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
var statearr_32307_34858 = state_32229__$1;
(statearr_32307_34858[(2)] = inst_32209);

(statearr_32307_34858[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (11))){
var inst_32182 = (state_32229[(14)]);
var inst_32193 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32182);
var state_32229__$1 = state_32229;
var statearr_32313_34859 = state_32229__$1;
(statearr_32313_34859[(2)] = inst_32193);

(statearr_32313_34859[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (9))){
var inst_32182 = (state_32229[(14)]);
var inst_32200 = (state_32229[(19)]);
var inst_32168 = (state_32229[(16)]);
var inst_32200__$1 = (inst_32168.cljs$core$IFn$_invoke$arity$1 ? inst_32168.cljs$core$IFn$_invoke$arity$1(inst_32182) : inst_32168.call(null,inst_32182));
var state_32229__$1 = (function (){var statearr_32316 = state_32229;
(statearr_32316[(19)] = inst_32200__$1);

return statearr_32316;
})();
if(cljs.core.truth_(inst_32200__$1)){
var statearr_32318_34864 = state_32229__$1;
(statearr_32318_34864[(1)] = (14));

} else {
var statearr_32319_34865 = state_32229__$1;
(statearr_32319_34865[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (5))){
var inst_32183 = (state_32229[(13)]);
var state_32229__$1 = state_32229;
var statearr_32323_34870 = state_32229__$1;
(statearr_32323_34870[(2)] = inst_32183);

(statearr_32323_34870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (14))){
var inst_32200 = (state_32229[(19)]);
var state_32229__$1 = state_32229;
var statearr_32325_34878 = state_32229__$1;
(statearr_32325_34878[(2)] = inst_32200);

(statearr_32325_34878[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (26))){
var inst_32219 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
var statearr_32329_34883 = state_32229__$1;
(statearr_32329_34883[(2)] = inst_32219);

(statearr_32329_34883[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (16))){
var inst_32211 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
if(cljs.core.truth_(inst_32211)){
var statearr_32330_34885 = state_32229__$1;
(statearr_32330_34885[(1)] = (20));

} else {
var statearr_32331_34886 = state_32229__$1;
(statearr_32331_34886[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (10))){
var inst_32225 = (state_32229[(2)]);
var state_32229__$1 = state_32229;
var statearr_32333_34890 = state_32229__$1;
(statearr_32333_34890[(2)] = inst_32225);

(statearr_32333_34890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (18))){
var inst_32203 = (state_32229[(15)]);
var state_32229__$1 = state_32229;
var statearr_32334_34894 = state_32229__$1;
(statearr_32334_34894[(2)] = inst_32203);

(statearr_32334_34894[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32230 === (8))){
var inst_32181 = (state_32229[(7)]);
var inst_32190 = (inst_32181 == null);
var state_32229__$1 = state_32229;
if(cljs.core.truth_(inst_32190)){
var statearr_32337_34895 = state_32229__$1;
(statearr_32337_34895[(1)] = (11));

} else {
var statearr_32339_34896 = state_32229__$1;
(statearr_32339_34896[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__29992__auto__ = null;
var cljs$core$async$mix_$_state_machine__29992__auto____0 = (function (){
var statearr_32341 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32341[(0)] = cljs$core$async$mix_$_state_machine__29992__auto__);

(statearr_32341[(1)] = (1));

return statearr_32341;
});
var cljs$core$async$mix_$_state_machine__29992__auto____1 = (function (state_32229){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_32229);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e32342){var ex__29995__auto__ = e32342;
var statearr_32343_34900 = state_32229;
(statearr_32343_34900[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_32229[(4)]))){
var statearr_32347_34901 = state_32229;
(statearr_32347_34901[(1)] = cljs.core.first((state_32229[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34909 = state_32229;
state_32229 = G__34909;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29992__auto__ = function(state_32229){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29992__auto____1.call(this,state_32229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29992__auto____0;
cljs$core$async$mix_$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29992__auto____1;
return cljs$core$async$mix_$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_32349 = f__30321__auto__();
(statearr_32349[(6)] = c__30320__auto___34795);

return statearr_32349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_34919 = (function (p,v,ch,close_QMARK_){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5393__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5391__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5391__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_34919(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_34924 = (function (p,v,ch){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5393__auto__.call(null,p,v,ch));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5391__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_34924(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_34926 = (function() {
var G__34927 = null;
var G__34927__1 = (function (p){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5393__auto__.call(null,p));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5391__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__34927__2 = (function (p,v){
var x__5392__auto__ = (((p == null))?null:p);
var m__5393__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5393__auto__.call(null,p,v));
} else {
var m__5391__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5391__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__34927 = function(p,v){
switch(arguments.length){
case 1:
return G__34927__1.call(this,p);
case 2:
return G__34927__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34927.cljs$core$IFn$_invoke$arity$1 = G__34927__1;
G__34927.cljs$core$IFn$_invoke$arity$2 = G__34927__2;
return G__34927;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32410 = arguments.length;
switch (G__32410) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34926(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34926(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32434 = arguments.length;
switch (G__32434) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32420_SHARP_){
if(cljs.core.truth_((p1__32420_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32420_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32420_SHARP_.call(null,topic)))){
return p1__32420_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32420_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32448 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32448 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32449){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32449 = meta32449;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32450,meta32449__$1){
var self__ = this;
var _32450__$1 = this;
return (new cljs.core.async.t_cljs$core$async32448(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32449__$1));
}));

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32450){
var self__ = this;
var _32450__$1 = this;
return self__.meta32449;
}));

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32448.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32448.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32449","meta32449",27676320,null)], null);
}));

(cljs.core.async.t_cljs$core$async32448.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32448.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32448");

(cljs.core.async.t_cljs$core$async32448.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async32448");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32448.
 */
cljs.core.async.__GT_t_cljs$core$async32448 = (function cljs$core$async$__GT_t_cljs$core$async32448(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32449){
return (new cljs.core.async.t_cljs$core$async32448(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32449));
});

}

return (new cljs.core.async.t_cljs$core$async32448(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30320__auto___34951 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_32578){
var state_val_32580 = (state_32578[(1)]);
if((state_val_32580 === (7))){
var inst_32572 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
var statearr_32588_34953 = state_32578__$1;
(statearr_32588_34953[(2)] = inst_32572);

(statearr_32588_34953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (20))){
var state_32578__$1 = state_32578;
var statearr_32591_34955 = state_32578__$1;
(statearr_32591_34955[(2)] = null);

(statearr_32591_34955[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (1))){
var state_32578__$1 = state_32578;
var statearr_32598_34957 = state_32578__$1;
(statearr_32598_34957[(2)] = null);

(statearr_32598_34957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (24))){
var inst_32554 = (state_32578[(7)]);
var inst_32564 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32554);
var state_32578__$1 = state_32578;
var statearr_32603_34958 = state_32578__$1;
(statearr_32603_34958[(2)] = inst_32564);

(statearr_32603_34958[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (4))){
var inst_32496 = (state_32578[(8)]);
var inst_32496__$1 = (state_32578[(2)]);
var inst_32497 = (inst_32496__$1 == null);
var state_32578__$1 = (function (){var statearr_32604 = state_32578;
(statearr_32604[(8)] = inst_32496__$1);

return statearr_32604;
})();
if(cljs.core.truth_(inst_32497)){
var statearr_32607_34966 = state_32578__$1;
(statearr_32607_34966[(1)] = (5));

} else {
var statearr_32609_34967 = state_32578__$1;
(statearr_32609_34967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (15))){
var inst_32547 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
var statearr_32611_34968 = state_32578__$1;
(statearr_32611_34968[(2)] = inst_32547);

(statearr_32611_34968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (21))){
var inst_32569 = (state_32578[(2)]);
var state_32578__$1 = (function (){var statearr_32612 = state_32578;
(statearr_32612[(9)] = inst_32569);

return statearr_32612;
})();
var statearr_32615_34969 = state_32578__$1;
(statearr_32615_34969[(2)] = null);

(statearr_32615_34969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (13))){
var inst_32526 = (state_32578[(10)]);
var inst_32528 = cljs.core.chunked_seq_QMARK_(inst_32526);
var state_32578__$1 = state_32578;
if(inst_32528){
var statearr_32616_34973 = state_32578__$1;
(statearr_32616_34973[(1)] = (16));

} else {
var statearr_32618_34975 = state_32578__$1;
(statearr_32618_34975[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (22))){
var inst_32560 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
if(cljs.core.truth_(inst_32560)){
var statearr_32621_34977 = state_32578__$1;
(statearr_32621_34977[(1)] = (23));

} else {
var statearr_32622_34978 = state_32578__$1;
(statearr_32622_34978[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (6))){
var inst_32496 = (state_32578[(8)]);
var inst_32556 = (state_32578[(11)]);
var inst_32554 = (state_32578[(7)]);
var inst_32554__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32496) : topic_fn.call(null,inst_32496));
var inst_32555 = cljs.core.deref(mults);
var inst_32556__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32555,inst_32554__$1);
var state_32578__$1 = (function (){var statearr_32629 = state_32578;
(statearr_32629[(11)] = inst_32556__$1);

(statearr_32629[(7)] = inst_32554__$1);

return statearr_32629;
})();
if(cljs.core.truth_(inst_32556__$1)){
var statearr_32633_34980 = state_32578__$1;
(statearr_32633_34980[(1)] = (19));

} else {
var statearr_32635_34982 = state_32578__$1;
(statearr_32635_34982[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (25))){
var inst_32566 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
var statearr_32636_34984 = state_32578__$1;
(statearr_32636_34984[(2)] = inst_32566);

(statearr_32636_34984[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (17))){
var inst_32526 = (state_32578[(10)]);
var inst_32536 = cljs.core.first(inst_32526);
var inst_32537 = cljs.core.async.muxch_STAR_(inst_32536);
var inst_32538 = cljs.core.async.close_BANG_(inst_32537);
var inst_32539 = cljs.core.next(inst_32526);
var inst_32507 = inst_32539;
var inst_32508 = null;
var inst_32509 = (0);
var inst_32510 = (0);
var state_32578__$1 = (function (){var statearr_32643 = state_32578;
(statearr_32643[(12)] = inst_32509);

(statearr_32643[(13)] = inst_32508);

(statearr_32643[(14)] = inst_32507);

(statearr_32643[(15)] = inst_32510);

(statearr_32643[(16)] = inst_32538);

return statearr_32643;
})();
var statearr_32644_34993 = state_32578__$1;
(statearr_32644_34993[(2)] = null);

(statearr_32644_34993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (3))){
var inst_32574 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32578__$1,inst_32574);
} else {
if((state_val_32580 === (12))){
var inst_32549 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
var statearr_32648_34996 = state_32578__$1;
(statearr_32648_34996[(2)] = inst_32549);

(statearr_32648_34996[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (2))){
var state_32578__$1 = state_32578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32578__$1,(4),ch);
} else {
if((state_val_32580 === (23))){
var state_32578__$1 = state_32578;
var statearr_32650_34997 = state_32578__$1;
(statearr_32650_34997[(2)] = null);

(statearr_32650_34997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (19))){
var inst_32496 = (state_32578[(8)]);
var inst_32556 = (state_32578[(11)]);
var inst_32558 = cljs.core.async.muxch_STAR_(inst_32556);
var state_32578__$1 = state_32578;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32578__$1,(22),inst_32558,inst_32496);
} else {
if((state_val_32580 === (11))){
var inst_32526 = (state_32578[(10)]);
var inst_32507 = (state_32578[(14)]);
var inst_32526__$1 = cljs.core.seq(inst_32507);
var state_32578__$1 = (function (){var statearr_32654 = state_32578;
(statearr_32654[(10)] = inst_32526__$1);

return statearr_32654;
})();
if(inst_32526__$1){
var statearr_32657_35001 = state_32578__$1;
(statearr_32657_35001[(1)] = (13));

} else {
var statearr_32658_35002 = state_32578__$1;
(statearr_32658_35002[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (9))){
var inst_32551 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
var statearr_32660_35007 = state_32578__$1;
(statearr_32660_35007[(2)] = inst_32551);

(statearr_32660_35007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (5))){
var inst_32504 = cljs.core.deref(mults);
var inst_32505 = cljs.core.vals(inst_32504);
var inst_32506 = cljs.core.seq(inst_32505);
var inst_32507 = inst_32506;
var inst_32508 = null;
var inst_32509 = (0);
var inst_32510 = (0);
var state_32578__$1 = (function (){var statearr_32670 = state_32578;
(statearr_32670[(12)] = inst_32509);

(statearr_32670[(13)] = inst_32508);

(statearr_32670[(14)] = inst_32507);

(statearr_32670[(15)] = inst_32510);

return statearr_32670;
})();
var statearr_32672_35008 = state_32578__$1;
(statearr_32672_35008[(2)] = null);

(statearr_32672_35008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (14))){
var state_32578__$1 = state_32578;
var statearr_32683_35009 = state_32578__$1;
(statearr_32683_35009[(2)] = null);

(statearr_32683_35009[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (16))){
var inst_32526 = (state_32578[(10)]);
var inst_32531 = cljs.core.chunk_first(inst_32526);
var inst_32532 = cljs.core.chunk_rest(inst_32526);
var inst_32533 = cljs.core.count(inst_32531);
var inst_32507 = inst_32532;
var inst_32508 = inst_32531;
var inst_32509 = inst_32533;
var inst_32510 = (0);
var state_32578__$1 = (function (){var statearr_32692 = state_32578;
(statearr_32692[(12)] = inst_32509);

(statearr_32692[(13)] = inst_32508);

(statearr_32692[(14)] = inst_32507);

(statearr_32692[(15)] = inst_32510);

return statearr_32692;
})();
var statearr_32693_35017 = state_32578__$1;
(statearr_32693_35017[(2)] = null);

(statearr_32693_35017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (10))){
var inst_32509 = (state_32578[(12)]);
var inst_32508 = (state_32578[(13)]);
var inst_32507 = (state_32578[(14)]);
var inst_32510 = (state_32578[(15)]);
var inst_32517 = cljs.core._nth(inst_32508,inst_32510);
var inst_32519 = cljs.core.async.muxch_STAR_(inst_32517);
var inst_32520 = cljs.core.async.close_BANG_(inst_32519);
var inst_32522 = (inst_32510 + (1));
var tmp32680 = inst_32509;
var tmp32681 = inst_32508;
var tmp32682 = inst_32507;
var inst_32507__$1 = tmp32682;
var inst_32508__$1 = tmp32681;
var inst_32509__$1 = tmp32680;
var inst_32510__$1 = inst_32522;
var state_32578__$1 = (function (){var statearr_32705 = state_32578;
(statearr_32705[(12)] = inst_32509__$1);

(statearr_32705[(13)] = inst_32508__$1);

(statearr_32705[(14)] = inst_32507__$1);

(statearr_32705[(15)] = inst_32510__$1);

(statearr_32705[(17)] = inst_32520);

return statearr_32705;
})();
var statearr_32706_35021 = state_32578__$1;
(statearr_32706_35021[(2)] = null);

(statearr_32706_35021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (18))){
var inst_32543 = (state_32578[(2)]);
var state_32578__$1 = state_32578;
var statearr_32710_35025 = state_32578__$1;
(statearr_32710_35025[(2)] = inst_32543);

(statearr_32710_35025[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32580 === (8))){
var inst_32509 = (state_32578[(12)]);
var inst_32510 = (state_32578[(15)]);
var inst_32512 = (inst_32510 < inst_32509);
var inst_32513 = inst_32512;
var state_32578__$1 = state_32578;
if(cljs.core.truth_(inst_32513)){
var statearr_32711_35029 = state_32578__$1;
(statearr_32711_35029[(1)] = (10));

} else {
var statearr_32713_35030 = state_32578__$1;
(statearr_32713_35030[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_32718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32718[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_32718[(1)] = (1));

return statearr_32718;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_32578){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_32578);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e32721){var ex__29995__auto__ = e32721;
var statearr_32722_35031 = state_32578;
(statearr_32722_35031[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_32578[(4)]))){
var statearr_32725_35032 = state_32578;
(statearr_32725_35032[(1)] = cljs.core.first((state_32578[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35033 = state_32578;
state_32578 = G__35033;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_32578){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_32578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_32728 = f__30321__auto__();
(statearr_32728[(6)] = c__30320__auto___34951);

return statearr_32728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32739 = arguments.length;
switch (G__32739) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32761 = arguments.length;
switch (G__32761) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32780 = arguments.length;
switch (G__32780) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30320__auto___35039 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_32862){
var state_val_32863 = (state_32862[(1)]);
if((state_val_32863 === (7))){
var state_32862__$1 = state_32862;
var statearr_32870_35041 = state_32862__$1;
(statearr_32870_35041[(2)] = null);

(statearr_32870_35041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (1))){
var state_32862__$1 = state_32862;
var statearr_32875_35048 = state_32862__$1;
(statearr_32875_35048[(2)] = null);

(statearr_32875_35048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (4))){
var inst_32803 = (state_32862[(7)]);
var inst_32802 = (state_32862[(8)]);
var inst_32807 = (inst_32803 < inst_32802);
var state_32862__$1 = state_32862;
if(cljs.core.truth_(inst_32807)){
var statearr_32877_35049 = state_32862__$1;
(statearr_32877_35049[(1)] = (6));

} else {
var statearr_32878_35050 = state_32862__$1;
(statearr_32878_35050[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (15))){
var inst_32846 = (state_32862[(9)]);
var inst_32851 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32846);
var state_32862__$1 = state_32862;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32862__$1,(17),out,inst_32851);
} else {
if((state_val_32863 === (13))){
var inst_32846 = (state_32862[(9)]);
var inst_32846__$1 = (state_32862[(2)]);
var inst_32847 = cljs.core.some(cljs.core.nil_QMARK_,inst_32846__$1);
var state_32862__$1 = (function (){var statearr_32888 = state_32862;
(statearr_32888[(9)] = inst_32846__$1);

return statearr_32888;
})();
if(cljs.core.truth_(inst_32847)){
var statearr_32889_35055 = state_32862__$1;
(statearr_32889_35055[(1)] = (14));

} else {
var statearr_32890_35057 = state_32862__$1;
(statearr_32890_35057[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (6))){
var state_32862__$1 = state_32862;
var statearr_32894_35058 = state_32862__$1;
(statearr_32894_35058[(2)] = null);

(statearr_32894_35058[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (17))){
var inst_32853 = (state_32862[(2)]);
var state_32862__$1 = (function (){var statearr_32905 = state_32862;
(statearr_32905[(10)] = inst_32853);

return statearr_32905;
})();
var statearr_32907_35060 = state_32862__$1;
(statearr_32907_35060[(2)] = null);

(statearr_32907_35060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (3))){
var inst_32858 = (state_32862[(2)]);
var state_32862__$1 = state_32862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32862__$1,inst_32858);
} else {
if((state_val_32863 === (12))){
var _ = (function (){var statearr_32913 = state_32862;
(statearr_32913[(4)] = cljs.core.rest((state_32862[(4)])));

return statearr_32913;
})();
var state_32862__$1 = state_32862;
var ex32904 = (state_32862__$1[(2)]);
var statearr_32914_35061 = state_32862__$1;
(statearr_32914_35061[(5)] = ex32904);


if((ex32904 instanceof Object)){
var statearr_32915_35062 = state_32862__$1;
(statearr_32915_35062[(1)] = (11));

(statearr_32915_35062[(5)] = null);

} else {
throw ex32904;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (2))){
var inst_32800 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32802 = cnt;
var inst_32803 = (0);
var state_32862__$1 = (function (){var statearr_32925 = state_32862;
(statearr_32925[(7)] = inst_32803);

(statearr_32925[(8)] = inst_32802);

(statearr_32925[(11)] = inst_32800);

return statearr_32925;
})();
var statearr_32926_35063 = state_32862__$1;
(statearr_32926_35063[(2)] = null);

(statearr_32926_35063[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (11))){
var inst_32817 = (state_32862[(2)]);
var inst_32818 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32862__$1 = (function (){var statearr_32927 = state_32862;
(statearr_32927[(12)] = inst_32817);

return statearr_32927;
})();
var statearr_32931_35064 = state_32862__$1;
(statearr_32931_35064[(2)] = inst_32818);

(statearr_32931_35064[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (9))){
var inst_32803 = (state_32862[(7)]);
var _ = (function (){var statearr_32935 = state_32862;
(statearr_32935[(4)] = cljs.core.cons((12),(state_32862[(4)])));

return statearr_32935;
})();
var inst_32827 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32803) : chs__$1.call(null,inst_32803));
var inst_32828 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32803) : done.call(null,inst_32803));
var inst_32829 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32827,inst_32828);
var ___$1 = (function (){var statearr_32936 = state_32862;
(statearr_32936[(4)] = cljs.core.rest((state_32862[(4)])));

return statearr_32936;
})();
var state_32862__$1 = state_32862;
var statearr_32940_35066 = state_32862__$1;
(statearr_32940_35066[(2)] = inst_32829);

(statearr_32940_35066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (5))){
var inst_32844 = (state_32862[(2)]);
var state_32862__$1 = (function (){var statearr_32942 = state_32862;
(statearr_32942[(13)] = inst_32844);

return statearr_32942;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32862__$1,(13),dchan);
} else {
if((state_val_32863 === (14))){
var inst_32849 = cljs.core.async.close_BANG_(out);
var state_32862__$1 = state_32862;
var statearr_32943_35069 = state_32862__$1;
(statearr_32943_35069[(2)] = inst_32849);

(statearr_32943_35069[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (16))){
var inst_32856 = (state_32862[(2)]);
var state_32862__$1 = state_32862;
var statearr_32947_35070 = state_32862__$1;
(statearr_32947_35070[(2)] = inst_32856);

(statearr_32947_35070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (10))){
var inst_32803 = (state_32862[(7)]);
var inst_32832 = (state_32862[(2)]);
var inst_32837 = (inst_32803 + (1));
var inst_32803__$1 = inst_32837;
var state_32862__$1 = (function (){var statearr_32949 = state_32862;
(statearr_32949[(7)] = inst_32803__$1);

(statearr_32949[(14)] = inst_32832);

return statearr_32949;
})();
var statearr_32950_35077 = state_32862__$1;
(statearr_32950_35077[(2)] = null);

(statearr_32950_35077[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32863 === (8))){
var inst_32842 = (state_32862[(2)]);
var state_32862__$1 = state_32862;
var statearr_32951_35078 = state_32862__$1;
(statearr_32951_35078[(2)] = inst_32842);

(statearr_32951_35078[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_32953 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32953[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_32953[(1)] = (1));

return statearr_32953;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_32862){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_32862);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e32954){var ex__29995__auto__ = e32954;
var statearr_32955_35089 = state_32862;
(statearr_32955_35089[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_32862[(4)]))){
var statearr_32956_35093 = state_32862;
(statearr_32956_35093[(1)] = cljs.core.first((state_32862[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35094 = state_32862;
state_32862 = G__35094;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_32862){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_32862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_32957 = f__30321__auto__();
(statearr_32957[(6)] = c__30320__auto___35039);

return statearr_32957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32967 = arguments.length;
switch (G__32967) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30320__auto___35102 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33021){
var state_val_33022 = (state_33021[(1)]);
if((state_val_33022 === (7))){
var inst_32984 = (state_33021[(7)]);
var inst_32983 = (state_33021[(8)]);
var inst_32983__$1 = (state_33021[(2)]);
var inst_32984__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32983__$1,(0),null);
var inst_32985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32983__$1,(1),null);
var inst_32986 = (inst_32984__$1 == null);
var state_33021__$1 = (function (){var statearr_33025 = state_33021;
(statearr_33025[(7)] = inst_32984__$1);

(statearr_33025[(9)] = inst_32985);

(statearr_33025[(8)] = inst_32983__$1);

return statearr_33025;
})();
if(cljs.core.truth_(inst_32986)){
var statearr_33026_35107 = state_33021__$1;
(statearr_33026_35107[(1)] = (8));

} else {
var statearr_33027_35112 = state_33021__$1;
(statearr_33027_35112[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (1))){
var inst_32973 = cljs.core.vec(chs);
var inst_32974 = inst_32973;
var state_33021__$1 = (function (){var statearr_33028 = state_33021;
(statearr_33028[(10)] = inst_32974);

return statearr_33028;
})();
var statearr_33029_35115 = state_33021__$1;
(statearr_33029_35115[(2)] = null);

(statearr_33029_35115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (4))){
var inst_32974 = (state_33021[(10)]);
var state_33021__$1 = state_33021;
return cljs.core.async.ioc_alts_BANG_(state_33021__$1,(7),inst_32974);
} else {
if((state_val_33022 === (6))){
var inst_33016 = (state_33021[(2)]);
var state_33021__$1 = state_33021;
var statearr_33040_35120 = state_33021__$1;
(statearr_33040_35120[(2)] = inst_33016);

(statearr_33040_35120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (3))){
var inst_33018 = (state_33021[(2)]);
var state_33021__$1 = state_33021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33021__$1,inst_33018);
} else {
if((state_val_33022 === (2))){
var inst_32974 = (state_33021[(10)]);
var inst_32976 = cljs.core.count(inst_32974);
var inst_32977 = (inst_32976 > (0));
var state_33021__$1 = state_33021;
if(cljs.core.truth_(inst_32977)){
var statearr_33046_35121 = state_33021__$1;
(statearr_33046_35121[(1)] = (4));

} else {
var statearr_33047_35122 = state_33021__$1;
(statearr_33047_35122[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (11))){
var inst_32974 = (state_33021[(10)]);
var inst_33008 = (state_33021[(2)]);
var tmp33041 = inst_32974;
var inst_32974__$1 = tmp33041;
var state_33021__$1 = (function (){var statearr_33052 = state_33021;
(statearr_33052[(11)] = inst_33008);

(statearr_33052[(10)] = inst_32974__$1);

return statearr_33052;
})();
var statearr_33054_35125 = state_33021__$1;
(statearr_33054_35125[(2)] = null);

(statearr_33054_35125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (9))){
var inst_32984 = (state_33021[(7)]);
var state_33021__$1 = state_33021;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33021__$1,(11),out,inst_32984);
} else {
if((state_val_33022 === (5))){
var inst_33014 = cljs.core.async.close_BANG_(out);
var state_33021__$1 = state_33021;
var statearr_33058_35129 = state_33021__$1;
(statearr_33058_35129[(2)] = inst_33014);

(statearr_33058_35129[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (10))){
var inst_33011 = (state_33021[(2)]);
var state_33021__$1 = state_33021;
var statearr_33061_35130 = state_33021__$1;
(statearr_33061_35130[(2)] = inst_33011);

(statearr_33061_35130[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33022 === (8))){
var inst_32984 = (state_33021[(7)]);
var inst_32985 = (state_33021[(9)]);
var inst_32974 = (state_33021[(10)]);
var inst_32983 = (state_33021[(8)]);
var inst_33000 = (function (){var cs = inst_32974;
var vec__32979 = inst_32983;
var v = inst_32984;
var c = inst_32985;
return (function (p1__32958_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32958_SHARP_);
});
})();
var inst_33001 = cljs.core.filterv(inst_33000,inst_32974);
var inst_32974__$1 = inst_33001;
var state_33021__$1 = (function (){var statearr_33075 = state_33021;
(statearr_33075[(10)] = inst_32974__$1);

return statearr_33075;
})();
var statearr_33076_35139 = state_33021__$1;
(statearr_33076_35139[(2)] = null);

(statearr_33076_35139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_33080 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33080[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_33080[(1)] = (1));

return statearr_33080;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_33021){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33021);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33081){var ex__29995__auto__ = e33081;
var statearr_33082_35140 = state_33021;
(statearr_33082_35140[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33021[(4)]))){
var statearr_33083_35141 = state_33021;
(statearr_33083_35141[(1)] = cljs.core.first((state_33021[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35142 = state_33021;
state_33021 = G__35142;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_33021){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_33021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33093 = f__30321__auto__();
(statearr_33093[(6)] = c__30320__auto___35102);

return statearr_33093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33099 = arguments.length;
switch (G__33099) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30320__auto___35150 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33136){
var state_val_33138 = (state_33136[(1)]);
if((state_val_33138 === (7))){
var inst_33112 = (state_33136[(7)]);
var inst_33112__$1 = (state_33136[(2)]);
var inst_33114 = (inst_33112__$1 == null);
var inst_33115 = cljs.core.not(inst_33114);
var state_33136__$1 = (function (){var statearr_33147 = state_33136;
(statearr_33147[(7)] = inst_33112__$1);

return statearr_33147;
})();
if(inst_33115){
var statearr_33148_35151 = state_33136__$1;
(statearr_33148_35151[(1)] = (8));

} else {
var statearr_33149_35152 = state_33136__$1;
(statearr_33149_35152[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (1))){
var inst_33106 = (0);
var state_33136__$1 = (function (){var statearr_33152 = state_33136;
(statearr_33152[(8)] = inst_33106);

return statearr_33152;
})();
var statearr_33154_35154 = state_33136__$1;
(statearr_33154_35154[(2)] = null);

(statearr_33154_35154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (4))){
var state_33136__$1 = state_33136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33136__$1,(7),ch);
} else {
if((state_val_33138 === (6))){
var inst_33131 = (state_33136[(2)]);
var state_33136__$1 = state_33136;
var statearr_33155_35155 = state_33136__$1;
(statearr_33155_35155[(2)] = inst_33131);

(statearr_33155_35155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (3))){
var inst_33133 = (state_33136[(2)]);
var inst_33134 = cljs.core.async.close_BANG_(out);
var state_33136__$1 = (function (){var statearr_33157 = state_33136;
(statearr_33157[(9)] = inst_33133);

return statearr_33157;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33136__$1,inst_33134);
} else {
if((state_val_33138 === (2))){
var inst_33106 = (state_33136[(8)]);
var inst_33108 = (inst_33106 < n);
var state_33136__$1 = state_33136;
if(cljs.core.truth_(inst_33108)){
var statearr_33159_35158 = state_33136__$1;
(statearr_33159_35158[(1)] = (4));

} else {
var statearr_33160_35162 = state_33136__$1;
(statearr_33160_35162[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (11))){
var inst_33106 = (state_33136[(8)]);
var inst_33122 = (state_33136[(2)]);
var inst_33124 = (inst_33106 + (1));
var inst_33106__$1 = inst_33124;
var state_33136__$1 = (function (){var statearr_33164 = state_33136;
(statearr_33164[(8)] = inst_33106__$1);

(statearr_33164[(10)] = inst_33122);

return statearr_33164;
})();
var statearr_33168_35164 = state_33136__$1;
(statearr_33168_35164[(2)] = null);

(statearr_33168_35164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (9))){
var state_33136__$1 = state_33136;
var statearr_33172_35165 = state_33136__$1;
(statearr_33172_35165[(2)] = null);

(statearr_33172_35165[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (5))){
var state_33136__$1 = state_33136;
var statearr_33173_35166 = state_33136__$1;
(statearr_33173_35166[(2)] = null);

(statearr_33173_35166[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (10))){
var inst_33128 = (state_33136[(2)]);
var state_33136__$1 = state_33136;
var statearr_33174_35167 = state_33136__$1;
(statearr_33174_35167[(2)] = inst_33128);

(statearr_33174_35167[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33138 === (8))){
var inst_33112 = (state_33136[(7)]);
var state_33136__$1 = state_33136;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33136__$1,(11),out,inst_33112);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_33178 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33178[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_33178[(1)] = (1));

return statearr_33178;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_33136){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33136);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33179){var ex__29995__auto__ = e33179;
var statearr_33182_35169 = state_33136;
(statearr_33182_35169[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33136[(4)]))){
var statearr_33192_35170 = state_33136;
(statearr_33192_35170[(1)] = cljs.core.first((state_33136[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35175 = state_33136;
state_33136 = G__35175;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_33136){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_33136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33195 = f__30321__auto__();
(statearr_33195[(6)] = c__30320__auto___35150);

return statearr_33195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33197 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33197 = (function (f,ch,meta33198){
this.f = f;
this.ch = ch;
this.meta33198 = meta33198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33199,meta33198__$1){
var self__ = this;
var _33199__$1 = this;
return (new cljs.core.async.t_cljs$core$async33197(self__.f,self__.ch,meta33198__$1));
}));

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33199){
var self__ = this;
var _33199__$1 = this;
return self__.meta33198;
}));

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33215 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33215 = (function (f,ch,meta33198,_,fn1,meta33216){
this.f = f;
this.ch = ch;
this.meta33198 = meta33198;
this._ = _;
this.fn1 = fn1;
this.meta33216 = meta33216;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33215.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33217,meta33216__$1){
var self__ = this;
var _33217__$1 = this;
return (new cljs.core.async.t_cljs$core$async33215(self__.f,self__.ch,self__.meta33198,self__._,self__.fn1,meta33216__$1));
}));

(cljs.core.async.t_cljs$core$async33215.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33217){
var self__ = this;
var _33217__$1 = this;
return self__.meta33216;
}));

(cljs.core.async.t_cljs$core$async33215.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33215.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33215.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33215.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33196_SHARP_){
var G__33225 = (((p1__33196_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33196_SHARP_) : self__.f.call(null,p1__33196_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33225) : f1.call(null,G__33225));
});
}));

(cljs.core.async.t_cljs$core$async33215.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33198","meta33198",-1356973235,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33197","cljs.core.async/t_cljs$core$async33197",1293450695,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33216","meta33216",1195399493,null)], null);
}));

(cljs.core.async.t_cljs$core$async33215.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33215.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33215");

(cljs.core.async.t_cljs$core$async33215.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async33215");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33215.
 */
cljs.core.async.__GT_t_cljs$core$async33215 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33215(f__$1,ch__$1,meta33198__$1,___$2,fn1__$1,meta33216){
return (new cljs.core.async.t_cljs$core$async33215(f__$1,ch__$1,meta33198__$1,___$2,fn1__$1,meta33216));
});

}

return (new cljs.core.async.t_cljs$core$async33215(self__.f,self__.ch,self__.meta33198,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33238 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33238) : self__.f.call(null,G__33238));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33197.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33198","meta33198",-1356973235,null)], null);
}));

(cljs.core.async.t_cljs$core$async33197.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33197.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33197");

(cljs.core.async.t_cljs$core$async33197.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async33197");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33197.
 */
cljs.core.async.__GT_t_cljs$core$async33197 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33197(f__$1,ch__$1,meta33198){
return (new cljs.core.async.t_cljs$core$async33197(f__$1,ch__$1,meta33198));
});

}

return (new cljs.core.async.t_cljs$core$async33197(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33253 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33253 = (function (f,ch,meta33254){
this.f = f;
this.ch = ch;
this.meta33254 = meta33254;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33255,meta33254__$1){
var self__ = this;
var _33255__$1 = this;
return (new cljs.core.async.t_cljs$core$async33253(self__.f,self__.ch,meta33254__$1));
}));

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33255){
var self__ = this;
var _33255__$1 = this;
return self__.meta33254;
}));

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33253.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33253.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33254","meta33254",2109345466,null)], null);
}));

(cljs.core.async.t_cljs$core$async33253.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33253.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33253");

(cljs.core.async.t_cljs$core$async33253.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async33253");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33253.
 */
cljs.core.async.__GT_t_cljs$core$async33253 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33253(f__$1,ch__$1,meta33254){
return (new cljs.core.async.t_cljs$core$async33253(f__$1,ch__$1,meta33254));
});

}

return (new cljs.core.async.t_cljs$core$async33253(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33279 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33279 = (function (p,ch,meta33280){
this.p = p;
this.ch = ch;
this.meta33280 = meta33280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33281,meta33280__$1){
var self__ = this;
var _33281__$1 = this;
return (new cljs.core.async.t_cljs$core$async33279(self__.p,self__.ch,meta33280__$1));
}));

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33281){
var self__ = this;
var _33281__$1 = this;
return self__.meta33280;
}));

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33279.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33279.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33280","meta33280",612049456,null)], null);
}));

(cljs.core.async.t_cljs$core$async33279.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33279.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33279");

(cljs.core.async.t_cljs$core$async33279.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"cljs.core.async/t_cljs$core$async33279");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33279.
 */
cljs.core.async.__GT_t_cljs$core$async33279 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33279(p__$1,ch__$1,meta33280){
return (new cljs.core.async.t_cljs$core$async33279(p__$1,ch__$1,meta33280));
});

}

return (new cljs.core.async.t_cljs$core$async33279(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33358 = arguments.length;
switch (G__33358) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30320__auto___35251 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33384){
var state_val_33385 = (state_33384[(1)]);
if((state_val_33385 === (7))){
var inst_33380 = (state_33384[(2)]);
var state_33384__$1 = state_33384;
var statearr_33390_35258 = state_33384__$1;
(statearr_33390_35258[(2)] = inst_33380);

(statearr_33390_35258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (1))){
var state_33384__$1 = state_33384;
var statearr_33391_35262 = state_33384__$1;
(statearr_33391_35262[(2)] = null);

(statearr_33391_35262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (4))){
var inst_33366 = (state_33384[(7)]);
var inst_33366__$1 = (state_33384[(2)]);
var inst_33367 = (inst_33366__$1 == null);
var state_33384__$1 = (function (){var statearr_33392 = state_33384;
(statearr_33392[(7)] = inst_33366__$1);

return statearr_33392;
})();
if(cljs.core.truth_(inst_33367)){
var statearr_33393_35269 = state_33384__$1;
(statearr_33393_35269[(1)] = (5));

} else {
var statearr_33394_35271 = state_33384__$1;
(statearr_33394_35271[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (6))){
var inst_33366 = (state_33384[(7)]);
var inst_33371 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33366) : p.call(null,inst_33366));
var state_33384__$1 = state_33384;
if(cljs.core.truth_(inst_33371)){
var statearr_33399_35275 = state_33384__$1;
(statearr_33399_35275[(1)] = (8));

} else {
var statearr_33404_35277 = state_33384__$1;
(statearr_33404_35277[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (3))){
var inst_33382 = (state_33384[(2)]);
var state_33384__$1 = state_33384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33384__$1,inst_33382);
} else {
if((state_val_33385 === (2))){
var state_33384__$1 = state_33384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33384__$1,(4),ch);
} else {
if((state_val_33385 === (11))){
var inst_33374 = (state_33384[(2)]);
var state_33384__$1 = state_33384;
var statearr_33422_35280 = state_33384__$1;
(statearr_33422_35280[(2)] = inst_33374);

(statearr_33422_35280[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (9))){
var state_33384__$1 = state_33384;
var statearr_33431_35282 = state_33384__$1;
(statearr_33431_35282[(2)] = null);

(statearr_33431_35282[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (5))){
var inst_33369 = cljs.core.async.close_BANG_(out);
var state_33384__$1 = state_33384;
var statearr_33432_35285 = state_33384__$1;
(statearr_33432_35285[(2)] = inst_33369);

(statearr_33432_35285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (10))){
var inst_33377 = (state_33384[(2)]);
var state_33384__$1 = (function (){var statearr_33433 = state_33384;
(statearr_33433[(8)] = inst_33377);

return statearr_33433;
})();
var statearr_33434_35286 = state_33384__$1;
(statearr_33434_35286[(2)] = null);

(statearr_33434_35286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33385 === (8))){
var inst_33366 = (state_33384[(7)]);
var state_33384__$1 = state_33384;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33384__$1,(11),out,inst_33366);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_33439 = [null,null,null,null,null,null,null,null,null];
(statearr_33439[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_33439[(1)] = (1));

return statearr_33439;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_33384){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33384);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33442){var ex__29995__auto__ = e33442;
var statearr_33443_35291 = state_33384;
(statearr_33443_35291[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33384[(4)]))){
var statearr_33444_35292 = state_33384;
(statearr_33444_35292[(1)] = cljs.core.first((state_33384[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35294 = state_33384;
state_33384 = G__35294;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_33384){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_33384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33447 = f__30321__auto__();
(statearr_33447[(6)] = c__30320__auto___35251);

return statearr_33447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33450 = arguments.length;
switch (G__33450) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30320__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33524){
var state_val_33525 = (state_33524[(1)]);
if((state_val_33525 === (7))){
var inst_33519 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33531_35307 = state_33524__$1;
(statearr_33531_35307[(2)] = inst_33519);

(statearr_33531_35307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (20))){
var inst_33484 = (state_33524[(7)]);
var inst_33496 = (state_33524[(2)]);
var inst_33497 = cljs.core.next(inst_33484);
var inst_33467 = inst_33497;
var inst_33468 = null;
var inst_33469 = (0);
var inst_33470 = (0);
var state_33524__$1 = (function (){var statearr_33535 = state_33524;
(statearr_33535[(8)] = inst_33468);

(statearr_33535[(9)] = inst_33469);

(statearr_33535[(10)] = inst_33470);

(statearr_33535[(11)] = inst_33467);

(statearr_33535[(12)] = inst_33496);

return statearr_33535;
})();
var statearr_33538_35315 = state_33524__$1;
(statearr_33538_35315[(2)] = null);

(statearr_33538_35315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (1))){
var state_33524__$1 = state_33524;
var statearr_33539_35317 = state_33524__$1;
(statearr_33539_35317[(2)] = null);

(statearr_33539_35317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (4))){
var inst_33456 = (state_33524[(13)]);
var inst_33456__$1 = (state_33524[(2)]);
var inst_33457 = (inst_33456__$1 == null);
var state_33524__$1 = (function (){var statearr_33540 = state_33524;
(statearr_33540[(13)] = inst_33456__$1);

return statearr_33540;
})();
if(cljs.core.truth_(inst_33457)){
var statearr_33541_35322 = state_33524__$1;
(statearr_33541_35322[(1)] = (5));

} else {
var statearr_33542_35323 = state_33524__$1;
(statearr_33542_35323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (15))){
var state_33524__$1 = state_33524;
var statearr_33546_35324 = state_33524__$1;
(statearr_33546_35324[(2)] = null);

(statearr_33546_35324[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (21))){
var state_33524__$1 = state_33524;
var statearr_33547_35325 = state_33524__$1;
(statearr_33547_35325[(2)] = null);

(statearr_33547_35325[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (13))){
var inst_33468 = (state_33524[(8)]);
var inst_33469 = (state_33524[(9)]);
var inst_33470 = (state_33524[(10)]);
var inst_33467 = (state_33524[(11)]);
var inst_33477 = (state_33524[(2)]);
var inst_33479 = (inst_33470 + (1));
var tmp33543 = inst_33468;
var tmp33544 = inst_33469;
var tmp33545 = inst_33467;
var inst_33467__$1 = tmp33545;
var inst_33468__$1 = tmp33543;
var inst_33469__$1 = tmp33544;
var inst_33470__$1 = inst_33479;
var state_33524__$1 = (function (){var statearr_33549 = state_33524;
(statearr_33549[(8)] = inst_33468__$1);

(statearr_33549[(9)] = inst_33469__$1);

(statearr_33549[(14)] = inst_33477);

(statearr_33549[(10)] = inst_33470__$1);

(statearr_33549[(11)] = inst_33467__$1);

return statearr_33549;
})();
var statearr_33550_35331 = state_33524__$1;
(statearr_33550_35331[(2)] = null);

(statearr_33550_35331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (22))){
var state_33524__$1 = state_33524;
var statearr_33552_35332 = state_33524__$1;
(statearr_33552_35332[(2)] = null);

(statearr_33552_35332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (6))){
var inst_33456 = (state_33524[(13)]);
var inst_33465 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33456) : f.call(null,inst_33456));
var inst_33466 = cljs.core.seq(inst_33465);
var inst_33467 = inst_33466;
var inst_33468 = null;
var inst_33469 = (0);
var inst_33470 = (0);
var state_33524__$1 = (function (){var statearr_33553 = state_33524;
(statearr_33553[(8)] = inst_33468);

(statearr_33553[(9)] = inst_33469);

(statearr_33553[(10)] = inst_33470);

(statearr_33553[(11)] = inst_33467);

return statearr_33553;
})();
var statearr_33554_35341 = state_33524__$1;
(statearr_33554_35341[(2)] = null);

(statearr_33554_35341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (17))){
var inst_33484 = (state_33524[(7)]);
var inst_33489 = cljs.core.chunk_first(inst_33484);
var inst_33490 = cljs.core.chunk_rest(inst_33484);
var inst_33491 = cljs.core.count(inst_33489);
var inst_33467 = inst_33490;
var inst_33468 = inst_33489;
var inst_33469 = inst_33491;
var inst_33470 = (0);
var state_33524__$1 = (function (){var statearr_33555 = state_33524;
(statearr_33555[(8)] = inst_33468);

(statearr_33555[(9)] = inst_33469);

(statearr_33555[(10)] = inst_33470);

(statearr_33555[(11)] = inst_33467);

return statearr_33555;
})();
var statearr_33556_35357 = state_33524__$1;
(statearr_33556_35357[(2)] = null);

(statearr_33556_35357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (3))){
var inst_33521 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33524__$1,inst_33521);
} else {
if((state_val_33525 === (12))){
var inst_33508 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33562_35375 = state_33524__$1;
(statearr_33562_35375[(2)] = inst_33508);

(statearr_33562_35375[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (2))){
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33524__$1,(4),in$);
} else {
if((state_val_33525 === (23))){
var inst_33517 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33571_35393 = state_33524__$1;
(statearr_33571_35393[(2)] = inst_33517);

(statearr_33571_35393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (19))){
var inst_33502 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33577_35408 = state_33524__$1;
(statearr_33577_35408[(2)] = inst_33502);

(statearr_33577_35408[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (11))){
var inst_33467 = (state_33524[(11)]);
var inst_33484 = (state_33524[(7)]);
var inst_33484__$1 = cljs.core.seq(inst_33467);
var state_33524__$1 = (function (){var statearr_33581 = state_33524;
(statearr_33581[(7)] = inst_33484__$1);

return statearr_33581;
})();
if(inst_33484__$1){
var statearr_33582_35425 = state_33524__$1;
(statearr_33582_35425[(1)] = (14));

} else {
var statearr_33584_35428 = state_33524__$1;
(statearr_33584_35428[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (9))){
var inst_33510 = (state_33524[(2)]);
var inst_33512 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33524__$1 = (function (){var statearr_33586 = state_33524;
(statearr_33586[(15)] = inst_33510);

return statearr_33586;
})();
if(cljs.core.truth_(inst_33512)){
var statearr_33587_35434 = state_33524__$1;
(statearr_33587_35434[(1)] = (21));

} else {
var statearr_33588_35435 = state_33524__$1;
(statearr_33588_35435[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (5))){
var inst_33459 = cljs.core.async.close_BANG_(out);
var state_33524__$1 = state_33524;
var statearr_33591_35438 = state_33524__$1;
(statearr_33591_35438[(2)] = inst_33459);

(statearr_33591_35438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (14))){
var inst_33484 = (state_33524[(7)]);
var inst_33487 = cljs.core.chunked_seq_QMARK_(inst_33484);
var state_33524__$1 = state_33524;
if(inst_33487){
var statearr_33592_35453 = state_33524__$1;
(statearr_33592_35453[(1)] = (17));

} else {
var statearr_33593_35454 = state_33524__$1;
(statearr_33593_35454[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (16))){
var inst_33506 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33594_35455 = state_33524__$1;
(statearr_33594_35455[(2)] = inst_33506);

(statearr_33594_35455[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33525 === (10))){
var inst_33468 = (state_33524[(8)]);
var inst_33470 = (state_33524[(10)]);
var inst_33475 = cljs.core._nth(inst_33468,inst_33470);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33524__$1,(13),out,inst_33475);
} else {
if((state_val_33525 === (18))){
var inst_33484 = (state_33524[(7)]);
var inst_33494 = cljs.core.first(inst_33484);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33524__$1,(20),out,inst_33494);
} else {
if((state_val_33525 === (8))){
var inst_33469 = (state_33524[(9)]);
var inst_33470 = (state_33524[(10)]);
var inst_33472 = (inst_33470 < inst_33469);
var inst_33473 = inst_33472;
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33473)){
var statearr_33607_35461 = state_33524__$1;
(statearr_33607_35461[(1)] = (10));

} else {
var statearr_33608_35462 = state_33524__$1;
(statearr_33608_35462[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29992__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29992__auto____0 = (function (){
var statearr_33609 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33609[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29992__auto__);

(statearr_33609[(1)] = (1));

return statearr_33609;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29992__auto____1 = (function (state_33524){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33524);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33610){var ex__29995__auto__ = e33610;
var statearr_33611_35464 = state_33524;
(statearr_33611_35464[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33524[(4)]))){
var statearr_33612_35467 = state_33524;
(statearr_33612_35467[(1)] = cljs.core.first((state_33524[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35473 = state_33524;
state_33524 = G__35473;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29992__auto__ = function(state_33524){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29992__auto____1.call(this,state_33524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29992__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29992__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33613 = f__30321__auto__();
(statearr_33613[(6)] = c__30320__auto__);

return statearr_33613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

return c__30320__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33615 = arguments.length;
switch (G__33615) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33622 = arguments.length;
switch (G__33622) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33631 = arguments.length;
switch (G__33631) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30320__auto___35496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33655){
var state_val_33656 = (state_33655[(1)]);
if((state_val_33656 === (7))){
var inst_33650 = (state_33655[(2)]);
var state_33655__$1 = state_33655;
var statearr_33659_35497 = state_33655__$1;
(statearr_33659_35497[(2)] = inst_33650);

(statearr_33659_35497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (1))){
var inst_33632 = null;
var state_33655__$1 = (function (){var statearr_33661 = state_33655;
(statearr_33661[(7)] = inst_33632);

return statearr_33661;
})();
var statearr_33662_35502 = state_33655__$1;
(statearr_33662_35502[(2)] = null);

(statearr_33662_35502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (4))){
var inst_33635 = (state_33655[(8)]);
var inst_33635__$1 = (state_33655[(2)]);
var inst_33636 = (inst_33635__$1 == null);
var inst_33637 = cljs.core.not(inst_33636);
var state_33655__$1 = (function (){var statearr_33663 = state_33655;
(statearr_33663[(8)] = inst_33635__$1);

return statearr_33663;
})();
if(inst_33637){
var statearr_33664_35510 = state_33655__$1;
(statearr_33664_35510[(1)] = (5));

} else {
var statearr_33665_35511 = state_33655__$1;
(statearr_33665_35511[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (6))){
var state_33655__$1 = state_33655;
var statearr_33666_35512 = state_33655__$1;
(statearr_33666_35512[(2)] = null);

(statearr_33666_35512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (3))){
var inst_33652 = (state_33655[(2)]);
var inst_33653 = cljs.core.async.close_BANG_(out);
var state_33655__$1 = (function (){var statearr_33670 = state_33655;
(statearr_33670[(9)] = inst_33652);

return statearr_33670;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33655__$1,inst_33653);
} else {
if((state_val_33656 === (2))){
var state_33655__$1 = state_33655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33655__$1,(4),ch);
} else {
if((state_val_33656 === (11))){
var inst_33635 = (state_33655[(8)]);
var inst_33644 = (state_33655[(2)]);
var inst_33632 = inst_33635;
var state_33655__$1 = (function (){var statearr_33671 = state_33655;
(statearr_33671[(7)] = inst_33632);

(statearr_33671[(10)] = inst_33644);

return statearr_33671;
})();
var statearr_33672_35524 = state_33655__$1;
(statearr_33672_35524[(2)] = null);

(statearr_33672_35524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (9))){
var inst_33635 = (state_33655[(8)]);
var state_33655__$1 = state_33655;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33655__$1,(11),out,inst_33635);
} else {
if((state_val_33656 === (5))){
var inst_33635 = (state_33655[(8)]);
var inst_33632 = (state_33655[(7)]);
var inst_33639 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33635,inst_33632);
var state_33655__$1 = state_33655;
if(inst_33639){
var statearr_33675_35527 = state_33655__$1;
(statearr_33675_35527[(1)] = (8));

} else {
var statearr_33676_35528 = state_33655__$1;
(statearr_33676_35528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (10))){
var inst_33647 = (state_33655[(2)]);
var state_33655__$1 = state_33655;
var statearr_33677_35531 = state_33655__$1;
(statearr_33677_35531[(2)] = inst_33647);

(statearr_33677_35531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33656 === (8))){
var inst_33632 = (state_33655[(7)]);
var tmp33674 = inst_33632;
var inst_33632__$1 = tmp33674;
var state_33655__$1 = (function (){var statearr_33678 = state_33655;
(statearr_33678[(7)] = inst_33632__$1);

return statearr_33678;
})();
var statearr_33679_35536 = state_33655__$1;
(statearr_33679_35536[(2)] = null);

(statearr_33679_35536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_33680 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33680[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_33680[(1)] = (1));

return statearr_33680;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_33655){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33655);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33682){var ex__29995__auto__ = e33682;
var statearr_33684_35537 = state_33655;
(statearr_33684_35537[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33655[(4)]))){
var statearr_33687_35540 = state_33655;
(statearr_33687_35540[(1)] = cljs.core.first((state_33655[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35541 = state_33655;
state_33655 = G__35541;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_33655){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_33655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33691 = f__30321__auto__();
(statearr_33691[(6)] = c__30320__auto___35496);

return statearr_33691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33695 = arguments.length;
switch (G__33695) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30320__auto___35551 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33738){
var state_val_33739 = (state_33738[(1)]);
if((state_val_33739 === (7))){
var inst_33734 = (state_33738[(2)]);
var state_33738__$1 = state_33738;
var statearr_33748_35553 = state_33738__$1;
(statearr_33748_35553[(2)] = inst_33734);

(statearr_33748_35553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (1))){
var inst_33698 = (new Array(n));
var inst_33699 = inst_33698;
var inst_33700 = (0);
var state_33738__$1 = (function (){var statearr_33749 = state_33738;
(statearr_33749[(7)] = inst_33700);

(statearr_33749[(8)] = inst_33699);

return statearr_33749;
})();
var statearr_33752_35554 = state_33738__$1;
(statearr_33752_35554[(2)] = null);

(statearr_33752_35554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (4))){
var inst_33703 = (state_33738[(9)]);
var inst_33703__$1 = (state_33738[(2)]);
var inst_33704 = (inst_33703__$1 == null);
var inst_33705 = cljs.core.not(inst_33704);
var state_33738__$1 = (function (){var statearr_33754 = state_33738;
(statearr_33754[(9)] = inst_33703__$1);

return statearr_33754;
})();
if(inst_33705){
var statearr_33759_35557 = state_33738__$1;
(statearr_33759_35557[(1)] = (5));

} else {
var statearr_33760_35558 = state_33738__$1;
(statearr_33760_35558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (15))){
var inst_33728 = (state_33738[(2)]);
var state_33738__$1 = state_33738;
var statearr_33761_35560 = state_33738__$1;
(statearr_33761_35560[(2)] = inst_33728);

(statearr_33761_35560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (13))){
var state_33738__$1 = state_33738;
var statearr_33762_35563 = state_33738__$1;
(statearr_33762_35563[(2)] = null);

(statearr_33762_35563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (6))){
var inst_33700 = (state_33738[(7)]);
var inst_33723 = (inst_33700 > (0));
var state_33738__$1 = state_33738;
if(cljs.core.truth_(inst_33723)){
var statearr_33763_35572 = state_33738__$1;
(statearr_33763_35572[(1)] = (12));

} else {
var statearr_33764_35573 = state_33738__$1;
(statearr_33764_35573[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (3))){
var inst_33736 = (state_33738[(2)]);
var state_33738__$1 = state_33738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33738__$1,inst_33736);
} else {
if((state_val_33739 === (12))){
var inst_33699 = (state_33738[(8)]);
var inst_33726 = cljs.core.vec(inst_33699);
var state_33738__$1 = state_33738;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33738__$1,(15),out,inst_33726);
} else {
if((state_val_33739 === (2))){
var state_33738__$1 = state_33738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33738__$1,(4),ch);
} else {
if((state_val_33739 === (11))){
var inst_33717 = (state_33738[(2)]);
var inst_33718 = (new Array(n));
var inst_33699 = inst_33718;
var inst_33700 = (0);
var state_33738__$1 = (function (){var statearr_33765 = state_33738;
(statearr_33765[(7)] = inst_33700);

(statearr_33765[(8)] = inst_33699);

(statearr_33765[(10)] = inst_33717);

return statearr_33765;
})();
var statearr_33766_35587 = state_33738__$1;
(statearr_33766_35587[(2)] = null);

(statearr_33766_35587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (9))){
var inst_33699 = (state_33738[(8)]);
var inst_33715 = cljs.core.vec(inst_33699);
var state_33738__$1 = state_33738;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33738__$1,(11),out,inst_33715);
} else {
if((state_val_33739 === (5))){
var inst_33700 = (state_33738[(7)]);
var inst_33699 = (state_33738[(8)]);
var inst_33709 = (state_33738[(11)]);
var inst_33703 = (state_33738[(9)]);
var inst_33707 = (inst_33699[inst_33700] = inst_33703);
var inst_33709__$1 = (inst_33700 + (1));
var inst_33711 = (inst_33709__$1 < n);
var state_33738__$1 = (function (){var statearr_33769 = state_33738;
(statearr_33769[(11)] = inst_33709__$1);

(statearr_33769[(12)] = inst_33707);

return statearr_33769;
})();
if(cljs.core.truth_(inst_33711)){
var statearr_33770_35598 = state_33738__$1;
(statearr_33770_35598[(1)] = (8));

} else {
var statearr_33771_35599 = state_33738__$1;
(statearr_33771_35599[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (14))){
var inst_33731 = (state_33738[(2)]);
var inst_33732 = cljs.core.async.close_BANG_(out);
var state_33738__$1 = (function (){var statearr_33773 = state_33738;
(statearr_33773[(13)] = inst_33731);

return statearr_33773;
})();
var statearr_33774_35601 = state_33738__$1;
(statearr_33774_35601[(2)] = inst_33732);

(statearr_33774_35601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (10))){
var inst_33721 = (state_33738[(2)]);
var state_33738__$1 = state_33738;
var statearr_33779_35602 = state_33738__$1;
(statearr_33779_35602[(2)] = inst_33721);

(statearr_33779_35602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33739 === (8))){
var inst_33699 = (state_33738[(8)]);
var inst_33709 = (state_33738[(11)]);
var tmp33772 = inst_33699;
var inst_33699__$1 = tmp33772;
var inst_33700 = inst_33709;
var state_33738__$1 = (function (){var statearr_33780 = state_33738;
(statearr_33780[(7)] = inst_33700);

(statearr_33780[(8)] = inst_33699__$1);

return statearr_33780;
})();
var statearr_33782_35608 = state_33738__$1;
(statearr_33782_35608[(2)] = null);

(statearr_33782_35608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_33783 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33783[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_33783[(1)] = (1));

return statearr_33783;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_33738){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33738);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33784){var ex__29995__auto__ = e33784;
var statearr_33785_35614 = state_33738;
(statearr_33785_35614[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33738[(4)]))){
var statearr_33786_35615 = state_33738;
(statearr_33786_35615[(1)] = cljs.core.first((state_33738[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35616 = state_33738;
state_33738 = G__35616;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_33738){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_33738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33791 = f__30321__auto__();
(statearr_33791[(6)] = c__30320__auto___35551);

return statearr_33791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33794 = arguments.length;
switch (G__33794) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30320__auto___35630 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_33853){
var state_val_33854 = (state_33853[(1)]);
if((state_val_33854 === (7))){
var inst_33847 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33868_35631 = state_33853__$1;
(statearr_33868_35631[(2)] = inst_33847);

(statearr_33868_35631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (1))){
var inst_33797 = [];
var inst_33798 = inst_33797;
var inst_33799 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33853__$1 = (function (){var statearr_33873 = state_33853;
(statearr_33873[(7)] = inst_33799);

(statearr_33873[(8)] = inst_33798);

return statearr_33873;
})();
var statearr_33886_35632 = state_33853__$1;
(statearr_33886_35632[(2)] = null);

(statearr_33886_35632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (4))){
var inst_33802 = (state_33853[(9)]);
var inst_33802__$1 = (state_33853[(2)]);
var inst_33806 = (inst_33802__$1 == null);
var inst_33808 = cljs.core.not(inst_33806);
var state_33853__$1 = (function (){var statearr_33893 = state_33853;
(statearr_33893[(9)] = inst_33802__$1);

return statearr_33893;
})();
if(inst_33808){
var statearr_33894_35633 = state_33853__$1;
(statearr_33894_35633[(1)] = (5));

} else {
var statearr_33895_35634 = state_33853__$1;
(statearr_33895_35634[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (15))){
var inst_33798 = (state_33853[(8)]);
var inst_33838 = cljs.core.vec(inst_33798);
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33853__$1,(18),out,inst_33838);
} else {
if((state_val_33854 === (13))){
var inst_33829 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33902_35635 = state_33853__$1;
(statearr_33902_35635[(2)] = inst_33829);

(statearr_33902_35635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (6))){
var inst_33798 = (state_33853[(8)]);
var inst_33835 = inst_33798.length;
var inst_33836 = (inst_33835 > (0));
var state_33853__$1 = state_33853;
if(cljs.core.truth_(inst_33836)){
var statearr_33905_35636 = state_33853__$1;
(statearr_33905_35636[(1)] = (15));

} else {
var statearr_33906_35637 = state_33853__$1;
(statearr_33906_35637[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (17))){
var inst_33844 = (state_33853[(2)]);
var inst_33845 = cljs.core.async.close_BANG_(out);
var state_33853__$1 = (function (){var statearr_33915 = state_33853;
(statearr_33915[(10)] = inst_33844);

return statearr_33915;
})();
var statearr_33922_35643 = state_33853__$1;
(statearr_33922_35643[(2)] = inst_33845);

(statearr_33922_35643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (3))){
var inst_33849 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33853__$1,inst_33849);
} else {
if((state_val_33854 === (12))){
var inst_33798 = (state_33853[(8)]);
var inst_33822 = cljs.core.vec(inst_33798);
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33853__$1,(14),out,inst_33822);
} else {
if((state_val_33854 === (2))){
var state_33853__$1 = state_33853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33853__$1,(4),ch);
} else {
if((state_val_33854 === (11))){
var inst_33802 = (state_33853[(9)]);
var inst_33798 = (state_33853[(8)]);
var inst_33810 = (state_33853[(11)]);
var inst_33819 = inst_33798.push(inst_33802);
var tmp33923 = inst_33798;
var inst_33798__$1 = tmp33923;
var inst_33799 = inst_33810;
var state_33853__$1 = (function (){var statearr_33930 = state_33853;
(statearr_33930[(7)] = inst_33799);

(statearr_33930[(8)] = inst_33798__$1);

(statearr_33930[(12)] = inst_33819);

return statearr_33930;
})();
var statearr_33931_35658 = state_33853__$1;
(statearr_33931_35658[(2)] = null);

(statearr_33931_35658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (9))){
var inst_33799 = (state_33853[(7)]);
var inst_33815 = cljs.core.keyword_identical_QMARK_(inst_33799,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_33853__$1 = state_33853;
var statearr_33934_35667 = state_33853__$1;
(statearr_33934_35667[(2)] = inst_33815);

(statearr_33934_35667[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (5))){
var inst_33799 = (state_33853[(7)]);
var inst_33811 = (state_33853[(13)]);
var inst_33802 = (state_33853[(9)]);
var inst_33810 = (state_33853[(11)]);
var inst_33810__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33802) : f.call(null,inst_33802));
var inst_33811__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33810__$1,inst_33799);
var state_33853__$1 = (function (){var statearr_33938 = state_33853;
(statearr_33938[(13)] = inst_33811__$1);

(statearr_33938[(11)] = inst_33810__$1);

return statearr_33938;
})();
if(inst_33811__$1){
var statearr_33939_35668 = state_33853__$1;
(statearr_33939_35668[(1)] = (8));

} else {
var statearr_33940_35669 = state_33853__$1;
(statearr_33940_35669[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (14))){
var inst_33802 = (state_33853[(9)]);
var inst_33810 = (state_33853[(11)]);
var inst_33824 = (state_33853[(2)]);
var inst_33825 = [];
var inst_33826 = inst_33825.push(inst_33802);
var inst_33798 = inst_33825;
var inst_33799 = inst_33810;
var state_33853__$1 = (function (){var statearr_33941 = state_33853;
(statearr_33941[(14)] = inst_33824);

(statearr_33941[(7)] = inst_33799);

(statearr_33941[(15)] = inst_33826);

(statearr_33941[(8)] = inst_33798);

return statearr_33941;
})();
var statearr_33946_35678 = state_33853__$1;
(statearr_33946_35678[(2)] = null);

(statearr_33946_35678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (16))){
var state_33853__$1 = state_33853;
var statearr_33950_35686 = state_33853__$1;
(statearr_33950_35686[(2)] = null);

(statearr_33950_35686[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (10))){
var inst_33817 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
if(cljs.core.truth_(inst_33817)){
var statearr_33951_35689 = state_33853__$1;
(statearr_33951_35689[(1)] = (11));

} else {
var statearr_33952_35691 = state_33853__$1;
(statearr_33952_35691[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (18))){
var inst_33840 = (state_33853[(2)]);
var state_33853__$1 = state_33853;
var statearr_33953_35700 = state_33853__$1;
(statearr_33953_35700[(2)] = inst_33840);

(statearr_33953_35700[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33854 === (8))){
var inst_33811 = (state_33853[(13)]);
var state_33853__$1 = state_33853;
var statearr_33957_35703 = state_33853__$1;
(statearr_33957_35703[(2)] = inst_33811);

(statearr_33957_35703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29992__auto__ = null;
var cljs$core$async$state_machine__29992__auto____0 = (function (){
var statearr_33958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33958[(0)] = cljs$core$async$state_machine__29992__auto__);

(statearr_33958[(1)] = (1));

return statearr_33958;
});
var cljs$core$async$state_machine__29992__auto____1 = (function (state_33853){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_33853);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e33959){var ex__29995__auto__ = e33959;
var statearr_33962_35718 = state_33853;
(statearr_33962_35718[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_33853[(4)]))){
var statearr_33965_35720 = state_33853;
(statearr_33965_35720[(1)] = cljs.core.first((state_33853[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35721 = state_33853;
state_33853 = G__35721;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
cljs$core$async$state_machine__29992__auto__ = function(state_33853){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29992__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29992__auto____1.call(this,state_33853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29992__auto____0;
cljs$core$async$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29992__auto____1;
return cljs$core$async$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_33970 = f__30321__auto__();
(statearr_33970[(6)] = c__30320__auto___35630);

return statearr_33970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
