goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41872 = schema.utils.use_fn_validation;
var output_schema41401_41873 = schema.core.Bool;
var input_schema41402_41874 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41403_41875 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41402_41874);
}),null));
var output_checker41404_41876 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41401_41873);
}),null));
var ret__39944__auto___41877 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41405){
var validate__37818__auto__ = cljs.core.deref(ufv___41872);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___41878 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41405], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41413_41879 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41414_41880 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41415_41881 = input_schema41402_41874;
var G__41416_41882 = cljs.core.deref(input_checker41403_41875);
var G__41417_41883 = args__37819__auto___41878;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41413_41879,G__41414_41880,G__41415_41881,G__41416_41882,G__41417_41883) : schema.core.fn_validator.call(null,G__41413_41879,G__41414_41880,G__41415_41881,G__41416_41882,G__41417_41883));
} else {
var temp__5804__auto___41884 = (function (){var fexpr__41418 = cljs.core.deref(input_checker41403_41875);
return (fexpr__41418.cljs$core$IFn$_invoke$arity$1 ? fexpr__41418.cljs$core$IFn$_invoke$arity$1(args__37819__auto___41878) : fexpr__41418.call(null,args__37819__auto___41878));
})();
if(cljs.core.truth_(temp__5804__auto___41884)){
var error__37820__auto___41885 = temp__5804__auto___41884;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41885], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41402_41874,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___41878,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41885], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var arg = G__41405;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41419_41886 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41420_41887 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41421_41888 = output_schema41401_41873;
var G__41422_41889 = cljs.core.deref(output_checker41404_41876);
var G__41423_41890 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41419_41886,G__41420_41887,G__41421_41888,G__41422_41889,G__41423_41890) : schema.core.fn_validator.call(null,G__41419_41886,G__41420_41887,G__41421_41888,G__41422_41889,G__41423_41890));
} else {
var temp__5804__auto___41891 = (function (){var fexpr__41425 = cljs.core.deref(output_checker41404_41876);
return (fexpr__41425.cljs$core$IFn$_invoke$arity$1 ? fexpr__41425.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41425.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41891)){
var error__37820__auto___41892 = temp__5804__auto___41891;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41892], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41401_41873,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41892], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41401_41873,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41402_41874], null)));

var ufv___41894 = schema.utils.use_fn_validation;
var output_schema41426_41895 = deercreeklabs.baracus.ByteArray;
var input_schema41427_41896 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41431_41897 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41428_41898 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41427_41896);
}),null));
var output_checker41429_41899 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41426_41895);
}),null));
var input_checker41432_41900 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41431_41897);
}),null));
var output_checker41433_41901 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41426_41895);
}),null));
var ret__39944__auto___41902 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41438 = arguments.length;
switch (G__41438) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41430){
var validate__37818__auto__ = cljs.core.deref(ufv___41894);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___41904 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41430], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41440_41905 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41441_41906 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41442_41907 = input_schema41427_41896;
var G__41443_41908 = cljs.core.deref(input_checker41428_41898);
var G__41444_41909 = args__37819__auto___41904;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41440_41905,G__41441_41906,G__41442_41907,G__41443_41908,G__41444_41909) : schema.core.fn_validator.call(null,G__41440_41905,G__41441_41906,G__41442_41907,G__41443_41908,G__41444_41909));
} else {
var temp__5804__auto___41910 = (function (){var fexpr__41445 = cljs.core.deref(input_checker41428_41898);
return (fexpr__41445.cljs$core$IFn$_invoke$arity$1 ? fexpr__41445.cljs$core$IFn$_invoke$arity$1(args__37819__auto___41904) : fexpr__41445.call(null,args__37819__auto___41904));
})();
if(cljs.core.truth_(temp__5804__auto___41910)){
var error__37820__auto___41911 = temp__5804__auto___41910;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41911], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41427_41896,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___41904,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41911], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var size_or_seq = G__41430;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41446_41912 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41447_41913 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41448_41914 = output_schema41426_41895;
var G__41449_41915 = cljs.core.deref(output_checker41429_41899);
var G__41450_41916 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41446_41912,G__41447_41913,G__41448_41914,G__41449_41915,G__41450_41916) : schema.core.fn_validator.call(null,G__41446_41912,G__41447_41913,G__41448_41914,G__41449_41915,G__41450_41916));
} else {
var temp__5804__auto___41917 = (function (){var fexpr__41463 = cljs.core.deref(output_checker41429_41899);
return (fexpr__41463.cljs$core$IFn$_invoke$arity$1 ? fexpr__41463.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41463.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41917)){
var error__37820__auto___41918 = temp__5804__auto___41917;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41918], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41426_41895,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41918], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41434,G__41435){
var validate__37818__auto__ = cljs.core.deref(ufv___41894);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___41919 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41434,G__41435], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41465_41920 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41466_41921 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41467_41922 = input_schema41431_41897;
var G__41468_41923 = cljs.core.deref(input_checker41432_41900);
var G__41469_41924 = args__37819__auto___41919;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41465_41920,G__41466_41921,G__41467_41922,G__41468_41923,G__41469_41924) : schema.core.fn_validator.call(null,G__41465_41920,G__41466_41921,G__41467_41922,G__41468_41923,G__41469_41924));
} else {
var temp__5804__auto___41926 = (function (){var fexpr__41470 = cljs.core.deref(input_checker41432_41900);
return (fexpr__41470.cljs$core$IFn$_invoke$arity$1 ? fexpr__41470.cljs$core$IFn$_invoke$arity$1(args__37819__auto___41919) : fexpr__41470.call(null,args__37819__auto___41919));
})();
if(cljs.core.truth_(temp__5804__auto___41926)){
var error__37820__auto___41927 = temp__5804__auto___41926;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41927], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41431_41897,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___41919,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41927], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var size = G__41434;
var init_val_or_seq = G__41435;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41472_41928 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41473_41929 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41474_41930 = output_schema41426_41895;
var G__41475_41931 = cljs.core.deref(output_checker41433_41901);
var G__41476_41932 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41472_41928,G__41473_41929,G__41474_41930,G__41475_41931,G__41476_41932) : schema.core.fn_validator.call(null,G__41472_41928,G__41473_41929,G__41474_41930,G__41475_41931,G__41476_41932));
} else {
var temp__5804__auto___41933 = (function (){var fexpr__41477 = cljs.core.deref(output_checker41433_41901);
return (fexpr__41477.cljs$core$IFn$_invoke$arity$1 ? fexpr__41477.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41477.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41933)){
var error__37820__auto___41934 = temp__5804__auto___41933;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41934], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41426_41895,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41934], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41426_41895,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41427_41896,input_schema41431_41897], null)));

var ufv___41937 = schema.utils.use_fn_validation;
var output_schema41479_41938 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41480_41939 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41481_41940 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41480_41939);
}),null));
var output_checker41482_41941 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41479_41938);
}),null));
var ret__39944__auto___41942 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41483){
var validate__37818__auto__ = cljs.core.deref(ufv___41937);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___41943 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41483], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41484_41944 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41485_41945 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41486_41946 = input_schema41480_41939;
var G__41487_41947 = cljs.core.deref(input_checker41481_41940);
var G__41488_41948 = args__37819__auto___41943;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41484_41944,G__41485_41945,G__41486_41946,G__41487_41947,G__41488_41948) : schema.core.fn_validator.call(null,G__41484_41944,G__41485_41945,G__41486_41946,G__41487_41947,G__41488_41948));
} else {
var temp__5804__auto___41950 = (function (){var fexpr__41490 = cljs.core.deref(input_checker41481_41940);
return (fexpr__41490.cljs$core$IFn$_invoke$arity$1 ? fexpr__41490.cljs$core$IFn$_invoke$arity$1(args__37819__auto___41943) : fexpr__41490.call(null,args__37819__auto___41943));
})();
if(cljs.core.truth_(temp__5804__auto___41950)){
var error__37820__auto___41953 = temp__5804__auto___41950;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41953], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41480_41939,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___41943,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41953], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var arrays = G__41483;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41492 = cljs.core.count(arrays__$1);
switch (G__41492) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41492,arrays__$1,validate__37818__auto__,ufv___41937,output_schema41479_41938,input_schema41480_41939,input_checker41481_41940,output_checker41482_41941){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41492,arrays__$1,validate__37818__auto__,ufv___41937,output_schema41479_41938,input_schema41480_41939,input_checker41481_41940,output_checker41482_41941))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41492,arrays__$1,validate__37818__auto__,ufv___41937,output_schema41479_41938,input_schema41480_41939,input_checker41481_41940,output_checker41482_41941){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41492,arrays__$1,validate__37818__auto__,ufv___41937,output_schema41479_41938,input_schema41480_41939,input_checker41481_41940,output_checker41482_41941))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41493_41958 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41494_41959 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41495_41960 = output_schema41479_41938;
var G__41496_41961 = cljs.core.deref(output_checker41482_41941);
var G__41497_41962 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41493_41958,G__41494_41959,G__41495_41960,G__41496_41961,G__41497_41962) : schema.core.fn_validator.call(null,G__41493_41958,G__41494_41959,G__41495_41960,G__41496_41961,G__41497_41962));
} else {
var temp__5804__auto___41965 = (function (){var fexpr__41498 = cljs.core.deref(output_checker41482_41941);
return (fexpr__41498.cljs$core$IFn$_invoke$arity$1 ? fexpr__41498.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41498.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41965)){
var error__37820__auto___41967 = temp__5804__auto___41965;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41967], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41479_41938,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41967], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41479_41938,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41480_41939], null)));

var ufv___41968 = schema.utils.use_fn_validation;
var output_schema41500_41969 = schema.core.Bool;
var input_schema41501_41970 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41502_41971 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41501_41970);
}),null));
var output_checker41503_41972 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41500_41969);
}),null));
var ret__39944__auto___41973 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41504,G__41505){
var validate__37818__auto__ = cljs.core.deref(ufv___41968);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___41974 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41504,G__41505], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41506_41975 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41507_41976 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41508_41977 = input_schema41501_41970;
var G__41509_41978 = cljs.core.deref(input_checker41502_41971);
var G__41510_41979 = args__37819__auto___41974;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41506_41975,G__41507_41976,G__41508_41977,G__41509_41978,G__41510_41979) : schema.core.fn_validator.call(null,G__41506_41975,G__41507_41976,G__41508_41977,G__41509_41978,G__41510_41979));
} else {
var temp__5804__auto___41982 = (function (){var fexpr__41514 = cljs.core.deref(input_checker41502_41971);
return (fexpr__41514.cljs$core$IFn$_invoke$arity$1 ? fexpr__41514.cljs$core$IFn$_invoke$arity$1(args__37819__auto___41974) : fexpr__41514.call(null,args__37819__auto___41974));
})();
if(cljs.core.truth_(temp__5804__auto___41982)){
var error__37820__auto___41983 = temp__5804__auto___41982;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41983], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41501_41970,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___41974,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41983], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var a = G__41504;
var b = G__41505;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41989 = ((i + (1)) | (0));
i = G__41989;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41516_41990 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41517_41991 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41518_41992 = output_schema41500_41969;
var G__41519_41993 = cljs.core.deref(output_checker41503_41972);
var G__41520_41994 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41516_41990,G__41517_41991,G__41518_41992,G__41519_41993,G__41520_41994) : schema.core.fn_validator.call(null,G__41516_41990,G__41517_41991,G__41518_41992,G__41519_41993,G__41520_41994));
} else {
var temp__5804__auto___41997 = (function (){var fexpr__41523 = cljs.core.deref(output_checker41503_41972);
return (fexpr__41523.cljs$core$IFn$_invoke$arity$1 ? fexpr__41523.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41523.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41997)){
var error__37820__auto___41998 = temp__5804__auto___41997;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___41998], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41500_41969,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___41998], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41500_41969,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41501_41970], null)));

var ufv___42000 = schema.utils.use_fn_validation;
var output_schema41524_42001 = schema.core.Str;
var input_schema41525_42002 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41526_42003 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41525_42002);
}),null));
var output_checker41527_42004 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41524_42001);
}),null));
var ret__39944__auto___42009 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41528){
var validate__37818__auto__ = cljs.core.deref(ufv___42000);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42011 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41528], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41531_42012 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41532_42013 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41533_42014 = input_schema41525_42002;
var G__41534_42015 = cljs.core.deref(input_checker41526_42003);
var G__41535_42016 = args__37819__auto___42011;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41531_42012,G__41532_42013,G__41533_42014,G__41534_42015,G__41535_42016) : schema.core.fn_validator.call(null,G__41531_42012,G__41532_42013,G__41533_42014,G__41534_42015,G__41535_42016));
} else {
var temp__5804__auto___42017 = (function (){var fexpr__41536 = cljs.core.deref(input_checker41526_42003);
return (fexpr__41536.cljs$core$IFn$_invoke$arity$1 ? fexpr__41536.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42011) : fexpr__41536.call(null,args__37819__auto___42011));
})();
if(cljs.core.truth_(temp__5804__auto___42017)){
var error__37820__auto___42019 = temp__5804__auto___42017;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42019], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41525_42002,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42011,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42019], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41528;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41538_42021 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41539_42022 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41540_42023 = output_schema41524_42001;
var G__41541_42024 = cljs.core.deref(output_checker41527_42004);
var G__41542_42025 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41538_42021,G__41539_42022,G__41540_42023,G__41541_42024,G__41542_42025) : schema.core.fn_validator.call(null,G__41538_42021,G__41539_42022,G__41540_42023,G__41541_42024,G__41542_42025));
} else {
var temp__5804__auto___42026 = (function (){var fexpr__41543 = cljs.core.deref(output_checker41527_42004);
return (fexpr__41543.cljs$core$IFn$_invoke$arity$1 ? fexpr__41543.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41543.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42026)){
var error__37820__auto___42029 = temp__5804__auto___42026;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42029], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41524_42001,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42029], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41524_42001,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41525_42002], null)));

var ufv___42032 = schema.utils.use_fn_validation;
var output_schema41550_42033 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41551_42034 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41555_42035 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41560_42036 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41552_42037 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41551_42034);
}),null));
var output_checker41553_42038 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41550_42033);
}),null));
var input_checker41556_42039 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41555_42035);
}),null));
var output_checker41557_42040 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41550_42033);
}),null));
var input_checker41561_42041 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41560_42036);
}),null));
var output_checker41562_42042 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41550_42033);
}),null));
var ret__39944__auto___42049 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41568 = arguments.length;
switch (G__41568) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41554){
var validate__37818__auto__ = cljs.core.deref(ufv___42032);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42052 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41554], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41570_42053 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41571_42054 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41572_42055 = input_schema41551_42034;
var G__41573_42056 = cljs.core.deref(input_checker41552_42037);
var G__41574_42057 = args__37819__auto___42052;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41570_42053,G__41571_42054,G__41572_42055,G__41573_42056,G__41574_42057) : schema.core.fn_validator.call(null,G__41570_42053,G__41571_42054,G__41572_42055,G__41573_42056,G__41574_42057));
} else {
var temp__5804__auto___42061 = (function (){var fexpr__41575 = cljs.core.deref(input_checker41552_42037);
return (fexpr__41575.cljs$core$IFn$_invoke$arity$1 ? fexpr__41575.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42052) : fexpr__41575.call(null,args__37819__auto___42052));
})();
if(cljs.core.truth_(temp__5804__auto___42061)){
var error__37820__auto___42064 = temp__5804__auto___42061;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42064], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41551_42034,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42052,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42064], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41554;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41576_42068 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41577_42069 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41578_42070 = output_schema41550_42033;
var G__41579_42071 = cljs.core.deref(output_checker41553_42038);
var G__41580_42072 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41576_42068,G__41577_42069,G__41578_42070,G__41579_42071,G__41580_42072) : schema.core.fn_validator.call(null,G__41576_42068,G__41577_42069,G__41578_42070,G__41579_42071,G__41580_42072));
} else {
var temp__5804__auto___42075 = (function (){var fexpr__41581 = cljs.core.deref(output_checker41553_42038);
return (fexpr__41581.cljs$core$IFn$_invoke$arity$1 ? fexpr__41581.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41581.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42075)){
var error__37820__auto___42076 = temp__5804__auto___42075;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42076], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41550_42033,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42076], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41558,G__41559){
var validate__37818__auto__ = cljs.core.deref(ufv___42032);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42079 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41558,G__41559], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41582_42080 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41583_42081 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41584_42082 = input_schema41555_42035;
var G__41585_42083 = cljs.core.deref(input_checker41556_42039);
var G__41586_42084 = args__37819__auto___42079;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41582_42080,G__41583_42081,G__41584_42082,G__41585_42083,G__41586_42084) : schema.core.fn_validator.call(null,G__41582_42080,G__41583_42081,G__41584_42082,G__41585_42083,G__41586_42084));
} else {
var temp__5804__auto___42085 = (function (){var fexpr__41587 = cljs.core.deref(input_checker41556_42039);
return (fexpr__41587.cljs$core$IFn$_invoke$arity$1 ? fexpr__41587.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42079) : fexpr__41587.call(null,args__37819__auto___42079));
})();
if(cljs.core.truth_(temp__5804__auto___42085)){
var error__37820__auto___42087 = temp__5804__auto___42085;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42087], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41555_42035,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42079,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42087], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41558;
var start = G__41559;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41589_42092 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41590_42093 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41591_42094 = output_schema41550_42033;
var G__41592_42095 = cljs.core.deref(output_checker41557_42040);
var G__41593_42096 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41589_42092,G__41590_42093,G__41591_42094,G__41592_42095,G__41593_42096) : schema.core.fn_validator.call(null,G__41589_42092,G__41590_42093,G__41591_42094,G__41592_42095,G__41593_42096));
} else {
var temp__5804__auto___42098 = (function (){var fexpr__41594 = cljs.core.deref(output_checker41557_42040);
return (fexpr__41594.cljs$core$IFn$_invoke$arity$1 ? fexpr__41594.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41594.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42098)){
var error__37820__auto___42099 = temp__5804__auto___42098;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42099], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41550_42033,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42099], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41563,G__41564,G__41565){
var validate__37818__auto__ = cljs.core.deref(ufv___42032);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42103 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41563,G__41564,G__41565], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41595_42104 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41596_42105 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41597_42106 = input_schema41560_42036;
var G__41598_42107 = cljs.core.deref(input_checker41561_42041);
var G__41599_42108 = args__37819__auto___42103;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41595_42104,G__41596_42105,G__41597_42106,G__41598_42107,G__41599_42108) : schema.core.fn_validator.call(null,G__41595_42104,G__41596_42105,G__41597_42106,G__41598_42107,G__41599_42108));
} else {
var temp__5804__auto___42110 = (function (){var fexpr__41600 = cljs.core.deref(input_checker41561_42041);
return (fexpr__41600.cljs$core$IFn$_invoke$arity$1 ? fexpr__41600.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42103) : fexpr__41600.call(null,args__37819__auto___42103));
})();
if(cljs.core.truth_(temp__5804__auto___42110)){
var error__37820__auto___42111 = temp__5804__auto___42110;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42111], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41560_42036,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42103,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42111], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41563;
var start = G__41564;
var end = G__41565;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41602_42118 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41603_42119 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41604_42120 = output_schema41550_42033;
var G__41605_42121 = cljs.core.deref(output_checker41562_42042);
var G__41606_42122 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41602_42118,G__41603_42119,G__41604_42120,G__41605_42121,G__41606_42122) : schema.core.fn_validator.call(null,G__41602_42118,G__41603_42119,G__41604_42120,G__41605_42121,G__41606_42122));
} else {
var temp__5804__auto___42126 = (function (){var fexpr__41607 = cljs.core.deref(output_checker41562_42042);
return (fexpr__41607.cljs$core$IFn$_invoke$arity$1 ? fexpr__41607.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41607.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42126)){
var error__37820__auto___42127 = temp__5804__auto___42126;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42127], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41550_42033,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42127], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41550_42033,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41551_42034,input_schema41555_42035,input_schema41560_42036], null)));

var ufv___42129 = schema.utils.use_fn_validation;
var output_schema41609_42130 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41610_42131 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41611_42132 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41610_42131);
}),null));
var output_checker41612_42133 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41609_42130);
}),null));
var ret__39944__auto___42135 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41613){
var validate__37818__auto__ = cljs.core.deref(ufv___42129);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42138 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41613], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41615_42139 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41616_42140 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41617_42141 = input_schema41610_42131;
var G__41618_42142 = cljs.core.deref(input_checker41611_42132);
var G__41619_42143 = args__37819__auto___42138;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41615_42139,G__41616_42140,G__41617_42141,G__41618_42142,G__41619_42143) : schema.core.fn_validator.call(null,G__41615_42139,G__41616_42140,G__41617_42141,G__41618_42142,G__41619_42143));
} else {
var temp__5804__auto___42144 = (function (){var fexpr__41620 = cljs.core.deref(input_checker41611_42132);
return (fexpr__41620.cljs$core$IFn$_invoke$arity$1 ? fexpr__41620.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42138) : fexpr__41620.call(null,args__37819__auto___42138));
})();
if(cljs.core.truth_(temp__5804__auto___42144)){
var error__37820__auto___42145 = temp__5804__auto___42144;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42145], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41610_42131,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42138,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42145], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41613;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5635__auto___42149 = num;
var i_42152 = (0);
while(true){
if((i_42152 < n__5635__auto___42149)){
(new$[i_42152] = (ba[(last - i_42152)]));

var G__42154 = (i_42152 + (1));
i_42152 = G__42154;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41622_42156 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41623_42157 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41624_42158 = output_schema41609_42130;
var G__41625_42159 = cljs.core.deref(output_checker41612_42133);
var G__41626_42160 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41622_42156,G__41623_42157,G__41624_42158,G__41625_42159,G__41626_42160) : schema.core.fn_validator.call(null,G__41622_42156,G__41623_42157,G__41624_42158,G__41625_42159,G__41626_42160));
} else {
var temp__5804__auto___42161 = (function (){var fexpr__41627 = cljs.core.deref(output_checker41612_42133);
return (fexpr__41627.cljs$core$IFn$_invoke$arity$1 ? fexpr__41627.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41627.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42161)){
var error__37820__auto___42162 = temp__5804__auto___42161;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42162], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41609_42130,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42162], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41609_42130,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41610_42131], null)));

var ufv___42171 = schema.utils.use_fn_validation;
var output_schema41628_42172 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41629_42173 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41630_42174 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41629_42173);
}),null));
var output_checker41631_42175 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41628_42172);
}),null));
var ret__39944__auto___42177 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41632,G__41633){
var validate__37818__auto__ = cljs.core.deref(ufv___42171);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42180 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41632,G__41633], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41635_42181 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41636_42182 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41637_42183 = input_schema41629_42173;
var G__41638_42184 = cljs.core.deref(input_checker41630_42174);
var G__41639_42185 = args__37819__auto___42180;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41635_42181,G__41636_42182,G__41637_42183,G__41638_42184,G__41639_42185) : schema.core.fn_validator.call(null,G__41635_42181,G__41636_42182,G__41637_42183,G__41638_42184,G__41639_42185));
} else {
var temp__5804__auto___42189 = (function (){var fexpr__41640 = cljs.core.deref(input_checker41630_42174);
return (fexpr__41640.cljs$core$IFn$_invoke$arity$1 ? fexpr__41640.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42180) : fexpr__41640.call(null,args__37819__auto___42180));
})();
if(cljs.core.truth_(temp__5804__auto___42189)){
var error__37820__auto___42192 = temp__5804__auto___42189;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42192], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41629_42173,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42180,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42192], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41632;
var fragment_size = G__41633;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__42200 = (end_offset | (0));
var G__42201 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__42200;
output = G__42201;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41641_42202 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41642_42203 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41643_42204 = output_schema41628_42172;
var G__41644_42205 = cljs.core.deref(output_checker41631_42175);
var G__41645_42206 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41641_42202,G__41642_42203,G__41643_42204,G__41644_42205,G__41645_42206) : schema.core.fn_validator.call(null,G__41641_42202,G__41642_42203,G__41643_42204,G__41644_42205,G__41645_42206));
} else {
var temp__5804__auto___42209 = (function (){var fexpr__41647 = cljs.core.deref(output_checker41631_42175);
return (fexpr__41647.cljs$core$IFn$_invoke$arity$1 ? fexpr__41647.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41647.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42209)){
var error__37820__auto___42211 = temp__5804__auto___42209;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42211], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41628_42172,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42211], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41628_42172,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41629_42173], null)));

var ufv___42221 = schema.utils.use_fn_validation;
var output_schema41648_42222 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41649_42223 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41650_42224 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41649_42223);
}),null));
var output_checker41651_42225 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41648_42222);
}),null));
var ret__39944__auto___42228 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an zig-zag encoded byte array and reads an integer from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41652){
var validate__37818__auto__ = cljs.core.deref(ufv___42221);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42230 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41652], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41654_42231 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41655_42232 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41656_42233 = input_schema41649_42223;
var G__41657_42234 = cljs.core.deref(input_checker41650_42224);
var G__41658_42235 = args__37819__auto___42230;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41654_42231,G__41655_42232,G__41656_42233,G__41657_42234,G__41658_42235) : schema.core.fn_validator.call(null,G__41654_42231,G__41655_42232,G__41656_42233,G__41657_42234,G__41658_42235));
} else {
var temp__5804__auto___42239 = (function (){var fexpr__41662 = cljs.core.deref(input_checker41650_42224);
return (fexpr__41662.cljs$core$IFn$_invoke$arity$1 ? fexpr__41662.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42230) : fexpr__41662.call(null,args__37819__auto___42230));
})();
if(cljs.core.truth_(temp__5804__auto___42239)){
var error__37820__auto___42241 = temp__5804__auto___42239;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42241], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41649_42223,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42230,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42241], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41652;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__42248 = (n + (1));
var G__42249 = (i__$1 | (0));
var G__42250 = (out__$1 | (0));
n = G__42248;
i = G__42249;
out = G__42250;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41664_42251 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41665_42252 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41666_42253 = output_schema41648_42222;
var G__41667_42254 = cljs.core.deref(output_checker41651_42225);
var G__41668_42255 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41664_42251,G__41665_42252,G__41666_42253,G__41667_42254,G__41668_42255) : schema.core.fn_validator.call(null,G__41664_42251,G__41665_42252,G__41666_42253,G__41667_42254,G__41668_42255));
} else {
var temp__5804__auto___42260 = (function (){var fexpr__41669 = cljs.core.deref(output_checker41651_42225);
return (fexpr__41669.cljs$core$IFn$_invoke$arity$1 ? fexpr__41669.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41669.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42260)){
var error__37820__auto___42261 = temp__5804__auto___42260;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an zig-zag encoded byte array and reads an integer from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42261], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41648_42222,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42261], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41648_42222,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41649_42223], null)));

var ufv___42264 = schema.utils.use_fn_validation;
var output_schema41670_42265 = deercreeklabs.baracus.ByteArray;
var input_schema41671_42266 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41672_42267 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41671_42266);
}),null));
var output_checker41673_42268 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41670_42265);
}),null));
var ret__39944__auto___42272 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Zig zag encodes an integer. Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41675){
var validate__37818__auto__ = cljs.core.deref(ufv___42264);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42273 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41675], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41676_42274 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41677_42275 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__41678_42276 = input_schema41671_42266;
var G__41679_42277 = cljs.core.deref(input_checker41672_42267);
var G__41680_42278 = args__37819__auto___42273;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41676_42274,G__41677_42275,G__41678_42276,G__41679_42277,G__41680_42278) : schema.core.fn_validator.call(null,G__41676_42274,G__41677_42275,G__41678_42276,G__41679_42277,G__41680_42278));
} else {
var temp__5804__auto___42279 = (function (){var fexpr__41681 = cljs.core.deref(input_checker41672_42267);
return (fexpr__41681.cljs$core$IFn$_invoke$arity$1 ? fexpr__41681.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42273) : fexpr__41681.call(null,args__37819__auto___42273));
})();
if(cljs.core.truth_(temp__5804__auto___42279)){
var error__37820__auto___42280 = temp__5804__auto___42279;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42280], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41671_42266,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42273,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42280], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var i = G__41675;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__42286 = (n >>> (7));
var G__42287 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__42286;
out = G__42287;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41683_42288 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41684_42289 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null));
var G__41685_42290 = output_schema41670_42265;
var G__41686_42291 = cljs.core.deref(output_checker41673_42268);
var G__41687_42292 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41683_42288,G__41684_42289,G__41685_42290,G__41686_42291,G__41687_42292) : schema.core.fn_validator.call(null,G__41683_42288,G__41684_42289,G__41685_42290,G__41686_42291,G__41687_42292));
} else {
var temp__5804__auto___42294 = (function (){var fexpr__41688 = cljs.core.deref(output_checker41673_42268);
return (fexpr__41688.cljs$core$IFn$_invoke$arity$1 ? fexpr__41688.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41688.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42294)){
var error__37820__auto___42295 = temp__5804__auto___42294;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Zig zag encodes an integer. Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42295], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41670_42265,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42295], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41670_42265,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41671_42266], null)));

var ufv___42301 = schema.utils.use_fn_validation;
var output_schema41692_42302 = schema.core.maybe(schema.core.Str);
var input_schema41693_42303 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41694_42304 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41693_42303);
}),null));
var output_checker41695_42305 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41692_42302);
}),null));
var ret__39944__auto___42306 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41696){
var validate__37818__auto__ = cljs.core.deref(ufv___42301);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42307 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41696], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41698_42308 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41699_42309 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41700_42310 = input_schema41693_42303;
var G__41701_42311 = cljs.core.deref(input_checker41694_42304);
var G__41702_42312 = args__37819__auto___42307;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41698_42308,G__41699_42309,G__41700_42310,G__41701_42311,G__41702_42312) : schema.core.fn_validator.call(null,G__41698_42308,G__41699_42309,G__41700_42310,G__41701_42311,G__41702_42312));
} else {
var temp__5804__auto___42315 = (function (){var fexpr__41703 = cljs.core.deref(input_checker41694_42304);
return (fexpr__41703.cljs$core$IFn$_invoke$arity$1 ? fexpr__41703.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42307) : fexpr__41703.call(null,args__37819__auto___42307));
})();
if(cljs.core.truth_(temp__5804__auto___42315)){
var error__37820__auto___42319 = temp__5804__auto___42315;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42319], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41693_42303,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42307,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42319], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var b = G__41696;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41705_42321 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41706_42322 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41707_42323 = output_schema41692_42302;
var G__41708_42324 = cljs.core.deref(output_checker41695_42305);
var G__41709_42325 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41705_42321,G__41706_42322,G__41707_42323,G__41708_42324,G__41709_42325) : schema.core.fn_validator.call(null,G__41705_42321,G__41706_42322,G__41707_42323,G__41708_42324,G__41709_42325));
} else {
var temp__5804__auto___42330 = (function (){var fexpr__41710 = cljs.core.deref(output_checker41695_42305);
return (fexpr__41710.cljs$core$IFn$_invoke$arity$1 ? fexpr__41710.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41710.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42330)){
var error__37820__auto___42331 = temp__5804__auto___42330;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42331], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41692_42302,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42331], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41692_42302,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41693_42303], null)));

var ufv___42335 = schema.utils.use_fn_validation;
var output_schema41712_42336 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41713_42337 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41714_42338 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41713_42337);
}),null));
var output_checker41715_42339 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41712_42336);
}),null));
var ret__39944__auto___42343 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41716){
var validate__37818__auto__ = cljs.core.deref(ufv___42335);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42346 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41716], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41718_42347 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41719_42348 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41720_42349 = input_schema41713_42337;
var G__41721_42350 = cljs.core.deref(input_checker41714_42338);
var G__41722_42351 = args__37819__auto___42346;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41718_42347,G__41719_42348,G__41720_42349,G__41721_42350,G__41722_42351) : schema.core.fn_validator.call(null,G__41718_42347,G__41719_42348,G__41720_42349,G__41721_42350,G__41722_42351));
} else {
var temp__5804__auto___42352 = (function (){var fexpr__41723 = cljs.core.deref(input_checker41714_42338);
return (fexpr__41723.cljs$core$IFn$_invoke$arity$1 ? fexpr__41723.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42346) : fexpr__41723.call(null,args__37819__auto___42346));
})();
if(cljs.core.truth_(temp__5804__auto___42352)){
var error__37820__auto___42353 = temp__5804__auto___42352;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42353], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41713_42337,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42346,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42353], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var s = G__41716;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41724_42358 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41725_42359 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41726_42360 = output_schema41712_42336;
var G__41727_42361 = cljs.core.deref(output_checker41715_42339);
var G__41728_42362 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41724_42358,G__41725_42359,G__41726_42360,G__41727_42361,G__41728_42362) : schema.core.fn_validator.call(null,G__41724_42358,G__41725_42359,G__41726_42360,G__41727_42361,G__41728_42362));
} else {
var temp__5804__auto___42363 = (function (){var fexpr__41729 = cljs.core.deref(output_checker41715_42339);
return (fexpr__41729.cljs$core$IFn$_invoke$arity$1 ? fexpr__41729.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41729.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42363)){
var error__37820__auto___42365 = temp__5804__auto___42363;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42365], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41712_42336,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42365], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41712_42336,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41713_42337], null)));

var ufv___42366 = schema.utils.use_fn_validation;
var output_schema41731_42367 = schema.core.maybe(schema.core.Str);
var input_schema41732_42368 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41733_42369 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41732_42368);
}),null));
var output_checker41734_42370 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41731_42367);
}),null));
var ret__39944__auto___42372 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41735){
var validate__37818__auto__ = cljs.core.deref(ufv___42366);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42374 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41735], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41737_42375 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41738_42376 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41739_42377 = input_schema41732_42368;
var G__41740_42378 = cljs.core.deref(input_checker41733_42369);
var G__41741_42379 = args__37819__auto___42374;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41737_42375,G__41738_42376,G__41739_42377,G__41740_42378,G__41741_42379) : schema.core.fn_validator.call(null,G__41737_42375,G__41738_42376,G__41739_42377,G__41740_42378,G__41741_42379));
} else {
var temp__5804__auto___42381 = (function (){var fexpr__41742 = cljs.core.deref(input_checker41733_42369);
return (fexpr__41742.cljs$core$IFn$_invoke$arity$1 ? fexpr__41742.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42374) : fexpr__41742.call(null,args__37819__auto___42374));
})();
if(cljs.core.truth_(temp__5804__auto___42381)){
var error__37820__auto___42382 = temp__5804__auto___42381;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42382], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41732_42368,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42374,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42382], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41735;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41743_42383 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41744_42384 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41745_42385 = output_schema41731_42367;
var G__41746_42386 = cljs.core.deref(output_checker41734_42370);
var G__41747_42387 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41743_42383,G__41744_42384,G__41745_42385,G__41746_42386,G__41747_42387) : schema.core.fn_validator.call(null,G__41743_42383,G__41744_42384,G__41745_42385,G__41746_42386,G__41747_42387));
} else {
var temp__5804__auto___42388 = (function (){var fexpr__41751 = cljs.core.deref(output_checker41734_42370);
return (fexpr__41751.cljs$core$IFn$_invoke$arity$1 ? fexpr__41751.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41751.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42388)){
var error__37820__auto___42390 = temp__5804__auto___42388;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42390], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41731_42367,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42390], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41731_42367,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41732_42368], null)));

var ufv___42393 = schema.utils.use_fn_validation;
var output_schema41753_42394 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41754_42395 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41755_42396 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41754_42395);
}),null));
var output_checker41756_42397 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41753_42394);
}),null));
var ret__39944__auto___42398 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41757){
var validate__37818__auto__ = cljs.core.deref(ufv___42393);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42399 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41757], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41758_42400 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41759_42401 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41760_42402 = input_schema41754_42395;
var G__41761_42403 = cljs.core.deref(input_checker41755_42396);
var G__41762_42404 = args__37819__auto___42399;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41758_42400,G__41759_42401,G__41760_42402,G__41761_42403,G__41762_42404) : schema.core.fn_validator.call(null,G__41758_42400,G__41759_42401,G__41760_42402,G__41761_42403,G__41762_42404));
} else {
var temp__5804__auto___42408 = (function (){var fexpr__41763 = cljs.core.deref(input_checker41755_42396);
return (fexpr__41763.cljs$core$IFn$_invoke$arity$1 ? fexpr__41763.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42399) : fexpr__41763.call(null,args__37819__auto___42399));
})();
if(cljs.core.truth_(temp__5804__auto___42408)){
var error__37820__auto___42410 = temp__5804__auto___42408;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42410], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41754_42395,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42399,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42410], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var s = G__41757;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41764_42414 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41765_42415 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41766_42416 = output_schema41753_42394;
var G__41767_42417 = cljs.core.deref(output_checker41756_42397);
var G__41768_42418 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41764_42414,G__41765_42415,G__41766_42416,G__41767_42417,G__41768_42418) : schema.core.fn_validator.call(null,G__41764_42414,G__41765_42415,G__41766_42416,G__41767_42417,G__41768_42418));
} else {
var temp__5804__auto___42421 = (function (){var fexpr__41770 = cljs.core.deref(output_checker41756_42397);
return (fexpr__41770.cljs$core$IFn$_invoke$arity$1 ? fexpr__41770.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41770.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42421)){
var error__37820__auto___42423 = temp__5804__auto___42421;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42423], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41753_42394,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42423], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41753_42394,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41754_42395], null)));

var ufv___42428 = schema.utils.use_fn_validation;
var output_schema41771_42429 = schema.core.maybe(schema.core.Str);
var input_schema41772_42430 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41773_42431 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41772_42430);
}),null));
var output_checker41774_42432 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41771_42429);
}),null));
var ret__39944__auto___42433 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41775){
var validate__37818__auto__ = cljs.core.deref(ufv___42428);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42434 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41775], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41776_42435 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41777_42436 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41778_42437 = input_schema41772_42430;
var G__41779_42438 = cljs.core.deref(input_checker41773_42431);
var G__41780_42439 = args__37819__auto___42434;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41776_42435,G__41777_42436,G__41778_42437,G__41779_42438,G__41780_42439) : schema.core.fn_validator.call(null,G__41776_42435,G__41777_42436,G__41778_42437,G__41779_42438,G__41780_42439));
} else {
var temp__5804__auto___42446 = (function (){var fexpr__41781 = cljs.core.deref(input_checker41773_42431);
return (fexpr__41781.cljs$core$IFn$_invoke$arity$1 ? fexpr__41781.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42434) : fexpr__41781.call(null,args__37819__auto___42434));
})();
if(cljs.core.truth_(temp__5804__auto___42446)){
var error__37820__auto___42450 = temp__5804__auto___42446;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42450], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41772_42430,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42434,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42450], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41775;
while(true){
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var hex_chars = new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null);
var ca = (new Array(((2) * len)));
var n__5635__auto___42451 = len;
var i_42452 = (0);
while(true){
if((i_42452 < n__5635__auto___42451)){
var b_42456 = ((ba[i_42452]) & (255));
var j_42457 = ((2) * i_42452);
(ca[j_42457] = (function (){var G__41783 = (b_42456 >> (4));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__41783) : hex_chars.call(null,G__41783));
})());

(ca[(j_42457 + (1))] = (function (){var G__41785 = (b_42456 & (15));
return (hex_chars.cljs$core$IFn$_invoke$arity$1 ? hex_chars.cljs$core$IFn$_invoke$arity$1(G__41785) : hex_chars.call(null,G__41785));
})());

var G__42459 = (i_42452 + (1));
i_42452 = G__42459;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41786_42460 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41787_42461 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41788_42462 = output_schema41771_42429;
var G__41789_42463 = cljs.core.deref(output_checker41774_42432);
var G__41790_42464 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41786_42460,G__41787_42461,G__41788_42462,G__41789_42463,G__41790_42464) : schema.core.fn_validator.call(null,G__41786_42460,G__41787_42461,G__41788_42462,G__41789_42463,G__41790_42464));
} else {
var temp__5804__auto___42467 = (function (){var fexpr__41791 = cljs.core.deref(output_checker41774_42432);
return (fexpr__41791.cljs$core$IFn$_invoke$arity$1 ? fexpr__41791.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41791.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42467)){
var error__37820__auto___42470 = temp__5804__auto___42467;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42470], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41771_42429,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42470], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41771_42429,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41772_42430], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42474 = schema.utils.use_fn_validation;
var output_schema41792_42475 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41793_42476 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41794_42477 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41793_42476);
}),null));
var output_checker41795_42478 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41792_42475);
}),null));
var ret__39944__auto___42479 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41796){
var validate__37818__auto__ = cljs.core.deref(ufv___42474);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42480 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41796], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41798_42481 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41799_42482 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41800_42483 = input_schema41793_42476;
var G__41801_42484 = cljs.core.deref(input_checker41794_42477);
var G__41802_42485 = args__37819__auto___42480;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41798_42481,G__41799_42482,G__41800_42483,G__41801_42484,G__41802_42485) : schema.core.fn_validator.call(null,G__41798_42481,G__41799_42482,G__41800_42483,G__41801_42484,G__41802_42485));
} else {
var temp__5804__auto___42486 = (function (){var fexpr__41803 = cljs.core.deref(input_checker41794_42477);
return (fexpr__41803.cljs$core$IFn$_invoke$arity$1 ? fexpr__41803.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42480) : fexpr__41803.call(null,args__37819__auto___42480));
})();
if(cljs.core.truth_(temp__5804__auto___42486)){
var error__37820__auto___42487 = temp__5804__auto___42486;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42487], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41793_42476,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42480,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42487], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var s = G__41796;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5635__auto___42495 = ba_len;
var i_42496 = (0);
while(true){
if((i_42496 < n__5635__auto___42495)){
var j_42497 = ((2) * i_42496);
(ba[i_42496] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42497)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42497 + (1))))));

var G__42498 = (i_42496 + (1));
i_42496 = G__42498;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41807_42499 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41808_42500 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41809_42501 = output_schema41792_42475;
var G__41810_42502 = cljs.core.deref(output_checker41795_42478);
var G__41811_42503 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41807_42499,G__41808_42500,G__41809_42501,G__41810_42502,G__41811_42503) : schema.core.fn_validator.call(null,G__41807_42499,G__41808_42500,G__41809_42501,G__41810_42502,G__41811_42503));
} else {
var temp__5804__auto___42505 = (function (){var fexpr__41813 = cljs.core.deref(output_checker41795_42478);
return (fexpr__41813.cljs$core$IFn$_invoke$arity$1 ? fexpr__41813.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41813.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42505)){
var error__37820__auto___42508 = temp__5804__auto___42505;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42508], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41792_42475,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42508], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41792_42475,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41793_42476], null)));

var ufv___42512 = schema.utils.use_fn_validation;
var output_schema41814_42513 = deercreeklabs.baracus.ByteArray;
var input_schema41815_42514 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41816_42515 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41815_42514);
}),null));
var output_checker41817_42516 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41814_42513);
}),null));
var ret__39944__auto___42521 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41818){
var validate__37818__auto__ = cljs.core.deref(ufv___42512);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42522 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41818], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41820_42523 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41821_42524 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41822_42525 = input_schema41815_42514;
var G__41823_42526 = cljs.core.deref(input_checker41816_42515);
var G__41824_42527 = args__37819__auto___42522;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41820_42523,G__41821_42524,G__41822_42525,G__41823_42526,G__41824_42527) : schema.core.fn_validator.call(null,G__41820_42523,G__41821_42524,G__41822_42525,G__41823_42526,G__41824_42527));
} else {
var temp__5804__auto___42529 = (function (){var fexpr__41825 = cljs.core.deref(input_checker41816_42515);
return (fexpr__41825.cljs$core$IFn$_invoke$arity$1 ? fexpr__41825.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42522) : fexpr__41825.call(null,args__37819__auto___42522));
})();
if(cljs.core.truth_(temp__5804__auto___42529)){
var error__37820__auto___42530 = temp__5804__auto___42529;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42530], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41815_42514,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42522,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42530], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41818;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41826_42535 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41827_42536 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41828_42537 = output_schema41814_42513;
var G__41829_42538 = cljs.core.deref(output_checker41817_42516);
var G__41830_42539 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41826_42535,G__41827_42536,G__41828_42537,G__41829_42538,G__41830_42539) : schema.core.fn_validator.call(null,G__41826_42535,G__41827_42536,G__41828_42537,G__41829_42538,G__41830_42539));
} else {
var temp__5804__auto___42540 = (function (){var fexpr__41831 = cljs.core.deref(output_checker41817_42516);
return (fexpr__41831.cljs$core$IFn$_invoke$arity$1 ? fexpr__41831.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41831.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42540)){
var error__37820__auto___42541 = temp__5804__auto___42540;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42541], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41814_42513,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42541], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41814_42513,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41815_42514], null)));

var ufv___42546 = schema.utils.use_fn_validation;
var output_schema41832_42547 = deercreeklabs.baracus.ByteArray;
var input_schema41833_42548 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41834_42549 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41833_42548);
}),null));
var output_checker41835_42550 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41832_42547);
}),null));
var ret__39944__auto___42557 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41836){
var validate__37818__auto__ = cljs.core.deref(ufv___42546);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42558 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41836], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41838_42559 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41839_42560 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41840_42561 = input_schema41833_42548;
var G__41841_42562 = cljs.core.deref(input_checker41834_42549);
var G__41842_42563 = args__37819__auto___42558;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41838_42559,G__41839_42560,G__41840_42561,G__41841_42562,G__41842_42563) : schema.core.fn_validator.call(null,G__41838_42559,G__41839_42560,G__41840_42561,G__41841_42562,G__41842_42563));
} else {
var temp__5804__auto___42565 = (function (){var fexpr__41843 = cljs.core.deref(input_checker41834_42549);
return (fexpr__41843.cljs$core$IFn$_invoke$arity$1 ? fexpr__41843.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42558) : fexpr__41843.call(null,args__37819__auto___42558));
})();
if(cljs.core.truth_(temp__5804__auto___42565)){
var error__37820__auto___42566 = temp__5804__auto___42565;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42566], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41833_42548,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42558,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42566], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41836;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41844_42571 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41845_42572 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41846_42573 = output_schema41832_42547;
var G__41847_42574 = cljs.core.deref(output_checker41835_42550);
var G__41848_42575 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41844_42571,G__41845_42572,G__41846_42573,G__41847_42574,G__41848_42575) : schema.core.fn_validator.call(null,G__41844_42571,G__41845_42572,G__41846_42573,G__41847_42574,G__41848_42575));
} else {
var temp__5804__auto___42576 = (function (){var fexpr__41849 = cljs.core.deref(output_checker41835_42550);
return (fexpr__41849.cljs$core$IFn$_invoke$arity$1 ? fexpr__41849.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41849.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42576)){
var error__37820__auto___42578 = temp__5804__auto___42576;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42578], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41832_42547,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42578], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41832_42547,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41833_42548], null)));

var ufv___42581 = schema.utils.use_fn_validation;
var output_schema41851_42582 = deercreeklabs.baracus.ByteArray;
var input_schema41852_42583 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41853_42584 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41852_42583);
}),null));
var output_checker41854_42585 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41851_42582);
}),null));
var ret__39944__auto___42588 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41855){
var validate__37818__auto__ = cljs.core.deref(ufv___42581);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___42591 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41855], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41857_42592 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41858_42593 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41859_42594 = input_schema41852_42583;
var G__41860_42595 = cljs.core.deref(input_checker41853_42584);
var G__41861_42596 = args__37819__auto___42591;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41857_42592,G__41858_42593,G__41859_42594,G__41860_42595,G__41861_42596) : schema.core.fn_validator.call(null,G__41857_42592,G__41858_42593,G__41859_42594,G__41860_42595,G__41861_42596));
} else {
var temp__5804__auto___42598 = (function (){var fexpr__41862 = cljs.core.deref(input_checker41853_42584);
return (fexpr__41862.cljs$core$IFn$_invoke$arity$1 ? fexpr__41862.cljs$core$IFn$_invoke$arity$1(args__37819__auto___42591) : fexpr__41862.call(null,args__37819__auto___42591));
})();
if(cljs.core.truth_(temp__5804__auto___42598)){
var error__37820__auto___42599 = temp__5804__auto___42598;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42599], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41852_42583,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___42591,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42599], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var ba = G__41855;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41864_42601 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41865_42602 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41866_42603 = output_schema41851_42582;
var G__41867_42604 = cljs.core.deref(output_checker41854_42585);
var G__41868_42605 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41864_42601,G__41865_42602,G__41866_42603,G__41867_42604,G__41868_42605) : schema.core.fn_validator.call(null,G__41864_42601,G__41865_42602,G__41866_42603,G__41867_42604,G__41868_42605));
} else {
var temp__5804__auto___42606 = (function (){var fexpr__41869 = cljs.core.deref(output_checker41854_42585);
return (fexpr__41869.cljs$core$IFn$_invoke$arity$1 ? fexpr__41869.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__41869.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42606)){
var error__37820__auto___42607 = temp__5804__auto___42606;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___42607], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41851_42582,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___42607], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41851_42582,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41852_42583], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
