goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39075__39076__auto__){
if((!((p1__39075__39076__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39075__39076__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39075__39076__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39075__39076__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39075__39076__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___55236 = schema.utils.use_fn_validation;
var output_schema54499_55237 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54500_55238 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker54501_55239 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54500_55238);
}),null));
var output_checker54502_55240 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54499_55237);
}),null));
var ret__39944__auto___55241 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__54503){
var validate__37818__auto__ = cljs.core.deref(ufv___55236);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55242 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54503], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54511_55243 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54512_55244 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__54513_55245 = input_schema54500_55238;
var G__54514_55246 = cljs.core.deref(input_checker54501_55239);
var G__54515_55247 = args__37819__auto___55242;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54511_55243,G__54512_55244,G__54513_55245,G__54514_55246,G__54515_55247) : schema.core.fn_validator.call(null,G__54511_55243,G__54512_55244,G__54513_55245,G__54514_55246,G__54515_55247));
} else {
var temp__5804__auto___55248 = (function (){var fexpr__54516 = cljs.core.deref(input_checker54501_55239);
return (fexpr__54516.cljs$core$IFn$_invoke$arity$1 ? fexpr__54516.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55242) : fexpr__54516.call(null,args__37819__auto___55242));
})();
if(cljs.core.truth_(temp__5804__auto___55248)){
var error__37820__auto___55249 = temp__5804__auto___55248;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55249], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54500_55238,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55242,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55249], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var json = G__54503;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54518_55252 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54519_55253 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__54520_55254 = output_schema54499_55237;
var G__54521_55255 = cljs.core.deref(output_checker54502_55240);
var G__54522_55256 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54518_55252,G__54519_55253,G__54520_55254,G__54521_55255,G__54522_55256) : schema.core.fn_validator.call(null,G__54518_55252,G__54519_55253,G__54520_55254,G__54521_55255,G__54522_55256));
} else {
var temp__5804__auto___55257 = (function (){var fexpr__54524 = cljs.core.deref(output_checker54502_55240);
return (fexpr__54524.cljs$core$IFn$_invoke$arity$1 ? fexpr__54524.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54524.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55257)){
var error__37820__auto___55258 = temp__5804__auto___55257;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55258], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54499_55237,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55258], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema54499_55237,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54500_55238], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___55259 = schema.utils.use_fn_validation;
var output_schema54527_55260 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54528_55261 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema54533_55262 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker54529_55263 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54528_55261);
}),null));
var output_checker54530_55264 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54527_55260);
}),null));
var input_checker54534_55265 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54533_55262);
}),null));
var output_checker54535_55266 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54527_55260);
}),null));
var ret__39944__auto___55267 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__54541 = arguments.length;
switch (G__54541) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__54531,G__54532){
var validate__37818__auto__ = cljs.core.deref(ufv___55259);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55269 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54531,G__54532], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54544_55270 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54545_55271 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__54546_55272 = input_schema54528_55261;
var G__54547_55273 = cljs.core.deref(input_checker54529_55263);
var G__54548_55274 = args__37819__auto___55269;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54544_55270,G__54545_55271,G__54546_55272,G__54547_55273,G__54548_55274) : schema.core.fn_validator.call(null,G__54544_55270,G__54545_55271,G__54546_55272,G__54547_55273,G__54548_55274));
} else {
var temp__5804__auto___55275 = (function (){var fexpr__54550 = cljs.core.deref(input_checker54529_55263);
return (fexpr__54550.cljs$core$IFn$_invoke$arity$1 ? fexpr__54550.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55269) : fexpr__54550.call(null,args__37819__auto___55269));
})();
if(cljs.core.truth_(temp__5804__auto___55275)){
var error__37820__auto___55276 = temp__5804__auto___55275;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55276], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54528_55261,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55269,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55276], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var name_kw = G__54531;
var fields = G__54532;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54560_55277 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54561_55278 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__54562_55279 = output_schema54527_55260;
var G__54563_55280 = cljs.core.deref(output_checker54530_55264);
var G__54564_55281 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54560_55277,G__54561_55278,G__54562_55279,G__54563_55280,G__54564_55281) : schema.core.fn_validator.call(null,G__54560_55277,G__54561_55278,G__54562_55279,G__54563_55280,G__54564_55281));
} else {
var temp__5804__auto___55282 = (function (){var fexpr__54566 = cljs.core.deref(output_checker54530_55264);
return (fexpr__54566.cljs$core$IFn$_invoke$arity$1 ? fexpr__54566.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54566.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55282)){
var error__37820__auto___55283 = temp__5804__auto___55282;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55283], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54527_55260,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55283], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__54536,G__54537,G__54538){
var validate__37818__auto__ = cljs.core.deref(ufv___55259);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55284 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54536,G__54537,G__54538], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54567_55285 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54568_55286 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__54569_55287 = input_schema54533_55262;
var G__54570_55288 = cljs.core.deref(input_checker54534_55265);
var G__54571_55289 = args__37819__auto___55284;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54567_55285,G__54568_55286,G__54569_55287,G__54570_55288,G__54571_55289) : schema.core.fn_validator.call(null,G__54567_55285,G__54568_55286,G__54569_55287,G__54570_55288,G__54571_55289));
} else {
var temp__5804__auto___55290 = (function (){var fexpr__54576 = cljs.core.deref(input_checker54534_55265);
return (fexpr__54576.cljs$core$IFn$_invoke$arity$1 ? fexpr__54576.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55284) : fexpr__54576.call(null,args__37819__auto___55284));
})();
if(cljs.core.truth_(temp__5804__auto___55290)){
var error__37820__auto___55291 = temp__5804__auto___55290;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55291], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54533_55262,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55284,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55291], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var name_kw = G__54536;
var docstring = G__54537;
var fields = G__54538;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54577_55292 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54578_55293 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__54579_55294 = output_schema54527_55260;
var G__54580_55295 = cljs.core.deref(output_checker54535_55266);
var G__54581_55296 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54577_55292,G__54578_55293,G__54579_55294,G__54580_55295,G__54581_55296) : schema.core.fn_validator.call(null,G__54577_55292,G__54578_55293,G__54579_55294,G__54580_55295,G__54581_55296));
} else {
var temp__5804__auto___55297 = (function (){var fexpr__54585 = cljs.core.deref(output_checker54535_55266);
return (fexpr__54585.cljs$core$IFn$_invoke$arity$1 ? fexpr__54585.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54585.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55297)){
var error__37820__auto___55299 = temp__5804__auto___55297;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55299], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54527_55260,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55299], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema54527_55260,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54528_55261,input_schema54533_55262], null)));

var ufv___55301 = schema.utils.use_fn_validation;
var output_schema54587_55302 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54588_55303 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema54593_55304 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker54589_55305 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54588_55303);
}),null));
var output_checker54590_55306 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54587_55302);
}),null));
var input_checker54594_55307 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54593_55304);
}),null));
var output_checker54595_55308 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54587_55302);
}),null));
var ret__39944__auto___55309 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__54604 = arguments.length;
switch (G__54604) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__54591,G__54592){
var validate__37818__auto__ = cljs.core.deref(ufv___55301);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55311 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54591,G__54592], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54606_55312 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54607_55313 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__54608_55314 = input_schema54588_55303;
var G__54609_55315 = cljs.core.deref(input_checker54589_55305);
var G__54610_55316 = args__37819__auto___55311;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54606_55312,G__54607_55313,G__54608_55314,G__54609_55315,G__54610_55316) : schema.core.fn_validator.call(null,G__54606_55312,G__54607_55313,G__54608_55314,G__54609_55315,G__54610_55316));
} else {
var temp__5804__auto___55317 = (function (){var fexpr__54611 = cljs.core.deref(input_checker54589_55305);
return (fexpr__54611.cljs$core$IFn$_invoke$arity$1 ? fexpr__54611.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55311) : fexpr__54611.call(null,args__37819__auto___55311));
})();
if(cljs.core.truth_(temp__5804__auto___55317)){
var error__37820__auto___55318 = temp__5804__auto___55317;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55318], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54588_55303,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55311,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55318], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var name_kw = G__54591;
var symbol_keywords = G__54592;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54614_55319 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54615_55320 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__54616_55321 = output_schema54587_55302;
var G__54617_55322 = cljs.core.deref(output_checker54590_55306);
var G__54618_55323 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54614_55319,G__54615_55320,G__54616_55321,G__54617_55322,G__54618_55323) : schema.core.fn_validator.call(null,G__54614_55319,G__54615_55320,G__54616_55321,G__54617_55322,G__54618_55323));
} else {
var temp__5804__auto___55324 = (function (){var fexpr__54619 = cljs.core.deref(output_checker54590_55306);
return (fexpr__54619.cljs$core$IFn$_invoke$arity$1 ? fexpr__54619.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54619.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55324)){
var error__37820__auto___55325 = temp__5804__auto___55324;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55325], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54587_55302,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55325], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__54596,G__54597,G__54598){
var validate__37818__auto__ = cljs.core.deref(ufv___55301);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55328 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54596,G__54597,G__54598], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54621_55329 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54622_55330 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__54623_55331 = input_schema54593_55304;
var G__54624_55332 = cljs.core.deref(input_checker54594_55307);
var G__54625_55333 = args__37819__auto___55328;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54621_55329,G__54622_55330,G__54623_55331,G__54624_55332,G__54625_55333) : schema.core.fn_validator.call(null,G__54621_55329,G__54622_55330,G__54623_55331,G__54624_55332,G__54625_55333));
} else {
var temp__5804__auto___55336 = (function (){var fexpr__54627 = cljs.core.deref(input_checker54594_55307);
return (fexpr__54627.cljs$core$IFn$_invoke$arity$1 ? fexpr__54627.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55328) : fexpr__54627.call(null,args__37819__auto___55328));
})();
if(cljs.core.truth_(temp__5804__auto___55336)){
var error__37820__auto___55337 = temp__5804__auto___55336;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55337], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54593_55304,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55328,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55337], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var name_kw = G__54596;
var docstring = G__54597;
var symbol_keywords = G__54598;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54629_55340 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54630_55341 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__54631_55342 = output_schema54587_55302;
var G__54632_55343 = cljs.core.deref(output_checker54595_55308);
var G__54633_55344 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54629_55340,G__54630_55341,G__54631_55342,G__54632_55343,G__54633_55344) : schema.core.fn_validator.call(null,G__54629_55340,G__54630_55341,G__54631_55342,G__54632_55343,G__54633_55344));
} else {
var temp__5804__auto___55345 = (function (){var fexpr__54635 = cljs.core.deref(output_checker54595_55308);
return (fexpr__54635.cljs$core$IFn$_invoke$arity$1 ? fexpr__54635.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54635.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55345)){
var error__37820__auto___55347 = temp__5804__auto___55345;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55347], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54587_55302,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55347], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema54587_55302,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54588_55303,input_schema54593_55304], null)));

var ufv___55352 = schema.utils.use_fn_validation;
var output_schema54638_55353 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54639_55354 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54640_55355 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54639_55354);
}),null));
var output_checker54641_55356 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54638_55353);
}),null));
var ret__39944__auto___55357 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__54642,G__54643){
var validate__37818__auto__ = cljs.core.deref(ufv___55352);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55360 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54642,G__54643], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54644_55362 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54645_55363 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__54646_55364 = input_schema54639_55354;
var G__54647_55365 = cljs.core.deref(input_checker54640_55355);
var G__54648_55366 = args__37819__auto___55360;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54644_55362,G__54645_55363,G__54646_55364,G__54647_55365,G__54648_55366) : schema.core.fn_validator.call(null,G__54644_55362,G__54645_55363,G__54646_55364,G__54647_55365,G__54648_55366));
} else {
var temp__5804__auto___55368 = (function (){var fexpr__54650 = cljs.core.deref(input_checker54640_55355);
return (fexpr__54650.cljs$core$IFn$_invoke$arity$1 ? fexpr__54650.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55360) : fexpr__54650.call(null,args__37819__auto___55360));
})();
if(cljs.core.truth_(temp__5804__auto___55368)){
var error__37820__auto___55370 = temp__5804__auto___55368;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55370], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54639_55354,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55360,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55370], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var name_kw = G__54642;
var size = G__54643;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54653_55374 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54654_55375 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__54655_55376 = output_schema54638_55353;
var G__54656_55377 = cljs.core.deref(output_checker54641_55356);
var G__54657_55378 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54653_55374,G__54654_55375,G__54655_55376,G__54656_55377,G__54657_55378) : schema.core.fn_validator.call(null,G__54653_55374,G__54654_55375,G__54655_55376,G__54656_55377,G__54657_55378));
} else {
var temp__5804__auto___55380 = (function (){var fexpr__54658 = cljs.core.deref(output_checker54641_55356);
return (fexpr__54658.cljs$core$IFn$_invoke$arity$1 ? fexpr__54658.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54658.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55380)){
var error__37820__auto___55382 = temp__5804__auto___55380;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55382], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54638_55353,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55382], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema54638_55353,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54639_55354], null)));

var ufv___55386 = schema.utils.use_fn_validation;
var output_schema54659_55387 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54660_55388 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker54661_55389 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54660_55388);
}),null));
var output_checker54662_55390 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54659_55387);
}),null));
var ret__39944__auto___55393 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__54663){
var validate__37818__auto__ = cljs.core.deref(ufv___55386);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55394 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54663], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54664_55395 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54665_55396 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__54666_55397 = input_schema54660_55388;
var G__54667_55398 = cljs.core.deref(input_checker54661_55389);
var G__54668_55399 = args__37819__auto___55394;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54664_55395,G__54665_55396,G__54666_55397,G__54667_55398,G__54668_55399) : schema.core.fn_validator.call(null,G__54664_55395,G__54665_55396,G__54666_55397,G__54667_55398,G__54668_55399));
} else {
var temp__5804__auto___55401 = (function (){var fexpr__54670 = cljs.core.deref(input_checker54661_55389);
return (fexpr__54670.cljs$core$IFn$_invoke$arity$1 ? fexpr__54670.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55394) : fexpr__54670.call(null,args__37819__auto___55394));
})();
if(cljs.core.truth_(temp__5804__auto___55401)){
var error__37820__auto___55402 = temp__5804__auto___55401;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55402], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54660_55388,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55394,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55402], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var items_schema = G__54663;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54674_55405 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54675_55406 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__54676_55407 = output_schema54659_55387;
var G__54677_55408 = cljs.core.deref(output_checker54662_55390);
var G__54678_55409 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54674_55405,G__54675_55406,G__54676_55407,G__54677_55408,G__54678_55409) : schema.core.fn_validator.call(null,G__54674_55405,G__54675_55406,G__54676_55407,G__54677_55408,G__54678_55409));
} else {
var temp__5804__auto___55410 = (function (){var fexpr__54687 = cljs.core.deref(output_checker54662_55390);
return (fexpr__54687.cljs$core$IFn$_invoke$arity$1 ? fexpr__54687.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54687.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55410)){
var error__37820__auto___55412 = temp__5804__auto___55410;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55412], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54659_55387,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55412], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema54659_55387,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54660_55388], null)));

var ufv___55414 = schema.utils.use_fn_validation;
var output_schema54695_55415 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54696_55416 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker54697_55417 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54696_55416);
}),null));
var output_checker54698_55418 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54695_55415);
}),null));
var ret__39944__auto___55421 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__54699){
var validate__37818__auto__ = cljs.core.deref(ufv___55414);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55422 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54699], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54710_55423 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54711_55424 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__54712_55425 = input_schema54696_55416;
var G__54713_55426 = cljs.core.deref(input_checker54697_55417);
var G__54714_55427 = args__37819__auto___55422;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54710_55423,G__54711_55424,G__54712_55425,G__54713_55426,G__54714_55427) : schema.core.fn_validator.call(null,G__54710_55423,G__54711_55424,G__54712_55425,G__54713_55426,G__54714_55427));
} else {
var temp__5804__auto___55429 = (function (){var fexpr__54719 = cljs.core.deref(input_checker54697_55417);
return (fexpr__54719.cljs$core$IFn$_invoke$arity$1 ? fexpr__54719.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55422) : fexpr__54719.call(null,args__37819__auto___55422));
})();
if(cljs.core.truth_(temp__5804__auto___55429)){
var error__37820__auto___55430 = temp__5804__auto___55429;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55430], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54696_55416,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55422,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55430], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var values_schema = G__54699;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54738_55435 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54739_55436 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__54740_55437 = output_schema54695_55415;
var G__54741_55438 = cljs.core.deref(output_checker54698_55418);
var G__54742_55439 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54738_55435,G__54739_55436,G__54740_55437,G__54741_55438,G__54742_55439) : schema.core.fn_validator.call(null,G__54738_55435,G__54739_55436,G__54740_55437,G__54741_55438,G__54742_55439));
} else {
var temp__5804__auto___55440 = (function (){var fexpr__54750 = cljs.core.deref(output_checker54698_55418);
return (fexpr__54750.cljs$core$IFn$_invoke$arity$1 ? fexpr__54750.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54750.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55440)){
var error__37820__auto___55441 = temp__5804__auto___55440;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55441], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54695_55415,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55441], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema54695_55415,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54696_55416], null)));

var ufv___55445 = schema.utils.use_fn_validation;
var output_schema54751_55446 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54752_55447 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker54753_55448 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54752_55447);
}),null));
var output_checker54754_55449 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54751_55446);
}),null));
var ret__39944__auto___55452 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__54755){
var validate__37818__auto__ = cljs.core.deref(ufv___55445);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55453 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54755], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54758_55454 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54759_55455 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__54760_55457 = input_schema54752_55447;
var G__54761_55458 = cljs.core.deref(input_checker54753_55448);
var G__54762_55459 = args__37819__auto___55453;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54758_55454,G__54759_55455,G__54760_55457,G__54761_55458,G__54762_55459) : schema.core.fn_validator.call(null,G__54758_55454,G__54759_55455,G__54760_55457,G__54761_55458,G__54762_55459));
} else {
var temp__5804__auto___55460 = (function (){var fexpr__54764 = cljs.core.deref(input_checker54753_55448);
return (fexpr__54764.cljs$core$IFn$_invoke$arity$1 ? fexpr__54764.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55453) : fexpr__54764.call(null,args__37819__auto___55453));
})();
if(cljs.core.truth_(temp__5804__auto___55460)){
var error__37820__auto___55462 = temp__5804__auto___55460;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55462], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54752_55447,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55453,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55462], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var member_schemas = G__54755;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54766_55464 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54767_55465 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__54768_55466 = output_schema54751_55446;
var G__54769_55467 = cljs.core.deref(output_checker54754_55449);
var G__54770_55468 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54766_55464,G__54767_55465,G__54768_55466,G__54769_55467,G__54770_55468) : schema.core.fn_validator.call(null,G__54766_55464,G__54767_55465,G__54768_55466,G__54769_55467,G__54770_55468));
} else {
var temp__5804__auto___55470 = (function (){var fexpr__54771 = cljs.core.deref(output_checker54754_55449);
return (fexpr__54771.cljs$core$IFn$_invoke$arity$1 ? fexpr__54771.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54771.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55470)){
var error__37820__auto___55472 = temp__5804__auto___55470;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55472], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54751_55446,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55472], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema54751_55446,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54752_55447], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___55473 = schema.utils.use_fn_validation;
var output_schema54772_55474 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54773_55475 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker54774_55476 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54773_55475);
}),null));
var output_checker54775_55477 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54772_55474);
}),null));
var ret__39944__auto___55479 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__54776){
var validate__37818__auto__ = cljs.core.deref(ufv___55473);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55480 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54776], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54777_55481 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54778_55482 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__54779_55483 = input_schema54773_55475;
var G__54780_55484 = cljs.core.deref(input_checker54774_55476);
var G__54781_55485 = args__37819__auto___55480;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54777_55481,G__54778_55482,G__54779_55483,G__54780_55484,G__54781_55485) : schema.core.fn_validator.call(null,G__54777_55481,G__54778_55482,G__54779_55483,G__54780_55484,G__54781_55485));
} else {
var temp__5804__auto___55491 = (function (){var fexpr__54782 = cljs.core.deref(input_checker54774_55476);
return (fexpr__54782.cljs$core$IFn$_invoke$arity$1 ? fexpr__54782.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55480) : fexpr__54782.call(null,args__37819__auto___55480));
})();
if(cljs.core.truth_(temp__5804__auto___55491)){
var error__37820__auto___55492 = temp__5804__auto___55491;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55492], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54773_55475,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55480,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55492], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54776;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54783_55496 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54784_55497 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__54785_55498 = output_schema54772_55474;
var G__54786_55499 = cljs.core.deref(output_checker54775_55477);
var G__54787_55500 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54783_55496,G__54784_55497,G__54785_55498,G__54786_55499,G__54787_55500) : schema.core.fn_validator.call(null,G__54783_55496,G__54784_55497,G__54785_55498,G__54786_55499,G__54787_55500));
} else {
var temp__5804__auto___55502 = (function (){var fexpr__54788 = cljs.core.deref(output_checker54775_55477);
return (fexpr__54788.cljs$core$IFn$_invoke$arity$1 ? fexpr__54788.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54788.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55502)){
var error__37820__auto___55503 = temp__5804__auto___55502;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55503], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54772_55474,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55503], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema54772_55474,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54773_55475], null)));

var ufv___55505 = schema.utils.use_fn_validation;
var output_schema54789_55506 = deercreeklabs.baracus.ByteArray;
var input_schema54790_55507 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker54791_55508 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54790_55507);
}),null));
var output_checker54792_55509 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54789_55506);
}),null));
var ret__39944__auto___55511 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__54793,G__54794){
var validate__37818__auto__ = cljs.core.deref(ufv___55505);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55512 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54793,G__54794], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54795_55513 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54796_55514 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__54797_55515 = input_schema54790_55507;
var G__54798_55516 = cljs.core.deref(input_checker54791_55508);
var G__54799_55517 = args__37819__auto___55512;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54795_55513,G__54796_55514,G__54797_55515,G__54798_55516,G__54799_55517) : schema.core.fn_validator.call(null,G__54795_55513,G__54796_55514,G__54797_55515,G__54798_55516,G__54799_55517));
} else {
var temp__5804__auto___55523 = (function (){var fexpr__54800 = cljs.core.deref(input_checker54791_55508);
return (fexpr__54800.cljs$core$IFn$_invoke$arity$1 ? fexpr__54800.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55512) : fexpr__54800.call(null,args__37819__auto___55512));
})();
if(cljs.core.truth_(temp__5804__auto___55523)){
var error__37820__auto___55525 = temp__5804__auto___55523;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55525], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54790_55507,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55512,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55525], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var writer_schema = G__54793;
var data = G__54794;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54802_55526 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54803_55527 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__54804_55528 = output_schema54789_55506;
var G__54805_55529 = cljs.core.deref(output_checker54792_55509);
var G__54806_55530 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54802_55526,G__54803_55527,G__54804_55528,G__54805_55529,G__54806_55530) : schema.core.fn_validator.call(null,G__54802_55526,G__54803_55527,G__54804_55528,G__54805_55529,G__54806_55530));
} else {
var temp__5804__auto___55532 = (function (){var fexpr__54807 = cljs.core.deref(output_checker54792_55509);
return (fexpr__54807.cljs$core$IFn$_invoke$arity$1 ? fexpr__54807.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54807.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55532)){
var error__37820__auto___55534 = temp__5804__auto___55532;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55534], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54789_55506,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55534], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema54789_55506,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54790_55507], null)));

var ufv___55535 = schema.utils.use_fn_validation;
var output_schema54808_55536 = schema.core.Any;
var input_schema54809_55537 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker54810_55538 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54809_55537);
}),null));
var output_checker54811_55539 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54808_55536);
}),null));
var ret__39944__auto___55541 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__54812,G__54813,G__54814){
var validate__37818__auto__ = cljs.core.deref(ufv___55535);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55543 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54812,G__54813,G__54814], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54815_55544 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54816_55545 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__54817_55546 = input_schema54809_55537;
var G__54818_55547 = cljs.core.deref(input_checker54810_55538);
var G__54819_55548 = args__37819__auto___55543;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54815_55544,G__54816_55545,G__54817_55546,G__54818_55547,G__54819_55548) : schema.core.fn_validator.call(null,G__54815_55544,G__54816_55545,G__54817_55546,G__54818_55547,G__54819_55548));
} else {
var temp__5804__auto___55550 = (function (){var fexpr__54820 = cljs.core.deref(input_checker54810_55538);
return (fexpr__54820.cljs$core$IFn$_invoke$arity$1 ? fexpr__54820.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55543) : fexpr__54820.call(null,args__37819__auto___55543));
})();
if(cljs.core.truth_(temp__5804__auto___55550)){
var error__37820__auto___55551 = temp__5804__auto___55550;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55551], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54809_55537,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55543,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55551], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var reader_schema = G__54812;
var writer_schema = G__54813;
var ba = G__54814;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54823_55558 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54824_55559 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__54825_55560 = output_schema54808_55536;
var G__54826_55561 = cljs.core.deref(output_checker54811_55539);
var G__54827_55562 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54823_55558,G__54824_55559,G__54825_55560,G__54826_55561,G__54827_55562) : schema.core.fn_validator.call(null,G__54823_55558,G__54824_55559,G__54825_55560,G__54826_55561,G__54827_55562));
} else {
var temp__5804__auto___55563 = (function (){var fexpr__54828 = cljs.core.deref(output_checker54811_55539);
return (fexpr__54828.cljs$core$IFn$_invoke$arity$1 ? fexpr__54828.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54828.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55563)){
var error__37820__auto___55565 = temp__5804__auto___55563;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55565], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54808_55536,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55565], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema54808_55536,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54809_55537], null)));

var ufv___55571 = schema.utils.use_fn_validation;
var output_schema54829_55572 = schema.core.Any;
var input_schema54830_55573 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker54831_55574 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54830_55573);
}),null));
var output_checker54832_55575 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54829_55572);
}),null));
var ret__39944__auto___55576 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__54833,G__54834){
var validate__37818__auto__ = cljs.core.deref(ufv___55571);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55577 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54833,G__54834], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54835_55578 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54836_55579 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__54837_55580 = input_schema54830_55573;
var G__54838_55581 = cljs.core.deref(input_checker54831_55574);
var G__54839_55582 = args__37819__auto___55577;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54835_55578,G__54836_55579,G__54837_55580,G__54838_55581,G__54839_55582) : schema.core.fn_validator.call(null,G__54835_55578,G__54836_55579,G__54837_55580,G__54838_55581,G__54839_55582));
} else {
var temp__5804__auto___55583 = (function (){var fexpr__54840 = cljs.core.deref(input_checker54831_55574);
return (fexpr__54840.cljs$core$IFn$_invoke$arity$1 ? fexpr__54840.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55577) : fexpr__54840.call(null,args__37819__auto___55577));
})();
if(cljs.core.truth_(temp__5804__auto___55583)){
var error__37820__auto___55585 = temp__5804__auto___55583;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55585], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54830_55573,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55577,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55585], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54833;
var ba = G__54834;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54841_55587 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54842_55588 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__54843_55589 = output_schema54829_55572;
var G__54844_55590 = cljs.core.deref(output_checker54832_55575);
var G__54845_55591 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54841_55587,G__54842_55588,G__54843_55589,G__54844_55590,G__54845_55591) : schema.core.fn_validator.call(null,G__54841_55587,G__54842_55588,G__54843_55589,G__54844_55590,G__54845_55591));
} else {
var temp__5804__auto___55595 = (function (){var fexpr__54846 = cljs.core.deref(output_checker54832_55575);
return (fexpr__54846.cljs$core$IFn$_invoke$arity$1 ? fexpr__54846.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54846.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55595)){
var error__37820__auto___55596 = temp__5804__auto___55595;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55596], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54829_55572,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55596], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema54829_55572,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54830_55573], null)));

var ufv___55598 = schema.utils.use_fn_validation;
var output_schema54847_55599 = schema.core.Any;
var input_schema54848_55600 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54849_55601 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54848_55600);
}),null));
var output_checker54850_55602 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54847_55599);
}),null));
var ret__39944__auto___55603 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__54851){
var validate__37818__auto__ = cljs.core.deref(ufv___55598);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55604 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54851], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54852_55606 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54853_55607 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__54854_55608 = input_schema54848_55600;
var G__54855_55609 = cljs.core.deref(input_checker54849_55601);
var G__54856_55610 = args__37819__auto___55604;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54852_55606,G__54853_55607,G__54854_55608,G__54855_55609,G__54856_55610) : schema.core.fn_validator.call(null,G__54852_55606,G__54853_55607,G__54854_55608,G__54855_55609,G__54856_55610));
} else {
var temp__5804__auto___55614 = (function (){var fexpr__54857 = cljs.core.deref(input_checker54849_55601);
return (fexpr__54857.cljs$core$IFn$_invoke$arity$1 ? fexpr__54857.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55604) : fexpr__54857.call(null,args__37819__auto___55604));
})();
if(cljs.core.truth_(temp__5804__auto___55614)){
var error__37820__auto___55615 = temp__5804__auto___55614;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55615], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54848_55600,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55604,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55615], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54851;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54858_55616 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54859_55617 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__54860_55618 = output_schema54847_55599;
var G__54861_55619 = cljs.core.deref(output_checker54850_55602);
var G__54862_55620 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54858_55616,G__54859_55617,G__54860_55618,G__54861_55619,G__54862_55620) : schema.core.fn_validator.call(null,G__54858_55616,G__54859_55617,G__54860_55618,G__54861_55619,G__54862_55620));
} else {
var temp__5804__auto___55621 = (function (){var fexpr__54863 = cljs.core.deref(output_checker54850_55602);
return (fexpr__54863.cljs$core$IFn$_invoke$arity$1 ? fexpr__54863.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54863.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55621)){
var error__37820__auto___55623 = temp__5804__auto___55621;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55623], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54847_55599,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55623], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema54847_55599,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54848_55600], null)));

var ufv___55624 = schema.utils.use_fn_validation;
var output_schema54864_55625 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54865_55626 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker54866_55627 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54865_55626);
}),null));
var output_checker54867_55628 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54864_55625);
}),null));
var ret__39944__auto___55629 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__54868){
var validate__37818__auto__ = cljs.core.deref(ufv___55624);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55631 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54868], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54871_55632 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54872_55633 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__54873_55634 = input_schema54865_55626;
var G__54874_55635 = cljs.core.deref(input_checker54866_55627);
var G__54875_55636 = args__37819__auto___55631;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54871_55632,G__54872_55633,G__54873_55634,G__54874_55635,G__54875_55636) : schema.core.fn_validator.call(null,G__54871_55632,G__54872_55633,G__54873_55634,G__54874_55635,G__54875_55636));
} else {
var temp__5804__auto___55637 = (function (){var fexpr__54876 = cljs.core.deref(input_checker54866_55627);
return (fexpr__54876.cljs$core$IFn$_invoke$arity$1 ? fexpr__54876.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55631) : fexpr__54876.call(null,args__37819__auto___55631));
})();
if(cljs.core.truth_(temp__5804__auto___55637)){
var error__37820__auto___55639 = temp__5804__auto___55637;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55639], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54865_55626,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55631,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55639], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var edn = G__54868;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54877_55641 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54878_55642 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__54879_55643 = output_schema54864_55625;
var G__54880_55644 = cljs.core.deref(output_checker54867_55628);
var G__54881_55645 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54877_55641,G__54878_55642,G__54879_55643,G__54880_55644,G__54881_55645) : schema.core.fn_validator.call(null,G__54877_55641,G__54878_55642,G__54879_55643,G__54880_55644,G__54881_55645));
} else {
var temp__5804__auto___55646 = (function (){var fexpr__54882 = cljs.core.deref(output_checker54867_55628);
return (fexpr__54882.cljs$core$IFn$_invoke$arity$1 ? fexpr__54882.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54882.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55646)){
var error__37820__auto___55648 = temp__5804__auto___55646;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55648], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54864_55625,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55648], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema54864_55625,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54865_55626], null)));

var ufv___55651 = schema.utils.use_fn_validation;
var output_schema54883_55652 = schema.core.Str;
var input_schema54884_55653 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54885_55654 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54884_55653);
}),null));
var output_checker54886_55655 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54883_55652);
}),null));
var ret__39944__auto___55659 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__54887){
var validate__37818__auto__ = cljs.core.deref(ufv___55651);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55660 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54887], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54888_55661 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54889_55662 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__54890_55663 = input_schema54884_55653;
var G__54891_55664 = cljs.core.deref(input_checker54885_55654);
var G__54892_55665 = args__37819__auto___55660;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54888_55661,G__54889_55662,G__54890_55663,G__54891_55664,G__54892_55665) : schema.core.fn_validator.call(null,G__54888_55661,G__54889_55662,G__54890_55663,G__54891_55664,G__54892_55665));
} else {
var temp__5804__auto___55669 = (function (){var fexpr__54893 = cljs.core.deref(input_checker54885_55654);
return (fexpr__54893.cljs$core$IFn$_invoke$arity$1 ? fexpr__54893.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55660) : fexpr__54893.call(null,args__37819__auto___55660));
})();
if(cljs.core.truth_(temp__5804__auto___55669)){
var error__37820__auto___55670 = temp__5804__auto___55669;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55670], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54884_55653,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55660,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55670], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54887;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54894_55673 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54895_55674 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__54896_55675 = output_schema54883_55652;
var G__54897_55676 = cljs.core.deref(output_checker54886_55655);
var G__54898_55677 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54894_55673,G__54895_55674,G__54896_55675,G__54897_55676,G__54898_55677) : schema.core.fn_validator.call(null,G__54894_55673,G__54895_55674,G__54896_55675,G__54897_55676,G__54898_55677));
} else {
var temp__5804__auto___55678 = (function (){var fexpr__54899 = cljs.core.deref(output_checker54886_55655);
return (fexpr__54899.cljs$core$IFn$_invoke$arity$1 ? fexpr__54899.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54899.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55678)){
var error__37820__auto___55679 = temp__5804__auto___55678;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55679], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54883_55652,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55679], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema54883_55652,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54884_55653], null)));

var ufv___55682 = schema.utils.use_fn_validation;
var output_schema54900_55683 = schema.core.Keyword;
var input_schema54901_55684 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54902_55685 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54901_55684);
}),null));
var output_checker54903_55686 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54900_55683);
}),null));
var ret__39944__auto___55689 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__54904){
var validate__37818__auto__ = cljs.core.deref(ufv___55682);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55693 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54904], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54906_55694 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54907_55695 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__54908_55696 = input_schema54901_55684;
var G__54909_55697 = cljs.core.deref(input_checker54902_55685);
var G__54910_55698 = args__37819__auto___55693;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54906_55694,G__54907_55695,G__54908_55696,G__54909_55697,G__54910_55698) : schema.core.fn_validator.call(null,G__54906_55694,G__54907_55695,G__54908_55696,G__54909_55697,G__54910_55698));
} else {
var temp__5804__auto___55699 = (function (){var fexpr__54911 = cljs.core.deref(input_checker54902_55685);
return (fexpr__54911.cljs$core$IFn$_invoke$arity$1 ? fexpr__54911.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55693) : fexpr__54911.call(null,args__37819__auto___55693));
})();
if(cljs.core.truth_(temp__5804__auto___55699)){
var error__37820__auto___55700 = temp__5804__auto___55699;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55700], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54901_55684,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55693,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55700], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54904;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54912_55701 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54913_55702 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__54914_55703 = output_schema54900_55683;
var G__54915_55704 = cljs.core.deref(output_checker54903_55686);
var G__54916_55705 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54912_55701,G__54913_55702,G__54914_55703,G__54915_55704,G__54916_55705) : schema.core.fn_validator.call(null,G__54912_55701,G__54913_55702,G__54914_55703,G__54915_55704,G__54916_55705));
} else {
var temp__5804__auto___55707 = (function (){var fexpr__54917 = cljs.core.deref(output_checker54903_55686);
return (fexpr__54917.cljs$core$IFn$_invoke$arity$1 ? fexpr__54917.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54917.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55707)){
var error__37820__auto___55708 = temp__5804__auto___55707;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55708], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54900_55683,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55708], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema54900_55683,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54901_55684], null)));

var ufv___55712 = schema.utils.use_fn_validation;
var output_schema54918_55713 = schema.core.Str;
var input_schema54919_55714 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54920_55715 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54919_55714);
}),null));
var output_checker54921_55716 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54918_55713);
}),null));
var ret__39944__auto___55717 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__54922){
var validate__37818__auto__ = cljs.core.deref(ufv___55712);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55718 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54922], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54923_55719 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54924_55720 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__54925_55721 = input_schema54919_55714;
var G__54926_55722 = cljs.core.deref(input_checker54920_55715);
var G__54927_55723 = args__37819__auto___55718;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54923_55719,G__54924_55720,G__54925_55721,G__54926_55722,G__54927_55723) : schema.core.fn_validator.call(null,G__54923_55719,G__54924_55720,G__54925_55721,G__54926_55722,G__54927_55723));
} else {
var temp__5804__auto___55725 = (function (){var fexpr__54928 = cljs.core.deref(input_checker54920_55715);
return (fexpr__54928.cljs$core$IFn$_invoke$arity$1 ? fexpr__54928.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55718) : fexpr__54928.call(null,args__37819__auto___55718));
})();
if(cljs.core.truth_(temp__5804__auto___55725)){
var error__37820__auto___55726 = temp__5804__auto___55725;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55726], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54919_55714,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55718,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55726], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54922;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54929_55727 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54930_55728 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__54931_55729 = output_schema54918_55713;
var G__54932_55730 = cljs.core.deref(output_checker54921_55716);
var G__54933_55731 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54929_55727,G__54930_55728,G__54931_55729,G__54932_55730,G__54933_55731) : schema.core.fn_validator.call(null,G__54929_55727,G__54930_55728,G__54931_55729,G__54932_55730,G__54933_55731));
} else {
var temp__5804__auto___55732 = (function (){var fexpr__54934 = cljs.core.deref(output_checker54921_55716);
return (fexpr__54934.cljs$core$IFn$_invoke$arity$1 ? fexpr__54934.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54934.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55732)){
var error__37820__auto___55733 = temp__5804__auto___55732;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55733], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54918_55713,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55733], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema54918_55713,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54919_55714], null)));

var ufv___55734 = schema.utils.use_fn_validation;
var output_schema54935_55735 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema54936_55736 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54937_55737 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54936_55736);
}),null));
var output_checker54938_55738 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54935_55735);
}),null));
var ret__39944__auto___55739 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__54939){
var validate__37818__auto__ = cljs.core.deref(ufv___55734);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55740 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54939], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54940_55741 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54941_55742 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54942_55743 = input_schema54936_55736;
var G__54943_55744 = cljs.core.deref(input_checker54937_55737);
var G__54944_55745 = args__37819__auto___55740;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54940_55741,G__54941_55742,G__54942_55743,G__54943_55744,G__54944_55745) : schema.core.fn_validator.call(null,G__54940_55741,G__54941_55742,G__54942_55743,G__54943_55744,G__54944_55745));
} else {
var temp__5804__auto___55746 = (function (){var fexpr__54945 = cljs.core.deref(input_checker54937_55737);
return (fexpr__54945.cljs$core$IFn$_invoke$arity$1 ? fexpr__54945.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55740) : fexpr__54945.call(null,args__37819__auto___55740));
})();
if(cljs.core.truth_(temp__5804__auto___55746)){
var error__37820__auto___55747 = temp__5804__auto___55746;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55747], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54936_55736,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55740,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55747], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54939;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54946_55748 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54947_55749 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54948_55750 = output_schema54935_55735;
var G__54949_55751 = cljs.core.deref(output_checker54938_55738);
var G__54950_55752 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54946_55748,G__54947_55749,G__54948_55750,G__54949_55751,G__54950_55752) : schema.core.fn_validator.call(null,G__54946_55748,G__54947_55749,G__54948_55750,G__54949_55751,G__54950_55752));
} else {
var temp__5804__auto___55753 = (function (){var fexpr__54951 = cljs.core.deref(output_checker54938_55738);
return (fexpr__54951.cljs$core$IFn$_invoke$arity$1 ? fexpr__54951.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54951.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55753)){
var error__37820__auto___55754 = temp__5804__auto___55753;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55754], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54935_55735,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55754], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema54935_55735,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54936_55736], null)));

var ufv___55759 = schema.utils.use_fn_validation;
var output_schema54952_55760 = deercreeklabs.baracus.ByteArray;
var input_schema54953_55761 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54954_55762 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54953_55761);
}),null));
var output_checker54955_55763 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54952_55760);
}),null));
var ret__39944__auto___55764 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__54956){
var validate__37818__auto__ = cljs.core.deref(ufv___55759);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55765 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54956], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54957_55766 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54958_55767 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54959_55768 = input_schema54953_55761;
var G__54960_55769 = cljs.core.deref(input_checker54954_55762);
var G__54961_55770 = args__37819__auto___55765;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54957_55766,G__54958_55767,G__54959_55768,G__54960_55769,G__54961_55770) : schema.core.fn_validator.call(null,G__54957_55766,G__54958_55767,G__54959_55768,G__54960_55769,G__54961_55770));
} else {
var temp__5804__auto___55771 = (function (){var fexpr__54962 = cljs.core.deref(input_checker54954_55762);
return (fexpr__54962.cljs$core$IFn$_invoke$arity$1 ? fexpr__54962.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55765) : fexpr__54962.call(null,args__37819__auto___55765));
})();
if(cljs.core.truth_(temp__5804__auto___55771)){
var error__37820__auto___55772 = temp__5804__auto___55771;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55772], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54953_55761,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55765,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55772], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54956;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54963_55773 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54964_55774 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54965_55775 = output_schema54952_55760;
var G__54966_55776 = cljs.core.deref(output_checker54955_55763);
var G__54967_55777 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54963_55773,G__54964_55774,G__54965_55775,G__54966_55776,G__54967_55777) : schema.core.fn_validator.call(null,G__54963_55773,G__54964_55774,G__54965_55775,G__54966_55776,G__54967_55777));
} else {
var temp__5804__auto___55779 = (function (){var fexpr__54968 = cljs.core.deref(output_checker54955_55763);
return (fexpr__54968.cljs$core$IFn$_invoke$arity$1 ? fexpr__54968.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54968.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55779)){
var error__37820__auto___55780 = temp__5804__auto___55779;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55780], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54952_55760,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55780], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema54952_55760,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54953_55761], null)));

var ufv___55782 = schema.utils.use_fn_validation;
var output_schema54969_55783 = deercreeklabs.baracus.ByteArray;
var input_schema54970_55784 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54971_55785 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54970_55784);
}),null));
var output_checker54972_55786 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54969_55783);
}),null));
var ret__39944__auto___55787 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__54973){
var validate__37818__auto__ = cljs.core.deref(ufv___55782);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55788 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54973], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54974_55790 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54975_55791 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54976_55792 = input_schema54970_55784;
var G__54977_55793 = cljs.core.deref(input_checker54971_55785);
var G__54978_55794 = args__37819__auto___55788;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54974_55790,G__54975_55791,G__54976_55792,G__54977_55793,G__54978_55794) : schema.core.fn_validator.call(null,G__54974_55790,G__54975_55791,G__54976_55792,G__54977_55793,G__54978_55794));
} else {
var temp__5804__auto___55795 = (function (){var fexpr__54979 = cljs.core.deref(input_checker54971_55785);
return (fexpr__54979.cljs$core$IFn$_invoke$arity$1 ? fexpr__54979.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55788) : fexpr__54979.call(null,args__37819__auto___55788));
})();
if(cljs.core.truth_(temp__5804__auto___55795)){
var error__37820__auto___55796 = temp__5804__auto___55795;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55796], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54970_55784,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55788,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55796], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__54973;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54980_55797 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54981_55798 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__54982_55799 = output_schema54969_55783;
var G__54983_55800 = cljs.core.deref(output_checker54972_55786);
var G__54984_55801 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54980_55797,G__54981_55798,G__54982_55799,G__54983_55800,G__54984_55801) : schema.core.fn_validator.call(null,G__54980_55797,G__54981_55798,G__54982_55799,G__54983_55800,G__54984_55801));
} else {
var temp__5804__auto___55803 = (function (){var fexpr__54985 = cljs.core.deref(output_checker54972_55786);
return (fexpr__54985.cljs$core$IFn$_invoke$arity$1 ? fexpr__54985.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__54985.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55803)){
var error__37820__auto___55804 = temp__5804__auto___55803;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55804], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54969_55783,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55804], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema54969_55783,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54970_55784], null)));

var ufv___55805 = schema.utils.use_fn_validation;
var output_schema54986_55806 = schema.core.Bool;
var input_schema54987_55807 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker54988_55808 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54987_55807);
}),null));
var output_checker54989_55809 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54986_55806);
}),null));
var ret__39944__auto___55810 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__54990){
var validate__37818__auto__ = cljs.core.deref(ufv___55805);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55811 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54990], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54991_55812 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54992_55813 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__54993_55814 = input_schema54987_55807;
var G__54994_55815 = cljs.core.deref(input_checker54988_55808);
var G__54995_55816 = args__37819__auto___55811;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54991_55812,G__54992_55813,G__54993_55814,G__54994_55815,G__54995_55816) : schema.core.fn_validator.call(null,G__54991_55812,G__54992_55813,G__54993_55814,G__54994_55815,G__54995_55816));
} else {
var temp__5804__auto___55817 = (function (){var fexpr__54996 = cljs.core.deref(input_checker54988_55808);
return (fexpr__54996.cljs$core$IFn$_invoke$arity$1 ? fexpr__54996.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55811) : fexpr__54996.call(null,args__37819__auto___55811));
})();
if(cljs.core.truth_(temp__5804__auto___55817)){
var error__37820__auto___55818 = temp__5804__auto___55817;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55818], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54987_55807,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55811,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55818], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var arg = G__54990;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55000_55819 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55001_55820 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__55002_55821 = output_schema54986_55806;
var G__55003_55822 = cljs.core.deref(output_checker54989_55809);
var G__55004_55823 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55000_55819,G__55001_55820,G__55002_55821,G__55003_55822,G__55004_55823) : schema.core.fn_validator.call(null,G__55000_55819,G__55001_55820,G__55002_55821,G__55003_55822,G__55004_55823));
} else {
var temp__5804__auto___55824 = (function (){var fexpr__55005 = cljs.core.deref(output_checker54989_55809);
return (fexpr__55005.cljs$core$IFn$_invoke$arity$1 ? fexpr__55005.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55005.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55824)){
var error__37820__auto___55825 = temp__5804__auto___55824;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55825], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54986_55806,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55825], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema54986_55806,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54987_55807], null)));

var ufv___55826 = schema.utils.use_fn_validation;
var output_schema55006_55827 = schema.core.Bool;
var input_schema55007_55828 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker55008_55829 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55007_55828);
}),null));
var output_checker55009_55830 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55006_55827);
}),null));
var ret__39944__auto___55831 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__55010,G__55011){
var validate__37818__auto__ = cljs.core.deref(ufv___55826);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55832 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55010,G__55011], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55012_55833 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55013_55834 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__55014_55835 = input_schema55007_55828;
var G__55015_55836 = cljs.core.deref(input_checker55008_55829);
var G__55016_55837 = args__37819__auto___55832;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55012_55833,G__55013_55834,G__55014_55835,G__55015_55836,G__55016_55837) : schema.core.fn_validator.call(null,G__55012_55833,G__55013_55834,G__55014_55835,G__55015_55836,G__55016_55837));
} else {
var temp__5804__auto___55838 = (function (){var fexpr__55017 = cljs.core.deref(input_checker55008_55829);
return (fexpr__55017.cljs$core$IFn$_invoke$arity$1 ? fexpr__55017.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55832) : fexpr__55017.call(null,args__37819__auto___55832));
})();
if(cljs.core.truth_(temp__5804__auto___55838)){
var error__37820__auto___55839 = temp__5804__auto___55838;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55839], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55007_55828,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55832,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55839], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var reader_schema = G__55010;
var writer_schema = G__55011;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55020_55840 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55021_55841 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__55022_55842 = output_schema55006_55827;
var G__55023_55843 = cljs.core.deref(output_checker55009_55830);
var G__55024_55844 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55020_55840,G__55021_55841,G__55022_55842,G__55023_55843,G__55024_55844) : schema.core.fn_validator.call(null,G__55020_55840,G__55021_55841,G__55022_55842,G__55023_55843,G__55024_55844));
} else {
var temp__5804__auto___55845 = (function (){var fexpr__55025 = cljs.core.deref(output_checker55009_55830);
return (fexpr__55025.cljs$core$IFn$_invoke$arity$1 ? fexpr__55025.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55025.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55845)){
var error__37820__auto___55846 = temp__5804__auto___55845;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55846], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55006_55827,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55846], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema55006_55827,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55007_55828], null)));

var ufv___55850 = schema.utils.use_fn_validation;
var output_schema55026_55851 = schema.core.Any;
var input_schema55027_55852 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker55028_55853 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55027_55852);
}),null));
var output_checker55029_55854 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55026_55851);
}),null));
var ret__39944__auto___55855 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__55030){
var validate__37818__auto__ = cljs.core.deref(ufv___55850);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55856 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55030], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55031_55857 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55032_55858 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__55033_55859 = input_schema55027_55852;
var G__55034_55860 = cljs.core.deref(input_checker55028_55853);
var G__55035_55861 = args__37819__auto___55856;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55031_55857,G__55032_55858,G__55033_55859,G__55034_55860,G__55035_55861) : schema.core.fn_validator.call(null,G__55031_55857,G__55032_55858,G__55033_55859,G__55034_55860,G__55035_55861));
} else {
var temp__5804__auto___55862 = (function (){var fexpr__55036 = cljs.core.deref(input_checker55028_55853);
return (fexpr__55036.cljs$core$IFn$_invoke$arity$1 ? fexpr__55036.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55856) : fexpr__55036.call(null,args__37819__auto___55856));
})();
if(cljs.core.truth_(temp__5804__auto___55862)){
var error__37820__auto___55863 = temp__5804__auto___55862;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55863], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55027_55852,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55856,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55863], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55030;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55037_55864 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55038_55865 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__55039_55866 = output_schema55026_55851;
var G__55040_55867 = cljs.core.deref(output_checker55029_55854);
var G__55041_55868 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55037_55864,G__55038_55865,G__55039_55866,G__55040_55867,G__55041_55868) : schema.core.fn_validator.call(null,G__55037_55864,G__55038_55865,G__55039_55866,G__55040_55867,G__55041_55868));
} else {
var temp__5804__auto___55869 = (function (){var fexpr__55042 = cljs.core.deref(output_checker55029_55854);
return (fexpr__55042.cljs$core$IFn$_invoke$arity$1 ? fexpr__55042.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55042.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55869)){
var error__37820__auto___55870 = temp__5804__auto___55869;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55870], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55026_55851,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55870], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema55026_55851,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55027_55852], null)));

var ufv___55871 = schema.utils.use_fn_validation;
var output_schema55043_55872 = schema.core.Any;
var input_schema55044_55873 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker55045_55874 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55044_55873);
}),null));
var output_checker55046_55875 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55043_55872);
}),null));
var ret__39944__auto___55876 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__55047){
var validate__37818__auto__ = cljs.core.deref(ufv___55871);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55877 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55047], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55048_55878 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55049_55879 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__55050_55880 = input_schema55044_55873;
var G__55051_55881 = cljs.core.deref(input_checker55045_55874);
var G__55052_55882 = args__37819__auto___55877;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55048_55878,G__55049_55879,G__55050_55880,G__55051_55881,G__55052_55882) : schema.core.fn_validator.call(null,G__55048_55878,G__55049_55879,G__55050_55880,G__55051_55881,G__55052_55882));
} else {
var temp__5804__auto___55883 = (function (){var fexpr__55053 = cljs.core.deref(input_checker55045_55874);
return (fexpr__55053.cljs$core$IFn$_invoke$arity$1 ? fexpr__55053.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55877) : fexpr__55053.call(null,args__37819__auto___55877));
})();
if(cljs.core.truth_(temp__5804__auto___55883)){
var error__37820__auto___55884 = temp__5804__auto___55883;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55884], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55044_55873,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55877,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55884], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55047;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55055_55885 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55056_55886 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__55057_55887 = output_schema55043_55872;
var G__55058_55888 = cljs.core.deref(output_checker55046_55875);
var G__55059_55889 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55055_55885,G__55056_55886,G__55057_55887,G__55058_55888,G__55059_55889) : schema.core.fn_validator.call(null,G__55055_55885,G__55056_55886,G__55057_55887,G__55058_55888,G__55059_55889));
} else {
var temp__5804__auto___55890 = (function (){var fexpr__55060 = cljs.core.deref(output_checker55046_55875);
return (fexpr__55060.cljs$core$IFn$_invoke$arity$1 ? fexpr__55060.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55060.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55890)){
var error__37820__auto___55891 = temp__5804__auto___55890;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55891], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55043_55872,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55891], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema55043_55872,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55044_55873], null)));

var ufv___55892 = schema.utils.use_fn_validation;
var output_schema55061_55893 = deercreeklabs.lancaster.LancasterSchema;
var input_schema55062_55894 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema55066_55895 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker55063_55896 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55062_55894);
}),null));
var output_checker55064_55897 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55061_55893);
}),null));
var input_checker55067_55898 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55066_55895);
}),null));
var output_checker55068_55899 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55061_55893);
}),null));
var ret__39944__auto___55900 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__55072 = arguments.length;
switch (G__55072) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__55065){
var validate__37818__auto__ = cljs.core.deref(ufv___55892);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55902 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55065], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55073_55903 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55074_55904 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__55075_55905 = input_schema55062_55894;
var G__55076_55906 = cljs.core.deref(input_checker55063_55896);
var G__55077_55907 = args__37819__auto___55902;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55073_55903,G__55074_55904,G__55075_55905,G__55076_55906,G__55077_55907) : schema.core.fn_validator.call(null,G__55073_55903,G__55074_55904,G__55075_55905,G__55076_55906,G__55077_55907));
} else {
var temp__5804__auto___55908 = (function (){var fexpr__55078 = cljs.core.deref(input_checker55063_55896);
return (fexpr__55078.cljs$core$IFn$_invoke$arity$1 ? fexpr__55078.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55902) : fexpr__55078.call(null,args__37819__auto___55902));
})();
if(cljs.core.truth_(temp__5804__auto___55908)){
var error__37820__auto___55909 = temp__5804__auto___55908;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55909], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55062_55894,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55902,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55909], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55065;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55079_55910 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55080_55911 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__55081_55912 = output_schema55061_55893;
var G__55082_55913 = cljs.core.deref(output_checker55064_55897);
var G__55083_55914 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55079_55910,G__55080_55911,G__55081_55912,G__55082_55913,G__55083_55914) : schema.core.fn_validator.call(null,G__55079_55910,G__55080_55911,G__55081_55912,G__55082_55913,G__55083_55914));
} else {
var temp__5804__auto___55915 = (function (){var fexpr__55084 = cljs.core.deref(output_checker55064_55897);
return (fexpr__55084.cljs$core$IFn$_invoke$arity$1 ? fexpr__55084.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55084.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55915)){
var error__37820__auto___55916 = temp__5804__auto___55915;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55916], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55061_55893,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55916], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__55069,G__55070){
var validate__37818__auto__ = cljs.core.deref(ufv___55892);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55919 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55069,G__55070], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55085_55921 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55086_55922 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__55087_55923 = input_schema55066_55895;
var G__55088_55924 = cljs.core.deref(input_checker55067_55898);
var G__55089_55925 = args__37819__auto___55919;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55085_55921,G__55086_55922,G__55087_55923,G__55088_55924,G__55089_55925) : schema.core.fn_validator.call(null,G__55085_55921,G__55086_55922,G__55087_55923,G__55088_55924,G__55089_55925));
} else {
var temp__5804__auto___55926 = (function (){var fexpr__55090 = cljs.core.deref(input_checker55067_55898);
return (fexpr__55090.cljs$core$IFn$_invoke$arity$1 ? fexpr__55090.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55919) : fexpr__55090.call(null,args__37819__auto___55919));
})();
if(cljs.core.truth_(temp__5804__auto___55926)){
var error__37820__auto___55930 = temp__5804__auto___55926;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55930], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55066_55895,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55919,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55930], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55069;
var field_kw_or_branch_i = G__55070;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55091_55931 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55092_55932 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__55093_55933 = output_schema55061_55893;
var G__55094_55934 = cljs.core.deref(output_checker55068_55899);
var G__55095_55935 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55091_55931,G__55092_55932,G__55093_55933,G__55094_55934,G__55095_55935) : schema.core.fn_validator.call(null,G__55091_55931,G__55092_55932,G__55093_55933,G__55094_55934,G__55095_55935));
} else {
var temp__5804__auto___55936 = (function (){var fexpr__55098 = cljs.core.deref(output_checker55068_55899);
return (fexpr__55098.cljs$core$IFn$_invoke$arity$1 ? fexpr__55098.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55098.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55936)){
var error__37820__auto___55937 = temp__5804__auto___55936;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55937], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55061_55893,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55937], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema55061_55893,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55062_55894,input_schema55066_55895], null)));

var ufv___55939 = schema.utils.use_fn_validation;
var output_schema55103_55940 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema55104_55941 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema55109_55942 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker55105_55943 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55104_55941);
}),null));
var output_checker55106_55944 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55103_55940);
}),null));
var input_checker55110_55945 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55109_55942);
}),null));
var output_checker55111_55946 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55103_55940);
}),null));
var ret__39944__auto___55948 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__55120 = arguments.length;
switch (G__55120) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__55107,G__55108){
var validate__37818__auto__ = cljs.core.deref(ufv___55939);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55951 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55107,G__55108], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55124_55952 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55125_55953 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__55126_55954 = input_schema55104_55941;
var G__55127_55955 = cljs.core.deref(input_checker55105_55943);
var G__55128_55956 = args__37819__auto___55951;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55124_55952,G__55125_55953,G__55126_55954,G__55127_55955,G__55128_55956) : schema.core.fn_validator.call(null,G__55124_55952,G__55125_55953,G__55126_55954,G__55127_55955,G__55128_55956));
} else {
var temp__5804__auto___55958 = (function (){var fexpr__55131 = cljs.core.deref(input_checker55105_55943);
return (fexpr__55131.cljs$core$IFn$_invoke$arity$1 ? fexpr__55131.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55951) : fexpr__55131.call(null,args__37819__auto___55951));
})();
if(cljs.core.truth_(temp__5804__auto___55958)){
var error__37820__auto___55959 = temp__5804__auto___55958;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55959], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55104_55941,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55951,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55959], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55107;
var path = G__55108;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55132_55960 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55133_55961 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__55134_55962 = output_schema55103_55940;
var G__55135_55963 = cljs.core.deref(output_checker55106_55944);
var G__55136_55964 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55132_55960,G__55133_55961,G__55134_55962,G__55135_55963,G__55136_55964) : schema.core.fn_validator.call(null,G__55132_55960,G__55133_55961,G__55134_55962,G__55135_55963,G__55136_55964));
} else {
var temp__5804__auto___55965 = (function (){var fexpr__55137 = cljs.core.deref(output_checker55106_55944);
return (fexpr__55137.cljs$core$IFn$_invoke$arity$1 ? fexpr__55137.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55137.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55965)){
var error__37820__auto___55966 = temp__5804__auto___55965;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55966], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55103_55940,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55966], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__55112,G__55113,G__55114){
var validate__37818__auto__ = cljs.core.deref(ufv___55939);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55967 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55112,G__55113,G__55114], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55138_55968 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55139_55969 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__55140_55970 = input_schema55109_55942;
var G__55141_55971 = cljs.core.deref(input_checker55110_55945);
var G__55142_55972 = args__37819__auto___55967;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55138_55968,G__55139_55969,G__55140_55970,G__55141_55971,G__55142_55972) : schema.core.fn_validator.call(null,G__55138_55968,G__55139_55969,G__55140_55970,G__55141_55971,G__55142_55972));
} else {
var temp__5804__auto___55973 = (function (){var fexpr__55143 = cljs.core.deref(input_checker55110_55945);
return (fexpr__55143.cljs$core$IFn$_invoke$arity$1 ? fexpr__55143.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55967) : fexpr__55143.call(null,args__37819__auto___55967));
})();
if(cljs.core.truth_(temp__5804__auto___55973)){
var error__37820__auto___55974 = temp__5804__auto___55973;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55974], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55109_55942,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55967,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55974], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55112;
var path = G__55113;
var G__55145 = G__55114;
var map__55146 = G__55145;
var map__55146__$1 = cljs.core.__destructure_map(map__55146);
var opts = map__55146__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55146__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__55145__$1 = G__55145;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__55147 = G__55145__$1;
var map__55147__$1 = cljs.core.__destructure_map(map__55147);
var opts__$1 = map__55147__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55147__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55149_55977 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55150_55978 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__55151_55979 = output_schema55103_55940;
var G__55152_55980 = cljs.core.deref(output_checker55111_55946);
var G__55153_55981 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55149_55977,G__55150_55978,G__55151_55979,G__55152_55980,G__55153_55981) : schema.core.fn_validator.call(null,G__55149_55977,G__55150_55978,G__55151_55979,G__55152_55980,G__55153_55981));
} else {
var temp__5804__auto___55982 = (function (){var fexpr__55154 = cljs.core.deref(output_checker55111_55946);
return (fexpr__55154.cljs$core$IFn$_invoke$arity$1 ? fexpr__55154.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55154.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55982)){
var error__37820__auto___55983 = temp__5804__auto___55982;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___55983], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55103_55940,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___55983], null));
} else {
}
}
} else {
}

return o__37821__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema55103_55940,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55104_55941,input_schema55109_55942], null)));

var ufv___55986 = schema.utils.use_fn_validation;
var output_schema55158_55987 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema55159_55988 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker55160_55989 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55159_55988);
}),null));
var output_checker55161_55990 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55158_55987);
}),null));
var ret__39944__auto___55991 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__55162){
var validate__37818__auto__ = cljs.core.deref(ufv___55986);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___55993 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55162], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55166_55994 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55167_55995 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__55168_55996 = input_schema55159_55988;
var G__55169_55997 = cljs.core.deref(input_checker55160_55989);
var G__55170_55998 = args__37819__auto___55993;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55166_55994,G__55167_55995,G__55168_55996,G__55169_55997,G__55170_55998) : schema.core.fn_validator.call(null,G__55166_55994,G__55167_55995,G__55168_55996,G__55169_55997,G__55170_55998));
} else {
var temp__5804__auto___55999 = (function (){var fexpr__55171 = cljs.core.deref(input_checker55160_55989);
return (fexpr__55171.cljs$core$IFn$_invoke$arity$1 ? fexpr__55171.cljs$core$IFn$_invoke$arity$1(args__37819__auto___55993) : fexpr__55171.call(null,args__37819__auto___55993));
})();
if(cljs.core.truth_(temp__5804__auto___55999)){
var error__37820__auto___56001 = temp__5804__auto___55999;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___56001], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55159_55988,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___55993,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___56001], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var union_schema = G__55162;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55173_56006 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55174_56007 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__55175_56008 = output_schema55158_55987;
var G__55176_56009 = cljs.core.deref(output_checker55161_55990);
var G__55177_56010 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55173_56006,G__55174_56007,G__55175_56008,G__55176_56009,G__55177_56010) : schema.core.fn_validator.call(null,G__55173_56006,G__55174_56007,G__55175_56008,G__55176_56009,G__55177_56010));
} else {
var temp__5804__auto___56013 = (function (){var fexpr__55178 = cljs.core.deref(output_checker55161_55990);
return (fexpr__55178.cljs$core$IFn$_invoke$arity$1 ? fexpr__55178.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55178.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___56013)){
var error__37820__auto___56015 = temp__5804__auto___56013;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___56015], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55158_55987,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___56015], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema55158_55987,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55159_55988], null)));

var ufv___56016 = schema.utils.use_fn_validation;
var output_schema55183_56017 = deercreeklabs.lancaster.LancasterSchema;
var input_schema55184_56018 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker55185_56019 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55184_56018);
}),null));
var output_checker55186_56020 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55183_56017);
}),null));
var ret__39944__auto___56021 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__55187,G__55188){
var validate__37818__auto__ = cljs.core.deref(ufv___56016);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___56023 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55187,G__55188], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55192_56025 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55193_56026 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__55194_56027 = input_schema55184_56018;
var G__55195_56028 = cljs.core.deref(input_checker55185_56019);
var G__55196_56029 = args__37819__auto___56023;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55192_56025,G__55193_56026,G__55194_56027,G__55195_56028,G__55196_56029) : schema.core.fn_validator.call(null,G__55192_56025,G__55193_56026,G__55194_56027,G__55195_56028,G__55196_56029));
} else {
var temp__5804__auto___56030 = (function (){var fexpr__55199 = cljs.core.deref(input_checker55185_56019);
return (fexpr__55199.cljs$core$IFn$_invoke$arity$1 ? fexpr__55199.cljs$core$IFn$_invoke$arity$1(args__37819__auto___56023) : fexpr__55199.call(null,args__37819__auto___56023));
})();
if(cljs.core.truth_(temp__5804__auto___56030)){
var error__37820__auto___56031 = temp__5804__auto___56030;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___56031], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55184_56018,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___56023,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___56031], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var union_schema = G__55187;
var branch_index = G__55188;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55201_56032 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55202_56033 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null));
var G__55204_56034 = output_schema55183_56017;
var G__55205_56035 = cljs.core.deref(output_checker55186_56020);
var G__55206_56036 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55201_56032,G__55202_56033,G__55204_56034,G__55205_56035,G__55206_56036) : schema.core.fn_validator.call(null,G__55201_56032,G__55202_56033,G__55204_56034,G__55205_56035,G__55206_56036));
} else {
var temp__5804__auto___56037 = (function (){var fexpr__55208 = cljs.core.deref(output_checker55186_56020);
return (fexpr__55208.cljs$core$IFn$_invoke$arity$1 ? fexpr__55208.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55208.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___56037)){
var error__37820__auto___56038 = temp__5804__auto___56037;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___56038], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55183_56017,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___56038], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema55183_56017,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55184_56018], null)));

var ufv___56039 = schema.utils.use_fn_validation;
var output_schema55209_56040 = schema.core.Keyword;
var input_schema55210_56041 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker55211_56042 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema55210_56041);
}),null));
var output_checker55212_56043 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema55209_56040);
}),null));
var ret__39944__auto___56044 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__55213){
var validate__37818__auto__ = cljs.core.deref(ufv___56039);
if(cljs.core.truth_(validate__37818__auto__)){
var args__37819__auto___56045 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__55213], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55214_56046 = new cljs.core.Keyword(null,"input","input",556931961);
var G__55215_56047 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__55216_56048 = input_schema55210_56041;
var G__55217_56049 = cljs.core.deref(input_checker55211_56042);
var G__55218_56050 = args__37819__auto___56045;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55214_56046,G__55215_56047,G__55216_56048,G__55217_56049,G__55218_56050) : schema.core.fn_validator.call(null,G__55214_56046,G__55215_56047,G__55216_56048,G__55217_56049,G__55218_56050));
} else {
var temp__5804__auto___56051 = (function (){var fexpr__55219 = cljs.core.deref(input_checker55211_56042);
return (fexpr__55219.cljs$core$IFn$_invoke$arity$1 ? fexpr__55219.cljs$core$IFn$_invoke$arity$1(args__37819__auto___56045) : fexpr__55219.call(null,args__37819__auto___56045));
})();
if(cljs.core.truth_(temp__5804__auto___56051)){
var error__37820__auto___56052 = temp__5804__auto___56051;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___56052], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema55210_56041,new cljs.core.Keyword(null,"value","value",305978217),args__37819__auto___56045,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___56052], null));
} else {
}
}
} else {
}

var o__37821__auto__ = (function (){var schema__$1 = G__55213;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37818__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__55221_56053 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__55222_56054 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__55223_56055 = output_schema55209_56040;
var G__55224_56056 = cljs.core.deref(output_checker55212_56043);
var G__55225_56057 = o__37821__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__55221_56053,G__55222_56054,G__55223_56055,G__55224_56056,G__55225_56057) : schema.core.fn_validator.call(null,G__55221_56053,G__55222_56054,G__55223_56055,G__55224_56056,G__55225_56057));
} else {
var temp__5804__auto___56058 = (function (){var fexpr__55228 = cljs.core.deref(output_checker55212_56043);
return (fexpr__55228.cljs$core$IFn$_invoke$arity$1 ? fexpr__55228.cljs$core$IFn$_invoke$arity$1(o__37821__auto__) : fexpr__55228.call(null,o__37821__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___56058)){
var error__37820__auto___56059 = temp__5804__auto___56058;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37820__auto___56059], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema55209_56040,new cljs.core.Keyword(null,"value","value",305978217),o__37821__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37820__auto___56059], null));
} else {
}
}
} else {
}

return o__37821__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema55209_56040,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema55210_56041], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
