goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35804 = (function (this$){
var x__5392__auto__ = (((this$ == null))?null:this$);
var m__5393__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5393__auto__.call(null,this$));
} else {
var m__5391__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5391__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35804(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35807 = (function (this$){
var x__5392__auto__ = (((this$ == null))?null:this$);
var m__5393__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5392__auto__)]);
if((!((m__5393__auto__ == null)))){
return (m__5393__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5393__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5393__auto__.call(null,this$));
} else {
var m__5391__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5391__auto__ == null)))){
return (m__5391__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5391__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5391__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35807(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34061 = coll;
var G__34062 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34061,G__34062) : shadow.dom.lazy_native_coll_seq.call(null,G__34061,G__34062));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5329__auto__,writer__5330__auto__,opt__5331__auto__){
return cljs.core._write(writer__5330__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34084 = arguments.length;
switch (G__34084) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34099 = arguments.length;
switch (G__34099) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34117 = arguments.length;
switch (G__34117) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34137 = arguments.length;
switch (G__34137) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34174 = arguments.length;
switch (G__34174) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34208 = arguments.length;
switch (G__34208) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34218){if((e34218 instanceof Object)){
var e = e34218;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34218;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34244 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34245 = null;
var count__34246 = (0);
var i__34247 = (0);
while(true){
if((i__34247 < count__34246)){
var el = chunk__34245.cljs$core$IIndexed$_nth$arity$2(null,i__34247);
var handler_35878__$1 = ((function (seq__34244,chunk__34245,count__34246,i__34247,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34244,chunk__34245,count__34246,i__34247,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35878__$1);


var G__35880 = seq__34244;
var G__35881 = chunk__34245;
var G__35882 = count__34246;
var G__35883 = (i__34247 + (1));
seq__34244 = G__35880;
chunk__34245 = G__35881;
count__34246 = G__35882;
i__34247 = G__35883;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34244);
if(temp__5804__auto__){
var seq__34244__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34244__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__34244__$1);
var G__35884 = cljs.core.chunk_rest(seq__34244__$1);
var G__35885 = c__5567__auto__;
var G__35886 = cljs.core.count(c__5567__auto__);
var G__35887 = (0);
seq__34244 = G__35884;
chunk__34245 = G__35885;
count__34246 = G__35886;
i__34247 = G__35887;
continue;
} else {
var el = cljs.core.first(seq__34244__$1);
var handler_35892__$1 = ((function (seq__34244,chunk__34245,count__34246,i__34247,el,seq__34244__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34244,chunk__34245,count__34246,i__34247,el,seq__34244__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35892__$1);


var G__35899 = cljs.core.next(seq__34244__$1);
var G__35900 = null;
var G__35901 = (0);
var G__35902 = (0);
seq__34244 = G__35899;
chunk__34245 = G__35900;
count__34246 = G__35901;
i__34247 = G__35902;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34277 = arguments.length;
switch (G__34277) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34323 = cljs.core.seq(events);
var chunk__34324 = null;
var count__34325 = (0);
var i__34326 = (0);
while(true){
if((i__34326 < count__34325)){
var vec__34339 = chunk__34324.cljs$core$IIndexed$_nth$arity$2(null,i__34326);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34339,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34339,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35925 = seq__34323;
var G__35926 = chunk__34324;
var G__35927 = count__34325;
var G__35928 = (i__34326 + (1));
seq__34323 = G__35925;
chunk__34324 = G__35926;
count__34325 = G__35927;
i__34326 = G__35928;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34323);
if(temp__5804__auto__){
var seq__34323__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34323__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__34323__$1);
var G__35931 = cljs.core.chunk_rest(seq__34323__$1);
var G__35932 = c__5567__auto__;
var G__35933 = cljs.core.count(c__5567__auto__);
var G__35934 = (0);
seq__34323 = G__35931;
chunk__34324 = G__35932;
count__34325 = G__35933;
i__34326 = G__35934;
continue;
} else {
var vec__34347 = cljs.core.first(seq__34323__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34347,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34347,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35939 = cljs.core.next(seq__34323__$1);
var G__35940 = null;
var G__35941 = (0);
var G__35942 = (0);
seq__34323 = G__35939;
chunk__34324 = G__35940;
count__34325 = G__35941;
i__34326 = G__35942;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34357 = cljs.core.seq(styles);
var chunk__34358 = null;
var count__34359 = (0);
var i__34360 = (0);
while(true){
if((i__34360 < count__34359)){
var vec__34386 = chunk__34358.cljs$core$IIndexed$_nth$arity$2(null,i__34360);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34386,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34386,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35957 = seq__34357;
var G__35958 = chunk__34358;
var G__35959 = count__34359;
var G__35960 = (i__34360 + (1));
seq__34357 = G__35957;
chunk__34358 = G__35958;
count__34359 = G__35959;
i__34360 = G__35960;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34357);
if(temp__5804__auto__){
var seq__34357__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34357__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__34357__$1);
var G__35962 = cljs.core.chunk_rest(seq__34357__$1);
var G__35963 = c__5567__auto__;
var G__35964 = cljs.core.count(c__5567__auto__);
var G__35965 = (0);
seq__34357 = G__35962;
chunk__34358 = G__35963;
count__34359 = G__35964;
i__34360 = G__35965;
continue;
} else {
var vec__34396 = cljs.core.first(seq__34357__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34396,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34396,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35967 = cljs.core.next(seq__34357__$1);
var G__35968 = null;
var G__35969 = (0);
var G__35970 = (0);
seq__34357 = G__35967;
chunk__34358 = G__35968;
count__34359 = G__35969;
i__34360 = G__35970;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34405_35973 = key;
var G__34405_35974__$1 = (((G__34405_35973 instanceof cljs.core.Keyword))?G__34405_35973.fqn:null);
switch (G__34405_35974__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35977 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35977,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35977,"aria-");
}
})())){
el.setAttribute(ks_35977,value);
} else {
(el[ks_35977] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34477){
var map__34484 = p__34477;
var map__34484__$1 = cljs.core.__destructure_map(map__34484);
var props = map__34484__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34484__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34486 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34486,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34486,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34486,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34491 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34491,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34491;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34497 = arguments.length;
switch (G__34497) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34502){
var vec__34503 = p__34502;
var seq__34504 = cljs.core.seq(vec__34503);
var first__34505 = cljs.core.first(seq__34504);
var seq__34504__$1 = cljs.core.next(seq__34504);
var nn = first__34505;
var first__34505__$1 = cljs.core.first(seq__34504__$1);
var seq__34504__$2 = cljs.core.next(seq__34504__$1);
var np = first__34505__$1;
var nc = seq__34504__$2;
var node = vec__34503;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34515 = nn;
var G__34516 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34515,G__34516) : create_fn.call(null,G__34515,G__34516));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34520 = nn;
var G__34521 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34520,G__34521) : create_fn.call(null,G__34520,G__34521));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34531 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34531,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34531,(1),null);
var seq__34534_35988 = cljs.core.seq(node_children);
var chunk__34535_35989 = null;
var count__34536_35990 = (0);
var i__34537_35991 = (0);
while(true){
if((i__34537_35991 < count__34536_35990)){
var child_struct_35995 = chunk__34535_35989.cljs$core$IIndexed$_nth$arity$2(null,i__34537_35991);
var children_35996 = shadow.dom.dom_node(child_struct_35995);
if(cljs.core.seq_QMARK_(children_35996)){
var seq__34613_35997 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35996));
var chunk__34615_35998 = null;
var count__34616_35999 = (0);
var i__34617_36000 = (0);
while(true){
if((i__34617_36000 < count__34616_35999)){
var child_36001 = chunk__34615_35998.cljs$core$IIndexed$_nth$arity$2(null,i__34617_36000);
if(cljs.core.truth_(child_36001)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36001);


var G__36002 = seq__34613_35997;
var G__36003 = chunk__34615_35998;
var G__36004 = count__34616_35999;
var G__36005 = (i__34617_36000 + (1));
seq__34613_35997 = G__36002;
chunk__34615_35998 = G__36003;
count__34616_35999 = G__36004;
i__34617_36000 = G__36005;
continue;
} else {
var G__36006 = seq__34613_35997;
var G__36007 = chunk__34615_35998;
var G__36008 = count__34616_35999;
var G__36009 = (i__34617_36000 + (1));
seq__34613_35997 = G__36006;
chunk__34615_35998 = G__36007;
count__34616_35999 = G__36008;
i__34617_36000 = G__36009;
continue;
}
} else {
var temp__5804__auto___36010 = cljs.core.seq(seq__34613_35997);
if(temp__5804__auto___36010){
var seq__34613_36011__$1 = temp__5804__auto___36010;
if(cljs.core.chunked_seq_QMARK_(seq__34613_36011__$1)){
var c__5567__auto___36012 = cljs.core.chunk_first(seq__34613_36011__$1);
var G__36013 = cljs.core.chunk_rest(seq__34613_36011__$1);
var G__36014 = c__5567__auto___36012;
var G__36015 = cljs.core.count(c__5567__auto___36012);
var G__36016 = (0);
seq__34613_35997 = G__36013;
chunk__34615_35998 = G__36014;
count__34616_35999 = G__36015;
i__34617_36000 = G__36016;
continue;
} else {
var child_36017 = cljs.core.first(seq__34613_36011__$1);
if(cljs.core.truth_(child_36017)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36017);


var G__36018 = cljs.core.next(seq__34613_36011__$1);
var G__36019 = null;
var G__36020 = (0);
var G__36021 = (0);
seq__34613_35997 = G__36018;
chunk__34615_35998 = G__36019;
count__34616_35999 = G__36020;
i__34617_36000 = G__36021;
continue;
} else {
var G__36022 = cljs.core.next(seq__34613_36011__$1);
var G__36023 = null;
var G__36024 = (0);
var G__36025 = (0);
seq__34613_35997 = G__36022;
chunk__34615_35998 = G__36023;
count__34616_35999 = G__36024;
i__34617_36000 = G__36025;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35996);
}


var G__36026 = seq__34534_35988;
var G__36027 = chunk__34535_35989;
var G__36028 = count__34536_35990;
var G__36029 = (i__34537_35991 + (1));
seq__34534_35988 = G__36026;
chunk__34535_35989 = G__36027;
count__34536_35990 = G__36028;
i__34537_35991 = G__36029;
continue;
} else {
var temp__5804__auto___36030 = cljs.core.seq(seq__34534_35988);
if(temp__5804__auto___36030){
var seq__34534_36031__$1 = temp__5804__auto___36030;
if(cljs.core.chunked_seq_QMARK_(seq__34534_36031__$1)){
var c__5567__auto___36032 = cljs.core.chunk_first(seq__34534_36031__$1);
var G__36033 = cljs.core.chunk_rest(seq__34534_36031__$1);
var G__36034 = c__5567__auto___36032;
var G__36035 = cljs.core.count(c__5567__auto___36032);
var G__36036 = (0);
seq__34534_35988 = G__36033;
chunk__34535_35989 = G__36034;
count__34536_35990 = G__36035;
i__34537_35991 = G__36036;
continue;
} else {
var child_struct_36037 = cljs.core.first(seq__34534_36031__$1);
var children_36038 = shadow.dom.dom_node(child_struct_36037);
if(cljs.core.seq_QMARK_(children_36038)){
var seq__34650_36039 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_36038));
var chunk__34652_36040 = null;
var count__34653_36041 = (0);
var i__34654_36042 = (0);
while(true){
if((i__34654_36042 < count__34653_36041)){
var child_36043 = chunk__34652_36040.cljs$core$IIndexed$_nth$arity$2(null,i__34654_36042);
if(cljs.core.truth_(child_36043)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36043);


var G__36044 = seq__34650_36039;
var G__36045 = chunk__34652_36040;
var G__36046 = count__34653_36041;
var G__36047 = (i__34654_36042 + (1));
seq__34650_36039 = G__36044;
chunk__34652_36040 = G__36045;
count__34653_36041 = G__36046;
i__34654_36042 = G__36047;
continue;
} else {
var G__36049 = seq__34650_36039;
var G__36050 = chunk__34652_36040;
var G__36051 = count__34653_36041;
var G__36052 = (i__34654_36042 + (1));
seq__34650_36039 = G__36049;
chunk__34652_36040 = G__36050;
count__34653_36041 = G__36051;
i__34654_36042 = G__36052;
continue;
}
} else {
var temp__5804__auto___36057__$1 = cljs.core.seq(seq__34650_36039);
if(temp__5804__auto___36057__$1){
var seq__34650_36058__$1 = temp__5804__auto___36057__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34650_36058__$1)){
var c__5567__auto___36059 = cljs.core.chunk_first(seq__34650_36058__$1);
var G__36061 = cljs.core.chunk_rest(seq__34650_36058__$1);
var G__36062 = c__5567__auto___36059;
var G__36063 = cljs.core.count(c__5567__auto___36059);
var G__36064 = (0);
seq__34650_36039 = G__36061;
chunk__34652_36040 = G__36062;
count__34653_36041 = G__36063;
i__34654_36042 = G__36064;
continue;
} else {
var child_36065 = cljs.core.first(seq__34650_36058__$1);
if(cljs.core.truth_(child_36065)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36065);


var G__36066 = cljs.core.next(seq__34650_36058__$1);
var G__36067 = null;
var G__36068 = (0);
var G__36069 = (0);
seq__34650_36039 = G__36066;
chunk__34652_36040 = G__36067;
count__34653_36041 = G__36068;
i__34654_36042 = G__36069;
continue;
} else {
var G__36070 = cljs.core.next(seq__34650_36058__$1);
var G__36071 = null;
var G__36072 = (0);
var G__36073 = (0);
seq__34650_36039 = G__36070;
chunk__34652_36040 = G__36071;
count__34653_36041 = G__36072;
i__34654_36042 = G__36073;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_36038);
}


var G__36075 = cljs.core.next(seq__34534_36031__$1);
var G__36076 = null;
var G__36077 = (0);
var G__36078 = (0);
seq__34534_35988 = G__36075;
chunk__34535_35989 = G__36076;
count__34536_35990 = G__36077;
i__34537_35991 = G__36078;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34695 = cljs.core.seq(node);
var chunk__34696 = null;
var count__34697 = (0);
var i__34698 = (0);
while(true){
if((i__34698 < count__34697)){
var n = chunk__34696.cljs$core$IIndexed$_nth$arity$2(null,i__34698);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__36085 = seq__34695;
var G__36086 = chunk__34696;
var G__36087 = count__34697;
var G__36088 = (i__34698 + (1));
seq__34695 = G__36085;
chunk__34696 = G__36086;
count__34697 = G__36087;
i__34698 = G__36088;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34695);
if(temp__5804__auto__){
var seq__34695__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34695__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__34695__$1);
var G__36090 = cljs.core.chunk_rest(seq__34695__$1);
var G__36091 = c__5567__auto__;
var G__36092 = cljs.core.count(c__5567__auto__);
var G__36093 = (0);
seq__34695 = G__36090;
chunk__34696 = G__36091;
count__34697 = G__36092;
i__34698 = G__36093;
continue;
} else {
var n = cljs.core.first(seq__34695__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__36094 = cljs.core.next(seq__34695__$1);
var G__36095 = null;
var G__36096 = (0);
var G__36097 = (0);
seq__34695 = G__36094;
chunk__34696 = G__36095;
count__34697 = G__36096;
i__34698 = G__36097;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34732 = arguments.length;
switch (G__34732) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34753 = arguments.length;
switch (G__34753) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34782 = arguments.length;
switch (G__34782) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5774__auto__ = [];
var len__5768__auto___36112 = arguments.length;
var i__5769__auto___36113 = (0);
while(true){
if((i__5769__auto___36113 < len__5768__auto___36112)){
args__5774__auto__.push((arguments[i__5769__auto___36113]));

var G__36114 = (i__5769__auto___36113 + (1));
i__5769__auto___36113 = G__36114;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((0) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5775__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34821_36115 = cljs.core.seq(nodes);
var chunk__34822_36116 = null;
var count__34823_36117 = (0);
var i__34824_36118 = (0);
while(true){
if((i__34824_36118 < count__34823_36117)){
var node_36121 = chunk__34822_36116.cljs$core$IIndexed$_nth$arity$2(null,i__34824_36118);
fragment.appendChild(shadow.dom._to_dom(node_36121));


var G__36122 = seq__34821_36115;
var G__36123 = chunk__34822_36116;
var G__36124 = count__34823_36117;
var G__36125 = (i__34824_36118 + (1));
seq__34821_36115 = G__36122;
chunk__34822_36116 = G__36123;
count__34823_36117 = G__36124;
i__34824_36118 = G__36125;
continue;
} else {
var temp__5804__auto___36126 = cljs.core.seq(seq__34821_36115);
if(temp__5804__auto___36126){
var seq__34821_36127__$1 = temp__5804__auto___36126;
if(cljs.core.chunked_seq_QMARK_(seq__34821_36127__$1)){
var c__5567__auto___36128 = cljs.core.chunk_first(seq__34821_36127__$1);
var G__36129 = cljs.core.chunk_rest(seq__34821_36127__$1);
var G__36130 = c__5567__auto___36128;
var G__36131 = cljs.core.count(c__5567__auto___36128);
var G__36132 = (0);
seq__34821_36115 = G__36129;
chunk__34822_36116 = G__36130;
count__34823_36117 = G__36131;
i__34824_36118 = G__36132;
continue;
} else {
var node_36133 = cljs.core.first(seq__34821_36127__$1);
fragment.appendChild(shadow.dom._to_dom(node_36133));


var G__36134 = cljs.core.next(seq__34821_36127__$1);
var G__36135 = null;
var G__36136 = (0);
var G__36137 = (0);
seq__34821_36115 = G__36134;
chunk__34822_36116 = G__36135;
count__34823_36117 = G__36136;
i__34824_36118 = G__36137;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34812){
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34812));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34866_36141 = cljs.core.seq(scripts);
var chunk__34867_36142 = null;
var count__34868_36143 = (0);
var i__34869_36144 = (0);
while(true){
if((i__34869_36144 < count__34868_36143)){
var vec__34897_36145 = chunk__34867_36142.cljs$core$IIndexed$_nth$arity$2(null,i__34869_36144);
var script_tag_36146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34897_36145,(0),null);
var script_body_36147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34897_36145,(1),null);
eval(script_body_36147);


var G__36148 = seq__34866_36141;
var G__36149 = chunk__34867_36142;
var G__36150 = count__34868_36143;
var G__36151 = (i__34869_36144 + (1));
seq__34866_36141 = G__36148;
chunk__34867_36142 = G__36149;
count__34868_36143 = G__36150;
i__34869_36144 = G__36151;
continue;
} else {
var temp__5804__auto___36152 = cljs.core.seq(seq__34866_36141);
if(temp__5804__auto___36152){
var seq__34866_36153__$1 = temp__5804__auto___36152;
if(cljs.core.chunked_seq_QMARK_(seq__34866_36153__$1)){
var c__5567__auto___36154 = cljs.core.chunk_first(seq__34866_36153__$1);
var G__36156 = cljs.core.chunk_rest(seq__34866_36153__$1);
var G__36157 = c__5567__auto___36154;
var G__36158 = cljs.core.count(c__5567__auto___36154);
var G__36159 = (0);
seq__34866_36141 = G__36156;
chunk__34867_36142 = G__36157;
count__34868_36143 = G__36158;
i__34869_36144 = G__36159;
continue;
} else {
var vec__34910_36160 = cljs.core.first(seq__34866_36153__$1);
var script_tag_36161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34910_36160,(0),null);
var script_body_36162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34910_36160,(1),null);
eval(script_body_36162);


var G__36164 = cljs.core.next(seq__34866_36153__$1);
var G__36165 = null;
var G__36166 = (0);
var G__36167 = (0);
seq__34866_36141 = G__36164;
chunk__34867_36142 = G__36165;
count__34868_36143 = G__36166;
i__34869_36144 = G__36167;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__34920){
var vec__34921 = p__34920;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34921,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34921,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__34933 = arguments.length;
switch (G__34933) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__34959 = cljs.core.seq(style_keys);
var chunk__34960 = null;
var count__34961 = (0);
var i__34962 = (0);
while(true){
if((i__34962 < count__34961)){
var it = chunk__34960.cljs$core$IIndexed$_nth$arity$2(null,i__34962);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36177 = seq__34959;
var G__36178 = chunk__34960;
var G__36179 = count__34961;
var G__36180 = (i__34962 + (1));
seq__34959 = G__36177;
chunk__34960 = G__36178;
count__34961 = G__36179;
i__34962 = G__36180;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34959);
if(temp__5804__auto__){
var seq__34959__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34959__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__34959__$1);
var G__36185 = cljs.core.chunk_rest(seq__34959__$1);
var G__36186 = c__5567__auto__;
var G__36187 = cljs.core.count(c__5567__auto__);
var G__36188 = (0);
seq__34959 = G__36185;
chunk__34960 = G__36186;
count__34961 = G__36187;
i__34962 = G__36188;
continue;
} else {
var it = cljs.core.first(seq__34959__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36191 = cljs.core.next(seq__34959__$1);
var G__36192 = null;
var G__36193 = (0);
var G__36194 = (0);
seq__34959 = G__36191;
chunk__34960 = G__36192;
count__34961 = G__36193;
i__34962 = G__36194;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k34986,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__35000 = k34986;
var G__35000__$1 = (((G__35000 instanceof cljs.core.Keyword))?G__35000.fqn:null);
switch (G__35000__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34986,else__5345__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__35010){
var vec__35011 = p__35010;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35011,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35011,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34985){
var self__ = this;
var G__34985__$1 = this;
return (new cljs.core.RecordIter((0),G__34985__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5339__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
})(this__5338__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34987,other34988){
var self__ = this;
var this34987__$1 = this;
return (((!((other34988 == null)))) && ((((this34987__$1.constructor === other34988.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34987__$1.x,other34988.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34987__$1.y,other34988.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34987__$1.__extmap,other34988.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k34986){
var self__ = this;
var this__5349__auto____$1 = this;
var G__35038 = k34986;
var G__35038__$1 = (((G__35038 instanceof cljs.core.Keyword))?G__35038.fqn:null);
switch (G__35038__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34986);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__34985){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__35040 = cljs.core.keyword_identical_QMARK_;
var expr__35042 = k__5351__auto__;
if(cljs.core.truth_((pred__35040.cljs$core$IFn$_invoke$arity$2 ? pred__35040.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35042) : pred__35040.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35042)))){
return (new shadow.dom.Coordinate(G__34985,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35040.cljs$core$IFn$_invoke$arity$2 ? pred__35040.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35042) : pred__35040.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35042)))){
return (new shadow.dom.Coordinate(self__.x,G__34985,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__34985),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__34985){
var self__ = this;
var this__5341__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__34985,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5348__auto__,(0)),cljs.core._nth(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__34990){
var extmap__5384__auto__ = (function (){var G__35065 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34990,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__34990)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35065);
} else {
return G__35065;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__34990),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__34990),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5342__auto__,k__5343__auto__){
var self__ = this;
var this__5342__auto____$1 = this;
return this__5342__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5343__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5344__auto__,k35082,else__5345__auto__){
var self__ = this;
var this__5344__auto____$1 = this;
var G__35099 = k35082;
var G__35099__$1 = (((G__35099 instanceof cljs.core.Keyword))?G__35099.fqn:null);
switch (G__35099__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35082,else__5345__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5362__auto__,f__5363__auto__,init__5364__auto__){
var self__ = this;
var this__5362__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5365__auto__,p__35103){
var vec__35104 = p__35103;
var k__5366__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35104,(0),null);
var v__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35104,(1),null);
return (f__5363__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5363__auto__.cljs$core$IFn$_invoke$arity$3(ret__5365__auto__,k__5366__auto__,v__5367__auto__) : f__5363__auto__.call(null,ret__5365__auto__,k__5366__auto__,v__5367__auto__));
}),init__5364__auto__,this__5362__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5357__auto__,writer__5358__auto__,opts__5359__auto__){
var self__ = this;
var this__5357__auto____$1 = this;
var pr_pair__5360__auto__ = (function (keyval__5361__auto__){
return cljs.core.pr_sequential_writer(writer__5358__auto__,cljs.core.pr_writer,""," ","",opts__5359__auto__,keyval__5361__auto__);
});
return cljs.core.pr_sequential_writer(writer__5358__auto__,pr_pair__5360__auto__,"#shadow.dom.Size{",", ","}",opts__5359__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35081){
var self__ = this;
var G__35081__$1 = this;
return (new cljs.core.RecordIter((0),G__35081__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5340__auto__){
var self__ = this;
var this__5340__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5337__auto__){
var self__ = this;
var this__5337__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5346__auto__){
var self__ = this;
var this__5346__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5339__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5339__auto__));
})(this__5338__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35083,other35084){
var self__ = this;
var this35083__$1 = this;
return (((!((other35084 == null)))) && ((((this35083__$1.constructor === other35084.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35083__$1.w,other35084.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35083__$1.h,other35084.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35083__$1.__extmap,other35084.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5352__auto__,k__5353__auto__){
var self__ = this;
var this__5352__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5353__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5352__auto____$1),self__.__meta),k__5353__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5353__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5349__auto__,k35082){
var self__ = this;
var this__5349__auto____$1 = this;
var G__35153 = k35082;
var G__35153__$1 = (((G__35153 instanceof cljs.core.Keyword))?G__35153.fqn:null);
switch (G__35153__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35082);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5350__auto__,k__5351__auto__,G__35081){
var self__ = this;
var this__5350__auto____$1 = this;
var pred__35159 = cljs.core.keyword_identical_QMARK_;
var expr__35160 = k__5351__auto__;
if(cljs.core.truth_((pred__35159.cljs$core$IFn$_invoke$arity$2 ? pred__35159.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35160) : pred__35159.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35160)))){
return (new shadow.dom.Size(G__35081,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35159.cljs$core$IFn$_invoke$arity$2 ? pred__35159.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35160) : pred__35159.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35160)))){
return (new shadow.dom.Size(self__.w,G__35081,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5351__auto__,G__35081),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5355__auto__){
var self__ = this;
var this__5355__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5341__auto__,G__35081){
var self__ = this;
var this__5341__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35081,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5347__auto__,entry__5348__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5348__auto__)){
return this__5347__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5348__auto__,(0)),cljs.core._nth(entry__5348__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5347__auto____$1,entry__5348__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5388__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5388__auto__,writer__5389__auto__){
return cljs.core._write(writer__5389__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35090){
var extmap__5384__auto__ = (function (){var G__35188 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35090,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35090)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35188);
} else {
return G__35188;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35090),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35090),null,cljs.core.not_empty(extmap__5384__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5632__auto__ = opts;
var l__5633__auto__ = a__5632__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5633__auto__)){
var G__36265 = (i + (1));
var G__36266 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__36265;
ret = G__36266;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35250){
var vec__35254 = p__35250;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35254,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35254,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35274 = arguments.length;
switch (G__35274) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__36280 = ps;
var G__36281 = (i + (1));
el__$1 = G__36280;
i = G__36281;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35376 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35376,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35376,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35376,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35403_36285 = cljs.core.seq(props);
var chunk__35404_36286 = null;
var count__35405_36287 = (0);
var i__35406_36288 = (0);
while(true){
if((i__35406_36288 < count__35405_36287)){
var vec__35458_36289 = chunk__35404_36286.cljs$core$IIndexed$_nth$arity$2(null,i__35406_36288);
var k_36290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35458_36289,(0),null);
var v_36291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35458_36289,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_36290);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36290),v_36291);


var G__36293 = seq__35403_36285;
var G__36294 = chunk__35404_36286;
var G__36295 = count__35405_36287;
var G__36296 = (i__35406_36288 + (1));
seq__35403_36285 = G__36293;
chunk__35404_36286 = G__36294;
count__35405_36287 = G__36295;
i__35406_36288 = G__36296;
continue;
} else {
var temp__5804__auto___36297 = cljs.core.seq(seq__35403_36285);
if(temp__5804__auto___36297){
var seq__35403_36298__$1 = temp__5804__auto___36297;
if(cljs.core.chunked_seq_QMARK_(seq__35403_36298__$1)){
var c__5567__auto___36299 = cljs.core.chunk_first(seq__35403_36298__$1);
var G__36300 = cljs.core.chunk_rest(seq__35403_36298__$1);
var G__36301 = c__5567__auto___36299;
var G__36302 = cljs.core.count(c__5567__auto___36299);
var G__36303 = (0);
seq__35403_36285 = G__36300;
chunk__35404_36286 = G__36301;
count__35405_36287 = G__36302;
i__35406_36288 = G__36303;
continue;
} else {
var vec__35474_36304 = cljs.core.first(seq__35403_36298__$1);
var k_36305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35474_36304,(0),null);
var v_36306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35474_36304,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_36305);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36305),v_36306);


var G__36307 = cljs.core.next(seq__35403_36298__$1);
var G__36308 = null;
var G__36309 = (0);
var G__36310 = (0);
seq__35403_36285 = G__36307;
chunk__35404_36286 = G__36308;
count__35405_36287 = G__36309;
i__35406_36288 = G__36310;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35499 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35499,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35499,(1),null);
var seq__35503_36314 = cljs.core.seq(node_children);
var chunk__35505_36315 = null;
var count__35506_36316 = (0);
var i__35507_36317 = (0);
while(true){
if((i__35507_36317 < count__35506_36316)){
var child_struct_36318 = chunk__35505_36315.cljs$core$IIndexed$_nth$arity$2(null,i__35507_36317);
if((!((child_struct_36318 == null)))){
if(typeof child_struct_36318 === 'string'){
var text_36319 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36319),child_struct_36318].join(''));
} else {
var children_36320 = shadow.dom.svg_node(child_struct_36318);
if(cljs.core.seq_QMARK_(children_36320)){
var seq__35588_36321 = cljs.core.seq(children_36320);
var chunk__35590_36322 = null;
var count__35591_36323 = (0);
var i__35592_36324 = (0);
while(true){
if((i__35592_36324 < count__35591_36323)){
var child_36325 = chunk__35590_36322.cljs$core$IIndexed$_nth$arity$2(null,i__35592_36324);
if(cljs.core.truth_(child_36325)){
node.appendChild(child_36325);


var G__36326 = seq__35588_36321;
var G__36327 = chunk__35590_36322;
var G__36328 = count__35591_36323;
var G__36329 = (i__35592_36324 + (1));
seq__35588_36321 = G__36326;
chunk__35590_36322 = G__36327;
count__35591_36323 = G__36328;
i__35592_36324 = G__36329;
continue;
} else {
var G__36330 = seq__35588_36321;
var G__36331 = chunk__35590_36322;
var G__36332 = count__35591_36323;
var G__36333 = (i__35592_36324 + (1));
seq__35588_36321 = G__36330;
chunk__35590_36322 = G__36331;
count__35591_36323 = G__36332;
i__35592_36324 = G__36333;
continue;
}
} else {
var temp__5804__auto___36334 = cljs.core.seq(seq__35588_36321);
if(temp__5804__auto___36334){
var seq__35588_36335__$1 = temp__5804__auto___36334;
if(cljs.core.chunked_seq_QMARK_(seq__35588_36335__$1)){
var c__5567__auto___36336 = cljs.core.chunk_first(seq__35588_36335__$1);
var G__36337 = cljs.core.chunk_rest(seq__35588_36335__$1);
var G__36338 = c__5567__auto___36336;
var G__36339 = cljs.core.count(c__5567__auto___36336);
var G__36340 = (0);
seq__35588_36321 = G__36337;
chunk__35590_36322 = G__36338;
count__35591_36323 = G__36339;
i__35592_36324 = G__36340;
continue;
} else {
var child_36341 = cljs.core.first(seq__35588_36335__$1);
if(cljs.core.truth_(child_36341)){
node.appendChild(child_36341);


var G__36342 = cljs.core.next(seq__35588_36335__$1);
var G__36343 = null;
var G__36344 = (0);
var G__36345 = (0);
seq__35588_36321 = G__36342;
chunk__35590_36322 = G__36343;
count__35591_36323 = G__36344;
i__35592_36324 = G__36345;
continue;
} else {
var G__36346 = cljs.core.next(seq__35588_36335__$1);
var G__36347 = null;
var G__36348 = (0);
var G__36349 = (0);
seq__35588_36321 = G__36346;
chunk__35590_36322 = G__36347;
count__35591_36323 = G__36348;
i__35592_36324 = G__36349;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36320);
}
}


var G__36352 = seq__35503_36314;
var G__36353 = chunk__35505_36315;
var G__36354 = count__35506_36316;
var G__36355 = (i__35507_36317 + (1));
seq__35503_36314 = G__36352;
chunk__35505_36315 = G__36353;
count__35506_36316 = G__36354;
i__35507_36317 = G__36355;
continue;
} else {
var G__36356 = seq__35503_36314;
var G__36357 = chunk__35505_36315;
var G__36358 = count__35506_36316;
var G__36359 = (i__35507_36317 + (1));
seq__35503_36314 = G__36356;
chunk__35505_36315 = G__36357;
count__35506_36316 = G__36358;
i__35507_36317 = G__36359;
continue;
}
} else {
var temp__5804__auto___36360 = cljs.core.seq(seq__35503_36314);
if(temp__5804__auto___36360){
var seq__35503_36361__$1 = temp__5804__auto___36360;
if(cljs.core.chunked_seq_QMARK_(seq__35503_36361__$1)){
var c__5567__auto___36362 = cljs.core.chunk_first(seq__35503_36361__$1);
var G__36363 = cljs.core.chunk_rest(seq__35503_36361__$1);
var G__36364 = c__5567__auto___36362;
var G__36365 = cljs.core.count(c__5567__auto___36362);
var G__36366 = (0);
seq__35503_36314 = G__36363;
chunk__35505_36315 = G__36364;
count__35506_36316 = G__36365;
i__35507_36317 = G__36366;
continue;
} else {
var child_struct_36367 = cljs.core.first(seq__35503_36361__$1);
if((!((child_struct_36367 == null)))){
if(typeof child_struct_36367 === 'string'){
var text_36368 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36368),child_struct_36367].join(''));
} else {
var children_36369 = shadow.dom.svg_node(child_struct_36367);
if(cljs.core.seq_QMARK_(children_36369)){
var seq__35624_36370 = cljs.core.seq(children_36369);
var chunk__35626_36371 = null;
var count__35627_36372 = (0);
var i__35628_36373 = (0);
while(true){
if((i__35628_36373 < count__35627_36372)){
var child_36374 = chunk__35626_36371.cljs$core$IIndexed$_nth$arity$2(null,i__35628_36373);
if(cljs.core.truth_(child_36374)){
node.appendChild(child_36374);


var G__36376 = seq__35624_36370;
var G__36377 = chunk__35626_36371;
var G__36378 = count__35627_36372;
var G__36379 = (i__35628_36373 + (1));
seq__35624_36370 = G__36376;
chunk__35626_36371 = G__36377;
count__35627_36372 = G__36378;
i__35628_36373 = G__36379;
continue;
} else {
var G__36380 = seq__35624_36370;
var G__36381 = chunk__35626_36371;
var G__36382 = count__35627_36372;
var G__36383 = (i__35628_36373 + (1));
seq__35624_36370 = G__36380;
chunk__35626_36371 = G__36381;
count__35627_36372 = G__36382;
i__35628_36373 = G__36383;
continue;
}
} else {
var temp__5804__auto___36384__$1 = cljs.core.seq(seq__35624_36370);
if(temp__5804__auto___36384__$1){
var seq__35624_36385__$1 = temp__5804__auto___36384__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35624_36385__$1)){
var c__5567__auto___36386 = cljs.core.chunk_first(seq__35624_36385__$1);
var G__36387 = cljs.core.chunk_rest(seq__35624_36385__$1);
var G__36388 = c__5567__auto___36386;
var G__36389 = cljs.core.count(c__5567__auto___36386);
var G__36390 = (0);
seq__35624_36370 = G__36387;
chunk__35626_36371 = G__36388;
count__35627_36372 = G__36389;
i__35628_36373 = G__36390;
continue;
} else {
var child_36391 = cljs.core.first(seq__35624_36385__$1);
if(cljs.core.truth_(child_36391)){
node.appendChild(child_36391);


var G__36392 = cljs.core.next(seq__35624_36385__$1);
var G__36393 = null;
var G__36394 = (0);
var G__36395 = (0);
seq__35624_36370 = G__36392;
chunk__35626_36371 = G__36393;
count__35627_36372 = G__36394;
i__35628_36373 = G__36395;
continue;
} else {
var G__36396 = cljs.core.next(seq__35624_36385__$1);
var G__36397 = null;
var G__36398 = (0);
var G__36399 = (0);
seq__35624_36370 = G__36396;
chunk__35626_36371 = G__36397;
count__35627_36372 = G__36398;
i__35628_36373 = G__36399;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36369);
}
}


var G__36400 = cljs.core.next(seq__35503_36361__$1);
var G__36401 = null;
var G__36402 = (0);
var G__36403 = (0);
seq__35503_36314 = G__36400;
chunk__35505_36315 = G__36401;
count__35506_36316 = G__36402;
i__35507_36317 = G__36403;
continue;
} else {
var G__36404 = cljs.core.next(seq__35503_36361__$1);
var G__36405 = null;
var G__36406 = (0);
var G__36407 = (0);
seq__35503_36314 = G__36404;
chunk__35505_36315 = G__36405;
count__35506_36316 = G__36406;
i__35507_36317 = G__36407;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5774__auto__ = [];
var len__5768__auto___36412 = arguments.length;
var i__5769__auto___36415 = (0);
while(true){
if((i__5769__auto___36415 < len__5768__auto___36412)){
args__5774__auto__.push((arguments[i__5769__auto___36415]));

var G__36418 = (i__5769__auto___36415 + (1));
i__5769__auto___36415 = G__36418;
continue;
} else {
}
break;
}

var argseq__5775__auto__ = ((((1) < args__5774__auto__.length))?(new cljs.core.IndexedSeq(args__5774__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5775__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35687){
var G__35688 = cljs.core.first(seq35687);
var seq35687__$1 = cljs.core.next(seq35687);
var self__5753__auto__ = this;
return self__5753__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35688,seq35687__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35750 = arguments.length;
switch (G__35750) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30320__auto___36428 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30321__auto__ = (function (){var switch__29991__auto__ = (function (state_35781){
var state_val_35782 = (state_35781[(1)]);
if((state_val_35782 === (1))){
var state_35781__$1 = state_35781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35781__$1,(2),once_or_cleanup);
} else {
if((state_val_35782 === (2))){
var inst_35778 = (state_35781[(2)]);
var inst_35779 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35781__$1 = (function (){var statearr_35785 = state_35781;
(statearr_35785[(7)] = inst_35778);

return statearr_35785;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35781__$1,inst_35779);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__29992__auto__ = null;
var shadow$dom$state_machine__29992__auto____0 = (function (){
var statearr_35789 = [null,null,null,null,null,null,null,null];
(statearr_35789[(0)] = shadow$dom$state_machine__29992__auto__);

(statearr_35789[(1)] = (1));

return statearr_35789;
});
var shadow$dom$state_machine__29992__auto____1 = (function (state_35781){
while(true){
var ret_value__29993__auto__ = (function (){try{while(true){
var result__29994__auto__ = switch__29991__auto__(state_35781);
if(cljs.core.keyword_identical_QMARK_(result__29994__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29994__auto__;
}
break;
}
}catch (e35790){var ex__29995__auto__ = e35790;
var statearr_35791_36434 = state_35781;
(statearr_35791_36434[(2)] = ex__29995__auto__);


if(cljs.core.seq((state_35781[(4)]))){
var statearr_35793_36436 = state_35781;
(statearr_35793_36436[(1)] = cljs.core.first((state_35781[(4)])));

} else {
throw ex__29995__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29993__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36438 = state_35781;
state_35781 = G__36438;
continue;
} else {
return ret_value__29993__auto__;
}
break;
}
});
shadow$dom$state_machine__29992__auto__ = function(state_35781){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__29992__auto____0.call(this);
case 1:
return shadow$dom$state_machine__29992__auto____1.call(this,state_35781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__29992__auto____0;
shadow$dom$state_machine__29992__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__29992__auto____1;
return shadow$dom$state_machine__29992__auto__;
})()
})();
var state__30322__auto__ = (function (){var statearr_35796 = f__30321__auto__();
(statearr_35796[(6)] = c__30320__auto___36428);

return statearr_35796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30322__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
