goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__54495){
var vec__54496 = p__54495;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54496,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54496,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__54504 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__54504__$1 = (((G__54504 instanceof cljs.core.Keyword))?G__54504.fqn:null);
switch (G__54504__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__54506 = (function (){
var seq__54507 = cljs.core.seq(vars__$1);
var chunk__54508 = null;
var count__54509 = (0);
var i__54510 = (0);
while(true){
if((i__54510 < count__54509)){
var v = chunk__54508.cljs$core$IIndexed$_nth$arity$2(null,i__54510);
var temp__5804__auto___54671 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___54671)){
var t_54672 = temp__5804__auto___54671;
var G__54525_54673 = ((function (seq__54507,chunk__54508,count__54509,i__54510,t_54672,temp__5804__auto___54671,v,each_fixture_fn,G__54504,G__54504__$1,env,once_fixtures,each_fixtures,vec__54496,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_54672)));
});})(seq__54507,chunk__54508,count__54509,i__54510,t_54672,temp__5804__auto___54671,v,each_fixture_fn,G__54504,G__54504__$1,env,once_fixtures,each_fixtures,vec__54496,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__54525_54673) : each_fixture_fn.call(null,G__54525_54673));
} else {
}


var G__54679 = seq__54507;
var G__54680 = chunk__54508;
var G__54681 = count__54509;
var G__54682 = (i__54510 + (1));
seq__54507 = G__54679;
chunk__54508 = G__54680;
count__54509 = G__54681;
i__54510 = G__54682;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__54507);
if(temp__5804__auto__){
var seq__54507__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__54507__$1)){
var c__5567__auto__ = cljs.core.chunk_first(seq__54507__$1);
var G__54683 = cljs.core.chunk_rest(seq__54507__$1);
var G__54684 = c__5567__auto__;
var G__54685 = cljs.core.count(c__5567__auto__);
var G__54686 = (0);
seq__54507 = G__54683;
chunk__54508 = G__54684;
count__54509 = G__54685;
i__54510 = G__54686;
continue;
} else {
var v = cljs.core.first(seq__54507__$1);
var temp__5804__auto___54688__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___54688__$1)){
var t_54689 = temp__5804__auto___54688__$1;
var G__54526_54690 = ((function (seq__54507,chunk__54508,count__54509,i__54510,t_54689,temp__5804__auto___54688__$1,v,seq__54507__$1,temp__5804__auto__,each_fixture_fn,G__54504,G__54504__$1,env,once_fixtures,each_fixtures,vec__54496,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_54689)));
});})(seq__54507,chunk__54508,count__54509,i__54510,t_54689,temp__5804__auto___54688__$1,v,seq__54507__$1,temp__5804__auto__,each_fixture_fn,G__54504,G__54504__$1,env,once_fixtures,each_fixtures,vec__54496,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__54526_54690) : each_fixture_fn.call(null,G__54526_54690));
} else {
}


var G__54691 = cljs.core.next(seq__54507__$1);
var G__54692 = null;
var G__54693 = (0);
var G__54694 = (0);
seq__54507 = G__54691;
chunk__54508 = G__54692;
count__54509 = G__54693;
i__54510 = G__54694;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__54505 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__54505.cljs$core$IFn$_invoke$arity$1 ? fexpr__54505.cljs$core$IFn$_invoke$arity$1(G__54506) : fexpr__54505.call(null,G__54506));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__54504__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__54493_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__54493_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__54539 = shadow.test.env.get_test_ns_info(ns);
var map__54539__$1 = cljs.core.__destructure_map(map__54539);
var test_ns = map__54539__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54539__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__54543,vars){
var map__54549 = p__54543;
var map__54549__$1 = cljs.core.__destructure_map(map__54549);
var env = map__54549__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54549__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__54551_54700 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__54553_54701 = null;
var count__54554_54702 = (0);
var i__54555_54703 = (0);
while(true){
if((i__54555_54703 < count__54554_54702)){
var vec__54582_54704 = chunk__54553_54701.cljs$core$IIndexed$_nth$arity$2(null,i__54555_54703);
var test_ns_54705 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54582_54704,(0),null);
var ns_info_54706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54582_54704,(1),null);
var map__54586_54707 = ns_info_54706;
var map__54586_54708__$1 = cljs.core.__destructure_map(map__54586_54707);
var fixtures_54709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54586_54708__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___54715 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_54709);
if(cljs.core.truth_(temp__5804__auto___54715)){
var fix_54716 = temp__5804__auto___54715;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_54705,fix_54716], 0));
} else {
}

var temp__5804__auto___54717 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_54709);
if(cljs.core.truth_(temp__5804__auto___54717)){
var fix_54718 = temp__5804__auto___54717;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_54705,fix_54718], 0));
} else {
}


var G__54720 = seq__54551_54700;
var G__54721 = chunk__54553_54701;
var G__54722 = count__54554_54702;
var G__54723 = (i__54555_54703 + (1));
seq__54551_54700 = G__54720;
chunk__54553_54701 = G__54721;
count__54554_54702 = G__54722;
i__54555_54703 = G__54723;
continue;
} else {
var temp__5804__auto___54724 = cljs.core.seq(seq__54551_54700);
if(temp__5804__auto___54724){
var seq__54551_54725__$1 = temp__5804__auto___54724;
if(cljs.core.chunked_seq_QMARK_(seq__54551_54725__$1)){
var c__5567__auto___54726 = cljs.core.chunk_first(seq__54551_54725__$1);
var G__54727 = cljs.core.chunk_rest(seq__54551_54725__$1);
var G__54728 = c__5567__auto___54726;
var G__54729 = cljs.core.count(c__5567__auto___54726);
var G__54730 = (0);
seq__54551_54700 = G__54727;
chunk__54553_54701 = G__54728;
count__54554_54702 = G__54729;
i__54555_54703 = G__54730;
continue;
} else {
var vec__54599_54731 = cljs.core.first(seq__54551_54725__$1);
var test_ns_54732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54599_54731,(0),null);
var ns_info_54733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54599_54731,(1),null);
var map__54602_54734 = ns_info_54733;
var map__54602_54735__$1 = cljs.core.__destructure_map(map__54602_54734);
var fixtures_54736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54602_54735__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___54737__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_54736);
if(cljs.core.truth_(temp__5804__auto___54737__$1)){
var fix_54743 = temp__5804__auto___54737__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_54732,fix_54743], 0));
} else {
}

var temp__5804__auto___54744__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_54736);
if(cljs.core.truth_(temp__5804__auto___54744__$1)){
var fix_54745 = temp__5804__auto___54744__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_54732,fix_54745], 0));
} else {
}


var G__54746 = cljs.core.next(seq__54551_54725__$1);
var G__54747 = null;
var G__54748 = (0);
var G__54749 = (0);
seq__54551_54700 = G__54746;
chunk__54553_54701 = G__54747;
count__54554_54702 = G__54748;
i__54555_54703 = G__54749;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__54542_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__54542_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__54605 = cljs.test.get_current_env();
var map__54605__$1 = cljs.core.__destructure_map(map__54605);
var env = map__54605__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54605__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54605__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__54613 = arguments.length;
switch (G__54613) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__54626 = arguments.length;
switch (G__54626) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__54628 = shadow.test.env.get_test_ns_info(ns);
var map__54628__$1 = cljs.core.__destructure_map(map__54628);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54628__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__54637 = arguments.length;
switch (G__54637) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__54634_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__54634_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__54652 = arguments.length;
switch (G__54652) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__54649_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__54649_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
