goog.provide('deercreeklabs.lancaster');
goog.scope(function(){
  deercreeklabs.lancaster.goog$module$goog$math$Long = goog.module.get('goog.math.Long');
});
deercreeklabs.lancaster.LancasterSchema = cljs.core.with_meta(schema.core.__GT_Protocol(deercreeklabs.lancaster.utils.ILancasterSchema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("u","ILancasterSchema","u/ILancasterSchema",1472311405,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__39326__39327__auto__){
if((!((p1__39326__39327__auto__ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__39326__39327__auto__.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!p1__39326__39327__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39326__39327__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,p1__39326__39327__auto__);
}
})], null));
deercreeklabs.lancaster.LancasterSchemaOrNameKW = schema.core.if$(cljs.core.keyword_QMARK_,schema.core.Keyword,deercreeklabs.lancaster.LancasterSchema);
var ufv___54312 = schema.utils.use_fn_validation;
var output_schema53123_54313 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53124_54314 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)))], null);
var input_checker53125_54315 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53124_54314);
}),null));
var output_checker53126_54316 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53123_54313);
}),null));
var ret__40195__auto___54319 = /**
 * Inputs: [json :- s/Str]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object from an Avro schema in JSON format.
 */
deercreeklabs.lancaster.json__GT_schema = (function deercreeklabs$lancaster$json__GT_schema(G__53127){
var validate__37896__auto__ = cljs.core.deref(ufv___54312);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54321 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53127], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53137_54322 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53138_54323 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53139_54324 = input_schema53124_54314;
var G__53140_54325 = cljs.core.deref(input_checker53125_54315);
var G__53141_54326 = args__37897__auto___54321;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53137_54322,G__53138_54323,G__53139_54324,G__53140_54325,G__53141_54326) : schema.core.fn_validator.call(null,G__53137_54322,G__53138_54323,G__53139_54324,G__53140_54325,G__53141_54326));
} else {
var temp__5804__auto___54330 = (function (){var fexpr__53142 = cljs.core.deref(input_checker53125_54315);
return (fexpr__53142.cljs$core$IFn$_invoke$arity$1 ? fexpr__53142.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54321) : fexpr__53142.call(null,args__37897__auto___54321));
})();
if(cljs.core.truth_(temp__5804__auto___54330)){
var error__37898__auto___54331 = temp__5804__auto___54330;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54331], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53124_54314,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54321,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54331], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var json = G__53127;
while(true){
if(typeof json === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to json->schema must be a string. Got ",(((json == null))?"nil.":["`",cljs.core.str.cljs$core$IFn$_invoke$arity$1(json),"`."].join(''))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"json","json",1279968570),json], null));
}

return deercreeklabs.lancaster.schemas.json_schema__GT_lancaster_schema(json);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53145_54337 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53146_54338 = cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null));
var G__53147_54339 = output_schema53123_54313;
var G__53148_54340 = cljs.core.deref(output_checker53126_54316);
var G__53149_54341 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53145_54337,G__53146_54338,G__53147_54339,G__53148_54340,G__53149_54341) : schema.core.fn_validator.call(null,G__53145_54337,G__53146_54338,G__53147_54339,G__53148_54340,G__53149_54341));
} else {
var temp__5804__auto___54347 = (function (){var fexpr__53152 = cljs.core.deref(output_checker53126_54316);
return (fexpr__53152.cljs$core$IFn$_invoke$arity$1 ? fexpr__53152.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53152.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54347)){
var error__37898__auto___54351 = temp__5804__auto___54347;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json->schema","json->schema",1874543181,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object from an Avro schema in JSON format."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54351], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53123_54313,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54351], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json__GT_schema),schema.core.__GT_FnSchema(output_schema53123_54313,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53124_54314], null)));

/**
 * Lancaster schema object representing an Avro int.
 */
deercreeklabs.lancaster.int_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"int","int",-1741416922));
/**
 * Lancaster schema object representing an Avro null.
 */
deercreeklabs.lancaster.null_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"null","null",-180137709));
/**
 * Lancaster schema object representing an Avro boolean.
 */
deercreeklabs.lancaster.boolean_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"boolean","boolean",-1919418404));
/**
 * Lancaster schema object representing an Avro long.
 */
deercreeklabs.lancaster.long_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"long","long",-171452093));
/**
 * Lancaster schema object representing an Avro float.
 */
deercreeklabs.lancaster.float_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"float","float",-1732389368));
/**
 * Lancaster schema object representing an Avro double.
 */
deercreeklabs.lancaster.double_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"double","double",884886883));
/**
 * Lancaster schema object representing an Avro bytes.
 */
deercreeklabs.lancaster.bytes_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"bytes","bytes",1175866680));
/**
 * Lancaster schema object representing an Avro string.
 */
deercreeklabs.lancaster.string_schema = deercreeklabs.lancaster.schemas.primitive_schema(new cljs.core.Keyword(null,"string","string",-1989541586));
var ufv___54353 = schema.utils.use_fn_validation;
var output_schema53165_54354 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53167_54355 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema53172_54356 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53168_54357 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53167_54355);
}),null));
var output_checker53169_54358 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53165_54354);
}),null));
var input_checker53173_54359 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53172_54356);
}),null));
var output_checker53174_54360 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53165_54354);
}),null));
var ret__40195__auto___54364 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword fields :- s/Any] [name-kw :- s/Keyword docstring :- s/Str fields :- s/Any])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro record
 * with the given field definitions. For a more
 * concise way to declare a record schema, see def-record-schema.
 */
deercreeklabs.lancaster.record_schema = (function deercreeklabs$lancaster$record_schema(var_args){
var G__53185 = arguments.length;
switch (G__53185) {
case 2:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53170,G__53171){
var validate__37896__auto__ = cljs.core.deref(ufv___54353);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54369 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53170,G__53171], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53192_54370 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53193_54371 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53194_54372 = input_schema53167_54355;
var G__53195_54373 = cljs.core.deref(input_checker53168_54357);
var G__53196_54374 = args__37897__auto___54369;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53192_54370,G__53193_54371,G__53194_54372,G__53195_54373,G__53196_54374) : schema.core.fn_validator.call(null,G__53192_54370,G__53193_54371,G__53194_54372,G__53195_54373,G__53196_54374));
} else {
var temp__5804__auto___54375 = (function (){var fexpr__53199 = cljs.core.deref(input_checker53168_54357);
return (fexpr__53199.cljs$core$IFn$_invoke$arity$1 ? fexpr__53199.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54369) : fexpr__53199.call(null,args__37897__auto___54369));
})();
if(cljs.core.truth_(temp__5804__auto___54375)){
var error__37898__auto___54378 = temp__5804__auto___54375;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54378], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53167_54355,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54369,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54378], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var name_kw = G__53170;
var fields = G__53171;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,null,fields);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53200_54383 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53201_54384 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53202_54385 = output_schema53165_54354;
var G__53203_54386 = cljs.core.deref(output_checker53169_54358);
var G__53204_54387 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53200_54383,G__53201_54384,G__53202_54385,G__53203_54386,G__53204_54387) : schema.core.fn_validator.call(null,G__53200_54383,G__53201_54384,G__53202_54385,G__53203_54386,G__53204_54387));
} else {
var temp__5804__auto___54388 = (function (){var fexpr__53205 = cljs.core.deref(output_checker53169_54358);
return (fexpr__53205.cljs$core$IFn$_invoke$arity$1 ? fexpr__53205.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53205.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54388)){
var error__37898__auto___54389 = temp__5804__auto___54388;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54389], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53165_54354,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54389], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53175,G__53176,G__53177){
var validate__37896__auto__ = cljs.core.deref(ufv___54353);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54401 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53175,G__53176,G__53177], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53210_54402 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53211_54403 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53212_54404 = input_schema53172_54356;
var G__53213_54405 = cljs.core.deref(input_checker53173_54359);
var G__53214_54406 = args__37897__auto___54401;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53210_54402,G__53211_54403,G__53212_54404,G__53213_54405,G__53214_54406) : schema.core.fn_validator.call(null,G__53210_54402,G__53211_54403,G__53212_54404,G__53213_54405,G__53214_54406));
} else {
var temp__5804__auto___54409 = (function (){var fexpr__53216 = cljs.core.deref(input_checker53173_54359);
return (fexpr__53216.cljs$core$IFn$_invoke$arity$1 ? fexpr__53216.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54401) : fexpr__53216.call(null,args__37897__auto___54401));
})();
if(cljs.core.truth_(temp__5804__auto___54409)){
var error__37898__auto___54410 = temp__5804__auto___54409;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54410], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53172_54356,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54401,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54410], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var name_kw = G__53175;
var docstring = G__53176;
var fields = G__53177;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"record","record",-779106859),name_kw,docstring,fields);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53217_54411 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53218_54412 = cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null));
var G__53219_54413 = output_schema53165_54354;
var G__53220_54414 = cljs.core.deref(output_checker53174_54360);
var G__53221_54415 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53217_54411,G__53218_54412,G__53219_54413,G__53220_54414,G__53221_54415) : schema.core.fn_validator.call(null,G__53217_54411,G__53218_54412,G__53219_54413,G__53220_54414,G__53221_54415));
} else {
var temp__5804__auto___54416 = (function (){var fexpr__53222 = cljs.core.deref(output_checker53174_54360);
return (fexpr__53222.cljs$core$IFn$_invoke$arity$1 ? fexpr__53222.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53222.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54416)){
var error__37898__auto___54420 = temp__5804__auto___54416;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"record-schema","record-schema",-129457954,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro record\n   with the given field definitions. For a more\n   concise way to declare a record schema, see def-record-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54420], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53165_54354,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54420], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.record_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.record_schema),schema.core.make_fn_schema(output_schema53165_54354,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53167_54355,input_schema53172_54356], null)));

var ufv___54427 = schema.utils.use_fn_validation;
var output_schema53223_54428 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53224_54429 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_schema53231_54430 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Str,cljs.core.with_meta(new cljs.core.Symbol(null,"docstring","docstring",-1775202652,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Keyword], null),cljs.core.with_meta(new cljs.core.Symbol(null,"symbol-keywords","symbol-keywords",1189792086,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null)], null)))], null);
var input_checker53225_54431 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53224_54429);
}),null));
var output_checker53226_54432 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53223_54428);
}),null));
var input_checker53232_54433 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53231_54430);
}),null));
var output_checker53233_54434 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53223_54428);
}),null));
var ret__40195__auto___54435 = (function (){
/**
 * Inputs: ([name-kw :- s/Keyword symbol-keywords :- [s/Keyword]] [name-kw :- s/Keyword docstring :- s/Str symbol-keywords :- [s/Keyword]])
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro enum
 * with the given symbol keywords. For a more concise way to declare
 * an enum schema, see def-enum-schema.
 */
deercreeklabs.lancaster.enum_schema = (function deercreeklabs$lancaster$enum_schema(var_args){
var G__53250 = arguments.length;
switch (G__53250) {
case 2:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53227,G__53228){
var validate__37896__auto__ = cljs.core.deref(ufv___54427);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54439 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53227,G__53228], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53254_54440 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53255_54441 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53256_54442 = input_schema53224_54429;
var G__53257_54443 = cljs.core.deref(input_checker53225_54431);
var G__53258_54444 = args__37897__auto___54439;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53254_54440,G__53255_54441,G__53256_54442,G__53257_54443,G__53258_54444) : schema.core.fn_validator.call(null,G__53254_54440,G__53255_54441,G__53256_54442,G__53257_54443,G__53258_54444));
} else {
var temp__5804__auto___54445 = (function (){var fexpr__53259 = cljs.core.deref(input_checker53225_54431);
return (fexpr__53259.cljs$core$IFn$_invoke$arity$1 ? fexpr__53259.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54439) : fexpr__53259.call(null,args__37897__auto___54439));
})();
if(cljs.core.truth_(temp__5804__auto___54445)){
var error__37898__auto___54446 = temp__5804__auto___54445;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54446], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53224_54429,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54439,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54446], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var name_kw = G__53227;
var symbol_keywords = G__53228;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,null,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53264_54448 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53265_54449 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53266_54450 = output_schema53223_54428;
var G__53267_54451 = cljs.core.deref(output_checker53226_54432);
var G__53268_54452 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53264_54448,G__53265_54449,G__53266_54450,G__53267_54451,G__53268_54452) : schema.core.fn_validator.call(null,G__53264_54448,G__53265_54449,G__53266_54450,G__53267_54451,G__53268_54452));
} else {
var temp__5804__auto___54455 = (function (){var fexpr__53269 = cljs.core.deref(output_checker53226_54432);
return (fexpr__53269.cljs$core$IFn$_invoke$arity$1 ? fexpr__53269.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53269.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54455)){
var error__37898__auto___54456 = temp__5804__auto___54455;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54456], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53223_54428,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54456], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$core$IFn$_invoke$arity$3 = (function (G__53234,G__53235,G__53236){
var validate__37896__auto__ = cljs.core.deref(ufv___54427);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54458 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53234,G__53235,G__53236], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53270_54459 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53271_54460 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53272_54461 = input_schema53231_54430;
var G__53273_54462 = cljs.core.deref(input_checker53232_54433);
var G__53274_54463 = args__37897__auto___54458;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53270_54459,G__53271_54460,G__53272_54461,G__53273_54462,G__53274_54463) : schema.core.fn_validator.call(null,G__53270_54459,G__53271_54460,G__53272_54461,G__53273_54462,G__53274_54463));
} else {
var temp__5804__auto___54466 = (function (){var fexpr__53275 = cljs.core.deref(input_checker53232_54433);
return (fexpr__53275.cljs$core$IFn$_invoke$arity$1 ? fexpr__53275.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54458) : fexpr__53275.call(null,args__37897__auto___54458));
})();
if(cljs.core.truth_(temp__5804__auto___54466)){
var error__37898__auto___54468 = temp__5804__auto___54466;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54468], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53231_54430,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54458,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54468], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var name_kw = G__53234;
var docstring = G__53235;
var symbol_keywords = G__53236;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"enum","enum",1679018432),name_kw,docstring,symbol_keywords);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53276_54470 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53277_54471 = cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null));
var G__53278_54472 = output_schema53223_54428;
var G__53279_54473 = cljs.core.deref(output_checker53233_54434);
var G__53280_54474 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53276_54470,G__53277_54471,G__53278_54472,G__53279_54473,G__53280_54474) : schema.core.fn_validator.call(null,G__53276_54470,G__53277_54471,G__53278_54472,G__53279_54473,G__53280_54474));
} else {
var temp__5804__auto___54479 = (function (){var fexpr__53283 = cljs.core.deref(output_checker53233_54434);
return (fexpr__53283.cljs$core$IFn$_invoke$arity$1 ? fexpr__53283.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53283.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54479)){
var error__37898__auto___54480 = temp__5804__auto___54479;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"enum-schema","enum-schema",-1935870999,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro enum\n   with the given symbol keywords. For a more concise way to declare\n   an enum schema, see def-enum-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54480], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53223_54428,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54480], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.enum_schema.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.enum_schema),schema.core.make_fn_schema(output_schema53223_54428,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53224_54429,input_schema53231_54430], null)));

var ufv___54482 = schema.utils.use_fn_validation;
var output_schema53286_54483 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53287_54484 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Keyword,cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker53288_54485 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53287_54484);
}),null));
var output_checker53289_54486 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53286_54483);
}),null));
var ret__40195__auto___54488 = /**
 * Inputs: [name-kw :- s/Keyword size :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro fixed
 * with the given size. For a more concise way to declare a fixed
 * schema, see def-fixed-schema.
 */
deercreeklabs.lancaster.fixed_schema = (function deercreeklabs$lancaster$fixed_schema(G__53290,G__53291){
var validate__37896__auto__ = cljs.core.deref(ufv___54482);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54490 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53290,G__53291], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53296_54491 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53297_54492 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53298_54493 = input_schema53287_54484;
var G__53299_54494 = cljs.core.deref(input_checker53288_54485);
var G__53300_54495 = args__37897__auto___54490;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53296_54491,G__53297_54492,G__53298_54493,G__53299_54494,G__53300_54495) : schema.core.fn_validator.call(null,G__53296_54491,G__53297_54492,G__53298_54493,G__53299_54494,G__53300_54495));
} else {
var temp__5804__auto___54496 = (function (){var fexpr__53302 = cljs.core.deref(input_checker53288_54485);
return (fexpr__53302.cljs$core$IFn$_invoke$arity$1 ? fexpr__53302.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54490) : fexpr__53302.call(null,args__37897__auto___54490));
})();
if(cljs.core.truth_(temp__5804__auto___54496)){
var error__37898__auto___54497 = temp__5804__auto___54496;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54497], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53287_54484,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54490,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54497], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var name_kw = G__53290;
var size = G__53291;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"fixed","fixed",-562004358),name_kw,size);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53303_54500 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53304_54501 = cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null));
var G__53305_54502 = output_schema53286_54483;
var G__53306_54503 = cljs.core.deref(output_checker53289_54486);
var G__53307_54504 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53303_54500,G__53304_54501,G__53305_54502,G__53306_54503,G__53307_54504) : schema.core.fn_validator.call(null,G__53303_54500,G__53304_54501,G__53305_54502,G__53306_54503,G__53307_54504));
} else {
var temp__5804__auto___54506 = (function (){var fexpr__53309 = cljs.core.deref(output_checker53289_54486);
return (fexpr__53309.cljs$core$IFn$_invoke$arity$1 ? fexpr__53309.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53309.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54506)){
var error__37898__auto___54507 = temp__5804__auto___54506;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fixed-schema","fixed-schema",314722050,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro fixed\n   with the given size. For a more concise way to declare a fixed\n   schema, see def-fixed-schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54507], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53286_54483,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54507], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fixed_schema),schema.core.__GT_FnSchema(output_schema53286_54483,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53287_54484], null)));

var ufv___54509 = schema.utils.use_fn_validation;
var output_schema53313_54510 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53314_54511 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"items-schema","items-schema",1585689171,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53315_54512 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53314_54511);
}),null));
var output_checker53316_54513 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53313_54510);
}),null));
var ret__40195__auto___54514 = /**
 * Inputs: [items-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro array
 * with the given items schema.
 */
deercreeklabs.lancaster.array_schema = (function deercreeklabs$lancaster$array_schema(G__53317){
var validate__37896__auto__ = cljs.core.deref(ufv___54509);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54515 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53317], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53318_54516 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53319_54517 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53320_54518 = input_schema53314_54511;
var G__53321_54519 = cljs.core.deref(input_checker53315_54512);
var G__53322_54520 = args__37897__auto___54515;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53318_54516,G__53319_54517,G__53320_54518,G__53321_54519,G__53322_54520) : schema.core.fn_validator.call(null,G__53318_54516,G__53319_54517,G__53320_54518,G__53321_54519,G__53322_54520));
} else {
var temp__5804__auto___54521 = (function (){var fexpr__53323 = cljs.core.deref(input_checker53315_54512);
return (fexpr__53323.cljs$core$IFn$_invoke$arity$1 ? fexpr__53323.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54515) : fexpr__53323.call(null,args__37897__auto___54515));
})();
if(cljs.core.truth_(temp__5804__auto___54521)){
var error__37898__auto___54522 = temp__5804__auto___54521;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54522], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53314_54511,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54515,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54522], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var items_schema = G__53317;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"array","array",-2080713842),null,items_schema);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53324_54523 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53325_54524 = cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null));
var G__53326_54525 = output_schema53313_54510;
var G__53327_54526 = cljs.core.deref(output_checker53316_54513);
var G__53328_54527 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53324_54523,G__53325_54524,G__53326_54525,G__53327_54526,G__53328_54527) : schema.core.fn_validator.call(null,G__53324_54523,G__53325_54524,G__53326_54525,G__53327_54526,G__53328_54527));
} else {
var temp__5804__auto___54528 = (function (){var fexpr__53330 = cljs.core.deref(output_checker53316_54513);
return (fexpr__53330.cljs$core$IFn$_invoke$arity$1 ? fexpr__53330.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53330.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54528)){
var error__37898__auto___54529 = temp__5804__auto___54528;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"array-schema","array-schema",-274262209,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro array\n   with the given items schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54529], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53313_54510,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54529], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.array_schema),schema.core.__GT_FnSchema(output_schema53313_54510,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53314_54511], null)));

var ufv___54534 = schema.utils.use_fn_validation;
var output_schema53333_54535 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53336_54536 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"values-schema","values-schema",901230710,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53337_54537 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53336_54536);
}),null));
var output_checker53338_54538 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53333_54535);
}),null));
var ret__40195__auto___54539 = /**
 * Inputs: [values-schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro map
 * with the given values schema. Keys are always strings.
 */
deercreeklabs.lancaster.map_schema = (function deercreeklabs$lancaster$map_schema(G__53339){
var validate__37896__auto__ = cljs.core.deref(ufv___54534);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54540 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53339], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53340_54541 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53341_54542 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53342_54543 = input_schema53336_54536;
var G__53343_54544 = cljs.core.deref(input_checker53337_54537);
var G__53344_54545 = args__37897__auto___54540;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53340_54541,G__53341_54542,G__53342_54543,G__53343_54544,G__53344_54545) : schema.core.fn_validator.call(null,G__53340_54541,G__53341_54542,G__53342_54543,G__53343_54544,G__53344_54545));
} else {
var temp__5804__auto___54546 = (function (){var fexpr__53347 = cljs.core.deref(input_checker53337_54537);
return (fexpr__53347.cljs$core$IFn$_invoke$arity$1 ? fexpr__53347.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54540) : fexpr__53347.call(null,args__37897__auto___54540));
})();
if(cljs.core.truth_(temp__5804__auto___54546)){
var error__37898__auto___54547 = temp__5804__auto___54546;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54547], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53336_54536,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54540,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54547], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var values_schema = G__53339;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"map","map",1371690461),null,values_schema);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53348_54549 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53349_54550 = cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null));
var G__53350_54551 = output_schema53333_54535;
var G__53351_54552 = cljs.core.deref(output_checker53338_54538);
var G__53352_54553 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53348_54549,G__53349_54550,G__53350_54551,G__53351_54552,G__53352_54553) : schema.core.fn_validator.call(null,G__53348_54549,G__53349_54550,G__53350_54551,G__53351_54552,G__53352_54553));
} else {
var temp__5804__auto___54554 = (function (){var fexpr__53357 = cljs.core.deref(output_checker53338_54538);
return (fexpr__53357.cljs$core$IFn$_invoke$arity$1 ? fexpr__53357.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53357.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54554)){
var error__37898__auto___54555 = temp__5804__auto___54554;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"map-schema","map-schema",994533390,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro map\n   with the given values schema. Keys are always strings."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54555], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53333_54535,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54555], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.map_schema),schema.core.__GT_FnSchema(output_schema53333_54535,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53336_54536], null)));

var ufv___54556 = schema.utils.use_fn_validation;
var output_schema53360_54557 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53361_54558 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchemaOrNameKW], null),cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)], null)))], null);
var input_checker53362_54559 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53361_54558);
}),null));
var output_checker53363_54560 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53360_54557);
}),null));
var ret__40195__auto___54562 = /**
 * Inputs: [member-schemas :- [LancasterSchemaOrNameKW]]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster schema object representing an Avro union
 * with the given member schemas.
 */
deercreeklabs.lancaster.union_schema = (function deercreeklabs$lancaster$union_schema(G__53364){
var validate__37896__auto__ = cljs.core.deref(ufv___54556);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54563 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53364], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53369_54564 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53370_54565 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53371_54566 = input_schema53361_54558;
var G__53372_54567 = cljs.core.deref(input_checker53362_54559);
var G__53373_54568 = args__37897__auto___54563;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53369_54564,G__53370_54565,G__53371_54566,G__53372_54567,G__53373_54568) : schema.core.fn_validator.call(null,G__53369_54564,G__53370_54565,G__53371_54566,G__53372_54567,G__53373_54568));
} else {
var temp__5804__auto___54569 = (function (){var fexpr__53374 = cljs.core.deref(input_checker53362_54559);
return (fexpr__53374.cljs$core$IFn$_invoke$arity$1 ? fexpr__53374.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54563) : fexpr__53374.call(null,args__37897__auto___54563));
})();
if(cljs.core.truth_(temp__5804__auto___54569)){
var error__37898__auto___54570 = temp__5804__auto___54569;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54570], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53361_54558,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54563,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54570], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var member_schemas = G__53364;
while(true){
return deercreeklabs.lancaster.schemas.schema.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"union","union",2142937499),null,member_schemas);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53376_54572 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53377_54573 = cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null));
var G__53378_54574 = output_schema53360_54557;
var G__53379_54575 = cljs.core.deref(output_checker53363_54560);
var G__53380_54576 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53376_54572,G__53377_54573,G__53378_54574,G__53379_54575,G__53380_54576) : schema.core.fn_validator.call(null,G__53376_54572,G__53377_54573,G__53378_54574,G__53379_54575,G__53380_54576));
} else {
var temp__5804__auto___54578 = (function (){var fexpr__53384 = cljs.core.deref(output_checker53363_54560);
return (fexpr__53384.cljs$core$IFn$_invoke$arity$1 ? fexpr__53384.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53384.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54578)){
var error__37898__auto___54579 = temp__5804__auto___54578;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster schema object representing an Avro union\n   with the given member schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54579], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53360_54557,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54579], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.union_schema),schema.core.__GT_FnSchema(output_schema53360_54557,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53361_54558], null)));

/**
 * Lancaster schema object representing a Clojure set with string members.
 * Implemented using an Avro map with null values.
 */
deercreeklabs.lancaster.string_set_schema = deercreeklabs.lancaster.map_schema(deercreeklabs.lancaster.null_schema);
var ufv___54581 = schema.utils.use_fn_validation;
var output_schema53386_54582 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53387_54583 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchemaOrNameKW,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchemaOrNameKW","LancasterSchemaOrNameKW",1802833443,null)], null)))], null);
var input_checker53388_54584 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53387_54583);
}),null));
var output_checker53389_54585 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53386_54582);
}),null));
var ret__40195__auto___54588 = /**
 * Inputs: [schema :- LancasterSchemaOrNameKW]
 *   Returns: LancasterSchema
 * 
 *   Creates a Lancaster union schema whose members are l/null-schema
 * and the given schema. Makes a schema nillable. If the given schema
 * is a union, returns a schema with l/null-schema in the first postion.
 * If the given union schema already has l/null-schema as a member, it
 * is returned unchanged. Similarly, if the given schema is
 * l/null-schema, it is returned unchanged.
 */
deercreeklabs.lancaster.maybe = (function deercreeklabs$lancaster$maybe(G__53390){
var validate__37896__auto__ = cljs.core.deref(ufv___54581);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54589 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53390], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53393_54590 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53394_54591 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53395_54592 = input_schema53387_54583;
var G__53396_54593 = cljs.core.deref(input_checker53388_54584);
var G__53397_54594 = args__37897__auto___54589;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53393_54590,G__53394_54591,G__53395_54592,G__53396_54593,G__53397_54594) : schema.core.fn_validator.call(null,G__53393_54590,G__53394_54591,G__53395_54592,G__53396_54593,G__53397_54594));
} else {
var temp__5804__auto___54598 = (function (){var fexpr__53398 = cljs.core.deref(input_checker53388_54584);
return (fexpr__53398.cljs$core$IFn$_invoke$arity$1 ? fexpr__53398.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54589) : fexpr__53398.call(null,args__37897__auto___54589));
})();
if(cljs.core.truth_(temp__5804__auto___54598)){
var error__37898__auto___54599 = temp__5804__auto___54598;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54599], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53387_54583,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54589,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54599], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53390;
while(true){
return deercreeklabs.lancaster.schemas.maybe(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53400_54601 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53401_54602 = cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null));
var G__53402_54603 = output_schema53386_54582;
var G__53403_54604 = cljs.core.deref(output_checker53389_54585);
var G__53404_54605 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53400_54601,G__53401_54602,G__53402_54603,G__53403_54604,G__53404_54605) : schema.core.fn_validator.call(null,G__53400_54601,G__53401_54602,G__53402_54603,G__53403_54604,G__53404_54605));
} else {
var temp__5804__auto___54607 = (function (){var fexpr__53405 = cljs.core.deref(output_checker53389_54585);
return (fexpr__53405.cljs$core$IFn$_invoke$arity$1 ? fexpr__53405.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53405.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54607)){
var error__37898__auto___54608 = temp__5804__auto___54607;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"maybe","maybe",1326133967,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates a Lancaster union schema whose members are l/null-schema\n   and the given schema. Makes a schema nillable. If the given schema\n   is a union, returns a schema with l/null-schema in the first postion.\n   If the given union schema already has l/null-schema as a member, it\n   is returned unchanged. Similarly, if the given schema is\n   l/null-schema, it is returned unchanged."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54608], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53386_54582,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54608], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.maybe),schema.core.__GT_FnSchema(output_schema53386_54582,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53387_54583], null)));

var ufv___54612 = schema.utils.use_fn_validation;
var output_schema53415_54613 = deercreeklabs.baracus.ByteArray;
var input_schema53416_54614 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53417_54615 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53416_54614);
}),null));
var output_checker53418_54616 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53415_54613);
}),null));
var ret__40195__auto___54619 = /**
 * Inputs: [writer-schema :- LancasterSchema data :- s/Any]
 *   Returns: ba/ByteArray
 * 
 *   Serializes data to a byte array, using the given Lancaster schema.
 */
deercreeklabs.lancaster.serialize = (function deercreeklabs$lancaster$serialize(G__53419,G__53420){
var validate__37896__auto__ = cljs.core.deref(ufv___54612);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54621 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53419,G__53420], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53430_54622 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53431_54623 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53432_54624 = input_schema53416_54614;
var G__53433_54625 = cljs.core.deref(input_checker53417_54615);
var G__53434_54626 = args__37897__auto___54621;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53430_54622,G__53431_54623,G__53432_54624,G__53433_54625,G__53434_54626) : schema.core.fn_validator.call(null,G__53430_54622,G__53431_54623,G__53432_54624,G__53433_54625,G__53434_54626));
} else {
var temp__5804__auto___54629 = (function (){var fexpr__53436 = cljs.core.deref(input_checker53417_54615);
return (fexpr__53436.cljs$core$IFn$_invoke$arity$1 ? fexpr__53436.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54621) : fexpr__53436.call(null,args__37897__auto___54621));
})();
if(cljs.core.truth_(temp__5804__auto___54629)){
var error__37898__auto___54630 = temp__5804__auto___54629;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54630], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53416_54614,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54621,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54630], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var writer_schema = G__53419;
var data = G__53420;
while(true){
if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `serialize` must be a schema ","object. The object must satisfy the ILancasterSchema ","protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(writer_schema)], null));
}

return deercreeklabs.lancaster.utils.serialize(writer_schema,data);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53451_54635 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53452_54636 = cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null));
var G__53453_54637 = output_schema53415_54613;
var G__53454_54638 = cljs.core.deref(output_checker53418_54616);
var G__53455_54639 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53451_54635,G__53452_54636,G__53453_54637,G__53454_54638,G__53455_54639) : schema.core.fn_validator.call(null,G__53451_54635,G__53452_54636,G__53453_54637,G__53454_54638,G__53455_54639));
} else {
var temp__5804__auto___54640 = (function (){var fexpr__53460 = cljs.core.deref(output_checker53418_54616);
return (fexpr__53460.cljs$core$IFn$_invoke$arity$1 ? fexpr__53460.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53460.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54640)){
var error__37898__auto___54641 = temp__5804__auto___54640;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"serialize","serialize",1571314953,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Serializes data to a byte array, using the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54641], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53415_54613,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54641], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.serialize),schema.core.__GT_FnSchema(output_schema53415_54613,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53416_54614], null)));

var ufv___54645 = schema.utils.use_fn_validation;
var output_schema53471_54646 = schema.core.Any;
var input_schema53472_54647 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53473_54648 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53472_54647);
}),null));
var output_checker53474_54649 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53471_54646);
}),null));
var ret__40195__auto___54651 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given reader and
 * writer schemas.
 */
deercreeklabs.lancaster.deserialize = (function deercreeklabs$lancaster$deserialize(G__53476,G__53477,G__53478){
var validate__37896__auto__ = cljs.core.deref(ufv___54645);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54652 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53476,G__53477,G__53478], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53491_54653 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53492_54654 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53494_54655 = input_schema53472_54647;
var G__53495_54656 = cljs.core.deref(input_checker53473_54648);
var G__53496_54657 = args__37897__auto___54652;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53491_54653,G__53492_54654,G__53494_54655,G__53495_54656,G__53496_54657) : schema.core.fn_validator.call(null,G__53491_54653,G__53492_54654,G__53494_54655,G__53495_54656,G__53496_54657));
} else {
var temp__5804__auto___54660 = (function (){var fexpr__53499 = cljs.core.deref(input_checker53473_54648);
return (fexpr__53499.cljs$core$IFn$_invoke$arity$1 ? fexpr__53499.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54652) : fexpr__53499.call(null,args__37897__auto___54652));
})();
if(cljs.core.truth_(temp__5804__auto___54660)){
var error__37898__auto___54662 = temp__5804__auto___54660;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54662], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53472_54647,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54652,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54662], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var reader_schema = G__53476;
var writer_schema = G__53477;
var ba = G__53478;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to `deserialize` must be a schema ","object representing the reader's schema. The object ","must satisfy the ILancasterSchema protocol. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reader-schema","reader-schema",-121218890),deercreeklabs.lancaster.utils.pprint_str(reader_schema),new cljs.core.Keyword(null,"reader-schema-type","reader-schema-type",-647712427),cljs.core.type(reader_schema)], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to `deserialize` must be a schema ","object representing the writer's schema. The object ","must satisfy the ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"writer-schema","writer-schema",224900287),deercreeklabs.lancaster.utils.pprint_str(writer_schema),new cljs.core.Keyword(null,"writer-schema-type","writer-schema-type",2102709196),cljs.core.type(writer_schema)], null));
}

if((ba instanceof deercreeklabs.baracus.ByteArray)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Final argument to `deserialize` must be a byte ","array. The byte array must include the binary data ","to be deserialized. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ba","ba",-960950298),ba,new cljs.core.Keyword(null,"ba-type","ba-type",1986200961),cljs.core.type(ba)], null));
}

var is = deercreeklabs.lancaster.impl.input_stream(ba);
return deercreeklabs.lancaster.utils.deserialize(reader_schema,writer_schema,is);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53504_54675 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53505_54676 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null));
var G__53506_54677 = output_schema53471_54646;
var G__53507_54678 = cljs.core.deref(output_checker53474_54649);
var G__53508_54679 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53504_54675,G__53505_54676,G__53506_54677,G__53507_54678,G__53508_54679) : schema.core.fn_validator.call(null,G__53504_54675,G__53505_54676,G__53506_54677,G__53507_54678,G__53508_54679));
} else {
var temp__5804__auto___54683 = (function (){var fexpr__53512 = cljs.core.deref(output_checker53474_54649);
return (fexpr__53512.cljs$core$IFn$_invoke$arity$1 ? fexpr__53512.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53512.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54683)){
var error__37898__auto___54684 = temp__5804__auto___54683;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize","deserialize",-350525411,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given reader and\n   writer schemas."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54684], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53471_54646,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54684], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize),schema.core.__GT_FnSchema(output_schema53471_54646,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53472_54647], null)));

var ufv___54690 = schema.utils.use_fn_validation;
var output_schema53533_54691 = schema.core.Any;
var input_schema53534_54692 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null)], null)))], null);
var input_checker53535_54693 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53534_54692);
}),null));
var output_checker53536_54694 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53533_54691);
}),null));
var ret__40195__auto___54699 = /**
 * Inputs: [schema :- LancasterSchema ba :- ba/ByteArray]
 *   Returns: s/Any
 * 
 *   Deserializes Avro-encoded data from a byte array, using the given schema
 * as both the reader and writer schema. Note that this is not recommended,
 * since the original writer's schema should always be used to deserialize.
 * The writer's schema (in Parsing Canonical Form) should always be stored
 * or transmitted with encoded data.
 */
deercreeklabs.lancaster.deserialize_same = (function deercreeklabs$lancaster$deserialize_same(G__53537,G__53538){
var validate__37896__auto__ = cljs.core.deref(ufv___54690);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54700 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53537,G__53538], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53541_54702 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53542_54703 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53543_54704 = input_schema53534_54692;
var G__53544_54705 = cljs.core.deref(input_checker53535_54693);
var G__53545_54706 = args__37897__auto___54700;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53541_54702,G__53542_54703,G__53543_54704,G__53544_54705,G__53545_54706) : schema.core.fn_validator.call(null,G__53541_54702,G__53542_54703,G__53543_54704,G__53544_54705,G__53545_54706));
} else {
var temp__5804__auto___54710 = (function (){var fexpr__53546 = cljs.core.deref(input_checker53535_54693);
return (fexpr__53546.cljs$core$IFn$_invoke$arity$1 ? fexpr__53546.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54700) : fexpr__53546.call(null,args__37897__auto___54700));
})();
if(cljs.core.truth_(temp__5804__auto___54710)){
var error__37898__auto___54711 = temp__5804__auto___54710;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54711], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53534_54692,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54700,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54711], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53537;
var ba = G__53538;
while(true){
return deercreeklabs.lancaster.deserialize(schema__$1,schema__$1,ba);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53548_54715 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53549_54716 = cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null));
var G__53550_54717 = output_schema53533_54691;
var G__53551_54718 = cljs.core.deref(output_checker53536_54694);
var G__53552_54719 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53548_54715,G__53549_54716,G__53550_54717,G__53551_54718,G__53552_54719) : schema.core.fn_validator.call(null,G__53548_54715,G__53549_54716,G__53550_54717,G__53551_54718,G__53552_54719));
} else {
var temp__5804__auto___54721 = (function (){var fexpr__53553 = cljs.core.deref(output_checker53536_54694);
return (fexpr__53553.cljs$core$IFn$_invoke$arity$1 ? fexpr__53553.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53553.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54721)){
var error__37898__auto___54722 = temp__5804__auto___54721;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"deserialize-same","deserialize-same",-992043551,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deserializes Avro-encoded data from a byte array, using the given schema\n   as both the reader and writer schema. Note that this is not recommended,\n   since the original writer's schema should always be used to deserialize.\n   The writer's schema (in Parsing Canonical Form) should always be stored\n   or transmitted with encoded data."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54722], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53533_54691,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54722], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.deserialize_same),schema.core.__GT_FnSchema(output_schema53533_54691,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53534_54692], null)));

var ufv___54725 = schema.utils.use_fn_validation;
var output_schema53562_54726 = schema.core.Any;
var input_schema53564_54727 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53565_54728 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53564_54727);
}),null));
var output_checker53566_54729 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53562_54726);
}),null));
var ret__40195__auto___54730 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns an EDN representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.edn = (function deercreeklabs$lancaster$edn(G__53567){
var validate__37896__auto__ = cljs.core.deref(ufv___54725);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54731 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53567], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53572_54732 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53573_54733 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53574_54734 = input_schema53564_54727;
var G__53575_54735 = cljs.core.deref(input_checker53565_54728);
var G__53576_54736 = args__37897__auto___54731;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53572_54732,G__53573_54733,G__53574_54734,G__53575_54735,G__53576_54736) : schema.core.fn_validator.call(null,G__53572_54732,G__53573_54733,G__53574_54734,G__53575_54735,G__53576_54736));
} else {
var temp__5804__auto___54741 = (function (){var fexpr__53577 = cljs.core.deref(input_checker53565_54728);
return (fexpr__53577.cljs$core$IFn$_invoke$arity$1 ? fexpr__53577.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54731) : fexpr__53577.call(null,args__37897__auto___54731));
})();
if(cljs.core.truth_(temp__5804__auto___54741)){
var error__37898__auto___54742 = temp__5804__auto___54741;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54742], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53564_54727,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54731,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54742], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53567;
while(true){
return deercreeklabs.lancaster.utils.edn_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53581_54749 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53582_54750 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null));
var G__53583_54751 = output_schema53562_54726;
var G__53584_54752 = cljs.core.deref(output_checker53566_54729);
var G__53585_54753 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53581_54749,G__53582_54750,G__53583_54751,G__53584_54752,G__53585_54753) : schema.core.fn_validator.call(null,G__53581_54749,G__53582_54750,G__53583_54751,G__53584_54752,G__53585_54753));
} else {
var temp__5804__auto___54759 = (function (){var fexpr__53587 = cljs.core.deref(output_checker53566_54729);
return (fexpr__53587.cljs$core$IFn$_invoke$arity$1 ? fexpr__53587.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53587.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54759)){
var error__37898__auto___54760 = temp__5804__auto___54759;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an EDN representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54760], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53562_54726,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54760], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn),schema.core.__GT_FnSchema(output_schema53562_54726,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53564_54727], null)));

var ufv___54761 = schema.utils.use_fn_validation;
var output_schema53592_54762 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53593_54763 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"edn","edn",-1336594884,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53594_54764 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53593_54763);
}),null));
var output_checker53595_54765 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53592_54762);
}),null));
var ret__40195__auto___54766 = /**
 * Inputs: [edn :- s/Any]
 *   Returns: LancasterSchema
 */
deercreeklabs.lancaster.edn__GT_schema = (function deercreeklabs$lancaster$edn__GT_schema(G__53596){
var validate__37896__auto__ = cljs.core.deref(ufv___54761);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54767 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53596], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53602_54768 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53603_54769 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53604_54770 = input_schema53593_54763;
var G__53605_54771 = cljs.core.deref(input_checker53594_54764);
var G__53606_54772 = args__37897__auto___54767;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53602_54768,G__53603_54769,G__53604_54770,G__53605_54771,G__53606_54772) : schema.core.fn_validator.call(null,G__53602_54768,G__53603_54769,G__53604_54770,G__53605_54771,G__53606_54772));
} else {
var temp__5804__auto___54775 = (function (){var fexpr__53608 = cljs.core.deref(input_checker53594_54764);
return (fexpr__53608.cljs$core$IFn$_invoke$arity$1 ? fexpr__53608.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54767) : fexpr__53608.call(null,args__37897__auto___54767));
})();
if(cljs.core.truth_(temp__5804__auto___54775)){
var error__37898__auto___54780 = temp__5804__auto___54775;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54780], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53593_54763,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54767,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54780], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var edn = G__53596;
while(true){
return deercreeklabs.lancaster.schemas.edn_schema__GT_lancaster_schema.cljs$core$IFn$_invoke$arity$1(edn);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53609_54790 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53610_54791 = cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null));
var G__53611_54792 = output_schema53592_54762;
var G__53612_54793 = cljs.core.deref(output_checker53595_54765);
var G__53613_54794 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53609_54790,G__53610_54791,G__53611_54792,G__53612_54793,G__53613_54794) : schema.core.fn_validator.call(null,G__53609_54790,G__53610_54791,G__53611_54792,G__53612_54793,G__53613_54794));
} else {
var temp__5804__auto___54799 = (function (){var fexpr__53614 = cljs.core.deref(output_checker53595_54765);
return (fexpr__53614.cljs$core$IFn$_invoke$arity$1 ? fexpr__53614.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53614.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54799)){
var error__37898__auto___54803 = temp__5804__auto___54799;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"edn->schema","edn->schema",2104069778,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54803], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53592_54762,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54803], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.edn__GT_schema),schema.core.__GT_FnSchema(output_schema53592_54762,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53593_54763], null)));

var ufv___54807 = schema.utils.use_fn_validation;
var output_schema53632_54808 = schema.core.Str;
var input_schema53633_54809 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53634_54810 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53633_54809);
}),null));
var output_checker53635_54811 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53632_54808);
}),null));
var ret__40195__auto___54813 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns an Avro-compliant JSON representation of the given Lancaster schema.
 */
deercreeklabs.lancaster.json = (function deercreeklabs$lancaster$json(G__53636){
var validate__37896__auto__ = cljs.core.deref(ufv___54807);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54814 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53636], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53648_54815 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53649_54816 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53650_54817 = input_schema53633_54809;
var G__53651_54818 = cljs.core.deref(input_checker53634_54810);
var G__53652_54819 = args__37897__auto___54814;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53648_54815,G__53649_54816,G__53650_54817,G__53651_54818,G__53652_54819) : schema.core.fn_validator.call(null,G__53648_54815,G__53649_54816,G__53650_54817,G__53651_54818,G__53652_54819));
} else {
var temp__5804__auto___54823 = (function (){var fexpr__53657 = cljs.core.deref(input_checker53634_54810);
return (fexpr__53657.cljs$core$IFn$_invoke$arity$1 ? fexpr__53657.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54814) : fexpr__53657.call(null,args__37897__auto___54814));
})();
if(cljs.core.truth_(temp__5804__auto___54823)){
var error__37898__auto___54824 = temp__5804__auto___54823;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54824], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53633_54809,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54814,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54824], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53636;
while(true){
return deercreeklabs.lancaster.utils.json_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53660_54828 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53661_54829 = cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null));
var G__53662_54830 = output_schema53632_54808;
var G__53663_54831 = cljs.core.deref(output_checker53635_54811);
var G__53664_54832 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53660_54828,G__53661_54829,G__53662_54830,G__53663_54831,G__53664_54832) : schema.core.fn_validator.call(null,G__53660_54828,G__53661_54829,G__53662_54830,G__53663_54831,G__53664_54832));
} else {
var temp__5804__auto___54833 = (function (){var fexpr__53665 = cljs.core.deref(output_checker53635_54811);
return (fexpr__53665.cljs$core$IFn$_invoke$arity$1 ? fexpr__53665.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53665.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54833)){
var error__37898__auto___54835 = temp__5804__auto___54833;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns an Avro-compliant JSON representation of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54835], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53632_54808,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54835], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.json),schema.core.__GT_FnSchema(output_schema53632_54808,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53633_54809], null)));

var ufv___54836 = schema.utils.use_fn_validation;
var output_schema53669_54837 = schema.core.Keyword;
var input_schema53670_54838 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53671_54839 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53670_54838);
}),null));
var output_checker53672_54840 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53669_54837);
}),null));
var ret__40195__auto___54841 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the name keyword for the given Lancaster schema.
 */
deercreeklabs.lancaster.name_kw = (function deercreeklabs$lancaster$name_kw(G__53673){
var validate__37896__auto__ = cljs.core.deref(ufv___54836);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54844 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53673], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53687_54845 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53688_54846 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53689_54847 = input_schema53670_54838;
var G__53690_54848 = cljs.core.deref(input_checker53671_54839);
var G__53691_54849 = args__37897__auto___54844;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53687_54845,G__53688_54846,G__53689_54847,G__53690_54848,G__53691_54849) : schema.core.fn_validator.call(null,G__53687_54845,G__53688_54846,G__53689_54847,G__53690_54848,G__53691_54849));
} else {
var temp__5804__auto___54850 = (function (){var fexpr__53700 = cljs.core.deref(input_checker53671_54839);
return (fexpr__53700.cljs$core$IFn$_invoke$arity$1 ? fexpr__53700.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54844) : fexpr__53700.call(null,args__37897__auto___54844));
})();
if(cljs.core.truth_(temp__5804__auto___54850)){
var error__37898__auto___54851 = temp__5804__auto___54850;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54851], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53670_54838,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54844,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54851], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53673;
while(true){
return deercreeklabs.lancaster.utils.edn_schema__GT_name_kw(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53718_54854 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53719_54855 = cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null));
var G__53720_54856 = output_schema53669_54837;
var G__53721_54857 = cljs.core.deref(output_checker53672_54840);
var G__53722_54858 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53718_54854,G__53719_54855,G__53720_54856,G__53721_54857,G__53722_54858) : schema.core.fn_validator.call(null,G__53718_54854,G__53719_54855,G__53720_54856,G__53721_54857,G__53722_54858));
} else {
var temp__5804__auto___54859 = (function (){var fexpr__53725 = cljs.core.deref(output_checker53672_54840);
return (fexpr__53725.cljs$core$IFn$_invoke$arity$1 ? fexpr__53725.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53725.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54859)){
var error__37898__auto___54861 = temp__5804__auto___54859;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"name-kw","name-kw",1544028173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the name keyword for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54861], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53669_54837,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54861], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.name_kw),schema.core.__GT_FnSchema(output_schema53669_54837,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53670_54838], null)));

var ufv___54874 = schema.utils.use_fn_validation;
var output_schema53728_54875 = schema.core.Str;
var input_schema53729_54876 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53730_54877 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53729_54876);
}),null));
var output_checker53731_54878 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53728_54875);
}),null));
var ret__40195__auto___54888 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Str
 * 
 *   Returns a JSON string containing the Avro Parsing Canonical Form of
 *   the given Lancaster schema.
 */
deercreeklabs.lancaster.pcf = (function deercreeklabs$lancaster$pcf(G__53732){
var validate__37896__auto__ = cljs.core.deref(ufv___54874);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54893 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53732], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53737_54894 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53738_54895 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53739_54896 = input_schema53729_54876;
var G__53740_54897 = cljs.core.deref(input_checker53730_54877);
var G__53741_54898 = args__37897__auto___54893;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53737_54894,G__53738_54895,G__53739_54896,G__53740_54897,G__53741_54898) : schema.core.fn_validator.call(null,G__53737_54894,G__53738_54895,G__53739_54896,G__53740_54897,G__53741_54898));
} else {
var temp__5804__auto___54900 = (function (){var fexpr__53742 = cljs.core.deref(input_checker53730_54877);
return (fexpr__53742.cljs$core$IFn$_invoke$arity$1 ? fexpr__53742.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54893) : fexpr__53742.call(null,args__37897__auto___54893));
})();
if(cljs.core.truth_(temp__5804__auto___54900)){
var error__37898__auto___54901 = temp__5804__auto___54900;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54901], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53729_54876,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54893,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54901], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53732;
while(true){
return deercreeklabs.lancaster.utils.parsing_canonical_form(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53743_54903 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53744_54904 = cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null));
var G__53745_54905 = output_schema53728_54875;
var G__53746_54906 = cljs.core.deref(output_checker53731_54878);
var G__53747_54907 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53743_54903,G__53744_54904,G__53745_54905,G__53746_54906,G__53747_54907) : schema.core.fn_validator.call(null,G__53743_54903,G__53744_54904,G__53745_54905,G__53746_54906,G__53747_54907));
} else {
var temp__5804__auto___54908 = (function (){var fexpr__53749 = cljs.core.deref(output_checker53731_54878);
return (fexpr__53749.cljs$core$IFn$_invoke$arity$1 ? fexpr__53749.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53749.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54908)){
var error__37898__auto___54909 = temp__5804__auto___54908;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"pcf","pcf",796966670,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a JSON string containing the Avro Parsing Canonical Form of\n  the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54909], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53728_54875,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54909], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.pcf),schema.core.__GT_FnSchema(output_schema53728_54875,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53729_54876], null)));

var ufv___54915 = schema.utils.use_fn_validation;
var output_schema53752_54916 = deercreeklabs.lancaster.goog$module$goog$math$Long;
var input_schema53755_54918 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53756_54919 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53755_54918);
}),null));
var output_checker53757_54920 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53752_54916);
}),null));
var ret__40195__auto___54921 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: Long
 * 
 *   Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint64 = (function deercreeklabs$lancaster$fingerprint64(G__53758){
var validate__37896__auto__ = cljs.core.deref(ufv___54915);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54925 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53758], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53762_54926 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53764_54927 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53765_54928 = input_schema53755_54918;
var G__53766_54929 = cljs.core.deref(input_checker53756_54919);
var G__53767_54930 = args__37897__auto___54925;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53762_54926,G__53764_54927,G__53765_54928,G__53766_54929,G__53767_54930) : schema.core.fn_validator.call(null,G__53762_54926,G__53764_54927,G__53765_54928,G__53766_54929,G__53767_54930));
} else {
var temp__5804__auto___54931 = (function (){var fexpr__53771 = cljs.core.deref(input_checker53756_54919);
return (fexpr__53771.cljs$core$IFn$_invoke$arity$1 ? fexpr__53771.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54925) : fexpr__53771.call(null,args__37897__auto___54925));
})();
if(cljs.core.truth_(temp__5804__auto___54931)){
var error__37898__auto___54935 = temp__5804__auto___54931;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54935], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53755_54918,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54925,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54935], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53758;
while(true){
return deercreeklabs.lancaster.utils.fingerprint64(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53773_54939 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53774_54940 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53775_54941 = output_schema53752_54916;
var G__53776_54942 = cljs.core.deref(output_checker53757_54920);
var G__53777_54943 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53773_54939,G__53774_54940,G__53775_54941,G__53776_54942,G__53777_54943) : schema.core.fn_validator.call(null,G__53773_54939,G__53774_54940,G__53775_54941,G__53776_54942,G__53777_54943));
} else {
var temp__5804__auto___54944 = (function (){var fexpr__53779 = cljs.core.deref(output_checker53757_54920);
return (fexpr__53779.cljs$core$IFn$_invoke$arity$1 ? fexpr__53779.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53779.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54944)){
var error__37898__auto___54945 = temp__5804__auto___54944;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint64","fingerprint64",-166325219,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"Long","Long",-1427240163,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 64-bit Rabin fingerprint of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54945], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53752_54916,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54945], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint64),schema.core.__GT_FnSchema(output_schema53752_54916,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53755_54918], null)));

var ufv___54946 = schema.utils.use_fn_validation;
var output_schema53782_54947 = deercreeklabs.baracus.ByteArray;
var input_schema53784_54948 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53785_54949 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53784_54948);
}),null));
var output_checker53786_54950 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53782_54947);
}),null));
var ret__40195__auto___54951 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 128-bit MD5 digest of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint128 = (function deercreeklabs$lancaster$fingerprint128(G__53787){
var validate__37896__auto__ = cljs.core.deref(ufv___54946);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54954 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53787], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53794_54955 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53795_54956 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53796_54957 = input_schema53784_54948;
var G__53797_54958 = cljs.core.deref(input_checker53785_54949);
var G__53798_54959 = args__37897__auto___54954;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53794_54955,G__53795_54956,G__53796_54957,G__53797_54958,G__53798_54959) : schema.core.fn_validator.call(null,G__53794_54955,G__53795_54956,G__53796_54957,G__53797_54958,G__53798_54959));
} else {
var temp__5804__auto___54960 = (function (){var fexpr__53800 = cljs.core.deref(input_checker53785_54949);
return (fexpr__53800.cljs$core$IFn$_invoke$arity$1 ? fexpr__53800.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54954) : fexpr__53800.call(null,args__37897__auto___54954));
})();
if(cljs.core.truth_(temp__5804__auto___54960)){
var error__37898__auto___54963 = temp__5804__auto___54960;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54963], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53784_54948,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54954,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54963], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53787;
while(true){
return deercreeklabs.lancaster.utils.fingerprint128(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53803_54965 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53804_54966 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53805_54967 = output_schema53782_54947;
var G__53806_54968 = cljs.core.deref(output_checker53786_54950);
var G__53807_54969 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53803_54965,G__53804_54966,G__53805_54967,G__53806_54968,G__53807_54969) : schema.core.fn_validator.call(null,G__53803_54965,G__53804_54966,G__53805_54967,G__53806_54968,G__53807_54969));
} else {
var temp__5804__auto___54970 = (function (){var fexpr__53809 = cljs.core.deref(output_checker53786_54950);
return (fexpr__53809.cljs$core$IFn$_invoke$arity$1 ? fexpr__53809.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53809.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___54970)){
var error__37898__auto___54972 = temp__5804__auto___54970;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint128","fingerprint128",-1047019708,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 128-bit MD5 digest of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54972], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53782_54947,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54972], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint128),schema.core.__GT_FnSchema(output_schema53782_54947,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53784_54948], null)));

var ufv___54974 = schema.utils.use_fn_validation;
var output_schema53812_54975 = deercreeklabs.baracus.ByteArray;
var input_schema53813_54976 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53814_54977 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53813_54976);
}),null));
var output_checker53815_54978 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53812_54975);
}),null));
var ret__40195__auto___54981 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: ba/ByteArray
 * 
 *   Returns the 256-bit SHA-256 hash of the Parsing Canonical Form
 * of the given Lancaster schema.
 */
deercreeklabs.lancaster.fingerprint256 = (function deercreeklabs$lancaster$fingerprint256(G__53816){
var validate__37896__auto__ = cljs.core.deref(ufv___54974);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___54984 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53816], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53821_54985 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53822_54986 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53823_54987 = input_schema53813_54976;
var G__53824_54988 = cljs.core.deref(input_checker53814_54977);
var G__53825_54989 = args__37897__auto___54984;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53821_54985,G__53822_54986,G__53823_54987,G__53824_54988,G__53825_54989) : schema.core.fn_validator.call(null,G__53821_54985,G__53822_54986,G__53823_54987,G__53824_54988,G__53825_54989));
} else {
var temp__5804__auto___54992 = (function (){var fexpr__53827 = cljs.core.deref(input_checker53814_54977);
return (fexpr__53827.cljs$core$IFn$_invoke$arity$1 ? fexpr__53827.cljs$core$IFn$_invoke$arity$1(args__37897__auto___54984) : fexpr__53827.call(null,args__37897__auto___54984));
})();
if(cljs.core.truth_(temp__5804__auto___54992)){
var error__37898__auto___54993 = temp__5804__auto___54992;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___54993], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53813_54976,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___54984,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___54993], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53816;
while(true){
return deercreeklabs.lancaster.utils.fingerprint256(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53829_54999 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53830_55000 = cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null));
var G__53831_55001 = output_schema53812_54975;
var G__53832_55002 = cljs.core.deref(output_checker53815_54978);
var G__53833_55003 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53829_54999,G__53830_55000,G__53831_55001,G__53832_55002,G__53833_55003) : schema.core.fn_validator.call(null,G__53829_54999,G__53830_55000,G__53831_55001,G__53832_55002,G__53833_55003));
} else {
var temp__5804__auto___55005 = (function (){var fexpr__53834 = cljs.core.deref(output_checker53815_54978);
return (fexpr__53834.cljs$core$IFn$_invoke$arity$1 ? fexpr__53834.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53834.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55005)){
var error__37898__auto___55006 = temp__5804__auto___55005;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"fingerprint256","fingerprint256",1432621218,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("ba","ByteArray","ba/ByteArray",1312427475,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the 256-bit SHA-256 hash of the Parsing Canonical Form\n   of the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55006], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53812_54975,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55006], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.fingerprint256),schema.core.__GT_FnSchema(output_schema53812_54975,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53813_54976], null)));

var ufv___55007 = schema.utils.use_fn_validation;
var output_schema53837_55008 = schema.core.Bool;
var input_schema53838_55009 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker53839_55010 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53838_55009);
}),null));
var output_checker53840_55011 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53837_55008);
}),null));
var ret__40195__auto___55012 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the argument is a
 * Lancaster schema object.
 */
deercreeklabs.lancaster.schema_QMARK_ = (function deercreeklabs$lancaster$schema_QMARK_(G__53841){
var validate__37896__auto__ = cljs.core.deref(ufv___55007);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55013 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53841], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53845_55014 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53846_55015 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53847_55016 = input_schema53838_55009;
var G__53848_55017 = cljs.core.deref(input_checker53839_55010);
var G__53849_55018 = args__37897__auto___55013;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53845_55014,G__53846_55015,G__53847_55016,G__53848_55017,G__53849_55018) : schema.core.fn_validator.call(null,G__53845_55014,G__53846_55015,G__53847_55016,G__53848_55017,G__53849_55018));
} else {
var temp__5804__auto___55020 = (function (){var fexpr__53851 = cljs.core.deref(input_checker53839_55010);
return (fexpr__53851.cljs$core$IFn$_invoke$arity$1 ? fexpr__53851.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55013) : fexpr__53851.call(null,args__37897__auto___55013));
})();
if(cljs.core.truth_(temp__5804__auto___55020)){
var error__37898__auto___55022 = temp__5804__auto___55020;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55022], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53838_55009,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55013,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55022], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var arg = G__53841;
while(true){
if((!((arg == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === arg.deercreeklabs$lancaster$utils$ILancasterSchema$)))){
return true;
} else {
if((!arg.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,arg);
}
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53859_55032 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53860_55033 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null));
var G__53861_55034 = output_schema53837_55008;
var G__53862_55035 = cljs.core.deref(output_checker53840_55011);
var G__53863_55036 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53859_55032,G__53860_55033,G__53861_55034,G__53862_55035,G__53863_55036) : schema.core.fn_validator.call(null,G__53859_55032,G__53860_55033,G__53861_55034,G__53862_55035,G__53863_55036));
} else {
var temp__5804__auto___55037 = (function (){var fexpr__53865 = cljs.core.deref(output_checker53840_55011);
return (fexpr__53865.cljs$core$IFn$_invoke$arity$1 ? fexpr__53865.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53865.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55037)){
var error__37898__auto___55038 = temp__5804__auto___55037;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema?","schema?",1781760118,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the argument is a\n   Lancaster schema object."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55038], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53837_55008,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55038], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_QMARK_),schema.core.__GT_FnSchema(output_schema53837_55008,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53838_55009], null)));

var ufv___55041 = schema.utils.use_fn_validation;
var output_schema53870_55042 = schema.core.Bool;
var input_schema53872_55043 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"reader-schema","reader-schema",1519312637,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"writer-schema","writer-schema",1865431814,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53873_55044 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53872_55043);
}),null));
var output_checker53874_55045 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53870_55042);
}),null));
var ret__40195__auto___55051 = /**
 * Inputs: [reader-schema :- LancasterSchema writer-schema :- LancasterSchema]
 *   Returns: s/Bool
 * 
 *   Returns a boolean indicating whether or not the given reader and
 * writer schemas match, according to the Avro matching rules.
 */
deercreeklabs.lancaster.schemas_match_QMARK_ = (function deercreeklabs$lancaster$schemas_match_QMARK_(G__53875,G__53876){
var validate__37896__auto__ = cljs.core.deref(ufv___55041);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55053 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53875,G__53876], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53879_55054 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53880_55055 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53881_55056 = input_schema53872_55043;
var G__53882_55057 = cljs.core.deref(input_checker53873_55044);
var G__53883_55058 = args__37897__auto___55053;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53879_55054,G__53880_55055,G__53881_55056,G__53882_55057,G__53883_55058) : schema.core.fn_validator.call(null,G__53879_55054,G__53880_55055,G__53881_55056,G__53882_55057,G__53883_55058));
} else {
var temp__5804__auto___55063 = (function (){var fexpr__53884 = cljs.core.deref(input_checker53873_55044);
return (fexpr__53884.cljs$core$IFn$_invoke$arity$1 ? fexpr__53884.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55053) : fexpr__53884.call(null,args__37897__auto___55053));
})();
if(cljs.core.truth_(temp__5804__auto___55063)){
var error__37898__auto___55064 = temp__5804__auto___55063;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55064], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53872_55043,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55053,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55064], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var reader_schema = G__53875;
var writer_schema = G__53876;
while(true){
if((((!((reader_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === reader_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!reader_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,reader_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["reader-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(reader_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),reader_schema], null));
}

if((((!((writer_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === writer_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!writer_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,writer_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["writer-schema must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(writer_schema),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),writer_schema], null));
}

return deercreeklabs.lancaster.schemas.match_QMARK_(reader_schema,writer_schema);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53893_55069 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53894_55070 = cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null));
var G__53895_55071 = output_schema53870_55042;
var G__53896_55072 = cljs.core.deref(output_checker53874_55045);
var G__53897_55073 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53893_55069,G__53894_55070,G__53895_55071,G__53896_55072,G__53897_55073) : schema.core.fn_validator.call(null,G__53893_55069,G__53894_55070,G__53895_55071,G__53896_55072,G__53897_55073));
} else {
var temp__5804__auto___55074 = (function (){var fexpr__53898 = cljs.core.deref(output_checker53874_55045);
return (fexpr__53898.cljs$core$IFn$_invoke$arity$1 ? fexpr__53898.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53898.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55074)){
var error__37898__auto___55075 = temp__5804__auto___55074;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schemas-match?","schemas-match?",284424106,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a boolean indicating whether or not the given reader and\n   writer schemas match, according to the Avro matching rules."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55075], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53870_55042,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55075], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schemas_match_QMARK_),schema.core.__GT_FnSchema(output_schema53870_55042,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53872_55043], null)));

var ufv___55076 = schema.utils.use_fn_validation;
var output_schema53903_55077 = schema.core.Any;
var input_schema53904_55078 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53905_55079 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53904_55078);
}),null));
var output_checker53906_55080 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53903_55077);
}),null));
var ret__40195__auto___55082 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Returns a Plumatic schema for the given Lancaster schema.
 */
deercreeklabs.lancaster.plumatic_schema = (function deercreeklabs$lancaster$plumatic_schema(G__53907){
var validate__37896__auto__ = cljs.core.deref(ufv___55076);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55087 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53907], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53914_55088 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53915_55089 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53916_55090 = input_schema53904_55078;
var G__53917_55091 = cljs.core.deref(input_checker53905_55079);
var G__53918_55092 = args__37897__auto___55087;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53914_55088,G__53915_55089,G__53916_55090,G__53917_55091,G__53918_55092) : schema.core.fn_validator.call(null,G__53914_55088,G__53915_55089,G__53916_55090,G__53917_55091,G__53918_55092));
} else {
var temp__5804__auto___55093 = (function (){var fexpr__53921 = cljs.core.deref(input_checker53905_55079);
return (fexpr__53921.cljs$core$IFn$_invoke$arity$1 ? fexpr__53921.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55087) : fexpr__53921.call(null,args__37897__auto___55087));
})();
if(cljs.core.truth_(temp__5804__auto___55093)){
var error__37898__auto___55095 = temp__5804__auto___55093;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55095], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53904_55078,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55087,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55095], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53907;
while(true){
return deercreeklabs.lancaster.utils.plumatic_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53928_55099 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53929_55100 = cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null));
var G__53930_55101 = output_schema53903_55077;
var G__53931_55102 = cljs.core.deref(output_checker53906_55080);
var G__53932_55103 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53928_55099,G__53929_55100,G__53930_55101,G__53931_55102,G__53932_55103) : schema.core.fn_validator.call(null,G__53928_55099,G__53929_55100,G__53930_55101,G__53931_55102,G__53932_55103));
} else {
var temp__5804__auto___55104 = (function (){var fexpr__53933 = cljs.core.deref(output_checker53906_55080);
return (fexpr__53933.cljs$core$IFn$_invoke$arity$1 ? fexpr__53933.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53933.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55104)){
var error__37898__auto___55107 = temp__5804__auto___55104;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"plumatic-schema","plumatic-schema",627124202,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a Plumatic schema for the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55107], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53903_55077,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55107], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.plumatic_schema),schema.core.__GT_FnSchema(output_schema53903_55077,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53904_55078], null)));

var ufv___55109 = schema.utils.use_fn_validation;
var output_schema53940_55110 = schema.core.Any;
var input_schema53941_55111 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker53942_55112 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53941_55111);
}),null));
var output_checker53943_55113 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53940_55110);
}),null));
var ret__40195__auto___55115 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Any
 * 
 *   Creates default data that conforms to the given Lancaster schema.
 */
deercreeklabs.lancaster.default_data = (function deercreeklabs$lancaster$default_data(G__53944){
var validate__37896__auto__ = cljs.core.deref(ufv___55109);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55116 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53944], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53952_55117 = new cljs.core.Keyword(null,"input","input",556931961);
var G__53953_55118 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53954_55119 = input_schema53941_55111;
var G__53955_55120 = cljs.core.deref(input_checker53942_55112);
var G__53956_55121 = args__37897__auto___55116;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53952_55117,G__53953_55118,G__53954_55119,G__53955_55120,G__53956_55121) : schema.core.fn_validator.call(null,G__53952_55117,G__53953_55118,G__53954_55119,G__53955_55120,G__53956_55121));
} else {
var temp__5804__auto___55122 = (function (){var fexpr__53957 = cljs.core.deref(input_checker53942_55112);
return (fexpr__53957.cljs$core$IFn$_invoke$arity$1 ? fexpr__53957.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55116) : fexpr__53957.call(null,args__37897__auto___55116));
})();
if(cljs.core.truth_(temp__5804__auto___55122)){
var error__37898__auto___55123 = temp__5804__auto___55122;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55123], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53941_55111,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55116,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55123], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53944;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to default-data must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.default_data.cljs$core$IFn$_invoke$arity$1(deercreeklabs.lancaster.edn(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__53970_55125 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__53971_55126 = cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null));
var G__53972_55127 = output_schema53940_55110;
var G__53973_55128 = cljs.core.deref(output_checker53943_55113);
var G__53974_55129 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__53970_55125,G__53971_55126,G__53972_55127,G__53973_55128,G__53974_55129) : schema.core.fn_validator.call(null,G__53970_55125,G__53971_55126,G__53972_55127,G__53973_55128,G__53974_55129));
} else {
var temp__5804__auto___55131 = (function (){var fexpr__53978 = cljs.core.deref(output_checker53943_55113);
return (fexpr__53978.cljs$core$IFn$_invoke$arity$1 ? fexpr__53978.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__53978.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55131)){
var error__37898__auto___55132 = temp__5804__auto___55131;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"default-data","default-data",-260790774,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates default data that conforms to the given Lancaster schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55132], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53940_55110,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55132], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.default_data),schema.core.__GT_FnSchema(output_schema53940_55110,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53941_55111], null)));

var ufv___55135 = schema.utils.use_fn_validation;
var output_schema53984_55136 = deercreeklabs.lancaster.LancasterSchema;
var input_schema53988_55137 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_schema53992_55138 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"field-kw-or-branch-i","field-kw-or-branch-i",-669619433,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null)))], null);
var input_checker53989_55139 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53988_55137);
}),null));
var output_checker53990_55140 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53984_55136);
}),null));
var input_checker53993_55141 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema53992_55138);
}),null));
var output_checker53994_55142 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema53984_55136);
}),null));
var ret__40195__auto___55145 = (function (){
/**
 * Inputs: ([schema] [schema field-kw-or-branch-i])
 *   Returns: LancasterSchema
 * 
 *   Returns the child schema of the given schema
 */
deercreeklabs.lancaster.child_schema = (function deercreeklabs$lancaster$child_schema(var_args){
var G__54013 = arguments.length;
switch (G__54013) {
case 1:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$1 = (function (G__53991){
var validate__37896__auto__ = cljs.core.deref(ufv___55135);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55151 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53991], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54014_55152 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54015_55153 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54016_55154 = input_schema53988_55137;
var G__54017_55155 = cljs.core.deref(input_checker53989_55139);
var G__54018_55156 = args__37897__auto___55151;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54014_55152,G__54015_55153,G__54016_55154,G__54017_55155,G__54018_55156) : schema.core.fn_validator.call(null,G__54014_55152,G__54015_55153,G__54016_55154,G__54017_55155,G__54018_55156));
} else {
var temp__5804__auto___55158 = (function (){var fexpr__54021 = cljs.core.deref(input_checker53989_55139);
return (fexpr__54021.cljs$core$IFn$_invoke$arity$1 ? fexpr__54021.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55151) : fexpr__54021.call(null,args__37897__auto___55151));
})();
if(cljs.core.truth_(temp__5804__auto___55158)){
var error__37898__auto___55159 = temp__5804__auto___55158;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55159], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53988_55137,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55151,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55159], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53991;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54024_55161 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54025_55162 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54026_55163 = output_schema53984_55136;
var G__54027_55164 = cljs.core.deref(output_checker53990_55140);
var G__54028_55165 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54024_55161,G__54025_55162,G__54026_55163,G__54027_55164,G__54028_55165) : schema.core.fn_validator.call(null,G__54024_55161,G__54025_55162,G__54026_55163,G__54027_55164,G__54028_55165));
} else {
var temp__5804__auto___55166 = (function (){var fexpr__54029 = cljs.core.deref(output_checker53990_55140);
return (fexpr__54029.cljs$core$IFn$_invoke$arity$1 ? fexpr__54029.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54029.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55166)){
var error__37898__auto___55167 = temp__5804__auto___55166;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55167], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53984_55136,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55167], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$core$IFn$_invoke$arity$2 = (function (G__53995,G__53996){
var validate__37896__auto__ = cljs.core.deref(ufv___55135);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55168 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__53995,G__53996], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54031_55169 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54032_55170 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54033_55171 = input_schema53992_55138;
var G__54034_55172 = cljs.core.deref(input_checker53993_55141);
var G__54035_55173 = args__37897__auto___55168;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54031_55169,G__54032_55170,G__54033_55171,G__54034_55172,G__54035_55173) : schema.core.fn_validator.call(null,G__54031_55169,G__54032_55170,G__54033_55171,G__54034_55172,G__54035_55173));
} else {
var temp__5804__auto___55174 = (function (){var fexpr__54036 = cljs.core.deref(input_checker53993_55141);
return (fexpr__54036.cljs$core$IFn$_invoke$arity$1 ? fexpr__54036.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55168) : fexpr__54036.call(null,args__37897__auto___55168));
})();
if(cljs.core.truth_(temp__5804__auto___55174)){
var error__37898__auto___55175 = temp__5804__auto___55174;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55175], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema53992_55138,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55168,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55175], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__53995;
var field_kw_or_branch_i = G__53996;
while(true){
return deercreeklabs.lancaster.utils.child_schema(schema__$1,field_kw_or_branch_i);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54038_55176 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54039_55177 = cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null));
var G__54040_55178 = output_schema53984_55136;
var G__54041_55179 = cljs.core.deref(output_checker53994_55142);
var G__54042_55180 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54038_55176,G__54039_55177,G__54040_55178,G__54041_55179,G__54042_55180) : schema.core.fn_validator.call(null,G__54038_55176,G__54039_55177,G__54040_55178,G__54041_55179,G__54042_55180));
} else {
var temp__5804__auto___55181 = (function (){var fexpr__54046 = cljs.core.deref(output_checker53994_55142);
return (fexpr__54046.cljs$core$IFn$_invoke$arity$1 ? fexpr__54046.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54046.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55181)){
var error__37898__auto___55182 = temp__5804__auto___55181;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"child-schema","child-schema",850966635,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the child schema of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55182], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema53984_55136,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55182], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.child_schema.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.child_schema),schema.core.make_fn_schema(output_schema53984_55136,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema53988_55137,input_schema53992_55138], null)));

var ufv___55183 = schema.utils.use_fn_validation;
var output_schema54050_55184 = schema.core.maybe(deercreeklabs.lancaster.LancasterSchema);
var input_schema54051_55185 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null)))], null);
var input_schema54057_55186 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),cljs.core.with_meta(new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)], null))),schema.core.one(cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.optional_key(new cljs.core.Keyword(null,"branches?","branches?",-1426607703)),schema.core.Bool,schema.core.Keyword,schema.core.Any]),new cljs.core.Symbol(null,"arg2","arg2",-924884852,null))], null);
var input_checker54052_55187 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54051_55185);
}),null));
var output_checker54053_55188 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54050_55184);
}),null));
var input_checker54058_55189 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54057_55186);
}),null));
var output_checker54059_55190 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54050_55184);
}),null));
var ret__40195__auto___55192 = (function (){
/**
 * Inputs: ([schema :- LancasterSchema path :- [s/Any]] [schema :- LancasterSchema path :- [s/Any] {:keys [branches?], :as opts} :- {(s/optional-key :branches?) s/Bool, s/Keyword s/Any}])
 *   Returns: (s/maybe LancasterSchema)
 */
deercreeklabs.lancaster.schema_at_path = (function deercreeklabs$lancaster$schema_at_path(var_args){
var G__54077 = arguments.length;
switch (G__54077) {
case 2:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$2 = (function (G__54054,G__54055){
var validate__37896__auto__ = cljs.core.deref(ufv___55183);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55197 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54054,G__54055], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54081_55198 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54082_55199 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54083_55200 = input_schema54051_55185;
var G__54084_55201 = cljs.core.deref(input_checker54052_55187);
var G__54085_55202 = args__37897__auto___55197;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54081_55198,G__54082_55199,G__54083_55200,G__54084_55201,G__54085_55202) : schema.core.fn_validator.call(null,G__54081_55198,G__54082_55199,G__54083_55200,G__54084_55201,G__54085_55202));
} else {
var temp__5804__auto___55205 = (function (){var fexpr__54086 = cljs.core.deref(input_checker54052_55187);
return (fexpr__54086.cljs$core$IFn$_invoke$arity$1 ? fexpr__54086.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55197) : fexpr__54086.call(null,args__37897__auto___55197));
})();
if(cljs.core.truth_(temp__5804__auto___55205)){
var error__37898__auto___55206 = temp__5804__auto___55205;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55206], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54051_55185,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55197,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55206], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__54054;
var path = G__54055;
while(true){
return deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$1,path,cljs.core.PersistentArrayMap.EMPTY);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54091_55207 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54092_55208 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54093_55209 = output_schema54050_55184;
var G__54094_55210 = cljs.core.deref(output_checker54053_55188);
var G__54095_55211 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54091_55207,G__54092_55208,G__54093_55209,G__54094_55210,G__54095_55211) : schema.core.fn_validator.call(null,G__54091_55207,G__54092_55208,G__54093_55209,G__54094_55210,G__54095_55211));
} else {
var temp__5804__auto___55212 = (function (){var fexpr__54096 = cljs.core.deref(output_checker54053_55188);
return (fexpr__54096.cljs$core$IFn$_invoke$arity$1 ? fexpr__54096.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54096.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55212)){
var error__37898__auto___55214 = temp__5804__auto___55212;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55214], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54050_55184,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55214], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$core$IFn$_invoke$arity$3 = (function (G__54060,G__54061,G__54062){
var validate__37896__auto__ = cljs.core.deref(ufv___55183);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55218 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54060,G__54061,G__54062], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54098_55220 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54099_55221 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54100_55222 = input_schema54057_55186;
var G__54101_55223 = cljs.core.deref(input_checker54058_55189);
var G__54102_55224 = args__37897__auto___55218;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54098_55220,G__54099_55221,G__54100_55222,G__54101_55223,G__54102_55224) : schema.core.fn_validator.call(null,G__54098_55220,G__54099_55221,G__54100_55222,G__54101_55223,G__54102_55224));
} else {
var temp__5804__auto___55228 = (function (){var fexpr__54103 = cljs.core.deref(input_checker54058_55189);
return (fexpr__54103.cljs$core$IFn$_invoke$arity$1 ? fexpr__54103.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55218) : fexpr__54103.call(null,args__37897__auto___55218));
})();
if(cljs.core.truth_(temp__5804__auto___55228)){
var error__37898__auto___55230 = temp__5804__auto___55228;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55230], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54057_55186,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55218,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55230], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__54060;
var path = G__54061;
var G__54105 = G__54062;
var map__54107 = G__54105;
var map__54107__$1 = cljs.core.__destructure_map(map__54107);
var opts = map__54107__$1;
var branches_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54107__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
var schema__$2 = schema__$1;
var path__$1 = path;
var G__54105__$1 = G__54105;
while(true){
var schema__$3 = schema__$2;
var path__$2 = path__$1;
var map__54108 = G__54105__$1;
var map__54108__$1 = cljs.core.__destructure_map(map__54108);
var opts__$1 = map__54108__$1;
var branches_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54108__$1,new cljs.core.Keyword(null,"branches?","branches?",-1426607703));
if((((!((schema__$3 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$3.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$3.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$3))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["First argument to schema-at-path must be a schema object. ","Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$3),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$3], null));
}

if((path__$2 == null)){
} else {
if(cljs.core.truth_(deercreeklabs.lancaster.utils.path_QMARK_(path__$2))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to schema-at-path must be nil or a sequence of ","path keys, which must be keywords, strings, or integers. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path__$2),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-path","given-path",1645463679),path__$2], null));
}
}

if((((!((branches_QMARK___$1 == null)))) && ((!(cljs.core.boolean_QMARK_(branches_QMARK___$1)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["`branches?` option, when provided, must be a boolean. When true ","it causes integers in the path to be interpreted as branches in ","union if the corresponding schema is a union rather than causing ","a search in the union for an array. Got: `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(branches_QMARK___$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-opts","given-opts",632184974),opts__$1], null));
} else {
}

return deercreeklabs.lancaster.sub.schema_at_path.cljs$core$IFn$_invoke$arity$3(schema__$3,path__$2,opts__$1);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54113_55237 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54114_55238 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null));
var G__54115_55239 = output_schema54050_55184;
var G__54116_55240 = cljs.core.deref(output_checker54059_55190);
var G__54117_55241 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54113_55237,G__54114_55238,G__54115_55239,G__54116_55240,G__54117_55241) : schema.core.fn_validator.call(null,G__54113_55237,G__54114_55238,G__54115_55239,G__54116_55240,G__54117_55241));
} else {
var temp__5804__auto___55247 = (function (){var fexpr__54118 = cljs.core.deref(output_checker54059_55190);
return (fexpr__54118.cljs$core$IFn$_invoke$arity$1 ? fexpr__54118.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54118.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55247)){
var error__37898__auto___55248 = temp__5804__auto___55247;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-at-path","schema-at-path",1094262342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55248], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54050_55184,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55248], null));
} else {
}
}
} else {
}

return o__37899__auto__;
}));

(deercreeklabs.lancaster.schema_at_path.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_at_path),schema.core.make_fn_schema(output_schema54050_55184,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54051_55185,input_schema54057_55186], null)));

var ufv___55254 = schema.utils.use_fn_validation;
var output_schema54126_55255 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.lancaster.LancasterSchema], null);
var input_schema54127_55256 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54128_55257 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54127_55256);
}),null));
var output_checker54129_55258 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54126_55255);
}),null));
var ret__40195__auto___55259 = /**
 * Inputs: [union-schema :- LancasterSchema]
 *   Returns: [LancasterSchema]
 * 
 *   Returns the member schemas of the given union schema.
 */
deercreeklabs.lancaster.member_schemas = (function deercreeklabs$lancaster$member_schemas(G__54130){
var validate__37896__auto__ = cljs.core.deref(ufv___55254);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55262 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54130], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54135_55263 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54136_55264 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__54137_55265 = input_schema54127_55256;
var G__54138_55266 = cljs.core.deref(input_checker54128_55257);
var G__54139_55267 = args__37897__auto___55262;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54135_55263,G__54136_55264,G__54137_55265,G__54138_55266,G__54139_55267) : schema.core.fn_validator.call(null,G__54135_55263,G__54136_55264,G__54137_55265,G__54138_55266,G__54139_55267));
} else {
var temp__5804__auto___55272 = (function (){var fexpr__54143 = cljs.core.deref(input_checker54128_55257);
return (fexpr__54143.cljs$core$IFn$_invoke$arity$1 ? fexpr__54143.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55262) : fexpr__54143.call(null,args__37897__auto___55262));
})();
if(cljs.core.truth_(temp__5804__auto___55272)){
var error__37898__auto___55273 = temp__5804__auto___55272;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55273], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54127_55256,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55262,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55273], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var union_schema = G__54130;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The argument to `member-schemas` must satisfy the ","ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

return deercreeklabs.lancaster.sub.member_schemas(union_schema);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54155_55280 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54156_55281 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null));
var G__54157_55282 = output_schema54126_55255;
var G__54158_55283 = cljs.core.deref(output_checker54129_55258);
var G__54159_55284 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54155_55280,G__54156_55281,G__54157_55282,G__54158_55283,G__54159_55284) : schema.core.fn_validator.call(null,G__54155_55280,G__54156_55281,G__54157_55282,G__54158_55283,G__54159_55284));
} else {
var temp__5804__auto___55286 = (function (){var fexpr__54163 = cljs.core.deref(output_checker54129_55258);
return (fexpr__54163.cljs$core$IFn$_invoke$arity$1 ? fexpr__54163.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54163.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55286)){
var error__37898__auto___55289 = temp__5804__auto___55286;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schemas","member-schemas",-1535785960,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schemas of the given union schema."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55289], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54126_55255,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55289], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schemas),schema.core.__GT_FnSchema(output_schema54126_55255,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54127_55256], null)));

var ufv___55297 = schema.utils.use_fn_validation;
var output_schema54170_55298 = deercreeklabs.lancaster.LancasterSchema;
var input_schema54171_55299 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"union-schema","union-schema",1641054132,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"branch-index","branch-index",1034866665,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker54172_55300 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54171_55299);
}),null));
var output_checker54173_55301 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54170_55298);
}),null));
var ret__40195__auto___55303 = /**
 * Inputs: [union-schema :- LancasterSchema branch-index :- s/Int]
 *   Returns: LancasterSchema
 * 
 *   Returns the member schema at the given union schema branch index.
 */
deercreeklabs.lancaster.member_schema_at_branch = (function deercreeklabs$lancaster$member_schema_at_branch(G__54174,G__54175){
var validate__37896__auto__ = cljs.core.deref(ufv___55297);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55306 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54174,G__54175], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54188_55309 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54189_55310 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__54190_55311 = input_schema54171_55299;
var G__54191_55312 = cljs.core.deref(input_checker54172_55300);
var G__54192_55313 = args__37897__auto___55306;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54188_55309,G__54189_55310,G__54190_55311,G__54191_55312,G__54192_55313) : schema.core.fn_validator.call(null,G__54188_55309,G__54189_55310,G__54190_55311,G__54191_55312,G__54192_55313));
} else {
var temp__5804__auto___55316 = (function (){var fexpr__54202 = cljs.core.deref(input_checker54172_55300);
return (fexpr__54202.cljs$core$IFn$_invoke$arity$1 ? fexpr__54202.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55306) : fexpr__54202.call(null,args__37897__auto___55306));
})();
if(cljs.core.truth_(temp__5804__auto___55316)){
var error__37898__auto___55317 = temp__5804__auto___55316;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55317], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54171_55299,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55306,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55317], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var union_schema = G__54174;
var branch_index = G__54175;
while(true){
if((((!((union_schema == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === union_schema.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!union_schema.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,union_schema))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The first argument to `member-schema-at-branch` must ","satisfy the  ILancasterSchema protocol. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = union_schema;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),deercreeklabs.lancaster.utils.pprint_str(union_schema),new cljs.core.Keyword(null,"schema-type","schema-type",-1474759536),cljs.core.type(union_schema)], null));
}

if(cljs.core.int_QMARK_(branch_index)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The second argument to `member-schema-at-branch` must ","be an integer indicating the union branch index. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = branch_index;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "nil";
}
})()),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"branch-index","branch-index",-605664862),branch_index], null));
}

return deercreeklabs.lancaster.sub.member_schema_at_branch(union_schema,branch_index);
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54215_55325 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54216_55326 = cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null));
var G__54217_55327 = output_schema54170_55298;
var G__54218_55328 = cljs.core.deref(output_checker54173_55301);
var G__54219_55329 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54215_55325,G__54216_55326,G__54217_55327,G__54218_55328,G__54219_55329) : schema.core.fn_validator.call(null,G__54215_55325,G__54216_55326,G__54217_55327,G__54218_55328,G__54219_55329));
} else {
var temp__5804__auto___55330 = (function (){var fexpr__54220 = cljs.core.deref(output_checker54173_55301);
return (fexpr__54220.cljs$core$IFn$_invoke$arity$1 ? fexpr__54220.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54220.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55330)){
var error__37898__auto___55332 = temp__5804__auto___55330;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"member-schema-at-branch","member-schema-at-branch",-46643460,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the member schema at the given union schema branch index."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55332], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54170_55298,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55332], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.member_schema_at_branch),schema.core.__GT_FnSchema(output_schema54170_55298,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54171_55299], null)));

var ufv___55339 = schema.utils.use_fn_validation;
var output_schema54221_55340 = schema.core.Keyword;
var input_schema54222_55341 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.lancaster.LancasterSchema,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"LancasterSchema","LancasterSchema",-1424436567,null)], null)))], null);
var input_checker54223_55342 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema54222_55341);
}),null));
var output_checker54224_55343 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema54221_55340);
}),null));
var ret__40195__auto___55346 = /**
 * Inputs: [schema :- LancasterSchema]
 *   Returns: s/Keyword
 * 
 *   Returns the Avro type of the given schema
 */
deercreeklabs.lancaster.schema_type = (function deercreeklabs$lancaster$schema_type(G__54225){
var validate__37896__auto__ = cljs.core.deref(ufv___55339);
if(cljs.core.truth_(validate__37896__auto__)){
var args__37897__auto___55349 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__54225], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54226_55350 = new cljs.core.Keyword(null,"input","input",556931961);
var G__54227_55351 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__54228_55352 = input_schema54222_55341;
var G__54229_55353 = cljs.core.deref(input_checker54223_55342);
var G__54230_55354 = args__37897__auto___55349;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54226_55350,G__54227_55351,G__54228_55352,G__54229_55353,G__54230_55354) : schema.core.fn_validator.call(null,G__54226_55350,G__54227_55351,G__54228_55352,G__54229_55353,G__54230_55354));
} else {
var temp__5804__auto___55355 = (function (){var fexpr__54231 = cljs.core.deref(input_checker54223_55342);
return (fexpr__54231.cljs$core$IFn$_invoke$arity$1 ? fexpr__54231.cljs$core$IFn$_invoke$arity$1(args__37897__auto___55349) : fexpr__54231.call(null,args__37897__auto___55349));
})();
if(cljs.core.truth_(temp__5804__auto___55355)){
var error__37898__auto___55357 = temp__5804__auto___55355;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55357], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema54222_55341,new cljs.core.Keyword(null,"value","value",305978217),args__37897__auto___55349,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55357], null));
} else {
}
}
} else {
}

var o__37899__auto__ = (function (){var schema__$1 = G__54225;
while(true){
if((((!((schema__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.deercreeklabs$lancaster$utils$ILancasterSchema$))))?true:(((!schema__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1):false)):cljs.core.native_satisfies_QMARK_(deercreeklabs.lancaster.utils.ILancasterSchema,schema__$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Argument to `schema-type` must be a schema object. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(schema__$1),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"given-arg","given-arg",-1129212927),schema__$1], null));
}

return deercreeklabs.lancaster.utils.get_avro_type(deercreeklabs.lancaster.utils.edn_schema(schema__$1));
break;
}
})();
if(cljs.core.truth_(validate__37896__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__54237_55366 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__54238_55367 = cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null));
var G__54239_55368 = output_schema54221_55340;
var G__54240_55369 = cljs.core.deref(output_checker54224_55343);
var G__54241_55370 = o__37899__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__54237_55366,G__54238_55367,G__54239_55368,G__54240_55369,G__54241_55370) : schema.core.fn_validator.call(null,G__54237_55366,G__54238_55367,G__54239_55368,G__54240_55369,G__54241_55370));
} else {
var temp__5804__auto___55373 = (function (){var fexpr__54244 = cljs.core.deref(output_checker54224_55343);
return (fexpr__54244.cljs$core$IFn$_invoke$arity$1 ? fexpr__54244.cljs$core$IFn$_invoke$arity$1(o__37899__auto__) : fexpr__54244.call(null,o__37899__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___55373)){
var error__37898__auto___55376 = temp__5804__auto___55373;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"schema-type","schema-type",165771991,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Keyword","s/Keyword",-850066400,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the Avro type of the given schema"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37898__auto___55376], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema54221_55340,new cljs.core.Keyword(null,"value","value",305978217),o__37899__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37898__auto___55376], null));
} else {
}
}
} else {
}

return o__37899__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.lancaster.schema_type),schema.core.__GT_FnSchema(output_schema54221_55340,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema54222_55341], null)));

/**
 * Creates a Lancaster schema object representing a map of `int` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.int_map_schema = (function deercreeklabs$lancaster$int_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"int-map",deercreeklabs.lancaster.int_schema,values_schema,cljs.core.int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.long_map_schema = (function deercreeklabs$lancaster$long_map_schema(name_kw,values_schema){
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"long-map",deercreeklabs.lancaster.long_schema,values_schema,deercreeklabs.lancaster.utils.long_or_int_QMARK_);
});
/**
 * Creates a Lancaster schema object representing a map of `long` keys
 * to values described by the given `values-schema`.
 * Differs from map-schema, which only allows string keys.
 */
deercreeklabs.lancaster.fixed_map_schema = (function deercreeklabs$lancaster$fixed_map_schema(name_kw,key_size,values_schema){
if(cljs.core.nat_int_QMARK_(key_size)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Second argument to fixed-map-schema must be a ","positive integer. Got `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key_size),"`."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key-size","key-size",779633187),key_size], null));
}

var key_schema_name = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(name_kw),[cljs.core.name(name_kw),"-value"].join(''));
var key_schema = deercreeklabs.lancaster.fixed_schema(key_schema_name,key_size);
return deercreeklabs.lancaster.bilt.flex_map_schema(name_kw,"fixed-map",key_schema,values_schema,deercreeklabs.baracus.byte_array_QMARK_);
});
/**
 * Lancaster schema object representing a (possibly namespaced)
 * Clojure keyword.
 */
deercreeklabs.lancaster.keyword_schema = deercreeklabs.lancaster.bilt.keyword_schema;

//# sourceMappingURL=deercreeklabs.lancaster.js.map
