goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35738 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35738(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35739 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35739(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34547 = coll;
var G__34548 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34547,G__34548) : shadow.dom.lazy_native_coll_seq.call(null,G__34547,G__34548));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34584 = arguments.length;
switch (G__34584) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34590 = arguments.length;
switch (G__34590) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34603 = arguments.length;
switch (G__34603) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34635 = arguments.length;
switch (G__34635) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34696 = arguments.length;
switch (G__34696) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34731 = arguments.length;
switch (G__34731) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34748){if((e34748 instanceof Object)){
var e = e34748;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34748;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34761 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34762 = null;
var count__34763 = (0);
var i__34764 = (0);
while(true){
if((i__34764 < count__34763)){
var el = chunk__34762.cljs$core$IIndexed$_nth$arity$2(null,i__34764);
var handler_35826__$1 = ((function (seq__34761,chunk__34762,count__34763,i__34764,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34761,chunk__34762,count__34763,i__34764,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35826__$1);


var G__35828 = seq__34761;
var G__35829 = chunk__34762;
var G__35830 = count__34763;
var G__35831 = (i__34764 + (1));
seq__34761 = G__35828;
chunk__34762 = G__35829;
count__34763 = G__35830;
i__34764 = G__35831;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34761);
if(temp__5804__auto__){
var seq__34761__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34761__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34761__$1);
var G__35836 = cljs.core.chunk_rest(seq__34761__$1);
var G__35837 = c__5568__auto__;
var G__35838 = cljs.core.count(c__5568__auto__);
var G__35839 = (0);
seq__34761 = G__35836;
chunk__34762 = G__35837;
count__34763 = G__35838;
i__34764 = G__35839;
continue;
} else {
var el = cljs.core.first(seq__34761__$1);
var handler_35840__$1 = ((function (seq__34761,chunk__34762,count__34763,i__34764,el,seq__34761__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34761,chunk__34762,count__34763,i__34764,el,seq__34761__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35840__$1);


var G__35841 = cljs.core.next(seq__34761__$1);
var G__35842 = null;
var G__35843 = (0);
var G__35844 = (0);
seq__34761 = G__35841;
chunk__34762 = G__35842;
count__34763 = G__35843;
i__34764 = G__35844;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34790 = arguments.length;
switch (G__34790) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34802 = cljs.core.seq(events);
var chunk__34803 = null;
var count__34804 = (0);
var i__34805 = (0);
while(true){
if((i__34805 < count__34804)){
var vec__34822 = chunk__34803.cljs$core$IIndexed$_nth$arity$2(null,i__34805);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34822,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34822,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35850 = seq__34802;
var G__35851 = chunk__34803;
var G__35852 = count__34804;
var G__35853 = (i__34805 + (1));
seq__34802 = G__35850;
chunk__34803 = G__35851;
count__34804 = G__35852;
i__34805 = G__35853;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34802);
if(temp__5804__auto__){
var seq__34802__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34802__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34802__$1);
var G__35855 = cljs.core.chunk_rest(seq__34802__$1);
var G__35856 = c__5568__auto__;
var G__35857 = cljs.core.count(c__5568__auto__);
var G__35858 = (0);
seq__34802 = G__35855;
chunk__34803 = G__35856;
count__34804 = G__35857;
i__34805 = G__35858;
continue;
} else {
var vec__34828 = cljs.core.first(seq__34802__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34828,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34828,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35861 = cljs.core.next(seq__34802__$1);
var G__35862 = null;
var G__35863 = (0);
var G__35864 = (0);
seq__34802 = G__35861;
chunk__34803 = G__35862;
count__34804 = G__35863;
i__34805 = G__35864;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34836 = cljs.core.seq(styles);
var chunk__34837 = null;
var count__34838 = (0);
var i__34839 = (0);
while(true){
if((i__34839 < count__34838)){
var vec__34855 = chunk__34837.cljs$core$IIndexed$_nth$arity$2(null,i__34839);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34855,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34855,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35866 = seq__34836;
var G__35867 = chunk__34837;
var G__35868 = count__34838;
var G__35869 = (i__34839 + (1));
seq__34836 = G__35866;
chunk__34837 = G__35867;
count__34838 = G__35868;
i__34839 = G__35869;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34836);
if(temp__5804__auto__){
var seq__34836__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34836__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34836__$1);
var G__35870 = cljs.core.chunk_rest(seq__34836__$1);
var G__35871 = c__5568__auto__;
var G__35872 = cljs.core.count(c__5568__auto__);
var G__35873 = (0);
seq__34836 = G__35870;
chunk__34837 = G__35871;
count__34838 = G__35872;
i__34839 = G__35873;
continue;
} else {
var vec__34862 = cljs.core.first(seq__34836__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34862,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34862,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35878 = cljs.core.next(seq__34836__$1);
var G__35879 = null;
var G__35880 = (0);
var G__35881 = (0);
seq__34836 = G__35878;
chunk__34837 = G__35879;
count__34838 = G__35880;
i__34839 = G__35881;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34869_35883 = key;
var G__34869_35884__$1 = (((G__34869_35883 instanceof cljs.core.Keyword))?G__34869_35883.fqn:null);
switch (G__34869_35884__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35887 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35887,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35887,"aria-");
}
})())){
el.setAttribute(ks_35887,value);
} else {
(el[ks_35887] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34895){
var map__34896 = p__34895;
var map__34896__$1 = cljs.core.__destructure_map(map__34896);
var props = map__34896__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34896__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34898 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34898,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34898,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34898,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34901 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34901,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34901;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34911 = arguments.length;
switch (G__34911) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34919){
var vec__34920 = p__34919;
var seq__34921 = cljs.core.seq(vec__34920);
var first__34922 = cljs.core.first(seq__34921);
var seq__34921__$1 = cljs.core.next(seq__34921);
var nn = first__34922;
var first__34922__$1 = cljs.core.first(seq__34921__$1);
var seq__34921__$2 = cljs.core.next(seq__34921__$1);
var np = first__34922__$1;
var nc = seq__34921__$2;
var node = vec__34920;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34926 = nn;
var G__34927 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34926,G__34927) : create_fn.call(null,G__34926,G__34927));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34928 = nn;
var G__34929 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34928,G__34929) : create_fn.call(null,G__34928,G__34929));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34934 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34934,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34934,(1),null);
var seq__34937_35897 = cljs.core.seq(node_children);
var chunk__34938_35898 = null;
var count__34939_35899 = (0);
var i__34940_35900 = (0);
while(true){
if((i__34940_35900 < count__34939_35899)){
var child_struct_35903 = chunk__34938_35898.cljs$core$IIndexed$_nth$arity$2(null,i__34940_35900);
var children_35904 = shadow.dom.dom_node(child_struct_35903);
if(cljs.core.seq_QMARK_(children_35904)){
var seq__34983_35907 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35904));
var chunk__34985_35908 = null;
var count__34986_35909 = (0);
var i__34987_35910 = (0);
while(true){
if((i__34987_35910 < count__34986_35909)){
var child_35911 = chunk__34985_35908.cljs$core$IIndexed$_nth$arity$2(null,i__34987_35910);
if(cljs.core.truth_(child_35911)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35911);


var G__35912 = seq__34983_35907;
var G__35913 = chunk__34985_35908;
var G__35914 = count__34986_35909;
var G__35915 = (i__34987_35910 + (1));
seq__34983_35907 = G__35912;
chunk__34985_35908 = G__35913;
count__34986_35909 = G__35914;
i__34987_35910 = G__35915;
continue;
} else {
var G__35916 = seq__34983_35907;
var G__35917 = chunk__34985_35908;
var G__35918 = count__34986_35909;
var G__35919 = (i__34987_35910 + (1));
seq__34983_35907 = G__35916;
chunk__34985_35908 = G__35917;
count__34986_35909 = G__35918;
i__34987_35910 = G__35919;
continue;
}
} else {
var temp__5804__auto___35920 = cljs.core.seq(seq__34983_35907);
if(temp__5804__auto___35920){
var seq__34983_35921__$1 = temp__5804__auto___35920;
if(cljs.core.chunked_seq_QMARK_(seq__34983_35921__$1)){
var c__5568__auto___35922 = cljs.core.chunk_first(seq__34983_35921__$1);
var G__35923 = cljs.core.chunk_rest(seq__34983_35921__$1);
var G__35924 = c__5568__auto___35922;
var G__35925 = cljs.core.count(c__5568__auto___35922);
var G__35926 = (0);
seq__34983_35907 = G__35923;
chunk__34985_35908 = G__35924;
count__34986_35909 = G__35925;
i__34987_35910 = G__35926;
continue;
} else {
var child_35927 = cljs.core.first(seq__34983_35921__$1);
if(cljs.core.truth_(child_35927)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35927);


var G__35928 = cljs.core.next(seq__34983_35921__$1);
var G__35929 = null;
var G__35930 = (0);
var G__35931 = (0);
seq__34983_35907 = G__35928;
chunk__34985_35908 = G__35929;
count__34986_35909 = G__35930;
i__34987_35910 = G__35931;
continue;
} else {
var G__35934 = cljs.core.next(seq__34983_35921__$1);
var G__35935 = null;
var G__35936 = (0);
var G__35937 = (0);
seq__34983_35907 = G__35934;
chunk__34985_35908 = G__35935;
count__34986_35909 = G__35936;
i__34987_35910 = G__35937;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35904);
}


var G__35940 = seq__34937_35897;
var G__35941 = chunk__34938_35898;
var G__35942 = count__34939_35899;
var G__35943 = (i__34940_35900 + (1));
seq__34937_35897 = G__35940;
chunk__34938_35898 = G__35941;
count__34939_35899 = G__35942;
i__34940_35900 = G__35943;
continue;
} else {
var temp__5804__auto___35944 = cljs.core.seq(seq__34937_35897);
if(temp__5804__auto___35944){
var seq__34937_35945__$1 = temp__5804__auto___35944;
if(cljs.core.chunked_seq_QMARK_(seq__34937_35945__$1)){
var c__5568__auto___35946 = cljs.core.chunk_first(seq__34937_35945__$1);
var G__35947 = cljs.core.chunk_rest(seq__34937_35945__$1);
var G__35948 = c__5568__auto___35946;
var G__35949 = cljs.core.count(c__5568__auto___35946);
var G__35950 = (0);
seq__34937_35897 = G__35947;
chunk__34938_35898 = G__35948;
count__34939_35899 = G__35949;
i__34940_35900 = G__35950;
continue;
} else {
var child_struct_35951 = cljs.core.first(seq__34937_35945__$1);
var children_35952 = shadow.dom.dom_node(child_struct_35951);
if(cljs.core.seq_QMARK_(children_35952)){
var seq__35006_35953 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35952));
var chunk__35008_35954 = null;
var count__35009_35955 = (0);
var i__35010_35956 = (0);
while(true){
if((i__35010_35956 < count__35009_35955)){
var child_35957 = chunk__35008_35954.cljs$core$IIndexed$_nth$arity$2(null,i__35010_35956);
if(cljs.core.truth_(child_35957)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35957);


var G__35958 = seq__35006_35953;
var G__35959 = chunk__35008_35954;
var G__35960 = count__35009_35955;
var G__35961 = (i__35010_35956 + (1));
seq__35006_35953 = G__35958;
chunk__35008_35954 = G__35959;
count__35009_35955 = G__35960;
i__35010_35956 = G__35961;
continue;
} else {
var G__35962 = seq__35006_35953;
var G__35963 = chunk__35008_35954;
var G__35964 = count__35009_35955;
var G__35965 = (i__35010_35956 + (1));
seq__35006_35953 = G__35962;
chunk__35008_35954 = G__35963;
count__35009_35955 = G__35964;
i__35010_35956 = G__35965;
continue;
}
} else {
var temp__5804__auto___35966__$1 = cljs.core.seq(seq__35006_35953);
if(temp__5804__auto___35966__$1){
var seq__35006_35967__$1 = temp__5804__auto___35966__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35006_35967__$1)){
var c__5568__auto___35968 = cljs.core.chunk_first(seq__35006_35967__$1);
var G__35969 = cljs.core.chunk_rest(seq__35006_35967__$1);
var G__35970 = c__5568__auto___35968;
var G__35971 = cljs.core.count(c__5568__auto___35968);
var G__35972 = (0);
seq__35006_35953 = G__35969;
chunk__35008_35954 = G__35970;
count__35009_35955 = G__35971;
i__35010_35956 = G__35972;
continue;
} else {
var child_35973 = cljs.core.first(seq__35006_35967__$1);
if(cljs.core.truth_(child_35973)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35973);


var G__35974 = cljs.core.next(seq__35006_35967__$1);
var G__35975 = null;
var G__35976 = (0);
var G__35977 = (0);
seq__35006_35953 = G__35974;
chunk__35008_35954 = G__35975;
count__35009_35955 = G__35976;
i__35010_35956 = G__35977;
continue;
} else {
var G__35978 = cljs.core.next(seq__35006_35967__$1);
var G__35979 = null;
var G__35980 = (0);
var G__35981 = (0);
seq__35006_35953 = G__35978;
chunk__35008_35954 = G__35979;
count__35009_35955 = G__35980;
i__35010_35956 = G__35981;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35952);
}


var G__35982 = cljs.core.next(seq__34937_35945__$1);
var G__35983 = null;
var G__35984 = (0);
var G__35985 = (0);
seq__34937_35897 = G__35982;
chunk__34938_35898 = G__35983;
count__34939_35899 = G__35984;
i__34940_35900 = G__35985;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__35033 = cljs.core.seq(node);
var chunk__35034 = null;
var count__35035 = (0);
var i__35036 = (0);
while(true){
if((i__35036 < count__35035)){
var n = chunk__35034.cljs$core$IIndexed$_nth$arity$2(null,i__35036);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35986 = seq__35033;
var G__35987 = chunk__35034;
var G__35988 = count__35035;
var G__35989 = (i__35036 + (1));
seq__35033 = G__35986;
chunk__35034 = G__35987;
count__35035 = G__35988;
i__35036 = G__35989;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__35033);
if(temp__5804__auto__){
var seq__35033__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35033__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__35033__$1);
var G__35990 = cljs.core.chunk_rest(seq__35033__$1);
var G__35991 = c__5568__auto__;
var G__35992 = cljs.core.count(c__5568__auto__);
var G__35993 = (0);
seq__35033 = G__35990;
chunk__35034 = G__35991;
count__35035 = G__35992;
i__35036 = G__35993;
continue;
} else {
var n = cljs.core.first(seq__35033__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35994 = cljs.core.next(seq__35033__$1);
var G__35995 = null;
var G__35996 = (0);
var G__35997 = (0);
seq__35033 = G__35994;
chunk__35034 = G__35995;
count__35035 = G__35996;
i__35036 = G__35997;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__35041 = arguments.length;
switch (G__35041) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__35069 = arguments.length;
switch (G__35069) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__35103 = arguments.length;
switch (G__35103) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36004 = arguments.length;
var i__5770__auto___36005 = (0);
while(true){
if((i__5770__auto___36005 < len__5769__auto___36004)){
args__5775__auto__.push((arguments[i__5770__auto___36005]));

var G__36006 = (i__5770__auto___36005 + (1));
i__5770__auto___36005 = G__36006;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__35164_36007 = cljs.core.seq(nodes);
var chunk__35166_36008 = null;
var count__35167_36009 = (0);
var i__35168_36010 = (0);
while(true){
if((i__35168_36010 < count__35167_36009)){
var node_36011 = chunk__35166_36008.cljs$core$IIndexed$_nth$arity$2(null,i__35168_36010);
fragment.appendChild(shadow.dom._to_dom(node_36011));


var G__36012 = seq__35164_36007;
var G__36013 = chunk__35166_36008;
var G__36014 = count__35167_36009;
var G__36015 = (i__35168_36010 + (1));
seq__35164_36007 = G__36012;
chunk__35166_36008 = G__36013;
count__35167_36009 = G__36014;
i__35168_36010 = G__36015;
continue;
} else {
var temp__5804__auto___36016 = cljs.core.seq(seq__35164_36007);
if(temp__5804__auto___36016){
var seq__35164_36017__$1 = temp__5804__auto___36016;
if(cljs.core.chunked_seq_QMARK_(seq__35164_36017__$1)){
var c__5568__auto___36018 = cljs.core.chunk_first(seq__35164_36017__$1);
var G__36019 = cljs.core.chunk_rest(seq__35164_36017__$1);
var G__36020 = c__5568__auto___36018;
var G__36021 = cljs.core.count(c__5568__auto___36018);
var G__36022 = (0);
seq__35164_36007 = G__36019;
chunk__35166_36008 = G__36020;
count__35167_36009 = G__36021;
i__35168_36010 = G__36022;
continue;
} else {
var node_36023 = cljs.core.first(seq__35164_36017__$1);
fragment.appendChild(shadow.dom._to_dom(node_36023));


var G__36024 = cljs.core.next(seq__35164_36017__$1);
var G__36025 = null;
var G__36026 = (0);
var G__36027 = (0);
seq__35164_36007 = G__36024;
chunk__35166_36008 = G__36025;
count__35167_36009 = G__36026;
i__35168_36010 = G__36027;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq35127){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35127));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__35207_36028 = cljs.core.seq(scripts);
var chunk__35208_36029 = null;
var count__35209_36030 = (0);
var i__35210_36031 = (0);
while(true){
if((i__35210_36031 < count__35209_36030)){
var vec__35220_36033 = chunk__35208_36029.cljs$core$IIndexed$_nth$arity$2(null,i__35210_36031);
var script_tag_36034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35220_36033,(0),null);
var script_body_36035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35220_36033,(1),null);
eval(script_body_36035);


var G__36037 = seq__35207_36028;
var G__36038 = chunk__35208_36029;
var G__36039 = count__35209_36030;
var G__36040 = (i__35210_36031 + (1));
seq__35207_36028 = G__36037;
chunk__35208_36029 = G__36038;
count__35209_36030 = G__36039;
i__35210_36031 = G__36040;
continue;
} else {
var temp__5804__auto___36041 = cljs.core.seq(seq__35207_36028);
if(temp__5804__auto___36041){
var seq__35207_36042__$1 = temp__5804__auto___36041;
if(cljs.core.chunked_seq_QMARK_(seq__35207_36042__$1)){
var c__5568__auto___36043 = cljs.core.chunk_first(seq__35207_36042__$1);
var G__36044 = cljs.core.chunk_rest(seq__35207_36042__$1);
var G__36045 = c__5568__auto___36043;
var G__36046 = cljs.core.count(c__5568__auto___36043);
var G__36047 = (0);
seq__35207_36028 = G__36044;
chunk__35208_36029 = G__36045;
count__35209_36030 = G__36046;
i__35210_36031 = G__36047;
continue;
} else {
var vec__35223_36048 = cljs.core.first(seq__35207_36042__$1);
var script_tag_36049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35223_36048,(0),null);
var script_body_36050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35223_36048,(1),null);
eval(script_body_36050);


var G__36051 = cljs.core.next(seq__35207_36042__$1);
var G__36052 = null;
var G__36053 = (0);
var G__36054 = (0);
seq__35207_36028 = G__36051;
chunk__35208_36029 = G__36052;
count__35209_36030 = G__36053;
i__35210_36031 = G__36054;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__35227){
var vec__35229 = p__35227;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35229,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35229,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35266 = arguments.length;
switch (G__35266) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35291 = cljs.core.seq(style_keys);
var chunk__35292 = null;
var count__35293 = (0);
var i__35294 = (0);
while(true){
if((i__35294 < count__35293)){
var it = chunk__35292.cljs$core$IIndexed$_nth$arity$2(null,i__35294);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36057 = seq__35291;
var G__36058 = chunk__35292;
var G__36059 = count__35293;
var G__36060 = (i__35294 + (1));
seq__35291 = G__36057;
chunk__35292 = G__36058;
count__35293 = G__36059;
i__35294 = G__36060;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__35291);
if(temp__5804__auto__){
var seq__35291__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35291__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__35291__$1);
var G__36061 = cljs.core.chunk_rest(seq__35291__$1);
var G__36062 = c__5568__auto__;
var G__36063 = cljs.core.count(c__5568__auto__);
var G__36064 = (0);
seq__35291 = G__36061;
chunk__35292 = G__36062;
count__35293 = G__36063;
i__35294 = G__36064;
continue;
} else {
var it = cljs.core.first(seq__35291__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36065 = cljs.core.next(seq__35291__$1);
var G__36066 = null;
var G__36067 = (0);
var G__36068 = (0);
seq__35291 = G__36065;
chunk__35292 = G__36066;
count__35293 = G__36067;
i__35294 = G__36068;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35312,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35328 = k35312;
var G__35328__$1 = (((G__35328 instanceof cljs.core.Keyword))?G__35328.fqn:null);
switch (G__35328__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35312,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35329){
var vec__35330 = p__35329;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35330,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35330,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35311){
var self__ = this;
var G__35311__$1 = this;
return (new cljs.core.RecordIter((0),G__35311__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35314,other35315){
var self__ = this;
var this35314__$1 = this;
return (((!((other35315 == null)))) && ((((this35314__$1.constructor === other35315.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35314__$1.x,other35315.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35314__$1.y,other35315.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35314__$1.__extmap,other35315.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35312){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35352 = k35312;
var G__35352__$1 = (((G__35352 instanceof cljs.core.Keyword))?G__35352.fqn:null);
switch (G__35352__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35312);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35311){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35355 = cljs.core.keyword_identical_QMARK_;
var expr__35356 = k__5352__auto__;
if(cljs.core.truth_((pred__35355.cljs$core$IFn$_invoke$arity$2 ? pred__35355.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35356) : pred__35355.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35356)))){
return (new shadow.dom.Coordinate(G__35311,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35355.cljs$core$IFn$_invoke$arity$2 ? pred__35355.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35356) : pred__35355.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35356)))){
return (new shadow.dom.Coordinate(self__.x,G__35311,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35311),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35311){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35311,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35318){
var extmap__5385__auto__ = (function (){var G__35398 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35318,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__35318)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35398);
} else {
return G__35398;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35318),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35318),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k35418,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__35440 = k35418;
var G__35440__$1 = (((G__35440 instanceof cljs.core.Keyword))?G__35440.fqn:null);
switch (G__35440__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35418,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__35455){
var vec__35457 = p__35455;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35457,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35457,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35417){
var self__ = this;
var G__35417__$1 = this;
return (new cljs.core.RecordIter((0),G__35417__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35419,other35420){
var self__ = this;
var this35419__$1 = this;
return (((!((other35420 == null)))) && ((((this35419__$1.constructor === other35420.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35419__$1.w,other35420.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35419__$1.h,other35420.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35419__$1.__extmap,other35420.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k35418){
var self__ = this;
var this__5350__auto____$1 = this;
var G__35519 = k35418;
var G__35519__$1 = (((G__35519 instanceof cljs.core.Keyword))?G__35519.fqn:null);
switch (G__35519__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35418);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__35417){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__35527 = cljs.core.keyword_identical_QMARK_;
var expr__35528 = k__5352__auto__;
if(cljs.core.truth_((pred__35527.cljs$core$IFn$_invoke$arity$2 ? pred__35527.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35528) : pred__35527.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35528)))){
return (new shadow.dom.Size(G__35417,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35527.cljs$core$IFn$_invoke$arity$2 ? pred__35527.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35528) : pred__35527.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35528)))){
return (new shadow.dom.Size(self__.w,G__35417,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__35417),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__35417){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35417,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35426){
var extmap__5385__auto__ = (function (){var G__35546 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35426,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35426)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35546);
} else {
return G__35546;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35426),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35426),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__36129 = (i + (1));
var G__36130 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__36129;
ret = G__36130;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35565){
var vec__35566 = p__35565;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35566,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35566,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35576 = arguments.length;
switch (G__35576) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__36151 = ps;
var G__36152 = (i + (1));
el__$1 = G__36151;
i = G__36152;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35588 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35588,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35588,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35588,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35591_36166 = cljs.core.seq(props);
var chunk__35592_36167 = null;
var count__35593_36168 = (0);
var i__35594_36169 = (0);
while(true){
if((i__35594_36169 < count__35593_36168)){
var vec__35608_36170 = chunk__35592_36167.cljs$core$IIndexed$_nth$arity$2(null,i__35594_36169);
var k_36171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35608_36170,(0),null);
var v_36172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35608_36170,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_36171);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36171),v_36172);


var G__36177 = seq__35591_36166;
var G__36178 = chunk__35592_36167;
var G__36179 = count__35593_36168;
var G__36180 = (i__35594_36169 + (1));
seq__35591_36166 = G__36177;
chunk__35592_36167 = G__36178;
count__35593_36168 = G__36179;
i__35594_36169 = G__36180;
continue;
} else {
var temp__5804__auto___36181 = cljs.core.seq(seq__35591_36166);
if(temp__5804__auto___36181){
var seq__35591_36182__$1 = temp__5804__auto___36181;
if(cljs.core.chunked_seq_QMARK_(seq__35591_36182__$1)){
var c__5568__auto___36189 = cljs.core.chunk_first(seq__35591_36182__$1);
var G__36190 = cljs.core.chunk_rest(seq__35591_36182__$1);
var G__36191 = c__5568__auto___36189;
var G__36192 = cljs.core.count(c__5568__auto___36189);
var G__36193 = (0);
seq__35591_36166 = G__36190;
chunk__35592_36167 = G__36191;
count__35593_36168 = G__36192;
i__35594_36169 = G__36193;
continue;
} else {
var vec__35611_36194 = cljs.core.first(seq__35591_36182__$1);
var k_36195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35611_36194,(0),null);
var v_36196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35611_36194,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_36195);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_36195),v_36196);


var G__36200 = cljs.core.next(seq__35591_36182__$1);
var G__36201 = null;
var G__36202 = (0);
var G__36203 = (0);
seq__35591_36166 = G__36200;
chunk__35592_36167 = G__36201;
count__35593_36168 = G__36202;
i__35594_36169 = G__36203;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35619 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35619,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35619,(1),null);
var seq__35622_36220 = cljs.core.seq(node_children);
var chunk__35624_36221 = null;
var count__35625_36222 = (0);
var i__35626_36223 = (0);
while(true){
if((i__35626_36223 < count__35625_36222)){
var child_struct_36230 = chunk__35624_36221.cljs$core$IIndexed$_nth$arity$2(null,i__35626_36223);
if((!((child_struct_36230 == null)))){
if(typeof child_struct_36230 === 'string'){
var text_36231 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36231),child_struct_36230].join(''));
} else {
var children_36232 = shadow.dom.svg_node(child_struct_36230);
if(cljs.core.seq_QMARK_(children_36232)){
var seq__35651_36233 = cljs.core.seq(children_36232);
var chunk__35653_36234 = null;
var count__35654_36235 = (0);
var i__35655_36236 = (0);
while(true){
if((i__35655_36236 < count__35654_36235)){
var child_36237 = chunk__35653_36234.cljs$core$IIndexed$_nth$arity$2(null,i__35655_36236);
if(cljs.core.truth_(child_36237)){
node.appendChild(child_36237);


var G__36240 = seq__35651_36233;
var G__36241 = chunk__35653_36234;
var G__36242 = count__35654_36235;
var G__36243 = (i__35655_36236 + (1));
seq__35651_36233 = G__36240;
chunk__35653_36234 = G__36241;
count__35654_36235 = G__36242;
i__35655_36236 = G__36243;
continue;
} else {
var G__36248 = seq__35651_36233;
var G__36249 = chunk__35653_36234;
var G__36250 = count__35654_36235;
var G__36251 = (i__35655_36236 + (1));
seq__35651_36233 = G__36248;
chunk__35653_36234 = G__36249;
count__35654_36235 = G__36250;
i__35655_36236 = G__36251;
continue;
}
} else {
var temp__5804__auto___36252 = cljs.core.seq(seq__35651_36233);
if(temp__5804__auto___36252){
var seq__35651_36253__$1 = temp__5804__auto___36252;
if(cljs.core.chunked_seq_QMARK_(seq__35651_36253__$1)){
var c__5568__auto___36254 = cljs.core.chunk_first(seq__35651_36253__$1);
var G__36255 = cljs.core.chunk_rest(seq__35651_36253__$1);
var G__36256 = c__5568__auto___36254;
var G__36257 = cljs.core.count(c__5568__auto___36254);
var G__36258 = (0);
seq__35651_36233 = G__36255;
chunk__35653_36234 = G__36256;
count__35654_36235 = G__36257;
i__35655_36236 = G__36258;
continue;
} else {
var child_36259 = cljs.core.first(seq__35651_36253__$1);
if(cljs.core.truth_(child_36259)){
node.appendChild(child_36259);


var G__36260 = cljs.core.next(seq__35651_36253__$1);
var G__36261 = null;
var G__36262 = (0);
var G__36263 = (0);
seq__35651_36233 = G__36260;
chunk__35653_36234 = G__36261;
count__35654_36235 = G__36262;
i__35655_36236 = G__36263;
continue;
} else {
var G__36264 = cljs.core.next(seq__35651_36253__$1);
var G__36265 = null;
var G__36266 = (0);
var G__36267 = (0);
seq__35651_36233 = G__36264;
chunk__35653_36234 = G__36265;
count__35654_36235 = G__36266;
i__35655_36236 = G__36267;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36232);
}
}


var G__36268 = seq__35622_36220;
var G__36269 = chunk__35624_36221;
var G__36270 = count__35625_36222;
var G__36271 = (i__35626_36223 + (1));
seq__35622_36220 = G__36268;
chunk__35624_36221 = G__36269;
count__35625_36222 = G__36270;
i__35626_36223 = G__36271;
continue;
} else {
var G__36272 = seq__35622_36220;
var G__36273 = chunk__35624_36221;
var G__36274 = count__35625_36222;
var G__36275 = (i__35626_36223 + (1));
seq__35622_36220 = G__36272;
chunk__35624_36221 = G__36273;
count__35625_36222 = G__36274;
i__35626_36223 = G__36275;
continue;
}
} else {
var temp__5804__auto___36276 = cljs.core.seq(seq__35622_36220);
if(temp__5804__auto___36276){
var seq__35622_36277__$1 = temp__5804__auto___36276;
if(cljs.core.chunked_seq_QMARK_(seq__35622_36277__$1)){
var c__5568__auto___36278 = cljs.core.chunk_first(seq__35622_36277__$1);
var G__36279 = cljs.core.chunk_rest(seq__35622_36277__$1);
var G__36280 = c__5568__auto___36278;
var G__36281 = cljs.core.count(c__5568__auto___36278);
var G__36282 = (0);
seq__35622_36220 = G__36279;
chunk__35624_36221 = G__36280;
count__35625_36222 = G__36281;
i__35626_36223 = G__36282;
continue;
} else {
var child_struct_36286 = cljs.core.first(seq__35622_36277__$1);
if((!((child_struct_36286 == null)))){
if(typeof child_struct_36286 === 'string'){
var text_36287 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_36287),child_struct_36286].join(''));
} else {
var children_36288 = shadow.dom.svg_node(child_struct_36286);
if(cljs.core.seq_QMARK_(children_36288)){
var seq__35664_36289 = cljs.core.seq(children_36288);
var chunk__35666_36290 = null;
var count__35667_36291 = (0);
var i__35668_36292 = (0);
while(true){
if((i__35668_36292 < count__35667_36291)){
var child_36293 = chunk__35666_36290.cljs$core$IIndexed$_nth$arity$2(null,i__35668_36292);
if(cljs.core.truth_(child_36293)){
node.appendChild(child_36293);


var G__36294 = seq__35664_36289;
var G__36295 = chunk__35666_36290;
var G__36296 = count__35667_36291;
var G__36297 = (i__35668_36292 + (1));
seq__35664_36289 = G__36294;
chunk__35666_36290 = G__36295;
count__35667_36291 = G__36296;
i__35668_36292 = G__36297;
continue;
} else {
var G__36298 = seq__35664_36289;
var G__36299 = chunk__35666_36290;
var G__36300 = count__35667_36291;
var G__36301 = (i__35668_36292 + (1));
seq__35664_36289 = G__36298;
chunk__35666_36290 = G__36299;
count__35667_36291 = G__36300;
i__35668_36292 = G__36301;
continue;
}
} else {
var temp__5804__auto___36302__$1 = cljs.core.seq(seq__35664_36289);
if(temp__5804__auto___36302__$1){
var seq__35664_36303__$1 = temp__5804__auto___36302__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35664_36303__$1)){
var c__5568__auto___36304 = cljs.core.chunk_first(seq__35664_36303__$1);
var G__36305 = cljs.core.chunk_rest(seq__35664_36303__$1);
var G__36306 = c__5568__auto___36304;
var G__36307 = cljs.core.count(c__5568__auto___36304);
var G__36308 = (0);
seq__35664_36289 = G__36305;
chunk__35666_36290 = G__36306;
count__35667_36291 = G__36307;
i__35668_36292 = G__36308;
continue;
} else {
var child_36309 = cljs.core.first(seq__35664_36303__$1);
if(cljs.core.truth_(child_36309)){
node.appendChild(child_36309);


var G__36310 = cljs.core.next(seq__35664_36303__$1);
var G__36311 = null;
var G__36312 = (0);
var G__36313 = (0);
seq__35664_36289 = G__36310;
chunk__35666_36290 = G__36311;
count__35667_36291 = G__36312;
i__35668_36292 = G__36313;
continue;
} else {
var G__36314 = cljs.core.next(seq__35664_36303__$1);
var G__36315 = null;
var G__36316 = (0);
var G__36317 = (0);
seq__35664_36289 = G__36314;
chunk__35666_36290 = G__36315;
count__35667_36291 = G__36316;
i__35668_36292 = G__36317;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_36288);
}
}


var G__36318 = cljs.core.next(seq__35622_36277__$1);
var G__36319 = null;
var G__36320 = (0);
var G__36321 = (0);
seq__35622_36220 = G__36318;
chunk__35624_36221 = G__36319;
count__35625_36222 = G__36320;
i__35626_36223 = G__36321;
continue;
} else {
var G__36322 = cljs.core.next(seq__35622_36277__$1);
var G__36323 = null;
var G__36324 = (0);
var G__36325 = (0);
seq__35622_36220 = G__36322;
chunk__35624_36221 = G__36323;
count__35625_36222 = G__36324;
i__35626_36223 = G__36325;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36330 = arguments.length;
var i__5770__auto___36334 = (0);
while(true){
if((i__5770__auto___36334 < len__5769__auto___36330)){
args__5775__auto__.push((arguments[i__5770__auto___36334]));

var G__36335 = (i__5770__auto___36334 + (1));
i__5770__auto___36334 = G__36335;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35676){
var G__35677 = cljs.core.first(seq35676);
var seq35676__$1 = cljs.core.next(seq35676);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35677,seq35676__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35691 = arguments.length;
switch (G__35691) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30974__auto___36338 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30975__auto__ = (function (){var switch__30602__auto__ = (function (state_35711){
var state_val_35712 = (state_35711[(1)]);
if((state_val_35712 === (1))){
var state_35711__$1 = state_35711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35711__$1,(2),once_or_cleanup);
} else {
if((state_val_35712 === (2))){
var inst_35708 = (state_35711[(2)]);
var inst_35709 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35711__$1 = (function (){var statearr_35715 = state_35711;
(statearr_35715[(7)] = inst_35708);

return statearr_35715;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35711__$1,inst_35709);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__30603__auto__ = null;
var shadow$dom$state_machine__30603__auto____0 = (function (){
var statearr_35716 = [null,null,null,null,null,null,null,null];
(statearr_35716[(0)] = shadow$dom$state_machine__30603__auto__);

(statearr_35716[(1)] = (1));

return statearr_35716;
});
var shadow$dom$state_machine__30603__auto____1 = (function (state_35711){
while(true){
var ret_value__30604__auto__ = (function (){try{while(true){
var result__30605__auto__ = switch__30602__auto__(state_35711);
if(cljs.core.keyword_identical_QMARK_(result__30605__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30605__auto__;
}
break;
}
}catch (e35717){var ex__30606__auto__ = e35717;
var statearr_35718_36343 = state_35711;
(statearr_35718_36343[(2)] = ex__30606__auto__);


if(cljs.core.seq((state_35711[(4)]))){
var statearr_35719_36344 = state_35711;
(statearr_35719_36344[(1)] = cljs.core.first((state_35711[(4)])));

} else {
throw ex__30606__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30604__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36345 = state_35711;
state_35711 = G__36345;
continue;
} else {
return ret_value__30604__auto__;
}
break;
}
});
shadow$dom$state_machine__30603__auto__ = function(state_35711){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__30603__auto____0.call(this);
case 1:
return shadow$dom$state_machine__30603__auto____1.call(this,state_35711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__30603__auto____0;
shadow$dom$state_machine__30603__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__30603__auto____1;
return shadow$dom$state_machine__30603__auto__;
})()
})();
var state__30976__auto__ = (function (){var statearr_35720 = f__30975__auto__();
(statearr_35720[(6)] = c__30974__auto___36338);

return statearr_35720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30976__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
