goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__56435){
var vec__56437 = p__56435;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56437,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56437,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__56442 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__56442__$1 = (((G__56442 instanceof cljs.core.Keyword))?G__56442.fqn:null);
switch (G__56442__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__56447 = (function (){
var seq__56448 = cljs.core.seq(vars__$1);
var chunk__56449 = null;
var count__56450 = (0);
var i__56451 = (0);
while(true){
if((i__56451 < count__56450)){
var v = chunk__56449.cljs$core$IIndexed$_nth$arity$2(null,i__56451);
var temp__5804__auto___56871 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56871)){
var t_56872 = temp__5804__auto___56871;
var G__56454_56873 = ((function (seq__56448,chunk__56449,count__56450,i__56451,t_56872,temp__5804__auto___56871,v,each_fixture_fn,G__56442,G__56442__$1,env,once_fixtures,each_fixtures,vec__56437,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56872)));
});})(seq__56448,chunk__56449,count__56450,i__56451,t_56872,temp__5804__auto___56871,v,each_fixture_fn,G__56442,G__56442__$1,env,once_fixtures,each_fixtures,vec__56437,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56454_56873) : each_fixture_fn.call(null,G__56454_56873));
} else {
}


var G__56876 = seq__56448;
var G__56878 = chunk__56449;
var G__56879 = count__56450;
var G__56880 = (i__56451 + (1));
seq__56448 = G__56876;
chunk__56449 = G__56878;
count__56450 = G__56879;
i__56451 = G__56880;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__56448);
if(temp__5804__auto__){
var seq__56448__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56448__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__56448__$1);
var G__56881 = cljs.core.chunk_rest(seq__56448__$1);
var G__56882 = c__5568__auto__;
var G__56883 = cljs.core.count(c__5568__auto__);
var G__56884 = (0);
seq__56448 = G__56881;
chunk__56449 = G__56882;
count__56450 = G__56883;
i__56451 = G__56884;
continue;
} else {
var v = cljs.core.first(seq__56448__$1);
var temp__5804__auto___56886__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56886__$1)){
var t_56887 = temp__5804__auto___56886__$1;
var G__56460_56888 = ((function (seq__56448,chunk__56449,count__56450,i__56451,t_56887,temp__5804__auto___56886__$1,v,seq__56448__$1,temp__5804__auto__,each_fixture_fn,G__56442,G__56442__$1,env,once_fixtures,each_fixtures,vec__56437,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56887)));
});})(seq__56448,chunk__56449,count__56450,i__56451,t_56887,temp__5804__auto___56886__$1,v,seq__56448__$1,temp__5804__auto__,each_fixture_fn,G__56442,G__56442__$1,env,once_fixtures,each_fixtures,vec__56437,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56460_56888) : each_fixture_fn.call(null,G__56460_56888));
} else {
}


var G__56891 = cljs.core.next(seq__56448__$1);
var G__56892 = null;
var G__56893 = (0);
var G__56894 = (0);
seq__56448 = G__56891;
chunk__56449 = G__56892;
count__56450 = G__56893;
i__56451 = G__56894;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__56446 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__56446.cljs$core$IFn$_invoke$arity$1 ? fexpr__56446.cljs$core$IFn$_invoke$arity$1(G__56447) : fexpr__56446.call(null,G__56447));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56442__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__56425_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56425_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__56466 = shadow.test.env.get_test_ns_info(ns);
var map__56466__$1 = cljs.core.__destructure_map(map__56466);
var test_ns = map__56466__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56466__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__56476,vars){
var map__56477 = p__56476;
var map__56477__$1 = cljs.core.__destructure_map(map__56477);
var env = map__56477__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56477__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__56478_56896 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__56480_56897 = null;
var count__56481_56898 = (0);
var i__56482_56899 = (0);
while(true){
if((i__56482_56899 < count__56481_56898)){
var vec__56573_56900 = chunk__56480_56897.cljs$core$IIndexed$_nth$arity$2(null,i__56482_56899);
var test_ns_56901 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56573_56900,(0),null);
var ns_info_56902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56573_56900,(1),null);
var map__56576_56903 = ns_info_56902;
var map__56576_56904__$1 = cljs.core.__destructure_map(map__56576_56903);
var fixtures_56905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56576_56904__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56906 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56905);
if(cljs.core.truth_(temp__5804__auto___56906)){
var fix_56907 = temp__5804__auto___56906;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56901,fix_56907], 0));
} else {
}

var temp__5804__auto___56908 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56905);
if(cljs.core.truth_(temp__5804__auto___56908)){
var fix_56909 = temp__5804__auto___56908;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56901,fix_56909], 0));
} else {
}


var G__56910 = seq__56478_56896;
var G__56911 = chunk__56480_56897;
var G__56912 = count__56481_56898;
var G__56913 = (i__56482_56899 + (1));
seq__56478_56896 = G__56910;
chunk__56480_56897 = G__56911;
count__56481_56898 = G__56912;
i__56482_56899 = G__56913;
continue;
} else {
var temp__5804__auto___56914 = cljs.core.seq(seq__56478_56896);
if(temp__5804__auto___56914){
var seq__56478_56915__$1 = temp__5804__auto___56914;
if(cljs.core.chunked_seq_QMARK_(seq__56478_56915__$1)){
var c__5568__auto___56916 = cljs.core.chunk_first(seq__56478_56915__$1);
var G__56917 = cljs.core.chunk_rest(seq__56478_56915__$1);
var G__56918 = c__5568__auto___56916;
var G__56919 = cljs.core.count(c__5568__auto___56916);
var G__56920 = (0);
seq__56478_56896 = G__56917;
chunk__56480_56897 = G__56918;
count__56481_56898 = G__56919;
i__56482_56899 = G__56920;
continue;
} else {
var vec__56579_56921 = cljs.core.first(seq__56478_56915__$1);
var test_ns_56922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56579_56921,(0),null);
var ns_info_56923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56579_56921,(1),null);
var map__56582_56924 = ns_info_56923;
var map__56582_56925__$1 = cljs.core.__destructure_map(map__56582_56924);
var fixtures_56926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56582_56925__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56927__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56926);
if(cljs.core.truth_(temp__5804__auto___56927__$1)){
var fix_56928 = temp__5804__auto___56927__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56922,fix_56928], 0));
} else {
}

var temp__5804__auto___56929__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56926);
if(cljs.core.truth_(temp__5804__auto___56929__$1)){
var fix_56930 = temp__5804__auto___56929__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56922,fix_56930], 0));
} else {
}


var G__56931 = cljs.core.next(seq__56478_56915__$1);
var G__56932 = null;
var G__56933 = (0);
var G__56934 = (0);
seq__56478_56896 = G__56931;
chunk__56480_56897 = G__56932;
count__56481_56898 = G__56933;
i__56482_56899 = G__56934;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56475_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56475_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__56599 = cljs.test.get_current_env();
var map__56599__$1 = cljs.core.__destructure_map(map__56599);
var env = map__56599__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56599__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56599__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__56616 = arguments.length;
switch (G__56616) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__56667 = arguments.length;
switch (G__56667) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__56683 = shadow.test.env.get_test_ns_info(ns);
var map__56683__$1 = cljs.core.__destructure_map(map__56683);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56683__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__56686 = arguments.length;
switch (G__56686) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56684_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56684_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__56703 = arguments.length;
switch (G__56703) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56687_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56687_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
