goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31015 = arguments.length;
switch (G__31015) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31019 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31019 = (function (f,blockable,meta31020){
this.f = f;
this.blockable = blockable;
this.meta31020 = meta31020;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31021,meta31020__$1){
var self__ = this;
var _31021__$1 = this;
return (new cljs.core.async.t_cljs$core$async31019(self__.f,self__.blockable,meta31020__$1));
}));

(cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31021){
var self__ = this;
var _31021__$1 = this;
return self__.meta31020;
}));

(cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async31019.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async31019.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31020","meta31020",-35562413,null)], null);
}));

(cljs.core.async.t_cljs$core$async31019.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31019.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31019");

(cljs.core.async.t_cljs$core$async31019.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31019");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31019.
 */
cljs.core.async.__GT_t_cljs$core$async31019 = (function cljs$core$async$__GT_t_cljs$core$async31019(f__$1,blockable__$1,meta31020){
return (new cljs.core.async.t_cljs$core$async31019(f__$1,blockable__$1,meta31020));
});

}

return (new cljs.core.async.t_cljs$core$async31019(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31035 = arguments.length;
switch (G__31035) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31055 = arguments.length;
switch (G__31055) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31073 = arguments.length;
switch (G__31073) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_34211 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34211) : fn1.call(null,val_34211));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_34211) : fn1.call(null,val_34211));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31077 = arguments.length;
switch (G__31077) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___34221 = n;
var x_34222 = (0);
while(true){
if((x_34222 < n__5636__auto___34221)){
(a[x_34222] = x_34222);

var G__34224 = (x_34222 + (1));
x_34222 = G__34224;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31100 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31100 = (function (flag,meta31101){
this.flag = flag;
this.meta31101 = meta31101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31102,meta31101__$1){
var self__ = this;
var _31102__$1 = this;
return (new cljs.core.async.t_cljs$core$async31100(self__.flag,meta31101__$1));
}));

(cljs.core.async.t_cljs$core$async31100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31102){
var self__ = this;
var _31102__$1 = this;
return self__.meta31101;
}));

(cljs.core.async.t_cljs$core$async31100.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31100.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31100.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31100.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async31100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31101","meta31101",-1972840469,null)], null);
}));

(cljs.core.async.t_cljs$core$async31100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31100");

(cljs.core.async.t_cljs$core$async31100.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31100.
 */
cljs.core.async.__GT_t_cljs$core$async31100 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31100(flag__$1,meta31101){
return (new cljs.core.async.t_cljs$core$async31100(flag__$1,meta31101));
});

}

return (new cljs.core.async.t_cljs$core$async31100(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async31130 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31130 = (function (flag,cb,meta31131){
this.flag = flag;
this.cb = cb;
this.meta31131 = meta31131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31132,meta31131__$1){
var self__ = this;
var _31132__$1 = this;
return (new cljs.core.async.t_cljs$core$async31130(self__.flag,self__.cb,meta31131__$1));
}));

(cljs.core.async.t_cljs$core$async31130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31132){
var self__ = this;
var _31132__$1 = this;
return self__.meta31131;
}));

(cljs.core.async.t_cljs$core$async31130.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31130.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async31130.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async31130.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async31130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31131","meta31131",798600579,null)], null);
}));

(cljs.core.async.t_cljs$core$async31130.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31130");

(cljs.core.async.t_cljs$core$async31130.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31130");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31130.
 */
cljs.core.async.__GT_t_cljs$core$async31130 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31130(flag__$1,cb__$1,meta31131){
return (new cljs.core.async.t_cljs$core$async31130(flag__$1,cb__$1,meta31131));
});

}

return (new cljs.core.async.t_cljs$core$async31130(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31145_SHARP_){
var G__31152 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31145_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31152) : fret.call(null,G__31152));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31146_SHARP_){
var G__31153 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31146_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31153) : fret.call(null,G__31153));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__34244 = (i + (1));
i = G__34244;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34247 = arguments.length;
var i__5770__auto___34248 = (0);
while(true){
if((i__5770__auto___34248 < len__5769__auto___34247)){
args__5775__auto__.push((arguments[i__5770__auto___34248]));

var G__34249 = (i__5770__auto___34248 + (1));
i__5770__auto___34248 = G__34249;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31168){
var map__31169 = p__31168;
var map__31169__$1 = cljs.core.__destructure_map(map__31169);
var opts = map__31169__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31159){
var G__31160 = cljs.core.first(seq31159);
var seq31159__$1 = cljs.core.next(seq31159);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31160,seq31159__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31191 = arguments.length;
switch (G__31191) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30937__auto___34253 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_31265){
var state_val_31266 = (state_31265[(1)]);
if((state_val_31266 === (7))){
var inst_31251 = (state_31265[(2)]);
var state_31265__$1 = state_31265;
var statearr_31287_34255 = state_31265__$1;
(statearr_31287_34255[(2)] = inst_31251);

(statearr_31287_34255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (1))){
var state_31265__$1 = state_31265;
var statearr_31288_34256 = state_31265__$1;
(statearr_31288_34256[(2)] = null);

(statearr_31288_34256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (4))){
var inst_31225 = (state_31265[(7)]);
var inst_31225__$1 = (state_31265[(2)]);
var inst_31229 = (inst_31225__$1 == null);
var state_31265__$1 = (function (){var statearr_31289 = state_31265;
(statearr_31289[(7)] = inst_31225__$1);

return statearr_31289;
})();
if(cljs.core.truth_(inst_31229)){
var statearr_31292_34257 = state_31265__$1;
(statearr_31292_34257[(1)] = (5));

} else {
var statearr_31293_34258 = state_31265__$1;
(statearr_31293_34258[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (13))){
var state_31265__$1 = state_31265;
var statearr_31294_34260 = state_31265__$1;
(statearr_31294_34260[(2)] = null);

(statearr_31294_34260[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (6))){
var inst_31225 = (state_31265[(7)]);
var state_31265__$1 = state_31265;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31265__$1,(11),to,inst_31225);
} else {
if((state_val_31266 === (3))){
var inst_31253 = (state_31265[(2)]);
var state_31265__$1 = state_31265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31265__$1,inst_31253);
} else {
if((state_val_31266 === (12))){
var state_31265__$1 = state_31265;
var statearr_31305_34263 = state_31265__$1;
(statearr_31305_34263[(2)] = null);

(statearr_31305_34263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (2))){
var state_31265__$1 = state_31265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31265__$1,(4),from);
} else {
if((state_val_31266 === (11))){
var inst_31244 = (state_31265[(2)]);
var state_31265__$1 = state_31265;
if(cljs.core.truth_(inst_31244)){
var statearr_31309_34264 = state_31265__$1;
(statearr_31309_34264[(1)] = (12));

} else {
var statearr_31310_34266 = state_31265__$1;
(statearr_31310_34266[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (9))){
var state_31265__$1 = state_31265;
var statearr_31312_34268 = state_31265__$1;
(statearr_31312_34268[(2)] = null);

(statearr_31312_34268[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (5))){
var state_31265__$1 = state_31265;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31314_34270 = state_31265__$1;
(statearr_31314_34270[(1)] = (8));

} else {
var statearr_31315_34271 = state_31265__$1;
(statearr_31315_34271[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (14))){
var inst_31249 = (state_31265[(2)]);
var state_31265__$1 = state_31265;
var statearr_31320_34272 = state_31265__$1;
(statearr_31320_34272[(2)] = inst_31249);

(statearr_31320_34272[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (10))){
var inst_31241 = (state_31265[(2)]);
var state_31265__$1 = state_31265;
var statearr_31321_34273 = state_31265__$1;
(statearr_31321_34273[(2)] = inst_31241);

(statearr_31321_34273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31266 === (8))){
var inst_31234 = cljs.core.async.close_BANG_(to);
var state_31265__$1 = state_31265;
var statearr_31334_34274 = state_31265__$1;
(statearr_31334_34274[(2)] = inst_31234);

(statearr_31334_34274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_31342 = [null,null,null,null,null,null,null,null];
(statearr_31342[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_31342[(1)] = (1));

return statearr_31342;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_31265){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31265);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31344){var ex__30484__auto__ = e31344;
var statearr_31348_34281 = state_31265;
(statearr_31348_34281[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31265[(4)]))){
var statearr_31349_34283 = state_31265;
(statearr_31349_34283[(1)] = cljs.core.first((state_31265[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34284 = state_31265;
state_31265 = G__34284;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_31265){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_31265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_31354 = f__30938__auto__();
(statearr_31354[(6)] = c__30937__auto___34253);

return statearr_31354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__31367){
var vec__31368 = p__31367;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31368,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31368,(1),null);
var job = vec__31368;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30937__auto___34287 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_31382){
var state_val_31383 = (state_31382[(1)]);
if((state_val_31383 === (1))){
var state_31382__$1 = state_31382;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31382__$1,(2),res,v);
} else {
if((state_val_31383 === (2))){
var inst_31379 = (state_31382[(2)]);
var inst_31380 = cljs.core.async.close_BANG_(res);
var state_31382__$1 = (function (){var statearr_31387 = state_31382;
(statearr_31387[(7)] = inst_31379);

return statearr_31387;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31382__$1,inst_31380);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0 = (function (){
var statearr_31391 = [null,null,null,null,null,null,null,null];
(statearr_31391[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__);

(statearr_31391[(1)] = (1));

return statearr_31391;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1 = (function (state_31382){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31382);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31392){var ex__30484__auto__ = e31392;
var statearr_31393_34298 = state_31382;
(statearr_31393_34298[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31382[(4)]))){
var statearr_31395_34304 = state_31382;
(statearr_31395_34304[(1)] = cljs.core.first((state_31382[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34308 = state_31382;
state_31382 = G__34308;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = function(state_31382){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1.call(this,state_31382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_31396 = f__30938__auto__();
(statearr_31396[(6)] = c__30937__auto___34287);

return statearr_31396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31402){
var vec__31403 = p__31402;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31403,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31403,(1),null);
var job = vec__31403;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___34323 = n;
var __34324 = (0);
while(true){
if((__34324 < n__5636__auto___34323)){
var G__31412_34325 = type;
var G__31412_34326__$1 = (((G__31412_34325 instanceof cljs.core.Keyword))?G__31412_34325.fqn:null);
switch (G__31412_34326__$1) {
case "compute":
var c__30937__auto___34332 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34324,c__30937__auto___34332,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async){
return (function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = ((function (__34324,c__30937__auto___34332,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async){
return (function (state_31429){
var state_val_31430 = (state_31429[(1)]);
if((state_val_31430 === (1))){
var state_31429__$1 = state_31429;
var statearr_31436_34343 = state_31429__$1;
(statearr_31436_34343[(2)] = null);

(statearr_31436_34343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (2))){
var state_31429__$1 = state_31429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31429__$1,(4),jobs);
} else {
if((state_val_31430 === (3))){
var inst_31427 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31429__$1,inst_31427);
} else {
if((state_val_31430 === (4))){
var inst_31418 = (state_31429[(2)]);
var inst_31419 = process__$1(inst_31418);
var state_31429__$1 = state_31429;
if(cljs.core.truth_(inst_31419)){
var statearr_31439_34352 = state_31429__$1;
(statearr_31439_34352[(1)] = (5));

} else {
var statearr_31445_34353 = state_31429__$1;
(statearr_31445_34353[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (5))){
var state_31429__$1 = state_31429;
var statearr_31448_34358 = state_31429__$1;
(statearr_31448_34358[(2)] = null);

(statearr_31448_34358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (6))){
var state_31429__$1 = state_31429;
var statearr_31449_34360 = state_31429__$1;
(statearr_31449_34360[(2)] = null);

(statearr_31449_34360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31430 === (7))){
var inst_31425 = (state_31429[(2)]);
var state_31429__$1 = state_31429;
var statearr_31453_34362 = state_31429__$1;
(statearr_31453_34362[(2)] = inst_31425);

(statearr_31453_34362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34324,c__30937__auto___34332,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async))
;
return ((function (__34324,switch__30480__auto__,c__30937__auto___34332,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0 = (function (){
var statearr_31454 = [null,null,null,null,null,null,null];
(statearr_31454[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__);

(statearr_31454[(1)] = (1));

return statearr_31454;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1 = (function (state_31429){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31429);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31457){var ex__30484__auto__ = e31457;
var statearr_31458_34364 = state_31429;
(statearr_31458_34364[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31429[(4)]))){
var statearr_31461_34365 = state_31429;
(statearr_31461_34365[(1)] = cljs.core.first((state_31429[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34373 = state_31429;
state_31429 = G__34373;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = function(state_31429){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1.call(this,state_31429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__;
})()
;})(__34324,switch__30480__auto__,c__30937__auto___34332,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async))
})();
var state__30939__auto__ = (function (){var statearr_31464 = f__30938__auto__();
(statearr_31464[(6)] = c__30937__auto___34332);

return statearr_31464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
});})(__34324,c__30937__auto___34332,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async))
);


break;
case "async":
var c__30937__auto___34381 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__34324,c__30937__auto___34381,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async){
return (function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = ((function (__34324,c__30937__auto___34381,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async){
return (function (state_31480){
var state_val_31481 = (state_31480[(1)]);
if((state_val_31481 === (1))){
var state_31480__$1 = state_31480;
var statearr_31482_34392 = state_31480__$1;
(statearr_31482_34392[(2)] = null);

(statearr_31482_34392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (2))){
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31480__$1,(4),jobs);
} else {
if((state_val_31481 === (3))){
var inst_31478 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31480__$1,inst_31478);
} else {
if((state_val_31481 === (4))){
var inst_31469 = (state_31480[(2)]);
var inst_31470 = async(inst_31469);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31470)){
var statearr_31483_34394 = state_31480__$1;
(statearr_31483_34394[(1)] = (5));

} else {
var statearr_31484_34395 = state_31480__$1;
(statearr_31484_34395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (5))){
var state_31480__$1 = state_31480;
var statearr_31485_34396 = state_31480__$1;
(statearr_31485_34396[(2)] = null);

(statearr_31485_34396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (6))){
var state_31480__$1 = state_31480;
var statearr_31492_34404 = state_31480__$1;
(statearr_31492_34404[(2)] = null);

(statearr_31492_34404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (7))){
var inst_31476 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31493_34408 = state_31480__$1;
(statearr_31493_34408[(2)] = inst_31476);

(statearr_31493_34408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__34324,c__30937__auto___34381,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async))
;
return ((function (__34324,switch__30480__auto__,c__30937__auto___34381,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0 = (function (){
var statearr_31503 = [null,null,null,null,null,null,null];
(statearr_31503[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__);

(statearr_31503[(1)] = (1));

return statearr_31503;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1 = (function (state_31480){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31480);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31508){var ex__30484__auto__ = e31508;
var statearr_31509_34414 = state_31480;
(statearr_31509_34414[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31480[(4)]))){
var statearr_31514_34415 = state_31480;
(statearr_31514_34415[(1)] = cljs.core.first((state_31480[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34416 = state_31480;
state_31480 = G__34416;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = function(state_31480){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1.call(this,state_31480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__;
})()
;})(__34324,switch__30480__auto__,c__30937__auto___34381,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async))
})();
var state__30939__auto__ = (function (){var statearr_31523 = f__30938__auto__();
(statearr_31523[(6)] = c__30937__auto___34381);

return statearr_31523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
});})(__34324,c__30937__auto___34381,G__31412_34325,G__31412_34326__$1,n__5636__auto___34323,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31412_34326__$1)].join('')));

}

var G__34417 = (__34324 + (1));
__34324 = G__34417;
continue;
} else {
}
break;
}

var c__30937__auto___34418 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_31573){
var state_val_31574 = (state_31573[(1)]);
if((state_val_31574 === (7))){
var inst_31568 = (state_31573[(2)]);
var state_31573__$1 = state_31573;
var statearr_31576_34421 = state_31573__$1;
(statearr_31576_34421[(2)] = inst_31568);

(statearr_31576_34421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31574 === (1))){
var state_31573__$1 = state_31573;
var statearr_31579_34429 = state_31573__$1;
(statearr_31579_34429[(2)] = null);

(statearr_31579_34429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31574 === (4))){
var inst_31550 = (state_31573[(7)]);
var inst_31550__$1 = (state_31573[(2)]);
var inst_31551 = (inst_31550__$1 == null);
var state_31573__$1 = (function (){var statearr_31582 = state_31573;
(statearr_31582[(7)] = inst_31550__$1);

return statearr_31582;
})();
if(cljs.core.truth_(inst_31551)){
var statearr_31585_34433 = state_31573__$1;
(statearr_31585_34433[(1)] = (5));

} else {
var statearr_31586_34435 = state_31573__$1;
(statearr_31586_34435[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31574 === (6))){
var inst_31555 = (state_31573[(8)]);
var inst_31550 = (state_31573[(7)]);
var inst_31555__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31560 = [inst_31550,inst_31555__$1];
var inst_31561 = (new cljs.core.PersistentVector(null,2,(5),inst_31559,inst_31560,null));
var state_31573__$1 = (function (){var statearr_31587 = state_31573;
(statearr_31587[(8)] = inst_31555__$1);

return statearr_31587;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31573__$1,(8),jobs,inst_31561);
} else {
if((state_val_31574 === (3))){
var inst_31570 = (state_31573[(2)]);
var state_31573__$1 = state_31573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31573__$1,inst_31570);
} else {
if((state_val_31574 === (2))){
var state_31573__$1 = state_31573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31573__$1,(4),from);
} else {
if((state_val_31574 === (9))){
var inst_31565 = (state_31573[(2)]);
var state_31573__$1 = (function (){var statearr_31590 = state_31573;
(statearr_31590[(9)] = inst_31565);

return statearr_31590;
})();
var statearr_31600_34440 = state_31573__$1;
(statearr_31600_34440[(2)] = null);

(statearr_31600_34440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31574 === (5))){
var inst_31553 = cljs.core.async.close_BANG_(jobs);
var state_31573__$1 = state_31573;
var statearr_31603_34442 = state_31573__$1;
(statearr_31603_34442[(2)] = inst_31553);

(statearr_31603_34442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31574 === (8))){
var inst_31555 = (state_31573[(8)]);
var inst_31563 = (state_31573[(2)]);
var state_31573__$1 = (function (){var statearr_31605 = state_31573;
(statearr_31605[(10)] = inst_31563);

return statearr_31605;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31573__$1,(9),results,inst_31555);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0 = (function (){
var statearr_31611 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31611[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__);

(statearr_31611[(1)] = (1));

return statearr_31611;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1 = (function (state_31573){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31573);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31617){var ex__30484__auto__ = e31617;
var statearr_31622_34451 = state_31573;
(statearr_31622_34451[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31573[(4)]))){
var statearr_31627_34454 = state_31573;
(statearr_31627_34454[(1)] = cljs.core.first((state_31573[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34455 = state_31573;
state_31573 = G__34455;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = function(state_31573){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1.call(this,state_31573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_31639 = f__30938__auto__();
(statearr_31639[(6)] = c__30937__auto___34418);

return statearr_31639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


var c__30937__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_31708){
var state_val_31709 = (state_31708[(1)]);
if((state_val_31709 === (7))){
var inst_31697 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31719_34457 = state_31708__$1;
(statearr_31719_34457[(2)] = inst_31697);

(statearr_31719_34457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (20))){
var state_31708__$1 = state_31708;
var statearr_31725_34458 = state_31708__$1;
(statearr_31725_34458[(2)] = null);

(statearr_31725_34458[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (1))){
var state_31708__$1 = state_31708;
var statearr_31734_34460 = state_31708__$1;
(statearr_31734_34460[(2)] = null);

(statearr_31734_34460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (4))){
var inst_31648 = (state_31708[(7)]);
var inst_31648__$1 = (state_31708[(2)]);
var inst_31650 = (inst_31648__$1 == null);
var state_31708__$1 = (function (){var statearr_31745 = state_31708;
(statearr_31745[(7)] = inst_31648__$1);

return statearr_31745;
})();
if(cljs.core.truth_(inst_31650)){
var statearr_31746_34464 = state_31708__$1;
(statearr_31746_34464[(1)] = (5));

} else {
var statearr_31747_34469 = state_31708__$1;
(statearr_31747_34469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (15))){
var inst_31667 = (state_31708[(8)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31708__$1,(18),to,inst_31667);
} else {
if((state_val_31709 === (21))){
var inst_31691 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31753_34472 = state_31708__$1;
(statearr_31753_34472[(2)] = inst_31691);

(statearr_31753_34472[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (13))){
var inst_31693 = (state_31708[(2)]);
var state_31708__$1 = (function (){var statearr_31755 = state_31708;
(statearr_31755[(9)] = inst_31693);

return statearr_31755;
})();
var statearr_31758_34475 = state_31708__$1;
(statearr_31758_34475[(2)] = null);

(statearr_31758_34475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (6))){
var inst_31648 = (state_31708[(7)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31708__$1,(11),inst_31648);
} else {
if((state_val_31709 === (17))){
var inst_31682 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
if(cljs.core.truth_(inst_31682)){
var statearr_31762_34478 = state_31708__$1;
(statearr_31762_34478[(1)] = (19));

} else {
var statearr_31763_34484 = state_31708__$1;
(statearr_31763_34484[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (3))){
var inst_31699 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31708__$1,inst_31699);
} else {
if((state_val_31709 === (12))){
var inst_31663 = (state_31708[(10)]);
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31708__$1,(14),inst_31663);
} else {
if((state_val_31709 === (2))){
var state_31708__$1 = state_31708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31708__$1,(4),results);
} else {
if((state_val_31709 === (19))){
var state_31708__$1 = state_31708;
var statearr_31765_34491 = state_31708__$1;
(statearr_31765_34491[(2)] = null);

(statearr_31765_34491[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (11))){
var inst_31663 = (state_31708[(2)]);
var state_31708__$1 = (function (){var statearr_31766 = state_31708;
(statearr_31766[(10)] = inst_31663);

return statearr_31766;
})();
var statearr_31769_34492 = state_31708__$1;
(statearr_31769_34492[(2)] = null);

(statearr_31769_34492[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (9))){
var state_31708__$1 = state_31708;
var statearr_31779_34497 = state_31708__$1;
(statearr_31779_34497[(2)] = null);

(statearr_31779_34497[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (5))){
var state_31708__$1 = state_31708;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31780_34499 = state_31708__$1;
(statearr_31780_34499[(1)] = (8));

} else {
var statearr_31781_34502 = state_31708__$1;
(statearr_31781_34502[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (14))){
var inst_31667 = (state_31708[(8)]);
var inst_31673 = (state_31708[(11)]);
var inst_31667__$1 = (state_31708[(2)]);
var inst_31672 = (inst_31667__$1 == null);
var inst_31673__$1 = cljs.core.not(inst_31672);
var state_31708__$1 = (function (){var statearr_31786 = state_31708;
(statearr_31786[(8)] = inst_31667__$1);

(statearr_31786[(11)] = inst_31673__$1);

return statearr_31786;
})();
if(inst_31673__$1){
var statearr_31787_34514 = state_31708__$1;
(statearr_31787_34514[(1)] = (15));

} else {
var statearr_31788_34515 = state_31708__$1;
(statearr_31788_34515[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (16))){
var inst_31673 = (state_31708[(11)]);
var state_31708__$1 = state_31708;
var statearr_31790_34517 = state_31708__$1;
(statearr_31790_34517[(2)] = inst_31673);

(statearr_31790_34517[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (10))){
var inst_31659 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31792_34525 = state_31708__$1;
(statearr_31792_34525[(2)] = inst_31659);

(statearr_31792_34525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (18))){
var inst_31679 = (state_31708[(2)]);
var state_31708__$1 = state_31708;
var statearr_31801_34528 = state_31708__$1;
(statearr_31801_34528[(2)] = inst_31679);

(statearr_31801_34528[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31709 === (8))){
var inst_31656 = cljs.core.async.close_BANG_(to);
var state_31708__$1 = state_31708;
var statearr_31806_34537 = state_31708__$1;
(statearr_31806_34537[(2)] = inst_31656);

(statearr_31806_34537[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0 = (function (){
var statearr_31812 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31812[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__);

(statearr_31812[(1)] = (1));

return statearr_31812;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1 = (function (state_31708){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31708);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31814){var ex__30484__auto__ = e31814;
var statearr_31815_34543 = state_31708;
(statearr_31815_34543[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31708[(4)]))){
var statearr_31817_34545 = state_31708;
(statearr_31817_34545[(1)] = cljs.core.first((state_31708[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34546 = state_31708;
state_31708 = G__34546;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__ = function(state_31708){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1.call(this,state_31708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30481__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_31823 = f__30938__auto__();
(statearr_31823[(6)] = c__30937__auto__);

return statearr_31823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

return c__30937__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31836 = arguments.length;
switch (G__31836) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31844 = arguments.length;
switch (G__31844) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31847 = arguments.length;
switch (G__31847) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30937__auto___34583 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_31886){
var state_val_31887 = (state_31886[(1)]);
if((state_val_31887 === (7))){
var inst_31881 = (state_31886[(2)]);
var state_31886__$1 = state_31886;
var statearr_31890_34586 = state_31886__$1;
(statearr_31890_34586[(2)] = inst_31881);

(statearr_31890_34586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (1))){
var state_31886__$1 = state_31886;
var statearr_31891_34587 = state_31886__$1;
(statearr_31891_34587[(2)] = null);

(statearr_31891_34587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (4))){
var inst_31859 = (state_31886[(7)]);
var inst_31859__$1 = (state_31886[(2)]);
var inst_31860 = (inst_31859__$1 == null);
var state_31886__$1 = (function (){var statearr_31895 = state_31886;
(statearr_31895[(7)] = inst_31859__$1);

return statearr_31895;
})();
if(cljs.core.truth_(inst_31860)){
var statearr_31897_34588 = state_31886__$1;
(statearr_31897_34588[(1)] = (5));

} else {
var statearr_31898_34590 = state_31886__$1;
(statearr_31898_34590[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (13))){
var state_31886__$1 = state_31886;
var statearr_31899_34591 = state_31886__$1;
(statearr_31899_34591[(2)] = null);

(statearr_31899_34591[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (6))){
var inst_31859 = (state_31886[(7)]);
var inst_31865 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31859) : p.call(null,inst_31859));
var state_31886__$1 = state_31886;
if(cljs.core.truth_(inst_31865)){
var statearr_31901_34596 = state_31886__$1;
(statearr_31901_34596[(1)] = (9));

} else {
var statearr_31906_34597 = state_31886__$1;
(statearr_31906_34597[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (3))){
var inst_31884 = (state_31886[(2)]);
var state_31886__$1 = state_31886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31886__$1,inst_31884);
} else {
if((state_val_31887 === (12))){
var state_31886__$1 = state_31886;
var statearr_31913_34598 = state_31886__$1;
(statearr_31913_34598[(2)] = null);

(statearr_31913_34598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (2))){
var state_31886__$1 = state_31886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31886__$1,(4),ch);
} else {
if((state_val_31887 === (11))){
var inst_31859 = (state_31886[(7)]);
var inst_31871 = (state_31886[(2)]);
var state_31886__$1 = state_31886;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31886__$1,(8),inst_31871,inst_31859);
} else {
if((state_val_31887 === (9))){
var state_31886__$1 = state_31886;
var statearr_31918_34603 = state_31886__$1;
(statearr_31918_34603[(2)] = tc);

(statearr_31918_34603[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (5))){
var inst_31862 = cljs.core.async.close_BANG_(tc);
var inst_31863 = cljs.core.async.close_BANG_(fc);
var state_31886__$1 = (function (){var statearr_31919 = state_31886;
(statearr_31919[(8)] = inst_31862);

return statearr_31919;
})();
var statearr_31920_34607 = state_31886__$1;
(statearr_31920_34607[(2)] = inst_31863);

(statearr_31920_34607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (14))){
var inst_31878 = (state_31886[(2)]);
var state_31886__$1 = state_31886;
var statearr_31921_34609 = state_31886__$1;
(statearr_31921_34609[(2)] = inst_31878);

(statearr_31921_34609[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (10))){
var state_31886__$1 = state_31886;
var statearr_31924_34612 = state_31886__$1;
(statearr_31924_34612[(2)] = fc);

(statearr_31924_34612[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31887 === (8))){
var inst_31873 = (state_31886[(2)]);
var state_31886__$1 = state_31886;
if(cljs.core.truth_(inst_31873)){
var statearr_31925_34616 = state_31886__$1;
(statearr_31925_34616[(1)] = (12));

} else {
var statearr_31926_34620 = state_31886__$1;
(statearr_31926_34620[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_31929 = [null,null,null,null,null,null,null,null,null];
(statearr_31929[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_31929[(1)] = (1));

return statearr_31929;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_31886){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31886);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e31930){var ex__30484__auto__ = e31930;
var statearr_31931_34626 = state_31886;
(statearr_31931_34626[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31886[(4)]))){
var statearr_31932_34631 = state_31886;
(statearr_31932_34631[(1)] = cljs.core.first((state_31886[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34632 = state_31886;
state_31886 = G__34632;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_31886){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_31886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_31933 = f__30938__auto__();
(statearr_31933[(6)] = c__30937__auto___34583);

return statearr_31933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30937__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_31968){
var state_val_31969 = (state_31968[(1)]);
if((state_val_31969 === (7))){
var inst_31964 = (state_31968[(2)]);
var state_31968__$1 = state_31968;
var statearr_31974_34640 = state_31968__$1;
(statearr_31974_34640[(2)] = inst_31964);

(statearr_31974_34640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (1))){
var inst_31943 = init;
var inst_31944 = inst_31943;
var state_31968__$1 = (function (){var statearr_31975 = state_31968;
(statearr_31975[(7)] = inst_31944);

return statearr_31975;
})();
var statearr_31976_34641 = state_31968__$1;
(statearr_31976_34641[(2)] = null);

(statearr_31976_34641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (4))){
var inst_31951 = (state_31968[(8)]);
var inst_31951__$1 = (state_31968[(2)]);
var inst_31952 = (inst_31951__$1 == null);
var state_31968__$1 = (function (){var statearr_31977 = state_31968;
(statearr_31977[(8)] = inst_31951__$1);

return statearr_31977;
})();
if(cljs.core.truth_(inst_31952)){
var statearr_31978_34647 = state_31968__$1;
(statearr_31978_34647[(1)] = (5));

} else {
var statearr_31979_34651 = state_31968__$1;
(statearr_31979_34651[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (6))){
var inst_31944 = (state_31968[(7)]);
var inst_31955 = (state_31968[(9)]);
var inst_31951 = (state_31968[(8)]);
var inst_31955__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31944,inst_31951) : f.call(null,inst_31944,inst_31951));
var inst_31956 = cljs.core.reduced_QMARK_(inst_31955__$1);
var state_31968__$1 = (function (){var statearr_31980 = state_31968;
(statearr_31980[(9)] = inst_31955__$1);

return statearr_31980;
})();
if(inst_31956){
var statearr_31981_34657 = state_31968__$1;
(statearr_31981_34657[(1)] = (8));

} else {
var statearr_31982_34659 = state_31968__$1;
(statearr_31982_34659[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (3))){
var inst_31966 = (state_31968[(2)]);
var state_31968__$1 = state_31968;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31968__$1,inst_31966);
} else {
if((state_val_31969 === (2))){
var state_31968__$1 = state_31968;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31968__$1,(4),ch);
} else {
if((state_val_31969 === (9))){
var inst_31955 = (state_31968[(9)]);
var inst_31944 = inst_31955;
var state_31968__$1 = (function (){var statearr_31987 = state_31968;
(statearr_31987[(7)] = inst_31944);

return statearr_31987;
})();
var statearr_31992_34666 = state_31968__$1;
(statearr_31992_34666[(2)] = null);

(statearr_31992_34666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (5))){
var inst_31944 = (state_31968[(7)]);
var state_31968__$1 = state_31968;
var statearr_31993_34670 = state_31968__$1;
(statearr_31993_34670[(2)] = inst_31944);

(statearr_31993_34670[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (10))){
var inst_31962 = (state_31968[(2)]);
var state_31968__$1 = state_31968;
var statearr_31994_34671 = state_31968__$1;
(statearr_31994_34671[(2)] = inst_31962);

(statearr_31994_34671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (8))){
var inst_31955 = (state_31968[(9)]);
var inst_31958 = cljs.core.deref(inst_31955);
var state_31968__$1 = state_31968;
var statearr_31997_34676 = state_31968__$1;
(statearr_31997_34676[(2)] = inst_31958);

(statearr_31997_34676[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__30481__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30481__auto____0 = (function (){
var statearr_32000 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32000[(0)] = cljs$core$async$reduce_$_state_machine__30481__auto__);

(statearr_32000[(1)] = (1));

return statearr_32000;
});
var cljs$core$async$reduce_$_state_machine__30481__auto____1 = (function (state_31968){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_31968);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e32001){var ex__30484__auto__ = e32001;
var statearr_32002_34678 = state_31968;
(statearr_32002_34678[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_31968[(4)]))){
var statearr_32003_34679 = state_31968;
(statearr_32003_34679[(1)] = cljs.core.first((state_31968[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34681 = state_31968;
state_31968 = G__34681;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30481__auto__ = function(state_31968){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30481__auto____1.call(this,state_31968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30481__auto____0;
cljs$core$async$reduce_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30481__auto____1;
return cljs$core$async$reduce_$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_32004 = f__30938__auto__();
(statearr_32004[(6)] = c__30937__auto__);

return statearr_32004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

return c__30937__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30937__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_32010){
var state_val_32011 = (state_32010[(1)]);
if((state_val_32011 === (1))){
var inst_32005 = cljs.core.async.reduce(f__$1,init,ch);
var state_32010__$1 = state_32010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32010__$1,(2),inst_32005);
} else {
if((state_val_32011 === (2))){
var inst_32007 = (state_32010[(2)]);
var inst_32008 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32007) : f__$1.call(null,inst_32007));
var state_32010__$1 = state_32010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32010__$1,inst_32008);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__30481__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30481__auto____0 = (function (){
var statearr_32014 = [null,null,null,null,null,null,null];
(statearr_32014[(0)] = cljs$core$async$transduce_$_state_machine__30481__auto__);

(statearr_32014[(1)] = (1));

return statearr_32014;
});
var cljs$core$async$transduce_$_state_machine__30481__auto____1 = (function (state_32010){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_32010);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e32015){var ex__30484__auto__ = e32015;
var statearr_32016_34695 = state_32010;
(statearr_32016_34695[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_32010[(4)]))){
var statearr_32017_34700 = state_32010;
(statearr_32017_34700[(1)] = cljs.core.first((state_32010[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34705 = state_32010;
state_32010 = G__34705;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30481__auto__ = function(state_32010){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30481__auto____1.call(this,state_32010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30481__auto____0;
cljs$core$async$transduce_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30481__auto____1;
return cljs$core$async$transduce_$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_32018 = f__30938__auto__();
(statearr_32018[(6)] = c__30937__auto__);

return statearr_32018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

return c__30937__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__32022 = arguments.length;
switch (G__32022) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30937__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_32050){
var state_val_32051 = (state_32050[(1)]);
if((state_val_32051 === (7))){
var inst_32032 = (state_32050[(2)]);
var state_32050__$1 = state_32050;
var statearr_32056_34724 = state_32050__$1;
(statearr_32056_34724[(2)] = inst_32032);

(statearr_32056_34724[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (1))){
var inst_32026 = cljs.core.seq(coll);
var inst_32027 = inst_32026;
var state_32050__$1 = (function (){var statearr_32057 = state_32050;
(statearr_32057[(7)] = inst_32027);

return statearr_32057;
})();
var statearr_32058_34737 = state_32050__$1;
(statearr_32058_34737[(2)] = null);

(statearr_32058_34737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (4))){
var inst_32027 = (state_32050[(7)]);
var inst_32030 = cljs.core.first(inst_32027);
var state_32050__$1 = state_32050;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32050__$1,(7),ch,inst_32030);
} else {
if((state_val_32051 === (13))){
var inst_32044 = (state_32050[(2)]);
var state_32050__$1 = state_32050;
var statearr_32062_34741 = state_32050__$1;
(statearr_32062_34741[(2)] = inst_32044);

(statearr_32062_34741[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (6))){
var inst_32035 = (state_32050[(2)]);
var state_32050__$1 = state_32050;
if(cljs.core.truth_(inst_32035)){
var statearr_32066_34745 = state_32050__$1;
(statearr_32066_34745[(1)] = (8));

} else {
var statearr_32067_34747 = state_32050__$1;
(statearr_32067_34747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (3))){
var inst_32048 = (state_32050[(2)]);
var state_32050__$1 = state_32050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32050__$1,inst_32048);
} else {
if((state_val_32051 === (12))){
var state_32050__$1 = state_32050;
var statearr_32068_34751 = state_32050__$1;
(statearr_32068_34751[(2)] = null);

(statearr_32068_34751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (2))){
var inst_32027 = (state_32050[(7)]);
var state_32050__$1 = state_32050;
if(cljs.core.truth_(inst_32027)){
var statearr_32073_34753 = state_32050__$1;
(statearr_32073_34753[(1)] = (4));

} else {
var statearr_32074_34754 = state_32050__$1;
(statearr_32074_34754[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (11))){
var inst_32041 = cljs.core.async.close_BANG_(ch);
var state_32050__$1 = state_32050;
var statearr_32076_34757 = state_32050__$1;
(statearr_32076_34757[(2)] = inst_32041);

(statearr_32076_34757[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (9))){
var state_32050__$1 = state_32050;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32079_34758 = state_32050__$1;
(statearr_32079_34758[(1)] = (11));

} else {
var statearr_32083_34760 = state_32050__$1;
(statearr_32083_34760[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (5))){
var inst_32027 = (state_32050[(7)]);
var state_32050__$1 = state_32050;
var statearr_32084_34761 = state_32050__$1;
(statearr_32084_34761[(2)] = inst_32027);

(statearr_32084_34761[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (10))){
var inst_32046 = (state_32050[(2)]);
var state_32050__$1 = state_32050;
var statearr_32085_34762 = state_32050__$1;
(statearr_32085_34762[(2)] = inst_32046);

(statearr_32085_34762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32051 === (8))){
var inst_32027 = (state_32050[(7)]);
var inst_32037 = cljs.core.next(inst_32027);
var inst_32027__$1 = inst_32037;
var state_32050__$1 = (function (){var statearr_32089 = state_32050;
(statearr_32089[(7)] = inst_32027__$1);

return statearr_32089;
})();
var statearr_32090_34767 = state_32050__$1;
(statearr_32090_34767[(2)] = null);

(statearr_32090_34767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_32092 = [null,null,null,null,null,null,null,null];
(statearr_32092[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_32092[(1)] = (1));

return statearr_32092;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_32050){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_32050);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e32098){var ex__30484__auto__ = e32098;
var statearr_32099_34771 = state_32050;
(statearr_32099_34771[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_32050[(4)]))){
var statearr_32100_34779 = state_32050;
(statearr_32100_34779[(1)] = cljs.core.first((state_32050[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34782 = state_32050;
state_32050 = G__34782;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_32050){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_32050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_32101 = f__30938__auto__();
(statearr_32101[(6)] = c__30937__auto__);

return statearr_32101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

return c__30937__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32104 = arguments.length;
switch (G__32104) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34791 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34791(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34798 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34798(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34811 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34811(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34815 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34815(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32114 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32114 = (function (ch,cs,meta32115){
this.ch = ch;
this.cs = cs;
this.meta32115 = meta32115;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32116,meta32115__$1){
var self__ = this;
var _32116__$1 = this;
return (new cljs.core.async.t_cljs$core$async32114(self__.ch,self__.cs,meta32115__$1));
}));

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32116){
var self__ = this;
var _32116__$1 = this;
return self__.meta32115;
}));

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async32114.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async32114.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32115","meta32115",503995675,null)], null);
}));

(cljs.core.async.t_cljs$core$async32114.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32114.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32114");

(cljs.core.async.t_cljs$core$async32114.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32114");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32114.
 */
cljs.core.async.__GT_t_cljs$core$async32114 = (function cljs$core$async$mult_$___GT_t_cljs$core$async32114(ch__$1,cs__$1,meta32115){
return (new cljs.core.async.t_cljs$core$async32114(ch__$1,cs__$1,meta32115));
});

}

return (new cljs.core.async.t_cljs$core$async32114(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30937__auto___34838 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_32296){
var state_val_32297 = (state_32296[(1)]);
if((state_val_32297 === (7))){
var inst_32286 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32301_34841 = state_32296__$1;
(statearr_32301_34841[(2)] = inst_32286);

(statearr_32301_34841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (20))){
var inst_32170 = (state_32296[(7)]);
var inst_32187 = cljs.core.first(inst_32170);
var inst_32188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(0),null);
var inst_32189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32187,(1),null);
var state_32296__$1 = (function (){var statearr_32302 = state_32296;
(statearr_32302[(8)] = inst_32188);

return statearr_32302;
})();
if(cljs.core.truth_(inst_32189)){
var statearr_32303_34842 = state_32296__$1;
(statearr_32303_34842[(1)] = (22));

} else {
var statearr_32306_34847 = state_32296__$1;
(statearr_32306_34847[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (27))){
var inst_32223 = (state_32296[(9)]);
var inst_32132 = (state_32296[(10)]);
var inst_32231 = (state_32296[(11)]);
var inst_32225 = (state_32296[(12)]);
var inst_32231__$1 = cljs.core._nth(inst_32223,inst_32225);
var inst_32233 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32231__$1,inst_32132,done);
var state_32296__$1 = (function (){var statearr_32317 = state_32296;
(statearr_32317[(11)] = inst_32231__$1);

return statearr_32317;
})();
if(cljs.core.truth_(inst_32233)){
var statearr_32318_34850 = state_32296__$1;
(statearr_32318_34850[(1)] = (30));

} else {
var statearr_32319_34851 = state_32296__$1;
(statearr_32319_34851[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (1))){
var state_32296__$1 = state_32296;
var statearr_32320_34853 = state_32296__$1;
(statearr_32320_34853[(2)] = null);

(statearr_32320_34853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (24))){
var inst_32170 = (state_32296[(7)]);
var inst_32197 = (state_32296[(2)]);
var inst_32198 = cljs.core.next(inst_32170);
var inst_32146 = inst_32198;
var inst_32147 = null;
var inst_32148 = (0);
var inst_32149 = (0);
var state_32296__$1 = (function (){var statearr_32323 = state_32296;
(statearr_32323[(13)] = inst_32149);

(statearr_32323[(14)] = inst_32197);

(statearr_32323[(15)] = inst_32146);

(statearr_32323[(16)] = inst_32147);

(statearr_32323[(17)] = inst_32148);

return statearr_32323;
})();
var statearr_32325_34861 = state_32296__$1;
(statearr_32325_34861[(2)] = null);

(statearr_32325_34861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (39))){
var state_32296__$1 = state_32296;
var statearr_32336_34862 = state_32296__$1;
(statearr_32336_34862[(2)] = null);

(statearr_32336_34862[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (4))){
var inst_32132 = (state_32296[(10)]);
var inst_32132__$1 = (state_32296[(2)]);
var inst_32134 = (inst_32132__$1 == null);
var state_32296__$1 = (function (){var statearr_32337 = state_32296;
(statearr_32337[(10)] = inst_32132__$1);

return statearr_32337;
})();
if(cljs.core.truth_(inst_32134)){
var statearr_32341_34866 = state_32296__$1;
(statearr_32341_34866[(1)] = (5));

} else {
var statearr_32342_34867 = state_32296__$1;
(statearr_32342_34867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (15))){
var inst_32149 = (state_32296[(13)]);
var inst_32146 = (state_32296[(15)]);
var inst_32147 = (state_32296[(16)]);
var inst_32148 = (state_32296[(17)]);
var inst_32165 = (state_32296[(2)]);
var inst_32166 = (inst_32149 + (1));
var tmp32331 = inst_32146;
var tmp32332 = inst_32147;
var tmp32333 = inst_32148;
var inst_32146__$1 = tmp32331;
var inst_32147__$1 = tmp32332;
var inst_32148__$1 = tmp32333;
var inst_32149__$1 = inst_32166;
var state_32296__$1 = (function (){var statearr_32347 = state_32296;
(statearr_32347[(13)] = inst_32149__$1);

(statearr_32347[(15)] = inst_32146__$1);

(statearr_32347[(16)] = inst_32147__$1);

(statearr_32347[(17)] = inst_32148__$1);

(statearr_32347[(18)] = inst_32165);

return statearr_32347;
})();
var statearr_32348_34870 = state_32296__$1;
(statearr_32348_34870[(2)] = null);

(statearr_32348_34870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (21))){
var inst_32202 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32353_34871 = state_32296__$1;
(statearr_32353_34871[(2)] = inst_32202);

(statearr_32353_34871[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (31))){
var inst_32231 = (state_32296[(11)]);
var inst_32244 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32231);
var state_32296__$1 = state_32296;
var statearr_32354_34873 = state_32296__$1;
(statearr_32354_34873[(2)] = inst_32244);

(statearr_32354_34873[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (32))){
var inst_32224 = (state_32296[(19)]);
var inst_32223 = (state_32296[(9)]);
var inst_32222 = (state_32296[(20)]);
var inst_32225 = (state_32296[(12)]);
var inst_32246 = (state_32296[(2)]);
var inst_32247 = (inst_32225 + (1));
var tmp32350 = inst_32224;
var tmp32351 = inst_32223;
var tmp32352 = inst_32222;
var inst_32222__$1 = tmp32352;
var inst_32223__$1 = tmp32351;
var inst_32224__$1 = tmp32350;
var inst_32225__$1 = inst_32247;
var state_32296__$1 = (function (){var statearr_32360 = state_32296;
(statearr_32360[(19)] = inst_32224__$1);

(statearr_32360[(9)] = inst_32223__$1);

(statearr_32360[(20)] = inst_32222__$1);

(statearr_32360[(21)] = inst_32246);

(statearr_32360[(12)] = inst_32225__$1);

return statearr_32360;
})();
var statearr_32373_34885 = state_32296__$1;
(statearr_32373_34885[(2)] = null);

(statearr_32373_34885[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (40))){
var inst_32259 = (state_32296[(22)]);
var inst_32263 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32259);
var state_32296__$1 = state_32296;
var statearr_32379_34890 = state_32296__$1;
(statearr_32379_34890[(2)] = inst_32263);

(statearr_32379_34890[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (33))){
var inst_32250 = (state_32296[(23)]);
var inst_32252 = cljs.core.chunked_seq_QMARK_(inst_32250);
var state_32296__$1 = state_32296;
if(inst_32252){
var statearr_32383_34893 = state_32296__$1;
(statearr_32383_34893[(1)] = (36));

} else {
var statearr_32385_34894 = state_32296__$1;
(statearr_32385_34894[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (13))){
var inst_32158 = (state_32296[(24)]);
var inst_32161 = cljs.core.async.close_BANG_(inst_32158);
var state_32296__$1 = state_32296;
var statearr_32391_34895 = state_32296__$1;
(statearr_32391_34895[(2)] = inst_32161);

(statearr_32391_34895[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (22))){
var inst_32188 = (state_32296[(8)]);
var inst_32194 = cljs.core.async.close_BANG_(inst_32188);
var state_32296__$1 = state_32296;
var statearr_32393_34898 = state_32296__$1;
(statearr_32393_34898[(2)] = inst_32194);

(statearr_32393_34898[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (36))){
var inst_32250 = (state_32296[(23)]);
var inst_32254 = cljs.core.chunk_first(inst_32250);
var inst_32255 = cljs.core.chunk_rest(inst_32250);
var inst_32256 = cljs.core.count(inst_32254);
var inst_32222 = inst_32255;
var inst_32223 = inst_32254;
var inst_32224 = inst_32256;
var inst_32225 = (0);
var state_32296__$1 = (function (){var statearr_32397 = state_32296;
(statearr_32397[(19)] = inst_32224);

(statearr_32397[(9)] = inst_32223);

(statearr_32397[(20)] = inst_32222);

(statearr_32397[(12)] = inst_32225);

return statearr_32397;
})();
var statearr_32398_34901 = state_32296__$1;
(statearr_32398_34901[(2)] = null);

(statearr_32398_34901[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (41))){
var inst_32250 = (state_32296[(23)]);
var inst_32265 = (state_32296[(2)]);
var inst_32266 = cljs.core.next(inst_32250);
var inst_32222 = inst_32266;
var inst_32223 = null;
var inst_32224 = (0);
var inst_32225 = (0);
var state_32296__$1 = (function (){var statearr_32402 = state_32296;
(statearr_32402[(19)] = inst_32224);

(statearr_32402[(25)] = inst_32265);

(statearr_32402[(9)] = inst_32223);

(statearr_32402[(20)] = inst_32222);

(statearr_32402[(12)] = inst_32225);

return statearr_32402;
})();
var statearr_32407_34903 = state_32296__$1;
(statearr_32407_34903[(2)] = null);

(statearr_32407_34903[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (43))){
var state_32296__$1 = state_32296;
var statearr_32408_34905 = state_32296__$1;
(statearr_32408_34905[(2)] = null);

(statearr_32408_34905[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (29))){
var inst_32274 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32410_34907 = state_32296__$1;
(statearr_32410_34907[(2)] = inst_32274);

(statearr_32410_34907[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (44))){
var inst_32283 = (state_32296[(2)]);
var state_32296__$1 = (function (){var statearr_32414 = state_32296;
(statearr_32414[(26)] = inst_32283);

return statearr_32414;
})();
var statearr_32420_34911 = state_32296__$1;
(statearr_32420_34911[(2)] = null);

(statearr_32420_34911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (6))){
var inst_32214 = (state_32296[(27)]);
var inst_32213 = cljs.core.deref(cs);
var inst_32214__$1 = cljs.core.keys(inst_32213);
var inst_32215 = cljs.core.count(inst_32214__$1);
var inst_32216 = cljs.core.reset_BANG_(dctr,inst_32215);
var inst_32221 = cljs.core.seq(inst_32214__$1);
var inst_32222 = inst_32221;
var inst_32223 = null;
var inst_32224 = (0);
var inst_32225 = (0);
var state_32296__$1 = (function (){var statearr_32425 = state_32296;
(statearr_32425[(27)] = inst_32214__$1);

(statearr_32425[(19)] = inst_32224);

(statearr_32425[(28)] = inst_32216);

(statearr_32425[(9)] = inst_32223);

(statearr_32425[(20)] = inst_32222);

(statearr_32425[(12)] = inst_32225);

return statearr_32425;
})();
var statearr_32428_34929 = state_32296__$1;
(statearr_32428_34929[(2)] = null);

(statearr_32428_34929[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (28))){
var inst_32222 = (state_32296[(20)]);
var inst_32250 = (state_32296[(23)]);
var inst_32250__$1 = cljs.core.seq(inst_32222);
var state_32296__$1 = (function (){var statearr_32429 = state_32296;
(statearr_32429[(23)] = inst_32250__$1);

return statearr_32429;
})();
if(inst_32250__$1){
var statearr_32435_34930 = state_32296__$1;
(statearr_32435_34930[(1)] = (33));

} else {
var statearr_32437_34931 = state_32296__$1;
(statearr_32437_34931[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (25))){
var inst_32224 = (state_32296[(19)]);
var inst_32225 = (state_32296[(12)]);
var inst_32227 = (inst_32225 < inst_32224);
var inst_32228 = inst_32227;
var state_32296__$1 = state_32296;
if(cljs.core.truth_(inst_32228)){
var statearr_32439_34932 = state_32296__$1;
(statearr_32439_34932[(1)] = (27));

} else {
var statearr_32441_34942 = state_32296__$1;
(statearr_32441_34942[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (34))){
var state_32296__$1 = state_32296;
var statearr_32446_34950 = state_32296__$1;
(statearr_32446_34950[(2)] = null);

(statearr_32446_34950[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (17))){
var state_32296__$1 = state_32296;
var statearr_32449_34951 = state_32296__$1;
(statearr_32449_34951[(2)] = null);

(statearr_32449_34951[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (3))){
var inst_32288 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32296__$1,inst_32288);
} else {
if((state_val_32297 === (12))){
var inst_32208 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32453_34958 = state_32296__$1;
(statearr_32453_34958[(2)] = inst_32208);

(statearr_32453_34958[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (2))){
var state_32296__$1 = state_32296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32296__$1,(4),ch);
} else {
if((state_val_32297 === (23))){
var state_32296__$1 = state_32296;
var statearr_32456_34959 = state_32296__$1;
(statearr_32456_34959[(2)] = null);

(statearr_32456_34959[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (35))){
var inst_32272 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32458_34960 = state_32296__$1;
(statearr_32458_34960[(2)] = inst_32272);

(statearr_32458_34960[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (19))){
var inst_32170 = (state_32296[(7)]);
var inst_32176 = cljs.core.chunk_first(inst_32170);
var inst_32179 = cljs.core.chunk_rest(inst_32170);
var inst_32180 = cljs.core.count(inst_32176);
var inst_32146 = inst_32179;
var inst_32147 = inst_32176;
var inst_32148 = inst_32180;
var inst_32149 = (0);
var state_32296__$1 = (function (){var statearr_32460 = state_32296;
(statearr_32460[(13)] = inst_32149);

(statearr_32460[(15)] = inst_32146);

(statearr_32460[(16)] = inst_32147);

(statearr_32460[(17)] = inst_32148);

return statearr_32460;
})();
var statearr_32462_34963 = state_32296__$1;
(statearr_32462_34963[(2)] = null);

(statearr_32462_34963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (11))){
var inst_32146 = (state_32296[(15)]);
var inst_32170 = (state_32296[(7)]);
var inst_32170__$1 = cljs.core.seq(inst_32146);
var state_32296__$1 = (function (){var statearr_32464 = state_32296;
(statearr_32464[(7)] = inst_32170__$1);

return statearr_32464;
})();
if(inst_32170__$1){
var statearr_32466_34965 = state_32296__$1;
(statearr_32466_34965[(1)] = (16));

} else {
var statearr_32468_34966 = state_32296__$1;
(statearr_32468_34966[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (9))){
var inst_32210 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32469_34967 = state_32296__$1;
(statearr_32469_34967[(2)] = inst_32210);

(statearr_32469_34967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (5))){
var inst_32140 = cljs.core.deref(cs);
var inst_32141 = cljs.core.seq(inst_32140);
var inst_32146 = inst_32141;
var inst_32147 = null;
var inst_32148 = (0);
var inst_32149 = (0);
var state_32296__$1 = (function (){var statearr_32471 = state_32296;
(statearr_32471[(13)] = inst_32149);

(statearr_32471[(15)] = inst_32146);

(statearr_32471[(16)] = inst_32147);

(statearr_32471[(17)] = inst_32148);

return statearr_32471;
})();
var statearr_32472_34970 = state_32296__$1;
(statearr_32472_34970[(2)] = null);

(statearr_32472_34970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (14))){
var state_32296__$1 = state_32296;
var statearr_32473_34974 = state_32296__$1;
(statearr_32473_34974[(2)] = null);

(statearr_32473_34974[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (45))){
var inst_32280 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32475_34975 = state_32296__$1;
(statearr_32475_34975[(2)] = inst_32280);

(statearr_32475_34975[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (26))){
var inst_32214 = (state_32296[(27)]);
var inst_32276 = (state_32296[(2)]);
var inst_32277 = cljs.core.seq(inst_32214);
var state_32296__$1 = (function (){var statearr_32478 = state_32296;
(statearr_32478[(29)] = inst_32276);

return statearr_32478;
})();
if(inst_32277){
var statearr_32479_34980 = state_32296__$1;
(statearr_32479_34980[(1)] = (42));

} else {
var statearr_32480_34981 = state_32296__$1;
(statearr_32480_34981[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (16))){
var inst_32170 = (state_32296[(7)]);
var inst_32174 = cljs.core.chunked_seq_QMARK_(inst_32170);
var state_32296__$1 = state_32296;
if(inst_32174){
var statearr_32485_34982 = state_32296__$1;
(statearr_32485_34982[(1)] = (19));

} else {
var statearr_32486_34983 = state_32296__$1;
(statearr_32486_34983[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (38))){
var inst_32269 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32487_34985 = state_32296__$1;
(statearr_32487_34985[(2)] = inst_32269);

(statearr_32487_34985[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (30))){
var state_32296__$1 = state_32296;
var statearr_32489_34986 = state_32296__$1;
(statearr_32489_34986[(2)] = null);

(statearr_32489_34986[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (10))){
var inst_32149 = (state_32296[(13)]);
var inst_32147 = (state_32296[(16)]);
var inst_32157 = cljs.core._nth(inst_32147,inst_32149);
var inst_32158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32157,(0),null);
var inst_32159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32157,(1),null);
var state_32296__$1 = (function (){var statearr_32492 = state_32296;
(statearr_32492[(24)] = inst_32158);

return statearr_32492;
})();
if(cljs.core.truth_(inst_32159)){
var statearr_32493_34987 = state_32296__$1;
(statearr_32493_34987[(1)] = (13));

} else {
var statearr_32494_34988 = state_32296__$1;
(statearr_32494_34988[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (18))){
var inst_32206 = (state_32296[(2)]);
var state_32296__$1 = state_32296;
var statearr_32495_34989 = state_32296__$1;
(statearr_32495_34989[(2)] = inst_32206);

(statearr_32495_34989[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (42))){
var state_32296__$1 = state_32296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32296__$1,(45),dchan);
} else {
if((state_val_32297 === (37))){
var inst_32132 = (state_32296[(10)]);
var inst_32259 = (state_32296[(22)]);
var inst_32250 = (state_32296[(23)]);
var inst_32259__$1 = cljs.core.first(inst_32250);
var inst_32260 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32259__$1,inst_32132,done);
var state_32296__$1 = (function (){var statearr_32504 = state_32296;
(statearr_32504[(22)] = inst_32259__$1);

return statearr_32504;
})();
if(cljs.core.truth_(inst_32260)){
var statearr_32510_35001 = state_32296__$1;
(statearr_32510_35001[(1)] = (39));

} else {
var statearr_32512_35006 = state_32296__$1;
(statearr_32512_35006[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32297 === (8))){
var inst_32149 = (state_32296[(13)]);
var inst_32148 = (state_32296[(17)]);
var inst_32151 = (inst_32149 < inst_32148);
var inst_32152 = inst_32151;
var state_32296__$1 = state_32296;
if(cljs.core.truth_(inst_32152)){
var statearr_32522_35011 = state_32296__$1;
(statearr_32522_35011[(1)] = (10));

} else {
var statearr_32523_35012 = state_32296__$1;
(statearr_32523_35012[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__30481__auto__ = null;
var cljs$core$async$mult_$_state_machine__30481__auto____0 = (function (){
var statearr_32526 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32526[(0)] = cljs$core$async$mult_$_state_machine__30481__auto__);

(statearr_32526[(1)] = (1));

return statearr_32526;
});
var cljs$core$async$mult_$_state_machine__30481__auto____1 = (function (state_32296){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_32296);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e32527){var ex__30484__auto__ = e32527;
var statearr_32530_35019 = state_32296;
(statearr_32530_35019[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_32296[(4)]))){
var statearr_32532_35020 = state_32296;
(statearr_32532_35020[(1)] = cljs.core.first((state_32296[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35024 = state_32296;
state_32296 = G__35024;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30481__auto__ = function(state_32296){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30481__auto____1.call(this,state_32296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30481__auto____0;
cljs$core$async$mult_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30481__auto____1;
return cljs$core$async$mult_$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_32535 = f__30938__auto__();
(statearr_32535[(6)] = c__30937__auto___34838);

return statearr_32535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32543 = arguments.length;
switch (G__32543) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_35030 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_35030(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_35031 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_35031(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_35034 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_35034(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_35035 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_35035(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_35044 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_35044(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35048 = arguments.length;
var i__5770__auto___35049 = (0);
while(true){
if((i__5770__auto___35049 < len__5769__auto___35048)){
args__5775__auto__.push((arguments[i__5770__auto___35049]));

var G__35050 = (i__5770__auto___35049 + (1));
i__5770__auto___35049 = G__35050;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32588){
var map__32589 = p__32588;
var map__32589__$1 = cljs.core.__destructure_map(map__32589);
var opts = map__32589__$1;
var statearr_32590_35051 = state;
(statearr_32590_35051[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32591_35052 = state;
(statearr_32591_35052[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32592_35053 = state;
(statearr_32592_35053[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32580){
var G__32581 = cljs.core.first(seq32580);
var seq32580__$1 = cljs.core.next(seq32580);
var G__32582 = cljs.core.first(seq32580__$1);
var seq32580__$2 = cljs.core.next(seq32580__$1);
var G__32583 = cljs.core.first(seq32580__$2);
var seq32580__$3 = cljs.core.next(seq32580__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32581,G__32582,G__32583,seq32580__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32594 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32594 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32595){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32595 = meta32595;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32596,meta32595__$1){
var self__ = this;
var _32596__$1 = this;
return (new cljs.core.async.t_cljs$core$async32594(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32595__$1));
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32596){
var self__ = this;
var _32596__$1 = this;
return self__.meta32595;
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32594.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32594.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32595","meta32595",2034889944,null)], null);
}));

(cljs.core.async.t_cljs$core$async32594.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32594.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32594");

(cljs.core.async.t_cljs$core$async32594.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32594");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32594.
 */
cljs.core.async.__GT_t_cljs$core$async32594 = (function cljs$core$async$mix_$___GT_t_cljs$core$async32594(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32595){
return (new cljs.core.async.t_cljs$core$async32594(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32595));
});

}

return (new cljs.core.async.t_cljs$core$async32594(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30937__auto___35073 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_32686){
var state_val_32687 = (state_32686[(1)]);
if((state_val_32687 === (7))){
var inst_32643 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
if(cljs.core.truth_(inst_32643)){
var statearr_32689_35075 = state_32686__$1;
(statearr_32689_35075[(1)] = (8));

} else {
var statearr_32690_35077 = state_32686__$1;
(statearr_32690_35077[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (20))){
var inst_32636 = (state_32686[(7)]);
var state_32686__$1 = state_32686;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32686__$1,(23),out,inst_32636);
} else {
if((state_val_32687 === (1))){
var inst_32616 = calc_state();
var inst_32617 = cljs.core.__destructure_map(inst_32616);
var inst_32618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32617,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32617,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32617,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32621 = inst_32616;
var state_32686__$1 = (function (){var statearr_32692 = state_32686;
(statearr_32692[(8)] = inst_32621);

(statearr_32692[(9)] = inst_32620);

(statearr_32692[(10)] = inst_32619);

(statearr_32692[(11)] = inst_32618);

return statearr_32692;
})();
var statearr_32695_35079 = state_32686__$1;
(statearr_32695_35079[(2)] = null);

(statearr_32695_35079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (24))){
var inst_32626 = (state_32686[(12)]);
var inst_32621 = inst_32626;
var state_32686__$1 = (function (){var statearr_32702 = state_32686;
(statearr_32702[(8)] = inst_32621);

return statearr_32702;
})();
var statearr_32703_35082 = state_32686__$1;
(statearr_32703_35082[(2)] = null);

(statearr_32703_35082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (4))){
var inst_32638 = (state_32686[(13)]);
var inst_32636 = (state_32686[(7)]);
var inst_32634 = (state_32686[(2)]);
var inst_32636__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32634,(0),null);
var inst_32637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32634,(1),null);
var inst_32638__$1 = (inst_32636__$1 == null);
var state_32686__$1 = (function (){var statearr_32704 = state_32686;
(statearr_32704[(13)] = inst_32638__$1);

(statearr_32704[(7)] = inst_32636__$1);

(statearr_32704[(14)] = inst_32637);

return statearr_32704;
})();
if(cljs.core.truth_(inst_32638__$1)){
var statearr_32705_35083 = state_32686__$1;
(statearr_32705_35083[(1)] = (5));

} else {
var statearr_32706_35084 = state_32686__$1;
(statearr_32706_35084[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (15))){
var inst_32627 = (state_32686[(15)]);
var inst_32657 = (state_32686[(16)]);
var inst_32657__$1 = cljs.core.empty_QMARK_(inst_32627);
var state_32686__$1 = (function (){var statearr_32711 = state_32686;
(statearr_32711[(16)] = inst_32657__$1);

return statearr_32711;
})();
if(inst_32657__$1){
var statearr_32712_35085 = state_32686__$1;
(statearr_32712_35085[(1)] = (17));

} else {
var statearr_32713_35086 = state_32686__$1;
(statearr_32713_35086[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (21))){
var inst_32626 = (state_32686[(12)]);
var inst_32621 = inst_32626;
var state_32686__$1 = (function (){var statearr_32718 = state_32686;
(statearr_32718[(8)] = inst_32621);

return statearr_32718;
})();
var statearr_32723_35087 = state_32686__$1;
(statearr_32723_35087[(2)] = null);

(statearr_32723_35087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (13))){
var inst_32650 = (state_32686[(2)]);
var inst_32651 = calc_state();
var inst_32621 = inst_32651;
var state_32686__$1 = (function (){var statearr_32724 = state_32686;
(statearr_32724[(8)] = inst_32621);

(statearr_32724[(17)] = inst_32650);

return statearr_32724;
})();
var statearr_32726_35091 = state_32686__$1;
(statearr_32726_35091[(2)] = null);

(statearr_32726_35091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (22))){
var inst_32680 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
var statearr_32729_35093 = state_32686__$1;
(statearr_32729_35093[(2)] = inst_32680);

(statearr_32729_35093[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (6))){
var inst_32637 = (state_32686[(14)]);
var inst_32641 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32637,change);
var state_32686__$1 = state_32686;
var statearr_32730_35100 = state_32686__$1;
(statearr_32730_35100[(2)] = inst_32641);

(statearr_32730_35100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (25))){
var state_32686__$1 = state_32686;
var statearr_32731_35101 = state_32686__$1;
(statearr_32731_35101[(2)] = null);

(statearr_32731_35101[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (17))){
var inst_32637 = (state_32686[(14)]);
var inst_32628 = (state_32686[(18)]);
var inst_32661 = (inst_32628.cljs$core$IFn$_invoke$arity$1 ? inst_32628.cljs$core$IFn$_invoke$arity$1(inst_32637) : inst_32628.call(null,inst_32637));
var inst_32662 = cljs.core.not(inst_32661);
var state_32686__$1 = state_32686;
var statearr_32734_35102 = state_32686__$1;
(statearr_32734_35102[(2)] = inst_32662);

(statearr_32734_35102[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (3))){
var inst_32684 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32686__$1,inst_32684);
} else {
if((state_val_32687 === (12))){
var state_32686__$1 = state_32686;
var statearr_32737_35103 = state_32686__$1;
(statearr_32737_35103[(2)] = null);

(statearr_32737_35103[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (2))){
var inst_32621 = (state_32686[(8)]);
var inst_32626 = (state_32686[(12)]);
var inst_32626__$1 = cljs.core.__destructure_map(inst_32621);
var inst_32627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32626__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32626__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32626__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32686__$1 = (function (){var statearr_32740 = state_32686;
(statearr_32740[(15)] = inst_32627);

(statearr_32740[(12)] = inst_32626__$1);

(statearr_32740[(18)] = inst_32628);

return statearr_32740;
})();
return cljs.core.async.ioc_alts_BANG_(state_32686__$1,(4),inst_32629);
} else {
if((state_val_32687 === (23))){
var inst_32670 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
if(cljs.core.truth_(inst_32670)){
var statearr_32742_35106 = state_32686__$1;
(statearr_32742_35106[(1)] = (24));

} else {
var statearr_32743_35110 = state_32686__$1;
(statearr_32743_35110[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (19))){
var inst_32665 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
var statearr_32744_35111 = state_32686__$1;
(statearr_32744_35111[(2)] = inst_32665);

(statearr_32744_35111[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (11))){
var inst_32637 = (state_32686[(14)]);
var inst_32647 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32637);
var state_32686__$1 = state_32686;
var statearr_32745_35112 = state_32686__$1;
(statearr_32745_35112[(2)] = inst_32647);

(statearr_32745_35112[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (9))){
var inst_32627 = (state_32686[(15)]);
var inst_32654 = (state_32686[(19)]);
var inst_32637 = (state_32686[(14)]);
var inst_32654__$1 = (inst_32627.cljs$core$IFn$_invoke$arity$1 ? inst_32627.cljs$core$IFn$_invoke$arity$1(inst_32637) : inst_32627.call(null,inst_32637));
var state_32686__$1 = (function (){var statearr_32747 = state_32686;
(statearr_32747[(19)] = inst_32654__$1);

return statearr_32747;
})();
if(cljs.core.truth_(inst_32654__$1)){
var statearr_32748_35115 = state_32686__$1;
(statearr_32748_35115[(1)] = (14));

} else {
var statearr_32749_35120 = state_32686__$1;
(statearr_32749_35120[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (5))){
var inst_32638 = (state_32686[(13)]);
var state_32686__$1 = state_32686;
var statearr_32757_35121 = state_32686__$1;
(statearr_32757_35121[(2)] = inst_32638);

(statearr_32757_35121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (14))){
var inst_32654 = (state_32686[(19)]);
var state_32686__$1 = state_32686;
var statearr_32760_35126 = state_32686__$1;
(statearr_32760_35126[(2)] = inst_32654);

(statearr_32760_35126[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (26))){
var inst_32676 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
var statearr_32761_35132 = state_32686__$1;
(statearr_32761_35132[(2)] = inst_32676);

(statearr_32761_35132[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (16))){
var inst_32667 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
if(cljs.core.truth_(inst_32667)){
var statearr_32762_35133 = state_32686__$1;
(statearr_32762_35133[(1)] = (20));

} else {
var statearr_32763_35134 = state_32686__$1;
(statearr_32763_35134[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (10))){
var inst_32682 = (state_32686[(2)]);
var state_32686__$1 = state_32686;
var statearr_32765_35138 = state_32686__$1;
(statearr_32765_35138[(2)] = inst_32682);

(statearr_32765_35138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (18))){
var inst_32657 = (state_32686[(16)]);
var state_32686__$1 = state_32686;
var statearr_32766_35146 = state_32686__$1;
(statearr_32766_35146[(2)] = inst_32657);

(statearr_32766_35146[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32687 === (8))){
var inst_32636 = (state_32686[(7)]);
var inst_32645 = (inst_32636 == null);
var state_32686__$1 = state_32686;
if(cljs.core.truth_(inst_32645)){
var statearr_32769_35151 = state_32686__$1;
(statearr_32769_35151[(1)] = (11));

} else {
var statearr_32772_35155 = state_32686__$1;
(statearr_32772_35155[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__30481__auto__ = null;
var cljs$core$async$mix_$_state_machine__30481__auto____0 = (function (){
var statearr_32774 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32774[(0)] = cljs$core$async$mix_$_state_machine__30481__auto__);

(statearr_32774[(1)] = (1));

return statearr_32774;
});
var cljs$core$async$mix_$_state_machine__30481__auto____1 = (function (state_32686){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_32686);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e32778){var ex__30484__auto__ = e32778;
var statearr_32783_35157 = state_32686;
(statearr_32783_35157[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_32686[(4)]))){
var statearr_32784_35158 = state_32686;
(statearr_32784_35158[(1)] = cljs.core.first((state_32686[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35159 = state_32686;
state_32686 = G__35159;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30481__auto__ = function(state_32686){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30481__auto____1.call(this,state_32686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30481__auto____0;
cljs$core$async$mix_$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30481__auto____1;
return cljs$core$async$mix_$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_32786 = f__30938__auto__();
(statearr_32786[(6)] = c__30937__auto___35073);

return statearr_32786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_35171 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_35171(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_35186 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_35186(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_35197 = (function() {
var G__35198 = null;
var G__35198__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__35198__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__35198 = function(p,v){
switch(arguments.length){
case 1:
return G__35198__1.call(this,p);
case 2:
return G__35198__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35198.cljs$core$IFn$_invoke$arity$1 = G__35198__1;
G__35198.cljs$core$IFn$_invoke$arity$2 = G__35198__2;
return G__35198;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32796 = arguments.length;
switch (G__32796) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35197(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_35197(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32803 = arguments.length;
switch (G__32803) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32800_SHARP_){
if(cljs.core.truth_((p1__32800_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32800_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32800_SHARP_.call(null,topic)))){
return p1__32800_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32800_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async32810 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32810 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32811){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32811 = meta32811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32812,meta32811__$1){
var self__ = this;
var _32812__$1 = this;
return (new cljs.core.async.t_cljs$core$async32810(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32811__$1));
}));

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32812){
var self__ = this;
var _32812__$1 = this;
return self__.meta32811;
}));

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32810.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32810.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32811","meta32811",-748503315,null)], null);
}));

(cljs.core.async.t_cljs$core$async32810.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32810");

(cljs.core.async.t_cljs$core$async32810.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32810");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32810.
 */
cljs.core.async.__GT_t_cljs$core$async32810 = (function cljs$core$async$__GT_t_cljs$core$async32810(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32811){
return (new cljs.core.async.t_cljs$core$async32810(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32811));
});

}

return (new cljs.core.async.t_cljs$core$async32810(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30937__auto___35209 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_32930){
var state_val_32931 = (state_32930[(1)]);
if((state_val_32931 === (7))){
var inst_32926 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
var statearr_32933_35210 = state_32930__$1;
(statearr_32933_35210[(2)] = inst_32926);

(statearr_32933_35210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (20))){
var state_32930__$1 = state_32930;
var statearr_32934_35212 = state_32930__$1;
(statearr_32934_35212[(2)] = null);

(statearr_32934_35212[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (1))){
var state_32930__$1 = state_32930;
var statearr_32935_35213 = state_32930__$1;
(statearr_32935_35213[(2)] = null);

(statearr_32935_35213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (24))){
var inst_32908 = (state_32930[(7)]);
var inst_32918 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32908);
var state_32930__$1 = state_32930;
var statearr_32937_35214 = state_32930__$1;
(statearr_32937_35214[(2)] = inst_32918);

(statearr_32937_35214[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (4))){
var inst_32846 = (state_32930[(8)]);
var inst_32846__$1 = (state_32930[(2)]);
var inst_32847 = (inst_32846__$1 == null);
var state_32930__$1 = (function (){var statearr_32940 = state_32930;
(statearr_32940[(8)] = inst_32846__$1);

return statearr_32940;
})();
if(cljs.core.truth_(inst_32847)){
var statearr_32941_35215 = state_32930__$1;
(statearr_32941_35215[(1)] = (5));

} else {
var statearr_32942_35216 = state_32930__$1;
(statearr_32942_35216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (15))){
var inst_32902 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
var statearr_32943_35217 = state_32930__$1;
(statearr_32943_35217[(2)] = inst_32902);

(statearr_32943_35217[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (21))){
var inst_32923 = (state_32930[(2)]);
var state_32930__$1 = (function (){var statearr_32944 = state_32930;
(statearr_32944[(9)] = inst_32923);

return statearr_32944;
})();
var statearr_32945_35218 = state_32930__$1;
(statearr_32945_35218[(2)] = null);

(statearr_32945_35218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (13))){
var inst_32878 = (state_32930[(10)]);
var inst_32881 = cljs.core.chunked_seq_QMARK_(inst_32878);
var state_32930__$1 = state_32930;
if(inst_32881){
var statearr_32946_35219 = state_32930__$1;
(statearr_32946_35219[(1)] = (16));

} else {
var statearr_32947_35220 = state_32930__$1;
(statearr_32947_35220[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (22))){
var inst_32915 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
if(cljs.core.truth_(inst_32915)){
var statearr_32950_35223 = state_32930__$1;
(statearr_32950_35223[(1)] = (23));

} else {
var statearr_32951_35224 = state_32930__$1;
(statearr_32951_35224[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (6))){
var inst_32846 = (state_32930[(8)]);
var inst_32908 = (state_32930[(7)]);
var inst_32910 = (state_32930[(11)]);
var inst_32908__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32846) : topic_fn.call(null,inst_32846));
var inst_32909 = cljs.core.deref(mults);
var inst_32910__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32909,inst_32908__$1);
var state_32930__$1 = (function (){var statearr_32961 = state_32930;
(statearr_32961[(7)] = inst_32908__$1);

(statearr_32961[(11)] = inst_32910__$1);

return statearr_32961;
})();
if(cljs.core.truth_(inst_32910__$1)){
var statearr_32963_35225 = state_32930__$1;
(statearr_32963_35225[(1)] = (19));

} else {
var statearr_32966_35226 = state_32930__$1;
(statearr_32966_35226[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (25))){
var inst_32920 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
var statearr_32967_35227 = state_32930__$1;
(statearr_32967_35227[(2)] = inst_32920);

(statearr_32967_35227[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (17))){
var inst_32878 = (state_32930[(10)]);
var inst_32892 = cljs.core.first(inst_32878);
var inst_32894 = cljs.core.async.muxch_STAR_(inst_32892);
var inst_32895 = cljs.core.async.close_BANG_(inst_32894);
var inst_32896 = cljs.core.next(inst_32878);
var inst_32856 = inst_32896;
var inst_32857 = null;
var inst_32858 = (0);
var inst_32859 = (0);
var state_32930__$1 = (function (){var statearr_32982 = state_32930;
(statearr_32982[(12)] = inst_32857);

(statearr_32982[(13)] = inst_32859);

(statearr_32982[(14)] = inst_32856);

(statearr_32982[(15)] = inst_32858);

(statearr_32982[(16)] = inst_32895);

return statearr_32982;
})();
var statearr_32985_35229 = state_32930__$1;
(statearr_32985_35229[(2)] = null);

(statearr_32985_35229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (3))){
var inst_32928 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32930__$1,inst_32928);
} else {
if((state_val_32931 === (12))){
var inst_32904 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
var statearr_32991_35240 = state_32930__$1;
(statearr_32991_35240[(2)] = inst_32904);

(statearr_32991_35240[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (2))){
var state_32930__$1 = state_32930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32930__$1,(4),ch);
} else {
if((state_val_32931 === (23))){
var state_32930__$1 = state_32930;
var statearr_32992_35242 = state_32930__$1;
(statearr_32992_35242[(2)] = null);

(statearr_32992_35242[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (19))){
var inst_32846 = (state_32930[(8)]);
var inst_32910 = (state_32930[(11)]);
var inst_32913 = cljs.core.async.muxch_STAR_(inst_32910);
var state_32930__$1 = state_32930;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32930__$1,(22),inst_32913,inst_32846);
} else {
if((state_val_32931 === (11))){
var inst_32878 = (state_32930[(10)]);
var inst_32856 = (state_32930[(14)]);
var inst_32878__$1 = cljs.core.seq(inst_32856);
var state_32930__$1 = (function (){var statearr_32993 = state_32930;
(statearr_32993[(10)] = inst_32878__$1);

return statearr_32993;
})();
if(inst_32878__$1){
var statearr_32995_35247 = state_32930__$1;
(statearr_32995_35247[(1)] = (13));

} else {
var statearr_32996_35249 = state_32930__$1;
(statearr_32996_35249[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (9))){
var inst_32906 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
var statearr_32997_35253 = state_32930__$1;
(statearr_32997_35253[(2)] = inst_32906);

(statearr_32997_35253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (5))){
var inst_32853 = cljs.core.deref(mults);
var inst_32854 = cljs.core.vals(inst_32853);
var inst_32855 = cljs.core.seq(inst_32854);
var inst_32856 = inst_32855;
var inst_32857 = null;
var inst_32858 = (0);
var inst_32859 = (0);
var state_32930__$1 = (function (){var statearr_32999 = state_32930;
(statearr_32999[(12)] = inst_32857);

(statearr_32999[(13)] = inst_32859);

(statearr_32999[(14)] = inst_32856);

(statearr_32999[(15)] = inst_32858);

return statearr_32999;
})();
var statearr_33000_35256 = state_32930__$1;
(statearr_33000_35256[(2)] = null);

(statearr_33000_35256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (14))){
var state_32930__$1 = state_32930;
var statearr_33004_35258 = state_32930__$1;
(statearr_33004_35258[(2)] = null);

(statearr_33004_35258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (16))){
var inst_32878 = (state_32930[(10)]);
var inst_32887 = cljs.core.chunk_first(inst_32878);
var inst_32888 = cljs.core.chunk_rest(inst_32878);
var inst_32889 = cljs.core.count(inst_32887);
var inst_32856 = inst_32888;
var inst_32857 = inst_32887;
var inst_32858 = inst_32889;
var inst_32859 = (0);
var state_32930__$1 = (function (){var statearr_33005 = state_32930;
(statearr_33005[(12)] = inst_32857);

(statearr_33005[(13)] = inst_32859);

(statearr_33005[(14)] = inst_32856);

(statearr_33005[(15)] = inst_32858);

return statearr_33005;
})();
var statearr_33006_35259 = state_32930__$1;
(statearr_33006_35259[(2)] = null);

(statearr_33006_35259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (10))){
var inst_32857 = (state_32930[(12)]);
var inst_32859 = (state_32930[(13)]);
var inst_32856 = (state_32930[(14)]);
var inst_32858 = (state_32930[(15)]);
var inst_32868 = cljs.core._nth(inst_32857,inst_32859);
var inst_32869 = cljs.core.async.muxch_STAR_(inst_32868);
var inst_32870 = cljs.core.async.close_BANG_(inst_32869);
var inst_32871 = (inst_32859 + (1));
var tmp33001 = inst_32857;
var tmp33002 = inst_32856;
var tmp33003 = inst_32858;
var inst_32856__$1 = tmp33002;
var inst_32857__$1 = tmp33001;
var inst_32858__$1 = tmp33003;
var inst_32859__$1 = inst_32871;
var state_32930__$1 = (function (){var statearr_33007 = state_32930;
(statearr_33007[(12)] = inst_32857__$1);

(statearr_33007[(13)] = inst_32859__$1);

(statearr_33007[(17)] = inst_32870);

(statearr_33007[(14)] = inst_32856__$1);

(statearr_33007[(15)] = inst_32858__$1);

return statearr_33007;
})();
var statearr_33008_35260 = state_32930__$1;
(statearr_33008_35260[(2)] = null);

(statearr_33008_35260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (18))){
var inst_32899 = (state_32930[(2)]);
var state_32930__$1 = state_32930;
var statearr_33010_35261 = state_32930__$1;
(statearr_33010_35261[(2)] = inst_32899);

(statearr_33010_35261[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32931 === (8))){
var inst_32859 = (state_32930[(13)]);
var inst_32858 = (state_32930[(15)]);
var inst_32861 = (inst_32859 < inst_32858);
var inst_32862 = inst_32861;
var state_32930__$1 = state_32930;
if(cljs.core.truth_(inst_32862)){
var statearr_33011_35262 = state_32930__$1;
(statearr_33011_35262[(1)] = (10));

} else {
var statearr_33012_35263 = state_32930__$1;
(statearr_33012_35263[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33017[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33017[(1)] = (1));

return statearr_33017;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_32930){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_32930);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33018){var ex__30484__auto__ = e33018;
var statearr_33019_35264 = state_32930;
(statearr_33019_35264[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_32930[(4)]))){
var statearr_33024_35265 = state_32930;
(statearr_33024_35265[(1)] = cljs.core.first((state_32930[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35266 = state_32930;
state_32930 = G__35266;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_32930){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_32930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33029 = f__30938__auto__();
(statearr_33029[(6)] = c__30937__auto___35209);

return statearr_33029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__33032 = arguments.length;
switch (G__33032) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__33037 = arguments.length;
switch (G__33037) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__33045 = arguments.length;
switch (G__33045) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30937__auto___35273 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33099){
var state_val_33100 = (state_33099[(1)]);
if((state_val_33100 === (7))){
var state_33099__$1 = state_33099;
var statearr_33104_35274 = state_33099__$1;
(statearr_33104_35274[(2)] = null);

(statearr_33104_35274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (1))){
var state_33099__$1 = state_33099;
var statearr_33107_35275 = state_33099__$1;
(statearr_33107_35275[(2)] = null);

(statearr_33107_35275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (4))){
var inst_33050 = (state_33099[(7)]);
var inst_33051 = (state_33099[(8)]);
var inst_33055 = (inst_33051 < inst_33050);
var state_33099__$1 = state_33099;
if(cljs.core.truth_(inst_33055)){
var statearr_33111_35276 = state_33099__$1;
(statearr_33111_35276[(1)] = (6));

} else {
var statearr_33112_35277 = state_33099__$1;
(statearr_33112_35277[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (15))){
var inst_33084 = (state_33099[(9)]);
var inst_33089 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33084);
var state_33099__$1 = state_33099;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33099__$1,(17),out,inst_33089);
} else {
if((state_val_33100 === (13))){
var inst_33084 = (state_33099[(9)]);
var inst_33084__$1 = (state_33099[(2)]);
var inst_33085 = cljs.core.some(cljs.core.nil_QMARK_,inst_33084__$1);
var state_33099__$1 = (function (){var statearr_33115 = state_33099;
(statearr_33115[(9)] = inst_33084__$1);

return statearr_33115;
})();
if(cljs.core.truth_(inst_33085)){
var statearr_33116_35278 = state_33099__$1;
(statearr_33116_35278[(1)] = (14));

} else {
var statearr_33117_35279 = state_33099__$1;
(statearr_33117_35279[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (6))){
var state_33099__$1 = state_33099;
var statearr_33118_35280 = state_33099__$1;
(statearr_33118_35280[(2)] = null);

(statearr_33118_35280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (17))){
var inst_33091 = (state_33099[(2)]);
var state_33099__$1 = (function (){var statearr_33122 = state_33099;
(statearr_33122[(10)] = inst_33091);

return statearr_33122;
})();
var statearr_33123_35281 = state_33099__$1;
(statearr_33123_35281[(2)] = null);

(statearr_33123_35281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (3))){
var inst_33096 = (state_33099[(2)]);
var state_33099__$1 = state_33099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33099__$1,inst_33096);
} else {
if((state_val_33100 === (12))){
var _ = (function (){var statearr_33125 = state_33099;
(statearr_33125[(4)] = cljs.core.rest((state_33099[(4)])));

return statearr_33125;
})();
var state_33099__$1 = state_33099;
var ex33121 = (state_33099__$1[(2)]);
var statearr_33126_35294 = state_33099__$1;
(statearr_33126_35294[(5)] = ex33121);


if((ex33121 instanceof Object)){
var statearr_33133_35295 = state_33099__$1;
(statearr_33133_35295[(1)] = (11));

(statearr_33133_35295[(5)] = null);

} else {
throw ex33121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (2))){
var inst_33048 = cljs.core.reset_BANG_(dctr,cnt);
var inst_33050 = cnt;
var inst_33051 = (0);
var state_33099__$1 = (function (){var statearr_33136 = state_33099;
(statearr_33136[(7)] = inst_33050);

(statearr_33136[(8)] = inst_33051);

(statearr_33136[(11)] = inst_33048);

return statearr_33136;
})();
var statearr_33137_35300 = state_33099__$1;
(statearr_33137_35300[(2)] = null);

(statearr_33137_35300[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (11))){
var inst_33059 = (state_33099[(2)]);
var inst_33061 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33099__$1 = (function (){var statearr_33140 = state_33099;
(statearr_33140[(12)] = inst_33059);

return statearr_33140;
})();
var statearr_33141_35304 = state_33099__$1;
(statearr_33141_35304[(2)] = inst_33061);

(statearr_33141_35304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (9))){
var inst_33051 = (state_33099[(8)]);
var _ = (function (){var statearr_33143 = state_33099;
(statearr_33143[(4)] = cljs.core.cons((12),(state_33099[(4)])));

return statearr_33143;
})();
var inst_33069 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33051) : chs__$1.call(null,inst_33051));
var inst_33070 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33051) : done.call(null,inst_33051));
var inst_33071 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33069,inst_33070);
var ___$1 = (function (){var statearr_33147 = state_33099;
(statearr_33147[(4)] = cljs.core.rest((state_33099[(4)])));

return statearr_33147;
})();
var state_33099__$1 = state_33099;
var statearr_33148_35306 = state_33099__$1;
(statearr_33148_35306[(2)] = inst_33071);

(statearr_33148_35306[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (5))){
var inst_33082 = (state_33099[(2)]);
var state_33099__$1 = (function (){var statearr_33149 = state_33099;
(statearr_33149[(13)] = inst_33082);

return statearr_33149;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33099__$1,(13),dchan);
} else {
if((state_val_33100 === (14))){
var inst_33087 = cljs.core.async.close_BANG_(out);
var state_33099__$1 = state_33099;
var statearr_33150_35310 = state_33099__$1;
(statearr_33150_35310[(2)] = inst_33087);

(statearr_33150_35310[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (16))){
var inst_33094 = (state_33099[(2)]);
var state_33099__$1 = state_33099;
var statearr_33156_35311 = state_33099__$1;
(statearr_33156_35311[(2)] = inst_33094);

(statearr_33156_35311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (10))){
var inst_33051 = (state_33099[(8)]);
var inst_33074 = (state_33099[(2)]);
var inst_33076 = (inst_33051 + (1));
var inst_33051__$1 = inst_33076;
var state_33099__$1 = (function (){var statearr_33159 = state_33099;
(statearr_33159[(14)] = inst_33074);

(statearr_33159[(8)] = inst_33051__$1);

return statearr_33159;
})();
var statearr_33160_35312 = state_33099__$1;
(statearr_33160_35312[(2)] = null);

(statearr_33160_35312[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33100 === (8))){
var inst_33080 = (state_33099[(2)]);
var state_33099__$1 = state_33099;
var statearr_33163_35316 = state_33099__$1;
(statearr_33163_35316[(2)] = inst_33080);

(statearr_33163_35316[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33165 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33165[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33165[(1)] = (1));

return statearr_33165;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_33099){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33099);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33166){var ex__30484__auto__ = e33166;
var statearr_33167_35317 = state_33099;
(statearr_33167_35317[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33099[(4)]))){
var statearr_33168_35318 = state_33099;
(statearr_33168_35318[(1)] = cljs.core.first((state_33099[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35322 = state_33099;
state_33099 = G__35322;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_33099){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_33099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33170 = f__30938__auto__();
(statearr_33170[(6)] = c__30937__auto___35273);

return statearr_33170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33177 = arguments.length;
switch (G__33177) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30937__auto___35324 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33214){
var state_val_33215 = (state_33214[(1)]);
if((state_val_33215 === (7))){
var inst_33192 = (state_33214[(7)]);
var inst_33193 = (state_33214[(8)]);
var inst_33192__$1 = (state_33214[(2)]);
var inst_33193__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33192__$1,(0),null);
var inst_33194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33192__$1,(1),null);
var inst_33195 = (inst_33193__$1 == null);
var state_33214__$1 = (function (){var statearr_33217 = state_33214;
(statearr_33217[(7)] = inst_33192__$1);

(statearr_33217[(8)] = inst_33193__$1);

(statearr_33217[(9)] = inst_33194);

return statearr_33217;
})();
if(cljs.core.truth_(inst_33195)){
var statearr_33218_35328 = state_33214__$1;
(statearr_33218_35328[(1)] = (8));

} else {
var statearr_33220_35329 = state_33214__$1;
(statearr_33220_35329[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (1))){
var inst_33182 = cljs.core.vec(chs);
var inst_33183 = inst_33182;
var state_33214__$1 = (function (){var statearr_33221 = state_33214;
(statearr_33221[(10)] = inst_33183);

return statearr_33221;
})();
var statearr_33222_35330 = state_33214__$1;
(statearr_33222_35330[(2)] = null);

(statearr_33222_35330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (4))){
var inst_33183 = (state_33214[(10)]);
var state_33214__$1 = state_33214;
return cljs.core.async.ioc_alts_BANG_(state_33214__$1,(7),inst_33183);
} else {
if((state_val_33215 === (6))){
var inst_33209 = (state_33214[(2)]);
var state_33214__$1 = state_33214;
var statearr_33225_35334 = state_33214__$1;
(statearr_33225_35334[(2)] = inst_33209);

(statearr_33225_35334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (3))){
var inst_33211 = (state_33214[(2)]);
var state_33214__$1 = state_33214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33214__$1,inst_33211);
} else {
if((state_val_33215 === (2))){
var inst_33183 = (state_33214[(10)]);
var inst_33185 = cljs.core.count(inst_33183);
var inst_33186 = (inst_33185 > (0));
var state_33214__$1 = state_33214;
if(cljs.core.truth_(inst_33186)){
var statearr_33227_35343 = state_33214__$1;
(statearr_33227_35343[(1)] = (4));

} else {
var statearr_33228_35344 = state_33214__$1;
(statearr_33228_35344[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (11))){
var inst_33183 = (state_33214[(10)]);
var inst_33202 = (state_33214[(2)]);
var tmp33226 = inst_33183;
var inst_33183__$1 = tmp33226;
var state_33214__$1 = (function (){var statearr_33229 = state_33214;
(statearr_33229[(10)] = inst_33183__$1);

(statearr_33229[(11)] = inst_33202);

return statearr_33229;
})();
var statearr_33230_35351 = state_33214__$1;
(statearr_33230_35351[(2)] = null);

(statearr_33230_35351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (9))){
var inst_33193 = (state_33214[(8)]);
var state_33214__$1 = state_33214;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33214__$1,(11),out,inst_33193);
} else {
if((state_val_33215 === (5))){
var inst_33207 = cljs.core.async.close_BANG_(out);
var state_33214__$1 = state_33214;
var statearr_33234_35352 = state_33214__$1;
(statearr_33234_35352[(2)] = inst_33207);

(statearr_33234_35352[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (10))){
var inst_33205 = (state_33214[(2)]);
var state_33214__$1 = state_33214;
var statearr_33235_35353 = state_33214__$1;
(statearr_33235_35353[(2)] = inst_33205);

(statearr_33235_35353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33215 === (8))){
var inst_33183 = (state_33214[(10)]);
var inst_33192 = (state_33214[(7)]);
var inst_33193 = (state_33214[(8)]);
var inst_33194 = (state_33214[(9)]);
var inst_33197 = (function (){var cs = inst_33183;
var vec__33188 = inst_33192;
var v = inst_33193;
var c = inst_33194;
return (function (p1__33172_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33172_SHARP_);
});
})();
var inst_33198 = cljs.core.filterv(inst_33197,inst_33183);
var inst_33183__$1 = inst_33198;
var state_33214__$1 = (function (){var statearr_33237 = state_33214;
(statearr_33237[(10)] = inst_33183__$1);

return statearr_33237;
})();
var statearr_33238_35354 = state_33214__$1;
(statearr_33238_35354[(2)] = null);

(statearr_33238_35354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33240 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33240[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33240[(1)] = (1));

return statearr_33240;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_33214){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33214);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33241){var ex__30484__auto__ = e33241;
var statearr_33242_35356 = state_33214;
(statearr_33242_35356[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33214[(4)]))){
var statearr_33243_35363 = state_33214;
(statearr_33243_35363[(1)] = cljs.core.first((state_33214[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35364 = state_33214;
state_33214 = G__35364;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_33214){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_33214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33245 = f__30938__auto__();
(statearr_33245[(6)] = c__30937__auto___35324);

return statearr_33245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33248 = arguments.length;
switch (G__33248) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30937__auto___35373 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33274){
var state_val_33275 = (state_33274[(1)]);
if((state_val_33275 === (7))){
var inst_33256 = (state_33274[(7)]);
var inst_33256__$1 = (state_33274[(2)]);
var inst_33257 = (inst_33256__$1 == null);
var inst_33258 = cljs.core.not(inst_33257);
var state_33274__$1 = (function (){var statearr_33277 = state_33274;
(statearr_33277[(7)] = inst_33256__$1);

return statearr_33277;
})();
if(inst_33258){
var statearr_33278_35383 = state_33274__$1;
(statearr_33278_35383[(1)] = (8));

} else {
var statearr_33279_35384 = state_33274__$1;
(statearr_33279_35384[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (1))){
var inst_33251 = (0);
var state_33274__$1 = (function (){var statearr_33280 = state_33274;
(statearr_33280[(8)] = inst_33251);

return statearr_33280;
})();
var statearr_33281_35385 = state_33274__$1;
(statearr_33281_35385[(2)] = null);

(statearr_33281_35385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (4))){
var state_33274__$1 = state_33274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33274__$1,(7),ch);
} else {
if((state_val_33275 === (6))){
var inst_33269 = (state_33274[(2)]);
var state_33274__$1 = state_33274;
var statearr_33282_35390 = state_33274__$1;
(statearr_33282_35390[(2)] = inst_33269);

(statearr_33282_35390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (3))){
var inst_33271 = (state_33274[(2)]);
var inst_33272 = cljs.core.async.close_BANG_(out);
var state_33274__$1 = (function (){var statearr_33283 = state_33274;
(statearr_33283[(9)] = inst_33271);

return statearr_33283;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33274__$1,inst_33272);
} else {
if((state_val_33275 === (2))){
var inst_33251 = (state_33274[(8)]);
var inst_33253 = (inst_33251 < n);
var state_33274__$1 = state_33274;
if(cljs.core.truth_(inst_33253)){
var statearr_33285_35391 = state_33274__$1;
(statearr_33285_35391[(1)] = (4));

} else {
var statearr_33286_35392 = state_33274__$1;
(statearr_33286_35392[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (11))){
var inst_33251 = (state_33274[(8)]);
var inst_33261 = (state_33274[(2)]);
var inst_33262 = (inst_33251 + (1));
var inst_33251__$1 = inst_33262;
var state_33274__$1 = (function (){var statearr_33287 = state_33274;
(statearr_33287[(8)] = inst_33251__$1);

(statearr_33287[(10)] = inst_33261);

return statearr_33287;
})();
var statearr_33288_35400 = state_33274__$1;
(statearr_33288_35400[(2)] = null);

(statearr_33288_35400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (9))){
var state_33274__$1 = state_33274;
var statearr_33289_35401 = state_33274__$1;
(statearr_33289_35401[(2)] = null);

(statearr_33289_35401[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (5))){
var state_33274__$1 = state_33274;
var statearr_33290_35402 = state_33274__$1;
(statearr_33290_35402[(2)] = null);

(statearr_33290_35402[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (10))){
var inst_33266 = (state_33274[(2)]);
var state_33274__$1 = state_33274;
var statearr_33291_35410 = state_33274__$1;
(statearr_33291_35410[(2)] = inst_33266);

(statearr_33291_35410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33275 === (8))){
var inst_33256 = (state_33274[(7)]);
var state_33274__$1 = state_33274;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33274__$1,(11),out,inst_33256);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33294 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33294[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33294[(1)] = (1));

return statearr_33294;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_33274){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33274);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33295){var ex__30484__auto__ = e33295;
var statearr_33296_35411 = state_33274;
(statearr_33296_35411[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33274[(4)]))){
var statearr_33297_35412 = state_33274;
(statearr_33297_35412[(1)] = cljs.core.first((state_33274[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35413 = state_33274;
state_33274 = G__35413;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_33274){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_33274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33299 = f__30938__auto__();
(statearr_33299[(6)] = c__30937__auto___35373);

return statearr_33299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33303 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33303 = (function (f,ch,meta33304){
this.f = f;
this.ch = ch;
this.meta33304 = meta33304;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33305,meta33304__$1){
var self__ = this;
var _33305__$1 = this;
return (new cljs.core.async.t_cljs$core$async33303(self__.f,self__.ch,meta33304__$1));
}));

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33305){
var self__ = this;
var _33305__$1 = this;
return self__.meta33304;
}));

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33307 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33307 = (function (f,ch,meta33304,_,fn1,meta33308){
this.f = f;
this.ch = ch;
this.meta33304 = meta33304;
this._ = _;
this.fn1 = fn1;
this.meta33308 = meta33308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33309,meta33308__$1){
var self__ = this;
var _33309__$1 = this;
return (new cljs.core.async.t_cljs$core$async33307(self__.f,self__.ch,self__.meta33304,self__._,self__.fn1,meta33308__$1));
}));

(cljs.core.async.t_cljs$core$async33307.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33309){
var self__ = this;
var _33309__$1 = this;
return self__.meta33308;
}));

(cljs.core.async.t_cljs$core$async33307.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33307.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33307.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33307.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33302_SHARP_){
var G__33312 = (((p1__33302_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33302_SHARP_) : self__.f.call(null,p1__33302_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33312) : f1.call(null,G__33312));
});
}));

(cljs.core.async.t_cljs$core$async33307.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33304","meta33304",-1671634224,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33303","cljs.core.async/t_cljs$core$async33303",-73134696,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33308","meta33308",1941024039,null)], null);
}));

(cljs.core.async.t_cljs$core$async33307.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33307");

(cljs.core.async.t_cljs$core$async33307.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33307");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33307.
 */
cljs.core.async.__GT_t_cljs$core$async33307 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33307(f__$1,ch__$1,meta33304__$1,___$2,fn1__$1,meta33308){
return (new cljs.core.async.t_cljs$core$async33307(f__$1,ch__$1,meta33304__$1,___$2,fn1__$1,meta33308));
});

}

return (new cljs.core.async.t_cljs$core$async33307(self__.f,self__.ch,self__.meta33304,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33316 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33316) : self__.f.call(null,G__33316));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33303.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33303.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33304","meta33304",-1671634224,null)], null);
}));

(cljs.core.async.t_cljs$core$async33303.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33303.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33303");

(cljs.core.async.t_cljs$core$async33303.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33303");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33303.
 */
cljs.core.async.__GT_t_cljs$core$async33303 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33303(f__$1,ch__$1,meta33304){
return (new cljs.core.async.t_cljs$core$async33303(f__$1,ch__$1,meta33304));
});

}

return (new cljs.core.async.t_cljs$core$async33303(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33319 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33319 = (function (f,ch,meta33320){
this.f = f;
this.ch = ch;
this.meta33320 = meta33320;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33321,meta33320__$1){
var self__ = this;
var _33321__$1 = this;
return (new cljs.core.async.t_cljs$core$async33319(self__.f,self__.ch,meta33320__$1));
}));

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33321){
var self__ = this;
var _33321__$1 = this;
return self__.meta33320;
}));

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33319.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33319.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33320","meta33320",-1902553377,null)], null);
}));

(cljs.core.async.t_cljs$core$async33319.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33319.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33319");

(cljs.core.async.t_cljs$core$async33319.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33319");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33319.
 */
cljs.core.async.__GT_t_cljs$core$async33319 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33319(f__$1,ch__$1,meta33320){
return (new cljs.core.async.t_cljs$core$async33319(f__$1,ch__$1,meta33320));
});

}

return (new cljs.core.async.t_cljs$core$async33319(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async33328 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33328 = (function (p,ch,meta33329){
this.p = p;
this.ch = ch;
this.meta33329 = meta33329;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33330,meta33329__$1){
var self__ = this;
var _33330__$1 = this;
return (new cljs.core.async.t_cljs$core$async33328(self__.p,self__.ch,meta33329__$1));
}));

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33330){
var self__ = this;
var _33330__$1 = this;
return self__.meta33329;
}));

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33328.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33328.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33329","meta33329",2037288913,null)], null);
}));

(cljs.core.async.t_cljs$core$async33328.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33328.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33328");

(cljs.core.async.t_cljs$core$async33328.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33328");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33328.
 */
cljs.core.async.__GT_t_cljs$core$async33328 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33328(p__$1,ch__$1,meta33329){
return (new cljs.core.async.t_cljs$core$async33328(p__$1,ch__$1,meta33329));
});

}

return (new cljs.core.async.t_cljs$core$async33328(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33336 = arguments.length;
switch (G__33336) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30937__auto___35448 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33364){
var state_val_33365 = (state_33364[(1)]);
if((state_val_33365 === (7))){
var inst_33360 = (state_33364[(2)]);
var state_33364__$1 = state_33364;
var statearr_33366_35449 = state_33364__$1;
(statearr_33366_35449[(2)] = inst_33360);

(statearr_33366_35449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (1))){
var state_33364__$1 = state_33364;
var statearr_33367_35450 = state_33364__$1;
(statearr_33367_35450[(2)] = null);

(statearr_33367_35450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (4))){
var inst_33346 = (state_33364[(7)]);
var inst_33346__$1 = (state_33364[(2)]);
var inst_33347 = (inst_33346__$1 == null);
var state_33364__$1 = (function (){var statearr_33368 = state_33364;
(statearr_33368[(7)] = inst_33346__$1);

return statearr_33368;
})();
if(cljs.core.truth_(inst_33347)){
var statearr_33369_35452 = state_33364__$1;
(statearr_33369_35452[(1)] = (5));

} else {
var statearr_33371_35453 = state_33364__$1;
(statearr_33371_35453[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (6))){
var inst_33346 = (state_33364[(7)]);
var inst_33351 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33346) : p.call(null,inst_33346));
var state_33364__$1 = state_33364;
if(cljs.core.truth_(inst_33351)){
var statearr_33372_35456 = state_33364__$1;
(statearr_33372_35456[(1)] = (8));

} else {
var statearr_33374_35457 = state_33364__$1;
(statearr_33374_35457[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (3))){
var inst_33362 = (state_33364[(2)]);
var state_33364__$1 = state_33364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33364__$1,inst_33362);
} else {
if((state_val_33365 === (2))){
var state_33364__$1 = state_33364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33364__$1,(4),ch);
} else {
if((state_val_33365 === (11))){
var inst_33354 = (state_33364[(2)]);
var state_33364__$1 = state_33364;
var statearr_33375_35459 = state_33364__$1;
(statearr_33375_35459[(2)] = inst_33354);

(statearr_33375_35459[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (9))){
var state_33364__$1 = state_33364;
var statearr_33380_35460 = state_33364__$1;
(statearr_33380_35460[(2)] = null);

(statearr_33380_35460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (5))){
var inst_33349 = cljs.core.async.close_BANG_(out);
var state_33364__$1 = state_33364;
var statearr_33385_35461 = state_33364__$1;
(statearr_33385_35461[(2)] = inst_33349);

(statearr_33385_35461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (10))){
var inst_33357 = (state_33364[(2)]);
var state_33364__$1 = (function (){var statearr_33391 = state_33364;
(statearr_33391[(8)] = inst_33357);

return statearr_33391;
})();
var statearr_33392_35462 = state_33364__$1;
(statearr_33392_35462[(2)] = null);

(statearr_33392_35462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33365 === (8))){
var inst_33346 = (state_33364[(7)]);
var state_33364__$1 = state_33364;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33364__$1,(11),out,inst_33346);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33396 = [null,null,null,null,null,null,null,null,null];
(statearr_33396[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33396[(1)] = (1));

return statearr_33396;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_33364){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33364);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33400){var ex__30484__auto__ = e33400;
var statearr_33401_35463 = state_33364;
(statearr_33401_35463[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33364[(4)]))){
var statearr_33402_35464 = state_33364;
(statearr_33402_35464[(1)] = cljs.core.first((state_33364[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35471 = state_33364;
state_33364 = G__35471;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_33364){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_33364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33403 = f__30938__auto__();
(statearr_33403[(6)] = c__30937__auto___35448);

return statearr_33403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33406 = arguments.length;
switch (G__33406) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30937__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33498){
var state_val_33502 = (state_33498[(1)]);
if((state_val_33502 === (7))){
var inst_33492 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
var statearr_33513_35474 = state_33498__$1;
(statearr_33513_35474[(2)] = inst_33492);

(statearr_33513_35474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (20))){
var inst_33455 = (state_33498[(7)]);
var inst_33472 = (state_33498[(2)]);
var inst_33473 = cljs.core.next(inst_33455);
var inst_33439 = inst_33473;
var inst_33440 = null;
var inst_33441 = (0);
var inst_33442 = (0);
var state_33498__$1 = (function (){var statearr_33515 = state_33498;
(statearr_33515[(8)] = inst_33442);

(statearr_33515[(9)] = inst_33472);

(statearr_33515[(10)] = inst_33439);

(statearr_33515[(11)] = inst_33441);

(statearr_33515[(12)] = inst_33440);

return statearr_33515;
})();
var statearr_33517_35483 = state_33498__$1;
(statearr_33517_35483[(2)] = null);

(statearr_33517_35483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (1))){
var state_33498__$1 = state_33498;
var statearr_33520_35484 = state_33498__$1;
(statearr_33520_35484[(2)] = null);

(statearr_33520_35484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (4))){
var inst_33422 = (state_33498[(13)]);
var inst_33422__$1 = (state_33498[(2)]);
var inst_33424 = (inst_33422__$1 == null);
var state_33498__$1 = (function (){var statearr_33524 = state_33498;
(statearr_33524[(13)] = inst_33422__$1);

return statearr_33524;
})();
if(cljs.core.truth_(inst_33424)){
var statearr_33525_35487 = state_33498__$1;
(statearr_33525_35487[(1)] = (5));

} else {
var statearr_33526_35488 = state_33498__$1;
(statearr_33526_35488[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (15))){
var state_33498__$1 = state_33498;
var statearr_33534_35489 = state_33498__$1;
(statearr_33534_35489[(2)] = null);

(statearr_33534_35489[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (21))){
var state_33498__$1 = state_33498;
var statearr_33535_35490 = state_33498__$1;
(statearr_33535_35490[(2)] = null);

(statearr_33535_35490[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (13))){
var inst_33442 = (state_33498[(8)]);
var inst_33439 = (state_33498[(10)]);
var inst_33441 = (state_33498[(11)]);
var inst_33440 = (state_33498[(12)]);
var inst_33451 = (state_33498[(2)]);
var inst_33452 = (inst_33442 + (1));
var tmp33530 = inst_33439;
var tmp33531 = inst_33441;
var tmp33532 = inst_33440;
var inst_33439__$1 = tmp33530;
var inst_33440__$1 = tmp33532;
var inst_33441__$1 = tmp33531;
var inst_33442__$1 = inst_33452;
var state_33498__$1 = (function (){var statearr_33541 = state_33498;
(statearr_33541[(14)] = inst_33451);

(statearr_33541[(8)] = inst_33442__$1);

(statearr_33541[(10)] = inst_33439__$1);

(statearr_33541[(11)] = inst_33441__$1);

(statearr_33541[(12)] = inst_33440__$1);

return statearr_33541;
})();
var statearr_33543_35497 = state_33498__$1;
(statearr_33543_35497[(2)] = null);

(statearr_33543_35497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (22))){
var state_33498__$1 = state_33498;
var statearr_33544_35501 = state_33498__$1;
(statearr_33544_35501[(2)] = null);

(statearr_33544_35501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (6))){
var inst_33422 = (state_33498[(13)]);
var inst_33437 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33422) : f.call(null,inst_33422));
var inst_33438 = cljs.core.seq(inst_33437);
var inst_33439 = inst_33438;
var inst_33440 = null;
var inst_33441 = (0);
var inst_33442 = (0);
var state_33498__$1 = (function (){var statearr_33549 = state_33498;
(statearr_33549[(8)] = inst_33442);

(statearr_33549[(10)] = inst_33439);

(statearr_33549[(11)] = inst_33441);

(statearr_33549[(12)] = inst_33440);

return statearr_33549;
})();
var statearr_33550_35502 = state_33498__$1;
(statearr_33550_35502[(2)] = null);

(statearr_33550_35502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (17))){
var inst_33455 = (state_33498[(7)]);
var inst_33460 = cljs.core.chunk_first(inst_33455);
var inst_33462 = cljs.core.chunk_rest(inst_33455);
var inst_33463 = cljs.core.count(inst_33460);
var inst_33439 = inst_33462;
var inst_33440 = inst_33460;
var inst_33441 = inst_33463;
var inst_33442 = (0);
var state_33498__$1 = (function (){var statearr_33553 = state_33498;
(statearr_33553[(8)] = inst_33442);

(statearr_33553[(10)] = inst_33439);

(statearr_33553[(11)] = inst_33441);

(statearr_33553[(12)] = inst_33440);

return statearr_33553;
})();
var statearr_33557_35507 = state_33498__$1;
(statearr_33557_35507[(2)] = null);

(statearr_33557_35507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (3))){
var inst_33494 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33498__$1,inst_33494);
} else {
if((state_val_33502 === (12))){
var inst_33482 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
var statearr_33562_35508 = state_33498__$1;
(statearr_33562_35508[(2)] = inst_33482);

(statearr_33562_35508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (2))){
var state_33498__$1 = state_33498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33498__$1,(4),in$);
} else {
if((state_val_33502 === (23))){
var inst_33490 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
var statearr_33564_35509 = state_33498__$1;
(statearr_33564_35509[(2)] = inst_33490);

(statearr_33564_35509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (19))){
var inst_33477 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
var statearr_33566_35516 = state_33498__$1;
(statearr_33566_35516[(2)] = inst_33477);

(statearr_33566_35516[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (11))){
var inst_33455 = (state_33498[(7)]);
var inst_33439 = (state_33498[(10)]);
var inst_33455__$1 = cljs.core.seq(inst_33439);
var state_33498__$1 = (function (){var statearr_33570 = state_33498;
(statearr_33570[(7)] = inst_33455__$1);

return statearr_33570;
})();
if(inst_33455__$1){
var statearr_33573_35517 = state_33498__$1;
(statearr_33573_35517[(1)] = (14));

} else {
var statearr_33574_35518 = state_33498__$1;
(statearr_33574_35518[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (9))){
var inst_33484 = (state_33498[(2)]);
var inst_33485 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33498__$1 = (function (){var statearr_33577 = state_33498;
(statearr_33577[(15)] = inst_33484);

return statearr_33577;
})();
if(cljs.core.truth_(inst_33485)){
var statearr_33579_35519 = state_33498__$1;
(statearr_33579_35519[(1)] = (21));

} else {
var statearr_33580_35526 = state_33498__$1;
(statearr_33580_35526[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (5))){
var inst_33429 = cljs.core.async.close_BANG_(out);
var state_33498__$1 = state_33498;
var statearr_33581_35527 = state_33498__$1;
(statearr_33581_35527[(2)] = inst_33429);

(statearr_33581_35527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (14))){
var inst_33455 = (state_33498[(7)]);
var inst_33458 = cljs.core.chunked_seq_QMARK_(inst_33455);
var state_33498__$1 = state_33498;
if(inst_33458){
var statearr_33586_35528 = state_33498__$1;
(statearr_33586_35528[(1)] = (17));

} else {
var statearr_33587_35529 = state_33498__$1;
(statearr_33587_35529[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (16))){
var inst_33480 = (state_33498[(2)]);
var state_33498__$1 = state_33498;
var statearr_33589_35530 = state_33498__$1;
(statearr_33589_35530[(2)] = inst_33480);

(statearr_33589_35530[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33502 === (10))){
var inst_33442 = (state_33498[(8)]);
var inst_33440 = (state_33498[(12)]);
var inst_33449 = cljs.core._nth(inst_33440,inst_33442);
var state_33498__$1 = state_33498;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33498__$1,(13),out,inst_33449);
} else {
if((state_val_33502 === (18))){
var inst_33455 = (state_33498[(7)]);
var inst_33468 = cljs.core.first(inst_33455);
var state_33498__$1 = state_33498;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33498__$1,(20),out,inst_33468);
} else {
if((state_val_33502 === (8))){
var inst_33442 = (state_33498[(8)]);
var inst_33441 = (state_33498[(11)]);
var inst_33446 = (inst_33442 < inst_33441);
var inst_33447 = inst_33446;
var state_33498__$1 = state_33498;
if(cljs.core.truth_(inst_33447)){
var statearr_33597_35532 = state_33498__$1;
(statearr_33597_35532[(1)] = (10));

} else {
var statearr_33599_35533 = state_33498__$1;
(statearr_33599_35533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30481__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30481__auto____0 = (function (){
var statearr_33600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33600[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30481__auto__);

(statearr_33600[(1)] = (1));

return statearr_33600;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30481__auto____1 = (function (state_33498){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33498);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33602){var ex__30484__auto__ = e33602;
var statearr_33603_35535 = state_33498;
(statearr_33603_35535[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33498[(4)]))){
var statearr_33604_35536 = state_33498;
(statearr_33604_35536[(1)] = cljs.core.first((state_33498[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35537 = state_33498;
state_33498 = G__35537;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30481__auto__ = function(state_33498){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30481__auto____1.call(this,state_33498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30481__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30481__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33608 = f__30938__auto__();
(statearr_33608[(6)] = c__30937__auto__);

return statearr_33608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));

return c__30937__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33612 = arguments.length;
switch (G__33612) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33622 = arguments.length;
switch (G__33622) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33639 = arguments.length;
switch (G__33639) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30937__auto___35554 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33689){
var state_val_33690 = (state_33689[(1)]);
if((state_val_33690 === (7))){
var inst_33679 = (state_33689[(2)]);
var state_33689__$1 = state_33689;
var statearr_33694_35555 = state_33689__$1;
(statearr_33694_35555[(2)] = inst_33679);

(statearr_33694_35555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (1))){
var inst_33651 = null;
var state_33689__$1 = (function (){var statearr_33698 = state_33689;
(statearr_33698[(7)] = inst_33651);

return statearr_33698;
})();
var statearr_33700_35557 = state_33689__$1;
(statearr_33700_35557[(2)] = null);

(statearr_33700_35557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (4))){
var inst_33654 = (state_33689[(8)]);
var inst_33654__$1 = (state_33689[(2)]);
var inst_33659 = (inst_33654__$1 == null);
var inst_33660 = cljs.core.not(inst_33659);
var state_33689__$1 = (function (){var statearr_33701 = state_33689;
(statearr_33701[(8)] = inst_33654__$1);

return statearr_33701;
})();
if(inst_33660){
var statearr_33703_35563 = state_33689__$1;
(statearr_33703_35563[(1)] = (5));

} else {
var statearr_33705_35565 = state_33689__$1;
(statearr_33705_35565[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (6))){
var state_33689__$1 = state_33689;
var statearr_33711_35566 = state_33689__$1;
(statearr_33711_35566[(2)] = null);

(statearr_33711_35566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (3))){
var inst_33681 = (state_33689[(2)]);
var inst_33682 = cljs.core.async.close_BANG_(out);
var state_33689__$1 = (function (){var statearr_33719 = state_33689;
(statearr_33719[(9)] = inst_33681);

return statearr_33719;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33689__$1,inst_33682);
} else {
if((state_val_33690 === (2))){
var state_33689__$1 = state_33689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33689__$1,(4),ch);
} else {
if((state_val_33690 === (11))){
var inst_33654 = (state_33689[(8)]);
var inst_33669 = (state_33689[(2)]);
var inst_33651 = inst_33654;
var state_33689__$1 = (function (){var statearr_33741 = state_33689;
(statearr_33741[(10)] = inst_33669);

(statearr_33741[(7)] = inst_33651);

return statearr_33741;
})();
var statearr_33743_35569 = state_33689__$1;
(statearr_33743_35569[(2)] = null);

(statearr_33743_35569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (9))){
var inst_33654 = (state_33689[(8)]);
var state_33689__$1 = state_33689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33689__$1,(11),out,inst_33654);
} else {
if((state_val_33690 === (5))){
var inst_33654 = (state_33689[(8)]);
var inst_33651 = (state_33689[(7)]);
var inst_33662 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33654,inst_33651);
var state_33689__$1 = state_33689;
if(inst_33662){
var statearr_33749_35572 = state_33689__$1;
(statearr_33749_35572[(1)] = (8));

} else {
var statearr_33750_35576 = state_33689__$1;
(statearr_33750_35576[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (10))){
var inst_33676 = (state_33689[(2)]);
var state_33689__$1 = state_33689;
var statearr_33752_35577 = state_33689__$1;
(statearr_33752_35577[(2)] = inst_33676);

(statearr_33752_35577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (8))){
var inst_33651 = (state_33689[(7)]);
var tmp33748 = inst_33651;
var inst_33651__$1 = tmp33748;
var state_33689__$1 = (function (){var statearr_33753 = state_33689;
(statearr_33753[(7)] = inst_33651__$1);

return statearr_33753;
})();
var statearr_33754_35578 = state_33689__$1;
(statearr_33754_35578[(2)] = null);

(statearr_33754_35578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33758 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33758[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33758[(1)] = (1));

return statearr_33758;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_33689){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33689);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33759){var ex__30484__auto__ = e33759;
var statearr_33760_35580 = state_33689;
(statearr_33760_35580[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33689[(4)]))){
var statearr_33761_35588 = state_33689;
(statearr_33761_35588[(1)] = cljs.core.first((state_33689[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35590 = state_33689;
state_33689 = G__35590;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_33689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_33689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33769 = f__30938__auto__();
(statearr_33769[(6)] = c__30937__auto___35554);

return statearr_33769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33775 = arguments.length;
switch (G__33775) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30937__auto___35595 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_33835){
var state_val_33836 = (state_33835[(1)]);
if((state_val_33836 === (7))){
var inst_33830 = (state_33835[(2)]);
var state_33835__$1 = state_33835;
var statearr_33844_35596 = state_33835__$1;
(statearr_33844_35596[(2)] = inst_33830);

(statearr_33844_35596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (1))){
var inst_33781 = (new Array(n));
var inst_33782 = inst_33781;
var inst_33783 = (0);
var state_33835__$1 = (function (){var statearr_33850 = state_33835;
(statearr_33850[(7)] = inst_33782);

(statearr_33850[(8)] = inst_33783);

return statearr_33850;
})();
var statearr_33851_35598 = state_33835__$1;
(statearr_33851_35598[(2)] = null);

(statearr_33851_35598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (4))){
var inst_33786 = (state_33835[(9)]);
var inst_33786__$1 = (state_33835[(2)]);
var inst_33793 = (inst_33786__$1 == null);
var inst_33794 = cljs.core.not(inst_33793);
var state_33835__$1 = (function (){var statearr_33857 = state_33835;
(statearr_33857[(9)] = inst_33786__$1);

return statearr_33857;
})();
if(inst_33794){
var statearr_33860_35610 = state_33835__$1;
(statearr_33860_35610[(1)] = (5));

} else {
var statearr_33861_35611 = state_33835__$1;
(statearr_33861_35611[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (15))){
var inst_33824 = (state_33835[(2)]);
var state_33835__$1 = state_33835;
var statearr_33866_35613 = state_33835__$1;
(statearr_33866_35613[(2)] = inst_33824);

(statearr_33866_35613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (13))){
var state_33835__$1 = state_33835;
var statearr_33867_35618 = state_33835__$1;
(statearr_33867_35618[(2)] = null);

(statearr_33867_35618[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (6))){
var inst_33783 = (state_33835[(8)]);
var inst_33819 = (inst_33783 > (0));
var state_33835__$1 = state_33835;
if(cljs.core.truth_(inst_33819)){
var statearr_33871_35620 = state_33835__$1;
(statearr_33871_35620[(1)] = (12));

} else {
var statearr_33872_35621 = state_33835__$1;
(statearr_33872_35621[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (3))){
var inst_33832 = (state_33835[(2)]);
var state_33835__$1 = state_33835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33835__$1,inst_33832);
} else {
if((state_val_33836 === (12))){
var inst_33782 = (state_33835[(7)]);
var inst_33822 = cljs.core.vec(inst_33782);
var state_33835__$1 = state_33835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33835__$1,(15),out,inst_33822);
} else {
if((state_val_33836 === (2))){
var state_33835__$1 = state_33835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33835__$1,(4),ch);
} else {
if((state_val_33836 === (11))){
var inst_33809 = (state_33835[(2)]);
var inst_33810 = (new Array(n));
var inst_33782 = inst_33810;
var inst_33783 = (0);
var state_33835__$1 = (function (){var statearr_33882 = state_33835;
(statearr_33882[(7)] = inst_33782);

(statearr_33882[(8)] = inst_33783);

(statearr_33882[(10)] = inst_33809);

return statearr_33882;
})();
var statearr_33883_35622 = state_33835__$1;
(statearr_33883_35622[(2)] = null);

(statearr_33883_35622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (9))){
var inst_33782 = (state_33835[(7)]);
var inst_33807 = cljs.core.vec(inst_33782);
var state_33835__$1 = state_33835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33835__$1,(11),out,inst_33807);
} else {
if((state_val_33836 === (5))){
var inst_33782 = (state_33835[(7)]);
var inst_33786 = (state_33835[(9)]);
var inst_33783 = (state_33835[(8)]);
var inst_33798 = (state_33835[(11)]);
var inst_33796 = (inst_33782[inst_33783] = inst_33786);
var inst_33798__$1 = (inst_33783 + (1));
var inst_33799 = (inst_33798__$1 < n);
var state_33835__$1 = (function (){var statearr_33894 = state_33835;
(statearr_33894[(12)] = inst_33796);

(statearr_33894[(11)] = inst_33798__$1);

return statearr_33894;
})();
if(cljs.core.truth_(inst_33799)){
var statearr_33895_35635 = state_33835__$1;
(statearr_33895_35635[(1)] = (8));

} else {
var statearr_33896_35636 = state_33835__$1;
(statearr_33896_35636[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (14))){
var inst_33827 = (state_33835[(2)]);
var inst_33828 = cljs.core.async.close_BANG_(out);
var state_33835__$1 = (function (){var statearr_33899 = state_33835;
(statearr_33899[(13)] = inst_33827);

return statearr_33899;
})();
var statearr_33901_35637 = state_33835__$1;
(statearr_33901_35637[(2)] = inst_33828);

(statearr_33901_35637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (10))){
var inst_33813 = (state_33835[(2)]);
var state_33835__$1 = state_33835;
var statearr_33906_35642 = state_33835__$1;
(statearr_33906_35642[(2)] = inst_33813);

(statearr_33906_35642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33836 === (8))){
var inst_33782 = (state_33835[(7)]);
var inst_33798 = (state_33835[(11)]);
var tmp33897 = inst_33782;
var inst_33782__$1 = tmp33897;
var inst_33783 = inst_33798;
var state_33835__$1 = (function (){var statearr_33908 = state_33835;
(statearr_33908[(7)] = inst_33782__$1);

(statearr_33908[(8)] = inst_33783);

return statearr_33908;
})();
var statearr_33911_35647 = state_33835__$1;
(statearr_33911_35647[(2)] = null);

(statearr_33911_35647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_33915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33915[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_33915[(1)] = (1));

return statearr_33915;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_33835){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_33835);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e33920){var ex__30484__auto__ = e33920;
var statearr_33921_35655 = state_33835;
(statearr_33921_35655[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_33835[(4)]))){
var statearr_33922_35656 = state_33835;
(statearr_33922_35656[(1)] = cljs.core.first((state_33835[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35657 = state_33835;
state_33835 = G__35657;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_33835){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_33835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_33929 = f__30938__auto__();
(statearr_33929[(6)] = c__30937__auto___35595);

return statearr_33929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33939 = arguments.length;
switch (G__33939) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30937__auto___35660 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30938__auto__ = (function (){var switch__30480__auto__ = (function (state_34018){
var state_val_34022 = (state_34018[(1)]);
if((state_val_34022 === (7))){
var inst_34010 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
var statearr_34028_35661 = state_34018__$1;
(statearr_34028_35661[(2)] = inst_34010);

(statearr_34028_35661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (1))){
var inst_33963 = [];
var inst_33967 = inst_33963;
var inst_33968 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34018__$1 = (function (){var statearr_34033 = state_34018;
(statearr_34033[(7)] = inst_33967);

(statearr_34033[(8)] = inst_33968);

return statearr_34033;
})();
var statearr_34039_35663 = state_34018__$1;
(statearr_34039_35663[(2)] = null);

(statearr_34039_35663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (4))){
var inst_33971 = (state_34018[(9)]);
var inst_33971__$1 = (state_34018[(2)]);
var inst_33972 = (inst_33971__$1 == null);
var inst_33973 = cljs.core.not(inst_33972);
var state_34018__$1 = (function (){var statearr_34043 = state_34018;
(statearr_34043[(9)] = inst_33971__$1);

return statearr_34043;
})();
if(inst_33973){
var statearr_34047_35665 = state_34018__$1;
(statearr_34047_35665[(1)] = (5));

} else {
var statearr_34053_35667 = state_34018__$1;
(statearr_34053_35667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (15))){
var inst_33967 = (state_34018[(7)]);
var inst_34002 = cljs.core.vec(inst_33967);
var state_34018__$1 = state_34018;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34018__$1,(18),out,inst_34002);
} else {
if((state_val_34022 === (13))){
var inst_33996 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
var statearr_34058_35671 = state_34018__$1;
(statearr_34058_35671[(2)] = inst_33996);

(statearr_34058_35671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (6))){
var inst_33967 = (state_34018[(7)]);
var inst_33998 = inst_33967.length;
var inst_33999 = (inst_33998 > (0));
var state_34018__$1 = state_34018;
if(cljs.core.truth_(inst_33999)){
var statearr_34063_35672 = state_34018__$1;
(statearr_34063_35672[(1)] = (15));

} else {
var statearr_34065_35673 = state_34018__$1;
(statearr_34065_35673[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (17))){
var inst_34007 = (state_34018[(2)]);
var inst_34008 = cljs.core.async.close_BANG_(out);
var state_34018__$1 = (function (){var statearr_34069 = state_34018;
(statearr_34069[(10)] = inst_34007);

return statearr_34069;
})();
var statearr_34070_35674 = state_34018__$1;
(statearr_34070_35674[(2)] = inst_34008);

(statearr_34070_35674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (3))){
var inst_34016 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34018__$1,inst_34016);
} else {
if((state_val_34022 === (12))){
var inst_33967 = (state_34018[(7)]);
var inst_33987 = cljs.core.vec(inst_33967);
var state_34018__$1 = state_34018;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34018__$1,(14),out,inst_33987);
} else {
if((state_val_34022 === (2))){
var state_34018__$1 = state_34018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34018__$1,(4),ch);
} else {
if((state_val_34022 === (11))){
var inst_33971 = (state_34018[(9)]);
var inst_33975 = (state_34018[(11)]);
var inst_33967 = (state_34018[(7)]);
var inst_33984 = inst_33967.push(inst_33971);
var tmp34072 = inst_33967;
var inst_33967__$1 = tmp34072;
var inst_33968 = inst_33975;
var state_34018__$1 = (function (){var statearr_34078 = state_34018;
(statearr_34078[(12)] = inst_33984);

(statearr_34078[(7)] = inst_33967__$1);

(statearr_34078[(8)] = inst_33968);

return statearr_34078;
})();
var statearr_34082_35679 = state_34018__$1;
(statearr_34082_35679[(2)] = null);

(statearr_34082_35679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (9))){
var inst_33968 = (state_34018[(8)]);
var inst_33980 = cljs.core.keyword_identical_QMARK_(inst_33968,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_34018__$1 = state_34018;
var statearr_34083_35680 = state_34018__$1;
(statearr_34083_35680[(2)] = inst_33980);

(statearr_34083_35680[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (5))){
var inst_33971 = (state_34018[(9)]);
var inst_33975 = (state_34018[(11)]);
var inst_33977 = (state_34018[(13)]);
var inst_33968 = (state_34018[(8)]);
var inst_33975__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33971) : f.call(null,inst_33971));
var inst_33977__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33975__$1,inst_33968);
var state_34018__$1 = (function (){var statearr_34094 = state_34018;
(statearr_34094[(11)] = inst_33975__$1);

(statearr_34094[(13)] = inst_33977__$1);

return statearr_34094;
})();
if(inst_33977__$1){
var statearr_34096_35682 = state_34018__$1;
(statearr_34096_35682[(1)] = (8));

} else {
var statearr_34097_35683 = state_34018__$1;
(statearr_34097_35683[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (14))){
var inst_33971 = (state_34018[(9)]);
var inst_33975 = (state_34018[(11)]);
var inst_33989 = (state_34018[(2)]);
var inst_33990 = [];
var inst_33992 = inst_33990.push(inst_33971);
var inst_33967 = inst_33990;
var inst_33968 = inst_33975;
var state_34018__$1 = (function (){var statearr_34098 = state_34018;
(statearr_34098[(14)] = inst_33989);

(statearr_34098[(7)] = inst_33967);

(statearr_34098[(8)] = inst_33968);

(statearr_34098[(15)] = inst_33992);

return statearr_34098;
})();
var statearr_34099_35684 = state_34018__$1;
(statearr_34099_35684[(2)] = null);

(statearr_34099_35684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (16))){
var state_34018__$1 = state_34018;
var statearr_34103_35685 = state_34018__$1;
(statearr_34103_35685[(2)] = null);

(statearr_34103_35685[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (10))){
var inst_33982 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
if(cljs.core.truth_(inst_33982)){
var statearr_34105_35687 = state_34018__$1;
(statearr_34105_35687[(1)] = (11));

} else {
var statearr_34106_35688 = state_34018__$1;
(statearr_34106_35688[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (18))){
var inst_34004 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
var statearr_34110_35689 = state_34018__$1;
(statearr_34110_35689[(2)] = inst_34004);

(statearr_34110_35689[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34022 === (8))){
var inst_33977 = (state_34018[(13)]);
var state_34018__$1 = state_34018;
var statearr_34112_35695 = state_34018__$1;
(statearr_34112_35695[(2)] = inst_33977);

(statearr_34112_35695[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30481__auto__ = null;
var cljs$core$async$state_machine__30481__auto____0 = (function (){
var statearr_34113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34113[(0)] = cljs$core$async$state_machine__30481__auto__);

(statearr_34113[(1)] = (1));

return statearr_34113;
});
var cljs$core$async$state_machine__30481__auto____1 = (function (state_34018){
while(true){
var ret_value__30482__auto__ = (function (){try{while(true){
var result__30483__auto__ = switch__30480__auto__(state_34018);
if(cljs.core.keyword_identical_QMARK_(result__30483__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30483__auto__;
}
break;
}
}catch (e34117){var ex__30484__auto__ = e34117;
var statearr_34119_35708 = state_34018;
(statearr_34119_35708[(2)] = ex__30484__auto__);


if(cljs.core.seq((state_34018[(4)]))){
var statearr_34120_35713 = state_34018;
(statearr_34120_35713[(1)] = cljs.core.first((state_34018[(4)])));

} else {
throw ex__30484__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30482__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35716 = state_34018;
state_34018 = G__35716;
continue;
} else {
return ret_value__30482__auto__;
}
break;
}
});
cljs$core$async$state_machine__30481__auto__ = function(state_34018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30481__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30481__auto____1.call(this,state_34018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30481__auto____0;
cljs$core$async$state_machine__30481__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30481__auto____1;
return cljs$core$async$state_machine__30481__auto__;
})()
})();
var state__30939__auto__ = (function (){var statearr_34122 = f__30938__auto__();
(statearr_34122[(6)] = c__30937__auto___35660);

return statearr_34122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30939__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
