goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41684 = schema.utils.use_fn_validation;
var output_schema41204_41685 = schema.core.Bool;
var input_schema41205_41686 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41206_41687 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41205_41686);
}),null));
var output_checker41207_41688 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41204_41685);
}),null));
var ret__40629__auto___41689 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41208){
var validate__38023__auto__ = cljs.core.deref(ufv___41684);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41690 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41208], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41213_41691 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41214_41692 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41215_41693 = input_schema41205_41686;
var G__41216_41694 = cljs.core.deref(input_checker41206_41687);
var G__41217_41695 = args__38024__auto___41690;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41213_41691,G__41214_41692,G__41215_41693,G__41216_41694,G__41217_41695) : schema.core.fn_validator.call(null,G__41213_41691,G__41214_41692,G__41215_41693,G__41216_41694,G__41217_41695));
} else {
var temp__5804__auto___41696 = (function (){var fexpr__41218 = cljs.core.deref(input_checker41206_41687);
return (fexpr__41218.cljs$core$IFn$_invoke$arity$1 ? fexpr__41218.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41690) : fexpr__41218.call(null,args__38024__auto___41690));
})();
if(cljs.core.truth_(temp__5804__auto___41696)){
var error__38025__auto___41697 = temp__5804__auto___41696;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41697], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41205_41686,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41690,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41697], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var arg = G__41208;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41220_41699 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41221_41700 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41222_41701 = output_schema41204_41685;
var G__41223_41702 = cljs.core.deref(output_checker41207_41688);
var G__41224_41703 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41220_41699,G__41221_41700,G__41222_41701,G__41223_41702,G__41224_41703) : schema.core.fn_validator.call(null,G__41220_41699,G__41221_41700,G__41222_41701,G__41223_41702,G__41224_41703));
} else {
var temp__5804__auto___41704 = (function (){var fexpr__41225 = cljs.core.deref(output_checker41207_41688);
return (fexpr__41225.cljs$core$IFn$_invoke$arity$1 ? fexpr__41225.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41225.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41704)){
var error__38025__auto___41705 = temp__5804__auto___41704;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41705], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41204_41685,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41705], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41204_41685,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41205_41686], null)));

var ufv___41706 = schema.utils.use_fn_validation;
var output_schema41226_41707 = deercreeklabs.baracus.ByteArray;
var input_schema41227_41708 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41231_41709 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41228_41710 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41227_41708);
}),null));
var output_checker41229_41711 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41226_41707);
}),null));
var input_checker41232_41712 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41231_41709);
}),null));
var output_checker41233_41713 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41226_41707);
}),null));
var ret__40629__auto___41714 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41239 = arguments.length;
switch (G__41239) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41230){
var validate__38023__auto__ = cljs.core.deref(ufv___41706);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41716 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41230], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41240_41717 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41241_41718 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41242_41719 = input_schema41227_41708;
var G__41243_41720 = cljs.core.deref(input_checker41228_41710);
var G__41244_41721 = args__38024__auto___41716;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41240_41717,G__41241_41718,G__41242_41719,G__41243_41720,G__41244_41721) : schema.core.fn_validator.call(null,G__41240_41717,G__41241_41718,G__41242_41719,G__41243_41720,G__41244_41721));
} else {
var temp__5804__auto___41722 = (function (){var fexpr__41245 = cljs.core.deref(input_checker41228_41710);
return (fexpr__41245.cljs$core$IFn$_invoke$arity$1 ? fexpr__41245.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41716) : fexpr__41245.call(null,args__38024__auto___41716));
})();
if(cljs.core.truth_(temp__5804__auto___41722)){
var error__38025__auto___41723 = temp__5804__auto___41722;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41723], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41227_41708,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41716,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41723], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var size_or_seq = G__41230;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41247_41725 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41248_41726 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41249_41727 = output_schema41226_41707;
var G__41250_41728 = cljs.core.deref(output_checker41229_41711);
var G__41251_41729 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41247_41725,G__41248_41726,G__41249_41727,G__41250_41728,G__41251_41729) : schema.core.fn_validator.call(null,G__41247_41725,G__41248_41726,G__41249_41727,G__41250_41728,G__41251_41729));
} else {
var temp__5804__auto___41730 = (function (){var fexpr__41252 = cljs.core.deref(output_checker41229_41711);
return (fexpr__41252.cljs$core$IFn$_invoke$arity$1 ? fexpr__41252.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41252.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41730)){
var error__38025__auto___41731 = temp__5804__auto___41730;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41731], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41226_41707,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41731], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41234,G__41235){
var validate__38023__auto__ = cljs.core.deref(ufv___41706);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41732 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41234,G__41235], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41253_41733 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41254_41734 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41255_41735 = input_schema41231_41709;
var G__41256_41736 = cljs.core.deref(input_checker41232_41712);
var G__41257_41737 = args__38024__auto___41732;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41253_41733,G__41254_41734,G__41255_41735,G__41256_41736,G__41257_41737) : schema.core.fn_validator.call(null,G__41253_41733,G__41254_41734,G__41255_41735,G__41256_41736,G__41257_41737));
} else {
var temp__5804__auto___41738 = (function (){var fexpr__41258 = cljs.core.deref(input_checker41232_41712);
return (fexpr__41258.cljs$core$IFn$_invoke$arity$1 ? fexpr__41258.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41732) : fexpr__41258.call(null,args__38024__auto___41732));
})();
if(cljs.core.truth_(temp__5804__auto___41738)){
var error__38025__auto___41739 = temp__5804__auto___41738;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41739], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41231_41709,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41732,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41739], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var size = G__41234;
var init_val_or_seq = G__41235;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41259_41740 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41260_41741 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41261_41742 = output_schema41226_41707;
var G__41262_41743 = cljs.core.deref(output_checker41233_41713);
var G__41263_41744 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41259_41740,G__41260_41741,G__41261_41742,G__41262_41743,G__41263_41744) : schema.core.fn_validator.call(null,G__41259_41740,G__41260_41741,G__41261_41742,G__41262_41743,G__41263_41744));
} else {
var temp__5804__auto___41745 = (function (){var fexpr__41264 = cljs.core.deref(output_checker41233_41713);
return (fexpr__41264.cljs$core$IFn$_invoke$arity$1 ? fexpr__41264.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41264.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41745)){
var error__38025__auto___41746 = temp__5804__auto___41745;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41746], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41226_41707,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41746], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41226_41707,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41227_41708,input_schema41231_41709], null)));

var ufv___41748 = schema.utils.use_fn_validation;
var output_schema41266_41749 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41267_41750 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41268_41751 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41267_41750);
}),null));
var output_checker41269_41752 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41266_41749);
}),null));
var ret__40629__auto___41753 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41270){
var validate__38023__auto__ = cljs.core.deref(ufv___41748);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41754 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41270], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41271_41755 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41272_41756 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41273_41757 = input_schema41267_41750;
var G__41274_41758 = cljs.core.deref(input_checker41268_41751);
var G__41275_41759 = args__38024__auto___41754;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41271_41755,G__41272_41756,G__41273_41757,G__41274_41758,G__41275_41759) : schema.core.fn_validator.call(null,G__41271_41755,G__41272_41756,G__41273_41757,G__41274_41758,G__41275_41759));
} else {
var temp__5804__auto___41760 = (function (){var fexpr__41277 = cljs.core.deref(input_checker41268_41751);
return (fexpr__41277.cljs$core$IFn$_invoke$arity$1 ? fexpr__41277.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41754) : fexpr__41277.call(null,args__38024__auto___41754));
})();
if(cljs.core.truth_(temp__5804__auto___41760)){
var error__38025__auto___41761 = temp__5804__auto___41760;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41761], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41267_41750,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41754,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41761], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var arrays = G__41270;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41278 = cljs.core.count(arrays__$1);
switch (G__41278) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41278,arrays__$1,validate__38023__auto__,ufv___41748,output_schema41266_41749,input_schema41267_41750,input_checker41268_41751,output_checker41269_41752){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41278,arrays__$1,validate__38023__auto__,ufv___41748,output_schema41266_41749,input_schema41267_41750,input_checker41268_41751,output_checker41269_41752))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41278,arrays__$1,validate__38023__auto__,ufv___41748,output_schema41266_41749,input_schema41267_41750,input_checker41268_41751,output_checker41269_41752){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41278,arrays__$1,validate__38023__auto__,ufv___41748,output_schema41266_41749,input_schema41267_41750,input_checker41268_41751,output_checker41269_41752))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41280_41763 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41281_41764 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41282_41765 = output_schema41266_41749;
var G__41283_41766 = cljs.core.deref(output_checker41269_41752);
var G__41284_41767 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41280_41763,G__41281_41764,G__41282_41765,G__41283_41766,G__41284_41767) : schema.core.fn_validator.call(null,G__41280_41763,G__41281_41764,G__41282_41765,G__41283_41766,G__41284_41767));
} else {
var temp__5804__auto___41769 = (function (){var fexpr__41285 = cljs.core.deref(output_checker41269_41752);
return (fexpr__41285.cljs$core$IFn$_invoke$arity$1 ? fexpr__41285.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41285.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41769)){
var error__38025__auto___41770 = temp__5804__auto___41769;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41770], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41266_41749,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41770], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41266_41749,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41267_41750], null)));

var ufv___41771 = schema.utils.use_fn_validation;
var output_schema41286_41772 = schema.core.Bool;
var input_schema41287_41773 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41288_41774 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41287_41773);
}),null));
var output_checker41289_41775 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41286_41772);
}),null));
var ret__40629__auto___41776 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41290,G__41291){
var validate__38023__auto__ = cljs.core.deref(ufv___41771);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41777 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41290,G__41291], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41293_41779 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41294_41780 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41295_41781 = input_schema41287_41773;
var G__41296_41782 = cljs.core.deref(input_checker41288_41774);
var G__41297_41783 = args__38024__auto___41777;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41293_41779,G__41294_41780,G__41295_41781,G__41296_41782,G__41297_41783) : schema.core.fn_validator.call(null,G__41293_41779,G__41294_41780,G__41295_41781,G__41296_41782,G__41297_41783));
} else {
var temp__5804__auto___41785 = (function (){var fexpr__41298 = cljs.core.deref(input_checker41288_41774);
return (fexpr__41298.cljs$core$IFn$_invoke$arity$1 ? fexpr__41298.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41777) : fexpr__41298.call(null,args__38024__auto___41777));
})();
if(cljs.core.truth_(temp__5804__auto___41785)){
var error__38025__auto___41786 = temp__5804__auto___41785;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41786], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41287_41773,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41777,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41786], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var a = G__41290;
var b = G__41291;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41789 = ((i + (1)) | (0));
i = G__41789;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41302_41790 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41303_41791 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41304_41792 = output_schema41286_41772;
var G__41305_41793 = cljs.core.deref(output_checker41289_41775);
var G__41306_41794 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41302_41790,G__41303_41791,G__41304_41792,G__41305_41793,G__41306_41794) : schema.core.fn_validator.call(null,G__41302_41790,G__41303_41791,G__41304_41792,G__41305_41793,G__41306_41794));
} else {
var temp__5804__auto___41797 = (function (){var fexpr__41307 = cljs.core.deref(output_checker41289_41775);
return (fexpr__41307.cljs$core$IFn$_invoke$arity$1 ? fexpr__41307.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41307.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41797)){
var error__38025__auto___41798 = temp__5804__auto___41797;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41798], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41286_41772,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41798], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41286_41772,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41287_41773], null)));

var ufv___41801 = schema.utils.use_fn_validation;
var output_schema41309_41802 = schema.core.Str;
var input_schema41310_41803 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41311_41804 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41310_41803);
}),null));
var output_checker41312_41805 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41309_41802);
}),null));
var ret__40629__auto___41807 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41313){
var validate__38023__auto__ = cljs.core.deref(ufv___41801);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41808 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41313], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41314_41809 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41315_41810 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41316_41811 = input_schema41310_41803;
var G__41317_41812 = cljs.core.deref(input_checker41311_41804);
var G__41318_41813 = args__38024__auto___41808;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41314_41809,G__41315_41810,G__41316_41811,G__41317_41812,G__41318_41813) : schema.core.fn_validator.call(null,G__41314_41809,G__41315_41810,G__41316_41811,G__41317_41812,G__41318_41813));
} else {
var temp__5804__auto___41814 = (function (){var fexpr__41319 = cljs.core.deref(input_checker41311_41804);
return (fexpr__41319.cljs$core$IFn$_invoke$arity$1 ? fexpr__41319.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41808) : fexpr__41319.call(null,args__38024__auto___41808));
})();
if(cljs.core.truth_(temp__5804__auto___41814)){
var error__38025__auto___41815 = temp__5804__auto___41814;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41815], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41310_41803,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41808,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41815], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41313;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41321_41823 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41322_41824 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41323_41825 = output_schema41309_41802;
var G__41324_41826 = cljs.core.deref(output_checker41312_41805);
var G__41325_41827 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41321_41823,G__41322_41824,G__41323_41825,G__41324_41826,G__41325_41827) : schema.core.fn_validator.call(null,G__41321_41823,G__41322_41824,G__41323_41825,G__41324_41826,G__41325_41827));
} else {
var temp__5804__auto___41829 = (function (){var fexpr__41326 = cljs.core.deref(output_checker41312_41805);
return (fexpr__41326.cljs$core$IFn$_invoke$arity$1 ? fexpr__41326.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41326.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41829)){
var error__38025__auto___41830 = temp__5804__auto___41829;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41830], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41309_41802,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41830], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41309_41802,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41310_41803], null)));

var ufv___41832 = schema.utils.use_fn_validation;
var output_schema41327_41833 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41328_41834 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41332_41835 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41337_41836 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41329_41837 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41328_41834);
}),null));
var output_checker41330_41838 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41327_41833);
}),null));
var input_checker41333_41839 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41332_41835);
}),null));
var output_checker41334_41840 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41327_41833);
}),null));
var input_checker41338_41841 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41337_41836);
}),null));
var output_checker41339_41842 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41327_41833);
}),null));
var ret__40629__auto___41847 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41346 = arguments.length;
switch (G__41346) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41331){
var validate__38023__auto__ = cljs.core.deref(ufv___41832);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41851 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41331], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41347_41852 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41348_41853 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41349_41854 = input_schema41328_41834;
var G__41350_41855 = cljs.core.deref(input_checker41329_41837);
var G__41351_41856 = args__38024__auto___41851;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41347_41852,G__41348_41853,G__41349_41854,G__41350_41855,G__41351_41856) : schema.core.fn_validator.call(null,G__41347_41852,G__41348_41853,G__41349_41854,G__41350_41855,G__41351_41856));
} else {
var temp__5804__auto___41859 = (function (){var fexpr__41352 = cljs.core.deref(input_checker41329_41837);
return (fexpr__41352.cljs$core$IFn$_invoke$arity$1 ? fexpr__41352.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41851) : fexpr__41352.call(null,args__38024__auto___41851));
})();
if(cljs.core.truth_(temp__5804__auto___41859)){
var error__38025__auto___41860 = temp__5804__auto___41859;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41860], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41328_41834,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41851,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41860], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41331;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41353_41865 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41354_41866 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41355_41867 = output_schema41327_41833;
var G__41356_41868 = cljs.core.deref(output_checker41330_41838);
var G__41357_41869 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41353_41865,G__41354_41866,G__41355_41867,G__41356_41868,G__41357_41869) : schema.core.fn_validator.call(null,G__41353_41865,G__41354_41866,G__41355_41867,G__41356_41868,G__41357_41869));
} else {
var temp__5804__auto___41871 = (function (){var fexpr__41358 = cljs.core.deref(output_checker41330_41838);
return (fexpr__41358.cljs$core$IFn$_invoke$arity$1 ? fexpr__41358.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41358.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41871)){
var error__38025__auto___41872 = temp__5804__auto___41871;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41872], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41327_41833,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41872], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41335,G__41336){
var validate__38023__auto__ = cljs.core.deref(ufv___41832);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41878 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41335,G__41336], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41360_41879 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41361_41880 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41362_41881 = input_schema41332_41835;
var G__41363_41882 = cljs.core.deref(input_checker41333_41839);
var G__41364_41883 = args__38024__auto___41878;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41360_41879,G__41361_41880,G__41362_41881,G__41363_41882,G__41364_41883) : schema.core.fn_validator.call(null,G__41360_41879,G__41361_41880,G__41362_41881,G__41363_41882,G__41364_41883));
} else {
var temp__5804__auto___41886 = (function (){var fexpr__41365 = cljs.core.deref(input_checker41333_41839);
return (fexpr__41365.cljs$core$IFn$_invoke$arity$1 ? fexpr__41365.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41878) : fexpr__41365.call(null,args__38024__auto___41878));
})();
if(cljs.core.truth_(temp__5804__auto___41886)){
var error__38025__auto___41887 = temp__5804__auto___41886;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41887], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41332_41835,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41878,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41887], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41335;
var start = G__41336;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41366_41890 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41367_41891 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41368_41892 = output_schema41327_41833;
var G__41369_41893 = cljs.core.deref(output_checker41334_41840);
var G__41370_41894 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41366_41890,G__41367_41891,G__41368_41892,G__41369_41893,G__41370_41894) : schema.core.fn_validator.call(null,G__41366_41890,G__41367_41891,G__41368_41892,G__41369_41893,G__41370_41894));
} else {
var temp__5804__auto___41898 = (function (){var fexpr__41371 = cljs.core.deref(output_checker41334_41840);
return (fexpr__41371.cljs$core$IFn$_invoke$arity$1 ? fexpr__41371.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41371.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41898)){
var error__38025__auto___41900 = temp__5804__auto___41898;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41900], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41327_41833,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41900], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41340,G__41341,G__41342){
var validate__38023__auto__ = cljs.core.deref(ufv___41832);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41903 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41340,G__41341,G__41342], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41372_41904 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41373_41905 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41374_41906 = input_schema41337_41836;
var G__41375_41907 = cljs.core.deref(input_checker41338_41841);
var G__41376_41908 = args__38024__auto___41903;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41372_41904,G__41373_41905,G__41374_41906,G__41375_41907,G__41376_41908) : schema.core.fn_validator.call(null,G__41372_41904,G__41373_41905,G__41374_41906,G__41375_41907,G__41376_41908));
} else {
var temp__5804__auto___41911 = (function (){var fexpr__41377 = cljs.core.deref(input_checker41338_41841);
return (fexpr__41377.cljs$core$IFn$_invoke$arity$1 ? fexpr__41377.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41903) : fexpr__41377.call(null,args__38024__auto___41903));
})();
if(cljs.core.truth_(temp__5804__auto___41911)){
var error__38025__auto___41912 = temp__5804__auto___41911;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41912], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41337_41836,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41903,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41912], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41340;
var start = G__41341;
var end = G__41342;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41378_41918 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41379_41919 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41380_41920 = output_schema41327_41833;
var G__41381_41921 = cljs.core.deref(output_checker41339_41842);
var G__41382_41922 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41378_41918,G__41379_41919,G__41380_41920,G__41381_41921,G__41382_41922) : schema.core.fn_validator.call(null,G__41378_41918,G__41379_41919,G__41380_41920,G__41381_41921,G__41382_41922));
} else {
var temp__5804__auto___41925 = (function (){var fexpr__41383 = cljs.core.deref(output_checker41339_41842);
return (fexpr__41383.cljs$core$IFn$_invoke$arity$1 ? fexpr__41383.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41383.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41925)){
var error__38025__auto___41926 = temp__5804__auto___41925;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41926], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41327_41833,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41926], null));
} else {
}
}
} else {
}

return o__38026__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41327_41833,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41328_41834,input_schema41332_41835,input_schema41337_41836], null)));

var ufv___41931 = schema.utils.use_fn_validation;
var output_schema41384_41932 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41385_41933 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41386_41934 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41385_41933);
}),null));
var output_checker41387_41935 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41384_41932);
}),null));
var ret__40629__auto___41937 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41388){
var validate__38023__auto__ = cljs.core.deref(ufv___41931);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41938 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41388], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41390_41939 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41391_41940 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41392_41941 = input_schema41385_41933;
var G__41393_41942 = cljs.core.deref(input_checker41386_41934);
var G__41394_41943 = args__38024__auto___41938;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41390_41939,G__41391_41940,G__41392_41941,G__41393_41942,G__41394_41943) : schema.core.fn_validator.call(null,G__41390_41939,G__41391_41940,G__41392_41941,G__41393_41942,G__41394_41943));
} else {
var temp__5804__auto___41946 = (function (){var fexpr__41395 = cljs.core.deref(input_checker41386_41934);
return (fexpr__41395.cljs$core$IFn$_invoke$arity$1 ? fexpr__41395.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41938) : fexpr__41395.call(null,args__38024__auto___41938));
})();
if(cljs.core.truth_(temp__5804__auto___41946)){
var error__38025__auto___41948 = temp__5804__auto___41946;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41948], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41385_41933,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41938,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41948], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41388;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5636__auto___41953 = num;
var i_41954 = (0);
while(true){
if((i_41954 < n__5636__auto___41953)){
(new$[i_41954] = (ba[(last - i_41954)]));

var G__41955 = (i_41954 + (1));
i_41954 = G__41955;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41396_41956 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41397_41957 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41398_41958 = output_schema41384_41932;
var G__41399_41959 = cljs.core.deref(output_checker41387_41935);
var G__41400_41960 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41396_41956,G__41397_41957,G__41398_41958,G__41399_41959,G__41400_41960) : schema.core.fn_validator.call(null,G__41396_41956,G__41397_41957,G__41398_41958,G__41399_41959,G__41400_41960));
} else {
var temp__5804__auto___41962 = (function (){var fexpr__41401 = cljs.core.deref(output_checker41387_41935);
return (fexpr__41401.cljs$core$IFn$_invoke$arity$1 ? fexpr__41401.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41401.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41962)){
var error__38025__auto___41963 = temp__5804__auto___41962;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41963], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41384_41932,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41963], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41384_41932,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41385_41933], null)));

var ufv___41966 = schema.utils.use_fn_validation;
var output_schema41403_41967 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41404_41968 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41405_41969 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41404_41968);
}),null));
var output_checker41406_41970 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41403_41967);
}),null));
var ret__40629__auto___41973 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41407,G__41408){
var validate__38023__auto__ = cljs.core.deref(ufv___41966);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___41976 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41407,G__41408], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41409_41977 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41410_41978 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41411_41979 = input_schema41404_41968;
var G__41412_41980 = cljs.core.deref(input_checker41405_41969);
var G__41413_41981 = args__38024__auto___41976;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41409_41977,G__41410_41978,G__41411_41979,G__41412_41980,G__41413_41981) : schema.core.fn_validator.call(null,G__41409_41977,G__41410_41978,G__41411_41979,G__41412_41980,G__41413_41981));
} else {
var temp__5804__auto___41983 = (function (){var fexpr__41415 = cljs.core.deref(input_checker41405_41969);
return (fexpr__41415.cljs$core$IFn$_invoke$arity$1 ? fexpr__41415.cljs$core$IFn$_invoke$arity$1(args__38024__auto___41976) : fexpr__41415.call(null,args__38024__auto___41976));
})();
if(cljs.core.truth_(temp__5804__auto___41983)){
var error__38025__auto___41985 = temp__5804__auto___41983;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41985], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41404_41968,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___41976,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41985], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41407;
var fragment_size = G__41408;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__41987 = (end_offset | (0));
var G__41988 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__41987;
output = G__41988;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41416_41989 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41417_41990 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41418_41991 = output_schema41403_41967;
var G__41419_41992 = cljs.core.deref(output_checker41406_41970);
var G__41420_41993 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41416_41989,G__41417_41990,G__41418_41991,G__41419_41992,G__41420_41993) : schema.core.fn_validator.call(null,G__41416_41989,G__41417_41990,G__41418_41991,G__41419_41992,G__41420_41993));
} else {
var temp__5804__auto___41995 = (function (){var fexpr__41421 = cljs.core.deref(output_checker41406_41970);
return (fexpr__41421.cljs$core$IFn$_invoke$arity$1 ? fexpr__41421.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41421.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41995)){
var error__38025__auto___41996 = temp__5804__auto___41995;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___41996], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41403_41967,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___41996], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41403_41967,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41404_41968], null)));

var ufv___41997 = schema.utils.use_fn_validation;
var output_schema41423_41998 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41424_41999 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41425_42000 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41424_41999);
}),null));
var output_checker41426_42001 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41423_41998);
}),null));
var ret__40629__auto___42002 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an variable-length zig-zag encoded byte array and reads an integer
 * from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41427){
var validate__38023__auto__ = cljs.core.deref(ufv___41997);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42003 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41427], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41428_42004 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41429_42005 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41430_42006 = input_schema41424_41999;
var G__41431_42007 = cljs.core.deref(input_checker41425_42000);
var G__41432_42008 = args__38024__auto___42003;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41428_42004,G__41429_42005,G__41430_42006,G__41431_42007,G__41432_42008) : schema.core.fn_validator.call(null,G__41428_42004,G__41429_42005,G__41430_42006,G__41431_42007,G__41432_42008));
} else {
var temp__5804__auto___42011 = (function (){var fexpr__41433 = cljs.core.deref(input_checker41425_42000);
return (fexpr__41433.cljs$core$IFn$_invoke$arity$1 ? fexpr__41433.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42003) : fexpr__41433.call(null,args__38024__auto___42003));
})();
if(cljs.core.truth_(temp__5804__auto___42011)){
var error__38025__auto___42012 = temp__5804__auto___42011;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42012], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41424_41999,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42003,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42012], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41427;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__42021 = (n + (1));
var G__42022 = (i__$1 | (0));
var G__42023 = (out__$1 | (0));
n = G__42021;
i = G__42022;
out = G__42023;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41435_42024 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41436_42025 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41437_42026 = output_schema41423_41998;
var G__41438_42027 = cljs.core.deref(output_checker41426_42001);
var G__41439_42028 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41435_42024,G__41436_42025,G__41437_42026,G__41438_42027,G__41439_42028) : schema.core.fn_validator.call(null,G__41435_42024,G__41436_42025,G__41437_42026,G__41438_42027,G__41439_42028));
} else {
var temp__5804__auto___42030 = (function (){var fexpr__41440 = cljs.core.deref(output_checker41426_42001);
return (fexpr__41440.cljs$core$IFn$_invoke$arity$1 ? fexpr__41440.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41440.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42030)){
var error__38025__auto___42031 = temp__5804__auto___42030;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42031], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41423_41998,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42031], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41423_41998,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41424_41999], null)));

var ufv___42032 = schema.utils.use_fn_validation;
var output_schema41442_42033 = deercreeklabs.baracus.ByteArray;
var input_schema41443_42034 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41444_42035 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41443_42034);
}),null));
var output_checker41445_42036 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41442_42033);
}),null));
var ret__40629__auto___42037 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Encodes an integer using variable length zig-zag coding.
 * Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41446){
var validate__38023__auto__ = cljs.core.deref(ufv___42032);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42038 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41446], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41448_42040 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41449_42041 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41450_42043 = input_schema41443_42034;
var G__41451_42044 = cljs.core.deref(input_checker41444_42035);
var G__41452_42045 = args__38024__auto___42038;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41448_42040,G__41449_42041,G__41450_42043,G__41451_42044,G__41452_42045) : schema.core.fn_validator.call(null,G__41448_42040,G__41449_42041,G__41450_42043,G__41451_42044,G__41452_42045));
} else {
var temp__5804__auto___42047 = (function (){var fexpr__41453 = cljs.core.deref(input_checker41444_42035);
return (fexpr__41453.cljs$core$IFn$_invoke$arity$1 ? fexpr__41453.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42038) : fexpr__41453.call(null,args__38024__auto___42038));
})();
if(cljs.core.truth_(temp__5804__auto___42047)){
var error__38025__auto___42050 = temp__5804__auto___42047;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42050], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41443_42034,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42038,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42050], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var i = G__41446;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__42055 = (n >>> (7));
var G__42056 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__42055;
out = G__42056;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41457_42058 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41458_42059 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41459_42060 = output_schema41442_42033;
var G__41460_42061 = cljs.core.deref(output_checker41445_42036);
var G__41461_42062 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41457_42058,G__41458_42059,G__41459_42060,G__41460_42061,G__41461_42062) : schema.core.fn_validator.call(null,G__41457_42058,G__41458_42059,G__41459_42060,G__41460_42061,G__41461_42062));
} else {
var temp__5804__auto___42063 = (function (){var fexpr__41462 = cljs.core.deref(output_checker41445_42036);
return (fexpr__41462.cljs$core$IFn$_invoke$arity$1 ? fexpr__41462.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41462.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42063)){
var error__38025__auto___42064 = temp__5804__auto___42063;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42064], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41442_42033,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42064], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41442_42033,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41443_42034], null)));

var ufv___42065 = schema.utils.use_fn_validation;
var output_schema41464_42066 = schema.core.maybe(schema.core.Str);
var input_schema41465_42067 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41466_42068 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41465_42067);
}),null));
var output_checker41467_42069 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41464_42066);
}),null));
var ret__40629__auto___42070 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41468){
var validate__38023__auto__ = cljs.core.deref(ufv___42065);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42071 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41468], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41469_42072 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41470_42073 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41471_42074 = input_schema41465_42067;
var G__41472_42075 = cljs.core.deref(input_checker41466_42068);
var G__41473_42076 = args__38024__auto___42071;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41469_42072,G__41470_42073,G__41471_42074,G__41472_42075,G__41473_42076) : schema.core.fn_validator.call(null,G__41469_42072,G__41470_42073,G__41471_42074,G__41472_42075,G__41473_42076));
} else {
var temp__5804__auto___42077 = (function (){var fexpr__41474 = cljs.core.deref(input_checker41466_42068);
return (fexpr__41474.cljs$core$IFn$_invoke$arity$1 ? fexpr__41474.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42071) : fexpr__41474.call(null,args__38024__auto___42071));
})();
if(cljs.core.truth_(temp__5804__auto___42077)){
var error__38025__auto___42078 = temp__5804__auto___42077;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42078], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41465_42067,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42071,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42078], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var b = G__41468;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41475_42080 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41476_42081 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41477_42082 = output_schema41464_42066;
var G__41478_42083 = cljs.core.deref(output_checker41467_42069);
var G__41479_42084 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41475_42080,G__41476_42081,G__41477_42082,G__41478_42083,G__41479_42084) : schema.core.fn_validator.call(null,G__41475_42080,G__41476_42081,G__41477_42082,G__41478_42083,G__41479_42084));
} else {
var temp__5804__auto___42085 = (function (){var fexpr__41481 = cljs.core.deref(output_checker41467_42069);
return (fexpr__41481.cljs$core$IFn$_invoke$arity$1 ? fexpr__41481.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41481.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42085)){
var error__38025__auto___42086 = temp__5804__auto___42085;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42086], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41464_42066,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42086], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41464_42066,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41465_42067], null)));

var ufv___42087 = schema.utils.use_fn_validation;
var output_schema41482_42088 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41483_42089 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41484_42090 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41483_42089);
}),null));
var output_checker41485_42091 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41482_42088);
}),null));
var ret__40629__auto___42092 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41486){
var validate__38023__auto__ = cljs.core.deref(ufv___42087);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42093 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41486], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41488_42094 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41489_42095 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41490_42096 = input_schema41483_42089;
var G__41491_42097 = cljs.core.deref(input_checker41484_42090);
var G__41492_42098 = args__38024__auto___42093;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41488_42094,G__41489_42095,G__41490_42096,G__41491_42097,G__41492_42098) : schema.core.fn_validator.call(null,G__41488_42094,G__41489_42095,G__41490_42096,G__41491_42097,G__41492_42098));
} else {
var temp__5804__auto___42099 = (function (){var fexpr__41493 = cljs.core.deref(input_checker41484_42090);
return (fexpr__41493.cljs$core$IFn$_invoke$arity$1 ? fexpr__41493.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42093) : fexpr__41493.call(null,args__38024__auto___42093));
})();
if(cljs.core.truth_(temp__5804__auto___42099)){
var error__38025__auto___42100 = temp__5804__auto___42099;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42100], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41483_42089,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42093,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42100], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var s = G__41486;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41494_42105 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41495_42106 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41496_42107 = output_schema41482_42088;
var G__41497_42108 = cljs.core.deref(output_checker41485_42091);
var G__41498_42109 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41494_42105,G__41495_42106,G__41496_42107,G__41497_42108,G__41498_42109) : schema.core.fn_validator.call(null,G__41494_42105,G__41495_42106,G__41496_42107,G__41497_42108,G__41498_42109));
} else {
var temp__5804__auto___42110 = (function (){var fexpr__41499 = cljs.core.deref(output_checker41485_42091);
return (fexpr__41499.cljs$core$IFn$_invoke$arity$1 ? fexpr__41499.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41499.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42110)){
var error__38025__auto___42111 = temp__5804__auto___42110;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42111], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41482_42088,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42111], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41482_42088,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41483_42089], null)));

var ufv___42115 = schema.utils.use_fn_validation;
var output_schema41503_42116 = schema.core.maybe(schema.core.Str);
var input_schema41504_42117 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41505_42118 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41504_42117);
}),null));
var output_checker41506_42119 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41503_42116);
}),null));
var ret__40629__auto___42120 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41507){
var validate__38023__auto__ = cljs.core.deref(ufv___42115);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42121 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41507], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41508_42122 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41509_42123 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41510_42124 = input_schema41504_42117;
var G__41511_42125 = cljs.core.deref(input_checker41505_42118);
var G__41512_42126 = args__38024__auto___42121;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41508_42122,G__41509_42123,G__41510_42124,G__41511_42125,G__41512_42126) : schema.core.fn_validator.call(null,G__41508_42122,G__41509_42123,G__41510_42124,G__41511_42125,G__41512_42126));
} else {
var temp__5804__auto___42128 = (function (){var fexpr__41514 = cljs.core.deref(input_checker41505_42118);
return (fexpr__41514.cljs$core$IFn$_invoke$arity$1 ? fexpr__41514.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42121) : fexpr__41514.call(null,args__38024__auto___42121));
})();
if(cljs.core.truth_(temp__5804__auto___42128)){
var error__38025__auto___42130 = temp__5804__auto___42128;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42130], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41504_42117,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42121,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42130], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41507;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41515_42131 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41516_42132 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41517_42133 = output_schema41503_42116;
var G__41518_42134 = cljs.core.deref(output_checker41506_42119);
var G__41519_42135 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41515_42131,G__41516_42132,G__41517_42133,G__41518_42134,G__41519_42135) : schema.core.fn_validator.call(null,G__41515_42131,G__41516_42132,G__41517_42133,G__41518_42134,G__41519_42135));
} else {
var temp__5804__auto___42136 = (function (){var fexpr__41521 = cljs.core.deref(output_checker41506_42119);
return (fexpr__41521.cljs$core$IFn$_invoke$arity$1 ? fexpr__41521.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41521.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42136)){
var error__38025__auto___42137 = temp__5804__auto___42136;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42137], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41503_42116,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42137], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41503_42116,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41504_42117], null)));

var ufv___42138 = schema.utils.use_fn_validation;
var output_schema41522_42139 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41523_42140 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41524_42141 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41523_42140);
}),null));
var output_checker41525_42142 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41522_42139);
}),null));
var ret__40629__auto___42143 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41526){
var validate__38023__auto__ = cljs.core.deref(ufv___42138);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42144 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41526], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41528_42145 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41529_42146 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41530_42147 = input_schema41523_42140;
var G__41531_42148 = cljs.core.deref(input_checker41524_42141);
var G__41532_42149 = args__38024__auto___42144;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41528_42145,G__41529_42146,G__41530_42147,G__41531_42148,G__41532_42149) : schema.core.fn_validator.call(null,G__41528_42145,G__41529_42146,G__41530_42147,G__41531_42148,G__41532_42149));
} else {
var temp__5804__auto___42151 = (function (){var fexpr__41533 = cljs.core.deref(input_checker41524_42141);
return (fexpr__41533.cljs$core$IFn$_invoke$arity$1 ? fexpr__41533.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42144) : fexpr__41533.call(null,args__38024__auto___42144));
})();
if(cljs.core.truth_(temp__5804__auto___42151)){
var error__38025__auto___42152 = temp__5804__auto___42151;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42152], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41523_42140,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42144,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42152], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var s = G__41526;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41535_42154 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41536_42155 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41537_42156 = output_schema41522_42139;
var G__41538_42157 = cljs.core.deref(output_checker41525_42142);
var G__41539_42158 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41535_42154,G__41536_42155,G__41537_42156,G__41538_42157,G__41539_42158) : schema.core.fn_validator.call(null,G__41535_42154,G__41536_42155,G__41537_42156,G__41538_42157,G__41539_42158));
} else {
var temp__5804__auto___42159 = (function (){var fexpr__41540 = cljs.core.deref(output_checker41525_42142);
return (fexpr__41540.cljs$core$IFn$_invoke$arity$1 ? fexpr__41540.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41540.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42159)){
var error__38025__auto___42160 = temp__5804__auto___42159;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42160], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41522_42139,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42160], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41522_42139,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41523_42140], null)));

deercreeklabs.baracus.byte_array__GT_hex_str_STAR_ = (function deercreeklabs$baracus$byte_array__GT_hex_str_STAR_(p__41541){
var map__41542 = p__41541;
var map__41542__$1 = cljs.core.__destructure_map(map__41542);
var alphabet = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41542__$1,new cljs.core.Keyword(null,"alphabet","alphabet",788478088));
var ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41542__$1,new cljs.core.Keyword(null,"ba","ba",-960950298));
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var ca = (new Array(((2) * len)));
var n__5636__auto___42162 = len;
var i_42163 = (0);
while(true){
if((i_42163 < n__5636__auto___42162)){
var b_42164 = ((ba[i_42163]) & (255));
var j_42165 = ((2) * i_42163);
(ca[j_42165] = (function (){var G__41543 = (b_42164 >> (4));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41543) : alphabet.call(null,G__41543));
})());

(ca[(j_42165 + (1))] = (function (){var G__41545 = (b_42164 & (15));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41545) : alphabet.call(null,G__41545));
})());

var G__42166 = (i_42163 + (1));
i_42163 = G__42166;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
});
var ufv___42167 = schema.utils.use_fn_validation;
var output_schema41546_42168 = schema.core.maybe(schema.core.Str);
var input_schema41547_42169 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41548_42170 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41547_42169);
}),null));
var output_checker41549_42171 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41546_42168);
}),null));
var ret__40629__auto___42172 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41550){
var validate__38023__auto__ = cljs.core.deref(ufv___42167);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42173 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41550], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41552_42174 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41553_42175 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41554_42176 = input_schema41547_42169;
var G__41555_42177 = cljs.core.deref(input_checker41548_42170);
var G__41556_42178 = args__38024__auto___42173;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41552_42174,G__41553_42175,G__41554_42176,G__41555_42177,G__41556_42178) : schema.core.fn_validator.call(null,G__41552_42174,G__41553_42175,G__41554_42176,G__41555_42177,G__41556_42178));
} else {
var temp__5804__auto___42179 = (function (){var fexpr__41557 = cljs.core.deref(input_checker41548_42170);
return (fexpr__41557.cljs$core$IFn$_invoke$arity$1 ? fexpr__41557.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42173) : fexpr__41557.call(null,args__38024__auto___42173));
})();
if(cljs.core.truth_(temp__5804__auto___42179)){
var error__38025__auto___42180 = temp__5804__auto___42179;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42180], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41547_42169,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42173,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42180], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41550;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41558_42181 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41559_42182 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41560_42183 = output_schema41546_42168;
var G__41561_42184 = cljs.core.deref(output_checker41549_42171);
var G__41562_42185 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41558_42181,G__41559_42182,G__41560_42183,G__41561_42184,G__41562_42185) : schema.core.fn_validator.call(null,G__41558_42181,G__41559_42182,G__41560_42183,G__41561_42184,G__41562_42185));
} else {
var temp__5804__auto___42186 = (function (){var fexpr__41563 = cljs.core.deref(output_checker41549_42171);
return (fexpr__41563.cljs$core$IFn$_invoke$arity$1 ? fexpr__41563.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41563.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42186)){
var error__38025__auto___42187 = temp__5804__auto___42186;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42187], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41546_42168,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42187], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41546_42168,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41547_42169], null)));

var ufv___42188 = schema.utils.use_fn_validation;
var output_schema41567_42189 = schema.core.maybe(schema.core.Str);
var input_schema41568_42190 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41569_42191 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41568_42190);
}),null));
var output_checker41570_42192 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41567_42189);
}),null));
var ret__40629__auto___42193 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_upper_hex_str = (function deercreeklabs$baracus$byte_array__GT_upper_hex_str(G__41571){
var validate__38023__auto__ = cljs.core.deref(ufv___42188);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42194 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41571], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41573_42195 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41574_42196 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41575_42197 = input_schema41568_42190;
var G__41576_42198 = cljs.core.deref(input_checker41569_42191);
var G__41577_42199 = args__38024__auto___42194;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41573_42195,G__41574_42196,G__41575_42197,G__41576_42198,G__41577_42199) : schema.core.fn_validator.call(null,G__41573_42195,G__41574_42196,G__41575_42197,G__41576_42198,G__41577_42199));
} else {
var temp__5804__auto___42200 = (function (){var fexpr__41578 = cljs.core.deref(input_checker41569_42191);
return (fexpr__41578.cljs$core$IFn$_invoke$arity$1 ? fexpr__41578.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42194) : fexpr__41578.call(null,args__38024__auto___42194));
})();
if(cljs.core.truth_(temp__5804__auto___42200)){
var error__38025__auto___42201 = temp__5804__auto___42200;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42201], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41568_42190,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42194,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42201], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41571;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41579_42202 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41580_42203 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41581_42204 = output_schema41567_42189;
var G__41582_42205 = cljs.core.deref(output_checker41570_42192);
var G__41583_42206 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41579_42202,G__41580_42203,G__41581_42204,G__41582_42205,G__41583_42206) : schema.core.fn_validator.call(null,G__41579_42202,G__41580_42203,G__41581_42204,G__41582_42205,G__41583_42206));
} else {
var temp__5804__auto___42207 = (function (){var fexpr__41584 = cljs.core.deref(output_checker41570_42192);
return (fexpr__41584.cljs$core$IFn$_invoke$arity$1 ? fexpr__41584.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41584.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42207)){
var error__38025__auto___42209 = temp__5804__auto___42207;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42209], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41567_42189,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42209], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_upper_hex_str),schema.core.__GT_FnSchema(output_schema41567_42189,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41568_42190], null)));

var ufv___42210 = schema.utils.use_fn_validation;
var output_schema41585_42211 = schema.core.maybe(schema.core.Str);
var input_schema41586_42212 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41587_42213 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41586_42212);
}),null));
var output_checker41588_42214 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41585_42211);
}),null));
var ret__40629__auto___42215 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_b16_alpha_str = (function deercreeklabs$baracus$byte_array__GT_b16_alpha_str(G__41589){
var validate__38023__auto__ = cljs.core.deref(ufv___42210);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42217 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41589], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41591_42218 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41592_42219 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41593_42220 = input_schema41586_42212;
var G__41594_42221 = cljs.core.deref(input_checker41587_42213);
var G__41595_42222 = args__38024__auto___42217;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41591_42218,G__41592_42219,G__41593_42220,G__41594_42221,G__41595_42222) : schema.core.fn_validator.call(null,G__41591_42218,G__41592_42219,G__41593_42220,G__41594_42221,G__41595_42222));
} else {
var temp__5804__auto___42223 = (function (){var fexpr__41596 = cljs.core.deref(input_checker41587_42213);
return (fexpr__41596.cljs$core$IFn$_invoke$arity$1 ? fexpr__41596.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42217) : fexpr__41596.call(null,args__38024__auto___42217));
})();
if(cljs.core.truth_(temp__5804__auto___42223)){
var error__38025__auto___42224 = temp__5804__auto___42223;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42224], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41586_42212,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42217,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42224], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41589;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["a","b","c","d","c","e","f","g","h","i","j","k","l","m","n","o"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41597_42225 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41598_42226 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41599_42227 = output_schema41585_42211;
var G__41600_42228 = cljs.core.deref(output_checker41588_42214);
var G__41601_42229 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41597_42225,G__41598_42226,G__41599_42227,G__41600_42228,G__41601_42229) : schema.core.fn_validator.call(null,G__41597_42225,G__41598_42226,G__41599_42227,G__41600_42228,G__41601_42229));
} else {
var temp__5804__auto___42230 = (function (){var fexpr__41602 = cljs.core.deref(output_checker41588_42214);
return (fexpr__41602.cljs$core$IFn$_invoke$arity$1 ? fexpr__41602.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41602.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42230)){
var error__38025__auto___42231 = temp__5804__auto___42230;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42231], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41585_42211,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42231], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b16_alpha_str),schema.core.__GT_FnSchema(output_schema41585_42211,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41586_42212], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42232 = schema.utils.use_fn_validation;
var output_schema41605_42233 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41606_42234 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41607_42235 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41606_42234);
}),null));
var output_checker41608_42236 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41605_42233);
}),null));
var ret__40629__auto___42238 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41609){
var validate__38023__auto__ = cljs.core.deref(ufv___42232);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42239 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41609], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41610_42240 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41611_42241 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41612_42242 = input_schema41606_42234;
var G__41613_42243 = cljs.core.deref(input_checker41607_42235);
var G__41614_42244 = args__38024__auto___42239;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41610_42240,G__41611_42241,G__41612_42242,G__41613_42243,G__41614_42244) : schema.core.fn_validator.call(null,G__41610_42240,G__41611_42241,G__41612_42242,G__41613_42243,G__41614_42244));
} else {
var temp__5804__auto___42246 = (function (){var fexpr__41615 = cljs.core.deref(input_checker41607_42235);
return (fexpr__41615.cljs$core$IFn$_invoke$arity$1 ? fexpr__41615.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42239) : fexpr__41615.call(null,args__38024__auto___42239));
})();
if(cljs.core.truth_(temp__5804__auto___42246)){
var error__38025__auto___42249 = temp__5804__auto___42246;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42249], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41606_42234,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42239,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42249], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var s = G__41609;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5636__auto___42253 = ba_len;
var i_42254 = (0);
while(true){
if((i_42254 < n__5636__auto___42253)){
var j_42255 = ((2) * i_42254);
(ba[i_42254] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42255)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42255 + (1))))));

var G__42256 = (i_42254 + (1));
i_42254 = G__42256;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41617_42258 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41618_42259 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41619_42260 = output_schema41605_42233;
var G__41620_42261 = cljs.core.deref(output_checker41608_42236);
var G__41621_42262 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41617_42258,G__41618_42259,G__41619_42260,G__41620_42261,G__41621_42262) : schema.core.fn_validator.call(null,G__41617_42258,G__41618_42259,G__41619_42260,G__41620_42261,G__41621_42262));
} else {
var temp__5804__auto___42265 = (function (){var fexpr__41622 = cljs.core.deref(output_checker41608_42236);
return (fexpr__41622.cljs$core$IFn$_invoke$arity$1 ? fexpr__41622.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41622.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42265)){
var error__38025__auto___42266 = temp__5804__auto___42265;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42266], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41605_42233,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42266], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41605_42233,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41606_42234], null)));

var ufv___42267 = schema.utils.use_fn_validation;
var output_schema41623_42268 = deercreeklabs.baracus.ByteArray;
var input_schema41624_42269 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41625_42270 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41624_42269);
}),null));
var output_checker41626_42271 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41623_42268);
}),null));
var ret__40629__auto___42272 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41627){
var validate__38023__auto__ = cljs.core.deref(ufv___42267);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42273 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41627], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41631_42274 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41632_42275 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41633_42276 = input_schema41624_42269;
var G__41634_42277 = cljs.core.deref(input_checker41625_42270);
var G__41635_42278 = args__38024__auto___42273;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41631_42274,G__41632_42275,G__41633_42276,G__41634_42277,G__41635_42278) : schema.core.fn_validator.call(null,G__41631_42274,G__41632_42275,G__41633_42276,G__41634_42277,G__41635_42278));
} else {
var temp__5804__auto___42281 = (function (){var fexpr__41636 = cljs.core.deref(input_checker41625_42270);
return (fexpr__41636.cljs$core$IFn$_invoke$arity$1 ? fexpr__41636.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42273) : fexpr__41636.call(null,args__38024__auto___42273));
})();
if(cljs.core.truth_(temp__5804__auto___42281)){
var error__38025__auto___42282 = temp__5804__auto___42281;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42282], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41624_42269,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42273,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42282], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41627;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41637_42287 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41638_42288 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41639_42289 = output_schema41623_42268;
var G__41640_42290 = cljs.core.deref(output_checker41626_42271);
var G__41641_42291 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41637_42287,G__41638_42288,G__41639_42289,G__41640_42290,G__41641_42291) : schema.core.fn_validator.call(null,G__41637_42287,G__41638_42288,G__41639_42289,G__41640_42290,G__41641_42291));
} else {
var temp__5804__auto___42293 = (function (){var fexpr__41643 = cljs.core.deref(output_checker41626_42271);
return (fexpr__41643.cljs$core$IFn$_invoke$arity$1 ? fexpr__41643.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41643.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42293)){
var error__38025__auto___42295 = temp__5804__auto___42293;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42295], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41623_42268,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42295], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41623_42268,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41624_42269], null)));

var ufv___42296 = schema.utils.use_fn_validation;
var output_schema41644_42297 = deercreeklabs.baracus.ByteArray;
var input_schema41645_42298 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41646_42299 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41645_42298);
}),null));
var output_checker41647_42300 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41644_42297);
}),null));
var ret__40629__auto___42301 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41648){
var validate__38023__auto__ = cljs.core.deref(ufv___42296);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42302 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41648], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41649_42303 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41650_42304 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41651_42305 = input_schema41645_42298;
var G__41652_42306 = cljs.core.deref(input_checker41646_42299);
var G__41653_42307 = args__38024__auto___42302;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41649_42303,G__41650_42304,G__41651_42305,G__41652_42306,G__41653_42307) : schema.core.fn_validator.call(null,G__41649_42303,G__41650_42304,G__41651_42305,G__41652_42306,G__41653_42307));
} else {
var temp__5804__auto___42308 = (function (){var fexpr__41654 = cljs.core.deref(input_checker41646_42299);
return (fexpr__41654.cljs$core$IFn$_invoke$arity$1 ? fexpr__41654.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42302) : fexpr__41654.call(null,args__38024__auto___42302));
})();
if(cljs.core.truth_(temp__5804__auto___42308)){
var error__38025__auto___42309 = temp__5804__auto___42308;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42309], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41645_42298,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42302,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42309], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41648;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41656_42314 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41657_42315 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41658_42316 = output_schema41644_42297;
var G__41659_42317 = cljs.core.deref(output_checker41647_42300);
var G__41660_42318 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41656_42314,G__41657_42315,G__41658_42316,G__41659_42317,G__41660_42318) : schema.core.fn_validator.call(null,G__41656_42314,G__41657_42315,G__41658_42316,G__41659_42317,G__41660_42318));
} else {
var temp__5804__auto___42319 = (function (){var fexpr__41661 = cljs.core.deref(output_checker41647_42300);
return (fexpr__41661.cljs$core$IFn$_invoke$arity$1 ? fexpr__41661.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41661.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42319)){
var error__38025__auto___42320 = temp__5804__auto___42319;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42320], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41644_42297,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42320], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41644_42297,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41645_42298], null)));

var ufv___42324 = schema.utils.use_fn_validation;
var output_schema41662_42325 = deercreeklabs.baracus.ByteArray;
var input_schema41663_42326 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41664_42327 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41663_42326);
}),null));
var output_checker41665_42328 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41662_42325);
}),null));
var ret__40629__auto___42331 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41666){
var validate__38023__auto__ = cljs.core.deref(ufv___42324);
if(cljs.core.truth_(validate__38023__auto__)){
var args__38024__auto___42335 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41666], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41667_42337 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41668_42338 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41669_42339 = input_schema41663_42326;
var G__41670_42340 = cljs.core.deref(input_checker41664_42327);
var G__41671_42341 = args__38024__auto___42335;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41667_42337,G__41668_42338,G__41669_42339,G__41670_42340,G__41671_42341) : schema.core.fn_validator.call(null,G__41667_42337,G__41668_42338,G__41669_42339,G__41670_42340,G__41671_42341));
} else {
var temp__5804__auto___42343 = (function (){var fexpr__41672 = cljs.core.deref(input_checker41664_42327);
return (fexpr__41672.cljs$core$IFn$_invoke$arity$1 ? fexpr__41672.cljs$core$IFn$_invoke$arity$1(args__38024__auto___42335) : fexpr__41672.call(null,args__38024__auto___42335));
})();
if(cljs.core.truth_(temp__5804__auto___42343)){
var error__38025__auto___42344 = temp__5804__auto___42343;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42344], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41663_42326,new cljs.core.Keyword(null,"value","value",305978217),args__38024__auto___42335,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42344], null));
} else {
}
}
} else {
}

var o__38026__auto__ = (function (){var ba = G__41666;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update(ba);

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__38023__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41674_42350 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41675_42351 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41676_42352 = output_schema41662_42325;
var G__41677_42353 = cljs.core.deref(output_checker41665_42328);
var G__41678_42354 = o__38026__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41674_42350,G__41675_42351,G__41676_42352,G__41677_42353,G__41678_42354) : schema.core.fn_validator.call(null,G__41674_42350,G__41675_42351,G__41676_42352,G__41677_42353,G__41678_42354));
} else {
var temp__5804__auto___42362 = (function (){var fexpr__41679 = cljs.core.deref(output_checker41665_42328);
return (fexpr__41679.cljs$core$IFn$_invoke$arity$1 ? fexpr__41679.cljs$core$IFn$_invoke$arity$1(o__38026__auto__) : fexpr__41679.call(null,o__38026__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42362)){
var error__38025__auto___42364 = temp__5804__auto___42362;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__38025__auto___42364], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41662_42325,new cljs.core.Keyword(null,"value","value",305978217),o__38026__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__38025__auto___42364], null));
} else {
}
}
} else {
}

return o__38026__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41662_42325,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41663_42326], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
