goog.provide('deercreeklabs.baracus');
deercreeklabs.baracus.Nil = schema.core.eq(null);
deercreeklabs.baracus.ByteArray = Int8Array;
var ufv___41500 = schema.utils.use_fn_validation;
var output_schema41010_41501 = schema.core.Bool;
var input_schema41011_41502 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"arg","arg",-106730310,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_checker41012_41503 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41011_41502);
}),null));
var output_checker41013_41504 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41010_41501);
}),null));
var ret__40100__auto___41506 = /**
 * Inputs: [arg :- s/Any]
 *   Returns: s/Bool
 * 
 *   Tests if the argument is a byte array
 */
deercreeklabs.baracus.byte_array_QMARK_ = (function deercreeklabs$baracus$byte_array_QMARK_(G__41014){
var validate__37763__auto__ = cljs.core.deref(ufv___41500);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41507 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41014], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41017_41508 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41018_41509 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41019_41510 = input_schema41011_41502;
var G__41020_41511 = cljs.core.deref(input_checker41012_41503);
var G__41021_41512 = args__37764__auto___41507;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41017_41508,G__41018_41509,G__41019_41510,G__41020_41511,G__41021_41512) : schema.core.fn_validator.call(null,G__41017_41508,G__41018_41509,G__41019_41510,G__41020_41511,G__41021_41512));
} else {
var temp__5804__auto___41513 = (function (){var fexpr__41024 = cljs.core.deref(input_checker41012_41503);
return (fexpr__41024.cljs$core$IFn$_invoke$arity$1 ? fexpr__41024.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41507) : fexpr__41024.call(null,args__37764__auto___41507));
})();
if(cljs.core.truth_(temp__5804__auto___41513)){
var error__37765__auto___41514 = temp__5804__auto___41513;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41514], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41011_41502,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41507,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41514], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var arg = G__41014;
while(true){
if((arg == null)){
return null;
} else {
return cljs.core.boolean$(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deercreeklabs.baracus.ByteArray,cljs.core.type(arg)));
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41025_41515 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41026_41516 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null));
var G__41027_41517 = output_schema41010_41501;
var G__41028_41518 = cljs.core.deref(output_checker41013_41504);
var G__41029_41519 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41025_41515,G__41026_41516,G__41027_41517,G__41028_41518,G__41029_41519) : schema.core.fn_validator.call(null,G__41025_41515,G__41026_41516,G__41027_41517,G__41028_41518,G__41029_41519));
} else {
var temp__5804__auto___41521 = (function (){var fexpr__41030 = cljs.core.deref(output_checker41013_41504);
return (fexpr__41030.cljs$core$IFn$_invoke$arity$1 ? fexpr__41030.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41030.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41521)){
var error__37765__auto___41522 = temp__5804__auto___41521;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array?","byte-array?",-2062038781,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Tests if the argument is a byte array"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41522], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41010_41501,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41522], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array_QMARK_),schema.core.__GT_FnSchema(output_schema41010_41501,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41011_41502], null)));

var ufv___41523 = schema.utils.use_fn_validation;
var output_schema41031_41524 = deercreeklabs.baracus.ByteArray;
var input_schema41032_41525 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"size-or-seq","size-or-seq",-2062823589,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null)))], null);
var input_schema41036_41526 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null))),schema.core.one(schema.core.if$(cljs.core.sequential_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.Any], null),schema.core.Any),cljs.core.with_meta(new cljs.core.Symbol(null,"init-val-or-seq","init-val-or-seq",-1168783320,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","if","s/if",1181719683,null),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("s","Any","s/Any",1277490110,null)], null),new cljs.core.Symbol("s","Any","s/Any",1277490110,null))], null)))], null);
var input_checker41033_41527 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41032_41525);
}),null));
var output_checker41034_41528 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41031_41524);
}),null));
var input_checker41037_41529 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41036_41526);
}),null));
var output_checker41038_41530 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41031_41524);
}),null));
var ret__40100__auto___41532 = (function (){
/**
 * Inputs: ([size-or-seq :- s/Any] [size :- s/Int init-val-or-seq :- (s/if sequential? [s/Any] s/Any)])
 *   Returns: ByteArray
 * 
 *   Construct a byte array.
 * Args:
 *   - size-or-seq: An integer size or sequence of bytes.
 */
deercreeklabs.baracus.byte_array = (function deercreeklabs$baracus$byte_array(var_args){
var G__41045 = arguments.length;
switch (G__41045) {
case 1:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41035){
var validate__37763__auto__ = cljs.core.deref(ufv___41523);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41534 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41035], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41046_41535 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41047_41536 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41048_41537 = input_schema41032_41525;
var G__41049_41538 = cljs.core.deref(input_checker41033_41527);
var G__41050_41539 = args__37764__auto___41534;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41046_41535,G__41047_41536,G__41048_41537,G__41049_41538,G__41050_41539) : schema.core.fn_validator.call(null,G__41046_41535,G__41047_41536,G__41048_41537,G__41049_41538,G__41050_41539));
} else {
var temp__5804__auto___41540 = (function (){var fexpr__41052 = cljs.core.deref(input_checker41033_41527);
return (fexpr__41052.cljs$core$IFn$_invoke$arity$1 ? fexpr__41052.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41534) : fexpr__41052.call(null,args__37764__auto___41534));
})();
if(cljs.core.truth_(temp__5804__auto___41540)){
var error__37765__auto___41541 = temp__5804__auto___41540;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41541], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41032_41525,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41534,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41541], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var size_or_seq = G__41035;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$1(size_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41053_41542 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41054_41543 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41055_41544 = output_schema41031_41524;
var G__41056_41545 = cljs.core.deref(output_checker41034_41528);
var G__41057_41546 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41053_41542,G__41054_41543,G__41055_41544,G__41056_41545,G__41057_41546) : schema.core.fn_validator.call(null,G__41053_41542,G__41054_41543,G__41055_41544,G__41056_41545,G__41057_41546));
} else {
var temp__5804__auto___41548 = (function (){var fexpr__41058 = cljs.core.deref(output_checker41034_41528);
return (fexpr__41058.cljs$core$IFn$_invoke$arity$1 ? fexpr__41058.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41058.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41548)){
var error__37765__auto___41549 = temp__5804__auto___41548;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41549], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41031_41524,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41549], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41039,G__41040){
var validate__37763__auto__ = cljs.core.deref(ufv___41523);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41550 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41039,G__41040], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41060_41551 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41061_41552 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41062_41553 = input_schema41036_41526;
var G__41063_41554 = cljs.core.deref(input_checker41037_41529);
var G__41064_41555 = args__37764__auto___41550;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41060_41551,G__41061_41552,G__41062_41553,G__41063_41554,G__41064_41555) : schema.core.fn_validator.call(null,G__41060_41551,G__41061_41552,G__41062_41553,G__41063_41554,G__41064_41555));
} else {
var temp__5804__auto___41556 = (function (){var fexpr__41065 = cljs.core.deref(input_checker41037_41529);
return (fexpr__41065.cljs$core$IFn$_invoke$arity$1 ? fexpr__41065.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41550) : fexpr__41065.call(null,args__37764__auto___41550));
})();
if(cljs.core.truth_(temp__5804__auto___41556)){
var error__37765__auto___41557 = temp__5804__auto___41556;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41557], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41036_41526,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41550,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41557], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var size = G__41039;
var init_val_or_seq = G__41040;
while(true){
return deercreeklabs.baracus.cljs_utils.byte_array_cljs.cljs$core$IFn$_invoke$arity$2(size,init_val_or_seq);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41066_41558 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41067_41559 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null));
var G__41068_41560 = output_schema41031_41524;
var G__41069_41561 = cljs.core.deref(output_checker41038_41530);
var G__41070_41562 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41066_41558,G__41067_41559,G__41068_41560,G__41069_41561,G__41070_41562) : schema.core.fn_validator.call(null,G__41066_41558,G__41067_41559,G__41068_41560,G__41069_41561,G__41070_41562));
} else {
var temp__5804__auto___41563 = (function (){var fexpr__41071 = cljs.core.deref(output_checker41038_41530);
return (fexpr__41071.cljs$core$IFn$_invoke$arity$1 ? fexpr__41071.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41071.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41563)){
var error__37765__auto___41564 = temp__5804__auto___41563;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array","byte-array",2009690064,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Construct a byte array.\n   Args:\n     - size-or-seq: An integer size or sequence of bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41564], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41031_41524,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41564], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.baracus.byte_array.cljs$lang$maxFixedArity = 2);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array),schema.core.make_fn_schema(output_schema41031_41524,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41032_41525,input_schema41036_41526], null)));

var ufv___41566 = schema.utils.use_fn_validation;
var output_schema41073_41567 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41074_41568 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.maybe(deercreeklabs.baracus.ByteArray)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arrays","arrays",-1540989271,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))], null)))], null);
var input_checker41075_41569 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41074_41568);
}),null));
var output_checker41076_41570 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41073_41567);
}),null));
var ret__40100__auto___41571 = /**
 * Inputs: [arrays :- (s/maybe [(s/maybe ByteArray)])]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Concatenate a sequence of byte arrays
 */
deercreeklabs.baracus.concat_byte_arrays = (function deercreeklabs$baracus$concat_byte_arrays(G__41077){
var validate__37763__auto__ = cljs.core.deref(ufv___41566);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41572 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41077], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41078_41573 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41079_41574 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41080_41575 = input_schema41074_41568;
var G__41081_41576 = cljs.core.deref(input_checker41075_41569);
var G__41082_41577 = args__37764__auto___41572;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41078_41573,G__41079_41574,G__41080_41575,G__41081_41576,G__41082_41577) : schema.core.fn_validator.call(null,G__41078_41573,G__41079_41574,G__41080_41575,G__41081_41576,G__41082_41577));
} else {
var temp__5804__auto___41578 = (function (){var fexpr__41084 = cljs.core.deref(input_checker41075_41569);
return (fexpr__41084.cljs$core$IFn$_invoke$arity$1 ? fexpr__41084.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41572) : fexpr__41084.call(null,args__37764__auto___41572));
})();
if(cljs.core.truth_(temp__5804__auto___41578)){
var error__37765__auto___41579 = temp__5804__auto___41578;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41579], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41074_41568,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41572,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41579], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var arrays = G__41077;
while(true){
if(cljs.core.truth_(arrays)){
var arrays__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,arrays);
var G__41086 = cljs.core.count(arrays__$1);
switch (G__41086) {
case (0):
return null;

break;
case (1):
return cljs.core.first(arrays__$1);

break;
default:
var len = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41086,arrays__$1,validate__37763__auto__,ufv___41566,output_schema41073_41567,input_schema41074_41568,input_checker41075_41569,output_checker41076_41570){
return (function (acc,ba){
return (acc + cljs.core.count(ba));
});})(G__41086,arrays__$1,validate__37763__auto__,ufv___41566,output_schema41073_41567,input_schema41074_41568,input_checker41075_41569,output_checker41076_41570))
,(0),arrays__$1);
var new_ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(len);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (len,new_ba,G__41086,arrays__$1,validate__37763__auto__,ufv___41566,output_schema41073_41567,input_schema41074_41568,input_checker41075_41569,output_checker41076_41570){
return (function (pos,ba){
new_ba.set(ba,pos);

return (pos + cljs.core.count(ba));
});})(len,new_ba,G__41086,arrays__$1,validate__37763__auto__,ufv___41566,output_schema41073_41567,input_schema41074_41568,input_checker41075_41569,output_checker41076_41570))
,(0),arrays__$1);

return new_ba;

}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41087_41587 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41088_41588 = cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null));
var G__41089_41589 = output_schema41073_41567;
var G__41090_41590 = cljs.core.deref(output_checker41076_41570);
var G__41091_41591 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41087_41587,G__41088_41588,G__41089_41589,G__41090_41590,G__41091_41591) : schema.core.fn_validator.call(null,G__41087_41587,G__41088_41588,G__41089_41589,G__41090_41590,G__41091_41591));
} else {
var temp__5804__auto___41593 = (function (){var fexpr__41092 = cljs.core.deref(output_checker41076_41570);
return (fexpr__41092.cljs$core$IFn$_invoke$arity$1 ? fexpr__41092.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41092.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41593)){
var error__37765__auto___41594 = temp__5804__auto___41593;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"concat-byte-arrays","concat-byte-arrays",80595656,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenate a sequence of byte arrays"], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41594], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41073_41567,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41594], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.concat_byte_arrays),schema.core.__GT_FnSchema(output_schema41073_41567,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41074_41568], null)));

var ufv___41595 = schema.utils.use_fn_validation;
var output_schema41094_41596 = schema.core.Bool;
var input_schema41095_41597 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))),schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41096_41598 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41095_41597);
}),null));
var output_checker41097_41599 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41094_41596);
}),null));
var ret__40100__auto___41600 = /**
 * Inputs: [a :- ByteArray b :- ByteArray]
 *   Returns: s/Bool
 * 
 *   Test if two byte arrays are equivalent. Normal Clojure = on byte arrays
 * checks identity, not equality. Note that this is an O(n) operation.
 */
deercreeklabs.baracus.equivalent_byte_arrays_QMARK_ = (function deercreeklabs$baracus$equivalent_byte_arrays_QMARK_(G__41098,G__41099){
var validate__37763__auto__ = cljs.core.deref(ufv___41595);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41601 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41098,G__41099], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41102_41602 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41103_41603 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41104_41604 = input_schema41095_41597;
var G__41105_41605 = cljs.core.deref(input_checker41096_41598);
var G__41106_41606 = args__37764__auto___41601;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41102_41602,G__41103_41603,G__41104_41604,G__41105_41605,G__41106_41606) : schema.core.fn_validator.call(null,G__41102_41602,G__41103_41603,G__41104_41604,G__41105_41605,G__41106_41606));
} else {
var temp__5804__auto___41609 = (function (){var fexpr__41108 = cljs.core.deref(input_checker41096_41598);
return (fexpr__41108.cljs$core$IFn$_invoke$arity$1 ? fexpr__41108.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41601) : fexpr__41108.call(null,args__37764__auto___41601));
})();
if(cljs.core.truth_(temp__5804__auto___41609)){
var error__37765__auto___41612 = temp__5804__auto___41609;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41612], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41095_41597,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41601,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41612], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var a = G__41098;
var b = G__41099;
while(true){
var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b));
if(and__5043__auto__){
var num = cljs.core.count(a);
var i = (0);
while(true){
if((i >= num)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((a[i]),(b[i]))){
var G__41616 = ((i + (1)) | (0));
i = G__41616;
continue;
} else {
return false;
}
}
break;
}
} else {
return and__5043__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41110_41617 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41111_41618 = cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null));
var G__41112_41619 = output_schema41094_41596;
var G__41113_41620 = cljs.core.deref(output_checker41097_41599);
var G__41114_41621 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41110_41617,G__41111_41618,G__41112_41619,G__41113_41620,G__41114_41621) : schema.core.fn_validator.call(null,G__41110_41617,G__41111_41618,G__41112_41619,G__41113_41620,G__41114_41621));
} else {
var temp__5804__auto___41622 = (function (){var fexpr__41115 = cljs.core.deref(output_checker41097_41599);
return (fexpr__41115.cljs$core$IFn$_invoke$arity$1 ? fexpr__41115.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41115.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41622)){
var error__37765__auto___41623 = temp__5804__auto___41622;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"equivalent-byte-arrays?","equivalent-byte-arrays?",560262726,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Bool","s/Bool",195910545,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Test if two byte arrays are equivalent. Normal Clojure = on byte arrays\n   checks identity, not equality. Note that this is an O(n) operation."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41623], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41094_41596,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41623], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.equivalent_byte_arrays_QMARK_),schema.core.__GT_FnSchema(output_schema41094_41596,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41095_41597], null)));

var ufv___41628 = schema.utils.use_fn_validation;
var output_schema41116_41629 = schema.core.Str;
var input_schema41117_41630 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41118_41631 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41117_41630);
}),null));
var output_checker41119_41632 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41116_41629);
}),null));
var ret__40100__auto___41633 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: s/Str
 */
deercreeklabs.baracus.byte_array__GT_debug_str = (function deercreeklabs$baracus$byte_array__GT_debug_str(G__41120){
var validate__37763__auto__ = cljs.core.deref(ufv___41628);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41634 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41120], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41122_41635 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41123_41636 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41124_41637 = input_schema41117_41630;
var G__41125_41638 = cljs.core.deref(input_checker41118_41631);
var G__41126_41639 = args__37764__auto___41634;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41122_41635,G__41123_41636,G__41124_41637,G__41125_41638,G__41126_41639) : schema.core.fn_validator.call(null,G__41122_41635,G__41123_41636,G__41124_41637,G__41125_41638,G__41126_41639));
} else {
var temp__5804__auto___41640 = (function (){var fexpr__41127 = cljs.core.deref(input_checker41118_41631);
return (fexpr__41127.cljs$core$IFn$_invoke$arity$1 ? fexpr__41127.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41634) : fexpr__41127.call(null,args__37764__auto___41634));
})();
if(cljs.core.truth_(temp__5804__auto___41640)){
var error__37765__auto___41641 = temp__5804__auto___41640;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41641], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41117_41630,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41634,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41641], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41120;
while(true){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ba);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41128_41643 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41129_41644 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null));
var G__41130_41645 = output_schema41116_41629;
var G__41131_41647 = cljs.core.deref(output_checker41119_41632);
var G__41132_41648 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41128_41643,G__41129_41644,G__41130_41645,G__41131_41647,G__41132_41648) : schema.core.fn_validator.call(null,G__41128_41643,G__41129_41644,G__41130_41645,G__41131_41647,G__41132_41648));
} else {
var temp__5804__auto___41650 = (function (){var fexpr__41133 = cljs.core.deref(output_checker41119_41632);
return (fexpr__41133.cljs$core$IFn$_invoke$arity$1 ? fexpr__41133.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41133.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41650)){
var error__37765__auto___41651 = temp__5804__auto___41650;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->debug-str","byte-array->debug-str",1201688612,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Str","s/Str",907974338,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41651], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41116_41629,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41651], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_debug_str),schema.core.__GT_FnSchema(output_schema41116_41629,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41117_41630], null)));

var ufv___41653 = schema.utils.use_fn_validation;
var output_schema41135_41654 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41136_41655 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_schema41140_41656 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_schema41145_41657 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null))),schema.core.one(schema.core.Num,cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Num","s/Num",-2044935073,null)], null)))], null);
var input_checker41137_41658 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41136_41655);
}),null));
var output_checker41138_41659 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41135_41654);
}),null));
var input_checker41141_41660 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41140_41656);
}),null));
var output_checker41142_41661 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41135_41654);
}),null));
var input_checker41146_41662 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41145_41657);
}),null));
var output_checker41147_41663 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41135_41654);
}),null));
var ret__40100__auto___41669 = (function (){
/**
 * Inputs: ([ba :- (s/maybe ByteArray)] [ba :- (s/maybe ByteArray) start :- s/Num] [ba :- (s/maybe ByteArray) start :- s/Num end :- s/Num])
 *   Returns: (s/maybe ByteArray)
 * 
 *   Return a slice of the given byte array.
 * Args:
 *      - ba - Byte array to be sliced. Required.
 *      - start - Start index. Optional. Defaults to 0.
 *      - end - End index. Optional. If not provided, the slice will extend
 *           to the end of the array. The returned slice will not contain
 *           the byte at the end index position, i.e.: the slice fn uses
 *           a half-open interval.
 */
deercreeklabs.baracus.slice_byte_array = (function deercreeklabs$baracus$slice_byte_array(var_args){
var G__41154 = arguments.length;
switch (G__41154) {
case 1:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1 = (function (G__41139){
var validate__37763__auto__ = cljs.core.deref(ufv___41653);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41673 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41139], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41155_41675 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41156_41676 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41157_41677 = input_schema41136_41655;
var G__41158_41678 = cljs.core.deref(input_checker41137_41658);
var G__41159_41679 = args__37764__auto___41673;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41155_41675,G__41156_41676,G__41157_41677,G__41158_41678,G__41159_41679) : schema.core.fn_validator.call(null,G__41155_41675,G__41156_41676,G__41157_41677,G__41158_41678,G__41159_41679));
} else {
var temp__5804__auto___41680 = (function (){var fexpr__41160 = cljs.core.deref(input_checker41137_41658);
return (fexpr__41160.cljs$core$IFn$_invoke$arity$1 ? fexpr__41160.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41673) : fexpr__41160.call(null,args__37764__auto___41673));
})();
if(cljs.core.truth_(temp__5804__auto___41680)){
var error__37765__auto___41683 = temp__5804__auto___41680;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41683], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41136_41655,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41673,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41683], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41139;
while(true){
if(cljs.core.truth_(ba)){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,(0),cljs.core.count(ba));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41161_41689 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41162_41690 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41163_41691 = output_schema41135_41654;
var G__41164_41692 = cljs.core.deref(output_checker41138_41659);
var G__41165_41693 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41161_41689,G__41162_41690,G__41163_41691,G__41164_41692,G__41165_41693) : schema.core.fn_validator.call(null,G__41161_41689,G__41162_41690,G__41163_41691,G__41164_41692,G__41165_41693));
} else {
var temp__5804__auto___41695 = (function (){var fexpr__41166 = cljs.core.deref(output_checker41138_41659);
return (fexpr__41166.cljs$core$IFn$_invoke$arity$1 ? fexpr__41166.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41166.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41695)){
var error__37765__auto___41696 = temp__5804__auto___41695;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41696], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41135_41654,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41696], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2 = (function (G__41143,G__41144){
var validate__37763__auto__ = cljs.core.deref(ufv___41653);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41701 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41143,G__41144], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41167_41703 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41168_41704 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41169_41705 = input_schema41140_41656;
var G__41170_41706 = cljs.core.deref(input_checker41141_41660);
var G__41171_41707 = args__37764__auto___41701;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41167_41703,G__41168_41704,G__41169_41705,G__41170_41706,G__41171_41707) : schema.core.fn_validator.call(null,G__41167_41703,G__41168_41704,G__41169_41705,G__41170_41706,G__41171_41707));
} else {
var temp__5804__auto___41708 = (function (){var fexpr__41172 = cljs.core.deref(input_checker41141_41660);
return (fexpr__41172.cljs$core$IFn$_invoke$arity$1 ? fexpr__41172.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41701) : fexpr__41172.call(null,args__37764__auto___41701));
})();
if(cljs.core.truth_(temp__5804__auto___41708)){
var error__37765__auto___41710 = temp__5804__auto___41708;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41710], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41140_41656,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41701,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41710], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41143;
var start = G__41144;
while(true){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,start,cljs.core.count(ba));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41174_41713 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41175_41714 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41176_41715 = output_schema41135_41654;
var G__41177_41716 = cljs.core.deref(output_checker41142_41661);
var G__41178_41717 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41174_41713,G__41175_41714,G__41176_41715,G__41177_41716,G__41178_41717) : schema.core.fn_validator.call(null,G__41174_41713,G__41175_41714,G__41176_41715,G__41177_41716,G__41178_41717));
} else {
var temp__5804__auto___41722 = (function (){var fexpr__41179 = cljs.core.deref(output_checker41142_41661);
return (fexpr__41179.cljs$core$IFn$_invoke$arity$1 ? fexpr__41179.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41179.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41722)){
var error__37765__auto___41723 = temp__5804__auto___41722;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41723], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41135_41654,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41723], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3 = (function (G__41148,G__41149,G__41150){
var validate__37763__auto__ = cljs.core.deref(ufv___41653);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41726 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41148,G__41149,G__41150], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41180_41727 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41181_41728 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41182_41729 = input_schema41145_41657;
var G__41183_41730 = cljs.core.deref(input_checker41146_41662);
var G__41184_41731 = args__37764__auto___41726;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41180_41727,G__41181_41728,G__41182_41729,G__41183_41730,G__41184_41731) : schema.core.fn_validator.call(null,G__41180_41727,G__41181_41728,G__41182_41729,G__41183_41730,G__41184_41731));
} else {
var temp__5804__auto___41733 = (function (){var fexpr__41185 = cljs.core.deref(input_checker41146_41662);
return (fexpr__41185.cljs$core$IFn$_invoke$arity$1 ? fexpr__41185.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41726) : fexpr__41185.call(null,args__37764__auto___41726));
})();
if(cljs.core.truth_(temp__5804__auto___41733)){
var error__37765__auto___41736 = temp__5804__auto___41733;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41736], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41145_41657,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41726,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41736], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41148;
var start = G__41149;
var end = G__41150;
while(true){
if((start > end)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Slice start is greater than end.",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"slice-start-is-greater-than-end","slice-start-is-greater-than-end",-447187267),new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
}

var stop = (function (){var x__5133__auto__ = end;
var y__5134__auto__ = cljs.core.count(ba);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})();
return ba.slice(start,stop);
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41187_41741 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41188_41742 = cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null));
var G__41189_41743 = output_schema41135_41654;
var G__41190_41744 = cljs.core.deref(output_checker41147_41663);
var G__41191_41745 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41187_41741,G__41188_41742,G__41189_41743,G__41190_41744,G__41191_41745) : schema.core.fn_validator.call(null,G__41187_41741,G__41188_41742,G__41189_41743,G__41190_41744,G__41191_41745));
} else {
var temp__5804__auto___41747 = (function (){var fexpr__41192 = cljs.core.deref(output_checker41147_41663);
return (fexpr__41192.cljs$core$IFn$_invoke$arity$1 ? fexpr__41192.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41192.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41747)){
var error__37765__auto___41748 = temp__5804__auto___41747;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"slice-byte-array","slice-byte-array",201283992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return a slice of the given byte array.\n   Args:\n        - ba - Byte array to be sliced. Required.\n        - start - Start index. Optional. Defaults to 0.\n        - end - End index. Optional. If not provided, the slice will extend\n             to the end of the array. The returned slice will not contain\n             the byte at the end index position, i.e.: the slice fn uses\n             a half-open interval."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41748], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41135_41654,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41748], null));
} else {
}
}
} else {
}

return o__37766__auto__;
}));

(deercreeklabs.baracus.slice_byte_array.cljs$lang$maxFixedArity = 3);

return null;
})()
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.slice_byte_array),schema.core.make_fn_schema(output_schema41135_41654,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41136_41655,input_schema41140_41656,input_schema41145_41657], null)));

var ufv___41754 = schema.utils.use_fn_validation;
var output_schema41193_41755 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41194_41756 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41195_41757 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41194_41756);
}),null));
var output_checker41196_41758 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41193_41755);
}),null));
var ret__40100__auto___41760 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe ByteArray)
 * 
 *   Returns a new byte array with bytes reversed.
 */
deercreeklabs.baracus.reverse_byte_array = (function deercreeklabs$baracus$reverse_byte_array(G__41197){
var validate__37763__auto__ = cljs.core.deref(ufv___41754);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41762 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41197], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41199_41763 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41200_41764 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41201_41765 = input_schema41194_41756;
var G__41202_41766 = cljs.core.deref(input_checker41195_41757);
var G__41203_41767 = args__37764__auto___41762;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41199_41763,G__41200_41764,G__41201_41765,G__41202_41766,G__41203_41767) : schema.core.fn_validator.call(null,G__41199_41763,G__41200_41764,G__41201_41765,G__41202_41766,G__41203_41767));
} else {
var temp__5804__auto___41769 = (function (){var fexpr__41204 = cljs.core.deref(input_checker41195_41757);
return (fexpr__41204.cljs$core$IFn$_invoke$arity$1 ? fexpr__41204.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41762) : fexpr__41204.call(null,args__37764__auto___41762));
})();
if(cljs.core.truth_(temp__5804__auto___41769)){
var error__37765__auto___41770 = temp__5804__auto___41769;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41770], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41194_41756,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41762,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41770], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41197;
while(true){
if(cljs.core.truth_(ba)){
var num = cljs.core.count(ba);
var last = (num - (1));
var new$ = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(num);
var n__5636__auto___41775 = num;
var i_41776 = (0);
while(true){
if((i_41776 < n__5636__auto___41775)){
(new$[i_41776] = (ba[(last - i_41776)]));

var G__41778 = (i_41776 + (1));
i_41776 = G__41778;
continue;
} else {
}
break;
}

return new$;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41205_41779 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41206_41780 = cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null));
var G__41207_41781 = output_schema41193_41755;
var G__41208_41782 = cljs.core.deref(output_checker41196_41758);
var G__41209_41783 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41205_41779,G__41206_41780,G__41207_41781,G__41208_41782,G__41209_41783) : schema.core.fn_validator.call(null,G__41205_41779,G__41206_41780,G__41207_41781,G__41208_41782,G__41209_41783));
} else {
var temp__5804__auto___41786 = (function (){var fexpr__41211 = cljs.core.deref(output_checker41196_41758);
return (fexpr__41211.cljs$core$IFn$_invoke$arity$1 ? fexpr__41211.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41211.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41786)){
var error__37765__auto___41787 = temp__5804__auto___41786;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"reverse-byte-array","reverse-byte-array",-739404488,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a new byte array with bytes reversed."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41787], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41193_41755,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41787], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.reverse_byte_array),schema.core.__GT_FnSchema(output_schema41193_41755,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41194_41756], null)));

var ufv___41789 = schema.utils.use_fn_validation;
var output_schema41212_41790 = schema.core.maybe(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [deercreeklabs.baracus.ByteArray], null));
var input_schema41213_41791 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null))),schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"fragment-size","fragment-size",146643197,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41214_41792 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41213_41791);
}),null));
var output_checker41215_41793 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41212_41790);
}),null));
var ret__40100__auto___41794 = /**
 * Inputs: [ba :- (s/maybe ByteArray) fragment-size :- s/Int]
 *   Returns: (s/maybe [ByteArray])
 */
deercreeklabs.baracus.byte_array__GT_fragments = (function deercreeklabs$baracus$byte_array__GT_fragments(G__41216,G__41217){
var validate__37763__auto__ = cljs.core.deref(ufv___41789);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41795 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41216,G__41217], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41218_41796 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41219_41797 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41220_41798 = input_schema41213_41791;
var G__41221_41799 = cljs.core.deref(input_checker41214_41792);
var G__41222_41800 = args__37764__auto___41795;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41218_41796,G__41219_41797,G__41220_41798,G__41221_41799,G__41222_41800) : schema.core.fn_validator.call(null,G__41218_41796,G__41219_41797,G__41220_41798,G__41221_41799,G__41222_41800));
} else {
var temp__5804__auto___41801 = (function (){var fexpr__41224 = cljs.core.deref(input_checker41214_41792);
return (fexpr__41224.cljs$core$IFn$_invoke$arity$1 ? fexpr__41224.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41795) : fexpr__41224.call(null,args__37764__auto___41795));
})();
if(cljs.core.truth_(temp__5804__auto___41801)){
var error__37765__auto___41802 = temp__5804__auto___41801;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41802], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41213_41791,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41795,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41802], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41216;
var fragment_size = G__41217;
while(true){
if(cljs.core.truth_(ba)){
if((fragment_size === (0))){
return deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$1(ba);
} else {
var offset = (0);
var output = cljs.core.PersistentVector.EMPTY;
while(true){
if((offset >= cljs.core.count(ba))){
return output;
} else {
var end_offset = (offset + fragment_size);
var fragment = deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$3(ba,offset,end_offset);
var G__41807 = (end_offset | (0));
var G__41808 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(output,fragment);
offset = G__41807;
output = G__41808;
continue;
}
break;
}
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41225_41809 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41226_41810 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null));
var G__41227_41811 = output_schema41212_41790;
var G__41228_41812 = cljs.core.deref(output_checker41215_41793);
var G__41229_41813 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41225_41809,G__41226_41810,G__41227_41811,G__41228_41812,G__41229_41813) : schema.core.fn_validator.call(null,G__41225_41809,G__41226_41810,G__41227_41811,G__41228_41812,G__41229_41813));
} else {
var temp__5804__auto___41816 = (function (){var fexpr__41230 = cljs.core.deref(output_checker41215_41793);
return (fexpr__41230.cljs$core$IFn$_invoke$arity$1 ? fexpr__41230.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41230.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41816)){
var error__37765__auto___41818 = temp__5804__auto___41816;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->fragments","byte-array->fragments",1869874094,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41818], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41212_41790,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41818], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_fragments),schema.core.__GT_FnSchema(output_schema41212_41790,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41213_41791], null)));

var ufv___41820 = schema.utils.use_fn_validation;
var output_schema41233_41821 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,new cljs.core.Keyword(null,"int","int",-1741416922)),schema.core.optional(deercreeklabs.baracus.ByteArray,new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null);
var input_schema41234_41822 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41235_41823 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41234_41822);
}),null));
var output_checker41236_41824 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41233_41821);
}),null));
var ret__40100__auto___41825 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: [(s/one s/Int :int) (s/optional ByteArray :unread-remainder)]
 * 
 *   Takes an variable-length zig-zag encoded byte array and reads an integer
 * from it.
 * Returns a vector of the integer and, optionally, any unread bytes.
 */
deercreeklabs.baracus.decode_int = (function deercreeklabs$baracus$decode_int(G__41237){
var validate__37763__auto__ = cljs.core.deref(ufv___41820);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41826 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41237], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41241_41827 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41242_41828 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41243_41829 = input_schema41234_41822;
var G__41244_41830 = cljs.core.deref(input_checker41235_41823);
var G__41245_41831 = args__37764__auto___41826;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41241_41827,G__41242_41828,G__41243_41829,G__41244_41830,G__41245_41831) : schema.core.fn_validator.call(null,G__41241_41827,G__41242_41828,G__41243_41829,G__41244_41830,G__41245_41831));
} else {
var temp__5804__auto___41832 = (function (){var fexpr__41247 = cljs.core.deref(input_checker41235_41823);
return (fexpr__41247.cljs$core$IFn$_invoke$arity$1 ? fexpr__41247.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41826) : fexpr__41247.call(null,args__37764__auto___41826));
})();
if(cljs.core.truth_(temp__5804__auto___41832)){
var error__37765__auto___41835 = temp__5804__auto___41832;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41835], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41234_41822,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41826,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41835], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41237;
while(true){
var n = (0);
var i = (0);
var out = (0);
while(true){
var b = (ba[n]);
if(((b & (128)) === (0))){
var zz_n = ((b << i) | out);
var int_out = ((zz_n >>> (1)) ^ ((0) - (zz_n & (1))));
if(((n + (1)) < cljs.core.count(ba))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out,deercreeklabs.baracus.slice_byte_array.cljs$core$IFn$_invoke$arity$2(ba,(n + (1)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [int_out], null);
}
} else {
var out__$1 = (((b & (127)) << i) | out);
var i__$1 = ((7) + i);
if((i__$1 <= (31))){
var G__41842 = (n + (1));
var G__41843 = (i__$1 | (0));
var G__41844 = (out__$1 | (0));
n = G__41842;
i = G__41843;
out = G__41844;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Variable-length quantity is more than 32 bits",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"illegal-argument","illegal-argument",-1845493170),new cljs.core.Keyword(null,"subtype","subtype",-2092672993),new cljs.core.Keyword(null,"var-len-num-more-than-32-bits","var-len-num-more-than-32-bits",-51391939),new cljs.core.Keyword(null,"i","i",-1386841315),i__$1], null));
}
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41248_41845 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41249_41846 = cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null));
var G__41250_41847 = output_schema41233_41821;
var G__41251_41848 = cljs.core.deref(output_checker41236_41824);
var G__41252_41849 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41248_41845,G__41249_41846,G__41250_41847,G__41251_41848,G__41252_41849) : schema.core.fn_validator.call(null,G__41248_41845,G__41249_41846,G__41250_41847,G__41251_41848,G__41252_41849));
} else {
var temp__5804__auto___41850 = (function (){var fexpr__41253 = cljs.core.deref(output_checker41236_41824);
return (fexpr__41253.cljs$core$IFn$_invoke$arity$1 ? fexpr__41253.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41253.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41850)){
var error__37765__auto___41851 = temp__5804__auto___41850;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"decode-int","decode-int",1051615173,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("s","one","s/one",-1719427222,null),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null),new cljs.core.Keyword(null,"int","int",-1741416922)),cljs.core.list(new cljs.core.Symbol("s","optional","s/optional",-600484177,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"unread-remainder","unread-remainder",-1691333590))], null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes an variable-length zig-zag encoded byte array and reads an integer\n   from it.\n   Returns a vector of the integer and, optionally, any unread bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41851], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41233_41821,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41851], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.decode_int),schema.core.__GT_FnSchema(output_schema41233_41821,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41234_41822], null)));

var ufv___41852 = schema.utils.use_fn_validation;
var output_schema41255_41853 = deercreeklabs.baracus.ByteArray;
var input_schema41256_41854 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("s","Int","s/Int",-2116888657,null)], null)))], null);
var input_checker41257_41855 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41256_41854);
}),null));
var output_checker41258_41856 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41255_41853);
}),null));
var ret__40100__auto___41857 = /**
 * Inputs: [i :- s/Int]
 *   Returns: ByteArray
 * 
 *   Encodes an integer using variable length zig-zag coding.
 * Returns the encoded bytes.
 */
deercreeklabs.baracus.encode_int = (function deercreeklabs$baracus$encode_int(G__41259){
var validate__37763__auto__ = cljs.core.deref(ufv___41852);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41858 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41259], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41261_41859 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41262_41860 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41263_41861 = input_schema41256_41854;
var G__41264_41862 = cljs.core.deref(input_checker41257_41855);
var G__41265_41863 = args__37764__auto___41858;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41261_41859,G__41262_41860,G__41263_41861,G__41264_41862,G__41265_41863) : schema.core.fn_validator.call(null,G__41261_41859,G__41262_41860,G__41263_41861,G__41264_41862,G__41265_41863));
} else {
var temp__5804__auto___41866 = (function (){var fexpr__41266 = cljs.core.deref(input_checker41257_41855);
return (fexpr__41266.cljs$core$IFn$_invoke$arity$1 ? fexpr__41266.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41858) : fexpr__41266.call(null,args__37764__auto___41858));
})();
if(cljs.core.truth_(temp__5804__auto___41866)){
var error__37765__auto___41868 = temp__5804__auto___41866;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41868], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41256_41854,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41858,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41868], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var i = G__41259;
while(true){
var zz_n = ((i << (1)) ^ (i >> (31)));
var n = zz_n;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
if(((n & (-128)) === (0))){
return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,(n & (127))));
} else {
var b = ((n & (127)) | (128));
var G__41873 = (n >>> (7));
var G__41874 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,b);
n = G__41873;
out = G__41874;
continue;
}
break;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41270_41875 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41271_41876 = cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null));
var G__41272_41877 = output_schema41255_41853;
var G__41273_41878 = cljs.core.deref(output_checker41258_41856);
var G__41274_41879 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41270_41875,G__41271_41876,G__41272_41877,G__41273_41878,G__41274_41879) : schema.core.fn_validator.call(null,G__41270_41875,G__41271_41876,G__41272_41877,G__41273_41878,G__41274_41879));
} else {
var temp__5804__auto___41880 = (function (){var fexpr__41275 = cljs.core.deref(output_checker41258_41856);
return (fexpr__41275.cljs$core$IFn$_invoke$arity$1 ? fexpr__41275.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41275.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41880)){
var error__37765__auto___41881 = temp__5804__auto___41880;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"encode-int","encode-int",-913631625,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Encodes an integer using variable length zig-zag coding.\n   Returns the encoded bytes."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41881], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41255_41853,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41881], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.encode_int),schema.core.__GT_FnSchema(output_schema41255_41853,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41256_41854], null)));

var ufv___41883 = schema.utils.use_fn_validation;
var output_schema41277_41884 = schema.core.maybe(schema.core.Str);
var input_schema41278_41885 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"b","b",-1172211299,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41279_41886 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41278_41885);
}),null));
var output_checker41280_41887 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41277_41884);
}),null));
var ret__40100__auto___41888 = /**
 * Inputs: [b :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 * 
 *   Note that this does not return a URL-safe string.
 */
deercreeklabs.baracus.byte_array__GT_b64 = (function deercreeklabs$baracus$byte_array__GT_b64(G__41281){
var validate__37763__auto__ = cljs.core.deref(ufv___41883);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41889 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41281], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41283_41890 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41284_41891 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41285_41892 = input_schema41278_41885;
var G__41286_41893 = cljs.core.deref(input_checker41279_41886);
var G__41287_41894 = args__37764__auto___41889;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41283_41890,G__41284_41891,G__41285_41892,G__41286_41893,G__41287_41894) : schema.core.fn_validator.call(null,G__41283_41890,G__41284_41891,G__41285_41892,G__41286_41893,G__41287_41894));
} else {
var temp__5804__auto___41895 = (function (){var fexpr__41288 = cljs.core.deref(input_checker41279_41886);
return (fexpr__41288.cljs$core$IFn$_invoke$arity$1 ? fexpr__41288.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41889) : fexpr__41288.call(null,args__37764__auto___41889));
})();
if(cljs.core.truth_(temp__5804__auto___41895)){
var error__37765__auto___41896 = temp__5804__auto___41895;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41896], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41278_41885,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41889,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41896], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var b = G__41281;
while(true){
if(cljs.core.truth_(b)){
return goog.crypt.base64.encodeByteArray((new Uint8Array(b)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41290_41898 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41291_41899 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null));
var G__41292_41900 = output_schema41277_41884;
var G__41293_41901 = cljs.core.deref(output_checker41280_41887);
var G__41294_41902 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41290_41898,G__41291_41899,G__41292_41900,G__41293_41901,G__41294_41902) : schema.core.fn_validator.call(null,G__41290_41898,G__41291_41899,G__41292_41900,G__41293_41901,G__41294_41902));
} else {
var temp__5804__auto___41903 = (function (){var fexpr__41295 = cljs.core.deref(output_checker41280_41887);
return (fexpr__41295.cljs$core$IFn$_invoke$arity$1 ? fexpr__41295.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41295.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41903)){
var error__37765__auto___41904 = temp__5804__auto___41903;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b64","byte-array->b64",-1592125227,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Note that this does not return a URL-safe string."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41904], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41277_41884,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41904], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b64),schema.core.__GT_FnSchema(output_schema41277_41884,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41278_41885], null)));

var ufv___41905 = schema.utils.use_fn_validation;
var output_schema41297_41906 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41298_41907 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41299_41908 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41298_41907);
}),null));
var output_checker41300_41909 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41297_41906);
}),null));
var ret__40100__auto___41911 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.b64__GT_byte_array = (function deercreeklabs$baracus$b64__GT_byte_array(G__41301){
var validate__37763__auto__ = cljs.core.deref(ufv___41905);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41912 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41301], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41302_41913 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41303_41914 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41304_41915 = input_schema41298_41907;
var G__41305_41916 = cljs.core.deref(input_checker41299_41908);
var G__41306_41917 = args__37764__auto___41912;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41302_41913,G__41303_41914,G__41304_41915,G__41305_41916,G__41306_41917) : schema.core.fn_validator.call(null,G__41302_41913,G__41303_41914,G__41304_41915,G__41305_41916,G__41306_41917));
} else {
var temp__5804__auto___41918 = (function (){var fexpr__41308 = cljs.core.deref(input_checker41299_41908);
return (fexpr__41308.cljs$core$IFn$_invoke$arity$1 ? fexpr__41308.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41912) : fexpr__41308.call(null,args__37764__auto___41912));
})();
if(cljs.core.truth_(temp__5804__auto___41918)){
var error__37765__auto___41919 = temp__5804__auto___41918;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41919], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41298_41907,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41912,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41919], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var s = G__41301;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.base64.decodeStringToUint8Array(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41309_41920 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41310_41921 = cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41311_41922 = output_schema41297_41906;
var G__41312_41923 = cljs.core.deref(output_checker41300_41909);
var G__41313_41924 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41309_41920,G__41310_41921,G__41311_41922,G__41312_41923,G__41313_41924) : schema.core.fn_validator.call(null,G__41309_41920,G__41310_41921,G__41311_41922,G__41312_41923,G__41313_41924));
} else {
var temp__5804__auto___41925 = (function (){var fexpr__41314 = cljs.core.deref(output_checker41300_41909);
return (fexpr__41314.cljs$core$IFn$_invoke$arity$1 ? fexpr__41314.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41314.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41925)){
var error__37765__auto___41926 = temp__5804__auto___41925;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"b64->byte-array","b64->byte-array",-1651840809,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41926], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41297_41906,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41926], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.b64__GT_byte_array),schema.core.__GT_FnSchema(output_schema41297_41906,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41298_41907], null)));

var ufv___41927 = schema.utils.use_fn_validation;
var output_schema41316_41928 = schema.core.maybe(schema.core.Str);
var input_schema41317_41929 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41318_41930 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41317_41929);
}),null));
var output_checker41319_41931 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41316_41928);
}),null));
var ret__40100__auto___41932 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_utf8 = (function deercreeklabs$baracus$byte_array__GT_utf8(G__41320){
var validate__37763__auto__ = cljs.core.deref(ufv___41927);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41933 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41320], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41324_41934 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41325_41935 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41326_41936 = input_schema41317_41929;
var G__41327_41937 = cljs.core.deref(input_checker41318_41930);
var G__41328_41938 = args__37764__auto___41933;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41324_41934,G__41325_41935,G__41326_41936,G__41327_41937,G__41328_41938) : schema.core.fn_validator.call(null,G__41324_41934,G__41325_41935,G__41326_41936,G__41327_41937,G__41328_41938));
} else {
var temp__5804__auto___41939 = (function (){var fexpr__41329 = cljs.core.deref(input_checker41318_41930);
return (fexpr__41329.cljs$core$IFn$_invoke$arity$1 ? fexpr__41329.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41933) : fexpr__41329.call(null,args__37764__auto___41933));
})();
if(cljs.core.truth_(temp__5804__auto___41939)){
var error__37765__auto___41940 = temp__5804__auto___41939;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41940], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41317_41929,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41933,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41940], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41320;
while(true){
if(cljs.core.truth_(ba)){
return goog.crypt.utf8ByteArrayToString((new Uint8Array(ba)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41331_41941 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41332_41942 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41333_41943 = output_schema41316_41928;
var G__41334_41944 = cljs.core.deref(output_checker41319_41931);
var G__41335_41945 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41331_41941,G__41332_41942,G__41333_41943,G__41334_41944,G__41335_41945) : schema.core.fn_validator.call(null,G__41331_41941,G__41332_41942,G__41333_41943,G__41334_41944,G__41335_41945));
} else {
var temp__5804__auto___41946 = (function (){var fexpr__41336 = cljs.core.deref(output_checker41319_41931);
return (fexpr__41336.cljs$core$IFn$_invoke$arity$1 ? fexpr__41336.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41336.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41946)){
var error__37765__auto___41947 = temp__5804__auto___41946;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->utf8","byte-array->utf8",1295149325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41947], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41316_41928,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41947], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_utf8),schema.core.__GT_FnSchema(output_schema41316_41928,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41317_41929], null)));

var ufv___41948 = schema.utils.use_fn_validation;
var output_schema41337_41949 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41338_41950 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41339_41951 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41338_41950);
}),null));
var output_checker41340_41952 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41337_41949);
}),null));
var ret__40100__auto___41953 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.utf8__GT_byte_array = (function deercreeklabs$baracus$utf8__GT_byte_array(G__41341){
var validate__37763__auto__ = cljs.core.deref(ufv___41948);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41954 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41341], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41343_41955 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41344_41956 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41345_41957 = input_schema41338_41950;
var G__41346_41958 = cljs.core.deref(input_checker41339_41951);
var G__41347_41959 = args__37764__auto___41954;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41343_41955,G__41344_41956,G__41345_41957,G__41346_41958,G__41347_41959) : schema.core.fn_validator.call(null,G__41343_41955,G__41344_41956,G__41345_41957,G__41346_41958,G__41347_41959));
} else {
var temp__5804__auto___41960 = (function (){var fexpr__41348 = cljs.core.deref(input_checker41339_41951);
return (fexpr__41348.cljs$core$IFn$_invoke$arity$1 ? fexpr__41348.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41954) : fexpr__41348.call(null,args__37764__auto___41954));
})();
if(cljs.core.truth_(temp__5804__auto___41960)){
var error__37765__auto___41961 = temp__5804__auto___41960;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41961], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41338_41950,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41954,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41961], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var s = G__41341;
while(true){
if(cljs.core.truth_(s)){
return (new Int8Array(goog.crypt.stringToUtf8ByteArray(s)));
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41349_41962 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41350_41963 = cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41351_41964 = output_schema41337_41949;
var G__41352_41965 = cljs.core.deref(output_checker41340_41952);
var G__41353_41966 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41349_41962,G__41350_41963,G__41351_41964,G__41352_41965,G__41353_41966) : schema.core.fn_validator.call(null,G__41349_41962,G__41350_41963,G__41351_41964,G__41352_41965,G__41353_41966));
} else {
var temp__5804__auto___41967 = (function (){var fexpr__41354 = cljs.core.deref(output_checker41340_41952);
return (fexpr__41354.cljs$core$IFn$_invoke$arity$1 ? fexpr__41354.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41354.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41967)){
var error__37765__auto___41968 = temp__5804__auto___41967;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"utf8->byte-array","utf8->byte-array",-940630679,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41968], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41337_41949,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41968], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.utf8__GT_byte_array),schema.core.__GT_FnSchema(output_schema41337_41949,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41338_41950], null)));

deercreeklabs.baracus.byte_array__GT_hex_str_STAR_ = (function deercreeklabs$baracus$byte_array__GT_hex_str_STAR_(p__41355){
var map__41356 = p__41355;
var map__41356__$1 = cljs.core.__destructure_map(map__41356);
var alphabet = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41356__$1,new cljs.core.Keyword(null,"alphabet","alphabet",788478088));
var ba = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41356__$1,new cljs.core.Keyword(null,"ba","ba",-960950298));
if(cljs.core.truth_(ba)){
var len = cljs.core.count(ba);
var ca = (new Array(((2) * len)));
var n__5636__auto___41970 = len;
var i_41971 = (0);
while(true){
if((i_41971 < n__5636__auto___41970)){
var b_41972 = ((ba[i_41971]) & (255));
var j_41973 = ((2) * i_41971);
(ca[j_41973] = (function (){var G__41358 = (b_41972 >> (4));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41358) : alphabet.call(null,G__41358));
})());

(ca[(j_41973 + (1))] = (function (){var G__41359 = (b_41972 & (15));
return (alphabet.cljs$core$IFn$_invoke$arity$1 ? alphabet.cljs$core$IFn$_invoke$arity$1(G__41359) : alphabet.call(null,G__41359));
})());

var G__41974 = (i_41971 + (1));
i_41971 = G__41974;
continue;
} else {
}
break;
}

return ca.join("");
} else {
return null;
}
});
var ufv___41975 = schema.utils.use_fn_validation;
var output_schema41361_41976 = schema.core.maybe(schema.core.Str);
var input_schema41362_41977 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41363_41978 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41362_41977);
}),null));
var output_checker41364_41979 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41361_41976);
}),null));
var ret__40100__auto___41980 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_hex_str = (function deercreeklabs$baracus$byte_array__GT_hex_str(G__41365){
var validate__37763__auto__ = cljs.core.deref(ufv___41975);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___41982 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41365], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41366_41983 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41367_41984 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41368_41985 = input_schema41362_41977;
var G__41369_41986 = cljs.core.deref(input_checker41363_41978);
var G__41370_41987 = args__37764__auto___41982;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41366_41983,G__41367_41984,G__41368_41985,G__41369_41986,G__41370_41987) : schema.core.fn_validator.call(null,G__41366_41983,G__41367_41984,G__41368_41985,G__41369_41986,G__41370_41987));
} else {
var temp__5804__auto___41988 = (function (){var fexpr__41371 = cljs.core.deref(input_checker41363_41978);
return (fexpr__41371.cljs$core$IFn$_invoke$arity$1 ? fexpr__41371.cljs$core$IFn$_invoke$arity$1(args__37764__auto___41982) : fexpr__41371.call(null,args__37764__auto___41982));
})();
if(cljs.core.truth_(temp__5804__auto___41988)){
var error__37765__auto___41989 = temp__5804__auto___41988;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41989], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41362_41977,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___41982,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41989], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41365;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41372_41990 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41373_41991 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41374_41992 = output_schema41361_41976;
var G__41375_41993 = cljs.core.deref(output_checker41364_41979);
var G__41376_41994 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41372_41990,G__41373_41991,G__41374_41992,G__41375_41993,G__41376_41994) : schema.core.fn_validator.call(null,G__41372_41990,G__41373_41991,G__41374_41992,G__41375_41993,G__41376_41994));
} else {
var temp__5804__auto___41995 = (function (){var fexpr__41378 = cljs.core.deref(output_checker41364_41979);
return (fexpr__41378.cljs$core$IFn$_invoke$arity$1 ? fexpr__41378.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41378.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___41995)){
var error__37765__auto___41996 = temp__5804__auto___41995;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->hex-str","byte-array->hex-str",1070118492,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___41996], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41361_41976,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___41996], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_hex_str),schema.core.__GT_FnSchema(output_schema41361_41976,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41362_41977], null)));

var ufv___41997 = schema.utils.use_fn_validation;
var output_schema41379_41998 = schema.core.maybe(schema.core.Str);
var input_schema41380_41999 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41381_42000 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41380_41999);
}),null));
var output_checker41382_42001 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41379_41998);
}),null));
var ret__40100__auto___42002 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_upper_hex_str = (function deercreeklabs$baracus$byte_array__GT_upper_hex_str(G__41383){
var validate__37763__auto__ = cljs.core.deref(ufv___41997);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___42003 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41383], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41387_42004 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41388_42005 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41389_42006 = input_schema41380_41999;
var G__41390_42007 = cljs.core.deref(input_checker41381_42000);
var G__41391_42008 = args__37764__auto___42003;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41387_42004,G__41388_42005,G__41389_42006,G__41390_42007,G__41391_42008) : schema.core.fn_validator.call(null,G__41387_42004,G__41388_42005,G__41389_42006,G__41390_42007,G__41391_42008));
} else {
var temp__5804__auto___42009 = (function (){var fexpr__41393 = cljs.core.deref(input_checker41381_42000);
return (fexpr__41393.cljs$core$IFn$_invoke$arity$1 ? fexpr__41393.cljs$core$IFn$_invoke$arity$1(args__37764__auto___42003) : fexpr__41393.call(null,args__37764__auto___42003));
})();
if(cljs.core.truth_(temp__5804__auto___42009)){
var error__37765__auto___42010 = temp__5804__auto___42009;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42010], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41380_41999,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___42003,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42010], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41383;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41394_42011 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41395_42012 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41396_42013 = output_schema41379_41998;
var G__41397_42014 = cljs.core.deref(output_checker41382_42001);
var G__41398_42015 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41394_42011,G__41395_42012,G__41396_42013,G__41397_42014,G__41398_42015) : schema.core.fn_validator.call(null,G__41394_42011,G__41395_42012,G__41396_42013,G__41397_42014,G__41398_42015));
} else {
var temp__5804__auto___42016 = (function (){var fexpr__41399 = cljs.core.deref(output_checker41382_42001);
return (fexpr__41399.cljs$core$IFn$_invoke$arity$1 ? fexpr__41399.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41399.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42016)){
var error__37765__auto___42018 = temp__5804__auto___42016;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->upper-hex-str","byte-array->upper-hex-str",-332945892,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42018], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41379_41998,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42018], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_upper_hex_str),schema.core.__GT_FnSchema(output_schema41379_41998,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41380_41999], null)));

var ufv___42019 = schema.utils.use_fn_validation;
var output_schema41401_42020 = schema.core.maybe(schema.core.Str);
var input_schema41402_42021 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(deercreeklabs.baracus.ByteArray),cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)))], null);
var input_checker41403_42022 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41402_42021);
}),null));
var output_checker41404_42023 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41401_42020);
}),null));
var ret__40100__auto___42024 = /**
 * Inputs: [ba :- (s/maybe ByteArray)]
 *   Returns: (s/maybe s/Str)
 */
deercreeklabs.baracus.byte_array__GT_b16_alpha_str = (function deercreeklabs$baracus$byte_array__GT_b16_alpha_str(G__41405){
var validate__37763__auto__ = cljs.core.deref(ufv___42019);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___42026 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41405], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41406_42028 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41407_42029 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41408_42030 = input_schema41402_42021;
var G__41409_42031 = cljs.core.deref(input_checker41403_42022);
var G__41410_42032 = args__37764__auto___42026;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41406_42028,G__41407_42029,G__41408_42030,G__41409_42031,G__41410_42032) : schema.core.fn_validator.call(null,G__41406_42028,G__41407_42029,G__41408_42030,G__41409_42031,G__41410_42032));
} else {
var temp__5804__auto___42034 = (function (){var fexpr__41411 = cljs.core.deref(input_checker41403_42022);
return (fexpr__41411.cljs$core$IFn$_invoke$arity$1 ? fexpr__41411.cljs$core$IFn$_invoke$arity$1(args__37764__auto___42026) : fexpr__41411.call(null,args__37764__auto___42026));
})();
if(cljs.core.truth_(temp__5804__auto___42034)){
var error__37765__auto___42035 = temp__5804__auto___42034;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42035], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41402_42021,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___42026,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42035], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41405;
while(true){
return deercreeklabs.baracus.byte_array__GT_hex_str_STAR_(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alphabet","alphabet",788478088),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, ["a","b","c","d","c","e","f","g","h","i","j","k","l","m","n","o"], null),new cljs.core.Keyword(null,"ba","ba",-960950298),ba], null));
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41412_42039 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41413_42040 = cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null));
var G__41414_42041 = output_schema41401_42020;
var G__41415_42042 = cljs.core.deref(output_checker41404_42023);
var G__41416_42043 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41412_42039,G__41413_42040,G__41414_42041,G__41415_42042,G__41416_42043) : schema.core.fn_validator.call(null,G__41412_42039,G__41413_42040,G__41414_42041,G__41415_42042,G__41416_42043));
} else {
var temp__5804__auto___42046 = (function (){var fexpr__41417 = cljs.core.deref(output_checker41404_42023);
return (fexpr__41417.cljs$core$IFn$_invoke$arity$1 ? fexpr__41417.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41417.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42046)){
var error__37765__auto___42048 = temp__5804__auto___42046;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"byte-array->b16-alpha-str","byte-array->b16-alpha-str",1050124449,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42048], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41401_42020,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42048], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.byte_array__GT_b16_alpha_str),schema.core.__GT_FnSchema(output_schema41401_42020,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41402_42021], null)));

deercreeklabs.baracus.hex_chars_set = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, ["A",null,"a",null,"B",null,"b",null,"C",null,"c",null,"D",null,"d",null,"E",null,"e",null,"F",null,"f",null,"0",null,"1",null,"2",null,"3",null,"4",null,"5",null,"6",null,"7",null,"8",null,"9",null], null), null);
deercreeklabs.baracus.char__GT_int = (function deercreeklabs$baracus$char__GT_int(ch){
if(cljs.core.truth_((deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1 ? deercreeklabs.baracus.hex_chars_set.cljs$core$IFn$_invoke$arity$1(ch) : deercreeklabs.baracus.hex_chars_set.call(null,ch)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Character `",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),"` is not a hex character."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ch","ch",-554717905),ch], null));
}

return parseInt(ch,(16));
});
var ufv___42049 = schema.utils.use_fn_validation;
var output_schema41419_42050 = schema.core.maybe(deercreeklabs.baracus.ByteArray);
var input_schema41420_42051 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.maybe(schema.core.Str),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol("s","Str","s/Str",907974338,null))], null)))], null);
var input_checker41421_42052 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41420_42051);
}),null));
var output_checker41422_42053 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41419_42050);
}),null));
var ret__40100__auto___42054 = /**
 * Inputs: [s :- (s/maybe s/Str)]
 *   Returns: (s/maybe ByteArray)
 */
deercreeklabs.baracus.hex_str__GT_byte_array = (function deercreeklabs$baracus$hex_str__GT_byte_array(G__41423){
var validate__37763__auto__ = cljs.core.deref(ufv___42049);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___42055 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41423], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41425_42056 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41426_42057 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41427_42058 = input_schema41420_42051;
var G__41428_42059 = cljs.core.deref(input_checker41421_42052);
var G__41429_42060 = args__37764__auto___42055;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41425_42056,G__41426_42057,G__41427_42058,G__41428_42059,G__41429_42060) : schema.core.fn_validator.call(null,G__41425_42056,G__41426_42057,G__41427_42058,G__41428_42059,G__41429_42060));
} else {
var temp__5804__auto___42063 = (function (){var fexpr__41431 = cljs.core.deref(input_checker41421_42052);
return (fexpr__41431.cljs$core$IFn$_invoke$arity$1 ? fexpr__41431.cljs$core$IFn$_invoke$arity$1(args__37764__auto___42055) : fexpr__41431.call(null,args__37764__auto___42055));
})();
if(cljs.core.truth_(temp__5804__auto___42063)){
var error__37765__auto___42064 = temp__5804__auto___42063;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42064], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41420_42051,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___42055,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42064], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var s = G__41423;
while(true){
if(cljs.core.truth_(s)){
var str_len = cljs.core.count(s);
var _ = ((cljs.core.even_QMARK_(str_len))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Hex string argument must have an even ","number of characters. Got ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(str_len)," character(s)."].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"str-len","str-len",-1863008368),str_len], null))})());
var ba_len = (str_len / (2));
var ba = deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(ba_len);
var n__5636__auto___42069 = ba_len;
var i_42070 = (0);
while(true){
if((i_42070 < n__5636__auto___42069)){
var j_42071 = ((2) * i_42070);
(ba[i_42070] = ((deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,j_42071)) << (4)) + deercreeklabs.baracus.char__GT_int(cljs.core.get.cljs$core$IFn$_invoke$arity$2(s,(j_42071 + (1))))));

var G__42073 = (i_42070 + (1));
i_42070 = G__42073;
continue;
} else {
}
break;
}

return ba;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41433_42075 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41434_42076 = cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null));
var G__41435_42077 = output_schema41419_42050;
var G__41436_42078 = cljs.core.deref(output_checker41422_42053);
var G__41437_42079 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41433_42075,G__41434_42076,G__41435_42077,G__41436_42078,G__41437_42079) : schema.core.fn_validator.call(null,G__41433_42075,G__41434_42076,G__41435_42077,G__41436_42078,G__41437_42079));
} else {
var temp__5804__auto___42080 = (function (){var fexpr__41438 = cljs.core.deref(output_checker41422_42053);
return (fexpr__41438.cljs$core$IFn$_invoke$arity$1 ? fexpr__41438.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41438.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42080)){
var error__37765__auto___42081 = temp__5804__auto___42080;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"hex-str->byte-array","hex-str->byte-array",1745861283,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.list(new cljs.core.Symbol("s","maybe","s/maybe",1326133944,null),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null))], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42081], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41419_42050,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42081], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.hex_str__GT_byte_array),schema.core.__GT_FnSchema(output_schema41419_42050,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41420_42051], null)));

var ufv___42082 = schema.utils.use_fn_validation;
var output_schema41439_42083 = deercreeklabs.baracus.ByteArray;
var input_schema41440_42084 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41441_42085 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41440_42084);
}),null));
var output_checker41442_42086 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41439_42083);
}),null));
var ret__40100__auto___42087 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha256 = (function deercreeklabs$baracus$sha256(G__41443){
var validate__37763__auto__ = cljs.core.deref(ufv___42082);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___42089 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41443], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41444_42090 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41445_42091 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41446_42092 = input_schema41440_42084;
var G__41447_42093 = cljs.core.deref(input_checker41441_42085);
var G__41448_42094 = args__37764__auto___42089;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41444_42090,G__41445_42091,G__41446_42092,G__41447_42093,G__41448_42094) : schema.core.fn_validator.call(null,G__41444_42090,G__41445_42091,G__41446_42092,G__41447_42093,G__41448_42094));
} else {
var temp__5804__auto___42098 = (function (){var fexpr__41450 = cljs.core.deref(input_checker41441_42085);
return (fexpr__41450.cljs$core$IFn$_invoke$arity$1 ? fexpr__41450.cljs$core$IFn$_invoke$arity$1(args__37764__auto___42089) : fexpr__41450.call(null,args__37764__auto___42089));
})();
if(cljs.core.truth_(temp__5804__auto___42098)){
var error__37765__auto___42099 = temp__5804__auto___42098;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42099], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41440_42084,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___42089,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42099], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41443;
while(true){
var hasher = (new goog.crypt.Sha256());
hasher.update((new Uint8Array(ba)));

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41451_42101 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41452_42102 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41453_42103 = output_schema41439_42083;
var G__41454_42104 = cljs.core.deref(output_checker41442_42086);
var G__41455_42105 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41451_42101,G__41452_42102,G__41453_42103,G__41454_42104,G__41455_42105) : schema.core.fn_validator.call(null,G__41451_42101,G__41452_42102,G__41453_42103,G__41454_42104,G__41455_42105));
} else {
var temp__5804__auto___42108 = (function (){var fexpr__41456 = cljs.core.deref(output_checker41442_42086);
return (fexpr__41456.cljs$core$IFn$_invoke$arity$1 ? fexpr__41456.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41456.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42108)){
var error__37765__auto___42111 = temp__5804__auto___42108;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha256","sha256",-763823969,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42111], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41439_42083,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42111], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha256),schema.core.__GT_FnSchema(output_schema41439_42083,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41440_42084], null)));

var ufv___42117 = schema.utils.use_fn_validation;
var output_schema41458_42118 = deercreeklabs.baracus.ByteArray;
var input_schema41459_42119 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41460_42120 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41459_42119);
}),null));
var output_checker41461_42121 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41458_42118);
}),null));
var ret__40100__auto___42123 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.sha1 = (function deercreeklabs$baracus$sha1(G__41462){
var validate__37763__auto__ = cljs.core.deref(ufv___42117);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___42125 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41462], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41463_42126 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41464_42127 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41465_42128 = input_schema41459_42119;
var G__41466_42129 = cljs.core.deref(input_checker41460_42120);
var G__41467_42130 = args__37764__auto___42125;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41463_42126,G__41464_42127,G__41465_42128,G__41466_42129,G__41467_42130) : schema.core.fn_validator.call(null,G__41463_42126,G__41464_42127,G__41465_42128,G__41466_42129,G__41467_42130));
} else {
var temp__5804__auto___42133 = (function (){var fexpr__41468 = cljs.core.deref(input_checker41460_42120);
return (fexpr__41468.cljs$core$IFn$_invoke$arity$1 ? fexpr__41468.cljs$core$IFn$_invoke$arity$1(args__37764__auto___42125) : fexpr__41468.call(null,args__37764__auto___42125));
})();
if(cljs.core.truth_(temp__5804__auto___42133)){
var error__37765__auto___42134 = temp__5804__auto___42133;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42134], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41459_42119,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___42125,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42134], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41462;
while(true){
var hasher = (new goog.crypt.Sha1());
hasher.update((new Uint8Array(ba)));

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41470_42144 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41471_42145 = cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41472_42146 = output_schema41458_42118;
var G__41473_42147 = cljs.core.deref(output_checker41461_42121);
var G__41474_42148 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41470_42144,G__41471_42145,G__41472_42146,G__41473_42147,G__41474_42148) : schema.core.fn_validator.call(null,G__41470_42144,G__41471_42145,G__41472_42146,G__41473_42147,G__41474_42148));
} else {
var temp__5804__auto___42149 = (function (){var fexpr__41475 = cljs.core.deref(output_checker41461_42121);
return (fexpr__41475.cljs$core$IFn$_invoke$arity$1 ? fexpr__41475.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41475.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42149)){
var error__37765__auto___42150 = temp__5804__auto___42149;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"sha1","sha1",705430168,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42150], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41458_42118,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42150], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.sha1),schema.core.__GT_FnSchema(output_schema41458_42118,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41459_42119], null)));

var ufv___42151 = schema.utils.use_fn_validation;
var output_schema41476_42152 = deercreeklabs.baracus.ByteArray;
var input_schema41477_42153 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(deercreeklabs.baracus.ByteArray,cljs.core.with_meta(new cljs.core.Symbol(null,"ba","ba",679581229,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)))], null);
var input_checker41478_42154 = (new cljs.core.Delay((function (){
return schema.core.checker(input_schema41477_42153);
}),null));
var output_checker41479_42155 = (new cljs.core.Delay((function (){
return schema.core.checker(output_schema41476_42152);
}),null));
var ret__40100__auto___42156 = /**
 * Inputs: [ba :- ByteArray]
 *   Returns: ByteArray
 */
deercreeklabs.baracus.md5 = (function deercreeklabs$baracus$md5(G__41480){
var validate__37763__auto__ = cljs.core.deref(ufv___42151);
if(cljs.core.truth_(validate__37763__auto__)){
var args__37764__auto___42157 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__41480], null);
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41482_42158 = new cljs.core.Keyword(null,"input","input",556931961);
var G__41483_42159 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41484_42160 = input_schema41477_42153;
var G__41485_42161 = cljs.core.deref(input_checker41478_42154);
var G__41486_42162 = args__37764__auto___42157;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41482_42158,G__41483_42159,G__41484_42160,G__41485_42161,G__41486_42162) : schema.core.fn_validator.call(null,G__41482_42158,G__41483_42159,G__41484_42160,G__41485_42161,G__41486_42162));
} else {
var temp__5804__auto___42163 = (function (){var fexpr__41487 = cljs.core.deref(input_checker41478_42154);
return (fexpr__41487.cljs$core$IFn$_invoke$arity$1 ? fexpr__41487.cljs$core$IFn$_invoke$arity$1(args__37764__auto___42157) : fexpr__41487.call(null,args__37764__auto___42157));
})();
if(cljs.core.truth_(temp__5804__auto___42163)){
var error__37765__auto___42164 = temp__5804__auto___42163;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42164], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema41477_42153,new cljs.core.Keyword(null,"value","value",305978217),args__37764__auto___42157,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42164], null));
} else {
}
}
} else {
}

var o__37766__auto__ = (function (){var ba = G__41480;
while(true){
var hasher = (new goog.crypt.Md5());
hasher.update((new Uint8Array(ba)));

return deercreeklabs.baracus.byte_array.cljs$core$IFn$_invoke$arity$1(hasher.digest());
break;
}
})();
if(cljs.core.truth_(validate__37763__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
var G__41488_42168 = new cljs.core.Keyword(null,"output","output",-1105869043);
var G__41489_42169 = cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null));
var G__41490_42170 = output_schema41476_42152;
var G__41491_42171 = cljs.core.deref(output_checker41479_42155);
var G__41492_42172 = o__37766__auto__;
(schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5 ? schema.core.fn_validator.cljs$core$IFn$_invoke$arity$5(G__41488_42168,G__41489_42169,G__41490_42170,G__41491_42171,G__41492_42172) : schema.core.fn_validator.call(null,G__41488_42168,G__41489_42169,G__41490_42170,G__41491_42171,G__41492_42172));
} else {
var temp__5804__auto___42173 = (function (){var fexpr__41493 = cljs.core.deref(output_checker41479_42155);
return (fexpr__41493.cljs$core$IFn$_invoke$arity$1 ? fexpr__41493.cljs$core$IFn$_invoke$arity$1(o__37766__auto__) : fexpr__41493.call(null,o__37766__auto__));
})();
if(cljs.core.truth_(temp__5804__auto___42173)){
var error__37765__auto___42176 = temp__5804__auto___42173;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.with_meta(new cljs.core.Symbol(null,"md5","md5",-260854901,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"ByteArray","ByteArray",1312436492,null)], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error__37765__auto___42176], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema41476_42152,new cljs.core.Keyword(null,"value","value",305978217),o__37766__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__37765__auto___42176], null));
} else {
}
}
} else {
}

return o__37766__auto__;
});
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(deercreeklabs.baracus.md5),schema.core.__GT_FnSchema(output_schema41476_42152,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema41477_42153], null)));


//# sourceMappingURL=deercreeklabs.baracus.js.map
