goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__56399){
var vec__56400 = p__56399;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56400,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56400,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__56409 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__56409__$1 = (((G__56409 instanceof cljs.core.Keyword))?G__56409.fqn:null);
switch (G__56409__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__56411 = (function (){
var seq__56412 = cljs.core.seq(vars__$1);
var chunk__56413 = null;
var count__56414 = (0);
var i__56415 = (0);
while(true){
if((i__56415 < count__56414)){
var v = chunk__56413.cljs$core$IIndexed$_nth$arity$2(null,i__56415);
var temp__5804__auto___56540 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56540)){
var t_56541 = temp__5804__auto___56540;
var G__56424_56542 = ((function (seq__56412,chunk__56413,count__56414,i__56415,t_56541,temp__5804__auto___56540,v,each_fixture_fn,G__56409,G__56409__$1,env,once_fixtures,each_fixtures,vec__56400,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56541)));
});})(seq__56412,chunk__56413,count__56414,i__56415,t_56541,temp__5804__auto___56540,v,each_fixture_fn,G__56409,G__56409__$1,env,once_fixtures,each_fixtures,vec__56400,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56424_56542) : each_fixture_fn.call(null,G__56424_56542));
} else {
}


var G__56546 = seq__56412;
var G__56547 = chunk__56413;
var G__56548 = count__56414;
var G__56549 = (i__56415 + (1));
seq__56412 = G__56546;
chunk__56413 = G__56547;
count__56414 = G__56548;
i__56415 = G__56549;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__56412);
if(temp__5804__auto__){
var seq__56412__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56412__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__56412__$1);
var G__56550 = cljs.core.chunk_rest(seq__56412__$1);
var G__56551 = c__5568__auto__;
var G__56552 = cljs.core.count(c__5568__auto__);
var G__56553 = (0);
seq__56412 = G__56550;
chunk__56413 = G__56551;
count__56414 = G__56552;
i__56415 = G__56553;
continue;
} else {
var v = cljs.core.first(seq__56412__$1);
var temp__5804__auto___56554__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___56554__$1)){
var t_56555 = temp__5804__auto___56554__$1;
var G__56430_56556 = ((function (seq__56412,chunk__56413,count__56414,i__56415,t_56555,temp__5804__auto___56554__$1,v,seq__56412__$1,temp__5804__auto__,each_fixture_fn,G__56409,G__56409__$1,env,once_fixtures,each_fixtures,vec__56400,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_56555)));
});})(seq__56412,chunk__56413,count__56414,i__56415,t_56555,temp__5804__auto___56554__$1,v,seq__56412__$1,temp__5804__auto__,each_fixture_fn,G__56409,G__56409__$1,env,once_fixtures,each_fixtures,vec__56400,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__56430_56556) : each_fixture_fn.call(null,G__56430_56556));
} else {
}


var G__56558 = cljs.core.next(seq__56412__$1);
var G__56559 = null;
var G__56560 = (0);
var G__56561 = (0);
seq__56412 = G__56558;
chunk__56413 = G__56559;
count__56414 = G__56560;
i__56415 = G__56561;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__56410 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__56410.cljs$core$IFn$_invoke$arity$1 ? fexpr__56410.cljs$core$IFn$_invoke$arity$1(G__56411) : fexpr__56410.call(null,G__56411));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__56409__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__56388_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56388_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__56439 = shadow.test.env.get_test_ns_info(ns);
var map__56439__$1 = cljs.core.__destructure_map(map__56439);
var test_ns = map__56439__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56439__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__56442,vars){
var map__56443 = p__56442;
var map__56443__$1 = cljs.core.__destructure_map(map__56443);
var env = map__56443__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56443__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__56444_56567 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__56446_56568 = null;
var count__56447_56569 = (0);
var i__56448_56570 = (0);
while(true){
if((i__56448_56570 < count__56447_56569)){
var vec__56464_56571 = chunk__56446_56568.cljs$core$IIndexed$_nth$arity$2(null,i__56448_56570);
var test_ns_56572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56464_56571,(0),null);
var ns_info_56573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56464_56571,(1),null);
var map__56467_56575 = ns_info_56573;
var map__56467_56576__$1 = cljs.core.__destructure_map(map__56467_56575);
var fixtures_56577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56467_56576__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56578 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56577);
if(cljs.core.truth_(temp__5804__auto___56578)){
var fix_56579 = temp__5804__auto___56578;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56572,fix_56579], 0));
} else {
}

var temp__5804__auto___56581 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56577);
if(cljs.core.truth_(temp__5804__auto___56581)){
var fix_56582 = temp__5804__auto___56581;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56572,fix_56582], 0));
} else {
}


var G__56584 = seq__56444_56567;
var G__56585 = chunk__56446_56568;
var G__56586 = count__56447_56569;
var G__56587 = (i__56448_56570 + (1));
seq__56444_56567 = G__56584;
chunk__56446_56568 = G__56585;
count__56447_56569 = G__56586;
i__56448_56570 = G__56587;
continue;
} else {
var temp__5804__auto___56588 = cljs.core.seq(seq__56444_56567);
if(temp__5804__auto___56588){
var seq__56444_56589__$1 = temp__5804__auto___56588;
if(cljs.core.chunked_seq_QMARK_(seq__56444_56589__$1)){
var c__5568__auto___56590 = cljs.core.chunk_first(seq__56444_56589__$1);
var G__56591 = cljs.core.chunk_rest(seq__56444_56589__$1);
var G__56592 = c__5568__auto___56590;
var G__56593 = cljs.core.count(c__5568__auto___56590);
var G__56594 = (0);
seq__56444_56567 = G__56591;
chunk__56446_56568 = G__56592;
count__56447_56569 = G__56593;
i__56448_56570 = G__56594;
continue;
} else {
var vec__56469_56596 = cljs.core.first(seq__56444_56589__$1);
var test_ns_56597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56469_56596,(0),null);
var ns_info_56598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__56469_56596,(1),null);
var map__56472_56600 = ns_info_56598;
var map__56472_56601__$1 = cljs.core.__destructure_map(map__56472_56600);
var fixtures_56602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56472_56601__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___56603__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_56602);
if(cljs.core.truth_(temp__5804__auto___56603__$1)){
var fix_56604 = temp__5804__auto___56603__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56597,fix_56604], 0));
} else {
}

var temp__5804__auto___56605__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_56602);
if(cljs.core.truth_(temp__5804__auto___56605__$1)){
var fix_56606 = temp__5804__auto___56605__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_56597,fix_56606], 0));
} else {
}


var G__56609 = cljs.core.next(seq__56444_56589__$1);
var G__56610 = null;
var G__56611 = (0);
var G__56612 = (0);
seq__56444_56567 = G__56609;
chunk__56446_56568 = G__56610;
count__56447_56569 = G__56611;
i__56448_56570 = G__56612;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56441_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56441_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__56477 = cljs.test.get_current_env();
var map__56477__$1 = cljs.core.__destructure_map(map__56477);
var env = map__56477__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56477__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56477__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__56482 = arguments.length;
switch (G__56482) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__56493 = arguments.length;
switch (G__56493) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__56496 = shadow.test.env.get_test_ns_info(ns);
var map__56496__$1 = cljs.core.__destructure_map(map__56496);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56496__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__56514 = arguments.length;
switch (G__56514) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56502_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__56502_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__56524 = arguments.length;
switch (G__56524) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__56518_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56518_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
