goog.provide('cljs.analyzer.impl.namespaces');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__43135 = libspec;
var seq__43136 = cljs.core.seq(vec__43135);
var first__43137 = cljs.core.first(seq__43136);
var seq__43136__$1 = cljs.core.next(seq__43136);
var lib = first__43137;
var spec = seq__43136__$1;
var libspec__$1 = vec__43135;
var vec__43138 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43138,(0),null);
var vec__43141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43138,(1),null);
var seq__43142 = cljs.core.seq(vec__43141);
var first__43143 = cljs.core.first(seq__43142);
var seq__43142__$1 = cljs.core.next(seq__43142);
var _ = first__43143;
var first__43143__$1 = cljs.core.first(seq__43142__$1);
var seq__43142__$2 = cljs.core.next(seq__43142__$1);
var alias = first__43143__$1;
var post_spec = seq__43142__$2;
var post = vec__43141;
if(cljs.core.seq(post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__43146 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count(libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__43146,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__43146;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__43151 = cljs.core.seq(new_as_aliases);
var chunk__43152 = null;
var count__43153 = (0);
var i__43154 = (0);
while(true){
if((i__43154 < count__43153)){
var vec__43173 = chunk__43152.cljs$core$IIndexed$_nth$arity$2(null,i__43154);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43173,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43173,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__43251 = seq__43151;
var G__43252 = chunk__43152;
var G__43253 = count__43153;
var G__43254 = (i__43154 + (1));
seq__43151 = G__43251;
chunk__43152 = G__43252;
count__43153 = G__43253;
i__43154 = G__43254;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__43151);
if(temp__5804__auto__){
var seq__43151__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43151__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__43151__$1);
var G__43256 = cljs.core.chunk_rest(seq__43151__$1);
var G__43257 = c__5568__auto__;
var G__43258 = cljs.core.count(c__5568__auto__);
var G__43259 = (0);
seq__43151 = G__43256;
chunk__43152 = G__43257;
count__43153 = G__43258;
i__43154 = G__43259;
continue;
} else {
var vec__43179 = cljs.core.first(seq__43151__$1);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43179,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43179,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__43261 = cljs.core.next(seq__43151__$1);
var G__43262 = null;
var G__43263 = (0);
var G__43264 = (0);
seq__43151 = G__43261;
chunk__43152 = G__43262;
count__43153 = G__43263;
i__43154 = G__43264;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__43189 = arguments.length;
switch (G__43189) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__$1,libspec){
var map__43190 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias(libspec);
var map__43190__$1 = cljs.core.__destructure_map(map__43190);
var as_alias = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43190__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43190__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates(new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__43191 = ret__$1;
var G__43191__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__43191,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__43191);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__43191__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__43191__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__43202,p__43203){
var map__43204 = p__43202;
var map__43204__$1 = cljs.core.__destructure_map(map__43204);
var ret__$1 = map__43204__$1;
var as_aliases = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43204__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__43205 = p__43203;
var seq__43206 = cljs.core.seq(vec__43205);
var first__43207 = cljs.core.first(seq__43206);
var seq__43206__$1 = cljs.core.next(seq__43206);
var spec_key = first__43207;
var libspecs = seq__43206__$1;
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__43211 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,as_aliases);
var map__43211__$1 = cljs.core.__destructure_map(map__43211);
var as_aliases__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43211__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43211__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__43221 = ret__$1;
var G__43221__$1 = (((!(cljs.core.empty_QMARK_(as_aliases__$1))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__43221,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__43221);
if((!(cljs.core.empty_QMARK_(libspecs__$1)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__43221__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs__$1));
} else {
return G__43221__$1;
}
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs));
}
}),ret,ns_specs);
});

//# sourceMappingURL=cljs.analyzer.impl.namespaces.js.map
