goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30194 = (function (f,blockable,meta30195){
this.f = f;
this.blockable = blockable;
this.meta30195 = meta30195;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30194.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30196,meta30195__$1){
var self__ = this;
var _30196__$1 = this;
return (new cljs.core.async.t_cljs$core$async30194(self__.f,self__.blockable,meta30195__$1));
}));

(cljs.core.async.t_cljs$core$async30194.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30196){
var self__ = this;
var _30196__$1 = this;
return self__.meta30195;
}));

(cljs.core.async.t_cljs$core$async30194.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30194.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30194.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30194.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30194.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30195","meta30195",20561321,null)], null);
}));

(cljs.core.async.t_cljs$core$async30194.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30194.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30194");

(cljs.core.async.t_cljs$core$async30194.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30194");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30194.
 */
cljs.core.async.__GT_t_cljs$core$async30194 = (function cljs$core$async$__GT_t_cljs$core$async30194(f,blockable,meta30195){
return (new cljs.core.async.t_cljs$core$async30194(f,blockable,meta30195));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30189 = arguments.length;
switch (G__30189) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async30194(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30241 = arguments.length;
switch (G__30241) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30255 = arguments.length;
switch (G__30255) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30272 = arguments.length;
switch (G__30272) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_33433 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33433) : fn1.call(null,val_33433));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33433) : fn1.call(null,val_33433));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30285 = arguments.length;
switch (G__30285) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___33439 = n;
var x_33440 = (0);
while(true){
if((x_33440 < n__5636__auto___33439)){
(a[x_33440] = x_33440);

var G__33441 = (x_33440 + (1));
x_33440 = G__33441;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30323 = (function (flag,meta30324){
this.flag = flag;
this.meta30324 = meta30324;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30323.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30325,meta30324__$1){
var self__ = this;
var _30325__$1 = this;
return (new cljs.core.async.t_cljs$core$async30323(self__.flag,meta30324__$1));
}));

(cljs.core.async.t_cljs$core$async30323.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30325){
var self__ = this;
var _30325__$1 = this;
return self__.meta30324;
}));

(cljs.core.async.t_cljs$core$async30323.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30323.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30323.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30323.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30323.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30324","meta30324",-1888008800,null)], null);
}));

(cljs.core.async.t_cljs$core$async30323.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30323.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30323");

(cljs.core.async.t_cljs$core$async30323.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30323");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30323.
 */
cljs.core.async.__GT_t_cljs$core$async30323 = (function cljs$core$async$__GT_t_cljs$core$async30323(flag,meta30324){
return (new cljs.core.async.t_cljs$core$async30323(flag,meta30324));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async30323(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30337 = (function (flag,cb,meta30338){
this.flag = flag;
this.cb = cb;
this.meta30338 = meta30338;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30337.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30339,meta30338__$1){
var self__ = this;
var _30339__$1 = this;
return (new cljs.core.async.t_cljs$core$async30337(self__.flag,self__.cb,meta30338__$1));
}));

(cljs.core.async.t_cljs$core$async30337.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30339){
var self__ = this;
var _30339__$1 = this;
return self__.meta30338;
}));

(cljs.core.async.t_cljs$core$async30337.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30337.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30337.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30337.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30337.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30338","meta30338",248119565,null)], null);
}));

(cljs.core.async.t_cljs$core$async30337.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30337.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30337");

(cljs.core.async.t_cljs$core$async30337.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30337");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30337.
 */
cljs.core.async.__GT_t_cljs$core$async30337 = (function cljs$core$async$__GT_t_cljs$core$async30337(flag,cb,meta30338){
return (new cljs.core.async.t_cljs$core$async30337(flag,cb,meta30338));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async30337(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__30358_SHARP_){
var G__30361 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30358_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30361) : fret.call(null,G__30361));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__30359_SHARP_){
var G__30362 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30359_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30362) : fret.call(null,G__30362));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33458 = (i + (1));
i = G__33458;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___33460 = arguments.length;
var i__5770__auto___33461 = (0);
while(true){
if((i__5770__auto___33461 < len__5769__auto___33460)){
args__5775__auto__.push((arguments[i__5770__auto___33461]));

var G__33462 = (i__5770__auto___33461 + (1));
i__5770__auto___33461 = G__33462;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30367){
var map__30368 = p__30367;
var map__30368__$1 = cljs.core.__destructure_map(map__30368);
var opts = map__30368__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30365){
var G__30366 = cljs.core.first(seq30365);
var seq30365__$1 = cljs.core.next(seq30365);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30366,seq30365__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30370 = arguments.length;
switch (G__30370) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30087__auto___33468 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_30443){
var state_val_30445 = (state_30443[(1)]);
if((state_val_30445 === (7))){
var inst_30439 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30470_33469 = state_30443__$1;
(statearr_30470_33469[(2)] = inst_30439);

(statearr_30470_33469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (1))){
var state_30443__$1 = state_30443;
var statearr_30471_33470 = state_30443__$1;
(statearr_30471_33470[(2)] = null);

(statearr_30471_33470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (4))){
var inst_30413 = (state_30443[(7)]);
var inst_30413__$1 = (state_30443[(2)]);
var inst_30423 = (inst_30413__$1 == null);
var state_30443__$1 = (function (){var statearr_30475 = state_30443;
(statearr_30475[(7)] = inst_30413__$1);

return statearr_30475;
})();
if(cljs.core.truth_(inst_30423)){
var statearr_30477_33471 = state_30443__$1;
(statearr_30477_33471[(1)] = (5));

} else {
var statearr_30478_33472 = state_30443__$1;
(statearr_30478_33472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (13))){
var state_30443__$1 = state_30443;
var statearr_30479_33476 = state_30443__$1;
(statearr_30479_33476[(2)] = null);

(statearr_30479_33476[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (6))){
var inst_30413 = (state_30443[(7)]);
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30443__$1,(11),to,inst_30413);
} else {
if((state_val_30445 === (3))){
var inst_30441 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30443__$1,inst_30441);
} else {
if((state_val_30445 === (12))){
var state_30443__$1 = state_30443;
var statearr_30482_33482 = state_30443__$1;
(statearr_30482_33482[(2)] = null);

(statearr_30482_33482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (2))){
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30443__$1,(4),from);
} else {
if((state_val_30445 === (11))){
var inst_30432 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
if(cljs.core.truth_(inst_30432)){
var statearr_30489_33486 = state_30443__$1;
(statearr_30489_33486[(1)] = (12));

} else {
var statearr_30491_33487 = state_30443__$1;
(statearr_30491_33487[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (9))){
var state_30443__$1 = state_30443;
var statearr_30498_33488 = state_30443__$1;
(statearr_30498_33488[(2)] = null);

(statearr_30498_33488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (5))){
var state_30443__$1 = state_30443;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30502_33489 = state_30443__$1;
(statearr_30502_33489[(1)] = (8));

} else {
var statearr_30507_33490 = state_30443__$1;
(statearr_30507_33490[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (14))){
var inst_30437 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30509_33491 = state_30443__$1;
(statearr_30509_33491[(2)] = inst_30437);

(statearr_30509_33491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (10))){
var inst_30429 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30515_33492 = state_30443__$1;
(statearr_30515_33492[(2)] = inst_30429);

(statearr_30515_33492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30445 === (8))){
var inst_30426 = cljs.core.async.close_BANG_(to);
var state_30443__$1 = state_30443;
var statearr_30518_33493 = state_30443__$1;
(statearr_30518_33493[(2)] = inst_30426);

(statearr_30518_33493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_30520 = [null,null,null,null,null,null,null,null];
(statearr_30520[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_30520[(1)] = (1));

return statearr_30520;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_30443){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_30443);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e30521){var ex__29885__auto__ = e30521;
var statearr_30526_33505 = state_30443;
(statearr_30526_33505[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_30443[(4)]))){
var statearr_30527_33506 = state_30443;
(statearr_30527_33506[(1)] = cljs.core.first((state_30443[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33507 = state_30443;
state_30443 = G__33507;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_30443){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_30443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_30539 = f__30088__auto__();
(statearr_30539[(6)] = c__30087__auto___33468);

return statearr_30539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__30567){
var vec__30569 = p__30567;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30569,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30569,(1),null);
var job = vec__30569;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30087__auto___33516 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_30581){
var state_val_30582 = (state_30581[(1)]);
if((state_val_30582 === (1))){
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30581__$1,(2),res,v);
} else {
if((state_val_30582 === (2))){
var inst_30576 = (state_30581[(2)]);
var inst_30577 = cljs.core.async.close_BANG_(res);
var state_30581__$1 = (function (){var statearr_30591 = state_30581;
(statearr_30591[(7)] = inst_30576);

return statearr_30591;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30581__$1,inst_30577);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0 = (function (){
var statearr_30598 = [null,null,null,null,null,null,null,null];
(statearr_30598[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__);

(statearr_30598[(1)] = (1));

return statearr_30598;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1 = (function (state_30581){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_30581);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e30605){var ex__29885__auto__ = e30605;
var statearr_30607_33523 = state_30581;
(statearr_30607_33523[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_30581[(4)]))){
var statearr_30609_33524 = state_30581;
(statearr_30609_33524[(1)] = cljs.core.first((state_30581[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33525 = state_30581;
state_30581 = G__33525;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = function(state_30581){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1.call(this,state_30581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_30622 = f__30088__auto__();
(statearr_30622[(6)] = c__30087__auto___33516);

return statearr_30622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__30627){
var vec__30628 = p__30627;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30628,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30628,(1),null);
var job = vec__30628;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___33528 = n;
var __33529 = (0);
while(true){
if((__33529 < n__5636__auto___33528)){
var G__30633_33530 = type;
var G__30633_33531__$1 = (((G__30633_33530 instanceof cljs.core.Keyword))?G__30633_33530.fqn:null);
switch (G__30633_33531__$1) {
case "compute":
var c__30087__auto___33534 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33529,c__30087__auto___33534,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async){
return (function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = ((function (__33529,c__30087__auto___33534,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async){
return (function (state_30652){
var state_val_30653 = (state_30652[(1)]);
if((state_val_30653 === (1))){
var state_30652__$1 = state_30652;
var statearr_30655_33536 = state_30652__$1;
(statearr_30655_33536[(2)] = null);

(statearr_30655_33536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30653 === (2))){
var state_30652__$1 = state_30652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30652__$1,(4),jobs);
} else {
if((state_val_30653 === (3))){
var inst_30649 = (state_30652[(2)]);
var state_30652__$1 = state_30652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30652__$1,inst_30649);
} else {
if((state_val_30653 === (4))){
var inst_30638 = (state_30652[(2)]);
var inst_30640 = process__$1(inst_30638);
var state_30652__$1 = state_30652;
if(cljs.core.truth_(inst_30640)){
var statearr_30657_33538 = state_30652__$1;
(statearr_30657_33538[(1)] = (5));

} else {
var statearr_30658_33541 = state_30652__$1;
(statearr_30658_33541[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30653 === (5))){
var state_30652__$1 = state_30652;
var statearr_30660_33547 = state_30652__$1;
(statearr_30660_33547[(2)] = null);

(statearr_30660_33547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30653 === (6))){
var state_30652__$1 = state_30652;
var statearr_30665_33548 = state_30652__$1;
(statearr_30665_33548[(2)] = null);

(statearr_30665_33548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30653 === (7))){
var inst_30647 = (state_30652[(2)]);
var state_30652__$1 = state_30652;
var statearr_30668_33551 = state_30652__$1;
(statearr_30668_33551[(2)] = inst_30647);

(statearr_30668_33551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33529,c__30087__auto___33534,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async))
;
return ((function (__33529,switch__29881__auto__,c__30087__auto___33534,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0 = (function (){
var statearr_30670 = [null,null,null,null,null,null,null];
(statearr_30670[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__);

(statearr_30670[(1)] = (1));

return statearr_30670;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1 = (function (state_30652){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_30652);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e30675){var ex__29885__auto__ = e30675;
var statearr_30677_33554 = state_30652;
(statearr_30677_33554[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_30652[(4)]))){
var statearr_30678_33557 = state_30652;
(statearr_30678_33557[(1)] = cljs.core.first((state_30652[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33560 = state_30652;
state_30652 = G__33560;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = function(state_30652){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1.call(this,state_30652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__;
})()
;})(__33529,switch__29881__auto__,c__30087__auto___33534,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async))
})();
var state__30089__auto__ = (function (){var statearr_30682 = f__30088__auto__();
(statearr_30682[(6)] = c__30087__auto___33534);

return statearr_30682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
});})(__33529,c__30087__auto___33534,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async))
);


break;
case "async":
var c__30087__auto___33561 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33529,c__30087__auto___33561,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async){
return (function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = ((function (__33529,c__30087__auto___33561,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async){
return (function (state_30704){
var state_val_30707 = (state_30704[(1)]);
if((state_val_30707 === (1))){
var state_30704__$1 = state_30704;
var statearr_30719_33562 = state_30704__$1;
(statearr_30719_33562[(2)] = null);

(statearr_30719_33562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30707 === (2))){
var state_30704__$1 = state_30704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30704__$1,(4),jobs);
} else {
if((state_val_30707 === (3))){
var inst_30702 = (state_30704[(2)]);
var state_30704__$1 = state_30704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30704__$1,inst_30702);
} else {
if((state_val_30707 === (4))){
var inst_30692 = (state_30704[(2)]);
var inst_30694 = async(inst_30692);
var state_30704__$1 = state_30704;
if(cljs.core.truth_(inst_30694)){
var statearr_30732_33571 = state_30704__$1;
(statearr_30732_33571[(1)] = (5));

} else {
var statearr_30738_33572 = state_30704__$1;
(statearr_30738_33572[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30707 === (5))){
var state_30704__$1 = state_30704;
var statearr_30740_33573 = state_30704__$1;
(statearr_30740_33573[(2)] = null);

(statearr_30740_33573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30707 === (6))){
var state_30704__$1 = state_30704;
var statearr_30742_33574 = state_30704__$1;
(statearr_30742_33574[(2)] = null);

(statearr_30742_33574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30707 === (7))){
var inst_30700 = (state_30704[(2)]);
var state_30704__$1 = state_30704;
var statearr_30743_33576 = state_30704__$1;
(statearr_30743_33576[(2)] = inst_30700);

(statearr_30743_33576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33529,c__30087__auto___33561,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async))
;
return ((function (__33529,switch__29881__auto__,c__30087__auto___33561,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0 = (function (){
var statearr_30748 = [null,null,null,null,null,null,null];
(statearr_30748[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__);

(statearr_30748[(1)] = (1));

return statearr_30748;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1 = (function (state_30704){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_30704);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e30751){var ex__29885__auto__ = e30751;
var statearr_30753_33578 = state_30704;
(statearr_30753_33578[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_30704[(4)]))){
var statearr_30754_33579 = state_30704;
(statearr_30754_33579[(1)] = cljs.core.first((state_30704[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33580 = state_30704;
state_30704 = G__33580;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = function(state_30704){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1.call(this,state_30704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__;
})()
;})(__33529,switch__29881__auto__,c__30087__auto___33561,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async))
})();
var state__30089__auto__ = (function (){var statearr_30758 = f__30088__auto__();
(statearr_30758[(6)] = c__30087__auto___33561);

return statearr_30758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
});})(__33529,c__30087__auto___33561,G__30633_33530,G__30633_33531__$1,n__5636__auto___33528,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30633_33531__$1)].join('')));

}

var G__33584 = (__33529 + (1));
__33529 = G__33584;
continue;
} else {
}
break;
}

var c__30087__auto___33585 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_30796){
var state_val_30797 = (state_30796[(1)]);
if((state_val_30797 === (7))){
var inst_30792 = (state_30796[(2)]);
var state_30796__$1 = state_30796;
var statearr_30822_33589 = state_30796__$1;
(statearr_30822_33589[(2)] = inst_30792);

(statearr_30822_33589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30797 === (1))){
var state_30796__$1 = state_30796;
var statearr_30828_33590 = state_30796__$1;
(statearr_30828_33590[(2)] = null);

(statearr_30828_33590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30797 === (4))){
var inst_30769 = (state_30796[(7)]);
var inst_30769__$1 = (state_30796[(2)]);
var inst_30770 = (inst_30769__$1 == null);
var state_30796__$1 = (function (){var statearr_30829 = state_30796;
(statearr_30829[(7)] = inst_30769__$1);

return statearr_30829;
})();
if(cljs.core.truth_(inst_30770)){
var statearr_30830_33600 = state_30796__$1;
(statearr_30830_33600[(1)] = (5));

} else {
var statearr_30831_33602 = state_30796__$1;
(statearr_30831_33602[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30797 === (6))){
var inst_30769 = (state_30796[(7)]);
var inst_30778 = (state_30796[(8)]);
var inst_30778__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_30781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30782 = [inst_30769,inst_30778__$1];
var inst_30783 = (new cljs.core.PersistentVector(null,2,(5),inst_30781,inst_30782,null));
var state_30796__$1 = (function (){var statearr_30832 = state_30796;
(statearr_30832[(8)] = inst_30778__$1);

return statearr_30832;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30796__$1,(8),jobs,inst_30783);
} else {
if((state_val_30797 === (3))){
var inst_30794 = (state_30796[(2)]);
var state_30796__$1 = state_30796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30796__$1,inst_30794);
} else {
if((state_val_30797 === (2))){
var state_30796__$1 = state_30796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30796__$1,(4),from);
} else {
if((state_val_30797 === (9))){
var inst_30787 = (state_30796[(2)]);
var state_30796__$1 = (function (){var statearr_30834 = state_30796;
(statearr_30834[(9)] = inst_30787);

return statearr_30834;
})();
var statearr_30835_33603 = state_30796__$1;
(statearr_30835_33603[(2)] = null);

(statearr_30835_33603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30797 === (5))){
var inst_30774 = cljs.core.async.close_BANG_(jobs);
var state_30796__$1 = state_30796;
var statearr_30836_33604 = state_30796__$1;
(statearr_30836_33604[(2)] = inst_30774);

(statearr_30836_33604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30797 === (8))){
var inst_30778 = (state_30796[(8)]);
var inst_30785 = (state_30796[(2)]);
var state_30796__$1 = (function (){var statearr_30837 = state_30796;
(statearr_30837[(10)] = inst_30785);

return statearr_30837;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30796__$1,(9),results,inst_30778);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0 = (function (){
var statearr_30848 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30848[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__);

(statearr_30848[(1)] = (1));

return statearr_30848;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1 = (function (state_30796){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_30796);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e30853){var ex__29885__auto__ = e30853;
var statearr_30856_33612 = state_30796;
(statearr_30856_33612[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_30796[(4)]))){
var statearr_30859_33617 = state_30796;
(statearr_30859_33617[(1)] = cljs.core.first((state_30796[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33618 = state_30796;
state_30796 = G__33618;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = function(state_30796){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1.call(this,state_30796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_30862 = f__30088__auto__();
(statearr_30862[(6)] = c__30087__auto___33585);

return statearr_30862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


var c__30087__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_30902){
var state_val_30903 = (state_30902[(1)]);
if((state_val_30903 === (7))){
var inst_30898 = (state_30902[(2)]);
var state_30902__$1 = state_30902;
var statearr_30905_33619 = state_30902__$1;
(statearr_30905_33619[(2)] = inst_30898);

(statearr_30905_33619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (20))){
var state_30902__$1 = state_30902;
var statearr_30906_33620 = state_30902__$1;
(statearr_30906_33620[(2)] = null);

(statearr_30906_33620[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (1))){
var state_30902__$1 = state_30902;
var statearr_30907_33624 = state_30902__$1;
(statearr_30907_33624[(2)] = null);

(statearr_30907_33624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (4))){
var inst_30866 = (state_30902[(7)]);
var inst_30866__$1 = (state_30902[(2)]);
var inst_30868 = (inst_30866__$1 == null);
var state_30902__$1 = (function (){var statearr_30909 = state_30902;
(statearr_30909[(7)] = inst_30866__$1);

return statearr_30909;
})();
if(cljs.core.truth_(inst_30868)){
var statearr_30911_33628 = state_30902__$1;
(statearr_30911_33628[(1)] = (5));

} else {
var statearr_30912_33632 = state_30902__$1;
(statearr_30912_33632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (15))){
var inst_30880 = (state_30902[(8)]);
var state_30902__$1 = state_30902;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30902__$1,(18),to,inst_30880);
} else {
if((state_val_30903 === (21))){
var inst_30893 = (state_30902[(2)]);
var state_30902__$1 = state_30902;
var statearr_30913_33637 = state_30902__$1;
(statearr_30913_33637[(2)] = inst_30893);

(statearr_30913_33637[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (13))){
var inst_30895 = (state_30902[(2)]);
var state_30902__$1 = (function (){var statearr_30914 = state_30902;
(statearr_30914[(9)] = inst_30895);

return statearr_30914;
})();
var statearr_30916_33644 = state_30902__$1;
(statearr_30916_33644[(2)] = null);

(statearr_30916_33644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (6))){
var inst_30866 = (state_30902[(7)]);
var state_30902__$1 = state_30902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30902__$1,(11),inst_30866);
} else {
if((state_val_30903 === (17))){
var inst_30888 = (state_30902[(2)]);
var state_30902__$1 = state_30902;
if(cljs.core.truth_(inst_30888)){
var statearr_30917_33647 = state_30902__$1;
(statearr_30917_33647[(1)] = (19));

} else {
var statearr_30918_33648 = state_30902__$1;
(statearr_30918_33648[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (3))){
var inst_30900 = (state_30902[(2)]);
var state_30902__$1 = state_30902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30902__$1,inst_30900);
} else {
if((state_val_30903 === (12))){
var inst_30877 = (state_30902[(10)]);
var state_30902__$1 = state_30902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30902__$1,(14),inst_30877);
} else {
if((state_val_30903 === (2))){
var state_30902__$1 = state_30902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30902__$1,(4),results);
} else {
if((state_val_30903 === (19))){
var state_30902__$1 = state_30902;
var statearr_30919_33659 = state_30902__$1;
(statearr_30919_33659[(2)] = null);

(statearr_30919_33659[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (11))){
var inst_30877 = (state_30902[(2)]);
var state_30902__$1 = (function (){var statearr_30920 = state_30902;
(statearr_30920[(10)] = inst_30877);

return statearr_30920;
})();
var statearr_30921_33663 = state_30902__$1;
(statearr_30921_33663[(2)] = null);

(statearr_30921_33663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (9))){
var state_30902__$1 = state_30902;
var statearr_30922_33665 = state_30902__$1;
(statearr_30922_33665[(2)] = null);

(statearr_30922_33665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (5))){
var state_30902__$1 = state_30902;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30923_33672 = state_30902__$1;
(statearr_30923_33672[(1)] = (8));

} else {
var statearr_30924_33673 = state_30902__$1;
(statearr_30924_33673[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (14))){
var inst_30880 = (state_30902[(8)]);
var inst_30882 = (state_30902[(11)]);
var inst_30880__$1 = (state_30902[(2)]);
var inst_30881 = (inst_30880__$1 == null);
var inst_30882__$1 = cljs.core.not(inst_30881);
var state_30902__$1 = (function (){var statearr_30931 = state_30902;
(statearr_30931[(8)] = inst_30880__$1);

(statearr_30931[(11)] = inst_30882__$1);

return statearr_30931;
})();
if(inst_30882__$1){
var statearr_30932_33688 = state_30902__$1;
(statearr_30932_33688[(1)] = (15));

} else {
var statearr_30933_33689 = state_30902__$1;
(statearr_30933_33689[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (16))){
var inst_30882 = (state_30902[(11)]);
var state_30902__$1 = state_30902;
var statearr_30935_33696 = state_30902__$1;
(statearr_30935_33696[(2)] = inst_30882);

(statearr_30935_33696[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (10))){
var inst_30874 = (state_30902[(2)]);
var state_30902__$1 = state_30902;
var statearr_30947_33701 = state_30902__$1;
(statearr_30947_33701[(2)] = inst_30874);

(statearr_30947_33701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (18))){
var inst_30885 = (state_30902[(2)]);
var state_30902__$1 = state_30902;
var statearr_30952_33702 = state_30902__$1;
(statearr_30952_33702[(2)] = inst_30885);

(statearr_30952_33702[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30903 === (8))){
var inst_30871 = cljs.core.async.close_BANG_(to);
var state_30902__$1 = state_30902;
var statearr_30953_33703 = state_30902__$1;
(statearr_30953_33703[(2)] = inst_30871);

(statearr_30953_33703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0 = (function (){
var statearr_30958 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30958[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__);

(statearr_30958[(1)] = (1));

return statearr_30958;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1 = (function (state_30902){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_30902);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e30962){var ex__29885__auto__ = e30962;
var statearr_30963_33709 = state_30902;
(statearr_30963_33709[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_30902[(4)]))){
var statearr_30964_33713 = state_30902;
(statearr_30964_33713[(1)] = cljs.core.first((state_30902[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33714 = state_30902;
state_30902 = G__33714;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__ = function(state_30902){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1.call(this,state_30902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29882__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_30967 = f__30088__auto__();
(statearr_30967[(6)] = c__30087__auto__);

return statearr_30967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

return c__30087__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__30973 = arguments.length;
switch (G__30973) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__30988 = arguments.length;
switch (G__30988) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31002 = arguments.length;
switch (G__31002) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30087__auto___33734 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_31036){
var state_val_31037 = (state_31036[(1)]);
if((state_val_31037 === (7))){
var inst_31032 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
var statearr_31043_33738 = state_31036__$1;
(statearr_31043_33738[(2)] = inst_31032);

(statearr_31043_33738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (1))){
var state_31036__$1 = state_31036;
var statearr_31044_33739 = state_31036__$1;
(statearr_31044_33739[(2)] = null);

(statearr_31044_33739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (4))){
var inst_31013 = (state_31036[(7)]);
var inst_31013__$1 = (state_31036[(2)]);
var inst_31014 = (inst_31013__$1 == null);
var state_31036__$1 = (function (){var statearr_31045 = state_31036;
(statearr_31045[(7)] = inst_31013__$1);

return statearr_31045;
})();
if(cljs.core.truth_(inst_31014)){
var statearr_31046_33743 = state_31036__$1;
(statearr_31046_33743[(1)] = (5));

} else {
var statearr_31050_33745 = state_31036__$1;
(statearr_31050_33745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (13))){
var state_31036__$1 = state_31036;
var statearr_31051_33746 = state_31036__$1;
(statearr_31051_33746[(2)] = null);

(statearr_31051_33746[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (6))){
var inst_31013 = (state_31036[(7)]);
var inst_31019 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31013) : p.call(null,inst_31013));
var state_31036__$1 = state_31036;
if(cljs.core.truth_(inst_31019)){
var statearr_31053_33747 = state_31036__$1;
(statearr_31053_33747[(1)] = (9));

} else {
var statearr_31054_33748 = state_31036__$1;
(statearr_31054_33748[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (3))){
var inst_31034 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31036__$1,inst_31034);
} else {
if((state_val_31037 === (12))){
var state_31036__$1 = state_31036;
var statearr_31058_33752 = state_31036__$1;
(statearr_31058_33752[(2)] = null);

(statearr_31058_33752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (2))){
var state_31036__$1 = state_31036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31036__$1,(4),ch);
} else {
if((state_val_31037 === (11))){
var inst_31013 = (state_31036[(7)]);
var inst_31023 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31036__$1,(8),inst_31023,inst_31013);
} else {
if((state_val_31037 === (9))){
var state_31036__$1 = state_31036;
var statearr_31059_33753 = state_31036__$1;
(statearr_31059_33753[(2)] = tc);

(statearr_31059_33753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (5))){
var inst_31016 = cljs.core.async.close_BANG_(tc);
var inst_31017 = cljs.core.async.close_BANG_(fc);
var state_31036__$1 = (function (){var statearr_31060 = state_31036;
(statearr_31060[(8)] = inst_31016);

return statearr_31060;
})();
var statearr_31061_33754 = state_31036__$1;
(statearr_31061_33754[(2)] = inst_31017);

(statearr_31061_33754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (14))){
var inst_31030 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
var statearr_31063_33756 = state_31036__$1;
(statearr_31063_33756[(2)] = inst_31030);

(statearr_31063_33756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (10))){
var state_31036__$1 = state_31036;
var statearr_31064_33760 = state_31036__$1;
(statearr_31064_33760[(2)] = fc);

(statearr_31064_33760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31037 === (8))){
var inst_31025 = (state_31036[(2)]);
var state_31036__$1 = state_31036;
if(cljs.core.truth_(inst_31025)){
var statearr_31065_33762 = state_31036__$1;
(statearr_31065_33762[(1)] = (12));

} else {
var statearr_31066_33763 = state_31036__$1;
(statearr_31066_33763[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_31067 = [null,null,null,null,null,null,null,null,null];
(statearr_31067[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_31067[(1)] = (1));

return statearr_31067;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_31036){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_31036);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e31068){var ex__29885__auto__ = e31068;
var statearr_31069_33765 = state_31036;
(statearr_31069_33765[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_31036[(4)]))){
var statearr_31070_33766 = state_31036;
(statearr_31070_33766[(1)] = cljs.core.first((state_31036[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33767 = state_31036;
state_31036 = G__33767;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_31036){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_31036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_31073 = f__30088__auto__();
(statearr_31073[(6)] = c__30087__auto___33734);

return statearr_31073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30087__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_31096){
var state_val_31097 = (state_31096[(1)]);
if((state_val_31097 === (7))){
var inst_31092 = (state_31096[(2)]);
var state_31096__$1 = state_31096;
var statearr_31099_33768 = state_31096__$1;
(statearr_31099_33768[(2)] = inst_31092);

(statearr_31099_33768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (1))){
var inst_31074 = init;
var inst_31075 = inst_31074;
var state_31096__$1 = (function (){var statearr_31100 = state_31096;
(statearr_31100[(7)] = inst_31075);

return statearr_31100;
})();
var statearr_31102_33769 = state_31096__$1;
(statearr_31102_33769[(2)] = null);

(statearr_31102_33769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (4))){
var inst_31078 = (state_31096[(8)]);
var inst_31078__$1 = (state_31096[(2)]);
var inst_31079 = (inst_31078__$1 == null);
var state_31096__$1 = (function (){var statearr_31103 = state_31096;
(statearr_31103[(8)] = inst_31078__$1);

return statearr_31103;
})();
if(cljs.core.truth_(inst_31079)){
var statearr_31104_33770 = state_31096__$1;
(statearr_31104_33770[(1)] = (5));

} else {
var statearr_31105_33771 = state_31096__$1;
(statearr_31105_33771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (6))){
var inst_31075 = (state_31096[(7)]);
var inst_31078 = (state_31096[(8)]);
var inst_31082 = (state_31096[(9)]);
var inst_31082__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31075,inst_31078) : f.call(null,inst_31075,inst_31078));
var inst_31083 = cljs.core.reduced_QMARK_(inst_31082__$1);
var state_31096__$1 = (function (){var statearr_31106 = state_31096;
(statearr_31106[(9)] = inst_31082__$1);

return statearr_31106;
})();
if(inst_31083){
var statearr_31108_33774 = state_31096__$1;
(statearr_31108_33774[(1)] = (8));

} else {
var statearr_31111_33775 = state_31096__$1;
(statearr_31111_33775[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (3))){
var inst_31094 = (state_31096[(2)]);
var state_31096__$1 = state_31096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31096__$1,inst_31094);
} else {
if((state_val_31097 === (2))){
var state_31096__$1 = state_31096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31096__$1,(4),ch);
} else {
if((state_val_31097 === (9))){
var inst_31082 = (state_31096[(9)]);
var inst_31075 = inst_31082;
var state_31096__$1 = (function (){var statearr_31112 = state_31096;
(statearr_31112[(7)] = inst_31075);

return statearr_31112;
})();
var statearr_31113_33776 = state_31096__$1;
(statearr_31113_33776[(2)] = null);

(statearr_31113_33776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (5))){
var inst_31075 = (state_31096[(7)]);
var state_31096__$1 = state_31096;
var statearr_31114_33778 = state_31096__$1;
(statearr_31114_33778[(2)] = inst_31075);

(statearr_31114_33778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (10))){
var inst_31090 = (state_31096[(2)]);
var state_31096__$1 = state_31096;
var statearr_31115_33779 = state_31096__$1;
(statearr_31115_33779[(2)] = inst_31090);

(statearr_31115_33779[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31097 === (8))){
var inst_31082 = (state_31096[(9)]);
var inst_31086 = cljs.core.deref(inst_31082);
var state_31096__$1 = state_31096;
var statearr_31117_33784 = state_31096__$1;
(statearr_31117_33784[(2)] = inst_31086);

(statearr_31117_33784[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__29882__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29882__auto____0 = (function (){
var statearr_31118 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31118[(0)] = cljs$core$async$reduce_$_state_machine__29882__auto__);

(statearr_31118[(1)] = (1));

return statearr_31118;
});
var cljs$core$async$reduce_$_state_machine__29882__auto____1 = (function (state_31096){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_31096);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e31119){var ex__29885__auto__ = e31119;
var statearr_31120_33797 = state_31096;
(statearr_31120_33797[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_31096[(4)]))){
var statearr_31121_33802 = state_31096;
(statearr_31121_33802[(1)] = cljs.core.first((state_31096[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33804 = state_31096;
state_31096 = G__33804;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29882__auto__ = function(state_31096){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29882__auto____1.call(this,state_31096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29882__auto____0;
cljs$core$async$reduce_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29882__auto____1;
return cljs$core$async$reduce_$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_31122 = f__30088__auto__();
(statearr_31122[(6)] = c__30087__auto__);

return statearr_31122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

return c__30087__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30087__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_31133){
var state_val_31134 = (state_31133[(1)]);
if((state_val_31134 === (1))){
var inst_31126 = cljs.core.async.reduce(f__$1,init,ch);
var state_31133__$1 = state_31133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31133__$1,(2),inst_31126);
} else {
if((state_val_31134 === (2))){
var inst_31128 = (state_31133[(2)]);
var inst_31130 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31128) : f__$1.call(null,inst_31128));
var state_31133__$1 = state_31133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31133__$1,inst_31130);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__29882__auto__ = null;
var cljs$core$async$transduce_$_state_machine__29882__auto____0 = (function (){
var statearr_31138 = [null,null,null,null,null,null,null];
(statearr_31138[(0)] = cljs$core$async$transduce_$_state_machine__29882__auto__);

(statearr_31138[(1)] = (1));

return statearr_31138;
});
var cljs$core$async$transduce_$_state_machine__29882__auto____1 = (function (state_31133){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_31133);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e31139){var ex__29885__auto__ = e31139;
var statearr_31143_33810 = state_31133;
(statearr_31143_33810[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_31133[(4)]))){
var statearr_31145_33811 = state_31133;
(statearr_31145_33811[(1)] = cljs.core.first((state_31133[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33812 = state_31133;
state_31133 = G__33812;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__29882__auto__ = function(state_31133){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__29882__auto____1.call(this,state_31133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__29882__auto____0;
cljs$core$async$transduce_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__29882__auto____1;
return cljs$core$async$transduce_$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_31147 = f__30088__auto__();
(statearr_31147[(6)] = c__30087__auto__);

return statearr_31147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

return c__30087__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31153 = arguments.length;
switch (G__31153) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30087__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_31179){
var state_val_31180 = (state_31179[(1)]);
if((state_val_31180 === (7))){
var inst_31161 = (state_31179[(2)]);
var state_31179__$1 = state_31179;
var statearr_31183_33825 = state_31179__$1;
(statearr_31183_33825[(2)] = inst_31161);

(statearr_31183_33825[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (1))){
var inst_31155 = cljs.core.seq(coll);
var inst_31156 = inst_31155;
var state_31179__$1 = (function (){var statearr_31190 = state_31179;
(statearr_31190[(7)] = inst_31156);

return statearr_31190;
})();
var statearr_31193_33828 = state_31179__$1;
(statearr_31193_33828[(2)] = null);

(statearr_31193_33828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (4))){
var inst_31156 = (state_31179[(7)]);
var inst_31159 = cljs.core.first(inst_31156);
var state_31179__$1 = state_31179;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31179__$1,(7),ch,inst_31159);
} else {
if((state_val_31180 === (13))){
var inst_31173 = (state_31179[(2)]);
var state_31179__$1 = state_31179;
var statearr_31195_33835 = state_31179__$1;
(statearr_31195_33835[(2)] = inst_31173);

(statearr_31195_33835[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (6))){
var inst_31164 = (state_31179[(2)]);
var state_31179__$1 = state_31179;
if(cljs.core.truth_(inst_31164)){
var statearr_31198_33838 = state_31179__$1;
(statearr_31198_33838[(1)] = (8));

} else {
var statearr_31200_33840 = state_31179__$1;
(statearr_31200_33840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (3))){
var inst_31177 = (state_31179[(2)]);
var state_31179__$1 = state_31179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31179__$1,inst_31177);
} else {
if((state_val_31180 === (12))){
var state_31179__$1 = state_31179;
var statearr_31205_33842 = state_31179__$1;
(statearr_31205_33842[(2)] = null);

(statearr_31205_33842[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (2))){
var inst_31156 = (state_31179[(7)]);
var state_31179__$1 = state_31179;
if(cljs.core.truth_(inst_31156)){
var statearr_31206_33844 = state_31179__$1;
(statearr_31206_33844[(1)] = (4));

} else {
var statearr_31207_33846 = state_31179__$1;
(statearr_31207_33846[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (11))){
var inst_31170 = cljs.core.async.close_BANG_(ch);
var state_31179__$1 = state_31179;
var statearr_31210_33850 = state_31179__$1;
(statearr_31210_33850[(2)] = inst_31170);

(statearr_31210_33850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (9))){
var state_31179__$1 = state_31179;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31221_33851 = state_31179__$1;
(statearr_31221_33851[(1)] = (11));

} else {
var statearr_31222_33852 = state_31179__$1;
(statearr_31222_33852[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (5))){
var inst_31156 = (state_31179[(7)]);
var state_31179__$1 = state_31179;
var statearr_31224_33853 = state_31179__$1;
(statearr_31224_33853[(2)] = inst_31156);

(statearr_31224_33853[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (10))){
var inst_31175 = (state_31179[(2)]);
var state_31179__$1 = state_31179;
var statearr_31225_33868 = state_31179__$1;
(statearr_31225_33868[(2)] = inst_31175);

(statearr_31225_33868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31180 === (8))){
var inst_31156 = (state_31179[(7)]);
var inst_31166 = cljs.core.next(inst_31156);
var inst_31156__$1 = inst_31166;
var state_31179__$1 = (function (){var statearr_31228 = state_31179;
(statearr_31228[(7)] = inst_31156__$1);

return statearr_31228;
})();
var statearr_31231_33871 = state_31179__$1;
(statearr_31231_33871[(2)] = null);

(statearr_31231_33871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_31234 = [null,null,null,null,null,null,null,null];
(statearr_31234[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_31234[(1)] = (1));

return statearr_31234;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_31179){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_31179);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e31237){var ex__29885__auto__ = e31237;
var statearr_31238_33875 = state_31179;
(statearr_31238_33875[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_31179[(4)]))){
var statearr_31239_33877 = state_31179;
(statearr_31239_33877[(1)] = cljs.core.first((state_31179[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33885 = state_31179;
state_31179 = G__33885;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_31179){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_31179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_31247 = f__30088__auto__();
(statearr_31247[(6)] = c__30087__auto__);

return statearr_31247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

return c__30087__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31251 = arguments.length;
switch (G__31251) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33910 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33910(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33912 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33912(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33913 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33913(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33914 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33914(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31293 = (function (ch,cs,meta31294){
this.ch = ch;
this.cs = cs;
this.meta31294 = meta31294;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31295,meta31294__$1){
var self__ = this;
var _31295__$1 = this;
return (new cljs.core.async.t_cljs$core$async31293(self__.ch,self__.cs,meta31294__$1));
}));

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31295){
var self__ = this;
var _31295__$1 = this;
return self__.meta31294;
}));

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31293.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31293.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31294","meta31294",-1438878336,null)], null);
}));

(cljs.core.async.t_cljs$core$async31293.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31293.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31293");

(cljs.core.async.t_cljs$core$async31293.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31293");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31293.
 */
cljs.core.async.__GT_t_cljs$core$async31293 = (function cljs$core$async$__GT_t_cljs$core$async31293(ch,cs,meta31294){
return (new cljs.core.async.t_cljs$core$async31293(ch,cs,meta31294));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async31293(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30087__auto___33931 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_31444){
var state_val_31445 = (state_31444[(1)]);
if((state_val_31445 === (7))){
var inst_31439 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31446_33938 = state_31444__$1;
(statearr_31446_33938[(2)] = inst_31439);

(statearr_31446_33938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (20))){
var inst_31336 = (state_31444[(7)]);
var inst_31350 = cljs.core.first(inst_31336);
var inst_31351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(0),null);
var inst_31352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31350,(1),null);
var state_31444__$1 = (function (){var statearr_31447 = state_31444;
(statearr_31447[(8)] = inst_31351);

return statearr_31447;
})();
if(cljs.core.truth_(inst_31352)){
var statearr_31448_33939 = state_31444__$1;
(statearr_31448_33939[(1)] = (22));

} else {
var statearr_31449_33940 = state_31444__$1;
(statearr_31449_33940[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (27))){
var inst_31381 = (state_31444[(9)]);
var inst_31383 = (state_31444[(10)]);
var inst_31388 = (state_31444[(11)]);
var inst_31300 = (state_31444[(12)]);
var inst_31388__$1 = cljs.core._nth(inst_31381,inst_31383);
var inst_31389 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31388__$1,inst_31300,done);
var state_31444__$1 = (function (){var statearr_31451 = state_31444;
(statearr_31451[(11)] = inst_31388__$1);

return statearr_31451;
})();
if(cljs.core.truth_(inst_31389)){
var statearr_31452_33946 = state_31444__$1;
(statearr_31452_33946[(1)] = (30));

} else {
var statearr_31453_33947 = state_31444__$1;
(statearr_31453_33947[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (1))){
var state_31444__$1 = state_31444;
var statearr_31454_33950 = state_31444__$1;
(statearr_31454_33950[(2)] = null);

(statearr_31454_33950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (24))){
var inst_31336 = (state_31444[(7)]);
var inst_31357 = (state_31444[(2)]);
var inst_31358 = cljs.core.next(inst_31336);
var inst_31310 = inst_31358;
var inst_31311 = null;
var inst_31312 = (0);
var inst_31313 = (0);
var state_31444__$1 = (function (){var statearr_31455 = state_31444;
(statearr_31455[(13)] = inst_31357);

(statearr_31455[(14)] = inst_31310);

(statearr_31455[(15)] = inst_31311);

(statearr_31455[(16)] = inst_31312);

(statearr_31455[(17)] = inst_31313);

return statearr_31455;
})();
var statearr_31456_33952 = state_31444__$1;
(statearr_31456_33952[(2)] = null);

(statearr_31456_33952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (39))){
var state_31444__$1 = state_31444;
var statearr_31461_33954 = state_31444__$1;
(statearr_31461_33954[(2)] = null);

(statearr_31461_33954[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (4))){
var inst_31300 = (state_31444[(12)]);
var inst_31300__$1 = (state_31444[(2)]);
var inst_31301 = (inst_31300__$1 == null);
var state_31444__$1 = (function (){var statearr_31465 = state_31444;
(statearr_31465[(12)] = inst_31300__$1);

return statearr_31465;
})();
if(cljs.core.truth_(inst_31301)){
var statearr_31467_33962 = state_31444__$1;
(statearr_31467_33962[(1)] = (5));

} else {
var statearr_31468_33963 = state_31444__$1;
(statearr_31468_33963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (15))){
var inst_31313 = (state_31444[(17)]);
var inst_31310 = (state_31444[(14)]);
var inst_31311 = (state_31444[(15)]);
var inst_31312 = (state_31444[(16)]);
var inst_31328 = (state_31444[(2)]);
var inst_31329 = (inst_31313 + (1));
var tmp31458 = inst_31310;
var tmp31459 = inst_31312;
var tmp31460 = inst_31311;
var inst_31310__$1 = tmp31458;
var inst_31311__$1 = tmp31460;
var inst_31312__$1 = tmp31459;
var inst_31313__$1 = inst_31329;
var state_31444__$1 = (function (){var statearr_31476 = state_31444;
(statearr_31476[(18)] = inst_31328);

(statearr_31476[(14)] = inst_31310__$1);

(statearr_31476[(15)] = inst_31311__$1);

(statearr_31476[(16)] = inst_31312__$1);

(statearr_31476[(17)] = inst_31313__$1);

return statearr_31476;
})();
var statearr_31477_33970 = state_31444__$1;
(statearr_31477_33970[(2)] = null);

(statearr_31477_33970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (21))){
var inst_31361 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31481_33971 = state_31444__$1;
(statearr_31481_33971[(2)] = inst_31361);

(statearr_31481_33971[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (31))){
var inst_31388 = (state_31444[(11)]);
var inst_31392 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31388);
var state_31444__$1 = state_31444;
var statearr_31483_33972 = state_31444__$1;
(statearr_31483_33972[(2)] = inst_31392);

(statearr_31483_33972[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (32))){
var inst_31383 = (state_31444[(10)]);
var inst_31380 = (state_31444[(19)]);
var inst_31381 = (state_31444[(9)]);
var inst_31382 = (state_31444[(20)]);
var inst_31395 = (state_31444[(2)]);
var inst_31396 = (inst_31383 + (1));
var tmp31478 = inst_31380;
var tmp31479 = inst_31381;
var tmp31480 = inst_31382;
var inst_31380__$1 = tmp31478;
var inst_31381__$1 = tmp31479;
var inst_31382__$1 = tmp31480;
var inst_31383__$1 = inst_31396;
var state_31444__$1 = (function (){var statearr_31485 = state_31444;
(statearr_31485[(21)] = inst_31395);

(statearr_31485[(19)] = inst_31380__$1);

(statearr_31485[(9)] = inst_31381__$1);

(statearr_31485[(20)] = inst_31382__$1);

(statearr_31485[(10)] = inst_31383__$1);

return statearr_31485;
})();
var statearr_31487_33991 = state_31444__$1;
(statearr_31487_33991[(2)] = null);

(statearr_31487_33991[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (40))){
var inst_31408 = (state_31444[(22)]);
var inst_31412 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31408);
var state_31444__$1 = state_31444;
var statearr_31491_33992 = state_31444__$1;
(statearr_31491_33992[(2)] = inst_31412);

(statearr_31491_33992[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (33))){
var inst_31399 = (state_31444[(23)]);
var inst_31401 = cljs.core.chunked_seq_QMARK_(inst_31399);
var state_31444__$1 = state_31444;
if(inst_31401){
var statearr_31493_33997 = state_31444__$1;
(statearr_31493_33997[(1)] = (36));

} else {
var statearr_31494_33998 = state_31444__$1;
(statearr_31494_33998[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (13))){
var inst_31322 = (state_31444[(24)]);
var inst_31325 = cljs.core.async.close_BANG_(inst_31322);
var state_31444__$1 = state_31444;
var statearr_31499_33999 = state_31444__$1;
(statearr_31499_33999[(2)] = inst_31325);

(statearr_31499_33999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (22))){
var inst_31351 = (state_31444[(8)]);
var inst_31354 = cljs.core.async.close_BANG_(inst_31351);
var state_31444__$1 = state_31444;
var statearr_31501_34001 = state_31444__$1;
(statearr_31501_34001[(2)] = inst_31354);

(statearr_31501_34001[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (36))){
var inst_31399 = (state_31444[(23)]);
var inst_31403 = cljs.core.chunk_first(inst_31399);
var inst_31404 = cljs.core.chunk_rest(inst_31399);
var inst_31405 = cljs.core.count(inst_31403);
var inst_31380 = inst_31404;
var inst_31381 = inst_31403;
var inst_31382 = inst_31405;
var inst_31383 = (0);
var state_31444__$1 = (function (){var statearr_31502 = state_31444;
(statearr_31502[(19)] = inst_31380);

(statearr_31502[(9)] = inst_31381);

(statearr_31502[(20)] = inst_31382);

(statearr_31502[(10)] = inst_31383);

return statearr_31502;
})();
var statearr_31504_34009 = state_31444__$1;
(statearr_31504_34009[(2)] = null);

(statearr_31504_34009[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (41))){
var inst_31399 = (state_31444[(23)]);
var inst_31415 = (state_31444[(2)]);
var inst_31416 = cljs.core.next(inst_31399);
var inst_31380 = inst_31416;
var inst_31381 = null;
var inst_31382 = (0);
var inst_31383 = (0);
var state_31444__$1 = (function (){var statearr_31506 = state_31444;
(statearr_31506[(25)] = inst_31415);

(statearr_31506[(19)] = inst_31380);

(statearr_31506[(9)] = inst_31381);

(statearr_31506[(20)] = inst_31382);

(statearr_31506[(10)] = inst_31383);

return statearr_31506;
})();
var statearr_31510_34011 = state_31444__$1;
(statearr_31510_34011[(2)] = null);

(statearr_31510_34011[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (43))){
var state_31444__$1 = state_31444;
var statearr_31512_34012 = state_31444__$1;
(statearr_31512_34012[(2)] = null);

(statearr_31512_34012[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (29))){
var inst_31427 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31514_34013 = state_31444__$1;
(statearr_31514_34013[(2)] = inst_31427);

(statearr_31514_34013[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (44))){
var inst_31436 = (state_31444[(2)]);
var state_31444__$1 = (function (){var statearr_31518 = state_31444;
(statearr_31518[(26)] = inst_31436);

return statearr_31518;
})();
var statearr_31519_34016 = state_31444__$1;
(statearr_31519_34016[(2)] = null);

(statearr_31519_34016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (6))){
var inst_31371 = (state_31444[(27)]);
var inst_31370 = cljs.core.deref(cs);
var inst_31371__$1 = cljs.core.keys(inst_31370);
var inst_31372 = cljs.core.count(inst_31371__$1);
var inst_31373 = cljs.core.reset_BANG_(dctr,inst_31372);
var inst_31379 = cljs.core.seq(inst_31371__$1);
var inst_31380 = inst_31379;
var inst_31381 = null;
var inst_31382 = (0);
var inst_31383 = (0);
var state_31444__$1 = (function (){var statearr_31521 = state_31444;
(statearr_31521[(27)] = inst_31371__$1);

(statearr_31521[(28)] = inst_31373);

(statearr_31521[(19)] = inst_31380);

(statearr_31521[(9)] = inst_31381);

(statearr_31521[(20)] = inst_31382);

(statearr_31521[(10)] = inst_31383);

return statearr_31521;
})();
var statearr_31522_34021 = state_31444__$1;
(statearr_31522_34021[(2)] = null);

(statearr_31522_34021[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (28))){
var inst_31380 = (state_31444[(19)]);
var inst_31399 = (state_31444[(23)]);
var inst_31399__$1 = cljs.core.seq(inst_31380);
var state_31444__$1 = (function (){var statearr_31523 = state_31444;
(statearr_31523[(23)] = inst_31399__$1);

return statearr_31523;
})();
if(inst_31399__$1){
var statearr_31524_34027 = state_31444__$1;
(statearr_31524_34027[(1)] = (33));

} else {
var statearr_31525_34028 = state_31444__$1;
(statearr_31525_34028[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (25))){
var inst_31383 = (state_31444[(10)]);
var inst_31382 = (state_31444[(20)]);
var inst_31385 = (inst_31383 < inst_31382);
var inst_31386 = inst_31385;
var state_31444__$1 = state_31444;
if(cljs.core.truth_(inst_31386)){
var statearr_31526_34029 = state_31444__$1;
(statearr_31526_34029[(1)] = (27));

} else {
var statearr_31527_34030 = state_31444__$1;
(statearr_31527_34030[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (34))){
var state_31444__$1 = state_31444;
var statearr_31528_34031 = state_31444__$1;
(statearr_31528_34031[(2)] = null);

(statearr_31528_34031[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (17))){
var state_31444__$1 = state_31444;
var statearr_31529_34036 = state_31444__$1;
(statearr_31529_34036[(2)] = null);

(statearr_31529_34036[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (3))){
var inst_31441 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31444__$1,inst_31441);
} else {
if((state_val_31445 === (12))){
var inst_31366 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31530_34046 = state_31444__$1;
(statearr_31530_34046[(2)] = inst_31366);

(statearr_31530_34046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (2))){
var state_31444__$1 = state_31444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31444__$1,(4),ch);
} else {
if((state_val_31445 === (23))){
var state_31444__$1 = state_31444;
var statearr_31532_34050 = state_31444__$1;
(statearr_31532_34050[(2)] = null);

(statearr_31532_34050[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (35))){
var inst_31425 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31533_34051 = state_31444__$1;
(statearr_31533_34051[(2)] = inst_31425);

(statearr_31533_34051[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (19))){
var inst_31336 = (state_31444[(7)]);
var inst_31340 = cljs.core.chunk_first(inst_31336);
var inst_31342 = cljs.core.chunk_rest(inst_31336);
var inst_31343 = cljs.core.count(inst_31340);
var inst_31310 = inst_31342;
var inst_31311 = inst_31340;
var inst_31312 = inst_31343;
var inst_31313 = (0);
var state_31444__$1 = (function (){var statearr_31534 = state_31444;
(statearr_31534[(14)] = inst_31310);

(statearr_31534[(15)] = inst_31311);

(statearr_31534[(16)] = inst_31312);

(statearr_31534[(17)] = inst_31313);

return statearr_31534;
})();
var statearr_31535_34053 = state_31444__$1;
(statearr_31535_34053[(2)] = null);

(statearr_31535_34053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (11))){
var inst_31310 = (state_31444[(14)]);
var inst_31336 = (state_31444[(7)]);
var inst_31336__$1 = cljs.core.seq(inst_31310);
var state_31444__$1 = (function (){var statearr_31536 = state_31444;
(statearr_31536[(7)] = inst_31336__$1);

return statearr_31536;
})();
if(inst_31336__$1){
var statearr_31538_34063 = state_31444__$1;
(statearr_31538_34063[(1)] = (16));

} else {
var statearr_31539_34064 = state_31444__$1;
(statearr_31539_34064[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (9))){
var inst_31368 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31540_34066 = state_31444__$1;
(statearr_31540_34066[(2)] = inst_31368);

(statearr_31540_34066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (5))){
var inst_31307 = cljs.core.deref(cs);
var inst_31308 = cljs.core.seq(inst_31307);
var inst_31310 = inst_31308;
var inst_31311 = null;
var inst_31312 = (0);
var inst_31313 = (0);
var state_31444__$1 = (function (){var statearr_31542 = state_31444;
(statearr_31542[(14)] = inst_31310);

(statearr_31542[(15)] = inst_31311);

(statearr_31542[(16)] = inst_31312);

(statearr_31542[(17)] = inst_31313);

return statearr_31542;
})();
var statearr_31543_34072 = state_31444__$1;
(statearr_31543_34072[(2)] = null);

(statearr_31543_34072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (14))){
var state_31444__$1 = state_31444;
var statearr_31547_34073 = state_31444__$1;
(statearr_31547_34073[(2)] = null);

(statearr_31547_34073[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (45))){
var inst_31433 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31551_34074 = state_31444__$1;
(statearr_31551_34074[(2)] = inst_31433);

(statearr_31551_34074[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (26))){
var inst_31371 = (state_31444[(27)]);
var inst_31429 = (state_31444[(2)]);
var inst_31430 = cljs.core.seq(inst_31371);
var state_31444__$1 = (function (){var statearr_31554 = state_31444;
(statearr_31554[(29)] = inst_31429);

return statearr_31554;
})();
if(inst_31430){
var statearr_31555_34080 = state_31444__$1;
(statearr_31555_34080[(1)] = (42));

} else {
var statearr_31556_34081 = state_31444__$1;
(statearr_31556_34081[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (16))){
var inst_31336 = (state_31444[(7)]);
var inst_31338 = cljs.core.chunked_seq_QMARK_(inst_31336);
var state_31444__$1 = state_31444;
if(inst_31338){
var statearr_31558_34084 = state_31444__$1;
(statearr_31558_34084[(1)] = (19));

} else {
var statearr_31559_34085 = state_31444__$1;
(statearr_31559_34085[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (38))){
var inst_31419 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31560_34086 = state_31444__$1;
(statearr_31560_34086[(2)] = inst_31419);

(statearr_31560_34086[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (30))){
var state_31444__$1 = state_31444;
var statearr_31561_34087 = state_31444__$1;
(statearr_31561_34087[(2)] = null);

(statearr_31561_34087[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (10))){
var inst_31311 = (state_31444[(15)]);
var inst_31313 = (state_31444[(17)]);
var inst_31321 = cljs.core._nth(inst_31311,inst_31313);
var inst_31322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31321,(0),null);
var inst_31323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31321,(1),null);
var state_31444__$1 = (function (){var statearr_31563 = state_31444;
(statearr_31563[(24)] = inst_31322);

return statearr_31563;
})();
if(cljs.core.truth_(inst_31323)){
var statearr_31564_34089 = state_31444__$1;
(statearr_31564_34089[(1)] = (13));

} else {
var statearr_31565_34091 = state_31444__$1;
(statearr_31565_34091[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (18))){
var inst_31364 = (state_31444[(2)]);
var state_31444__$1 = state_31444;
var statearr_31566_34093 = state_31444__$1;
(statearr_31566_34093[(2)] = inst_31364);

(statearr_31566_34093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (42))){
var state_31444__$1 = state_31444;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31444__$1,(45),dchan);
} else {
if((state_val_31445 === (37))){
var inst_31399 = (state_31444[(23)]);
var inst_31408 = (state_31444[(22)]);
var inst_31300 = (state_31444[(12)]);
var inst_31408__$1 = cljs.core.first(inst_31399);
var inst_31409 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31408__$1,inst_31300,done);
var state_31444__$1 = (function (){var statearr_31569 = state_31444;
(statearr_31569[(22)] = inst_31408__$1);

return statearr_31569;
})();
if(cljs.core.truth_(inst_31409)){
var statearr_31570_34095 = state_31444__$1;
(statearr_31570_34095[(1)] = (39));

} else {
var statearr_31571_34096 = state_31444__$1;
(statearr_31571_34096[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31445 === (8))){
var inst_31313 = (state_31444[(17)]);
var inst_31312 = (state_31444[(16)]);
var inst_31315 = (inst_31313 < inst_31312);
var inst_31316 = inst_31315;
var state_31444__$1 = state_31444;
if(cljs.core.truth_(inst_31316)){
var statearr_31573_34101 = state_31444__$1;
(statearr_31573_34101[(1)] = (10));

} else {
var statearr_31577_34102 = state_31444__$1;
(statearr_31577_34102[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__29882__auto__ = null;
var cljs$core$async$mult_$_state_machine__29882__auto____0 = (function (){
var statearr_31581 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31581[(0)] = cljs$core$async$mult_$_state_machine__29882__auto__);

(statearr_31581[(1)] = (1));

return statearr_31581;
});
var cljs$core$async$mult_$_state_machine__29882__auto____1 = (function (state_31444){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_31444);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e31584){var ex__29885__auto__ = e31584;
var statearr_31585_34104 = state_31444;
(statearr_31585_34104[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_31444[(4)]))){
var statearr_31587_34105 = state_31444;
(statearr_31587_34105[(1)] = cljs.core.first((state_31444[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34107 = state_31444;
state_31444 = G__34107;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29882__auto__ = function(state_31444){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29882__auto____1.call(this,state_31444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29882__auto____0;
cljs$core$async$mult_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29882__auto____1;
return cljs$core$async$mult_$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_31592 = f__30088__auto__();
(statearr_31592[(6)] = c__30087__auto___33931);

return statearr_31592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31598 = arguments.length;
switch (G__31598) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_34114 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_34114(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_34120 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_34120(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_34127 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_34127(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_34131 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_34131(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_34139 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_34139(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34149 = arguments.length;
var i__5770__auto___34150 = (0);
while(true){
if((i__5770__auto___34150 < len__5769__auto___34149)){
args__5775__auto__.push((arguments[i__5770__auto___34150]));

var G__34154 = (i__5770__auto___34150 + (1));
i__5770__auto___34150 = G__34154;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31670){
var map__31671 = p__31670;
var map__31671__$1 = cljs.core.__destructure_map(map__31671);
var opts = map__31671__$1;
var statearr_31672_34161 = state;
(statearr_31672_34161[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_31677_34162 = state;
(statearr_31677_34162[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_31679_34166 = state;
(statearr_31679_34166[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31657){
var G__31658 = cljs.core.first(seq31657);
var seq31657__$1 = cljs.core.next(seq31657);
var G__31659 = cljs.core.first(seq31657__$1);
var seq31657__$2 = cljs.core.next(seq31657__$1);
var G__31660 = cljs.core.first(seq31657__$2);
var seq31657__$3 = cljs.core.next(seq31657__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31658,G__31659,G__31660,seq31657__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31706 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31707){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31707 = meta31707;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31708,meta31707__$1){
var self__ = this;
var _31708__$1 = this;
return (new cljs.core.async.t_cljs$core$async31706(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31707__$1));
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31708){
var self__ = this;
var _31708__$1 = this;
return self__.meta31707;
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31706.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31706.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31707","meta31707",-2038444980,null)], null);
}));

(cljs.core.async.t_cljs$core$async31706.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31706.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31706");

(cljs.core.async.t_cljs$core$async31706.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31706");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31706.
 */
cljs.core.async.__GT_t_cljs$core$async31706 = (function cljs$core$async$__GT_t_cljs$core$async31706(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31707){
return (new cljs.core.async.t_cljs$core$async31706(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31707));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async31706(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__30087__auto___34223 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_31809){
var state_val_31811 = (state_31809[(1)]);
if((state_val_31811 === (7))){
var inst_31751 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
if(cljs.core.truth_(inst_31751)){
var statearr_31818_34230 = state_31809__$1;
(statearr_31818_34230[(1)] = (8));

} else {
var statearr_31819_34231 = state_31809__$1;
(statearr_31819_34231[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (20))){
var inst_31744 = (state_31809[(7)]);
var state_31809__$1 = state_31809;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31809__$1,(23),out,inst_31744);
} else {
if((state_val_31811 === (1))){
var inst_31727 = calc_state();
var inst_31728 = cljs.core.__destructure_map(inst_31727);
var inst_31729 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31728,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31728,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31728,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31732 = inst_31727;
var state_31809__$1 = (function (){var statearr_31822 = state_31809;
(statearr_31822[(8)] = inst_31729);

(statearr_31822[(9)] = inst_31730);

(statearr_31822[(10)] = inst_31731);

(statearr_31822[(11)] = inst_31732);

return statearr_31822;
})();
var statearr_31825_34240 = state_31809__$1;
(statearr_31825_34240[(2)] = null);

(statearr_31825_34240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (24))){
var inst_31735 = (state_31809[(12)]);
var inst_31732 = inst_31735;
var state_31809__$1 = (function (){var statearr_31827 = state_31809;
(statearr_31827[(11)] = inst_31732);

return statearr_31827;
})();
var statearr_31828_34246 = state_31809__$1;
(statearr_31828_34246[(2)] = null);

(statearr_31828_34246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (4))){
var inst_31744 = (state_31809[(7)]);
var inst_31746 = (state_31809[(13)]);
var inst_31743 = (state_31809[(2)]);
var inst_31744__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(0),null);
var inst_31745 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31743,(1),null);
var inst_31746__$1 = (inst_31744__$1 == null);
var state_31809__$1 = (function (){var statearr_31838 = state_31809;
(statearr_31838[(7)] = inst_31744__$1);

(statearr_31838[(14)] = inst_31745);

(statearr_31838[(13)] = inst_31746__$1);

return statearr_31838;
})();
if(cljs.core.truth_(inst_31746__$1)){
var statearr_31840_34247 = state_31809__$1;
(statearr_31840_34247[(1)] = (5));

} else {
var statearr_31841_34248 = state_31809__$1;
(statearr_31841_34248[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (15))){
var inst_31736 = (state_31809[(15)]);
var inst_31773 = (state_31809[(16)]);
var inst_31773__$1 = cljs.core.empty_QMARK_(inst_31736);
var state_31809__$1 = (function (){var statearr_31842 = state_31809;
(statearr_31842[(16)] = inst_31773__$1);

return statearr_31842;
})();
if(inst_31773__$1){
var statearr_31843_34250 = state_31809__$1;
(statearr_31843_34250[(1)] = (17));

} else {
var statearr_31844_34251 = state_31809__$1;
(statearr_31844_34251[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (21))){
var inst_31735 = (state_31809[(12)]);
var inst_31732 = inst_31735;
var state_31809__$1 = (function (){var statearr_31845 = state_31809;
(statearr_31845[(11)] = inst_31732);

return statearr_31845;
})();
var statearr_31846_34253 = state_31809__$1;
(statearr_31846_34253[(2)] = null);

(statearr_31846_34253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (13))){
var inst_31762 = (state_31809[(2)]);
var inst_31763 = calc_state();
var inst_31732 = inst_31763;
var state_31809__$1 = (function (){var statearr_31847 = state_31809;
(statearr_31847[(17)] = inst_31762);

(statearr_31847[(11)] = inst_31732);

return statearr_31847;
})();
var statearr_31848_34254 = state_31809__$1;
(statearr_31848_34254[(2)] = null);

(statearr_31848_34254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (22))){
var inst_31801 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
var statearr_31849_34256 = state_31809__$1;
(statearr_31849_34256[(2)] = inst_31801);

(statearr_31849_34256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (6))){
var inst_31745 = (state_31809[(14)]);
var inst_31749 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31745,change);
var state_31809__$1 = state_31809;
var statearr_31850_34261 = state_31809__$1;
(statearr_31850_34261[(2)] = inst_31749);

(statearr_31850_34261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (25))){
var state_31809__$1 = state_31809;
var statearr_31851_34267 = state_31809__$1;
(statearr_31851_34267[(2)] = null);

(statearr_31851_34267[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (17))){
var inst_31737 = (state_31809[(18)]);
var inst_31745 = (state_31809[(14)]);
var inst_31775 = (inst_31737.cljs$core$IFn$_invoke$arity$1 ? inst_31737.cljs$core$IFn$_invoke$arity$1(inst_31745) : inst_31737.call(null,inst_31745));
var inst_31776 = cljs.core.not(inst_31775);
var state_31809__$1 = state_31809;
var statearr_31853_34268 = state_31809__$1;
(statearr_31853_34268[(2)] = inst_31776);

(statearr_31853_34268[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (3))){
var inst_31805 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31809__$1,inst_31805);
} else {
if((state_val_31811 === (12))){
var state_31809__$1 = state_31809;
var statearr_31855_34269 = state_31809__$1;
(statearr_31855_34269[(2)] = null);

(statearr_31855_34269[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (2))){
var inst_31732 = (state_31809[(11)]);
var inst_31735 = (state_31809[(12)]);
var inst_31735__$1 = cljs.core.__destructure_map(inst_31732);
var inst_31736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31735__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31735__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31735__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31809__$1 = (function (){var statearr_31861 = state_31809;
(statearr_31861[(12)] = inst_31735__$1);

(statearr_31861[(15)] = inst_31736);

(statearr_31861[(18)] = inst_31737);

return statearr_31861;
})();
return cljs.core.async.ioc_alts_BANG_(state_31809__$1,(4),inst_31738);
} else {
if((state_val_31811 === (23))){
var inst_31792 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
if(cljs.core.truth_(inst_31792)){
var statearr_31863_34274 = state_31809__$1;
(statearr_31863_34274[(1)] = (24));

} else {
var statearr_31864_34275 = state_31809__$1;
(statearr_31864_34275[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (19))){
var inst_31779 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
var statearr_31866_34280 = state_31809__$1;
(statearr_31866_34280[(2)] = inst_31779);

(statearr_31866_34280[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (11))){
var inst_31745 = (state_31809[(14)]);
var inst_31759 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31745);
var state_31809__$1 = state_31809;
var statearr_31869_34282 = state_31809__$1;
(statearr_31869_34282[(2)] = inst_31759);

(statearr_31869_34282[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (9))){
var inst_31736 = (state_31809[(15)]);
var inst_31745 = (state_31809[(14)]);
var inst_31766 = (state_31809[(19)]);
var inst_31766__$1 = (inst_31736.cljs$core$IFn$_invoke$arity$1 ? inst_31736.cljs$core$IFn$_invoke$arity$1(inst_31745) : inst_31736.call(null,inst_31745));
var state_31809__$1 = (function (){var statearr_31871 = state_31809;
(statearr_31871[(19)] = inst_31766__$1);

return statearr_31871;
})();
if(cljs.core.truth_(inst_31766__$1)){
var statearr_31872_34283 = state_31809__$1;
(statearr_31872_34283[(1)] = (14));

} else {
var statearr_31874_34284 = state_31809__$1;
(statearr_31874_34284[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (5))){
var inst_31746 = (state_31809[(13)]);
var state_31809__$1 = state_31809;
var statearr_31876_34285 = state_31809__$1;
(statearr_31876_34285[(2)] = inst_31746);

(statearr_31876_34285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (14))){
var inst_31766 = (state_31809[(19)]);
var state_31809__$1 = state_31809;
var statearr_31880_34294 = state_31809__$1;
(statearr_31880_34294[(2)] = inst_31766);

(statearr_31880_34294[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (26))){
var inst_31797 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
var statearr_31884_34298 = state_31809__$1;
(statearr_31884_34298[(2)] = inst_31797);

(statearr_31884_34298[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (16))){
var inst_31781 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
if(cljs.core.truth_(inst_31781)){
var statearr_31885_34306 = state_31809__$1;
(statearr_31885_34306[(1)] = (20));

} else {
var statearr_31886_34307 = state_31809__$1;
(statearr_31886_34307[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (10))){
var inst_31803 = (state_31809[(2)]);
var state_31809__$1 = state_31809;
var statearr_31888_34308 = state_31809__$1;
(statearr_31888_34308[(2)] = inst_31803);

(statearr_31888_34308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (18))){
var inst_31773 = (state_31809[(16)]);
var state_31809__$1 = state_31809;
var statearr_31889_34309 = state_31809__$1;
(statearr_31889_34309[(2)] = inst_31773);

(statearr_31889_34309[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31811 === (8))){
var inst_31744 = (state_31809[(7)]);
var inst_31753 = (inst_31744 == null);
var state_31809__$1 = state_31809;
if(cljs.core.truth_(inst_31753)){
var statearr_31892_34310 = state_31809__$1;
(statearr_31892_34310[(1)] = (11));

} else {
var statearr_31893_34311 = state_31809__$1;
(statearr_31893_34311[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__29882__auto__ = null;
var cljs$core$async$mix_$_state_machine__29882__auto____0 = (function (){
var statearr_31896 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31896[(0)] = cljs$core$async$mix_$_state_machine__29882__auto__);

(statearr_31896[(1)] = (1));

return statearr_31896;
});
var cljs$core$async$mix_$_state_machine__29882__auto____1 = (function (state_31809){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_31809);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e31898){var ex__29885__auto__ = e31898;
var statearr_31900_34312 = state_31809;
(statearr_31900_34312[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_31809[(4)]))){
var statearr_31901_34314 = state_31809;
(statearr_31901_34314[(1)] = cljs.core.first((state_31809[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34317 = state_31809;
state_31809 = G__34317;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29882__auto__ = function(state_31809){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29882__auto____1.call(this,state_31809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29882__auto____0;
cljs$core$async$mix_$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29882__auto____1;
return cljs$core$async$mix_$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_31905 = f__30088__auto__();
(statearr_31905[(6)] = c__30087__auto___34223);

return statearr_31905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_34318 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_34318(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_34331 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_34331(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_34336 = (function() {
var G__34337 = null;
var G__34337__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__34337__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__34337 = function(p,v){
switch(arguments.length){
case 1:
return G__34337__1.call(this,p);
case 2:
return G__34337__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34337.cljs$core$IFn$_invoke$arity$1 = G__34337__1;
G__34337.cljs$core$IFn$_invoke$arity$2 = G__34337__2;
return G__34337;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31939 = arguments.length;
switch (G__31939) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34336(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34336(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32010 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32011){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32011 = meta32011;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32012,meta32011__$1){
var self__ = this;
var _32012__$1 = this;
return (new cljs.core.async.t_cljs$core$async32010(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32011__$1));
}));

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32012){
var self__ = this;
var _32012__$1 = this;
return self__.meta32011;
}));

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32010.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32010.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32011","meta32011",-278985616,null)], null);
}));

(cljs.core.async.t_cljs$core$async32010.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32010.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32010");

(cljs.core.async.t_cljs$core$async32010.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32010");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32010.
 */
cljs.core.async.__GT_t_cljs$core$async32010 = (function cljs$core$async$__GT_t_cljs$core$async32010(ch,topic_fn,buf_fn,mults,ensure_mult,meta32011){
return (new cljs.core.async.t_cljs$core$async32010(ch,topic_fn,buf_fn,mults,ensure_mult,meta32011));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31996 = arguments.length;
switch (G__31996) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__31979_SHARP_){
if(cljs.core.truth_((p1__31979_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31979_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31979_SHARP_.call(null,topic)))){
return p1__31979_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31979_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async32010(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__30087__auto___34360 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_32128){
var state_val_32129 = (state_32128[(1)]);
if((state_val_32129 === (7))){
var inst_32122 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
var statearr_32138_34365 = state_32128__$1;
(statearr_32138_34365[(2)] = inst_32122);

(statearr_32138_34365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (20))){
var state_32128__$1 = state_32128;
var statearr_32141_34366 = state_32128__$1;
(statearr_32141_34366[(2)] = null);

(statearr_32141_34366[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (1))){
var state_32128__$1 = state_32128;
var statearr_32143_34367 = state_32128__$1;
(statearr_32143_34367[(2)] = null);

(statearr_32143_34367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (24))){
var inst_32103 = (state_32128[(7)]);
var inst_32114 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32103);
var state_32128__$1 = state_32128;
var statearr_32147_34369 = state_32128__$1;
(statearr_32147_34369[(2)] = inst_32114);

(statearr_32147_34369[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (4))){
var inst_32047 = (state_32128[(8)]);
var inst_32047__$1 = (state_32128[(2)]);
var inst_32049 = (inst_32047__$1 == null);
var state_32128__$1 = (function (){var statearr_32150 = state_32128;
(statearr_32150[(8)] = inst_32047__$1);

return statearr_32150;
})();
if(cljs.core.truth_(inst_32049)){
var statearr_32152_34374 = state_32128__$1;
(statearr_32152_34374[(1)] = (5));

} else {
var statearr_32154_34380 = state_32128__$1;
(statearr_32154_34380[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (15))){
var inst_32097 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
var statearr_32161_34385 = state_32128__$1;
(statearr_32161_34385[(2)] = inst_32097);

(statearr_32161_34385[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (21))){
var inst_32119 = (state_32128[(2)]);
var state_32128__$1 = (function (){var statearr_32162 = state_32128;
(statearr_32162[(9)] = inst_32119);

return statearr_32162;
})();
var statearr_32164_34388 = state_32128__$1;
(statearr_32164_34388[(2)] = null);

(statearr_32164_34388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (13))){
var inst_32077 = (state_32128[(10)]);
var inst_32080 = cljs.core.chunked_seq_QMARK_(inst_32077);
var state_32128__$1 = state_32128;
if(inst_32080){
var statearr_32168_34389 = state_32128__$1;
(statearr_32168_34389[(1)] = (16));

} else {
var statearr_32172_34390 = state_32128__$1;
(statearr_32172_34390[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (22))){
var inst_32109 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
if(cljs.core.truth_(inst_32109)){
var statearr_32174_34394 = state_32128__$1;
(statearr_32174_34394[(1)] = (23));

} else {
var statearr_32177_34395 = state_32128__$1;
(statearr_32177_34395[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (6))){
var inst_32047 = (state_32128[(8)]);
var inst_32103 = (state_32128[(7)]);
var inst_32105 = (state_32128[(11)]);
var inst_32103__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32047) : topic_fn.call(null,inst_32047));
var inst_32104 = cljs.core.deref(mults);
var inst_32105__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32104,inst_32103__$1);
var state_32128__$1 = (function (){var statearr_32182 = state_32128;
(statearr_32182[(7)] = inst_32103__$1);

(statearr_32182[(11)] = inst_32105__$1);

return statearr_32182;
})();
if(cljs.core.truth_(inst_32105__$1)){
var statearr_32185_34402 = state_32128__$1;
(statearr_32185_34402[(1)] = (19));

} else {
var statearr_32186_34403 = state_32128__$1;
(statearr_32186_34403[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (25))){
var inst_32116 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
var statearr_32190_34404 = state_32128__$1;
(statearr_32190_34404[(2)] = inst_32116);

(statearr_32190_34404[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (17))){
var inst_32077 = (state_32128[(10)]);
var inst_32087 = cljs.core.first(inst_32077);
var inst_32088 = cljs.core.async.muxch_STAR_(inst_32087);
var inst_32089 = cljs.core.async.close_BANG_(inst_32088);
var inst_32090 = cljs.core.next(inst_32077);
var inst_32060 = inst_32090;
var inst_32061 = null;
var inst_32062 = (0);
var inst_32063 = (0);
var state_32128__$1 = (function (){var statearr_32197 = state_32128;
(statearr_32197[(12)] = inst_32089);

(statearr_32197[(13)] = inst_32060);

(statearr_32197[(14)] = inst_32061);

(statearr_32197[(15)] = inst_32062);

(statearr_32197[(16)] = inst_32063);

return statearr_32197;
})();
var statearr_32199_34407 = state_32128__$1;
(statearr_32199_34407[(2)] = null);

(statearr_32199_34407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (3))){
var inst_32124 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32128__$1,inst_32124);
} else {
if((state_val_32129 === (12))){
var inst_32099 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
var statearr_32201_34412 = state_32128__$1;
(statearr_32201_34412[(2)] = inst_32099);

(statearr_32201_34412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (2))){
var state_32128__$1 = state_32128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32128__$1,(4),ch);
} else {
if((state_val_32129 === (23))){
var state_32128__$1 = state_32128;
var statearr_32206_34413 = state_32128__$1;
(statearr_32206_34413[(2)] = null);

(statearr_32206_34413[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (19))){
var inst_32105 = (state_32128[(11)]);
var inst_32047 = (state_32128[(8)]);
var inst_32107 = cljs.core.async.muxch_STAR_(inst_32105);
var state_32128__$1 = state_32128;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32128__$1,(22),inst_32107,inst_32047);
} else {
if((state_val_32129 === (11))){
var inst_32060 = (state_32128[(13)]);
var inst_32077 = (state_32128[(10)]);
var inst_32077__$1 = cljs.core.seq(inst_32060);
var state_32128__$1 = (function (){var statearr_32211 = state_32128;
(statearr_32211[(10)] = inst_32077__$1);

return statearr_32211;
})();
if(inst_32077__$1){
var statearr_32212_34414 = state_32128__$1;
(statearr_32212_34414[(1)] = (13));

} else {
var statearr_32213_34416 = state_32128__$1;
(statearr_32213_34416[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (9))){
var inst_32101 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
var statearr_32215_34420 = state_32128__$1;
(statearr_32215_34420[(2)] = inst_32101);

(statearr_32215_34420[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (5))){
var inst_32055 = cljs.core.deref(mults);
var inst_32056 = cljs.core.vals(inst_32055);
var inst_32057 = cljs.core.seq(inst_32056);
var inst_32060 = inst_32057;
var inst_32061 = null;
var inst_32062 = (0);
var inst_32063 = (0);
var state_32128__$1 = (function (){var statearr_32220 = state_32128;
(statearr_32220[(13)] = inst_32060);

(statearr_32220[(14)] = inst_32061);

(statearr_32220[(15)] = inst_32062);

(statearr_32220[(16)] = inst_32063);

return statearr_32220;
})();
var statearr_32224_34425 = state_32128__$1;
(statearr_32224_34425[(2)] = null);

(statearr_32224_34425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (14))){
var state_32128__$1 = state_32128;
var statearr_32229_34427 = state_32128__$1;
(statearr_32229_34427[(2)] = null);

(statearr_32229_34427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (16))){
var inst_32077 = (state_32128[(10)]);
var inst_32082 = cljs.core.chunk_first(inst_32077);
var inst_32083 = cljs.core.chunk_rest(inst_32077);
var inst_32084 = cljs.core.count(inst_32082);
var inst_32060 = inst_32083;
var inst_32061 = inst_32082;
var inst_32062 = inst_32084;
var inst_32063 = (0);
var state_32128__$1 = (function (){var statearr_32233 = state_32128;
(statearr_32233[(13)] = inst_32060);

(statearr_32233[(14)] = inst_32061);

(statearr_32233[(15)] = inst_32062);

(statearr_32233[(16)] = inst_32063);

return statearr_32233;
})();
var statearr_32234_34438 = state_32128__$1;
(statearr_32234_34438[(2)] = null);

(statearr_32234_34438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (10))){
var inst_32061 = (state_32128[(14)]);
var inst_32063 = (state_32128[(16)]);
var inst_32060 = (state_32128[(13)]);
var inst_32062 = (state_32128[(15)]);
var inst_32069 = cljs.core._nth(inst_32061,inst_32063);
var inst_32070 = cljs.core.async.muxch_STAR_(inst_32069);
var inst_32071 = cljs.core.async.close_BANG_(inst_32070);
var inst_32072 = (inst_32063 + (1));
var tmp32226 = inst_32061;
var tmp32227 = inst_32062;
var tmp32228 = inst_32060;
var inst_32060__$1 = tmp32228;
var inst_32061__$1 = tmp32226;
var inst_32062__$1 = tmp32227;
var inst_32063__$1 = inst_32072;
var state_32128__$1 = (function (){var statearr_32242 = state_32128;
(statearr_32242[(17)] = inst_32071);

(statearr_32242[(13)] = inst_32060__$1);

(statearr_32242[(14)] = inst_32061__$1);

(statearr_32242[(15)] = inst_32062__$1);

(statearr_32242[(16)] = inst_32063__$1);

return statearr_32242;
})();
var statearr_32247_34448 = state_32128__$1;
(statearr_32247_34448[(2)] = null);

(statearr_32247_34448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (18))){
var inst_32094 = (state_32128[(2)]);
var state_32128__$1 = state_32128;
var statearr_32249_34452 = state_32128__$1;
(statearr_32249_34452[(2)] = inst_32094);

(statearr_32249_34452[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32129 === (8))){
var inst_32063 = (state_32128[(16)]);
var inst_32062 = (state_32128[(15)]);
var inst_32066 = (inst_32063 < inst_32062);
var inst_32067 = inst_32066;
var state_32128__$1 = state_32128;
if(cljs.core.truth_(inst_32067)){
var statearr_32261_34456 = state_32128__$1;
(statearr_32261_34456[(1)] = (10));

} else {
var statearr_32264_34457 = state_32128__$1;
(statearr_32264_34457[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_32270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32270[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_32270[(1)] = (1));

return statearr_32270;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_32128){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_32128);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e32276){var ex__29885__auto__ = e32276;
var statearr_32278_34460 = state_32128;
(statearr_32278_34460[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_32128[(4)]))){
var statearr_32279_34461 = state_32128;
(statearr_32279_34461[(1)] = cljs.core.first((state_32128[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34463 = state_32128;
state_32128 = G__34463;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_32128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_32128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_32282 = f__30088__auto__();
(statearr_32282[(6)] = c__30087__auto___34360);

return statearr_32282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32290 = arguments.length;
switch (G__32290) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32315 = arguments.length;
switch (G__32315) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32326 = arguments.length;
switch (G__32326) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30087__auto___34481 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_32398){
var state_val_32399 = (state_32398[(1)]);
if((state_val_32399 === (7))){
var state_32398__$1 = state_32398;
var statearr_32405_34483 = state_32398__$1;
(statearr_32405_34483[(2)] = null);

(statearr_32405_34483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (1))){
var state_32398__$1 = state_32398;
var statearr_32406_34485 = state_32398__$1;
(statearr_32406_34485[(2)] = null);

(statearr_32406_34485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (4))){
var inst_32341 = (state_32398[(7)]);
var inst_32340 = (state_32398[(8)]);
var inst_32343 = (inst_32341 < inst_32340);
var state_32398__$1 = state_32398;
if(cljs.core.truth_(inst_32343)){
var statearr_32412_34489 = state_32398__$1;
(statearr_32412_34489[(1)] = (6));

} else {
var statearr_32413_34490 = state_32398__$1;
(statearr_32413_34490[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (15))){
var inst_32380 = (state_32398[(9)]);
var inst_32385 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32380);
var state_32398__$1 = state_32398;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32398__$1,(17),out,inst_32385);
} else {
if((state_val_32399 === (13))){
var inst_32380 = (state_32398[(9)]);
var inst_32380__$1 = (state_32398[(2)]);
var inst_32381 = cljs.core.some(cljs.core.nil_QMARK_,inst_32380__$1);
var state_32398__$1 = (function (){var statearr_32415 = state_32398;
(statearr_32415[(9)] = inst_32380__$1);

return statearr_32415;
})();
if(cljs.core.truth_(inst_32381)){
var statearr_32419_34493 = state_32398__$1;
(statearr_32419_34493[(1)] = (14));

} else {
var statearr_32420_34494 = state_32398__$1;
(statearr_32420_34494[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (6))){
var state_32398__$1 = state_32398;
var statearr_32421_34495 = state_32398__$1;
(statearr_32421_34495[(2)] = null);

(statearr_32421_34495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (17))){
var inst_32387 = (state_32398[(2)]);
var state_32398__$1 = (function (){var statearr_32442 = state_32398;
(statearr_32442[(10)] = inst_32387);

return statearr_32442;
})();
var statearr_32443_34505 = state_32398__$1;
(statearr_32443_34505[(2)] = null);

(statearr_32443_34505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (3))){
var inst_32392 = (state_32398[(2)]);
var state_32398__$1 = state_32398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32398__$1,inst_32392);
} else {
if((state_val_32399 === (12))){
var _ = (function (){var statearr_32448 = state_32398;
(statearr_32448[(4)] = cljs.core.rest((state_32398[(4)])));

return statearr_32448;
})();
var state_32398__$1 = state_32398;
var ex32440 = (state_32398__$1[(2)]);
var statearr_32452_34513 = state_32398__$1;
(statearr_32452_34513[(5)] = ex32440);


if((ex32440 instanceof Object)){
var statearr_32454_34514 = state_32398__$1;
(statearr_32454_34514[(1)] = (11));

(statearr_32454_34514[(5)] = null);

} else {
throw ex32440;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (2))){
var inst_32339 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32340 = cnt;
var inst_32341 = (0);
var state_32398__$1 = (function (){var statearr_32460 = state_32398;
(statearr_32460[(11)] = inst_32339);

(statearr_32460[(8)] = inst_32340);

(statearr_32460[(7)] = inst_32341);

return statearr_32460;
})();
var statearr_32462_34524 = state_32398__$1;
(statearr_32462_34524[(2)] = null);

(statearr_32462_34524[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (11))){
var inst_32352 = (state_32398[(2)]);
var inst_32356 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32398__$1 = (function (){var statearr_32464 = state_32398;
(statearr_32464[(12)] = inst_32352);

return statearr_32464;
})();
var statearr_32465_34525 = state_32398__$1;
(statearr_32465_34525[(2)] = inst_32356);

(statearr_32465_34525[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (9))){
var inst_32341 = (state_32398[(7)]);
var _ = (function (){var statearr_32466 = state_32398;
(statearr_32466[(4)] = cljs.core.cons((12),(state_32398[(4)])));

return statearr_32466;
})();
var inst_32364 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32341) : chs__$1.call(null,inst_32341));
var inst_32365 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32341) : done.call(null,inst_32341));
var inst_32366 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32364,inst_32365);
var ___$1 = (function (){var statearr_32471 = state_32398;
(statearr_32471[(4)] = cljs.core.rest((state_32398[(4)])));

return statearr_32471;
})();
var state_32398__$1 = state_32398;
var statearr_32475_34526 = state_32398__$1;
(statearr_32475_34526[(2)] = inst_32366);

(statearr_32475_34526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (5))){
var inst_32376 = (state_32398[(2)]);
var state_32398__$1 = (function (){var statearr_32478 = state_32398;
(statearr_32478[(13)] = inst_32376);

return statearr_32478;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32398__$1,(13),dchan);
} else {
if((state_val_32399 === (14))){
var inst_32383 = cljs.core.async.close_BANG_(out);
var state_32398__$1 = state_32398;
var statearr_32482_34527 = state_32398__$1;
(statearr_32482_34527[(2)] = inst_32383);

(statearr_32482_34527[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (16))){
var inst_32390 = (state_32398[(2)]);
var state_32398__$1 = state_32398;
var statearr_32487_34540 = state_32398__$1;
(statearr_32487_34540[(2)] = inst_32390);

(statearr_32487_34540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (10))){
var inst_32341 = (state_32398[(7)]);
var inst_32369 = (state_32398[(2)]);
var inst_32370 = (inst_32341 + (1));
var inst_32341__$1 = inst_32370;
var state_32398__$1 = (function (){var statearr_32489 = state_32398;
(statearr_32489[(14)] = inst_32369);

(statearr_32489[(7)] = inst_32341__$1);

return statearr_32489;
})();
var statearr_32491_34542 = state_32398__$1;
(statearr_32491_34542[(2)] = null);

(statearr_32491_34542[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32399 === (8))){
var inst_32374 = (state_32398[(2)]);
var state_32398__$1 = state_32398;
var statearr_32495_34543 = state_32398__$1;
(statearr_32495_34543[(2)] = inst_32374);

(statearr_32495_34543[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_32497 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32497[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_32497[(1)] = (1));

return statearr_32497;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_32398){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_32398);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e32500){var ex__29885__auto__ = e32500;
var statearr_32502_34548 = state_32398;
(statearr_32502_34548[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_32398[(4)]))){
var statearr_32503_34549 = state_32398;
(statearr_32503_34549[(1)] = cljs.core.first((state_32398[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34550 = state_32398;
state_32398 = G__34550;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_32398){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_32398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_32509 = f__30088__auto__();
(statearr_32509[(6)] = c__30087__auto___34481);

return statearr_32509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32513 = arguments.length;
switch (G__32513) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30087__auto___34561 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_32557){
var state_val_32558 = (state_32557[(1)]);
if((state_val_32558 === (7))){
var inst_32529 = (state_32557[(7)]);
var inst_32530 = (state_32557[(8)]);
var inst_32529__$1 = (state_32557[(2)]);
var inst_32530__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32529__$1,(0),null);
var inst_32531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32529__$1,(1),null);
var inst_32532 = (inst_32530__$1 == null);
var state_32557__$1 = (function (){var statearr_32559 = state_32557;
(statearr_32559[(7)] = inst_32529__$1);

(statearr_32559[(8)] = inst_32530__$1);

(statearr_32559[(9)] = inst_32531);

return statearr_32559;
})();
if(cljs.core.truth_(inst_32532)){
var statearr_32561_34569 = state_32557__$1;
(statearr_32561_34569[(1)] = (8));

} else {
var statearr_32562_34570 = state_32557__$1;
(statearr_32562_34570[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (1))){
var inst_32518 = cljs.core.vec(chs);
var inst_32519 = inst_32518;
var state_32557__$1 = (function (){var statearr_32564 = state_32557;
(statearr_32564[(10)] = inst_32519);

return statearr_32564;
})();
var statearr_32565_34571 = state_32557__$1;
(statearr_32565_34571[(2)] = null);

(statearr_32565_34571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (4))){
var inst_32519 = (state_32557[(10)]);
var state_32557__$1 = state_32557;
return cljs.core.async.ioc_alts_BANG_(state_32557__$1,(7),inst_32519);
} else {
if((state_val_32558 === (6))){
var inst_32549 = (state_32557[(2)]);
var state_32557__$1 = state_32557;
var statearr_32566_34580 = state_32557__$1;
(statearr_32566_34580[(2)] = inst_32549);

(statearr_32566_34580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (3))){
var inst_32551 = (state_32557[(2)]);
var state_32557__$1 = state_32557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32557__$1,inst_32551);
} else {
if((state_val_32558 === (2))){
var inst_32519 = (state_32557[(10)]);
var inst_32521 = cljs.core.count(inst_32519);
var inst_32522 = (inst_32521 > (0));
var state_32557__$1 = state_32557;
if(cljs.core.truth_(inst_32522)){
var statearr_32570_34581 = state_32557__$1;
(statearr_32570_34581[(1)] = (4));

} else {
var statearr_32571_34585 = state_32557__$1;
(statearr_32571_34585[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (11))){
var inst_32519 = (state_32557[(10)]);
var inst_32542 = (state_32557[(2)]);
var tmp32567 = inst_32519;
var inst_32519__$1 = tmp32567;
var state_32557__$1 = (function (){var statearr_32575 = state_32557;
(statearr_32575[(11)] = inst_32542);

(statearr_32575[(10)] = inst_32519__$1);

return statearr_32575;
})();
var statearr_32576_34586 = state_32557__$1;
(statearr_32576_34586[(2)] = null);

(statearr_32576_34586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (9))){
var inst_32530 = (state_32557[(8)]);
var state_32557__$1 = state_32557;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32557__$1,(11),out,inst_32530);
} else {
if((state_val_32558 === (5))){
var inst_32547 = cljs.core.async.close_BANG_(out);
var state_32557__$1 = state_32557;
var statearr_32582_34590 = state_32557__$1;
(statearr_32582_34590[(2)] = inst_32547);

(statearr_32582_34590[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (10))){
var inst_32545 = (state_32557[(2)]);
var state_32557__$1 = state_32557;
var statearr_32584_34591 = state_32557__$1;
(statearr_32584_34591[(2)] = inst_32545);

(statearr_32584_34591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32558 === (8))){
var inst_32519 = (state_32557[(10)]);
var inst_32529 = (state_32557[(7)]);
var inst_32530 = (state_32557[(8)]);
var inst_32531 = (state_32557[(9)]);
var inst_32537 = (function (){var cs = inst_32519;
var vec__32525 = inst_32529;
var v = inst_32530;
var c = inst_32531;
return (function (p1__32510_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32510_SHARP_);
});
})();
var inst_32538 = cljs.core.filterv(inst_32537,inst_32519);
var inst_32519__$1 = inst_32538;
var state_32557__$1 = (function (){var statearr_32586 = state_32557;
(statearr_32586[(10)] = inst_32519__$1);

return statearr_32586;
})();
var statearr_32587_34597 = state_32557__$1;
(statearr_32587_34597[(2)] = null);

(statearr_32587_34597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_32588 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32588[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_32588[(1)] = (1));

return statearr_32588;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_32557){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_32557);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e32589){var ex__29885__auto__ = e32589;
var statearr_32590_34612 = state_32557;
(statearr_32590_34612[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_32557[(4)]))){
var statearr_32591_34620 = state_32557;
(statearr_32591_34620[(1)] = cljs.core.first((state_32557[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34622 = state_32557;
state_32557 = G__34622;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_32557){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_32557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_32592 = f__30088__auto__();
(statearr_32592[(6)] = c__30087__auto___34561);

return statearr_32592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32597 = arguments.length;
switch (G__32597) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30087__auto___34638 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_32648){
var state_val_32649 = (state_32648[(1)]);
if((state_val_32649 === (7))){
var inst_32630 = (state_32648[(7)]);
var inst_32630__$1 = (state_32648[(2)]);
var inst_32631 = (inst_32630__$1 == null);
var inst_32632 = cljs.core.not(inst_32631);
var state_32648__$1 = (function (){var statearr_32650 = state_32648;
(statearr_32650[(7)] = inst_32630__$1);

return statearr_32650;
})();
if(inst_32632){
var statearr_32651_34639 = state_32648__$1;
(statearr_32651_34639[(1)] = (8));

} else {
var statearr_32652_34642 = state_32648__$1;
(statearr_32652_34642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (1))){
var inst_32625 = (0);
var state_32648__$1 = (function (){var statearr_32653 = state_32648;
(statearr_32653[(8)] = inst_32625);

return statearr_32653;
})();
var statearr_32654_34644 = state_32648__$1;
(statearr_32654_34644[(2)] = null);

(statearr_32654_34644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (4))){
var state_32648__$1 = state_32648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32648__$1,(7),ch);
} else {
if((state_val_32649 === (6))){
var inst_32643 = (state_32648[(2)]);
var state_32648__$1 = state_32648;
var statearr_32661_34648 = state_32648__$1;
(statearr_32661_34648[(2)] = inst_32643);

(statearr_32661_34648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (3))){
var inst_32645 = (state_32648[(2)]);
var inst_32646 = cljs.core.async.close_BANG_(out);
var state_32648__$1 = (function (){var statearr_32662 = state_32648;
(statearr_32662[(9)] = inst_32645);

return statearr_32662;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32648__$1,inst_32646);
} else {
if((state_val_32649 === (2))){
var inst_32625 = (state_32648[(8)]);
var inst_32627 = (inst_32625 < n);
var state_32648__$1 = state_32648;
if(cljs.core.truth_(inst_32627)){
var statearr_32663_34655 = state_32648__$1;
(statearr_32663_34655[(1)] = (4));

} else {
var statearr_32664_34656 = state_32648__$1;
(statearr_32664_34656[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (11))){
var inst_32625 = (state_32648[(8)]);
var inst_32635 = (state_32648[(2)]);
var inst_32636 = (inst_32625 + (1));
var inst_32625__$1 = inst_32636;
var state_32648__$1 = (function (){var statearr_32667 = state_32648;
(statearr_32667[(10)] = inst_32635);

(statearr_32667[(8)] = inst_32625__$1);

return statearr_32667;
})();
var statearr_32670_34657 = state_32648__$1;
(statearr_32670_34657[(2)] = null);

(statearr_32670_34657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (9))){
var state_32648__$1 = state_32648;
var statearr_32673_34658 = state_32648__$1;
(statearr_32673_34658[(2)] = null);

(statearr_32673_34658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (5))){
var state_32648__$1 = state_32648;
var statearr_32674_34659 = state_32648__$1;
(statearr_32674_34659[(2)] = null);

(statearr_32674_34659[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (10))){
var inst_32640 = (state_32648[(2)]);
var state_32648__$1 = state_32648;
var statearr_32675_34660 = state_32648__$1;
(statearr_32675_34660[(2)] = inst_32640);

(statearr_32675_34660[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32649 === (8))){
var inst_32630 = (state_32648[(7)]);
var state_32648__$1 = state_32648;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32648__$1,(11),out,inst_32630);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_32678 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32678[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_32678[(1)] = (1));

return statearr_32678;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_32648){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_32648);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e32681){var ex__29885__auto__ = e32681;
var statearr_32682_34678 = state_32648;
(statearr_32682_34678[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_32648[(4)]))){
var statearr_32683_34679 = state_32648;
(statearr_32683_34679[(1)] = cljs.core.first((state_32648[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34680 = state_32648;
state_32648 = G__34680;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_32648){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_32648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_32686 = f__30088__auto__();
(statearr_32686[(6)] = c__30087__auto___34638);

return statearr_32686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32699 = (function (f,ch,meta32690,_,fn1,meta32700){
this.f = f;
this.ch = ch;
this.meta32690 = meta32690;
this._ = _;
this.fn1 = fn1;
this.meta32700 = meta32700;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32699.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32701,meta32700__$1){
var self__ = this;
var _32701__$1 = this;
return (new cljs.core.async.t_cljs$core$async32699(self__.f,self__.ch,self__.meta32690,self__._,self__.fn1,meta32700__$1));
}));

(cljs.core.async.t_cljs$core$async32699.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32701){
var self__ = this;
var _32701__$1 = this;
return self__.meta32700;
}));

(cljs.core.async.t_cljs$core$async32699.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32699.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async32699.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async32699.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__32688_SHARP_){
var G__32709 = (((p1__32688_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__32688_SHARP_) : self__.f.call(null,p1__32688_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32709) : f1.call(null,G__32709));
});
}));

(cljs.core.async.t_cljs$core$async32699.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32690","meta32690",1678851128,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32689","cljs.core.async/t_cljs$core$async32689",2116139509,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32700","meta32700",-949191092,null)], null);
}));

(cljs.core.async.t_cljs$core$async32699.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32699.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32699");

(cljs.core.async.t_cljs$core$async32699.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32699");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32699.
 */
cljs.core.async.__GT_t_cljs$core$async32699 = (function cljs$core$async$__GT_t_cljs$core$async32699(f,ch,meta32690,_,fn1,meta32700){
return (new cljs.core.async.t_cljs$core$async32699(f,ch,meta32690,_,fn1,meta32700));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32689 = (function (f,ch,meta32690){
this.f = f;
this.ch = ch;
this.meta32690 = meta32690;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32691,meta32690__$1){
var self__ = this;
var _32691__$1 = this;
return (new cljs.core.async.t_cljs$core$async32689(self__.f,self__.ch,meta32690__$1));
}));

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32691){
var self__ = this;
var _32691__$1 = this;
return self__.meta32690;
}));

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async32699(self__.f,self__.ch,self__.meta32690,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32712 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32712) : self__.f.call(null,G__32712));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32689.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async32689.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32690","meta32690",1678851128,null)], null);
}));

(cljs.core.async.t_cljs$core$async32689.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32689.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32689");

(cljs.core.async.t_cljs$core$async32689.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32689");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32689.
 */
cljs.core.async.__GT_t_cljs$core$async32689 = (function cljs$core$async$__GT_t_cljs$core$async32689(f,ch,meta32690){
return (new cljs.core.async.t_cljs$core$async32689(f,ch,meta32690));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async32689(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32719 = (function (f,ch,meta32721){
this.f = f;
this.ch = ch;
this.meta32721 = meta32721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32722,meta32721__$1){
var self__ = this;
var _32722__$1 = this;
return (new cljs.core.async.t_cljs$core$async32719(self__.f,self__.ch,meta32721__$1));
}));

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32722){
var self__ = this;
var _32722__$1 = this;
return self__.meta32721;
}));

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32719.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async32719.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32721","meta32721",-2007985527,null)], null);
}));

(cljs.core.async.t_cljs$core$async32719.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32719.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32719");

(cljs.core.async.t_cljs$core$async32719.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32719");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32719.
 */
cljs.core.async.__GT_t_cljs$core$async32719 = (function cljs$core$async$__GT_t_cljs$core$async32719(f,ch,meta32721){
return (new cljs.core.async.t_cljs$core$async32719(f,ch,meta32721));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async32719(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32732 = (function (p,ch,meta32733){
this.p = p;
this.ch = ch;
this.meta32733 = meta32733;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32734,meta32733__$1){
var self__ = this;
var _32734__$1 = this;
return (new cljs.core.async.t_cljs$core$async32732(self__.p,self__.ch,meta32733__$1));
}));

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32734){
var self__ = this;
var _32734__$1 = this;
return self__.meta32733;
}));

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32732.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32732.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32733","meta32733",2088094294,null)], null);
}));

(cljs.core.async.t_cljs$core$async32732.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32732.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32732");

(cljs.core.async.t_cljs$core$async32732.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32732");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32732.
 */
cljs.core.async.__GT_t_cljs$core$async32732 = (function cljs$core$async$__GT_t_cljs$core$async32732(p,ch,meta32733){
return (new cljs.core.async.t_cljs$core$async32732(p,ch,meta32733));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async32732(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32750 = arguments.length;
switch (G__32750) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30087__auto___34729 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_32774){
var state_val_32775 = (state_32774[(1)]);
if((state_val_32775 === (7))){
var inst_32770 = (state_32774[(2)]);
var state_32774__$1 = state_32774;
var statearr_32781_34736 = state_32774__$1;
(statearr_32781_34736[(2)] = inst_32770);

(statearr_32781_34736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (1))){
var state_32774__$1 = state_32774;
var statearr_32782_34738 = state_32774__$1;
(statearr_32782_34738[(2)] = null);

(statearr_32782_34738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (4))){
var inst_32756 = (state_32774[(7)]);
var inst_32756__$1 = (state_32774[(2)]);
var inst_32757 = (inst_32756__$1 == null);
var state_32774__$1 = (function (){var statearr_32783 = state_32774;
(statearr_32783[(7)] = inst_32756__$1);

return statearr_32783;
})();
if(cljs.core.truth_(inst_32757)){
var statearr_32785_34739 = state_32774__$1;
(statearr_32785_34739[(1)] = (5));

} else {
var statearr_32787_34745 = state_32774__$1;
(statearr_32787_34745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (6))){
var inst_32756 = (state_32774[(7)]);
var inst_32761 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32756) : p.call(null,inst_32756));
var state_32774__$1 = state_32774;
if(cljs.core.truth_(inst_32761)){
var statearr_32788_34749 = state_32774__$1;
(statearr_32788_34749[(1)] = (8));

} else {
var statearr_32789_34750 = state_32774__$1;
(statearr_32789_34750[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (3))){
var inst_32772 = (state_32774[(2)]);
var state_32774__$1 = state_32774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32774__$1,inst_32772);
} else {
if((state_val_32775 === (2))){
var state_32774__$1 = state_32774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32774__$1,(4),ch);
} else {
if((state_val_32775 === (11))){
var inst_32764 = (state_32774[(2)]);
var state_32774__$1 = state_32774;
var statearr_32790_34753 = state_32774__$1;
(statearr_32790_34753[(2)] = inst_32764);

(statearr_32790_34753[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (9))){
var state_32774__$1 = state_32774;
var statearr_32792_34758 = state_32774__$1;
(statearr_32792_34758[(2)] = null);

(statearr_32792_34758[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (5))){
var inst_32759 = cljs.core.async.close_BANG_(out);
var state_32774__$1 = state_32774;
var statearr_32794_34766 = state_32774__$1;
(statearr_32794_34766[(2)] = inst_32759);

(statearr_32794_34766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (10))){
var inst_32767 = (state_32774[(2)]);
var state_32774__$1 = (function (){var statearr_32795 = state_32774;
(statearr_32795[(8)] = inst_32767);

return statearr_32795;
})();
var statearr_32799_34769 = state_32774__$1;
(statearr_32799_34769[(2)] = null);

(statearr_32799_34769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32775 === (8))){
var inst_32756 = (state_32774[(7)]);
var state_32774__$1 = state_32774;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32774__$1,(11),out,inst_32756);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_32801 = [null,null,null,null,null,null,null,null,null];
(statearr_32801[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_32801[(1)] = (1));

return statearr_32801;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_32774){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_32774);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e32802){var ex__29885__auto__ = e32802;
var statearr_32806_34784 = state_32774;
(statearr_32806_34784[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_32774[(4)]))){
var statearr_32807_34789 = state_32774;
(statearr_32807_34789[(1)] = cljs.core.first((state_32774[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34792 = state_32774;
state_32774 = G__34792;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_32774){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_32774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_32808 = f__30088__auto__();
(statearr_32808[(6)] = c__30087__auto___34729);

return statearr_32808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32813 = arguments.length;
switch (G__32813) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30087__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_32897){
var state_val_32898 = (state_32897[(1)]);
if((state_val_32898 === (7))){
var inst_32893 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32907_34809 = state_32897__$1;
(statearr_32907_34809[(2)] = inst_32893);

(statearr_32907_34809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (20))){
var inst_32846 = (state_32897[(7)]);
var inst_32867 = (state_32897[(2)]);
var inst_32871 = cljs.core.next(inst_32846);
var inst_32832 = inst_32871;
var inst_32833 = null;
var inst_32834 = (0);
var inst_32835 = (0);
var state_32897__$1 = (function (){var statearr_32908 = state_32897;
(statearr_32908[(8)] = inst_32867);

(statearr_32908[(9)] = inst_32832);

(statearr_32908[(10)] = inst_32833);

(statearr_32908[(11)] = inst_32834);

(statearr_32908[(12)] = inst_32835);

return statearr_32908;
})();
var statearr_32912_34817 = state_32897__$1;
(statearr_32912_34817[(2)] = null);

(statearr_32912_34817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (1))){
var state_32897__$1 = state_32897;
var statearr_32913_34821 = state_32897__$1;
(statearr_32913_34821[(2)] = null);

(statearr_32913_34821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (4))){
var inst_32821 = (state_32897[(13)]);
var inst_32821__$1 = (state_32897[(2)]);
var inst_32822 = (inst_32821__$1 == null);
var state_32897__$1 = (function (){var statearr_32918 = state_32897;
(statearr_32918[(13)] = inst_32821__$1);

return statearr_32918;
})();
if(cljs.core.truth_(inst_32822)){
var statearr_32919_34832 = state_32897__$1;
(statearr_32919_34832[(1)] = (5));

} else {
var statearr_32924_34835 = state_32897__$1;
(statearr_32924_34835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (15))){
var state_32897__$1 = state_32897;
var statearr_32931_34836 = state_32897__$1;
(statearr_32931_34836[(2)] = null);

(statearr_32931_34836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (21))){
var state_32897__$1 = state_32897;
var statearr_32935_34837 = state_32897__$1;
(statearr_32935_34837[(2)] = null);

(statearr_32935_34837[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (13))){
var inst_32835 = (state_32897[(12)]);
var inst_32832 = (state_32897[(9)]);
var inst_32833 = (state_32897[(10)]);
var inst_32834 = (state_32897[(11)]);
var inst_32842 = (state_32897[(2)]);
var inst_32843 = (inst_32835 + (1));
var tmp32928 = inst_32832;
var tmp32929 = inst_32833;
var tmp32930 = inst_32834;
var inst_32832__$1 = tmp32928;
var inst_32833__$1 = tmp32929;
var inst_32834__$1 = tmp32930;
var inst_32835__$1 = inst_32843;
var state_32897__$1 = (function (){var statearr_32936 = state_32897;
(statearr_32936[(14)] = inst_32842);

(statearr_32936[(9)] = inst_32832__$1);

(statearr_32936[(10)] = inst_32833__$1);

(statearr_32936[(11)] = inst_32834__$1);

(statearr_32936[(12)] = inst_32835__$1);

return statearr_32936;
})();
var statearr_32937_34839 = state_32897__$1;
(statearr_32937_34839[(2)] = null);

(statearr_32937_34839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (22))){
var state_32897__$1 = state_32897;
var statearr_32938_34842 = state_32897__$1;
(statearr_32938_34842[(2)] = null);

(statearr_32938_34842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (6))){
var inst_32821 = (state_32897[(13)]);
var inst_32830 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32821) : f.call(null,inst_32821));
var inst_32831 = cljs.core.seq(inst_32830);
var inst_32832 = inst_32831;
var inst_32833 = null;
var inst_32834 = (0);
var inst_32835 = (0);
var state_32897__$1 = (function (){var statearr_32942 = state_32897;
(statearr_32942[(9)] = inst_32832);

(statearr_32942[(10)] = inst_32833);

(statearr_32942[(11)] = inst_32834);

(statearr_32942[(12)] = inst_32835);

return statearr_32942;
})();
var statearr_32943_34846 = state_32897__$1;
(statearr_32943_34846[(2)] = null);

(statearr_32943_34846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (17))){
var inst_32846 = (state_32897[(7)]);
var inst_32856 = cljs.core.chunk_first(inst_32846);
var inst_32858 = cljs.core.chunk_rest(inst_32846);
var inst_32859 = cljs.core.count(inst_32856);
var inst_32832 = inst_32858;
var inst_32833 = inst_32856;
var inst_32834 = inst_32859;
var inst_32835 = (0);
var state_32897__$1 = (function (){var statearr_32944 = state_32897;
(statearr_32944[(9)] = inst_32832);

(statearr_32944[(10)] = inst_32833);

(statearr_32944[(11)] = inst_32834);

(statearr_32944[(12)] = inst_32835);

return statearr_32944;
})();
var statearr_32945_34850 = state_32897__$1;
(statearr_32945_34850[(2)] = null);

(statearr_32945_34850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (3))){
var inst_32895 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32897__$1,inst_32895);
} else {
if((state_val_32898 === (12))){
var inst_32881 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32946_34852 = state_32897__$1;
(statearr_32946_34852[(2)] = inst_32881);

(statearr_32946_34852[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (2))){
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32897__$1,(4),in$);
} else {
if((state_val_32898 === (23))){
var inst_32891 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32947_34855 = state_32897__$1;
(statearr_32947_34855[(2)] = inst_32891);

(statearr_32947_34855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (19))){
var inst_32874 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32952_34856 = state_32897__$1;
(statearr_32952_34856[(2)] = inst_32874);

(statearr_32952_34856[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (11))){
var inst_32832 = (state_32897[(9)]);
var inst_32846 = (state_32897[(7)]);
var inst_32846__$1 = cljs.core.seq(inst_32832);
var state_32897__$1 = (function (){var statearr_32953 = state_32897;
(statearr_32953[(7)] = inst_32846__$1);

return statearr_32953;
})();
if(inst_32846__$1){
var statearr_32954_34859 = state_32897__$1;
(statearr_32954_34859[(1)] = (14));

} else {
var statearr_32955_34860 = state_32897__$1;
(statearr_32955_34860[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (9))){
var inst_32883 = (state_32897[(2)]);
var inst_32886 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32897__$1 = (function (){var statearr_32957 = state_32897;
(statearr_32957[(15)] = inst_32883);

return statearr_32957;
})();
if(cljs.core.truth_(inst_32886)){
var statearr_32958_34861 = state_32897__$1;
(statearr_32958_34861[(1)] = (21));

} else {
var statearr_32959_34862 = state_32897__$1;
(statearr_32959_34862[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (5))){
var inst_32824 = cljs.core.async.close_BANG_(out);
var state_32897__$1 = state_32897;
var statearr_32963_34873 = state_32897__$1;
(statearr_32963_34873[(2)] = inst_32824);

(statearr_32963_34873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (14))){
var inst_32846 = (state_32897[(7)]);
var inst_32848 = cljs.core.chunked_seq_QMARK_(inst_32846);
var state_32897__$1 = state_32897;
if(inst_32848){
var statearr_32964_34879 = state_32897__$1;
(statearr_32964_34879[(1)] = (17));

} else {
var statearr_32965_34880 = state_32897__$1;
(statearr_32965_34880[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (16))){
var inst_32877 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32966_34886 = state_32897__$1;
(statearr_32966_34886[(2)] = inst_32877);

(statearr_32966_34886[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32898 === (10))){
var inst_32833 = (state_32897[(10)]);
var inst_32835 = (state_32897[(12)]);
var inst_32840 = cljs.core._nth(inst_32833,inst_32835);
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32897__$1,(13),out,inst_32840);
} else {
if((state_val_32898 === (18))){
var inst_32846 = (state_32897[(7)]);
var inst_32862 = cljs.core.first(inst_32846);
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32897__$1,(20),out,inst_32862);
} else {
if((state_val_32898 === (8))){
var inst_32835 = (state_32897[(12)]);
var inst_32834 = (state_32897[(11)]);
var inst_32837 = (inst_32835 < inst_32834);
var inst_32838 = inst_32837;
var state_32897__$1 = state_32897;
if(cljs.core.truth_(inst_32838)){
var statearr_32967_34890 = state_32897__$1;
(statearr_32967_34890[(1)] = (10));

} else {
var statearr_32968_34891 = state_32897__$1;
(statearr_32968_34891[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29882__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29882__auto____0 = (function (){
var statearr_32969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32969[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29882__auto__);

(statearr_32969[(1)] = (1));

return statearr_32969;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29882__auto____1 = (function (state_32897){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_32897);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e32970){var ex__29885__auto__ = e32970;
var statearr_32971_34906 = state_32897;
(statearr_32971_34906[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_32897[(4)]))){
var statearr_32972_34908 = state_32897;
(statearr_32972_34908[(1)] = cljs.core.first((state_32897[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34914 = state_32897;
state_32897 = G__34914;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29882__auto__ = function(state_32897){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29882__auto____1.call(this,state_32897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29882__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29882__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_32974 = f__30088__auto__();
(statearr_32974[(6)] = c__30087__auto__);

return statearr_32974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

return c__30087__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32998 = arguments.length;
switch (G__32998) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33012 = arguments.length;
switch (G__33012) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33016 = arguments.length;
switch (G__33016) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30087__auto___34933 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_33043){
var state_val_33044 = (state_33043[(1)]);
if((state_val_33044 === (7))){
var inst_33038 = (state_33043[(2)]);
var state_33043__$1 = state_33043;
var statearr_33049_34939 = state_33043__$1;
(statearr_33049_34939[(2)] = inst_33038);

(statearr_33049_34939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (1))){
var inst_33019 = null;
var state_33043__$1 = (function (){var statearr_33050 = state_33043;
(statearr_33050[(7)] = inst_33019);

return statearr_33050;
})();
var statearr_33052_34950 = state_33043__$1;
(statearr_33052_34950[(2)] = null);

(statearr_33052_34950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (4))){
var inst_33022 = (state_33043[(8)]);
var inst_33022__$1 = (state_33043[(2)]);
var inst_33023 = (inst_33022__$1 == null);
var inst_33024 = cljs.core.not(inst_33023);
var state_33043__$1 = (function (){var statearr_33053 = state_33043;
(statearr_33053[(8)] = inst_33022__$1);

return statearr_33053;
})();
if(inst_33024){
var statearr_33054_34964 = state_33043__$1;
(statearr_33054_34964[(1)] = (5));

} else {
var statearr_33055_34966 = state_33043__$1;
(statearr_33055_34966[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (6))){
var state_33043__$1 = state_33043;
var statearr_33056_34970 = state_33043__$1;
(statearr_33056_34970[(2)] = null);

(statearr_33056_34970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (3))){
var inst_33040 = (state_33043[(2)]);
var inst_33041 = cljs.core.async.close_BANG_(out);
var state_33043__$1 = (function (){var statearr_33057 = state_33043;
(statearr_33057[(9)] = inst_33040);

return statearr_33057;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33043__$1,inst_33041);
} else {
if((state_val_33044 === (2))){
var state_33043__$1 = state_33043;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33043__$1,(4),ch);
} else {
if((state_val_33044 === (11))){
var inst_33022 = (state_33043[(8)]);
var inst_33032 = (state_33043[(2)]);
var inst_33019 = inst_33022;
var state_33043__$1 = (function (){var statearr_33059 = state_33043;
(statearr_33059[(10)] = inst_33032);

(statearr_33059[(7)] = inst_33019);

return statearr_33059;
})();
var statearr_33060_34996 = state_33043__$1;
(statearr_33060_34996[(2)] = null);

(statearr_33060_34996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (9))){
var inst_33022 = (state_33043[(8)]);
var state_33043__$1 = state_33043;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33043__$1,(11),out,inst_33022);
} else {
if((state_val_33044 === (5))){
var inst_33022 = (state_33043[(8)]);
var inst_33019 = (state_33043[(7)]);
var inst_33026 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33022,inst_33019);
var state_33043__$1 = state_33043;
if(inst_33026){
var statearr_33062_35004 = state_33043__$1;
(statearr_33062_35004[(1)] = (8));

} else {
var statearr_33064_35006 = state_33043__$1;
(statearr_33064_35006[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (10))){
var inst_33035 = (state_33043[(2)]);
var state_33043__$1 = state_33043;
var statearr_33069_35016 = state_33043__$1;
(statearr_33069_35016[(2)] = inst_33035);

(statearr_33069_35016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33044 === (8))){
var inst_33019 = (state_33043[(7)]);
var tmp33061 = inst_33019;
var inst_33019__$1 = tmp33061;
var state_33043__$1 = (function (){var statearr_33070 = state_33043;
(statearr_33070[(7)] = inst_33019__$1);

return statearr_33070;
})();
var statearr_33072_35017 = state_33043__$1;
(statearr_33072_35017[(2)] = null);

(statearr_33072_35017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_33073 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33073[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_33073[(1)] = (1));

return statearr_33073;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_33043){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_33043);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e33074){var ex__29885__auto__ = e33074;
var statearr_33075_35034 = state_33043;
(statearr_33075_35034[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_33043[(4)]))){
var statearr_33076_35045 = state_33043;
(statearr_33076_35045[(1)] = cljs.core.first((state_33043[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35057 = state_33043;
state_33043 = G__35057;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_33043){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_33043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_33079 = f__30088__auto__();
(statearr_33079[(6)] = c__30087__auto___34933);

return statearr_33079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33087 = arguments.length;
switch (G__33087) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30087__auto___35069 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_33129){
var state_val_33130 = (state_33129[(1)]);
if((state_val_33130 === (7))){
var inst_33125 = (state_33129[(2)]);
var state_33129__$1 = state_33129;
var statearr_33131_35078 = state_33129__$1;
(statearr_33131_35078[(2)] = inst_33125);

(statearr_33131_35078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (1))){
var inst_33092 = (new Array(n));
var inst_33093 = inst_33092;
var inst_33094 = (0);
var state_33129__$1 = (function (){var statearr_33132 = state_33129;
(statearr_33132[(7)] = inst_33093);

(statearr_33132[(8)] = inst_33094);

return statearr_33132;
})();
var statearr_33133_35094 = state_33129__$1;
(statearr_33133_35094[(2)] = null);

(statearr_33133_35094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (4))){
var inst_33097 = (state_33129[(9)]);
var inst_33097__$1 = (state_33129[(2)]);
var inst_33098 = (inst_33097__$1 == null);
var inst_33099 = cljs.core.not(inst_33098);
var state_33129__$1 = (function (){var statearr_33134 = state_33129;
(statearr_33134[(9)] = inst_33097__$1);

return statearr_33134;
})();
if(inst_33099){
var statearr_33135_35101 = state_33129__$1;
(statearr_33135_35101[(1)] = (5));

} else {
var statearr_33136_35102 = state_33129__$1;
(statearr_33136_35102[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (15))){
var inst_33119 = (state_33129[(2)]);
var state_33129__$1 = state_33129;
var statearr_33137_35107 = state_33129__$1;
(statearr_33137_35107[(2)] = inst_33119);

(statearr_33137_35107[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (13))){
var state_33129__$1 = state_33129;
var statearr_33142_35110 = state_33129__$1;
(statearr_33142_35110[(2)] = null);

(statearr_33142_35110[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (6))){
var inst_33094 = (state_33129[(8)]);
var inst_33115 = (inst_33094 > (0));
var state_33129__$1 = state_33129;
if(cljs.core.truth_(inst_33115)){
var statearr_33144_35124 = state_33129__$1;
(statearr_33144_35124[(1)] = (12));

} else {
var statearr_33145_35126 = state_33129__$1;
(statearr_33145_35126[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (3))){
var inst_33127 = (state_33129[(2)]);
var state_33129__$1 = state_33129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33129__$1,inst_33127);
} else {
if((state_val_33130 === (12))){
var inst_33093 = (state_33129[(7)]);
var inst_33117 = cljs.core.vec(inst_33093);
var state_33129__$1 = state_33129;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33129__$1,(15),out,inst_33117);
} else {
if((state_val_33130 === (2))){
var state_33129__$1 = state_33129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33129__$1,(4),ch);
} else {
if((state_val_33130 === (11))){
var inst_33109 = (state_33129[(2)]);
var inst_33110 = (new Array(n));
var inst_33093 = inst_33110;
var inst_33094 = (0);
var state_33129__$1 = (function (){var statearr_33155 = state_33129;
(statearr_33155[(10)] = inst_33109);

(statearr_33155[(7)] = inst_33093);

(statearr_33155[(8)] = inst_33094);

return statearr_33155;
})();
var statearr_33156_35149 = state_33129__$1;
(statearr_33156_35149[(2)] = null);

(statearr_33156_35149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (9))){
var inst_33093 = (state_33129[(7)]);
var inst_33107 = cljs.core.vec(inst_33093);
var state_33129__$1 = state_33129;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33129__$1,(11),out,inst_33107);
} else {
if((state_val_33130 === (5))){
var inst_33093 = (state_33129[(7)]);
var inst_33094 = (state_33129[(8)]);
var inst_33097 = (state_33129[(9)]);
var inst_33102 = (state_33129[(11)]);
var inst_33101 = (inst_33093[inst_33094] = inst_33097);
var inst_33102__$1 = (inst_33094 + (1));
var inst_33103 = (inst_33102__$1 < n);
var state_33129__$1 = (function (){var statearr_33157 = state_33129;
(statearr_33157[(12)] = inst_33101);

(statearr_33157[(11)] = inst_33102__$1);

return statearr_33157;
})();
if(cljs.core.truth_(inst_33103)){
var statearr_33158_35164 = state_33129__$1;
(statearr_33158_35164[(1)] = (8));

} else {
var statearr_33161_35174 = state_33129__$1;
(statearr_33161_35174[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (14))){
var inst_33122 = (state_33129[(2)]);
var inst_33123 = cljs.core.async.close_BANG_(out);
var state_33129__$1 = (function (){var statearr_33163 = state_33129;
(statearr_33163[(13)] = inst_33122);

return statearr_33163;
})();
var statearr_33164_35177 = state_33129__$1;
(statearr_33164_35177[(2)] = inst_33123);

(statearr_33164_35177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (10))){
var inst_33113 = (state_33129[(2)]);
var state_33129__$1 = state_33129;
var statearr_33165_35178 = state_33129__$1;
(statearr_33165_35178[(2)] = inst_33113);

(statearr_33165_35178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33130 === (8))){
var inst_33093 = (state_33129[(7)]);
var inst_33102 = (state_33129[(11)]);
var tmp33162 = inst_33093;
var inst_33093__$1 = tmp33162;
var inst_33094 = inst_33102;
var state_33129__$1 = (function (){var statearr_33166 = state_33129;
(statearr_33166[(7)] = inst_33093__$1);

(statearr_33166[(8)] = inst_33094);

return statearr_33166;
})();
var statearr_33167_35184 = state_33129__$1;
(statearr_33167_35184[(2)] = null);

(statearr_33167_35184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_33168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33168[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_33168[(1)] = (1));

return statearr_33168;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_33129){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_33129);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e33169){var ex__29885__auto__ = e33169;
var statearr_33170_35187 = state_33129;
(statearr_33170_35187[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_33129[(4)]))){
var statearr_33171_35188 = state_33129;
(statearr_33171_35188[(1)] = cljs.core.first((state_33129[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35191 = state_33129;
state_33129 = G__35191;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_33129){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_33129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_33172 = f__30088__auto__();
(statearr_33172[(6)] = c__30087__auto___35069);

return statearr_33172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33180 = arguments.length;
switch (G__33180) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30087__auto___35196 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_33228){
var state_val_33229 = (state_33228[(1)]);
if((state_val_33229 === (7))){
var inst_33224 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
var statearr_33230_35205 = state_33228__$1;
(statearr_33230_35205[(2)] = inst_33224);

(statearr_33230_35205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (1))){
var inst_33184 = [];
var inst_33185 = inst_33184;
var inst_33186 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33228__$1 = (function (){var statearr_33232 = state_33228;
(statearr_33232[(7)] = inst_33185);

(statearr_33232[(8)] = inst_33186);

return statearr_33232;
})();
var statearr_33233_35221 = state_33228__$1;
(statearr_33233_35221[(2)] = null);

(statearr_33233_35221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (4))){
var inst_33189 = (state_33228[(9)]);
var inst_33189__$1 = (state_33228[(2)]);
var inst_33190 = (inst_33189__$1 == null);
var inst_33191 = cljs.core.not(inst_33190);
var state_33228__$1 = (function (){var statearr_33236 = state_33228;
(statearr_33236[(9)] = inst_33189__$1);

return statearr_33236;
})();
if(inst_33191){
var statearr_33237_35243 = state_33228__$1;
(statearr_33237_35243[(1)] = (5));

} else {
var statearr_33238_35249 = state_33228__$1;
(statearr_33238_35249[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (15))){
var inst_33185 = (state_33228[(7)]);
var inst_33216 = cljs.core.vec(inst_33185);
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33228__$1,(18),out,inst_33216);
} else {
if((state_val_33229 === (13))){
var inst_33211 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
var statearr_33241_35261 = state_33228__$1;
(statearr_33241_35261[(2)] = inst_33211);

(statearr_33241_35261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (6))){
var inst_33185 = (state_33228[(7)]);
var inst_33213 = inst_33185.length;
var inst_33214 = (inst_33213 > (0));
var state_33228__$1 = state_33228;
if(cljs.core.truth_(inst_33214)){
var statearr_33245_35271 = state_33228__$1;
(statearr_33245_35271[(1)] = (15));

} else {
var statearr_33246_35272 = state_33228__$1;
(statearr_33246_35272[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (17))){
var inst_33221 = (state_33228[(2)]);
var inst_33222 = cljs.core.async.close_BANG_(out);
var state_33228__$1 = (function (){var statearr_33249 = state_33228;
(statearr_33249[(10)] = inst_33221);

return statearr_33249;
})();
var statearr_33250_35280 = state_33228__$1;
(statearr_33250_35280[(2)] = inst_33222);

(statearr_33250_35280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (3))){
var inst_33226 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33228__$1,inst_33226);
} else {
if((state_val_33229 === (12))){
var inst_33185 = (state_33228[(7)]);
var inst_33204 = cljs.core.vec(inst_33185);
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33228__$1,(14),out,inst_33204);
} else {
if((state_val_33229 === (2))){
var state_33228__$1 = state_33228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33228__$1,(4),ch);
} else {
if((state_val_33229 === (11))){
var inst_33185 = (state_33228[(7)]);
var inst_33189 = (state_33228[(9)]);
var inst_33193 = (state_33228[(11)]);
var inst_33201 = inst_33185.push(inst_33189);
var tmp33253 = inst_33185;
var inst_33185__$1 = tmp33253;
var inst_33186 = inst_33193;
var state_33228__$1 = (function (){var statearr_33255 = state_33228;
(statearr_33255[(12)] = inst_33201);

(statearr_33255[(7)] = inst_33185__$1);

(statearr_33255[(8)] = inst_33186);

return statearr_33255;
})();
var statearr_33256_35332 = state_33228__$1;
(statearr_33256_35332[(2)] = null);

(statearr_33256_35332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (9))){
var inst_33186 = (state_33228[(8)]);
var inst_33197 = cljs.core.keyword_identical_QMARK_(inst_33186,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_33228__$1 = state_33228;
var statearr_33257_35348 = state_33228__$1;
(statearr_33257_35348[(2)] = inst_33197);

(statearr_33257_35348[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (5))){
var inst_33189 = (state_33228[(9)]);
var inst_33193 = (state_33228[(11)]);
var inst_33186 = (state_33228[(8)]);
var inst_33194 = (state_33228[(13)]);
var inst_33193__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33189) : f.call(null,inst_33189));
var inst_33194__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33193__$1,inst_33186);
var state_33228__$1 = (function (){var statearr_33258 = state_33228;
(statearr_33258[(11)] = inst_33193__$1);

(statearr_33258[(13)] = inst_33194__$1);

return statearr_33258;
})();
if(inst_33194__$1){
var statearr_33259_35364 = state_33228__$1;
(statearr_33259_35364[(1)] = (8));

} else {
var statearr_33260_35369 = state_33228__$1;
(statearr_33260_35369[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (14))){
var inst_33189 = (state_33228[(9)]);
var inst_33193 = (state_33228[(11)]);
var inst_33206 = (state_33228[(2)]);
var inst_33207 = [];
var inst_33208 = inst_33207.push(inst_33189);
var inst_33185 = inst_33207;
var inst_33186 = inst_33193;
var state_33228__$1 = (function (){var statearr_33261 = state_33228;
(statearr_33261[(14)] = inst_33206);

(statearr_33261[(15)] = inst_33208);

(statearr_33261[(7)] = inst_33185);

(statearr_33261[(8)] = inst_33186);

return statearr_33261;
})();
var statearr_33262_35371 = state_33228__$1;
(statearr_33262_35371[(2)] = null);

(statearr_33262_35371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (16))){
var state_33228__$1 = state_33228;
var statearr_33263_35374 = state_33228__$1;
(statearr_33263_35374[(2)] = null);

(statearr_33263_35374[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (10))){
var inst_33199 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
if(cljs.core.truth_(inst_33199)){
var statearr_33264_35379 = state_33228__$1;
(statearr_33264_35379[(1)] = (11));

} else {
var statearr_33265_35385 = state_33228__$1;
(statearr_33265_35385[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (18))){
var inst_33218 = (state_33228[(2)]);
var state_33228__$1 = state_33228;
var statearr_33267_35390 = state_33228__$1;
(statearr_33267_35390[(2)] = inst_33218);

(statearr_33267_35390[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33229 === (8))){
var inst_33194 = (state_33228[(13)]);
var state_33228__$1 = state_33228;
var statearr_33268_35402 = state_33228__$1;
(statearr_33268_35402[(2)] = inst_33194);

(statearr_33268_35402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__29882__auto__ = null;
var cljs$core$async$state_machine__29882__auto____0 = (function (){
var statearr_33269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33269[(0)] = cljs$core$async$state_machine__29882__auto__);

(statearr_33269[(1)] = (1));

return statearr_33269;
});
var cljs$core$async$state_machine__29882__auto____1 = (function (state_33228){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_33228);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e33270){var ex__29885__auto__ = e33270;
var statearr_33271_35417 = state_33228;
(statearr_33271_35417[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_33228[(4)]))){
var statearr_33275_35418 = state_33228;
(statearr_33275_35418[(1)] = cljs.core.first((state_33228[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35424 = state_33228;
state_33228 = G__35424;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
cljs$core$async$state_machine__29882__auto__ = function(state_33228){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29882__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29882__auto____1.call(this,state_33228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29882__auto____0;
cljs$core$async$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29882__auto____1;
return cljs$core$async$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_33278 = f__30088__auto__();
(statearr_33278[(6)] = c__30087__auto___35196);

return statearr_33278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
