goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_34844 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_34844(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_34848 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_34848(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__33465 = coll;
var G__33466 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__33465,G__33466) : shadow.dom.lazy_native_coll_seq.call(null,G__33465,G__33466));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__33515 = arguments.length;
switch (G__33515) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__33527 = arguments.length;
switch (G__33527) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__33535 = arguments.length;
switch (G__33535) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__33544 = arguments.length;
switch (G__33544) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33559 = arguments.length;
switch (G__33559) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33577 = arguments.length;
switch (G__33577) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33601){if((e33601 instanceof Object)){
var e = e33601;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33601;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33608 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33609 = null;
var count__33610 = (0);
var i__33611 = (0);
while(true){
if((i__33611 < count__33610)){
var el = chunk__33609.cljs$core$IIndexed$_nth$arity$2(null,i__33611);
var handler_34965__$1 = ((function (seq__33608,chunk__33609,count__33610,i__33611,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33608,chunk__33609,count__33610,i__33611,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34965__$1);


var G__34971 = seq__33608;
var G__34972 = chunk__33609;
var G__34973 = count__33610;
var G__34974 = (i__33611 + (1));
seq__33608 = G__34971;
chunk__33609 = G__34972;
count__33610 = G__34973;
i__33611 = G__34974;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33608);
if(temp__5804__auto__){
var seq__33608__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33608__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33608__$1);
var G__34983 = cljs.core.chunk_rest(seq__33608__$1);
var G__34984 = c__5568__auto__;
var G__34985 = cljs.core.count(c__5568__auto__);
var G__34986 = (0);
seq__33608 = G__34983;
chunk__33609 = G__34984;
count__33610 = G__34985;
i__33611 = G__34986;
continue;
} else {
var el = cljs.core.first(seq__33608__$1);
var handler_34991__$1 = ((function (seq__33608,chunk__33609,count__33610,i__33611,el,seq__33608__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33608,chunk__33609,count__33610,i__33611,el,seq__33608__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34991__$1);


var G__34992 = cljs.core.next(seq__33608__$1);
var G__34993 = null;
var G__34994 = (0);
var G__34995 = (0);
seq__33608 = G__34992;
chunk__33609 = G__34993;
count__33610 = G__34994;
i__33611 = G__34995;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33646 = arguments.length;
switch (G__33646) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33684 = cljs.core.seq(events);
var chunk__33685 = null;
var count__33686 = (0);
var i__33687 = (0);
while(true){
if((i__33687 < count__33686)){
var vec__33710 = chunk__33685.cljs$core$IIndexed$_nth$arity$2(null,i__33687);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33710,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33710,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35027 = seq__33684;
var G__35028 = chunk__33685;
var G__35029 = count__33686;
var G__35030 = (i__33687 + (1));
seq__33684 = G__35027;
chunk__33685 = G__35028;
count__33686 = G__35029;
i__33687 = G__35030;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33684);
if(temp__5804__auto__){
var seq__33684__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33684__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33684__$1);
var G__35036 = cljs.core.chunk_rest(seq__33684__$1);
var G__35037 = c__5568__auto__;
var G__35038 = cljs.core.count(c__5568__auto__);
var G__35039 = (0);
seq__33684 = G__35036;
chunk__33685 = G__35037;
count__33686 = G__35038;
i__33687 = G__35039;
continue;
} else {
var vec__33716 = cljs.core.first(seq__33684__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33716,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33716,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35058 = cljs.core.next(seq__33684__$1);
var G__35059 = null;
var G__35060 = (0);
var G__35061 = (0);
seq__33684 = G__35058;
chunk__33685 = G__35059;
count__33686 = G__35060;
i__33687 = G__35061;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__33720 = cljs.core.seq(styles);
var chunk__33721 = null;
var count__33722 = (0);
var i__33723 = (0);
while(true){
if((i__33723 < count__33722)){
var vec__33740 = chunk__33721.cljs$core$IIndexed$_nth$arity$2(null,i__33723);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33740,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33740,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35064 = seq__33720;
var G__35065 = chunk__33721;
var G__35066 = count__33722;
var G__35067 = (i__33723 + (1));
seq__33720 = G__35064;
chunk__33721 = G__35065;
count__33722 = G__35066;
i__33723 = G__35067;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33720);
if(temp__5804__auto__){
var seq__33720__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33720__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33720__$1);
var G__35070 = cljs.core.chunk_rest(seq__33720__$1);
var G__35071 = c__5568__auto__;
var G__35072 = cljs.core.count(c__5568__auto__);
var G__35073 = (0);
seq__33720 = G__35070;
chunk__33721 = G__35071;
count__33722 = G__35072;
i__33723 = G__35073;
continue;
} else {
var vec__33749 = cljs.core.first(seq__33720__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33749,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33749,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35084 = cljs.core.next(seq__33720__$1);
var G__35085 = null;
var G__35086 = (0);
var G__35087 = (0);
seq__33720 = G__35084;
chunk__33721 = G__35085;
count__33722 = G__35086;
i__33723 = G__35087;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__33764_35092 = key;
var G__33764_35093__$1 = (((G__33764_35092 instanceof cljs.core.Keyword))?G__33764_35092.fqn:null);
switch (G__33764_35093__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35125 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35125,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35125,"aria-");
}
})())){
el.setAttribute(ks_35125,value);
} else {
(el[ks_35125] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__33813){
var map__33815 = p__33813;
var map__33815__$1 = cljs.core.__destructure_map(map__33815);
var props = map__33815__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33815__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__33819 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33819,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33819,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33819,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__33824 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__33824,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__33824;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__33832 = arguments.length;
switch (G__33832) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__33845){
var vec__33847 = p__33845;
var seq__33848 = cljs.core.seq(vec__33847);
var first__33849 = cljs.core.first(seq__33848);
var seq__33848__$1 = cljs.core.next(seq__33848);
var nn = first__33849;
var first__33849__$1 = cljs.core.first(seq__33848__$1);
var seq__33848__$2 = cljs.core.next(seq__33848__$1);
var np = first__33849__$1;
var nc = seq__33848__$2;
var node = vec__33847;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33854 = nn;
var G__33855 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33854,G__33855) : create_fn.call(null,G__33854,G__33855));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33869 = nn;
var G__33870 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33869,G__33870) : create_fn.call(null,G__33869,G__33870));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__33878 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33878,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33878,(1),null);
var seq__33886_35210 = cljs.core.seq(node_children);
var chunk__33887_35211 = null;
var count__33888_35213 = (0);
var i__33889_35214 = (0);
while(true){
if((i__33889_35214 < count__33888_35213)){
var child_struct_35220 = chunk__33887_35211.cljs$core$IIndexed$_nth$arity$2(null,i__33889_35214);
var children_35223 = shadow.dom.dom_node(child_struct_35220);
if(cljs.core.seq_QMARK_(children_35223)){
var seq__33932_35228 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35223));
var chunk__33934_35229 = null;
var count__33935_35230 = (0);
var i__33936_35231 = (0);
while(true){
if((i__33936_35231 < count__33935_35230)){
var child_35238 = chunk__33934_35229.cljs$core$IIndexed$_nth$arity$2(null,i__33936_35231);
if(cljs.core.truth_(child_35238)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35238);


var G__35245 = seq__33932_35228;
var G__35246 = chunk__33934_35229;
var G__35247 = count__33935_35230;
var G__35248 = (i__33936_35231 + (1));
seq__33932_35228 = G__35245;
chunk__33934_35229 = G__35246;
count__33935_35230 = G__35247;
i__33936_35231 = G__35248;
continue;
} else {
var G__35250 = seq__33932_35228;
var G__35251 = chunk__33934_35229;
var G__35252 = count__33935_35230;
var G__35253 = (i__33936_35231 + (1));
seq__33932_35228 = G__35250;
chunk__33934_35229 = G__35251;
count__33935_35230 = G__35252;
i__33936_35231 = G__35253;
continue;
}
} else {
var temp__5804__auto___35254 = cljs.core.seq(seq__33932_35228);
if(temp__5804__auto___35254){
var seq__33932_35255__$1 = temp__5804__auto___35254;
if(cljs.core.chunked_seq_QMARK_(seq__33932_35255__$1)){
var c__5568__auto___35256 = cljs.core.chunk_first(seq__33932_35255__$1);
var G__35257 = cljs.core.chunk_rest(seq__33932_35255__$1);
var G__35258 = c__5568__auto___35256;
var G__35259 = cljs.core.count(c__5568__auto___35256);
var G__35260 = (0);
seq__33932_35228 = G__35257;
chunk__33934_35229 = G__35258;
count__33935_35230 = G__35259;
i__33936_35231 = G__35260;
continue;
} else {
var child_35262 = cljs.core.first(seq__33932_35255__$1);
if(cljs.core.truth_(child_35262)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35262);


var G__35263 = cljs.core.next(seq__33932_35255__$1);
var G__35264 = null;
var G__35265 = (0);
var G__35266 = (0);
seq__33932_35228 = G__35263;
chunk__33934_35229 = G__35264;
count__33935_35230 = G__35265;
i__33936_35231 = G__35266;
continue;
} else {
var G__35267 = cljs.core.next(seq__33932_35255__$1);
var G__35268 = null;
var G__35269 = (0);
var G__35270 = (0);
seq__33932_35228 = G__35267;
chunk__33934_35229 = G__35268;
count__33935_35230 = G__35269;
i__33936_35231 = G__35270;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35223);
}


var G__35273 = seq__33886_35210;
var G__35274 = chunk__33887_35211;
var G__35275 = count__33888_35213;
var G__35276 = (i__33889_35214 + (1));
seq__33886_35210 = G__35273;
chunk__33887_35211 = G__35274;
count__33888_35213 = G__35275;
i__33889_35214 = G__35276;
continue;
} else {
var temp__5804__auto___35277 = cljs.core.seq(seq__33886_35210);
if(temp__5804__auto___35277){
var seq__33886_35278__$1 = temp__5804__auto___35277;
if(cljs.core.chunked_seq_QMARK_(seq__33886_35278__$1)){
var c__5568__auto___35279 = cljs.core.chunk_first(seq__33886_35278__$1);
var G__35281 = cljs.core.chunk_rest(seq__33886_35278__$1);
var G__35282 = c__5568__auto___35279;
var G__35283 = cljs.core.count(c__5568__auto___35279);
var G__35284 = (0);
seq__33886_35210 = G__35281;
chunk__33887_35211 = G__35282;
count__33888_35213 = G__35283;
i__33889_35214 = G__35284;
continue;
} else {
var child_struct_35289 = cljs.core.first(seq__33886_35278__$1);
var children_35291 = shadow.dom.dom_node(child_struct_35289);
if(cljs.core.seq_QMARK_(children_35291)){
var seq__33973_35292 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35291));
var chunk__33975_35293 = null;
var count__33976_35294 = (0);
var i__33977_35295 = (0);
while(true){
if((i__33977_35295 < count__33976_35294)){
var child_35305 = chunk__33975_35293.cljs$core$IIndexed$_nth$arity$2(null,i__33977_35295);
if(cljs.core.truth_(child_35305)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35305);


var G__35306 = seq__33973_35292;
var G__35307 = chunk__33975_35293;
var G__35308 = count__33976_35294;
var G__35309 = (i__33977_35295 + (1));
seq__33973_35292 = G__35306;
chunk__33975_35293 = G__35307;
count__33976_35294 = G__35308;
i__33977_35295 = G__35309;
continue;
} else {
var G__35312 = seq__33973_35292;
var G__35313 = chunk__33975_35293;
var G__35314 = count__33976_35294;
var G__35315 = (i__33977_35295 + (1));
seq__33973_35292 = G__35312;
chunk__33975_35293 = G__35313;
count__33976_35294 = G__35314;
i__33977_35295 = G__35315;
continue;
}
} else {
var temp__5804__auto___35316__$1 = cljs.core.seq(seq__33973_35292);
if(temp__5804__auto___35316__$1){
var seq__33973_35321__$1 = temp__5804__auto___35316__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33973_35321__$1)){
var c__5568__auto___35326 = cljs.core.chunk_first(seq__33973_35321__$1);
var G__35327 = cljs.core.chunk_rest(seq__33973_35321__$1);
var G__35328 = c__5568__auto___35326;
var G__35329 = cljs.core.count(c__5568__auto___35326);
var G__35330 = (0);
seq__33973_35292 = G__35327;
chunk__33975_35293 = G__35328;
count__33976_35294 = G__35329;
i__33977_35295 = G__35330;
continue;
} else {
var child_35333 = cljs.core.first(seq__33973_35321__$1);
if(cljs.core.truth_(child_35333)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35333);


var G__35336 = cljs.core.next(seq__33973_35321__$1);
var G__35337 = null;
var G__35338 = (0);
var G__35339 = (0);
seq__33973_35292 = G__35336;
chunk__33975_35293 = G__35337;
count__33976_35294 = G__35338;
i__33977_35295 = G__35339;
continue;
} else {
var G__35344 = cljs.core.next(seq__33973_35321__$1);
var G__35345 = null;
var G__35346 = (0);
var G__35347 = (0);
seq__33973_35292 = G__35344;
chunk__33975_35293 = G__35345;
count__33976_35294 = G__35346;
i__33977_35295 = G__35347;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35291);
}


var G__35356 = cljs.core.next(seq__33886_35278__$1);
var G__35357 = null;
var G__35358 = (0);
var G__35359 = (0);
seq__33886_35210 = G__35356;
chunk__33887_35211 = G__35357;
count__33888_35213 = G__35358;
i__33889_35214 = G__35359;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34042 = cljs.core.seq(node);
var chunk__34043 = null;
var count__34044 = (0);
var i__34045 = (0);
while(true){
if((i__34045 < count__34044)){
var n = chunk__34043.cljs$core$IIndexed$_nth$arity$2(null,i__34045);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35380 = seq__34042;
var G__35381 = chunk__34043;
var G__35382 = count__34044;
var G__35383 = (i__34045 + (1));
seq__34042 = G__35380;
chunk__34043 = G__35381;
count__34044 = G__35382;
i__34045 = G__35383;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34042);
if(temp__5804__auto__){
var seq__34042__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34042__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34042__$1);
var G__35391 = cljs.core.chunk_rest(seq__34042__$1);
var G__35392 = c__5568__auto__;
var G__35393 = cljs.core.count(c__5568__auto__);
var G__35394 = (0);
seq__34042 = G__35391;
chunk__34043 = G__35392;
count__34044 = G__35393;
i__34045 = G__35394;
continue;
} else {
var n = cljs.core.first(seq__34042__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35403 = cljs.core.next(seq__34042__$1);
var G__35404 = null;
var G__35405 = (0);
var G__35406 = (0);
seq__34042 = G__35403;
chunk__34043 = G__35404;
count__34044 = G__35405;
i__34045 = G__35406;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34062 = arguments.length;
switch (G__34062) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34071 = arguments.length;
switch (G__34071) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34092 = arguments.length;
switch (G__34092) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35443 = arguments.length;
var i__5770__auto___35444 = (0);
while(true){
if((i__5770__auto___35444 < len__5769__auto___35443)){
args__5775__auto__.push((arguments[i__5770__auto___35444]));

var G__35446 = (i__5770__auto___35444 + (1));
i__5770__auto___35444 = G__35446;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34116_35449 = cljs.core.seq(nodes);
var chunk__34117_35450 = null;
var count__34118_35451 = (0);
var i__34119_35452 = (0);
while(true){
if((i__34119_35452 < count__34118_35451)){
var node_35455 = chunk__34117_35450.cljs$core$IIndexed$_nth$arity$2(null,i__34119_35452);
fragment.appendChild(shadow.dom._to_dom(node_35455));


var G__35456 = seq__34116_35449;
var G__35457 = chunk__34117_35450;
var G__35458 = count__34118_35451;
var G__35459 = (i__34119_35452 + (1));
seq__34116_35449 = G__35456;
chunk__34117_35450 = G__35457;
count__34118_35451 = G__35458;
i__34119_35452 = G__35459;
continue;
} else {
var temp__5804__auto___35462 = cljs.core.seq(seq__34116_35449);
if(temp__5804__auto___35462){
var seq__34116_35463__$1 = temp__5804__auto___35462;
if(cljs.core.chunked_seq_QMARK_(seq__34116_35463__$1)){
var c__5568__auto___35464 = cljs.core.chunk_first(seq__34116_35463__$1);
var G__35465 = cljs.core.chunk_rest(seq__34116_35463__$1);
var G__35466 = c__5568__auto___35464;
var G__35467 = cljs.core.count(c__5568__auto___35464);
var G__35468 = (0);
seq__34116_35449 = G__35465;
chunk__34117_35450 = G__35466;
count__34118_35451 = G__35467;
i__34119_35452 = G__35468;
continue;
} else {
var node_35469 = cljs.core.first(seq__34116_35463__$1);
fragment.appendChild(shadow.dom._to_dom(node_35469));


var G__35471 = cljs.core.next(seq__34116_35463__$1);
var G__35473 = null;
var G__35474 = (0);
var G__35475 = (0);
seq__34116_35449 = G__35471;
chunk__34117_35450 = G__35473;
count__34118_35451 = G__35474;
i__34119_35452 = G__35475;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34113){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34113));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34141_35479 = cljs.core.seq(scripts);
var chunk__34142_35480 = null;
var count__34143_35481 = (0);
var i__34144_35482 = (0);
while(true){
if((i__34144_35482 < count__34143_35481)){
var vec__34174_35483 = chunk__34142_35480.cljs$core$IIndexed$_nth$arity$2(null,i__34144_35482);
var script_tag_35484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34174_35483,(0),null);
var script_body_35485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34174_35483,(1),null);
eval(script_body_35485);


var G__35490 = seq__34141_35479;
var G__35491 = chunk__34142_35480;
var G__35492 = count__34143_35481;
var G__35493 = (i__34144_35482 + (1));
seq__34141_35479 = G__35490;
chunk__34142_35480 = G__35491;
count__34143_35481 = G__35492;
i__34144_35482 = G__35493;
continue;
} else {
var temp__5804__auto___35494 = cljs.core.seq(seq__34141_35479);
if(temp__5804__auto___35494){
var seq__34141_35498__$1 = temp__5804__auto___35494;
if(cljs.core.chunked_seq_QMARK_(seq__34141_35498__$1)){
var c__5568__auto___35499 = cljs.core.chunk_first(seq__34141_35498__$1);
var G__35500 = cljs.core.chunk_rest(seq__34141_35498__$1);
var G__35501 = c__5568__auto___35499;
var G__35502 = cljs.core.count(c__5568__auto___35499);
var G__35503 = (0);
seq__34141_35479 = G__35500;
chunk__34142_35480 = G__35501;
count__34143_35481 = G__35502;
i__34144_35482 = G__35503;
continue;
} else {
var vec__34179_35504 = cljs.core.first(seq__34141_35498__$1);
var script_tag_35505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34179_35504,(0),null);
var script_body_35506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34179_35504,(1),null);
eval(script_body_35506);


var G__35507 = cljs.core.next(seq__34141_35498__$1);
var G__35508 = null;
var G__35509 = (0);
var G__35510 = (0);
seq__34141_35479 = G__35507;
chunk__34142_35480 = G__35508;
count__34143_35481 = G__35509;
i__34144_35482 = G__35510;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__34188){
var vec__34189 = p__34188;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34189,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34189,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__34222 = arguments.length;
switch (G__34222) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__34257 = cljs.core.seq(style_keys);
var chunk__34258 = null;
var count__34259 = (0);
var i__34260 = (0);
while(true){
if((i__34260 < count__34259)){
var it = chunk__34258.cljs$core$IIndexed$_nth$arity$2(null,i__34260);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35526 = seq__34257;
var G__35527 = chunk__34258;
var G__35528 = count__34259;
var G__35529 = (i__34260 + (1));
seq__34257 = G__35526;
chunk__34258 = G__35527;
count__34259 = G__35528;
i__34260 = G__35529;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34257);
if(temp__5804__auto__){
var seq__34257__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34257__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34257__$1);
var G__35531 = cljs.core.chunk_rest(seq__34257__$1);
var G__35532 = c__5568__auto__;
var G__35533 = cljs.core.count(c__5568__auto__);
var G__35534 = (0);
seq__34257 = G__35531;
chunk__34258 = G__35532;
count__34259 = G__35533;
i__34260 = G__35534;
continue;
} else {
var it = cljs.core.first(seq__34257__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35535 = cljs.core.next(seq__34257__$1);
var G__35536 = null;
var G__35537 = (0);
var G__35538 = (0);
seq__34257 = G__35535;
chunk__34258 = G__35536;
count__34259 = G__35537;
i__34260 = G__35538;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34271,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34286 = k34271;
var G__34286__$1 = (((G__34286 instanceof cljs.core.Keyword))?G__34286.fqn:null);
switch (G__34286__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34271,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34302){
var vec__34303 = p__34302;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34303,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34303,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34270){
var self__ = this;
var G__34270__$1 = this;
return (new cljs.core.RecordIter((0),G__34270__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34272,other34273){
var self__ = this;
var this34272__$1 = this;
return (((!((other34273 == null)))) && ((((this34272__$1.constructor === other34273.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34272__$1.x,other34273.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34272__$1.y,other34273.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34272__$1.__extmap,other34273.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34271){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34332 = k34271;
var G__34332__$1 = (((G__34332 instanceof cljs.core.Keyword))?G__34332.fqn:null);
switch (G__34332__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34271);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34270){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34333 = cljs.core.keyword_identical_QMARK_;
var expr__34334 = k__5352__auto__;
if(cljs.core.truth_((pred__34333.cljs$core$IFn$_invoke$arity$2 ? pred__34333.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__34334) : pred__34333.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__34334)))){
return (new shadow.dom.Coordinate(G__34270,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34333.cljs$core$IFn$_invoke$arity$2 ? pred__34333.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__34334) : pred__34333.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__34334)))){
return (new shadow.dom.Coordinate(self__.x,G__34270,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34270),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34270){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__34270,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__34281){
var extmap__5385__auto__ = (function (){var G__34350 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34281,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__34281)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34350);
} else {
return G__34350;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__34281),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__34281),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34354,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34368 = k34354;
var G__34368__$1 = (((G__34368 instanceof cljs.core.Keyword))?G__34368.fqn:null);
switch (G__34368__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34354,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34373){
var vec__34375 = p__34373;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34375,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34375,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34353){
var self__ = this;
var G__34353__$1 = this;
return (new cljs.core.RecordIter((0),G__34353__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34355,other34356){
var self__ = this;
var this34355__$1 = this;
return (((!((other34356 == null)))) && ((((this34355__$1.constructor === other34356.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34355__$1.w,other34356.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34355__$1.h,other34356.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34355__$1.__extmap,other34356.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34354){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34426 = k34354;
var G__34426__$1 = (((G__34426 instanceof cljs.core.Keyword))?G__34426.fqn:null);
switch (G__34426__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34354);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34353){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34431 = cljs.core.keyword_identical_QMARK_;
var expr__34432 = k__5352__auto__;
if(cljs.core.truth_((pred__34431.cljs$core$IFn$_invoke$arity$2 ? pred__34431.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__34432) : pred__34431.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__34432)))){
return (new shadow.dom.Size(G__34353,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34431.cljs$core$IFn$_invoke$arity$2 ? pred__34431.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__34432) : pred__34431.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__34432)))){
return (new shadow.dom.Size(self__.w,G__34353,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34353),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34353){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__34353,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__34359){
var extmap__5385__auto__ = (function (){var G__34459 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34359,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__34359)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34459);
} else {
return G__34459;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__34359),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__34359),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__35640 = (i + (1));
var G__35641 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35640;
ret = G__35641;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34484){
var vec__34486 = p__34484;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34486,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34486,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__34492 = arguments.length;
switch (G__34492) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35655 = ps;
var G__35656 = (i + (1));
el__$1 = G__35655;
i = G__35656;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__34555 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34555,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34555,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34555,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__34562_35667 = cljs.core.seq(props);
var chunk__34563_35668 = null;
var count__34564_35669 = (0);
var i__34565_35670 = (0);
while(true){
if((i__34565_35670 < count__34564_35669)){
var vec__34582_35672 = chunk__34563_35668.cljs$core$IIndexed$_nth$arity$2(null,i__34565_35670);
var k_35673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34582_35672,(0),null);
var v_35674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34582_35672,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_35673);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35673),v_35674);


var G__35678 = seq__34562_35667;
var G__35679 = chunk__34563_35668;
var G__35680 = count__34564_35669;
var G__35681 = (i__34565_35670 + (1));
seq__34562_35667 = G__35678;
chunk__34563_35668 = G__35679;
count__34564_35669 = G__35680;
i__34565_35670 = G__35681;
continue;
} else {
var temp__5804__auto___35683 = cljs.core.seq(seq__34562_35667);
if(temp__5804__auto___35683){
var seq__34562_35685__$1 = temp__5804__auto___35683;
if(cljs.core.chunked_seq_QMARK_(seq__34562_35685__$1)){
var c__5568__auto___35687 = cljs.core.chunk_first(seq__34562_35685__$1);
var G__35688 = cljs.core.chunk_rest(seq__34562_35685__$1);
var G__35689 = c__5568__auto___35687;
var G__35690 = cljs.core.count(c__5568__auto___35687);
var G__35691 = (0);
seq__34562_35667 = G__35688;
chunk__34563_35668 = G__35689;
count__34564_35669 = G__35690;
i__34565_35670 = G__35691;
continue;
} else {
var vec__34587_35692 = cljs.core.first(seq__34562_35685__$1);
var k_35693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34587_35692,(0),null);
var v_35694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34587_35692,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35693);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35693),v_35694);


var G__35700 = cljs.core.next(seq__34562_35685__$1);
var G__35701 = null;
var G__35702 = (0);
var G__35703 = (0);
seq__34562_35667 = G__35700;
chunk__34563_35668 = G__35701;
count__34564_35669 = G__35702;
i__34565_35670 = G__35703;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__34605 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34605,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34605,(1),null);
var seq__34614_35712 = cljs.core.seq(node_children);
var chunk__34616_35713 = null;
var count__34617_35714 = (0);
var i__34618_35715 = (0);
while(true){
if((i__34618_35715 < count__34617_35714)){
var child_struct_35720 = chunk__34616_35713.cljs$core$IIndexed$_nth$arity$2(null,i__34618_35715);
if((!((child_struct_35720 == null)))){
if(typeof child_struct_35720 === 'string'){
var text_35721 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35721),child_struct_35720].join(''));
} else {
var children_35722 = shadow.dom.svg_node(child_struct_35720);
if(cljs.core.seq_QMARK_(children_35722)){
var seq__34667_35723 = cljs.core.seq(children_35722);
var chunk__34669_35724 = null;
var count__34670_35725 = (0);
var i__34671_35726 = (0);
while(true){
if((i__34671_35726 < count__34670_35725)){
var child_35729 = chunk__34669_35724.cljs$core$IIndexed$_nth$arity$2(null,i__34671_35726);
if(cljs.core.truth_(child_35729)){
node.appendChild(child_35729);


var G__35730 = seq__34667_35723;
var G__35731 = chunk__34669_35724;
var G__35732 = count__34670_35725;
var G__35733 = (i__34671_35726 + (1));
seq__34667_35723 = G__35730;
chunk__34669_35724 = G__35731;
count__34670_35725 = G__35732;
i__34671_35726 = G__35733;
continue;
} else {
var G__35734 = seq__34667_35723;
var G__35735 = chunk__34669_35724;
var G__35736 = count__34670_35725;
var G__35737 = (i__34671_35726 + (1));
seq__34667_35723 = G__35734;
chunk__34669_35724 = G__35735;
count__34670_35725 = G__35736;
i__34671_35726 = G__35737;
continue;
}
} else {
var temp__5804__auto___35738 = cljs.core.seq(seq__34667_35723);
if(temp__5804__auto___35738){
var seq__34667_35739__$1 = temp__5804__auto___35738;
if(cljs.core.chunked_seq_QMARK_(seq__34667_35739__$1)){
var c__5568__auto___35740 = cljs.core.chunk_first(seq__34667_35739__$1);
var G__35741 = cljs.core.chunk_rest(seq__34667_35739__$1);
var G__35742 = c__5568__auto___35740;
var G__35743 = cljs.core.count(c__5568__auto___35740);
var G__35744 = (0);
seq__34667_35723 = G__35741;
chunk__34669_35724 = G__35742;
count__34670_35725 = G__35743;
i__34671_35726 = G__35744;
continue;
} else {
var child_35745 = cljs.core.first(seq__34667_35739__$1);
if(cljs.core.truth_(child_35745)){
node.appendChild(child_35745);


var G__35746 = cljs.core.next(seq__34667_35739__$1);
var G__35747 = null;
var G__35748 = (0);
var G__35749 = (0);
seq__34667_35723 = G__35746;
chunk__34669_35724 = G__35747;
count__34670_35725 = G__35748;
i__34671_35726 = G__35749;
continue;
} else {
var G__35752 = cljs.core.next(seq__34667_35739__$1);
var G__35754 = null;
var G__35755 = (0);
var G__35756 = (0);
seq__34667_35723 = G__35752;
chunk__34669_35724 = G__35754;
count__34670_35725 = G__35755;
i__34671_35726 = G__35756;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35722);
}
}


var G__35758 = seq__34614_35712;
var G__35759 = chunk__34616_35713;
var G__35760 = count__34617_35714;
var G__35761 = (i__34618_35715 + (1));
seq__34614_35712 = G__35758;
chunk__34616_35713 = G__35759;
count__34617_35714 = G__35760;
i__34618_35715 = G__35761;
continue;
} else {
var G__35762 = seq__34614_35712;
var G__35763 = chunk__34616_35713;
var G__35764 = count__34617_35714;
var G__35765 = (i__34618_35715 + (1));
seq__34614_35712 = G__35762;
chunk__34616_35713 = G__35763;
count__34617_35714 = G__35764;
i__34618_35715 = G__35765;
continue;
}
} else {
var temp__5804__auto___35766 = cljs.core.seq(seq__34614_35712);
if(temp__5804__auto___35766){
var seq__34614_35767__$1 = temp__5804__auto___35766;
if(cljs.core.chunked_seq_QMARK_(seq__34614_35767__$1)){
var c__5568__auto___35768 = cljs.core.chunk_first(seq__34614_35767__$1);
var G__35769 = cljs.core.chunk_rest(seq__34614_35767__$1);
var G__35770 = c__5568__auto___35768;
var G__35771 = cljs.core.count(c__5568__auto___35768);
var G__35772 = (0);
seq__34614_35712 = G__35769;
chunk__34616_35713 = G__35770;
count__34617_35714 = G__35771;
i__34618_35715 = G__35772;
continue;
} else {
var child_struct_35773 = cljs.core.first(seq__34614_35767__$1);
if((!((child_struct_35773 == null)))){
if(typeof child_struct_35773 === 'string'){
var text_35778 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35778),child_struct_35773].join(''));
} else {
var children_35779 = shadow.dom.svg_node(child_struct_35773);
if(cljs.core.seq_QMARK_(children_35779)){
var seq__34693_35780 = cljs.core.seq(children_35779);
var chunk__34695_35781 = null;
var count__34696_35782 = (0);
var i__34697_35783 = (0);
while(true){
if((i__34697_35783 < count__34696_35782)){
var child_35784 = chunk__34695_35781.cljs$core$IIndexed$_nth$arity$2(null,i__34697_35783);
if(cljs.core.truth_(child_35784)){
node.appendChild(child_35784);


var G__35785 = seq__34693_35780;
var G__35786 = chunk__34695_35781;
var G__35787 = count__34696_35782;
var G__35788 = (i__34697_35783 + (1));
seq__34693_35780 = G__35785;
chunk__34695_35781 = G__35786;
count__34696_35782 = G__35787;
i__34697_35783 = G__35788;
continue;
} else {
var G__35789 = seq__34693_35780;
var G__35790 = chunk__34695_35781;
var G__35791 = count__34696_35782;
var G__35792 = (i__34697_35783 + (1));
seq__34693_35780 = G__35789;
chunk__34695_35781 = G__35790;
count__34696_35782 = G__35791;
i__34697_35783 = G__35792;
continue;
}
} else {
var temp__5804__auto___35793__$1 = cljs.core.seq(seq__34693_35780);
if(temp__5804__auto___35793__$1){
var seq__34693_35794__$1 = temp__5804__auto___35793__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34693_35794__$1)){
var c__5568__auto___35795 = cljs.core.chunk_first(seq__34693_35794__$1);
var G__35796 = cljs.core.chunk_rest(seq__34693_35794__$1);
var G__35797 = c__5568__auto___35795;
var G__35798 = cljs.core.count(c__5568__auto___35795);
var G__35799 = (0);
seq__34693_35780 = G__35796;
chunk__34695_35781 = G__35797;
count__34696_35782 = G__35798;
i__34697_35783 = G__35799;
continue;
} else {
var child_35800 = cljs.core.first(seq__34693_35794__$1);
if(cljs.core.truth_(child_35800)){
node.appendChild(child_35800);


var G__35801 = cljs.core.next(seq__34693_35794__$1);
var G__35802 = null;
var G__35803 = (0);
var G__35804 = (0);
seq__34693_35780 = G__35801;
chunk__34695_35781 = G__35802;
count__34696_35782 = G__35803;
i__34697_35783 = G__35804;
continue;
} else {
var G__35805 = cljs.core.next(seq__34693_35794__$1);
var G__35806 = null;
var G__35807 = (0);
var G__35808 = (0);
seq__34693_35780 = G__35805;
chunk__34695_35781 = G__35806;
count__34696_35782 = G__35807;
i__34697_35783 = G__35808;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35779);
}
}


var G__35809 = cljs.core.next(seq__34614_35767__$1);
var G__35810 = null;
var G__35811 = (0);
var G__35812 = (0);
seq__34614_35712 = G__35809;
chunk__34616_35713 = G__35810;
count__34617_35714 = G__35811;
i__34618_35715 = G__35812;
continue;
} else {
var G__35813 = cljs.core.next(seq__34614_35767__$1);
var G__35814 = null;
var G__35815 = (0);
var G__35816 = (0);
seq__34614_35712 = G__35813;
chunk__34616_35713 = G__35814;
count__34617_35714 = G__35815;
i__34618_35715 = G__35816;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35817 = arguments.length;
var i__5770__auto___35818 = (0);
while(true){
if((i__5770__auto___35818 < len__5769__auto___35817)){
args__5775__auto__.push((arguments[i__5770__auto___35818]));

var G__35819 = (i__5770__auto___35818 + (1));
i__5770__auto___35818 = G__35819;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq34712){
var G__34713 = cljs.core.first(seq34712);
var seq34712__$1 = cljs.core.next(seq34712);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34713,seq34712__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__34737 = arguments.length;
switch (G__34737) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30087__auto___35832 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30088__auto__ = (function (){var switch__29881__auto__ = (function (state_34759){
var state_val_34760 = (state_34759[(1)]);
if((state_val_34760 === (1))){
var state_34759__$1 = state_34759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34759__$1,(2),once_or_cleanup);
} else {
if((state_val_34760 === (2))){
var inst_34755 = (state_34759[(2)]);
var inst_34756 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_34759__$1 = (function (){var statearr_34770 = state_34759;
(statearr_34770[(7)] = inst_34755);

return statearr_34770;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34759__$1,inst_34756);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__29882__auto__ = null;
var shadow$dom$state_machine__29882__auto____0 = (function (){
var statearr_34772 = [null,null,null,null,null,null,null,null];
(statearr_34772[(0)] = shadow$dom$state_machine__29882__auto__);

(statearr_34772[(1)] = (1));

return statearr_34772;
});
var shadow$dom$state_machine__29882__auto____1 = (function (state_34759){
while(true){
var ret_value__29883__auto__ = (function (){try{while(true){
var result__29884__auto__ = switch__29881__auto__(state_34759);
if(cljs.core.keyword_identical_QMARK_(result__29884__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29884__auto__;
}
break;
}
}catch (e34777){var ex__29885__auto__ = e34777;
var statearr_34778_35839 = state_34759;
(statearr_34778_35839[(2)] = ex__29885__auto__);


if(cljs.core.seq((state_34759[(4)]))){
var statearr_34783_35840 = state_34759;
(statearr_34783_35840[(1)] = cljs.core.first((state_34759[(4)])));

} else {
throw ex__29885__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__29883__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35841 = state_34759;
state_34759 = G__35841;
continue;
} else {
return ret_value__29883__auto__;
}
break;
}
});
shadow$dom$state_machine__29882__auto__ = function(state_34759){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__29882__auto____0.call(this);
case 1:
return shadow$dom$state_machine__29882__auto____1.call(this,state_34759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__29882__auto____0;
shadow$dom$state_machine__29882__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__29882__auto____1;
return shadow$dom$state_machine__29882__auto__;
})()
})();
var state__30089__auto__ = (function (){var statearr_34791 = f__30088__auto__();
(statearr_34791[(6)] = c__30087__auto___35832);

return statearr_34791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30089__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
