goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__51340){
var vec__51341 = p__51340;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51341,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51341,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__51344 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__51344__$1 = (((G__51344 instanceof cljs.core.Keyword))?G__51344.fqn:null);
switch (G__51344__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__51346 = (function (){
var seq__51347 = cljs.core.seq(vars__$1);
var chunk__51348 = null;
var count__51349 = (0);
var i__51350 = (0);
while(true){
if((i__51350 < count__51349)){
var v = chunk__51348.cljs$core$IIndexed$_nth$arity$2(null,i__51350);
var temp__5804__auto___51527 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___51527)){
var t_51529 = temp__5804__auto___51527;
var G__51355_51531 = ((function (seq__51347,chunk__51348,count__51349,i__51350,t_51529,temp__5804__auto___51527,v,each_fixture_fn,G__51344,G__51344__$1,env,once_fixtures,each_fixtures,vec__51341,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_51529)));
});})(seq__51347,chunk__51348,count__51349,i__51350,t_51529,temp__5804__auto___51527,v,each_fixture_fn,G__51344,G__51344__$1,env,once_fixtures,each_fixtures,vec__51341,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__51355_51531) : each_fixture_fn.call(null,G__51355_51531));
} else {
}


var G__51536 = seq__51347;
var G__51537 = chunk__51348;
var G__51538 = count__51349;
var G__51539 = (i__51350 + (1));
seq__51347 = G__51536;
chunk__51348 = G__51537;
count__51349 = G__51538;
i__51350 = G__51539;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__51347);
if(temp__5804__auto__){
var seq__51347__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51347__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__51347__$1);
var G__51546 = cljs.core.chunk_rest(seq__51347__$1);
var G__51547 = c__5568__auto__;
var G__51548 = cljs.core.count(c__5568__auto__);
var G__51549 = (0);
seq__51347 = G__51546;
chunk__51348 = G__51547;
count__51349 = G__51548;
i__51350 = G__51549;
continue;
} else {
var v = cljs.core.first(seq__51347__$1);
var temp__5804__auto___51552__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___51552__$1)){
var t_51554 = temp__5804__auto___51552__$1;
var G__51356_51555 = ((function (seq__51347,chunk__51348,count__51349,i__51350,t_51554,temp__5804__auto___51552__$1,v,seq__51347__$1,temp__5804__auto__,each_fixture_fn,G__51344,G__51344__$1,env,once_fixtures,each_fixtures,vec__51341,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_51554)));
});})(seq__51347,chunk__51348,count__51349,i__51350,t_51554,temp__5804__auto___51552__$1,v,seq__51347__$1,temp__5804__auto__,each_fixture_fn,G__51344,G__51344__$1,env,once_fixtures,each_fixtures,vec__51341,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__51356_51555) : each_fixture_fn.call(null,G__51356_51555));
} else {
}


var G__51558 = cljs.core.next(seq__51347__$1);
var G__51559 = null;
var G__51560 = (0);
var G__51561 = (0);
seq__51347 = G__51558;
chunk__51348 = G__51559;
count__51349 = G__51560;
i__51350 = G__51561;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__51345 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__51345.cljs$core$IFn$_invoke$arity$1 ? fexpr__51345.cljs$core$IFn$_invoke$arity$1(G__51346) : fexpr__51345.call(null,G__51346));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__51344__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__51339_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__51339_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__51369 = shadow.test.env.get_test_ns_info(ns);
var map__51369__$1 = cljs.core.__destructure_map(map__51369);
var test_ns = map__51369__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51369__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__51408,vars){
var map__51409 = p__51408;
var map__51409__$1 = cljs.core.__destructure_map(map__51409);
var env = map__51409__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51409__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__51414_51587 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__51416_51588 = null;
var count__51417_51589 = (0);
var i__51418_51590 = (0);
while(true){
if((i__51418_51590 < count__51417_51589)){
var vec__51442_51597 = chunk__51416_51588.cljs$core$IIndexed$_nth$arity$2(null,i__51418_51590);
var test_ns_51598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51442_51597,(0),null);
var ns_info_51599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51442_51597,(1),null);
var map__51447_51602 = ns_info_51599;
var map__51447_51603__$1 = cljs.core.__destructure_map(map__51447_51602);
var fixtures_51604 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51447_51603__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___51609 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_51604);
if(cljs.core.truth_(temp__5804__auto___51609)){
var fix_51613 = temp__5804__auto___51609;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51598,fix_51613], 0));
} else {
}

var temp__5804__auto___51615 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_51604);
if(cljs.core.truth_(temp__5804__auto___51615)){
var fix_51616 = temp__5804__auto___51615;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51598,fix_51616], 0));
} else {
}


var G__51623 = seq__51414_51587;
var G__51624 = chunk__51416_51588;
var G__51625 = count__51417_51589;
var G__51626 = (i__51418_51590 + (1));
seq__51414_51587 = G__51623;
chunk__51416_51588 = G__51624;
count__51417_51589 = G__51625;
i__51418_51590 = G__51626;
continue;
} else {
var temp__5804__auto___51630 = cljs.core.seq(seq__51414_51587);
if(temp__5804__auto___51630){
var seq__51414_51638__$1 = temp__5804__auto___51630;
if(cljs.core.chunked_seq_QMARK_(seq__51414_51638__$1)){
var c__5568__auto___51646 = cljs.core.chunk_first(seq__51414_51638__$1);
var G__51647 = cljs.core.chunk_rest(seq__51414_51638__$1);
var G__51648 = c__5568__auto___51646;
var G__51649 = cljs.core.count(c__5568__auto___51646);
var G__51650 = (0);
seq__51414_51587 = G__51647;
chunk__51416_51588 = G__51648;
count__51417_51589 = G__51649;
i__51418_51590 = G__51650;
continue;
} else {
var vec__51459_51653 = cljs.core.first(seq__51414_51638__$1);
var test_ns_51654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51459_51653,(0),null);
var ns_info_51655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51459_51653,(1),null);
var map__51466_51656 = ns_info_51655;
var map__51466_51657__$1 = cljs.core.__destructure_map(map__51466_51656);
var fixtures_51658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51466_51657__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___51659__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_51658);
if(cljs.core.truth_(temp__5804__auto___51659__$1)){
var fix_51660 = temp__5804__auto___51659__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51654,fix_51660], 0));
} else {
}

var temp__5804__auto___51661__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_51658);
if(cljs.core.truth_(temp__5804__auto___51661__$1)){
var fix_51662 = temp__5804__auto___51661__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51654,fix_51662], 0));
} else {
}


var G__51663 = cljs.core.next(seq__51414_51638__$1);
var G__51664 = null;
var G__51665 = (0);
var G__51666 = (0);
seq__51414_51587 = G__51663;
chunk__51416_51588 = G__51664;
count__51417_51589 = G__51665;
i__51418_51590 = G__51666;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__51406_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__51406_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__51474 = cljs.test.get_current_env();
var map__51474__$1 = cljs.core.__destructure_map(map__51474);
var env = map__51474__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51474__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51474__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__51478 = arguments.length;
switch (G__51478) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__51491 = arguments.length;
switch (G__51491) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__51499 = shadow.test.env.get_test_ns_info(ns);
var map__51499__$1 = cljs.core.__destructure_map(map__51499);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51499__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__51505 = arguments.length;
switch (G__51505) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__51502_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__51502_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__51519 = arguments.length;
switch (G__51519) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__51517_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51517_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
