goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30433 = (function (f,blockable,meta30434){
this.f = f;
this.blockable = blockable;
this.meta30434 = meta30434;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30433.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30435,meta30434__$1){
var self__ = this;
var _30435__$1 = this;
return (new cljs.core.async.t_cljs$core$async30433(self__.f,self__.blockable,meta30434__$1));
}));

(cljs.core.async.t_cljs$core$async30433.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30435){
var self__ = this;
var _30435__$1 = this;
return self__.meta30434;
}));

(cljs.core.async.t_cljs$core$async30433.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30433.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30433.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30433.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30433.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30434","meta30434",314850158,null)], null);
}));

(cljs.core.async.t_cljs$core$async30433.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30433.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30433");

(cljs.core.async.t_cljs$core$async30433.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30433");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30433.
 */
cljs.core.async.__GT_t_cljs$core$async30433 = (function cljs$core$async$__GT_t_cljs$core$async30433(f,blockable,meta30434){
return (new cljs.core.async.t_cljs$core$async30433(f,blockable,meta30434));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30432 = arguments.length;
switch (G__30432) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async30433(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30444 = arguments.length;
switch (G__30444) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30449 = arguments.length;
switch (G__30449) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30460 = arguments.length;
switch (G__30460) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_33891 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33891) : fn1.call(null,val_33891));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_33891) : fn1.call(null,val_33891));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30475 = arguments.length;
switch (G__30475) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___33899 = n;
var x_33900 = (0);
while(true){
if((x_33900 < n__5636__auto___33899)){
(a[x_33900] = x_33900);

var G__33901 = (x_33900 + (1));
x_33900 = G__33901;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30494 = (function (flag,meta30495){
this.flag = flag;
this.meta30495 = meta30495;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30494.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30496,meta30495__$1){
var self__ = this;
var _30496__$1 = this;
return (new cljs.core.async.t_cljs$core$async30494(self__.flag,meta30495__$1));
}));

(cljs.core.async.t_cljs$core$async30494.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30496){
var self__ = this;
var _30496__$1 = this;
return self__.meta30495;
}));

(cljs.core.async.t_cljs$core$async30494.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30494.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30494.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30494.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30494.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30495","meta30495",775597679,null)], null);
}));

(cljs.core.async.t_cljs$core$async30494.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30494.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30494");

(cljs.core.async.t_cljs$core$async30494.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30494");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30494.
 */
cljs.core.async.__GT_t_cljs$core$async30494 = (function cljs$core$async$__GT_t_cljs$core$async30494(flag,meta30495){
return (new cljs.core.async.t_cljs$core$async30494(flag,meta30495));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async30494(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30530 = (function (flag,cb,meta30531){
this.flag = flag;
this.cb = cb;
this.meta30531 = meta30531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30532,meta30531__$1){
var self__ = this;
var _30532__$1 = this;
return (new cljs.core.async.t_cljs$core$async30530(self__.flag,self__.cb,meta30531__$1));
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30532){
var self__ = this;
var _30532__$1 = this;
return self__.meta30531;
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30530.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30530.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30531","meta30531",1732011096,null)], null);
}));

(cljs.core.async.t_cljs$core$async30530.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30530.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30530");

(cljs.core.async.t_cljs$core$async30530.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30530");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30530.
 */
cljs.core.async.__GT_t_cljs$core$async30530 = (function cljs$core$async$__GT_t_cljs$core$async30530(flag,cb,meta30531){
return (new cljs.core.async.t_cljs$core$async30530(flag,cb,meta30531));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async30530(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__30554_SHARP_){
var G__30567 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30554_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30567) : fret.call(null,G__30567));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__30558_SHARP_){
var G__30571 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30558_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30571) : fret.call(null,G__30571));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33905 = (i + (1));
i = G__33905;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___33906 = arguments.length;
var i__5770__auto___33907 = (0);
while(true){
if((i__5770__auto___33907 < len__5769__auto___33906)){
args__5775__auto__.push((arguments[i__5770__auto___33907]));

var G__33910 = (i__5770__auto___33907 + (1));
i__5770__auto___33907 = G__33910;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30691){
var map__30692 = p__30691;
var map__30692__$1 = cljs.core.__destructure_map(map__30692);
var opts = map__30692__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30683){
var G__30684 = cljs.core.first(seq30683);
var seq30683__$1 = cljs.core.next(seq30683);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30684,seq30683__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30743 = arguments.length;
switch (G__30743) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30323__auto___33933 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_30880){
var state_val_30883 = (state_30880[(1)]);
if((state_val_30883 === (7))){
var inst_30869 = (state_30880[(2)]);
var state_30880__$1 = state_30880;
var statearr_30898_33935 = state_30880__$1;
(statearr_30898_33935[(2)] = inst_30869);

(statearr_30898_33935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (1))){
var state_30880__$1 = state_30880;
var statearr_30908_33936 = state_30880__$1;
(statearr_30908_33936[(2)] = null);

(statearr_30908_33936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (4))){
var inst_30822 = (state_30880[(7)]);
var inst_30822__$1 = (state_30880[(2)]);
var inst_30832 = (inst_30822__$1 == null);
var state_30880__$1 = (function (){var statearr_30913 = state_30880;
(statearr_30913[(7)] = inst_30822__$1);

return statearr_30913;
})();
if(cljs.core.truth_(inst_30832)){
var statearr_30914_33939 = state_30880__$1;
(statearr_30914_33939[(1)] = (5));

} else {
var statearr_30919_33940 = state_30880__$1;
(statearr_30919_33940[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (13))){
var state_30880__$1 = state_30880;
var statearr_30923_33943 = state_30880__$1;
(statearr_30923_33943[(2)] = null);

(statearr_30923_33943[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (6))){
var inst_30822 = (state_30880[(7)]);
var state_30880__$1 = state_30880;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30880__$1,(11),to,inst_30822);
} else {
if((state_val_30883 === (3))){
var inst_30872 = (state_30880[(2)]);
var state_30880__$1 = state_30880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30880__$1,inst_30872);
} else {
if((state_val_30883 === (12))){
var state_30880__$1 = state_30880;
var statearr_30937_33946 = state_30880__$1;
(statearr_30937_33946[(2)] = null);

(statearr_30937_33946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (2))){
var state_30880__$1 = state_30880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30880__$1,(4),from);
} else {
if((state_val_30883 === (11))){
var inst_30858 = (state_30880[(2)]);
var state_30880__$1 = state_30880;
if(cljs.core.truth_(inst_30858)){
var statearr_30942_33947 = state_30880__$1;
(statearr_30942_33947[(1)] = (12));

} else {
var statearr_30944_33948 = state_30880__$1;
(statearr_30944_33948[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (9))){
var state_30880__$1 = state_30880;
var statearr_30949_33949 = state_30880__$1;
(statearr_30949_33949[(2)] = null);

(statearr_30949_33949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (5))){
var state_30880__$1 = state_30880;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30950_33953 = state_30880__$1;
(statearr_30950_33953[(1)] = (8));

} else {
var statearr_30951_33954 = state_30880__$1;
(statearr_30951_33954[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (14))){
var inst_30867 = (state_30880[(2)]);
var state_30880__$1 = state_30880;
var statearr_30952_33958 = state_30880__$1;
(statearr_30952_33958[(2)] = inst_30867);

(statearr_30952_33958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (10))){
var inst_30854 = (state_30880[(2)]);
var state_30880__$1 = state_30880;
var statearr_30955_33961 = state_30880__$1;
(statearr_30955_33961[(2)] = inst_30854);

(statearr_30955_33961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30883 === (8))){
var inst_30847 = cljs.core.async.close_BANG_(to);
var state_30880__$1 = state_30880;
var statearr_30960_33962 = state_30880__$1;
(statearr_30960_33962[(2)] = inst_30847);

(statearr_30960_33962[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_30961 = [null,null,null,null,null,null,null,null];
(statearr_30961[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_30961[(1)] = (1));

return statearr_30961;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_30880){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_30880);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e30962){var ex__30030__auto__ = e30962;
var statearr_30963_33967 = state_30880;
(statearr_30963_33967[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_30880[(4)]))){
var statearr_30964_33968 = state_30880;
(statearr_30964_33968[(1)] = cljs.core.first((state_30880[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33969 = state_30880;
state_30880 = G__33969;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_30880){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_30880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_30966 = f__30324__auto__();
(statearr_30966[(6)] = c__30323__auto___33933);

return statearr_30966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__30995){
var vec__30996 = p__30995;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30996,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30996,(1),null);
var job = vec__30996;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__30323__auto___33972 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31004){
var state_val_31005 = (state_31004[(1)]);
if((state_val_31005 === (1))){
var state_31004__$1 = state_31004;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31004__$1,(2),res,v);
} else {
if((state_val_31005 === (2))){
var inst_31001 = (state_31004[(2)]);
var inst_31002 = cljs.core.async.close_BANG_(res);
var state_31004__$1 = (function (){var statearr_31011 = state_31004;
(statearr_31011[(7)] = inst_31001);

return statearr_31011;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31004__$1,inst_31002);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0 = (function (){
var statearr_31013 = [null,null,null,null,null,null,null,null];
(statearr_31013[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__);

(statearr_31013[(1)] = (1));

return statearr_31013;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1 = (function (state_31004){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31004);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31015){var ex__30030__auto__ = e31015;
var statearr_31016_33976 = state_31004;
(statearr_31016_33976[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31004[(4)]))){
var statearr_31018_33977 = state_31004;
(statearr_31018_33977[(1)] = cljs.core.first((state_31004[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33978 = state_31004;
state_31004 = G__33978;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = function(state_31004){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1.call(this,state_31004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31037 = f__30324__auto__();
(statearr_31037[(6)] = c__30323__auto___33972);

return statearr_31037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__31041){
var vec__31042 = p__31041;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31042,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31042,(1),null);
var job = vec__31042;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___33981 = n;
var __33982 = (0);
while(true){
if((__33982 < n__5636__auto___33981)){
var G__31048_33983 = type;
var G__31048_33984__$1 = (((G__31048_33983 instanceof cljs.core.Keyword))?G__31048_33983.fqn:null);
switch (G__31048_33984__$1) {
case "compute":
var c__30323__auto___33986 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33982,c__30323__auto___33986,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async){
return (function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = ((function (__33982,c__30323__auto___33986,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async){
return (function (state_31064){
var state_val_31065 = (state_31064[(1)]);
if((state_val_31065 === (1))){
var state_31064__$1 = state_31064;
var statearr_31069_33988 = state_31064__$1;
(statearr_31069_33988[(2)] = null);

(statearr_31069_33988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31065 === (2))){
var state_31064__$1 = state_31064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31064__$1,(4),jobs);
} else {
if((state_val_31065 === (3))){
var inst_31062 = (state_31064[(2)]);
var state_31064__$1 = state_31064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31064__$1,inst_31062);
} else {
if((state_val_31065 === (4))){
var inst_31054 = (state_31064[(2)]);
var inst_31055 = process__$1(inst_31054);
var state_31064__$1 = state_31064;
if(cljs.core.truth_(inst_31055)){
var statearr_31076_33991 = state_31064__$1;
(statearr_31076_33991[(1)] = (5));

} else {
var statearr_31077_33992 = state_31064__$1;
(statearr_31077_33992[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31065 === (5))){
var state_31064__$1 = state_31064;
var statearr_31078_33994 = state_31064__$1;
(statearr_31078_33994[(2)] = null);

(statearr_31078_33994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31065 === (6))){
var state_31064__$1 = state_31064;
var statearr_31085_33995 = state_31064__$1;
(statearr_31085_33995[(2)] = null);

(statearr_31085_33995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31065 === (7))){
var inst_31060 = (state_31064[(2)]);
var state_31064__$1 = state_31064;
var statearr_31086_33997 = state_31064__$1;
(statearr_31086_33997[(2)] = inst_31060);

(statearr_31086_33997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33982,c__30323__auto___33986,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async))
;
return ((function (__33982,switch__30026__auto__,c__30323__auto___33986,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0 = (function (){
var statearr_31089 = [null,null,null,null,null,null,null];
(statearr_31089[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__);

(statearr_31089[(1)] = (1));

return statearr_31089;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1 = (function (state_31064){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31064);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31098){var ex__30030__auto__ = e31098;
var statearr_31099_34001 = state_31064;
(statearr_31099_34001[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31064[(4)]))){
var statearr_31101_34002 = state_31064;
(statearr_31101_34002[(1)] = cljs.core.first((state_31064[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34003 = state_31064;
state_31064 = G__34003;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = function(state_31064){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1.call(this,state_31064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__;
})()
;})(__33982,switch__30026__auto__,c__30323__auto___33986,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async))
})();
var state__30325__auto__ = (function (){var statearr_31102 = f__30324__auto__();
(statearr_31102[(6)] = c__30323__auto___33986);

return statearr_31102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
});})(__33982,c__30323__auto___33986,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async))
);


break;
case "async":
var c__30323__auto___34004 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33982,c__30323__auto___34004,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async){
return (function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = ((function (__33982,c__30323__auto___34004,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async){
return (function (state_31123){
var state_val_31124 = (state_31123[(1)]);
if((state_val_31124 === (1))){
var state_31123__$1 = state_31123;
var statearr_31134_34005 = state_31123__$1;
(statearr_31134_34005[(2)] = null);

(statearr_31134_34005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31124 === (2))){
var state_31123__$1 = state_31123;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31123__$1,(4),jobs);
} else {
if((state_val_31124 === (3))){
var inst_31121 = (state_31123[(2)]);
var state_31123__$1 = state_31123;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31123__$1,inst_31121);
} else {
if((state_val_31124 === (4))){
var inst_31111 = (state_31123[(2)]);
var inst_31113 = async(inst_31111);
var state_31123__$1 = state_31123;
if(cljs.core.truth_(inst_31113)){
var statearr_31136_34009 = state_31123__$1;
(statearr_31136_34009[(1)] = (5));

} else {
var statearr_31143_34010 = state_31123__$1;
(statearr_31143_34010[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31124 === (5))){
var state_31123__$1 = state_31123;
var statearr_31146_34011 = state_31123__$1;
(statearr_31146_34011[(2)] = null);

(statearr_31146_34011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31124 === (6))){
var state_31123__$1 = state_31123;
var statearr_31156_34012 = state_31123__$1;
(statearr_31156_34012[(2)] = null);

(statearr_31156_34012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31124 === (7))){
var inst_31119 = (state_31123[(2)]);
var state_31123__$1 = state_31123;
var statearr_31157_34020 = state_31123__$1;
(statearr_31157_34020[(2)] = inst_31119);

(statearr_31157_34020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33982,c__30323__auto___34004,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async))
;
return ((function (__33982,switch__30026__auto__,c__30323__auto___34004,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0 = (function (){
var statearr_31158 = [null,null,null,null,null,null,null];
(statearr_31158[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__);

(statearr_31158[(1)] = (1));

return statearr_31158;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1 = (function (state_31123){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31123);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31159){var ex__30030__auto__ = e31159;
var statearr_31160_34021 = state_31123;
(statearr_31160_34021[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31123[(4)]))){
var statearr_31162_34022 = state_31123;
(statearr_31162_34022[(1)] = cljs.core.first((state_31123[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34024 = state_31123;
state_31123 = G__34024;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = function(state_31123){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1.call(this,state_31123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__;
})()
;})(__33982,switch__30026__auto__,c__30323__auto___34004,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async))
})();
var state__30325__auto__ = (function (){var statearr_31172 = f__30324__auto__();
(statearr_31172[(6)] = c__30323__auto___34004);

return statearr_31172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
});})(__33982,c__30323__auto___34004,G__31048_33983,G__31048_33984__$1,n__5636__auto___33981,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31048_33984__$1)].join('')));

}

var G__34042 = (__33982 + (1));
__33982 = G__34042;
continue;
} else {
}
break;
}

var c__30323__auto___34043 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31205){
var state_val_31206 = (state_31205[(1)]);
if((state_val_31206 === (7))){
var inst_31201 = (state_31205[(2)]);
var state_31205__$1 = state_31205;
var statearr_31214_34048 = state_31205__$1;
(statearr_31214_34048[(2)] = inst_31201);

(statearr_31214_34048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31206 === (1))){
var state_31205__$1 = state_31205;
var statearr_31217_34067 = state_31205__$1;
(statearr_31217_34067[(2)] = null);

(statearr_31217_34067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31206 === (4))){
var inst_31178 = (state_31205[(7)]);
var inst_31178__$1 = (state_31205[(2)]);
var inst_31180 = (inst_31178__$1 == null);
var state_31205__$1 = (function (){var statearr_31220 = state_31205;
(statearr_31220[(7)] = inst_31178__$1);

return statearr_31220;
})();
if(cljs.core.truth_(inst_31180)){
var statearr_31223_34073 = state_31205__$1;
(statearr_31223_34073[(1)] = (5));

} else {
var statearr_31225_34083 = state_31205__$1;
(statearr_31225_34083[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31206 === (6))){
var inst_31178 = (state_31205[(7)]);
var inst_31184 = (state_31205[(8)]);
var inst_31184__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31190 = [inst_31178,inst_31184__$1];
var inst_31191 = (new cljs.core.PersistentVector(null,2,(5),inst_31189,inst_31190,null));
var state_31205__$1 = (function (){var statearr_31227 = state_31205;
(statearr_31227[(8)] = inst_31184__$1);

return statearr_31227;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31205__$1,(8),jobs,inst_31191);
} else {
if((state_val_31206 === (3))){
var inst_31203 = (state_31205[(2)]);
var state_31205__$1 = state_31205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31205__$1,inst_31203);
} else {
if((state_val_31206 === (2))){
var state_31205__$1 = state_31205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31205__$1,(4),from);
} else {
if((state_val_31206 === (9))){
var inst_31198 = (state_31205[(2)]);
var state_31205__$1 = (function (){var statearr_31228 = state_31205;
(statearr_31228[(9)] = inst_31198);

return statearr_31228;
})();
var statearr_31229_34134 = state_31205__$1;
(statearr_31229_34134[(2)] = null);

(statearr_31229_34134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31206 === (5))){
var inst_31182 = cljs.core.async.close_BANG_(jobs);
var state_31205__$1 = state_31205;
var statearr_31230_34160 = state_31205__$1;
(statearr_31230_34160[(2)] = inst_31182);

(statearr_31230_34160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31206 === (8))){
var inst_31184 = (state_31205[(8)]);
var inst_31196 = (state_31205[(2)]);
var state_31205__$1 = (function (){var statearr_31231 = state_31205;
(statearr_31231[(10)] = inst_31196);

return statearr_31231;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31205__$1,(9),results,inst_31184);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0 = (function (){
var statearr_31233 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31233[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__);

(statearr_31233[(1)] = (1));

return statearr_31233;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1 = (function (state_31205){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31205);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31237){var ex__30030__auto__ = e31237;
var statearr_31238_34171 = state_31205;
(statearr_31238_34171[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31205[(4)]))){
var statearr_31239_34173 = state_31205;
(statearr_31239_34173[(1)] = cljs.core.first((state_31205[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34177 = state_31205;
state_31205 = G__34177;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = function(state_31205){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1.call(this,state_31205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31241 = f__30324__auto__();
(statearr_31241[(6)] = c__30323__auto___34043);

return statearr_31241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


var c__30323__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31294){
var state_val_31296 = (state_31294[(1)]);
if((state_val_31296 === (7))){
var inst_31290 = (state_31294[(2)]);
var state_31294__$1 = state_31294;
var statearr_31302_34179 = state_31294__$1;
(statearr_31302_34179[(2)] = inst_31290);

(statearr_31302_34179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (20))){
var state_31294__$1 = state_31294;
var statearr_31303_34180 = state_31294__$1;
(statearr_31303_34180[(2)] = null);

(statearr_31303_34180[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (1))){
var state_31294__$1 = state_31294;
var statearr_31305_34181 = state_31294__$1;
(statearr_31305_34181[(2)] = null);

(statearr_31305_34181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (4))){
var inst_31245 = (state_31294[(7)]);
var inst_31245__$1 = (state_31294[(2)]);
var inst_31246 = (inst_31245__$1 == null);
var state_31294__$1 = (function (){var statearr_31308 = state_31294;
(statearr_31308[(7)] = inst_31245__$1);

return statearr_31308;
})();
if(cljs.core.truth_(inst_31246)){
var statearr_31309_34183 = state_31294__$1;
(statearr_31309_34183[(1)] = (5));

} else {
var statearr_31317_34185 = state_31294__$1;
(statearr_31317_34185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (15))){
var inst_31270 = (state_31294[(8)]);
var state_31294__$1 = state_31294;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31294__$1,(18),to,inst_31270);
} else {
if((state_val_31296 === (21))){
var inst_31285 = (state_31294[(2)]);
var state_31294__$1 = state_31294;
var statearr_31319_34188 = state_31294__$1;
(statearr_31319_34188[(2)] = inst_31285);

(statearr_31319_34188[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (13))){
var inst_31287 = (state_31294[(2)]);
var state_31294__$1 = (function (){var statearr_31321 = state_31294;
(statearr_31321[(9)] = inst_31287);

return statearr_31321;
})();
var statearr_31323_34190 = state_31294__$1;
(statearr_31323_34190[(2)] = null);

(statearr_31323_34190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (6))){
var inst_31245 = (state_31294[(7)]);
var state_31294__$1 = state_31294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31294__$1,(11),inst_31245);
} else {
if((state_val_31296 === (17))){
var inst_31280 = (state_31294[(2)]);
var state_31294__$1 = state_31294;
if(cljs.core.truth_(inst_31280)){
var statearr_31324_34196 = state_31294__$1;
(statearr_31324_34196[(1)] = (19));

} else {
var statearr_31326_34198 = state_31294__$1;
(statearr_31326_34198[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (3))){
var inst_31292 = (state_31294[(2)]);
var state_31294__$1 = state_31294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31294__$1,inst_31292);
} else {
if((state_val_31296 === (12))){
var inst_31265 = (state_31294[(10)]);
var state_31294__$1 = state_31294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31294__$1,(14),inst_31265);
} else {
if((state_val_31296 === (2))){
var state_31294__$1 = state_31294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31294__$1,(4),results);
} else {
if((state_val_31296 === (19))){
var state_31294__$1 = state_31294;
var statearr_31337_34202 = state_31294__$1;
(statearr_31337_34202[(2)] = null);

(statearr_31337_34202[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (11))){
var inst_31265 = (state_31294[(2)]);
var state_31294__$1 = (function (){var statearr_31338 = state_31294;
(statearr_31338[(10)] = inst_31265);

return statearr_31338;
})();
var statearr_31340_34203 = state_31294__$1;
(statearr_31340_34203[(2)] = null);

(statearr_31340_34203[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (9))){
var state_31294__$1 = state_31294;
var statearr_31341_34206 = state_31294__$1;
(statearr_31341_34206[(2)] = null);

(statearr_31341_34206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (5))){
var state_31294__$1 = state_31294;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31344_34209 = state_31294__$1;
(statearr_31344_34209[(1)] = (8));

} else {
var statearr_31345_34210 = state_31294__$1;
(statearr_31345_34210[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (14))){
var inst_31270 = (state_31294[(8)]);
var inst_31273 = (state_31294[(11)]);
var inst_31270__$1 = (state_31294[(2)]);
var inst_31272 = (inst_31270__$1 == null);
var inst_31273__$1 = cljs.core.not(inst_31272);
var state_31294__$1 = (function (){var statearr_31347 = state_31294;
(statearr_31347[(8)] = inst_31270__$1);

(statearr_31347[(11)] = inst_31273__$1);

return statearr_31347;
})();
if(inst_31273__$1){
var statearr_31348_34212 = state_31294__$1;
(statearr_31348_34212[(1)] = (15));

} else {
var statearr_31349_34213 = state_31294__$1;
(statearr_31349_34213[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (16))){
var inst_31273 = (state_31294[(11)]);
var state_31294__$1 = state_31294;
var statearr_31350_34214 = state_31294__$1;
(statearr_31350_34214[(2)] = inst_31273);

(statearr_31350_34214[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (10))){
var inst_31261 = (state_31294[(2)]);
var state_31294__$1 = state_31294;
var statearr_31352_34215 = state_31294__$1;
(statearr_31352_34215[(2)] = inst_31261);

(statearr_31352_34215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (18))){
var inst_31277 = (state_31294[(2)]);
var state_31294__$1 = state_31294;
var statearr_31354_34216 = state_31294__$1;
(statearr_31354_34216[(2)] = inst_31277);

(statearr_31354_34216[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31296 === (8))){
var inst_31249 = cljs.core.async.close_BANG_(to);
var state_31294__$1 = state_31294;
var statearr_31357_34217 = state_31294__$1;
(statearr_31357_34217[(2)] = inst_31249);

(statearr_31357_34217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0 = (function (){
var statearr_31364 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31364[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__);

(statearr_31364[(1)] = (1));

return statearr_31364;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1 = (function (state_31294){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31294);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31365){var ex__30030__auto__ = e31365;
var statearr_31366_34222 = state_31294;
(statearr_31366_34222[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31294[(4)]))){
var statearr_31367_34223 = state_31294;
(statearr_31367_34223[(1)] = cljs.core.first((state_31294[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34224 = state_31294;
state_31294 = G__34224;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__ = function(state_31294){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1.call(this,state_31294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30027__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31369 = f__30324__auto__();
(statearr_31369[(6)] = c__30323__auto__);

return statearr_31369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

return c__30323__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31375 = arguments.length;
switch (G__31375) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31380 = arguments.length;
switch (G__31380) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31391 = arguments.length;
switch (G__31391) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__30323__auto___34246 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31425){
var state_val_31426 = (state_31425[(1)]);
if((state_val_31426 === (7))){
var inst_31421 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31432_34248 = state_31425__$1;
(statearr_31432_34248[(2)] = inst_31421);

(statearr_31432_34248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (1))){
var state_31425__$1 = state_31425;
var statearr_31433_34249 = state_31425__$1;
(statearr_31433_34249[(2)] = null);

(statearr_31433_34249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (4))){
var inst_31398 = (state_31425[(7)]);
var inst_31398__$1 = (state_31425[(2)]);
var inst_31402 = (inst_31398__$1 == null);
var state_31425__$1 = (function (){var statearr_31434 = state_31425;
(statearr_31434[(7)] = inst_31398__$1);

return statearr_31434;
})();
if(cljs.core.truth_(inst_31402)){
var statearr_31435_34253 = state_31425__$1;
(statearr_31435_34253[(1)] = (5));

} else {
var statearr_31436_34254 = state_31425__$1;
(statearr_31436_34254[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (13))){
var state_31425__$1 = state_31425;
var statearr_31437_34255 = state_31425__$1;
(statearr_31437_34255[(2)] = null);

(statearr_31437_34255[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (6))){
var inst_31398 = (state_31425[(7)]);
var inst_31407 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31398) : p.call(null,inst_31398));
var state_31425__$1 = state_31425;
if(cljs.core.truth_(inst_31407)){
var statearr_31438_34256 = state_31425__$1;
(statearr_31438_34256[(1)] = (9));

} else {
var statearr_31439_34257 = state_31425__$1;
(statearr_31439_34257[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (3))){
var inst_31423 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31425__$1,inst_31423);
} else {
if((state_val_31426 === (12))){
var state_31425__$1 = state_31425;
var statearr_31441_34258 = state_31425__$1;
(statearr_31441_34258[(2)] = null);

(statearr_31441_34258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (2))){
var state_31425__$1 = state_31425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31425__$1,(4),ch);
} else {
if((state_val_31426 === (11))){
var inst_31398 = (state_31425[(7)]);
var inst_31411 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31425__$1,(8),inst_31411,inst_31398);
} else {
if((state_val_31426 === (9))){
var state_31425__$1 = state_31425;
var statearr_31443_34259 = state_31425__$1;
(statearr_31443_34259[(2)] = tc);

(statearr_31443_34259[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (5))){
var inst_31404 = cljs.core.async.close_BANG_(tc);
var inst_31405 = cljs.core.async.close_BANG_(fc);
var state_31425__$1 = (function (){var statearr_31445 = state_31425;
(statearr_31445[(8)] = inst_31404);

return statearr_31445;
})();
var statearr_31446_34266 = state_31425__$1;
(statearr_31446_34266[(2)] = inst_31405);

(statearr_31446_34266[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (14))){
var inst_31419 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
var statearr_31447_34268 = state_31425__$1;
(statearr_31447_34268[(2)] = inst_31419);

(statearr_31447_34268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (10))){
var state_31425__$1 = state_31425;
var statearr_31451_34270 = state_31425__$1;
(statearr_31451_34270[(2)] = fc);

(statearr_31451_34270[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31426 === (8))){
var inst_31413 = (state_31425[(2)]);
var state_31425__$1 = state_31425;
if(cljs.core.truth_(inst_31413)){
var statearr_31452_34272 = state_31425__$1;
(statearr_31452_34272[(1)] = (12));

} else {
var statearr_31454_34273 = state_31425__$1;
(statearr_31454_34273[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_31457 = [null,null,null,null,null,null,null,null,null];
(statearr_31457[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_31457[(1)] = (1));

return statearr_31457;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_31425){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31425);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31461){var ex__30030__auto__ = e31461;
var statearr_31462_34277 = state_31425;
(statearr_31462_34277[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31425[(4)]))){
var statearr_31463_34278 = state_31425;
(statearr_31463_34278[(1)] = cljs.core.first((state_31425[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34279 = state_31425;
state_31425 = G__34279;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_31425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_31425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31464 = f__30324__auto__();
(statearr_31464[(6)] = c__30323__auto___34246);

return statearr_31464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30323__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31492){
var state_val_31493 = (state_31492[(1)]);
if((state_val_31493 === (7))){
var inst_31488 = (state_31492[(2)]);
var state_31492__$1 = state_31492;
var statearr_31496_34283 = state_31492__$1;
(statearr_31496_34283[(2)] = inst_31488);

(statearr_31496_34283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (1))){
var inst_31469 = init;
var inst_31470 = inst_31469;
var state_31492__$1 = (function (){var statearr_31499 = state_31492;
(statearr_31499[(7)] = inst_31470);

return statearr_31499;
})();
var statearr_31501_34287 = state_31492__$1;
(statearr_31501_34287[(2)] = null);

(statearr_31501_34287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (4))){
var inst_31475 = (state_31492[(8)]);
var inst_31475__$1 = (state_31492[(2)]);
var inst_31476 = (inst_31475__$1 == null);
var state_31492__$1 = (function (){var statearr_31507 = state_31492;
(statearr_31507[(8)] = inst_31475__$1);

return statearr_31507;
})();
if(cljs.core.truth_(inst_31476)){
var statearr_31508_34289 = state_31492__$1;
(statearr_31508_34289[(1)] = (5));

} else {
var statearr_31509_34290 = state_31492__$1;
(statearr_31509_34290[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (6))){
var inst_31470 = (state_31492[(7)]);
var inst_31475 = (state_31492[(8)]);
var inst_31479 = (state_31492[(9)]);
var inst_31479__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31470,inst_31475) : f.call(null,inst_31470,inst_31475));
var inst_31480 = cljs.core.reduced_QMARK_(inst_31479__$1);
var state_31492__$1 = (function (){var statearr_31510 = state_31492;
(statearr_31510[(9)] = inst_31479__$1);

return statearr_31510;
})();
if(inst_31480){
var statearr_31511_34303 = state_31492__$1;
(statearr_31511_34303[(1)] = (8));

} else {
var statearr_31512_34304 = state_31492__$1;
(statearr_31512_34304[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (3))){
var inst_31490 = (state_31492[(2)]);
var state_31492__$1 = state_31492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31492__$1,inst_31490);
} else {
if((state_val_31493 === (2))){
var state_31492__$1 = state_31492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31492__$1,(4),ch);
} else {
if((state_val_31493 === (9))){
var inst_31479 = (state_31492[(9)]);
var inst_31470 = inst_31479;
var state_31492__$1 = (function (){var statearr_31513 = state_31492;
(statearr_31513[(7)] = inst_31470);

return statearr_31513;
})();
var statearr_31514_34305 = state_31492__$1;
(statearr_31514_34305[(2)] = null);

(statearr_31514_34305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (5))){
var inst_31470 = (state_31492[(7)]);
var state_31492__$1 = state_31492;
var statearr_31516_34309 = state_31492__$1;
(statearr_31516_34309[(2)] = inst_31470);

(statearr_31516_34309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (10))){
var inst_31486 = (state_31492[(2)]);
var state_31492__$1 = state_31492;
var statearr_31517_34310 = state_31492__$1;
(statearr_31517_34310[(2)] = inst_31486);

(statearr_31517_34310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31493 === (8))){
var inst_31479 = (state_31492[(9)]);
var inst_31482 = cljs.core.deref(inst_31479);
var state_31492__$1 = state_31492;
var statearr_31518_34311 = state_31492__$1;
(statearr_31518_34311[(2)] = inst_31482);

(statearr_31518_34311[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__30027__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30027__auto____0 = (function (){
var statearr_31521 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31521[(0)] = cljs$core$async$reduce_$_state_machine__30027__auto__);

(statearr_31521[(1)] = (1));

return statearr_31521;
});
var cljs$core$async$reduce_$_state_machine__30027__auto____1 = (function (state_31492){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31492);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31522){var ex__30030__auto__ = e31522;
var statearr_31523_34322 = state_31492;
(statearr_31523_34322[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31492[(4)]))){
var statearr_31525_34323 = state_31492;
(statearr_31525_34323[(1)] = cljs.core.first((state_31492[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34325 = state_31492;
state_31492 = G__34325;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30027__auto__ = function(state_31492){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30027__auto____1.call(this,state_31492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30027__auto____0;
cljs$core$async$reduce_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30027__auto____1;
return cljs$core$async$reduce_$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31528 = f__30324__auto__();
(statearr_31528[(6)] = c__30323__auto__);

return statearr_31528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

return c__30323__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__30323__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31536){
var state_val_31537 = (state_31536[(1)]);
if((state_val_31537 === (1))){
var inst_31531 = cljs.core.async.reduce(f__$1,init,ch);
var state_31536__$1 = state_31536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31536__$1,(2),inst_31531);
} else {
if((state_val_31537 === (2))){
var inst_31533 = (state_31536[(2)]);
var inst_31534 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31533) : f__$1.call(null,inst_31533));
var state_31536__$1 = state_31536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31536__$1,inst_31534);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__30027__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30027__auto____0 = (function (){
var statearr_31540 = [null,null,null,null,null,null,null];
(statearr_31540[(0)] = cljs$core$async$transduce_$_state_machine__30027__auto__);

(statearr_31540[(1)] = (1));

return statearr_31540;
});
var cljs$core$async$transduce_$_state_machine__30027__auto____1 = (function (state_31536){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31536);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31544){var ex__30030__auto__ = e31544;
var statearr_31545_34337 = state_31536;
(statearr_31545_34337[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31536[(4)]))){
var statearr_31546_34338 = state_31536;
(statearr_31546_34338[(1)] = cljs.core.first((state_31536[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34343 = state_31536;
state_31536 = G__34343;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30027__auto__ = function(state_31536){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30027__auto____1.call(this,state_31536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30027__auto____0;
cljs$core$async$transduce_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30027__auto____1;
return cljs$core$async$transduce_$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31549 = f__30324__auto__();
(statearr_31549[(6)] = c__30323__auto__);

return statearr_31549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

return c__30323__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__31551 = arguments.length;
switch (G__31551) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30323__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31582){
var state_val_31583 = (state_31582[(1)]);
if((state_val_31583 === (7))){
var inst_31563 = (state_31582[(2)]);
var state_31582__$1 = state_31582;
var statearr_31584_34349 = state_31582__$1;
(statearr_31584_34349[(2)] = inst_31563);

(statearr_31584_34349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (1))){
var inst_31555 = cljs.core.seq(coll);
var inst_31557 = inst_31555;
var state_31582__$1 = (function (){var statearr_31589 = state_31582;
(statearr_31589[(7)] = inst_31557);

return statearr_31589;
})();
var statearr_31590_34354 = state_31582__$1;
(statearr_31590_34354[(2)] = null);

(statearr_31590_34354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (4))){
var inst_31557 = (state_31582[(7)]);
var inst_31561 = cljs.core.first(inst_31557);
var state_31582__$1 = state_31582;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31582__$1,(7),ch,inst_31561);
} else {
if((state_val_31583 === (13))){
var inst_31576 = (state_31582[(2)]);
var state_31582__$1 = state_31582;
var statearr_31593_34360 = state_31582__$1;
(statearr_31593_34360[(2)] = inst_31576);

(statearr_31593_34360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (6))){
var inst_31566 = (state_31582[(2)]);
var state_31582__$1 = state_31582;
if(cljs.core.truth_(inst_31566)){
var statearr_31594_34361 = state_31582__$1;
(statearr_31594_34361[(1)] = (8));

} else {
var statearr_31595_34362 = state_31582__$1;
(statearr_31595_34362[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (3))){
var inst_31580 = (state_31582[(2)]);
var state_31582__$1 = state_31582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31582__$1,inst_31580);
} else {
if((state_val_31583 === (12))){
var state_31582__$1 = state_31582;
var statearr_31596_34367 = state_31582__$1;
(statearr_31596_34367[(2)] = null);

(statearr_31596_34367[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (2))){
var inst_31557 = (state_31582[(7)]);
var state_31582__$1 = state_31582;
if(cljs.core.truth_(inst_31557)){
var statearr_31597_34369 = state_31582__$1;
(statearr_31597_34369[(1)] = (4));

} else {
var statearr_31598_34370 = state_31582__$1;
(statearr_31598_34370[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (11))){
var inst_31573 = cljs.core.async.close_BANG_(ch);
var state_31582__$1 = state_31582;
var statearr_31600_34371 = state_31582__$1;
(statearr_31600_34371[(2)] = inst_31573);

(statearr_31600_34371[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (9))){
var state_31582__$1 = state_31582;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31601_34373 = state_31582__$1;
(statearr_31601_34373[(1)] = (11));

} else {
var statearr_31602_34374 = state_31582__$1;
(statearr_31602_34374[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (5))){
var inst_31557 = (state_31582[(7)]);
var state_31582__$1 = state_31582;
var statearr_31603_34375 = state_31582__$1;
(statearr_31603_34375[(2)] = inst_31557);

(statearr_31603_34375[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (10))){
var inst_31578 = (state_31582[(2)]);
var state_31582__$1 = state_31582;
var statearr_31608_34379 = state_31582__$1;
(statearr_31608_34379[(2)] = inst_31578);

(statearr_31608_34379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31583 === (8))){
var inst_31557 = (state_31582[(7)]);
var inst_31569 = cljs.core.next(inst_31557);
var inst_31557__$1 = inst_31569;
var state_31582__$1 = (function (){var statearr_31609 = state_31582;
(statearr_31609[(7)] = inst_31557__$1);

return statearr_31609;
})();
var statearr_31610_34383 = state_31582__$1;
(statearr_31610_34383[(2)] = null);

(statearr_31610_34383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_31614 = [null,null,null,null,null,null,null,null];
(statearr_31614[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_31614[(1)] = (1));

return statearr_31614;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_31582){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31582);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e31618){var ex__30030__auto__ = e31618;
var statearr_31619_34385 = state_31582;
(statearr_31619_34385[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31582[(4)]))){
var statearr_31620_34386 = state_31582;
(statearr_31620_34386[(1)] = cljs.core.first((state_31582[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34392 = state_31582;
state_31582 = G__34392;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_31582){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_31582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_31621 = f__30324__auto__();
(statearr_31621[(6)] = c__30323__auto__);

return statearr_31621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

return c__30323__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31633 = arguments.length;
switch (G__31633) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_34400 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_34400(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_34401 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_34401(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_34402 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_34402(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_34404 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_34404(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31657 = (function (ch,cs,meta31658){
this.ch = ch;
this.cs = cs;
this.meta31658 = meta31658;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31659,meta31658__$1){
var self__ = this;
var _31659__$1 = this;
return (new cljs.core.async.t_cljs$core$async31657(self__.ch,self__.cs,meta31658__$1));
}));

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31659){
var self__ = this;
var _31659__$1 = this;
return self__.meta31658;
}));

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async31657.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async31657.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31658","meta31658",1321359800,null)], null);
}));

(cljs.core.async.t_cljs$core$async31657.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31657.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31657");

(cljs.core.async.t_cljs$core$async31657.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31657");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31657.
 */
cljs.core.async.__GT_t_cljs$core$async31657 = (function cljs$core$async$__GT_t_cljs$core$async31657(ch,cs,meta31658){
return (new cljs.core.async.t_cljs$core$async31657(ch,cs,meta31658));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async31657(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__30323__auto___34414 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_31822){
var state_val_31823 = (state_31822[(1)]);
if((state_val_31823 === (7))){
var inst_31815 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31824_34415 = state_31822__$1;
(statearr_31824_34415[(2)] = inst_31815);

(statearr_31824_34415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (20))){
var inst_31707 = (state_31822[(7)]);
var inst_31727 = cljs.core.first(inst_31707);
var inst_31728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31727,(0),null);
var inst_31729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31727,(1),null);
var state_31822__$1 = (function (){var statearr_31825 = state_31822;
(statearr_31825[(8)] = inst_31728);

return statearr_31825;
})();
if(cljs.core.truth_(inst_31729)){
var statearr_31826_34416 = state_31822__$1;
(statearr_31826_34416[(1)] = (22));

} else {
var statearr_31827_34420 = state_31822__$1;
(statearr_31827_34420[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (27))){
var inst_31757 = (state_31822[(9)]);
var inst_31759 = (state_31822[(10)]);
var inst_31764 = (state_31822[(11)]);
var inst_31674 = (state_31822[(12)]);
var inst_31764__$1 = cljs.core._nth(inst_31757,inst_31759);
var inst_31765 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31764__$1,inst_31674,done);
var state_31822__$1 = (function (){var statearr_31830 = state_31822;
(statearr_31830[(11)] = inst_31764__$1);

return statearr_31830;
})();
if(cljs.core.truth_(inst_31765)){
var statearr_31832_34421 = state_31822__$1;
(statearr_31832_34421[(1)] = (30));

} else {
var statearr_31833_34422 = state_31822__$1;
(statearr_31833_34422[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (1))){
var state_31822__$1 = state_31822;
var statearr_31835_34423 = state_31822__$1;
(statearr_31835_34423[(2)] = null);

(statearr_31835_34423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (24))){
var inst_31707 = (state_31822[(7)]);
var inst_31734 = (state_31822[(2)]);
var inst_31735 = cljs.core.next(inst_31707);
var inst_31683 = inst_31735;
var inst_31684 = null;
var inst_31685 = (0);
var inst_31686 = (0);
var state_31822__$1 = (function (){var statearr_31840 = state_31822;
(statearr_31840[(13)] = inst_31734);

(statearr_31840[(14)] = inst_31683);

(statearr_31840[(15)] = inst_31684);

(statearr_31840[(16)] = inst_31685);

(statearr_31840[(17)] = inst_31686);

return statearr_31840;
})();
var statearr_31842_34424 = state_31822__$1;
(statearr_31842_34424[(2)] = null);

(statearr_31842_34424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (39))){
var state_31822__$1 = state_31822;
var statearr_31846_34425 = state_31822__$1;
(statearr_31846_34425[(2)] = null);

(statearr_31846_34425[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (4))){
var inst_31674 = (state_31822[(12)]);
var inst_31674__$1 = (state_31822[(2)]);
var inst_31675 = (inst_31674__$1 == null);
var state_31822__$1 = (function (){var statearr_31848 = state_31822;
(statearr_31848[(12)] = inst_31674__$1);

return statearr_31848;
})();
if(cljs.core.truth_(inst_31675)){
var statearr_31849_34426 = state_31822__$1;
(statearr_31849_34426[(1)] = (5));

} else {
var statearr_31851_34427 = state_31822__$1;
(statearr_31851_34427[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (15))){
var inst_31686 = (state_31822[(17)]);
var inst_31683 = (state_31822[(14)]);
var inst_31684 = (state_31822[(15)]);
var inst_31685 = (state_31822[(16)]);
var inst_31703 = (state_31822[(2)]);
var inst_31704 = (inst_31686 + (1));
var tmp31843 = inst_31685;
var tmp31844 = inst_31684;
var tmp31845 = inst_31683;
var inst_31683__$1 = tmp31845;
var inst_31684__$1 = tmp31844;
var inst_31685__$1 = tmp31843;
var inst_31686__$1 = inst_31704;
var state_31822__$1 = (function (){var statearr_31857 = state_31822;
(statearr_31857[(18)] = inst_31703);

(statearr_31857[(14)] = inst_31683__$1);

(statearr_31857[(15)] = inst_31684__$1);

(statearr_31857[(16)] = inst_31685__$1);

(statearr_31857[(17)] = inst_31686__$1);

return statearr_31857;
})();
var statearr_31858_34429 = state_31822__$1;
(statearr_31858_34429[(2)] = null);

(statearr_31858_34429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (21))){
var inst_31738 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31862_34433 = state_31822__$1;
(statearr_31862_34433[(2)] = inst_31738);

(statearr_31862_34433[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (31))){
var inst_31764 = (state_31822[(11)]);
var inst_31768 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31764);
var state_31822__$1 = state_31822;
var statearr_31863_34434 = state_31822__$1;
(statearr_31863_34434[(2)] = inst_31768);

(statearr_31863_34434[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (32))){
var inst_31759 = (state_31822[(10)]);
var inst_31756 = (state_31822[(19)]);
var inst_31757 = (state_31822[(9)]);
var inst_31758 = (state_31822[(20)]);
var inst_31770 = (state_31822[(2)]);
var inst_31771 = (inst_31759 + (1));
var tmp31859 = inst_31758;
var tmp31860 = inst_31756;
var tmp31861 = inst_31757;
var inst_31756__$1 = tmp31860;
var inst_31757__$1 = tmp31861;
var inst_31758__$1 = tmp31859;
var inst_31759__$1 = inst_31771;
var state_31822__$1 = (function (){var statearr_31864 = state_31822;
(statearr_31864[(21)] = inst_31770);

(statearr_31864[(19)] = inst_31756__$1);

(statearr_31864[(9)] = inst_31757__$1);

(statearr_31864[(20)] = inst_31758__$1);

(statearr_31864[(10)] = inst_31759__$1);

return statearr_31864;
})();
var statearr_31870_34437 = state_31822__$1;
(statearr_31870_34437[(2)] = null);

(statearr_31870_34437[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (40))){
var inst_31785 = (state_31822[(22)]);
var inst_31791 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31785);
var state_31822__$1 = state_31822;
var statearr_31871_34441 = state_31822__$1;
(statearr_31871_34441[(2)] = inst_31791);

(statearr_31871_34441[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (33))){
var inst_31774 = (state_31822[(23)]);
var inst_31776 = cljs.core.chunked_seq_QMARK_(inst_31774);
var state_31822__$1 = state_31822;
if(inst_31776){
var statearr_31875_34442 = state_31822__$1;
(statearr_31875_34442[(1)] = (36));

} else {
var statearr_31876_34443 = state_31822__$1;
(statearr_31876_34443[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (13))){
var inst_31697 = (state_31822[(24)]);
var inst_31700 = cljs.core.async.close_BANG_(inst_31697);
var state_31822__$1 = state_31822;
var statearr_31880_34445 = state_31822__$1;
(statearr_31880_34445[(2)] = inst_31700);

(statearr_31880_34445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (22))){
var inst_31728 = (state_31822[(8)]);
var inst_31731 = cljs.core.async.close_BANG_(inst_31728);
var state_31822__$1 = state_31822;
var statearr_31881_34446 = state_31822__$1;
(statearr_31881_34446[(2)] = inst_31731);

(statearr_31881_34446[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (36))){
var inst_31774 = (state_31822[(23)]);
var inst_31780 = cljs.core.chunk_first(inst_31774);
var inst_31781 = cljs.core.chunk_rest(inst_31774);
var inst_31782 = cljs.core.count(inst_31780);
var inst_31756 = inst_31781;
var inst_31757 = inst_31780;
var inst_31758 = inst_31782;
var inst_31759 = (0);
var state_31822__$1 = (function (){var statearr_31883 = state_31822;
(statearr_31883[(19)] = inst_31756);

(statearr_31883[(9)] = inst_31757);

(statearr_31883[(20)] = inst_31758);

(statearr_31883[(10)] = inst_31759);

return statearr_31883;
})();
var statearr_31885_34454 = state_31822__$1;
(statearr_31885_34454[(2)] = null);

(statearr_31885_34454[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (41))){
var inst_31774 = (state_31822[(23)]);
var inst_31793 = (state_31822[(2)]);
var inst_31794 = cljs.core.next(inst_31774);
var inst_31756 = inst_31794;
var inst_31757 = null;
var inst_31758 = (0);
var inst_31759 = (0);
var state_31822__$1 = (function (){var statearr_31889 = state_31822;
(statearr_31889[(25)] = inst_31793);

(statearr_31889[(19)] = inst_31756);

(statearr_31889[(9)] = inst_31757);

(statearr_31889[(20)] = inst_31758);

(statearr_31889[(10)] = inst_31759);

return statearr_31889;
})();
var statearr_31894_34459 = state_31822__$1;
(statearr_31894_34459[(2)] = null);

(statearr_31894_34459[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (43))){
var state_31822__$1 = state_31822;
var statearr_31898_34463 = state_31822__$1;
(statearr_31898_34463[(2)] = null);

(statearr_31898_34463[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (29))){
var inst_31803 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31899_34464 = state_31822__$1;
(statearr_31899_34464[(2)] = inst_31803);

(statearr_31899_34464[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (44))){
var inst_31812 = (state_31822[(2)]);
var state_31822__$1 = (function (){var statearr_31902 = state_31822;
(statearr_31902[(26)] = inst_31812);

return statearr_31902;
})();
var statearr_31903_34465 = state_31822__$1;
(statearr_31903_34465[(2)] = null);

(statearr_31903_34465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (6))){
var inst_31748 = (state_31822[(27)]);
var inst_31747 = cljs.core.deref(cs);
var inst_31748__$1 = cljs.core.keys(inst_31747);
var inst_31749 = cljs.core.count(inst_31748__$1);
var inst_31750 = cljs.core.reset_BANG_(dctr,inst_31749);
var inst_31755 = cljs.core.seq(inst_31748__$1);
var inst_31756 = inst_31755;
var inst_31757 = null;
var inst_31758 = (0);
var inst_31759 = (0);
var state_31822__$1 = (function (){var statearr_31912 = state_31822;
(statearr_31912[(27)] = inst_31748__$1);

(statearr_31912[(28)] = inst_31750);

(statearr_31912[(19)] = inst_31756);

(statearr_31912[(9)] = inst_31757);

(statearr_31912[(20)] = inst_31758);

(statearr_31912[(10)] = inst_31759);

return statearr_31912;
})();
var statearr_31917_34466 = state_31822__$1;
(statearr_31917_34466[(2)] = null);

(statearr_31917_34466[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (28))){
var inst_31756 = (state_31822[(19)]);
var inst_31774 = (state_31822[(23)]);
var inst_31774__$1 = cljs.core.seq(inst_31756);
var state_31822__$1 = (function (){var statearr_31919 = state_31822;
(statearr_31919[(23)] = inst_31774__$1);

return statearr_31919;
})();
if(inst_31774__$1){
var statearr_31920_34468 = state_31822__$1;
(statearr_31920_34468[(1)] = (33));

} else {
var statearr_31922_34469 = state_31822__$1;
(statearr_31922_34469[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (25))){
var inst_31759 = (state_31822[(10)]);
var inst_31758 = (state_31822[(20)]);
var inst_31761 = (inst_31759 < inst_31758);
var inst_31762 = inst_31761;
var state_31822__$1 = state_31822;
if(cljs.core.truth_(inst_31762)){
var statearr_31926_34470 = state_31822__$1;
(statearr_31926_34470[(1)] = (27));

} else {
var statearr_31930_34471 = state_31822__$1;
(statearr_31930_34471[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (34))){
var state_31822__$1 = state_31822;
var statearr_31931_34472 = state_31822__$1;
(statearr_31931_34472[(2)] = null);

(statearr_31931_34472[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (17))){
var state_31822__$1 = state_31822;
var statearr_31935_34473 = state_31822__$1;
(statearr_31935_34473[(2)] = null);

(statearr_31935_34473[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (3))){
var inst_31817 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31822__$1,inst_31817);
} else {
if((state_val_31823 === (12))){
var inst_31743 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31940_34478 = state_31822__$1;
(statearr_31940_34478[(2)] = inst_31743);

(statearr_31940_34478[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (2))){
var state_31822__$1 = state_31822;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31822__$1,(4),ch);
} else {
if((state_val_31823 === (23))){
var state_31822__$1 = state_31822;
var statearr_31945_34479 = state_31822__$1;
(statearr_31945_34479[(2)] = null);

(statearr_31945_34479[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (35))){
var inst_31801 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31947_34482 = state_31822__$1;
(statearr_31947_34482[(2)] = inst_31801);

(statearr_31947_34482[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (19))){
var inst_31707 = (state_31822[(7)]);
var inst_31718 = cljs.core.chunk_first(inst_31707);
var inst_31719 = cljs.core.chunk_rest(inst_31707);
var inst_31721 = cljs.core.count(inst_31718);
var inst_31683 = inst_31719;
var inst_31684 = inst_31718;
var inst_31685 = inst_31721;
var inst_31686 = (0);
var state_31822__$1 = (function (){var statearr_31949 = state_31822;
(statearr_31949[(14)] = inst_31683);

(statearr_31949[(15)] = inst_31684);

(statearr_31949[(16)] = inst_31685);

(statearr_31949[(17)] = inst_31686);

return statearr_31949;
})();
var statearr_31950_34488 = state_31822__$1;
(statearr_31950_34488[(2)] = null);

(statearr_31950_34488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (11))){
var inst_31683 = (state_31822[(14)]);
var inst_31707 = (state_31822[(7)]);
var inst_31707__$1 = cljs.core.seq(inst_31683);
var state_31822__$1 = (function (){var statearr_31954 = state_31822;
(statearr_31954[(7)] = inst_31707__$1);

return statearr_31954;
})();
if(inst_31707__$1){
var statearr_31956_34489 = state_31822__$1;
(statearr_31956_34489[(1)] = (16));

} else {
var statearr_31958_34490 = state_31822__$1;
(statearr_31958_34490[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (9))){
var inst_31745 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31960_34491 = state_31822__$1;
(statearr_31960_34491[(2)] = inst_31745);

(statearr_31960_34491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (5))){
var inst_31681 = cljs.core.deref(cs);
var inst_31682 = cljs.core.seq(inst_31681);
var inst_31683 = inst_31682;
var inst_31684 = null;
var inst_31685 = (0);
var inst_31686 = (0);
var state_31822__$1 = (function (){var statearr_31961 = state_31822;
(statearr_31961[(14)] = inst_31683);

(statearr_31961[(15)] = inst_31684);

(statearr_31961[(16)] = inst_31685);

(statearr_31961[(17)] = inst_31686);

return statearr_31961;
})();
var statearr_31969_34495 = state_31822__$1;
(statearr_31969_34495[(2)] = null);

(statearr_31969_34495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (14))){
var state_31822__$1 = state_31822;
var statearr_31970_34500 = state_31822__$1;
(statearr_31970_34500[(2)] = null);

(statearr_31970_34500[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (45))){
var inst_31809 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31972_34501 = state_31822__$1;
(statearr_31972_34501[(2)] = inst_31809);

(statearr_31972_34501[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (26))){
var inst_31748 = (state_31822[(27)]);
var inst_31805 = (state_31822[(2)]);
var inst_31806 = cljs.core.seq(inst_31748);
var state_31822__$1 = (function (){var statearr_31973 = state_31822;
(statearr_31973[(29)] = inst_31805);

return statearr_31973;
})();
if(inst_31806){
var statearr_31976_34502 = state_31822__$1;
(statearr_31976_34502[(1)] = (42));

} else {
var statearr_31978_34509 = state_31822__$1;
(statearr_31978_34509[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (16))){
var inst_31707 = (state_31822[(7)]);
var inst_31715 = cljs.core.chunked_seq_QMARK_(inst_31707);
var state_31822__$1 = state_31822;
if(inst_31715){
var statearr_31979_34510 = state_31822__$1;
(statearr_31979_34510[(1)] = (19));

} else {
var statearr_31980_34511 = state_31822__$1;
(statearr_31980_34511[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (38))){
var inst_31798 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31982_34512 = state_31822__$1;
(statearr_31982_34512[(2)] = inst_31798);

(statearr_31982_34512[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (30))){
var state_31822__$1 = state_31822;
var statearr_31984_34513 = state_31822__$1;
(statearr_31984_34513[(2)] = null);

(statearr_31984_34513[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (10))){
var inst_31684 = (state_31822[(15)]);
var inst_31686 = (state_31822[(17)]);
var inst_31696 = cljs.core._nth(inst_31684,inst_31686);
var inst_31697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31696,(0),null);
var inst_31698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31696,(1),null);
var state_31822__$1 = (function (){var statearr_31987 = state_31822;
(statearr_31987[(24)] = inst_31697);

return statearr_31987;
})();
if(cljs.core.truth_(inst_31698)){
var statearr_31988_34514 = state_31822__$1;
(statearr_31988_34514[(1)] = (13));

} else {
var statearr_31990_34515 = state_31822__$1;
(statearr_31990_34515[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (18))){
var inst_31741 = (state_31822[(2)]);
var state_31822__$1 = state_31822;
var statearr_31991_34516 = state_31822__$1;
(statearr_31991_34516[(2)] = inst_31741);

(statearr_31991_34516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (42))){
var state_31822__$1 = state_31822;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31822__$1,(45),dchan);
} else {
if((state_val_31823 === (37))){
var inst_31774 = (state_31822[(23)]);
var inst_31785 = (state_31822[(22)]);
var inst_31674 = (state_31822[(12)]);
var inst_31785__$1 = cljs.core.first(inst_31774);
var inst_31788 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31785__$1,inst_31674,done);
var state_31822__$1 = (function (){var statearr_31996 = state_31822;
(statearr_31996[(22)] = inst_31785__$1);

return statearr_31996;
})();
if(cljs.core.truth_(inst_31788)){
var statearr_31998_34520 = state_31822__$1;
(statearr_31998_34520[(1)] = (39));

} else {
var statearr_31999_34521 = state_31822__$1;
(statearr_31999_34521[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31823 === (8))){
var inst_31686 = (state_31822[(17)]);
var inst_31685 = (state_31822[(16)]);
var inst_31688 = (inst_31686 < inst_31685);
var inst_31689 = inst_31688;
var state_31822__$1 = state_31822;
if(cljs.core.truth_(inst_31689)){
var statearr_32002_34522 = state_31822__$1;
(statearr_32002_34522[(1)] = (10));

} else {
var statearr_32004_34523 = state_31822__$1;
(statearr_32004_34523[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__30027__auto__ = null;
var cljs$core$async$mult_$_state_machine__30027__auto____0 = (function (){
var statearr_32011 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32011[(0)] = cljs$core$async$mult_$_state_machine__30027__auto__);

(statearr_32011[(1)] = (1));

return statearr_32011;
});
var cljs$core$async$mult_$_state_machine__30027__auto____1 = (function (state_31822){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_31822);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e32017){var ex__30030__auto__ = e32017;
var statearr_32019_34524 = state_31822;
(statearr_32019_34524[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_31822[(4)]))){
var statearr_32021_34525 = state_31822;
(statearr_32021_34525[(1)] = cljs.core.first((state_31822[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34526 = state_31822;
state_31822 = G__34526;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30027__auto__ = function(state_31822){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30027__auto____1.call(this,state_31822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30027__auto____0;
cljs$core$async$mult_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30027__auto____1;
return cljs$core$async$mult_$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_32025 = f__30324__auto__();
(statearr_32025[(6)] = c__30323__auto___34414);

return statearr_32025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32032 = arguments.length;
switch (G__32032) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_34532 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_34532(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_34539 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_34539(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_34540 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_34540(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_34541 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_34541(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_34548 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_34548(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34564 = arguments.length;
var i__5770__auto___34568 = (0);
while(true){
if((i__5770__auto___34568 < len__5769__auto___34564)){
args__5775__auto__.push((arguments[i__5770__auto___34568]));

var G__34574 = (i__5770__auto___34568 + (1));
i__5770__auto___34568 = G__34574;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32090){
var map__32091 = p__32090;
var map__32091__$1 = cljs.core.__destructure_map(map__32091);
var opts = map__32091__$1;
var statearr_32092_34579 = state;
(statearr_32092_34579[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_32098_34580 = state;
(statearr_32098_34580[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_32104_34587 = state;
(statearr_32104_34587[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32079){
var G__32080 = cljs.core.first(seq32079);
var seq32079__$1 = cljs.core.next(seq32079);
var G__32081 = cljs.core.first(seq32079__$1);
var seq32079__$2 = cljs.core.next(seq32079__$1);
var G__32082 = cljs.core.first(seq32079__$2);
var seq32079__$3 = cljs.core.next(seq32079__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32080,G__32081,G__32082,seq32079__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32112 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32113){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32113 = meta32113;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32114,meta32113__$1){
var self__ = this;
var _32114__$1 = this;
return (new cljs.core.async.t_cljs$core$async32112(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32113__$1));
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32114){
var self__ = this;
var _32114__$1 = this;
return self__.meta32113;
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32112.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async32112.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta32113","meta32113",950322692,null)], null);
}));

(cljs.core.async.t_cljs$core$async32112.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32112.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32112");

(cljs.core.async.t_cljs$core$async32112.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32112");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32112.
 */
cljs.core.async.__GT_t_cljs$core$async32112 = (function cljs$core$async$__GT_t_cljs$core$async32112(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32113){
return (new cljs.core.async.t_cljs$core$async32112(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32113));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async32112(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__30323__auto___34612 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_32186){
var state_val_32187 = (state_32186[(1)]);
if((state_val_32187 === (7))){
var inst_32145 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
if(cljs.core.truth_(inst_32145)){
var statearr_32189_34613 = state_32186__$1;
(statearr_32189_34613[(1)] = (8));

} else {
var statearr_32190_34614 = state_32186__$1;
(statearr_32190_34614[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (20))){
var inst_32138 = (state_32186[(7)]);
var state_32186__$1 = state_32186;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32186__$1,(23),out,inst_32138);
} else {
if((state_val_32187 === (1))){
var inst_32121 = calc_state();
var inst_32122 = cljs.core.__destructure_map(inst_32121);
var inst_32123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32122,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32122,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32122,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32126 = inst_32121;
var state_32186__$1 = (function (){var statearr_32191 = state_32186;
(statearr_32191[(8)] = inst_32123);

(statearr_32191[(9)] = inst_32124);

(statearr_32191[(10)] = inst_32125);

(statearr_32191[(11)] = inst_32126);

return statearr_32191;
})();
var statearr_32192_34615 = state_32186__$1;
(statearr_32192_34615[(2)] = null);

(statearr_32192_34615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (24))){
var inst_32129 = (state_32186[(12)]);
var inst_32126 = inst_32129;
var state_32186__$1 = (function (){var statearr_32193 = state_32186;
(statearr_32193[(11)] = inst_32126);

return statearr_32193;
})();
var statearr_32194_34618 = state_32186__$1;
(statearr_32194_34618[(2)] = null);

(statearr_32194_34618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (4))){
var inst_32138 = (state_32186[(7)]);
var inst_32140 = (state_32186[(13)]);
var inst_32137 = (state_32186[(2)]);
var inst_32138__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32137,(0),null);
var inst_32139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32137,(1),null);
var inst_32140__$1 = (inst_32138__$1 == null);
var state_32186__$1 = (function (){var statearr_32195 = state_32186;
(statearr_32195[(7)] = inst_32138__$1);

(statearr_32195[(14)] = inst_32139);

(statearr_32195[(13)] = inst_32140__$1);

return statearr_32195;
})();
if(cljs.core.truth_(inst_32140__$1)){
var statearr_32196_34623 = state_32186__$1;
(statearr_32196_34623[(1)] = (5));

} else {
var statearr_32197_34624 = state_32186__$1;
(statearr_32197_34624[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (15))){
var inst_32130 = (state_32186[(15)]);
var inst_32160 = (state_32186[(16)]);
var inst_32160__$1 = cljs.core.empty_QMARK_(inst_32130);
var state_32186__$1 = (function (){var statearr_32198 = state_32186;
(statearr_32198[(16)] = inst_32160__$1);

return statearr_32198;
})();
if(inst_32160__$1){
var statearr_32200_34625 = state_32186__$1;
(statearr_32200_34625[(1)] = (17));

} else {
var statearr_32201_34626 = state_32186__$1;
(statearr_32201_34626[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (21))){
var inst_32129 = (state_32186[(12)]);
var inst_32126 = inst_32129;
var state_32186__$1 = (function (){var statearr_32202 = state_32186;
(statearr_32202[(11)] = inst_32126);

return statearr_32202;
})();
var statearr_32203_34629 = state_32186__$1;
(statearr_32203_34629[(2)] = null);

(statearr_32203_34629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (13))){
var inst_32153 = (state_32186[(2)]);
var inst_32154 = calc_state();
var inst_32126 = inst_32154;
var state_32186__$1 = (function (){var statearr_32204 = state_32186;
(statearr_32204[(17)] = inst_32153);

(statearr_32204[(11)] = inst_32126);

return statearr_32204;
})();
var statearr_32205_34630 = state_32186__$1;
(statearr_32205_34630[(2)] = null);

(statearr_32205_34630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (22))){
var inst_32180 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
var statearr_32206_34631 = state_32186__$1;
(statearr_32206_34631[(2)] = inst_32180);

(statearr_32206_34631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (6))){
var inst_32139 = (state_32186[(14)]);
var inst_32143 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32139,change);
var state_32186__$1 = state_32186;
var statearr_32207_34633 = state_32186__$1;
(statearr_32207_34633[(2)] = inst_32143);

(statearr_32207_34633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (25))){
var state_32186__$1 = state_32186;
var statearr_32208_34634 = state_32186__$1;
(statearr_32208_34634[(2)] = null);

(statearr_32208_34634[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (17))){
var inst_32131 = (state_32186[(18)]);
var inst_32139 = (state_32186[(14)]);
var inst_32162 = (inst_32131.cljs$core$IFn$_invoke$arity$1 ? inst_32131.cljs$core$IFn$_invoke$arity$1(inst_32139) : inst_32131.call(null,inst_32139));
var inst_32163 = cljs.core.not(inst_32162);
var state_32186__$1 = state_32186;
var statearr_32209_34636 = state_32186__$1;
(statearr_32209_34636[(2)] = inst_32163);

(statearr_32209_34636[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (3))){
var inst_32184 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32186__$1,inst_32184);
} else {
if((state_val_32187 === (12))){
var state_32186__$1 = state_32186;
var statearr_32210_34645 = state_32186__$1;
(statearr_32210_34645[(2)] = null);

(statearr_32210_34645[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (2))){
var inst_32126 = (state_32186[(11)]);
var inst_32129 = (state_32186[(12)]);
var inst_32129__$1 = cljs.core.__destructure_map(inst_32126);
var inst_32130 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32129__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32129__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32132 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32129__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32186__$1 = (function (){var statearr_32211 = state_32186;
(statearr_32211[(12)] = inst_32129__$1);

(statearr_32211[(15)] = inst_32130);

(statearr_32211[(18)] = inst_32131);

return statearr_32211;
})();
return cljs.core.async.ioc_alts_BANG_(state_32186__$1,(4),inst_32132);
} else {
if((state_val_32187 === (23))){
var inst_32171 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
if(cljs.core.truth_(inst_32171)){
var statearr_32212_34651 = state_32186__$1;
(statearr_32212_34651[(1)] = (24));

} else {
var statearr_32213_34652 = state_32186__$1;
(statearr_32213_34652[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (19))){
var inst_32166 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
var statearr_32214_34653 = state_32186__$1;
(statearr_32214_34653[(2)] = inst_32166);

(statearr_32214_34653[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (11))){
var inst_32139 = (state_32186[(14)]);
var inst_32150 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32139);
var state_32186__$1 = state_32186;
var statearr_32215_34654 = state_32186__$1;
(statearr_32215_34654[(2)] = inst_32150);

(statearr_32215_34654[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (9))){
var inst_32130 = (state_32186[(15)]);
var inst_32139 = (state_32186[(14)]);
var inst_32157 = (state_32186[(19)]);
var inst_32157__$1 = (inst_32130.cljs$core$IFn$_invoke$arity$1 ? inst_32130.cljs$core$IFn$_invoke$arity$1(inst_32139) : inst_32130.call(null,inst_32139));
var state_32186__$1 = (function (){var statearr_32216 = state_32186;
(statearr_32216[(19)] = inst_32157__$1);

return statearr_32216;
})();
if(cljs.core.truth_(inst_32157__$1)){
var statearr_32217_34658 = state_32186__$1;
(statearr_32217_34658[(1)] = (14));

} else {
var statearr_32218_34663 = state_32186__$1;
(statearr_32218_34663[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (5))){
var inst_32140 = (state_32186[(13)]);
var state_32186__$1 = state_32186;
var statearr_32219_34665 = state_32186__$1;
(statearr_32219_34665[(2)] = inst_32140);

(statearr_32219_34665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (14))){
var inst_32157 = (state_32186[(19)]);
var state_32186__$1 = state_32186;
var statearr_32221_34666 = state_32186__$1;
(statearr_32221_34666[(2)] = inst_32157);

(statearr_32221_34666[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (26))){
var inst_32176 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
var statearr_32225_34671 = state_32186__$1;
(statearr_32225_34671[(2)] = inst_32176);

(statearr_32225_34671[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (16))){
var inst_32168 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
if(cljs.core.truth_(inst_32168)){
var statearr_32226_34676 = state_32186__$1;
(statearr_32226_34676[(1)] = (20));

} else {
var statearr_32227_34677 = state_32186__$1;
(statearr_32227_34677[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (10))){
var inst_32182 = (state_32186[(2)]);
var state_32186__$1 = state_32186;
var statearr_32234_34678 = state_32186__$1;
(statearr_32234_34678[(2)] = inst_32182);

(statearr_32234_34678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (18))){
var inst_32160 = (state_32186[(16)]);
var state_32186__$1 = state_32186;
var statearr_32235_34679 = state_32186__$1;
(statearr_32235_34679[(2)] = inst_32160);

(statearr_32235_34679[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32187 === (8))){
var inst_32138 = (state_32186[(7)]);
var inst_32147 = (inst_32138 == null);
var state_32186__$1 = state_32186;
if(cljs.core.truth_(inst_32147)){
var statearr_32236_34680 = state_32186__$1;
(statearr_32236_34680[(1)] = (11));

} else {
var statearr_32238_34681 = state_32186__$1;
(statearr_32238_34681[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__30027__auto__ = null;
var cljs$core$async$mix_$_state_machine__30027__auto____0 = (function (){
var statearr_32239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32239[(0)] = cljs$core$async$mix_$_state_machine__30027__auto__);

(statearr_32239[(1)] = (1));

return statearr_32239;
});
var cljs$core$async$mix_$_state_machine__30027__auto____1 = (function (state_32186){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_32186);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e32242){var ex__30030__auto__ = e32242;
var statearr_32244_34685 = state_32186;
(statearr_32244_34685[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_32186[(4)]))){
var statearr_32245_34686 = state_32186;
(statearr_32245_34686[(1)] = cljs.core.first((state_32186[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34687 = state_32186;
state_32186 = G__34687;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30027__auto__ = function(state_32186){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30027__auto____1.call(this,state_32186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30027__auto____0;
cljs$core$async$mix_$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30027__auto____1;
return cljs$core$async$mix_$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_32251 = f__30324__auto__();
(statearr_32251[(6)] = c__30323__auto___34612);

return statearr_32251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_34688 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_34688(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_34692 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_34692(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_34695 = (function() {
var G__34696 = null;
var G__34696__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__34696__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__34696 = function(p,v){
switch(arguments.length){
case 1:
return G__34696__1.call(this,p);
case 2:
return G__34696__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34696.cljs$core$IFn$_invoke$arity$1 = G__34696__1;
G__34696.cljs$core$IFn$_invoke$arity$2 = G__34696__2;
return G__34696;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32358 = arguments.length;
switch (G__32358) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34695(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_34695(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32412 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32413){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32413 = meta32413;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32414,meta32413__$1){
var self__ = this;
var _32414__$1 = this;
return (new cljs.core.async.t_cljs$core$async32412(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32413__$1));
}));

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32414){
var self__ = this;
var _32414__$1 = this;
return self__.meta32413;
}));

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async32412.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32413","meta32413",1205644109,null)], null);
}));

(cljs.core.async.t_cljs$core$async32412.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32412.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32412");

(cljs.core.async.t_cljs$core$async32412.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32412");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32412.
 */
cljs.core.async.__GT_t_cljs$core$async32412 = (function cljs$core$async$__GT_t_cljs$core$async32412(ch,topic_fn,buf_fn,mults,ensure_mult,meta32413){
return (new cljs.core.async.t_cljs$core$async32412(ch,topic_fn,buf_fn,mults,ensure_mult,meta32413));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32395 = arguments.length;
switch (G__32395) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__32378_SHARP_){
if(cljs.core.truth_((p1__32378_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32378_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32378_SHARP_.call(null,topic)))){
return p1__32378_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32378_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async32412(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__30323__auto___34713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_32540){
var state_val_32541 = (state_32540[(1)]);
if((state_val_32541 === (7))){
var inst_32532 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
var statearr_32548_34714 = state_32540__$1;
(statearr_32548_34714[(2)] = inst_32532);

(statearr_32548_34714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (20))){
var state_32540__$1 = state_32540;
var statearr_32549_34715 = state_32540__$1;
(statearr_32549_34715[(2)] = null);

(statearr_32549_34715[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (1))){
var state_32540__$1 = state_32540;
var statearr_32552_34716 = state_32540__$1;
(statearr_32552_34716[(2)] = null);

(statearr_32552_34716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (24))){
var inst_32509 = (state_32540[(7)]);
var inst_32522 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32509);
var state_32540__$1 = state_32540;
var statearr_32558_34717 = state_32540__$1;
(statearr_32558_34717[(2)] = inst_32522);

(statearr_32558_34717[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (4))){
var inst_32452 = (state_32540[(8)]);
var inst_32452__$1 = (state_32540[(2)]);
var inst_32453 = (inst_32452__$1 == null);
var state_32540__$1 = (function (){var statearr_32559 = state_32540;
(statearr_32559[(8)] = inst_32452__$1);

return statearr_32559;
})();
if(cljs.core.truth_(inst_32453)){
var statearr_32560_34718 = state_32540__$1;
(statearr_32560_34718[(1)] = (5));

} else {
var statearr_32561_34719 = state_32540__$1;
(statearr_32561_34719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (15))){
var inst_32503 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
var statearr_32571_34720 = state_32540__$1;
(statearr_32571_34720[(2)] = inst_32503);

(statearr_32571_34720[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (21))){
var inst_32527 = (state_32540[(2)]);
var state_32540__$1 = (function (){var statearr_32572 = state_32540;
(statearr_32572[(9)] = inst_32527);

return statearr_32572;
})();
var statearr_32573_34721 = state_32540__$1;
(statearr_32573_34721[(2)] = null);

(statearr_32573_34721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (13))){
var inst_32477 = (state_32540[(10)]);
var inst_32479 = cljs.core.chunked_seq_QMARK_(inst_32477);
var state_32540__$1 = state_32540;
if(inst_32479){
var statearr_32575_34726 = state_32540__$1;
(statearr_32575_34726[(1)] = (16));

} else {
var statearr_32576_34727 = state_32540__$1;
(statearr_32576_34727[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (22))){
var inst_32518 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
if(cljs.core.truth_(inst_32518)){
var statearr_32577_34728 = state_32540__$1;
(statearr_32577_34728[(1)] = (23));

} else {
var statearr_32578_34729 = state_32540__$1;
(statearr_32578_34729[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (6))){
var inst_32452 = (state_32540[(8)]);
var inst_32509 = (state_32540[(7)]);
var inst_32511 = (state_32540[(11)]);
var inst_32509__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32452) : topic_fn.call(null,inst_32452));
var inst_32510 = cljs.core.deref(mults);
var inst_32511__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32510,inst_32509__$1);
var state_32540__$1 = (function (){var statearr_32579 = state_32540;
(statearr_32579[(7)] = inst_32509__$1);

(statearr_32579[(11)] = inst_32511__$1);

return statearr_32579;
})();
if(cljs.core.truth_(inst_32511__$1)){
var statearr_32580_34730 = state_32540__$1;
(statearr_32580_34730[(1)] = (19));

} else {
var statearr_32581_34731 = state_32540__$1;
(statearr_32581_34731[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (25))){
var inst_32524 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
var statearr_32586_34732 = state_32540__$1;
(statearr_32586_34732[(2)] = inst_32524);

(statearr_32586_34732[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (17))){
var inst_32477 = (state_32540[(10)]);
var inst_32494 = cljs.core.first(inst_32477);
var inst_32495 = cljs.core.async.muxch_STAR_(inst_32494);
var inst_32496 = cljs.core.async.close_BANG_(inst_32495);
var inst_32497 = cljs.core.next(inst_32477);
var inst_32462 = inst_32497;
var inst_32463 = null;
var inst_32464 = (0);
var inst_32465 = (0);
var state_32540__$1 = (function (){var statearr_32591 = state_32540;
(statearr_32591[(12)] = inst_32496);

(statearr_32591[(13)] = inst_32462);

(statearr_32591[(14)] = inst_32463);

(statearr_32591[(15)] = inst_32464);

(statearr_32591[(16)] = inst_32465);

return statearr_32591;
})();
var statearr_32593_34736 = state_32540__$1;
(statearr_32593_34736[(2)] = null);

(statearr_32593_34736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (3))){
var inst_32534 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32540__$1,inst_32534);
} else {
if((state_val_32541 === (12))){
var inst_32505 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
var statearr_32595_34738 = state_32540__$1;
(statearr_32595_34738[(2)] = inst_32505);

(statearr_32595_34738[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (2))){
var state_32540__$1 = state_32540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32540__$1,(4),ch);
} else {
if((state_val_32541 === (23))){
var state_32540__$1 = state_32540;
var statearr_32597_34739 = state_32540__$1;
(statearr_32597_34739[(2)] = null);

(statearr_32597_34739[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (19))){
var inst_32511 = (state_32540[(11)]);
var inst_32452 = (state_32540[(8)]);
var inst_32516 = cljs.core.async.muxch_STAR_(inst_32511);
var state_32540__$1 = state_32540;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32540__$1,(22),inst_32516,inst_32452);
} else {
if((state_val_32541 === (11))){
var inst_32462 = (state_32540[(13)]);
var inst_32477 = (state_32540[(10)]);
var inst_32477__$1 = cljs.core.seq(inst_32462);
var state_32540__$1 = (function (){var statearr_32599 = state_32540;
(statearr_32599[(10)] = inst_32477__$1);

return statearr_32599;
})();
if(inst_32477__$1){
var statearr_32600_34740 = state_32540__$1;
(statearr_32600_34740[(1)] = (13));

} else {
var statearr_32601_34745 = state_32540__$1;
(statearr_32601_34745[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (9))){
var inst_32507 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
var statearr_32602_34746 = state_32540__$1;
(statearr_32602_34746[(2)] = inst_32507);

(statearr_32602_34746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (5))){
var inst_32459 = cljs.core.deref(mults);
var inst_32460 = cljs.core.vals(inst_32459);
var inst_32461 = cljs.core.seq(inst_32460);
var inst_32462 = inst_32461;
var inst_32463 = null;
var inst_32464 = (0);
var inst_32465 = (0);
var state_32540__$1 = (function (){var statearr_32605 = state_32540;
(statearr_32605[(13)] = inst_32462);

(statearr_32605[(14)] = inst_32463);

(statearr_32605[(15)] = inst_32464);

(statearr_32605[(16)] = inst_32465);

return statearr_32605;
})();
var statearr_32606_34747 = state_32540__$1;
(statearr_32606_34747[(2)] = null);

(statearr_32606_34747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (14))){
var state_32540__$1 = state_32540;
var statearr_32610_34748 = state_32540__$1;
(statearr_32610_34748[(2)] = null);

(statearr_32610_34748[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (16))){
var inst_32477 = (state_32540[(10)]);
var inst_32481 = cljs.core.chunk_first(inst_32477);
var inst_32486 = cljs.core.chunk_rest(inst_32477);
var inst_32491 = cljs.core.count(inst_32481);
var inst_32462 = inst_32486;
var inst_32463 = inst_32481;
var inst_32464 = inst_32491;
var inst_32465 = (0);
var state_32540__$1 = (function (){var statearr_32611 = state_32540;
(statearr_32611[(13)] = inst_32462);

(statearr_32611[(14)] = inst_32463);

(statearr_32611[(15)] = inst_32464);

(statearr_32611[(16)] = inst_32465);

return statearr_32611;
})();
var statearr_32612_34749 = state_32540__$1;
(statearr_32612_34749[(2)] = null);

(statearr_32612_34749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (10))){
var inst_32463 = (state_32540[(14)]);
var inst_32465 = (state_32540[(16)]);
var inst_32462 = (state_32540[(13)]);
var inst_32464 = (state_32540[(15)]);
var inst_32470 = cljs.core._nth(inst_32463,inst_32465);
var inst_32471 = cljs.core.async.muxch_STAR_(inst_32470);
var inst_32472 = cljs.core.async.close_BANG_(inst_32471);
var inst_32474 = (inst_32465 + (1));
var tmp32607 = inst_32462;
var tmp32608 = inst_32464;
var tmp32609 = inst_32463;
var inst_32462__$1 = tmp32607;
var inst_32463__$1 = tmp32609;
var inst_32464__$1 = tmp32608;
var inst_32465__$1 = inst_32474;
var state_32540__$1 = (function (){var statearr_32615 = state_32540;
(statearr_32615[(17)] = inst_32472);

(statearr_32615[(13)] = inst_32462__$1);

(statearr_32615[(14)] = inst_32463__$1);

(statearr_32615[(15)] = inst_32464__$1);

(statearr_32615[(16)] = inst_32465__$1);

return statearr_32615;
})();
var statearr_32616_34753 = state_32540__$1;
(statearr_32616_34753[(2)] = null);

(statearr_32616_34753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (18))){
var inst_32500 = (state_32540[(2)]);
var state_32540__$1 = state_32540;
var statearr_32617_34758 = state_32540__$1;
(statearr_32617_34758[(2)] = inst_32500);

(statearr_32617_34758[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32541 === (8))){
var inst_32465 = (state_32540[(16)]);
var inst_32464 = (state_32540[(15)]);
var inst_32467 = (inst_32465 < inst_32464);
var inst_32468 = inst_32467;
var state_32540__$1 = state_32540;
if(cljs.core.truth_(inst_32468)){
var statearr_32642_34759 = state_32540__$1;
(statearr_32642_34759[(1)] = (10));

} else {
var statearr_32644_34760 = state_32540__$1;
(statearr_32644_34760[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_32645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32645[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_32645[(1)] = (1));

return statearr_32645;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_32540){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_32540);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e32646){var ex__30030__auto__ = e32646;
var statearr_32648_34765 = state_32540;
(statearr_32648_34765[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_32540[(4)]))){
var statearr_32649_34766 = state_32540;
(statearr_32649_34766[(1)] = cljs.core.first((state_32540[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34770 = state_32540;
state_32540 = G__34770;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_32540){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_32540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_32650 = f__30324__auto__();
(statearr_32650[(6)] = c__30323__auto___34713);

return statearr_32650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32652 = arguments.length;
switch (G__32652) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32659 = arguments.length;
switch (G__32659) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32670 = arguments.length;
switch (G__32670) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__30323__auto___34791 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_32725){
var state_val_32726 = (state_32725[(1)]);
if((state_val_32726 === (7))){
var state_32725__$1 = state_32725;
var statearr_32737_34795 = state_32725__$1;
(statearr_32737_34795[(2)] = null);

(statearr_32737_34795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (1))){
var state_32725__$1 = state_32725;
var statearr_32742_34796 = state_32725__$1;
(statearr_32742_34796[(2)] = null);

(statearr_32742_34796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (4))){
var inst_32680 = (state_32725[(7)]);
var inst_32679 = (state_32725[(8)]);
var inst_32682 = (inst_32680 < inst_32679);
var state_32725__$1 = state_32725;
if(cljs.core.truth_(inst_32682)){
var statearr_32743_34797 = state_32725__$1;
(statearr_32743_34797[(1)] = (6));

} else {
var statearr_32744_34798 = state_32725__$1;
(statearr_32744_34798[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (15))){
var inst_32708 = (state_32725[(9)]);
var inst_32713 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32708);
var state_32725__$1 = state_32725;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32725__$1,(17),out,inst_32713);
} else {
if((state_val_32726 === (13))){
var inst_32708 = (state_32725[(9)]);
var inst_32708__$1 = (state_32725[(2)]);
var inst_32709 = cljs.core.some(cljs.core.nil_QMARK_,inst_32708__$1);
var state_32725__$1 = (function (){var statearr_32747 = state_32725;
(statearr_32747[(9)] = inst_32708__$1);

return statearr_32747;
})();
if(cljs.core.truth_(inst_32709)){
var statearr_32748_34799 = state_32725__$1;
(statearr_32748_34799[(1)] = (14));

} else {
var statearr_32749_34800 = state_32725__$1;
(statearr_32749_34800[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (6))){
var state_32725__$1 = state_32725;
var statearr_32750_34801 = state_32725__$1;
(statearr_32750_34801[(2)] = null);

(statearr_32750_34801[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (17))){
var inst_32715 = (state_32725[(2)]);
var state_32725__$1 = (function (){var statearr_32760 = state_32725;
(statearr_32760[(10)] = inst_32715);

return statearr_32760;
})();
var statearr_32762_34802 = state_32725__$1;
(statearr_32762_34802[(2)] = null);

(statearr_32762_34802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (3))){
var inst_32720 = (state_32725[(2)]);
var state_32725__$1 = state_32725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32725__$1,inst_32720);
} else {
if((state_val_32726 === (12))){
var _ = (function (){var statearr_32782 = state_32725;
(statearr_32782[(4)] = cljs.core.rest((state_32725[(4)])));

return statearr_32782;
})();
var state_32725__$1 = state_32725;
var ex32756 = (state_32725__$1[(2)]);
var statearr_32783_34808 = state_32725__$1;
(statearr_32783_34808[(5)] = ex32756);


if((ex32756 instanceof Object)){
var statearr_32793_34809 = state_32725__$1;
(statearr_32793_34809[(1)] = (11));

(statearr_32793_34809[(5)] = null);

} else {
throw ex32756;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (2))){
var inst_32678 = cljs.core.reset_BANG_(dctr,cnt);
var inst_32679 = cnt;
var inst_32680 = (0);
var state_32725__$1 = (function (){var statearr_32798 = state_32725;
(statearr_32798[(11)] = inst_32678);

(statearr_32798[(8)] = inst_32679);

(statearr_32798[(7)] = inst_32680);

return statearr_32798;
})();
var statearr_32799_34811 = state_32725__$1;
(statearr_32799_34811[(2)] = null);

(statearr_32799_34811[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (11))){
var inst_32687 = (state_32725[(2)]);
var inst_32688 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32725__$1 = (function (){var statearr_32803 = state_32725;
(statearr_32803[(12)] = inst_32687);

return statearr_32803;
})();
var statearr_32804_34812 = state_32725__$1;
(statearr_32804_34812[(2)] = inst_32688);

(statearr_32804_34812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (9))){
var inst_32680 = (state_32725[(7)]);
var _ = (function (){var statearr_32805 = state_32725;
(statearr_32805[(4)] = cljs.core.cons((12),(state_32725[(4)])));

return statearr_32805;
})();
var inst_32694 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32680) : chs__$1.call(null,inst_32680));
var inst_32695 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32680) : done.call(null,inst_32680));
var inst_32696 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32694,inst_32695);
var ___$1 = (function (){var statearr_32806 = state_32725;
(statearr_32806[(4)] = cljs.core.rest((state_32725[(4)])));

return statearr_32806;
})();
var state_32725__$1 = state_32725;
var statearr_32809_34813 = state_32725__$1;
(statearr_32809_34813[(2)] = inst_32696);

(statearr_32809_34813[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (5))){
var inst_32706 = (state_32725[(2)]);
var state_32725__$1 = (function (){var statearr_32810 = state_32725;
(statearr_32810[(13)] = inst_32706);

return statearr_32810;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32725__$1,(13),dchan);
} else {
if((state_val_32726 === (14))){
var inst_32711 = cljs.core.async.close_BANG_(out);
var state_32725__$1 = state_32725;
var statearr_32825_34814 = state_32725__$1;
(statearr_32825_34814[(2)] = inst_32711);

(statearr_32825_34814[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (16))){
var inst_32718 = (state_32725[(2)]);
var state_32725__$1 = state_32725;
var statearr_32826_34815 = state_32725__$1;
(statearr_32826_34815[(2)] = inst_32718);

(statearr_32826_34815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (10))){
var inst_32680 = (state_32725[(7)]);
var inst_32699 = (state_32725[(2)]);
var inst_32700 = (inst_32680 + (1));
var inst_32680__$1 = inst_32700;
var state_32725__$1 = (function (){var statearr_32833 = state_32725;
(statearr_32833[(14)] = inst_32699);

(statearr_32833[(7)] = inst_32680__$1);

return statearr_32833;
})();
var statearr_32834_34820 = state_32725__$1;
(statearr_32834_34820[(2)] = null);

(statearr_32834_34820[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32726 === (8))){
var inst_32704 = (state_32725[(2)]);
var state_32725__$1 = state_32725;
var statearr_32836_34821 = state_32725__$1;
(statearr_32836_34821[(2)] = inst_32704);

(statearr_32836_34821[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_32841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32841[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_32841[(1)] = (1));

return statearr_32841;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_32725){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_32725);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e32845){var ex__30030__auto__ = e32845;
var statearr_32846_34822 = state_32725;
(statearr_32846_34822[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_32725[(4)]))){
var statearr_32850_34823 = state_32725;
(statearr_32850_34823[(1)] = cljs.core.first((state_32725[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34824 = state_32725;
state_32725 = G__34824;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_32725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_32725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_32851 = f__30324__auto__();
(statearr_32851[(6)] = c__30323__auto___34791);

return statearr_32851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32858 = arguments.length;
switch (G__32858) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30323__auto___34829 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_32898){
var state_val_32899 = (state_32898[(1)]);
if((state_val_32899 === (7))){
var inst_32876 = (state_32898[(7)]);
var inst_32877 = (state_32898[(8)]);
var inst_32876__$1 = (state_32898[(2)]);
var inst_32877__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32876__$1,(0),null);
var inst_32878 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32876__$1,(1),null);
var inst_32879 = (inst_32877__$1 == null);
var state_32898__$1 = (function (){var statearr_32909 = state_32898;
(statearr_32909[(7)] = inst_32876__$1);

(statearr_32909[(8)] = inst_32877__$1);

(statearr_32909[(9)] = inst_32878);

return statearr_32909;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_32910_34834 = state_32898__$1;
(statearr_32910_34834[(1)] = (8));

} else {
var statearr_32911_34835 = state_32898__$1;
(statearr_32911_34835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (1))){
var inst_32862 = cljs.core.vec(chs);
var inst_32863 = inst_32862;
var state_32898__$1 = (function (){var statearr_32912 = state_32898;
(statearr_32912[(10)] = inst_32863);

return statearr_32912;
})();
var statearr_32913_34836 = state_32898__$1;
(statearr_32913_34836[(2)] = null);

(statearr_32913_34836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (4))){
var inst_32863 = (state_32898[(10)]);
var state_32898__$1 = state_32898;
return cljs.core.async.ioc_alts_BANG_(state_32898__$1,(7),inst_32863);
} else {
if((state_val_32899 === (6))){
var inst_32894 = (state_32898[(2)]);
var state_32898__$1 = state_32898;
var statearr_32915_34837 = state_32898__$1;
(statearr_32915_34837[(2)] = inst_32894);

(statearr_32915_34837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (3))){
var inst_32896 = (state_32898[(2)]);
var state_32898__$1 = state_32898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32898__$1,inst_32896);
} else {
if((state_val_32899 === (2))){
var inst_32863 = (state_32898[(10)]);
var inst_32866 = cljs.core.count(inst_32863);
var inst_32867 = (inst_32866 > (0));
var state_32898__$1 = state_32898;
if(cljs.core.truth_(inst_32867)){
var statearr_32917_34840 = state_32898__$1;
(statearr_32917_34840[(1)] = (4));

} else {
var statearr_32918_34841 = state_32898__$1;
(statearr_32918_34841[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (11))){
var inst_32863 = (state_32898[(10)]);
var inst_32887 = (state_32898[(2)]);
var tmp32916 = inst_32863;
var inst_32863__$1 = tmp32916;
var state_32898__$1 = (function (){var statearr_32920 = state_32898;
(statearr_32920[(11)] = inst_32887);

(statearr_32920[(10)] = inst_32863__$1);

return statearr_32920;
})();
var statearr_32924_34845 = state_32898__$1;
(statearr_32924_34845[(2)] = null);

(statearr_32924_34845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (9))){
var inst_32877 = (state_32898[(8)]);
var state_32898__$1 = state_32898;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32898__$1,(11),out,inst_32877);
} else {
if((state_val_32899 === (5))){
var inst_32892 = cljs.core.async.close_BANG_(out);
var state_32898__$1 = state_32898;
var statearr_32927_34846 = state_32898__$1;
(statearr_32927_34846[(2)] = inst_32892);

(statearr_32927_34846[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (10))){
var inst_32890 = (state_32898[(2)]);
var state_32898__$1 = state_32898;
var statearr_32931_34851 = state_32898__$1;
(statearr_32931_34851[(2)] = inst_32890);

(statearr_32931_34851[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32899 === (8))){
var inst_32863 = (state_32898[(10)]);
var inst_32876 = (state_32898[(7)]);
var inst_32877 = (state_32898[(8)]);
var inst_32878 = (state_32898[(9)]);
var inst_32882 = (function (){var cs = inst_32863;
var vec__32870 = inst_32876;
var v = inst_32877;
var c = inst_32878;
return (function (p1__32855_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32855_SHARP_);
});
})();
var inst_32883 = cljs.core.filterv(inst_32882,inst_32863);
var inst_32863__$1 = inst_32883;
var state_32898__$1 = (function (){var statearr_32934 = state_32898;
(statearr_32934[(10)] = inst_32863__$1);

return statearr_32934;
})();
var statearr_32935_34853 = state_32898__$1;
(statearr_32935_34853[(2)] = null);

(statearr_32935_34853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_32937 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32937[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_32937[(1)] = (1));

return statearr_32937;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_32898){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_32898);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e32938){var ex__30030__auto__ = e32938;
var statearr_32939_34854 = state_32898;
(statearr_32939_34854[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_32898[(4)]))){
var statearr_32941_34855 = state_32898;
(statearr_32941_34855[(1)] = cljs.core.first((state_32898[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34856 = state_32898;
state_32898 = G__34856;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_32898){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_32898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_32942 = f__30324__auto__();
(statearr_32942[(6)] = c__30323__auto___34829);

return statearr_32942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32944 = arguments.length;
switch (G__32944) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30323__auto___34863 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_32982){
var state_val_32983 = (state_32982[(1)]);
if((state_val_32983 === (7))){
var inst_32964 = (state_32982[(7)]);
var inst_32964__$1 = (state_32982[(2)]);
var inst_32965 = (inst_32964__$1 == null);
var inst_32966 = cljs.core.not(inst_32965);
var state_32982__$1 = (function (){var statearr_32988 = state_32982;
(statearr_32988[(7)] = inst_32964__$1);

return statearr_32988;
})();
if(inst_32966){
var statearr_32992_34874 = state_32982__$1;
(statearr_32992_34874[(1)] = (8));

} else {
var statearr_32994_34875 = state_32982__$1;
(statearr_32994_34875[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (1))){
var inst_32954 = (0);
var state_32982__$1 = (function (){var statearr_32998 = state_32982;
(statearr_32998[(8)] = inst_32954);

return statearr_32998;
})();
var statearr_32999_34876 = state_32982__$1;
(statearr_32999_34876[(2)] = null);

(statearr_32999_34876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (4))){
var state_32982__$1 = state_32982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32982__$1,(7),ch);
} else {
if((state_val_32983 === (6))){
var inst_32977 = (state_32982[(2)]);
var state_32982__$1 = state_32982;
var statearr_33000_34883 = state_32982__$1;
(statearr_33000_34883[(2)] = inst_32977);

(statearr_33000_34883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (3))){
var inst_32979 = (state_32982[(2)]);
var inst_32980 = cljs.core.async.close_BANG_(out);
var state_32982__$1 = (function (){var statearr_33001 = state_32982;
(statearr_33001[(9)] = inst_32979);

return statearr_33001;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32982__$1,inst_32980);
} else {
if((state_val_32983 === (2))){
var inst_32954 = (state_32982[(8)]);
var inst_32957 = (inst_32954 < n);
var state_32982__$1 = state_32982;
if(cljs.core.truth_(inst_32957)){
var statearr_33002_34888 = state_32982__$1;
(statearr_33002_34888[(1)] = (4));

} else {
var statearr_33003_34889 = state_32982__$1;
(statearr_33003_34889[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (11))){
var inst_32954 = (state_32982[(8)]);
var inst_32969 = (state_32982[(2)]);
var inst_32970 = (inst_32954 + (1));
var inst_32954__$1 = inst_32970;
var state_32982__$1 = (function (){var statearr_33004 = state_32982;
(statearr_33004[(10)] = inst_32969);

(statearr_33004[(8)] = inst_32954__$1);

return statearr_33004;
})();
var statearr_33007_34890 = state_32982__$1;
(statearr_33007_34890[(2)] = null);

(statearr_33007_34890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (9))){
var state_32982__$1 = state_32982;
var statearr_33009_34891 = state_32982__$1;
(statearr_33009_34891[(2)] = null);

(statearr_33009_34891[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (5))){
var state_32982__$1 = state_32982;
var statearr_33010_34896 = state_32982__$1;
(statearr_33010_34896[(2)] = null);

(statearr_33010_34896[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (10))){
var inst_32974 = (state_32982[(2)]);
var state_32982__$1 = state_32982;
var statearr_33012_34897 = state_32982__$1;
(statearr_33012_34897[(2)] = inst_32974);

(statearr_33012_34897[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32983 === (8))){
var inst_32964 = (state_32982[(7)]);
var state_32982__$1 = state_32982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32982__$1,(11),out,inst_32964);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_33019 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33019[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_33019[(1)] = (1));

return statearr_33019;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_32982){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_32982);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e33022){var ex__30030__auto__ = e33022;
var statearr_33023_34898 = state_32982;
(statearr_33023_34898[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_32982[(4)]))){
var statearr_33024_34911 = state_32982;
(statearr_33024_34911[(1)] = cljs.core.first((state_32982[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34912 = state_32982;
state_32982 = G__34912;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_32982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_32982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_33035 = f__30324__auto__();
(statearr_33035[(6)] = c__30323__auto___34863);

return statearr_33035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33065 = (function (f,ch,meta33050,_,fn1,meta33066){
this.f = f;
this.ch = ch;
this.meta33050 = meta33050;
this._ = _;
this.fn1 = fn1;
this.meta33066 = meta33066;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33065.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33067,meta33066__$1){
var self__ = this;
var _33067__$1 = this;
return (new cljs.core.async.t_cljs$core$async33065(self__.f,self__.ch,self__.meta33050,self__._,self__.fn1,meta33066__$1));
}));

(cljs.core.async.t_cljs$core$async33065.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33067){
var self__ = this;
var _33067__$1 = this;
return self__.meta33066;
}));

(cljs.core.async.t_cljs$core$async33065.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33065.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async33065.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async33065.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__33041_SHARP_){
var G__33081 = (((p1__33041_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33041_SHARP_) : self__.f.call(null,p1__33041_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33081) : f1.call(null,G__33081));
});
}));

(cljs.core.async.t_cljs$core$async33065.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33050","meta33050",-1933374841,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33049","cljs.core.async/t_cljs$core$async33049",-1423580584,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33066","meta33066",-1097936177,null)], null);
}));

(cljs.core.async.t_cljs$core$async33065.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33065.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33065");

(cljs.core.async.t_cljs$core$async33065.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33065");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33065.
 */
cljs.core.async.__GT_t_cljs$core$async33065 = (function cljs$core$async$__GT_t_cljs$core$async33065(f,ch,meta33050,_,fn1,meta33066){
return (new cljs.core.async.t_cljs$core$async33065(f,ch,meta33050,_,fn1,meta33066));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33049 = (function (f,ch,meta33050){
this.f = f;
this.ch = ch;
this.meta33050 = meta33050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33051,meta33050__$1){
var self__ = this;
var _33051__$1 = this;
return (new cljs.core.async.t_cljs$core$async33049(self__.f,self__.ch,meta33050__$1));
}));

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33051){
var self__ = this;
var _33051__$1 = this;
return self__.meta33050;
}));

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async33065(self__.f,self__.ch,self__.meta33050,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33087 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33087) : self__.f.call(null,G__33087));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33049.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async33049.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33050","meta33050",-1933374841,null)], null);
}));

(cljs.core.async.t_cljs$core$async33049.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33049.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33049");

(cljs.core.async.t_cljs$core$async33049.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33049");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33049.
 */
cljs.core.async.__GT_t_cljs$core$async33049 = (function cljs$core$async$__GT_t_cljs$core$async33049(f,ch,meta33050){
return (new cljs.core.async.t_cljs$core$async33049(f,ch,meta33050));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async33049(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33089 = (function (f,ch,meta33090){
this.f = f;
this.ch = ch;
this.meta33090 = meta33090;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33091,meta33090__$1){
var self__ = this;
var _33091__$1 = this;
return (new cljs.core.async.t_cljs$core$async33089(self__.f,self__.ch,meta33090__$1));
}));

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33091){
var self__ = this;
var _33091__$1 = this;
return self__.meta33090;
}));

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async33089.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33090","meta33090",-1508258114,null)], null);
}));

(cljs.core.async.t_cljs$core$async33089.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33089.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33089");

(cljs.core.async.t_cljs$core$async33089.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33089");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33089.
 */
cljs.core.async.__GT_t_cljs$core$async33089 = (function cljs$core$async$__GT_t_cljs$core$async33089(f,ch,meta33090){
return (new cljs.core.async.t_cljs$core$async33089(f,ch,meta33090));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async33089(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33106 = (function (p,ch,meta33107){
this.p = p;
this.ch = ch;
this.meta33107 = meta33107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33108,meta33107__$1){
var self__ = this;
var _33108__$1 = this;
return (new cljs.core.async.t_cljs$core$async33106(self__.p,self__.ch,meta33107__$1));
}));

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33108){
var self__ = this;
var _33108__$1 = this;
return self__.meta33107;
}));

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async33106.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async33106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33107","meta33107",1699551481,null)], null);
}));

(cljs.core.async.t_cljs$core$async33106.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async33106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33106");

(cljs.core.async.t_cljs$core$async33106.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async33106");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33106.
 */
cljs.core.async.__GT_t_cljs$core$async33106 = (function cljs$core$async$__GT_t_cljs$core$async33106(p,ch,meta33107){
return (new cljs.core.async.t_cljs$core$async33106(p,ch,meta33107));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async33106(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33118 = arguments.length;
switch (G__33118) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30323__auto___34923 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_33142){
var state_val_33143 = (state_33142[(1)]);
if((state_val_33143 === (7))){
var inst_33138 = (state_33142[(2)]);
var state_33142__$1 = state_33142;
var statearr_33146_34924 = state_33142__$1;
(statearr_33146_34924[(2)] = inst_33138);

(statearr_33146_34924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (1))){
var state_33142__$1 = state_33142;
var statearr_33147_34925 = state_33142__$1;
(statearr_33147_34925[(2)] = null);

(statearr_33147_34925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (4))){
var inst_33124 = (state_33142[(7)]);
var inst_33124__$1 = (state_33142[(2)]);
var inst_33125 = (inst_33124__$1 == null);
var state_33142__$1 = (function (){var statearr_33148 = state_33142;
(statearr_33148[(7)] = inst_33124__$1);

return statearr_33148;
})();
if(cljs.core.truth_(inst_33125)){
var statearr_33149_34926 = state_33142__$1;
(statearr_33149_34926[(1)] = (5));

} else {
var statearr_33150_34927 = state_33142__$1;
(statearr_33150_34927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (6))){
var inst_33124 = (state_33142[(7)]);
var inst_33129 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33124) : p.call(null,inst_33124));
var state_33142__$1 = state_33142;
if(cljs.core.truth_(inst_33129)){
var statearr_33151_34928 = state_33142__$1;
(statearr_33151_34928[(1)] = (8));

} else {
var statearr_33152_34929 = state_33142__$1;
(statearr_33152_34929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (3))){
var inst_33140 = (state_33142[(2)]);
var state_33142__$1 = state_33142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33142__$1,inst_33140);
} else {
if((state_val_33143 === (2))){
var state_33142__$1 = state_33142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33142__$1,(4),ch);
} else {
if((state_val_33143 === (11))){
var inst_33132 = (state_33142[(2)]);
var state_33142__$1 = state_33142;
var statearr_33153_34934 = state_33142__$1;
(statearr_33153_34934[(2)] = inst_33132);

(statearr_33153_34934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (9))){
var state_33142__$1 = state_33142;
var statearr_33158_34935 = state_33142__$1;
(statearr_33158_34935[(2)] = null);

(statearr_33158_34935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (5))){
var inst_33127 = cljs.core.async.close_BANG_(out);
var state_33142__$1 = state_33142;
var statearr_33163_34937 = state_33142__$1;
(statearr_33163_34937[(2)] = inst_33127);

(statearr_33163_34937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (10))){
var inst_33135 = (state_33142[(2)]);
var state_33142__$1 = (function (){var statearr_33168 = state_33142;
(statearr_33168[(8)] = inst_33135);

return statearr_33168;
})();
var statearr_33169_34942 = state_33142__$1;
(statearr_33169_34942[(2)] = null);

(statearr_33169_34942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33143 === (8))){
var inst_33124 = (state_33142[(7)]);
var state_33142__$1 = state_33142;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33142__$1,(11),out,inst_33124);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_33170 = [null,null,null,null,null,null,null,null,null];
(statearr_33170[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_33170[(1)] = (1));

return statearr_33170;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_33142){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_33142);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e33171){var ex__30030__auto__ = e33171;
var statearr_33172_34949 = state_33142;
(statearr_33172_34949[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_33142[(4)]))){
var statearr_33173_34952 = state_33142;
(statearr_33173_34952[(1)] = cljs.core.first((state_33142[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34953 = state_33142;
state_33142 = G__34953;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_33142){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_33142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_33174 = f__30324__auto__();
(statearr_33174[(6)] = c__30323__auto___34923);

return statearr_33174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33177 = arguments.length;
switch (G__33177) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30323__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_33254){
var state_val_33255 = (state_33254[(1)]);
if((state_val_33255 === (7))){
var inst_33250 = (state_33254[(2)]);
var state_33254__$1 = state_33254;
var statearr_33268_34961 = state_33254__$1;
(statearr_33268_34961[(2)] = inst_33250);

(statearr_33268_34961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (20))){
var inst_33219 = (state_33254[(7)]);
var inst_33231 = (state_33254[(2)]);
var inst_33232 = cljs.core.next(inst_33219);
var inst_33201 = inst_33232;
var inst_33202 = null;
var inst_33203 = (0);
var inst_33204 = (0);
var state_33254__$1 = (function (){var statearr_33272 = state_33254;
(statearr_33272[(8)] = inst_33231);

(statearr_33272[(9)] = inst_33201);

(statearr_33272[(10)] = inst_33202);

(statearr_33272[(11)] = inst_33203);

(statearr_33272[(12)] = inst_33204);

return statearr_33272;
})();
var statearr_33273_34963 = state_33254__$1;
(statearr_33273_34963[(2)] = null);

(statearr_33273_34963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (1))){
var state_33254__$1 = state_33254;
var statearr_33274_34964 = state_33254__$1;
(statearr_33274_34964[(2)] = null);

(statearr_33274_34964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (4))){
var inst_33190 = (state_33254[(13)]);
var inst_33190__$1 = (state_33254[(2)]);
var inst_33191 = (inst_33190__$1 == null);
var state_33254__$1 = (function (){var statearr_33275 = state_33254;
(statearr_33275[(13)] = inst_33190__$1);

return statearr_33275;
})();
if(cljs.core.truth_(inst_33191)){
var statearr_33277_34968 = state_33254__$1;
(statearr_33277_34968[(1)] = (5));

} else {
var statearr_33278_34969 = state_33254__$1;
(statearr_33278_34969[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (15))){
var state_33254__$1 = state_33254;
var statearr_33282_34970 = state_33254__$1;
(statearr_33282_34970[(2)] = null);

(statearr_33282_34970[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (21))){
var state_33254__$1 = state_33254;
var statearr_33283_34976 = state_33254__$1;
(statearr_33283_34976[(2)] = null);

(statearr_33283_34976[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (13))){
var inst_33204 = (state_33254[(12)]);
var inst_33201 = (state_33254[(9)]);
var inst_33202 = (state_33254[(10)]);
var inst_33203 = (state_33254[(11)]);
var inst_33215 = (state_33254[(2)]);
var inst_33216 = (inst_33204 + (1));
var tmp33279 = inst_33201;
var tmp33280 = inst_33203;
var tmp33281 = inst_33202;
var inst_33201__$1 = tmp33279;
var inst_33202__$1 = tmp33281;
var inst_33203__$1 = tmp33280;
var inst_33204__$1 = inst_33216;
var state_33254__$1 = (function (){var statearr_33288 = state_33254;
(statearr_33288[(14)] = inst_33215);

(statearr_33288[(9)] = inst_33201__$1);

(statearr_33288[(10)] = inst_33202__$1);

(statearr_33288[(11)] = inst_33203__$1);

(statearr_33288[(12)] = inst_33204__$1);

return statearr_33288;
})();
var statearr_33291_34978 = state_33254__$1;
(statearr_33291_34978[(2)] = null);

(statearr_33291_34978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (22))){
var state_33254__$1 = state_33254;
var statearr_33294_34979 = state_33254__$1;
(statearr_33294_34979[(2)] = null);

(statearr_33294_34979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (6))){
var inst_33190 = (state_33254[(13)]);
var inst_33199 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33190) : f.call(null,inst_33190));
var inst_33200 = cljs.core.seq(inst_33199);
var inst_33201 = inst_33200;
var inst_33202 = null;
var inst_33203 = (0);
var inst_33204 = (0);
var state_33254__$1 = (function (){var statearr_33299 = state_33254;
(statearr_33299[(9)] = inst_33201);

(statearr_33299[(10)] = inst_33202);

(statearr_33299[(11)] = inst_33203);

(statearr_33299[(12)] = inst_33204);

return statearr_33299;
})();
var statearr_33302_34982 = state_33254__$1;
(statearr_33302_34982[(2)] = null);

(statearr_33302_34982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (17))){
var inst_33219 = (state_33254[(7)]);
var inst_33224 = cljs.core.chunk_first(inst_33219);
var inst_33225 = cljs.core.chunk_rest(inst_33219);
var inst_33226 = cljs.core.count(inst_33224);
var inst_33201 = inst_33225;
var inst_33202 = inst_33224;
var inst_33203 = inst_33226;
var inst_33204 = (0);
var state_33254__$1 = (function (){var statearr_33307 = state_33254;
(statearr_33307[(9)] = inst_33201);

(statearr_33307[(10)] = inst_33202);

(statearr_33307[(11)] = inst_33203);

(statearr_33307[(12)] = inst_33204);

return statearr_33307;
})();
var statearr_33308_34984 = state_33254__$1;
(statearr_33308_34984[(2)] = null);

(statearr_33308_34984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (3))){
var inst_33252 = (state_33254[(2)]);
var state_33254__$1 = state_33254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33254__$1,inst_33252);
} else {
if((state_val_33255 === (12))){
var inst_33240 = (state_33254[(2)]);
var state_33254__$1 = state_33254;
var statearr_33310_34988 = state_33254__$1;
(statearr_33310_34988[(2)] = inst_33240);

(statearr_33310_34988[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (2))){
var state_33254__$1 = state_33254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33254__$1,(4),in$);
} else {
if((state_val_33255 === (23))){
var inst_33248 = (state_33254[(2)]);
var state_33254__$1 = state_33254;
var statearr_33311_34993 = state_33254__$1;
(statearr_33311_34993[(2)] = inst_33248);

(statearr_33311_34993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (19))){
var inst_33235 = (state_33254[(2)]);
var state_33254__$1 = state_33254;
var statearr_33315_34994 = state_33254__$1;
(statearr_33315_34994[(2)] = inst_33235);

(statearr_33315_34994[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (11))){
var inst_33201 = (state_33254[(9)]);
var inst_33219 = (state_33254[(7)]);
var inst_33219__$1 = cljs.core.seq(inst_33201);
var state_33254__$1 = (function (){var statearr_33316 = state_33254;
(statearr_33316[(7)] = inst_33219__$1);

return statearr_33316;
})();
if(inst_33219__$1){
var statearr_33317_34997 = state_33254__$1;
(statearr_33317_34997[(1)] = (14));

} else {
var statearr_33319_34998 = state_33254__$1;
(statearr_33319_34998[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (9))){
var inst_33242 = (state_33254[(2)]);
var inst_33243 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33254__$1 = (function (){var statearr_33321 = state_33254;
(statearr_33321[(15)] = inst_33242);

return statearr_33321;
})();
if(cljs.core.truth_(inst_33243)){
var statearr_33322_35001 = state_33254__$1;
(statearr_33322_35001[(1)] = (21));

} else {
var statearr_33323_35002 = state_33254__$1;
(statearr_33323_35002[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (5))){
var inst_33193 = cljs.core.async.close_BANG_(out);
var state_33254__$1 = state_33254;
var statearr_33324_35003 = state_33254__$1;
(statearr_33324_35003[(2)] = inst_33193);

(statearr_33324_35003[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (14))){
var inst_33219 = (state_33254[(7)]);
var inst_33222 = cljs.core.chunked_seq_QMARK_(inst_33219);
var state_33254__$1 = state_33254;
if(inst_33222){
var statearr_33334_35004 = state_33254__$1;
(statearr_33334_35004[(1)] = (17));

} else {
var statearr_33338_35005 = state_33254__$1;
(statearr_33338_35005[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (16))){
var inst_33238 = (state_33254[(2)]);
var state_33254__$1 = state_33254;
var statearr_33345_35007 = state_33254__$1;
(statearr_33345_35007[(2)] = inst_33238);

(statearr_33345_35007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33255 === (10))){
var inst_33202 = (state_33254[(10)]);
var inst_33204 = (state_33254[(12)]);
var inst_33210 = cljs.core._nth(inst_33202,inst_33204);
var state_33254__$1 = state_33254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33254__$1,(13),out,inst_33210);
} else {
if((state_val_33255 === (18))){
var inst_33219 = (state_33254[(7)]);
var inst_33229 = cljs.core.first(inst_33219);
var state_33254__$1 = state_33254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33254__$1,(20),out,inst_33229);
} else {
if((state_val_33255 === (8))){
var inst_33204 = (state_33254[(12)]);
var inst_33203 = (state_33254[(11)]);
var inst_33207 = (inst_33204 < inst_33203);
var inst_33208 = inst_33207;
var state_33254__$1 = state_33254;
if(cljs.core.truth_(inst_33208)){
var statearr_33359_35010 = state_33254__$1;
(statearr_33359_35010[(1)] = (10));

} else {
var statearr_33360_35011 = state_33254__$1;
(statearr_33360_35011[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30027__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30027__auto____0 = (function (){
var statearr_33362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33362[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30027__auto__);

(statearr_33362[(1)] = (1));

return statearr_33362;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30027__auto____1 = (function (state_33254){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_33254);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e33365){var ex__30030__auto__ = e33365;
var statearr_33374_35020 = state_33254;
(statearr_33374_35020[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_33254[(4)]))){
var statearr_33376_35021 = state_33254;
(statearr_33376_35021[(1)] = cljs.core.first((state_33254[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35022 = state_33254;
state_33254 = G__35022;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30027__auto__ = function(state_33254){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30027__auto____1.call(this,state_33254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30027__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30027__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_33386 = f__30324__auto__();
(statearr_33386[(6)] = c__30323__auto__);

return statearr_33386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

return c__30323__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33394 = arguments.length;
switch (G__33394) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33401 = arguments.length;
switch (G__33401) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33411 = arguments.length;
switch (G__33411) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30323__auto___35028 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_33447){
var state_val_33448 = (state_33447[(1)]);
if((state_val_33448 === (7))){
var inst_33440 = (state_33447[(2)]);
var state_33447__$1 = state_33447;
var statearr_33449_35033 = state_33447__$1;
(statearr_33449_35033[(2)] = inst_33440);

(statearr_33449_35033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (1))){
var inst_33413 = null;
var state_33447__$1 = (function (){var statearr_33453 = state_33447;
(statearr_33453[(7)] = inst_33413);

return statearr_33453;
})();
var statearr_33454_35035 = state_33447__$1;
(statearr_33454_35035[(2)] = null);

(statearr_33454_35035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (4))){
var inst_33419 = (state_33447[(8)]);
var inst_33419__$1 = (state_33447[(2)]);
var inst_33424 = (inst_33419__$1 == null);
var inst_33425 = cljs.core.not(inst_33424);
var state_33447__$1 = (function (){var statearr_33455 = state_33447;
(statearr_33455[(8)] = inst_33419__$1);

return statearr_33455;
})();
if(inst_33425){
var statearr_33456_35053 = state_33447__$1;
(statearr_33456_35053[(1)] = (5));

} else {
var statearr_33457_35054 = state_33447__$1;
(statearr_33457_35054[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (6))){
var state_33447__$1 = state_33447;
var statearr_33458_35055 = state_33447__$1;
(statearr_33458_35055[(2)] = null);

(statearr_33458_35055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (3))){
var inst_33442 = (state_33447[(2)]);
var inst_33443 = cljs.core.async.close_BANG_(out);
var state_33447__$1 = (function (){var statearr_33460 = state_33447;
(statearr_33460[(9)] = inst_33442);

return statearr_33460;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33447__$1,inst_33443);
} else {
if((state_val_33448 === (2))){
var state_33447__$1 = state_33447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33447__$1,(4),ch);
} else {
if((state_val_33448 === (11))){
var inst_33419 = (state_33447[(8)]);
var inst_33434 = (state_33447[(2)]);
var inst_33413 = inst_33419;
var state_33447__$1 = (function (){var statearr_33468 = state_33447;
(statearr_33468[(10)] = inst_33434);

(statearr_33468[(7)] = inst_33413);

return statearr_33468;
})();
var statearr_33469_35063 = state_33447__$1;
(statearr_33469_35063[(2)] = null);

(statearr_33469_35063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (9))){
var inst_33419 = (state_33447[(8)]);
var state_33447__$1 = state_33447;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33447__$1,(11),out,inst_33419);
} else {
if((state_val_33448 === (5))){
var inst_33419 = (state_33447[(8)]);
var inst_33413 = (state_33447[(7)]);
var inst_33427 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33419,inst_33413);
var state_33447__$1 = state_33447;
if(inst_33427){
var statearr_33471_35068 = state_33447__$1;
(statearr_33471_35068[(1)] = (8));

} else {
var statearr_33472_35069 = state_33447__$1;
(statearr_33472_35069[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (10))){
var inst_33437 = (state_33447[(2)]);
var state_33447__$1 = state_33447;
var statearr_33473_35084 = state_33447__$1;
(statearr_33473_35084[(2)] = inst_33437);

(statearr_33473_35084[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33448 === (8))){
var inst_33413 = (state_33447[(7)]);
var tmp33470 = inst_33413;
var inst_33413__$1 = tmp33470;
var state_33447__$1 = (function (){var statearr_33474 = state_33447;
(statearr_33474[(7)] = inst_33413__$1);

return statearr_33474;
})();
var statearr_33475_35094 = state_33447__$1;
(statearr_33475_35094[(2)] = null);

(statearr_33475_35094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_33476 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33476[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_33476[(1)] = (1));

return statearr_33476;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_33447){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_33447);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e33477){var ex__30030__auto__ = e33477;
var statearr_33478_35114 = state_33447;
(statearr_33478_35114[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_33447[(4)]))){
var statearr_33481_35124 = state_33447;
(statearr_33481_35124[(1)] = cljs.core.first((state_33447[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35129 = state_33447;
state_33447 = G__35129;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_33447){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_33447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_33482 = f__30324__auto__();
(statearr_33482[(6)] = c__30323__auto___35028);

return statearr_33482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33487 = arguments.length;
switch (G__33487) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30323__auto___35146 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_33540){
var state_val_33541 = (state_33540[(1)]);
if((state_val_33541 === (7))){
var inst_33536 = (state_33540[(2)]);
var state_33540__$1 = state_33540;
var statearr_33544_35156 = state_33540__$1;
(statearr_33544_35156[(2)] = inst_33536);

(statearr_33544_35156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (1))){
var inst_33493 = (new Array(n));
var inst_33495 = inst_33493;
var inst_33496 = (0);
var state_33540__$1 = (function (){var statearr_33548 = state_33540;
(statearr_33548[(7)] = inst_33495);

(statearr_33548[(8)] = inst_33496);

return statearr_33548;
})();
var statearr_33549_35167 = state_33540__$1;
(statearr_33549_35167[(2)] = null);

(statearr_33549_35167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (4))){
var inst_33500 = (state_33540[(9)]);
var inst_33500__$1 = (state_33540[(2)]);
var inst_33503 = (inst_33500__$1 == null);
var inst_33504 = cljs.core.not(inst_33503);
var state_33540__$1 = (function (){var statearr_33550 = state_33540;
(statearr_33550[(9)] = inst_33500__$1);

return statearr_33550;
})();
if(inst_33504){
var statearr_33552_35173 = state_33540__$1;
(statearr_33552_35173[(1)] = (5));

} else {
var statearr_33553_35178 = state_33540__$1;
(statearr_33553_35178[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (15))){
var inst_33530 = (state_33540[(2)]);
var state_33540__$1 = state_33540;
var statearr_33554_35183 = state_33540__$1;
(statearr_33554_35183[(2)] = inst_33530);

(statearr_33554_35183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (13))){
var state_33540__$1 = state_33540;
var statearr_33555_35184 = state_33540__$1;
(statearr_33555_35184[(2)] = null);

(statearr_33555_35184[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (6))){
var inst_33496 = (state_33540[(8)]);
var inst_33526 = (inst_33496 > (0));
var state_33540__$1 = state_33540;
if(cljs.core.truth_(inst_33526)){
var statearr_33556_35193 = state_33540__$1;
(statearr_33556_35193[(1)] = (12));

} else {
var statearr_33558_35194 = state_33540__$1;
(statearr_33558_35194[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (3))){
var inst_33538 = (state_33540[(2)]);
var state_33540__$1 = state_33540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33540__$1,inst_33538);
} else {
if((state_val_33541 === (12))){
var inst_33495 = (state_33540[(7)]);
var inst_33528 = cljs.core.vec(inst_33495);
var state_33540__$1 = state_33540;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33540__$1,(15),out,inst_33528);
} else {
if((state_val_33541 === (2))){
var state_33540__$1 = state_33540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33540__$1,(4),ch);
} else {
if((state_val_33541 === (11))){
var inst_33517 = (state_33540[(2)]);
var inst_33518 = (new Array(n));
var inst_33495 = inst_33518;
var inst_33496 = (0);
var state_33540__$1 = (function (){var statearr_33560 = state_33540;
(statearr_33560[(10)] = inst_33517);

(statearr_33560[(7)] = inst_33495);

(statearr_33560[(8)] = inst_33496);

return statearr_33560;
})();
var statearr_33562_35205 = state_33540__$1;
(statearr_33562_35205[(2)] = null);

(statearr_33562_35205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (9))){
var inst_33495 = (state_33540[(7)]);
var inst_33515 = cljs.core.vec(inst_33495);
var state_33540__$1 = state_33540;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33540__$1,(11),out,inst_33515);
} else {
if((state_val_33541 === (5))){
var inst_33495 = (state_33540[(7)]);
var inst_33496 = (state_33540[(8)]);
var inst_33500 = (state_33540[(9)]);
var inst_33510 = (state_33540[(11)]);
var inst_33507 = (inst_33495[inst_33496] = inst_33500);
var inst_33510__$1 = (inst_33496 + (1));
var inst_33511 = (inst_33510__$1 < n);
var state_33540__$1 = (function (){var statearr_33567 = state_33540;
(statearr_33567[(12)] = inst_33507);

(statearr_33567[(11)] = inst_33510__$1);

return statearr_33567;
})();
if(cljs.core.truth_(inst_33511)){
var statearr_33568_35207 = state_33540__$1;
(statearr_33568_35207[(1)] = (8));

} else {
var statearr_33569_35208 = state_33540__$1;
(statearr_33569_35208[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (14))){
var inst_33533 = (state_33540[(2)]);
var inst_33534 = cljs.core.async.close_BANG_(out);
var state_33540__$1 = (function (){var statearr_33571 = state_33540;
(statearr_33571[(13)] = inst_33533);

return statearr_33571;
})();
var statearr_33572_35209 = state_33540__$1;
(statearr_33572_35209[(2)] = inst_33534);

(statearr_33572_35209[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (10))){
var inst_33521 = (state_33540[(2)]);
var state_33540__$1 = state_33540;
var statearr_33575_35210 = state_33540__$1;
(statearr_33575_35210[(2)] = inst_33521);

(statearr_33575_35210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33541 === (8))){
var inst_33495 = (state_33540[(7)]);
var inst_33510 = (state_33540[(11)]);
var tmp33570 = inst_33495;
var inst_33495__$1 = tmp33570;
var inst_33496 = inst_33510;
var state_33540__$1 = (function (){var statearr_33577 = state_33540;
(statearr_33577[(7)] = inst_33495__$1);

(statearr_33577[(8)] = inst_33496);

return statearr_33577;
})();
var statearr_33578_35211 = state_33540__$1;
(statearr_33578_35211[(2)] = null);

(statearr_33578_35211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_33580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33580[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_33580[(1)] = (1));

return statearr_33580;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_33540){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_33540);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e33584){var ex__30030__auto__ = e33584;
var statearr_33586_35213 = state_33540;
(statearr_33586_35213[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_33540[(4)]))){
var statearr_33589_35214 = state_33540;
(statearr_33589_35214[(1)] = cljs.core.first((state_33540[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35215 = state_33540;
state_33540 = G__35215;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_33540){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_33540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_33592 = f__30324__auto__();
(statearr_33592[(6)] = c__30323__auto___35146);

return statearr_33592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33600 = arguments.length;
switch (G__33600) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__30323__auto___35218 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_33684){
var state_val_33685 = (state_33684[(1)]);
if((state_val_33685 === (7))){
var inst_33677 = (state_33684[(2)]);
var state_33684__$1 = state_33684;
var statearr_33686_35224 = state_33684__$1;
(statearr_33686_35224[(2)] = inst_33677);

(statearr_33686_35224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (1))){
var inst_33609 = [];
var inst_33610 = inst_33609;
var inst_33611 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33684__$1 = (function (){var statearr_33687 = state_33684;
(statearr_33687[(7)] = inst_33610);

(statearr_33687[(8)] = inst_33611);

return statearr_33687;
})();
var statearr_33691_35229 = state_33684__$1;
(statearr_33691_35229[(2)] = null);

(statearr_33691_35229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (4))){
var inst_33614 = (state_33684[(9)]);
var inst_33614__$1 = (state_33684[(2)]);
var inst_33615 = (inst_33614__$1 == null);
var inst_33616 = cljs.core.not(inst_33615);
var state_33684__$1 = (function (){var statearr_33699 = state_33684;
(statearr_33699[(9)] = inst_33614__$1);

return statearr_33699;
})();
if(inst_33616){
var statearr_33700_35237 = state_33684__$1;
(statearr_33700_35237[(1)] = (5));

} else {
var statearr_33701_35238 = state_33684__$1;
(statearr_33701_35238[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (15))){
var inst_33610 = (state_33684[(7)]);
var inst_33669 = cljs.core.vec(inst_33610);
var state_33684__$1 = state_33684;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33684__$1,(18),out,inst_33669);
} else {
if((state_val_33685 === (13))){
var inst_33664 = (state_33684[(2)]);
var state_33684__$1 = state_33684;
var statearr_33712_35240 = state_33684__$1;
(statearr_33712_35240[(2)] = inst_33664);

(statearr_33712_35240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (6))){
var inst_33610 = (state_33684[(7)]);
var inst_33666 = inst_33610.length;
var inst_33667 = (inst_33666 > (0));
var state_33684__$1 = state_33684;
if(cljs.core.truth_(inst_33667)){
var statearr_33728_35241 = state_33684__$1;
(statearr_33728_35241[(1)] = (15));

} else {
var statearr_33729_35245 = state_33684__$1;
(statearr_33729_35245[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (17))){
var inst_33674 = (state_33684[(2)]);
var inst_33675 = cljs.core.async.close_BANG_(out);
var state_33684__$1 = (function (){var statearr_33733 = state_33684;
(statearr_33733[(10)] = inst_33674);

return statearr_33733;
})();
var statearr_33734_35246 = state_33684__$1;
(statearr_33734_35246[(2)] = inst_33675);

(statearr_33734_35246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (3))){
var inst_33679 = (state_33684[(2)]);
var state_33684__$1 = state_33684;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33684__$1,inst_33679);
} else {
if((state_val_33685 === (12))){
var inst_33610 = (state_33684[(7)]);
var inst_33632 = cljs.core.vec(inst_33610);
var state_33684__$1 = state_33684;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33684__$1,(14),out,inst_33632);
} else {
if((state_val_33685 === (2))){
var state_33684__$1 = state_33684;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33684__$1,(4),ch);
} else {
if((state_val_33685 === (11))){
var inst_33610 = (state_33684[(7)]);
var inst_33614 = (state_33684[(9)]);
var inst_33619 = (state_33684[(11)]);
var inst_33628 = inst_33610.push(inst_33614);
var tmp33735 = inst_33610;
var inst_33610__$1 = tmp33735;
var inst_33611 = inst_33619;
var state_33684__$1 = (function (){var statearr_33756 = state_33684;
(statearr_33756[(12)] = inst_33628);

(statearr_33756[(7)] = inst_33610__$1);

(statearr_33756[(8)] = inst_33611);

return statearr_33756;
})();
var statearr_33757_35250 = state_33684__$1;
(statearr_33757_35250[(2)] = null);

(statearr_33757_35250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (9))){
var inst_33611 = (state_33684[(8)]);
var inst_33623 = cljs.core.keyword_identical_QMARK_(inst_33611,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_33684__$1 = state_33684;
var statearr_33764_35251 = state_33684__$1;
(statearr_33764_35251[(2)] = inst_33623);

(statearr_33764_35251[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (5))){
var inst_33614 = (state_33684[(9)]);
var inst_33619 = (state_33684[(11)]);
var inst_33611 = (state_33684[(8)]);
var inst_33620 = (state_33684[(13)]);
var inst_33619__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33614) : f.call(null,inst_33614));
var inst_33620__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33619__$1,inst_33611);
var state_33684__$1 = (function (){var statearr_33769 = state_33684;
(statearr_33769[(11)] = inst_33619__$1);

(statearr_33769[(13)] = inst_33620__$1);

return statearr_33769;
})();
if(inst_33620__$1){
var statearr_33770_35259 = state_33684__$1;
(statearr_33770_35259[(1)] = (8));

} else {
var statearr_33771_35260 = state_33684__$1;
(statearr_33771_35260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (14))){
var inst_33614 = (state_33684[(9)]);
var inst_33619 = (state_33684[(11)]);
var inst_33634 = (state_33684[(2)]);
var inst_33660 = [];
var inst_33661 = inst_33660.push(inst_33614);
var inst_33610 = inst_33660;
var inst_33611 = inst_33619;
var state_33684__$1 = (function (){var statearr_33779 = state_33684;
(statearr_33779[(14)] = inst_33634);

(statearr_33779[(15)] = inst_33661);

(statearr_33779[(7)] = inst_33610);

(statearr_33779[(8)] = inst_33611);

return statearr_33779;
})();
var statearr_33783_35263 = state_33684__$1;
(statearr_33783_35263[(2)] = null);

(statearr_33783_35263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (16))){
var state_33684__$1 = state_33684;
var statearr_33784_35267 = state_33684__$1;
(statearr_33784_35267[(2)] = null);

(statearr_33784_35267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (10))){
var inst_33625 = (state_33684[(2)]);
var state_33684__$1 = state_33684;
if(cljs.core.truth_(inst_33625)){
var statearr_33788_35270 = state_33684__$1;
(statearr_33788_35270[(1)] = (11));

} else {
var statearr_33789_35271 = state_33684__$1;
(statearr_33789_35271[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (18))){
var inst_33671 = (state_33684[(2)]);
var state_33684__$1 = state_33684;
var statearr_33798_35272 = state_33684__$1;
(statearr_33798_35272[(2)] = inst_33671);

(statearr_33798_35272[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33685 === (8))){
var inst_33620 = (state_33684[(13)]);
var state_33684__$1 = state_33684;
var statearr_33807_35273 = state_33684__$1;
(statearr_33807_35273[(2)] = inst_33620);

(statearr_33807_35273[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__30027__auto__ = null;
var cljs$core$async$state_machine__30027__auto____0 = (function (){
var statearr_33810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33810[(0)] = cljs$core$async$state_machine__30027__auto__);

(statearr_33810[(1)] = (1));

return statearr_33810;
});
var cljs$core$async$state_machine__30027__auto____1 = (function (state_33684){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_33684);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e33812){var ex__30030__auto__ = e33812;
var statearr_33813_35283 = state_33684;
(statearr_33813_35283[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_33684[(4)]))){
var statearr_33815_35284 = state_33684;
(statearr_33815_35284[(1)] = cljs.core.first((state_33684[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35291 = state_33684;
state_33684 = G__35291;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
cljs$core$async$state_machine__30027__auto__ = function(state_33684){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30027__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30027__auto____1.call(this,state_33684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30027__auto____0;
cljs$core$async$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30027__auto____1;
return cljs$core$async$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_33820 = f__30324__auto__();
(statearr_33820[(6)] = c__30323__auto___35218);

return statearr_33820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
