goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_35488 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_35488(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_35489 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_35489(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34025 = coll;
var G__34026 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34025,G__34026) : shadow.dom.lazy_native_coll_seq.call(null,G__34025,G__34026));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34087 = arguments.length;
switch (G__34087) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34093 = arguments.length;
switch (G__34093) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34128 = arguments.length;
switch (G__34128) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__34170 = arguments.length;
switch (G__34170) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__34184 = arguments.length;
switch (G__34184) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__34207 = arguments.length;
switch (G__34207) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e34221){if((e34221 instanceof Object)){
var e = e34221;
return console.log("didnt support attachEvent",el,e);
} else {
throw e34221;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__34231 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__34232 = null;
var count__34233 = (0);
var i__34234 = (0);
while(true){
if((i__34234 < count__34233)){
var el = chunk__34232.cljs$core$IIndexed$_nth$arity$2(null,i__34234);
var handler_35515__$1 = ((function (seq__34231,chunk__34232,count__34233,i__34234,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34231,chunk__34232,count__34233,i__34234,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35515__$1);


var G__35516 = seq__34231;
var G__35517 = chunk__34232;
var G__35518 = count__34233;
var G__35519 = (i__34234 + (1));
seq__34231 = G__35516;
chunk__34232 = G__35517;
count__34233 = G__35518;
i__34234 = G__35519;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34231);
if(temp__5804__auto__){
var seq__34231__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34231__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34231__$1);
var G__35520 = cljs.core.chunk_rest(seq__34231__$1);
var G__35521 = c__5568__auto__;
var G__35522 = cljs.core.count(c__5568__auto__);
var G__35523 = (0);
seq__34231 = G__35520;
chunk__34232 = G__35521;
count__34233 = G__35522;
i__34234 = G__35523;
continue;
} else {
var el = cljs.core.first(seq__34231__$1);
var handler_35524__$1 = ((function (seq__34231,chunk__34232,count__34233,i__34234,el,seq__34231__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__34231,chunk__34232,count__34233,i__34234,el,seq__34231__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_35524__$1);


var G__35525 = cljs.core.next(seq__34231__$1);
var G__35526 = null;
var G__35527 = (0);
var G__35528 = (0);
seq__34231 = G__35525;
chunk__34232 = G__35526;
count__34233 = G__35527;
i__34234 = G__35528;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__34269 = arguments.length;
switch (G__34269) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__34291 = cljs.core.seq(events);
var chunk__34292 = null;
var count__34293 = (0);
var i__34294 = (0);
while(true){
if((i__34294 < count__34293)){
var vec__34314 = chunk__34292.cljs$core$IIndexed$_nth$arity$2(null,i__34294);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34314,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34314,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35530 = seq__34291;
var G__35531 = chunk__34292;
var G__35532 = count__34293;
var G__35533 = (i__34294 + (1));
seq__34291 = G__35530;
chunk__34292 = G__35531;
count__34293 = G__35532;
i__34294 = G__35533;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34291);
if(temp__5804__auto__){
var seq__34291__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34291__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34291__$1);
var G__35534 = cljs.core.chunk_rest(seq__34291__$1);
var G__35535 = c__5568__auto__;
var G__35536 = cljs.core.count(c__5568__auto__);
var G__35537 = (0);
seq__34291 = G__35534;
chunk__34292 = G__35535;
count__34293 = G__35536;
i__34294 = G__35537;
continue;
} else {
var vec__34326 = cljs.core.first(seq__34291__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34326,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34326,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35538 = cljs.core.next(seq__34291__$1);
var G__35539 = null;
var G__35540 = (0);
var G__35541 = (0);
seq__34291 = G__35538;
chunk__34292 = G__35539;
count__34293 = G__35540;
i__34294 = G__35541;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__34339 = cljs.core.seq(styles);
var chunk__34340 = null;
var count__34341 = (0);
var i__34342 = (0);
while(true){
if((i__34342 < count__34341)){
var vec__34363 = chunk__34340.cljs$core$IIndexed$_nth$arity$2(null,i__34342);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34363,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34363,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35542 = seq__34339;
var G__35543 = chunk__34340;
var G__35544 = count__34341;
var G__35545 = (i__34342 + (1));
seq__34339 = G__35542;
chunk__34340 = G__35543;
count__34341 = G__35544;
i__34342 = G__35545;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34339);
if(temp__5804__auto__){
var seq__34339__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34339__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34339__$1);
var G__35546 = cljs.core.chunk_rest(seq__34339__$1);
var G__35547 = c__5568__auto__;
var G__35548 = cljs.core.count(c__5568__auto__);
var G__35549 = (0);
seq__34339 = G__35546;
chunk__34340 = G__35547;
count__34341 = G__35548;
i__34342 = G__35549;
continue;
} else {
var vec__34376 = cljs.core.first(seq__34339__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34376,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34376,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__35559 = cljs.core.next(seq__34339__$1);
var G__35560 = null;
var G__35561 = (0);
var G__35562 = (0);
seq__34339 = G__35559;
chunk__34340 = G__35560;
count__34341 = G__35561;
i__34342 = G__35562;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__34393_35563 = key;
var G__34393_35564__$1 = (((G__34393_35563 instanceof cljs.core.Keyword))?G__34393_35563.fqn:null);
switch (G__34393_35564__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35570 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_35570,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_35570,"aria-");
}
})())){
el.setAttribute(ks_35570,value);
} else {
(el[ks_35570] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__34435){
var map__34436 = p__34435;
var map__34436__$1 = cljs.core.__destructure_map(map__34436);
var props = map__34436__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34436__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__34438 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34438,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34438,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34438,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__34444 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__34444,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__34444;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__34458 = arguments.length;
switch (G__34458) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__34474){
var vec__34475 = p__34474;
var seq__34476 = cljs.core.seq(vec__34475);
var first__34477 = cljs.core.first(seq__34476);
var seq__34476__$1 = cljs.core.next(seq__34476);
var nn = first__34477;
var first__34477__$1 = cljs.core.first(seq__34476__$1);
var seq__34476__$2 = cljs.core.next(seq__34476__$1);
var np = first__34477__$1;
var nc = seq__34476__$2;
var node = vec__34475;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34480 = nn;
var G__34481 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34480,G__34481) : create_fn.call(null,G__34480,G__34481));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__34486 = nn;
var G__34487 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__34486,G__34487) : create_fn.call(null,G__34486,G__34487));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__34492 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34492,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34492,(1),null);
var seq__34496_35581 = cljs.core.seq(node_children);
var chunk__34497_35582 = null;
var count__34498_35583 = (0);
var i__34499_35584 = (0);
while(true){
if((i__34499_35584 < count__34498_35583)){
var child_struct_35585 = chunk__34497_35582.cljs$core$IIndexed$_nth$arity$2(null,i__34499_35584);
var children_35586 = shadow.dom.dom_node(child_struct_35585);
if(cljs.core.seq_QMARK_(children_35586)){
var seq__34581_35587 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35586));
var chunk__34583_35588 = null;
var count__34584_35589 = (0);
var i__34585_35590 = (0);
while(true){
if((i__34585_35590 < count__34584_35589)){
var child_35591 = chunk__34583_35588.cljs$core$IIndexed$_nth$arity$2(null,i__34585_35590);
if(cljs.core.truth_(child_35591)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35591);


var G__35592 = seq__34581_35587;
var G__35593 = chunk__34583_35588;
var G__35594 = count__34584_35589;
var G__35595 = (i__34585_35590 + (1));
seq__34581_35587 = G__35592;
chunk__34583_35588 = G__35593;
count__34584_35589 = G__35594;
i__34585_35590 = G__35595;
continue;
} else {
var G__35596 = seq__34581_35587;
var G__35597 = chunk__34583_35588;
var G__35598 = count__34584_35589;
var G__35599 = (i__34585_35590 + (1));
seq__34581_35587 = G__35596;
chunk__34583_35588 = G__35597;
count__34584_35589 = G__35598;
i__34585_35590 = G__35599;
continue;
}
} else {
var temp__5804__auto___35600 = cljs.core.seq(seq__34581_35587);
if(temp__5804__auto___35600){
var seq__34581_35601__$1 = temp__5804__auto___35600;
if(cljs.core.chunked_seq_QMARK_(seq__34581_35601__$1)){
var c__5568__auto___35602 = cljs.core.chunk_first(seq__34581_35601__$1);
var G__35603 = cljs.core.chunk_rest(seq__34581_35601__$1);
var G__35604 = c__5568__auto___35602;
var G__35605 = cljs.core.count(c__5568__auto___35602);
var G__35606 = (0);
seq__34581_35587 = G__35603;
chunk__34583_35588 = G__35604;
count__34584_35589 = G__35605;
i__34585_35590 = G__35606;
continue;
} else {
var child_35607 = cljs.core.first(seq__34581_35601__$1);
if(cljs.core.truth_(child_35607)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35607);


var G__35608 = cljs.core.next(seq__34581_35601__$1);
var G__35609 = null;
var G__35610 = (0);
var G__35611 = (0);
seq__34581_35587 = G__35608;
chunk__34583_35588 = G__35609;
count__34584_35589 = G__35610;
i__34585_35590 = G__35611;
continue;
} else {
var G__35612 = cljs.core.next(seq__34581_35601__$1);
var G__35613 = null;
var G__35614 = (0);
var G__35615 = (0);
seq__34581_35587 = G__35612;
chunk__34583_35588 = G__35613;
count__34584_35589 = G__35614;
i__34585_35590 = G__35615;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35586);
}


var G__35616 = seq__34496_35581;
var G__35617 = chunk__34497_35582;
var G__35618 = count__34498_35583;
var G__35619 = (i__34499_35584 + (1));
seq__34496_35581 = G__35616;
chunk__34497_35582 = G__35617;
count__34498_35583 = G__35618;
i__34499_35584 = G__35619;
continue;
} else {
var temp__5804__auto___35620 = cljs.core.seq(seq__34496_35581);
if(temp__5804__auto___35620){
var seq__34496_35621__$1 = temp__5804__auto___35620;
if(cljs.core.chunked_seq_QMARK_(seq__34496_35621__$1)){
var c__5568__auto___35622 = cljs.core.chunk_first(seq__34496_35621__$1);
var G__35623 = cljs.core.chunk_rest(seq__34496_35621__$1);
var G__35624 = c__5568__auto___35622;
var G__35625 = cljs.core.count(c__5568__auto___35622);
var G__35626 = (0);
seq__34496_35581 = G__35623;
chunk__34497_35582 = G__35624;
count__34498_35583 = G__35625;
i__34499_35584 = G__35626;
continue;
} else {
var child_struct_35627 = cljs.core.first(seq__34496_35621__$1);
var children_35628 = shadow.dom.dom_node(child_struct_35627);
if(cljs.core.seq_QMARK_(children_35628)){
var seq__34606_35629 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35628));
var chunk__34608_35630 = null;
var count__34609_35631 = (0);
var i__34610_35632 = (0);
while(true){
if((i__34610_35632 < count__34609_35631)){
var child_35633 = chunk__34608_35630.cljs$core$IIndexed$_nth$arity$2(null,i__34610_35632);
if(cljs.core.truth_(child_35633)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35633);


var G__35634 = seq__34606_35629;
var G__35635 = chunk__34608_35630;
var G__35636 = count__34609_35631;
var G__35637 = (i__34610_35632 + (1));
seq__34606_35629 = G__35634;
chunk__34608_35630 = G__35635;
count__34609_35631 = G__35636;
i__34610_35632 = G__35637;
continue;
} else {
var G__35638 = seq__34606_35629;
var G__35639 = chunk__34608_35630;
var G__35640 = count__34609_35631;
var G__35641 = (i__34610_35632 + (1));
seq__34606_35629 = G__35638;
chunk__34608_35630 = G__35639;
count__34609_35631 = G__35640;
i__34610_35632 = G__35641;
continue;
}
} else {
var temp__5804__auto___35642__$1 = cljs.core.seq(seq__34606_35629);
if(temp__5804__auto___35642__$1){
var seq__34606_35643__$1 = temp__5804__auto___35642__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34606_35643__$1)){
var c__5568__auto___35644 = cljs.core.chunk_first(seq__34606_35643__$1);
var G__35646 = cljs.core.chunk_rest(seq__34606_35643__$1);
var G__35647 = c__5568__auto___35644;
var G__35648 = cljs.core.count(c__5568__auto___35644);
var G__35649 = (0);
seq__34606_35629 = G__35646;
chunk__34608_35630 = G__35647;
count__34609_35631 = G__35648;
i__34610_35632 = G__35649;
continue;
} else {
var child_35650 = cljs.core.first(seq__34606_35643__$1);
if(cljs.core.truth_(child_35650)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35650);


var G__35651 = cljs.core.next(seq__34606_35643__$1);
var G__35652 = null;
var G__35653 = (0);
var G__35654 = (0);
seq__34606_35629 = G__35651;
chunk__34608_35630 = G__35652;
count__34609_35631 = G__35653;
i__34610_35632 = G__35654;
continue;
} else {
var G__35655 = cljs.core.next(seq__34606_35643__$1);
var G__35656 = null;
var G__35657 = (0);
var G__35658 = (0);
seq__34606_35629 = G__35655;
chunk__34608_35630 = G__35656;
count__34609_35631 = G__35657;
i__34610_35632 = G__35658;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35628);
}


var G__35659 = cljs.core.next(seq__34496_35621__$1);
var G__35660 = null;
var G__35661 = (0);
var G__35662 = (0);
seq__34496_35581 = G__35659;
chunk__34497_35582 = G__35660;
count__34498_35583 = G__35661;
i__34499_35584 = G__35662;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__34667 = cljs.core.seq(node);
var chunk__34668 = null;
var count__34669 = (0);
var i__34670 = (0);
while(true){
if((i__34670 < count__34669)){
var n = chunk__34668.cljs$core$IIndexed$_nth$arity$2(null,i__34670);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35663 = seq__34667;
var G__35664 = chunk__34668;
var G__35665 = count__34669;
var G__35666 = (i__34670 + (1));
seq__34667 = G__35663;
chunk__34668 = G__35664;
count__34669 = G__35665;
i__34670 = G__35666;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34667);
if(temp__5804__auto__){
var seq__34667__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34667__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34667__$1);
var G__35667 = cljs.core.chunk_rest(seq__34667__$1);
var G__35668 = c__5568__auto__;
var G__35669 = cljs.core.count(c__5568__auto__);
var G__35670 = (0);
seq__34667 = G__35667;
chunk__34668 = G__35668;
count__34669 = G__35669;
i__34670 = G__35670;
continue;
} else {
var n = cljs.core.first(seq__34667__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35671 = cljs.core.next(seq__34667__$1);
var G__35672 = null;
var G__35673 = (0);
var G__35674 = (0);
seq__34667 = G__35671;
chunk__34668 = G__35672;
count__34669 = G__35673;
i__34670 = G__35674;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__34691 = arguments.length;
switch (G__34691) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__34698 = arguments.length;
switch (G__34698) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__34706 = arguments.length;
switch (G__34706) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35691 = arguments.length;
var i__5770__auto___35692 = (0);
while(true){
if((i__5770__auto___35692 < len__5769__auto___35691)){
args__5775__auto__.push((arguments[i__5770__auto___35692]));

var G__35693 = (i__5770__auto___35692 + (1));
i__5770__auto___35692 = G__35693;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__34741_35697 = cljs.core.seq(nodes);
var chunk__34742_35698 = null;
var count__34743_35699 = (0);
var i__34744_35700 = (0);
while(true){
if((i__34744_35700 < count__34743_35699)){
var node_35701 = chunk__34742_35698.cljs$core$IIndexed$_nth$arity$2(null,i__34744_35700);
fragment.appendChild(shadow.dom._to_dom(node_35701));


var G__35702 = seq__34741_35697;
var G__35703 = chunk__34742_35698;
var G__35704 = count__34743_35699;
var G__35705 = (i__34744_35700 + (1));
seq__34741_35697 = G__35702;
chunk__34742_35698 = G__35703;
count__34743_35699 = G__35704;
i__34744_35700 = G__35705;
continue;
} else {
var temp__5804__auto___35706 = cljs.core.seq(seq__34741_35697);
if(temp__5804__auto___35706){
var seq__34741_35707__$1 = temp__5804__auto___35706;
if(cljs.core.chunked_seq_QMARK_(seq__34741_35707__$1)){
var c__5568__auto___35708 = cljs.core.chunk_first(seq__34741_35707__$1);
var G__35709 = cljs.core.chunk_rest(seq__34741_35707__$1);
var G__35710 = c__5568__auto___35708;
var G__35711 = cljs.core.count(c__5568__auto___35708);
var G__35712 = (0);
seq__34741_35697 = G__35709;
chunk__34742_35698 = G__35710;
count__34743_35699 = G__35711;
i__34744_35700 = G__35712;
continue;
} else {
var node_35713 = cljs.core.first(seq__34741_35707__$1);
fragment.appendChild(shadow.dom._to_dom(node_35713));


var G__35714 = cljs.core.next(seq__34741_35707__$1);
var G__35715 = null;
var G__35716 = (0);
var G__35717 = (0);
seq__34741_35697 = G__35714;
chunk__34742_35698 = G__35715;
count__34743_35699 = G__35716;
i__34744_35700 = G__35717;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq34737){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34737));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__34761_35718 = cljs.core.seq(scripts);
var chunk__34762_35719 = null;
var count__34763_35720 = (0);
var i__34764_35721 = (0);
while(true){
if((i__34764_35721 < count__34763_35720)){
var vec__34776_35722 = chunk__34762_35719.cljs$core$IIndexed$_nth$arity$2(null,i__34764_35721);
var script_tag_35723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34776_35722,(0),null);
var script_body_35724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34776_35722,(1),null);
eval(script_body_35724);


var G__35725 = seq__34761_35718;
var G__35726 = chunk__34762_35719;
var G__35727 = count__34763_35720;
var G__35728 = (i__34764_35721 + (1));
seq__34761_35718 = G__35725;
chunk__34762_35719 = G__35726;
count__34763_35720 = G__35727;
i__34764_35721 = G__35728;
continue;
} else {
var temp__5804__auto___35729 = cljs.core.seq(seq__34761_35718);
if(temp__5804__auto___35729){
var seq__34761_35730__$1 = temp__5804__auto___35729;
if(cljs.core.chunked_seq_QMARK_(seq__34761_35730__$1)){
var c__5568__auto___35731 = cljs.core.chunk_first(seq__34761_35730__$1);
var G__35732 = cljs.core.chunk_rest(seq__34761_35730__$1);
var G__35733 = c__5568__auto___35731;
var G__35734 = cljs.core.count(c__5568__auto___35731);
var G__35735 = (0);
seq__34761_35718 = G__35732;
chunk__34762_35719 = G__35733;
count__34763_35720 = G__35734;
i__34764_35721 = G__35735;
continue;
} else {
var vec__34787_35736 = cljs.core.first(seq__34761_35730__$1);
var script_tag_35737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34787_35736,(0),null);
var script_body_35738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34787_35736,(1),null);
eval(script_body_35738);


var G__35739 = cljs.core.next(seq__34761_35730__$1);
var G__35740 = null;
var G__35741 = (0);
var G__35742 = (0);
seq__34761_35718 = G__35739;
chunk__34762_35719 = G__35740;
count__34763_35720 = G__35741;
i__34764_35721 = G__35742;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__34790){
var vec__34792 = p__34790;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34792,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34792,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__34810 = arguments.length;
switch (G__34810) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__34830 = cljs.core.seq(style_keys);
var chunk__34831 = null;
var count__34832 = (0);
var i__34833 = (0);
while(true){
if((i__34833 < count__34832)){
var it = chunk__34831.cljs$core$IIndexed$_nth$arity$2(null,i__34833);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35751 = seq__34830;
var G__35752 = chunk__34831;
var G__35753 = count__34832;
var G__35754 = (i__34833 + (1));
seq__34830 = G__35751;
chunk__34831 = G__35752;
count__34832 = G__35753;
i__34833 = G__35754;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__34830);
if(temp__5804__auto__){
var seq__34830__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34830__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__34830__$1);
var G__35762 = cljs.core.chunk_rest(seq__34830__$1);
var G__35763 = c__5568__auto__;
var G__35764 = cljs.core.count(c__5568__auto__);
var G__35765 = (0);
seq__34830 = G__35762;
chunk__34831 = G__35763;
count__34832 = G__35764;
i__34833 = G__35765;
continue;
} else {
var it = cljs.core.first(seq__34830__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35766 = cljs.core.next(seq__34830__$1);
var G__35767 = null;
var G__35768 = (0);
var G__35769 = (0);
seq__34830 = G__35766;
chunk__34831 = G__35767;
count__34832 = G__35768;
i__34833 = G__35769;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34848,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34857 = k34848;
var G__34857__$1 = (((G__34857 instanceof cljs.core.Keyword))?G__34857.fqn:null);
switch (G__34857__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34848,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34864){
var vec__34865 = p__34864;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34865,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34865,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34847){
var self__ = this;
var G__34847__$1 = this;
return (new cljs.core.RecordIter((0),G__34847__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34849,other34850){
var self__ = this;
var this34849__$1 = this;
return (((!((other34850 == null)))) && ((((this34849__$1.constructor === other34850.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34849__$1.x,other34850.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34849__$1.y,other34850.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34849__$1.__extmap,other34850.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34848){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34914 = k34848;
var G__34914__$1 = (((G__34914 instanceof cljs.core.Keyword))?G__34914.fqn:null);
switch (G__34914__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34848);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34847){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34915 = cljs.core.keyword_identical_QMARK_;
var expr__34916 = k__5352__auto__;
if(cljs.core.truth_((pred__34915.cljs$core$IFn$_invoke$arity$2 ? pred__34915.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__34916) : pred__34915.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__34916)))){
return (new shadow.dom.Coordinate(G__34847,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34915.cljs$core$IFn$_invoke$arity$2 ? pred__34915.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__34916) : pred__34915.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__34916)))){
return (new shadow.dom.Coordinate(self__.x,G__34847,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34847),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34847){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__34847,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__34852){
var extmap__5385__auto__ = (function (){var G__34921 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34852,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__34852)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34921);
} else {
return G__34921;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__34852),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__34852),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k34931,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__34950 = k34931;
var G__34950__$1 = (((G__34950 instanceof cljs.core.Keyword))?G__34950.fqn:null);
switch (G__34950__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34931,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__34954){
var vec__34957 = p__34954;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34957,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34957,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34930){
var self__ = this;
var G__34930__$1 = this;
return (new cljs.core.RecordIter((0),G__34930__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34932,other34933){
var self__ = this;
var this34932__$1 = this;
return (((!((other34933 == null)))) && ((((this34932__$1.constructor === other34933.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34932__$1.w,other34933.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34932__$1.h,other34933.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34932__$1.__extmap,other34933.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k34931){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34983 = k34931;
var G__34983__$1 = (((G__34983 instanceof cljs.core.Keyword))?G__34983.fqn:null);
switch (G__34983__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34931);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__34930){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34985 = cljs.core.keyword_identical_QMARK_;
var expr__34986 = k__5352__auto__;
if(cljs.core.truth_((pred__34985.cljs$core$IFn$_invoke$arity$2 ? pred__34985.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__34986) : pred__34985.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__34986)))){
return (new shadow.dom.Size(G__34930,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34985.cljs$core$IFn$_invoke$arity$2 ? pred__34985.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__34986) : pred__34985.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__34986)))){
return (new shadow.dom.Size(self__.w,G__34930,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__34930),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__34930){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__34930,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__34936){
var extmap__5385__auto__ = (function (){var G__35012 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34936,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__34936)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35012);
} else {
return G__35012;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__34936),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__34936),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__35783 = (i + (1));
var G__35784 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35783;
ret = G__35784;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35130){
var vec__35131 = p__35130;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35131,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35131,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35151 = arguments.length;
switch (G__35151) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35787 = ps;
var G__35788 = (i + (1));
el__$1 = G__35787;
i = G__35788;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35225 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35225,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35225,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35225,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35230_35790 = cljs.core.seq(props);
var chunk__35231_35791 = null;
var count__35232_35792 = (0);
var i__35233_35793 = (0);
while(true){
if((i__35233_35793 < count__35232_35792)){
var vec__35247_35794 = chunk__35231_35791.cljs$core$IIndexed$_nth$arity$2(null,i__35233_35793);
var k_35795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35247_35794,(0),null);
var v_35796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35247_35794,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_35795);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35795),v_35796);


var G__35797 = seq__35230_35790;
var G__35798 = chunk__35231_35791;
var G__35799 = count__35232_35792;
var G__35800 = (i__35233_35793 + (1));
seq__35230_35790 = G__35797;
chunk__35231_35791 = G__35798;
count__35232_35792 = G__35799;
i__35233_35793 = G__35800;
continue;
} else {
var temp__5804__auto___35801 = cljs.core.seq(seq__35230_35790);
if(temp__5804__auto___35801){
var seq__35230_35802__$1 = temp__5804__auto___35801;
if(cljs.core.chunked_seq_QMARK_(seq__35230_35802__$1)){
var c__5568__auto___35803 = cljs.core.chunk_first(seq__35230_35802__$1);
var G__35804 = cljs.core.chunk_rest(seq__35230_35802__$1);
var G__35805 = c__5568__auto___35803;
var G__35806 = cljs.core.count(c__5568__auto___35803);
var G__35807 = (0);
seq__35230_35790 = G__35804;
chunk__35231_35791 = G__35805;
count__35232_35792 = G__35806;
i__35233_35793 = G__35807;
continue;
} else {
var vec__35252_35808 = cljs.core.first(seq__35230_35802__$1);
var k_35809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35252_35808,(0),null);
var v_35810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35252_35808,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35809);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35809),v_35810);


var G__35811 = cljs.core.next(seq__35230_35802__$1);
var G__35812 = null;
var G__35813 = (0);
var G__35814 = (0);
seq__35230_35790 = G__35811;
chunk__35231_35791 = G__35812;
count__35232_35792 = G__35813;
i__35233_35793 = G__35814;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35274 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35274,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35274,(1),null);
var seq__35277_35815 = cljs.core.seq(node_children);
var chunk__35279_35816 = null;
var count__35280_35817 = (0);
var i__35281_35818 = (0);
while(true){
if((i__35281_35818 < count__35280_35817)){
var child_struct_35819 = chunk__35279_35816.cljs$core$IIndexed$_nth$arity$2(null,i__35281_35818);
if((!((child_struct_35819 == null)))){
if(typeof child_struct_35819 === 'string'){
var text_35820 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35820),child_struct_35819].join(''));
} else {
var children_35821 = shadow.dom.svg_node(child_struct_35819);
if(cljs.core.seq_QMARK_(children_35821)){
var seq__35330_35822 = cljs.core.seq(children_35821);
var chunk__35332_35823 = null;
var count__35333_35824 = (0);
var i__35334_35825 = (0);
while(true){
if((i__35334_35825 < count__35333_35824)){
var child_35826 = chunk__35332_35823.cljs$core$IIndexed$_nth$arity$2(null,i__35334_35825);
if(cljs.core.truth_(child_35826)){
node.appendChild(child_35826);


var G__35827 = seq__35330_35822;
var G__35828 = chunk__35332_35823;
var G__35829 = count__35333_35824;
var G__35830 = (i__35334_35825 + (1));
seq__35330_35822 = G__35827;
chunk__35332_35823 = G__35828;
count__35333_35824 = G__35829;
i__35334_35825 = G__35830;
continue;
} else {
var G__35831 = seq__35330_35822;
var G__35832 = chunk__35332_35823;
var G__35833 = count__35333_35824;
var G__35834 = (i__35334_35825 + (1));
seq__35330_35822 = G__35831;
chunk__35332_35823 = G__35832;
count__35333_35824 = G__35833;
i__35334_35825 = G__35834;
continue;
}
} else {
var temp__5804__auto___35835 = cljs.core.seq(seq__35330_35822);
if(temp__5804__auto___35835){
var seq__35330_35836__$1 = temp__5804__auto___35835;
if(cljs.core.chunked_seq_QMARK_(seq__35330_35836__$1)){
var c__5568__auto___35837 = cljs.core.chunk_first(seq__35330_35836__$1);
var G__35838 = cljs.core.chunk_rest(seq__35330_35836__$1);
var G__35839 = c__5568__auto___35837;
var G__35840 = cljs.core.count(c__5568__auto___35837);
var G__35841 = (0);
seq__35330_35822 = G__35838;
chunk__35332_35823 = G__35839;
count__35333_35824 = G__35840;
i__35334_35825 = G__35841;
continue;
} else {
var child_35842 = cljs.core.first(seq__35330_35836__$1);
if(cljs.core.truth_(child_35842)){
node.appendChild(child_35842);


var G__35843 = cljs.core.next(seq__35330_35836__$1);
var G__35844 = null;
var G__35845 = (0);
var G__35846 = (0);
seq__35330_35822 = G__35843;
chunk__35332_35823 = G__35844;
count__35333_35824 = G__35845;
i__35334_35825 = G__35846;
continue;
} else {
var G__35847 = cljs.core.next(seq__35330_35836__$1);
var G__35848 = null;
var G__35849 = (0);
var G__35850 = (0);
seq__35330_35822 = G__35847;
chunk__35332_35823 = G__35848;
count__35333_35824 = G__35849;
i__35334_35825 = G__35850;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35821);
}
}


var G__35851 = seq__35277_35815;
var G__35852 = chunk__35279_35816;
var G__35853 = count__35280_35817;
var G__35854 = (i__35281_35818 + (1));
seq__35277_35815 = G__35851;
chunk__35279_35816 = G__35852;
count__35280_35817 = G__35853;
i__35281_35818 = G__35854;
continue;
} else {
var G__35855 = seq__35277_35815;
var G__35856 = chunk__35279_35816;
var G__35857 = count__35280_35817;
var G__35858 = (i__35281_35818 + (1));
seq__35277_35815 = G__35855;
chunk__35279_35816 = G__35856;
count__35280_35817 = G__35857;
i__35281_35818 = G__35858;
continue;
}
} else {
var temp__5804__auto___35859 = cljs.core.seq(seq__35277_35815);
if(temp__5804__auto___35859){
var seq__35277_35860__$1 = temp__5804__auto___35859;
if(cljs.core.chunked_seq_QMARK_(seq__35277_35860__$1)){
var c__5568__auto___35861 = cljs.core.chunk_first(seq__35277_35860__$1);
var G__35862 = cljs.core.chunk_rest(seq__35277_35860__$1);
var G__35863 = c__5568__auto___35861;
var G__35864 = cljs.core.count(c__5568__auto___35861);
var G__35865 = (0);
seq__35277_35815 = G__35862;
chunk__35279_35816 = G__35863;
count__35280_35817 = G__35864;
i__35281_35818 = G__35865;
continue;
} else {
var child_struct_35866 = cljs.core.first(seq__35277_35860__$1);
if((!((child_struct_35866 == null)))){
if(typeof child_struct_35866 === 'string'){
var text_35867 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35867),child_struct_35866].join(''));
} else {
var children_35868 = shadow.dom.svg_node(child_struct_35866);
if(cljs.core.seq_QMARK_(children_35868)){
var seq__35348_35869 = cljs.core.seq(children_35868);
var chunk__35350_35870 = null;
var count__35351_35871 = (0);
var i__35352_35872 = (0);
while(true){
if((i__35352_35872 < count__35351_35871)){
var child_35873 = chunk__35350_35870.cljs$core$IIndexed$_nth$arity$2(null,i__35352_35872);
if(cljs.core.truth_(child_35873)){
node.appendChild(child_35873);


var G__35874 = seq__35348_35869;
var G__35875 = chunk__35350_35870;
var G__35876 = count__35351_35871;
var G__35877 = (i__35352_35872 + (1));
seq__35348_35869 = G__35874;
chunk__35350_35870 = G__35875;
count__35351_35871 = G__35876;
i__35352_35872 = G__35877;
continue;
} else {
var G__35878 = seq__35348_35869;
var G__35879 = chunk__35350_35870;
var G__35880 = count__35351_35871;
var G__35881 = (i__35352_35872 + (1));
seq__35348_35869 = G__35878;
chunk__35350_35870 = G__35879;
count__35351_35871 = G__35880;
i__35352_35872 = G__35881;
continue;
}
} else {
var temp__5804__auto___35882__$1 = cljs.core.seq(seq__35348_35869);
if(temp__5804__auto___35882__$1){
var seq__35348_35883__$1 = temp__5804__auto___35882__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35348_35883__$1)){
var c__5568__auto___35886 = cljs.core.chunk_first(seq__35348_35883__$1);
var G__35887 = cljs.core.chunk_rest(seq__35348_35883__$1);
var G__35888 = c__5568__auto___35886;
var G__35889 = cljs.core.count(c__5568__auto___35886);
var G__35890 = (0);
seq__35348_35869 = G__35887;
chunk__35350_35870 = G__35888;
count__35351_35871 = G__35889;
i__35352_35872 = G__35890;
continue;
} else {
var child_35891 = cljs.core.first(seq__35348_35883__$1);
if(cljs.core.truth_(child_35891)){
node.appendChild(child_35891);


var G__35892 = cljs.core.next(seq__35348_35883__$1);
var G__35893 = null;
var G__35894 = (0);
var G__35895 = (0);
seq__35348_35869 = G__35892;
chunk__35350_35870 = G__35893;
count__35351_35871 = G__35894;
i__35352_35872 = G__35895;
continue;
} else {
var G__35896 = cljs.core.next(seq__35348_35883__$1);
var G__35897 = null;
var G__35898 = (0);
var G__35899 = (0);
seq__35348_35869 = G__35896;
chunk__35350_35870 = G__35897;
count__35351_35871 = G__35898;
i__35352_35872 = G__35899;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35868);
}
}


var G__35900 = cljs.core.next(seq__35277_35860__$1);
var G__35901 = null;
var G__35902 = (0);
var G__35903 = (0);
seq__35277_35815 = G__35900;
chunk__35279_35816 = G__35901;
count__35280_35817 = G__35902;
i__35281_35818 = G__35903;
continue;
} else {
var G__35904 = cljs.core.next(seq__35277_35860__$1);
var G__35905 = null;
var G__35906 = (0);
var G__35907 = (0);
seq__35277_35815 = G__35904;
chunk__35279_35816 = G__35905;
count__35280_35817 = G__35906;
i__35281_35818 = G__35907;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35911 = arguments.length;
var i__5770__auto___35912 = (0);
while(true){
if((i__5770__auto___35912 < len__5769__auto___35911)){
args__5775__auto__.push((arguments[i__5770__auto___35912]));

var G__35913 = (i__5770__auto___35912 + (1));
i__5770__auto___35912 = G__35913;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq35389){
var G__35390 = cljs.core.first(seq35389);
var seq35389__$1 = cljs.core.next(seq35389);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35390,seq35389__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35415 = arguments.length;
switch (G__35415) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__30323__auto___35926 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__30324__auto__ = (function (){var switch__30026__auto__ = (function (state_35452){
var state_val_35453 = (state_35452[(1)]);
if((state_val_35453 === (1))){
var state_35452__$1 = state_35452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35452__$1,(2),once_or_cleanup);
} else {
if((state_val_35453 === (2))){
var inst_35449 = (state_35452[(2)]);
var inst_35450 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35452__$1 = (function (){var statearr_35467 = state_35452;
(statearr_35467[(7)] = inst_35449);

return statearr_35467;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35452__$1,inst_35450);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__30027__auto__ = null;
var shadow$dom$state_machine__30027__auto____0 = (function (){
var statearr_35474 = [null,null,null,null,null,null,null,null];
(statearr_35474[(0)] = shadow$dom$state_machine__30027__auto__);

(statearr_35474[(1)] = (1));

return statearr_35474;
});
var shadow$dom$state_machine__30027__auto____1 = (function (state_35452){
while(true){
var ret_value__30028__auto__ = (function (){try{while(true){
var result__30029__auto__ = switch__30026__auto__(state_35452);
if(cljs.core.keyword_identical_QMARK_(result__30029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30029__auto__;
}
break;
}
}catch (e35475){var ex__30030__auto__ = e35475;
var statearr_35476_35927 = state_35452;
(statearr_35476_35927[(2)] = ex__30030__auto__);


if(cljs.core.seq((state_35452[(4)]))){
var statearr_35477_35928 = state_35452;
(statearr_35477_35928[(1)] = cljs.core.first((state_35452[(4)])));

} else {
throw ex__30030__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__30028__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35929 = state_35452;
state_35452 = G__35929;
continue;
} else {
return ret_value__30028__auto__;
}
break;
}
});
shadow$dom$state_machine__30027__auto__ = function(state_35452){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__30027__auto____0.call(this);
case 1:
return shadow$dom$state_machine__30027__auto____1.call(this,state_35452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__30027__auto____0;
shadow$dom$state_machine__30027__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__30027__auto____1;
return shadow$dom$state_machine__30027__auto__;
})()
})();
var state__30325__auto__ = (function (){var statearr_35481 = f__30324__auto__();
(statearr_35481[(6)] = c__30323__auto___35926);

return statearr_35481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__30325__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
