goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__51366){
var vec__51367 = p__51366;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51367,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51367,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__51374 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__51374__$1 = (((G__51374 instanceof cljs.core.Keyword))?G__51374.fqn:null);
switch (G__51374__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__51382 = (function (){
var seq__51384 = cljs.core.seq(vars__$1);
var chunk__51386 = null;
var count__51387 = (0);
var i__51388 = (0);
while(true){
if((i__51388 < count__51387)){
var v = chunk__51386.cljs$core$IIndexed$_nth$arity$2(null,i__51388);
var temp__5804__auto___51526 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___51526)){
var t_51527 = temp__5804__auto___51526;
var G__51413_51528 = ((function (seq__51384,chunk__51386,count__51387,i__51388,t_51527,temp__5804__auto___51526,v,each_fixture_fn,G__51374,G__51374__$1,env,once_fixtures,each_fixtures,vec__51367,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_51527)));
});})(seq__51384,chunk__51386,count__51387,i__51388,t_51527,temp__5804__auto___51526,v,each_fixture_fn,G__51374,G__51374__$1,env,once_fixtures,each_fixtures,vec__51367,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__51413_51528) : each_fixture_fn.call(null,G__51413_51528));
} else {
}


var G__51532 = seq__51384;
var G__51533 = chunk__51386;
var G__51534 = count__51387;
var G__51535 = (i__51388 + (1));
seq__51384 = G__51532;
chunk__51386 = G__51533;
count__51387 = G__51534;
i__51388 = G__51535;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__51384);
if(temp__5804__auto__){
var seq__51384__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51384__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__51384__$1);
var G__51536 = cljs.core.chunk_rest(seq__51384__$1);
var G__51537 = c__5568__auto__;
var G__51538 = cljs.core.count(c__5568__auto__);
var G__51539 = (0);
seq__51384 = G__51536;
chunk__51386 = G__51537;
count__51387 = G__51538;
i__51388 = G__51539;
continue;
} else {
var v = cljs.core.first(seq__51384__$1);
var temp__5804__auto___51540__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5804__auto___51540__$1)){
var t_51541 = temp__5804__auto___51540__$1;
var G__51414_51542 = ((function (seq__51384,chunk__51386,count__51387,i__51388,t_51541,temp__5804__auto___51540__$1,v,seq__51384__$1,temp__5804__auto__,each_fixture_fn,G__51374,G__51374__$1,env,once_fixtures,each_fixtures,vec__51367,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_51541)));
});})(seq__51384,chunk__51386,count__51387,i__51388,t_51541,temp__5804__auto___51540__$1,v,seq__51384__$1,temp__5804__auto__,each_fixture_fn,G__51374,G__51374__$1,env,once_fixtures,each_fixtures,vec__51367,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__51414_51542) : each_fixture_fn.call(null,G__51414_51542));
} else {
}


var G__51543 = cljs.core.next(seq__51384__$1);
var G__51544 = null;
var G__51545 = (0);
var G__51546 = (0);
seq__51384 = G__51543;
chunk__51386 = G__51544;
count__51387 = G__51545;
i__51388 = G__51546;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__51381 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__51381.cljs$core$IFn$_invoke$arity$1 ? fexpr__51381.cljs$core$IFn$_invoke$arity$1(G__51382) : fexpr__51381.call(null,G__51382));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__51374__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__51362_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__51362_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__51436 = shadow.test.env.get_test_ns_info(ns);
var map__51436__$1 = cljs.core.__destructure_map(map__51436);
var test_ns = map__51436__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51436__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__51447,vars){
var map__51455 = p__51447;
var map__51455__$1 = cljs.core.__destructure_map(map__51455);
var env = map__51455__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51455__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__51456_51549 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__51458_51550 = null;
var count__51459_51551 = (0);
var i__51460_51552 = (0);
while(true){
if((i__51460_51552 < count__51459_51551)){
var vec__51474_51557 = chunk__51458_51550.cljs$core$IIndexed$_nth$arity$2(null,i__51460_51552);
var test_ns_51558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51474_51557,(0),null);
var ns_info_51559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51474_51557,(1),null);
var map__51477_51560 = ns_info_51559;
var map__51477_51561__$1 = cljs.core.__destructure_map(map__51477_51560);
var fixtures_51562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51477_51561__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___51563 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_51562);
if(cljs.core.truth_(temp__5804__auto___51563)){
var fix_51564 = temp__5804__auto___51563;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51558,fix_51564], 0));
} else {
}

var temp__5804__auto___51565 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_51562);
if(cljs.core.truth_(temp__5804__auto___51565)){
var fix_51566 = temp__5804__auto___51565;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51558,fix_51566], 0));
} else {
}


var G__51567 = seq__51456_51549;
var G__51568 = chunk__51458_51550;
var G__51569 = count__51459_51551;
var G__51570 = (i__51460_51552 + (1));
seq__51456_51549 = G__51567;
chunk__51458_51550 = G__51568;
count__51459_51551 = G__51569;
i__51460_51552 = G__51570;
continue;
} else {
var temp__5804__auto___51571 = cljs.core.seq(seq__51456_51549);
if(temp__5804__auto___51571){
var seq__51456_51572__$1 = temp__5804__auto___51571;
if(cljs.core.chunked_seq_QMARK_(seq__51456_51572__$1)){
var c__5568__auto___51573 = cljs.core.chunk_first(seq__51456_51572__$1);
var G__51574 = cljs.core.chunk_rest(seq__51456_51572__$1);
var G__51575 = c__5568__auto___51573;
var G__51576 = cljs.core.count(c__5568__auto___51573);
var G__51577 = (0);
seq__51456_51549 = G__51574;
chunk__51458_51550 = G__51575;
count__51459_51551 = G__51576;
i__51460_51552 = G__51577;
continue;
} else {
var vec__51479_51579 = cljs.core.first(seq__51456_51572__$1);
var test_ns_51580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51479_51579,(0),null);
var ns_info_51581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51479_51579,(1),null);
var map__51482_51582 = ns_info_51581;
var map__51482_51583__$1 = cljs.core.__destructure_map(map__51482_51582);
var fixtures_51584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51482_51583__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5804__auto___51585__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_51584);
if(cljs.core.truth_(temp__5804__auto___51585__$1)){
var fix_51586 = temp__5804__auto___51585__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51580,fix_51586], 0));
} else {
}

var temp__5804__auto___51587__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_51584);
if(cljs.core.truth_(temp__5804__auto___51587__$1)){
var fix_51588 = temp__5804__auto___51587__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_51580,fix_51588], 0));
} else {
}


var G__51589 = cljs.core.next(seq__51456_51572__$1);
var G__51590 = null;
var G__51591 = (0);
var G__51592 = (0);
seq__51456_51549 = G__51589;
chunk__51458_51550 = G__51590;
count__51459_51551 = G__51591;
i__51460_51552 = G__51592;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__51443_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__51443_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__51485 = cljs.test.get_current_env();
var map__51485__$1 = cljs.core.__destructure_map(map__51485);
var env = map__51485__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51485__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51485__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__51487 = arguments.length;
switch (G__51487) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__51495 = arguments.length;
switch (G__51495) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__51500 = shadow.test.env.get_test_ns_info(ns);
var map__51500__$1 = cljs.core.__destructure_map(map__51500);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51500__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__51507 = arguments.length;
switch (G__51507) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__51502_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__51502_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__51517 = arguments.length;
switch (G__51517) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__51513_SHARP_){
var or__5045__auto__ = (re == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51513_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
