// Compiled by ClojureScript 1.9.946 {}
goog.provide('iron.core');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('re_frame.loggers');
goog.require('iron.re_utils');
goog.require('iron.utils');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("iron","size","iron/size",1053697111),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null,new cljs.core.Keyword(null,"tiny","tiny",1577883515),null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null,new cljs.core.Keyword(null,"tiny","tiny",1577883515),null], null), null));
iron.core.negligible_QMARK_ = (function iron$core$negligible_QMARK_(x){
if(cljs.core.seqable_QMARK_.call(null,x)){
return cljs.core.empty_QMARK_.call(null,x);
} else {
return cljs.core.not.call(null,x);
}
});
/**
 * Return a function suitable for an on-* handler, to deliver the value
 *   into into a re-frame event. See also >atom.
 *   The first argument is a re-frame event vector, into which the value
 *   will be conjed as the final element.
 *   It is followed by two optional arguments: a default value that will
 *   be used when the value is empty, and a 'coercer' function to convert
 *   the value into a suitable form for the event.
 *   Note that the default value is _not_ passed through the coercer.
 */
iron.core._GT_event = (function iron$core$_GT_event(var_args){
var G__11929 = arguments.length;
switch (G__11929) {
case 1:
return iron.core._GT_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return iron.core._GT_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return iron.core._GT_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

iron.core._GT_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return iron.core._GT_event.call(null,event,"");
});

iron.core._GT_event.cljs$core$IFn$_invoke$arity$2 = (function (event,default$){
return iron.core._GT_event.call(null,event,default$,cljs.core.identity);
});

iron.core._GT_event.cljs$core$IFn$_invoke$arity$3 = (function (event,default$,coercer){
return (function (p1__11927_SHARP_,p2__11926_SHARP_){
return iron.re_utils._GT_evt.call(null,(function (){var value = (function (){var or__8782__auto__ = p2__11926_SHARP_.value;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return p2__11926_SHARP_.checked;
}
})();
return cljs.core.conj.call(null,event,coercer.call(null,(cljs.core.truth_(iron.core.negligible_QMARK_.call(null,value))?default$:value)));
})());
});
});

iron.core._GT_event.cljs$lang$maxFixedArity = 3;

/**
 * Utility function to dispatch multiple events from an on-* hander.
 *   The syntax is a bit opaque, because we have to wrap both the event
 *   parameters and the parameters to >event (default and coercer).
 * 
 *   So, a usage looks like:
 * 
 *  (na/>events [[[:update-age :in-minutes] 42]
 *               [[:set-color] :cyan nearest-color]])
 *   
 */
iron.core._GT_events = (function iron$core$_GT_events(events){
return (function (dom_event,param_map){
return cljs.core.run_BANG_.call(null,(function (event){
return cljs.core.apply.call(null,iron.core._GT_event,event).call(null,dom_event,param_map);
}),events);
});
});
/**
 * Return a function suitable for an on-* handler, to deliver the value
 *   into into an atom. This would typically be used to store a result into
 *   a local reagent atom. See also >event.
 *   The first argument is an atom, which the value will be reset! into.
 *   It is followed by two optional arguments: a default value that will
 *   be used when the value is empty, and a 'coercer' function to convert
 *   the value into a suitable form for the event.
 *   Note that the default value is _not_ passed through the coercer.
 */
iron.core._GT_atom = (function iron$core$_GT_atom(var_args){
var G__11934 = arguments.length;
switch (G__11934) {
case 1:
return iron.core._GT_atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return iron.core._GT_atom.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return iron.core._GT_atom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

iron.core._GT_atom.cljs$core$IFn$_invoke$arity$1 = (function (atom){
return iron.core._GT_atom.call(null,atom,"");
});

iron.core._GT_atom.cljs$core$IFn$_invoke$arity$2 = (function (atom,default$){
return iron.core._GT_atom.call(null,atom,default$,cljs.core.identity);
});

iron.core._GT_atom.cljs$core$IFn$_invoke$arity$3 = (function (atom,default$,coercer){
return (function (p1__11932_SHARP_,p2__11931_SHARP_){
return cljs.core.reset_BANG_.call(null,atom,coercer.call(null,cljs.core.js__GT_clj.call(null,(function (){var or__8782__auto__ = p2__11931_SHARP_.value;
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return p2__11931_SHARP_.checked;
}
})())));
});
});

iron.core._GT_atom.cljs$lang$maxFixedArity = 3;

/**
 * Get a value from an atom. Suitable to use, e.g., as the :value or
 *   :default-value parameter to a component.
 *   Atom is the atom to be dereferenced. It will be translated by access-fn.
 *   If null, default will be supplied instead.
 */
iron.core._LT_atom = (function iron$core$_LT_atom(var_args){
var G__11937 = arguments.length;
switch (G__11937) {
case 1:
return iron.core._LT_atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return iron.core._LT_atom.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return iron.core._LT_atom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

iron.core._LT_atom.cljs$core$IFn$_invoke$arity$1 = (function (atom){
return iron.core._LT_atom.call(null,atom,null);
});

iron.core._LT_atom.cljs$core$IFn$_invoke$arity$2 = (function (atom,default$){
return iron.core._LT_atom.call(null,atom,default$,cljs.core.identity);
});

iron.core._LT_atom.cljs$core$IFn$_invoke$arity$3 = (function (atom,default$,access_fn){
var or__8782__auto__ = access_fn.call(null,cljs.core.deref.call(null,atom));
if(cljs.core.truth_(or__8782__auto__)){
return or__8782__auto__;
} else {
return default$;
}
});

iron.core._LT_atom.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=core.js.map
