// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__15474_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__15474_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__5457__auto___15475 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___15475)){
var not_i_15476 = temp__5457__auto___15475;
if(cljs.core.fn_QMARK_.call(null,not_i_15476)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_15476);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_15476);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_15477 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_15478 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__12463__auto___15491 = re_frame.interop.now.call(null);
var duration__12464__auto___15492 = (end__12463__auto___15491 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__15479_15493 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__15480_15494 = null;
var count__15481_15495 = (0);
var i__15482_15496 = (0);
while(true){
if((i__15482_15496 < count__15481_15495)){
var vec__15483_15497 = cljs.core._nth.call(null,chunk__15480_15494,i__15482_15496);
var k__12465__auto___15498 = cljs.core.nth.call(null,vec__15483_15497,(0),null);
var cb__12466__auto___15499 = cljs.core.nth.call(null,vec__15483_15497,(1),null);
try{cb__12466__auto___15499.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__12464__auto___15492,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e15486){if((e15486 instanceof java.lang.Exception)){
var e__12467__auto___15500 = e15486;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__12465__auto___15498,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__12467__auto___15500);
} else {
throw e15486;

}
}
var G__15501 = seq__15479_15493;
var G__15502 = chunk__15480_15494;
var G__15503 = count__15481_15495;
var G__15504 = (i__15482_15496 + (1));
seq__15479_15493 = G__15501;
chunk__15480_15494 = G__15502;
count__15481_15495 = G__15503;
i__15482_15496 = G__15504;
continue;
} else {
var temp__5457__auto___15505 = cljs.core.seq.call(null,seq__15479_15493);
if(temp__5457__auto___15505){
var seq__15479_15506__$1 = temp__5457__auto___15505;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__15479_15506__$1)){
var c__9713__auto___15507 = cljs.core.chunk_first.call(null,seq__15479_15506__$1);
var G__15508 = cljs.core.chunk_rest.call(null,seq__15479_15506__$1);
var G__15509 = c__9713__auto___15507;
var G__15510 = cljs.core.count.call(null,c__9713__auto___15507);
var G__15511 = (0);
seq__15479_15493 = G__15508;
chunk__15480_15494 = G__15509;
count__15481_15495 = G__15510;
i__15482_15496 = G__15511;
continue;
} else {
var vec__15487_15512 = cljs.core.first.call(null,seq__15479_15506__$1);
var k__12465__auto___15513 = cljs.core.nth.call(null,vec__15487_15512,(0),null);
var cb__12466__auto___15514 = cljs.core.nth.call(null,vec__15487_15512,(1),null);
try{cb__12466__auto___15514.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__12464__auto___15492,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e15490){if((e15490 instanceof java.lang.Exception)){
var e__12467__auto___15515 = e15490;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__12465__auto___15513,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__12467__auto___15515);
} else {
throw e15490;

}
}
var G__15516 = cljs.core.next.call(null,seq__15479_15506__$1);
var G__15517 = null;
var G__15518 = (0);
var G__15519 = (0);
seq__15479_15493 = G__15516;
chunk__15480_15494 = G__15517;
count__15481_15495 = G__15518;
i__15482_15496 = G__15519;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_15478;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_15477;
}}
} else {
return null;
}
});

//# sourceMappingURL=events.js.map
