// Compiled by ClojureScript 1.10.238 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_6807 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__6808 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__6809 = null;
var count__6810 = (0);
var i__6811 = (0);
while(true){
if((i__6811 < count__6810)){
var vec__6812 = cljs.core._nth.call(null,chunk__6809,i__6811);
var effect_key = cljs.core.nth.call(null,vec__6812,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6812,(1),null);
var temp__5455__auto___6828 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___6828)){
var effect_fn_6829 = temp__5455__auto___6828;
effect_fn_6829.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6830 = seq__6808;
var G__6831 = chunk__6809;
var G__6832 = count__6810;
var G__6833 = (i__6811 + (1));
seq__6808 = G__6830;
chunk__6809 = G__6831;
count__6810 = G__6832;
i__6811 = G__6833;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__6808);
if(temp__5457__auto__){
var seq__6808__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6808__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__6808__$1);
var G__6834 = cljs.core.chunk_rest.call(null,seq__6808__$1);
var G__6835 = c__4319__auto__;
var G__6836 = cljs.core.count.call(null,c__4319__auto__);
var G__6837 = (0);
seq__6808 = G__6834;
chunk__6809 = G__6835;
count__6810 = G__6836;
i__6811 = G__6837;
continue;
} else {
var vec__6815 = cljs.core.first.call(null,seq__6808__$1);
var effect_key = cljs.core.nth.call(null,vec__6815,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6815,(1),null);
var temp__5455__auto___6838 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___6838)){
var effect_fn_6839 = temp__5455__auto___6838;
effect_fn_6839.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6840 = cljs.core.next.call(null,seq__6808__$1);
var G__6841 = null;
var G__6842 = (0);
var G__6843 = (0);
seq__6808 = G__6840;
chunk__6809 = G__6841;
count__6810 = G__6842;
i__6811 = G__6843;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__5890__auto___6844 = re_frame.interop.now.call(null);
var duration__5891__auto___6845 = (end__5890__auto___6844 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__5891__auto___6845,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__5890__auto___6844);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_6807;
}} else {
var seq__6818 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__6819 = null;
var count__6820 = (0);
var i__6821 = (0);
while(true){
if((i__6821 < count__6820)){
var vec__6822 = cljs.core._nth.call(null,chunk__6819,i__6821);
var effect_key = cljs.core.nth.call(null,vec__6822,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6822,(1),null);
var temp__5455__auto___6846 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___6846)){
var effect_fn_6847 = temp__5455__auto___6846;
effect_fn_6847.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6848 = seq__6818;
var G__6849 = chunk__6819;
var G__6850 = count__6820;
var G__6851 = (i__6821 + (1));
seq__6818 = G__6848;
chunk__6819 = G__6849;
count__6820 = G__6850;
i__6821 = G__6851;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__6818);
if(temp__5457__auto__){
var seq__6818__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6818__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__6818__$1);
var G__6852 = cljs.core.chunk_rest.call(null,seq__6818__$1);
var G__6853 = c__4319__auto__;
var G__6854 = cljs.core.count.call(null,c__4319__auto__);
var G__6855 = (0);
seq__6818 = G__6852;
chunk__6819 = G__6853;
count__6820 = G__6854;
i__6821 = G__6855;
continue;
} else {
var vec__6825 = cljs.core.first.call(null,seq__6818__$1);
var effect_key = cljs.core.nth.call(null,vec__6825,(0),null);
var effect_value = cljs.core.nth.call(null,vec__6825,(1),null);
var temp__5455__auto___6856 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___6856)){
var effect_fn_6857 = temp__5455__auto___6856;
effect_fn_6857.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__6858 = cljs.core.next.call(null,seq__6818__$1);
var G__6859 = null;
var G__6860 = (0);
var G__6861 = (0);
seq__6818 = G__6858;
chunk__6819 = G__6859;
count__6820 = G__6860;
i__6821 = G__6861;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__6862 = cljs.core.seq.call(null,value);
var chunk__6863 = null;
var count__6864 = (0);
var i__6865 = (0);
while(true){
if((i__6865 < count__6864)){
var map__6866 = cljs.core._nth.call(null,chunk__6863,i__6865);
var map__6866__$1 = ((((!((map__6866 == null)))?(((((map__6866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6866.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6866):map__6866);
var effect = map__6866__$1;
var ms = cljs.core.get.call(null,map__6866__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__6866__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__6862,chunk__6863,count__6864,i__6865,map__6866,map__6866__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__6862,chunk__6863,count__6864,i__6865,map__6866,map__6866__$1,effect,ms,dispatch))
,ms);
}


var G__6870 = seq__6862;
var G__6871 = chunk__6863;
var G__6872 = count__6864;
var G__6873 = (i__6865 + (1));
seq__6862 = G__6870;
chunk__6863 = G__6871;
count__6864 = G__6872;
i__6865 = G__6873;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__6862);
if(temp__5457__auto__){
var seq__6862__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6862__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__6862__$1);
var G__6874 = cljs.core.chunk_rest.call(null,seq__6862__$1);
var G__6875 = c__4319__auto__;
var G__6876 = cljs.core.count.call(null,c__4319__auto__);
var G__6877 = (0);
seq__6862 = G__6874;
chunk__6863 = G__6875;
count__6864 = G__6876;
i__6865 = G__6877;
continue;
} else {
var map__6868 = cljs.core.first.call(null,seq__6862__$1);
var map__6868__$1 = ((((!((map__6868 == null)))?(((((map__6868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6868):map__6868);
var effect = map__6868__$1;
var ms = cljs.core.get.call(null,map__6868__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__6868__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__6862,chunk__6863,count__6864,i__6865,map__6868,map__6868__$1,effect,ms,dispatch,seq__6862__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__6862,chunk__6863,count__6864,i__6865,map__6868,map__6868__$1,effect,ms,dispatch,seq__6862__$1,temp__5457__auto__))
,ms);
}


var G__6878 = cljs.core.next.call(null,seq__6862__$1);
var G__6879 = null;
var G__6880 = (0);
var G__6881 = (0);
seq__6862 = G__6878;
chunk__6863 = G__6879;
count__6864 = G__6880;
i__6865 = G__6881;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__6882 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__6883 = null;
var count__6884 = (0);
var i__6885 = (0);
while(true){
if((i__6885 < count__6884)){
var event = cljs.core._nth.call(null,chunk__6883,i__6885);
re_frame.router.dispatch.call(null,event);


var G__6886 = seq__6882;
var G__6887 = chunk__6883;
var G__6888 = count__6884;
var G__6889 = (i__6885 + (1));
seq__6882 = G__6886;
chunk__6883 = G__6887;
count__6884 = G__6888;
i__6885 = G__6889;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__6882);
if(temp__5457__auto__){
var seq__6882__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6882__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__6882__$1);
var G__6890 = cljs.core.chunk_rest.call(null,seq__6882__$1);
var G__6891 = c__4319__auto__;
var G__6892 = cljs.core.count.call(null,c__4319__auto__);
var G__6893 = (0);
seq__6882 = G__6890;
chunk__6883 = G__6891;
count__6884 = G__6892;
i__6885 = G__6893;
continue;
} else {
var event = cljs.core.first.call(null,seq__6882__$1);
re_frame.router.dispatch.call(null,event);


var G__6894 = cljs.core.next.call(null,seq__6882__$1);
var G__6895 = null;
var G__6896 = (0);
var G__6897 = (0);
seq__6882 = G__6894;
chunk__6883 = G__6895;
count__6884 = G__6896;
i__6885 = G__6897;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__6898 = cljs.core.seq.call(null,value);
var chunk__6899 = null;
var count__6900 = (0);
var i__6901 = (0);
while(true){
if((i__6901 < count__6900)){
var event = cljs.core._nth.call(null,chunk__6899,i__6901);
clear_event.call(null,event);


var G__6902 = seq__6898;
var G__6903 = chunk__6899;
var G__6904 = count__6900;
var G__6905 = (i__6901 + (1));
seq__6898 = G__6902;
chunk__6899 = G__6903;
count__6900 = G__6904;
i__6901 = G__6905;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__6898);
if(temp__5457__auto__){
var seq__6898__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6898__$1)){
var c__4319__auto__ = cljs.core.chunk_first.call(null,seq__6898__$1);
var G__6906 = cljs.core.chunk_rest.call(null,seq__6898__$1);
var G__6907 = c__4319__auto__;
var G__6908 = cljs.core.count.call(null,c__4319__auto__);
var G__6909 = (0);
seq__6898 = G__6906;
chunk__6899 = G__6907;
count__6900 = G__6908;
i__6901 = G__6909;
continue;
} else {
var event = cljs.core.first.call(null,seq__6898__$1);
clear_event.call(null,event);


var G__6910 = cljs.core.next.call(null,seq__6898__$1);
var G__6911 = null;
var G__6912 = (0);
var G__6913 = (0);
seq__6898 = G__6910;
chunk__6899 = G__6911;
count__6900 = G__6912;
i__6901 = G__6913;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map
