// Compiled by ClojureScript 1.9.671 {}
goog.provide('sodium.utils');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
goog.require('re_frame.core');
/**
 * Shorthand for re-frame subscribe and deref.
 */
sodium.utils._LT_sub = cljs.core.comp.call(null,cljs.core.deref,re_frame.core.subscribe);
/**
 * Shorthand for re-frame dispatch to event.
 */
sodium.utils._GT_evt = re_frame.core.dispatch;
/**
 * Like s/valid?, but show the error like s/assert. Useful for pre-conditions.
 */
sodium.utils.validate = (function sodium$utils$validate(spec,x){
var or__7438__auto__ = cljs.spec.alpha.valid_QMARK_.call(null,spec,x);
if(cljs.core.truth_(or__7438__auto__)){
return or__7438__auto__;
} else {
return cljs.spec.alpha.explain.call(null,spec,x);
}
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("sodium.utils","event-vector","sodium.utils/event-vector",-1205574834),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"event","event",301435442),new cljs.core.Keyword(null,"params","params",710516235)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword_QMARK_,cljs.spec.alpha.rep_impl.call(null,new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","keyword?","cljs.core/keyword?",713156450,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","*","cljs.spec.alpha/*",-1238084288,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))], null)));
/**
 * Remove trailing '?' from predicate, to make suitable for JavaScript
 */
sodium.utils.unpredicate = (function sodium$utils$unpredicate(s){
if(clojure.string.ends_with_QMARK_.call(null,s,"?")){
return cljs.core.subs.call(null,s,(0),(cljs.core.count.call(null,s) - (1)));
} else {
return s;
}
});
/**
 * Convert a string from ClojureScript to JavaScript conventions.
 *   - Replace hyphens with camelCase
 *   - Remove trailing '?'
 */
sodium.utils.camelize_str = (function sodium$utils$camelize_str(s){
var vec__10937 = clojure.string.split.call(null,sodium.utils.unpredicate.call(null,s),"-");
var seq__10938 = cljs.core.seq.call(null,vec__10937);
var first__10939 = cljs.core.first.call(null,seq__10938);
var seq__10938__$1 = cljs.core.next.call(null,seq__10938);
var first_word = first__10939;
var more = seq__10938__$1;
if(more){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(first_word),cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,cljs.core.map.call(null,clojure.string.capitalize,more)))].join('');
} else {
return first_word;
}
});
sodium.utils.preserved_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-tooltip","data-tooltip",121719926),null], null), null);
/**
 * Convert a keyword from ClojureScript to JavaScript conventions.
 *   - Replace hyphens with camelCase
 *   - Remove trailing '?'
 *   - Preserve namespaces as-is
 *   - [UGLY ALERT] Do not change certain keywords that JavaScript wants to see hyphenated
 */
sodium.utils.camelize_key = (function sodium$utils$camelize_key(k){
if(cljs.core.contains_QMARK_.call(null,sodium.utils.preserved_keys,k)){
return k;
} else {
return cljs.core.keyword.call(null,cljs.core.namespace.call(null,k),sodium.utils.camelize_str.call(null,cljs.core.name.call(null,k)));
}
});
/**
 * Convert a map from ClojureScript to JavaScript conventions. Change the map
 *   keys, but leave the values alone.
 */
sodium.utils.camelize_map_keys = (function sodium$utils$camelize_map_keys(m){
return cljs.core.reduce_kv.call(null,(function (m__$1,k,v){
return cljs.core.assoc.call(null,m__$1,sodium.utils.camelize_key.call(null,k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});

//# sourceMappingURL=utils.js.map